    REM *** WAVEMATE JUPITER II 2708 EPROM PROGRAMMER ***
    REM Mods:
    REM    1/22/82    Upgraded from BASIC 1.3 to BASIC 1.4

    DIM CHAR$[1],LINE$[80]
    DIM ROMW$[1024],ROMR$[1024],MAP$[1024]
    DIM STARTRECORD$/:1,0,0,:FF,:FF/,LASTRECORD$/:3,0,0,0,0/,RECORDHEADER$[3]

    PRINT "WaveMate Jupiter II 2708 EPROM Programmer, V1.1"
10  GOSUB POP 0 \ ! CLEAN UP ANY LOST GOSUBS ON STACK
    INPUT "Toast, Verify, Read or Stop (T,V,R or S)? " LINE$
    LET LINE$=UPPERCASE$(LINE$)
    IF LINE$="S" THEN EXIT
    IF LINE$="T" THEN 10000
    IF LINE$="V" THEN 20000
    IF LINE$="R" THEN 30000
    PRINT "WHAT??"
    GOTO 10

GetParameters:
    INPUT "Inverted Address Lines? (Default=YES) " LINE$
    LET INVERTAD=IF FIND(UPPERCASE$(LINE$),"N")=1 THEN :0000 ELSE :03FF FI
    INPUT "Inverted Data Lines? (Default=YES) " LINE$
    LET INVERTDATA=IF FIND(UPPERCASE$(LINE$),"N")=1 THEN 0 ELSE :FF FI
    INPUT "Lowest address in EPROM in hex? " OFFSET
    RETURN

10000 ! TOAST: BURN A 2708 EPROM
    LEN(ROMR$)=MAXLEN(ROMR$)\CALL READBACK(ROMR$)
    FOR I=1 TO LEN(ROMR$)
        IF ROMR$[1]<>:FF
        THEN
            INPUT "EPROM is NOT empty...proceed anyway? " LINE$
            IF FIND(UPPERCASE$(LINE$),"Y")<>1 THEN 10 ELSE EXIT I
        FI
    NEXT I
    GOSUB 40000\CALL TOASTY(ROMW$)
10005 ! DO VERIFY
    CALL READBACK(ROMR$)
    LEN(ROMW$)=MAXLEN(ROMW$)
    LEN(ROMR$)=MAXLEN(ROMR$)
    IF ROMW$=ROMR$ THEN PRINT "Contents Verified!"\GOTO 10
    PRINT "*** PROM DOESN'T MATCH MASTER ***"
    PRINT "  ROM";TAB(10);"  ROM";TAB(20);"  ROM"
    PRINT "ADDRESS";TAB(10);"DESIRED";TAB(20);"TOASTED"
    FOR J=1 TO 30\PRINT "=";\NEXT J\PRINT
    FOR I=1 TO LEN(ROMW$)
        IF MAP$[I]&ROMW$[I]=ROMR$[I]&MAP$[I] THEN CYCLE I
        PRINT HEX$(I-1);TAB(10);HEX$(ROMW$[I])[4,2];TAB(20);HEX$(ROMR$[I])[4,2]
    NEXT I
    GOTO 10

20000 ! VERIFY ROM AGAINST FILE
    GOSUB 40000\! READ IN TRUTH
    GOTO 10005\! FAKE IT LIKE WE JUST TOASTED IT

30000 ! READ ROM INTO A FILE
    LEN(ROMR$)=MAXLEN(ROMR$)\CALL READBACK(ROMR$)
    INPUT "Place binary object where ? " LINE$
    CREATE #1,LINE$
    GOSUB GETPARAMETERS
    FOR I=1 TO LEN(ROMR$) DO ROMR$[I]=ROMR$[I] XOR INVERTDATA
    IF INVERTAD
    THEN FOR I=0 TO 511
             DO T=ROMR$[1+I]\ROMR$[1+I]=ROMR$[1024-I]\ROMR$[1024-I]=T
         NEXT I
    ! NOW BUILD OBJECT FILE IMAGE
    LET STARTRECORD$[2]=OFFSET**-8\STARTRECORD$[3]=OFFSET&:FF
    LET STARTRECORD$[4]=:FF-STARTRECORD$[2]\STARTRECORD$[5]=:FF-STARTRECORD$[3]
    LET LASTRECORD$[2,1]=STARTRECORD$[2,3]
    LET LASTRECORD$[4]=1024**-8\LASTRECORD$[5]=1024&:FF
    WRITE #1,STARTRECORD$,LASTRECORD$,ROMR$ \ ! OUTPUT CONTENTS OF OBJECT FILE
    CLOSE #1
    GOTO 10

40000 INPUT "Binary file name: " LINE$
    OPEN #1,LINE$
    READ #1,RECORDHEADER$
    IF RECORDHEADER$(1)<>1 and RECORDHEADER$(1)<>2
    THEN PRINT "Not an object file."\CLOSE #1\GOTO 10
    FOR I=1 TO 2 DO READ #1,CHAR$ \ ! EAT REST OF TYPE 1 RECORD
    GOSUB GETPARAMETERS
    ! MAP$[I]=0 IF BINARY FILE DOES NOT SPECIFY CONTENTS OF ROM LOCATION I
    ! MAP$[I]=:FF IF BINARY FILE GIVES EXPLICIT VALUE FOR ROM LOCATION I
    ! INITIALLY ASSUME ALL ROM LOCATIONS ARE UNSPECIFIED, FILL WITH :FF
    FOR I=1 TO MAXLEN(MAP$) DO MAP$[I]=0\ROMW$[I]=:FF

40010 READ #1,RECORDHEADER$
    IF EOF(1) THEN PRINT "Unexpected EOF."\CLOSE #1\GOTO 10
    LET ADDRESS=RECORDHEADER$[2]*256+RECORDHEADER$[3]
    IF RECORDHEADER$[1]=0
    THEN FOR I=1 TO ADDRESS\READ #1,CHAR$\NEXT I\GOTO 40010\! EAT SKIP RECORD
    IF RECORDHEADER$[1]=2 THEN GOSUB PROCESSRECORD\GOTO 40010
    ELSEIF RECORDHEADER$[1]=3 THEN GOSUB PROCESSRECORD\Close #1\RETURN
    PRINT "Illegal load record (";RECORDHEADER$[1];") encountered."
    CLOSE #1\GOTO 10

PROCESSRECORD: ! PROCESS CONTENTS OF TYPE 2 OR TYPE 3 RECORD
    ! GET LENGTH OF RECORD
    READ #1,CHAR$
    LET RECORDLENGTH=CHAR$[1]*256
    READ #1,CHAR$
    LET RECORDLENGTH=RECORDLENGTH+CHAR$[1]
    FOR ADDRESS=ADDRESS TO ADDRESS+RECORDLENGTH-1
        ! PROCESS BYTE OF RECORD
        READ #1,CHAR$
        IF EOF(1) THEN PRINT "Unexpected EOF."\CLOSE #1\GOTO 10
        IF ADDRESS>=OFFSET AND ADDRESS<OFFSET+1024
        THEN
!           PRINT "ADDRESS=";HEX$(ADDRESS);((ADDRESS-OFFSET) XOR INVERTAD)+1
            ROMW$[((ADDRESS-OFFSET) XOR INVERTAD)+1]=CHAR$[1] XOR INVERTDATA
            ! MARK THIS ROM LOCATION AS SPECIFIED BY FILE.
            MAP$[((ADDRESS-OFFSET) XOR INVERTAD)+1]=:FF
        FI
    NEXT ADDRESS
    RETURN

    END
