REM   "COMPILE" -- PROGRAM TO MANUFACTURE "DO" FILE TO RUN THE BASIC COMPILER,
REM                FOLLOWED BY ASSEMBLER
REM   PROGRAM INVOCATION:
REM
REM          .COMPILE <PROG> [ WITH <FILE> ]
REM
REM          WHERE "PROG" IS NAME OF BASIC PROGRAM,
REM          AND "FILE" IS NAME OF OPTIONAL ASSEMBLY LANGUAGE ADDITION
REM
REM     REVISION HISTORY:
REM     COMPILE 1.0  3/24/80
REM            First version; released with BASIC 1.3 under SDOS.
REM     COMPILE 1.0A 1/29/81
REM            Released with BASIC 1.4h
REM     COMPILE 1.0B 4/24/82
REM            Constructed to release with 6809 software.
REM            Creates filenames of form: "filename.DO" in order to allow
REM            use under SDOS/MT 1.x (single directory SDOS)
REM            Added operator prompting and self-id message
REM

    DIM VERSION$/"Compile v1.0b"/
    DIM COMMANDLINE$(120),BASICSOURCE$(50),ASMSOURCE$(50)
    DIM MAINNAME$(50)
    DIM ERROR102$/:12,4,0,102/,CREATELOG$/:7,:E/

    ! FIND OUT WHAT USER WANTS
    IF COL(0)>1
    THEN
        ! SOPHISTICATED USER, READ INPUT LINE AND PARSE
        INPUT "" COMMANDLINE$
        PRINT VERSION$
    ELSE
        ! DUMB USER, GIVE HIM PROMPTS TO HELP HIM OUT
        PRINT VERSION$ \ ! LET HIM KNOW WHAT WE ARE
        INPUT "Name of BASIC program to compile: " BASICSOURCE$
        INPUT "Name of Assembly file to include: (default=NONE) " ASMSOURCE$
        COMMANDLINE$=BASICSOURCE$
        IF ASMSOURCE$<>""
        THEN LET COMMANDLINE$=COMMANDLINE$ CAT " with " CAT ASMSOURCE$
        PRINT "Next time, you can type:"
        PRINT "     .compile ";COMMANDLINE$
    FI
    ! RIP APART THE COMMAND LINE
    COMMANDLINE$=UPPERCASE$(COMMANDLINE$)
    LET I=FIND(COMMANDLINE$," ")
    IF I=0
    THEN
        BASICSOURCE$=COMMANDLINE$
        ASMSOURCE$=""
    ELSE
        BASICSOURCE$=LEFT$(COMMANDLINE$,I-1)
        LET ASMSOURCE$=RIGHT$(COMMANDLINE$,I+1)
        LET I=FIND(UPPERCASE$(ASMSOURCE$),"WITH ")
        IF I=0 THEN SYSCALL(ERROR102$) \ ! COMMAND SYNTAX ERROR
        LET ASMSOURCE$=RIGHT$(ASMSOURCE$,I+5)
    FI

    LET I=FIND(BASICSOURCE$,".")
    IF I=0
    THEN LET BASICSOURCE$=BASICSOURCE$ CAT ".BAS"
    ! FIND PART OF FILENAME THAT DOES NOT INCLUDE THE EXTENSION
    FOR I=LEN(BASICSOURCE$) TO 1 STEP -1 UNTIL BASICSOURCE$[I,1]="." DO ! NADA
    LET MAINNAME$=BASICSOURCE$[1,I-1]
    REM RECOVER DISK SPACE CURRENTLY HELD BY MAINNAME.TMP FILES
    CREATE #1,MAINNAME$ CAT ".TMP"\CLOSE #1
    CREATE #1,MAINNAME$ CAT ".SYM"\CLOSE #1

    REM NOW CONSTRUCT A DO FILE TO FORCE WHAT WE WANT DONE
    CREATE #1,MAINNAME$ CAT ".DO"
    PRINT #1,BASICSOURCE$\ ! NAME OF FILE TO COMPILE
    PRINT #1,MAINNAME$ CAT ".TMP"
    PRINT #1,"IFERROR 100 FIX"
    PRINT #1,"ASM"
    IF ASMSOURCE$=""
    THEN
        PRINT #1,MAINNAME$;".TMP"
        PRINT #1,MAINNAME$;".SYM"
        PRINT #1,MAINNAME$ \ ! OBJECT FILE NAME
        PRINT #1,"      WITH    NLST"
        PRINT #1
    ELSE
        PRINT #1,ASMSOURCE$
        PRINT #1,MAINNAME$;".SYM"
        PRINT #1,MAINNAME$ \ ! OBJECT FILE NAME
        PRINT #1,"      WITH NLST"
        PRINT #1,"      INCLUDE ";MAINNAME$;".TMP"
        PRINT #1
    FI
    PRINT #1,"IFERROR 100 FIX"
    PRINT #1,"GOTO COMPILEDONE"
    PRINT #1,"LABEL FIX"
    PRINT #1,"FIX ";COMMANDLINE$
    PRINT #1,"LABEL COMPILEDONE"
    CLOSE #1
    REM DO FILE IS BUILT, NOW "DO" IT!
    CLOSE #0
    OPEN #0,MAINNAME$ CAT ".DO"
    DELETE MAINNAME$ CAT ".DO"
    IF ERROR WHEN SYSCALL(CREATELOG$,"CONSOLE:",COMMANDLINE$)
    THEN IF ERR<>1031 THEN ERROR \ ! IGNORE ERROR CAUSED IF LOGGING ACTIVE
    PRINT ".BASIC"\ ! JUST TO MAKE IT LOOK LIKE WE WENT THRU SDOSCMDS
    CHAIN "BASIC"
    PRINT "AAAAIIIIIEEEEE!!!!!"
END
