    Rem Disk I/O test
    Dim Filename$(50)
    Dim FileSizes(20)
    Dim SectorSizes(20)
    Dim Answer$[10]
    Print "Disk I/O test v1.1d"

Subroutine BreakTrap
999 Exit Subroutine
End

Def Value(Value$)
    let Valueresult=0
    For i=1 to len(Value$) do Valueresult=valueresult*256+Value$[i]
    Return ValueResult
End

Def FileSize(FileChannel)
    Dim SCGetType$/:f,14,0,4/
    Dim SCGetFileSize$/:f,14,0,3/
    Dim SCGetParams$/:f,14,0,5/,CCUnlockDisk$/:e,4,0,:10/
    Dim Reply$(8)
    Syscall #FileChannel,SCGettype$,"",Reply$
    If Reply$[1]=0
    Then
        Rem is disk file, ask for size
        Syscall #FileChannel,SCGetFileSIze$,"",Reply$
        Return Value(Reply$)
    Elseif Reply$[1]=1
    Then
        Rem is Disk device, get parameters
        Syscall #FileChannel,ScGetParams$,"",Reply$
        Syscall #FileChannel,CcUnlockDisk$ \ ! so we can write on it
        Return Value(Reply$[1,2])*Value(Reply$[3,2])...
&             *Value(Reply$[5,2])*Value(Reply$[7,2])
    Else Print "Can't do DIOTEST on that!!!"\Exit
End

Rem **** Main program begins here ****

    Let NFiles=0
GetNames: Repeat
            Print "#";Nfiles+1;
            Input "Name of file/device? " Filename$
            If FileName$=""
            Then
                If Nfiles=0
                Then Print "No files open, bye!"\Exit
                Else Exit GetNames Fi
            Fi
            Nfiles=Nfiles+1
            If Error when Open #Nfiles,Filename$
            Then
                If Err=1011
                Then
                    Input "No such file. Create it? " Answer$
                    If Len(Answer$)>1 and Uppercase$(Answer$[1,1])="Y"
                    Then Create #Nfiles,FileName$\FileSizes(Nfiles)=0 Fi
                Else
                    Print "Error ";Err;"attempting to open ";Filename$
                    Nfiles=Nfiles-1
                Fi
            Else
                Let FileSizes(Nfiles)=Filesize(Nfiles)
                Print "Filesize = ";FileSizes(Nfiles)
            Fi
            Input "Sector Size (default is 6) = " Answer$
            If Answer$="" then SectorSizes(Nfiles)=6
            Else
               If Error When SectorSizes(Nfiles)=Val(Answer$)
               Then
                  print "Invalid Sector Size"
                  Close #Nfiles
                  Nfiles=Nfiles-1
               Fi
           Fi
        End
Mainloop:
    Input "0: Stop  1: Fill  2: Seq Test  3: Rnd Read  4: Extend  5: Rnd Wrt " command
    On Command Goto 100,200,300,400,500
    Exit

100 Rem Fill a File
    If Nfiles=1 Then DesiredFile=1 Else Input "Which file? " DesiredFile
    Print "Current size is: ";Filesizes(DesiredFile)
    Input "Fill to (default is current size): " Answer$
    If Len(Answer$)>0 Then Filesizes(DesiredFile)=Val(Answer$)
    For i=0 to Int(Filesizes(DesiredFile))/SectorSizes(DesiredFile)-1
110     If SectorSizes(DesiredFile)=6 Then Write #DesiredFile,i
        Else Write #DesiredFile @i*SectorSizes(DesiredFile),i
    Next i
    Print "File is filled."
    Goto 210

200 Rem Read sequentially thru a file to verify correctness
    If Nfiles=1 Then DesiredFile=1 Else Input "Which file? " Desiredfile
210 Position #DesiredFile@0
    For i=0 to Int(Filesizes(DesiredFile))/SectorSizes(DesiredFile)-1
220     If SectorSizes(DesiredFile)=6 Then Read #DesiredFile,j
        Else Read #DesiredFile @i*SectorSizes(DesiredFile),j
        If i<>j
        then
            print "Seq test failure: expected";i;"Retreived";j
            Write #DesiredFile@i*SectorSizes(DesiredFile),i
        fi
    Next i
    Goto MainLoop

300 Rem Random read over all the files
    Input "How many read operations <default=1000>? " Answer$
    Opcount=If Len(Answer$)=0 Then 1000 Else Val(Answer$) Fi
    Input "New random seed <default is none>? " Answer$
    If Len(Answer$) Then RND=val(Answer$)
    If Nfiles=1
    Then
        Desiredfile=1
        Let i=1
        Let LastRandomNumber=-1
        While (int(i/1000)+1)*1000<Opcount Do
            For i=i to (int(i/1000)+1)*1000
                Gosub DoRandomReadStep
            Next i
            Print i;"random reads completed."
        End
        For i=i to Opcount-1
            Gosub DoRandomReadStep
        Next i
    Else
        Let i=1
        Let LastRandomNumber=-1
        While (int(i/1000)+1)*1000<Opcount Do
            For i=i to (int(i/1000)+1)*1000
                Rem pick a random file
                Let Desiredfile=1+int(Rnd*Nfiles)
                Gosub DoRandomReadStep
            Next i
            Print i;"random reads completed."
        End
        For i=i to Opcount-1
            Rem pick a random file
            Let Desiredfile=1+int(Rnd*Nfiles)
            Gosub DoRandomReadStep
        Next i
    Fi
    Print i;"random reads completed."
    Goto MainLoop

DoRandomReadStep: ! Do one step of random read test
    Rem pick a random place
    Let LastRandomNumber=j
    let j=int(Rnd*Int(Filesizes(Desiredfile)/SectorSizes(DesiredFile)))
    Read #Desiredfile@j*SectorSizes(DesiredFile),k
    If j<>k then
        print "Random Read: File ";DesiredFile;"Expected ";j;"Retreived";k;
        Print "Last";LastRandomNumber
        call breaktrap
    Fi
    Return

400 Rem Extend a file
    If Nfiles=1 Then DesiredFile=1 Else Input "Which file? " DesiredFile
    Print "Current size is: ";Filesizes(DesiredFile)
    Input "Fill to: " Newsize
    Position #Desiredfile@Int(Filesizes(DesiredFile)/SectorSizes(DesiredFile))*SectorSizes(DesiredFile)
    For i=Int(Filesizes(Desiredfile)/SectorSizes(DesiredFile)) to Int(Newsize/SectorSizes(DesiredFile))-1
410     Write #Desiredfile,i
    Next i
    Let Filesizes(DesiredFile)=Newsize
    Print "You need to run a sequential test on this file now."
    Goto Mainloop

500 Rem Randomly write to all the files
    Input "How many Write operations <default=1000>? " Answer$
    Opcount=If Len(Answer$)=0 Then 1000 Else Val(Answer$) Fi
    Input "New random seed <default is none>? " Answer$
    If Len(Answer$) Then RND=val(Answer$)
    If Nfiles=1
    Then
        Desiredfile=1
        Let i=1
        While (int(i/1000)+1)*1000<Opcount Do
            For i=i to (int(i/1000)+1)*1000
                Gosub DoRandomWriteStep
            Next i
            Print i;"random writes completed."
        End
        For i=i to Opcount-1
            Gosub DoRandomWriteStep
        Next i
    Else
        Let i=1
        While (int(i/1000)+1)*1000<Opcount Do
            For i=i to (int(i/1000)+1)*1000
                Rem pick a random file
                Let Desiredfile=1+int(Rnd*Nfiles)
                Gosub DoRandomWriteStep
            Next i
            Print i;"random writes completed."
        End
        For i=i to Opcount-1
            Rem pick a random file
            Let Desiredfile=1+int(Rnd*Nfiles)
            Gosub DoRandomWriteStep
        Next i
    Fi
    Print i;"random writes completed."
    Print "Random write pass complete, now verifying files"
    For DesiredFile=1 To Nfiles
        Position #Desiredfile@0
        For i=0 to Int(Filesizes(DesiredFile))/SectorSizes(DesiredFile)-1
550         If SectorSizes(DesiredFile)=6 Then Read #DesiredFile,j
            Else Read #DesiredFile @i*SectorSizes(DesiredFile),j
            If i<>j then
                print "Random Validate: File";DesiredFile;"Expected";i;"Retreived";j
                call breaktrap
            Fi
        Next i
    Next DesiredFile
    Goto MainLoop

DoRandomWriteStep: ! Do one cycle of Random Write Test
    Rem pick a random place
    Let LastRandomNumber=j
    let j=int(Rnd*Int(Filesizes(Desiredfile)/SectorSizes(DesiredFile)))
510 Read #Desiredfile@j*SectorSizes(DesiredFile),k
    If j<>k then
        print "Random Write: File";DesiredFile;"Expected";j;"Retreived";k;
        Print "Last";LastRandomNumber
        call breaktrap
    Fi
    Write #Desiredfile@j*SectorSizes(DesiredFile),k
    Return

END
