.FS 10
SDOS SYSTEMS IMPLEMENTER'S GUIDE
.BR
ROUGH DRAFT
.BR
.CD
.pa
.fs 10
.ce
S D O S
.sp
.ce
SYSTEMS IMPLEMENTER'S GUIDE
.SP 10
.CE
COPYRIGHT (C) 1978 SOFTWARE DYNAMICS
.sp
.CE
4th Printing
.pa
.fs 8
.ce
NOTICE
.BR
.CE
------
.SP
This manual describes Software Dynamics Operating System (SDOS) Version 1.0.
Software Dynamics has carefully checked the information given in this manual,
and it is believed to be entirely reliable.  However, no
responsibility is assumed for inaccuracies.
.sp
SD reserves the right to change the specifications without notice.
.SP
.pw 120
.ll 100
.im 21
**********************************************************************
** This manual  describes software  which is a proprietary  product **
** of Software Dynamics (SD).  SD software is licensed for use on a **
** single copy per computer basis, and is covered by U.S  copyright **
** laws.  Unless a written exception is obtained from SD, the soft- **
** ware must be used only on the single computer whose unique,  SD- **
** assigned serial number matches that for which  the  software was **
** purchased.  Copying the software  for  any  purpose  other  than **
** archival storage, or use of the  software on other than the  as- **
** signed serial numbered CPU is strictly  prohibited.   SD assumes **
** no liability regarding the use of the software.                  **
** Certain  software  programs and  datafiles are delivered for use **
** in an encrypted  format.  The content of such  programs and data **
** are  considered  to be a  trade  secret of SD.  Attempts or suc- **
** cess at  breaking the  encryption, publication of the results of **
** such attempts or successes, or copying, storage or use of such a **
** file in clear text form will be treated as theft of a trade sec- **
** ret, and prosecuted as such.                                     **
** POSSESSION OR USE  OF THIS  MANUAL OR THE SOFTWARE  IT DESCRIBES **
** CONSTITUTES AGREEMENT BY THE USER TO THESE TERMS.                **
**********************************************************************
.ix Encryption
.sp
.ll 65
.pw 85
This manual and the software it describes are the copyrighted property of
Software Dynamics.
.pa
Changes to make to this document:
.sp 2
Under SDOS/MT, what about I/O to ports other than CONSOLE:, LPT:?
.sp
There is a high-performance block move subroutine built into SDOS, usable by
any task (i.e., uses scatchpad locations.)  This note belongs in I/O
package description.
.sp
Write up ESC timeout stuff for DPBs.
.sp
What does ^H do on a hardcopy device?  Adjust user's manual?
.sp
DPBFLAGs:XON handshake bit allows operation of VT driver with terminals that
use XON/XOFF for flow control.  This bit disables echo of ^S.  Should your
terminal get hung up, and it uses such flow control, then typing ^Q may get
it out; this can happen if the ^Q sent by terminal after ^S gets garbled by
line noise.
.sp
See VT11D Version history notes for new changes.
.sp 2
SDNET STUFF
.SP 2
.im 10
              Talk about:  RECOVERFILES
              TAPEBACKUP
              NEW SCANDISK
              VARIOUS PROPERTIES OF FANCY FLOPPY DRIVER

              SDOS System Support Utility programs

              FINDBADCLUSTER
              THE SERIALIZE, RECRYPT and patching encrypted
              files
Stuff from NEED WRITEUPS ON
.SP
Write up Floppy Formatter
.SP
TS program
.sp
* NEED WRITEUPS ON: **** INFO CALCULATE JOBCONTROL PERFORMANCE KEYVALIDATE
FORMAT
.SP
NEED DISK ERROR STATS DOC
.pa
NOTES ABOUT CHANGES TO EXTERNAL SDOS SPECIFICATIONS
.SP
Under SDOS/MT (not clear about single user SDOS), SYSCALL:READA triggers
ERR:ACTIVATIONNOTINBUFFER if reply if filled and no activation character is
received.
.sp
CC:KILLPROOF delays job abort until job does CC:KILLENABLE.  A background job
will be stopped automatically if log disk space is exhausted; no error will
be recorded because no disk space is available to record in it.
.sp
SDOS/ES allows a foreground user and a background user; background user is
simply a "job" and cannot communicate with the terminal.
.sp
The format of the data read from the CLOCK:  device is THE STANDARD SDOS
clock format (with the possible extension of a single byte to make a 32 bit
within-day timer).  All timestamps throughout the system have IDENTICAL
formats.
.sp
DIR:HCSIC and DIR:NCLUSTERS are now both zeroed when a file is deleted.
.pa
NEW LOAD RECORD TYPES
.SP
Motorola and other semiconductor manufacturers insist on producing many
variants of the 6800/6809 family.  Each of these chips has a slightly
different instruction set, and so object files for these chips must be
distinguishable so an SDOS system for a particular machine will refuse to
execute an object file for a different machine.  The distinguishing mark is
the first byte in the start record of an object file.  New chip types are
defined as follows:
.im 4
     $09      M6805 object files (produced by SD's ASM05
              assembler)
     $11      M6811 object files (produced by SD's ASM68 assembler
              with WI M6811 set.
.im 0
.pa
The PERFORMANCE test.
.sp
The PERFORMANCE program is used to test the performance of an SDOS system.
It measures some computational properties of the SD Runtime package that
are key determiners of application program execution speed (FOR-NEXT loop
timing, string-copy timing, and subroutine call/return overhead), and
various SDOS operations (disk file I/O speeds for various kinds of disk
operations such as PRINT and INPUT, READ and WRITE (small and large amounts),
CREATE and DELETE times, and terminal I/O speeds.
.sp
The program is useful for two purposes:  first, to determine if a particular
SDOS system is tuned as well as others (simply compare the results), and
secondly, to help application programmers determine how to write their
programs using efficent SDOS operations.
.sp
The program is self-explanatory in operation.
.sp
EXAMPLE:
<EXAMPLE GOES HERE; get example from SMOKE.>
.PA
REHASHING A DIRECTORY
.SP
SDOS hashes a filename to select an initial search starting point in
DIRECTORY.SYS.  A filename search starts from the starting point and scans
DIRECTORY.SYS forward till the end of the directory, and then continues from
the beginning of the directory.  The search stops under one of two conditions:
the filename is encountered in the directory, or a "never-before-used"
directory entry is found.  Under ideal conditions (the number of free slots
in the directory is more than about 20% of the total number of slots in the
directory, and the directory has not recently been completely full), this
scheme virtually assures that the filename will be found by scanning 1 or 2
directory sectors, (i.e., a single seek) or that the search will terminate
(with "file not found") by encountering a "never-before-used" directory
slot.  Thus good performance with even very large directories is assured.
.sp
If DIRECTORY.SYS has recently been expanded (SDOSDISKINIT "expands"
DIRECTORY.SYS on a blank disk from "empty") or has fewer than 20% free slots
in it, then SDOS may have to search large parts, or even all of
DIRECTORY.SYS when locating a file name.  This is particularly time
consuming on RENAME, CREATE, and DELETE (non-existent) files, and will
especially adversely affect the operation of SDOS/MT.  The cure is to run
REHASHDIR, which re-organizes the directory, expands/shrinks the directory,
and ensures that the file name lookup is reasonably optimized.
.sp
NOTE:  BEFORE RUNNING REHASHDIR, READ THIS ENTIRE SECTION.  REHASHDIR should
be run every few months on a live system simply to ensure that directory
searches are not getting slow.  It can be run simply to display
"hashing statistics", and will tell the operator if the hashing statistics
are inappropriate.
.sp
The program will ask the name of the disk drive to rehash, and will then
display some statistics about the current organization of the directory on
the drive.  One should write down the statistics values before proceeding
(the program will print enough output while re-organizing the directory so
these statistics will roll off the screen) so they can be compared with the
statistics produced when the process is completed.  Only two of the
statistics are really useful:  the number of free slots, and the average
lookup time (i.e., how long it takes SDOS to OPEN/CREATE/RENAME/... a file).
The larger the number of free slots in a directory, the lower the average
lookup time AFTER the directory has been rehashed.  At this point, the
program will offer to reeorganize the directory.  If the statistics are
satisfactory, the user may simply quit.  If unsatisfactory, the user can
request the program to actually reorganize the directory.  If he asks to
reorganize the directory, the program will offer an opportunity to change
the size of the directory, and will the recompute the statistics.  This is
primarily important when checking that there are enough free slots;  changing
the directory size generally makes the lookup time go to hell, but
reorganizing the directory AFTER it has been extended will neatly solve
this problem.  If the user does not want the directory size changed, he
simply lets the program proceed to the reorganization pass.  On a
Winchester with 1000 file slots and "enough" free slots, this takes about 2
minutes; larger directories will take correspondingly longer.  When the
process is complete, the directory statistics are re-computed so any
improvement can be seen.  If there are very few slots in the directory,
re-organizing it will take a VERY long time (20 minutes to an hour); under
these circumstances, the directory should always be expanded.
.sp
WARNINGS:  NEVER REHASHDIR WITHOUT HAVING FIRST RUN SDOSDISKVALIDATE AND
OBTAINING A "CLEAN BILL OF HEALTH" FOR THE DRIVE.  ALWAYS MAKE SURE THAT ALL
FILES YOU WANT ARE BACKED UP SAFELY BEFORE STARTING THIS PROCESS.  DO NOT
ATTEMPT TO EXPAND THE DIRECTORY IF THERE IS NO FREE SPACE ON THE DISK DRIVE.
DO NOT ALLOW OTHER USERS TO USE THE SYSTEM DURING THE REHASHDIR PROCESS.  DO
NOT TYPE ^C^C OR (ESCAPE) DURING THIS PROCESS AS YOU COULD LOSE ONE OR MORE
FILES; THERE IS ALSO A CHANCE OF LOSING THE DIRECTORY ENTIRELY.  While the
REHASHDIR program IS reliable, it is possible that a power failure, hardware
failure, or operator error can abort the process before the directory has been
restored to a usable state.
.sp
To convince yourself that it is safe and to get some experience running it
before trying it out on a live system, we suggest you build a few floppy
disks (that you don't care about) full of stuff and run the program on them
first.
.sp
After SDOSDISKINIT'ing a Winchester, the REHASHDIR procedure must be run if
one desires ensure efficient lookups.
.pa
EXAMPLE:
<EXAMPLE GOES HERE; get example from SMOKE.>
.pa
The LOGOFF program (PUT THIS NEAR /MT documentation)
.sp
LOGOFF is a program run by SDOS/MT at boot time, or by a user when he is
through using an SDOS system.  Its primary purpose is to prevent unauthorized
users from gaining access to an SDOS system.  This is useful for systems used
in high-traffic areas, or on systems which have dial-in ports.
.sp
The program has two modes of use:  NORMAL and SUPPORT.  Normal mode is the
default, and occurs when the program is started with no parameters; this
"logs" the fact that a user has left the system.  Once logged off, the
program merely waits for a keyboard entry matching a person's ID, and then
asks for a password.  If the ID and the password match (ignoring
upper/lowercase distinctions) a User profile data base, then the user is
allowed access to the computer (If one desires anybody to use the system, one
simply adds a user with the ID "ANONYMOUS" and an empty password).  A failed
match causes denial of access to the computer.  Failed attempts get recorded
in a  log file so that attempts to crack a system can be traced.  The program
cannot be aborted by ^C^C or by ESCAPE, and thus a valid ID and password must
be presented to the LOGOFF program to gain access to the system.  A
successful attempt is called a LOGIN, and the ID of the logged in person is
timestamped and recorded in the LOGOFF.DATA file.  The file LOGOFF.NEWS is
printed so that system messages can be seen by all users; this file can
simply be edited if one wishes to change news seen by users.  Initial access
to the computer causes a particular program, dependent on the user ID, to
fetched; normally, this is DEFAULTPROGRAM, but it may be something else if one
wishes to restrict the user to running a particular program.  Normal mode runs
KILLPROOF, so it cannot be aborted by a conventional user.  KILLPROOF mode is
removed if the user profile so states.
.sp
Support mode is entered when the LOGOFF program detects a login attempt with
user id of MANAGER that has the correct password.  In support mode, one can
add new ID and profile information, delete a user ID and profile information,
change a user's password or profile (by deleting and re-inserting the ID); or
one can adjust the LOGOFF.DATA file.  These functions cannot be performed by
users not in support mode, as the LOGOFF.DATA file has its contents stored
in an encrypted (I wish!) format.
.pa
Support mode is also entered the first time the program is operated to allow
the manager's account to be inserted into the database.  When exiting support
mode, the screen is erased so no LOGOFF.DATA information is visible to a
casual user.  Creation of the LOGOFF.DATA file is enabled by the response
"ZAP" instead of the more obvious "YES" when asked; this keeps users which are
not familiar with this documentation from firing up a fresh copy of LOGOFF and
locking everybody else out of the system.
.sp
The LOGOFF.DATA file is kept write-protected to ensure it is never
accidentally erased.  Should LOGOFF.DATA ever get garbled, the cure is simple:
boot from another disk that does NOT have a LOGOFF on it, delete the garbled
LOGOFF.DATA, and reboot.  You will automatically enter support mode, and will
be forced to re-create a valid LOGOFF.DATA file.
.sp
At SDOS boot time, LOGOFF will accept and set TIME if not already properly
set by the I/O package; this is necessary as LOGOFF wants to update
LOGOFF.DATA and can't do that unless TIME is set.  The time will be
requested only from the main CONSOLE:; other users will be prevented from
obtaining access to the system until the time has been set.
.sp
When logging a user out, LOGOFF attempts to DISMOUNT DISK:.  This hints to the
disk driver that DISK:  should park its heads when the last user logs off.
Failure to DISMOUNT will not affect any running applications, but will notify
the user logging off that there are other users still using the system.
Note that a successful dismount does not mean that there
are no other users on the system; but a failure is a sure indication that some
program has a file open, which means that a user is still on the system.
.sp
LOGOFF needs to be attached to a Runtime package before it is placed in the
file LOGOFF as it runs before a DEFAULTPROGRAM at boot time.
.sp
LOGOFF.DATA file format:
.sp
16 Bytes    LOGOFF data file interlock object ID.
.br
64 Bytes    System ID message.  Printed at each login attempt.
.br
6  Bytes    Number of user records.
.br
57 Bytes    User Record.  Format as follows:
            16 Bytes:  User ID, lowercase, blank padded
            16 Bytes:  User password, lowercase, blank padded
.pa
.im 2
            1  Byte:   KILLENABLE flag
            24 Bytes:  Name of program to run on LOGIN
.im 0
.sp
Ascii line:  User LOGIN record
            8  bytes:  "LOGIN" "LOGOUT" or "FAILED"
            ~15 Bytes*  MM/DD/YY HH:MM (time of login attempt)
            16 Bytes:  User ID, blank padded
            16 Bytes:  User password if login attempt failed
.sp
<EXAMPLE OF LOGIN GOES HERE>
.SP
<EXAMPLE OF MANAGER OPERATION GOES HERE>
.SP
<EXAMPLE OF INITIAL OPERATION GOES HERE>
.PA
.he SDOS SYSTEM IMPLEMENTER'S GUIDE
.sh SECTION I: I/O PACKAGE
.il Copyright (C) 1978
.ir Software Dynamics
.PA
SDOS SYSTEM BUILDERS GUIDE
.sp
New revisions of FIX are available that allow use of SEDIT instead of EDIT.
.sp
SD offers several UNSUPPORTED utility programs with SDOS systems. This short
note describes these programs.
.pa
.pw 130
.ll 100
.im 3
"SLIST" -- SOURCE LISTER PROGRAM
  PRINTS BIG BANNER HEADLINES, FOLLOWED BY SOURCE LISTING...
TO OUTPUT DEVICE (DEFAULT = :LPT) OF ONE'S CHOICE.
.sp
.im 8
INVOCATION FORMAT:
    .SLIST file ["title"][options][TO device:][/WIDTH=nnn][/DEPTH=nnn]
or
    .SLIST @file [TO device:][/WIDTH=nnn][/DEPTH=nnn]
or
    .SLIST "title" [/WIDTH=nnn][/DEPTH=nnn]
or
    .SLIST
.sp
.ll 65
.pw 85
If the '@' is not present, the file is presumed to contain the listing. If
'@' is present, file contains a LIST of files to be printed this way. If
SLIST is invoked all by itself, it will converse with the operator.
.sp
The optional title will be printed instead of the filename, if supplied.
.sp
Options are "switch" format signals specifying that SLIST is to perform some
optional processing.  These switches are individually set and reset for each
file listed, and can be attached to file names in an "at" file.  Currently
defined switches are:
.sp
.in 15
.un 15
/P{aginate}~~~~Causes Pagination of Source file
.br
This means that each printed page is titled with the name of the file
(device prefix is dropped), the creation date of the file, the current time, and
source form and page number info. Each line from the source file is numbered
and followed by a Bar character to seperate the numbering from the source
text. The characters ^L, if found in a source line in columns 2 and 3, or
columns 3 and 4, cause a page throw.  The rest of that source line is NOT
listed. The 1st (two) characters are ignored to allow a language specific
comment to precede the ^L.
.sp
.un 15
/O{override}~~~Supresses automatic processing determined by the file
extension.
.pa
.in 0
SLIST knows about several kinds of file extensions.  Each extension causes
certain automatic processing to take place, as a convenience. The processing
is extension-specific. Any file whose name is of the form "xxxxx.LPT" is
simply printed as is, as are all files whose extension type is not known to
SLIST.
.sp
Files whose name is "xxxxx.BAS", "xxxxx.ASM", "xxxxx.DO" are automatically
paginated.
.sp
.im 2
     /WIDTH=xxx specifies an over-ride width.
     /DEPTH=xxx specifies and over-ride depth.
.sp
Width and Depth are defaulted to the values returned by the output device.
.sp
.ll 65
.pw 85
.br
SLIST is used to print large block letters as the heading page of a listing.
After giving SLIST a title line (and an optional filename), SLIST will print
a block letter version of the title line and a block letter version of the
current time and date. The contents of the specified file are listed
following the title page printed.    REWRITE-->Add printer interlock code,
like MTPRINT.BAS Add code to handle .DO as paginate case.
.sp
FINDLABEL is a program that makes locating the name of a label in compiled
BASIC program much easier.  When a BASIC program prints a line number of the
form :dddd (because of an abortive error, trace/breakpoint or PRINT
HEX$(ELN) statement), one normally must look in the symbol table produced by
the assembler to find the name of the corresponding label. When using FIX or
COMPILE, the symbol table is automatically placed in the file "ASMLOG.TMP". 
Typing FINDLABEL :dddd<CR> will cause FINDLABEL to search ASMLOG.TMP for the
symbol, and display the corresponding name as <LABELNAME>/:dddd. If no such
label is found, nothing is printed.
.sp
.pa
STRIPIFS is used to remove unwanted conditional assembly code from an
assembly language source file. The program allows the operator to examine
each of the conditions on conditional assembly statements in turn, and
declare the value of the condition to be unknown, TRUE, FALSE, or wrong
(needing a change). STRIPIFS then leaves the conditional assembly text
alone, drops the unneeded conditional assembly statements, drops the
conditional assembly block altogether, or allows alteration of the
condition, as required.  If STRIPIFS drops text because a condition is
false, code after an ELSE is retained without conditional assembly
statements around it, and similarly for other conditonal statements.
Operation of the program is pretty much self-explanatory once it is invoked.
.pa
Disk I/O Test (DIOTEST)
.sp
DIOTEST is a go/nogo test for SDOS disk I/O facilities, and is the main tool
used in-house at SD for this purpose.  It checks for proper operation of SDOS,
I/O package disk drivers, and the disk media.  It can be used to periodically
verify the continued correct operation of an SDOS systerm, or more usually, to
help verify the absence of problems in a newly generated I/O package (this is
especially important when any changes to disk drivers are made).
.sp
INACCURATE:  Operation is simple:  run DIOTEST, and give it the name or a disk
device (or a file, if you wish to work out SDOS more than the drivers).  It
will ask how many bytes are to be allocated to the test region of the
disk/file (an IBM floppy has 256256 bytes).  DIOTEST will request a function
to perform; FILL is the right thing to do first (if DIOTEST says the disk is
write locked, let it unlock it by answering "YES"; you will then have to
repeat the command).  A FILL causes DIOTEST to write the numbers
0, 1, 2, 3, etc. in binary format.  This process essentially marks every 6th
byte on the disk with a unique code.  The FILL process takes roughly 1/2 hour
on an IBM floppy.
.sp
The fill pass automatically does a SEQuential read test, which reads back all
of the numbers written to verify that they were correctly written in the
proper order.  If the disk size was specified when DIOTEST was started, it is
obvious (well, left as an exercise for the reader) that for this test to
succeed, each and every sector on the entire disk must have been written
properly!  (and even more important, that none of the Logical Sector Numbers
assigned specify the same physical sector of the disk).  If an error is
encountered, DIOTEST will display the expected value, and the retreived
value respectively.  The Logical Sector number of the offending sector can
then be located by multiplying the expected value by 6, and dividing by the
sector size in bytes.  A RANDom test is used to check out proper seeking
to random places (it assumes FILL has already been performed).
.sp
The RANDom test displays errors in the same form as the SEQ test.  It takes
an extremely long time to run (like overnight).
.sp
The EXTEND test increases the number bytes to be tested by roughly 30%, and
fills the newly added part before doing a SEQ test.  This is useful when
testing an SDOS disk file for proper extension.
.sp
RND WRT test randomly positions all over the target file, and writes the
position it thought it positioned to into the sector it finds there.  When
through, it runs a SEQ test to verify that all the dats written was written
to the correct place.  Like RANDom test, this takes a long time for a disk
device.
.PA
We typically run FILL, RAND, and RND WRT tests on new I/O packages before we
release them.  If ANY error is reported by DIOTEST the cause should be
located (it could be a tired floppy) and corrected.  If this is not done,
operation of SDOS will be unreliable.  A very useful thing to do when the
tests are complete is to take note of the Error counts reported by
DISMOUNTing the tested disk; this will give an idea of the expected "soft"
error rate; since floppies should have been named "flakies", this count will
normally be non-zero but small.
.pa
NOTE REVISED SCANDISK:  REDOCUMENT.  SCANDISK is used to scan a disk(ette)
for bad or flaky sectors, and to attempt to repair the bad sectors. To
invoke the program, type
.br
     SCANDISK diskname:
.br
The program will ask for a starting (logical) sector number; <CR> is
interpreted as "zero" and is the normal value to use. SCANDISK will read
across the disk, printing every 64th LSN as a record of its progress. If an
unreadable sector is encountered, SCANDISK will display the error obtained,
and offer the operator an opportunity to re-try the read some number of
times. When a disk read error is the cause, the retries sometimes succeed in
reading the sector correctly; the program will let the operator write the
correctly obtained sector back to the disk (this generally cures the disk
read error permanently).  Note: SCANning the disk runs significantly faster
if the disk is mounted with a reasonable mapalgorithm; and easy way to
accomplish this is to type MOUNT diskname: before invoking SCANDISK.
.sp
FINDBADCLUSTERS tests all the sectors on a disk for
readability/writeability, and updates BADCLUSTERS.SYS with the Logical
cluster number of any sectors found to be bad. It can only be run on a disk
that has been SDOSDISKINITed (otherwise no BADCLUSTERS.SYS exists!).
FINDBADCLUSTERS examines all clusters not marked as "allocated" in the disk
map, so it is a good idea to run SDOSDISKVALIDATE first, to make sure the
disk map is not damaged. If the disk map is correct, FINDBADCLUSTERS can be
safely run on any disk, with no effect on the files on that disk (although
none of the sectors held by the files will be tested). To invoke the
program, type FINDBADCLUSTERS diskname:.
.sp
RECOVERFILES is used to recover from a directory disaster (it can also
generally resurrect a file accidentally deleted, but is not intended for
this purpose). RECOVERFILES can be made to recover only text files that
contain a certain string in the first data sector. To invoke the program,
type RECOVERFILES diskname:. Operation is obvious once the the program is
started.  NOTE ABOUT HAVING TO REHASH TO OBTAIN FILE NAME; DON'T USE
DUPLICATE FILE NAMES, MUST VALIDATE WHEN DONE.
.pa
EXORCISE is used to make EXORcisor(TM Motorola)-based SDOS bootable after
SYSGEN. The EXORcisor disk controller reads in sector 20 and 21 when told to
do an OSLOAD$; SDOS systems require sector 0 to be read. EXORCISE modifies
each sector on track 0 to contain code that says, essentially, "read in
sector 0", so that no matter which sector the boot rom reads, sector 0 gets
read next. EXORCISE fiddles with the load records in SDOS.SYS in a
non-destructive way to accomplish this. Failing to use EXORCISE after a
SYSGEN will result in an unbootable disk.
.PA
.ix MAKEBINARY
.in 10
.un 10
MAKEBINARY converts
.IX MIKBUG
.un 10
MIKBUG records into SDOS load format
.ix Program Loading
records, which considerably speeds up program loading and
uses less file space.
.sp
.ix MAKEMIKBUG
.un 10
MAKEMIKBUG converts SDOS files containing load format records
to MIKBUG format.
*********finish example .asm*****************
????????????????????????  MAKEBINARY** STEAL THIS STUFF FROM OLD SDOS MANUAL!!
.sp
.in 0
.ix MAKEBINARY
.ix MIKBUG
MAKEBINARY is used to convert MIKBUG format files to SDOS
.ix Load Record Format
Load Record Format.  MAKEBINARY should be used on production programs
because Load Record Format files occupy less disk space and load faster than
the MIKBUG versions.
.sp 2
.tc
.ix MAKEBINARY
MAKEBINARY is invoked by typing its name:
.sp
.im 1
        .MAKEBINARY
.sp
It will identify itself, and prompt for a MIKBUG input file, and a binary
output file.
.sp
.im 3
        MIKBUG INPUT FILE = PRIME.MIK
        SDOS LOAD RECORD OUTPUT FILE = PRIME
        START ADDRESS = <CR>
.sp
.ix Start Address
If <CR> is typed in response to START ADDRESS, the start address is set to
that of the address of the first MIKBUG load record (this is automatically
correct for compiled BASIC programs).  Otherwise, a hex value must be
entered; this value is taken to be the start address.  ********makemikbug
goes here as soon as i find it************ MIKBUG LOAD RECORD FORMATS
.sp
MIKBUG records are handled by SDOS to retain compatibility with Motorola
compatible software.  MIKBUG records are inefficient on both space and load
time because all binary data which participates in the load process is
stored in ASCII format, 2 hex digits per byte, and requires conversion by
the loader.
.sp
Only two MIKBUG record types are processed by SDOS: S1 and S9 records.
.pa
S1 records specify a count byte, a load address (2 bytes) and a set of data
bytes to be loaded into sequentially increasing addresses starting with the
load address, and a checksum byte.  Each "byte" is represented by 2 ASCII
hexadecimal digits (0-9,A-F).  The count byte includes the address and the
checksum byte.  The address has its MSB first, LSB second.  The checksum
byte is equal in value to hex :FF minus the sum of the binary values of the
count, address MSB and LSB, and all the data bytes, modulo 256.
.sp
Example: S1061002A7D967
.sp
S9 records are used to mark the end of a load file.  Officially, S9 records also
contain a start address; SDOS ignores this and uses the first load address
given by an S1 record as the start address.
.sp
CR (hex :0D) characters and nulls are legal between MIKBUG load records, but
nowhere else.  No other characters are legal in a MIKBUG image load file.
.sp
**********WRONG********MAKEMIKBUG accepts SDOS object files for 6800, 6801,
6303, 6805, 6809, and 6811.
.BR
The SD 6800 Assembler produces "binary" load files in MIKBUG format.
.IX MAKEBINARY
.IX MIKBUG
.ix Files
.ix Sector Boundary
.ix DMA
.ix Sector Size
.ix Sector, Physical Boundary
The utility program, MAKEBINARY, converts MIKBUG format load files into SDOS
load record format files, and does some alignment of data records on
power-of-two positions within the load file.  This optimization is intended
to increase the probability that large load records, with addresses that are
a multiple of the physical sector size for a disk, start on a physical
sector boundary within a file, thus providing SDOS with the opportunity to
do direct DMA reads from the disk file.
.sp
***SRCCOM, Recoverfiles, scandisk, serialize, find bad clusters, makebinary,
makehex, patch
.pa
.ix Running A Program
RUNNING A PROGRAM
.tc
.sp
How to run a program
.sp
How to give a userprogram parameters
.sp
Mumble about encrypted programs, here.
.sp 2
COMMAND LINE PROMPTING
.ix Command Line Prompting
.ix Prompts
.ix VT Driver
.ix Null Prompt
.sp
Most utility programs supplied with SDOS have two styles of use: terse and
dialogue. Utility programs are either used heavily (e.g., COMPILE) or rarely
(e.g., RECOVERFILES).  For those used heavily, it is convenient if an
easy-to-type notation is available to invoke it.  For those used rarely, a
sequence of prompts to help the operator thru is very nice human
engineering.  This implies 2 parameter collecting routines are needed for
each program, and a way for the program to determine which parameter style
is desired by the user.  This is easily accomplished with SDOS systems that
have the VT driver: the COL(0) function will have a zero value on entry to
the program if <utility><cr> was typed; it will have a non-zero value if
<utility><space><parameters> was typed.  If a non-zero value of COL(0) is
found, then parameters have been supplied on the command line and can be
read by the program by simply doing INPUT '' PARAMETERS$ (the '' is a null
prompt). If a value is zero if found, the operator has clearly not supplied
any parameters, and should be prompted for them; it is especially nice if
the utility then shows the user what he could have typed instead to avoid
all the prompting, thus teaching him how to save his own time.  This style
of fast prompt/easy prompt will become more common in SD software over time.
.sp
??????TERSE OR VERBOSE??????
.pa
SDOS SYSTEM BUILDERS GUIDE
.SP
MORE SUBJECTS TO WRITE ABOUT:
.SP
HOW TO DO FAST DIVIDES FOR LSN SHREDDING
.BR
GENERIC MAPPING FOR WINCHESTERS OF SIZE 5Mb to 250 MB
.br
BOOT ROM STYLE + SUGGESTED EMBEDDED DIAGONSTICS
.BR
SEMICONDUCTOR DISK SOFTWARE
.BR
SDNET STUFF
.PA
.tc
FILE CONTROL BLOCKS (FCBs)
.ix File Control Blocks
.ix FCBs
.sp
.ix Files
.ix IOCBs
.ix Open
.ix Channels
FCBs are used to keep track of files as entities.  (IOCBs are used to keep
track of I/O paths to files, so there may be several IOCBs associated with
an FCB, i.e., when the same file is open on two channels).
.sp
.ix File, Created
.ix File, Opened
.ix File, Deleted
.ix File Size
.ix Clusters, Allocated
.ix I/O Channels
.ix FCB
The FCB tells SDOS where the file is on a disk, whether the file is newly
created, simply opened, or deleted; the size of the file, number of
allocated clusters, etc.  Having all this information in one place for a
file means it can be open for update and/or expansion on several I/O
channels, and an expansion or deletion operation on one channel will be
automatically noticed on other channels because the FCB is shared.
.sp
.ix Directory
.ix Pointer, FCB
Also, the FCB contains a pointer to the directory slot for that file so if
directory updating is required, it is easily accomplished.
.sp
.ix Directory
.ix Diskmap
.ix Error File
All open files, including the directory, the diskmap, and the error file are
recorded in FCBs.
.pa
The Boot ROM
.sp
SDOS requires a certain code sequence in the Boot ROM. This code is
explained below. The Restart and NMI vector routines must check an
"Encrypted program is running" flag; if it is set, then memory must be
zeroed (this code sequence MUST be in the ROM). SDOS locates this flag by
following the Restart vector to a Jump instruction, which must point to a
fixed instruction sequence (see below).  The extended address specified in
the LDAA instruction is defined as the location of the "Encrypted program is
running" flag; if this code sequence does not exist in the ROM, SDOS will
refuse to load any encrypted file (including SERIALNUMBER.SYS).
.sp
The Restart code sequence must be exactly as follows:
.sp
.im 18
      $FFFE --> JMP $xxxx
                [8 bytes of CPU Serial Number]
                ...
      $xxxx --> LDS  #anyvalue           Set up stack pointer for JSR
                LDAA RunningEncrypted    [Extended mode reference]
                BEQ  Dontzeromemory      b/ Not running Encrypted
                LDAA #numberofbanks-1    = largest number of banks
      EraseBank JSR  SELECTBANK          Turn on bank given by (A)
      EraseMem  LDX  #$BFFF              Yes, zero out user memory
      EraseLoop CLR  0,x                 Make it go away.
                DEX                      Get all of it...
                BNE  Eraseloop           B/ Not done yet.
                DECA                     Preserved by SELECTBANK
                BPL  EraseBank           Assert: Numberofbanks<128
      Dontzeromemory ; Where to go if not running encrypted
                ...
                CLR  RunningEncrypted    Mark "Not running encrypted"
                ...
.sp
Similarly, the NMI sequence must be as follows:
.sp
.im 4
      $FFFC --> LDAA RunningEncrypted    [Extended mode reference]
                BNE  AnyRTI              B/ Running encrypted, ignore
                ...                      No, do as we please...
      AnyRTI    RTI                      How to get back from NMI
.sp
SDOS sets the RunningEncrypted flag whenever it encounters a CHAIN to an
encrypted module (a LOAD request aimed at an encrypted module is not honored
unless the module to be loaded is encrypted with a key identical to the key
of the module invoking the LOAD). Before loading the CHAINed-to module, SDOS
first trashes the user space. If a RunningEncrypted program issues a
LOAD/CHAIN, the userspace is trashed; however, if the CHAINed-to program has
the identical decryption key, the userspace is NOT trashed, thereby allowing
an application suite to CHAIN among its components, passing COMMONed
variables.
.pa
SDOS SERIAL NUMBERS
.sp
*******:NEED REVISION********
.sp
SDOS serial numbers are used to identify systems assigned serial numbers by
SD or its distributors.
.sp
These serial numbers are 8 bytes long.
.sp
Serial numbers are assigned to each machine licensed for SD software. The
top 8 bits of 64 are used to hold a distributor code (with SD's code being
:5D). The bottom 56 bits contain the customer number for that distributor.
Serial numbers are placed in a ROM in the assigned machine, such that the
restart address points to 8+ address of serial number block.  A serial number
whose bottom 56 bits are zero is reserved for a particular distributors
main development system.
.sp
ROM Serial Numbers:
.sp
.im 9
          ________________________________________________________
          | JMP |   |   |  D# |    |    |    |    |    |    |    |
          --------------------------------------------------------
             ^
             |          | <------- 8 byte serial number -------> |
         ____|____
  :FFFE  |   *   |
         ---------



.sp
The ROM serial number is located by following the restart vector pointer and
is checked by SDOS to make sure it is in a ROM.
.sp
Serial numbers are assigned by an encryption program supplied by SD. This
program is, of course, encrypted.


.bp
.pa
.tc
.ix I/O Package
I/O PACKAGE
.sp
This section describes the I/O package part of SDOS.  It need be read only
by system programmers who need to change the I/O configuration of SDOS.
.sp
.ix Local Environment
.ix Drivers
.ix Disk Sector Read
.ix Disk Sector Write
.ix Interrupt System
.ix System Debugger
.ix Buffer Space
.ix Disk Sector Verify
The I/O package customizes SDOS to the local environment. It contains
drivers for the various devices; it contains disk sector read, write, and
verify routines; it contains information allowing SDOS to control the
interrupt system, locate the system debugger, and it contains the buffer
space used by all the drivers.
.sp
.ix SDOSIOPKDEFS.ASM
This section describes each of the different parts of the I/O package in
some detail.  Examples are given.  Symbolic definitions of all assembly
language labels defined in this section of the manual can be found in the
file SDOSIOPKDEFS.ASM.
.sp
First, we give an overview of how SDOS does I/O.
.pa
.tc
SDOS INTERRUPT SYSTEM PHILOSOPHY
.ix Interrupt System Philosophy
.ix Manufacturer's Implementation
.sp
This section gives the philosophy of the software part of any SDOS interrupt
system.  Naturally, this view is colored by characteristics of the 6800/6809
hardware, and, in particular, the specific manufacturer's implementation of
a 6800/6809 computer system.
.sp
.ix Timeouts
.ix Hanging
.ix Priority Interrupts
The interrupt system allows multiple I/O tasks with nested, priority
interrupts.  Timeouts prevent programs from hanging up on I/O devices.
.sp
.ix Task
.ix Scheduler
.ix User Program
.ix SYSCALL
.ix I/O Driver
.ix Interrupt Routine
.ix Interrupt
Execution of a particular sequence of programs is done by "tasks".  A task
is literally an execution of a program that can wait for some event, or be
stopped and started by the "scheduler".  Several tasks can simutaneously
exist, each in its own state of execution or waiting.  One task is dedicated
to execution of the user program; this task is known as the user task.  The
user program performs I/O by issuing SYSCALLs which cause the user task to
eventually execute an I/O driver routine.  The I/O driver stores information
describing the I/O in a table it shares with the interrupt routine for that
device, and then causes an interrupt to activate the interrupt routine.  The
interrupt routines process the interrupt.
.sp
.ix SYSCALL
The SYSCALLs simply switch the user task to the proper I/O driver after some
"reasonableness" checking.
.sp
.ix Task Level
.ix Interrupt Level
.ix Poll Chain
.ix Device control block
.ix DCB
An I/O driver has several parts: the task level part, which is executed by a
task to signal the need for I/O; an interrupt level part, which services an
interrupt; a poll chain portion, which detects that a particular device
needs to service an interrupt; a device control block, which holds data
describing to SDOS the type of device and certain parameters, and finally,
miscellaneous storage, to hold data not suitable for storage in a DCB.
.sp
.ix I/O Driver
.ix SYSCALL
.ix Data Tables
.ix Queues
.ix Interrupt routines
.ix User Task
.ix Peripheral Device
The I/O driver is responsible for interpreting the specific SYSCALL and
setting up any data tables, or queues needed by the interrupt routines to
perform the desired I/O.  In many cases, the task level portion of the I/O
driver will cause the user task to wait for the completion of some
operation being performed by the interrupt routine for that device before
setting up tables, etc.  Generally, the I/O driver itself needs to do no
actual I/O (i.e., any loads, stores, or tests of peripheral device
registers).
.sp
.ix Interrupt Routine
.ix Physical I/O
.ix I/O Device Driver
The interrupt routines for a device perform all the physical I/O (loads,
stores, etc.) to the device (registers), using the data set up by the I/O
device driver.  The interrupt routines also signal completion of an
operation and readiness for another operation to the I/O device driver so
that any waiting task(s) may continue setting up data required for I/O.
.sh SECTION II: INTERRUPTS
.pa
.tc
INTERRUPTS
.sp
.ix Nested Interrupt
.ix I/O Package
When an interrupt occurs, the 6800/6809 microprocessor saves the current
context on the stack and transfers to an interrupt routine.  At this point,
interrupts are off.  The interrupt routine is required by SDOS to switch to
a new stack if this is not a nested interrupt.  This scheme obviates the
need for any tasks to allocate stack space for nested interrupts; a special
interrupt stack is set aside in the I/O package for this purpose.
.sp
.ix Interrupt Context Block
.ix FIRQ
.ix NMI Context Block
The total space a user program must dedicate to interrupts is one interrupt
context block, one FIRQ block, 8 bytes and an NMI context block.
.sp
.ix STACKSWITCHED
.ix Interrupt Nesting
.ix Interrupt
A (single byte) counter, SDOS:STACKSWITCHED, is used to keep track of the
interrupt nesting level.  If the counter's value is -1 (:FF), the stack in
use is that of the currently executing task, and must be switched when an
interrupt occurs.  Each time a (nested) interrupt occurs, the counter is
incremented by one, so the counter always contains a value equal to the
number of nested interrupts minus 1.  The counter is decremented on exit
from an interrupt routine, and stacks re-switched if the interrupt stack is
empty.
.sp
.ix Nested Set of Interrupts
.ix Interrupt Routine
.ix Stack Switching
.ix CURRENTASK
It is assumed that no more than 127 interrupts can be nested, (i.e., the
counter can never be incremented from :7F to :80). Switching stacks is
required only on the first of a nested set of interrupts, and requires the
interrupt routine to save the current value of the S register in the task
control block selected by SDOS:CURRENTASK; then the S register is loaded
with a pointer to the end of the reserved interrupt stack area. Stack
switching must occur before interrupts are re-enabled. 
.ix Interrupts
.ix Fast Devices
.ix Slow Devices
.ix FIRQ
.sp
The interrupt scheme divides devices into two categories: fast and slow. 
Fast devices require very fast response but need very little processing;
examples are output interrupts for serial terminals, FIRQ, etc.  Slow
devices include all other devices.
.sp
.ix Stack Switching
.ix Fast Interrupt Routine
.ix Interrupt Context Block
.ix User Stack
.ix RTI
Stack switching need not be done by an interrupt routine that pushes less
than one context block plus eight bytes onto the stack, and is not
interruptable; this situation occurs in fast interrupt handlers (such as
serial output by the terminal drivers, or routines using FIRQ).  Normally
stack switching is always included with an interrupt routine.  A fast
interrupt routine must not push more than 8 bytes and an interrupt context
block on a user stack.  Typically, a fast interrupt routine exits via RTI,
but it can switch stacks if it discovers more processing is neded and then
exit via SDOS:RTI or SDOS:RESCHEDULE. A fast interrupt may NOT allow a
nested interrupt.
.PA
The code to effect a stack switch is as follows:
.sp
* INTERRUPT VECTORED TO HERE
.sp
.im 7
              INC       SDOS+SDOS:STACKSWITCHED
              BNE       INTERRUPT:POLL
              LDX       SDOS+SDOS:CURRENTASK
              STS       TCB:STACK,X
              LDS       INTERRUPTSTACKTOP
INTERRUPTPOLL EQU       *   DECIDE WHICH DEVICE
                        CAUSED THE INTERRUPT
.SP
.ix Standard 6800/6809 Interrupt System
.ix IRQ Vector
.ix IOINT
.ix IOINTPOLL
.ix Fast Interrupt
.ix Poll Chain
As a convenience to 6800/6809 systems which use the standard interrupt
system the IRQ vector can be aimed at SDOS+SDOS:IOINT, which contains this
stack switching code. SDOS:IOINT jumps to the location specified by
CNFG:IOINTPOLL after switching stacks, where code must exist to determine
which device caused the interrupt. I/O packages having fast interrupt
services can aim the IRQ vector at a poll chain to determine which fast
device wants an interrupt; if no fast device needs an interrupt, then
control can be transferred to SDOS+SDOS:IOINT. SDOS:IOINT is provided only
as a convenience, and need not be used.
.ix Slow Interrupt Exit
.sp
A possible method for exiting a slow interrupt routine is as follows:
.sp
.im 8
       NOP             (IN CASE INTERRUPTS WERE ENABLED...
       SEI             TO ALLOW NESTED INTERRUPTS)
       DEC     SDOS+SDOS:STACKSWITCHED
       BPL     DORTI
       LDX     SDOS+SDOS:CURRENTASK
       LDS     TCB:STACK,X
DORTI  EQU     *
       RTI
.sp
.ix SDOS:RTI
This is essentially the code supplied by the SDOS entry point, SDOS:RTI,
except that scheduling is forced if any nested interrupt routine signaled an
interesting event.  Use of SDOS:RTI is recommended.
.sp
The interrupt stack must have enough space to handle the total sum of all
pushes by all the possible nested interrupt routines, plus room for a
context block for each interruptable interrupt routine, plus space for an
NMI context block (for debugging) and some space for the scheduler to use. 
This total space requirement is needed for the rare case that all the
interrupt routines interrupt each other at the worst possible time (in terms
of stack usage), and an NMI occurs in the most deeply nested routine.
.sp
.ix Interrupt Context Block
.ix FIRQ
.ix NMI Context Block
The total space a user program must dedicate to interrupts is one interrupt
context block, one FIRQ block, 8 bytes and an NMI context block.
.sp
.ix Interrupt Routine
.ix Cause of Interrupt
.ix Vectoring Hardware
Once stacks have been switched, the interrupt routine will probably need to
poll the various hardware I/O registers to determine the cause of the
interrupt.  Some systems have special vectoring hardware that vectors to a
unique location for each device; this system saves the time required to poll
(Note: a copy of the stack switch code must be present at each of the vector
points, if needed, in this case!).  With the cause of the interrupt
determined, the interrupt routine for the appropriate device can be
executed.
.sp
It is appropriate to note here that device interrupt routines should contain
test not only for device-requires-service, but also for
device-enabled-for-interrupts, and device-does-not-exist.  Most Motorola
family parts will signal presence of device-requires-service, but the signal
does not necessarily mean that the device has been armed to cause an
interrupt.  It is also the case that when a device in not present on the bus,
the device address will still respond with something which can be
mis-interpreted as device-requires-service.  Usually, checking for device
enabled for interrupts is sufficient to prevent this interpretation from
confusing the drivers; however, it is good practice for a device reset routine
to check for the actual presence of a device (by performing some
device-specific check of the device registers) and set a flag which
permanently disables interrupt testing of the device if the device is not
present.
.SP
.ix Interrupt Routine
.ix Nested Interrupt
.ix Interrupt Communication
The interrupt routine for a device is responsible for effecting the actual
device data transfer and is totally device dependent.  There are only two
properties of a device interrupt routine that SDOS affects: how the routine
handles nested interrupts; and communication by the interrupt routine to any
task(s).
.sp
.ix Nested Interrupt
.ix Re-enabling Interrupts
.ix Disable Interrupts
A device interrupt routine may allow nested interrupts by re-enabling the
interrupt system (usually, via a CLI instruction) (SDOS:STACKSWITCHED will
keep track of interrupt nesting of it occurs).  Re-enabling interrupts can
only be allowed if no further interrupts from the device will occur while
the interrupt routine for that device is still active (or much confusion may
result!).  An interruptable interrupt routine must disable interrupts before
un-switching stack pointers.  For short interrupt routines, re-enabling
interrupts usually does not improve system performance.
.sp
.ix Interrupt Routines
.ix Single-State Interrupt
.ix Multi-State Interrupt
.ix I/O Operation
.ix Floppy Disk Controller
There are generally two kinds of interrupt routines: single-state and
multi-state.  Single-state interrupt routines are generally used for serial
terminals, line printers, and other devices in which only a single step is
required for each I/O operation.  Multi-state interrupt routines are used
whenever several steps are required for each operation (i.e., on a floppy
disk controller, a step may be required to move the heads, another step to
wait for the desired sector to come under the heads, and a final step to
actually read or write a data sector).  Multi-state interrupt routines are
coded much like a task level routine; each step is performed, and then the
interrupt routine waits (for a completion interrupt) before proceeding on
the next step.
.sp
.ix Single-State Interrupt
Single-state interrupt routines require no special tricks and so are not
further discussed here.
.sp
.ix Multi-State Interrupt
.ix Interrupt Routine
.ix Wait
A Multi-state interrupt routine is one in which only a part of the entire
interrupt routine is executed on the first interrupt; another part executed
on the second, etc.  At the end of execution of each part, an operation is
issued to the device, and (logically), a wait for completion of that
operation is performed (no "wait" is actually performed; what really happens
is that the interrupted program is allowed to continue). Completion is
signalled by another interrupt, which causes the next part of the interrupt
routine to be executed.  Usually, each part of the interrupt routine knows
which part of the interrupt routine is to be executed next.
.sp
.ix Multi-State Interrupt
.ix Dynamic Pointer
Multi-state interrupt routines are conveniently implemented via a dynamic
pointer which is set at the end of execution of each part, to point to the
next part.
.sp
An example is included here:
.cp 22
.im 22
INTERRUPT   EQU   *
*           SWITCH STACKS
*           TEST DEVICE
            B-- JUMPNEXTPART    IF THIS DEVICE CAUSED INTERRUPT
            ...

JMPNEXTPART EQU   *
            FCB   $7E,0,0

INTPART1    EQU   *
            ...   START NEXT DEVICE OPERATION
            JSR   WAITFORINT
INTPART2    EQU   *
            ...   START NEXT DEVICE OPERATION
            JSR   WAITFORINT
INTPART3    EQU   *
            ...

WAITFORINT  EQU   *
            PULD
            STD   JMPNEXTPART+1
*           RETURN TO INTERRUPTED PROGRAM
.sp
.ix Tasks
.ix STARTIO
Tasks signal the presence of data to be processed by an interrupt routine by
a combination of flags and a STARTIO interrupt.  Tasks never do actual
stores or loads to device registers; these operations are left for the
interrupt routine.
.sp
.ix I/O Operation
.ix I/O Block
.ix Interrupt Routine
.ix Task
A task setting up an I/O operation builds an I/O block (of data) (usually in
the device DCB) to be inspected by the interrupt routine.  A single byte
flag (or counter) associated with the I/O block prevents the interrupt
routine from performing this inspection until the construction is complete. 
The task building the I/O block is responsible for setting the flag
(incrementing the counter) (never resetting it); the interrupt routine
clears the flag (decrementing the counter) (never sets it) when processing
of that I/O block by the interrupt routine is complete.
.sp
.ix Interrupt Routine
.ix INTERRUPTEXPECTED
The interrupt routine cannot inspect the I/O block(s) unless it is awakened
by an interrupt.  To prevent the possibility of no further interrupt
expected, and a task waiting for an I/O block to be inspected, an
INTERRUPTEXPECTED flag is associated with each interrupt routine.  The
interrupt routine sets or clears this flag depending on whether it expects
another interrupt or not.  Whenever the interrupt routine finishes
processing one I/O block, it checks other I/O blocks associated with it to
determine if any of those blocks are ready to be processed; if so, then
processing continues and the INTERRUPTEXPECTED flag is set (or left set);
otherwise, the INTERRUPTEXPECTED flag is reset.
.sp
.ix I/O Block Ready
.ix INTERRUPTEXPECTED
After a task sets the "I/O block ready" flag, it inspects the
INTERRUPTEXPECTED flag.  If the flag is set, the interrupt routine will
eventually discover the I/O block and process it; the task need do nothing
further to cause the I/O to occur.  If the flag is reset, then there is a
possibility that the interrupt routine has not seen the newly-readied I/O
block; the task then causes an interrupt via the SDOS:STARTIO routine.  This
interrupt causes the interrupt routine to look for ready I/O blocks.
.sp
.ix I/O Operation
.ix I/O Block
The task can determine when the I/O operation on the I/O block is complete
by waiting for a flag associated with the I/O block to get set by the
interrupt routine.
.sp
In many cases, a counter associated with a circular buffer is a convenient
substitute for a set of I/O blocks with corresponding flags.
.sp
.ix Task
.ix DONE
.ix STARTIO
.ix Interrupt Routine
An interrupt routine signals completion of an I/O operation to task by
merely setting a flag or incrementing a counter. Tasks waiting for I/O
complete do so by waiting for a particular memory location to be non-zero. 
A typical interrupt routine will have a DONE flag and a status word;
completion of the I/O operation causes the DONE flag to get set and the
status word to be updated to reflect the completion status.  When a task
waiting for the done flag wakes up, it can inspect the status.  The part of
the interrupt routine that receives an interrupt from a STARTIO operation
must clear the DONE flag.
.sp
.ix Exit
.ix SDOS:RTI
.ix Priority Processing
.ix Task
.ix SDOS:RESCHEDULE
An interrupt routine must exit to SDOS:RTI if no interesting activity
occurred (i.e., it did not signal completion to a task) or if the signal was
of low enough priority so that a relatively long wait before a waiting task
discovers the signal will not hurt.  If an interesting event occurred that
needs priority processing by a task, the interrupt routine must exit to
SDOS:RESCHEDULE, which will cause task rescheduling.  Both SDOS:RTI and
SDOS:RESCHEDULE unswitch the stacks properly so that this need not be done
by the interrupt routine.
.sp
.ix Timeouts
.ix Long-Term Timing
.ix Abort I/O Operations
.ix Retry
.ix TIMED OUT
Timeouts (TIMEOUT:) are used to perform long-term timing and/or aborting of
I/O operations initiated by an interrupt routine. Essentially, a timeout
causes a guaranteed interrupt, even if the device itself, for some reason,
does not.  An interrupt routine, on receipt of a timeout interrupt, can
retry the operation or mark the I/O block for which the I/O was initiated
as "TIMED OUT", and signal completion of I/O on that block.  At this point,
the interrupt routine is now ready to start the next I/O operation.  SDOS
provides a standard mechanism for implementing timeouts.  Such timeouts have
extremely low overhead, at the price of a somewhat large error on the high
side in the length of the timeout.
.sp
SDOS also provides high resolution (near millisecond accuracy) timers (TOB:)
for I/O drivers requiring accurate delays.  Such timers cost extra
overhead and so a tradeoff occurs.
.pa
SDOS TASK MANAGEMENT PHILOSOPHY
.sp
Scratchpad, use of; page zero, use of:  Note that scratchpad not necessarily
<> 0-7.
.pa
NORMAL 6800/6809 INTERRUPT HARDWARE
.ix Interrupt Hardware
.ix Interrupt Handling
.ix I/O Interrupt
.ix IOINT
.ix IOINTPOLL
.ix SDOS:RTI
.ix SDOS:RESCHEDULE
.IX CLI
.IX CURRENTTASK
.IX TCB
.IX I/O Interrupt Service
.sp
Interrupt handling, conceptual.
.sp
.im 21
                  SDOS:CURRENTTASK
                        !
                        ! TCB
                        V
                    ____________
                    !          !
              ...---->       .--->Next TCB
                    !          !
                    !__________!
                    !Stack for !
                    !   TASK   !
                    !(pointer) !
                    !__________!
                    !          !
                    !__________!
                    !          !
                    ! Location !
                    !  0 - 7   !
                    !__________!





.pa
.pw 120
.ll 100
.sp
.cp 51
.im 51
                                                 _____________
                                   I/O Interrupt !           !
                                     --------------  USER    !
                                     !           !___________!
                              ______________           ^
                              !            !           ! Unswitch Stacks,
            ------------------!    Fast    !           ! Pass
            !                 !     Int    !           ! Control
            V            -----!    Poll    !           !
      _____________      !    !____________!           !
      !    Fast   !      !       not !        _____________________
      ! Interrupt !      V      fast ! IOINT  !____               !
      !  Service  !              int !------->!///!Switches       !
      !___________!                           !///!Stacks if      !
            !                        ---------!///!Necessary      !
           / \                       !        !---!               !
          /   \                      V        !                   !
         /more \  No          ______________  !   S D O S         !
        /  work \____>RTI     !            !  !                   !
        \ needed/             !    Slow    !  !                   !
         \     /              !  Interrupt !  !                   !
          \   /               !    Poll    !  !  SDOS:  SDOS:     !
           \ / Yes            !____________!  !  RTI    RESCHEDULE!
     _______!_____             !  !   !       !___________________!
     !  Switch   !     <-------!  !   !            ^     ^
     !  Stacks   !                !   !            !     !
     !    if     !       <--------!   !            !     !
     !  Needed   !                    !            !     !
     !___________!                    !            !     !
            !                         V            !     !
     _____________             ____________        !     !
     ! Optional  !             ! Optional  !       !     !
     !   CLI     !             !   CLI     !       !     !
     !___________!             !___________!       !     !
     ! Interrupt !             ! Interrupt !       !     !
     ! Service   !             ! Service   !       !     !
     ! Routine   !             ! Routine   !       !     !
     !___________!             !___________!       !     !
            !                         !            !     !
           / \                       / \           !     !
          /   \                     /   \          !     !
         /     \ No                /     \ No      !     !
         \Event/----->SDOS:RTI     \Event/---------!     !
          \   /                     \   /                !
           \ /                       \ /                 !
            !                         !                  !
            !                         !                  !
            ! Yes                     ! Yes              !
            !                         !                  !
            !_________________________!__________________!

.ll 65
.pw 85
.pa
Vectored Interrupt Hardware
.ix Vectored Interrupt Hardware
.ix I/O INT Routine
.IX SDOS:RESCHEDULE
.IX SDOS:RTI

.sp
.cp 41
.im 41
                                           __________
                                           !        !
___________________________________________!  USER  !
!   !      !       !               !       !________!
!   !      !       !               !            ^
V   V      V       !               !            !
                   V               !            !
               _______             !       ___________
               !/////!do stack     !       !          !
               !/////!switch       !       !____      !
               !-----!if           !------>!///!Stack !
                   ! needed                !///!Switch!
                   !                    !--!///!If    !
                   V                    !  !---!Needed!
            ____________                V  !          !
            ! Intpoll  !                   ! S D O S  !
            ! for this !                   !          !
            ! level    !                   !          !
            ! interrupt!                   !          !
            !__________!                   !          !
                   !                       !__________!  ^ Back to
                   V                       ! Undo     !  ! user
        __________________                 ! Stack    !--! task
        ! I/O INT routine!                 ! Switch   !
        !________________!                 !__________!
                   !                          ^    ^
                   !                          !    !
                   V                          !    !
                  / \                         !    !
                 /   \                        !    !
                /     \                       !    !
               /       \  Interesting         !    !
              /  Event  \_____________________!    !
              \    ?    / SDOS:RESCHEDULE          !
               \       /                           !
                \     /                            !
                 \   /                             !
                  \ /                              !
                   !     Boring                    !
                   !_______________________________!
                         SDOS:RTI

.pa
.SH SECTION III: ENTRY POINTS
.tc
SDOS ENTRY POINTS
.ix Entry Points
.ix I/O Package
.sp
The SDOS entry point table contains entry points to SDOS routines and the
values of certain variables needed by the I/O package.
.sp
.ix Permanent Resident
The table physically starts at the lowest address of the permanently
resident part of SDOS.  All entries in this table are named SDOS:XXX in the
definitions file, and are meant to be accessed directly via LDAA/JMP/LDX
SDOS+SDOS:XXX instructions, where SDOS is a symbol whose value is the base
of the permanently resident portion.
.sp
The entry points are described here.
.sp
.in 10
.un 10
SDOS:VERSIONNUMBER
.ix SDOS:VERSIONNUMBER
.br
This byte contains the hex equivalent of the version number of SDOS, with
the leftmost 4 bits being the major version number, and the right 4 bits
being the revision number.  An I/O package coded for a particular revision
of SDOS should check this byte, as the I/O package interface is very likely
to change from revision to revision.
.sp
.IX SDOS:LASTERROR
.un 10
SDOS:LASTERROR
.IX Boot Failure
.ix Crash
.ix Error Routine
.ix Error
.br
SDOS:LASTERROR is the last 16 bit error number of the error that SDOS
handled or reported.  This is most useful as an aid to the systems
programmer in determining why SDOS will not boot or why it crashed; after a
failure, the programmer may see the cause by looking here if the error
routine in SDOS did not print out the reason for failure. Locations $FC,$FD
point to a jump; the jump "points" to the SYSCALL entry point into SDOS; the
2 bytes preceeding the entry point contain a pointer to the base of the
SDOS: entry points. This information allows a programmer to find
SDOS:LASTERROR after a system crash.
.sp
.un 10
SDOS:CONFIGURATION
.ix SDOS:CONFIGURATION
.ix CNFIG
.ix I/O Package
.ix Entry Point
.br
SDOS:CONFIGURATION is a 16 bit pointer to the I/O package configuration
table (CNFIG:).  This is really the only entry point to the I/O package, and
is set by the I/O package via an assembly like the following:
.sp
.im 4
               ORG     SDOS+SDOS:CONFIGURATION
               FDB     CONFIGURATION
               ORG     -------
          (see configuration table)
.pa
.un 10
SDOS:SERIALNUMBER
.ix SDOS:SERIALNUMBER
.br
This is a 16 bit serial number assigned to this particular copy of SDOS.
This field is currently not used.
.sp
.un 10
SDOS:IOBLOCKPTR
.ix SDOS:IOBLOCKPTR
.IX SYSCALL block
.ix Device Drivers
.br
A Pointer to the SYSCALL block associated with the SYSCALL currently being
processed; set by SDOS for use by device drivers to get parameters from
SYSCALL blocks.
.sp
.un 10
SDOS:CLOCK
.ix SDOS:CLOCK
.ix Midnight
.br
A 24 bit unsigned integer counting 60HZ clock ticks.  This clock is zeroed
at midnight.
.sp
.un 10
SDOS:DAY
.ix SDOS:DAY
.ix Midnight
.br
Day number in BCD ($01 = 1st day of the month). Automatically updated at
midnight.  This byte must be set to zero at assembly time so that SDOS can
detect that the time is not set.
.sp
.un 10
SDOS:MONTH
.ix SDOS:MONTH
.ix February 29
.ix Leap Years
.br
Month number in BCD ($01 = JAN, $02 = FEB, etc.) Updated at end of month. 
February 29 is handled correctly on leap years.
.sp
.un 10
SDOS:YEAR
.ix SDOS:YEAR
.ix January 1
.br
Year number modulo 100 in BCD ($78 = 1978).  Bumped on transition of date to
January 1.
.sp
.un 10
SDOS:STACKSWITCHED
.ix SDOS:STACKSWITCHED
.ix Interrupt Routines
.ix TCB
.ix Task Control Block
.ix INTERRUPTSTACK
.ix TASK
.br
Eight bit counter used by interrupt routines to determine if a stack switch
to the interrupt stack has occurred.  -1 means "stacks not switched";
switching stacks or taking an interrupt bumps this counter.  If bumping the
counter causes it to go to zero, then the current value of the stack
register is saved in a TCB (task control block), and a new stack pointer
value is loaded (equal to the highest usable byte of the INTERRUPTSTACK). 
All interrupt routines run using the interrupt stack, not a TASK's stack.
.sp
.im 7
          *       INTERRUPT GOES HERE
                  INC     SDOS+SDOS:STACKSWITCHED
                  BNE     L1
                  LDX     CURRENTASK
                  STS     TCB:STACK,X
                  LDS     #INTERRUPTSTACK
          L1      EQU     *
.ix Nested Interrupts
.sp
Nested interrupts do not switch stacks again.  On exit from an interrupt
routine, SDOS:STACKSWITCHED must be decremented; if it goes negative, a
switch back to the task's stack is required (see section on INTERRUPTS).
.pa
.un 10
SDOS:IOINT
.ix SDOS:IOINT
.ix I/O Interrupt Vector
.IX SDOS:STACKSWITCHED
.IX CNFG:IOINTPOLL
.IX I/O Package Routine
.ix Device Interrupt
.ix INTERRUPTSTACK
.br
I/O Interrupt entry point.  6800's with only a single I/O interrupt vector
should aim it at SDOS:IOINT.  SDOS:IOINT adjusts SDOS:STACKSWITCHED, effects
stack switching if required, and then transfers control with interrupts
disabled to CNFG:IOINTPOLL, which is an I/O package routine to determine
what device caused the interrupt, and to go handle the interrupt.  Once in
the interrupt routine, the routine may re-enable interrupts for a nestable
priority-interrupt driven system. INTERRUPTSTACK must be deep enough to
handle all the pushdown storage required by the nested interrupt routines +
9 bytes for the task scheduler.
.sp
.un 10
SDOS:RTI
.ix SDOS:RTI
.IX Exit
.ix Interrupt Routine
.ix Interrupt Disable
.ix SDOS:STACKSWITCHED
.ix Nested Interrupt
.ix Task Scheduler
.br
SDOS:RTI is the exit for an interrupt routine that has discovered nothing of
interest happening (from the point of view of a task waiting for that
interrupt routine).  SDOS:RTI disables interrupts, adjusts
SDOS:STACKSWITCHED by decrementing, and returns control to the previously
nested interrupt routine or user task if no higher priority interrupt
routine has signalled an interesting event.  If there are no more nested
interrupts, and some interrupt routine has signalled "interesting event
occurred", then the task scheduler is invoked and task switching may occur.
.sp
.un 10
SDOS:RESCHEDULE
.ix SDOS:RESCHEDULE
.ix Interrupt Routine Exit
.ix Task
.br
SDOS:RESCHEDULE is the exit for an interrupt routine that has discovered an
event that may be of interest to a task.  The particular event and any
associated data must be set up independently of this call (see WAIT
routines); this merely sets a flag and passes control to SDOS:RTI. 
Eventually (when all of a nested burst of interrupts have been processed),
the scheduler will gain control and reschedule the tasks, including waking
up one that might have been waiting for the event of interest.
.pa
.un 10
SDOS:CLOCKTICKED
.ix SDOS:CLOCKTICKED
.ix Timer
.ix Interrupts Enabled
.ix Interrupts Disabled
.ix Pseudo-Clock
.ix CNFG:TASKQUEUE
.ix SDOS:RESCHEDULE
.ix Exits
.ix Timed Out
.br
This routine gets control via a JMP from the timer interrupt routine, with
the number of 1/60th second clock ticks since the previous call passed in
the A register. Stacks must be switched. SDOS:CLOCKTICKED updates the system
clock and date as needed and causes the timeout task to run. 
SDOS:CLOCKTICKED can be run with interrupts enabled or disabled, as long as
no interrupt routine reads the clock if SDOS:CLOCKTICKED runs interrupt
enabled.  If no clock device or regular source of interrupts is available, a
psuedo-clock can be constructed by placing a dummy task on CNFG:TASKQUEUE
whose only business in life is to be stuck in a permanent wait state, so
that its wait routine can increment a counter to be used as a clock. 
SDOS:CLOCKTICKED exits to SDOS:RESCHEDULE when it is done.  Calling this
routine causes timeout blocks to get checked for "timed out".
.sp
.un 10
SDOS:CURRENTASK
.ix SDOS:CURRENTASK
.IX TCB
.IX INTERRUPT
.IX Task
.br
SDOS:CURRENTASK is a pointer to the TCB of the task most recently run (or
considered by the scheduler). This is used only by stack-switching routines
as described under INTERRUPT systems.
.sp
.un 10
SDOS:KILLPROOF
.ix SDOS:KILLPROOF
.IX SDOS:KILLENABLE
.IX ^C
.IX SDOS:KILLUSERPROGRAM
.IX CONSOLE:
.IX ^D
.br
This is a one byte flag, which, if not zero, indicates that the application
program is not to be "killed".  The flag is set and cleared by
SYSCALL:KILLPROOF and SYSCALL:KILLENABLE syscalls respectively.  This flag
is checked by SDOS:KILLUSERPROGRAM (not by the ^C recognition in the
CONSOLE: driver) and by ^D (debug call) recognition.  A ^D is to be ignored
if this flag is set.
.pa
.un 10
SDOS:KILLUSERPROGRAM
.ix SDOS:KILLUSERPROGRAM
.IX I/O Package
.ix CONSOLE: Driver
.ix ^C^C
.ix SDOS:KILLPROOF
.IX ERRORTS
.ix Logging
.ix DO file
.ix Aborted DO File
.ix Time Bomb
.ix OKRTS
.ix Task
.ix I/O Driver
.ix Time-Out
.ix Forced Wake-Up
.ix Input Wait Mode
.br
This routine is called by an I/O package routine that recognizes an operator
request to kill the user program currently running.  Normally, this is
recognized by the CONSOLE: driver when the operator types two ^C ^C
characters in succession. KILLUSERPROGRAM decides if the user program is
killable by examining SDOS:KILLPROOF; if not, a return with carry set
(error!) (ERRORRTS) is executed.  Otherwise, the user program (logging, and
the currently active DO file) is aborted (instantly, or via a time bomb,
depending on what the user is doing at the moment) and control returns via
OKRTS (with carry reset).  If the user task is currently executing (or
waiting) in a device driver, then SDOS delays the "kill" action until the
task has left the I/O driver and returned to execution in SDOS.  Since
execution of a driver operation will either complete or time-out in a fixed
period of time, this delaying action is safe. The user program eventually
gets killed.  The CONSOLE: driver has a special problem; there is no
time-out on an input wait!  This is solved by having the CONSOLE: driver
perform a forced wake-up of the task when KILLUSERPROGRAM says "OKRTS" and
the CONSOLE: driver detects that the task is in input wait mode (which it
can do by making the task set an "I'm about to wait for input" flag).
.sp
.un 10
SDOS:STARTIO
.ix SDOS:STARTIO
.IX Task
.ix Interrupt
.ix Interrupt Disables
.br
This subroutine is used only by task level parts of the I/O drivers to cause
a simulated interrupt to the address specified by the X register.  SDOS
disables interrupts, pushes a context block containing the return address,
switches stacks to the interrupt stack, and goes to the address specified by
X. The interrupt routine is entered with (D) matching value in (D) when
STARTIO is issued. This routine is used to start the operation of the
interrupt portion of the driver, if the interrupt portion is not expecting
another interrupt. The contents of the scratchpad are preserved through this
call.
.pa
.un 10
SDOS:WAITCOND
.ix SDOS:WAITCOND
.ix Task
.ix Wait
.ix Scheduler
.ix Test Subroutine
.ix Interrupts Disabled
.ix Slowing Down
.ix INTERRUPTSTACK
.IX SDOS:WAITEVENT
.br
This subroutine causes a task to wait for a condition specified by a test
subroutine whose address is in (A,B,), with a parameter in X.  The task is
put to sleep until the condition occurs; other tasks of lower priority then
have an opportunity to execute.  When the condition has occurred, the task
continues execution at the return address.  The test subroutine is called
periodically by the scheduler; on entry to the test subroutine, X is equal
to the original parameter (usually the address of something).  The
subroutine must return a code in the A register.  Zero means "not ready";
not-zero means task is ready.  The test subroutine ceases to be called when
it signals the task has gone ready.  When the task wakes, it will find the
ready code returned by the test subroutine in its A register.  The test
subroutine must not disable interrupts (for long), nor may its execution
take considerable time without slowing down the real-time response of SDOS
significantly. Furthermore, the test subroutine is called using the
INTERRUPTSTACK, not the task's stack.  The generality of WAITCOND is hardly
ever needed. Normally, SDOS:WAITEVENT is sufficient.  On return from
WAITCOND, interrupts have been enabled.  The conditional test subroutine
must not push any bytes on the stack as the interrupt stack may not have
space reserved for this. The scratchpad conten and (X) are preserved
through this call.
.sp
.un 10
SDOS:WAITEVENT
.ix SDOS:WAITEVENT
.IX Wait
.ix Task Wait
.ix WAITCOND
.ix Task Synchronizing
.ix Interrupt Out Buffer
.br
This subroutine causes a task to wait for the byte pointed to by the X
register to become non-zero. It works as a special case of SDOS:WAITCOND;
essentially, the test subroutine is:
.sp
.im 2
                LDAA    0,X
                RTS
.sp
where X contains a pointer to the desired byte. The task continues execution
at the return address with the A register set to the value of byte at the
time that the scheduler, via the test subroutine, discovered the byte to be
non-zero.  This is particularly useful in synchronizing a task to an
interrupt output buffer free counter (if the counter is zero, the task
automatically waits) or an interrupt input buffer counter.  As an example:
.sp
.cp 17
.im 17
        *       TASK LEVEL ROUTINE: (A)
                CONTAINS CHARACTER TO OUTPUT
        LDX     #OUTPUTFREECNT
        LDAB    0,X         WAIT EVENT IS SLOW,
                            SO THIS OPTIMIZES THE
                            CASE OF "SPACE AVAILABLE"
        BNE     L1
        PSHA
        JSR     SDOS+SDOS:WAITEVENT     X CONTAINS POINTER TO COUNTER
        PULA

 L1     LDX     OUTBUFPTR   PUT CHARACTER INTO BUFFER
        STAA    0,X
        DEC     OUTPUTFREECNT   LET INTERRUPT ROUTINE KNOW (NOW
                                OUTPUTFREECNT <> SIZE OF BUFFER)
        INX                 BUMP BUFFER ADDRESS
        STX     OUTBUFPTR
.sp
On return from SDOS:WAITEVENT, interrupts have been re-enabled. The
scratchpad is preserved through this call.
.sp
.un 10
SDOS:ERROR
.ix SDOS:ERROR
.ix Task
.ix Error
.ix Error Code
.ix Abort Error
.ix SDOSIOPKDEFS.ASM
.ix Error Numbers
.ix Interrupt Routines
.br
SDOS:ERROR is the standard routine used by the user task to signal an error.
A two byte error code is placed in the line following the JSR to SDOS:ERROR.
A JSR is required even though control is not returned.  The error code is
loaded into the X register; the carry is set; and the subroutine which
signalled the error is aborted and control is passed to the return address
specified by its caller.  If the caller does not have a BCC or BCS
instruction at its return address, then the caller is likewise aborted and
control is passed to its caller.  This process continues until a BCC or BCS
is found at a return address (see ERROR HANDLING). Suitable error codes are
defined in the SDOSIOPKDEFS.ASM file; these error numbers may be augmented
as needed.  This routine may not be used by interrupt routines or by any
non-user task.
.sp
Example Use:
.sp
.im 4
               TST     TTYEOFFLAG
               BEQ     ...     B/ NOT EOF
               JSR     SDOS+SDOS:ERROR
               FDB     ERR:EOFHIT
.pa
.un 10
SDOS::ERRORSAVE
.ix SDOS:ERRORSAVE
.ix TasK
.ix Error Recovery
.ix SDOS:ERRORED
.ix Recovery Routine
.br
SDOS:ERRORSAVE is a user task subroutine which is used to store the X
register (presumably containing an error number) for later use by
SDOS:ERRORED. This is done if an error recovery routine will pass the error
on after cleaning up.  It does not hurt to do an SDOS:ERRORSAVE even if
SDOS:ERRORED is not later used.  Note that if the error recovery routine
invokes subroutines which can error, the saved error code will be distroyed!
If this possibility can occur, the recovery routine will have to save the
error code somewhere else, and issue a SDOS:ERRORSAVE later before it does
an SDOS:ERRORED.
.sp
.un 10
SDOS:ERRORED
.ix SDOS:ERRORED
.ix Task
.ix Error Recovery Routine
.ix SDOS:ERRORSAVE
.br
This is used by the user task to signal that an error recovery routine is
finished, and wishes to pass the error back to the caller.  SDOS:ERRORSAVE
must be called before SDOS:ERRORED is used.  This entry point requires no
parameters.  An example of use is:
.sp
.im 9
                         JSR     WIDGET
                         BCS     OOPS    B/ ERROR
                         ...

          OOPS           JSR     SDOS+SDOS:ERRORSAVE
                         CPX     #ERR:...
                         BNE     OOPSOOPS
                         <do recovery>
          OOPSOOPS       JMP     SDOS+SDOS:ERRORED
.sp
.un 10
SDOS:CHECKRDLEN
.ix SDOS:CHECKRDLEN
.ix Task
.ix Reply Buffer Length
.ix SYSCALL Block
.ix I/O Drivers
.ix IOBLOCKPTR
.ix SCBLK:RPLEN
.br
SDOS:CHECKRDLEN is a user task subroutine used to check that the reply
buffer length of a SYSCALL block is at least as large as the two byte value
coded inline following the call.  This call is used as a convenience to I/O
drivers.  The SYSCALL block checked is that specified by SDOS:IOBLOCKPTR. 
An error (see SDOS:ERROR) is caused if the SYSCALL block is too short to
have a reply buffer, or if the reply buffer length is not at least as large
as the inline value specified.  If an error occurs, control does not return;
if no error occurs, SCBLK:RPLEN in the SYSCALL block is set to the specified
inline value and control returns to the point following the inline value. 
The X register is left pointing to the SYSCALL block to make further
processing convenient.
.sp
Example:
.sp
.im 4
               JSR     SDOS+SDOS:CHECKRDLEN
               FDB     5       MUST HAVE >= 5 BYTES OR WE
                               ERROR
               *       RETURN HERE IF OK
.pa
.un 10
SDOS:CHECKWRLEN
.ix SDOS:CHECKWRLEN
.ix Task
.ix Write Buffer Length
.ix SYSCALL Block
.ix SDOS:IOBLOCKPTR
.ix Error
.ix SDOS:WRLEN
.br
SDOS:CHECKWRLEN is a user task subroutine to check that the write buffer
length of a SYSCALL block is at least as long as the two byte value coded
inline following the call.  This call is used as a convenience to the I/O
drivers.  The SYSCALL block checked is that specified by SDOS:IOBLOCKPTR. 
An error is caused if the SYSCALL block is too short to contain write buffer
pointer and length, or if SCBLK:WRLEN specifies a value smaller than that
given by the inline value.  Otherwise, control returns to the point
following the inline value. The X register is left pointing to the SYSCALL
block to make further processing convenient.
.sp
Example:
.sp
.im 6
               JSR     SDOS+SDOS:CHECKWRLEN
               FDB     2       MUST HAVE >= 2 BYTES OR WE ERROR
               *       RETURN HERE IF OK
               LDX     SCBLK:WRBUF,X
               LDAA    0,X     GET DATA BYTES
               LDAB    1,X     FROM WRITE BUFFER
.IM 0
.SP
.IN 10
.UN 10
SDOS:ILLEGALDEVICEOPERATION
.BR
Is passed control to signal ERR:ILLDEVICEOP.  It is normally used by
control/status entry points of various device drivers to signal that an
unknown SC:XX (to the driver) or CC:XX syscall has been issued.
.PA
.in 10
.un 10
SDOS:TIMEOUTCOUNT
.br
This one-byte variable keeps track of the number of timeout blocks
currently in the timeout block chain.  The number of timeout blocks
installed in the I/O package initially are counted by SDOS
at boot time; each call to SDOS:TIMEOUTINSERT adds one to the count,
and each call to SDOS:TIMEOUTDELETE (that actually removes a block
from the timeout list) decrements it.  To set a delay of N clock
ticks into a timeout block, the value N+SDOS:TIMEOUTCOUNT should be
stored into TIMEOUT:FUSE.
.sp
.un 10
SDOS:TIMEOUTINSERT
.br
This routine inserts a timeout block in the timeout block chain.  It is
called from interrupt level with interrupts disabled with (X) pointing to
the timeout block to be inserted in the chain; the timeout block must not
already be in the chain.  Exits with interrupts disabled.  Zeros the fuse of
the timeout block.  Increments SDOS:TIMEOUTCOUNT.  Increments all non-zero
fuse values of blocks already in the timeout list.
.sp
.un 10
SDOS:TIMEOUTDELETE
.br
This routine removes the timeout block pointed to by (X) from the
timeout block chain.  It is called from interrupt level with
interrupts disabled, and exits with interrupts disabled.  No action
is taken if the timeout block specified is not in the list.
Decrements SDOS:TIMEOUTCOUNT if the timeout block was in the list,
and decrements all non-zero fuse values of other blocks in the
timeout list.
.sp
.un 10
SDOS:SCHEDULESOONFLAG
.br
This flag is zero if the task scheduler should be run soon (usually
after the next clock tick).  It is set non-zero each time the task
scheduler is run, and is zeroed by any very fast (interrupt) routine
which wishes to signal a significant event to a task, but cannot
afford to force the scheduler to run on each event (this is typical
of Virtual Terminal character output routines, which can generate up
to 2000 signals to the scheduler per second).  This is accomplished
by running the scheduler periodically if scheduling soon is
required.
.sp
.un 10
SDOS:SURPRISE
.br
This flag is zero if the scheduler should be run immediately, i.e.,
before control is returned to the currently interrupted task.  It is
set to zero by any interrupt routine wishing to signal a task that
some interesting event has occurred and should be serviced
immediately.  Setting this flag is an alternative to passing control
to SDOS:RESCHEDULE, which does not return.
.IN 0
.pa
.IN 10
.un 10
SDOS:MSTICK
.BR
This subroutine is called by the millisecond clock interrupt routines with the
clock interrupt hardware disabled (SDOS:MSTICK may run a long time and
re-enables interrupts) and the elapsed time in milliseconds since the
last call to IO:RET in (B).  [IO:RET is an I/O package routine, which returns
elapsed time in milliseconds in (B) since the last time IO:RET was called.]
SDOS:MSTICK adjusts all the active TOB: blocks, simulates interrupts to any
TOBs that expire, and finally calls CNFG:SETCLOCKINTERVALMILLISECONDS,
before returning to the clock interrupt routine.
.sp
.un 10
SDOS:ITOB
.BR
This subroutine can be called from task level or reset routines.  (X) points
to a TOB, which is initialized to an idle state.  (D) contains a value
used to set TOB:PARAMETER and TOB:ROUTINE; the caller should initialize
whichever field is set incorrectly.  This initialization is required
before calling SDOS:RTOB or SDOS:UTOB.  A TOB must only be initialized once.
The TOB is left in a deactivated state.
.sp
.un 10
SDOS:RTOB
.BR
This subroutine is called from interrupt-disabled routines to deactivate a
TOB at (X).  (Note:  It is safe, and cheap, to deactivate an already
deactivated TOB).
.sp
.un 10
SDOS:UTOB
.BR
This subroutine is called with TOB address in (X) and desired delay in
(D) in milliseconds (the delay is relative in time to the call on
SDOS:UTOB).  This call activates the TOB.  A short time (a few milliseconds
at most) after the delay expires, a stack-switched interrupt is simulated
to the address specified by TOB:ROUTINE with (X) and (D) set to TOB:PARAMETER.
Calling SDOS:RTOB before the delay expires prevents the simulated interrupt.
It is safe to call SDOS:UTOB on an active TOB; its delay will be adjusted to
the new value.
.in 0
.pa
.tc
.SH SECTION IV: THE CONFIGURATION TABLE
THE CONFIGURATION TABLE (CNFG:)
.ix Configuration Table
.ix CNFG:
.ix Hardware
.ix Device Driver
.ix I/O Package
.ix SDOS:CONFIGURATION
.sp
This table tells SDOS the specific configuration (i.e., hardware, device
drivers, etc.) in which it is running.  The builder of an I/O package must
plant a pointer in SDOS:CONFIGURATION to this table so that SDOS can find
it.
.sp
.in 10
.un 10
CNFG:DISKDCBS
.ix CNFG:DISKDCBS
.ix Disk Drive
.ix DISKINFO
.ix Disk I/O
.ix Device Name
.ix Default Disk
.br
CNFG:DISKDCBS is a pointer to a list of DISKINFO: tables.  Each DISKINFO
table describes a physical disk drive and gives SDOS access to the sector
I/O routines needed to do disk I/O.  The first DISKINFO table in the list
usually specifies a device name of "D0:" and is normally pointed to by
CNFG:BOOTDEFAULTDISKDCB.  All disk drives are mentioned in this list.
.sp
.un 10
CNFG:DEVICEDCBS
.ix CNFG:DEVICEDCBS
.ix Device Control Blocks
.ix DCB
.ix Device Name
.ix Non-Disk Device
.ix Operator's Console
.ix CONSOLE:
.br
CNFG:DEVICEDCBS is a pointer to a list of non-disk device control blocks. 
Each DCB specifies a device name and a driver entry point vector to be used
when executing I/O SYSCALLs for that device.  All non-disk devices must
appear in this list.  Some device in the list must be named "CONSOLE:"; the
DCB for that device is normally named pointed to by CNFG:BOOTCONSOLEDCB and
will be used as the operator's console at boot time.
.sp
.un 10
CNFG:IOCBPTRS
.ix CNFG:IOCBPTRS
.ix I/O Control Blocks
.ix IOCB
.ix I/O Channels
.ix File Control Blocks
.ix FCB
.ix Non-Disk Devices
.ix Disk Files
.ix NMAGIC
.br
CNFG:IOCBPTRS points to a table of pointers to I/O control blocks.  There is
one IOCB for each I/O channel defined.  Most SDOS systems have eight user
I/O channels.  The IOCB's are used by SDOS to keep track of open disk files,
and to know which driver to call for non-disk devices.  The number of IOCB's
is selected at I/O package generation time. Immediately preceding the table
of pointers must be a table of File Control Blocks.  There must be one FCB
for each IOCB, two for each disk drive, plus NMAGIC FCB's which are used by
SDOS.  Typical code for the FCB's, table of pointers, and IOCB's is:
.sp
.im 6
          FCBS      RMB          FCB:SIZE*(NIOCHANNELS+2*NDRIVES+
                                 NMAGICFCBS)
          IOCB      RMB          IOCB:SIZE*NIOCHANNELS
          *         CONFG:IOCBPTRS MUST POINT HERE
          IOCBPTRS  RPT          NIOCHANNELS
          FDB                    IOCBS+IOCB:SIZE*(*-IOCBPTRS)/2
.sp
.un 10
CNFG:NIOCHANNELS
.ix CNFG:NIOCHANNELS
.ix I/O Channels
.br
This byte contains the number of I/O channels configured into this I/O
package (8 is standard).
.pa
.un 10
CNFG:DSKBUFFERPOOL
.ix CNFG:DSKBUFFERPOOL
.IX Disk Sector Buffer Pool
.ix Boot Time
.ix Sector Buffers
.ix Sector Sizes
.ix Better System Performance
.ix Cluster Size
.br
CNFG:DSKBUFFERPOOL points to the base of a disk sector buffer pool.  At SDOS
boot time, SDOS dynamically allocates a set of sector buffers from this
area.  The size of the sector buffers is the maximum of the sector sizes
used by all the disk drives in this configuration.  Furthermore, all sector
buffers are allocated on a power of two boundary corresponding to the size
of the sector buffers.  Finally, one control block per sector buffer,
describing the sector buffer is allocated from this region.  SDOS must be
able to allocate at least two control and sector buffer blocks from this
region, or it will not boot; however, much better system performance is
obtained if the number of sector buffers available from this pool is
slightly larger than the cluster size.  Usually, the region size is chosen
to be whatever memory space is left over after SDOS and the I/O package are
placed into the memory assigned to them.
.sp
.un 10
CNFG:DSKPOOLSIZE
.ix CNFG:DSKPOOLSIZE
.IX CNFG:DSKBUFFERPOOL
.br
This 2 byte value tells SDOS how much space is available in
CNFG:DSKBUFFERPOOL.
.sp
.un 10
CNFG:ATTNCHECK   ***??What about VT driver affect on this???
.IX CNFG:ATTNCHECK
.IX Request for Attention
.ix ESCAPE
.ix OKRTS
.ix SDOS:ERROR
.ix ERR:ATTENTION
.br
CNFG:ATTNCHECK contains a pointer to a routine that checks to see if an
operator request for attention has occurred (typically, the console input
interrupt routines simply set a flag when the ESCAPE key is struck).  The
routine does an OKRTS if no request has occurred, otherwise, it calls
SDOS:ERROR with ERR:ATTENTION.
.sp
Typical code for the attention check routine might be:
.im 16
          ATTNCHECK      EQU     *
                         LDAA    ESCAPEHITCOUNT
                         0BNE     ATTNCHECK1
                         OKRTS
          ATTNCHECK1     EQU     *
                         DEC     ESCAPEHITCOUNT
          *              RESET ESCAPE HIT FLAG
                         JSR     SDOS+SDOS:ERROR
                         FDB     ERR:ATTENTION
                         ...
          *              IN CONSOLE INPUT INTERRUPT ROUTINE
                         CMPA    #ESCAPE
                         BNE     ...
                         INC     ESCAPEHITCOUNT
                         JMP     SDOS+SDOS:RTI
          *
.pa
.un 10
CNFG:DEBUGGER
.ix CNFG:DEBUGGER
.ix SYSCALL:DEBUG
.ix Debugger Program
.ix Abort
.IX ERR:NODEBUGGER
.br
CNFG:DEBUGGER contains a pointer to the entry point of the local debugger
program.  A SYSCALL:DEBUG call causes SDOS to leave the return address of
the SYSCALL on the stack and transfer control to the address specified by
this point.  If CNFG:DEBUGGER contains a 0, and a SYSCALL:DEBUG is executed,
SDOS will abort the user's program with ERR:NODEBUGGER.
.sp
.un 10
CNFG:DRIVERBASE
.ix CNFG:DRIVERBASE
.ix I/O Package
.ix LOAD
.IX CHAIN
.ix Memory Available
.ix User Programs
.br
This contains a pointer to the lowest address memory byte occupied by the
drivers if the I/O package sits below SDOS in memory.  Otherwise, it must
point to SDOS-3.  A JMP to the SDOS entry point is planted by SDOS on a
CHAIN or LOAD syscall; this address also constitutes a ceiling on the memory
available to user programs.
.sp
.un 10
CNFG:INTSETUP
.ix CNFG:INTSETUP
.ix Interrupt System Operation
.ix Interrupt Hardware
.ix Initializing
.ix Boot
.ix Enable Interrupts
.br
CNFG:INTSETUP contains a pointer to a subroutine to set up the interrupt
system operation.  Normally, this routine initializes the interrupt hardware
of the processor (i.e., sets up interrupt vectors, etc.).  It is called once
by the initializing phase of SDOS immediately after booting and then is
never called again.  This routine does not enable interrupts!  It is
appropriate to place this routine in a buffer area used by a driver so that
no penalty is paid for the space it occupies.  Note:  it may NOT be placed in
the disk buffer pool.
.sp
.un 10
CNFG:INTDISABLE
.ix CNFG:INTDISABLE
.ix Interrupts Disable
.br
CNFG:INTDISABLE contains a 3 byte subroutine to disable interrupts.  For
most 6800's, this consists merely of:
.sp
.im 3
               NOP
               SEI
               RTS
.ix Interrupt Systems
.sp
For more complicated interrupt systems, a JMP to an interrupt disable
routine can be used.  Note: CNFG:INTDISABLE must preserve the X register!  A
and B can be damaged.  This routine should be as fast as possible.
.sp
.un 10
CNFG:INTENABLE
.ix CNFG:INTENABLE
.ix Interrupts Enabl
.br
CNFG:INTENABLE contains a 3 byte subroutine to enable interrupts.  For most
6800's, this consists merely of:
.sp
.im 2
               CLI
               RTS
.sp
More complicated routines require a JMP to be placed here.  The X register
must be preserved; A and B can be damaged.  This routine should be as fast
as possible.
.sp
.un 10
CNFG:INTRTI
.ix CNFG:INTRTI
.ix Interrupt Re-Enable
.ix SDOS:RTI
.br
This contains a 3 byte routine to re-enable the interrupt system based on
the state of the I bit in CC register in the context block specified by the
top of the stack, and then perform an RTI.  Most 6800 systems simply use an
RTI instruction here. For more complex interrupt systems a JMP to a routine
can be placed here.
.sp
.un 10
CNFG:INTERRUPTSTACK
.ix CNFG:INTERRUPTSTACK
.ix NMI
.ix Interrupt Stack
.br
CNFG:INTERRUPTSTACK is a pointer to the highest available byte of the space
reserved for the interrupt stack.  The interrupt stack must have space for
an NMI context block, space for context blocks pushed by nested interrupts,
space for bytes pushed by JSR and PSH- instructions in nestable interrupt
routines, plus 9 bytes (for a scheduler context block plus 2 pushed bytes).
.sp
.un 10
CNFG:IOINTPOLL
.ix CNFG:IOINTPOLL
.ix Device Poll Routine
.ix Interrupt
.ix SDOS:IOINT
.ix IRQ
.ix CNFG:IOINTPOLL
.br
CNFG:IOINTPOLL contains a pointer to the device poll routine which is used
to determine which device caused an interrupt.  If the I/O package is
configured to transfer control to SDOS:IOINT when an IRQ occurs, then, after
stacks have been switched, SDOS will JMP to CNFG:IOINTPOLL.  If SDOS:IOINT
is not used, then CNFG:IOINTPOLL is ignored.
.sp
.un 10
CNFG:TASKQUEUE
.ix CNFG:TASKQUEUE
.ix I/O Task TCBs
.ix Initialization
.ix Task Priority
.br
This is a pointer to a list of I/O task TCBs.  The user task TCB is added by
SDOS to the end of this list at initialization time.  Each TCB points to the
next TCB, or points to 0 to signify end of list.  If (as is usually the
case) no special I/O tasks are needed, CNFG:TASKQUEUE must be zeroed. Task
priority is determined by the order of this list; the user task has the
lowest priority.  TCBs may not be added to this list dynamically.
.sp
.un 10
CNFG:TIMEOUTLIST
.ix CNFG:TIMEOUTLIST
.IX Time Out
.ix Time Out Block
.ix Initialization
.br
CNFG:TIMEOUTLIST is a pointer to a list of timeout blocks (see TIMEOUT
BLOCKS).  Each timeout block points to the next timeout block or to 0 to
signify end of list.  SDOS counts the number of timeout blocks in this list
at initialization time and places that count in SDOS:TIMEOUTCOUNT.
.in 0
.pa
.IN 10
.UN 10
CNFG:MTPRIMS
.BR
This pair of bytes points to the SDOS/MT or (SDOS/ES) primitives used to pass
control or data between multiple banks of memory.  See section on SDOS/MT
PRIMITIVES.
.SP
.UN 10
CNFG:BOOTDEFAULTDISKDCB
.BR
This pair of bytes points to the DCB to be used for the DEFAULTDISK, starting
at boot time, until a DEFAULTDISK command is executed.
.sp
.un 10
CNFG:BOOTCONSOLEDCB
.BR
This pair of bytes points to the DCB to be used for the operator's console at
boot time.
.sp
.un 10
CNFG:SETCLOCKINTERVALMILLISECONDS
.BR
This pair of bytes points to a routine which enables a clock interrupt at
time T0+(D), where T0 was the absolute time in milliseconds when IO:RET
was last called.  (The clock interrupt will pass control to SDOS:MSTICK).
If the current absolute time, T1, is greater than T0+(D) (i.e., the desired
time for interrupt has already passed), then an clock interrupt should
occur as soon as possible (generally easy to arrange in the next few
milliseconds).
.sp
.un 10
CNFG:RETURNELAPSEDMILLISECONDS
.BR
This pair of bytes points to a routine to compute the amount of time elapsed,
in milliseconds, since it was last called.  This routine is also needed by the
I/O package clock interrupt handler logic, and is usually named IO:RET in
the I/O package).
.IN 0
.PA
CONFIGURATION Table
.ix Configuration Table
.ix Disk Drivers
.ix Non-Disk Device Drivers
.ix IOCBs
.sp
This table contains all the information required by SDOS to determine its
particular configuration.  In particular, the CONFIG table lists addresses
of physical disk drivers, non-disk device drivers, IOCBs, etc.
.sp
.ix I/O Package
.ix SDOS:CONFIGPTR
.IX Disk Buffer Pool
.ix CNFIG:DEVICEDCBS
.IX CNFIG:DISKDCBS
.IX CNFIG:DSKBUFFERPOOL
.ix CNFIG:DSKPOOLSIZE
.cp 31
.im 31
            ---------------
      :0000 !             !
            !     USER    !
            !     RAM     !
            !             !
            !_____________!
            !             !
            ! "I/O PKG."  !
            !_____________!
            !    DISK     !
            !   BUFFER    !
            !    POOL     !
            !_____________!
SDOS        !             !    
CONFIGPTR   !      -------------
            !_____________!    !
            !             !    !
            !             !    !   ----------
            !             !    !-->!CNFIG:DEVICEDCBS
            !     SDOS    !        !CNFIG:DISKDCBS
            !             !        !
            !             !        !CNFIG:DSKBUFFERPOOL
            !             !        !       POINTER TO SPACE
            !             !        !       FOR DISK SECTOR
            !             !        !       BUFFER
            !             !        !CNFIG:DSKPOOLSIZE
            !             !        !       SIZE OF SPACE
            !_____________!        !       AVAILABLE FOR DISK
                                   !       SECTOR BUFFERS
                                   !ETC.
                                   !_________
.sh SECTION V: TASK CONTROL BLOCKS (TCBs)
.pa
.tc
TASK CONTROL BLOCKS (TCBs)
.ix Task Control Blocks
.ix TCBs
.ix Task
.sp
Each potential parallel execution of a program is called a "task".  Tasks
are represented inside SDOS by Task Control Blocks, which serve to give
tasks an identity, and provide storage for information critical to the
revival of a task when it is needed or ready to run.
.sp
A TCB has the following format:
.sp
.im 11
*      TCB (TASK CONTROL BLOCK) DISPLACEMENTS

               ORG     0
TCB:LNK        RMB     2       POINTER TO NEXT TCB IN QUEUE
TCB:STACK      RMB     2       STACK POINTER FOR TASK
*      ON TOP OF A STACK IS ALWAYS A CONTEXT BLOCK
TCB:COND       RMB     2       TASK'S WAKE UP ROUTINE
TCB:PARAM      RMB     2       PARAMETER TO TCB:CND ROUTINE
TCB:SCRATCHPAD RMB     8       SPACE FOR TASK'S SCRATCHPAD
                               (LOCATIONS 0-7)
TCB:SIZE       EQU     *       SIZE OF TASK CONTROL BLOCK
*
.ix TCB:LNK
.ix CNFG:TASKQUEUE
.in 10
.sp
.un 10
TCB:LNK is a pointer to the next TCB in the TCB list specified by
CNFG:TASKQUEUE.  Zero means "end of list".  Task priority is determined by
the position of the task in the queue; highest priority being the task
selected by CNFG:TASKQUEUE.
.ix TCB:STACK
.ix WAIT
.sp
.un 10
TCB:STACK is a storage area in which the current value of a task's stack
register is stored when the task is interrupted or WAITing for an event.
.sp
.ix TCB:COND
.ix Task Scheduler
.ix SDOS:WAITEVENT
.IX SDOS:WAITCOND
.un 10
TCB:COND is the address of a subroutine to test whether or not this task
should be running.  The SDOS task scheduler periodically calls the
subroutine for a task to determine whether or not the task should be given
some CPU time.  This subroutine address is changed by SDOS:WAITEVENT or
SDOS:WAITCOND, and is set to a special value ('executing') for a task which
is in execution and needs more CPU time.
.sp
.ix TCB:PARAM
.IX TCB:COND
.IX Scheduler
.ix Task
.ix Wait
.ix Crash
.un 10
TCB:PARAM is a 16 bit parameter passed in the X register to the subroutine
specified by TCB:COND when called by the scheduler.  Usually, this parameter
is the address of an event for which the task is waiting, and is a good way
to determine what the task was doing if the system crashed. Actual use of
the parameter is determined by the subroutine.
.pa
.ix TCB:SCRATCHPAD
.ix Scheduler
.ix Scratch Storage
.un 10
TCB:SCRATCHPAD is an 8 byte area used to save task page zero scratchpad
locations when a task is interrupted or forced to wait.  (These scratchpad
locations are at different places in different CPU chips:  for 6800, 6802,
6809, SCRATCHPAD is 0-7; for 6801, 6303 it is $10, and for $6811 it is $20.)
Because the scheduler saves and restores these locations every time a task
context switch occurs, each task effectively owns its own copy of the
scratchpad locations.  This provides fast and convenient scratch storage for
the task (a typical use for an I/O task is to place a DCB address in
location SCRATCHPAD+6.  This scratchpad also serves to shorten the
effective length (in both time and space) of routines executed by a task.
.sp
.in 0
.ix Task
.ix I/O Package
To add a task to perform some special function, the following
must be added to the I/O package:
.in 3
.sp
.ix Task Control Block
.un 3
1.~A Task Control Block for that task must be defined.
.br
.ix CNFG:TASKQUEUE
.un 3
2.~The TCB must be linked into the CNFG:TASKQUEUE list.
.ix Task
.ix Condition Code
.ix Fake Context Block
.ix NMI
.ix MINSTACK
.ix SDOSIOPKDEFS.ASM
.br
.un 3
3.~A stack for the task to use must be defined, with an initial context
block set up to contain a start address for the task, and a condition code
byte which enables interrupts (for the 6809, the E bit in the condition
code byte MUST be set). The stack must have enough space for a fake context
block (built by the scheduler), an interrupt context block, an NMI context
block, plus some stack space needed by scheduler, (this amount is defined by
MINSTACK in the SDOSIOPKDEFS.ASM file), plus whatever extra stack space is
used by the task (return address, pushed data, etc.).
.br
.ix TCB
.ix Context Block
.un 3
4.~The stack pointer value in the TCB must be set in such a way that the
initial context block will be used when the scheduler starts the task.
.in 0
.ix Task
.ix Priority
.ix Wait
.ix Initialization
.sp
When SDOS is first started, the task is marked as 'in execution' and will
execute as soon as all other tasks of higher priority have entered a wait
state.  When the task starts execution at the task start address specified
in the initial context block, it should perform any dynamic initialization
of any tables it might need, and then wait for whatever wake up condition is
appropriate.
.ix Built-In Task
.ix User Task
.ix User Program
.ix Timeout Task
.ix SDOS:CLOCKTICKED
.ix Timeout Blocks
.sp
SDOS comes with two built in tasks: the User task, which actually executes
the user program and shows up at the task level of the I/O drivers, and the
Timeout task, which is triggered by SDOS:CLOCKTICKED and adjusts the
contents of the Timeout Blocks.
.sp
.cp 26
Example:
.sp
.im 19
                  ...
                  ORG   CONFIGURATION+CNFG:TASKQUEUE
                  FDB   SPECIALTASKTCB
                  ...
*                 STACK SPACE FOR TASK
                  RMB   MINSTACK+EXTRANEEDED-7
                  FCB   0               INITIAL CC--> INTERRUPTS
                                        ENABLED
                  RMB   4               FOR GARBAGE A, B, AND X
                  FDB   SPECIALIOTASKSTART      ADDRESS OF FIRST
                                                INSTRUCTION TO BE
                                                EXECUTED BY TASK
INITIALSTACK      EQU   *-8
                  ...
*                 TCB FOR SPECIALIOTASK
SPECIALIOTASKTCB  EQU  *
                  FDB   nexttcb USUALLY NO MORE (ZERO)
                  FDB   INITIALSTACK    FOR SPECIAL TASK
                  RMB   TCB:SIZE-(*-SPECIALIOTASKTCB)
.sp
******** 7 ABOVE IS FOR M600 ONLY - WHAT ABOUT OTHER CPUs?*****************
.sh SECTION VI: TIMEOUT BLOCKS
.pa
.tc
TIMEOUT BLOCKS (Low Resolution)
.ix Timeout Blocks
.ix Timeout
.ix Timing Functions
.ix DCBPOINTEr
.sp
Timeout blocks are used to time out interrupt-driven devices, and to perform
various other timing functions (such as unloading floppy disk heads after a
predetermined period of time).
.sp
.im 11
                        TIMEOUT block
                   -------------------------
                   !         LINK          !
                   !_______________________!
                   !         FUSE          !
                   !      (16 BITS)        !
                   !_______________________!
                   !    TIMEOUT ROUTINE    !
                   !_______________________!
                   !      DCBPOINTER       !
                   !_______________________!
.ix Interrupt Routine
.sp
Each interrupt routine should be associated with one timeout block.
.sp
.ix Clock Tick
.ix FUSE
.ix CNFG:TIMEOUTLIST
.IX SDOS:RESCHEDULE
.IX DCBPOINTER
.IX SDOS:RTI
.IX SDOS:RESCHEDULE
At each clock tick (every 60th second), the next timeout list element is
chosen (circularly).  "FUSE", if non-zero, is decremented by the number of
timeout blocks on CNFG:TIMEOUTLIST, and if it goes zero or negative, the
timeout routine is called (in interrupt mode with the stack already
switched; (A,B) will contain the DCBPOINTER selected by the timeout block). 
The timeout routine should initiate any desired activity, and then transfer
control to SDOS:RTI or SDOS:RESCHEDULE.  If FUSE is zero, the timeout
routine will not be called.
.sp
.ix I/O Operation
.ix Timeout Delay
.ix FUSE
.ix Interrupt Routine
On initiating an I/O operation (for which an interrupt is to be timed out),
the time-out delay in ticks is stored (by the interrupt routine) into the
FUSE field of its corresponding timeout-block.  The interrupt routine is
expected to zero the fuse field in its corresponding time-out block on
receipt of its expected interrupt.  The timeout routines are designed to be
timing-splinter proof; if the interrupt is properly acknowledged (by zeroing
the time-out count), the timeout routine will not be called.
.sp
.ix Timeout List
.ix I/O Package
It is intended that timeout list elements are placed into the time-out list
statically at assembly time of the I/O package. An I/O package must always
have at least one timeout block.
.sp
.in 7
.un 7
Note:~The actual timeout value used must be equal to the
desired time-out (measured in 60HZ clock ticks) plus the
number of timeout blocks in CNFG:TIMEOUTLIST.  This value can
be computed at assembly time; or obtained dynamically, from SDOS:TIMEOUTCOUNT.
.in 0
.pa
TIMEOUT BLOCKS (High Resolution)
.sp
.im 12
                          TOB
                  ------------------------
                  |  TOB:QFLINK          |
                  ------------------------
                  |  TOB:QBLINK          |
                  ------------------------
                  |  TOB:DELAYDELTA      |
                  ------------------------
                  |  TOB:ROUTINE         |
                  ------------------------
                  |  TOB:PARAMETER       |
                  ------------------------
.SP
High resolution timer blocks (TOBs) are used to time-out fast events which
require tighter tolerances than TIMEOUT:  blocks can provide.  A TOB is initialized
at reset time by a call to SDOS:ITOB.  At I/O time, it is activated by a call
to SDOS:UTOB by an interrupt routine, which specifies the duration of the
delay in milliseconds (for TIMEOUTS, the delay is in 60HZ clock ticks, roughly
16 milliseconds).  Should the delay expire, the routine specified by
TOB:ROUTINE will obtain control, usually only a few milliseconds after delay
expiration.  An interrupt routine may also disable a TOB by calling SDOS:RTOB.
(TOBs are used extensively by VT DPB input translation routines to time out
the arrival of escape sequences)
.sp
.in 10
.un 10
TOB:QFLINK, TOB:QBLINK
.BR
Are managed by SDOS and need not concern the I/O package designer.
.sp
.un 10
TOB:DELAYDELTA
.br
Records the incremental delay for this TOB.  It need not concern the
I/O package designer.
.sp
.un 10
TOB:ROUTINE
.BR
Points to an interrupt routine.  The interrupt routine will gain control if
the delay specified by a call to is SDOS:UTOB expires before SDOS:RTOB is
called, or SDOS:UTOB is called with another delay.  (D) and (X) will be set
to TOB:PARAMETER when the routine gains control.
.sp
.un 10
TOB:PARAMETER
.BR
Is a value passed to TOB:ROUTINE when the delay for a TOB expires.  It is
usually set to contain a DCB address, but may be any value.
.in 0
.pa
.in 10
.un 10
CLOCK INTERRUPT ROUTINES
.br
SDOS logically uses two clock interrupt routines, for clocks that have
different rates.  SDOS:CLOCKTICKED accepts 60HZ tick interrupts, and
manages the low overhead, low resolution timers.  Generally, a 60HZ fixed
rate interrupt os "fed" to SDOS:CLOCKTICKED.  SDOS:MSTICK accepts
millisecond tick interrupt information, and along with SDOS:RTOB and
SDOS:UTOB, manages the high resolution, medium overhead timers.
SDOS:MSTICK could possibly be implemented by a fixed rate interrupt, but
the overhead is lower, and the resolution better, if a variable-length
interval timer can be used.  On systems with only 60HZ interrupt sources,
careful coding can run both timer logics from the single source, losing
some of the resolution of the high resolution timer.
.in 0
.pa
.ce
TOB:  Clock Support Routines
.sp
.im 45
     Stack-Switched
     Interrupt
     Poll Chain
       |
       |
       ^
      / \
     /   \
    /     \              |-------------------------------|
   /       \   YES       | ACKNOWLEDGE CLOCK INTERRUPT   |
  < MSCLOCK?>----------->|          then                 |
   \       /             | DISABLE CLOCK INTERRUPT       |
    \     /              |-------------------------------|
     \   /                           |
      \ /                            |
       V                             |
       |                             |
       | NO                  -----------------
       V                    <      IO:RET     >
                             -----------------
                                     |
                                     V
                             -----------------
                           <    SDOS:MSTICK   >
                             -----------------
                                     |
                                     V
                             -----------------
                           <      SDOS:RTI    >
                             -----------------






                      CNFG:RETURNELAPSEDMILLISECONDS
                                     |
                                     V
                          ------------------------
                         <        IO:RET          >
                          ------------------------
                                     |
                                     V
                                    RTS
.PA
.IM 43
                     IO:RET
                       |
                       V
              ------------------
              |     TEMP:=T0   |
              |     T0:=NOW    |
              ------------------
                       |
                       |
                       V
                      / \
                     /   \
                    /     \
                   /       \  YES             --------------
                  < T0-NOW  >---------------->|    ERROR   |
                   \ >256  /                  --------------
                    \     /
                     \   /
                      \ /
                       |
                       | NO
                       |
                       V
               -----------------
               |  (D):=T0-NOW  |
               -----------------
                       |
                       V
                      RTS




                      NOW
                       |
                       V
             ----------------------
             |  READ MILLISECOND  |
             |    "SWEEP HAND"    |
             ----------------------
                       |
                       |
                      RTS
.PA
.IM 34
        CNFG:SETCLOCKINTERVALMILLISECONDS
                       |
                       V
        ------------------------------
        |        T1:=T0+DELAY        |
        ------------------------------
                       |
                       |
                      / \
                     /   \
                    /     \
                   /  T1>  \  YES    -------------------------------
                  <   NOW   >------->|  SET CLOCK INTERRUPT FOR T1 |
                   \   ?   /         -------------------------------
                    \     /                        |
                     \   /                         |
                      \ /                          |
                       |                           |
                       | NO                        |
                       V                           |
    ------------------------------------------     |
    |  SET CLOCK INTERRUPT FOR NOW + EPSILON |     |
    ------------------------------------------     |
                       |                           |
                       |                           |
                       | <-------------------------|
                       |
                       V
        -------------------------------
        |    ENABLE CLOCK INTERRUPT   |
        -------------------------------
                       |
                       V
                      RTS
.PA
.IM 54
        |
        |
       / \
      /   \
     /     \
    /       \  1+YES      -------------------------------
   <   60HZ  >-----------|  DISABLE FURTHER CLOCK INTS  |
    \  INT? /            |-------------------------------
     \     /             |
      \   /              |
       \ /               V
        |          ---------------------------- =0
        | NO       | MOD3COUNT <-- MOD3COUNT-1 >-----------
        V          ----------------------------           |
                         |  =0                            V
                         |                     ---------------------
                         |                     |   MOD3COUNT <--3  |
                         |                     ---------------------
                         |                                |
                         V                                V
                   -------------------         ---------------------
                   |    (B) <-- 17   |         |     (B) <-- 16    |
                   -------------------         ---------------------
                         |                                |
                         |<-------------------------------|
                         |
                         V
                 ----------------
               <   SDOS:MSTICK   >
                 ----------------
                         |            CNFG:RETURNELAPSEDMILLISECONDS
                         |                          |
                         V                          V
                 ----------------            ----------------
                 |  (A) <-- 1   |            |   (B) <-- 0  |
                 ----------------            ----------------
                         |                          |
                         |                          V
                         V                         RTS
                --------------------
                | SDOS:CLOCKTICKED |
                --------------------
                         |            CNFG:SETINTERVALDELAYINMILLISECONDS
                         |                          |
                         |                          V
                         |               -----------------------
                         |              | ENABLE 60HZ CLOCKINT |
                         |               -----------------------
                         V                          |
                     SDOS:RTI                       V
                                                   RTS

Implementing SDOS:MSTICK and SDOS:CLOCKTICKED from a single 60HZ
fixed rate interrupt.
.sh SECTION VII: DEVICE CONTROL BLOCKS (DCBs)
.pa
.tc
.IN 10
.UN 10
DEVICE CONTROL BLOCKS (DCBs)
.ix Device Control Blocks
.ix DCBs
.ix I/O Device
.BR
Each I/O device is made known to SDOS through a Device Control Block (DCB).
DCBs specify the device name, select a driver, and hold miscellaneous data
appropriate for the driver for that device.
.ix Device Driver
.sp
DCBs have two parts: a part defined by SDOS, and a driver-specific part. 
The form and content driver-specific part is completely determined by the
device driver itself, and so is of no concern here, except that the
driver-specific portion immediately follows the SDOS-specific portion in a
DCB.  As a result, DCB sizes vary.
.sp
The SDOS-specific portion of a DCB has the following format:
.IN 0
.sp
.ix Device Control Block Displacements
.im 13
*      DEVICE CONTROL BLOCK DISPLACEMENTS


*
       ORG     0
DCB:DONEFLAG   RMB     1       0 --> DEVICE IS BUSY; <>0 -->
                               DEVICE IS DONE
DCB:LASTERROR  RMB     2       IF DCB IS DONE, CONTAINS ERROR STATUS
                               (0 = NONE )
DCB:NAME       RMB     2       POINTER TO DEVICE NAME STRING TERMINATED
                               BY ZERO BYTE
DCB:NEXTDCB    RMB     2       POINTER TO NEXT DCB IN LIST OR ZERO
DCB:DRIVER     RMB     2       POINTER TO DRIVER ENTRY POINT LIST
DCB:SIZE       EQU     *       DEVICE SPECIFIC DATA EXTENDS DCB
                               FROM HERE
.in 10
.sp
.ix DCB:DONEFLAG
.IX Interrupt Routine
.un 10
DCB:DONEFLAG is used by an interrupt routine to signal that an operation
started on the device has completed; 0 = busy, <> 0 means completed. 
Whether or not this flag is used is up to the I/O driver; SDOS does not use
it directly.
.sp
.ix DCB:NEXTDCB
.ix Non-Dis Device
.ix Disk Device
.un 10
DCB:NEXTDCB is a pointer to the next DCB in a chain of DCBs, or zero. SDOS
currently has two DCB chains: one for non-disk devices, and one for disk
devices.  DCBs on one chain are treated somewhat differently than DCBs on
the other.
.sp
.ix DCB:DRIVER
.ix Device Driver
.un 10
DCB:DRIVER is a pointer to a vector of entry points to the device driver for
a device.  Note that several DCBs may share the same driver.  See DRIVER
entry points.
.sp
.ix DCB:SIZE
.IX Device/Driver
.un 10
DCB:SIZE is the displacement into a DCB where device/driver specific data
may begin.
.pa
.ix DCB:LASTERROR
.ix DCB:DONEFLAG
.ix Interrupt Operation
.un 10
DCB:LASTERROR was intended to hold device interrupt operation completion
status.  Many drivers place 0 here to mean "completed ok", or place an
ERR:something code to mean "device operation failed because of ....".
Typical I/O driver code using DCB:DONEFLAG and DCB:LASTERROR is:
.sp
<set up I/O by filling in driver-specific part of DCB>
.im 12
     LDX     DCBPOINTER      WHICH POINTS TO DESIRED DCB
     LDX     DCB:DRIVER,X    FIND DRIVER VECTOR FOR DEVICE
     LDX     DRIVER:STARTIO,X        WHERE TO TRIGGER INTERRUPT
     JSR     SDOS+SDOS:STARTIO       TRIGGER FAKE I/O INTERRUPT
     LDX     DCBPOINTER      WAIT FOR 'DONE'
     JSR     SDOS+SDOS:WAITEVENT
     LDX     DCBPOINTER      GET COMPLETION STATUS
     LDX     DCB:LASTERROR,X
     BEQ     L1              B/ NO ERROR
     JSR     SDOS+SDOS:ERRORSAVE     SAVE ERROR CODE
     JMP     SDOS+SDOS:ERRORED       AND GO COMPLAIN!
L1   OKRTS           (CLC,RTS)       I/O COMPLETED
.sp
.ix DCB:NAME
.ix Specific Device Name
.un 10
DCB:NAME points to an ASCII text string giving the name of this specific
device, such as "LPT:", "D0:", etc.  The device name must be legal, and all
letters in it must be uppercase. The name must be terminated by an ASCII
";" (colon) character.  This device name is used as a template against which
user-program specified filenames are compared in determining which driver to
use. An example is:
.sp
.im 1
     FCC     "CONSOLE:"
.in 0
.sh SECTION VIII: DRIVER ENTRY POINTS
.pa
.tc
DRIVER ENTRY POINTS
.ix Driver Entry Points
.ix Device Driver
.ix Entry Points
.ix I/O Operations
.ix DCB
.ix Non-Disk Device
.ix Disk Device
.sp
A Device driver is a routine which effects I/O operations on a device.  Each
device driver has several entry points.  Each of these entry points has a
specific I/O function associated with it.  The entry points are located via
a vector of addresses pointed to by the DCB for that device.  SDOS supports
two different device types: disk devices, and non-disk devices.  The form
and meaning of the entry points depends on what kind of device a driver is
supposed to operate.
.sp
.ix SYSCALL
.ix SYSCALL Block
.ix Interrupt Routines
.ix Wait
.ix EXI
.ix WAIT
.ix OKRTS
.ix SDOS:ERRORED
.ix Error Handling
.ix I/O Error
Control is passed to a driver entry point when a user program issues a
SYSCALL to perform an operation on a device handled by that driver.  The
driver is executed by the user task; the code in the driver must collect
whatever parameters it needs from the SYSCALL block; set up the required
I/O; initiate the I/O (by triggering the interrupt routines if necessary);
and wait for I/O completed if needed.  Since the driver is executed as a
task-level routine, it may perform WAITs, etc. EXIT if via OKRTS if the
operation succeeded, or via SDOS:ERRORED if some I/O error occurs while
processing the SYSCALL (see error handling).
.sp
.ix DCBPOINTER
.IX DCB
SDOS conveniently places the address of the DCB in location 6 (DCBPOINTER)
for the driver's use.
.sp
.ix Non-Disk Device Driver
.ix SDOS:IOBLOCKPTR
.IX SDOS:CHECKRDLEN
.IX SDOS:CHECKWRLEN
For non-disk device drivers, the SYSCALL block address may be found in
SDOS:IOBLOCKPTR.  The driver should check for the presence of read and write
buffers in each SYSCALL before using them by calling SDOS:CHECKRDLEN and/or
SDOS:CHECKWRLEN.
.sp
.ix Non-Disk Device Drivers
.ix CNFG:DEVICEDCBS
.ix Entry Point
Non-disk device drivers (i.e., those located via DCBs in the CNFG:DEVICEDCBS
chain) have a driver entry point table as follows:
.sp
.ix Device Driver Routine Entry Points
.ix DRIVER:OPEN
.IX DRIVER:CLOSE
.IX DRIVER:READA
.IX DRIVER:WRITEA
.IX DRIVER:READB
.IX DRIVER:WRITEB
.IX DRIVER:CREATE
.IX DRIVER:RENAME
.IX DRIVER:DELETE
.IX DRIVER:CONTROL
.IX DRIVER:STATUS
.IX DRIVER:RESET
.IX DRIVER:STARTIO
.IX DRIVER:PFRESTART
.cp 18
.im 18
*      DEVICE DRIVER ROUTINE ENTRY POINTS
*
        ORG    0
DRIVER:OPEN    RMB     2       OPEN FILE
DRIVER:CLOSE   RMB     2       CLOSE FILE
DRIVER:READA   RMB     2       READ ASCII
DRIVER:WRITEA  RMB     2       WRITE ASCII
DRIVER:READB   RMB     2       READ BINARY
DRIVER:WRITEB  RMB     2       WRITE BINARY
DRIVER:CREATE  RMB     2       CREATE FILE
DRIVER:RENAME  RMB     2       RENAME FILE
DRIVER:DELETE  RMB     2       DELETE FILE
DRIVER:CONTROL RMB     2       DO CONTROL OPERATION
DRIVER:STATUS  RMB     2       READ DEVICE (DRIVER) STATUS
DRIVER:RESET   RMB     2       RESET DRIVER (ON BOOT)
DRIVER:STARTIO RMB     2       INTERRUPT ROUTINE STARTUP
DRIVER:PFRESTART       RMB     2       POWER FAIL RESTART
*
.pa
.IX Entry Points
.ix SYSCALL
These entry points are used to execute a SYSCALL; their functional
definition is very close to the SYSCALLs after which they are named.
.sp
.ix SCBLK:PARAMS
The I/O channel in the SYSCALL block (SCBLK:PARAMS byte) is meaningless from
the point of view of the driver; it is used by SDOS only to determine which
driver to call.
.sp
.ix DRIVER:OPEN
.ix Open File
.ix DCB
.ix SC:GETTYP
.in 10
.un 10
DRIVER:OPEN is passed control when a user program opens a file prefixed by a
device name specified in a DCB which selects the driver.  The driver is
expected to perform whatever actions are necessary to "open" the device for
input or update.  All devices must be OPENable (so that SC:GETTYP can be
used to read the device type without knowing the type of device).
.sp
.ix Filename
.ix File
.ix Device Name
.ix RPLEN
.ix SYSCALL:OPEN
The driver may use the filename portion of the device name to further select
a "file" (port, or whatever) under that name. If it does so, it must modify
the reply buffer in accordance with the SYSCALL:OPEN specifications.  The
device name has been parsed from the input string already, RPLEN is zeroed,
and the pointer advanced past the device name, before control is passed to
OPEN.
.sp
.ix DRIVER:CLOSE
.un 10
DRIVER:CLOSE is used to "close" a device, and usually causes the driver to
flush its buffers.  The SYSCALL block contains nothing of interest to the
driver.
.sp
.ix DRIVER:READA
.IX Read ASCII from Device
.ix RDLEN
.un 10
DRIVER:READA is used to effect a READ ASCII from the device. The driver must
implement the operation given by the SYSCALL:READA specification, including
adjusting RDLEN in the SYSCALL block.
.sp
.ix DRIVER:WRITEA
.IX Write ASCII SYSCALL to Device
.un 10
DRIVER:WRITEA is used to effect a WRITE ASCII SYSCALL to the device.  The
driver must implement the operation given by the SYSCALL:WRITEA
specification.
.sp
.ix DRIVER:READB
.ix Read Binary From Device
.ix SYSCALL:READB
.ix RDLEN
.un 10
DRIVER:READB is used to effect a READ BINARY from the device. The driver
must implement the operation given by the SYSCALL:READB specification,
including adjusting RDLEN in the SYSCALL block.
.sp
.ix Write Binary SYSCALL
.ix DRIVER:WRITEB
.ix SYSCALL:WRITEB
.un 10
DRIVER:WRITEB is used to effect a WRITE BINARY SYSCALL to the device.  The
driver must implement the operation given by the SYSCALL:WRITEB
specification.
.pa
.ix DRIVER:CREATE
.IX SYSCALL:CREATE
.IX Filename
.ix Device
.ix Device Name
.ix DRIVER:OPEN
.ix RPLEN
.un 10
DRIVER:CREATE is passed control when the user executes a SYSCALL:CREATE with
a filename that selects the device.  The driver is expected to perform any
required operations to "CREATE" the device output stream.  This operation is
illegal if the device is input-only.  The part of the filename string, not
including the device name prefix, is passed to the driver for its
inspection, if needed (see DRIVER:OPEN). RPLEN in the SYSCALL block must be
updated if the driver uses part of the filename.
.sp
.ix DRIVER:RENAME
.ix RPLEN
.ix SYSCALL:RENAME
.ix Non-Disk Drivers
.un 10
DRIVER:RENAME is given control when a RENAME syscall is executed on this
device.  For virtually all non-disk drivers, this operation is illegal.  If
not illegal, the driver should perform a RENAME in accordance to the
SYSCALL:RENAME specification; RPLEN in the SYSCALL block must be updated.
.sp
.ix DRIVER:DELETE
.ix Non-Disk Device
.ix Illegal Operation
.ix SYSCALL:DELETE
.ix RPLEN
.un 10
DRIVER:DELETE is given control when a delete operation is directed to the
device.  For virtually all non-disk devices, this operation is illegal.  If
not illegal, the driver should perform a DELETE in accordance to the
SYSCALL:DELETE specification; RPLEN in the SYSCALL block must be updated.
.sp
.ix DRIVER:CONTROL
.IX SCBLK:PARAMS+1
.IX CC:POSITION
.IX CC:DUMPBUFFERS
.ix Driver
.ix Control Oprations
.ix Error
.ix WRBUF
.un 10
DRIVER:CONTROL is used to effect a control operation on the device.  On
entry to the driver, the A register contains the control sub-code (i.e., the
contents of the SCBLK:PARAMS+1 byte in the SYSCALL block).  The driver must
determine which control operation is desired (usually via a sequence of
compare and branches) and implement the desired operation. Control
operations not recognized by the device must cause an error.  Each driver
should implement the standard control operations of CC:POSITION and
CC:DUMPBUFFERS.  Unique device-specific control operations may also be
implemented. Data may be passed to the driver via the WRBUF in the SYSCALL
block.
.sp
.IX DRIVER:STATUS
.IX SCBLK:PARAMS+1
.IX SC:GETTYP
.ix RDBUF
.ix DCB
.ix Error
.un 10
DRIVER:STATUS is used to read device status.  On entry, the A register
contains the status sub-code (the contents of SCBLK:PARAMS+1).  The driver
must determine which status operation is desired, return the appropriate
status in the RDBUF specified by the SYSCALL block, and adjust RPLEN as
needed.  Usually, the desired status can be copied from somewhere in the
device DCB.  An error must be signalled if an unrecognized device status
call is requested.  A device driver must always be able to return its type
(SC:GETTYP).
.pa
.ix DRIVER:RESET
.ix Boot
.ix Device
.ix Reset Code
.ix Interrupts Enable
.ix OKRTS
.ix Error
.un 10
DRIVER:RESET is called at SDOS boot time, with interrupts disabled, to allow
the driver to reset the device, initialize buffers, etc.  The reset code may
do anything it pleases, except it must not enable interrupts.  Return is
made via OKRTS unless an error in device initialization is detected.
.sp
.ix DRIVER:STARTIO
.ix SDOS:STARTIO
.ix Entry Point Ignored
.un 10
DRIVER:STARTIO points to the interrupt routine start I/O entry points, and
is used only by the driver itself to perform SDOS:STARTIOs if needed.  Many
drivers ignore this "entry point" and use addresses wired into the driver
routine.
.sp
.ix DRIVER:PFRESTART
.un 10
DRIVER:PFRESTART is a pipe dream and is not currently used.
.in 0
.sh SECTION IX: DISK DEVICE DRIVERS
.pa
.tc
DISK DEVICE DRIVERS
.ix Disk Device Drivers
.sp
.ix Non-Disk Driver Vector
.ix File Management
Disk device drivers are treated specially by SDOS, since SDOS includes
virtually everything necessary to do file management except the actual
sector I/O routines and a few miscellaneous routines (actually, SDOS
internally has a "non-disk" driver vector for all "file devices", and
another for "disk devices", which has the same form and use as the driver
vectors described by non-disk device drivers).
.sp
.ix New Disk (Controller)
.ix I/O Routine
.ix CNFG:DISKDCB
.ix DCB
To add a new disk (controller) to the list of disk devices usuable by SDOS,
only disk I/O routines need be coded, and made known to SDOS via a
new DCB added to the CNFG:DISKDCBs chain.
.sp
.ix Start Read
.ix Start Write
.ix Disk Driver Entry Point
.ix DCBPOINTER
.ix Selected Disk
.ix DSKINFO:
The only operations required of a disk driver in the I/O
package is "start a read", "start a write", "wait for read/write complete",
and miscellaneous control and status operations.  Like non-disk device
drivers, when a disk driver entry point gets control, DCBPOINTER contains
the address of the DCB for the selected disk.  The DCB for a disk sector I/O
driver has 3 parts: the SDOS standard part (see DCBs), a DSKINFO: part, and
a disk-specific part.  The DSKINFO: part contains data manipulated by SDOS
to keep track of each disk unit.  The disk driver must not damage (store
into) any part of the DSKINFO: portion of the DCB tables.
.sp
.ix Entry Point Vector
A disk driver has an entry point vector of the following form:
.sp
.ix Disk Sector I/O Driver
.ix I/O Driver Routine Entry Points
.ix DRIVER:DISKRESET
.IX DRIVER:DISKREAD
.IX DRIVER:DISKWRITE
.IX DRIVER:DISKWAIT
.IX DRIVER:DISKSTTUS
.IX DRIVER:DISKCONTROL
.cp 12
.im 12
*      DISK SECTOR I/O DRIVER ROUTINE ENTRY POINTS
*
                       ORG     0
DRIVER:DISKRESET       RMB     2       RESET THIS DISK DRIVER
DRIVER:DISKREAD                RMB     2       INITIATE A DISK
                                               READ
DRIVER:DISKWRITE       RMB     2       INITIATE A DISK WRITE
DRIVER:DISKWAIT        RMB     2       WAIT FOR DISK I/O
                                               COMPLETE
DRIVER:DISKSTATUS      RMB     2       READ DISK-SPECIFIC STATUS
DRIVER:DISKCONTROL     RMB     2       PERFORM DISK-SPECIFIC CONTROL
                                       OPERATION
.sp
.in 10
.IX DRIVER:DISKRESET
.ix Boot
.ix Reset
.ix Disk Device
.ix DCB
.ix DCBPOINTER
.IX Disk Buffer Pool
.ix CNFG:DSKBUFFERPOOL
.un 10
DRIVER:DISKRESET
.br
DRIVER:DISKRESET is used at SDOS boot time to reset the disk device
represented by the DCB selected by DCBPOINTER.  Since it is only used once
per physical drive, the reset code may be placed in the disk buffer pool
(see CNFG:DSKBUFFERPOOL).
.pa
.ix DRIVER:DISKREAD
.ix Disk Read
.ix LSN
.ix Sector Descriptor Block
.ix DISKINFO:SECTORDB
.ix DCB
.un 10
DRIVER:DISKREAD
.br
DRIVER:DISKREAD is used to initiate a disk read operation on a disk. 
DISKREAD does not wait for sector I/O to complete.  The LSN of the sector to
be read and the target memory address are given in the Sector Descriptor
Block selected by the pointer DSKINFO:SECTORDB in the DCB for that disk.
.ix LSN
.IX DSKINFO:NLSN
.IX DSKINFO:MAPALGORITHM
.IX DSKINFO:SIZE
.IX STARTIO
.ix OKRTS
.sp
Typically, the task level part of the driver will check the LSN) for
legality (by comparing it to DSKINFO:NLSN), and then tear the LSN apart into
its component cylinder, track, and sector addresses, performing mapping as
specified by DSKINFO:MAPALGORITHM (note that LSN 0 must map to physical
sector 0, track 0, cylinder 0).  This data would be placed in the DCB for
the particular drive in space allocated to the DCB beyond DSKINFO:SIZE, and
passed to the interrupt part of the driver via a STARTIO interrupt.  Once
the I/O is started, the driver may return control to SDOS via an OKRTS.
.sp
.ix Retries
.ix Timeouts
The interrupt routine for the driver usually handles multiple retries and
time-outs as SDOS does not.
.sp
.ix DRIVER:DISKWRITE
.IX Wait
.ix Disk Transfer
.ix DSKINFO:SECTORDB
.IX LSN
.IX DRIVER:DISKREAD
.ix Sector Descriptor Block
.ix Read-Back
.un 10
DRIVER:DISKWRITE
.br
DRIVER:DISKWRITE is used to initiate a disk write to the selected disk. 
DSKINFO:SECTORDB points to a Sector Descriptor Block which specifies the LSN
and source memory address of the transfer.  Other than writing,
DRIVER:DISKWRITE works identically to DRIVER:DISKREAD.  For floppy disks, a
verify read-back after write is recommended to increase reliability.
.sp
.un 10
DRIVER:DISKWAIT
.ix DRIVER:DISKWAIT
.IX DRIVER:DISKREAD
.IX DRIVER:DISKWRITE
.ix SDOS:WAITEVENT
.IX DCB:DONEFLAG
.IX OKRTS
.IX SDOS:ERRORED
.IX SDOS:ERRORSAVE
.ix Exit
.ix Error
.br
DRIVER:DISKWAIT is used to wait for a disk transfer (started by
DRIVER:DISKREAD or DRIVER:DISKWRITE) to complete.  The driver returns only
after completion of the I/O.  Usually, the driver causes the user task to
wait by doing an SDOS:WAITEVENT on DCB:DONEFLAG (presuming an interrupt that
completes the transfer sets the DCB:DONEFLAG).  Exit via OKRTS unless a
transfer error has occurred; otherwise, exit via SDOS:ERRORED after giving
the error code to SDOS:ERRORSAVE.  SDOS will never call DISKWAIT without
first calling DISKREAD or DISKWRITE.
.pa
.un 10
DRIVER:DISKSTATUS
.ix DRIVER:DISKSTATUS
.IX SC:GETPOS
.IX SC:GETCOL
.IX SC:GETEOF
.IX SC:GETFILESIZE
.IX SC:GETTYPE
.IX SCBLK:PARAMS+1
.IX RDBUF
.IX RPLEN
.IX SC:GETERRORSTATS
.ix SECTORDB
.ix DSKINFO
.ix Error, Illegal Device Operation
.br
DRIVER:DISKSTATUS is used to read status from the disk driver.  Only
disk-specific status is read this way; SDOS intercepts and performs the
status calls SC:GETPOS, SC:GETCOL, SC:GETEOF, SC:GETFILESIZE, SC:GETTYPE,
SC:GETPARAMS when SC:GETERRORSTATS for disk device (SDOS automatically zeros
DSKINFO error statistics after returning data from a SC:GETERRORSTATS call).
All other status requests are passed to the driver, with the A register
containing the contents of the SCBLK:PARAMS+1 byte of the SYSCALL. The
driver must check the validity of the status request and complain if an
unknown status type is requested.  The driver must adjust RDBUF and RPLEN
according to valid, returned status.  The driver must not damage the
SECTORDB block.  Most disk drivers do not have any special status to be read
back, and therefore simply cause an Illegal Device Operation error when this
entry point is called.
.sp
.un 10
DRIVER:DISKCONTROL
.ix DRIVER:DISKCONTROL
.IX CC:POSITION
.IX CC:DUMPBUFFERS
.IX CC:UNLOCKDISK
.IX CC:SETMAPALGORITHM
.IX CC:DISMOUNTDISK
.IX SCBLK:PARAMS+1
.ix Disk Device
.ix Eject Disk
.ix Write Out Track Buffers
.ix Illegal Control Operations
.ix Disk Driver
.br
DRIVER:DISKCONTROL is used to effect non-standard control operations on a
disk drive.  SDOS intercepts and performs CC:POSITION, CC:DUMPBUFFERS,
CC:UNLOCKDISK and CC:SETMAPALGORITHM control operations directed to a disk
device.  The operation CC:DISMOUNTDISK is intercepted and executed by SDOS,
but it is also handed to the driver so that it may eject the disk, write out
track buffers, or do any really final operations needed to let go of a disk.
The driver is entered with the A register containing the contents of the
SCBLK:PARAMS+1 byte of the SYSCALL. The driver must check for control
operations legal for this disk driver.  Data for the control operation can
be obtained from the SYSCALL block. The driver must complain about illegal
control operations.
.sp
.ix CC:FORMATDISK
.IX CC:DISMOUNT
.ix Disk Write Driver
.ix Blind-Write Mode
.ix Exit
A standard "special" control operation commonly implemented for disk drivers
is CC:FORMATDISK. This operation switches the disk write driver into a
"blind-write" mode, which is useful when writing all over an unformatted
disk.  "Blind-write" mode is exited when a CC:DISMOUNT control operation is
executed on the same drive.
.in 0
.pa
.ix DCB
.ix Driver Vectors
.ix Drivers
.ix Device List
.cp 44
DCBs, Driver Vectors, and Drivers
.sp
.im 42
Device List       DCB           DCB       Disk List     DCB
        !       ________      ________          !     ________
        !-----> !      !      !      !          !---> !      !
                !   --------> ! -----------> ....     !   -------->
      --------------   !      !      !          ----------   !
      !         !   -------   !   -------       !     !   --------
      V         !      !  !   !      !  !       V     !      !   !
_____________   !      !  !   !      !  !   ________  !      !   !
!    FCC    !   !      !  !   !      !  !   ! Disk !  !      !   !
! "filename"!   !      !  !   !      !  !   ! Name !  !      !   !
-------------   !______!  !   !______!  !   !______!  !______!   !
                          !             !                        !
           ---------------!             !                        !
           !                            !                        !
           !                            !                        !
           !     DRIVERVECTOR           !                        !
           !     ________               !                        !
           !---> !      ! <-------------!                        !
                 !   -------------                               !
                 !      !        !   Driver Code                 !
                 !   ----------  !   __________                  !
                 !      !     !  !-> !  OPEN  !                  !
                 !   -------  !      !        !                  !
                 !______!  !  !----> ! WRITEA !                  !
                           !         !        !                  !
                           !-------> !  CLOSE !                  !
                                     !________!                  !
                                                                 !
                                                                 !
      -----------------------------------------------------------!
      !
      !   DRIVERVECTOR                      DISK DRIVER
      !     ________                      ______________
      !---> !      !                      !            !
            !   ------------------------> ! DISK RESET !
            !      !                      !            !
            !   ------------------------> ! DISK READ  !
            !      !                      !            !
            !   ------------------------> ! DISK WRITE !
            !      !                      !            !
            !   ------------------------> !            !
            !______!                      !____________!
.pa
.tc
DSKINFO: Table
.ix DSKINFO: Table
.ix DCB
.sp
The DSKINFO: table is actually a part of each and every disk DCB, and is
used to hold sundry information about a disk drive unit.
.sp
The form of the DSKINFO: part of the DCB is as follows:
.ix DISKINFO Table Displacements
.ix DISKINFO:NBPS
.IX DSKINFO:NSPT
.IX DSKINFO:NTPC
.IX DSKINFO:NCYL
.IX DSKINFO:NSPC
.IX DSKINFO:MINALLOC
.IX DSKINFO:MIDALLOC
.IX DSKINFO:MAPALGORITHM
.IX BOOT:PARAMSIZE
.IX DSKINFO:LOG2NBPS
.IX DSKINFO:NBPSM1
.IX DSKINFO:NLSN
.IX DSKINFO:NLCN
.IX DSKINFO:NBPC
.IX DSKINFO:RANDMAP
.IX DSKINFO:MAPLSN
.IX DSKINFO:DIRFCB
.sp
.im 39
*      DISKINFO TABLE DISPLACEMENTS
*
ORG     DCB:SIZE
DSKINFO:NBPS   RMB     2       NUMBER OF BYTES PER SECTOR
DSKINFO:NSPT   RMB     2       NUMBER OF SECTORS PER TRACK
DSKINFO:NTPC   RMB     2       NUMBER OF TRACKS PER CYLINDER
DSKINFO:NCYL   RMB     2       NUMBER OF CYLINDERS PER DRIVE
*
*      THE FOLLOWING ARE FILLED FROM THE BOOT SECTOR
DSKINFO:NSPC   RMB     1       NUMBER OF SECTORS PER CLUSTER
DSKINFO:MINALLOC       RMB     LCN:SIZE        ALLOCATION MINIMUM
                                               FOR NEW FILES
DSKINFO:MIDALLOC       RMB     LCN:SIZE        ALLOCATION MIN FOR
                                               FILE EXTENSION
DSKINFO:MAPALGORITHM   RMB     2       CODE TO SELECT LOGICAL TO
                                       PHYSICAL SECTOR MAP ALGORITHM
BOOT:PARAMSIZE EQU     *-DSKINFO:NSPC  SYSTEM DEPENDENT PARAMETERS
                                       IN BOOT BLOCK
*      END OF BOOT SECTOR DISK INFO
*
DSKINFO:LOG2NBPS       RMB     1       LOG BASE 2 OF DSKINFO:NBPS
DSKINFO:NBPSM1 RMB     2       = NBPS-1 FOR USE AS MASK (QUICK
                               "MOD NBPS")
DSKINFO:NLSN   RMB     LSN:SIZE        NUMBER OF LSNS FOR THIS
                                       DISK = NSPT*NTPC*NCYL
DSKINFO:NLCN   RMB     LCN:SIZE        NUMBER OF LCNS FOR THIS
                                       DISK = NLSN/NSPC
DSKINFO:NBPC   RMB     2       NUMBER OF BYTES PER CLUSTER
DSKINFO:RANDMAP        RMB     LCN:SIZE        "RANDOM" LCN TO
                                               DISTRIBUTE NEW FILES
DSKINFO:MAPLSN RMB     LSN:SIZE        LSN OF 1ST SECTOR IN DISK
*                      ALLOCATION MAP CLUSTER
DSKINFO:DIRFCB RMB     2       POINTER TO FCB FOR $DIRECTORY FILE
DSKINFO:MAPFCB RMB     2       POINTER TO FCB FOR $DISKMAP FILE
DSKINFO:SECTORDB       RMB     2       POINTER TO RDSI CONTAINING
                                       LSN, ADDRESS PARAMETERS
DSKINFO:BADLSN RMB     3       LSN OF LAST SECTOR THAT COULDN'T
                               READ/WRITE/SEEK
DSKINFO:SIZE   EQU     *
.pa
.in 10
.ix DSKINFO:NBPS
.un 10
DSKINFO:NBPS
.br
DSKINFO:NBPS is the number of bytes per sector defined for this drive, and
is fixed at assembly time.
.sp
.ix DSKINFO:NSPT
.un 10
DSKINFO:NSPT
.br
DSKINFO:NSPT is the number of sectors per track defined for this drive, and
is fixed at assembly time.
.sp
.ix DSKINFO:NTPC
.un 10
DSKINFO:NTPC
.br
DSKINFO:NTPC is the number of tracks per cylinder defined for this drive,
and is fixed at assembly time.
.sp
.ix DSKINFO:NCYL
.un 10
DSKINFO:NCYL
.br
DSKINFO:NCYL is the number of cylinders defined for this drive, and is fixed
at assembly time.
.sp
.un 10
DSKINFO:SECTORDB
.ix DSINFO:SECTODB
.ix DRIVER:DISKWRITE
.ix DRIVER:DISKREAD
.ix Sector Descriptor Block
.br
DSKINFO:SECTORDB contains a pointer to a Sector Descriptor Block when
DRIVER:DISKREAD or DRIVER:DISKWRITE is called.
.sp
.ix DSKINFO:NBPS
.IX DSKINFO:NSPT
.IX DSKINFO:NTPC
.IX DSKINFO:NCYL
.ix DRIVER:DISKRESET
.ix DCB
.ix Initialization
.ix Disk First Mounted
.in 0
DSKINFO:NBPS, :NSPT, :NTPC and :NCYL are the only values assembled into the
DCB for a drive.  All the other DSKINFO: table entries are filled in by SDOS
at initialization (i.e., before DRIVER:DISKRESET is called) or when a disk
is first mounted.
.sp
.ix DSKINFO:
.ix DCB Allocated Space
All other entries in the DSKINFO: table need not concern the systems
programmer with the exception that space must be allocated in the DCB for
those entries.
.sp 4
*******DISCUSS ERROR STATISTICS! WHERE'S DOC???*******
.pa
SPECIAL PHYSICAL DISK ACCESS CONTROL CALLS
.sp
In newer disk drivers implemented for SDOS a general purpose scheme for
formatting, reading, and writing physical sectors has been devised. The
scheme allows for the user to do simultaneous physical disk I/O along with
any standard SDOS operation including disk file operations. The disk drivers
are designed with complete interlocking between physical and standard SDOS
file calls, including error reporting, etc.
.sp
The possible uses of the physical disk accesss scheme include: logical to
physical disk formatting, disk to disk physical bbackups, quick data area
swapping for multi-user systems, special asssembly language system support
under SDOS.
.sp
A physical transfer is accomplished by executing two special control calls
to the SDOS disk driver. The first call specifies the transfer type (i.e.,
read, write, format), sets the address of the transfer area, and the map
which contains the cylinder, head and list of sectors to transfer
sequentially into or out of the transfer area. The second control call
allows the user to determine when the transfer operation is complete and
also results in the propogation of any error received during the transfer.
In the case of writing or formatting, the WRBUF address is used as the
transfer area. In the case of reading, the RDBUF address is used.
.sp
SPECIAL PHYSICAL DISK SYSCALL BLOCK LAYOUT
.sp
.in 15
.un 15
SCBLK:OPCODE~~~1 byte specifying control operation
.br
.un 15
SCBLK:WLEN~~~~~1 byte specifying the length of the syscall block which is at
least 18 bytes for physical sector transfers.
.br
.un 15
SCBLK:PARAMS~~~2 bytes, byte1 specifies special control operation, i.e. Read
physical write physical, format, wait for transfer complete; byte 2 gives to
channel number on which the unit is open.
.br
.un 15
SLBLK:WRBUF~~~~In case of formatting or writing, these 2 bytes give the data
area to begin transfer at.
.br
.un 15
SLBLK:WRLEN~~~~Specifies size of write buffer when writing it is checked to
be at last 256 bytes (a multiple of the sector size).
.br
.un 15
SCBLK:RPLEN~~~~Set to zero for format and writes, and to RDLEN for READS.
.br
.un 15
SCBLK:RDBUF~~~~Specifies read buffer address for reads.
.br
.un 15
SCBLK:RDLEN~~~~Specifies size of read buffer when reading it is checked to
be at least 256 bytes (a multiple of the sector size).
.br
.un 15
SCBLK:DATA~~~~~Used for transfer map. Byte 1 is cylinder, Byte 2 is head,
Byte 3 to end is a logical list of sectors (to transfer). If the list
terminates before a whole track is transferred a terminator of (255) must be
used.
.sp
.in 0
For more detailed SDOS syscall block layout description, see SECTION III:
SYSCALLS in the Applications Programmer's Guide in the SDOS reference manual.
.pa
SPECIAL DISK STATUS ACCESS
.sp
In newer disk drivers implemented for SDOS, a series of status information
bytes are kept on each unit. When a unit is dismounted, these values are
reset. The information kept includes individual read, write and seek error
counts and last error status. A total operation count is also kept. In this
way, the DEFAULTPROGRAM can report disk operation status at dismount time
and keep a running summary if determined to be of value.
.sp
The information is accessed by a special status call to the driver. The
following layout describes the status returned.
.sp
2 bytes of seek error count
.br
2 bytes of last seek error status
.br
2 bytes of write error count
.br
2 bytes of last write error status
.br
2 bytes of read error count
.br
2 bytes of last read error status
.br
3 bytes of operation count total
.sp
By providing this information, it is hoped that disk related problems can be
more easily isolated and marginal problems can be remeied before serious
data looss occurs.
.pa
CHARACTERISTICS OF THE IBM FLOPPY FORMATTER
.sp
.in 3
.un 3
1.~The disk unit must be dismounted before the user may format a given disk.
If not dismounted, an "ILLEGAL DEVICE OPERATION:" will occur.
.br
.un 3
2.~The formatter uses the special diskette density call to determine whether
to format the diskette as double or single density. Double sided will be
formatted as double density; single sided as single density.
.br
.un 3
3.~The formatter is an assembly language program, running under SDOS.
.br
.un 3
4.~The formatter has soft and hard error handling built in. Any errors are
reported to the user and recovery procedures are taken.
.br
.un 3
5.~Total time to format and verify a double density diskette is less than
two minutes.
.sp
.in 0
OPERATING THE IBM FLOPPY FORMATTER
.sp
.in 3
.un 3
1.~Dismount the floppy unit to be formatted.
.br
.un 3
2.~Invoke the formatter by typing: IBMFORMATTER <CR>
.br
.un 3
3.~Enter the unit name, i.e. "DD0:" or "SD0:".
.sp
.in 0
CHARACTERISTICS OF THE WINCHESTER FORMATTER
.sp
.in 3
.un 3
1.~The particular Winchester unit (head) must be dismounted befoe the user
may format it. If not dismounted, an "ILLEGAL DEVICE OPERATION" will occur.
.br
.un 3
2.~The formatter has soft and hard error handling built in. Any errors are
reported to the user and recovery procedures are taken.
.br
.un 3
3.~Total time to format and verify a Winchester unit is less than 20
minutes.
.br
.un 3
4.~A new Winchester must have all four units formatted independently.
.sp
.in 0
OPERATING THE WINCHESTER FORMATTER
.sp
.in 3
.un 3
1.~Dismount the Winchester unit which you are formatting. Make sure the unit
is not your default disk.
.br
.un 3
2.~Invoke the formatter.
.br
.un 3
3.~Enter the name, i.e. "WD0:"..."WD3:"
.br
.un 3
4.~Enter the interleave constant which is the difference between logical
sectors as mapped onto the physical sector locations.
.br
.un 3
5.~Enter the cylindder spiral constant. This constant reflects the
difference between the last logical sector on a cylinder and the first
logical sector on the next cylinder.
.br
.un 3
6.~At this point formatting begins. When complete, the formatter will ask
for anothr unit; if "NONE" is entered, control is returned to the
DEFAULTPROGRAM.
.in 0
.sp
CHARACTERISTICS OF THE WINCHESTER COPY PROGRAM
.sp
.in 3
.un 3
1.~The source and destination unit are dismounted.
.br
.un 3
2.~The copy program does data verification and automatic error recovery.
.br
.un 3
3.~The copy program uses the special physical transfer calls to allow for
fast operation.
.sp
.in 0
OPERATING THE WINCHESTER COPY PROGRAM
.sp
.in 3
.un 3
1.~Invoke the copy program.
.br
.un 3
2.~Enter the interleave constant.
.br
.un 3
3.~Enter the unit source and destination.
.br
.un 3
4.~Copy time should be less than ten minutes.
.in 0
.pa
.tc
RESIDENT DISK SECTOR INFO (RDSI) TABLES
.ix RDSI Tables
.ix Resident Disk Sector Info
.ix Unnecessary Reads
.ix Read-Aheads
.sp
SDOS automatically manages a set at physical disk sector buffers for the
purpose of improving system throughput by eliminating unnecessary reads and
allowing automatic read-aheads.
.sp
.ix Disk Buffers
.ix NBPS
.ix DCB
.ix Boot Time
These disk buffers are constrained to be on addresses which are a multiple
of NBPS (for historical hardware reasons).  To ensure this, SDOS scans all
the disk DCBs at boot time, and choses the largest NBPS found for alignment
purposes.
.sp
.ix RDSI
.ix Disk Buffers
.ix Status, Disk Buffers
A set of tables called RDSIs are used to keep track of these disk buffers
and their status.  There is one RDSI per disk buffer.  Each RDSI contains:
.sp
*****EXTRACT FROM NEW DEFS FILE*****
.sp
.cp 22
.im 22
*      RESIDENT DISK SECTOR INFORMATION BLOCK DISPLACEMENTS
*
               ORG     0
RDSI:DISKINFO  RMB     2       POINTER TO DISKINFO TABLE FOR THIS
                               DRIVE
RDSI:LSN       RMB     LSN:SIZE        LOGICAL SECTOR NUMBER OF
                                       SECTOR
RDSI:SECTORBASE        RMB     2       POINTER TO ACTUAL SECTOR
                                       CONTENTS
RDSI:FLINK     RMB     2       FORWARD LINK IN LRU CHAIN
RDSI:BLINK     RMB     2       BACKWARD LINK IN LRU CHAIN
RDSI:MODIFIED  RMB     1       "THIS SECTOR MODIFIED" FLAG
RDSI:STATE     RMB     1       STATE OF RDSI
RDSI:SIZE      EQU     *
*
*      RDSI STATE DEFINITIONS
*
RDSISTATE:IDLE EQU     0       SECTOR TRANSFER IS COMPLETE
RDSISTATE:READING      EQU     1       SECTOR IS BEING READ INTO
                                       MEMORY
RDSISTATE:WRITING      EQU     2       SECTOR IS BEING WRITTEN
                                       FROM MEMORY
.sp
.ix DRIVE
.ix LSN
.ix MODIFIED
.ix Buffer Contents
.ix Disk Sector Write-Back
The DRIVE and LSN are used to keep track of the sector currently in the
specified buffer.  MODIFIED indicates whether the buffer contents have
changed, and, therefore, whether the disk sector must be written back to the
disk.
.sp
.ix Links
.ix Queue
.ix RSDI
.ix New Disk Sector Read
.ix New Sector Buffer
The Links are used to queue the RSDIs in a more or less Least Recently Used
fashion.  Each time a new disk sector is read in from the disk, its RDSI is
placed at the top of the Least Recently Read queue.  When a new sector
buffer needs allocation, the RDSI at the bottom of the list is grabbed and
used.  The only variation to this scheme is the following:
.in 3
.pa
.un 3
1)~A sector just written to the disk is placed at the bottom of the list.
.sp
.un 3
2)~A sector whose contents have been processed is placed at the bottom of
the list.
.in 0
.sp
These two heuristics are intended to dump sectors whose useful life has been
exceeded.
.sp
.ix RDSI:DSKINFO
RDSI:DSKINFO points to the disk driver DCB for the disk from which this
sector is to come.
.pa
.tc
SECTOR DESCRIPTOR BLOCKS (SECTORDBs)
.ix Sector Descriptor Blocks
.ix SECTORDB
.ix Disk Sector Driver
.IX DSKINFO:SECTODB
.sp
Sector Descriptor Blocks are passed to a Disk Sector Driver (via
DSKINFO:SECTORDB) and tell the driver which sector to read/write and to what
memory address.
.sp
The form of a Sector Descriptor Block is as follows:
.sp
.ix Sector Descriptor Block Displacements
.ix SECTORDB:DISKINFO
.IX SECTORDB:LSN
.IX SECTODB:ADDRESS
.IX SECTODB:SIZE
.im 10
*      SECTOR DESCRIPTOR BLOCK DISPLACEMENTS
*
                       ORG     0
SECTORDB:DISKINFO      RMB     2       POINTER TO DCB FOR DRIVE
                                       CONTAINING SECTOR
SECTORDB:LSN           RMB     LSN:SIZE        LOGICAL SECTOR NUMBER
                                               OF SECTOR
SECTORDB:ADDRESS       RMB     2       MEMORY ADDRESS FOR SECTOR
SECTORDB:SIZE          EQU     *
*
.sp
.in 10
.un 10
.ix SECTORDB:DISINFO
.IX DCB
.IX SECTODB:LSN
.ix SECTORDB:ADDRESS
.ix Logical Sector Number
.ix Target Read Address
SECTORDB:DISKINFO is a pointer to the DCB and is redundant from the point of
view of the driver.  SECTORDB:LSN is 24 bits of Logical Sector Number. 
SECTORDB:ADDRESS is the target read address.
.in 0
.sh SECTION X: I/O CHANNEL BLOCKS
.pa
.tc
I/O CHANNEL BLOCKS (IOCBs)
.ix I/O Channel Blocks
.ix IOCB
.ix I/O Channel Open
.ix Chaannel-Dependent Data
.ix Disk File Driver
.sp
IOCBs are used to keep track of which I/O channels are open, to which driver
the I/O channel is open, and to hold any channel-dependent data the driver
may choose to store in it. Currently, only SDOS proper modifies the contents
of the IOCBs; most of the IOCB area is used by the disk file driver in SDOS
to keep track of open disk files.
.sp
.ix I/O Package
.ix CNFG:IOCBPTRS
The I/O package programmer need not concern himself with the contents of the
IOCBs; he needs merely to reserve enough space in the I/O package (see
CNFG:IOCBPTRS).
.sp
.ix I/O Channel Blocks
.ix IOCB Definitions
.IX IOCB:DCB
.IX IOCB:CURLSN
.IX IOCB:BUFFERP
.IX IOCB:FCB
.IX IOCB:DRIVER
.IX IOCB:EOFFLAG
.IX IOCB:COLCNT
.IX IOCB:CURBYTE
.IX IOCB:LOCATEDF
.IX IOCB:DRDSI
.IX IOCB:NEXTBYTE
.IX IOCB:BYTECOUNT
.IX IOCB:CURLCN
.IX IOCB:DRSN
.IX IOCB:RDCN
.ix IOCB:RBN
.IX IOCB:HRDSI
.IX IOCB:SIZE
.IX IOCB:DISKWRITELOCKED
IOCB - I/O Channel Blocks
.sp
.im 34
*      IOCB DEFINITIONS
*      ORG     0
IOCB:DCB       RMB     2       POINTER TO DEVICE CONTROL BLOCK
IOCB:CURLSN    RMB     LSN:SIZE        LOGICAL SECTOR # OF CURBYTE
IOCB:BUFFERP   RMB     2       ADDRESS OF 1ST BYTE TO TRANSFER
IOCB:FCB       RMB     2       POINTER TO FILE CONTROL BLOCK
IOCB:DRIVER    RMB     2       POINTER TO DRIVER VECTOR FOR DEVICE
IOCB:EOFFLAG   RMB     1       END OF FILE HIT FLAG
IOCB:COLCNT    RMB     1       COLUMN COUNTER
IOCB:CURBYTE   RMB     4       VIRTUAL BYTE # TO READ/WRITE FROM/TO
                               NEXT
IOCB:LOCATEDF  RMB     1       0 --> NEED TO DO A LOCATECURBYTE
*                      1 --> LOCATECURBYTE DONE
IOCB:DRDSI     RMB     2       POINTER TO DATA RESIDENT DISK SECTOR
                               INFO
IOCB:NEXTBYTE  RMB     2       POINTER TO NEXT BYTE OF DISK SECTOR
IOCB:BYTECOUNT RMB     2       NUMBER OF BYTES LEFT TO PROCESS
                               IN SECTOR
IOCB:CURLCN    RMB     LCN:SIZE        CURRENT LOGICAL CLUSTER
                                       NUMBER BEING PROCESSED
IOCB:DRSN      RMB     1       RELATIVE DATA SECTOR NUMBER WITHIN
                               CLUSTER
IOCB:RDCN      RMB     LCN:SIZE        RELATIVE DATA CLUSTER NUMBER
                                       W/ RESPECT TO DATA
*                      CLUSTERS WITHIN THE FILE (0=HEADER CLUSTER)
IOCB:RBN       RMB     2       RELATIVE BYTE # WITHIN A CLUSTER
IOCB:HRDSI     RMB     2       POINTER TO RDSI FOR CURRENT HEADER
                               BLOCK
IOCB:HRSN      RMB     1       RELATIVE SECTOR NUMBER OF HEADER
                               SECTOR
IOCB:SIZE      EQU     *

IOCB:DISKWRITELOCKED   EQU     IOCB:LOCATEDF   1 --> DISK "DEVICE"
                                               IS WRITE LOCKED
.sp
.ix I/O Control Blocks
.ix Periphral Driver Access
IOCBs are I/O control blocks, and contain all the information required by
SDOS to access a peripheral driver or a disk file.
.pa
.ix Peripheral Driver
.ix IOCB
.ix EOF Hit
.ix Column Counter
.ix I/O Buffers
.ix Control Information
In the case of a peripheral driver, the IOCB contains only the driver
address, an 'EOF hit' flag, and a column counter. The driver is expected to
allocate and maintain its own I/O buffers and/or any other control
information required.
.sp
.ix Disk Files
.ix IOCB
.ix Logical Byte Position
.ix Header Cluster Number
For disk files, the IOCBs contain information describing current logical
byte position within the file, the Header Cluster Number of the file,
current cluster number (being accessed), etc.
.sp
.ix I/O Channel
.ix IOCB
.ix Configuration Table
There is one IOCB for each I/O channel defined by a particular version of
SDOS.  This number of channels is defined in the configuration table.
.sp
.ix IOCB, Special
.ix Directory
.ix Disk Map
A special IOCB is invisibly allocated permanently to SDOS to deal with
system files like the directory and the disk map. This special IOCB is used
as temporary storage or as an IOCB, depending on the SDOS routine using it.
.sp 4
.ix IOCBTBL
.ix SYSIOCB
*****IRA, PER SOME COMMENT, GIVE THIS TABLE A NAME THAT MEANS
SOMETHING*********
.cp 18
.im 18
     IOCBTBL                                 SYSIOCB

     --------                    --------    --------
     !      !                    !      !    !      !
     !   ----------------------->!      !    !      !
     !      !                    ! IOCB !    !      !
     !   ---------------------   !  #0  !    !______!
     !      !                !   !------!
     !   ------------        !-->!      !
     !      !       !            !  #1  !
     !   --------   !            !------!
     !      !   !   !----------->!      ! <------
     !      !   !                !  #2  !       !
     !______!   !                !------!       !
                !                !      !       !
                !--------------->!  #3  !       !
                                 !______!       !
                                           IOCBPOINTER
.IX IOCBPOINTER
.pa
.ix SDOS Tables
.ix IOCB
.IX LSN
.IX MODF
.IX I/O Channel
.ix Disk Sector Buffer
SDOS Tables
.sp
.im 37
      IOCB            IOCB      IOCB      IOCB
    _________       ________  ________  ________
    ! DRIVE !       !      !  !      !  !      !
    !  DCB  !       !      !  !      !  !      !
    !_______!       !      !  !      !  !      ! I/O
    !  LSN  !       !      !  !      !  !      ! CHANNEL
    !_______!       !______!  !______!  !______! BLOCKS
----------  !    -------   !  !      !  !      !
!   !_______!    !  !______!  !______!  !______!
!   !       !    !  !      !  !      !  !      !
!   !_______!    !  !      !  !      !  !      !
!   !       !    !  !      !  !      !  !      !
!   !       !    !  !      !  !      !  !      !
!   !_______!    !  !______!  !______!  !______!
!                !   
!                --------------------!
!                                    !
!                                    !
!       RDSI   RDSI   RDSI   RDSI    !
!    ______________________________  !
!--->! DRIVE !      !      !      !<-!           RESIDENT
     !_______!      !      !      !              DISK SECTOR
     !  LSN  !      !      !      !              INFO BLOCKS
     !_______!      !      !      ! RDSI:SIZE
     ! MODF  !      !      !      ! BYTES
     !_______!      !      !      !
---------    !      !      !      !
!    !_______!______!______!______!
!    ! ORDER !      !      !      !
!    !   ------>------>------>    ! ORDER-OF-READING CHAIN
!    !___!___!______!______!__!___!
!        !____________________!
!
!    _________  ________  ________
!--->!       !  !      !  !      !         DISK SECTOR
     !       !  !      !  !      !         BUFFERS
     !_______!  !______!  !______! BUFFERSIZE=MAX OF ALL DSKINFO:NBPS
.sp 2
.ix RSDI
RSDI blocks are chained together two ways for easy insertion/deletion.
.sp
.ix Disk Sector Read
.ix LRU
Disk sector read updates chain in LRU sequence.
.br
.pa
RULE:  All terminals can backspace, all terminals with non-zero depth can
form feed (clear screen), all terminals can perform CR, LF, eat NUL.
.sp
DEPTH:  =0 form feed is output unchanged
.br
.im 1
        =0 form feed is output as '^L<CR>'
.im 0
.sp
Output Only:  reminders are not posted, reads are illegal device operations
.sp
Hardcopy edit:  set--> restricted editing,
.br
.im 13
                ^H,^J,^K,^L,^U,^E --> beep

                RUB echoes and deletes last character

                ^R,^X --> '^R<CR>' or '^X<CR>' and retype or cancel the
                line as appropriate

                ^E print '^E'

                reminders are posted wherever the appropriate key is struck

                position, set fields, write editline are illegal device
                operations
.im 0
.sp
.im 16
       reset--> full editing

                ^H,^J,^K,^L,^U,^E are operational

                RUB deletes last character typed and removes it from
                the screen

                ^R backspaces to the begin of input and retypes the whole
                input line, leaving the cursor where it was when ^R was struck

                ^X clears the type ahead buffer and the entire input line,
                erasing the echoed input from the screen

                ^E erases to end of line

                reminders are posted in the lower right corner of the screen

.im 0
.sp
The cursor is considered 'lost' when the debugger is called, a write binary
is done, or when the system has just been booted.  The cursor ceases to be
lost when display depth lines have been serially output, or a position call
has been made.
.sp
When hardcopy edit is reset, but the cursor is lost, certain editing actions
are modified.
.br
.im 5
       wrapping backward is not permitted: This includes RUB, BS

       ^R and ^S will behave as hardcopy

       reminders will be treated as hardcopy
.im 0
.pa
.bp
.il Copyright (c) 1981
.ir Software Dynamics
.he SDOS USER'S MANUAL
.ll 65
.pw 85
.fo
.sh SECTION __: VIRTUAL TERMINAL DEVICE DRIVER
.pa
VIRTUAL TERMINAL DRIVER
.TC
.br
.in 5
(CONSOLE:, LPT: and Other ASCII-Oriented Serial Devices)
.in 0
.sp
This section describes SDVT11C, known as the "Virtual Terminal Driver".
.sp
For functional characteristics of the operation of virtual terminal driver,
see "SDOS User's Manual: Using the Keyboard" and "SDOSSET" and "SDOS
Application Programmer's Guide: Virtual Terminal Driver".
.sp
Associated with each virtual terminal device is a "Device Profile Block".
The DPB customizes the terminal to operate with specific manufacturers'
devices so that standard SDOS operations are converted to equivalent
device-specific operations. This allows application programs to position
cursors, "color" the screen or screen regions, or update and erase the
screen without knowing the specific device type. A system command, SDOSSET,
can be used to change which device profile is in use; some profiles are
"malleable"; i.e., changeable, so even devices with properties not handled
by standard DPBs in a system can be accommodated. There are also special
control calls to allow an application to select or modify particular
profiles.
.sp
The file IOVTDPBS.ASM holds sources for various DPBs. MAKEVT11C gens VT code
automatically for ACIAs (more needed here).
.SP
THE MULTIPORT SERIAL DEVICE DRIVER    *****OLD DATA FOLLOWS, REVISE!!
.sp
The Serial Device Driver provides all the standard features of the SDOS
console and printer device drivers and provides as an extension input
editing capabilities normally found only on systems using expensive
terminals with line insert/delete harware functions.
.sp
The Serial Device Driver is a highly structured and reentrant program moule
capable of handling multiple terminals and printers. The reentrant and
asynchronus nature of the Serial Device Driver allows for multiple user
timesharing along with easy addition of different serial harware devices.
.sp
The Serial Device Driver is usually supplied with the programming to handle
the typical terminals and printers to be needed on an SDOS configuration. If
the set of configurations possible does not include a particular device,
then it is typically a very small effort to patch or code the necessary
device specific programming needed.
.sp
Using the Serial Device driver is a simple matter for the application
programmer. A serial device may be treated like a sequential disk file in the
simplest use, or in a more ambitious vein, a screen editor can be realized
which need not be terminal dependent.
.sp
The programmer can elect to use the editing characteristics provided by the
Serial Device Driver or completely circumvent them by using the direct read
or write binary (READB/WRITEB) calls.
.sp
When using the Serial Device Driver with multiuser SDOS, the application
typically performs console I/O to Channel 0 as it is automatically opened an
closed by SDOS. All other serial devices such as printers are opened by a
name such as "LPT:" or "Lineprinter:" supplied at sysgen time.
.sp
Read and write ASCII operations are the typical mode of communication
between the application program and the user's console and printer. In this
mode, the user can prepare a line of text inserting and deleting characters
as required and send it to the application program by pressing a carriage
return or some other dynamically define activation code.
.sp
The Serial Device Driver provides many special control and status features
which provide for features such as like dynamic tab stops and explicit CRT
cursor control. Control capabilities also allow for assynchronus line input
and output which makes multiuser timesharing possible.
.sp
The standard control calls are as follows:
.br
All the control calls use the write buffer the application sets as the
source of control call data.
.sp
??WHAT DOES HARDCOPY MEAN
.SP
need to accommodate hardcopy terminals in this document
.sp
VT devices, upon first OPEN or CREATE, copy the process ID of the OPENing
process. Subsequent OPENs or CREATEs are valid only if the same process
performs them. CLOSEing the device causes an "open counter" to be
decremented. When the "open counter" is zero, the device can be OPENed by a
different process.
.sp
The input line buffer is used for assembling a message from the type-ahead
buffer. Until the input line buffer is closed by an activation character,
the typist may edit that buffer.
.sp
**PURPOSE OF VT DRIVER???
.BR
DISCUSSION OF VT DRIVER
.BR
WR.T. SDOS/MT
.pa
.in 5
.un 5
CC:COLORING
.br
*******DRAW PICTURE OF CC:COLORING STUFF*******
.BR
.ix Design Deficient Terminal
CC:COLORING does not cause the cursor to move (some terminals violate this,
due to their design deficiencies).
.sp
.ix WRBUF
.ix Display Mode
.ix Alternate Roman Character Set
.ix Default Color
.ix CRT, Dumb
.ix OPEN
Two bytes in WRBUF are used to specify the display modes.  The first byte is
divided as follows: 2 bits for intensity, 1 bit for blink, 1 bit for
underscore, 1 bit for reverse video, 3 bits for (inverted) color (1 bit each
for "not red", "not green", and "not blue"). The second byte contains 3 bits
for selecting alternate Roman character sets; the remaining bits are
undefined and must be zero.  The default color of "zero"  (both bytes zero)
selects the standard Roman character set, standard intensity, no reverse
video, no underscore, no blink, and the color white (i.e., the display mode
obtained for virtually all "dumb" CRTs). The "zero" color is automatically
selected by OPEN.
.sp
.ix NOP
Although this control call is recognized by all systems, its actual
implementation will vary according to the particular terminals being
supported; in the simplest of cases, it will be implemented as a NOP.
.in 0
.sp
.in 5
.tc
.un 5
CC:BACKGROUND
.br
.ix CC:BACKGROUND
A "background" color is the color displayed in all screen locations which do
not contain a character.
.sp
.ix Default Color
.ix CC:COLORING
.ix WRBUF
.ix OPEN
CC:BACKGROUND selects the default coloring to be used when the display is
cleared, or when cursor positioning is to be done (see CC:COLORING, above).
The required byte of data is found in WRBUF and is of the same format as for
the first byte of CC:COLORING, above. A black background (hex :07) is
automatically selected by OPEN.
.sp
.ix NOP
Although this control call is recognized by all systems, its actual
implementation will vary according to the particular terminals being
supported; in the simplest of cases, it will be implemented as a NOP.
.sp
***SECTION ON HOW TO TEST FOR EXISTENCE OF DEVICES AT RESET TIME***
.in 0
.pa
.sh SECTION __: VT DRIVER SYSGEN INFORMATION
.ix Sysgen
.ix SDOS
.IX SYSCALL Request
.ix Necessary Logic
.ix I/O Package
.ix Interface to Myriad Terminal
VT DRIVER SYSGEN INFORMATION
.sp
The VT driver is logically separated into two parts.  One part, while
currently separate from SDOS, may be considered part of SDOS.  This part is
responsible for processing the SYSCALL requests and providing the logic
necessary to implement the VT driver services.  The other part is
incorporated in the I/O package and serves to interface the VT driver to the
myriad terminals in existence.  The relationship between the two parts is
.ix Disk Device Driver
.ix Terminal Device Driver
.ix SD Warranty
much the same as that between the disk file driver within SDOS, and the disk
device drivers found in the I/O package.  Like the disk device drivers in
the I/O package, the actual terminal device drivers are the responsibility
of the vendor, and are not necessarily included in the SD Warranty.
.sp 3
VT DRIVER FLOW DISCUSSION
.ix Flow Discussion
.ix Flow Between Modules
.sp
The VT driver is broken into several modules. The flow between these modules
can better be understood by discussing the diagram, below:
.sp
.in 5
The application issues a VT related SYSCALL (1). SDOS routes the request to
the VT driver (2). If the VT driver can satisfy the request without
initiating device activity, the request is immediately satisfied (9);
otherwise, the edit task, driving the terminal, is requested to perform the
service (3). The edit task transforms the service request into a series of
logical device orders, which are vectored (4), to the appropriate device
drivers in the I/O package, for interpretation as real device orders (5).
The routines input, output, and buffer data (6). Interrupts occur (7), and
are vectored to the VT driver (8). Once the edit task has performed the I/O,
the user is re-awakened (9 and 10).
.in
.ll 65
.pw 85
.pa
.pw 120
.ce
VT Driver: Linkage and Flow of Control
.sp 2
.cm ll + lm <= pw=85
.pw 90
.ll 80
.nf
             *----->Application request for VT services
             !  *---(i.e., READA, WRITEA, POSITION cursor)
             !  !
       (10)  !  V  (1)
             SDOS           SDOS interprets SYSCALL
             A  !           and routes request to VT Driver
        (9)  !  !  (2)
             !  V
*-->(VTDRIVER.ASM) VT Driver Within SDOS
!               !
!               !
!               !
!               !                    (IOVTCONFIG.ASM)
!               !                    DCBs and TCBs for each VT device
!               !       (3)
!               *--------------------*----------*-------//---------*
! (8)                                V          !                  !
!                                   DCB1        !                  !
!                                    TCB1       V                  !
!                                     !        DCB2                !
!                                     !         TCB2               V
!                                     !          !                DCBN
!   (IOVTCONFIG.ASM)                  !          *---------------* TCBN
!   Interrupt detection and           *-----------------------*  !  !
!   VT interrupt handling setup                               !  !  !
!                                  VT Driver I/O Routine      !  !  !
!                                  Entry Points               !  !  !
!                                                             !  !  !
*---Output interrupt   *-----VT I/O Driver Routine Vector 1<--*  !  ! (4)
!   to VT Driver       !                                         !  !
!                      !                                         !  !
! (7)                  *-----VT I/O Driver Routine Vector 2<-----*  !
!                      !                   .                        !
*---Input interrupt    !                   .                        !
    to VT Driver       !                   .                        !
                       *-----VT I/O Driver Routine Vector N<--------*
                       !
                       !
                   (5) !   (IOVTCONFIG.ASM) VT Driver I/O routines
                       !   perform device-related operations
                       !
                       V
                   Input and Output buffering for task,
               (6) cursor positioning, ACIA & PIA handling,
                   reset and initialization
.ll 65
.pw 85
.fo
.pa
VT DEVICE DRIVERS, DCBs, and TCBs
.ix Device Driver
.ix DCBs
.ix TCBs
.ix System Implementor
.ix SDOS
.ix System Configuration
.sp
The terminal device drivers are the only part of the VT driver serviceable
by a systems implementor; the VT driver, itself, is part of the "black box"
called SDOS. The terminal device drivers are broken into two sections, for
ease of system configuration.
.sp
.ix IOVTDPBS.ASM
.ix Device Profile Block
.ix Terminal Supported
.ix Printer Supported
.ix IOVTDPBS.ASM
.ix System Programmer
.ix MAKVTCONIG
.ix I/O Package Shell
.ix INCLUDE Statement
One section is named IOVTDPBS.ASM, and contains the device profile blocks
(DPBs) required to interface to the various types of standard
terminals/printers supported. Since there can be a large variety of these,
conditional assembly within IOVTDPBS.ASM allows the system programmer to
select just those DPBs which he thinks will be commonly used in the desired
target configuration (the program MAKEVTCONFIG will help him do this).
IOVTDPBS.ASM is relatively static, and can be obtained from Software
Dynamics.  New terminals for which support is desired require the systems
implementor to construct a new DPB (using other DPBs in IOVTDPBS.ASM as
models) and append it to the IOVTDPBS.ASM file. New DPBs should also be
forwarded to Software Dynamics, so the "official" IOVTDPBS.ASM file can act
as a library. The I/O package shell must make references to this file via
suitable INCLUDE statements.
.sp
.ix Target System
.ix Ring Buffer for Input
.ix Ring Buffer for Output
.ix IOVTCONFIG.ASM
The other section is a file named IOVTCONFIG.ASM, which contains
configuration information regarding the target system, as well as Device
Control Blocks (DCBs), ring buffers for input/output buffering and line
.ix Line Editing
.ix Data Structure
.ix Task Control Block
.ix Timeout Block
editing, and other data structures required by the VT driver to support each
DCB, such as Task Control Blocks (TCBs) and Timeout Blocks (TOBs). Such
configuration information includes actual code to manipulate the hardware
.ix Resetting Output Hardware Device
.ix Enabling Device Interrupt
.ix MAKEVTCONFIG
.ix Standard Hardware
.ix Unusual Hardware
.ix Hand-Coding
devices (such as resetting an output hardware device, outputting a byte to a
hardware register, enabling device interrupts, polling to determine which
hardware device caused an interrupt, etc.), and specialized code for CC:xxx
and SC:xxx calls which are non-standard. IOVTCONFIG.ASM is typically built
by a program called MAKEVTCONFIG, which queries the systems implementor as
to how many VT devices, their hardware addresses and characteristics, etc. 
MAKEVTCONFIG can only manufacture code for very standard hardware; code for
unusual hardware will require hand-coding on the part of systems implementor
for the unusual features (such as code for setting baud rates); he can use
.ix Default Generated
.ix INCLUDE
the defaults generated by MAKEVTCONFIG for the rest. The hand-coded section
is placed in the I/O package shell, not IOVTCONFIG.ASM, so it only need be
generated once. IOVTCONFIG must be referenced by an assembler INCLUDE
command in the I/O package shell.
.pa
.ix Naming Convention
Some naming conventions which are found throughout the VT driver and
associated mechanisms are:
.sp
.in 19
.un 14
.ix VT
.ix Virtual Terminal
VT~~~~~~~~~~~~stands for "Virtual Terminal"
.br
.ix TO
.ix Time Out
.un 14
TO~~~~~~~~~~~~stands for "Time Out"
.br
.ix TL
.ix Task Level
.un 14
TL~~~~~~~~~~~~stands for "Task Level" (i.e., executed by user/editor
task)
.br
.ix IL
.ix Interrupt Level
.un 14
IL~~~~~~~~~~~~stands for "Interrupt Level" (executed by interrupt code)
.in 0
.SP
WHAT ABOUT SC:GETCAPABILITY?
.SP
WHAT ABOUT VT PATCH REVISION BYTE?
.pa
.tc
VT DEVICE DRIVERS and THE DEVICE PROFILE BLOCK
.IX VT Device Driver
.ix Device Profile Block
.sp
.ix Standard Operation
.ix Device Characteristic
.ix General Flag
Each device profile block (DPB) contains information allowing standard
operations to be realized for each different type of device, as well as
device characteristics such as display width and depth, whether it is a
printer or a terminal, and general flags indicating such things as the
malleability of the profile. The fields of the DPB are defined below:
.in 5
.sp 2
.un 5
DPB:PROFILENUMBER
.ix DPB:PROFILENUMBER
.IX Numeric Profile Name
.ix CC:SETPROFILE
.br
This one-byte field contains the (numeric) "name" of the profile; it is the
target of the search made by the CC:SETPROFILE control call.  Profile
numbers are assigned by Software Dynamics.
.sp
.un 5
DPB:PROFILENAME
.ix DPB:PROFILENAME
.ix ASCII Name
.ix CC:GETPROFILENAME
.ix SDOSSET
.ix Available DPB
.br
This two-byte field points to a text string of up to 16 characters which
contain an ASCII name for the device profile block (i.e., "SOROC120"). It is
used by the CC:GETPROFILENAME call to allow programs like SDOSSET to
enumerate in a human-readable fashion exactly what DPBs are available in the
system.  The first byte of the string contains a binary count from 1 to 16
which specifies the number of characters which follow.
.sp
.un 5
DPB:DVTYP
.ix DPB:DVTYP
.ix DVTYP.CONSOLE
.IX DVTYP.PRINTER
.br
This one-byte field contains the "class" of the VT device: normally it will be
DVTYP.CONSOLE or DVTYP.PRINTER.
.sp
.un 5
DPB:NEXT
.ix DPB:NEXT
.ix CNFG:VTPROFILES
.ix Configuration Profile Chain
.br
This two-byte field contains a pointer to the next profile in the
configuration profile chain (see CNFG:VTPROFILES); this field contains zero
if this is the last profile in the chain.
.sp
.un 5
DPB:DEFWIDTH
.ix DPB:DEFWIDTH
.ix Default Width of Terminal
.ix CC:SETPARAMS
.br
This one-byte field contains the default width of the terminal; the width
may be subsequently changed by the CC:SETPARAMS control call.
.sp
.un 5
DPB:DEFDEPTH
.ix DPB:DEFDEPTH
.ix Terminal Depth
.ix CC:SETPARAMS
.br
This one-byte field contains the default depth of the terminal; the depth
may be subsequently changed by the CC:SETPARAMS control call. ??? does zero
imply continuous paper hardcopy (perhaps setting hcedit) ????
.pa
.un 5
DPB:FLAGS
.ix DPB:FLAGS
.IX Terminal Characteristic
.ix Profile Malleable
.ix CC:ALTERPROFILE
.ix Hard Copy Editing
.ix Output Only Terminal
.ix Wrapping
.br
This one-byte field contains flags noting particular characteristics of the
terminal; the flags indicate: the malleability of the profile (i.e., it be
altered by a CC:ALTERPROFILE control call), whether the terminal is output
only, whether an output line exceeding the display width should wrap to the
next display line or be truncated, whether the terminal will automatically
wrap to the next display line when the display width is exceeded,
whether special hardcopy editing should be performed, whether receipt of
XOFF/XON should regulate output data flow, and whether XOFF should be sent
when input ring buffer is approaching full.
.sp
.un 5
DPB:OUTTO
.ix DPB:OUTTO
.ix TIMEOUT:FUSE
.IX SDOS
.ix Character Output Time Limit
.ix Device Time Out
.ix Timeout Value
.ix CC:SETOUTPUTTIMEOUT
.br
This two-byte field contains a default fuse (see TIMEOUT:FUSE, in the SDOS
manual) for establishing a time limit on each character output; if the time
limit is exceeded, a Device Timed Out error is returned to the caller.  A
fuse of zero indicates that no timeout is to be used. The timeout value may
be subsequently changed by the CC:SETOUTPUTTIMEOUT control call.
.sp
.un 5
DPB:RESET
.BR
This field contains a JMP to a routine to reset the device in a profile
specific fashion when the profile is selected.  Exit via RTS.
.sp
.un 5
DPB:XLATEI
.ix DPB:XLATEI
.ix Input Translation
.ix Target Terminal
.ix JMP
.ix Keyboard Input
.ix READA
.ix RTS
.ix DCB:XLATESTATE
.ix CLC
.ix DPB:XLATEI
.IX SDOS:VTILPUTBUF
.br
The I/O package must supply a routine which performs input translation
peculiar to the target terminal.  The routine is referenced with a JMP
instruction in this field.  Each character input from the keyboard,
subsequent to a READA, will be passed to this routine in (A). Exit is made
with a RTS instruction.  If the routine returns with carry set, the
character will be discarded; otherwise, the character that is returned in
(A) will be retained.  The byte, DCB:XLATESTATE, is available for use by
this routine (possible uses include, but are not limited to, remembering the
previous character typed in an escape sequence automatically generated by
the terminal keyboard, or the terminal itself).  If no input translation is
to be done, then a CLC, RTS instruction sequence should be coded.
Translation to multiple characters (this can be useful with function keys)
can be effected by having DPB:XLATEI make multiple calls to SDOS:VTILPUTBUF,
and exiting with carry set, or simulating multiple interrupts to
SDOS:VTVIRTUALINPUTINT.
.PA
.un 5
DPB:GPINIT
.ix DPB:GPINIT
.IX DCB:GPUSE
.ix General Purpose DPB Routine
.ix DCB:XLATESTATE
.IX Reset Input Translation State
.ix Device-Dependent Use
.br
These 8 bytes contain values to be copied into DCB:GPUSE, to be used for any
general purpose by the DPB:xxx routines.  A typical use is to zero the state
of DCB:XLATESTATE (the first byte DCB:GPUSE) when a DPB is chosen, to reset
the input translation state. Other uses are very device-dependent.
.pa
.un 5
DPB:NEWPAGE
.ix DPB:NEWPAGE
.IX I/O Package
.ix New Page Function
.ix Erase Screen
.ix Cursor Position
.ix Top of Form
.ix JMP
.ix Control Character
.ix SDOS:VTTLSTORE
.IX Entry Point
.ix Special Case
.ix SDOS:VTMALNEWPAGE
.IX SDOS:VTNEWPAGEFF
.br
The I/O package must supply a routine which implements the New Page function
(erase screen, position cursor to 0,0 for CRTs or goto top of form for
printers). The routine is referenced with a JMP instruction in this field.
The routine typically implements this function by outputting a sequence of
control characters peculiar to the terminal handled by the DPB;
.IX ASCII Form Character
.IX User-Specified Character Sequence
.ix CC:ALTERPROFILE
.IX DPB:FLAGS
SDOS:VTTLSTORE is called for each character with the character in (A).  Two
entry points into the VT driver are supplied to handle special cases:
SDOS:VTNEWPAGEFF, which simply outputs an Ascii Form (:0C) character, and
SDOS:VTMALNEWPAGE, which outputs a user-specified character sequence which
can be set by CC:ALTERPROFILE (used only if DPB:FLAGS is marked as
"malleable"). For terminals for which these are satisfactory, the
DPB:NEWPAGE entry may jump directly to the appropriate VT driver entry
point.
.sp
.un 5
DPB:NEWLINE
.ix DPB:NEWLINE
.IX I/O Package
.ix New Line Function
.ix Control Character Sequence
.ix SDOS:VTTLSTORE
.ix Entry Point
.ix SDOS:VTNEWLINECRLF
.ix Carriage Return
.br
The I/O package must supply a routine which implements the New Line function
(move cursor one line further down the screen or paper). The routine is
referenced with a JMP instruction in this field. The routine typically
implements each this function by outputting a sequence of control characters
peculiar to the terminal handled by the DPB; SDOS:VTTLSTORE is called for
each character with the character in (A).  Two entry points into the VT
driver are supplied to handle special cases: SDOS:VTNEWLINECRLF, which
.ix Line Feed
.ix SDOS:VTMALNEWLINE
.ix User-Specified Character Sequence
.ix CC:ALTERPROFILE
simply outputs an Ascii Carriage Return (:0D) character followed by Ascii
Line Feed (:0A), and SDOS:VTMALNEWLINE, which outputs a user-specified
character sequence (ASCII:CR, ASCII:LF or ASCII:LF,ASCII:CR, either followed
by a variale number of idles) which can be set by CC:ALTERPROFILE (used only
if DPB:FLAGS is marked as "malleable"). For terminals for which these are
.ix DPB:FLAGS
.ix DPB:NEWLINE
satisfactory, the DPB:NEWLINE entry may jump directly to the appropriate VT
driver entry point.
.sp
.un 5
DPB:ERASETOEOL
.ix DPB:ERASETOEOL
.ix Erase to End of Line
.ix JMP
.ix Control Character
.ix SDOS:VTTLSTORE
.ix Entry Point
.ix SDOS:VTSIMEEOL
.ix Output Blank
.ix SDOS:VTMALEEOL
.ix CC:ALTERPROFILE
.IX DPB:FLAGS
.ix User-Specified Character
.br
The I/O package must supply a routine which implements the Erase to End of
Line function (place blanks from cursor to right margin, without moving
cursor). The routine is referenced with a JMP instruction in this field. The
routine typically implements each this function by outputting a sequence of
control characters peculiar to the terminal handled by the DPB;
SDOS:VTTLSTORE is called for each character with the character in (A).  Two
entry points into the VT driver are supplied to handle special cases:
SDOS:VTSIMEEOL, which simulates the desired function by literally outputting
blanks until the right side of the screen/paper is reached, and then
backspaces to the original column position, and SDOS:VTMALEEOL, which
outputs a user-specified character sequence which can be set by
CC:ALTERPROFILE (used only if DPB:FLAGS is marked as "malleable"). For
terminals for which these are satisfactory, the DPB:ERASETOEOL entry may
jump directly to the appropriate VT driver entry point.
.sp
.un 5
DPB:POSITION
.IX DPB:POSITION
.IX I/O Package
.ix JMP
.ix CLC\RTS Exit
.ix Cursor Position
.br
The I/O package must supply a routine which implements the Position function
(move cursor to specified row and column). The routine is referenced with a
JMP instruction in this field. It is entered with the row and column
position in the stack at 2,S and 3,S respectively, with the return address
on top of the stack. The routine may exit simply by CLC\RTS; the VT driver
will remove the cursor position that was passed in the stack. The routine
typically implements each this function by outputting a sequence of control
.ix Control Character
.ix SDOS:VTTLSTORE
.ix SDOS:VTMALPOSITION
.ix User-Specified Character
.ix CC:ALTERPROFILE
.IX DPB:FLAGS
characters peculiar to the terminal handled by the DPB; SDOS:VTTLSTORE is
called for each character with the character in (A).  An entry point
(SDOS:VTMALPOSITION) into the VT driver is supplied to handle the special
case of outputting a user-specified character sequence which can be set by
CC:ALTERPROFILE (used only if DPB:FLAGS is marked as "malleable"). For
terminals for which this is satisfactory, the DPB:POSITION entry may jump
.ix Illegal Device Operation
.ix SDOS:ILLEGALDEVICEOPERATION
directly to SDOS:VTMALPOSITION. Devices for which cursor positioning is not
possible must return an "Illegal Device Operation" error; the entry point
SDOS:ILLEGALDEVICEOPERATION can be referenced by the JMP to accomplish this.
.sp
.un 5
DPB:SETCOLORING
.ix DPB:SETCOLORING
.IX I/O Package
.ix JMP
.ix Color Function
.ix CLC
.ix RTS
.br
The I/O package must supply a routine which implements the coloring function
indicated in (D).  The routine is referenced with a JMP instruction in this
field.  If the coloring function is not desired, then implement the routine
with CLC followed by a RTS instruction.
.sp
.un 5
DPB:SETBACKGROUND
.ix DPB:SETBACKGROUND
.IX I/O Package
.ix JMP
.ix CLC
.ix RTS
.br
The I/O package must supply a routine which implements the background
function indicated in (A).  The routine is referenced with a JMP instruction
in this field.  If the background function is not desired, then implement
the routine with CLC followed by a RTS instruction.
.in
.ll 65
.pa
.tc
VT DEVICE DRIVERS LINKAGE
.IX Linkage
.ix Entry Point
.ix SDVT11C
.ix SDOS
.ix VT Driver Module
.ix I/O Section of VT Driver
.sp
All VT driver entry points are made available in a special linkage table.
For SDVT11C and SDOS 1.1, this linkage table resides at SDOS minus some
small amount and above the VT driver module. The linkage table provides
address, data and JMP vectors between the "virtual terminal module" and the
user I/O section of the VT driver.
.sp
.ix SDOS:xxx
.ix Entry
.ix Linkage Table
All entries in this table are named SDOS:xxx in the definitions file.  These
entries are typically addressed via LDAA/JMP/JSR/LDX SDOS+SDOS:xxx
instructions, where SDOS is a symbol whose value is the base of SDOS. Below
are the linkage table entries in the order in which they appear in the
linkage table definitions.
.in 5
.sp
.UN 5
SDOS:ILLEGALDEVICEOPERATION
.ix SDOS:ILLEGALDEVICEOPERATION
.ix Illegal Device Operation
.br
This entry point generates an "Illegal Device Operation" error, and is
supplied primarily as a target for DRIVER:xxx, DCB:xxx and DPB:xxx entries
that are not implemented.
.sp
.un 5
SDOS:VTTLPUTBUF
.ix SDOS:VTTLPUTBUF
.ix Output Ring Buffer
.ix DCBPOINTER
.br
This entry point is supplied by the VT driver to put the character in (A)
into the output ring buffer selected by the DCB whose address is in (X) and
in DCBPOINTER. Characters placed in the output ring are sent to the device
.ix DPB:SPECIALFN
.IX DPB:SETCOLORING
.IX DPB:SETBACKGROUND
.IX ERR:DEVICETIMEDOUT
as quickly as possible. This entry point is intended primarily as a target
for DCB:TLPUTBUF. It is not intended for general use or use by
DPB:SPECIALFN, DPB:SETCOLORING and DPB:SETBACKGROUND, as it does not
handle buffer full conditions; see SDOS:VTTLSTORE instead. It is possible
for this routine to return an error (especially ERR:DEVICETIMEDOUT) to the
caller.
.sp
.un 5
SDOS:VTILPUTBUF
.IX SDOS:VTILPUTBUF
.IX Entry Point
.ix Input Ring Buffer
.ix DPB:XLATEI
.ix Multiple Input Characters
.br
This entry point is supplied by the VT driver to put the character in (A)
into the input ring buffer.  This routine is intended for use only by
DPB:XLATEI when it translates some input sequence into multiple input
characters.
.sp
.un 5
SDOS:VTEDITTASK
.ix SDOS:VTEDITTASK
.IX I/O Package
.ix Edit Task TCB
.ix Entry Point at Sysgen
.br
The I/O package must point (P) of each edit task TCB at this entry point at
sysgen time; (X) must point to the associated DCB (see the SDOS manual for
details on building a TCB.)
.pa
.un 5
SDOS:VTNEWPAGEFF
.ix SDOS:VTNEWPAGEFF
.IX New Page
.ix ASCII:FF
.ix DPB:NEWPAGE
.IX SDOS:VTTLSTORE
.br
This entry point is supplied by the VT driver to perform the New Page
function for the large class of devices that perform a New Page function
when sent ASCII:FF.  DPB:NEWPAGE should contain a JMP to this entry point
for this class of device. An ASCII:FF character will be sent to the device
via SDOS:VTTLSTORE.
.sp
.un 5
SDOS:VTNEWLINECRLF
.ix SDOS:VTNEWLINECRLF
.IX New Line
.ix ASCII:CR
.IX ASCII:LF
.IX DPB:NEWLINE
.IX SDOS:VTTLSTORE
.br
This entry point is supplied by the VT driver to perform the New Line
function for the large class of devices that perform a New Line function
when sent ASCII:CR followed by ASCII:LF. DPB:NEWLINE should contain a JMP to
this entry point for this class of device.  An ASCII:CR followed by ASCII:LF
will be sent to the device via SDOS:VTTLSTORE.
.sp
.un 5
SDOS:VTSIMEEOL
.ix SDOS:VTSIMEEOL
.IX Erase to End of Line
.ix DPB:ERASETOEOL
.ix SDOS:VTTLSTORE
.br
This entry point is supplied by the VT driver to simulate the Erase To End
of Line function for the class of devices that cannot perform this function
directly. DPB:ERASETOEOL should contain a JMP to this entry point for this
class of device.  Enough spaces to move the cursor to the right margin,
followed by an equal number of backspaces, will be sent to the device via
SDOS:VTTLSTORE.
.sp
.un 5
SDOS:VTMALNEWPAGE
.ix SDOS:VTMALNEWPAGE
.IX DPB:FLAGS
.IX User-Defined New Page
.ix CC:ALTERPROFILE
.IX SDOS:VTTLSTORE
.IX DPB:NEWPAGE
.br
This entry point is supplied by the VT driver for DPBs whose DPB:FLAGS is
marked "malleable", and causes the VT driver to send a user-defined New Page
sequence (see CC:ALTERPROFILE) to a device via SDOS:VTTLSTORE.  Such DPBs
should have DPB:NEWPAGE containing a JMP to this entry point.
.sp
.un 5
SDOS:VTMALNEWLINE
.ix SDOS:VTMALNEWLINE
.IX DPB:FLAGS
.IX User-Defined New Line
.ix CC:ALTERPROFILE
.IX SDOS:VTTLSTORE
.IX DPB:NEWLINE
.br
This entry point is supplied by the VT driver for DPBs whose DPB:FLAGS is
marked "malleable", and causes the VT driver to send a user-defined New Line
sequence (see CC:ALTERPROFILE) to a device via SDOS:VTTLSTORE.  Such DPBs
should have DPB:NEWLINE containing a JMP to this entry point.
.sp
.un 5
SDOS:VTMALEEOL
.ix SDOS:VTMALEEOL
.IX DPB:FLAGS
.IX Erase to End of Line
.ix CC:ALTERPROFILE
.IX SDOS:VTTLSTORE
.IX DPB:ERASETOEOL
.br
This entry point is supplied by the VT driver for DPBs whose DPB:FLAGS is
marked "malleable", and causes the VT driver to send a user-defined Erase to
End of Line sequence (see CC:ALTERPROFILE) to a device via SDOS:VTTLSTORE.
Such DPBs should have DPB:ERASETOEOL containing a JMP to this entry point.
.sp
.un 5
SDOS:VTMALPOSITION
.IX SDOS:VTMALPOSITION
.IX DPB:FLAGS
.IX User-Defined Cursor Position
.ix CC:ALTERPROFILE
.IX DPB:ERASETOEOL
.IX SDOS:VTTLSTORE
.br
This entry point is supplied by the VT driver for DPBs whose DPB:FLAGS is
marked "malleable", and causes the VT driver to send a user-defined
cursor positioning sequence (see CC:ALTERPROFILE) to a device via
SDOS:VTTLSTORE. Such DPBs should have DPB:ERASETOEOL containing a JMP to
this entry point.
.sp
.un 5
SDOS:VTATTNCHECK
.IX SDOS:VTATTNCHECK
.IX CNFG:ATTNCHECK
.IX Configuration Table
.ix I/O Package
.br
This entry point is supplied by the VT driver for use by the CNFG:ATTNCHECK
field of the configuration table in the I/O package.
.sp
.un 5
SDOS:VTINPUTTO
.ix SDOS:VTINPUTTO
.IX Timeout Block
.ix Interrupt Disabled
.ix SDOS:RTI
.IX SDOS:RESCHEDULE
.br
This VT driver entry point is referenced by the input timeout block
associated with each DCB.  When it receives control, interrupts must be
disabled (which is the case when a fuse expires), and (X) must point at the
DCB (which is easily accomplished by suitable construction of the timeout
block). Exit will be made through either SDOS:RTI or SDOS:RESCHEDULE.
.sp
.un 5
SDOS:VTOUTPUTTO
.IX SDOS:VTOUTPUTTO
.IX TimeoutBlock
.ix Interrupt Disabled
.ix SDOS:RTI
.ix SDOS:RESCHEDULE
.br
This VT driver entry point is referenced by the output timeout block
associated with each DCB.  When it receives control, interrupts must be
disabled (which is the case when a fuse expires), and (X) must point at the
DCB (which is easily accomplished by suitable construction of the timeout
block).  Exit will be made through either SDOS:RTI or SDOS:RESCHEDULE.
.SP
.un 5
SDOS:VTINPUTINT
.ix SDOS:VTINPUTINT
.IX JMP
.IX Interrupt Poll Chain
.ix Interrupt Disabled
.ix Stack NOT Switched
.IX DCB:ILGETDEV
.ix Exit
.ix RTI
.ix Poll Chain Code
.ix Input Interrupt
.ix Output Interrupt
.ix SDOS:VTOUTPUTINT
.br
This VT driver entry point is referenced with a JMP instruction by the
interrupt poll chain upon receipt of an input interrupt which had no error.
When it receives control, interrupts must be disabled (which is the case when
an interrupt occurs), (A) must contain a byte of data from the device, the
device interrupt must have already been acknowledged, (X) must point at the
DCB and stacks mus NOT be switched.  Exit will eventually be made via an RTI.
Stack switching is not required so that poll chain code for VT driver class
devices is consistent for both input and output interrupts (see
SDOS:VTOUTPUTINT).
.SP
.UN 5
SDOS:VTINPUTERRORINT
.BR
This VT driver entry point is referenced with a JMP instruction by the
interrupt poll chain upon receipt of an input interrupt which had error.  When
it receives control, interrupts must be disabled (which is the case when an
interrupt occurs), (A) must contain an error code as specified below,
the device interrupt must have already been acknowledged, (X) must point at
the DCB and stacks must NOT be switched.  Exit will eventually be made via an
RTI.  Stack switching is not required so that poll chain code for VT driver
class devices is consistent for both input and output interrupts
(see SDOS:VTOUTPUTINT).  The error code passed in (A) can be any combination
of the following "framing error", bit 0; "data overrun", bit 1; and "parity
error", bit 2.
.pa
.un 5
SDOS:VTINPUTVIRTUALINT
.BR
This VT driver entry point is referenced with a JMP instruction to force a
character into the input stream seen by a virtual terminal.  It is usually
"called" by a Device Profile Block Input Translation routine when input
translation has determined that the translation of an input sequence is
several bytes long and must feed those bytes to the virtual terminal driver
in place of the actual input.  When it receives control, interrupts must be
disabled, (A) must contain a byte of data for the particular DCB in question,
(X) must point at the DCB and stacks MUST BE switched.  Exit will eventually
be made via an RTI, so a context block containing a desired return address is
usually pushed by the DPB before passing control to this entry point.
.pa
.un 5
SDOS:VTOUTPUTINT
.IX SDOS:VTOUTPUTINT
.IX Interrupt Poll Chain
.ix Interrupt Disabled
.ix Stack NOT Switched
.ix DCB:ILPUTDEV
.br
This VT driver entry point is referenced with a JMP instruction by the
interrupt poll chain upon receipt of an interrupt indicating that a device
has output a character and is ready for more.  When it receives control,
interrupts must be disabled (which is the case when an interrupt occurs),
and (X) must point at the DCB; stacks must NOT be switched. Since
DCB:ILPUTDEV will get control immediately if there is another character in
.ix Output Ring
.ix DCB:ILDISOI
.ix RTI
.ix Interrupt Poll Chain
.ix Output Ready Interrupt
.ix CPU Capacity
.ix SDOS:STACKSWITCHED
the output ring, or DCB:ILDISOI will be called follwed by RTI if there is
not, interrupt poll chain code need not clear the interrupt or disable
interrupts.  Since output to terminals can occur at very high rates
(38.4Kbaud), interrupt poll chain code for fast output terminals should be
very near the top of the interrupt poll chain, and should check for output
ready interrupt as quickly as possible (a few wasted instructions can burn
1% of the CPU's capacity).  Conventional SDOS stack switching (see
SDOS:STACKSWITCHED) is not performed because of the overhead it entails,
which is totally unnessary for a routine as streamlined as SDOS:VTOUTPUTINT,
which only takes about 100 machine cycles and then exits via RTI.
.sp
.un 5
SDOS:VTDISPATCH
.IX SDOS:VTDISPATCH
.IX I/O Driver Dispatch Vector
.ix DCB
.ix DCB:DRIVER Field
.br
This is the standard I/O driver dispatch vector which every VT device DCB
must reference with the DCB:DRIVER field.
.sp
.un 5
SDOS:VTINTDCB
.ix SDOS:VTINTDCB
.ix Interrupt Level Routine
.ix I/O Package
.ix Interrupt Disabled
.br
This field points at the DCB currently being serviced (or last serviced), by
an interrupt level routine; it is valid only at the time of an interrupt. 
This field is set by the VT driver when it begins to process interrupt level
code, and may be referenced by interrupt level routines supplied by the I/O
package.  All interrupt level code must leave interrupts disabled.
.sp
.un 5
SDOS:VTBEEPINT
.BR
This contains a JMP to a subroutine which will transmit an ASCII:BEL code to
the device whose DCB is specified by (X).  This routine is supplied for use
generally by DPB input translation routines.
.sp
.un 5
SDOS:VTATTNCHECK
.BR
This entry point to the VT driver is intended as a target for
CNFG:ATTNCHECK when the VT driver is used with SDOS (as it almost always
is).
.in 0
.ll 65
.pa
.tc
THE DEVICE CONTROL BLOCK FOR VT DEVICES
.ix DCB
.ix Device Control Block
.ix Device Hardware Manipulation
.sp
The VT driver requires a Device Control Block for each device it supports.
The DCB specifies the device name, provides access to procedures to
manipulate the device hardware, and holds miscellaneous data appropriate for
the driver of that device.
.sp
.ix SDOS
.ix I/O Package
.ix Device-Specific
.ix I/O Package Programmer
VT DCBs have three parts: a part defined by SDOS, a part defined by the VT
driver, and a driver-specific part. Certain portions of the VT driver DCB
must be filled in by the I/O package (especially those which are
device-specific), and the rest is maintained by the VT driver, and are of
little concern to the I/O package programmer. This section defines those DCB
entries which must be filled in by the I/O package.
.sp
.ix Linkage
.ix Device-Specific Code
.ix (X) Unchanged
Several DCB entries are used as linkages to device-specific code. Since the
code may need to reference the DCB (extension) to perform the desired
function, (X) points to the DCB on entry to the routine, unless otherwise
stated.  Routines passed (X) pointing to the DCB MUST exit with (X)
unchanged.
.sp
.ix Input Ring Buffer
.ix Output Ring Buffer
.ix Task Level
.ix Interrupt Code
.ix Ring Size
Several DCB entries are used to specify the location and size of input and
output ring buffers managed by routines internal to the VT driver. These
ring buffering routines act as buffers between the Task Level portion of the
VT driver and the Interrupt code specific to the hardware.  Rings may start
anywhere and be any size less than 65536 bytes, so any desired buffering
capacity can be easily specified. Sufficient interface to the ring-buffering
routines is provided via SDOS:VTxxx entries; the VT performs all the ring
management automatically and very quickly, to provide high-performance I/O
capabilities.
.sp
.ix Task Control Block
.ix Editor Task
.ix I/O Package
.ix TCB:SCRATCHPAD+DCBPOINTER
With each DCB for a VT device, there must be defined a task control block
for the Editor Task for that device.  The I/O package must supply a task
control block (TCB) for each DCB for this purpose. TCB:SCRATCHPAD+DCBPOINTER
must be initialized to point at the DCB. The I/O package must also supply a
stack for each TCB.  The stack must contain a machine environment frame,
.ix SDOS:VTEDITTASK
.ix Stack Size
which addresses the entry point SDOS:VTEDITTASK (see above) as the first
instruction to be executed by that task. The size of the stack must be
ENV:MINSTACK*2-ENV:SIZE bytes.
.sp
.ix MAKEVTCNFG
.ix TCBs
.ix Stack Area
.ix ORG Statement
.ix Customizing DCBs
The program MAKEVTCNFG will manufacture standard DCBs with all the following
fields filled in correctly, along with suitably constructed TCBs and their
stack areas.  DCBs requiring customization are most easily obtained by
allowing MAKEVTCNFG to manufacture a standard DCB, and using ORG statements
to "drop" customizations onto the standard DCB where needed.
.pa
.in 5
.un 5
DCB:PROFILE
.IX DCB:PROFILE
.IX I/O Package
.ix Default Profile
.ix DPB:PROFILENUMBER
.br
The I/O package must supply the "name" of a profile, which is valid for the
configuration; this one-byte field holds the number (see DPB:PROFILENUMBER)
for the default profile for this device.
.sp
.un 5
DCB:XLATESTATE
.ix DCB:XLATESTATE
.ix DPB:XLATEI
.ix READA Input Translation
.ix Decoding Escape Sequence
.ix CC:SETPROFILE
.IX DPB:GPINIT
.br
This one-byte field is reserved for use by the routine referenced by the
field DPB:XLATEI.  The intent is that it will contain a READA input
translation state, primarily for use in decoding escape sequences.  This
field will be cleared whenever the CC:SETPROFILE control call is made if
DPB:GPINIT is constructed so its first byte is zero.
.sp
.un 5
DCB:GPUSE
.ix DCB:GPUSE
.ix DCB:SLATESTATE
.ix State of Terminal
.ix DPB:GPINIT
.IX CC:SETPROFILE
.br
This 8 byte field is reserved for use only by the DPB:xxx routines of the
DPB currently selected for this DCB (the first byte is named
DCB:XLATESTATE), and is generally used by a DPB to keep track of the state
of the terminal it represents.  These 8 bytes are initialized to the value
in DPB:GPINIT when CC:SETPROFILE is invoked.
.sp
.un 5
DCB:LINEBUF
.IX DCB:LINEBUF
.ix I/O Package
.ix Line Buffer Address
.ix Activation Character
.br
The I/O package must place the address of the line buffer in this two-byte
field.  The size of this buffer constrains the number of characters that may
be accepted before an activation character must be entered.
.sp
.un 5
DCB:LINEBUFLEN
.ix DCB:LINEBUFLEN
.IX I/O Package
.ix Line Buffer Length
.br
The I/O package must place the length of the line buffer in this one-byte
field; the length must be at least 20 bytes and may not exceed 255 bytes.
.sp
.un 5
DCB:OUTPUTTOBLK
.ix DCB:OUTPUTTOBLK
.IX I/O Package
.ix Timeout Block
.ix SDOS:VTOUTPUTTO
.ix DCB:ILPUTDEV
.br
The I/O package must construct a timeout block in this field.  The timeout
block must be initialized with a fuse of zero, must point to SDOS:VTOUTPUTTO
as the timeout routine, and must specify this DCB as the value to place in
(X) when a timeout occurs.  This timeout block will have its fuse set to the
currently selected output timeout each time the VT driver calls
DCB:ILPUTDEV.
.SP
.un 5
DCB:INPUTTOBLK
.ix DCB:INPUTTOBLK
.IX I/O Package
.ix Timeout Block
.ix SDOS:VTINPUTTO
.ix CC:SETREADTIMEOUT
.br
The I/O package must construct a timeout block in this field.  The timeout
block must be initialized with a fuse of zero, must point to SDOS:VTINPUTTO
as the timeout routine, and must specify this DCB as the value to place in
(X) when a timeout occurs.  This timeout block will have its fuse set to the
value specified by CC:SETREADTIMEOUT.
.PA
.un 5
DCB:RESET
.ix DCB:RESET
.IX I/O Package
.ix Hardware Initialization
.ix RTS
.ix SDOS Boot Time
.ix Input Line Buffer
.ix Disk Buffer Pool
.br
The I/O package must supply a routine which initializes the hardware
necessary to "talk" to the device.  The routine is referenced with a JMP
instruction in this field.  The routine must exit with a RTS instruction. 
This routine is called once only, at SDOS boot time, and may be placed in
the input line buffer for the device or the disk buffer pool.
.sp
.un 5
DCB:TLCLOSEDEV
.ix DCB:TLCLOSEDEV
.IX I/O Package
.ix Device "Flushing"
.ix CC:DUMPBUFFERS
.IX CLOSE
.IX Carry Reset Exit
.ix RTS
.ix SDOS:ERROR Entry Point
.ix Output Ring Buffer
.ix CLC
.br
The I/O package must supply a routine which "flushes" the device, and
reference that routine with a JMP instruction in this field.  The routine
receives control due to either a CC:DUMPBUFFERS control call or a CLOSE
call; and must exit with carry reset, using a RTS instruction, or through
the SDOS:ERROR entry point, with an appropriate error code.  For most
devices, this field will contain a CLC, RTS code sequence. To ensure that
output is complete on a device, this routine would simply need to wait for
the output ring to become empty.
.sp
.un 5
DCB:ILPUTDEV (Interrupt Level Put Device)
.ix DCB:ILPUTDEV
.ix Interrupt Level Put Device
.ix I/O Package
.ix DCB:ILENBOI
.ix DCB:ILDISOI
.IX Interrupt System
.ix Output Ready For More
.ix RTI Exit
.ix JMP
.ix Execution Time
.br
The I/O package must supply a routine that outputs a byte in (A) to the
device represented by this DCB. This routine will be called only if
DCB:ILENBOI has been called more recently than DCB:ILDISOI, and the device
is ready for more output (i.e., DCB:ILENBOI returned with Z bit "nonzero")
or the interrupt system has recently signalled that this device has caused
an "output ready for more" interupt. Exits via RTI.  The routine can be
referenced by a JMP instruction in this feild. For most serial devices, the
instruction sequence "STAA >devaddr\RTI" is sufficient for this routine, and
so 4 bytes (sufficient for the sequence just described) are reserved for
this DCB slot so the code can be directly placed into the DCB (this saves
execution time).
.SP
.UN 5
DCB:XLATETOB
.BR
This field is initialized by the VT driver to contain a high resolution
timer (TOB:) with TOB:PARAMETER set to the DCB address.  It is reserved
for use by DPB input translation routine to time out escape or other
multicharacter sequences.  The input translation routine must set
DCB:XLATETOB+TOB:ROUTINE to a DPB-specific timeout routine, and call
SDOS:UTOB with a suitable delay.  Should the sequence arrive in time, the
input translation routines must call SDOS:RTOB to prevent the TOB from
expiring.  If the timer goes off, the routine specified by TOB:ROUTINE
should give the VT driver one or more characters appropriate for an aborted
sequence (i.e., if "ESC [ B" is a left arrow, and is received before
timeout, the DPB should give a left arrow to the VT driver; if only ESC is
received before the timeout expires an ESC should be given to the VT
driver).
.PA
.un 5
DCB:ISDEVICEREADY
.ix DCB:ISDEVICEREADY
.IX I/O Package
.ix JMP Instruction
.ix Device Ready
.ix Device Not Ready
.ix Task Level
.ix Interrupt Enabled
.ix Data Carrier Detect
.BR
The I/O package must supply a routine which checks to see if the VT device
is ready, and reference that routine with a JMP instruction in this field. 
The routine is not permitted to transfer data to or from the device. The
routine returns with carry clear to indicate that the device is ready; carry
set to indicate that the device is not ready. It is called from task level
with interrupts enabled. Typically, this routine checks Data Carrier Detect.
.sp
.un 5
DCB:ILENBOI (Interrupt Level Enable Output Interrupts)
.ix DCB:ILENBOI
.ix Interrupt Level Enable Output Interrupt
.ix I/O Package
.ix Output Buffer Empty Interrupt
.ix JMP Instruction
.br
The I/O package must supply a subroutine to enable device specified by DCB
in (X) to cause an "output buffer empty" interrupt when the device is ready
for more output data.  The routine is referenced by a JMP instruction in
this field. It is called with processor interrupts disabled; returns with Z
bit reset ("not zero") if device is ready immediately for more output data,
else returns with Z bit set. Normally called by VT driver once just before
it outputs a stream of bytes via interrupts to the device.
.sp
.un 5
DCB:ILDISOI (Interrupt Level Disable Output Interrupts)
.ix DCB:ILDISOI
.ix Interrupt Level Disable Output Interrupt
.ix I/O Package
.ix Output Buffer Empty Interrupt
.ix JMP Instruction
.br
The I/O package must supply a subroutine to disable device specified by DCB
in (X) from causing more "output buffer empty" interrupts. The routine is
referenced by a JMP instruction in this field.  It is called with processor
interrupts disabled. Normally called by VT driver once after outputting a
stream of bytes, when there are no more bytes to output.
.SP
.un 5
DCB:ILOTO (Interrupt Level Output Timeout)
.ix DCB:ILOTO
.ix Interrupt Level Output Timeout
.ix I/O Package
.ix Output Timeout
.ix WARNINGS
.br
The I/O package must supply a subroutine to reset the output device
specified by the DCB in the (X) register after an output timeout (this
routine must NOT reset the INPUT side of the device).   The routine is
referenced by a JMP instruction in this field.  It is called with processor
interrupts disabled.  Clears output activity on the device, and leaves
output interrupts disabled.
.sp
.un 5
DCB:ILSETBAUDRATE (Interrupt Level Set Baud Rate)
.ix DCB:ILSETBUADRATE
.ix Interrupt Level Set Baud Rate
.ix I/O Package
.ix Baud Rate
.ix Illegal Device Operation
.ix JMP Instruction
.ix ERRORRTS
.br
The I/O package must supply a routine that sets the baud rate to (D)
bits-per-second for the device represented by the DCB in (X).  Returns with
carry set if baud rate is not changeable to value in (D), and baud rate is
not changed (this causes VT driver is issue an "ILLEGAL DEVICE OPERATION"
error). The routine is referenced by a JMP instruction in this field; if the
baud rate cannot be changed by the software then an ERRORRTS can be placed in
this DCB slot.
.pa
.un 5
DCB:TLPUTBUF
.ix DCB:TLPUTBUF
.ix I/O Package
.ix JMP Instruction
.ix DCBPOINTER
.ix DCB Address
.ix Task Level
.ix Interrupt Enabled
.ix Memory-Mapped Video Device
.ix Video Buffer
.ix DCB:RINGOUTLEN
.ix Ring Buffer
.ix Internal Ring Buffer Management
.br
The I/O package must supply a routine which accepts a character to be
output.  The routine is referenced with a JMP instruction in this field, and
receives control with the character in (A), and (X) pointing at the DCB
(location DCBPOINTER also contains the address of the DCB).  The routine
will be called from the task level with interrupts will be enabled. I/O
packages servicing memory-mapped video devices may implement this routine by
storing directly into the video buffer and always returning with (X)
preserved and the "Z" condition code bit clear (i.e., "non-zero") (note:
DCB:RINGOUTLEN must also be initialized to -1). For devices requiring use
of ring buffers and interrupts, this field may be initialized with
"JMP~>0"; the VT driver will substitute an optimized "JMP
SDOS+SDOS:VTTLPUTBUF" and  use its internal ring buffer management and
DCB:ILxxx to empty the rings.
.sp
.un 5
DCB:OILQUIESCENT
.ix DCB:OILQUIESCENT
.ix Output Buffer Empty
.ix Interrupt-Driven Output Device
.ix Memory-Mapped Video Device
.br
This field tells the VT driver whether an "output buffer empty" interrupt is
expected from the device or not; it is zero if an interrupt IS expected. 
For interrupt-driven output devices, it should be initialized to 1; for
memory-mapped video devices, it should be initialized to zero.
.SP
.un 5
DCB:BAUDRATE
.ix DCB:BAUDRATE
.IX I/O Package
.ix Default Baud Rate
.ix DCB:ILSETBAUDRATE
.ix System Boot Time
.br
The I/O package must fill this 16 bit field with the default baudrate
desired for this DCB.  The VT driver reset code will call DCB:ILSETBAUDRATE
with this value at system boot time.
.sp
.un 5
DCB:RINGINBASE
.ix DCB:RINGINBASE
.IX I/O Package
.ix Input Ring Buffer
.br
The I/O package must supply space for an input ring buffer. This two-byte
field points at the base of the area reserved for the input ring buffer.
.sp
.un 5
DCB:RINGINLEN
.ix DCB:RINGINLEN
.ix Input Ring Buffer Length
.ix Ring Buffer NEGATIVE
.br
This two-byte field defines the length of the area reserved for the input
ring buffer, and contains the NEGATIVE of size of the ring.
.sp
.un 5
DCB:RINGINTHRESHOLD
.BR
This one-byte field specifies the amount of room left in the input ring when
DCB:ILCHOKEINPUT should be called and input choke by transmission of XOFF
should occur (if enabled by DPB:FLAGS).  The value is also used to specify
the amount of data left in the input ring when DCB:ILUNCHOKEINPUT should be
called, and input choking disabled by transmission of XON (if enabled by
DPB:FLAGS).
.PA
.un 5
DCB:RINGOUTBASE
.ix DCB:RINGOUTBASE
.ix I/O Package
.ix Output Ring Buffer
.ix Memory-Mapped Video Device
.br
The I/O package must supply space for an output ring buffer. This two-byte
field points at the base of the area reserved for the output ring buffer.
For memory-mapped video devices, the field may be set to any value; the
buffer so allocated will never get used.
.sp
.un 5
DCB:RINGOUTLEN
.ix DCB:RINTOUTLEN
.ix Output Ring Buffer Length
.ix Ring Buffer NEGATIVE
.ix Memory-Mapped Video Device
.br
This two-byte field defines the length of the area reserved for a output
ring buffer, and contains the NEGATIVE of the size of the ring. For
memory-mapped video devices, this field must contain -1.
.sp
.un 5
DCB:RINGOUTTHRESHOLD
.ix DCB:RINGOUTTHRESHOLD
.ix Output Ring
.ix Characters Available in Output Ring
.ix Blocking an Output
.ix Hysteris
.ix DCB:RINGOUTLEN
.br
This one-byte field defines the number of characters that must be available
in the output ring before the VT driver will wake up after blocking on
output. It thus provides a hysteris, ensuring that the when the VT driver
wakes, it can place many characters in the output ring before it must block
again, thus dividing the blocking overhead over many characters.  This field
is typically set to 1/8th the magnitude of DCB:RINGOUTLEN.
.SP
.un 5
DCB:CONTROL
.ix DCB:CONTROL
.ix I/O Package
.ix Unrecognized Control Call
.ix JMP Instruction
.ix Control Call Code
.ix RTS Exit
.ix SDOS:ERROR Entry Point
.ix Task Level
.ix Interrupt Enabled
.br
The I/O package must supply a routine which services unrecognized control
calls.  The routine is referenced with a JMP instruction in this field. 
When the routine receives control, (B) contains the control call code, and
(X) points at the DCB.  Exit must be made with a RTS instruction.  Return is
made with carry clear if the control call code is recognized and accepted;
otherwise, return is made through the SDOS:ERROR entry point, with an
appropriate error code. This routine operates at the task level, with
interrupts enabled.
.sp
.un 5
DCB:STATUS
.ix DCB:STATUS
.ix I/O Package
.ix Unrecognized Status Call
.ix JMP Instruction
.ix RTS
.ix Status Call Code
.ix SDOS:ERROR Entry Point
.ix Task Level
.ix Interrupt Enabled
.br
The I/O package must supply a routine which services unrecognized status
calls.  The routine is referenced with a JMP instruction in this field. 
When the routine receives control, (B) contains the status call code, and
(X) points at the DCB.  Exit must be made with a RTS instruction.  Return is
made with carry clear if the status call code is recognized and accepted;
otherwise, return is made through the SDOS:ERROR entry point, with an
appropriate error code. This routine operates at the task level, with
interrupts enabled.
.in
.ll 65
.pa
VT DRIVER INTERNAL DCB VARIABLES
.ix Internal DCB Variable
.ix System Implementor
.sp
This section describes the other DCB entries for documentation purposes
only.  The systems implementor need not concern himself with these fields.
.sp 3
.in 5
.un 5
DCB:TLROOM
.ix DCB:TLROOM
.IX Ring Buffer
.ix Free Output Buffer Space
.br
The ring buffer routines maintain this two-byte field, which is a count of
free output buffer space. A value of zero means that no output buffer space
is available.  A non-zero value means that room for at least one byte is
available. DCB:TLROOM must be updated in an indivisible fashion.
.sp
.un 5
DCB:ILDATA
.br
.ix DCB:ILDATA
.ix Ring Buffer
.ix Available Output Data Bytes Negative
The ring buffer routines maintain this two-byte field, which is the negative
of the count of available output data bytes, minus one. A value of minus one
means that no output data bytes are available. DCB:ILDATA must be updated in
an indivisible fashion.
.sp
.un 5
DCB:ILROOM
.ix DCB:ILROOM
.ix Ring Buffer
.ix Free Input Buffer Space, Negative
.br
The ring buffer routines maintain this two-byte field, which is the negative
of the count of free input buffer space, minus one. A value of minus one
that no input buffer space is available. DCB:ILROOM must be updated in an
indivisible fashion.
.sp
.un 5
DCB:TLDATA
.ix DCB:TLDATA
.ix DCB:ILPUTBUF
.ix DCB:TLGETBUF
.ix Available Input Data Bytes
.br
The routines referenced by the fields DCB:ILPUTBUF and DCB:TLGETBUF must
maintain this two-byte field, which is a count of available input data
bytes.  A value of zero means that no input data bytes are available.  A
non-zero value means that at least one input data byte is available.
DCB:ILROOM and DCB:TLDATA must be updated in an indivisible fashion.
.in
.ll 65
.pa
.tc
CONFIGURATION TABLE
.sp 2
.in 5
.un 5
CNFG:VTPROFILES
.ix CNFG:VTPROFILES
.IX I/O Package
.ix Device Profile Block
.br
The I/O package must supply the address of the head of a chain of DPBs
profiling this configuration (see Device Profile Block, above).
.sp
.un 5
CNFG:VTDEBUG
.ix CNFG:VTDEBUG
.IX I/O Package
.ix Debugger
.ix FDB Directive
.ix Interrupt Level
.ix Interrupt Disabled
.ix NMI
.ix Machine Environment Frame
.ix ^D
.br
The I/O package must supply a routine which calls the system debugger.  The
routine is referenced with an FDB directive in this field.  The routine
should return with carry clear, unless the system debugger is unavailable,
in which case return should be made with carry set.  This routine will
receive control at the interrupt level, with interrupts disabled, and a
machine environment frame on the stack, as though an NMI had occurred. ^D
beeps if CNFG:VTDEBUG=0??
.sp
.un 5
CNFG:VTDCB
.ix CNFG:VTDCB
.ix I/O Package
.ix Head of a Chain Address
.ix DCB:NEXTDCB
.ix Non-Disk Device DCB
.br
The I/O package must supply the address of the head of a chain of VT device
DCBs.  Each DCB points at the next DCB in the chain with the DCB:NEXTDCB
field; the last DCB in the chain contains zeroes in the field.  (Note that
this field is not currently required of the I/O package, but rather, the VT
device device DCBs are placed on the chain of non-disk device DCBs.)
.in
.ll 65
.ll 65
.pw 85
.pa
A VT driver package must contain the following:
.im 16
   Any of the following from the Components pack:
   / /   VTDRIVER60K.BIN
   / /   VTDRIVER48K.BIN
   / /   VTDRIVER56K.BIN

   One each of the following:
   / /   SDOSIOVTDEFS.ASM (Components pack)
   / /   VTSDOS11DEFS.ASM (Components pack)
   / /   IOVT.ASM (Components pack)
   / /   SET (Utilities pack)
   / /   MAKEVTCONFIG (Components pack)
   / /   IOPACKAGE.NOTE (Documentation pack)

   One each of the following, as necessary:
   / /   M680C (Utilities pack)
   / /   M680C.LIB (Utilities pack)
.im 0
.pa
VT devices, upon first OPEN or CREATE, copy the process ID of the
OPENing process.  Subsequent OPENs or CREATEs are valid only if
the same process performs them.  CLOSEing the device causes
an "open counter" to be decremented.  When the "open counter" is
zero, the device can be OPENed by a different process.
.sp
The input line buffer is used for assembling a message from the
type-ahead buffer.  Until the input line buffer is closed by an
activation character, the typist may edit that buffer.
.pa
CNFG:VTDEBUG lie? value=0 --> no debug?? stacks switched ??
.sp
3 states of a DPB:
.pa
.pw 130
.ll 100
.im 1
                   SDOS/MT  Memory Organization
.im 0
.sp
.cp 37
.im 37

          User Space Physical       System Space Physical
            ________________           ________________
            !              !           !              !
            !              !           !              !
            !______________!           !______________!
            ! User/System  !           ! User/System  !
            !  common  ----!------     !   common     !
            !          <---!---  |     !              !
            !______________!  |  |     !______________!
            !//////////////!  |  |     !//////////////!
            !/Nonexistent//!  |  |     !/Nonexistent//!
            !////memory////!  |  |     !////memory////!
            !//////////////!  |  |     !//////////////!
            !--------------!  |  |     !--------------!
            !    JMP   ----!--|  |     ! SDOS /       !
            !          <-----|   |     !     /        !
            !--------------! |   |     !    /  I/O    !
            !              ! |   |     !   /   PAK    !
            !              ! |   |     !  /           !
            !              ! |   |     ! /            !
            !     User     ! |   |     !--------------!
            !    Program,  ! |   |     !//////////////!
            !     Stack,   ! |   |     !/////Unused///!
            !      Etc.    ! |   |     !//////////////!
            !              ! |   |     !--------------!
            !              ! |   |     !              !
            !              ! |   |     !   Timeshare  !
            !              ! |   |     !     Logic    !
            !              ! |   |     !              !
            !              ! |   |     !              !
            !              ! |   |-----!---->         !
            !--------------! |         !--------------!
       :FB  !     JMP   <--!--     :FB !              !
            !--------------!           !--------------!
            !   Page Zero  !           !   Page Zero  !
            !______________!           !______________!



.ll 65
.pw 85
.sp
User/System Common memory is shared by all memory banks. Contains routines
to copy from system to user space, from user to system space, to turn on
user space, and to accept an interrupt and process it properly.

.ll 65
.pw 85
.pa
Assumptions about environment for SDOS/MT:
.sp
.in 3
.un 3
1.~1 to 16 users, max.
.br
.un 3
2.~Users mostly in terminal I/O state (usually input)
.br
.un 3
3.~Inputs take approx. 3-10 secs., min.?
.br
.un 3
4.~Output bursts are short (<=1 screen/page)
.br
.un 3
5.~Disk I/O is minimal; only used to fetch/update data in files
.br
.un 3
6.~Disk I/O is fast, so that disk transactions to files do not have to be
timeshared.
.in 0
.sp
IMPLICATIONS!!
.sp
.in 4
.un 4
==>~Users not computebound except short bursts
.br
.un 4
==>~Truly compute-bound users can be serviced after all I/O users need no
service.
.br
.un 4
==>~Program loads, giant reads/writes to files will take a long time (can be
kept under a few seconds with fast enough disk).
.br
.un 4
==>~Lotsa character I/O (i.e., LIST longfile.LPT to CONSOLE: is rare. ***HOW
DO 1-6 ==> this?
.br
This is important!! because CPU takes interrupt for each output character,
so they use up a lotta time at 9600 baud.
.br
(This assumption probably violated by system LPT port).
.sp
.in 0
.sh SECTION __: CARE AND FEEDING OF SDOS/MT
.sp
.in 3
.un 3
1.~/MT doc should note how to set up DO file like on MSI (split DO file)
.br
.un 3
2.~Include FIX.BAS as example of how to manufacture procedure file
.br
.un 3
3.~Mod doc to note that /MT user 0 can change def disk.
.sp
.in 0
.pa
The Care and Feeding of SDOS/MT and SDOS/ES
.ix SDOS/MT Care
.ix SDOS/MT Feeding
.sp 2
.tc
INTRODUCTION
.ix SDOS/ES
.ix Multi-address Space Environments
.sp
The purpose of this section is to guide the installer of SDOS/ES and
SDOS/MT. Other than being limited to a single-user, SDOS/ES is identical to
SDOS/MT (unless otherwise noted, all references to /MT also refer to /ES.).
It covers the SDOS/MT Primitives, which enable SDOS/MT to execute in a wide
variety of multi-address~space environments, and the installation of those
primitives in the I/O package. A sample set of MT primitives is provided.
Included also, are sections on initiating SDOS/MT, and the differences
between SDOS and SDOS/MT.
.sp 2
.tc
MINIMUM CONFIGURATION REQUIREMENTS
.ix VT Driver Components
.ix Userspace Required for /MT
.ix File System
.ix User Interaction
.ix CONSOLE:
.IX PORT1:
.IX PORT6:
.sp
SDOS/MT requires a 6800/6809 system capable of running a single-user SDOS
which includes the File System and VT Driver components.  The SDOS must
provide a userspace of at least :4000 (:3000) in which to run /MT (/ES).
In addition, the system must be able to access at least one, and up to
sixteen, (two for /ES) additional address spaces of at least 24K bytes each
(all address spaces need not be the same size; more than seventeen address
spaces may exist, but will not be used).  For each additional address space
to be used, there must be a VT Driver device suitable for user interaction.
The VT Driver devices must be named CONSOLE:, and PORT1: (/MT only) through
PORT15: (/MT only).  SDOS/ES only supports one foreground user and one
background user.
.sp 2
.tc
SDOS/MT PRIMITIVES
.ix SDOS/MT Primitives
.ix SDOS/MT Hardware Support
.sp
SDOS/MT requires that the hardware support some form of address space
management.  Since the particular implementation of address space management
varies widely from system to system, SDOS/MT requires the following
primitive routines to interface to the address space management hardware.
.ix SDOS/MT System Space
.ix SDOS/MT Logic
.ix SDOS/MT Interrupt Routines
.sp
SDOS/MT lives in an address space known as the "system" space.  This space
holds SDOS, the timesharing logic, and all of the interrupt routines (this
address space can be used to run small user programs before timesharing is
initiated).
.ix SDOS/MT User Programs
.sp
In timesharing mode, user programs are run in separate address spaces, known
as "user" spaces.
.sp
.ix SDOS/MT Support Routines
The support routines described here must be accessible when the system space
is enabled.  This is generally done by placing these routines in an area
which is common to all address spaces  (to give user programs as much room
as possible, this common memory must have as high an address as possible.)
.sp
.ix SDOS/MT I/O Package
.ix /MT Primitives Table
.ix SDOS/MT JMP Instructions
.ix CC:SETTIMESHARE Syscall
.ix VT Driver
.ix SC:RDBUF
.pa
The I/O package must contain a table called the /MT primitives table, which
specifies the location of these routines (see the section on I/O Package
Interface, below, and also Appendix A), and some miscellaneous data. The
table contains a list of (long) JMP instructions to the routines, in the
order specified by this document.  An entry in the SDOS configuration table
points to this jump table. An CC:SETTIMESHARE Syscall, directed at the VT
driver, will copy this table from the I/O package to a location specified by
the SC:RDBUF; typically this buffer points into an area set up by /MT. In
this way, /MT dynamically establishes a connection to the primitive
routines.
.sp
.ix Y Register
.ix Scratchpad Location
.ix TEMPX
Unless otherwise specified, these routines may destroy any register (except
DP, which is zero if called by /MT).  On the 6800 or 6801, the "Y" register
is the scratchpad location named TEMPX in the SDOS definitions file.
.sp 2
.tc
MT:ABORTQUANTUM
.ix MT:ABORTQUANTUM
.sp
.ix MT:SETQUANTUM
.ix VT Driver
This subroutine is called to "abort" a quantum.  If "minimum quantum" clock
ticks have elapsed since the last MT:SETQUANTUM call, then this user's  time
slice should be aborted (his remaining slice set zero or negative); if not,
the time slice should be set to a value equal to the remainder of a minimum
quantum.  The portion of the qquantum lost to the current user should be saved
so that MT:GETQUANTUM can return that value when called.  A jump to this
routine must be placed immediately preceding the
beginning of the primitives table.  This routine is not called by /MT
proper, but rather by the VT driver.
.sp 2
.tc
MT:USERSPACESYSCALL
.ix MT:USERSPACESYSCALL
.ix User Stack
.ix User Stack Pointer
.ix User Space
.ix Interrupt Vector
.ix Interrupt Poll Chain
.ix System Task
.ix RETURNTOUSER
.IX MT:COPYTOUSER
.IX MT:USERCURRENTSIZE
.ix /MT Primitive Table Entry
.sp
This routine is passed control when the user program does a JSR SYSCALL$. 
It pushes the accumulators to complete a context block (started by the user
JSR) on the user's stack, preserves the user's stack pointer in location
$F1 in the user space, reloads the system task's stack pointer, turns on the
system space, re-aims the interrupt vector at the interrupt poll chain in
the system space, loads the amount of remaining time in user's quantum into
(A), and passes control to the system task by performing a RTS (note that
DPR must be zero!). The pushed context block need contain only the value in
X, and a condition code byte with interrupts enabled and carry zeroed (for
the 6809, the DPR must be preserved); other "pushed" registers may be
garbage. The system task, on obtaining control, will service the system
call, and return control (perhaps after a very long time) to the user task
via RETURNTOUSER. /MT sets up the user space (by using MT:COPYTOUSER) to
pass control to MT:USERSPACESYSCALL by copying the /MT primitive table
entry to the top three bytes of the user space (as specified by
MT:USERCURRENTSIZE) and planting a JMP in user $FB to these top three bytes.
.pa
.tc
MT:USERSELECT
.ix MT:USERSELECT
.ix /MT Primitives
.ix User Last Selected
.ix Illegal Userspace
.ix MT:RETURNTOUSER
.IX MT:COPYTOUSER
.IX MT:COPYFROMUSER
.sp
This routine is called infrequently to switch the focus of attention from
one user (space) to another.  It precomputes whatever values are needed by
the other /MT primitives to keep them fast. Called with (A) = user number
(from 0 to :11, with 0 reserved to refer to the system bank); this establishes
the "user last selected". Sets up user space
to be selected/deselected. Does NOT enable user space. Returns carry set if
illegal userspace; otherwise, clear. Typically, /MT calls MT:USERSELECT
once for a particular user, then makes a call on MT:RETURNTOUSER and
then several calls on MT:COPYTO/FROM user before calling MT:USERSELECT
for a different user. This routine need not be in memory common to all
spaces.
.sp 2
.tc
MT:USERCURRENTSIZE
.ix MT:USERCURRENTSIZE
.ix Contiguous RAM Bytes Availabl
.ix User Space
.sp
Returns the current amount, in (A,B), of contiguous RAM bytes available
(starting at location 0) for the user last selected. The value returned,
+1, will be placed by /MT in the JMP at location $FB in the user space.
Different values may be returned for different users. /MT treats spaces
with less than 20kb as useless. This routine need not be in memory common to
all spaces.
.sp 2
.tc
MT:RETURNTOUSER
.ix MT:RETURNTOUSER
.ix User Program, Suspended
.ix Context Block
.ix Stack Pointer
.ix IRQ Vector
.ix TIMESLICEUP
.ix SETQUANTUM
.ix RTI
.sp
This routine passes control from the system task to a suspended user
program.  The user space must contain a context block and a saved stack
pointer (in $F1).  The routine saves the system task's stack pointer, sets
up IRQ vector so an interrupt occuring while in the user space passes
control to USERSPACEINTERRUPT, switches to the user space, fetches the
user's stack pointer, and does an RTI.  If this user's QUANTUM has expired
or was aborted, control is immediately passed back to SDOS/MT via the
TIMESLICEUP pointer set by SETQUANTUM, with (B) = number of clockticks over
quantum that this user got.
.sp 2
.tc
MT:SETQUANTUM
.ix MT:SETQUANTUM
.ix RETURNTOUSER
.IX USERRTI
.IX ABORTQUANTUM
.sp
This subroutine is called with (A) containing "quantum", the  number of
60ths of a second of execution a user program is allowed before being
suspended; (B) contains minimum quantum (always >= (A) ); (X) contains
address of place to JMP to when the time slice is expired. SETQUANTUM merely
saves these values for use in a place conveniently accessible by
RETURNTOUSER, USERRTI, and ABORTQUANTUM, and then returns immediately.
.sp
.ix I/O Package
The I/O package must decrement the quantum at each clock tick if it is
greater than -128. If the quantum is -128, it must not be changed.
.pa
.tc
MT:COPYTOSYSTEM
.ix MT:COPYTOSYSTEM
.ix Block Transfer Subroutine
.sp
A fast block transfer subroutine that copies a block of bytes from (X) in
the user space last selected to (Y) in the system space for (D) bytes. This
is typically a large routine because of the need for speed.
.sp 2
.tc
MT:COPYTOUSER
.ix MT:COPYTOUSER
.ix Block Transfer Subroutine
.sp
A fast block transfer subroutines that copies a block of bytes from (X) in
the system space to (Y) in the user space last selected for (D) bytes. This
is typically a large routine because of the need for speed.
.sp 2
.tc
MT:COPYUSERTODX
.ix MT:COPYUSERTODX
.IX TEMPX
.sp
A routine that copies the contents of the byte pair specified by the
contents of the X register from the address space of the user last selected,
to the D and the X registers.  Must not damage location TEMPX as specified
in SDOS definitions file.
.sp 2
.tc
MT:COPYATOUSER
.ix MT:COPYATOUSER
.sp
A subroutine that copies the contents of the A register, to the byte
specified by the contents of the X register in the address space of the
user last selected.
.sp 2
.tc
MT:COPYDTOUSER
.ix MT:COPYDTOUSER
.sp
A subroutine that copies the contents of the (A,B) register pair to the byte
pair specified by the contents of the X register in the address space of the
user last selected.
.sp 2
.tc
MT:COPYUSERTOA
.IX MT:COPYUSERTOA
.sp
A subroutine that copies the contents of the byte specified by the contents
of the X register from the address space of the user last selected, to the A
register.
.sp 2
.tc
MT:SETFUSE
.IX MT:SETFUSE
.IX SDOS/MT Timer
.sp
This subroutine is used to establish a timer for SDOS/MT. The X register
contains a desired delay time in 60ths of a second. The delay must be saved
and control returned immediately.  This routine need not be in memory common
to all spaces.
.pa
.tc
MT:TESTFUSE
.ix MT:TESTFUSE
.IX SETFUSE
.IX Z Reset
.sp
This routine returns the Z bit set if the time specified by the last SETFUSE
has passed, else this routine returns Z reset. This routine need not be in
memory common to all spaces.
.sp 2
.tc
MT:CRASHINFO
.ix MT:CRASHINFO
.ix Crash Information
.ix RESET Logic
.ix Boot ROM
.sp
This is a pointer to an 8 byte buffer which contains crash information if
SDOS/MT decides to stop operation.  This area should be above $C000 (or it
will be zeroed by the RESET logic in the boot ROM after a crash), and is
zeroed by SDOS/MT when started.  AFTER A SYSTEM CRASH, THIS AREA SHOULD BE
INSPECTED FOR NON-ZERO VALUES: The first two bytes contain the identification
of the version/revision of SDOS/MT in use, the next two bytes contain an SDOS
error code specifying why SDOS/MT shut down the system, and the next two bytes
contain SDOS/MT internal error information about the source of the error.  If
the cause of the crash cannot be determined, this information should be
forwarded to Software Dynamics for analysis.
.sp 2
.tc
MT:IOQUANTUMTICKS
.ix MT:IOQUANTUMTICKS
.ix Clock Ticks
.ix I/O Bound Job
.ix Compute Bound Job
.sp
This byte holds the number of clock ticks that an I/O bound job may run
without being declared compute (CPU) bound, which lowers its priority.  I/O
bound jobs are always serviced before compute-bound jobs to keep system
throughput high.  /MT reads this byte once at start-up.  The smaller this
value is, the more responsive the system is, at the cost of increased
overhead.
.sp 2
.tc
MT:CPUQUANTUMTICKS
.ix MT:CPUQUANTUMTICKS
.ix Clock Ticks
.ix CPR Bound Job
.ix MT:ABORTQUANTUM
.sp
This byte holds the number of clock ticks given a CPU-bound job before the
CPU is given to another job.  An I/O bound job suddenly requiring CPU will
get it, even if a compute-bound job's quantum is not complete (see
MT:ABORTQUANTUM).
.sp 2
.tc
MT:GETQUANTUM
.SP
This routine returns the amount of time-slice overrun/underrun in (A) for the
current user.  An overrun returns a negative value.  The N or Z bit in the
processor's condition codes is set if the user's time slice is over (i.e., has
used up the allocated quantum or has been aborted).
.pa
.ix /MT Primitives
.cp 25
The following routines are required, but are not included in the /MT
primitives table:
.sp 2
.tc
USERSPACEINTERRUPT
.ix USERSPACEINTERRUPT
.ix User Space
.ix User Stack Pointer
.ix Interrupt Vector
.ix Interrupt Poll Chain
.ix Context Block
.ix USERRTI
.ix FIRQ Context Block
.sp
This routine is the first recipient of an interrupt while running in a user
space.  Its purpose is to save the user's stack pointer in user space $F1,
re-aim the interrupt vector at the system space interrupt poll
chain, to switch in the system space, and pass control to the interrupt
poll chain in the system space. It sets up a dummy context block so that
when the system space interrupt code executes an RTI, control is passed to
USERRTI. NOTE: A FIRQ context block cannot be used for this purpose.
.sp 2
.tc
USERRTI
.ix Interrupted User Program
.ix IRQ Vector
.ix USERRTI
.IX USERSPACEINTERRUPT
.IX SETQUANTUM
.IX RETURNUSER
.sp
This routine returns control to an interrupted user program. It sets up the
IRQ vector to pass control to USERSPACEINTERRUPT routine; enables the user
space, loads the user's saved stack pointer from user space $F1, and does
an RTI. Before passing control to the user, USERRTI checks the quantum
remaining; if the remaining quantum <= 0, instead of passing control to the
user, control is passed to the location specified by the X register when
SETQUANTUM was called with (S) set to the value at entry to RETURNUSER
(note that the DP register must be zero here).
.SP 2
CLOCKTICKED
.tc
.sp
.ix CLOCKTICKED
.ix USERRTI
.ix SDOS:CLOCKTICKED
.ix I/O Package
This routine is responsible for decrementing a user's remaining quantum
(which eventually forces USERRTI to exit to /MT instead of the user). It is
typically a replacement for "SDOS:CLOCKTICKED" in a single-user SDOS I/O
package, and simply passes control to SDOS:CLOCKTICKED when it is done.
.pa
.tc
I/O PACKAGE INTERFACE
.ix I/O Package Interface
.ix Boot ROM Configuration
.sp
The boot ROM must be configured as specified in the section on the BOOT ROM.
.sp
.ix I/O Package
.ix SDOS/MT PRIMITIVES
.ix VT Driver
.ix CC:SETTIMESHARE
.ix CNFG:MTPRIMS
.ix RDBUF
The following table must be included in the I/O package, and reference the
routines described in SDOS/MT Primitives, above.  When /MT calls the VT
Driver with a CC:SETTIMESHARE control call, this table is returned in
the RDBUF.  The configuration table references this table with the
CNFG:MTPRIMS entry (see also Appendix A for Sample SDOS/MT Primitives).
.sp 2
.pw 120
.ll 100
.im 19
            JMP    ABORTQUANTUM
MTPRIMS     FDB    SIZEMTPRIMS         number of bytes in table, below
            JMP    USERSPACESYSCALL    where the user goes for SYSCALLs
            JMP    USERSELECT          select a user space
            JMP    USERCURRENTSIZE     get size of user space
            JMP    RETURNTOUSER        return to selected user space
            JMP    SETQUANTUM          set quantum for selected user
            JMP    COPYTOSYSTEM        copy from user to system space
            JMP    COPYTOUSER          copy from system to user space
            JMP    COPYUSERTODX        get two bytes from user space
            JMP    COPYATOUSER         copy (A) to user space
            JMP    COPYDTOUSER         copy (D) to user space
            JMP    COPYUSERTOA         copy from user space to (A)
            JMP    SETFUSE             set time delay fuse
            JMP    TESTFUSE            check time delay fuse expired
            FDB    CRASHINFO           where to store crash information
            FCB    IOQUANTUMTICKS      time slice for I/O bound jobs
            FCB    CPUQUANTUMTICKS     time slice for CPU bound jobs
SIZEMTPRIMS EQU    *-MTPRIMS-2
.ll 65
.pw 85
.sp 2
.ix USERSPACEINTERRUPT
.IX USERRTI
.ix I/O Package
In addition to the above table, the routines USERSPACEINTERRUPT and USERRTI
must also be provided in the I/O package.
.sp
.ix DCB
.ix VT Devices
.ix CONSOLE:
.IX PORT1:
.IX PORTn:
.ix PORT6:
.IX Bank Selct Routine
.ix SYSCALL:JOBCONTROL
.ix I/O Package
.ix Single-User SDOS
.ix Bootable Single-User System
.ix Minimum User Space
DCBs for VT devices named CONSOLE: and PORT1: through PORTn: must be
provided, where n must be less than or equal to 15. These VT devices will be
used for user consoles.  The bank select routines may provide up to 8 total
banks; if there are more banks than user consoles, they will be set up as
"free" jobs (see SYSCALL:JOBCONTROL).  The completed I/O package must be
attached to a single-user SDOS to make a bootable single-user system with
:5000 minimum user space.
.pa
.tc
INITIATING SDOS/MT
.ix Initiating SDOS/MT
.sp
After SDOS has been booted, the time set, and the desired default disk has
been selected, invoke SDOS/MT by typing
.sp
.im 1
     SDOSMT
.sp
after which
.sp
.im 1
     SDOS/MT Version 1.2xx, Copyright (C) 1980 Software Dynamics
.sp
.ix INITIALIZE.DO
.ix SET Program
.ix Virtual Terminal Device
.ix Boot Time
is displayed, and SDOS/MT is in service (SDOS/MT can also be initialized by
invoking it from the INITIALIZE.DO file, following the invocation of the SET
program for each virtual terminal device having characteristics different
from the system default characteristics for that terminal device.  The
INITIALIZE.DO file is performed as a DO file at boot time.)
.sp 2
.tc
DIFFERENCES AND OTHER CAVEATS
.ix SDOS/MT Differences
.sp
The following are differences between Single-User SDOS and SDOS/MT:
.sp
.ix Byte Transfer Limit
.ix RDBUF
.ix WRBUF
.ix READA
.ix READB
.ix WRITEA
.ix WRITEB
.ix RDLEN
.in 2
256 byte transfer limit on syscall RDBUF's and WRBUF's, except READA, READB,
WRITEA, and WRITEB.  (RDLEN may actually be larger than 256 bytes, as long as
the syscall will not transfer more than 256 bytes.)
.sp
Syscalls not supported by SDOS/MT:
.sp
.ix SYSCALL:DEFAULTDISK
.IX SYSCALL:DEBUG
.im 2
     SYSCALL:DEFAULTDISK
     SYSCALL:DEBUG
.sp
Syscalls supported only by SDOS/MT (see Appendix B):
.sp
.pw 120
.ll 100
.ix SYSCALL:INTERLOCK
.IX SYSCALL:JOBCONTROL
.im 3
     SYSCALL:INTERLOCK  (Single user SDOS simply treats this as
                        a null operation)
                         # lock ops applied to a single object <128
.sp
.ll 65
.pw 85
Number of different interlock objects locked at any instant <=16.
No deadlock detection. ^C^C takes user out of wait on lock. Does not remove
user's locked objects.
.sp
.im 1
     SYSCALL:JOBCONTROL (used to run background jobs)
.ll 65
.pw 85
.pa
LOGOFF program
.ix LOGOFF Program
.sp
.ix DISK:LOGOFF
.ix Initiating SDOS/MT
.IX DEFAULTPROGRAM
.in 5
If a program named DISK:LOGOFF exists, then control is passed to that
program, upon initiating SDOS/MT, rather than to DEFAULTPROGRAM. The purpose
of LOGOFF is to enable an installation to restrict or otherwise modify usage
of SDOS/M