.CE
SDNET (TM) PROVIDES DISTRIBUTED PROCESSING FOR MICROS
.BL 1
SDNET, an option for SDOS-based 6800/6809 microcomputer systems, allows independent
microprocessor systems to share facilities, such as peripherals, data bases and
software, or to work collectively toward a common goal.
.BL 1
Traditional microcomputer systems have a single microprocessor dedicated to
performing a single task, on a small database,  in one set of hardware.  As data bases grow, the cost of
the peripherals begins to dominate the price of the computer system, and it becomes
economically attractive to "time-share" the computer among several users.  
.bl 1
There are a number of difficulties with this approach.
Most currently available microprocessors bog down under the load of even a
few users, and so system response becomes sluggish and the users become annoyed.
Secondly, if an application requires a large percentage of a processor's attention,
only one user may effectively use the computer.  Third, time-sharing systems are
generally not good solutions where the realtime response of the application program
must be very good, as in process control or data acquisition.
Fourth, timesharing is somewhat like placing all of one's eggs in one basket, from a
reliability point of view -- if the cpu stops, so do all of the applications.
Lastly, purchase of a timesharing system requires relatively large chunks of the
system to be acquired for each increment of growth needed.
.BL 1
"Network" computer systems provide solutions to many of these problems.  A network
allows multiple computers to communicate with one another. 
The computers in the network exchange messages when they need one another's services;
otherwise, each computer continues to act on an individual basis.
.bl 1
Use of a network allows use of several computers to solve a (set of) problem(s),
thus dividing up the computational load between the computers.  This means each individual
computer has less work to do, and so it will not become overloaded as easily as a
timesharing system.
.bl 1
Also, use of multiple computers allows the dedication of any of them to perform a
computationally expensive task without affecting any of the others.  This also allows
dedication of a single processor to problems that have stringent real-time
constraints.
.bl 1
With a network, if one computer fails, only the activity being performed by that
computer need be lost.
.bl 1
Networks can expand easily; as more computational power is needed, another computer
can be added; if more peripherals or database store is needed, it can be attached to any
computer in the network capable of handling them, or attached to a new computer, if
needed.  Thus, expansion of a network system can be done in smaller chunks
than with timesharing.
.BL 1
Network systems can
be as simple as RS232 links with no high level software support, or as sophisticated
as ARPANET, DOD's Advanced Networking project that ties together hundreds of computers,
geographically distributed around the world.
.bl 1
SDNET provides a solution midway between these strategies.  SDNET ties together up to
255 local computers via a twisted wire pair (other communication mediums
may be used).  Data rates of 125 Kb/sec are used.  The message protocol used over
this link is Ethernet-like; messages are broken into varying length chunks called
"packets".  Each packet contains a destination computer number, a source computer
number, some message control information, the actual message contents, and error-checking
information.  SDNET handles all errors that occur on the communications link, due to
noise, message "collisions", etc., to ensure that a logically error-free stream of data
is established between any two computers.
.BL 1
All computers in the network may transmit via this data link; 
all computers listen to the link.  A distributed
strategy is used to resolve the case where many computers attempt to transmit
simultaneously.
.BL 1
The messages are used by the computers to request other computers to perform functions
on the originating computer's behalf (operation by cooperation).  Such functions
include "OPEN file", "Read record", etc.
.BL 1
The SDNET software
in each computer allows up to 255 logical, full duplex pipelines to be established.
Each pipeline is represented in a particular computer by a local "socket" number.
Pipelines can be established from a socket in a particular computer to any socket 
in any (other) computer.  Once established,
the pipelines may be used to effect inter-task communication.  Multiple tasks and
pipelines may be configured any way desired to effect an application.  SDNET uses
some of the pipelines to establish the connections, to locate resources, to
perform file I/O to remote files, and to perform sundry other functions.
.BL 1
Each computer establishes a low-level logical pipeline (via the physical link)
to other computers with which it desires to communicate.
This low level logical pipeline is multiplexed by SDNET to handle higher level
logical socket pipelines to other computers.
.BL 1
Remote file I/O is handled automatically by SDOS; files or devices which are not 
found locally are given to SDNET for opening.  Once open, all network operations
to implement file I/O to the remote file are totally transparent to the local task.
This allows a large common data base to be accessed by many computers.
.BL 1
Since remote file I/O is completely transparant, applications which operate on a
single user SDOS system will operate unchanged under SDNET.  All the system
utility programs under SDNET are likewise identical to those under single-user
SDOS.
This allows incremental growth. A customer may start with a single-user, 
single-computer system; as he
needs more disk capacity, he may add it; more terminals, he may tie another
computer with one or more terminals and tie them together with SDNET.  This is especially
convenient when the computer and terminal are combined into a single unit, like the
Pace 480, or the WaveMate Series 2000.
.BL 1
By adding another computer system for each user, the complete system does not bog
down due to a lack of computing resources.  (Of course, if each added computer can
handle several users/jobs, then SDOS/MT, SD's timesharing system, can be installed on
the computer, along with the SDNET option).
.BL 1
By distributing the database over the various computers in the network, reliability
can be significantly enhanced.  Failure of a node in the network makes only that
node's part of the database unavailable; the rest of the database is still accessible
and local computing resources are still available to each user because he has his
own computer.  Since SDNET has no  master computer, no computer failure can stop the entire system.
.BL 1
Interfacing to a foreign host computer is handled by designating one node as a foreign
host interface; a dedicated task in that node retranslates network requests into
messages compatible with the host and then passes them to the host.  The foreign host interface
task also performs functions on the network as required by the host.
.BL 1
Computers with no mass storage of their own can be downloaded by computers with
mass storage.  This allows "computing only" nodes, or nodes that are to serve as
controllers from some special device.
.BL 1
SDNET configurations allow as few as 2 computers, and as many as 255 computers to
share resources.  Since each computer could be running SDOS/MT, up to 1600 users could
theoretically be serviced.
.BL 1
Each computer may have a complete complement of peripherals (disk, printer, CRT), or
may be very specialized and drive only a simple controller.
.BL 1
A full SDNET node requires 56-60K bytes of RAM, disk, CRT and keyboard.  Controller
nodes require roughly 4k of EPROM and 8K of RAM for the SDNET interface software.
.BL 1
SDNET requires an error free link with broadcast capabilities in order to operate.
SD offers an RS232 "star" version, good for up to 8 computers, for those
environments requiring low cost with low performance.  SD also offers a 125Kb/sec
interface using twisted pair with parallel taps, suitable for tying 64 computers
together; a repeater option allows 256 computers to be tied together.  The repeater
also allows tree-structured networks to be built.  Both of these hardware designs
are available for licensing.
.BL 1
Other hardware designs can be integrated but require new low-level network drivers
to be custom-built and installed.
.BL 1
Application areas include: general "timesharing", distributed data base, inquiry, data
collection as a front end to a larger host computer, and distributed industrial or
laboratory control.
.bl 1
All of these application areas may be mixed on one network.
.bl 1
Future potentials include: Geographically distributed computers via a Foreign
host interface driving X.25 protocols, and SDNET options for 68120, which
would allow 68000 microprocessors to participate in SDNET.
.BL 1
Initial deliveries are targeted for second quarter, 1981.
.bl 2
(C111380)
