.cd
.br
SDNET USER'S MANUAL
.pa 1
.he SDNET USER'S MANUAL
.sh SECTION __: SDNET FOR CP/M 3.0
.il Copyright (C) 1983
.ir Software Dynamics
The contents of this document are proprietary property of Software Dynamics.
.sp
CP/M and MP/M are trademarks of Digital Research, Inc.
.SP
.TC
1. SDNET -- GENERAL
.sp
.IX SDNET/80
.IX SDNET/80
.ix 8085/Z80
.IX 8086/8088
.ix SDNET/86
.ix Task-To-Task
SDNET/80 and SDNET/86 are implementations of Software Dynamics' SDNET for
8085/Z80 and 8086/8088 processors running CP/M-80 and CP/M-86 respectively
(references to SDNET/80 throughout this document also refer to SDNET/86
except where explicitly noted).  Significant features include the
task-to-task remote interprocess communication facility standard with SDNET,
and a remote CP/M BDOS call network server.  This document assumes
familiarity on the part of the reader with CP/M.
.sp
.ix BDOS Call Network Server
.ix Net Server
.ix Device Name Assignment
.ix Remote Device
.ix MP/M Compatible Record Locking
.ix Spool Output
.ix Verify Access
.ix Failure
The remote CP/M BDOS call network server (referred to in the rest of the
document as "the net server") allows execution of CP/M BDOS calls intended
for files or devices on a machine remote from the point of execution in a
manner transparent to the application. Applications using any non-standard
BDOS calls or direct BIOS calls may fail when used with the net software.
Special CP/M support includes assignment of device names to remote devices,
MP/M compatible record locking, spooled output to a remote printer, and
remote physical disk BDOS calls.  The server also provides mechanisms for
verifying that access from a remote node is allowed to this node. The CP/M
BDOS net server is really just a particular SDNET service class, similar to
the SDOS net server.
.sp
.ix Large Disk Drive
.ix Unauthorized Access
Thus, SDNET allows multiple computers to share resources, such as printers,
databases, and large disk drives conveniently. Unauthorized access to
resources can be prohibited on a per-node, per-person, or per-password
basis.
.sp
.ix Node Mix
SDNET/80 runs under CP/M 3.0, banked version.  SDNET/86 runs under CPM/86. 
Networks may contain a mix of nodes running SDNET/80 and SDNET/86.
.sp
.ix Network User
.ix Network Server
SDNET/80 requires that computing nodes be divided into two types: Network
users, and network servers (an MPM node may be both simultaneously; CP/M
nodes may be either one at different times).
.sp
.ix Network User Node
.ix Logical Device Name
Network user nodes run completely standalone (make no use of remote
resources), or run with some assignment of logical device names to devices
in specified remote network server nodes. A network user node cannot use
resources at another node which is operating only as a network user.
.pa
1.5 Wish List -- Things that would be nice if SDNET can do (No gaurantees)
.sp
SDNET-80 under CP/M 3.0 allows a node to be both a network server and run
applications.  It does this by reserving the TPA for use by the application,
and running the NETSERVER program in a seperate bank of memory.  In this
configuration, a small portion (about 200 bytes) of the TPA is reserved for
use by NETSERVER; this reservation is transparent to the application
program.  Nodes that run applications while acting as a network server are
likely to see somewhat degraded performance at the application, due to
parallel handling of network traffic.  Applications which are not speed
sensitive still operate reasonably well.
.sp
.ix Automatic Download
Network user nodes need not have any disk drives.  In this circumstance,
CP/M 3.0 is downloaded from another network server node automatically at
power up.
.sp
.ix NETCOMM Software
.ix ROM Resident Software
.ix RAM Resident Software
.ix Host Computer
The NETCOMM software in the comm boards has two parts: a ROM resident
portion, and a RAM resident portion.  The ROM resident portion exists merely
to load the RAM resident portion, and will load it either from the host
computer, or over the network.
.sp
AREAS NEEDING POLISHING
.sp
Consider Minimal COMM ROM that yells for Help, downloads real comm software.
Also consider multiple jobs running under CP/M 3.0 that feed BDOS calls to
file server --> cheap MP/M replacement. Consider VT driver. Let NETSERVER
run in alternate bank to allow application program to run with it ? (yes!)
.sp
???If we run multiple copies of CP/M, and user use alt bank, also saves alt
register set??????????
.pa
.TC
2. USAGE
.sp
.ix Usage
.ix Processor Node
.ix Network Server
.ix Network User
.ix Winchester Disk
.ix Printer
.ix Application Processor
To use SDNET, one needs a network with at least two processor nodes in it,
one acting as a "network server", and one acting as a "network user".  The
network server is intended to provide access to the resources attached to
the node in which it is running; typically, this node will have a Winchester
disk and a printer (either high-speed or letter-quality), which are the
resources to be shared.  The network user node is intended to be an
applications processor, i.e., it runs a program
.ix Specific Task
.ix Database Shared
.ix Manufacturer-Specific Electronics
whose purpose in life is to accomplish some very specific task, like
inventory management, payroll, etc. The network user node will generally
need access to a shared database, to a fast printer, or to a letter quality
printer. All nodes attached to the network require manufacturer-specific,
network interface electronics to attach to a network bus that connects all
nodes together.
.sp
.ix Application Program
.ix NETASSIGN
.ix Logical Device
.ix Disk Name
.ix Real Device
.ix Arbitrary Net Server Node
.ix Access
SDNET provides totally transparent access to remote files and devices. 
Application programs that run without remote access can ignore the existence
of SDNET.  No modifications to the application programs are needed to run
with SDNET. However, those devices which an application program will need,
that must be remote, must be specified to SDNET before execution of the
application commences.   This is accomplished with the NETASSIGN command.  
NETASSIGN allows a user to specify what logical device and disk names are to
be assigned to which real devices at arbitrary net server nodes.  NETASSIGN
notifies the network server responsible for sharing the remote device that
this net user node desires access; access may be denied unless an
appropriate identification is presented by the user.  Once NETASSIGN is
complete, the application may be invoked.
.sp
.ix Application
.ix BDOS
.ix File I/O
.ix Device I/O
.ix NETBDOSTRAP
.ix Remote Device
.ix NETBDOSEXEC
.ix Net Server
As the application runs, it issues various BDOS calls for file and device
I/O.  The NETBDOSTRAP module inspects each BDOS call so issued to determine
if that call refers to a remote device.  If not, CP/M is allowed to process
the call. If so, then the request is diverted to NETBDOSEXEC for packaging
and mailing to the net server node appropriate for that remote resoure. 
Eventually, the net server node receives the request, processes it, and
mails back the appropriate reply, which is returned to the user by the
NETBDOSEXEC module.
.sp
<much more needed here>
.pa
3. COMPONENTS
.ix Components
.sp
The components of SDNET/80 are:
.sp
.in 13
.un 13
.ix NETLINKDRVR
.ix Network Communication
.ix Network Node
NETLINKDRVR~~Network Link Driver.  Establishes reliable link between a
network node and other network nodes.
.sp
.un 13
.ix NETSOCKETMGR
.ix Socket Manager
.ix Interprocess Communication
.ix NETLINKDRVR
NETSOCKETMGR~Socket manager.  Handles interprocess communication between
tasks in different network nodes. Uses NETLINKDRVR for support.
.sp
.un 13
.ix NETSERVER
.ix Application Program
.ix Transient Program Area
.ix BDOS
NETSERVER~~~~Runs as application program in Transient Program Area in a
network server node. Processes received remote BDOS calls.
.sp
.un 13
.ix NETSERVINTF
.ix NETSOCKETMGR
.ix NETSERVER
.ix System Space
.ix User Space
NETSERVINTF~~Interfaces NETSOCKETMGR module in system space to NETSERVER
module in user space.
.sp
.un 13
.ix NETBDOSTRAP
.ix BDOS
.ix Application Program
.ix Remote Device
.ix NETBDOSINTF
.IX Transient Program Area
NETBDOSTRAP~~Traps BDOS calls from application program, and diverts those
intended for a remote device to NETBDOSINTF. NETBDOSTRAP lives in the
Transient Program area above the application.
.sp
.un 13
.ix NETBDOSEXEC
.ix Remote Device
.ix Remote Host
.ix NETSOCKETMANAGER
NETBDOSEXEC~~Takes diverted BDOS calls for remote devices, and packages them
for shipment to the appropriate remote host via NETSOCKETMANAGER.  Also
returns results to user.
.sp
.un 13
.ix NETASSIGN
.ix Application Program
.ix Logical Device Name
.ix Validate Access
.ix User Identification
NETASSIGN~~~~Application program that allows user to assign local logical
device names to remote devices. Collects user identification if needed to
validate access to remote resources.  Also used to break remote connections
and give up access rights.  Performs miscellaneous administrative functions,
such as logging onto the net and displaying network statistics.
.sp
.un 13
.ix SDOSRT
.IX Multi-Task Scheduler
.ix NETSERVER
.IX NETSOCKETMGR
.IX NETLINKDRVR
SDOSRT~~~~~~~Multi-task scheduler used by NETSERVER, NETSOCKETMGR and
NETLINKDRVR modules.  Runs CP/M as a task.
.pa
.ix Overview
.un 13
OVERVIEW
.sp
.un 13
.ix NETBDOSTRAP
.ix Application Program
.ix BDOS
.ix CP/M Local Operating System
.ix NETBDOSEXEC
NETBDOSTRAP~~Gains control whenever an application program issues a CP/M
BDOS call.  NETBDOSTRAP inspects the call, and determines if it can be
handled by the local CP/M operating system.  If so, NETBDOSTRAP simply
passes the call to CP/M.  Otherwise, NETBDOSTRAP passes control to
NETBDOSEXEC (in another bank).  NETBDOSEXEC causes the BDOS call to be
executed remotely, and eventually, returns control to NETBDOSTRAP, with the
appropriate "CP/M" result.  NETBDOSTRAP then returns control to the
application program.
.sp
.un 13
.ix NETBDOSEXEC
.ix Parameter
.ix Net Server
.ix NETASSIGN
.ix Socket
.ix NETSERVER
.ix User Space
.ix NETBDOSTRAP
.ix Socket Connection
NETBDOSEXEC~~Performs whatever action is necessary to effect the network
BDOS call.  Sometimes this is as simple as simply recording a parameter from
the BDOS call (as in SETDMA address), but it usually requires that
NETBDOSEXEC determine which remote net server must handle the request (which
it can do by inspecting tables set up by NETASSIGN), package up the request,
and send it to the CP/M service at the remote node.  This is done via a
"socket" (a bi-directional pipeline) which is connected to NETSERVER in the
remote node.  The NETSERVER pulls the packaged request out of the pipeline,
processes it by executing the appropriate CP/M calls locally (to NETSERVER),
determines, packages the result, and sends it back via the same socket to
NETBDOSEXEC.  NETBDOSEXEC returns the results to the user space, and returns
control to NETBDOSTRAP.  The socket connection is established (by
NETASSIGN?) when NETBDOSEXEC first discovers it must communicate with a node
for which it has no socket connection.
.in 0
.pa
Configuration Requirements:
.sp
.ix Configuration Requirement
.ix Network Communications Board
(Optional) Network communications board with onboard Z80/8085+4KbROM+4KbRAM,
128Kb CPU with 8085 or Z80 processor running CP/M 3.0.
.sp
Organization of the Software:
.ix Software Organization
.sp
.ix NETLINKDRVR
.ix Network Communications Board
.ix SDOSRT
.ix System Space
.ix NETSOCKETMGR
NETLINKDRVR resides in the Network communications board if present (and has
its own private copy of SDOSRT); if no Network Comm board, NETLINKDRVR
resides in the system space. The system space holds SDOSRT, and
NETSOCKETMGR. 
.ix NETBDOSEXEC
.ix TPA
.ix Resident System Extension
.ix NETSERVER
.ix User Program
.ix NETSERVERINTF
NETBDOSEXEC resides in the system space on nodes performing access to remote
resources (net users). NETBDOSTRAP resides in the TPA as a Resident System
Extension; it intercepts user BDOS calls, and deflects the ones necessary
for remote access to NETBDOSEXEC.  NETSERVER runs as a user program in the
TPA in network server nodes; unless a network server processor is running
MPM, it can only act as a network server.  NETSERVERINTF lives in the system
.ix NETASSIGN
.ix Transient Program Area
.ix Remote Resource Accessed
.ix Access Authorization
space and acts as an interface between NETSERVER and NETSOCKETMGR. NETASSIGN
runs as a user program in the Transient Program area, and is used by network
user nodes to specify which remote resources are to be accessed, and to
specify access authorizations.
.pa
IMPLEMENTATION
.ix Implementation
.sp
.ix Machine Dependent
.ix 8085 Instruction
.ix Special Macro
.ix Index Reference Code
.ix Special Z80 Instruction
.ix Index Register
.ix Destroyable Resoure
SDNET/80 is designed to work on an 8085 or a Z80. Part of SDNET80 is
coded in "C", to make it relatively machine independent. The machine
dependent part is a single (set of) source(s0 for both 8085 and Z80.
This is accomplished by sticking to 8085 instructions except where the Z80
has a clear advantage (witness block move!). Special macros allow coding of
indexed references, some specialized Z80 instructions (such as bit set and
clear), and certain extensions (such as double-byte load/string), even on
the 8085 (these macros are defined by the file SDZ80C.LIB and are included
with every assembly). This is accomplished by software convention: (DE) is
treated as an index register (i.e, Z80 IX), and (HL) is treated as a
destroyable resource. A set of macros allows loading/storing the index
.ix DE
.ix Conditional Assembly
.ix Scratchpad Area
.ix Fixed Address
.ix Direct Memory Reference
.ix Code Speed
register, incrementing the index register, and loading and storing one and
two byte entities using a signed offset.  Use of DE destroys IX and
vice-versa; doing an indexed load/store destroys HL. Z80 IY is not supported
except inside conditional assembly.  To simplify life for tasks, a special
scratchpad area at a fixed address is set aside; the scheduler ensures that
whatever a particular task stores in the scratchpad is always present in the
scratchpad when the task is running.  This allows use of direct memory
references, speeding up the code considerably.
.sp
.ix Code Convention
.ix Intel Mnemonics
.ix External Label
.ix Macro File
.ix RMAC
Coding Conventions are those of the Digital Research RMAC assembler. In
particular, 16 character labels (using $ as break character) and Intel
mnemonics.  External labels are limited to 6 characters by the linker. Z80
instructions, if used, are coded according to the conventions established in
the macro file Z80.LIB from Digital Research, for use with RMAC.
.sp
.pa
SDOSRT
.IX SDOSRT
.sp
.ix Real-Time Task
.ix Task Scheduler
.ix Multiple Tasks
.ix Processor Time Management
.ix Intertask Communication
.ix Task-to-Interrupt Communication
.ix Interval/Event Timing
.ix Address Space Management
SDOSRT is a real-time task scheduler used by SDNET to manage the multiple
tasks required.  It provides processor time and and address space
management, intertask communication facilities, task-to-interrupt and
interrupt-to-task communications, and interval/event timing facilities. It
is a subset of SDOS/RT, specialized for SDNET.
.sp
.ix CP/M Task
.ix User Application Program
.ix NETSERVER
.ix Server Node
One of the tasks run by SDOSRT under SDNET is termed the "CP/M task", and
runs CP/M plus the user application program.  On network server nodes, the
user application program is NETSERVER.
.sp
SDOS/RT provides the following facilities:
.ix SDOS/RT Facility
.sp
.in 4
.ix Priority Level
.un 3
1)~Scheduling of tasks with 256 different priority levels, using a
priority queue
.br
.un 3
2)~Round-robin scheduling of tasks with equal priorities
.br
.un 3
.ix Task Error Signal
.ix Propogation Facility
3)~Task error signal and propogation facilities
.br
.ix Task Initiation
.un 3
4)~Task initiation, freezing and/or deletion by other tasks
.br
.un 3
5)~Task wait for arbitrary boolean condition (via wakeup routines)
.ix Boolean Condition
.br
.un 3
6)~Event waiting and signalling
.ix Event Wait
.ix Event Signal
.br
.un 3
7)~Semaphore handling
.ix Semaphore
.br
.un 3
8)~Critical regions
.br
.un 3
9)~Task-to-interrupt routine signalling via Simulated Interrupt
.ix Task-to-Interrupt
.ix Simulate Interrupt
.br
.un 4
10)~Interrupt routine event posting/semaphore signalling
.br
.un 4
11)~Stack management for re-entrant routines
.ix Stack Management
.br
.un 4
12)~Dynamic interrupt device poll chain management
.br
.un 4
13)~Task-level wait until (delay) x clocks
.ix Task-Level Wait
.br
.un 4
14)~Event signalling on timer
.br
.un 4
15)~Timeout interrupts for interrupt routines
.ix Time Out Interrupt
.br
.un 4
16)~Priority interrupt handling with 250uS context switch
.in 0
.sp
.ix System Space
.ix Interrupt Routine
.ix Task Control Block
.ix Event Object
SDOS/RT lives in a distinguished address space, called the "system space".
The system space holds all interrupt routines, Task Control blocks and event
objects referenceable by SDOS/RT.
.sp
SCRATCHPAD Storage
.ix Scratchpad Storage
.ix RT$SPad+0
.ix RT$SPad+7
.ix Table Pointer
.ix Subroutine Address
.sp
To facilitate the construction of tasks sharing common code on a machine
which discourages use of indexing for stack-frame access of commonly used
variables, SDOSRT provides a set of 8 locations, RT$SPad+0 thru RT$SPad+7,
which are switched as part of each task's context.  Thus, pointers to tables
can be placed in the Scratchpad and passed to subroutines which manipulate
those tables; the subroutines can use the same addresses throughout for
working storage and yet still be assured that seperate, but parallel
executions of the same code are kept appropriately separated.
.in 0
.pa
ERROR PROPOGATION under SDOSRT
.ix Error Porpogation
.ix SDOS/RT
.ix Error Signal
.ix Task-Level Code
.ix Disaster Exit
.ix Error Code
.ix Runtime Stack
.ix Error Recovery Point
.ix Stack Pointer
.sp
SDOS/RT provides mechanisms to implement error signalling and propogation
throughout task-level code.  This ensures that all routines pass and handle
error signals correctly, and exit correctly in the face of disaster.  Error
codes are defined as 16 bit numbers, and are passed in register BC. It is
important that routines which do not handle errors should pay as little as
possible in terms of time and space to allow error handling by those
routines that do.  This causes complications when an error must be
propogated through a routine that pushes data onto the runtime stack; how
can such a context block be removed automatically by the error propogation
mechanism?  This problem is solved by use of Error Recovery points; a module
that wishes to catch errors in itself, or in modules called by it, must
establish an Error Recovery point. Such a point records the current value of
.ix Recovery Point
.ix RT$RTrp
the stack pointer, so when control is passed to the recovery point, the
stack may be reset to a known good value, thus removing all extraneous
information on the stack at the time of the error recovery.   A routine
establishing an error recovery point, must, of course, remove it before
exiting; this can be accomplished by calling RT$RTrp.
.pa
Example:
.sp
.pw 120
.ll 100
.im 34
FRED:   ...
        lxi     h,FREDmain             ; address of block to be error trapped
        call    RT$STrp                ; save error recovery PC on stack
FREDErrorTrap:                         ; control transfers to here if an error occurs
        ; check (BC) for recoverable errors
        lxi     h,-errorcode           ; check for "errorcode"
        dad     b
        mov     h,a
        ora     l
        jz      handleerrorcode        ; b/ match, go recover
        ...
        jmp     RT$PErr                ; can't handle, propogate err

handleerrorcode ; handle error code (BC)
        <test for can recover>
        jnz     RT$PErr                ; b/ can't recover (BC unchanged)
        <do logic to recover>
        lxi     h,Fred2                ; reinstantiate error recovery block
        call    RT$STrp
        jmp     FREDErrorTrap

FREDmain ; main body of FRED goes here
        ...
        call    SAM                    ; which might error
        ...
        <do test>
        lxi     b,errorcode            ; assume this error will happen
        jz      RT$SErr                ; signal error if bad condition
        ...
FRED2:  ; reenter here after recovering from error
        ...
        call    RT$RTrp                ; remove error handler
        ...
        ret

.ll 65
.pw 85
.pa
.ix Scratchpad Location Preserved
.ix RT$SPAD
.in 6
.un 6
NOTE:~Unless otherwise indicated, registers are not preserved by SDOSRT
routines.  Scratchpad locations (RT$SPAD) are always preserved.
.in 0
.in 10
.sp
.un 10
.ix RT$STrp
.ix CALL
.ix Error Recovery Routine
.ix Return Address
.ix RT$EStk
.ix Stack Pointer
.ix Save Value
.ix Set Trap
RT$STrp (Set Trap) handles Error Trap setup.  It is entered by CALL; the
return address points to the error recovery routine, and (HL) points to the
beginning of the block of code to be executed with an error trap set.  The
current value of RT$EStk is saved along with the address of the error
recovery routine, and then RT$EStk is set to the current value of the
processor's stack pointer. If an error occurs while in the error trapped
code, the machine stack pointer will be reset to the value it had just
before the Call to this routine, RT$EStk will be set to the saved value,
and then control will be passed to the error recovery routine coded in line
after the call RT$STrp instruction.The registers A, BC, DE, IX  and IY are
preserved.
.sp
.un 10
.ix RT$RTrp
.ix RT$STrp
.ix Error Recovery Point
.ix Remove Trap
RT$RTrp (Remove Trap) deletes an error trap context set by RT$STrp.  No
parameters are necessary.  RT$EStk is set back to the value it had at time
of entry to RT$STrp; thus, an error occurring after RT$RTrp is called will
be propogated to the "next higher level of error recovery", i.e., the most
recent error recovery point set that has not been cancelled by a call to
RT$RTrp. The registers A, BC, DE, IX  and IY are preserved. Note: the stack
must have the same value it had on exit from RT$STrp (i.e., it's clean).
.sp
.ix RT$SErr
.ix Signal Error
.ix JMP
.ix Error Code in BC
.ix Error Trap
.ix Stack Pointer
.ix RT$STrp
.un 10
RT$SErr (Signal Error) is entered by a JMP with a 16 bit error code in BC.
This causes control to be passed, with the error code in BC, to the most
recently established Error trap routine that has not been cancelled; the
stack pointer is reset to the value it had at entry to RT$STrp. Passing
control to an error trap routine also has the effect of cancelling the
error trap, so an error detected in an error trap routine will be passed to
a higher level error handler.
.sp
.un 10
RT$PErr (Propogate Error) is entered by a JMP from an error trap routine
that does not recognize the error code it found in BC. This has the effect
of passing control to a higher level error handler, and also cancels the
error trap set by the higher level error handler.  SDOSRT ensures that
there exists a highest-lever error trap routine for each task, so no
error can propogate forever (but when highest level routine catches
an error, it kills the task).
.pa
.un 10
.ix RT$BMov
.ix Block Move
.ix SDOS/RT
.ix Subroutine
.ix LDIR Instruction
.ix Location HL
.ix Location DE
.ix Location BC
.ix Source Area
.ix Destination Area
.ix BC Exit
.ix Source String
.ix Destination String
.ix Number of Bytes
RT$BMov (Block Move) is a standard subroutine that must be supplied for use
with SDOSRT to move a block of data bytes.  It is essentially a substitute
for the Z80 LDIR instruction, and makes it possible to code for both the
8085 and the Z80 in a convenient fashion.  It moves bytes from the location
specified by (HL) to the location specified by (DE) for (BC) bytes; the
number of bytes moved must be nonzero. The source and destination areas must
not overlap. Exits with (BC) zeroed; (HL) has been advanced past the source
string, and (DE) has been advanced past the destination string. This block
move operates on blocks in the current space. It destroys scratchpad
locations 4 and 5.
.sp
.un 10
.ix RT$IMov
.ix Interspace Block Move
.ix Block Transfer Data
.ix Scratchpad Location 4
.ix Scratchpad Location 5
.ix RT$BMov
RT$IMov (Interspace Block Move) is used to block transfer data from one bank
to another. It has the same parameters as RT$BMov, with the additional
requirement that scratchpad location 4 contain the logical bank number of
the source bank, and scratchpad location 5 contains the logical bank number
of the destination bank.
.sp
.un 10
.ix RT$BCmp
.ix Block Compare
.ix Subroutine
.ix Return Condition Code
.ix HL
.ix DE
.ix BC
RT$BCmp (Block Compare) is a standard subroutine of SDOSRT to compare two
strings of bytes.  (HL) points to the 1st string, (DE) points to the second,
(BC) contains a count less than 256 of the number of bytes to compare. 
Returned condition codes are Zero if strings match for (BC) bytes; Not zero
indicates the strings don't match, (BC) is the remaining count before end of
string, and (DE) and (HL) have been incremented just past the point where
the comparison failed.
.sp
.in 0
.pa
INTERRUPTS under SDOSRT
.ix Interrupt
.ix Nestabl Interrupt
.ix Priority Vectored Interrupt
.ix Simulated Interrup
.ix Task-to-Interrupt
.sp
SDOSRT provides for nestable, priority vectored interrupts and supports
all interrupt modes of the 8085 or Z80.  It also provides for signalling
from an interrupt routine to a task, and simulated interrupts for
communication from task to interrupt routine.
.sp
.ix Vectored Interrupt
.ix Vector Target
.ix Memory Bank
.ix SDOSRT
SDOSRT's model of the interrupt system assumes that vectored interrupts
are always used (each vector target may, however, poll to determine
the source of the interrupt at that level). Further, SDOSRT allows
each interrupt routine (and task) to run in any memory bank. Each
(vectored) interrupt routine must be coded according to certain
standards to ensure correct operation with SDOSRT.
.sp
.ix Interrupt
.ix Common Memory
.ix NMI Interrupt
.ix Vector Point
.ix Interrupt Routine
All interrupts must vector to locations in Common memory (memory
which is present no matter which bank is selected; this is consistent
with the design of CP/M).  Note that this common bank requirement makes Z80
NMI interrupts illegal.  At the vector point, the interrupt routine is
.ix Switch Memory Bank
.ix RT$Bank
expected to switch memory banks so that the body of the interrupt routine is
addressable, and then to pass control to the body of the interrupt routine. 
This method keeps the amount of code in the common area to a minimum.  When
exiting the interrupt routine, the bank that was active before the interrupt
(RT$Bank) must be re-enabled.
.sp
.ix RT$Bank
.ix 2-Byte Variable
.ix Logical Bank
.ix Application Task
.ix RT$Bank+1
.ix Physical Bank Select Code
.ix OUT
.ix BankSelect Hardware Register
RT$Bank is a global 2-byte variable.  RT$Bank+0 contains the logical
bank selected (ignored by SDOSRT, but used by some application tasks
like CP/M as @CBNK).  RT$Bank+1 contains the physical bank select
code, which is generally OUTed to a BankSelect hardware register to
switch to a specific bank.
.sp
.ix Nestable Interrupt
.ix Stack-Stingy
.ix CP/M Application Program
.ix RT$IPC
.ix Interrupted Activity Stack
.ix PC
.ix Stack Pointr
.ix HL
.ix Interrupt HL
Nestable interrupts are ensured by requiring each (vector) interrupt routine
to use its own private stack area for temporarily storing register context
from the interrupted activity (task or interrupt routine), and for its own
needs (pushes/calls, etc.).  To support stack-stingy CP/M application
programs, only minimal context may be pushed onto the interrupted activity's
stack; the hardware pushes the PC when the interrupt occurs, and the
interrupt (vector) routine saves this PC in RT$IPC before it pushes the PSW
onto the interrupted activity's stack. To save the PC (and later, the stack
pointer on the 8085), HL must be saved; SDOSRT provides RT$IHL (Interrupt
HL) for this purpose. Immediately after saving minimal context, an interrupt
.ix Private Stack Switch
.ix Stack Pointer
.ix Interrupt Stack Pointer
routine MUST switch to its own private stack. Thus, an activity need
allocate only enough stack space for its own needs, and room for a PC (i.e.,
only 2 bytes of stack space are required beyond what the activity needs).
When switching stacks, the stack pointer of the interrupted activity must be
saved in RT$ISP (Interrupt Stack Pointer).
.pa
.ix Interrupt Routine
.ix Register Context
.ix Stack Pointer
.ix RT$ISP
.ix EI/RET Sequence
.ix RT$BRTI
.ix EI/RETI Sequence
To exit the interrupt routine, the interrupt routine must first ensure that
the interrupting device has withdrawn its interrupt request and then  the
register context (including the stack pointer saved in RT$ISP) at the time
of the interrupt must be restored, and an EI/RET sequence must be executed.
Code that accomplishes this effect in an optimized way is shown below in the
RT$BRTI example; most interrupt routines should JMP to RT$BRTI to exit to
take advantage of the optimization.
.sp
.ix Vector Interrupt Logic
.ix RETI
.ix SIO
.ix RT$RETI
.ix Z80
.ix 8085
On Z80 systems, the vector interrupt logic and RETI are particularly
troublesome. A RETI (or its equivalent, [e.g. SIO command RETURN FROM
INTERRUPT] must be executed exactly once (this can easily be accomplished
with a CALL to a RETI instruction [there is one located in common Ram under
the label RT$RETI]), then during the execution of an interrupt routine to
acknowledge the device interrupt. On 8085 systems, the device interrupt must
be cleared (once) in a device-specific fashion.
.sp
.ix RT$BRIT
A Z80 interrupt routine may exit via a RETI instruction, but it is generally
faster to call RT$RETI and then exit by JMP to RT$BRTI (an optimized
interrupt exit routine).
.pa
.ix Nested Priority Interrupt
.ix RT$Z80EI
.ix Enable Interrupt
.ix RT$Bank
.ix RT$IPC
.ix RT$ISP
.ix RT$IHL
.ix Bank Code
.ix Private Stack
.ix Interrupt Routine
.ix Interrupt Enable
To allow a nested priority interrupt, the interrupt routine must re-enable
interrupts, with an EI instruction on both 8085/Z80 (on the Z80, a CALL to a
RETI may be desired if the interrupt routine wishes to allow any device, not
merely one of higher priority to interrupt it). Before enabling interrupts,
the locations RT$Bank, RT$IPC, RT$ISP and RT$IHL must be saved in case
another interrupt occurs, and RT$Bank must be set to the bank codes required
to select the bank in which the interrupt routine runs. It is generally
convenient to push these values onto the private stack of the interrupt
routine, but this is not required. After operating with interrupts enabled
for a period, the interrupt routine will eventually need to disable
interrupts, after which it MUST restore RT$Bank, RT$IPC, RT$ISP and RT$IHL
to the values they had before enabling interrupts.
.sp
.ix RT$NIC
.ix Nested Interrupt Count
.ix RT$SIE
.ix Signal Interrupt Event
.ix Wait Condition
.ix Register Context
.ix RT$Schd
.ix RT$IPC
.ix RT$ISP
.ix RT$IHL
A counter, RT$NIC (Nested Interrupt Count), holds the number of nested
interrupts active, plus 1.  This counter MUST be incremented before
interrupts are enabled to allow an interrupt, and must be correspondingly
decremented after disabling a nested interrupt. Before exiting the interrupt
routine, this counter must be tested for zero (it can be set to this ONLY by
RT$SIE (Signal Interrupt Event); a nonzero value indicates that normal exit
from the interrupt routine is appropriate.  Zero indicates that some task
was woken from a wait condition, and that the SDOSRT scheduler needs to be
run; the interrupt routine must restore the entire register context to the
state at time of interrupt (EXCEPT RT$IPC, RT$ISP and RT$IHL) and transfer
control to the scheduler's front door, RT$Schd.  The scheduler will set
RT$NIC back to one.
.sp
.ix Primitive
Certain SDOSRT primitives executed by tasks bump RT$NIC, thus ensuring that
the primitive will run to completion before any other task or the scheduler
can run.
.sp
.ix Skeletal Example
.ix Interrupt Routine
.ix Vectored Interrupt Mode
.ix Z80 Alternate Register
.ix Disable Interrupt
Here are skeletal examples of how to construct interrupt routines that
operate under SDOSRT. Note the difference between handlers for the 8085 and
the Z80; the Z80 code is somewhat faster.  Note also that Z80 interrupt
routines may use the vectored interrupt mode.  Use of the
Z80 alternate register set is allowed, ONLY if interrupts remain completely
disabled during their use, so no other interrupt can occur, and if no task
running under SDOS/RT uses the alternate register set for its own purposes
(note that under SDNET, some CP/M programs use the alternate register
set, so the alternate set can't be used for interrupt routines).
.pa
.pw 120
.ll 100
.im 48
;       OVERALL INTERRUPT ROUTINE STRUCTURE

InterruptRoutineEntry ; <interrupt comes here, in common space>
        ; Act of taking interrupt has caused interrupted PC to be saved
        ;     Also, interrupts have been disabled
        shld    RT$IHL                 ; save HL in safe place
        pop     h                      ; remove interrupt PC from stack
        shld    RT$IPC                 ; and save in safe place
        push    psw                    ; save PSW on interrupted activity's stk
        ; can't push PSW on private stack since it may not be switched in yet!
        ; could store and reload (A), but that would take longer!
        mvi     a,InterruptRoutineSpaceSelect
        out     BankSelect
        jmp     InterruptRoutineBody   ; this makes for small code in common
        ...

        org     xxxx
InterruptRoutineBody ;interruptcode
        if      i8085
        lxi     0                      ; save task's SP
        dad     sp                     ; this screws up the carry bit
        shld    RT$ISP                 ; save task's SP in safe place
        else    ; z80
        sspd    RT$ISP                 ; save task's SP in safe place
        endif
        lxi     sp,InterruptRoutinePrivateStack ; pick up SP for this routine
        ; <save regs as necessary on stack, acknowledge and process interrupt>
        ...
        ; <optional: operate with interrupts enabled>
        ...
        ; <clean up, restore registers>
        ; assert: interrupts are disabled here
        if      OperatedWithIntsEnabled
        or      ThisInterruptSignaledAnEventSchedulerShouldSee
        lda     RT$NIC                 ; inspect nested interrupt count
        ana     a                      ; scheduling required ?
        jz      RT$SchE                ; yes, go to Scheduler Entry
        endif
        ; (see RT$BRTI example for optimized version interrupt exit code)
        if      i8085
        lhld    RT$ISP
        sphl                           ; switch back to interrupted context
        else    ; z80
        lspd    RT$ISP                 ; switch back to interrupted context
        endif
        jmp     InterruptRoutineExit   ; which is in common space



.ll 65
.pw 85
.pa
.pw 120
.ll 100

.im 18
        org     zzzz
InterruptRoutineExit ; this MUST be in common space
        lda     RT$Bank+1              ; get physical bank info
        out     BankSelect             ; select the physical bank
        pop     psw
        lhld    RT$IPC                 ; restore the interrupt PC...
        push    h                      ; to its proper place on the stack
        lhld    RT$IHL                 ; restore original HL register value
        ei
        if      i8085
        ret
        elsif   z80                    ; and interrupt already acknowledged
        ret
        else
        else    ; z80                  ; and interrupt not acknowledged
        reti
        endif

.ll 65
.pw 85
.pa
.pw 120
.ll 100
.im 34
        ; <STRUCTURE OF CODE TO ALLOW AN INTERRUPT ROUTINE
        ;  TO OPERATE WITH INTERRUPTS ENABLED >

        ; < take action to prevent device causing interrupt to cause another>
        if      InterruptRoutineTakesALongTime
        lhld    RT$ISP                 ; to make ourselves interruptable
        push    h
        lhld    RT$IHL                 ; save HL from interrupted context
        push    h
        lhld    RT$IPC                 ; save PC from interrupted context
        push    h
        lhld    RT$Bank                ; save interrupted routine's bank
        push    h
        mvi     a,InterruptRoutineSpaceSelect
        sta     RT$Bank+1              ; and set this routine's bank
        lxi     h,RT$NIC               ; bump count of nested interrupts
        ei                             ; now allow interrupts
        inr     m                      ; can't int between "ei" and "inr"
        ; Note: Z80 device interrupt must already be acknowledged here
        endif

        ; <operate with interrupts enabled>

        lxi     h,RT$NIC               ; decrement nested interrupt count
        di                             ; done, make us uninterruptable
        dcr     m
        pop     h                      ; restore saved Bank select
        shld    RT$Bank
        pop     h                      ; restore saved PC
        shld    RT$IPC
        pop     h                      ; restore saved HL
        shld    RT$IHL
        pop     h                      ; restore saved SP
        shld    RT$ISP
        endif   InterruptRoutineTakesALongTime
.ll 65
.pw 85
.pa
.ix PUBLIC Label
The implementer of a system using SDOSRT must define the following routines,
and make them available via PUBLIC labels to SDOSRT:
.sp
.pw 120
.ll 100
.im 40
        public  RT$SSBC                ; used by SDOSRT module
RT$SSBC db      SystemSpaceBankSelect  ; holds physical bank code of scheduler

        public  RT$Bank
RT$Bank ds      1       ; holds logical bank number
        ds      1       ; holds physical bank select code

        public  RT$SchS                ; used by very fast interrupt routines
RT$SchS ; Store SP in RT$ISP and start SDOSRT task scheduler
        ; RT$IHL and RT$IPC have already been set correctly
        ; This code MUST be in COMMON ram
        if      i8085
        lxi     0                      ; get SP value to HL
        dad     sp
        shld    RT$ISP                 ; save SP value
        else    ; z80
        sspd    RT$ISP                 ; save SP value
        endif
;       jmp     RT$SchE

        public  RT$SchE                ; used by interrupt routines
RT$SchE ; Scheduler Entry -- starts up SDOSRT task scheduler
        ; used to enter scheduler if interrupt routine is not in SystemSpace
        ; This code MUST be in COMMON ram
        ; all serviced interrupts must have been acknowledged
        mvi     a,RT$SSBC              ; this code must live in common space
        out     BankSelect             ; note: RT$Bank is preserved!
        extrn   RT$Schd                ; defined by SDOSRT module
        jmp     RT$Schd

        public  RT$EStk
RT$EStk dw      0                      ; holds error recovery stack pointer

        public  RT$SPad
RT$Spad ds      8                      ; holds Task Scratchpad storage

        public  RT$NIC
RT$NIC  ds      1                      ; holds nested interrupt count


.ll 65
.pw 85
.pa
.pw 120
.ll 100
.im 33
        public  RT$BRTI               ; used by SDOSRT module
RT$BRTI ; (optimized) select bank and return from interrupt
; Control is passed to here by interrupt routine on completion
; or by SDOSRT Scheduler when task is ready
; serviced interrupts must already by acknowledged
; This code MUST be in Common space!
        lxi     sp,0                   ; 10~ restore activity's stack pointer
        public  RT$ISP
RT$ISP  equ     *-2     ; holds stack pointer of interrupted activity
        public  RT$BRIS
RT$BRIS ; return from interrupt, SP is already restored
        lda     RT$Bank+1              ; 13~ get physical bank info
        out     bank                   ; 10~ select the physical bank
RT$RIPP ; return from interrupt, restore PSW
        pop     psw                    ; 10~ restore PSW of activity from stk
        lxi     h,0                    ; 10~ restore activity's HL register
        public  RT$IHL
RT$IHL  equ     *-2     ; holds HL of interrupted activities
        ei                             ; 4~ allow ints after next instruction
        jmp     0                      ; 10~ restore activity's PC
        public  RT$IPC
RT$IPC  equ     *-2     ; holds PC of interrupted activity
        if      Z80
        public  RT$                    ; used by SDOSRT module and int routines
RT$Z80Ei ; special interrupt-enable routine for Z80
        ei                             ; 4~ allow higher priority interrupts
        ; assert: cannot get an interrupt here!
        public  RT$RETI
RT$RETI ; CALL here to acknowledge Z80 device interrupt
        reti                           ; 10~ allow lower priority interrupts, also
        endif


.ll 65
.pw 85
.pa
.ix Application Task
.ix Performance Limitation
.ix Asynchronous Performance
SDOSRT supports an arbitrarily large number of application tasks (although
performance limitations restrict practical use to under 100 tasks).  Each
task is an independent thread of execution, and may perform activities
asynchronously (and, in effect, in parallel with) other executing tasks.
Tasks are given priorities to ensure that activities are performed according
.ix Event Variable
.ix Synchronize Operation
.ix Task Priority
to their importance; a task may change its priority up or down if necessary.
Tasks may send signals (via event variables) or wait for events to
synchronize their operation, and tasks may wait for interrupt events or
cause an "interrupt" to signal an interrupt routine that service is
required. SDOSRT allows different tasks to operate in different memory
.ix Memory Bank Space
.ix Interbank Transfer
banks, so that large applications can take advantage of memory spaces larger
than 64k; any task may change the bank in which it is operating, so
interbank transfers and programs larger than 64kb are possible (One of
SDOSRT's design goals was to allow execution of banked CP/M 3.0 as a single
task under SDOSRT, with the TPA living in bank one, and the BIOS and several
.ix TPA
.ix BIOS
.ix I/O Task
.ix System Bank
.ix Scratchpad Area
.ix Extra Register
I/O tasks living in the system bank). SDOSRT provides each task with an 8
byte scratchpad area, which can be treated as extra registers; references to
the scratchpad by code is completely re-entrant.  Since the scratchpad is in
Common ram, it provides a vehicle for a task to easily carry data from one
memory bank to another.
.sp
.ix Task Control Block
.ix TCB
.ix Processor Context
.ix Priority Value
.ix TCB$Bank
.ix Memory Bank
.ix TCB$StackPointer
.ix Address Space
.ix TCB$Priority
.ix PSW/PC Value
.ix Top of Stack
"Task Control Blocks" (TCBs) are objects that represent tasks.  For each
task operating under SDOSRT, a TCB must be defined.  Each TCB contains a
copy of the processor context when a task is not running, and a priority
value for the task.  Note that there are several important values that need
set-up to start a task: TCB$Bank, i.e., which memory bank the in which the
task will execute; TCB$StackPointer, which contains the value that the
processor SP will hold when the task starts execution (note: the processor
stack area must be in the address space specified by TCB$Bank);
TCB$Priority, to specify the relative priority of this task with respect to
all the others; and the PSW/PC values on the top of the stack specified by
TCB$StackPointer, which tells the processor where to start executing. All
TCBs must be in the same space as SDOSRT.
.sp
.in 10
.un 10
TCB$InterruptPSW is extra space set aside in the TCB to allow the Task
.ix TCB$InterruptPSW
.ix Load Processor Context
.ix Dump Processor Context
.ix Stack Pointer
.ix TCB
.ix PUSH
.ix Interrupt Enabled
.ix Switch Register Context
.ix System Programmer
scheduler to load/dump the processor context by setting a Stack pointer to
point INTO the TCB, and executing a series of PUSH instructions with
interrupts enabled. These two values provide space for the interrupt system
to push a PC and a PSW onto the stack pointing into the TCB, if an interrupt
should occur while the scheduler is switching register contexts.  Other than
allocating room in each TCB for these, the systems programmer need not be
concerned about them.
.pa
.un 10
TCB$ErrorRecoveryStack, TCB$ScratchPad and TCB$Bank are simply places to hold
.ix TCB$ErrorRecoveryStack
.ix TCB$Bank
.ix Task Value
.ix RT$EStk
.ix RT$SPad
.ix RT$Bank
.ix Propogated Error
.ix Garbage Stack Pointer
.ix TCB$ScratchPad
the task's values of RT$EStk, RT$SPad and RT$Bank while the task is not
executing.  TCB$ErrorRecoveryStack MUST be set to a value that allows a task
to catch a propogated error, so that propogated errors NEVER pick up a
garbage stack pointer. RT$ATsk automatically sets TCB$ErrorRecoveryStack.
.sp
.un 10
TCB$RegisterPC, TCB$RegisterBC, TCB$RegisterDE, TCB$RegisterHL,
TCB$StackPointer, TCB$RegisterIX and TCB$RegisterIY hold a copy of the task's
.ix TCB$RegisterPC
.ix TCB$RegisterBC
.ix TCB$RegisterDE
.ix TCB$RegisterHL
.ix TCB$StackPointer
.ix TCB$RegisterIX
.ix TCB$RegisterIY
.ix Task Register Context
.ix Task Stack
.ix Z80 Alternate Register
register context when it is not executing.  The task's PSW (Accumulator and
Flags) is always kept on the very top of the task's stack. Note: tasks are
NOT allowed to use the Z80 alternate register set, as SDOSRT does not save
the alternate register set when a task is put to sleep.
.sp
.un 10
TCB$Priority is a byte which specifies the priority at which a task
executes.  SDOSRT maintains a list of tasks which are ready for execution,
and will choose the highest priority task from that list each time the list
.ix TCB$Priority
.ix SDOSRT
.ix Compute-Bound Task
.ix Multiple Tasks with Same Priority
.ix CPU Time
.ix Timeshare
.ix User-Defined Task
.ix Idle Task
.ix RT$ChPr
.ix Change Priority
is updated. Once a task is chosen for execution, SDOSRT will run that task
until it waits for some event, or until a task with a higher priority
pre-empts execution.  A compute-bound task will prevent tasks of lower
priority from executing at all. If there are multiple tasks with the same
priority, SDOSRT will allow each equal task a fixed amount of CPU time
before forcing another task of equal priority to run; thus simple
timesharing is effected. SDOSRT defines 0 to be the HIGHEST priority, with
255 being the lowest; for implementation reasons, priority numbers 254 and
255 may NOT be used by any user-defined task (an Idle task of low priority
[254] soaks up all CPU cycles unwanted by other tasks).  A task may change
its priority by calling RT$ChPr (Change Priority).
.sp
.un 10
.ix TCB$NextTCB
.ix TCB Pointer
TCB$NextTCB contains a pointer to another TCB if the task is in a queue. If
the TCB is not in any queue (i.e., it is waiting on an event) then
TCB$NextTCB is zero.
.pa
.in 0
.ix Event
.ix Interrupt Routine
.ix Task Signal Interrupt Routine
.ix Event Control Block
.ix ECB
.ix Event Count
.ix Event Code
.ix TCB Pointer
.ix Simulated Interrupt
"Events" are objects that represent the occurrence of an event.  They are
used (primarily) to signal events from interrupt routines to tasks (tasks
signal interrupt routines via simulated interrupts), and (occasionally) as
signals between tasks.  Each event is represented by an Event Control Block
(ECB), which contains an event count, a event code, and a pointer to a TCB.
.ix Event Counter
The event count records the number of occurrences of an event, and is
limited to 255.  It is bumped when an event is "signalled", and it is
decremented when a task wakes up as a result of being "connected" to that
event; the event counter may also be forcibly zeroed.  The TCB pointer
indicates which task is waiting for the event to occur; since several ECBs
.ix OR Wait
may point to the same task, a task can be awakened when any of the events
occur, thus allowing OR waits.  Events can occur even when no task is
waiting for them; they are simply stored (by the counter) until some task
forms a connection to that event and then issues a wait.  This allows
interrupt routines and other tasks to build up several units of work,
asynchronously, with respect to the task whose job is to process those units
of work.
.sp
.in 10
.un 10
ECB$Count holds the event count stored by this event.  Limit is 255.
.ix ECB$Count
.ix Event Count
.ix Limit
.sp
.un 10
ECB$EventCode holds an 8 bit code which identifies the event represented by
.ix ECB$EventCode
this ECB.  This is used by a task upon wakeup to determine which event woke
it.  This code must be non-zero.
.sp
.un 10
ECB$ConnectedTCB points to the TCB of the task which most recently issued an
.ix ECB$ConnectedTCB
.ix SDOSRT$ConnectEvent
.ix RT$DWC
.ix Special Cell
SDOSRT$ConnectEvent request for this ECB.  If this ECB has most recently
been disconnected, this points to a special (RT$DWC) cell used only by
SDOSRT to make processing of events simple.
.sp
.in 0
"Semaphores" are used to lock and unlock critical regions of code
(resource management), and to communicate between tasks which do not know
.ix Semaphore
.ix Interrupt Routine
each other's identity (producer/consumer relationship).  They are
occasionally used to communicate from interrupt routines to tasks, and
never used from tasks to interrupt routines (this is because interrupt
routines cannot
.ix Sempahore Update
.ix Semaphore Control Block
.ix TCB
wait).  Semaphores are always used as a pair, i.e., for each semaphore
update, there exists a corresponding wait for that semaphore somewhere.  A
semaphore control block represents each semaphore, and contains a count
and a queue of TCBs.
.sp
.in 10
.un 10
.ix SCB$Count
.ix Semaphore Count
SCB$Count holds the semaphore count; 0 implies no resource available. A
limit of 127 resource units, and 128 waiting tasks results because the count
is stored in a byte.
.sp
.un 10
SCB$TCBQueue points to a queue of TCBs representing tasks, in priority
.ix SCB$TCBQueue
.ix TCB
.ix Priority Order
.ix Resource Available
order, which are waiting for availability of the resource.
.pa
.in 0
.ix Time Out
.ix Simulated Interrupt
.ix TOB
.ix HL
.ix RT$ITE
.ix InterruptTimeoutEvent
.ix Event Control Block
"Timeouts" are simulated interrupts which occur after a specified period of
time. A timeout block (TOB) represents a potential timeout interrupt, and
holds a timeout period, and a pointer to a block of code that gets control
as if an interrupt had occurred when the timer expires.  A parameter from
the timeout block is passed in (DE) to the timeout routine. RT$ITE
(InterruptTimeoutEvent) can be specified as the routine if an event needs to
be flagged when the timeout occurs (the parameter must point to an Event
Control Block); this allows easy conversion of a timeout interrupt to a
timeout event.
.sp
.in 10
.un 10
TOB$DelayDelta holds the timeout period in 1000Hz ticks (limited to about 65
seconds) after which a timeout occurs.  When a TOB is in the
TimeoutBlock list, TOB$DelayDelta contains the 2's complement of the number
.ix TO$DelayDelta
.ix Time Out Period
.ix TimeoutBlock
.ix Add Clock Tick
.ix RT$Tick
.ix $FF00 Ticks
.ix Limit Time Out
of clock ticks before the timeout will occur; this makes it easy to ADD a
clock tick. A timeout is complete when the most significant byte of the
remaining delay is zero (i.e., the time has arrived), thus allowing some
overshoot.  Since the number of clock ticks passed to RT$Tick cannot exceed
255 (really??), there is just enough overshoot to handle a maximum number of
ticks. These rules limit timeouts to $FF00 ticks, maximum (delays "larger"
than $FE00 are illegal.)
.sp
.un 10
TOB$Routine points to an interrupt routine which gains control via RT$SInt
when
.ix TOB$Routine
.ix RT$SInt
.ix RT$IDun
the timeout expires. See RT$SInt for description of properties that
interrupt one time must have.
.sp
.un 10
TOB$Parameter holds a 16 bit value which is passed to TOB$Routine in (DE)
when
.ix TOB$Parameter
.ix ROB$Routine in DE
it gets control.
.sp
.un 10
TOB$Queue holds pointer to next TOB in delay-sorted order; this ensures that
the timeout queue need process only the TOB at the head of the queue at each
clock tick.  If the TOB has expired then the TOB is not in the timer queue
and TOB$Queue is zero.
.pa
.un 10
RT$STMO (Set Timeout) is called with the address of a timeout block in HL,
and a timeout delay in DE.  The timeout block MUST NOT BE in the timer
queue, (IF IT MIGHT BE, USE RT$UTMO).  Interrupts must be disabled.
The TOB is then inserted in the
.ix RT$STMO
.ix Set Time Out
.ix Time Out Block in HL
.ix Time Out Delay in DE
.ix Timer Queue
.ix WARNING
.ix RT$UTMO
.ix TOB$Routie
.ix CALL
.ix TOB$Parameter
.ix Disable Interrup
.ix RET
.ix RETI
timer queue with the delay in milliseconds specified by DE.  After the delay
time has elapsed, the TOB is automatically removed from the timer queue, and
TOB$Routine is passed control via CALL  (with interrupts disabled) with DE
holding TOB$Parameter. The called routine need not save any registers, but
must exit via RET (not RETI). It may enable interrupts only if another clock
tick does not elapse while it has interrupts enabled.
.br
NOTE: A 1ms delay guarantees at least 1 millisecond will pass.
.sp
.un 10
RT$RTMO (Reset Timeout) is passed the address of a timeout block in HL. If
.ix RT$RTMO
.ix Reset Time Out
.ix Timer Queue
.ix Disable Interrupt
.ix Time Out Expire
the TOB is still in the timer queue, it is removed, otherwise no action
takes place.  This routine should be called if the event which a timeout is
watching takes place before the timeout expires, and the effects of timing
the event out are no longer desired. Interrupts must be disabled.
.sp
.un 10
RT$UTMO (Update timeout) first does RT$RTMO, followed by RT$STMO, but is
more
.ix RT$UTMO
.ix RT$RTMO
.ix RT$STMO
.ix Disable Interrupt
.ix Update Time Out
efficient than calling each individually. Arguments are the same as RT$STMO.
Interrupts must be disabled.
.pa
.in 10
.un 10
RT$Clk holds a 32 bit counter containing the number of clock ticks since the
.ix RT$Clk
.ix Number of Clock Ticks
.ix Clock Tick
.ix RT$TIME
.ix True Millisecond
system began operation.  Clock ticks are approximately 1/1000th  of a second
(1/1024th second is easily generated with Z80 CTC chip); but timing will be
slightly inaccurate. A system specifies routine, RT$TIME, must be called to
get the exact time in milliseconds; this routine knows the relationship
between RT$Clk and true milliseconds.
.sp
The clock tick error should be limited to 5% or software independent of
.ix SDOSRT
SDOSRT may not operate correctly.
.sp
.un 10
.ix RT$Tick
.ix Subroutine
.ix Hardware-Specific Clock Interrupt
.ix A Register
.ix RT$SCID
.ix Scheduler
.ix Disable Interrupt
.ix AF
.ix HL
RT$Tick is called as a subroutine by the hardware-specific clock interrupt
routine, and is given the nonzero number of clock ticks that have elapsed
since the previous call in the A register (note: this routine must be called
at least once per quarter second; RT$SCID will be called by the scheduler
often enough to ensure this). Interrupts must be in the disabled state;
RT$Tick does not enable interrupts and returns very quickly. The caller must
be in the same bank as RT$Tick, and need only have preserved AF and HL of
the interrupted activity.
.sp
.un 10
RT$RET (Return Elapsed Time) is a user-defined routine that returns the
.ix RT$RET
.ix Return Elapsed Time
.ix User-Defined Routine
.ix Clock Tick in A
.ix Hardware Clock
.ix SDOSRT
number of clock ticks in A that have elapsed since the last call to RT$. It
is intended to be used to ask a hardware clock the amount of elapsed time.
SDOSRT will issue a RT$RET at intervals no longer than (approx.) 100
milliseconds.
.sp
.un 10
RT$SCID (Set Clock Interrupt Delay) is a user-defined subroutine that will
.ix RT$SCID
.ix Set Clock Interrupt Delay
.ix User--Defined Subroutine
.ix Hardware Clock
.ix RT$Tick
.ix A Clock Tick
.ix RT$RET
.ix Disable Interrupt
.ix Multiple Calls
cause an interrupt (by use of a hardware clock) to RT$Tick after A clock
ticks (min 1, max 127) have passed since a call to RT$RET. It is called with
interrupts disabled. This routine should be very fast to keep interrupt
system overhead small. A call to RT$SCID is always preceded by a call to
RT$RET or RT$Tick. It is not possible for the sequence
RT$RET...RT$Tick...RT$SCID or RT$Tick...RTRET...RT$SCID to occur. Multiple
calls to RT$RET are valid.
.in 0
.pa
.in 10
.un 10
RT$Wait is called by a task to wait for a wakeup condition. RT$CEvent must
.ix RT$Wait
.ix Wait
.ix RT$CEvent
.ix RT$RWC
.ix Event Count Decrement
.ix Time Out Block
.ix Time Out Event
.ix NI:A Task
.ix Abort Event
be called once for each event that might wake the task, prior to executing
RT$Wait.  Upon awakening, the Event code of the event that woke the task is
in (A), or can be obtained by calling RT$RWC, so the task may know which
event caused it to awaken. The event which caused the task to awaken will
have its event count decremented. If a task must not wait longer than a
fixed period of time, it can set up a timeout block to signal a timeout
event, and connect to the timeout event. NI:A task may also awaken because
of an Abort event, which sets BC to Err$Aborted, and performs an implicit
RT$SERR (Signal Error) to start error recovery; in this case, no registers
.ix Err$Aborted
.ix RT$SERR
.ix Signal Error
.ix Error Recovery
are preserved.
.sp
.un 10
RT$AFW (Arm for Wakeup) allows events about to be connected to wakeup this
.ix RT$AFW
.ix Arm for Wakeup
task if it waits.  RT$AFW must be called before connecting to any events, or
no event will wake the task.  No parameters needed.
.sp
.un 10
RT$RWC (Read Wakeup Code) is called to read the Event Code that woke this
.ix RT$RWC
.ix Read Wakeup Code
.ix Event Code
.ix RT$Wait
task. This can be used after waking up from waiting to determine which of
several connected events caused the wakeup (see RT$Wait).
.sp
.un 10
RT$REvn (Reset Event) is called with HL pointing to an Event Control Block.
.ix RT$REvn
.ix Reset Event
.ix Event Control Block
.ix HL
.ix ECB
The event count is zeroed. This is used to ensure that an ECB only records
"the next event" as opposed to some events stored from the past, and should
be called before RT$AFW.
.sp
.un 10
RT$CEvn (Connect Event) is called with HL pointing to an Event Control
.ix RT$CEvn
.ix Connect Event
.ix Event Control Block
.ix RT$Wait
.ix OR Condition
.ix Event Code
.ix NI:Err$AlreadyConnected
Block. This sets up the event to awaken the task when an RT$Wait is issued. 
Several events may be connected to a task before issuing a wait; this allows
a task to wait on an OR condition of any event. Since the awakening event
sets an event code, the task can easily determine which of several events
woke it.  Only one task may be connected to an event at a time. 
NI:Err$AlreadyConnected will be issued if the event is already connected to
some other task.
.sp
.un 10
RT$DEvn (Disconnect Event) is called with HL pointing to an Event Control
.ix RT$DEvn
.ix Disconnect Event
.ix Event Control Block
.ix ECB
.ix Issuing Task
Block. This disconnects the event from the task; after a disconnect, the
event cannot awaken a task.  No error is given, even if the ECB is not
currently connected to the issuing task.
.sp
.un 10
RT$SEvn (Signal Event) is called with HL pointing to an Event Control
.ix RT$SEvn
.ix Signal Event
.ix Event Control Block
.ix HL
.ix Task Level Routine
.ix Interrupt
.ix RT$SIE
.ix Event Code
.ix Signal Interrupt Event
Block (this entry point is meant for use by task level routines only;
interrupt routines must use RT$SIE (Signal Interrupt Event)). The event
count is incremented by one, and, if some task is waiting for this event,
that task is awoken with an event code taken from the Event Control Block.
.sp
*******NEEDS WORK********
.br
.un 10
RT$SIW (Signal Interrupt Waiting) is called with HL pointing to an Event
.ix RT$SIW
.ix Signal Interupt Waiting
.ix RT$SIE
.ix Signal Interrupt Event
.ix Event Control Block
.ix Interrupt Routine
.ix Task Level Routine
.ix RT$SEvn
.ix Signal Event
.ix Event Count
.ix Buffer Busy
.ix Buffer Free
Control Block (this entry point is meant for use by interrupt routines only;
task level routines should use RT$SEvn (Signal Event)). The event count is
set to one (not incremented!) , and, if some task is waiting for this event,
that task is awoken with an event code taken from the Event Control Block.
RT$SIW is typically used when the interrupt routine keeps a separate count
of data, collects variable amounts of data in each transaction, and is used
to notify the task level that new data has arrived.
.sp
.un 10
RT$SIE (Signal Interrupt Event) is called with HL pointing to an Event
.ix RT$SIE
.ix Signal Interrupt Event
.ix Event Control Block
.ix Interrupt Routine
.ix Task Level Routine
.ix RT$SEvn
.ix Signal Event
.ix Event Count
.ix Buffer Busy
.ix Buffer Free
Control Block (this entry point is meant for use by interrupt routines
only; task level routines must use RT$SEvn (Signal Event)). The event
count is incremented by one, and, if some task is waiting for this event,
that task is awoken with an event code taken from the Event Control Block.
The event count for an interrupt event is typically a "buffer busy" or
"buffer free" count, and is limited to 255.
.sp
.un 10
RT$SInt (Simulate Interrupt) is called with HL pointing to an interrupt
.ix RT$SInt
.ix Simulate Interrupt
.ix DI
.ix Register Contents
.ix True Interrupt Routine
.ix RET
.ix Switch Stack
.ix Save Register
.ix RETI
routine. The task is stopped exactly as if an interrupt had occurred; an
interrupt is simulated, including a DI. The contents of the registers are
preserved for inspection by the interrupt routine.  This allows a task to
start an interrupt routine's operation, and to pass that routine parameters
describing the work to be done.  When the interrupt routine has completed,
it exits exactly like a true interrupt routine (on the Z80, it must exit
via RET, not RETI), and the task continues execution with registers
unchanged. This is the preferred method for a task to signal to an interrupt
routine that something interesting to the interrupt routine has occurred. 
Note that the interrupt routine must switch stacks and save registers, just
like a real interrupt! No address space switch occurs; (HL) must point to an
interrupt routine that is visible when the system space is enabled. RT$SINT
also handles storing HL into RT$IHL, storing the return PC in to RT$IPC and
storing SP in RT$ISP. The interrupt code must set SP to its own stack. If an
interrupt routine must do an RT$SInt, it must be prepared for nested
interrupts. When control returns, interrupts are enabled.
.sp
.ix RT$RLck
.ix Semaphore
.un 10
RT$RLck Initializes a semaphore.
.sp
.un 10
RT$Lock is called with HL pointing to a semaphore. If the semaphore is already
.ix RT$Lock
.ix Semaphore
.ix Semaphore Locked
.ix TCB$Priority
.ix Serial Execution
.ix Critical Code Section
.ix RT$Unlk
.ix Task Error
.ix Region Locked
.ix Priority Order
locked, the task is put to sleep until the semaphore is unlocked.  When
control is returned, the semaphore is locked. If several tasks lock a region,
the first to the region will succeed; the others will get their turn in
priority order, as specified by TCB$Priority. This call is meant primarily to
help ensure serial execution of critical sections of code, and should be used
in conjunction with RT$Unlk (Unlock). The programmer must ensure that tasks
erroring within a locked region recover gracefully, in particular, the error
recovery code must perform an RT$Unlk (Unlock) on the appropriate semaphore.
.sp
NI:HOw to handle error recovery and aborts.  If the waiting task times out,
.ix NI*HOw
.ix Time Out
.ix Error Trap
or is aborted, it will wake up and pass control to the most recent error
trap set, with an approriate error code in BC.
.sp
.un 10
RT$Unlk (Unlock) is called with HL pointing to a semaphore.  The semaphore
.ix RT$Unlk
.ix Unlock
.ix Semaphore
.ix RT$Lock
is unlocked; if there is a task waiting for the semaphore to be unlocked
(RT$Lock), that task is woken and placed into execution.   The calling
task does not wait; control returns immediately.
.sp
.un 10
RT$Alloc NI:(Allocate Resource) is called with HL pointing to a semaphore,
.ix RT$ALLOC
.ix NI*(Allocate Resource)
.ix Semaphore
.ix Resource Number Count
and (A) containing a count of the number of resource units to allocate.
.sp
.un 10
RT$DAlloc NI:(Deallocate Resource) is called with HL pointing to a
.ix RT$DAlloc
.ix NI*(Deallocate Resource)
semaphore, and (A) containing a count of the number of resource units to
deallocate.
.sp
.un 10
RT$Init (Initialize) is called to start the operation of SDOSRT.  It must be
.ix RT$Init
.ix Initialize
.ix SDOSRT
.ix RT$ATsk
.ix TCB$StackPointer
.ix Task Control Block
.ix HL
called interrupts disabled before any other SDOSRT function.  On entry,
(A) must contain a priority and (HL) must point to a Task Control
Block, on return, the specified task will be running with the specified
priority. After it returns, additional tasks may be added via RT$ATsk; TCBs
for added tasks must have TCB$StackPointer set up with a stack having a PSW
and PC already pushed.
.ix PSW
.ix PC
.ix System-Specific Initialize
.ix RT$SchE
After all tasks are added, and other system-specific initializing is
complete, control must transfer to RT$SchE to enable operation of SDOSRT.
.sp
.un 10
RT$ATsk (Add Task) called with a TCB address in HL to add a new Task  to the
ready-to-run task queue.  This entrypoint is used to set up all the tasks
that will be in a running SDOSRT system, but can be used to dynamically add
tasks after the system starts operation. A task can be removed by waiting
on an event that never occurs. Must be called by a task. NI:RT$ATsk sets
TCB$ErrorRecoveryStack to crash recovery point which kills the offending
task if error recovery is possible.
.sp
.un 10
RT$ChPr (Change Priority) is called by a task to change its current priority
.ix RT$ChPr
.ix Change Priority
.ix A Register
.ix Undefined Value Result
to the value specified in the A register.  The value must be in the range
0-253; results for values 254 and 255 are undefined.
.in 0
.pa
.tc
NETASSIGN
.ix NETASSIGN
.ix Network User Node
.ix Remote Resource
.ix Protected Remote Resource
.sp
The NETASSIGN program is run by the operator of a network user node to
specify what remote resources are to be used, where those resources are, and
to supply authorization for access to protected remote resources.

.im 10
ASSIGN <nodeid> <driveid> AS <driveid>
ASSIGN <nodeid> <deviceid> AS <deviceid>
SPOOL <deviceid> TO <nodeid>
SPOOL <diskfilename> TO <nodeid>
PASSWORD FOR <nodeid><driveid><fileid> IS <passwordtext>
LOGON <password>  {provides access to network}
REMOTEEXECUTE <nodeid>

Requirements for SDNET-80
Record Interlock MPM style
remote file access

.pa
.tc
NETLINKDRVR
.ix NETLINKDRVR
.ix Link Driver
.ix Physical Link
.ix NETSOCKETMGR
.ix Network Link Hardware
.ix Interface
.ix Disk Driver
.sp
The NETLINKDRVR module (also known as the Link Driver) handles the physical
link transfers between nodes. It acts as the interface between NETSOCKETMGR
and the network link hardware, and as such, is highly hardware dependent.
The interface to NETSOCKETMGR is fixed, and is described in this section. 
No rules about how NETLINKDRVR drives the hardware are made, so a wide
selection of implmentations are possible; thus, NETLINKDRVR is very similar
to a disk driver in style and intent.
.sp
Each node has a physical node id (PNID) which uniquely identifies the node
.ix PNID
on the network.
.sp
.ix Network Hardware Driver
.ix Network Bus Driver
.ix SIO
.ix FIFO
.ix Bus Driver
.ix HDLC Data Message
.ix CRC
.ix Pre-Selected Node Address
.ix Message Header
.ix SIO Limit
.ix DMA Channel
.ix Link Driver
So that the discussion is concrete, we will postulate a sample network
hardware driver that consists of a Z80 SIO and a FIFO, and special network
bus drivers (for completeness, such an interface would include a Z80 CTC for
use by SDOSRT).  The network bus drivers have little effect upon the Link
Driver module, so no further discussion will be made here.  The SIO has the
properties that it will transmit HDLC data messages, automatically
generating/checking a CRC over the message, and will only notify the CPU
when a pre-selected node address is mentioned in a received message header.
The purpose of the FIFO is to capture bytes received by the SIO; this allows
the network interface to operate at the 800Kb SIO limit, and yet does not
require a DMA channel dedicated to the network interface.
.sp
.ix Socket Manager
.ix Two-Way Pipeline
.ix Broadcast Address
.ix Memory Space Limit
.ix NRB
.ix Node Representative Block
.ix Logical Pipeline
The Link Driver module establishes, based on requests from the Socket
Manager, logical, two-way pipelines (streams of bytes) to other nodes on the
net. Such logical links are relatively long-lived, i.e., many messages will
be transmitted over such a logical link before the need for the link
disappears. SDNET allows up to 255 nodes on a local net (an address is
reserved for broadcasts); a particular node can potentially communicate with
any combination of the other 254. Since no one node is likely to be
communicating with any large number of other nodes, and memory space is
limited, the information required to represent another node (NRB: a Node
Representative Block) and the corresponding buffers are usually dynamically
.ix Logical Link
allocated when a request is made to establish a logical link.
.sp
For each logical link established, the link driver must maintain a buffer of
data which has been requested by the socket manager to be sent to the other
node, but not yet been reliably transmitted it, and a buffer of data
received accurately from the other node, but not yet accepted by the Socket
Manager. The Socket Manager's view of the logical link is it is a
continuous data stream, with the bytes numbered from 0 (1st byte
sent/recieved after link is opened) to infinity.  When the Socket Manager
gives the link driver some bytes
.ix Logical Link
.ix Link Driver
.ix Data Buffer
.ix Remote Node
.ix Socket Manager
.ix Logical Message Boundary
to send, it expects that they will eventually arrive at the remote node (the
sooner the better!) with no further prompting by the Socket Manager. 
Likewise, the link driver should collect bytes sent from remote nodes and
save them for the Socket Manager to take at the next convenient opportunity.
the link driver has no idea where "logical messages boundaries" are within
the data stream, and is free to transmit the data in any size chunks or
order convenient, as long as byte order is preserved from the point of view
of the Socket Manager.   The Socket Manager does, however, provide Transmit
and Receive
.ix Link Driver
.ix Transmit Hint
.ix Receive Hint
.ix Logical Message
hints, to make the transmission of data somewhat more efficient; Transmit
hints are generally given after the end of a logical message, an Receive
hints are given when Socket Manager is anxious for more data from a
particular node.
.sp
.ix CRC
.ix Error Recovery Procedure
.ix Flow Control
.ix Network Protocol
.ix Equal Access
.ix Link Start Up
.ix Link Termination
.ix SDLP
It is the link driver's job to ensure that the data is reliably transferred
over the link by using some suitable protocol, proper handshaking, error
checking (such as CRC) and error recovery procedures.  It must perform this
task in an efficient manner, which generally requires flow control to
prevent data from redundantly being transmitted when the receiver has no
room.   It also requires observing network protocol rules so that all nodes
have equal access to opportunities to transmit data. Finally, it must
handle link startup and termination, both in the normal case when
everything is working fine, and in the case where the remote node dies or
goes crazy. For a good example of a link protocol which solves all of these
problems, see the section on SDLP.
.sp
.ix NRB
.ix Socket Manager
.ix Authorize Transmission
.ix Authorize Receipt
.ix Broadcast NRB
All the information required to perform these functions are stored in NRBs. 
NRBs are initialized by request from the Socket Manager; (?? how does a node
receive a message from somebody it has never heard from before??). No
message can be sent or received until the Socket Manager has authorized such
transmission or receipt; message recieved from nodes not authorized are
simply ignored.  A special case is the Broadcast NRB, which is always ready
to receive Broadcast messages.
.sp
Typical scenarios of link driver operation are given here.  In the case of
.ix OpenLink Request
.ix NRB
.ix Socket Manager
.ix Data Buffer
transmission, the Socket Manager first issues an OpenLink request, which
causes link driver to set up an NRB for communication with the specified
remote node, and to perform whatever initial handshaking is necessary to
establish the connection.  The Socket Manager then issues a Send request,
and specifies a buffer of data to send.  Link driver copies this buffer onto
the end of a buffer whose contents have yet to be sent to the remote node.
Because
.ix Send Request
.ix Transmit Hint
.ix Remote Node
.ix Logical Message
the Socket Manager may make several Send requests closely spaced in time,
link driver does not transmit immediately; instead, it sets a fuse which
will cause transmission if no further Send requests are issued by the Socket
Manager.  The Socket Manager may (or may not) issue a Transmit Hint; such a
hint is a signal to link driver that the Socket Manager has placed enough
data in the Send buffers so that the remote node can do some meaningful
work if all the Send data is transmitted (i.e., a logical message has been
Sent).  Link Driver may send immediately upon a Transmit Hint, or it may
wait for the Network to become free or for some other convenient
opportunity, but it should not wait long after a Hint before it sends, or
network throughput will
.ix Network Throughput
.ix Positive Acknowledgement
.ix Send Buffer
suffer.  The data is sent, but retained in the Send buffer until a positive
acknowledgement is received from the remote node that all the data has been
received reliably.  Once the acknowledgment is received, the acknowledged
portion is removed from the send buffer.  In the meantime, it is possible
that the Socket Manager has issued further Send requests, so Link Driver
must be careful as to the amount of data removed from the Send buffer on an
acknowledgement.  If no positive acknowledgment is recieved within a fixed
period of time, the sender re-transmits his data on the assumption that the
.ix CRC
receiver missed the message, received a bad CRC on the message and so
disbelieved the send-to address, or had no room in his buffers.   Thus,
messages are reliably sent.
.sp
On receipt of a message marked for this node, Link Driver inspects the
message
.ix Message Field
.ix NRB
.ix Garbled Message
.ix Verify Message
.ix Duplicate Message
.ix Receive Buffer
field which tells it the sender of the message.  If an NRB has not been
established for communication with the sender, the message is simply
discarded; no further action is necessary.   Messages with garbled contents
(as indicated by bad CRC, etc.) are likewise ignored; the sender will
eventually retransmit them. Otherwise, Link Driver verifies the message is
not a duplicate of one already received, and discards duplicate (portions). 
Non-duplicates have their data extracted and placed in a receive buffer
corresponding to the sender; since the receive buffer may be partially full,
portions of the received data may be discarded because there is no room. 
The amount retained is recorded in the NRB, and transmitted back to the
.ix Positive Acknowledgemnt
.ix Transmit Buffer Space
sender when convenient; this constitutes the positive acknowledgement that
the sender needs to free up his transmit buffer space.   Since data from
this node may be almost ready to send back to the sender, it is wise not to
send such acknowledgements immediately; with careful design, such
acknowledgements can by "piggybacked" onto the next data message sent to the
sender.  On the other hand, it is not good to hold off sending the
acknowledgement too long, as the sender's valuable buffer space is tied up
until he gets the acknowledgement.  As a compromise, an acknowledgement is
typically sent "soon" after new data is received if no transmit hint is
given by the reciever's Socket Manager. If no data is retained, the receiver
simply waits for the sender to send the data again.
.sp
.ix Interrupt Routine
.ix Task Level Entry Point
.ix Re-Entrant Module
.ix SDOS/RT
.ix RT$Lock
.ix RT$SInt
Typically, Link Driver is implemented as a large interrupt routine, with
task level entry points from the Socket Manager.  Since the Socket Manager
is a re-entrant module executed simultaneously by several tasks, any of
which may call the Link Driver module, care must be taken to interlock the
Link Driver's entry points to prevent task conflicts.  SDOS/RT provides a
suitable mechanism in
two forms: RT$SInt and RT$Lock.
.sp
Link Driver also signals events to the Socket Manager.  This is done
primarily
.ix Event Control Block
by use of Event Control Blocks.
.pa
.ix LD$xxxx
.ix Link Driver
.ix PNID
.ix A Register
.ix Open Link
.ix Entry Point
The following details the entry points that must be supplied by the Link
Driver module.  All Link Driver entry points are labelled LD$xxxx,
for "Link Driver...".  Many LD$ routines require a PNID in the A register;
except for LD$OLnk (Open Link), use of a PNID which has not been previously
.ix LD$OLnk
.ix ERR:LinkNotOpen
opened results in an ERR:LinkNotOpen error, and the operation is aborted. A
remote node specified by a PNID may fail in the middle of an operation; this
will cause an ERR:NODEDIED will be returned and the operation aborted.
Callers of NRB-specific routines must lock the NRB to ensure other tasks
don't mix outputs.
.sp
.in 10
.un 10
LD$RST (Reset) is called to reset the link driver. This call occurs once,
.ix LD$RST
.ix Reset
.ix Link Driver
.ix System Boot Time
at system boot time. The physical Node ID (PNID) must be
returned in
.ix LD$SNID
.ix Set Node ID
.ix Physical Node ID
.ix A Register
the A register. This sets the network physical node address of this node.
.sp
.un 10
LD$Bcst (Broadcast) is called with BC containing a count, and HL pointing to a
.ix LD$Bcst
.ix Broadcast
.ix BC
.ix HL
.ix Message Buffer
message buffer to broadcast.  NETCOMM must transmit the message once. 
Control is returned as soon as possible. ??Broadcast Byte?? Where does
message get built???
.sp
.un 10
.ix LD$SByt
.ix Physical Node Identification
LD$SByt (Send Byte) is called with A containing the physical node
identification of the node to which byte B must be sent.
.sp
.un 10
.ix LD$Blk
.ix Send Block
.ix Physical Node Identification
.ix Register A
.ix Transmit Buffer
.ix Calling Task
LD$Blk (Send block) is called with BC containing a count, HL pointing to a
buffer, and A containing the physical identification of the node to which
the buffer must be sent.  Register A will always specify a node for which an
NRB has established. NETCOMM must copy the bytes from the buffer specified
onto the end of the transmit buffer for the specified NRB.  If there is not
enough room in the transmit buffer, the calling task must be forced to wait
until there is enough room.
.sp
.un 10
LD$THnt (Transmit Hint) is called with A containing the physical id of a
.ix LD$THnt
.ix Transmit Hint
.ix Physical Node Identification
.ix Socket Manager
.ix LD$Send
.ix Logical Message Complete
node.  This call is This call is a transmit hint for the specified node,
and may be ignored by NETCOMM. It is called the Socket Manager when a task
has completed a series of LD$Send's that compose a complete logical message.
.sp
.un 10
LD$RHnt (Receive Hint) is called with A containing the physical id of a
.ix LD$RHnt
.ix Receive Hint
node.  This call is a receive hint for the specified node, and may be
ignored by NETCOMM. It is called by the Socket Manager when some task needs
more data from a remote node before it can proceed.
.sp
.un 10
LD$RQB  REQUEST BROADCASTING data Count
.br
Also LD$Byt and LD$GBlk
.ix LD$Byt
.ix LD$GBlk
.ix LD$RQB
.ix Request Broadcasting Data Count
.pa
.un 10
LD$RByt (Receive Byte) is called with a PNID in A, and returns the next byte
from that node in A. If no bytes are available, the task blocks until one
is.
.ix LD$RByt
.ix Receives Byte
.sp
.un 10
LD$RBlk (Receive Data) is called with A containing a PNID, BC
.ix LD$Rblk
.ix Wait for Receive Data
.ix DE
.ix Destination Buffer
containing a byte count and DE containing a destination buffer.  The caller
is put to sleep until BC bytes have arrived from the node specified and
buffer is filled with them.
.br
for SKTMGR, should pass source/dest address+bank so direct xfers to
userspace are possible???
.sp
.un 10
.ix LD$CLnk
.ix Close Link
.ix PNID
.ix Transmit Buffer
.ix Receive Buffer
.ix ERR:UNUSEDDATA
.ix Link Closed
LD$CLnk (Close Link) is called with A containing a PNID.  All data remaining
in the transmit buffer is sent to the node, and then the link is shut down
in an orderly manner, sending an indication to the remote node that this has
occurred.  Control is not returned until the link is shut down.  If there is
data remaining in the receive buffer when the link is closed, an
ERR:UNUSEDDATA is returned.
.sp
.un 10
LD$BLnk (Break Link) is called with A containing a PNID.  The link is broken
.ix LD$BLnk
.ix Break Link
.ix PNID
.ix ERR:LinkBrokenLocally
.ix Socket Manager
immediately.  All tasks waiting on transactions with the PNID specified are
woken with ERR:LinkBrokenLocally error. The remote node is not notified. No
error is returned.  This call is made only when the Socket Manager
determines that the remote node is crazy.
.sp
.un 10
.ix LD$OLnk
.ix Open Link
.ix PNID
.ix LD$CLnk
.ix Error Exit
LD$OLnk (Open Link) is called with A containing a PNID. Contact with the
specified node is established (it can be broken with LD$CLnk). An error exit
occurs if no contact can be made due to lack of resources in the computer
attempting to open the link.
.br
ASLD doesn't follow these convventions??????
.sp
.un 10
.ix BIOS
.ix Disk Transaction
BIOS guarantees that disk transactions always take a short time (under
approximately 1 second). Therefore, BDOS disk transactions always complete,
.ix BDOS
.ix Disk I/O
and we need not multiplex most of BDOS when performing disk I/O. We do need
to multiplex the BDOS entry point so that character I/O can operate in
parallel with disk I/O.
.ix BDOS Entry Point
.ix Character I/O
.sh SECTION __: SOCKETS
.il Copyright (C) 1983
.ir Software Dynamics
.in 0
.pa
PIPELINES and SOCKETS
.ix Pipeline
.ix Socket
.ix Data Byte
.sp
A "Pipeline" is the name of a two-way communication path used for
interprocess communication between tasks in physically separated computers. A
"Socket" is the name given to one end of a pipeline. A socket cannot
simultaneously be the end for two pipelines. Because pipelines cannot be
established without the aid of two co-operating computers, virtually all
activity related to a pipeline must be performed by referencing one of the
two end sockets, so our discussion will be oriented towards sockets. Once a
pipeline between two sockets have been established, data bytes written to the
pipeline at one end (via a socket) can be retrieved, in exactly the order
written, at the other end of the pipeline. For generality, a pipeline may
connect two sockets in the same computer.
.sp
.ix Network Computer
.ix End Socket
.ix Systen Call
.ix Transmit Socket
.ix Receive Socket
Since networked computers have no control over one another, a pipeline must
be established via a co-operative process. This is accomplished by first
creating end sockets independently, and then connecting them.  Creating of
sockets is accomplished by execution of a system call to do so; both
computers involved must make their own call. The connecting activity occurs
automatically once the sockets are established. One of the sockets must be
created as a "Transmit Socket" (i.e., a socket looking for a service), and
the other end is set up as a "Receive Socket" (a socket willing to supply a
service).
.sp
.ix Socket Class
.ix Transmi Socket
.ix Receive Socket
Information as to which node contains the desired Receive Socket must be
supplied when the Transmit Socket is set up; how a task determines where a
Receive Socket can be found is not handled by the socket mechanism (it can
be handled by "built-in" knowledge or using a user-specific "phonebook"
service to find the desired node). A "Socket Class" is also specified when
setting up a transmit socket; this specifies the kind of service that a
suitable recieve socket will supply.
.ix Receive Socket
.ix Socket Class
.ix General Service
.ix Application-Specific Purpose
.ix Socket Class Code, Obscure
.sp
A Receive socket is established to supply a particular kind of service,
called a "Socket Class".  Two uses of socket classes are typical: one is
the class of "servers", i.e., a task is willing to provide a general service
(such as remote file access using SDOS/6800 or CP/M, etc.); the other use is
for application-specific purposes.   Servers specify a socket class using a
"well-known" (i.e., published) socket class, so they are easy to find.  
Sockets for application-specific purposes use obscure socket class codes, to
prevent accidental attachment to a Transmit socket looking for a general
service.
.sp
A Socket Class is simply a 64 bit integer. Servers may choose a socket class
which is simply 8 bytes of ASCII characters containing the name of the
service supplied. The system provides a service that will produce a random
64 bit integer for the choice of arbitrary names.  Because of the extremely
large space of possible Socket classes, two randomly chosen class names have
an extremely small probability of overlap; it is so small, in fact, that it
is lower than the probability of failure of the hardware, so any errors it
might accidentally introduce are by definition acceptable if one is willing
to accept conventional hardware failure rates. Assuming a population of 1
million sockets in a network, the probablility of an accidental collision in
socket names is:
.br
.im 1
           1-[1-1/(2^64)]^1e6 ~~ 1-[1-1e6/(2^64)] = 5.4e-14
.sp
For comparison, typical hard disk error rates are 1 bit in 1e12, so this is
roughly 100 times more trustworthy than a hard disk, when a population of a
million sockets is present.  Real networks probably have only 100 sockets
active at once, with corresponding increase in reliability.
.sp
Receive sockets will only be attached to a transmit socket with the same
socket class.  Once attached, it will remain attached until the transmit
socket is destroyed or dies (of host failure); similarly, the recieve socket
can be destroyed or die. Once the transmit socket is destroyed, the recieve
socket is useless, as it can never participate in another conversation. For
servers, this means that the serving node typically has several tasks
performing a specific service; each task sets up a recieve socket for the
same service and waits for a connection to be established.  Once established,
the task serves just one remote socket until the remote socket dies; then the
task destroys its local receive socket and creates another, and waits for a
new connection.
.sp
Should the possibility of false connection be too high, the server task
can require a "password" of arbitrary complexity be transmitted as the first
data in the pipeline, and simply destroy the receive socket if the password
is not correct, thus preventing response to tasks it does not wish to
serve.
.sp
Two special socket classes are used to establish socket-to-socket links
between nodes. The special socket numbers are 0 (for receipt of broadcast
messages) and 1 (for receipt of function requests directed at a particular
node).
.sp
Socket class zero of a node is used to receive messages broadcast to all
nodes. Broadcasts, using this socket system, must contain a complete logical
message in one physical transmission packet.  A Recieve socket must be
created for each Broadcast message recieved; if a node has no socket set up
to receive broadcast messages at the instant a broadcast is made, the node
simply ignores the message (other nodes, of course, may be ready to catch the
message). Socket class zero has the special property that it is receive-only.
.sp
No guarantee is made that a broadcast message will be received by any
particular node; in fact, even if a node receives a broadcast message, there
is no guarantee it will process it (reasons it might not include: space
limitations or lack of capability to process it). A socket can be
interrogated as the sending node's number, so a broadcast server can know the
source of the broadcast. A broadcast could, of course, also include a socket
class to which to respond.
.sp
Socket class one is used to receive function requests aimed at a specific
node. A function request specifies an operation, some parameters, and a
socket number in the transmitting node from which the function request
originated and from which the rest of function request can be obtained. This
socket number may also serve as the target socket for the response to the
function. Some "functions" are responses to broadcasts, and have the form
"Remember this...(FACT)" (An example might be
.br
.in 10
"Remember node 5 has volume id=PAYROLL"
.in 0
.br
in response to a "where's volume PAYROLL?" broadcast). Unlike broadcasts, a
function request can be indefinitely long (measured in number of bytes). To
allow flow control of function data (since it can be arbitrarily large, or
consume a significant amount of time before completion), a socket number on
the receiving side is automatically assigned when a function request is
received. All function data must be read through this secondary socket
number, and not from socket 1. However, the function data is all sent to
logical socket one.
.sp
Messages received for inactive sockets are ignored.
.pa
SOCKET OPERATIONS
.sp
.in 5
.un 5
CreateTransmitSocket(NodeIdentifier,SocketClass) returns a unique socket
capability to allow transmission to a socket of class specified by Socket
Class Number. NodeIdentifier specifies the path to locate the node containing
a matching receive socket. The SocketClassNumber must match the
SocketClassNumber of some socket constructed by a CreateReceiveSocket in the
target node.  The system will repeat attempts to establish a connection with
a matching remote socket until such a connection is established or until it
can determine that the remote node has failed. (?? how do we handle the case
that the remote node simply doesn't provide a matching service?? provide a
try count ?? a try for duration ??) NodeIdentifier="All" and SocketClass=0
specifies a brodcast transmission.
.sp
.un 5
CreateReceiveSocket(SocketClassNumber) returns a unique socket capability
for a socket that will automatically be connected to a Transmit Socket that
has been created with the same SocketClassNumber.
.sp
SocketClass 0 is used to receive individual broadcasts. Only one broadcast
request is received per CreateReceiveSocket(0) call.  If several broadcasts
might be received in a short space of time, the correct strategy to ensure
high probability of capturing them all is to perform several
CreateReceiveSocket calls, one for each unit of expected broadcast load. 
First come, first serve.
.sp
Responses to functions or broadcasts are transmitted via the socket that
received the request. Internal activity of the socket manager insures
correct operation. ***There needs to be a way to attempt creation with error
if can't satisfy immediately.
.sp
.un 5
SocketDataReady(SocketCapability)
returns the number of bytes of data waiting to be read from the specified
socket.
.sp
.un 5
ReadSocket(SocketCapability, Buffer, Count)
fills Buffer with Count bytes of data if socket capability is valid.
Task waits if not enough data available to fill out count bytes (unless the
socket is abnormally terminated, upon which a reply count and termination is
returned).
.sp
.un 5
ConnectEvent (Socket Capability) connects a socket "data arrived" event to a
task, so that task may later issue a Wait Event, and discover which socket
has data first. This allows an arbitrarily-sized pool of tasks to service an
arbitrarily-sized pool of sockets.
.pa
.un 5
WriteSocket(SocketCapability, Buffer, Count) writes Count bytes from Buffer
to remotely attached socket if capability is valid. If socket buffers are
full, the task waits until enough space becomes free. If the socket
connection is terminated abnormally, a termination code is returned, and the
bytes are not written.
.sp
.un 5
DestroySocket(SocketCapability) destroys socket after all data is
transmitted. Invalidates the socket capability.  An error is returned if
some data is still available to be read, but the socket is destroyed anyway.
.sp
.un 5
ChangeSocketLocation(SocketCapability,SocketCapability) allows an activity
to move the socket from one node to another. Currently not implemented.
.in 0
.pa
SOCKET MANAGERS
.sp
A socket manager is the mechanism that implements logical sockets. There is
one socket manager per node. Each socket manager communicates with other
socket managers via an error free physical pipeline (not to be confused with
the logical pipelines the SocketManagers implement; the physical pipeline is
implemented by the physical network link driver). Socket managers perform
socket operations by exchanging messages with other socket managers over
these physical pipelines. Note that the SocketManager-To-SocketManager
pipeline only guarantees that data sent by one socket manager to another is
received correctly; it does NOT guarantee that the receiver has room to keep
the data (in contrast, logical pipelines implemented by the socket managers
never lose data).
.sp
A socket manager is composed of several mechanisms, and overlaps the packet
manager somewhat.  The mechanisms include:
.sp
.in 7
.un 3
1.~Sockets (SKT:).  A set of Socket descriptors contain all the information
needed to keep track of a particular socket.  A fixed number of
socket descriptors are built into a system at Sysgen time; if a node
needs more sockets to operate efficiently than it currently has, it
will require a new Sysgen to correct the problem.  Socket content
is updated by Socket manager code executed by user tasks, or by
Socket manager code executed by special "Listener Tasks".
.sp
.un 3
2.~Listener Tasks. There is one Listener Task associated with each Node
Representative Block (NRB; see packet manager for more details). An NRB
represents another remote node, and holds all the information required to
communicate with that node, including buffers for transmitting and receiving
data to/from that node. the listener task de-multiplexes the data stream from
the remote node into the appropriate target sockets, and also copies data
from local sockets to the remote node as space becomes available.
.in 0
.sp
The code collectively executed by user tasks and listener tasks is
known as the "socket manager".  Even though multiple tasks execute
the code, one can view the "socket manager" as a single entity.
Only the code itself need deal with the ugly details of who actually
shuffles data around.  Throughout the rest of this document,
reference to the "socket manager" refers to this nebulous entity.
.pa
Socket managers exchange only one type of message with one another.
.sp
.pw 120
.ll 100
.im 4
  1 byte       5 bytes         2 bytes  2 bytes
________________________________________________
| FNCODE | SOCKET CAPABILITY | RCVDOK | RCVRDY | ...
|________|___________________|_________________|
.sp
.im 4
          2 bytes              <---XMITCNT-------->
         ___________________________________________
      ...| XMITCNT | XMITBASE |     XMITDATA       |
         |_________|__________|____________________|
.sp
.ll 65
.pw 85
No checksum is needed as the pipeline is error-free (transmission errors are
handled transparently by the physical link driver).
.sp
.in 7
.un 7
The FNCODE field determines how the message is processed.
.sp
.un 7
The socket capability field holds a socket capability for a socket in the
transmitter or the receiver's node (depending on the function code). The
socket selected is used as a target for the data in the message.
.sp
.un 7
RCVDOK is the number of bytes received from the socket for which this
message is addressed.  For "First Message", RCVDOK must be zero.
.sp
.un 7
RCVRDY gives the receiver of the message an idea of how many data bytes can
be sent to the originating socket (0 to 65535).
.sp
.un 7
XMITCNT contains the number of data bytes sent in this message. If
XMITCNT=0, then neither XMITBASE or DATA fields are sent.
.sp
.un 7
XMITBASE is the index [of the first data byte in the message] in the virtual
string being sent to the target socket, modulo 65536.
.sp
.un 7
DATA is the data content of the message. This data is placed in the
receiving socket's buffer, to be taken by a task via a READ operation.
.sp
.in 0
.pa
Currently defined socket manager function codes include:
.sp
.in 7
.un 2
0~Normal continuation; socket capability="TO" socket
.br
.un 2
1~First message; socket capability="FROM". Meant for Function invocation.
.br
.un 2
2~"No such socket"; socket capability="TO" socket.
.br
.un 2
3~Assign socket target; specifies "TO" socket's target to be changed to
include "FROM" field. Otherwise treated as ???????
.sp
.in 0
A socket manager acts upon requests/data received from several different
points:
.sp
.in 7
.un 3
1.~Task requests for: CreateTransmitSocket, CreateReceiveSocket,
SocketDataReady, ReadSocket, WriteSocket, and DestroySocket.
.br
.un 3
2.~Physical link drivers, indicating that a link connection to node has
failed.
.br
.un 3
3.~Physical link drivers, indicating that a broadcast message has been
received.
.br
.un 3
4.~Physical link drivers, indicating that data bytes from a particular node
have been received.
.in 0
.sp
A task request for CreateXXXSocket causes the Socket Manager to locate a
free socket (task freezes if none). Once a free socket is located, the
socket manager manufactures a new capability for that socket and returns it
to the task. (This activity is performed at task level).
.sp
A ReadSocket request will cause data to be transferred from a socket
buffer to the task. If the task requests too much data to be satisfied, then
a continuation message is framed and sent to the remote socket, and the task
is suspended until the data becomes available. If the socket capability
presented is no longer valid, an EOF error is returned. (User task does all
this.)
.sp
A WriteSocket request causes data to be transferred from a task to the
write buffer of socket. If no buffer space is available for the socket, the
task waits until there is enough. Once all data is transferred to the socket
buffer, the user task can proceed. A background task (force) copies data from
the socket buffer to the Node Representative buffer, locking the NRB transmit
buffer to prevent other socket messages or socket manager responses from
being interleaved incorrectly.
.sp
A DestroySocket request causes a "No Such Socket" message to be transmitted
to the appropriate receiver. (User task does this.)
.sp
A "Node Died" signal is handled by the node representative's listener task.
This task marks all the currently open sockets to the node as "dead", and
marks the node as inactive.
.pa
A "Broadcast Receipt" is handled by the listener task for "Node" ZERO. The
listener task interprets the request, frames a suitable reply, locks the
transmit buffer of the NRB of the broadcaster, inserts its message, unlocks
the buffer, and falls asleep.
.sp
Bytes received from a node are handled by that node's listener task.
.sp
.ix RCVPOS
.IX XMTPOS
RCVPOS is number of bytes received without error from another sender. XMTPOS
is number of bytes sent that have been acknowledged reliably.
.sp
Invariants:
.br
.ix Invarients
Receiver's RCVPOS > = Transmitter's XMTPOS at all instants of time (unless
RCVR + XMITTER are out of step.)
.pa
Node Listener Task
.sp
There is one task per NRB, known as the "listener" task.  It is this task's
responsibility to listen to everything sent to it from the node (for which
the NRB is representative), and perform the appropriate "socket manager"
functions.
.sp
The listener task wakes up for any of the following reasons:
.sp
.in 6
.un 3
1.~The link driver has determined the node represented by NRB has died (many
transmissions but no response).
.sp
.un 3
2.~Data has arrived from the represented node.
.sp
.in 0
In case #1, the listener task will mark (delete?) all sockets connected to
the represented node. User tasks using the deleted sockets will find out
that the socket is dead when they perform a read or write.
.sp
In case #2, the listener task must read the data bytes, perform the proper
socket functions, and distribute the data bytes to the proper sockets.
.sp
If the listener task sees a function code or "Normal Continuation", it
verifies the validity of the socket capability. If invalid, the listener
task frames a "No Such Socket" response and sends it back. If valid, then
transmit buffers for the socket are freed in accordance with the RCVDOK
field. RCVDOK specified how many bytes of the transmit stream were retained.
Then XMIT data is placed in the proper socket's receive buffer.
.sp
There may not be enough room to keep all the transmitted data; the part for
which there is no room is thrown away, and a count for the retained part is
computed, and added to a retained but not acknowledged total kept in the
SDB (Socket Descriptor Block). (A user task upon issuing a read which cannot
be satisfied, will cause a response containing the computed sum to be sent
back to the originating node as a RCVDOK quantity, or it may get returned
along with new user data to be transmitted). Having received an explicit
response from the other socket, the listener task will package a reply
containing socket transmit data only if some transmit data is still left to
be sent. (This technique effects a flow control).
.sp
If a function code "No Such Socket" is seen, the socket capability is tested
for validity and discarded if invalid. If valid, the socket selected is
marked as "remote socket doesn't exist". The user task will discover this
when a read or write is attempted.
.pa
A function code of "Assign Socket Target" causes the selected socket to have
its target socket re-assigned (if the "TO" capability is valid), and then
the message is treated as a "Normal Continuation".
.sp
A "Function Invocation - First Message" causes the listener task to locate a
free socket, assign it to the socket transmitting the function, arrange for
the function task (waiting for a new function request socket to appear) to
wake up. In the case that no socket is available to handle the function
request, a "No Function Socket Available" message is framed and returned,
and the function invocation message is ignored.
.sp
If a "No Function Socket Available" message is received, all sockets trying
to obtain a function request initiation (i.e., those still aimed at Socket
1) are marked with an X second fuse. When the fuse goes off, the function
requests will be re-transmitted.
.sp
When a user task issues a read/write to a socket (a), and the read request
is not satisfied or a non-zero number of bytes are written, then a message
is framed for transmission to the matching socket (if this socket(a) is
newly assigned because of a function invocation, an "Assign Target Socket"
message is sent instead of "normal continuation"). Receipt by the remote
socket of this message will cause new data to flow to Socket A. In this
manner, unnecessary exchanges between sockets are minimized.
.sp
.pa
SOCKET PRIMITIVES - EXAMPLES
.sp
.in 3
.un 3
.pw 120
.ll 100
1.~Task needs to broadcast and wait for response.
.im 7
          ....
     socketid = Allocate Socket (0,16)  -- allocate a socket for broadcast
     write (socket id,broadcast message -- send the broadcast
          ....                          -- Only one write allowed!!
     Response = Read (Socket id)        -- Get response to broadcast
          ....
      close (socket id)                 -- No more responses needed.

.sp
.un 3
2.~Task needs function from node N (node number N located via broadcast)
.im 9
          ...
       socketid = Allocate socket (N,1) -- "1" = "function" socket
          ...
       write (Socketid, message)        -- send first part of message
       write (Socketid, message part 2)
          ...
       response = Read (Socketid)       -- get result
          ...
       close (socketid)                 -- close the response
.ll 65
.pw 85
.sp
3.??????????????
.in 0
Task T wants to establish pipeline to Task T' in node N
.sp
.pw 120
.ll 100
.im 7
T:  sktcapability = Allocate Socket ((n,1,0)) -- use for skt
    write (sktcapability, "Pass this socket # to T', please")
           ...
    begin reading and writing f task T' via sktcapability
           ...
    close (sktcapability)
           ...
.ll 65
.pw 85
.pa
.pw 120
.ll 100
Over in node N:
.sp
.im 14
Function task:
   |
   |     Loop: fnskt <--  next fn request
   |           fork loop
   |                fncode = Read (fnskt)
   |           case fncode of ...
   |           |
   |           | ...
   |           | "Pass this socket # to T'": stuff fnskt into
   |           |            task T's mailbox
   |           |            Suicide
   |           endcase
   |
End Function
.sp
Each node can have up to 256 sockets, numbered 0 to 255.
.sp
.in 3
.un 3
4.~Broadcast receiver task
.sp
.pw 120
.ll 100
.im 6
                  Socketid=Allocatesocket(0,0)--give me ownership of socket 0
Lotsatasksdothis: (sending node,sendingsocket,message):=Read (socketid)
                  Case message of ...
                   ...
                  typicalmessage:begin -- code to handle particular case
                  answerid:=allocatesocket (sending node, sending socket)
.ll 65
.pw 85
.sp
.pa
Q: Is it okay to add capability encryption bytes to messages from
performance standpoint?
.sp
W/O: ----> 14 bytes of syscall
.br
.im 19
            1 byte of fn code = 39 bytes = 390 bits
            2 bytes of TO/FROM             13.9 ms
     -------------------->
            preamble+CRC=12 bytes
     <-------------------
            resptosyscall -1
            2 bytes TO/FROM -2
            preamble+CRC -12
            50 bytes     -50
                         ---
                          65 bytes x 10 bits = 650 bits
                                               6.5 ms
                      x    1 ms syscallexec
                           5 ms fetch read data
                         ---
                       +  65
                       +  3.9
                         ---
                         16.4 ms
.sp
With:-----> add: 8 bytes to each message for capability protect
.br
                16 bytes total --> 160 us = .16 ms
.br
                                   1% overhead
.in 0
.pa
Who gets a SYSCALL that we don't understand?
.sp
Broadcast to find out?
.br
Locate one ahead of time?
.br
Preallocation?
.br
Wired in knowledge?
.br
Know implicitly for each individual call?
.sp
???Currently, this is NOT a problem!!!
.sp
No such syscalls!!
.pa
Assume:
.sp
BROADCAST MESSAGE IS ALLOWED TO BE LARGER THAN A SINGLE PACKET.
.br
Then broadcast receives must hold partial messages and ask for
re-transmission of past they did not hear (correctly). (These partial
messages tie up space in the receiver node).
.sp
The transmitter, on hearing a re-broadcast request, could re-broadcast just
the part needed (at which point a message to a specific node need be sent,
of the broadcast would have to be ignored by those machines that already
have the broadcast (assuming they can distinguish between a broadcast and a
re-broadcast of the same message). Note tha the broadcaster cannot (as is
usual with SDLP) dump the part of the broadcast buffer saved by the
receiver, as a different receiver may not have gotten the first part of the
message. (So, buffer space in the transmitter is also tied up). So we might
as well re-transmit the whole request since several listeners could want
re-transmission, it would be more efficient to re-broadcast than to send the
entire message (or parts of it) to all parties needing it, one at a time.
Finally, to reach those nodes that did not recognize it (as a broadcast, or
legal, or whatever), it will need to be re-broadcasted anyway. Since no
explicit action will cause this re-transmission, a timer must cause
re-transmission in broadcast mode. This being the case, asking for
re-transmission is redundant (since it will get re-transmitted anyway), so
receivers might as well ignore any incomplete brodcast message. Conclusion:
receivers should not ask for or retain partial broadcasts.
.sp
.ce
===> No partial broadcasts.
.sp
Assume:
.sp
BROADCAST REPLIES ARE ALLOWED TO BE LONGER THAN A SINGLE PHYSICAL PACKET.
.sp
Then broadcast responder (BR) must be prepared to receive acknowledgements
of messages and to respond with more of the messages.
.sp
Several possibilities arise:
.sp
.in 3
.un 3
a.~Broadcast Responder never hears acknowledgement for complete message. It
times out and throws away the response.
.sp
.un 3
b.~Broadcast Responder hears acknowledgement for complete response. Goes
through conventional close operations.
.sp
.un 3
c.~Broadcast Responder hears request for another part of message, and sends
it. (Broadcaster will selectively listen for just this transmission).
.sp
.in 0
Looks okay.
.sp
Broadcast responses must clearly label themselves as such, and their content
should indicate uniquely (over all posibl broadcast responses) so that a
broadcaster receiving an old response, can detect hat it is inappropriate
and throw it away. This it does by reading a capability from the broadcast
response.
.SH SECTION --: SDLP: A Simple Data Link Protocol
.pa
.tc
.ce
SDLP -- A SIMPLE DATA LINK PROTOCOL
.ix SDLP
.ix Data Link Protocol
.ix Bidirectional Exchange of Data Bytes
.ix Error-Free Exchange of Data Bytes
.sp
SDLP is a simple, data link protocol.  It provides for the bidirectional,
error-free exchange of data bytes (byte= 8 bits) between two or more
computers connected to a single, common party line.
.sp
.ix Underlying Bit-Exchange
.ix USART Circuits
.ix Data Rates
.ix Networking Processors
SDLP has the virtues of being fairly simple (in comparison to line protocols
such as IBM Bi-synch), very forgiving, and provides a high potential
throughput.  It does not dictate an underlying bit-exchange protocol, and
therefore can be used with Universal Asynchronous/Synchronous
Transmitter/Receiver (USART) circuits (for data rates of 300 baud over
modems to 100Kb local serial) or with faster parallel interfaces (computer
or DMA channel limited).  These characteristics make SDLP particularly
attractive for use when networking microprocessors. Many SDNET
implementations use SDLP (or slight variations, depending on hardware).
.sp 2
.tc
Communication Mediums appropriate for SDLP
.ix SDLP, Appropriate Communication Mediums
.sp
.ix SDLP, Implementation
.ix Overruns
.ix Party Line Bus
.ix Full Duplex Link
.ix Echo Reception
.ix Bit Serial
.ix Synchronous
.ix Asynchronous
SDLP can be implemented in any environment in which a communication medium
exists which can exchange 8 bit data bytes between computers.  Arrival of an
8 bit data byte must be signalled to the receiving computer (arrival of more
than one data byte without computer processing of the first should be
detectable, but only degrades performance in the presence of "overruns" if
not available).  Transmitted data must be receivable by the transmitting
computer (for echo checking) if a party line bus (for more than 2 computers)
is used.  If a full duplex link is used, echo reception is unnecessary, but
only 2 computers can use the link.  The transmission medium may be bit
serial, synchronous (with or without bit stuffing) (for medium bandwidth),
asynchronous (low bandwidth, low cost), or it may be paralell 8 bits (high
bandwidth).
.sp 2
.tc
Concepts
.ix Host Computer
.ix Proxy Computer
.ix Nodes
.ix Ethernet
.sp
SDLP is used between two computers to effect a (series of) conversation(s). 
The purpose of a conversation is to transmit (exchange) an ordered sequence
of data (bytes) from one computer to another.  The computers may be hosts,
or may simply be proxies for the hosts.  The computers actually involved
with SDLP will be referred to as "nodes". Conversations between multiple
pairs of nodes may simultaneously be extant.  Many of the ideas for SDLP as
a protocol are taken from HDLC and Ethernet[1].
.sp
.ix Synchronization with Another Node
Each conversation consists of one node establishing synchronization with
another node, exchanging some data, and finally terminating the
conversation.  The conversation is effected by an exchange of a series of
messages.
.sp
.ix Low-Level File Transfer Protocol
.ix End-Of-File Signal
.ix Target Node
A single conversation may be used to effect a low-level file transfer
protocol, in which the data in a file is completely transferred from one
node to another.  Here, conversation termination is used as an End-of-file
signal.  Several conversations are then needed to move several files, with
some independent mechanism for determining the source of each file and what
happens to it in the target node.
.sp
A conversation may also be used as the base of a higher level protocol
between processes in two nodes; this is the method used by SDNET.  In this
circumstance, conversation termination is used as a signal that the
terminating node is effecting an orderly shutdown, and is an infrequent
event.
.sp
.ix Data Exchange
.ix Virtual Data Stream
.ix Target Node
.ix Transmit Index Number
Data exchange between two nodes is based on a concept of a virtual data
stream.  Each node is considered to be transmitting a stream of data bytes
to another node (for each source node, there is one conceptual stream per
target node). The first data byte (in a stream) to be sent in a conversation
is numbered zero, the second numbered "1", and the Nth numbered N-1.  This
index is called the transmit index number.
.sp
.ix Receive Index Number
Likewise, the first data byte received during a conversation is numbered 0,
the second numbered "1", the Mth numbered M-1. This index is called the
receive index number.  The transmit and receive streams may be indefinitely
long.
.sp 2
.tc
Message Format
.sp
.ix Node Addresses
.ix Data Receipt Acknowledgements
.ix Flow Control Information
.ix Cyclic Redundancy Checksum
.ix Messages, Noise Corruption
.ix Messages, Collision Corruption
Messages passed from one node to another contain the source and destination
node addresses, data receipt acknowledgements, flow control information, and
(optionally) data.  Each message is protected by a Cyclic Redundancy
Checksum to prevent action being taken on messages corrupted by line noise
or collisions.  All messages exchanged in a conversation have a format as
follows:
.sp
.pa
.pw 120
.ll 100
.ix Message Format
.im 42
# BYTES        CONTENT         DESCRIPTION

            --------------
   1        !     TO     !  Who message is for (first
            !------------!  byte transmitted)
   1        !    FROM    !  Source of message
            !------------!
   1        !   IDCRC    !  CRC covering TO/FROM fields
            !------------!
   1        !  CONTROL   !  Special action to be taken
            !  FUNCTION  !  while processing message.
            !------------!
            !            !
   2        !  RECVDOK   !  Receive Index of first data
            !            !  byte not received correctly
            !------------!  from "TO" node (modulo 2^16)
            !            !
   2        !  RECVRDY   !  Suggested number of data
            !            !  bytes to be sent by "TO" node
            !------------!
            !            !
   2        !  XMITCNT   !  Number of data bytes in this
            !            !  message ()
            !------------!
   2        !            !
(0 if       !  XMITBASE  !  Transmit index of 1st data
XMITCNT=0)  !            !  byte in this message, modulo
            !------------!  2^16
            !            !
XMITCNT     !     D      !  Data byes in order determined
 bytes      !     a      !  by increasing transmit index
            !     t      !
            !     a      !
            !            !
            !------------!
            !            !
   2        !    CRC     !  Cyclic redundancy checksum on
            !            !  all other bytes of message
            !            !
            !------------!  A possible CRC polynomial=:11021 (CRC-(CIT)



.ll 65
.pw 85
.pa
.ix TO Field
.ix Broadcast Message
.ix Party Line
The TO field is used to indicate the address of the node for which the
message is intended.  A TO field of :00 is a broadcast message. Up to 255
nodes may be connected to a party line.
.sp
.ix FROM Field
The FROM field indicates the address of the node that sent the message.
.sp
.ix XMITCNT
.ix Transmit Index
.ix Last Data Byte
.ix Receiver Acknowledgement
The amount of data sent in a message is recorded explicitly in the XMITCNT
field.  A message may carry from zero to 65535 data bytes, however, the
transmit index of the last data byte sent must not be more than 65535 bytes
beyond the last transmit index acknowledged by the receiver. If XMITCNT=0,
the XMITBASE and data portions are not sent.
.sp
.ix Transmit Index Number
.ix First Data Byte
.ix XMITBASE Field
.ix Modulo
The transmit index number of the first data byte in the message is recorded
in the XMITBASE field.  Since the transmit index can be arbitrarily large,
the actual value placed in this field is the transmit index modulo 2^16.
.sp
.ix DATA Field
.ix Transmit Virtual Stream
The DATA field contains bytes from the FROM node's transmit virtual stream.
.sp
.ix RECVDOK Field
.ix TO Node
.ix Transmit Index Numbers
.ix Transmit Index Value Modulo
The RECVDOK field indicates that the FROM node has correctly received and
retained all data bytes (sent by the TO node) with transmit index numbers up
to but not including the TO node's transmit index value given by the RECVDOK
field. Since the transmit index number may be arbitrarily large, the actual
value listed in the field is the transmit index value modulo 2^16. The
receiver must not be allowed to fall more than 65535 bytes behind the
transmitter.
.sp
.ix RECVRDY Field
.ix TO Node
.ix FROM Node
.ix Flow Control
.ix Literal Limit
.ix Buffer Space Available
The RECVRDY field indicates that the TO node can transmit RECVRDY data bytes
in its next message to the FROM node. This field is used to effect flow
control (of data) between two nodes.  The TO node may use the value as a
literal limit; it may predict how much more or less buffer space will
actually be available at transmit time (in the FROM node) and transmit a
correspondingly adjusted number of data bytes; or it may use an adaptive
calculation with the RECVRDY values used as feedback, etc.  This field is
intended to be used only as a hint, and may actually be ignored by the TO
node with the only consequence being possible degraded throughput. Normally,
actual buffer available space in the FROM node is recorded in this field.
.pa
.tc
SDLP Protocol
.ix SDLP Protocol
.ix FROM Node
.ix TO Node
.ix RECVDOK Field
.ix XMITBASE
.ix Transmit Index
.ix Virtual Transmit Stream
.ix Real Implementations
.ix Data Buffer
.ix RECVDOK Value
.ix Confused Node
.sp
When a (FROM) node is ready to transmit (to TO node), it generally uses the
value specified in the RECVDOK field in the last message received from the
TO node as the XMITBASE (transmit index) of the first data byte to be sent. 
The number of data bytes sent in a message depends on the size of the FROM
node's transmit buffer, with limits imposed by limits on the value in the
XMITCNT field.  Assuming the FROM node has complete access to the entire
virtual transmit stream, sending the appropriate data is simple.  Real
implementations require a transmit data buffer; data bytes are placed in
this buffer by some sending process, and are not dropped from this buffer
until an acknowledgement (RCVDOK value) for the bytes to be dropped is
received correctly.  At transmit time, the oldest byte in the buffer usually
has a transmit index number equal to the XMITBASE to be sent (in no case can
the index of the oldest byte be greater than the last received RECVDOK value
unless the other node is confused).
.sp
.ix Error in TO Field
.ix CRC Value Verified
.ix Message Fowarding
.ix Received Node
.ix Addressed Node
.ix RECVDOK Field
.ix Transmit Data Buffer
.ix XMITCNT
.IX XMITBASE
.ix Control Message
When a message arrives, it is not interpreted until the CRC value has been
verified (there might be an error in the TO field!) [note that message
forwarding, if needed, could be done in real-time without CRC verification].
If the CRC is incorrect, the message is ignored. (To enhance performance, if
the CRC is incorrect, but the IDCRC is correct, then what amounts to
"negative knowledge" can be sent to the sender, instead of just timing out.
Since the majority of bad message bits are found in the bulky body part of
the message, this enhances the performance of the network in the presence of
errors). If the receiving node is not the addressed node, the message is
ignored.  The RECVDOK field is used to determine which bytes may be removed
from the transmit data buffer. If a control message is received, it is
processed as specified in the section on control messages.  If a message is
not a control message, and XMITCNT is non-zero, some data bytes have
arrived.  Using XMITBASE, the proper placement of the received data bytes in
the received data stream can be determined.  In the general case, the data
part of the message can be broken
.ix Data Redundantly Transmitted
.ix New Data
.ix FROM Node
.ix Large Data Message
.ix Receiver Buffer Limits
.ix Incorrect CRC
into three sections: data redundantly transmitted, new data for which buffer
space is available, and new data for which buffer space is not available. 
Redundantly transmitted data may show up because the acknowledgement for
that data was lost, and so the FROM node retransmitted the data.  A (large)
data message may contain more data bytes than the receiver can buffer, and
so some data bytes may have to be thrown away (note that buffer limits do
not prevent the retainable part of the data from being kept or the CRC from
being checked, assuming a cleverly designed receiver program!).  The amount
of data bufferable is computable in real time, as the message is received,
even if the CRC is not correct; this merely requires the receiver to
tentatively place received data into its receiving buffer, and either adjust
or not adjust the real buffer pointers once the CRC has been verified.  The
transmit index of the first data byte not kept will be returned in the next
message to the FROM computer as the RECVDOK field.
.PA
.tc
Control Function Codes:***CHECK ACCURACY**
.ix Control Function Codes
.pw 120
.ll 100
.sp
.im 11
       0          No special function
       5          Terminate conversation
       4          Agree to terminate                    ACKSOON??
       3          Want to terminate
       2          Re-synchronized
       1          Resynchronize request
       7-:FF      Reserved
       6          Resynchronize request; also terminates
                  conversation. Used to initiate a conversation,
                  send data, and terminate a conversation all in
                  one packet.
.ll 65
.pw 85
.sp
Note that a control message may contain a transmit data acknowledgement.
.sp
.ix Respective Virtual Transmi
.ix Receive Virtual Positions
.ix Resynchronize Control Message
.ix Normal Data Exchange
When one node first decides to open a conversation with another, it must
ensure that both nodes agree on their respective virtual transmit and
receive virtual positions. It does this by transmitting a "Resynchronize"
control message, zeroing its virtual transmit and receive positions, and
waiting for a "Resynchronized" response. Data may be transmitted in a
re-synch message. On receipt of the correct response, normal data exchange
may continue.
.sp
.ix Receiving Unexpected Resynchronize
.ix Zero Virtual Transmit
.ix Zero Receive Position
A node receiving an unexpected "resynchronize" request zeros its virtual
transmit and receive positions, and replies "resynchronized".  A
"resynchronize" signal must be passed to the local process that was using
the data link.  Further "resynchronize" messages (without intervening
non-resynch messages) cause a "resynchronized" response, but do not
signal the local process again.
.sp
.ix Lost Resynchronize
.ix Receiving Node
If the "resynchronize" request is lost, the sender will not receive the
proper reply and will eventually re-transmit it. If the "resynchronized"
response is lost, likewise, except that the receving node will already be
synchronized.
.sp
If both nodes decide to resynchronize simultaneously, then one of the two
will receive a "resynchronize" message before the other; that node knows
that the originating node also desires to resynch and simply transmits the
proper reply.
.pa
.ix Terminating a Conversaion
.ix "Wants to Terminate"
.ix "Agrees to Terminate"
.ix "Terminate Conversation"
.ix Failure of the Data Link
.ix Failure of A Node
At some point in time, one of the two nodes will decide to terminate a
conversation (due to an orderly shutdown of that node, etc.).  Termination
is performed by an exchange of three messages: "Wants to terminate", "Agrees
to terminate", and "terminate conversation".  This exchange sequence
guarantees that both nodes agree to terminate, and that termination can be
distinguished from failure of the data link or failure of a node.
.sp
The termination sequence may not be started by a node until it has received
acknowledgement for all the data bytes it has sent.
.sp
.im 1
       NODE1                           NODE2
.im 5
               "Wants to terminate" -->

               <-- "Agrees to terminate"

               "Terminate conversation" -->

.sp
.ix "Wants to Terminate"
.ix "Agrees to Terminate"
.ix End-Of-File
.ix "Terminate Conversation"
A node receiving "Wants to terminate" replies "Agrees to terminate" (and
signals its local process with an End-of-File).  A node receiving "Agrees to
terminate" responds "Terminate conversation" if it had just sent "Wants to
terminate".
.sp
.ix "Incorrect Termination"
If node1 does not hear "Agrees to terminate" in response to "Wants to
terminate", it simply re-transmits its request.  If no correct response is
ever obtained, the conversation is effectively terminated, but node1 is not
sure that node2 knows that the conversation was supposed to be terminated,
and so signals its local process with an "incorrect termination".
.sp
.ix "Incorrect Termination"
If node2 never receives the "Wants to terminate", and cannot establish
contact with node1 again, it is not sure that node1 had no more to say, and
likewise signals its local process with "incorrect termination".
.sp
Otherwise, the "Wants to terminate" message and the "Agrees to terminate"
messages are eventually exchanged, and both nodes know the other intended to
terminate.
.sp
.ix Ignore Data Link
The "terminate conversation" message is only transmitted once by node1,
after which node1 is free to ignore the data link entirely.  If node2
receives the "Terminate conversation" message properly, it too may ignore
the data link.  If the "Terminate conversation" message does not arrive
correctly at node2, it at least knows that node1 intended to terminate the
conversation and that no data was lost, so no error is signalled to the
local process.
.PA
.ce
SDLP State Transition Table
.sp
.pw 130
.ll 110
.LM 4
.IM 25
                MESSAGE TYPE RECEIVED-------------->

Current
State      RESYNCH   RESYNCHED NORMAL     WANTQUIT  AGREEQUIT QUIT     OTHER

DEAD       DEAD      DEAD      DEAD       DEAD      DEAD      DEAD     DEAD

AGREEQUIT  DEAD      QUIT      QUIT       AGREEQUIT QUIT      DEAD     QUIT

WANTQUIT   DEAD      QUIT      WANTQUIT   AGREEQUIT QUIT      DEAD     QUIT

INACTIVE   RESYNCHED QUIT      QUIT       QUIT      QUIT      DEAD     QUIT

ACTIVATING RESYNCHED ACTIVATED ACTIVAT-   ACTIVAT-  ACTIVAT-  ACTIVAT- ACTIVAT-
                               ING        ING       ING       ING      ING

RESYNCHED  RESYNCHED QUIT      CONNECTEDx AGREEQUIT QUIT      DEAD     QUIT

ACTIVATED  DEAD      ACTIVATED CONNECTEDx AGREEQUIT QUIT      DEAD     QUIT

CONNECTEDR DEAD      QUIT      CONNECTEDx AGREEQUIT QUIT      DEAD     QUIT

CONNECTEDS DEAD      QUIT      CONNECTEDx AGREEQUIT QUIT      DEAD     QUIT

*QUIT


.SP
.LM 10
.ll 65
.pw 85
*QUIT state sends one message and then goes "dead" state immediately; so it is
impossible to get a message in this state.
.sp
ACKSOON Code
.pa
.tc
Full Duplex Environment
.ix Full Duplex Environment
.sp
.ix Delays Between Messages
.ix Decision to Transmit
.ix Broadcast Feature
.ix TO Field Ignored
.ix FROM Field Ignored
In a full duplex environment, either node may send at any time. Delays
between messages and the decision to transmit or not are entirely left to
the implementer; usually, choices are made in such a way as to maximize
throughput.  In this mode, the broadcast feature is useless, and the TO and
FROM fields can be ignored.
.sp 2
.tc
Half Duplex Party Line Environment
.ix Half Duplex Party Line Environment
.sp
.ix Ethernet Operation
.ix BYTETIME
.ix Conflicts
.ix Improper Echo
.ix Detection of Conflects
.ix Resolution of Conflicts
.ix Quadratic Backing-Off of Timeouts
This mode of operation is virtually Ethernet[1] operation. Bytes in a
transmitted message are sent with a maximum spacing of BYTETIME.
Availability of the medium for message transmission is determined by noting
whether the medium has been quiet for a period longer than BYTETIME. 
Conflicts are detected by the improper echo of a transmitted message byte.
Detection of conflicts causes the detecting node to transmit a signal that
will cause other transmitting nodes to detect a conflict.  Resolution of
conflicts are done by the "quadratic backing-off" of timeouts[1].
.sp 2
.tc
Protection Issues
.ix Protection Issues
.sp
.ix Encrypted Message Content
.ix Decrypted Message Content
To obtain maximum protection in a network, the message content may be
encrypted by the transmitter and decrypted by the receiver.
.sp 2
.tc
Advantages of SDLP
.ix Advantages of SDLP
.sp
The data stream orientation of SDLP have several advantages:
.sp
.ix Acknowledgement of Message Received
.ix Data Byte Limit
.in 3
.un 3
1)~There is no (small) limit on the amount of data sent in successive
transmissions without received acknowledges.  Many protocols require a
one-for-one acknowledgement of each message; SDLP requires only
acknowledgment of data received, regardless of the number of actual messages
transmitted. SDLC (an IBM protocol) imposes a 7 message limit; SDLP imposes
a 64,000 data byte limit.
.sp
.ix Large Amounts of Data Acknowledgement
.un 3
2)~Lost acknowledges do not necessarily affect message throughput; any
single acknowledge may acknowledge large amounts of data.
.sp
.ix Buffer Space Limitations
.ix Flow Control Feedback
.un 3
3)~Buffer space limitations in the receiver do not prevent receipt of data;
it merely limits how much may be accepted from any single message. 
Extremely dumb nodes (with small amounts of storage) may be attached to the
network as a result.  Flow control feedback can be used to limit this
problem, but flow control feedback does not prevent progress from being
made; it merely decreases the potential throughput.
.sp
.ix Automatic Resynchronization
.un 3
4)~Automatic resynchronization of the transmitter and sender occurs with
each message, increasing the robustness of the protocol.
.sp
.ix ARPANET-Like Environment
.ix Reassembly Lockup Problems
.ix Actual Message Size
.ix Logical Message Size
.ix Buffers Tied Up
.un 3
5)~If SDLP is used in an ARPANET like environment, reassembly lockup [2]
problems are easily dealt with.  First "reassembly" problems occur because
of the mismatch between actual message size and logical message size.  SDLP
pushes logical messages up to a higher protocol level, reducing the problem
to one of delivering the data stream correctly. This, in turn, reduces the
number of buffers tied up while waiting for a "missing" piece to arrive
(since all parts of the data stream received up to the "missing" part can be
passed from a node to its host (or local process).  Parts of the message
received beyond the missing section can be dropped by a node if it needs the
buffer space, affecting only the throughput.
.in 0
.pa
.tc
An RS232 SDLP Implementation
.ix RS232 SDLP Implementation
.sp
.ix RS232 Interface
.ix ACIA
.ix Real-Time Data Acquisition Requirements
.ix "Break" Detection
.ix "Overrun" Detection
Each RS232 interface used an ACIA (a 6800 microprocessor family part) to
asynchronously transmit/receive serial data bytes.  ACIAs have a nice,
single character buffering property (removing really stringent real-time
data acquisition requirements), the capability to send and detect a "break",
and to detect an "overrun" (receipt of two bytes without the intervention of
the microprocessor).
.sp
Determination of line availability for transmission was done by checking the
"received a byte" status of the ACIA; if reset, no recent data has arrived
and so the line must(?) be free.  If the line was busy, the micro waited two
character times and check again.
.sp
.ix Improper Echo
Collisions were determined by detection of overrun or by improper echo.
Expected echos had to be queued due to the nice(?) receiver buffering in the
ACIA.
.sp
.ix Detecting A Collision
On detection of a collision, the transmitter would send a :A5 byte ("stomp
on the data lines") to cause other transmitters to detect a collision (it
should have sent a 2 millisecond "break", but...).
.sp
Collision resolution was performed by use of the method described in the
Ethernet paper (quadratic resolution by use of a mask and a random number). 
The random number used was equal to the last CRC value computed by the
program.  This expedient was chosen because a good random number (a 60Hz
real-time clock value) was available on only 4 out of the 5 DOSs.
.sp
255 byte transmit and receiver data byte buffers were used (to simplify
pointer manipulations on an 8 bit machine).  The receiver determined in real
time how much of each data message to ignore as redundant, to retain, and to
ignore as excess.  The retained part was placed in the unused part of the
reciever buffer, but the "received" buffer pointers were not updated to
reflect the newly arrived data until the CRC was verified.
.sp
Straightforward CRC computation on a micro turned out to be almost as
expensive on a per-bit basis as a divide (approx 40 microseconds per bit). 
Since the message reception had to be checked in real time to minimize the
buffering (above and beyond the space allocated to the receive buffer), a
routine was designed that computed 8 bits of CRC per 40 microseconds, at the
cost of a 512 byte table.
.sp
Throughput rates were measured to be some 450 bytes per second (on a 960
bytes per second potential line) when moving the 30,000 byte file.  This low
utilization is currently attributed to the lost messages, and throughput is
expected to increase when SDLP drivers are integrated into the DOSs using
interrupts.
.sp
Microprocessors (with the aid of some clever coding) are fast enough to keep
up with the data rates involved.  The throughput is only (potentially) an
order of magnitude slower than the floppy disks in use on the system, which
are mostly more that fast enough.  (RS232) interfaces which are low cost and
widely available are easy to modify for use with SDLP.  Faster, synchronous
interface ICs are available, are virtually as cheap, and can offer another
order of magnitude faster performance before the microprocessor itself
becomes a limiting factor and thus requires a more expensive interface.
