; SDNET Asynchronous Serial Link Driver (ASLD) definitions file
; ?? need to be split between SDNET defs and ASLD-specific defs
         page  SDNET Interface definitions
*     SDNET10DEFS.ASM -- definitions file for SDNET version 0.9
*
* Abbreviations used:
*   ASLD:xxx    Asynchronous Serial Link Driver.  Link driver for Asynch devices
*   LD:xxx      Link Driver.  Implements management of physical link device.
*   SM:xxx      Socket Manager. Implements inter-task pipes using LD:
*   NET:xxx     Net Device.  Implements remote file I/O via SM:xxx
*
                   ifund m6800
m6800              equ   1
m6801              equ   0
m6809              equ   0
                   fin

minstacksize equ contextblock:size*3 room for context, IRQ + NMI
                   page

*     Additional SDOS Entry Points
*
*     Used as portals into the "black box" called SDNET

sdos:surprise equ  $AF7A-AE00     0 --> makes SDOS:RTI do SDOS:RESCHEDULE

sdos:extensionsize equ   100      size of extension to SDOS:xxx entries

::                 set   *
                   org   -sdos:extensionsize

*                  Assorted entry points for the outside world

sdos:netlistenertask rmb 3             Newly hatched TCB points (P) here
sdos:netdispatch   rmb   driver:pfrestart+2 VT driver dispatch vector

                   org   ::
::                 set   *
                   page
*        Network Representative Block (NRB:xxx) definitions
*        NOTE: Information is placed in this NRB in an order that minimizes
*        the space occupied by indexed '09 offsets, (or sometimes, that
*        minimizes the time used by a frequently executed routine).
*        This ordering is based on an empirical analysis of static
*        references to NRB: offsets, and to a dynamic analysis of
*        output interrupt and task wake-up condition routines.
*        Altering the order of these definitions may cause the driver
*        to grow significantly, or to impair its performance.

                   org     0
*        The following items have 4 bit offsets on 6809
nrb:xbuflk         rmb     1           transmit buffer lock (must be offset 0)
         ; receive buffer lock unnecessary because only listener task receives
nrb:ringoutroom    rmb     2           amount of room available for task level
nrb:ringindata     rmb     2           count of input data avail for task level
*        End gauranteeed 4 bit offsets for 6809

nrb:timeqflink     rmb     2           forward link to next nrb in order list
nrb:timeqblink     rmb     2           backward link to previous nrb in order list
nrb:timeqdelta     rmb     1           delay delta from nrb(blink)

nrb:nextnrb        rmb     2           points to next nrb or zero
nrb:node           rmb     1           node number being represented (0-->free)
nrb:state          rmb     1           state of node being represented
                   page
*                  Information used to manage standard ring buffers
*                  These definitions are here due to both high static
*                  frequency of reference, and high dynamic references
*                  in output routines (typically for 9600 to 38.4kb CRTs)
*
nrb:ringinfetch    rmb   2             ring buffer; input fetch pointer
nrb:ringinfdter    rmb   2             ring buffer; fetch distance to end ring
nrb:ringinstore    rmb   2             ring buffer; input store pointer
nrb:ringinsdter    rmb   2             ring buffer; store distance to end ring
nrb:ringinbase     rmb   2             ring buffer; base of input ring pointer
nrb:ringinlen      rmb   2             ring buffer; length of input ring buffer
nrb:ringinroom     rmb   2             ring buffer; room avail for int. level
*
nrb:ringoutfetch   rmb   2             ring buffer; output fetch pointer
nrb:ringoutfdter   rmb   2             ring buffer; fetch distance to end ring
nrb:ringoutstore   rmb   2             ring buffer; output store pointer
nrb:ringoutsdter   rmb   2             ring buffer; store distance to end ring
nrb:ringoutbase    rmb   2             ring buffer; base of output ring buffer
nrb:ringoutlen     rmb   2             ring buffer; length of output ring buffer
nrb:ringoutdata    rmb   2             ring buffer; data avail for int. level

nrb:retry          rmb     1           number of timeouts to conclude dead
nrb:xvpos          rmb     2           transmit virtual position (modulo 2**16)
nrb:rvpos          rmb     2           received virtual position (modulo 2**16)
nrb:rcvdrdy        rmb     2           last rcvdready count
****************** Beyond this point, the number of static/dynamic references
****************** to variables is low enough so order is not important
nrb:lastxmitcnt    rmb     2           how many we sent in last transmission
nrb:datarequired   rmb     1           <>0 --> task is waiting for new data
nrb:goof           rmb     1           set this to holler "goof!!!"
nrb:epitaph        rmb     2           holds error code describing NRB's death
nrb:tcb            rmb     tcb:size    this node's listener task's tcb
nrb:tcbstack       rmb     20+minstack stack space for listener task
nrb:stackbase      rmb     1           stack base for listener task
nrb:size           equ     *
        page
*
*       network configuration control blocks
        org     0
netcnfg:bufferspace     rmb     2      pointer to net buffer space
netcnfg:bufferend       rmb     2      pointer to end of net buffer space
netcnfg:nsockets        rmb     1      number of sockets to set up
netcnfg:servebroadcast  rmb     1      <>0 --> services broadcasts

        page    SD Line Protocol Control field values
*
*       SDLP control field values
*
sdlpcontrol:normal      equ     0      normal data-carrying message
                                       ; (data ack when convenient)
sdlpcontrol:acksoon     equ     1      normal data-carrying message
                                       ; (data ack desired soon)
sdlpcontrol:resynchreq  equ     1      re-synchronize request
sdlpcontrol:resynched   equ     2      re-synchronized response
sdlpcontrol:wantquit    equ     3      wants to quit
sdlpcontrol:agreequit   equ     4      agrees to quit
sdlpcontrol:quit        equ     5      quit!
sdlpcontrol:resynchquit equ     6      resynchronize, have data, and quit
*
*       NRB states (function of SDLP message protocol)
                        org     0
nodestate:dead          rmb     1      represented node is dead
nodestate:agreequit     rmb     1      represented node sent "wantquit"
nodestate:wantquit      rmb     1      need to disconnect from represented node
nodestate:inactive      rmb     1      represented node is inactive
nodestate:activating    rmb     1      we are trying to establish contact with represented node
nodestate:resynched     rmb     1      represented node sent "resynch"
nodestate:activated     rmb     1      represented node sent "resynched"
nodestate:connectedr    rmb     1      represented node is connected; we expect to receive next
nodestate:connecteds    rmb     1      represented node is connected; we're expected to send next
nodestate:quit          rmb     1      we must send "quit" msg to represented node
         page
                   org   ::
                   page
*                  Extensions to the Configuration Table

::                 set   *
                   org   cnfg:vtsize
cnfg:ldinfo        rmb   2             points to link driver information

cnfg:netsize       equ   *
                   org   ::
                   page  Link Driver configuration/entry/exit points
                   org   -39
* The prefix ASLDC:xxx means that this label is a Customizing point, i.e,
* it is used by ASLD but defined (or filled) by the I/O package implementer.
*
*        Link tuning parameters, change for different baud rates
*
asldc:retrycount   rmb   1             holds # times to re-xmit before give up
asldc:retrytime    rmb   1             60Hz ticks before re-xmit a message
asldc:respondtime  rmb   1             max ticks before xmit response
asldc:charactertime rmb  1             max ticks per character xmit/rcv time
;                                      (longer than <gap> after message)
asldc:xmtbufovfthreshold rmb 1         number of bytes left when there is
*                                      danger that output room won't be
*                                      available next time LD:SEND is called
asldc:efficientmsgthreshold rmb  1     # data bytes req'd for efficient msg
asldc:msgdatasizemax rmb 2             maximum size of message body
asldc:busacquiretries rmb 1            max tries before give up requesting bus
*
*        Entry points to physical device I/O routines for Asynch LD to use
*
asldc:ilreset      rmb   3             called by LD to initialize link hardware
asldc:ilenbii      rmb   3             called by LD to enable link input ints
asldc:ilenboi      rmb   3             called by LD to enable link output ints
; (interrupt when empty output buffer) returns Z reset if device ready now
asldc:ildisii      rmb   3             call to disable input interrupts
asldc:ildisoi      rmb   3             call to disable empty buffer output int
asldc:ilputdev     rmb   4             call to output byte in (A), exit via RTI
;                                      usually contains STAA >DEV\RTI
asldc:ilcsma       rmb   3             call to sense absence of carrier
asldc:ilxgap       rmb   3             transmit end of message gap

asldc:nrbindex     rmb   2             points to physical-node to NRB lookup table
asldc:nrbindexsize rmb   1             hold # slots in ld:nrbindex table
asldc:nrbchain     rmb   2             points to list of Node Representative Blocks
                   if    *#0
                   ? LD: I/O routine entry points have unreasonable offsets ?
                   fin
                   page
*        Entry points from Socket Manager into Link Driver
*        (CNFG:LDINFO points here)
                   org   0
ld:reset           rmb   3             called by SM to reset link driver at boot
ld:bcst            rmb   3             called by SM to broadcast a message
ld:sbyt            rmb   3             called by SM to send a single byte
ld:send            rmb   3             called by SM to send a block of data
ld:thnt            rmb   3             called by SM to signal "Transmit Hint"
ld:rhnt            rmb   3             called by SM to when more data needed soon
ld:rqb             rmb   3             called by SM to get rcvd broadcast count
ld:gbyt            rmb   3             called by SM to get another byte soon
ld:rbyt            rmb   3             called by SM to get another byte leisurely
? ; update Network spec: change ld:recv to ld:rblk
; add ld:gbyt and ld:gblk (get more data soon or error and die)
ld:gblk            rmb   3             called by SM to get data block soon
ld:rblk            rmb   3             called by SM to get data block leisurely
ld:clnk            rmb   3             called by SM to nicely close link to other node
ld:blnk            rmb   3             called by SM to abruptly close link

*        Entry points into Asynchronous Serial Link Driver from I/O package

asld:ilclocktick   rmb   3             JMP here with elapsed ticks in (A)

asld:ilinputint    rmb   6             JMP here with newly arrived data in (A)

asld:ilinputbadint rmb   3             JMP here if input data is malformed

asld:ilinputlateint rmb  3             JMP here if we lost input data

asld:iloutputint   rmb   6             JMP here when device ready for more output data

nrbpointer   equ   dcbpointer          pointer to NRB in task scratchpad
        page
*       Link control tuning parameter defaults (suitable for 9600 baud)
        ifund   asld:charactertime     # clock ticks per char xmit/rcv
asld:charactertime equ 2               because 1 tick can occur instantly
        fin

        ifund   asld:msgdatasizemax
asld:msgdatasizemax     equ     256    space for message body
        fin

        ifund   asld:xmtbufovfthreshold number of buffer bytes indicating imminent buffer full condition
asld:xmtbufovfthreshold equ     asld:msgdatasizemax*8/10
        fin

        ifund   asld:xmitthreshold     how many data bytes are needed for SDLP: packet to be efficient
asld:efficientmsgthreshold equ 100     = 5 * message overhead in bytes
        fin

        ifund   asld:retrycount how many times to try before declaring dead node
asld:retrycount equ     100
        fin

        ifund   asld:eotfusetime       how long to wait before giving up end of message search
asld:eotfusetime        equ     asld:msgdatasizemax*asld:charactertime ticks
        fin

        ifund   asld:respondtime       how long to wait before responding to a message just received
asld:respondtime        equ     3      60ths of a second
        fin

        ifund   asld:retrytime         how long to wait before retransmitting our message
asld:retrytime  equ     10*asld:respondtime 60ths of a second
        fin
                   page
*                  Errors specific to SDNET

::                 set   *
                   org   1300

                   org   ::
         page
*
*       acia status register bits definitions
*
aciairq         equ     %10000000      "acia wants interrupt"
aciape          equ     %01000000      "parity error on received data"
aciaovrn        equ     %00100000      receiver overrun
aciafe          equ     %00010000      framing error
aciacts         equ     %00001000      not cts
aciadcd         equ     %00000100      not data carrier detect
aciatdre        equ     %00000010      transmit data register empty
aciardrf        equ     %00000001      receive data register full
*
*       acia control register bit definitions
*
aciarie         equ     %10000000      receiver interrupt enable
aciatcbrk       equ     %01100000      set *rts low, transmit break
aciatcrtslow    equ     %01000000      set *rts high, disable transmit interrupt
aciatcenbi      equ     %00100000      set *rts low, enable transmit interrupt
aciatcdisi      equ     %00000000      set *rts low, disable transmit interrupt
aciaws81s       equ     %00010100      8 data bits + 1 stop bit
aciareset       equ     %00000011      master reset to acia
aciadiv16       equ     %00000001      divide clock by 16
         page
