;        SDNET11ADEFS.ASM
;        Contains equates and definitions required to implement SDNET
;
? ; Network server: channel capability should include pointer to table entry
; ?? in remote machine containing channel capability to save time

         ifund m6811
m6811    equ   0
         fin

dvtyp:link equ 22                      stream data device

; Status Calls for NETSERVER: device
         org   sc:devicespecificop
sc:createreceivesocket rmb 1           create recieve socket and return capability for it
sc:readsocketdata rmb 1                read data from socket
sc:getbuffercount rmb 1                  read amount of data ready
sc:anysocketready rmb 1                determine if some NETSERVER: socket has data
;
; Control Calls for NETSERVER: device
         org   cc:devicespecificop
cc:destroysocket rmb 1                 destroy socket
cc:writesocketdata rmb 1               write data to a socket


; Capability (CAPABILITY:) definitions
         org   0                       THIS BELONGS IN SDOSDEFS.ASM
capability:encryptedobjectID rmb 6     holds object ID encrypted
capability:encryptedrights rmb 2       holds rights carried by capability
capability:type rmb 1                  type of object referenced
capability:netID rmb 1                 holds global Network number 0..255
capability:nodeID rmb 1                holds ID of node in specified network
capability:regionID rmb 1              holds region inside node (memory, disk, etc.)
capability:locatorinfo rmb 4           type-specific object locator
capability:size rmb 0                  size of capability object

sdos:netextensionsize equ $20          extends SDOS: table

         org   -sdos:netextensionsize
sdos:LogicalUserNumber rmb 1           holds User number of current User
                                       ; set by SDOS/MT on SelectUser call

VTDriver equ  SDOS-$2000               kluge to make assembler shut up
         page
         org   cnfg:mtprims+2          extends configuration table for NET:
cnfg:ConsoleDriver rmb 2 ; which device is to be opened as CONSOLE:
; Above goodie needs more thought: what if device name is not CONSOLE: ?
; Swap name pointers in DCB?
cnfg:BootDefaultDisk rmb 2 ; which device is to be DefaultDisk after bootup

cnfg:NRBchain rmb 2 ; points to list of all NRBs (live or dead) in I/O package
cnfg:MaxValidNetID rmb 1 ; contains maximum valid Network ID this node knows.
cnfg:NetIDtoNITMap rmb 2 ; points to list of pointers to NITs
;    There is one NIT for each network reachable (in)directly by this node
;    that table is found by indexing this map with the NetID.
cnfg:NetPLCBChain rmb 2 ; points to list of all Physical Link Control Blocks

         org   0
; Network Information Table Node Data Entry (NITNDE:)
;    Contains all the information about a particular node on a network
;    There is one entry per valid node ID in each NIT: (see below)
NITNDE:PLCB rmb 2                      ; points to PLCB to use for this node
NITNDE:NRB  rmb 2                      ; points to NRB assigned to node (or zero if none)
;    Used by link drivers to associate incoming messages with NRB associated
;    with node sending the message.
NITNDE:Size rmb 0                      ; size of NITNDE: slot

         org   0
; Network Information Table (NIT:)
;    Contains all the information about a particular network.
;    Also contains identity of THIS node.
;
NIT:NetID rmb 1                        ; Network Identity of nodes on this net
NIT:NodeID rmb 1                       ; Node ID of this node on network
NIT:MaxNodeID rmb 1                    ; Maximum valid node ID on network
NIT:GatewayNodeID equ NIT:NodeID       ; Which node to send gateway msgs to
NIT:GatewayNetID rmb 1                 ; <>0 --> forward messages to gateway
;                                      ; i.e., NIT:NetID not directly reachable
NIT:NodeLookupBase rmb NITNDE:Size*256 ; Room for 256 NRB pointers
; This table indexed by NodeID*NIT:NodeLookupEntrySize+...:Base

         org   0
; Physical Link Control Block.
;    This block is used to store all of the context required by a Link Driver
;    to operate a single physical link; usually, a single link has many
;    nodes attached to it.  However, a single network may require several
;    Physical Links to reach all of the nodes in it.
;
PLCB:NextPLCB rmb 2                    ; Points to next PLCB in chain or zero
PLCB:LinkDriver rmb 2                  ; Points to Link Driver which runs link
PLCB:NITpointer rmb 2                  ; Points to NIT for network which PLCB represents
;
; from this point on, PLCB entries are Link Driver dependent.
         page
         org   DCB:DRIVER+2
dcb:netid rmb  1                       ; specifies network number for node (usually = 0)
dcb:nodeid rmb 1                       ; holds remote node physical number
dcb:netsize rmb 0                      ; size of network DCB

         if    0
; Each remote node known by name to the local node must have a DCB
; in the local node with the following form:
         fcb   1                       ; DCB:DONEFLAG (dummy: ignored)
         fdb   0                       ; DCB:LASTERROR (dummy: ignored)
         fdb   NodeName                ; DCB:NAME points to node name
         fdb   NextDCB                 ; DCB:NEXTDCB points to next device DCB
         fdb   NetDeviceDriver         ; DCB:DRIVER points to SDNETDEVICE driver entry point
         fcb   NetworkID               ; DCB:NETID specifies network number for node (usually = 0)
         fcb   NodePhysicalNumber      ; DCB:NODEID holds remote node physical number

NodeName fcc   "NAME:"                 ; Sysgen-time assigned remote node name
         fcb   0
         fin
         page
         org   0
; Message types handled by SDOS Server code
SDOSserverfilenamesyscall rmb 1        ; 1st byte of "file name syscall" msg
SDOSservernoniosyscall rmb 1           ; 1st byte of "syscall w/o channel" msg
SDOSserverfileiosyscall rmb 1          ; 1st byte of "sycall with channel" msg"

         org   0
? ; kluge temp definitions: replace by real definitions !!!
nrb:nodeid rmb 1                       ; holds Node number within a network
nrb:netid rmb 1                        ; holds Network number in universe
nrb:linkdriver rmb 2                   ; points to vector of entry points...
                                       ; into logical link driver module
nrb:plcb rmb 2                         ; points to physical link control block
nrb:nextnrb rmb 2                      ; points to next NRB in list of all NRBs
nrb:nextfreenrb equ nrb:linkdriver     ; points to next NRB not currently in use


**** FOR SOCKET MANAGER KLUGE, MAKE NRB HOLD SOME SOCKET MANAGER DATA
; Socket Control Block (SKT:) definitions
;        org   0
skt:userchainflink rmb 2               ; forward User Socket Chain link
skt:userchainblink rmb 2               ; backward User Socket Chain link
skt:userchainreferencecount rmb 1      ; number of Channels using this socket
skt:nrbpointer rmb 2                   ; points to NRB to use with socket
skt:ecb rmb ecb:size                   ; holds event control block for socket


PLCBpointer equ 4                      ; Physical Link Control Block pointer
SocketPointer equ DCBPointer           ; points to socket while in SM:
NRBpointer equ DCBpointer              ; points to NRB while in physical link driver

         org   0 ; physical link driver entry (LDE:) points
lde:reset rmb  2                       ; reset device associated with PLCB
lde:olnk rmb   2                       ; open link using NRB
lde:clnk rmb   2                       ; close link to node nicely
lde:blnk rmb   2                       ; break link with node NOW
lde:sbyt rmb   2                       ; send 1 byte
lde:sblk rmb   2                       ; send a block of data
lde:thnt rmb   2                       ; transmit hint
lde:rhnt rmb   2                       ; receive hint
lde:rcnt rmb   2                       ; get received data count
lde:gbyt rmb   2                       ; get byte soon or die
lde:rbyt rmb   2                       ; receive byte leisurely
lde:gblk rmb   2                       ; get block soon or die
lde:rblk rmb   2                       ; receive block leisurely
lde:bcst rmb   2                       ; broadcast message
lde:rqb  rmb   2                       ; request broadcast count
lde:nint rmb   2                       ; initialize NRB for use
         org   1100
err:nofreeNRBs rmb 1 ; No free Node Representative Blocks available
err:noPLCBs rmb 1    ; No Physical Link Control Blocks defined
err:illegalnetID rmb 1 ; Network ID specified does not exist
err:illegalnodeID rmb 1 ; Node ID specified does not exist on specified network

scratchpad equ 0                       ; KLUGE: real defs file needed

;        END of SDNET11ADEFS.ASM
