	TITLE	*** SDOS DRIVERS FOR WAVEMATE SERIES 2000 (C) 1981 SOFTWARE DYNAMICS ***
	PCC	1
	NAME	SDOSDRIVERS
	TABS	20,28,44,45
	PSR	0	don't print skipped records
	PCA	0	don't print conditional assembly records
	PCC	0
*
*	BY SOFTWARE DYNAMICS
*	AND A CAST OF THOUSANDS!
*
EDITDATE	EQU	$0318	/81 MMDD IN HEX FORMAT
EDITYEAR	EQU	1982
*
*
WMSERIES2000	EQU	1	THIS I/O PACKAGE IS FOR A SERIES 2000
*********************************************************************
*   I/O PACKAGE STRUCTURE
*   The I/O package is organized in the following fashion:
*
*   Low addresses: !                   !
*                  !  Read-only code,  !
*                  !   tables, etc.    !
*                  !-------------------!
*                  !                   !
*                  !  Interrupt poll   !
*                  !     chains        !
*                  !   (readonly)      !
*                  !                   !
*                  !-------------------!
*                  !                   !
*                  !  Working storage, !
*                  !  DCBs, TCBs, etc. !
*                  !                   !
*                  !-------------------!
*                  !                   !
*                  !    Disk Buffer    !
*                  !       Pool        !
*                  !    I/O Driver     !
*                  !    Reset code     !
*                  !    (once-only)    !
*                  !                   !
*                  !-------------------!
*                  !                   !
*                  !   VT Drivers      !
*                  !      SDOS         !
*                  !     ....          !
*
	PAGE
*	To make this arrangement possible, each I/O package source is
*	organized in the following way:
*		IOxxxxx.DO	is a file containing a configuration
*				for machine xxxxx
*		IOxxxxx.DO      is a file containing an I/O package "shell"
*		IOyyyyy.ASM	is a file containing ALL driver-related code
*				tables, etc. for the hardware device yyyyyy
*
*	Each I/O package shell uses conditional assembly switches to conditionally
*	INCLUDE IOyyyyy.ASM in a particular configuration.  The IOyyyyy.ASM
*	file is actually INCLUDEd 4 times, once for each of the 4 areas of
*	the I/O package shown above.  The following conditional switches
*	are used by the driver source module to distinguish between areas:
*		IODRIVERBODY	selects the read-only code portion
*		IODRIVERPOLL	selects the Interrupt poll chain portion
*		IODRIVERRAM	selects read/write storage of driver
*		IODRIVERINIT	selects the once-only I/O driver initializing code
*
*	Note: the driver source module should define all equates and (DCB)
*	table displacements when the conditional switch IODRIVERBODY is enabled.

*
*	A Typical shell has the following source form:
*
*	*	SET DEFAULTS
*		IFUND	xxxx
*		IFUND	yyyy
*		...
*	*	BUILD READ-ONLY CODE
*	IODRIVERBODY	SET	1
*	IODRIVERPOLL	SET	0
*	IODRIVERRAM	SET	0
*	IODRIVERINIT	SET	0
*		IF	xxxx
*		INCLUDE	IOxxxx.ASM
*		FIN
*		IF	yyyy
*		INCLUDE	IOyyyy.ASM
*		FIN
*		...
*	PATCHSPACE	RTP	zzzz
*		SWI
*	*****	Build Interrupt Poll Chains
*	IODRIVERBODY	SET	0
*	IODRIVERPOLL	SET	1
*		IF	xxxx	Note: order of poll routines may be different than bodies
*		INCLUDE	IOxxxx.ASM
*		FIN
	PAGE
*		IF	yyyy
*		INCLUDE	IOyyyy.ASM
*		FIN
*		...
*	*****	Build Working Storage
*	IODRIVERPOLL	SET	0
*	IODRIVERRAM	SET	1
*		IF	xxxx
*		INCLUDE	IOxxxx.ASM
*		FIN
*		IF	xxxx
*		IF	yyyy
*		INCLUDE	IOyyyy.AMS
*		FIN
*		...
*	*****	Build Driver Reset routines
*	IODRIVERRAM	SET	0
*	IODRIVERINIT	SET	1
*		IF	xxxx
*		INCLUDE	IOxxxx.ASM
*		FIN
*		IF	yyyy
*		INCLUDE	IOyyyy.ASM
*		FIN
*		...
*	*****	Finish out disk buffer pool, etc
*		...
*		END

	PAGE
	IFUND	YES
YES	EQU	1
	FIN	YES
	IFUND	NO
NO	EQU	0
	FIN	NO
	IFUND	M6800
M6800	EQU	YES
	FIN	M6800
	IFUND	M6809
M6809	EQU	&M6800
	FIN	M6809
	IFUND	LIST.ALL
LIST.ALL	EQU	YES
	FIN	LIST.ALL
	IFUND	LIST.SDOSDEFS
LIST.SDOSDEFS	EQU	LIST.ALL
	FIN	LIST.SDOSDEFS
IOPKDEFS	EQU	1	I WANT THE I/O PACKAGE DEFS!
	INCLUDE	SDOSIOPKDEFS.ASM
	IFUND	LIST.SDOSIOVTDEFS
LIST.SDOSIOVTDEFS	EQU	LIST.ALL
	FIN	LIST.SDOSIOVTDEFS
	INCLUDE	SDOSIOVTDEFS.ASM
	IFUND	LIST.IOPACKAGE
LIST.IOPACKAGE	EQU	LIST.ALL
	FIN	LIST.IOPACKAGE
	IFUND	LIST.CLOCK
LIST.CLOCK	EQU	LIST.ALL
	FIN	LIST.CLOCK
	IFUND	LIST.STORAGEDEMON
LIST.STORAGEDEMON	EQU	LIST.ALL
	FIN	LIST.STORAGEDEMON
	IFUND	LIST.VIRTUALTERMINAL
LIST.VIRTUALTERMINAL	EQU	LIST.ALL
	FIN	LIST.VIRTUALTERMINAL
	IFUND	LIST.S2000FLOPPY
LIST.S2000FLOPPY	EQU	LIST.ALL
	FIN
	IFUND	TANDONDS
TANDONDS	EQU	2
	FIN	TANDONDS
	IFUND	TANDONSS
TANDONSS	EQU	2
	FIN	TANDONSS
	IFUND	TANDE
TANDE	EQU	0
	FIN	TANDE
	PAGE	I/O PACKAGE DEFAULT SWITCHES
K	EQU	1024	# BYTES PER "K" OF MEMORY

	IFUND	MEMSIZE	SPECIFIES MEMORY SIZE IN "K" BYTES
MEMSIZE	EQU	63	DEFAULT FOR SERIES 2000
	FIN	MEMSIZE

	IFUND	NIOCHANNELS
NIOCHANNELS	EQU	8
	FIN	NIOCHANNELS
*
	IFUND	CODE
CODE	EQU	$8000
	FIN	CODE
*
	IFUND	VTDRIVER
VTDRIVER	EQU	$B200
	FIN

	IFUND	SDOS
SDOS	EQU	MEMSIZE*K-$3200
	FIN	SDOS
*
	IFUND	DRIVERBASE
	IF	CODE<<SDOS
DRIVERBASE	EQU	CODE
	ELSE
DRIVERBASE	EQU	SDOS-3
	FIN	CODE<<SDOS
	FIN	DRIVERBASE

USECONSOLEACIAASCLOCK	EQU	0	SERIES 2000 HAS INTERNAL VIA FOR CLOCK

	IFUND	CLOCK
CLOCK	EQU	1
	FIN

	IFUND	STORAGEDEMON
STORAGEDEMON	EQU	0
	FIN
	IFUND	ATTNCHECK
ATTNCHECK	EQU	SDOS+SDOS:VTATTNCHECK
	FIN	ATTNCHECK
	PAGE	EQUATES SPECIFIC TO SERIES 2000 HARDWARE
SYSPG	EQU	$FE
SYSPGBASE	EQU	$EF00	; BASE ADDRESS OF SYSTEM PAGE
SYSPGIRQVECTOR	EQU	$FBFD	; IRQ VECTOR SET UP BY S2000 BOOT ROM
TICKSPERSECOND	EQU	60	OFFICIAL SDOS CLOCK TICK RATE

*	SERIES 2000 INTERNAL "VIA" (6522) REGISTER DEFINITIONS
*
S2000VIAT1LL	EQU	$FC49
S2000VIAT1CH	EQU	$FC4A
S2000VIAT1CL	EQU	$FC4B
S2000VIAACR	EQU	$FC44
S2000VIAIER	EQU	$FC41
S2000VIAIFR	EQU	$FC42
S2000VIADRA	EQU	$FC4E
S2000VIADRB	EQU	$FC4F

	PAGE
*
*	SDOS-TO-IOPACKAGE COMMUNICATION REGION
*
	ORG	SDOS+1
****	FCB	$10	SDOS VERSION NUMBER
	FDB	0	LAST ERROR ENCOUNTERED
	FDB	CNFGTABLE	TELL SDOS WHERE ALL THE GOODIES ARE
	FDB	0	SERIAL NUMBER
	FDB	0	IOBLOCKPTR
	FDB	0	IOCB POINTER (FOR FILE-TYPE DEVICE DRIVERS)
	FCB	0,0,0	SET CLOCK TO "MIDNITE"
	FCB	0	DAY, LET COMMAND INTERPRETER KNOW
	FCB	0	MONTH, THAT THE TIME HASN'T BEEN SET
	FCB	EDITYEAR\100	YEAR
*
	ORG	DRIVERBASE
SYSCALLIO	JMP	SYSCALLIO	SDOS SETS JMP ADDR TO ITS ENTRY POINT
*
*****	READ ONLY CODE SECTION
IODRIVERBODY	SET	1
IODRIVERPOLL	SET	0
IODRIVERRAM	SET	0
IODRIVERINIT	SET	0

NEXTTIMEOUT	SET	0
NEXTDISKDCB	SET	0
NEXTDEVICEDCB	SET	0
NTIMEOUTS	SET	0
NDISKDCBS	SET	0
NEXTTCB	SET	0	SET UP END OF TASK CHAIN
INTERRUPTTARGET	SET	SDOS+SDOS:IOINT	ASSUME CONVENTIONAL INTERRUPT SCHEME
	PAGE	INTERFACE TO S2000 DEBUG ROM
	IF	M6800
DEBUGSYSCALL	DES		PUSH REST OF CONTEXT BLOCK: MAKE SPACE FOR X
	DES		MAKE ROOM FOR INDEX REGISTER
	DES		MAKE ROOM FOR CONTENTS OF (A)
	DES		SAVE ACCB
	TPA
	PSHA		SAVE CC BITS
	JSR	INTDISABLE	TURN OFF INTERRUPTS
DEBUGINTERRUPT	LDX	$FFFC	FAKE AN "NMI" INTERRUPT
	JMP	0,X

;	note: the following code was found lying around as a patch
;	but nobody knows why it is built the way it is built
;	FEE6/ STS $FBDD
;	FEE9/ JMP $FBFA
;
;	FBFA/ JMP $FFF2
;
;	FFF2/ JMP $FD12
;	"mod IDB driver to go thru NMI vector!"
	FIN	M6800

	IF	CLOCK
	INCLUDE	IOCLOCK.ASM
	FIN

	LIST	LIST.VIRTUALTERMINAL
	page	VT DRIVER CONFIGURATION
*	NOTE: iovtconfig contains switches to enable parts of IOVTDPBS file
	include	iovtconfig.asm
	PAGE	*** Virtual Terminal Configuration ***
	TABS	11,20
	INCLUDE	IOVTDPBS.ASM
	page	vt device physical i/o routines
ilputdev:$FC7F
	staa	$FC7E	output data
	ldaa	#%10110101	enable output interrupts
	staa	$FC7F
rts:$FC7F
	rts

ilgetdev:$FC7F
	ldaa	$FC7E	get the interrupt-causing data
	ldab	$FC7F	get the status
	jmp	ilgetdevstatusfromacia	the rest is common code

tlcheckready:$FC7F
	ldaa	$FC7F	get the status
	rora		shift *DCD into carry bit
	rora
	rora
	rts

ilputdev:$FC6F
	staa	$FC6E	output data
	LDAA	CONTROLREG$FC6F
	ORAA	#%10110100	enable output interrupts
	staa	$FC6F
rts:$FC6F
	rts

ilgetdev:$FC6F
	ldaa	$FC6E	get the interrupt-causing data
	ldab	$FC6F	get the status
	jmp	ilgetdevstatusfromacia	the rest is common code

tlcheckready:$FC6F
	ldaa	$FC6F	get the status
	rora		shift *DCD into carry bit
	rora
	rora
	rts

ilputdev:$FC5F
	staa	$FC5E	output data
	LDAA	CONTROLREG$FC5F
	ORAA	#%10110100	enable output interrupts
	staa	$FC5F
rts:$FC5F
	rts

ilgetdev:$FC5F
	ldaa	$FC5E	get the interrupt-causing data
	ldab	$FC5F	get the status
	jmp	ilgetdevstatusfromacia	the rest is common code

tlcheckready:$FC5F
	ldaa	$FC5F	get the status
	rora		shift *DCD into carry bit
	rora
	rora
	rts
	page	special control calls for baud rate selection
	TABS	20,28,44,45
*    Assembly code to handle SYSCALL:CONTROL calls for Series 2000 computer...
*    That are directed at Virtual Terminal devices,...
*    But not handled by VT driver.
*
CC:SETBAUDRATE EQU $40    IF THIS DOESN'T CONFLICT WITH VT DRIVER CODES

VTSyscall:Control$FC6F ; VT drivers xfers here after deciding it cannot help
    Cmpb   #CC:SETBAUDRATE    Is it a...?
    Bne    IllVTdevopj          B/ I don't know what the hell it is...
    JSR    SDOS+SDOS:CHECKWRLEN DID USER PASS ENOUGH BYTES?
    FDB    1                  ...?
    LDX    SCBLK:WRBUF,X      Get baud rate control byte
    LDAB   0,x
SetLptBaudRate ; Do I really need a comment here?
    JSR    CNFGTABLE+CNFG:INTDISABLE So fooling with 6522 register isn't confusing
    pshb                      save 6850 divide factor
    andb   #3                 keep only binary output for LPT:
    ldaa   s2000viadRb        get old baud rate select
    anda   #%11111100         Mask off old binary output for LPT:
    aba                       combine with new output
    staa   s2000viadRb        update VIA output register
    pulb                      get 6850 divide factor back
    lsrb                      move to bottom 2 bits
    lsrb
    ldaa   controlreg$FC6F    update image of control register
    anda   #%11111100         Mask off old divide factor
    aba                       insert new divide factor
    staa   controlreg$FC6F    save updated image of control register
    staa   $FC6F              tell the ACIA about new divide factor
    JSR    CNFGTABLE+CNFG:INTENABLE
    OKRTS

* BAUD RATE DEFAULT = 9600 BAUD FOR $FC6F
CONTROLREG$FC6F FCB $95 IMAGE OF CONTROL REGISTER FOR $FC6F

* BAUD RATE DEFAULT = 9600 BAUD FOR $FC5F
CONTROLREG$FC5F FCB $95 IMAGE OF CONTROL REGISTER FOR $FC5F

IllVTdevopj jmp IlldevICEop        Can't set baud rate on any other device.

VTSyscall:Control$FC5F ; VT drivers xfers here after deciding it cannot help
    Cmpb   #CC:SETBAUDRATE    Is it a...?
    Bne    IllVTdevopj          B/ I don't know what the hell it is...
    JSR    SDOS+SDOS:CHECKWRLEN DID USER PASS ENOUGH BYTES?
    FDB    1                  ...?
    LDX    SCBLK:WRBUF,X      Get baud rate control byte
    LDAB   0,X
SetModemBaudRate ; Likewise....
    JSR    CNFGTABLE+CNFG:INTDISABLE So fooling with 6522 register isn't confusing
    pshb                      save 6850 divide factor
    andb   #3                 keep only binary output for MODEM:
    aslb                      Shift baud rate bits into position
    aslb
    aslb
    ldaa   s2000viadRb        get old baud rate select
    anda   #%11100111         Mask off old binary output for MODEM:
    aba                       combine with new output
    staa   s2000viadRb        update VIA output register
    pulb                      get 6850 divide factor back
    lsrb                      move to bottom 2 bits
    lsrb
    ldaa   controlreg$FC5F    update image of control register
    anda   #%11111100         Mask off old divide factor
    aba                       insert new divide factor
    staa   controlreg$FC5F    save updated image of control register
    staa   $FC5F              tell the ACIA about new divide factor
    JSR    CNFGTABLE+CNFG:INTENABLE
    OKRTS
	LIST	LIST.IOPACKAGE
	INCLUDE	IOS2000FLOPY.ASM	ALWAYS INCLUDE THE FLOPPY DRIVER
	IF	STORAGEDEMON
USEDEMONASCLOCK	EQU	0	DON'T USE DEMON AS REALTIME CLOCK
	INCLUDE	IOSTOREDEMON.ASM
	FIN
	PAGE	CONFIG TABLE
	IFUND	INTERRUPTSTACKSIZE
* ??? is all this stack space really needed ? (see sdos11defs.asm)
INTERRUPTSTACKSIZE	EQU	MINSTACK+7+7+7+7	7 FOR EACH POSSIBLE
*			NESTED INTERRUPT RESULTING FROM A DEVICE
	FIN	INTERRUPTSTACKSIZE
*
CNFGTABLE	FDB	DISKDCBS	DEFAULT DISK MUST BE FIRST
	FDB	TTYDCB	CONSOLE MUST BE FIRST
	FDB	IOCBPOINTERS
	FCB	NIOCHANNELS
	FDB	DSKBUFFERPOOL
	FDB	DSKPOOLSIZE
	FDB	ATTNCHECK
	FDB	DEBUGSYSCALL
	FDB	DRIVERBASE
	FDB	INTSETUP
INTDISABLE	NOP		INT DISABLE
	SEI
	RTS
INTENABLE	NOP		INT ENABLE
	CLI
	RTS
INTRTI	RTI		INT RTI
	NOP
	NOP
	FDB	INTERRUPTSTACKEND-1
	FDB	INTERRUPTDEVICEPOLL	ROUTINE TO DETERMINE INTERRUPTING DEVICE
	FDB	TASKQUEUE
	FDB	TIMEOUTQUEUE
	FDB	PROFILECHAIN
	FDB	DEBUGINTERRUPT	WITH CONTEXT BLOCK ON STACK
	FDB	0	NO TIMESHARE PRIMITIVE VECTOR

ILLDEVICEOP	JSR	SDOS+SDOS:ERROR
	FDB	ERR:ILLDEVICEOP
*
ERRETX	JSR	SDOS+SDOS:ERRORSAVE
	JMP	SDOS+SDOS:ERRORED

	PAGE	*** INTERRUPT POLL CHAINS ***
IODRIVERBODY	SET	0
IODRIVERPOLL	SET	1

*	SERIES 2000 FLOPPY DYNAMICALLY INSERTS ITSELF AT HEAD OF POLL CHAIN

INTERRUPTDEVICEPOLL	EQU	*
	INCLUDE	IOVTCONFIG.ASM	POLL CHAIN FOR VT DEVICES
	ldaa	$FC7F	test irq
	bpl	noint:$FC7F	b/ no int here
	ldx	#dcb:$FC7F	look more closely
	cmpa	#%10000010	handle output interrupts pronto!
	bne	notoutput:$FC7F
gotoutput:$FC7F
	ldaa	#%10010101	disable output interrupt
	staa	$FC7F
	jmp	sdos+sdos:vtoutputint
notoutput:$FC7F
	bita	#%00000100	data carrier detect dropped
	beq	notdcddrop:$FC7F
	ldab	$FC7E	clear interrupt caused by ~dcd
	bita	#%00000010	output requested with ~dcd?
	bne	gotoutput:$FC7F	b/ yup!
	jmp	sdos+sdos:rti
notdcddrop:$FC7F
	bita	#%01110001	receiver register full or error
	beq	notinput:$FC7F
	jmp	sdos+sdos:vtinputint
notinput:$FC7F
	bita	#%00001000	not CTS
	beq	*	wierd condition
	jmp	sdos+sdos:rti
noint:$FC7F
	page
	ldaa	$FC6F	test irq
	bpl	noint:$FC6F	b/ no int here
	ldx	#dcb:$FC6F	look more closely
	cmpa	#%10000010	handle output interrupts pronto!
	bne	notoutput:$FC6F
gotoutput:$FC6F
	ldaa	CONTROLREG$FC6F	disable output interrupt
	staa	$FC6F
	jmp	sdos+sdos:vtoutputint
notoutput:$FC6F
	bita	#%00000100	data carrier detect dropped
	beq	notdcddrop:$FC6F
	ldab	$FC6E	clear interrupt caused by ~dcd
	bita	#%00000010	output requested with ~dcd?
	bne	gotoutput:$FC6F	b/ yup!
	jmp	sdos+sdos:rti
notdcddrop:$FC6F
	bita	#%01110001	receiver register full or error
	beq	notinput:$FC6F
	jmp	sdos+sdos:vtinputint
notinput:$FC6F
	bita	#%00001000	not CTS
	beq	*	wierd condition
	jmp	sdos+sdos:rti
noint:$FC6F
	page
	ldaa	$FC5F	test irq
	bpl	noint:$FC5F	b/ no int here
	ldx	#dcb:$FC5F	look more closely
	cmpa	#%10000010	handle output interrupts pronto!
	bne	notoutput:$FC5F
gotoutput:$FC5F
	ldaa	CONTROLREG$FC5F	disable output interrupt
	staa	$FC5F
	jmp	sdos+sdos:vtoutputint
notoutput:$FC5F
	bita	#%00000100	data carrier detect dropped
	beq	notdcddrop:$FC5F
	ldab	$FC5E	clear interrupt caused by ~dcd
	bita	#%00000010	output requested with ~dcd?
	bne	gotoutput:$FC5F	b/ yup!
	jmp	sdos+sdos:rti
notdcddrop:$FC5F
	bita	#%01110001	receiver register full or error
	beq	notinput:$FC5F
	jmp	sdos+sdos:vtinputint
notinput:$FC5F
	bita	#%00001000	not CTS
	beq	*	wierd condition
	jmp	sdos+sdos:rti
noint:$FC5F
	page
*	POLL CHAIN FOR SERIES 2000 INTERNAL VIA/ SYSTEM CLOCK
	LDAA	S2000VIAIFR		IS THIS FOR ME?
	BPL	S2000VIANOTME	NOT VIA
	ANDA	S2000VIAIER		ONLY INTERESTED IN ENABLED INTERRUPTS
	BITA	#%01000000	IS IT THE CLOCK?
	BEQ	*		B/ NO, HANG UNTIL SOMEBODY GETS US OUT!
	LDAA	S2000VIAT1CL	ACK THE CLOCK INTERRUPT
	LDAA	#1		1/60 SECOND ELAPSED
	JMP	SDOS+SDOS:CLOCKTICKED	TELL SDOS ABOUT IT
S2000VIANOTME

	IF	STORAGEDEMON
	INCLUDE	IOSTOREDEMON.ASM
	FIN

	LDX	BADINTERRUPTCOUNT	CAN'T FIGURE OUT WHO IT IS...
	INX			BUMP CRAZY INTERRRUPT COUNTER
	STX	BADINTERRUPTCOUNT
	JMP	SDOS+SDOS:RTI	AND HOPE IT WENT AWAY !

	EQU	*-DRIVERBASE	SIZE OF READ-ONLY CODE
	PAGE	*** WORKING STORAGE ***
IODRIVERPOLL	SET	0
IODRIVERRAM	SET	1

PATCHSPACE	; PATCH SPACE FOR KLUGES
	RPT	50
	SWI

BADINTERRUPTCOUNT	FDB	0	# OF INTERRUPTS FROM UNKNOWN DEVICES

	IF	CLOCK
	INCLUDE	IOCLOCK.ASM
	FIN

	INCLUDE	IOVTCONFIG.ASM	VIRTUAL TERMINAL DCBS, ETC.
**** THE FOLLOWING LINE SHOULD BE GENERATED BY "MAKECONFIG" BUT ISN'T!
NEXTTCB	SET	TTYTCB	= HEAD OF VT DEVICES TCB CHAIN
****************************************************************

*	PLACE JUMPS TO CONTROL CALL HANDLING LOGIC FOR SERIAL DEVICES
::  SET    *
    ORG    DCB:$FC6F+DCB:CONTROL MAKE DCB POINT TO CONTROL ROUTINE
    JMP    VTSYSCALL:CONTROL$FC6F

    ORG    DCB:$FC5F+DCB:CONTROL MAKE DCB POINT TO CONTROL ROUTINE
    JMP    VTSYSCALL:CONTROL$FC5F
    ORG    ::

	IF	STORAGEDEMON
	INCLUDE	IOSTOREDEMON.ASM
	FIN

	INCLUDE	IOS2000FLOPY.ASM

;	Link Winchester DCBs with Floppy disk DCBs
::	SET	*
	ORG	:DCB+DCB:NEXTDCB
	FDB	WDC0DCB
	ORG	::

DISKDCBS	SET	NEXTDISKDCB
NDRIVES	SET	NDISKDCBS
DEVICEDCBS	SET	NEXTDEVICEDCB
TIMEOUTQUEUE	SET	NEXTTIMEOUT
NTIMEOUTBLOCKS	SET	NTIMEOUTS
TASKQUEUE	SET	NEXTTCB
PROFILECHAIN	SET	NEXTDPB
	PAGE	FCBS, IOCBS, INTERRUPT STACK
*
*	FCBS (MUST PRECEDE IOCBS)
*
FCBS	RPT	FCB:SIZE*(NIOCHANNELS+2*NDRIVES+NMAGICFCBS)
	FCB	0
*
*	IOCBS
*
IOCBS	RPT	IOCB:SIZE*NIOCHANNELS
	FCB	0
IOCBPOINTERS	RPT	NIOCHANNELS
	FDB	IOCBS+IOCB:SIZE*(*-IOCBPOINTERS)/2
	PGEN	0
*
INTERRUPTTO	SET	INTERRUPTTARGET

INTERRUPTSTACK	EQU	*	STACK SPACE FOR INTERRUPT ROUTINES
	RPT	INTERRUPTSTACKSIZE
	FCB	0
INTSETUP	LDAA	#INTERRUPTTO/256	= WHERE TO GO ON INTERRUPT
	LDAB	#INTERRUPTTO&$FF
	LDX	$FFF8	= IRQ VECTOR, POINTS TO JMP IN RAM
	STAA	1,X	SET UP JUMP TARGET = INTERRUPTTO
	STAB	2,X
	RTS
INTERRUPTSTACKEND	EQU	*
	PAGE	*** DRIVER INIT (ONCE-ONLY) CODE ***
IODRIVERRAM	SET	0
IODRIVERINIT	SET	1
DSKBUFFERPOOL	EQU	*

*	THIS ROUTINE SETS UP THE CLOCK, AND ALSO INITIALIZES THE VIA
*	FOR ALL OTHER FUNCTIONS REQUIRED.
*	NOTE THAT THE BOOT ROM HAS ALREADY SET UP THE DATA DIRECTION
*	REGISTERS, AND SET THE BAUD RATE OF $FC6F AND $FC5F TO 9600 BAUD.
CLOCKRESET	EQU	*	USE VIA CLOCK, ASSUME 1MHZ CPU
	LDAA	#16666/256	16666 US = 16.6 MS = 60HZ
	LDAB	#16666&$FF
	STAB	S2000VIAT1LL	; SET INTERVAL IN LOW LATCH
	STAA	S2000VIAT1CH	; LOAD HIGH LATCH AND INTO COUNTER
	LDAA	#%01000000
	STAA	S2000VIAACR	; SET CONTINUOUS INTERRUPTS FROM COUNTER
	LDAA	#%11000000
	STAA	S2000VIAIER	; ENABLE INTERRUPT REQUEST FROM CLOCK
	OKRTS

	IF	STORAGEDEMON
	INCLUDE	IOSTOREDEMON.ASM
	FIN

	INCLUDE	IOVTCONFIG.ASM	RESET ROUTINES FOR VT DEVICES
	PAGE	Reset routines for S2000 standard VT devices (CONSOLE:,LPT:,MODEM:)
reset:$FC7F
	ldaa	#%00000011	reset ACIA
	staa	$FC7F
	ldaa	#%10010101	in int; 8 D + 1 S; no parity; /16
	staa	$FC7F
	ldaa	$FC7E	clear any input interrupt
	rts

reset:$FC6F
	ldaa	#%00000011	reset ACIA
	staa	$FC6F
	ldaa	CONTROLREG$FC6F	in int; 8 D + 1 S; no parity; /16
	staa	$FC6F
	ldaa	$FC6E	clear any input interrupt
	rts

reset:$FC5F
	ldaa	#%00000011	reset ACIA
	staa	$FC5F
	ldaa	CONTROLREG$FC5F	in int; 8 D + 1 S; no parity; /16
	staa	$FC5F
	ldaa	$FC5E	clear any input interrupt
	rts
	page	;
	page
	INCLUDE	IOS2000FLOPY.ASM
	PAGE
	IF	CODE<<VTDRIVER
	IF	*>/VTDRIVER
	? DRIVERS TOO BIG ?
	ELSE
	RMB	VTDRIVER-*
	FIN	*>/VTDRIVER
	ELSE
	IF	*>/MEMSIZE*K
	? DRIVERS TOO BIG ?
	FIN	*>/MEMSIZE*K
	RMB	MEMSIZE*K-*
	FIN	CODE<<VTDRIVER
DSKPOOLSIZE	EQU	*-DSKBUFFERPOOL
ENDOFIOPACKAGE	EQU	*	SO I CAN SEE WHERE THE END IS...
	EQU	*-CODE	SO I CAN SEE HOW BIG THE WORLD IS
	END
