	TITLE *** SDOS -- SOFTWARE DYNAMICS 6800 OPERATING SYSTEM (C) 1978 ***
	PAGE	;
	TABS	20,28,44,45
	NAME	SDOS1.0
*
	WITH	WI=107,DE=51
*
*	SDOS FRONT END (I/O) BY RICK GROS, SOFTWARE DYNAMICS
*	SDOS DISK FILE DRIVER BY IRA BAXTER, SOFTWARE DYNAMICS
*
	IFUND	LISTDEFS
LISTDEFS	EQU	0
	FIN
	LIST	LISTDEFS
*
*	DEFS ARE BROKEN INTO 3 PARTS:
*		A) THOSE NEEDED TO ASSEMBLE SDOS PROPER OR SYSTEM PROGRAMS
*			(SDOSMAINDEFS.ASM)
*		B) THOSE NEEDED TO BUILD AN I/O PACKAGE (A SUBSET OF "A")
*			(SDOSIOPKDEFS.ASM)
*		C) THOSE NEEDED BY EVERYDAY USER PROGRAMS (A SUBSET OF "B")
*			(SDOSUSERDEFS.ASM)
*
	PAGE	*** SDOS 1.0 DEFINITIONS ***
*	SDOS 1.0 DEFINITIONS FILE (AS OF 9/4/78 2030)
*
	IFUND	SDOSVERSION
SDOSVERSION	EQU	$10	1.0 IN HEX
	FIN

SYSCALL$	EQU	$FB	JMP TO SDOS; RESERVED SYSCALL ENTRY POINT
*	CONTENTS OF ($FC,$FD) POINTS TO END OF USER RAM
*	CONTENTS OF ($FE,$FF) ARE SACRED; THEY BELONG TO THE ROM
*
*	SYSCALL$ OPCODE DEFINITIONS
*
	ORG	0
SYSCALL:OPEN	RMB	1	OPEN FILE
SYSCALL:CREATE	RMB	1	CREATE A NEW FILE
SYSCALL:CLOSE	RMB	1	CLOSE A FILE
SYSCALL:RENAME	RMB	1	RENAME A FILE
SYSCALL:DELETE	RMB	1	DELETE A FILE
SYSCALL:LOAD	RMB	1	LOAD AN OVERLAY
SYSCALL:CHAIN	RMB	1	CHAIN TO A FILE
SYSCALL:CREATELOG	RMB	1	CREATE THE LOG FILE
SYSCALL:CLOSELOG	RMB	1	CLOSE THE LOG FILE
SYSCALL:DISKDEFAULT	RMB	1	SELECT DEFAULT DISK DEVICE
SYSCALL:READA	RMB	1	READ ASCII BYTES FROM A FILE
SYSCALL:READB	RMB	1	READ BINARY BYTES FROM A FILE
SYSCALL:WRITEA	RMB	1	WRITE ASCII BYTES TO A FILE
SYSCALL:WRITEB	RMB	1	WRITE BINARY BYTES TO A FILE
SYSCALL:CONTROL	RMB	1	PERFORM A CONTROL OPERATION ON A FILE/DEVICE
SYSCALL:STATUS	RMB	1	READ FILE/DEVICE STATUS
SYSCALL:WAITDONE	RMB	1	WAIT FOR I/O ON CHANNEL TO COMPLETE
SYSCALL:EXIT	RMB	1	GIVE CONTROL BACK TO THE OPERATING SYSTEM
SYSCALL:ERROREXIT	RMB	1	EXIT TO SYSTEM WITH ERROR CODE
SYSCALL:SETERROR	RMB	1	REPORT AN ERROR TO THE SYSTEM
SYSCALL:GETERROR	RMB	1	READ BACK THE LAST ERROR CODE
SYSCALL:DISPERROR	RMB	1	DISPLAY ERROR MESSAGE CORRESPONDING TO LAST ERROR CODE
SYSCALL:KILLPROOF	RMB	1	PREVENT USER PROGRAM FROM BEING KILLED
SYSCALL:KILLENABLE	RMB	1	ALLOW USER PROGRAM TO BE KILLED
SYSCALL:DEBUG	RMB	1	CALL SYSTEM DEBUGGER
SYSCALL:ATTNCHECK	RMB	1	OPERATOR ATTENTION REQUEST CHECK
SYSCALL:ISCONSOLE	RMB	1	CHECK FOR CHANNEL 0 INPUT DEVICE = CONSOLE:
	PAGE
*
*	SYSCALL BLOCK DISPLACEMENTS
*
	ORG	0
SCBLK:OPCODE	RMB	1	PRIMARY SYSCALL FUNCTION (OPEN, READ, ETC.)
SCBLK:WLEN	RMB	1	WAIT FLAG BIT (0=WAIT) AND SYSCALL BLOCK LENGTH (0..127)
SCBLK:PARAMS	RMB	2	PARAMETER BYTES TO OPCODE (SECONDARY OPCODE, CHANNEL #)
SCBLK:WRBUF	RMB	2	POINTER TO WRITE DATA BUFFER
SCBLK:WRLEN	RMB	2	NUMBER OF BYTES IN WRITE DATA BUFFER
SCBLK:RPLEN	RMB	2	LENGTH OF REPLY (RESULT OF SYSCALL)
SCBLK:RDBUF	RMB	2	POINTER TO READ DATA BUFFER (WHERE RESULT GOES)
SCBLK:RDLEN	RMB	2	CEILING ON SIZE OF REPLY (READ DATA BUFFER)
SCBLK:DATA	RMB	0	OTHER PARAMETERS FOR SYSCALL; UP TO 127-12 BYTES
SCBLK:END	RMB	0	END OF SYSCALL BLOCK; ASSERT SCBLK:WLEN[1..7]=SCBLK:END-SCBLK:PARAMS
*
*	SYSCALL PARAMETER LIST DEFINITIONS
*
OPEN:CHANNEL	EQU	SCBLK:PARAMS	CHANNEL NUMBER
OPEN:LENGTH	EQU	SCBLK:WRLEN	FILE NAME LENGTH
OPEN:NAMEP	EQU	SCBLK:WRBUF	POINTER TO FILE NAME
OPEN:SCLEN	EQU	SCBLK:DATA	OPEN SYSCALL BLOCK LENGTH
*
CREATE:CHANNEL	EQU	SCBLK:PARAMS	CHANNEL NUMBER
CREATE:LENGTH	EQU	SCBLK:WRLEN	FILE NAME LENGTH
CREATE:NAMEP	EQU	SCBLK:WRBUF	POINTER TO FILE NAME
CREATE:SCLEN	EQU	SCBLK:DATA	CREATE SYSCALL BLOCK LENGTH
*
CLOSE:CHANNEL	EQU	SCBLK:PARAMS	CHANNEL NUMBER
CLOSE:SCLEN	EQU	SCBLK:PARAMS+1	CLOSE SYSCALL BLOCK LENGTH
*
RENAME:CHANNEL	EQU	SCBLK:PARAMS	CHANNEL NUMBER
RENAME:LENGTH	EQU	SCBLK:WRLEN	NEW FILE NAME LENGTH
RENAME:NAMEP	EQU	SCBLK:WRBUF	POINTER TO NEW FILE NAME
RENAME:SCLEN	EQU	SCBLK:DATA	RENAME SYSCALL BLOCK LENGTH
*
DELETE:LENGTH	EQU	SCBLK:WRLEN	FILE NAME LENGTH
DELETE:NAMEP	EQU	SCBLK:WRBUF	POINTER TO NAME
DELETE:SCLEN	EQU	SCBLK:DATA	DELETE SYSCALL BLOCK LENGTH
*
LOAD:LENGTH	EQU	SCBLK:WRLEN	LENGTH OF FILE NAME
LOAD:NAMEP	EQU	SCBLK:WRBUF	POINTER TO FILE NAME
LOAD:SCLEN	EQU	SCBLK:DATA	LOAD SYSCALL BLOCK LENGTH
*
CHAIN:LENGTH	EQU	SCBLK:WRLEN	LENGTH OF FILE NAME
CHAIN:NAMEP	EQU	SCBLK:WRBUF	POINTER TO FILE NAME
CHAIN:SCLEN	EQU	SCBLK:DATA	CHAIN SYSCALL BLOCK LENGTH
*
CREATELOG:LENGTH	EQU	SCBLK:WRLEN	LENGTH OF FILE NAME
CREATELOG:NAMEP	EQU	SCBLK:WRBUF	POINTER TO FILE NAME
CREATELOG:SCLEN	EQU	SCBLK:DATA	CREATELOG SYSCALL BLOCK LENGTH
*
CLOSELOG:SCLEN	EQU	SCBLK:PARAMS	CLOSELOG SYSCALL BLOCK LENGTH
*
DISKDEFAULT:LENGTH	EQU	SCBLK:WRLEN	FILE NAME LENGTH
DISKDEFAULT:NAMEP	EQU	SCBLK:WRBUF	POINTER TO FILE NAME
DISKDEFAULT:SCLEN	EQU	SCBLK:DATA	DISKDEFAULT SYSCALL BLOCK LENGTH
*
READA:CHANNEL	EQU	SCBLK:PARAMS	CHANNEL NUMBER
READA:LMFLAG	EQU	SCBLK:PARAMS+1	LINE MODE FLAG BYTE
READA:BUFFERP	EQU	SCBLK:RDBUF	BUFFER POINTER
READA:MAXCOUNT	EQU	SCBLK:RDLEN	BYTE COUNT
READA:ACTUALCOUNT	EQU	SCBLK:RPLEN	ACTUAL NUMBER OF BYTES TRANSFERRED
READA:SCLEN	EQU	SCBLK:DA                                                                                                                                :MAXCOUNT	EQU	SCBLK:RDLEN	BYTE COUNT
READB:ACTUALCOUNT	EQU	SCBLK:RPLEN	ACTUAL NUMBER OF BYTES TRANSFERRED
READB:SCLEN	EQU	SCBLK:DATA	READB SYSCALL BLOCK LENGTH
*
WRITEA:CHANNEL	EQU	SCBLK:PARAMS	CHANNEL NUMBER
WRITEA:BUFFERP	EQU	SCBLK:WRBUF	BUFFER POINTER
WRITEA:COUNT	EQU	SCBLK:WRLEN	BYTE COUNT
WRITEA:SCLEN	EQU	SCBLK:RPLEN	WRITEA SYSCALL BLOCK LENGTH
*
WRITEB:CHANNEL	EQU	SCBLK:PARAMS	CHANNEL NUMBER
WRITEB:BUFFERP	EQU	SCBLK:WRBUF	BUFFER POINTER
WRITEB:COUNT	EQU	SCBLK:WRLEN	BYTE COUNTER
WRITEB:SCLEN	EQU	SCBLK:RPLEN	WRITEB SYSCALL BLOCK LENGTH
*
CONTROL:CHANNEL	EQU	SCBLK:PARAMS	CHANNEL NUMBER
CONTROL:CODE	EQU	SCBLK:PARAMS+1	CONTROL CODE
CONTROL:SCLEN	EQU	SCBLK:WRBUF	CONTROL SYSCALL BLOCK MINIMUM LENGTH
CONTROL:DATA	EQU	0	DISPLACEMENT INTO WRITE BUFFER FOR CONTROL DATA
*
STATUS:CHANNEL	EQU	SCBLK:PARAMS	CHANNEL NUMBER
STATUS:CODE	EQU	SCBLK:PARAMS+1	STATUS SELECTOR CODE
STATUS:BUFFERP	EQU	SCBLK:RDBUF	POINTER TO STATUS TARGET BUFFER
STATUS:MAXCOUNT	EQU	SCBLK:RDLEN	SIZE OF STATUS READ-BACK BUFFER
STATUS:ACTUALCOUNT	EQU	SCBLK:RPLEN	ACTUAL # STATUS BYTES READ
STATUS:SCLEN	EQU	SCBLK:DATA	STATUS SYSCALL BLOCK MINIMUM LENGTH
STATUS:DATA	EQU	0	DISPLACEMENT INTO READ BUFFER FOR READ-BACK STATUS
*
WAITDONE:CHANNEL	EQU	SCBLK:PARAMS	CHANNEL NUMBER
WAITDONE:SCLEN	EQU	SCBLK:PARAMS+1	WAITDONE SYSCALL BLOCK LENGTH
*
EXIT:SCLEN	EQU	SCBLK:PARAMS	EXIT SYSCALL BLOCK LENGTH
*
ERROREXIT:CODE	EQU	SCBLK:PARAMS	ERROR CODE NUMBER
ERROREXIT:SCLEN	EQU	SCBLK:WRBUF	ERROREXIT SYSCALL BLOCK LENGTH
*
SETERROR:CODE	EQU	SCBLK:PARAMS	ERROR CODE NUMBER
SETERROR:SCLEN	EQU	SCBLK:WRBUF	SETERROR SYSCALL BLOCK LENGTH
*
GETERROR:BUFFERP	EQU	SCBLK:RDBUF	POINTER TO ERROR READ-BACK AREA
GETERROR:MAXCOUNT	EQU	SCBLK:RDLEN	SHOULD BE 2
GETERROR:ACTUALCOUNT	EQU	SCBLK:RPLEN	SHOULD BE RETURNED AS 2
GETERROR:SCLEN	EQU	SCBLK:DATA	GETERROR SYSCALL BLOCK LENGTH
*
DISPERROR:SCLEN	EQU	SCBLK:PARAMS	DISPERROR SYSCALL BLOCK LENGTH
*
KILLPROOF:SCLEN	EQU	SCBLK:PARAMS	KILLPROOF SYSCALL BLOCK LENGTH
*
KILLENABLE:SCLEN	EQU	SCBLK:PARAMS	KILLENABLE SYSCALL BLOCK LENGTH
*
DEBUG:SCLEN	EQU	SCBLK:PARAMS	DEBUG SYSCALL BLOCK LENGTH
*
ATTNCHECK:SCLEN	EQU	SCBLK:PARAMS	ATTNCHECK SYSCALL BLOCK LENGTH
*
ISCONSOLE:SCLEN	EQU	SCBLK:PARAMS	ISCONSOLE SYSCALL BLOCK LENGTH
	PAGE
*
*	STATUS SYSCALL$ SUB-CODES
*
	ORG	0
SC:GETPOS	RMB	1	GET BYTE POSITION
SC:GETCOL	RMB	1	GET COLUMN COUNT
SC:GETEOF	RMB	1	GET EOF FLAG
SC:GETFILESIZE	RMB	1	GET FILE SIZE
SC:GETTYPE	RMB	1	GET DEVICE TYPE AND CHARACTERISTICS
SC:GETPARAMS	RMB	1	GET DEVICE SPECIFIC PARAMETERS
SC:DEVICESPECIFICOP	EQU	$10	BASE FOR DEVICE SPECIFIC STATUS CODES
*
*	DEVICE TYPE DEFINITIONS 
*
	ORG	0
DVTYP.FILE	RMB	1	FILE (MANAGED BY SDOS)
DVTYP.DISK	RMB	1	DISK DEVICE (MANAGED BY SDOS)
DVTYP.STAPE	RMB	1	SERIAL TAPE DEVICE
DVTYP.DTAPE	RMB	1	DIRECTORIED TAPE DEVICE
DVTYP.CONSOLE	RMB	1	CONSOLE (HUMAN'S INTERFACE)
DVTYP.PRINTER	RMB	1	LINE PRINTER DEVICE
DVTYP.SERIALOUT	RMB	1	ILL-DEFINED
DVTYP.SERIALIN	RMB	1
DVTYP.PAROUT	RMB	1	PARALLEL OUT
DVTYP.PARIN	RMB	1	PARALLEL IN
DVTYP.DUMMY	RMB	1	BLACK HOLE FOR DATA BYTES
DVTYP.CLOCK	RMB	1	CLOCK DEVICE
	PAGE
*
*	DEVICE TYPE DATA DISPLACEMENTS
*
	ORG	0
DVTYP:TYPE	RMB	1	DEVICE TYPE
*
*	DEVICE-TYPE SPECIFIC DATA
*
	ORG	0	DISK DEVICE SPECIFIC DATA
DVDAT:NBPS	RMB	2	NUMBER OF BYTES PER SECTOR
DVDAT:NSPT	RMB	2	NUMBER OF SECTORS PER TRACK
DVDAT:NTPC	RMB	2	NUMBER OF TRACKS PER CYLINDER
DVDAT:NCYL	RMB	2	NUMBER OF CYLINDERS
*
	ORG	0	CONSOLE/PRINTER DEVICE SPECIFIC DATA
DVDAT:WIDTH	RMB	1	LINE WIDTH IN CHARACTERS
DVDAT:DEPTH	RMB	1	PAGE DEPTH (DEFAULT DEPTH FOR PRINTERS)
*				(0=INFINITY)
*
	ORG	DVDAT:NBPS+2	(DISK) FILE DEVICE SPECIFIC DATA
DVDAT:NSPC	RMB	1	NUMBER OF SECTORS PER CLUSTER
	PAGE
*	CONTROL SYSCALL$ COMMON SUB-CODES
*
	ORG	0
CC:POSITION	RMB	1	POSITION TO THIS PLACE IN THE FILE
CC:DUMPBUFFERS	RMB	1	DUMP BUFFERS TO THE DEVICE (MAINLY FOR DISK)
CC:DEVICESPECIFICOP	EQU	$10	BASE FOR DEVICE-SPECIFIC CONTROL CODES
CC:FORMAT	EQU	$20	TURN ON FORMATTING SWITCH IN DISK DRIVERS
*
*	TTY CONTROL OPS
*
	ORG	CC:DEVICESPECIFICOP
CC:ECHO	RMB	1	TURN ECHO OFF
CC:NOECHO	RMB	1	TURN ECHO ON
CC:IDLES	RMB	1	SET TTY IDLES
CC:TABS	RMB	1	SET TTY TABS
*
*	DISK DEVICE CONTROL OPS
*
	ORG	CC:DEVICESPECIFICOP
CC:UNLOCKDISK	RMB	1	UNLOCK THE DISK DEVICE FOR WRITING
CC:DISMOUNTDISK	RMB	1	DISMOUNT THE DISK
CC:SETMAPALGORITHM	RMB	1	SET MAP ALGORITHM NUMBER FOR DRIVE
*
*	POSITION CONTROL BLOCKS
*
	ORG	0
CONTROL:DIST	RMB	4	VALUE OF POSITIONING COMMANDS
*
	ORG	0
CONTROL:MAPALGORITHM	RMB	2	PARAMETER BLOCK FOR SET MAP ALGORITHM CALL
	PAGE
*	DISK DEVICE STATUS REQUESTS
*
	ORG	SC:DEVICESPECIFICOP
SC:GETLASTBADLSN	RMB	1	READ BACK LSN THAT CAUSED DRIVER A PROBLEM
*
*	RETURNED STATUS DISPLACEMENTS
*
	ORG	0
STATUS:DIST	RMB	4	POSITION IN DISK FILE
*
	ORG	0
STATUS:COLUMN	RMB	1	COLUMN NUMBER
*
	ORG	0
STATUS:EOFFLAG	RMB	1	END OF FILE FLAG
*
	ORG	0
STATUS:DEVTYPE	RMB	1	DEVICE TYPE DATA FOR DIRECTORIED DISK
*
	ORG	0
STATUS:NBPS	RMB	2	NUMBER OF BYTES PER SECTOR
STATUS:NSPT	RMB	2	NUMBER OF SECTORS PER TRACK
STATUS:NTPC	RMB	2	NUMBER OF TRACKS PER CYLINDER
STATUS:NCYL	RMB	2	NUMBER OF CYLINDERS
*
	ORG	0
STATUS:FILESIZE	RMB	4	SIZE OF DISK FILE IN BYTES
*
	ORG	0
STATUS:LASTBADLSN	RMB	3	LSN OF LAST BAD SECTOR ON DISK
	PAGE
*
*	SYSTEM-DEFINED ERROR CODES
*
	ORG	0
ERR:NONE	RMB	1	CODE 0 --> NO ERROR
ERR:ATTENTION	RMB	1	OPERATOR REQUESTED ATTENTION

	ORG	100
ERR:FATALCOMPILE	RMB	1	COMPILATION OR ASSEMBLY HAD FATAL ERRORS
ERR:WARNINGCOMPILE	RMB	1	COMPILATION OR ASSEMBLY HAD NON-FATAL ERRORS
*
*	SDOS ERROR CODES
*
*
*	ERROR CODES FOR SDOS ARE RESERVED BETWEEN 1000-1999
*
	ORG	1000
ERR:BOOTCKSUMFAIL	RMB	1	BOOT SECTOR DISKINFO CHECK SUM FAILED
ERR:EOFHIT	RMB	1	END OF FILE HIT
ERR:FILEISOPEN	RMB	1	A FILE IS OPEN DURING DUMPBUFFERS REQUEST
ERR:NODEBUGGER	RMB	1	NO DEBUGGER TO CALL!
ERR:BADPOSITION	RMB	1	BAD POSITIONING REQUEST
ERR:NBPCTOOBIG	RMB	1	NUMBER OF BYTES PER CLUSTER >= 65536
ERR:NODISKMAP	RMB	1	NO DISK MAP, CAN'T ALLOC OR FREE
ERR:NOMATCHFCB	RMB	1	NO MATCHING FILE CONTROL BLOCK FOUND
	RMB	1	*** UNUSED
ERR:FILEDELPROT	RMB	1	FILE IS DELETE PROTECTED
ERR:FILEWRTPROT	RMB	1	FILE IS WRITE PROTECTED
ERR:FILENOTFOUND	RMB	1	FILE NOT FOUND
ERR:ILLEGALLCN	RMB	1	LCN OUT OF RANGE
ERR:BADFNAMESIZE	RMB	1	LENGTH OF FILE NAME > 16 CHARACTERS
ERR:NEWFILEEXISTS	RMB	1	NEW FILE ALREADY EXISTS!
ERR:NODISKSPACE	RMB	1	DISK SPACE EXHAUSTED
ERR:LCNWASNTALLOC	RMB	1	LCN ENCOUNTERED BY FREECLUSTERS WASN'T ALLOCATED (*SYSTEM*)
ERR:NOFREEFCBS	RMB	1	RAN OUT OF FCBS (*SYSTEM*)
ERR:WRONGFILESYSTEM	RMB	1	FILE SYSTEM INCOMPATIBLE WITH THIS VERSION OF SDOS
ERR:FILEINCREATE	RMB	1	FILE IS BEING CREATED
ERR:DISKMOUNTED	RMB	1	DISK IS MOUNTED, CAN'T CHANGE MAPALGORITHM
ERR:CANTOPENMUSTCREATE	RMB	1	MUST CREATE TO OPEN OUTPUT ONLY DEVICE
ERR:NOERRORMSGS	RMB	1	NO $ERRORMESSAGES FILE ON DRIVE 0
ERR:BADFILENAME	RMB	1	FILENAME DOESN'T START WITH A-Z OR $
ERR:ILLFILESIZE	RMB	1	ILLEGAL FILE SIZE SPECIFICATION (SYNTAX OR OVFLOW)
ERR:HCSICTOOSMALL	RMB	1	HEADER CLUSTER NOT INITZED FOR RDCN FETCH
ERR:NOTENOUGHPOOL	RMB	1	NOT ENOUGH DISKBUFFER POOL (*SYSTEM*)
ERR:PWRFAILDISKF	RMB	1	DISK FILE HANDLERS DON'T IMPLEMENT POWER FAIL
ERR:NOTALOADFILE	RMB	1	CAN'T LOAD THAT - WRONG FORMAT
ERR:MIKBUGCHECKSUM	RMB	1	MIKBUG RECORD CHECKSUM FAILURE
ERR:CHTOOBIG	RMB	1	CHANNEL # IS TOO BIG
ERR:CHBUSY	RMB	1	CHANNEL IS ALREADY OPEN
ERR:CLOSED	RMB	1	CHANNEL IS ALREADY CLOSED
ERR:ILLEGALSYSCALL	RMB	1	ILLEGAL SYSCALL #
ERR:ILLDEVICEOP	RMB	1	ILLEGAL DEVICE OPERATION
ERR:RENAMEDEVICE	RMB	1	CAN'T RENAME TO DIFFERENT DEVICE
ERR:BADLOADRECORD	RMB	1	LOAD RECORD FORMAT ERROR
ERR:NOTENOUGHROOM	RMB	1	PROGRAM TOO BIG TO LOAD
ERR:ILLLSN	RMB	1	ILLEGAL LSN PASSED TO PHYSICAL DISK DRIVERS
ERR:TTYDRIVERCROAKED	RMB	1	TTY DRIVER IS SICK
ERR:IBUFOVERFLOW	RMB	1	INPUT BUFFER OVERFLOW IN THE DRIVERS
ERR:PROGRAMKILLED	RMB	1	PROGRAM KILLED BY OPERATOR
ERR:DEVICETIMEDOUT	RMB	1	DEVICE TIMED OUT
ERR:SECTORSIZE2	RMB	1	SECTORSIZE IS NOT A POWER OF 2!
ERR:SYSTEMCROAKED	RMB	1	...WHILE DOING AN EXIT OR CHAIN (*SYSTEM*)
ERR:DISKREAD	RMB	1	DISK READ ERROR
ERR:DISKWRITE	RMB	1	DISK WRITE ERROR
ERR:DISKSEEK	RMB	1	DISK SEEK ERROR
ERR:DSKWRTPROT	RMB	1	DISK IS WRITE PROTECTED
ERR:DISKWRITELOCKED	RMB	1	DISK DEVICE IS SOFTWARE WRITE LOCKED
ERR:SDOSCKSUM	RMB	1	SDOS GOT A KNIFE IN THE RIBS!
ERR:NLSNGE224	RMB	1	NLSN >= 2^24, ILLEGAL
ERR:CLUSTERSIZELIMITSFILE	RMB	1	CLUSTER SIZE IS TOO SMALL TO SUPPORT A FILE THAT BIG
ERR:SYSCALLTOOSHORT	RMB	1	SYSCALL BLOCK IS TOO SMALL FOR SPECIFIED SYSCALL
ERR:RDBUFTOOSMALL	RMB	1	READ BUFFER SPECIFIED BY SYSCALL IS TOO SHORT FOR REPLY
ERR:WRBUFTOOSMALL	RMB	1	WRITE BUFFER SPECIFIED BY SYSCALL IS TOO SHORT
ERR:NOSUCHDEVICE	RMB	1	NO SUCH DEVICE IN THIS CONFIGURATION
	RMB	1	*** UNUSED
ERR:MUSTBEDISK	RMB	1	MUST SELECT DISK DEVICE
ERR:NOTOPENTOCONSOLE	RMB	1	CHANNEL 0 IS NOT OPEN TO CONSOLE DEVICE
ERR:DEVICENOTREADY	RMB	1	DEVICE IS NOT READY
	PAGE
*
*	SDOS LOADER FORMAT:  RECORD TYPE DEFINITIONS
*
LOAD:TYPE0	EQU	0	IGNORE RECORD
LOAD:TYPE1	EQU	1	STARTUP RECORD
LOAD:TYPE2	EQU	2	LOAD BYTES RECORD
LOAD:TYPE3	EQU	3	LOAD BYTES AND STOP RECORD
*
*	USEFUL ERROR-HANDLING OPCODES
*
OKRTS	EQU	$0C39	"CLC,RTS"
ERRORRTS	EQU	$0D39	"SEC,RTS"
*
*	FUNNY VALUES TO MAKE DATA STORAGE ALLOCATION USES MORE CLEAR
*
IGNORED	EQU	0	SO I CAN MARK PLACES AS IGNORED
CHANGED	EQU	0	SO I CAN MARK PLACES AS CHANGED
	PAGE
*
*	ASCII CHARACTER SET
*
ASCII:NULL	EQU	0	^@ NULL
ASCII:SOH	EQU	1	^A START OF HEADING
ASCII:STX	EQU	2	^B START OF TEXT
ASCII:ETX	EQU	3	^C END OF TEXT
ASCII:EOT	EQU	4	^D END OF TRANSMISSION
ASCII:ENQ	EQU	5	^E ENQUIRY (WRU- WHO ARE YOU)
ASCII:ACK	EQU	6	^F ACKNOWLEDGE
ASCII:B                                                                                                                                RTICAL TAB
ASCII:FF	EQU	$C	^L FORM FEED
ASCII:CR	EQU	$D	^M CARRIAGE RETURN
ASCII:SO	EQU	$E	^N SHIFT OUT
ASCII:SI	EQU	$F	^O SHIFT IN
ASCII:DLE	EQU	$10	^P DATA LINK ESCAPE
ASCII:DC1	EQU	$11	^Q DEVICE CONTROL 1
ASCII:DC2	EQU	$12	^R DEVICE CONTROL 2
ASCII:DC3	EQU	$13	^S DEVICE CONTROL 3
ASCII:DC4	EQU	$14	^T DEVICE CONTROL 4
ASCII:NAK	EQU	$15	^U NEGATIVE ACKNOWLEDGE
ASCII:SYN	EQU	$16	^V SYNCHRONOUS IDLE
ASCII:ETB	EQU	$17	^W END OF TRANSMISSION BLOCK
ASCII:CAN	EQU	$18	^X CANCEL
ASCII:EM	EQU	$19	^Y END OF MEDIUM
ASCII:SUB	EQU	$1A	^Z SUBSTITUTE
ASCII:ESC	EQU	$1B	^[ ESCAPE
ASCII:FS	EQU	$1C	^\ FILE SEPERATOR
ASCII:GS	EQU	$1D	^] GROUP SEPERATOR
ASCII:RS	EQU	$1E	^^ RECORD SEPERATOR
ASCII:US	EQU	$1F	^_ UNIT SEPERATOR
ASCII:SPACE	EQU	$20	SPACE (WORD SEPERATOR)
ASCII:RUBOUT	EQU	$7F	DELETE (RUBOUT)
ASCII:MASK	EQU	$7F	TO MASK OFF ALL BUT 7 LEGAL ASCII BITS
	PAGE
*	THIS BEGINS START OF DEFINITIONS REQUIRED FOR I/O PACKAGES
*
*	SDOS ENTRY POINTS
*
	ORG	0
SDOS:VERSIONNUMBER	RMB	1	VERSION NUMBER BYTE ($AB = VERSION A.B)
SDOS:LASTERROR	RMB	2	MOST RECENT ERROR ENCOUNTERED BY SDOS
SDOS:CONFIGURATION	RMB	2	POINTER TO CONFIGURATION TABLE (SUPPLIED BY  I/O PACKAGE
SDOS:SERIALNUMBER	RMB	2	SERIAL NUMBER ASSIGNED TO THIS COPY
SDOS:IOBLOCKPTR	RMB	2	POINTER TO I/O REQUEST (PASSED TO DRIVERS)
SDOS:IOCBPOINTER	RMB	2	POINTER TO IOCB FOR THIS CHANNEL
SDOS:CLOCK	RMB	3	TIME OF DAY IN 1/60 SEC UNITS (0..5,183,999)
SDOS:DAY	RMB	1	DAY NUMBER IN MONTH (1..31) BCD
SDOS:MONTH	RMB	1	MONTH OF YEAR (1..12) BCD
SDOS:YEAR	RMB	1	YEAR MODULO 100 (78..99) BCD
SDOS:STACKSWITCHED	RMB	1	"SWITCHED TO INTERRUPT STACK" COUNTER
SDOS:IOINT	RMB	3	I/O INTERRUPT GOES HERE FIRST!
SDOS:RTI	RMB	3	JMP TO "RETURN FROM INTERRUPT; NO EVENT"
SDOS:RESCHEDULE	RMB	3	JMP TO "RETURN FROM INTERRUPT; PLEASE RESCHEDULE"
SDOS:CLOCKTICKED	RMB	3	JMP TO "CLOCKTICKED" WITH (A) = # TICKS
SDOS:CURRENTASK	RMB	2	POINTER TO TCB OF CURRENTLY ACTIVE TASK
SDOS:KILLPROOF	RMB	1	0 --> USER TASK IS KILLABLE
SDOS:KILLUSERPROGRAM	RMB	3	JMP TO "KILL USER PROGRAM" ROUTINE
SDOS:STARTIO	RMB	3	JMP TO START I/O ROUTINE (X POINTS TO INTERRUPT ROUTINE)
SDOS:WAITCOND	RMB	3	JMP TO WAIT FOR CONDITION IN (A,B)
SDOS:WAITEVENT	RMB	3	JMP TO WAIT FOR EVENT SELECTED BY (X)
SDOS:ERROR	RMB	3	ERROR SUBROUTINE; INLINE 2 BYTE ERROR CODE
SDOS:ERRORSAVE	RMB	3	ERROR CODE SAVE ROUTINE; SAVES (X) AS ERROR CODE
SDOS:ERRORED	RMB	3	"ERROR CAN'T BE HANDLED BY ME" ENTRY
SDOS:CHECKRDLEN	RMB	3	CHECK READ LENGTH SUBROUTINE ENTRY POINT
SDOS:CHECKWRLEN	RMB	3	CHECK WRITE LENGTH SUBROUTINE ENTRY POINT
SDOS:ENTRYSIZE	EQU	*
	PAGE
*
*	SDOS CONFIGURATION TABLE
*
	ORG	0
CNFG:DISKDCBS	RMB	2	POINTER TO DISK DEVICE CONTROL BLOCKS
CNFG:DEVICEDCBS	RMB	2	POINTER TO LIST OF NON-DISK DEVICE CONTROL BLOCKS
CNFG:IOCBPOINTERS	RMB	2	POINTER LIST TO IOCB'S
CNFG:NIOCHANNELS	RMB	1	NUMBER OF I/O CHANNELS
CNFG:DSKBUFFERPOOL	RMB	2	POINTER TO THE DISK BUFFER POOL
CNFG:DSKPOOLSIZE	RMB	2	SIZE OF THE BUFFER POOL
CNFG:ATTNCHECK	RMB	2	ADDRESS OF ATTENTION CHECK ROUTINE
CNFG:DEBUGGER	RMB	2	= ADDRESS OF DEBUGGER (0 IF NONE)
CNFG:DRIVERBASE	RMB	2	LOWEST ADDRESS USED BY DRIVERS
CNFG                                                                                                                                CNFG:INTENABLE	RMB	3	SUBROUTINE (OR "JMP") TO ENABLE ALL INTERRUPTS
CNFG:INTRTI	RMB	3	CODE TO ENABLE PRIORITY INTERRUPT AND DO RTI (USUALLY JUST "RTI")
CNFG:INTERRUPTSTACK	RMB	2	POINTER TO LAST BYTE OF INTERRUPT STACK SPACE
*			(USED BY AN "LDS" INSTRUCTION)
CNFG:IOINTPOLL	RMB	2	POINTER TO I/O INTERRUPT SERVICE DEVICE POLL ROUTINE
CNFG:TASKQUEUE	RMB	2	POINTER TO FIRST TASK IN TASK QUEUE
CNFG:TIMEOUTLIST	RMB	2	POINTER TO CHAINED LIST OF TIMEOUT BLOCKS
	PAGE
*
*	DEVICE DRIVER ROUTINE ENTRY POINTS
*
	ORG	0
DRIVER:OPEN	RMB	2	OPEN FILE
DRIVER:CLOSE	RMB	2	CLOSE FILE
DRIVER:READA	RMB	2	READ ASCII
DRIVER:WRITEA	RMB	2	WRITE ASCII
DRIVER:READB	RMB	2	READ BINARY
DRIVER:WRITEB	RMB	2	WRITE BINARY
DRIVER:CREATE	RMB	2	CREATE FILE
DRIVER:RENAME	RMB	2	RENAME FILE
DRIVER:DELETE	RMB	2	DELETE FILE
DRIVER:CONTROL	RMB	2	DO CONTROL OPERATION
DRIVER:STATUS	RMB	2	READ DEVICE (DRIVER) STATUS
DRIVER:RESET	RMB	2	RESET DRIVER (ON BOOT)
DRIVER:PFRESTART	RMB	2	POWER FAIL RESTART
*
*	DISK SECTOR I/O DRIVER ROUTINE ENTRY POINTS
*
	ORG	0
DRIVER:DISKRESET	RMB	2	RESET THIS DISK DRIVER
DRIVER:DISKREAD	RMB	2	INITIATE A DISK READ
DRIVER:DISKWRITE	RMB	2	INITIATE A DISK WRITE
DRIVER:DISKWAIT	RMB	2	WAIT FOR DISK I/O COMPLETE
DRIVER:DISKSTATUS	RMB	2	READ DISK-SPECIFIC STATUS
DRIVER:DISKCONTROL	RMB	2	PERFORM DISK-SPECIFIC CONTROL OPERATION
	PAGE
*
*	TIMEOUT ELEMENT DISPLACEMENTS
*
	ORG	0
TIMEOUT:LINK	RMB	2	POINTER TO NEXT TIMEOUT QUEUE ELEMENT
TIMEOUT:FUSE	RMB	2	16 BIT TIMEOUT COUNT (1/60 SEC UNITS); 0--> NO TIMEOUT
TIMEOUT:ROUTINE	RMB	2	POINTER TO TIMEOUT INTERRUPT ROUTINE FOR DEVICE
TIMEOUT:SIZE	EQU	*
*
*	REGISTER DISPLACEMENTS INTO A CONTEXT BLOCK
*	THESE VALUES ASSUME THAT (S) AFTER INTERRUPT, HAS BEEN COPIED INTO (X)
*
	ORG	1	THIS WORKS, DON'T KNOCK IT!
REG:CC	RMB	1	CONDITION CODE BITS
REG:B	RMB	1	B REGISTER
REG:A	RMB	1	A REGISTER
REG:X	RMB	2	X REGISTER (REG:X+1 IS LOW BYTE OF INDEX REGISTER)
REG:PC	RMB	2	P REGISTER (REG:P+1 IS LOW BYTE OF P COUNTER)
	PAGE
*
*	INTERRUPT SYSTEM DEFINITIONS

MINSTACK	EQU	7+7+7	7 BYTES FOR CONTEXT,...
*				7 FOR INTERRUPT AND 7 FOR NMI

*	TCB (TASK CONTROL BLOCK) DISPLACEMENTS

	ORG	0
TCB:LNK	RMB	2	POINTER TO NEXT TCB IN QUEUE
TCB:STACK	RMB	2	STACK POINTER FOR TASK
*	ON TOP OF A STACK IS ALWAYS A CONTEXT BLOCK
TCB:COND	RMB	2	TASK'S WAKE UP ROUTINE
TCB:PARAM	RMB	2	PARAMETER TO TCB:CND ROUTINE
TCB:SCRATCHPAD	RMB	8	SPACE FOR TASK'S SCRATCHPAD (LOCATIONS 0-7)
TCB:SIZE	EQU	*	SIZE OF TASK CONTROL BLOCK
*
*	LOCATIONS 0-7 ARE TREATED AS PART OF TASK'S CONTEXT
*	AND SAVED DURING A CONTEXT SWITCH
*
*	DEFINED TEMPORARIES
*	USED TO PUSH (X) ONTO STACK IN INTERRUPTABLE WAY
*	FOR USE BY TASK-LEVEL SUBROUTINES
*
	ORG	$0
TEMPX	RMB	2	ANY SUBROUTINE MAY STEP ON THIS!!!
TEMP	EQU	TEMPX	FOR CONVENIENCE
TEMPA	EQU	TEMPX	TEMP STORAGE FOR A REGISTER
TEMPB	EQU	TEMPX+1	TEMP STORAGE FOR B REGISTER
*
DCBPOINTER	EQU	$6	POINTER TO DEVICE CONTROL BLOCK
*
	ORG	$F0
SYSDEPENDENT	RMB	16	16 BYTES RESERVED FOR SYSTEM DEPENDENT USE
	PAGE
*
*
*
LSN:SIZE	EQU	3	# BYTES OCCUPIED BY AN LSN
LCN:SIZE	EQU	2	# BYTES OCCUPIED BY AN LCN
DUMMYLCN	EQU	$FFFF	"NO LCN" CODE
*
*	BOOT SECTOR DISPLACEMENTS (SPOS'D TO COME JUST BEFORE LSN:SIZE)
*
	ORG	0
BOOT:IPLDATA	RMB	16	CONTAINS "JMP BOOTSIZE" OR OTHER BOOTSTRAP DATA
BOOT:DISKINFO	RMB	0	SPACE FOR DISKINFO TABLES
BOOT:DISKINFOLEN	EQU	16
BOOT:FILESYSTEMVERSION	RMB	1	SDOS FILE SYSTEM FORMAT VERSION NUMBER $AB = A.B
BOOT:NSPC	RMB	1	NUMBER OF SECTORS PER CLUSTER
BOOT:MINALLOC	RMB	LCN:SIZE	ALLOCATION MINIMUM FOR NEW FILES
BOOT:MIDALLOC	RMB	LCN:SIZE	ALLOCATION MIN FOR FILE EXTENSION
BOOT:MAPALGORITHM	RMB	2	LOGICAL TO PHYSICAL CONVERSION ALGORITHM #
BOOT:CREATIONDATE	RMB	3	DD/MM/YY IN HEX
	RMB	BOOT:DISKINFOLEN+BOOT:DISKINFO-*-1
BOOT:CHECKSUM	RMB	1	SUCH THAT SUM OF DISKINFO BYTES (INCL CKSUM) = $FF
BOOT:DISKID	RMB	32	TEXT NAME OF DISK (TRAILING BLANK PADDED)
BOOT:SIZE	EQU	*
*
*	DEVICE CONTROL BLOCK DISPLACEMENTS
*
	ORG	0
DCB:DONEFLAG	RMB	1	0 --> DEVICE IS BUSY; <>0 --> DEVICE IS DONE
DCB:LASTERROR	RMB	2	IF DCB IS DONE, CONTAINS ERROR STATUS (0 = NONE )
DCB:NAME	RMB	2	POINTER TO DEVICE NAME STRING TERMINATED BY ZERO BYTE
DCB:NEXTDCB	RMB	2	POINTER TO NEXT DCB IN LIST OR ZERO
DCB:DRIVER	RMB	2	POINTER TO DRIVER ENTRY POINT LIST
DCB:SIZE	EQU	*	DEVICE SPECIFIC DATA EXTENDS DCB FROM HERE
	PAGE
*	DISKINFO TABLE DISPLACEMENTS
*
	ORG	DCB:SIZE
DSKINFO:NBPS	RMB	2	NUMBER OF BYTES PER SECTOR
DSKINFO:NSPT	RMB	2	NUMBER OF SECTORS PER TRACK
DSKINFO:NTPC	RMB	2	NUMBER OF TRACKS PER CYLINDER
DSKINFO:NCYL	RMB	2	NUMBER OF CYLINDERS PER DRIVE
*
*	THE FOLLOWING ARE FILLED FROM THE BOOT SECTOR
DSKINFO:NSPC	RMB	1	NUMBER OF SECTORS PER CLUSTER
DSKINFO:MINALLOC	RMB	LCN:SIZE	ALLOCATION MINIMUM FOR NEW FILES
DSKINFO:MIDALLOC	RMB	LCN:SIZE	ALLOCATION MIN FOR FILE EXTENSION
DSKINFO:MAPALGORITHM	RMB	2	CODE TO SELECT LOGICAL TO PHYSICAL SECTOR MAP ALGORITHM
BOOT:PARAMSIZE	EQU	*-DSKINFO:NSPC	SYSTEM DEPENDENT PARAMETERS IN BOOT BLOCK
*	END OF BOOT SECTOR DISK INFO
*
DSKINFO:LOG2NBPS	RMB	1	LOG BASE 2 OF DSKINFO:NBPS
DSKINFO:NBPSM1	RMB	2	= NBPS-1 FOR USE AS MASK (QUICK "MOD NBPS")
DSKINFO:NLSN	RMB	LSN:SIZE	NUMBER OF LSNS FOR THIS DISK = NSPT*NTPC*NCYL
DSKINFO:NLCN	RMB	LCN:SIZE	NUMBER OF LCNS FOR THIS DISK = NLSN/NSPC
DSKINFO:NBPC	RMB	2	NUMBER OF BYTES PER CLUSTER
DSKINFO:RANDMAP	RMB	LCN:SIZE	"RANDOM" LCN TO DISTRIBUTE NEW FILES
DSKINFO:MAPLSN	RMB	LSN:SIZE	LSN OF 1ST SECTOR IN DISK
*			ALLOCATION MAP CLUSTER
DSKINFO:DIRFCB	RMB	2	POINTER TO FCB FOR $DIRECTORY FILE
DSKINFO:MAPFCB	RMB	2	POINTER TO FCB FOR $DISKMAP FILE
DSKINFO:SECTORDB	RMB	2	POINTER TO RDSI CONTAINING LSN, ADDRESS PARAMETERS
DSKINFO:BADLSN	RMB	3	LSN OF LAST SECTOR THAT COULDN'T READ/WRITE/SEEK
DSKINFO:SEEKERRCNT	RMB	2
DSKINFO:SEEKERRSTS	RMB	2
DSKINFO:WRITEERRCNT	RMB	2
DSKINFO:WRITEERRSTS	RMB	2	
DSKINFO:READERRCNT	RMB	2
DSKINFO:READERRSTS	RMB	2
DSKINFO:OPSCOUNT	RMB	3
DSKINFO:ERRLSN	RMB	LSN:SIZE
DSKINFO:SIZE	EQU	*
	PAGE
*
*	SECTOR DESCRIPTOR BLOCK DISPLACEMENTS
*
	ORG	0
SECTORDB:DISKINFO	RMB	2	POINTER TO DISKINFO TABLE FOR DRIVE CONTAINING SECTOR
SECTORDB:LSN	RMB	LSN:SIZE	LOGICAL SECTOR NUMBER OF SECTOR
SECTORDB:ADDRESS	RMB	2	MEMORY ADDRESS FOR SECTOR
SECTORDB:SIZE	EQU	*
*
*	RESIDENT DISK SECTOR INFORMATION BLOCK DISPLACEMENTS
*
	ORG	0
RDSI:DISKINFO	RMB	2	POINTER TO DISKINFO TABLE FOR THIS DRIVE
RDSI:LSN	RMB	LSN:SIZE	LOGICAL SECTOR NUMBER OF SECTOR
RDSI:SECTORBASE	RMB	2	POINTER TO ACTUAL SECTOR CONTENTS
RDSI:FLINK	RMB	2	FORWARD LINK IN LRU CHAIN
RDSI:BLINK	RMB	2	BACKWARD LINK IN LRU CHAIN
RDSI:MODIFIED	RMB	1	"THIS SECTOR MODIFIED" FLAG
RDSI:STATE	RMB	1	STATE OF RDSI
RDSI:SIZE	EQU	*
*
*	RDSI STATE DEFINITIONS
*
RDSISTATE:IDLE	EQU	0	SECTOR TRANSFER IS COMPLETE
RDSISTATE:READING	EQU	1	SECTOR IS BEING READ INTO MEMORY
RDSISTATE:WRITING	EQU	2	SECTOR IS BEING WRITTEN FROM MEMORY
	PAGE
*
*	FILE CONTROL BLOCK DISPLACEMENTS
*
	ORG	0
FCB:DISKINFO	RMB	2	POINTER TO DISKINFO TABLE FOR THIS DRIVE
FCB:DIRLSN	RMB	LSN:SIZE	LSN OF DIRECTORY ENTRY
FCB:DIRDISP	RMB	2	DISPLACEMENT FOR DIRECTORY ENTRY FROM TOP OF SECTOR IN BYTES
FCB:HLSN	RMB	LSN:SIZE	= FCB:HLCN*DSKINFO:NSPC
FCB:FLAGS	RMB	1	FLAG BITS DESCRIBING FCB
FCB:REFCOUNT	RMB	1	NUMBER OF IOCBS USING THIS FCB
FCB:HLCN	RMB	LCN:SIZE	HEADER LOGICAL CLUSTER NUMBER OF FILE
FCB:HCSIC	RMB	1	HEADER CLUSTER INITIALIZED COUNT
FCB:NCLUSTERS	RMB	LCN:SIZE	NUMBER OF CLUSTERS ALLOCATED TO THE FILE
FCB:FILESIZE	RMB	4	SIZE OF THE FILE IN BYTES
FCB:PROT	RMB	1	PROTECTION BITS FROM DIRECTORY
FCB:DAY	RMB	1	DATE OF FILE CREATION
FCB:MONTH	RMB	1	MONTH OF FILE CREATION
FCB:YEAR	RMB	1	YEAR OF FILE CREATION MODULO 100
FCB:VERSION	RMB	1	VERSION # OF FILE (NOT USED IN 1.0)
FCB:SIZE	EQU	*
*
FCBFLG::NEWFILE	EQU	$80	FCB:FLAGS --> THIS FILE WAS CREATED
FCBFLG::UPDATEDIR	EQU	$40	FCB:FLAGS --> COPY FCB DATA BACK TO DIRECTORY
FCBFLG::DELETED	EQU	$20	FCB:FLAGS --> THIS FILE WAS REPLACED BY ANOTHER
*
*
*
NMAGICFCBS	EQU	2	FOR ERRMSGFCB, SYSFCB
	PAGE
*
*	DIRECTORY ENTRY DISPLACEMENTS
*
FILESYSTEMVERSION	EQU	$10	VERSION 1.0 OF FILESYSTEM FORMAT

	ORG	0
DIR:NAMESIZE	EQU	16	LENGTH OF DIRECTORY NAME
DIR:FILENAME	RMB	DIR:NAMESIZE	FILENAME IN ASCII
DIR:FCBDATA	RMB	0	FCB DATA FOR FILE MANAGEMENT STARTS HERE
DIR:HLCN	RMB	LCN:SIZE	LCN OF HEADER CLUSTER
DIR:HCSIC	RMB	1	HEADER CLUSTER INITIALIZED COUNT
DIR:NCLUSTERS	RMB	LCN:SIZE	NUMBER OF CLUSTERS ALLOCATED TO FILE
DIR:FILESIZE	RMB	4	LOGICAL SIZE OF FILE IN BYTES
DIR:PROTECTION	RMB	1	PROTECTION BITS
DIR:DAY	RMB	1	CREATION DATE OF FILE
DIR:MONTH	RMB	1	MONTH OF FILE CREATION
DIR:YEAR	RMB	1	YEAR OF FILE CREATION
DIR:VERSION	RMB	1	VERSION NUMBER OF FILE (0-255)
DIR:FCBDATASIZE	EQU	*-DIR:FCBDATA	# BYTES REQUIRED TO MANAGE FILES IN FCBS
	RMB	32-*	SPACE FOR SLOP
DIR:ENTRYSIZE	EQU	*
*
*	PROTECTION BITS FOR DIR:PROTECTION
*
PROT::DELETE	EQU	$80	PROTECT AGAINST DELETION
PROT::WRITE	EQU	$40	PROTECT AGAINST WRITES
	PAGE
*
*	IOCB DEFINITIONS
*
	ORG	0
IOCB:DCB	RMB	2	POINTER TO DEVICE CONTROL BLOCK
IOCB:CURLSN	RMB	LSN:SIZE	LOGICAL SECTOR # OF CURBYTE
IOCB:BUFFERP	RMB	2	ADDRESS OF 1ST BYTE TO TRANSFER
IOCB:FCB	RMB	2	POINTER TO FILE CONTROL BLOCK
IOCB:DRIVER	RMB	2	POINTER TO DRIVER VECTOR FOR DEVICE
IOCB:EOFFLAG	RMB	1	END OF FILE HIT FLAG
IOCB:COLCNT	RMB	1	COLUMN COUNTER
IOCB:CURBYTE	RMB	4	VIRTUAL BYTE # TO READ/WRITE FROM/TO NEXT
IOCB:LOCATEDF	RMB	1	0 --> NEED TO DO A LOCATECURBYTE
*			1 --> LOCATECURBYTE DONE
IOCB:DRDSI	RMB	2	POINTER TO DATA RESIDENT DISK SECTOR INFO
IOCB:NEXTBYTE	RMB	2	POINTER TO NEXT BYTE OF DISK SECTOR
IOCB:BYTECOUNT	RMB	2	NUMBER OF BYTES LEFT TO PROCESS IN SECTOR
IOCB:CURLCN	RMB	LCN:SIZE	CURRENT LOGICAL CLUSTER NUMBER BEING PROCESSED
IOCB:DRSN	RMB	1	RELATIVE DATA SECTOR NUMBER WITHIN CLUSTER
IOCB:RDCN	RMB	LCN:SIZE	RELATIVE DATA CLUSTER NUMBER W/ RESPECT TO DATA
*			CLUSTERS WITHIN THE FILE (0=HEADER CLUSTER)
IOCB:RBN	RMB	2	RELATIVE BYTE # WITHIN A CLUSTER
IOCB:HRDSI	RMB	2	POINTER TO RDSI FOR CURRENT HEADER BLOCK
IOCB:HRSN	RMB	1	RELATIVE SECTOR NUMBER OF HEADER SECTOR
IOCB:SIZE	EQU	*

IOCB:DISKWRITELOCKED	EQU	IOCB:LOCATEDF	1 --> DISK "DEVICE" IS WRITE LOCKED
	PAGE
*
*	DISKMAP DISPLACEMENTS
*
	ORG	0
DISKMAP:BYTE	RMB	1
NMBPB	EQU	8	# MAP BITS PER BYTE
*
*	????
*
SECTOR:BYTE	EQU	0	USED AS DISPLACEMENT ON SECTOR BYTE FETCH
*
READAHEADRDSIMIN	EQU	3	READ-AHEAD HAPPENS ONLY IF MORE BUFFERS AVAILABLE
*
*	HEADER CLUSTER DISPLACEMENTS
*
	ORG	0
HEADER:LCN	RMB	LCN:SIZE
*
*	WEIRD CHANNEL DEFINITIONS
*
LOGCHANNEL	EQU	$FF	(LOG CHANNEL MUST BE LOWEST OF THESE)
SYSCHANNEL	EQU	$FE	SYSTEM I/O CHANNEL (RESERVED)
	PAGE
	LIST	1
