!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!                                                                             !
!       MACRO EXPANDER 1.0 12/12/79 CJM                                       !
!       HACKED TO PRE-PROCESS 680C INSTRUCTIONS FOR ASM 8/6/80 JRY            !
!                                                                             !
!	Update History:
!		8/9/82 I.B.
!			Fixed 100 character ARG field causes error 11
!		7/30/82	I.B.
!			Fixed Lowercase operand not passed correctly
!			fixed	LDAA #'[       causes errors
!			fixed	LDAA #',       causes errors
!			fixed ';' in middle of line not detected a start comment
!			fixed long AF gets truncated
!
!       This program will expand macros in assembly language programs.        !
!       No forward references are allowed to macros, since this is a one      !
!       pass program.  Also, macro definitions ignore conditional assembly,   !
!       that is, you can not conditionally define a macro, though conditional !
!       assembly is permited within a macro.  Conditional assembly statements !
!       of two kinds are permitted: .IF, and IF; .ELSE, and ELSE; .ELSEIF,    !
!       and ELSEIF; .FIN and FIN.  Those without the leading period are       !
!       passed, as-is to the assembler.  Those with the leading period are    !
!       pre-processed in a crude manner, to omit those statements which the   !
!       assembler would have skipped, anyway.                                 !
!                                                                             !
!       MACRO DEFINITION                                                      !
!                                                                             !
!       To define a macro, the input stream must contain a line with the      !
!       word 'MACRO' in the label field followed by the name of the           !
!       macro in the command field.  The argument field and the comment       !
!       field are ignored.  The text of the macro follows, and finally        !
!       the word 'MEND' must appear in the op field after the last            !
!       line of the macro.                                                    !
!                                                                             !
!       Arguments are named ?n, where n varies from 0 to 9, corresponding     !
!       to the first through last argument.  Should an argument not be        !
!       supplied, the value of ?n is '0'.                                     !
!                                                                             !
!       Local labels can be generated by use of ?a, where 'a' is a letter.    !
!                                                                             !
!       EXAMPLE MACRO                                                         !
!                                                                             !
!       MACRO   PRINT   This macro prints a message on the terminal (chan 0)  !
!       *               The args are as follows: string,error routine         !
!       *               if the error routine isn't supplied (=0), an          !
!       *               error exit is performed on an error                   !
!               LDX     #?A                                                   !
!               JSR     $FB                                                   !
!               BCC     ?B                                                    !
!               IF      0=?1    IS THERE NO ERROR ROUTINE?                    !
!               STX     ?C                                                    !
!               LDX     #?D                                                   !
!               JMP     $FB     BYE-BYE!                                      !
!               ELSE                                                          !
!               JMP     ?1      GO TO HIS ERROR RECOVERY ROUTINE              !
!               FIN                                                           !
!       ?A      FCB     SYSCALL:WRITEA                                        !
!               FCB     WRITEA:SCLEN                                          !
!               FCB     0,IGNORED                                             !
!               FDB     ?E      STRING ADDRESS                                !
!               FDB     ?F      STRING LENGTH                                 !
!                                                                             !
!       ?E      FCC     ?0                                                    !
!       ?F      EQU     *-?E                                                  !
!                                                                             !
!       ?D      FCB     SYSCALL:ERROREXIT                                     !
!               FCB     ERROREXIT:SCLEN                                       !
!               FDB     CHANGED                                               !
!                                                                             !
!       ?B      EQU     *                                                     !
!               MEND                                                          !
!                                                                             !
!                                                                             !
!       SPECIAL COMMAND LINE PARSING                                          !
!                                                                             !
!       In order for macros to replace normal instructions, special parsing   !
!       is provided.  In particular, the following flags are SET to 1 iff     !
!       the following conditions are met:                                     !
!                                                                             !
!       FLAG            CONDITION                                             !
!       ----            ---------                                             !
!       IMMEDIATE       A number sign (#) appeared before the arg list        !
!       INDIR           The arg list was surrounded by brackets ('[]')        !
!       INDEXOFFX       An indexed address mode off X was given               !
!       INDEXOFFS       An indexed address mode off S was given               !
!       POSTINCREMENT   Post-inc indexing                                     !
!       PREDECREMENT    Pre-dec indexing                                      !
!       DOUBLEINCDEC    Either double Post-inc or Pre-dec                     !
!       INDEXED         Indexed addressing (of any kind)                      !
!       DIRECT          not(INDEXED or IMMEDIATE)                             !
!                                                                             !
!       Note: The indexing (which might be ',++X', etc.) DOES NOT get         !
!       passed as an argument to the macro!!                                  !
!                                                                             !
!       If one or more of the above flags occurs on a "." type conditional    !
!       assembly statement, and any of the values is 1, then the argument     !
!       of the statement is considered TRUE (a logical OR of all of the       !
!       arguments is performed).                                              !
!                                                                             !
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

	DIM	MACROS$[2048]/""/
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
         ! Macro expansion variable                                 !
         ! ! :FF ! name of macro ! :FE ! channel # ! File position !!
         !    1         n           1        1           3          !
         !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

!	other variables for macro expansion:
	DIM	MACRO$[20], MLINE$[132], MACROLINE$[132], FF$/:FF/
	DIM	FE$/:FE/, T$[4], ARGS$[150], BYTES4$/0,0,0,0/

!	macro processor state variable
	DIM	MACROSTATE/1/,EMITSTATE/1/,CONDBLOCK/0/,SAVEBLOCK/0/

!	various parsing variables
	DIM	IMMEDIATE/0/, POSTINC/0/, PREDEC/0/, DOUBLE/0/
	DIM	INDEXED/0/, INDEXOFFS/0/, INDEXOFFX/0/, INDIR/0/
	DIM	DIRECT/0/
	DIM	CONIF$/:09,".IF"/,CONELSE$/:09,".ELSE"/
	DIM	CONELSEIF$/:09,".ELSEIF"/,CONFIN$/:09,".FIN"/

!	Flag values
	DIM	IMMEDIATEFLAG/:01/
	DIM	POSTINCFLAG/:02/, PREDECFLAG/:04/
	DIM	DOUBLEFLAG/:08/, INDEXEDFLAG/:10/
	DIM	INDEXOFFXFLAG/:20/, INDEXOFFSFLAG/:40/
	DIM	INDIRFLAG/:80/, DIRECTFLAG/:100/
	DIM	 NEWFLAGS/:000/

!	argument binding variables
	DIM	ARGSP(10), ARGSL(10), NARGS/0/

!	position in macros$ of current macro
	DIM	MACROPOS

!	VARIABLES FOR PREPARSING

!	various fields in line
	DIM	LABEL$[32], CF$[32], AF$[132], REST$[132]

!	input line and scratch
	DIM	LINE$[132], TEMP$[132]

!	GET LINE VARIABLES
	DIM	CURCHAN/1/, OUTPUT/1/, FILE$[30]

!	SYSCALL VARIABLE(S)
	DIM	GETCURPOS$/:F,:E,0,0/, CHANNEL/3/

!	local label variables
	DIM	LABELBASE/0/,NLABELSUSED/0/

                              !!!!!!!!!!!!!!!!!!!
                              ! PROGRAM STARTUP !
                              !!!!!!!!!!!!!!!!!!!

	PRINT "M680C v1.0j   Copyright (C) 1980 Software Dynamics"
	INPUT	"Output file= " FILE$
	IF	FILE$="CONSOLE:" THEN OUTPUT=0
	ELSE	CREATE	#OUTPUT, FILE$
	CURCHAN=CURCHAN+1
	OPEN	#CURCHAN,"M680C.LIB"

                           !!!!!!!!!!!!!!!!!!!!!!!!
                           ! GET LINE FROM SOURCE !
                           !!!!!!!!!!!!!!!!!!!!!!!!
GETLINE:	INPUT	#CURCHAN, LINE$
	IF	EOF(CURCHAN) THEN UNEXPECTEDEOF

	GOSUB	PREPARSE
	IF	CF$<>"END" THEN MACROEXPANDER

GETNEXTFILE:	IF	CURCHAN=3 THEN WRAPTHINGSUP
	INPUT	"Input file= " FILE$
	IF	FILE$="" THEN WRAPTHINGSUP

	CURCHAN	=CURCHAN+1
	OPEN	#CURCHAN, FILE$
	GOTO	GETLINE

WRAPTHINGSUP:	PRINT	#OUTPUT, LINE$
	EXIT
UNEXPECTEDEOF:	LINE$="	END	;UNEXPECTED EOF"
	PRINT	"No END in file!"
	GOTO	GETNEXTFILE


                             !!!!!!!!!!!!!!!!!!!!!
                             ! PRE PARSE ROUTINE !
                             !!!!!!!!!!!!!!!!!!!!!
PREPARSE:	LABEL$	=""
	CF$	=""
	AF$	=""
	REST$	=""

!	a few quick tests...

	IF	FIND(LINE$,"*")=1 THEN
		REST$=LINE$
		RETURN
	FI

	IF	FIND(LINE$,';')
	THEN
		TEMP$=LINE$[1,FIND(LINE$,';')-1]
		REST$=RIGHT$(LINE$,FIND(LINE$,';'))
	ELSE
		TEMP$=LINE$
	FI

	IF LEN(TEMP$)=0 THEN RETURN

PREPARSEFORLABEL:	IF	TEMP$(1,1)=' ' OR TEMP$(1,1)='	'
	THEN
		GOSUB	EATSPACES
		GOTO	PREPARSEFORCF
	FI

	I	=FIND(TEMP$,'	')
	J	=FIND(TEMP$,' ')

	IF	I=0 THEN I=J
	IF	J=0 THEN J=I
	IF	I<J THEN
		LABEL$	=UPPERCASE$(TEMP$(1,I-1))
		TEMP$	=RIGHT$(TEMP$,I+1)
	ELSE
		IF J=0 THEN
			LABEL$=UPPERCASE$(TEMP$)
			RETURN
		FI
		LABEL$	=UPPERCASE$(TEMP$(1,J-1))
		TEMP$	=RIGHT$(TEMP$,J+1)
	FI

	GOSUB	EATSPACES

PREPARSEFORCF:	IF	TEMP$=""
	THEN
		LABEL$=""
		REST$=LINE$
		RETURN
	FI

	I	=FIND(TEMP$,'	')
	J	=FIND(TEMP$,' ')
	IF	I=0 THEN I=J
	IF	J=0 THEN J=I

	IF	I<J THEN
		CF$	=UPPERCASE$(TEMP$(1,I-1))
		TEMP$	=RIGHT$(TEMP$,I+1)
	ELSE
		IF J=0 THEN
			CF$=UPPERCASE$(TEMP$)
			RETURN
		FI
		CF$	=UPPERCASE$(TEMP$(1,J-1))
		TEMP$	=RIGHT$(TEMP$,J+1)
	FI

	GOSUB	EATSPACES

PREPARSEFORAF:	IF TEMP$="" THEN RETURN


	I	=FIND(TEMP$,"	")
	J	=FIND(TEMP$," ")

	IF	I=0  THEN I=J
	IF	J=0 THEN J=I
	IF	I<J
	THEN
		! NOTE: THIS LEAVES AF IN UPPER/LOWER CASE
		AF$	=TEMP$(1,I-1)
		TEMP$	=RIGHT$(TEMP$,I+1)
	ELSE
		IF J=0 THEN
			AF$=TEMP$
			RETURN
		FI
		AF$	=TEMP$(1,J-1)
		TEMP$	=RIGHT$(TEMP$,J+1)
	FI

	GOSUB	EATSPACES

PREPARSEREST:	REST$	=TEMP$ CAT REST$
	RETURN

                  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                  ! EAT SPACES AND TABS FROM FRONT OF TEMP$ !
                  !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

EATSPACES:	IF FIND(TEMP$,' ')=1 OR FIND(TEMP$,'	')=1 THEN
			TEMP$=RIGHT$(TEMP$,2)
			GOTO EATSPACES
		FI
	RETURN






                        !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                        ! ACTUAL MACRO EXPANSION CODE !
                        !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
!	Macro states:
!		1-not defining nor expanding a macro
!		2-expanding a macro (included for completeness)
!		3-defining a macro

        DEF ADJUSTCOND(INCR)

!        PRINT "MLINE$='";MLINE$;"'" !D!
!        PRINT "CONDBLOCK =";CONDBLOCK+INCR;" SAVEBLOCK =";SAVEBLOCK; !D!
!        PRINT " EMITSTATE =";EMITSTATE;" NEWFLAGS =";HEX$(NEWFLAGS) !D!
        RETURN CONDBLOCK+INCR

        END

MACROEXPANDER:	MLINE$	=LINE$
	ON MACROSTATE GOTO MACROSTART, EXPANDLOOP, ENDMACDEF
	PRINT	"Error encountered in MACROEXPANDER.  Processing continues."
	MACROSTATE=1
	GOTO MACROEXPANDER

!	state 1: look for either starting to define the macro
!	         or a macro call.  If neither, just pass line
!	         to the output routine.

MACROSTART:	IF	LABEL$="MACRO" THEN STARTMACDEF

!	now, look to see if name is in macro table...

	TEMP$	=FF$ CAT CF$ CAT FE$
	MACROPOS	=FIND(MACROS$,TEMP$)

	IF	NOT(MACROPOS) THEN
		GOSUB MACROOUTPUT
		GOTO  GETLINE
	FI

	NEWFLAGS=0
!	Since we're here, we have found a macro which matches CF$

!	Now, parse the arguments... (iQUE DOLOR!)

!	LIST MACRO CALL WITH ";" FOLLOWING LABEL FIELD-SEPARATOR

	TEMP$=UPPERCASE$(MLINE$)
	I=FIND(RIGHT$(TEMP$,LEN(LABEL$)+1),CF$)+LEN(LABEL$)
	MLINE$=LEFT$(MLINE$,I-1) CAT ";" CAT RIGHT$(MLINE$,I)
	GOSUB MACROOUTPUT

!
!	first, determine if we're using either immediate or
!	indirect addressing, and set or reset flags accordingly
!
	IF	FIND(AF$,'[')=1 THEN
		IF	AF$(LEN(AF$),1)=']' THEN
			AF$	=RIGHT$(AF$,2)
			AF$	=AF$(1,LEN(AF$)-1)
		ELSE
			PRINT	"Bad indirect syntax: "
			PRINT	LINE$
			AF$	=RIGHT$(AF$,2)
		FI
		NEWFLAGS=NEWFLAGS!INDIRFLAG
	ELSE
		IF	FIND(AF$,'#')=1 THEN
			AF$	=RIGHT$(AF$,2)
			NEWFLAGS=NEWFLAGS!IMMEDIATEFLAG
			GOTO	BINDARGS
		FI
	FI

!	Now, determine indexing, and set or reset the various flags

	T$	=",--X"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPREDEC
		GOSUB	SETDOUBLE
		GOSUB	SETINDEXOFFX
		GOTO	BINDARGS
	FI

	T$	=",-X"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPREDEC
		GOSUB	SETSINGLE
		GOSUB	SETINDEXOFFX
		GOTO	BINDARGS
	FI

	T$	=",X++"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPOSTINC
		GOSUB	SETDOUBLE
		GOSUB	SETINDEXOFFX
		GOTO	BINDARGS
	FI

	T$	=",X+"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPOSTINC
		GOSUB	SETSINGLE
		GOSUB	SETINDEXOFFX
		GOTO	BINDARGS
	FI

	T$	=",X"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETNOINCDEC
		GOSUB	SETINDEXOFFX
		GOTO	BINDARGS
	FI
	T$	=",--S"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPREDEC
		GOSUB	SETDOUBLE
		GOSUB	SETINDEXOFFS
		GOTO	BINDARGS
	FI

	T$	=",-S"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPREDEC
		GOSUB	SETSINGLE
		GOSUB	SETINDEXOFFS
		GOTO	BINDARGS
	FI

	T$	=",S++"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPOSTINC
		GOSUB	SETDOUBLE
		GOSUB	SETINDEXOFFS
		GOTO	BINDARGS
	FI

	T$	=",S+"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETPOSTINC
		GOSUB	SETSINGLE
		GOSUB	SETINDEXOFFS
		GOTO	BINDARGS
	FI

	T$	=",S"
	GOSUB	FINDIT
	IF	YES THEN
		GOSUB	REMOVEIT
		GOSUB	SETNOINCDEC
		GOSUB	SETINDEXOFFS
		GOTO	BINDARGS
	FI
	IF NOT(NEWFLAGS) THEN NEWFLAGS=NEWFLAGS!DIRECTFLAG


!	now that we have determined any addressing modes, bind
!	the arguments for the expansion phase

BINDARGS:	NARGS	=0
	ARGS$	=""

BINDLOOP:	IF	FIND(AF$,"',")=1 THEN LASTARG
	I	=FIND(AF$,",")
	IF	NOT(I) THEN LASTARG
	NARGS	=NARGS+1

	ARGSP(NARGS)	=LEN(ARGS$)+1
	ARGSL(NARGS)	=I-1
	LEN(ARGS$)	=LEN(ARGS$)+I-1
	ARGS$(ARGSP(NARGS),ARGSL(NARGS))=AF$(1,I-1)

	AF$	=RIGHT$(AF$,I+1)
	GOTO	BINDLOOP

LASTARG:	IF	AF$="" THEN EXPAND

	NARGS	=NARGS+1
	ARGSP(NARGS)	=LEN(ARGS$)+1
	ARGSL(NARGS)	=LEN(AF$)
	LEN(ARGS$)	=LEN(ARGS$)+LEN(AF$)
	ARGS$(ARGSP(NARGS),ARGSL(NARGS))=AF$

!	now start the expansion of the macro

EXPAND:	MACROSTATE=2
		GOSUB	MACROFETCHINIT

EXPANDLOOP:	GOSUB	MACROFETCH

	IF	MACROLINE$="MEND" THEN
!		PRINT "MEND encountered:" !D!
!		CONDBLOCK=ADJUSTCOND(0) !D!
		LABELBASE	=LABELBASE+NLABELSUSED
		NLABELSUSED=0
		MACROSTATE=1
		GOTO GETLINE
	FI
	I	=0

SUBSARGSLOOP:
	IF I+1 >= LEN(MACROLINE$) THEN DONETHISLINE
	J=I+FIND(RIGHT$(MACROLINE$,I+1),"?")
	IF	J=I THEN DONETHISLINE
	IF	J=LEN(MACROLINE$) THEN DONETHISLINE

	I	=J
	IF	MACROLINE$(I+1)>=ASC '0' AND MACROLINE$(I+1)<=ASC '9'
	THEN
		J	=VAL(MACROLINE$(I+1,1))+1
		IF	J>NARGS THEN
		MACROLINE$=MACROLINE$(1,I-1) CAT '0' CAT ...
&			RIGHT$(MACROLINE$,I+2)
		GOTO	SUBSARGSLOOP
		FI
		MACROLINE$=MACROLINE$(1,I-1) CAT ...
&			ARGS$(ARGSP(J),ARGSL(J)) CAT ...
&			RIGHT$(MACROLINE$,I+2)
		GOTO	SUBSARGSLOOP
	FI

!	maybe it's a local label...

	IF	MACROLINE$(I+1)>=ASC 'A' AND MACROLINE$(I+1)<=ASC 'Z'
	THEN
		J	=MACROLINE$(I+1)-ASC 'A'+1
		IF	J>NLABELSUSED
		THEN	NLABELSUSED	=J
		MACROLINE$=MACROLINE$(1,I-1) CAT ...
&			"MACRO" CAT HEX$(J+LABELBASE) CAT ...
&			RIGHT$(MACROLINE$,I+2)
	FI
	GOTO	SUBSARGSLOOP

DONETHISLINE:	MLINE$	=MACROLINE$
	GOSUB	MACROOUTPUT
	GOTO	EXPANDLOOP


!	Macro definition loop

STARTMACDEF:	IF	CF$="" THEN
		PRINT	"NULL MACRO NAME ENCOUNTERED!"
		GOTO	ENDMACDEF
	FI

	GETCURPOS$(CHANNEL)	=CURCHAN
	SYSCALL	(GETCURPOS$,'',BYTES4$)

	BYTES4$(1)=CURCHAN

	MACRO$	=FF$ CAT CF$ CAT FE$ CAT BYTES4$

	LEN(MACROS$)=LEN(MACROS$)+LEN(MACRO$)
	MACROS$(LEN(MACROS$)+1-LEN(MACRO$),LEN(MACRO$))= MACRO$
	MACROSTATE	=3
	GOTO	GETLINE

ENDMACDEF:	IF	CF$<>"MEND" THEN GETLINE
	MACROSTATE=1
	GOTO	GETLINE




                           !!!!!!!!!!!!!!!!!!!!!!!!!
                           ! EXPANSION SUBROUTINES !
                           !!!!!!!!!!!!!!!!!!!!!!!!!



!	removeit...removes the indexing and sets various flags

REMOVEIT:	AF$	=AF$(1,YES-1) CAT RIGHT$(AF$,YES+LEN(T$))

	NEWFLAGS=NEWFLAGS!INDEXEDFLAG
	RETURN

!	findit...finds t$ (real tough)

FINDIT:	YES	=FIND(UPPERCASE$(AF$),T$)
	RETURN

SETPOSTINC:	NEWFLAGS=NEWFLAGS!POSTINCFLAG
	AF$=""
	RETURN


SETPREDEC:	NEWFLAGS=NEWFLAGS!PREDECFLAG
	AF$=""
	RETURN

SETSINGLE:	RETURN

SETDOUBLE:	NEWFLAGS=NEWFLAGS!DOUBLEFLAG
	RETURN

SETINDEXOFFX:	NEWFLAGS=NEWFLAGS!INDEXOFFXFLAG
	RETURN

SETINDEXOFFS:	NEWFLAGS=NEWFLAGS!INDEXOFFSFLAG
	RETURN

SETNOINCDEC:	RETURN

!	macro fetch init... prepare for fetching macros

MACROFETCHINIT:	I	=FIND(RIGHT$(MACROS$,MACROPOS),FE$)
	MACRO$	=MACROS$(MACROPOS,I+4)

	GETCURPOS$(CHANNEL)=MACRO$(I+1)
	SYSCALL	(GETCURPOS$,'',BYTES4$)

	POSITION	#MACRO$(I+1), ...
&		MACRO$(I+2)*65536+MACRO$(I+3)*256+MACRO$(I+4)


	RETURN

!	macro fetch...must watch for end of macro

MACROFETCH:	INPUT	#MACRO$(LEN(MACRO$)-3), MLINE$
	IF	EOF(MACRO$(LEN(MACRO$)-3)) THEN
		PRINT	"End encountered before MEND"
!               CONDBLOCK=ADJUSTCOND(0) !D!
		EMITSTATE=1
		CONDBLOCK=0
		MLINE$	="	MEND"
	FI
	LINE$	=MLINE$
	GOSUB	PREPARSE
	IF	CF$="MEND" THEN
		POSITION	#MACRO$(LEN(MACRO$)-3), ...
&		BYTES4$(2)*65536+BYTES4$(3)*256+BYTES4$(4)
		MLINE$	="MEND"
	FI

	MACROLINE$	=MLINE$
	RETURN


                      !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
                      ! MACRO OUTPUT ROUTINE...FOR NOW !
                      !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!



!       Do a cheap expression evaluation

        DEF CONDITIONSMET(X)

!        CONDBLOCK=ADJUSTCOND(0) !D!
        IF    FIND(MLINE$,"IMMEDIATE") AND NEWFLAGS&IMMEDIATEFLAG...
&          OR FIND(MLINE$,"INDIR") AND NEWFLAGS&INDIRFLAG...
&          OR FIND(MLINE$,"INDEXOFFX") AND NEWFLAGS&INDEXOFFXFLAG...
&          OR FIND(MLINE$,"INDEXOFFS") AND NEWFLAGS&INDEXOFFSFLAG...
&          OR FIND(MLINE$,"POSTINCREMENT") AND NEWFLAGS&POSTINCFLAG...
&          OR FIND(MLINE$,"PREDECREMENT") AND NEWFLAGS&PREDECFLAG...
&          OR FIND(MLINE$,"DOUBLEINCDEC") AND NEWFLAGS&DOUBLEFLAG...
&          OR FIND(MLINE$,"INDEXED") AND NEWFLAGS&INDEXEDFLAG...
&          OR FIND(MLINE$,"DIRECT") AND NEWFLAGS&DIRECTFLAG
        THEN
!              PRINT " RETURN= 1" !D!
              RETURN 1
        ELSE
!              PRINT " RETURN= 0" !D!
              RETURN 0
        FI

        END

MACROOUTPUT: ! Jam useful stuff into the output file.  Flush the rest.

        IF    MACROSTATE=2
        THEN  ON EMITSTATE GOTO EMITALL,EMITCOND,EMITELSE,EMITFIN
        ELSE
              PRINT #OUTPUT,MLINE$
              RETURN
        FI

EMITALL: ! Not in conditional output:
         ! emit everything, up to "IF".
         ! When found, adjust count for matching "FIN".  If the
         ! the conditions were met, emit until "ELSE", "ELSEIF", or "FIN".

        IF    FIND(MLINE$,CONIF$) THEN
              CONDBLOCK=ADJUSTCOND(1)
              IF    CONDITIONSMET(0) THEN EMITSTATE=2
              ELSE
                    EMITSTATE=3
                    SAVEBLOCK=CONDBLOCK
              FI
        ELSE  PRINT #OUTPUT,MLINE$
        RETURN

EMITCOND: ! In conditional output:
          ! emit everything, up to "IF", "ELSE", "ELSEIF", or "FIN".
          ! When found, process an "IF" with EMITALL, a "FIN" with EMITFIN.
          ! An "ELSE" or "ELSEIF" causes further output to be flushed until
          ! a "FIN" is found.

        IF    FIND(MLINE$,CONELSE$) THEN
              EMITSTATE=4
              SAVEBLOCK=CONDBLOCK
              RETURN
        FI
        IF    FIND(MLINE$,CONIF$) THEN
              IF    CONDBLOCK>=254 THEN
                    PRINT "Nesting error!!"
                    PRINT #OUTPUT,"** Nesting error **"
              ELSE
                    CONDBLOCK=ADJUSTCOND(1)
                    IF    NOT(CONDITIONSMET(0)) THEN
                          EMITSTATE=3
                          SAVEBLOCK=CONDBLOCK
                    FI
                    RETURN
              FI
        FI
        IF    FIND(MLINE$,CONFIN$) THEN
              IF    CONDBLOCK THEN CONDBLOCK=ADJUSTCOND(-1)
              ELSE
                    PRINT "Too many FIN's!!"
                    PRINT #OUTPUT,"** Too many FIN's **"
              FI
              RETURN
        FI
        PRINT #OUTPUT,MLINE$
        RETURN

EMITELSE: ! Flush output until an "ELSE", "ELSEIF", or "FIN"
          ! is found.

        IF    FIND(MLINE$,CONIF$) THEN
              IF    CONDBLOCK>=254 THEN
                    PRINT "Nesting error!!"
                    PRINT #OUTPUT,"** Nesting error **"
              ELSE CONDBLOCK=ADJUSTCOND(1)
              RETURN
        FI
        IF    FIND(MLINE$,CONFIN$) THEN
              IF    CONDBLOCK THEN
                    CONDBLOCK=ADJUSTCOND(-1)
                    IF    CONDBLOCK < SAVEBLOCK THEN
                          IF    CONDBLOCK THEN EMITSTATE=2
                          ELSE  EMITSTATE=1
                    ELSE  RETURN
              ELSE
                    PRINT "Too many FIN's!!"
                    PRINT #OUTPUT,"** Too many FIN's **"
                    RETURN
              FI
        FI
        IF    CONDBLOCK <= SAVEBLOCK THEN
              IF    FIND(MLINE$,CONELSEIF$) THEN
                    IF    CONDITIONSMET(0) THEN EMITSTATE=2
                    RETURN
              FI
              IF    FIND(MLINE$,CONELSE$) THEN EMITSTATE=2 FI
        FI
        RETURN

EMITFIN: ! Flush output until a "FIN" is found.  Continue flushing until
         ! "FIN"s matching all flushed "IF"s have been flushed.  If, at
         ! this time, not all "FIN"s have been matched, return to the
         ! EMITCOND state.  If all "FIN"s have been matched, return to the
         ! EMITALL state.  

        IF    FIND(MLINE$,CONIF$) THEN
              IF    CONDBLOCK>=254 THEN
                    PRINT "Nesting error!!"
                    PRINT #OUTPUT,"** Nesting error **"
              ELSE  CONDBLOCK=ADJUSTCOND(1)
              RETURN
        FI
        IF    FIND(MLINE$,CONFIN$) THEN
              IF    CONDBLOCK THEN CONDBLOCK=ADJUSTCOND(-1)
              ELSE
                    PRINT "Too many FIN's!!"
                    PRINT #OUTPUT,"** Too many FIN's **"
              FI
        FI
        IF    CONDBLOCK < SAVEBLOCK THEN
              IF    CONDBLOCK THEN EMITSTATE=2
              ELSE  EMITSTATE=1 FI
        FI
        RETURN

END
