!   MAKEMIKBUG -- PROGRAM TO MANUFACTURE "MIKBUG" RECORDS...
!                 FROM SDOS LOAD RECORD FILES
!
!   REVISION HISTORY:
!       MAKEMIKBUGV1.0B 2/2/81
!                 RELEASED WITH BASIC14H
!       MAKEMIKBUGV1.1A 4/25/82
!                 CLEANED UP OPERATOR INTERFACE
!                 PRINTS CPU TYPE ('00, '01 OR '09) WHEN MAKING RECORDS
!                 RELEASED WITH SDOS/09
!
        DIM VERSION$/"Make MIKBUG v1.1a"/
        DIM BYTE$(1), ADDRESS$(2), COUNT$(2)
        DIM SDOSFILE$(100), MIKBUGFILE$(100), LINE$(200)
        DIM I, IN/1/, OUT/2/, RECORDTYPE, COUNT
        DIM ADDRESS,CHECKSUM

DEF HEX2$(X1)=HEX$(X1)[4,2]

DEF HEX4$(X2)=HEX$(X2)[2,4]

        IF COL(0)>1
        THEN
            ! Smart user, file name is on command line
            INPUT '' LINE$
            PRINT Version$
            LET LINE$=UPPERCASE$(LINE$)
            LET I=FIND(LINE$," TO ")
            IF I=0 THEN ERROR 102 \ ! BAD COMMAND FORMAT
            LET SDOSFILE$=LINE$[1,I-1]
            LET MIKBUGFILE$=RIGHT$(LINE$,I+4)
        ELSE
            PRINT Version$
            INPUT 'SDOS object file to convert to MIKBUG: ' SDOSFILE$
            INPUT 'MIKBUG output file: ' MIKBUGFILE$
            PRINT "Next time, you can type:"
            PRINT "     .makemikbug ";SDOSFILE$;" to ";MIKBUGFILE$
        FI
        OPEN #IN, SDOSFILE$
        CREATE #OUT, MIKBUGFILE$

        ! PROCESS THE START RECORD
        READ #IN,BYTE$,ADDRESS$
        IF BYTE$[1]=1 THEN PRINT "6800 Object file"
        ELSEIF BYTE$[1]=2 THEN PRINT "6809 Object file"
        ELSEIF BYTE$[1]=3 THEN PRINT "6801 Object file"
        ELSE ERROR 1028 \ ! Not load record format file
        PRINT   "Record type= START  ";
        PRINT "address= ";HEX$(ADDRESS$(1)**8+ADDRESS$(2))
        READ #IN, ADDRESS$

100     READ #IN, BYTE$ \ ! SEE WHAT KIND OF RECORD IT IS
        RECORDTYPE = BYTE$(1)
        ON RECORDTYPE + 1 GOTO 1000, 2000, 3000, 4000
2000    PRINT "Illegal record type encountered (:";hex$(RECORDTYPE)[4,2];")"
        ERROR 1036 \ ! SDOS LOAD RECORD FORMAT ERROR

1000    ! THIS IS A SKIP RECORD
        READ #IN, COUNT$
        COUNT = COUNT$(1)*256 + COUNT$(2)
        PRINT   'Record type= SKIP   count= ' ; HEX$(COUNT)
        IF COUNT = 0 THEN 100
        FOR I = 1 TO COUNT DO READ #IN, BYTE$
        GOTO 100

4000    ! THIS IS A TERMINAL LOAD RECORD
        PRINT   "Record type= GO     ";
        GOTO 3001
3000    ! THIS IS A LOAD RECORD
        PRINT   "Record type= LOAD   ";
3001    READ #IN, ADDRESS$, COUNT$
        ADDRESS = ADDRESS$(1)*256 + ADDRESS$(2)
        PRINT "address= ";HEX$(ADDRESS);"  ";
        COUNT = COUNT$(1)*256+COUNT$(2)
        PRINT "count= ";HEX$(COUNT)
5000    REM OUTPUT A MIKBUG RECORD
        IF COUNT <32 THEN 5100
        PRINT #OUT,"S123";
        LET CHECKSUM=(:23+(ADDRESS**-8)+(ADDRESS&:FF))&:FF
        PRINT #OUT,HEX4$(ADDRESS);
        FOR I=1 TO 32
5010            READ #IN,BYTE$
                LET COUNT=COUNT-1
                LET ADDRESS=ADDRESS+1
                PRINT #OUT,HEX2$(BYTE$(1));
                LET CHECKSUM=(CHECKSUM+BYTE$(1))&:FF
        NEXT I
5020    PRINT #OUT,HEX2$(:FF-CHECKSUM)
        GOTO 5000
5100    IF COUNT <= 0 THEN 5130
        PRINT #OUT,"S1";HEX2$(COUNT+3);
        PRINT #OUT,HEX4$(ADDRESS);
        LET CHECKSUM=(COUNT+3+(ADDRESS**-8)+(ADDRESS&:FF))&:FF
        FOR I=1 TO COUNT
                READ #IN,BYTE$
                COUNT=COUNT-1
                ADDRESS=ADDRESS+1
                PRINT #OUT,HEX2$(BYTE$(1));
                LET CHECKSUM=(CHECKSUM+BYTE$(1))&:FF
        NEXT I
5120    PRINT #OUT,HEX2$(:FF-CHECKSUM)
5130    IF RECORDTYPE <> 3 THEN 100
        PRINT #OUT, 'S9'
        PRINT 'All done'
        EXIT

END
