!  SDCOPY -- Single Disk Copy program
!  8/22/83 IDB
!  Utility program to copy files from one diskette to another,
!  using only the default disk drive.
!
!  Usage:  .SDCOPY sourcefilename TO targetfilename<CR>
!
!  Note: disk device names must NOT be specified, unless entire disk copy
!        desired, which requires DISK: for both source and destination.
!
!        targetfilename may be "*" if sourcefilename is not DISK:,
!        meaning, "use the same sourcefilename as targetfilename"
!
!  The program SDC does not have to be on the disk containing "sourcefilename".
!  SDC will direct the operator to switch disks as necessary.
!  When copying is complete, SDC will direct the operator to
!  insert a system disk (must have DEFAULTPROGRAM on it).
!  Appropriate DISMOUNTs will be issued as necessary.
!
!  Requires 32Kb of user space to run

   Dim ProgramID$/"Single Disk Copy 1.0a"/
   Dim CopyBuffer$(18432),SourceFile$(100),TargetFile$(100),Dummy$(1)
   Dim SourceFilePosition/0/,EndOfFileHit/0/
   Dim TargetCreated/0/,DiskUnlockRequired/0/
   Dim Dismount$/:E,4,0,:11/,UnlockDisk$/:E,4,0,:10/

   If Col (0)>1
   Then
       ! user typed "<sourcefile> TO <destinationfile>"
       Input "" CopyBuffer$ \ ! Fetch command line
       Print ProgramID$
       Let CopyBuffer$=lowercase$(CopyBuffer$)
       let i=find(CopyBuffer$," to ")
       if i=0 then error 102 \ ! illegal command format
       let SourceFile$=CopyBuffer$(1,i)
       let TargetFile$=Right$(CopyBuffer$,i+4)
   Else
       ! User is a dummy, ask him all the pertinent details
       Print ProgramID$
       Input "Name of Source File: " SourceFile$
       Input "Name of Target File: " TargetFile$
   Fi
   If TargetFile$="*" Then TargetFile$=SourceFile$
   Open #1,"Disk:"\Syscall #1,Dismount$\Close#1\! Dismount System disk

CopyLoop: ...
&  Repeat
       Input "Insert Source Disk, hit <RETURN> " Dummy$
       Open #1,SourceFile$\Read #1@SourceFilePosition,CopyBuffer$
       If Eof(1) Then EndOfFileHit=TRUE fi\Close #1
       Open #1,"Disk:"\Syscall #1,Dismount$\Close #1\! Dismount Source disk

       Input "Insert Target Disk, hit <RETURN> " Dummy$
       If  TargetCreated
       Then Open #1,TargetFile$
       Else Create #1,TargetFile$\TargetCreated=TRUE
RetryWrite: ! Come here to do Write again after first try to write on disk
       If DiskUnlockRequired Then Syscall #1,UnlockDisk$
       If Error When
           Write #1@SourceFilePosition,CopyBuffer$
       Then
           If Err<>1049 then Error
           ! 1049 is "Disk is Software Write Locked"
           Input "Are you sure you want to write on the disk DEVICE? " Dummy$
           If Uppercase$(Dummy$)="Y"
           Then DiskUnlockRequired=TRUE\Goto RetryWrite
           Else Print "*** COPY ABORTED *** ";\Exit CopyLoop
       Fi
       Close #1
       SourceFilePosition=SourceFilePosition+Len(CopyBuffer$)
       Open #1,"Disk:"\Syscall #1,Dismount$\Close #1\! Dismount Source disk
       If  EndOfFileHit
       Then Print "COPY COMPLETE: ";\Exit CopyLoop
   End
   Input "Insert System Disk, hit <RETURN> " Dummy$
   Exit

END
