         PAGE  *****  C O N T R O L  *****
;        "BASIC" SYSCALL SUBROUTINE INTERFACE
;
XOPSYSCALL1ARG EQU                     ; *
         TSX    
         BSR   SYSCALLCHOOSESCBLK
         CLR   SCBLK:WRLEN,X           ; ZERO THE WRITE BUFFER LENGTH
         CLR   SCBLK:WRLEN+1,X
SYSCALL1OR2ARG EQU                     ; *
         CLR   SCBLK:RDLEN,X           ; NO REPLY BUFFER, MAKE ITS LENGTH ZERO
         CLR   SCBLK:RDLEN+1,X
         lhld  #0
         shld  SYSCALLSTRHEADPTR
SYSCALLDOIT    EQU                     ; *
         lhld  TEMPX                   ; NOW CLEAN OFF THE STACK
         TXS    
         lhld  SYSCALLBLOCKPTR
         CLR   SCBLK:RPLEN,X           ; ZERO THE REPLY LENGTH IN CASE 
         CLR   SCBLK:RPLEN+1,X         ; SDOS DOESN'T SET IT
         LDA   SCBLK:PARAMS,X          ; SAVE CHANNEL # GIVEN IN OPCODE STRING
         STA   TBYTE
         LDA   CHANEL                  ; IS CHANNEL SELECTED <>0?
         jrz   SYSCALLDOIT0
         STA   SCBLK:PARAMS,X
SYSCALLDOIT0   call                    ; SYSCALL$
         jrc   SYSCALLDOIT1            ; B/ ERROR OCCURRED
         lhld  #0                      ; NO ERROR, PICK UP APPROPRIATE ERROR CODE
SYSCALLDOIT1   EQU                     ; *
         shld  TEMPX                   ; SAVE THE ERROR CODE TEMPORARILY
         lhld  SYSCALLBLOCKPTR         ; SET REPLY BUFFER LENGTH
         LDD   SCBLK:RPLEN,X
         lhld  SYSCALLSTRHEADPTR       ; WAS REPLY BUFFER A STRING OR SUBSTRING ?
         jrz   SYSCALLDOIT2            ; B/ WAS SUBSTRING, CAN'T SET "LEN"
         STD   CURLEN,X                ; SET LEN(READBUFFER$) TO REPLY LENGTH
SYSCALLDOIT2   EQU                     ; *
         lhld  SYSCALLBLOCKPTR         ; RESTORE CHANNEL # BYTE TO ORIGINAL VALUE
         LDA   TBYTE
         STA   SCBLK:PARAMS,X
         LDD   TEMPX                   ; ...
         BNED  SYSCALLDOIT4
         JMP   PL1PC1                  ; ALL IS OK!
SYSCALLDOIT4   EQU                     ; *
         JMP   IOERROR                 ; TO THE "BASIC" ERROR HANDLER ENTRY POINT
         PAGE    
SYSCALLCHOOSESCBLK                     ; EQU *
         call  SYSCALLGETSTRING        ; DETERMINE SIZE AND LOCATION OF SYSCALL OPCODE
         CMPD  #SCBLK:DATA             ; IS USER STRING LARGE ENOUGH ?
         BCC   SYSCALLCHOOSE1          ; B/ YEP, USE IT DIRECTLY
         LDD   ,X                      ; NO, GRAB CRITICAL 4 BYTES OF SYSCALL
         lhld  2,X
         STD   SYSCALLBLOCK            ; AND SAVE IN WORKING TEMP
         shld  SYSCALLBLOCK+2
         lhld  #SYSCALLBLOCK           ; REMEMBER WHERE WORKING STRING IS GOING TO BE
SYSCALLCHOOSE1 EQU                     ; * REMEMBER SYSCALL BLOCK ADDRESS
         shld  SYSCALLBLOCKPTR
         ret

SSB13J   JMP   SSB13

XOPSYSCALL4ARG EQU                     ; *
         call  RNDTOS                  ; B/ NOT AN INT --> SUBSCRIPT OUT OF RANGE!
         DW    SSB13                   ; GET READ-BACK BUFFER MAX LENGTH
         STD   TWORD
         TSX                           ; SET UP RDBUF POINTER
         BSR   SYSCALLGETRDBUF         ; GET READ BUFFER ADDRESS AND SIZE
         CMPD  TWORD                   ; CHECK GIVEN LENGTH AGAINST MAX
         jrc   SSB13J                  ; B/ GIVEN > STRLENGTH!
         LDD   TWORD                   ; OK, GIVEN VALUE IS LEGAL SO USE IT!
         jr    SYSCALL3ARGA            ; GO FINISH THE SYSCALL
         PAGE    
XOPSYSCALL3ARG EQU                     ; *
         TSX    
         BSR   SYSCALLGETRDBUF         ; GET READ BUFFER ADDRESS AND SIZE
SYSCALL3ARGA   EQU                     ; * (A,B) = READ BUFFER MAX LENGTH
         STD   SYSCALLRDLEN
         BSR   SYSCALLGETNEXTSTRING    ; = WRBUF DESCRIPTOR
         BSR   SYSCALLGETWRBUF1        ; AND SAVE THE PARAMETERS
         lhld  TEMPX
         LEAX  RSESIZ,X
         BSR   SYSCALLCHOOSESCBLK      ; DECIDE WHERE SCBLK IS GOING TO BE
         BSR   SYSCALLSETUPRDBUF       ; STUFF IN RDBUF PARAMS
         BSR   SYSCALLSETUPWRBUF       ; STUFF IN WRBUF PARAMS
         JMP   SYSCALLDOIT             ; YOU GUESS!!
         PAGE    
SYSCALLGETRDBUF                        ; EQU *
         shld  TEMPX                   ; DETERMINE SIZE AND LOCATION OF RDBUF
         LDD   4,X                     ; GET SIZE OF RDBUF STRING
         lhld  2,X                     ; AND ITS LOCATION
         CLR   SYSCALLSTRHEADPTR       ; ASSUME REFERENCE TO SUBSTRING
         CLR   SYSCALLSTRHEADPTR+1
         CMPD  #$FFFF                  ; REFERENCE TO "WHOLE STRING" ?
         jrnz  SYSCALLGETRDBUF1        ; B/ NO
         shld  SYSCALLSTRHEADPTR       ; YES, SAVE POINTER TO HEAD OF STRING
         LDD   MAXLEN,X                ; USE STRING DIMENSION AS MAX READ SIZE
SYSCALLGETRDBUF1                       ; EQU *
         LEAX  STRING,X
         shld  SYSCALLRDBUF            ; SAVPOINTER TO REPLY BUFFER AREA
         ret

SYSCALLSETUPRDBUF                      ; EQU * (X)=SYSCALLBLKPTR
         LDD   SYSCALLRDBUF
         STD   SCBLK:RDBUF,X
         LDD   SYSCALLRDLEN
         STD   SCBLK:RDLEN,X
         ret
         PAGE    
SYSCALLGETNEXTSTRING                   ; EQU *
         lhld  TEMPX
         LEAX  RSESIZ,X
SYSCALLGETSTRING                       ; EQU * (X) POINTS TO STRING DESCRIPTOR
         shld  TEMPX                   ; SO WE CAN FIND NEXT ARG IN LIST LATER
         LDD   R1SDC1,X                ; GET STRING SIZE
         lhld  R1SDA,X                 ; GET STRING ADDRESS
         CMPD  #$FFFF                  ; THE "WHOLE STRING" ?
         jrnz  SYSCALLGETSTRING1       ; B/ NO
         LDD   CURLEN,X                ; YES, USE CURRENT LENGTH OF STRING
SYSCALLGETSTRING1                      ; EQU *
         LEAX  STRING,X                ; COMPUTE POINTER TO 1ST DATA BYTE OF STRING
         ret

SYSCALLGETWRBUF                        ; EQU *
         BSR   SYSCALLGETSTRING
SYSCALLGETWRBUF1                       ; EQU *
         STD   SYSCALLWRLEN
         shld  SYSCALLWRBUF
         ret
         PAGE    
XOPSYSCALL2ARG EQU                     ; *
         TSX    
         BSR   SYSCALLGETWRBUF
         lhld  TEMPX
         LEAX  RSESIZ,X
         call  SYSCALLCHOOSESCBLK
         BSR   SYSCALLSETUPWRBUF
         JMP   SYSCALL1OR2ARG

SYSCALLSETUPWRBUF                      ; EQU *
         LDD   SYSCALLWRBUF            ; (X) CONTAINS SYSCALLBLKPTR
         STD   SCBLK:WRBUF,X           ; STUFF WRBUF PARAMS INTO CHOSEN SCBLK
         LDD   SYSCALLWRLEN
         STD   SCBLK:WRLEN,X
         ret
         PAGE    
SYSCALLONUSERCHAN                     ; PERFORM SYSCALL USING USER CHANNEL
         LDA   CHANEL
SYSCALLONCHANNELA                      ; STA SCBLK+SCBLK:PARAMS
;        JMP   ISYSCALL
;        I(NTERNAL) SYSCALL
;
;        SUPRESS EOF ERRORS ON CHANNELS 0-31
;        ONLY RETURNS ON ERROR IF CALLING ROUTINE HAS BCS OR BCC
;        AFTER THE JSR (OR BSR).  OTHERWISE TRAPS ERROR TO IOERROR
;
;
ISYSCALL EQU   *
;
;        FIRST, CLEAR EOF FLAG
;
         CLRA    
         CLR   EOFHITFLAG              ; ASSUME 'NO EOF HIT'
         LDB   SCBLK+SCBLK:PARAMS      ; CHANNEL #=>0
         BITB  #$E0                    ; B<32?
         jrnz  EXECISYSCALL            ; B/ NO, SO CAN'T DO A THING
         BSR   EOFBGEN                 ; MAKE ME AN EOF BIT AND X-REG
         COMA                          ; MAKE A MASK
         ANDA  ,X                      ; RESET 'EOF HIT' BIT
         STA   ,X

EXECISYSCALL   lhld                    ; #SCBLK NOW DO SYSCALL
         call  SYSCALL$
         jrc   RATS                    ; B/ GOT AN ERROR
         ret                           ; ALL DONE!

         PAGE    
RATS     CPX   #ERR:EOFHIT             ; GET AN EOF ERROR?
         jrz   TRAPEOF                 ; B/ YES, TRAP IT

;        CHECK FOR BCS OR BCC AFTER JSR

CHECKBCS shld  TEMPX
         LDA   [0,S]
         ANDA  #$FE
         CMPA  #$24                    ; IS IT?
         jrz   PASSBACKERROR
SYSCALLERRORED LDD                     ; TEMPX NO, SO GIVE ERROR TO BASIC PROGRAM
         JMP   IOERROR

PASSBACKERROR  lhld                    ; TEMPX
         SEC    
         ret

         PAGE    
TRAPEOF  LDA   SCBLK+SCBLK:PARAMS      ; IS IT WITHIN THE PROPER RANGE?
         BITA  #$E0                    ; 0..31
         jrnz  CHECKBCS
         INC   EOFHITFLAG
         BSR   EOFBGEN
         ORAB  ,X
         STB   ,X
         CLC                           ; WHAT ERROR?  DID YOU SEE AN ERROR?  I DIDN'T!
         ret

;        GENERATE X-REG AND MASK FOR CHANNEL IN EOF-TABLE
EOFBGEN  LDB   SCBLK+SCBLK:PARAMS
         ANDB  #7
         CLRA    
         SEC    

EOFBGEN2 ROLA                          ; GENERATE MASK FOR BIT NUMBER (B)
         DECB    
         BPL   EOFBGEN2

         LDB   SCBLK+SCBLK:PARAMS
         LSRB    
         LSRB    
         LSRB    
         IF    M6800!M6801
         ADDB  #EOFTABLE&$FF
         STB   TEMPX+1
         CLR   TEMPX                   ; ASSERT: EOFTABLE+7<=$FF
         lhld  TEMPX
         ELSE  (M6809)
         lhld  #EOFTABLE
         LEAX  B,X
         FIN    
         TFR   A,B
         ret
         PAGE    
;
;        BRANCH IF FLAG FALSE
;
XOPBF    LDA   FLAG
         jrnz  BT1
XOPJMP   EQU   *
BF0      ; UNCONDITIONALLY DO THE BRANC; H
         IF    M6800!M6801
         lhld  [BPC]                   ; GET TARGET ADDRESS
         ELSE  (M6809)
         lhld  ILADD,X                 ; A SMIDGEN FASTER THAN THE '00 COULD DO IT
         FIN    
         JMP   NTRPTX
;
;        BRANCH IF FLAG TRUE
;
XOPBT    LDA   FLAG
         jrnz  BF0
BT1      ; UNCONDITIONALLY **DON'T** DO;  THE BRANCH
         IF    M6800!M6801
         JMP   NTRPT3
         ELSE  (M6809)
         JMP   NTRPT3X
         FIN    
;
;        INVERT THE FLAG
;
XOPINV   COM   FLAG                    ; MAPS 0 TO $FF, $FF TO 0
         IF    M6800!M6801
         JMP   NTRPT1
         ELSE  (M6809)
         JMP   NTRPTX
         FIN    
         PAGE    
;        ON TOS GOTO
;        OPCODE, POINTER TO NEXT INSTRUCTION, ADDR1, ADDR2, ...
;
XOPON    call  RNDTOS
         DW    ONGOTO1                 ; B/ FAILED TO ROUND
         BSR   GOTOS
         jr    ONGOTO3                 ; ALL IS OK
ONGOTO1  lhld  [BPC]                   ; FALL THRU "ON" STMT
         jr    ONGOTO4
ONGOTO3  lhld  [TWORD]
ONGOTO4  JMP   NTRPTX
;
;        ON GOSUB
;
XOPONG   call  RNDTOS
         DW    ONGOTO1                 ; B/ FAILED TO ROUND!
         BSR   GOTOS
         jr    OPONG3
         jr    ONGOTO1
OPONG3   LDD   [BPC]                   ; GET RETURN ADDRESS
         lhld  [TWORD]                 ; GET WHERE TO GO
         jr    GOSUB1
         PAGE    
;        ON GOTO/GOSUB SUBROUTINE TO DETERMINE TARGET LINE NUMBER (ADDRESS)
;        (D) = ROUNDED VALUE OF "ON" EXPRESSION
;        NON-SKIP EXIT IF OK
;        SKIP EXIT IF INDEX OUT OF RANGE
;
GOTOS    SUBD  #1                      ; CONVERT TO ZERO ORIGIN
         ASLD    
         jrc   GOTOS2                  ; B/ # WAS TOO BIG OR WAS ZERO!
         ADDD  BPC
         jrc   GOTOS2
         ADDD  #ILADD+2                ; DISPLACEMENT TO 1ST TARGET ADDRESS
         jrc   GOTOS2
         CMPD  [BPC]                   ; POINTER TO TARGET BEYOND END OF TARGET ADDRESS LIST ?
         BCC   GOTOS2                  ; B/ YES, FALL THROUGH
GOTOS1   STD   TWORD
         ret

GOTOS2   PULX                          ; INDEX OUT OF RANGE, TAKE SKIP EXIT
         JMP   2,X
         PAGE    
;        GOSUB
;        OPGSB,ADDRESSOFSUBROUTINE
;
XOPGSB   ; "GOSUB" OPCODE
         IF    M6800!M6801
         lhld  BPC                     ; ASSERT: (S) = ERRORRECOVERYSTACK at this point
         FIN    
         LDD   BPC                     ; COMPUTE RETURN ADDRESS
         ADDD  #ILADD+2
         lhld  ILADD,X
;
;        GOSUB1                        -- DO THE GOSUB COMMON WORK
;              (X) = GOSUB TARGET PC
;              (D) = RETURN TARGET PC
;
GOSUB1   ; PUSH BPC, LINEADDR ONTO GOSU; B STACK
         PSHD                          ; SAVE "BASIC" RETURN ADDRESS
         LDD   LINEADDR                ; LINE # DERIVABLE FROM STACKED LINE ADDRESS!
         PSHD                          ; SAVE LAST ENCOUNTERED OPLINE ADDRESS
         sspd  ERRORRECOVERYSTACK      ; NEW STACK VALUE FOR ERROR TRAP RECOVERY
         JMP   NTRPTX
         PAGE    
;        GOSUB POP
;        TOS HAS # TO POP
;        IF POP TOO MANY, CROAK
;        IF TOS IS ZERO, EMPTY THE ENTIRE STACK
;
XOPGPOP  call  RNDTOS
         DW    RTRN1                   ; CAN'T FIX, YOU DIE!
         STD   LOOPX
         BEQD  OPGPOP0                 ; REAM THE STACK
OPGPOP2
         IF    M6800!M6801
         TSX                           ; POP A GOSUB STACK ENTRY
         DEX                           ; IS STACK FRAME EMPTY ?
         CPX   STACKFRAMEBASE          ; ...?
         ELSE  (M6809)
         CMPS  STACKFRAMEBASE          ; IS STACK FRAME EMPTY?
         FIN    
         jrz   RTRN1                   ; B/ YES, ERROR THE USER
         LEAS  4,S                     ; NO, GET RID OF A GOSUB STACK ENTRY NOTE: GOSUB POP DOES NOT WORK FOR SUB/FUN RETURN ADDRESSES!
         sspd  ERRORRECOVERYSTACK      ; UPDATE THE STACK ERROR RECOVERY POINT
         lhld  LOOPX
         DEX    
         shld  LOOPX
         jrnz  OPGPOP2                 ; B/ NEED TO POP ANOTHER....
         jr    OPGPOP3                 ; ALL DONE

OPGPOP0  lspd  STACKFRAMEBASE          ; "GOSUB POP 0"
         sspd  ERRORRECOVERYSTACK      ; UPDATE STACK ERROR RECOVERY PART
OPGPOP3  JMP   NTRPT2
         PAGE    
;        RETURN
;        POP BPC FROM GOSUB STACK & JUMP
;
XOPRET
         IF    M6800!M6801
         TSX                           ; ANY RETURN ADDRESSES STILL IN THIS STACK FRAME ?
         DEX    
         CPX   STACKFRAMEBASE          ; ...?
         ELSE  (M6809)
         CMPS  STACKFRAMEBASE          ; ANY RETURN ADDRESSES LEFT IN THIS STACK FRAME?
         FIN    
         jrz   RTRN1                   ; B/ NO, CAN'T DO A RETURN HERE!
         PULD                          ; RESTORE LAST LINE OPCODE ENCOUNTERED ADDRESS
         STD   LINEADDR                ; RESTORE LINE ADDRESS AT TIME OF GOSUB
         PULX                          ; RESTORE BPC AT TIME OF GOSUB
         sspd  ERRORRECOVERYSTACK      ; AND UPDATE RECOVERY TIME STACK VALUE
         JMP   NTRPTX

RTRN1    call  RTPERR
         db    :GSBUND
*       CALL USER SUBROUTINE
;        (OPCALL)(SUBROUTINE ADDR)(ARG COUNT)
;              NOTE: # ARGS LIMITED TO 255/6 = 42!
;
XOPCALL  BSR   CALLIT
;        CAME BACK! (SUB/FUNS COMPILED BY BASIC DON'T COME BACK HERE)
         jrc   XOPCALLERRED            ; B/ ERROR IN SUBROUTINE
         lspd  ERRORRECOVERYSTACK      ; MUST HAVE BEEN USER SUBROUTINE CALL
XOPCALL1 LDB   #3                      ; = DISTANCE TO BUMP BPC
         JMP   NTRADB                  ; GO DO NEXT INSTRUCTION
;
;        OPFNCALL -- CALL USER FUNCTION
;        (OPFNCALL) (FUNCTION ADDR) (ARGUMENT COUNT)
;
XOPFNCALL      BSR                     ; CALLIT GET THE FUNCTION ADDRESS, DUMMY!
         jrc   XOPCALLERRED            ; B/ ERROR IN FUNCTION
         lhld  #OPPOLYARG              ; CALL THE FUNCTION
         call  FSTORE                  ; SAVE THE RETURNED VALUE
         lhld  BPC                     ; NOW POP ARG LIST FROM STACK
         LDB   2,X
         ASLB                          ; ARG COUNT * 2
         IF    M6800!M6801             ; ADD #ARGS*6 TO STACK
         TBA    
         ASLA                          ; ... * 4
         ABA                           ; ... * 6
         sspd  TEMPX
         ADDA  TEMPX+1
         BCC   XOPFNCALL1
         INC   TEMPX
XOPFNCALL1     EQU                     ; *
         STA   TEMPX+1
         lspd  TEMPX
         ELSE  (M6809)
         ADDB  2,X                     ; ARG COUNT * 3
         ASLB                          ; * 6
         LEAS  B,S                     ; ASSERT: ARG COUNT < 128/3
         FIN    
         lhld  #OPPOLYARG              ; GET THE RETURNED VALUE BACK
         call  FLOAD
         jr    XOPCALL1
         PAGE    
CALLIT   ; SUBROUTINE FOR XOPCALL, XOPF; NCALL
         IF    M6800!M6801
         lhld  BPC
         FIN    
         LDD   ILADD,X                 ; GET SUBROUTINE ADDRESS
         PSHD                          ; PUSH ONTO STACK
         LDA   ILADD+2,X               ; GRAB ARGUMENT COUNT
         IF    M6800!M6801
         TSX                           ; GET POINTER TO PARAMETER LIST
         LEAX  4,X
         ELSE  (M6809)
         LEAX  4,S
         FIN    
         ret                           ; GO TO SUBROUTINE

XOPCALLERRED   ; USER FUNCTION/SUBROUTI; NE ERRORED!
         lspd  ERRORRECOVERYSTACK      ; SWITCH TO SAFE STACK POINTER
         shld  ERCODE                  ; SAVE THE ERROR CODE
         JMP   ERROR                   ; AND GO PROCESS THE ERROR!
         PAGE    
;        PARAMETERIZED SUBROUTINE/FUNCTION ENTRY POINT
;
;        CALL  $106                    WITH (A) = # ARGUMENTS PASSED BY CALLER
;        DB    version
;        DW    forwardreflabelchain
;        DW    pointer to first byte of last parameter variable storage
;                                      Argument variables are allocated contiguously
;        DW    baseofscalarvariables
;        DW    address of 1st byte above the data space
;        DB    #arguments given by SUBROUTINE/FUNCTION definition
;              ...basic opcodes...
;
;
;        1) CHECK ARG COUNT AND COMPLAIN IF INCORRECT
;        2) COPY ARGS OFF STACK INTO PARAMETER VARIABLES
;        3) PUSH RETURN ADDRESS (BPC) ONTO STACK ALONG WITH:
;              SCALAR VARIABLE TABLE BASE
;              LAST ENCOUNTERED LINE NUMBER/LABEL OPCODE ADDRESS
;              CURRENT VALUE OF ERROR TRAP ADDRESS
;              OLD STACKFRAMEBASE, ERRORRECOVERYSTACK
;        4) GO DO AN XOPSETLABEL
;
;        NOTE: ON A RETURN STATEMENT, CONTROL IS NOT PASSED BACK TO XOPCALL!
;        THIS IS BECAUSE XOPCALL WILL ATTEMPT TO CLEAN OFF THE STACK,
;        AND THIS WILL HAVE ALREADY BEEN DONE.
;
??       IF    OPLINE=$BD
         ?can't tell JSR from OPLINE?
         ENDIF

ARGCOUNTERROR ; report (fatal) Argument Count error
         LXI   H,0                     ; KILL OFF THE ERROR TRAP ADDRESS
         SHLD  ERTRAP                  ; SO THE ERROR IS FATAL
         CALL  RTPERR
         DB    ERR@ARGCNTERR

???VERSIONERRJ JMP VERSIONERROR        ; report "Wrong Version RTP" error
         PAGE    
SUBFUNENTRY ; enter Compiled BASIC Subroutine/Function
         pop   h                       ; = RETURN ADDRESS FROM CALL
         mov   c,a                     ; save argument count
         mov   a,m                     ; fetch RTP@VERSIONNUMBER
         cpi   #version                ; CHECK VERSION NUMBER
         jnz   VERSIONERRJ             ; B/ WRONG VERSION NUMBER
         SHLD  BPCSAV                  ; REMEMBER ROUGHLY WHERE BPC IS (CALL SITE)
         lxi   d,RTP@ARGCOUNT          ; find argument count
         dad   h
         mov   a,m                     ; and fetch it
         CMP   C                       ; IS ARG COUNT CORRECT ?
         jnz   ARGCOUNTERROR           ; B/ NO, GO YELL AND SCREAM AND DIE...
         inx   h                       ; now points to popcode start
         shld  BPC                     ; save location of 1st byte of popcode
         lxi   d,RTP@LASTPARAMADDR-RTP@FUNSUBOPCODE ; fetch pointer to params
         dad   d
         mov   b,m                     ; make HL point to last parameter variable
         inx   h
         mov   h,m
         mov   l,b
         pop   d                       ; POP $106 ENTRY POINT JSR RETURN ADDRESS OFF POP RETURN ADDRESS PUSHED BY OPCALL
         ana   a                       ; ANY ARGS LEFT TO COPY FROM STACK ?
         jz    SUBFUN2                 ; B/ NOPE
SUBFUNL ; PARAMETER FILL LOOP
         pop   d                       ; COPY ARGUMENT VALUE INTO A PARAMETER VARIABLE
         mov   m,e
         inx   h
         mov   m,d
         inx   h
         pop   d
         mov   m,e
         inx   h
         mov   m,d
         inx   h
         pop   d
         mov   m,e
         inx   h
         mov   m,d
;        inx   h
         lxi   d,-RSESIZ*2-1           ; find next parameter variable
         dad   d
         dcr   a
         jnz   SUBFUNL                 ; B/ MORE TO FILL!
         PAGE    
;
SUBFUN2 ; NOW PUSH OLD CONTEXT
         mvi   c,(ContextEnd-ContextStart)/2 ; how many bytes to save
         lxi   h,ContextEnd            ; do it the compact way...
SUBFUN2L ; SINCE WE DON'T DO IT OFTEN
         DCX   H
         mov   e,m
         dcx   h
         mov   d,m
         push  d                       ; push pair of context bytes
         dcr   c                       ; ??z80 improvement ??
         jnz   subfun2l
         lxi   h,SUBROUTINENESTING     ; ANOTHER CONTEXT BLOCK HAS BEEN PUSHED!
         inr   m
         lxi   h,0                     ; ANOTHER CONTEXT BLOCK PUSHED
         shld  ERTRAP                  ; NEW ENVIRONMENT:
                                       ; --> NEW ERROR TRAP MUST BE SET!
         dad   sp                      ; get base of stack frame
         shld  STACKFRAMEBASE          ; MARK BASE OF STACK FRAME
         shld  ERRORRECOVERYSTACK      ; MARK GOSUB LIST AS EMPTY
         lhld  BPCSAV                  ; ROUGHLY WHERE SUBROUTINE ENTRY IS
         call  INITCOMMON              ; GO DO COMMON INIT STUFF
         lhld  BPCSAV
         dcx   h
         dcx   h
         dcx   h                       ; = EXACTLY WHERE SUBROUTINE ENTRY IS
         shld  LINEADDR
         lhld  BPC                     ; ***PREVENT <ESC> ON FUNCTION ENTRY***
         lda   BreakLine+VINT1
         xra   h
         jnz   subfun3                 ; b/ breakpoint not required
         lda   BreakLine+VINT2
         xra   l
         jz    XOPLINE6J               ; B/ BREAKPOINT REQUIRED (ALLOW ESCAPE)
         LDA   LINEFLAGS               ; BREAKPOINT NOT DESIRED, TRACE OR SINGLE STEP!
         ana   a                       ; Trace or Single Step enabled ?
         jz    NTRPT1                  ; NORMAL CASE, GO DO NEXT OPCODE
;        jnz   XOPLINE6J               ; B/ TRACE OR SINGLE STEP DESIRED
XOPLINE6J JMP  XOPLINE6                ; GO PROCESS CURRENT LINEFLAGS
         PAGE    
;        FUNRETURN -- RETURN FROM A FUNCTION
;
XOPFUNRET ; Return from a Compile BASIC function (DEF)
         lxi   h,OPPOLYARG
         call  FSTORE
;
;        SUBRETURN -- RETURN FROM A SUBROUTINE
;
XOPSUBRET ; return from a Compiled BASIC SUBROUTINE
         lhld  BPC                     ; GRAB OPCODE BYTE, SAVE IN (B)
         dcx   h
         mov   b,m
         lspd  STACKFRAMEBASE          ; BYE BYE GOSUBS FOR THIS INCARNATION
         mvi   c,(ContextEnd-ContextStart)/2 ; how many bytes to save
         lxi   h,CONTEXTSTART          ; RESTORE CONTEXT FROM STACK
OPSUBRETL ; pop context byte pair
         pop   d                       ; see SUBFUN2L loop
         mov   m,d                     ; this does the opposite
         inx   h
         mov   m,e
         inx   h
         dcr   c                       ; ??Z80 improvement ??
         jnz   opsubretl
         lxi   h,SUBROUTINENESTING     ; ANOTHER CONTEXT BLOCK HAS BEEN POPPED
         dcr   m
         mov   a,b                     ; returning from a parameterized subroutine ?
         cpi   OPSUBRET
         jz    OPSUBRET1               ; B/ YES, GO CLEAN UP
         lxi   h,OPPOLYARG             ; NO, MUST BE RETURNING FROM PARAMETERIZED FUNCTION
         call  FLOAD                   ; MOVE RESULT VALUE BACK ONTO VALUE STACK
OPSUBRET1 JMP  XOPCALL1                ; ALL DONE, CONTINUE EXECUTION IN CALLING ENVIRONMENT
         PAGE    
;
;        ENTER ASSEMBLY LANGUAGE
;        JUMPS TO ADDRESS OF OPCODE + 1
;        OPASM
;
XOPASM   ; ENTER ASSEMBLY LANGUAGE OPCO; DE
         lhld  BPC
         pchl    
;
;        FORWARD REFERENCE LABEL
;        THE VALUE OF THE LABEL IS IN A VARIABLE
;        SO THAT IT CAN BE TREATED THE SAME AS A SCALAR
;
;        OPLFREFL
;        DW    SCALAR ADDRESS
;        DW    POINTER TO NEXT OPLFREL OPCODE
;
XOPLFREFL ; FORWARD REFERENCE LABEL OPCODE
;        Since RESOLVEFREF has already resolved Forward References,
;        we need do nothing but advance BPC past this opcode.
         lhld  BPC
         dcx   h                       ; MAKE POINTER TO OPCODE BYTE
         shld  LINEADDR                ; GOTO ELN NEEDS THIS
         lxi   d,5                     ; BUMP BPC SO NTRPT1 IS CORRECT EXIT
         dad   d
         shld  BPC
         jmp   XOPLFREFL1
;
;        SINGLE BYTE SET LABEL OPCODE
;
;        OPSETLABEL
;
XOPSETLABEL ; SET LABEL POINT
         lhld  BPC
         dcx   h                       ; MAKE IT POINT TO LABEL OPCODE
         shld  LINEADDR                ; GOTO ELN NEEDS THIS
         jr    XOPLFREFL1
         PAGE    
;
;        PRLINEADDR -- PRINT LINE NUMBER/ADDRESS OF OPCODE @HL
;              STORES LINE NUMBER/ADDRESS IN OPPOLYARG
;
PRLINEADDR ; Print Line Number/Address of Opcode at HL
         xra   a
         sta   OPPOLYARG               ; MAKE "OPPOLYARG" INTO AN INTEGER
         mov   a,m                     ; GET OPCODE SELECTED
         cpi   OPLINE                  ; A LINE NUMBER OPCODE ?
         jnz   PRLINEADDR1             ; B/ NO
         inx   h                       ; yes, grab the line number
         mov   a,m
         inx   h
         mov   h,m
         mov   l,a
         shld  OPPOLYARG+VINT1
         call  XBCODE                  ; NOW DISPLAY THE NUMBER
         DB    OPLOAD
         DW    OPPOLYARG
         DB    OPPV
         DB    OPPCR
         DB    OPASM
         ret    

PRLINEADDR1 ; Print Line Address in HL
         shld   OPPOLYARG+VINT1         ; NOT A LINE NUMBER OPCODE, PRINT THE ADDRESS
         call   XBCODE
         DB    OPLOAD
         DW    OPPOLYARG
         DB    HIGH OPHEX,LOW OPHEX
         DB    OPPS
         DB    OPPCR
         DB    OPASM
         ret    
         PAGE    
;        SET LINE NUMBER
;        PICK UP 2 BYTES & PUT IN THE LINE # REG
;        CHECK LINE FLAG
;        OPLINE,16BITLINENUMBER
;
XOPLINE  ; SET LINE NUMBER OPCODE
         lhld  BPC
         dcx   h                       ; SET LINEADDR = ADDRESS OF LINE # OPCODE
         shld  LINEADDR
         inx   h                       ; BUMP BPC SO NTRPT1 IS CORRECT EXIT
         inx   h
         inx   h
         shld  BPC
         dcx   h                       ; fetch line number to HL
         mov   a,m
         dcx   h
         mov   h,m
         mov   l,a
XOPLFREFL1 ; HL contains Line Number/Line address
;        **** HELP HELP! WHAT IF LINE # = LINE ADDRESS OF DIFFERENT LINE? ****
         lda   BreakLine+VINT1         ; hit line number breakpoint ?
         cmp   l
         jnz   xopline9                ; b/ no
         lda   BreakLine+VINT2
         cmp   h
         jz    XOPLINE6                ; b/ yes
         LDA   LINEFLAGS               ; REQUEST FOR TRACE/SINGLE STEP ?
         ana   a
         jz    XOPLINE0                ; B/ NO, SEE IF NEW REQUEST ARRIVED
XOPLINE6 ; MUST BE TRACE OR SINGLE STEP --> PRINT LINE NUMBER
         call  XBSUBR
         DB    OPZCHN                  ;  TO PRINT ON CHANNEL 0
         DB    OPLSC
         DB    5,'Line '
         DB    OPPS
         DB    OPASM
         lhld  LINEADDR
         call  PRLINEADDR
         lhld  BPCSAV                  ; RESTORE USER'S BASIC PC
         shld  BPC
         lhld  OPPOLYARG+VINT1
         lda   BreakLine+VINT1
         cmp   l
         jnz   xopline6a
         lda   BreakLine+VINT2
         cmp   h
         jz    XOPLINE7
xopline6a ; not at breakpoint
         LDA   LINEFLAGS               ; BREAKPOINT OR SINGLE STEP ?
         ana   SSTEPBIT                ; ...?
         jz    XOPLINE0                ; B/ NEITHER, CONTINUE EXECUTION
XOPLINE7 call  GETLINEFLAGS            ; WAIT FOR RESPONSE TO BREAK/SS
         ana   a
         jz    XOPLINE7                ; No response yet, wait some more
         call  PROCESSLINEFLAGS1       ; GO PROCESS LINE FLAGS JUST COLLECTED
         JMP   NTRPT1
         PAGE    
GETLINEFLAGS   ; SUBROUTINE TO GET LINE FLAGS
         call  SETSCOP                 ; SETUP TO DO A GETLINEFLAGS CALL
         db    SYSCALL:STATUS,14
         db    0,SC:GETLINEFLAGS
         call  SETSCRDBUF
         DW    TBYTE,1
         call  EXECISYSCALL            ; DO THE CALL
         jc    GETLINEFLAGS1           ; B/ CALL ERRORED, USE HINT AS RESULT
         LDA   TBYTE                   ; GET LINE FLAGS...
         mov   c,a
GETLINEFLAGS2 ; zap the hint and exit with line flags in (A)
         xra   a                       ; AND ZAP THE HINT
         sta   $F0
         mov   a,c
         RET    

GETLINEFLAGS1 ; SC:GETLINEFLAGS failed
         LDA   $F0                     ; USE HINT AS LINEFLAGS
         mov   c,a
         lxi   d,ERR:ILLDEVICEOP       ; INVALID CALL (NOT VT DRIVER?)
         dad   d                       ; Simply not implemented ?
         mov   a,h
         ora   l
         jz    GETLINEFLAGS2           ; B/ yes, we don't have VT DRIVER
         shld  ERCODE                  ; OOOH...SOMETHING IS VERY WRONG!
         JMP   ERRORLDS
         PAGE    
XOPLINE0 LDA   $F0                     ; DON'T HAVE TO DISPLAY LINE NUMBER, QUICKLY GET LINE FLAGS
         ana   a                       ; any hint about line flags present ?
         jz    XOPLINE4                ; B/ NOTHING TO DO, TAKE FAST EXIT
         lhld  LINEADDR                ; DID WE GET CAUGHT AT THE ERROR TRAP POINT?
         lda   ERTRAP
         cmp   l
         jnz   xopline0a
         lda   ERTRAP+1
         cmp   h
         jz    XOPLINE4                ; B/ YES, IGNORE
xopline0a ; not at error trap point, process the line flags
         CALL  PROCESSLINEFLAGS
XOPLINE4 JMP   NTRPT1                  ; ASSERT: BPC POINTS TO NEXT OP TO EXECUTE
;
;        PROCESSLINEFLAGS -- PROCESS LINE FLAGS
;        MUST NOT BE CALLED IN MIDDLE OF I/O STATEMENT TO NON-ZERO CHANNEL #
;
PROCESSLINEFLAGS                       ; EQU *
         BSR   GETLINEFLAGS            ; GET FLAGS TO PROCESS
PROCESSLINEFLAGS1 ; COME HERE WITH (A) ; = LINE FLAGS TO PROCESS
         LDB   LINEFLAGS               ; GET CURRENT STATE OF DEBUG INFO
         BITA  #GOBIT                  ; DID HE SAY "GO" ?
         jrz   XOPLINE8                ; B/ NO
         ANDB  #\SSTEPBIT              ; YES, DUMP THE SINGLE STEP BIT
XOPLINE8 BITA  #TRACEBIT
         jrz   XOPLINE1
         EORB  #TRACEBIT               ; LOOK! THERE'S SOMETHING TO DO!
XOPLINE1 BITA  #SSTEPBIT
         jrz   XOPLINE2
         ORAB  #SSTEPBIT
XOPLINE2 STB   LINEFLAGS
         BITA  #ABORTBIT
         jrnz  XOPABORT
         BITA  #BREAKBIT
         jrz   PROCESSLINEFLAGSRTS
         PAGE    
GETBREAKPOINT  call                    ; XBSUBR
         OPZCHN
         OPLSC
         db    17,ASCII:CR,ASCII:BEL
         db    'Break on Line? '
         OPPS    
         OPASM
         lhld  BPCSAV                  ; RESTORE BPC IN CASE OF CONVERSION ERROR, BELOW
         shld  BPC
         call  SETSCOP                 ; ISSUE SYSCALL:READA TO GET BREAKPOINT LINE NUMBER
         db    SYSCALL:READA,READA:SCLE; N
         db    0,1                     ; DO READ FROM CONSOLE IN LINE MODE
         call  SETSCRDBUF              ; PUT REPLY IN "OUTBUF" (A NICE TEMP)
         DW    OUTBUF,OUTBUFSIZE
         call  ISYSCALL                ; ISSUE THE READ
;** WHAT HAPPENS HERE IF AN I/O ERROR OCCURS ???
         lhld  #OUTBUF                 ; CONVERT THE INPUT TO A LINE NUMBER
         LDD   #OUTBUFSIZE
         call  CONVERT
         jr    GETBREAKPOINT1          ; B/ CONVERTED OK
         jr    GETBREAKPOINT           ; B/ FAILED TO CONVERT PROPERLY

GETBREAKPOINT1 call                    ; XBSUBR STORE THE CONVERTED VALUE
         OPSTORE,#BREAKLINE
         OPASM
         IF    0
;        THIS LITTLE STUNT ALLOWS OVERLAYED BASIC DEBUGGER TO GET CONTROL ON BKPT
         LDA   BREAKLINE
         BPL   --                      ; ONE OF IRA'S UNFINISHED SYMPHONIES ???
         --- CHAIN TO BASIC DEBUGGER --; -
         FIN   0
         lhld  BPCSAV
         shld  BPC
         LDA   BREAKLINE               ; IS BREAKPOINT AN INTEGER?
         jrnz  GETBREAKPOINT           ; B/ NO, ASK AGAIN!
PROCESSLINEFLAGSRTS                    ; RTS
         PAGE    
XOPABORT BSR   RTPERR
         db    :ABORT

XOPSTP   BSR   RTPERR
         db    :STOP

XOPERRCAUSE    ; CAUSE SPECIFIED ERROR ; CODE
         call  RNDTOS
         DW    FIXTOSERR
         jr    IOERROR

         PAGE  *****  E R R O R   S T U;  F F  *****
;        OPGOELN -- GOTO LINE NUMBER IN WHICH LAST ERROR OCCURRED
;
XOPGOELN EQU   *
         lhld  ERADDR                  ; IS ERROR ADDRESS SET ?
         CLR   ERADDR                  ; CLEAR "ERROR OCCURRED" FLAG
         CLR   ERADDR+1
         shld  TEMPX                   ; DID ERROR REALLY OCCUR ?
         jrnz  IOERRSTX                ; B/ ERROR DID OCCUR, CONTINUE EXECUTION
         BSR   RTPERR                  ; ELN WENT TO UNDEFINED LINE NUMBER!?
         db    :UDFLIN
;
;        ERROR STUFF
;
RTPERR   LDB   [,S]                    ; FETCH INLINE ERROR CODE
         CLRA    
IOERROR  STD   ERCODE                  ; SAVE ERROR CODE
ERRORLDS lspd  ERRORRECOVERYSTACK      ; GET US A CLEAN STACK TO WORK WITH...
         lhld  LINEADDR                ; SAVE POINTER TO LINE ORIGINATING THE ERROR
         shld  ORIGINALSINADDR
ERROR    lhld  USING                   ; WIPE OUT AN ACTIVE USING STRING
         shld  USINGMAX
         lhld  LINEADDR                ; SAVE ADDRESS OF LINE OPCODE IN WHICH ERROR OCCURRED
         shld  ERADDR                  ; FOR GOTOELN
         CPX   ERTRAP                  ; IS THE ERROR RECOVERY STUCK IN A LOOP?
         jrz   ERRPRINT                ; B/ YES, ABORT HIM
         lhld  ERCODE                  ; IS THIS A "STOP" STATEMENT ?
         jrz   ERRPRINT                ; B/ YES, NO ERROR RECOVERY POSSIBLE
         lhld  ERTRAP                  ; IS ERROR TRAPPING ENABLED?
         jrz   XOPERRST                ; B/ NO, ABORT HIM
IOERRSTX JMP   NTRPTX
;
;        OPTRP, STICK ADDRESS IN ERTRAP REG
;        OPTRP,POINTERTOERRORTRAPROUTINE
;
XOPTRP   ; SET ON ERROR TRAP TO INLINE ; ADDRESS
         IF    M6800!M6801
         lhld  BPC
         FIN    
         lhld  ILADD,X
         shld  ERTRAP
         JMP   NTRPT3
         PAGE    
;        OPERR, Prints Line number/address,
;        sets SDOS Error code, Prints it and exits
;        NOTE: COULD CHAIN TO SPECIAL PGM THAT CONVERTED HEX ADDRESS...
;        FOR LINE NUMBER BACK INTO ORIGINAL LABEL NAME BY LOOKING IT UP...
;        IN THE SYMBOL TABLE PRODUCED BY THE ASSEMBLER
;
;
XOPERRST TST   SUBROUTINENESTING       ; IN MAIN PROGRAM ?
         jrz   ERRPRINT                ; B/ YES, GO PRINT THE ERROR
         lspd  STACKFRAMEBASE          ; NO, POP A CONTEXT BLOCK
         lhld  #CONTEXTSTART+2         ; ( LEAVE ERCODE ALONE! )
         LEAS  2,S
XOPERRSTL      PULA    
         STA   ,X+
         CPX   #CONTEXTEND
         jrnz  XOPERRSTL
         DEC   SUBROUTINENESTING       ; = # PUSHED CONTEXT BLOCKS
         lspd  ERRORRECOVERYSTACK      ; POP CONTEXT TO GET TO CALLER'S CONTEXT
         jr    ERROR                   ; GO CHECK FOR ERROR RECOVERY

ERRPRINT call  XBSUBR
         OPZCHN                        ;  PRINT ON CONSOLE, PLEEZ...
         OPLSC                         ; LOAD CON STRING DES
         db    5
         db    'Line '
         OPPS                          ; PRINT THE STRING
         OPASM
         lhld  ORIGINALSINADDR         ; GET ADDRESS OF ORIGINAL SIN
         call  PRLINEADDR              ; PRINT THE LINE NUMBER/ADDRESS
         call  SETSCOP                 ; SET ERROR INTO SDOS SO DO FILES SEE THEM
         db    SYSCALL:ERROREXIT
         db    SETERROR:SCLEN
         DW    CHANGED

         lhld  ERCODE
         shld  SCBLK+SCBLK:PARAMS
         call  EXECISYSCALL            ; ASSERT: EOF CONDITION CANNOT OCCUR
         jrc   *                       ; GOOD GRIEF! SDOS DIDN'T KNOW WHAT TO DO!
         PAGE    
;
;        EXIT ROUTINE
;
XOPEXIT  call  SETSCOP
         db    SYSCALL:EXIT
         db    EXIT:SCLEN
         DW    IGNORED

         call  ISYSCALL
;        jr    *                       CAN'T GET HERE NORMALLY
        PAGE  *****  P E E K - P O K E;  *****
;        PEEK AT ADDRESS SPECIFIED BY TOS INTEGER
;
XOPEEK   LDA   R1TYPE,S
         jrnz  PEEK1
         IF    M6800!M6801
         lhld  R1ADD,X
         ELSE  (M6809)
         lhld  R1ADD,S
         FIN    
         LDB   BYTE,X
         JMP   LOADB1
;
;        POKE ADDRESS AT TOS-1, BYTE AT TOS
;        NO POKING AT THE INTERPRETER, PLEEZE
;
XOPOKE   call  MAKEBOTHLOGICAL         ; AFTER ALL, ISN'T THAT THE LOGICAL THING TO DO?
         LDD   #BASICRTPEND$
         SUBD  R2ADDH,S
         BCC   POKE4
         IF    M6800!M6801
         LDA   R1INT1,X
         jrnz  POKE5
         LDA   R1INT2,X
         lhld  R2ADD,X
         ELSE  (M6809)
         LDA   R1INT1,S
         jrnz  POKE5
         LDA   R1INT2,S
         lhld  R2ADD,S
         FIN    
         STA   BYTE,X
         JMP   PL2PC1

POKE4    call  RTPERR
         db    :POKRTP                 ; OUCH! THAT HURT!
POKE5    call  RTPERR
         db    :POKVAL
PEEK1    call  RTPERR
         db    :POKADD
         PAGE  *****  F O R - N E X T  ; *****
;        XOPFOR -- SETS UP A FOR/NEXT LOOP
;        ON THE VALUE STACK IS:
;        TOS   STEP
;        TOS-1 LIMIT
;        TOS-2 INITIAL VALUE FOR LOOP VARIABLE
;        (OPFOR)(OPNEXT ADDR+3)(INDEXVAR ADDR)(STEP/LIMIT VALUE ADDR)
;
XOPFOR
         IF    M6800!M6801
         lhld  BPC
         FIN    
         DEX                           ; MAKE BPC POINT TO FOR OPCODE
         shld  BPC
         ; ARE STEP, LIMIT, AND INITIAL;  VALUES ALL INTEGER ?
         LDA   R1TYPE,S                ; ...?
         IF    M6800!M6801
         ORAA  R2TYPE,X
         ORAA  R3TYPE,X
         ELSE  (M6809)
         ORAA  R2TYPE,S
         ORAA  R3TYPE,S
         FIN    
         jrz   FORINT                  ; B/ YES, THIS IS THE EASY CASE!
         call  MAKEBOTHFLOAT           ; NO, FORCE STEP AND LIMIT TO BE FLOATING
         BSR   STORESTEPANDLIMIT       ; AND SAVE THEM
         call  FORCEFLOAT              ; FORCE INITIAL VALUE TO BE FLOAT
         JMP   NEXTFS                  ; GO SAVE IT AND CHECK AGAINST LIMIT

FORINT   EQU   *                       ; STEP, LIMIT AND INITIAL VALUE ARE ALL INTEGER!
         BSR   STORESTEPANDLIMIT       ; SAVE STEP AND LIMIT VALUES
         lhld  BPC                     ; STORE INITIAL VALUE
         lhld  ILADD+3,X               ; GET LOOP INDEX ADDRESS
         call  FSTORE                  ; IT DOESN'T HURT TO BE A LITTLE SLOW HERE, WE ONLY DO THIS ONCE!
         lhld  BPC                     ; GET SET TO CHECK INITIAL VALUE AGAINST LOOP LIMIT
         lhld  ILADD+5,X
         LDD   #0                      ; CHEAT: FAKE STEP VALUE OF ZERO FOR BACK DOOR ENTRY
         jr    NEXTICHECK              ; GO CHECK LOOP LIMIT
         PAGE    
;        STORESTEPANDLIMIT -- COPIES TOS INTO STEP, TOS-1 INTO LIMIT
;
STORESTEPANDLIMIT                      ; EQU *
         IF    M6800!M6801
         PULD                          ; HIDE THE RETURN ADDRESS
         STD   RTPRET
         ELSE  (M6809)
         PULS  Y
         FIN    
         LDB   #RSESIZ*2               ; = # BYTES TO PULL OFF THE STACK
         lhld  BPC                     ; GET STEP/LIMIT STORAGE ADDRESS
         lhld  ILADD+5,X               ; POINTER TO PLACE FOR STEP
STORESTEPANDLIMITL                     ; EQU *
         PULA    
         STA   ,X+
         DECB    
         jrnz  STORESTEPANDLIMITL      ; YOU FIGURE IT OUT
         IF    M6800!M6801
         JMP   [RTPRET]
         ELSE  (M6809)
         JMP   ,Y
         FIN    
;
;        OPEXITLOOP -- PASS CONTROL TO STMT PAST "NEXT"
;        (OPEXITLOOP) (OPFORADDR )  [ I.E., POINTER TO "OPFOR" FOR MATCHING INDEX VAR)
;
XOPEXITLOOP    EQU                     ; *
         IF    M6800!M6801
         lhld  BPC                     ; FIND THE "FOR" OPCODE
         FIN    
         lhld  ILADD,X
         jr    NEXT1A                  ; THEN FIND THE "NEXT" THAT MATCHES AND EXIT THE LOOP
         PAGE    
;        OPNXT -- DO END OF LOOP PROCESSING FOR "FOR/NEXT" LOOP
;        (OPNXT)(OPFOR ADDR FOR MATCHING INDEX VAR)
;
;        NOTE: INTEGER PATH HAS BEEN OPTIMIZED TO DEATH!
;
XOPNEXT  EQU   *
         IF    M6800!M6801
         lhld  BPC                     ; FIND "OPFOR" OPCODE
         FIN    
         lhld  ILADD,X
         shld  BPC                     ; AND REMEMBER WHERE IT IS
         lhld  ILADD+5,X               ; GRAB POINTER TO STEP VALUE
         LDA   FSTYPE,X                ; IS STEP AN INTEGER ?
         ORAA  FLTYPE,X                ; (ARE BOTH STEP AND LIMIT INTEGERS ?)
         jrnz  NEXTF                   ; B/ NO, FLOATING OPERATIONS ARE REQUIRED
         LDD   FISTEP1,X               ; MOVE INTEGER STEP TO (A,B)
;        NOTE: IF USER FLOATED THE INDEX VAR, HE'LL BE SORRY!
NEXTICHECK     lhld                    ; FILIM1,X GRAB LOOP LIMIT
         shld  TEMPX                   ; SAVE IT A MOMENT
         lhld  BPC                     ; NOW ADD LOOP INDEX VALUE...
         lhld  ILADD+3,X               ; TO STEP VALUE
         TST   VTYPE,X                 ; CHECK FOR EXTREMELY UNUSUAL CASE
         jrnz  NEXTIF                  ; B/ USER FLOATED INDEX VARIABLE, SOMEHOW!
         ADDD  VINT1,X                 ; (A,B):= NEXT INDEX VARIABLE VALUE
         jrc   NEXTIOV                 ; B/ NEW INDEX VALUE > 65535, RATS!
         STD   VINT1,X                 ; SAVE UPDATED LOOP INDEX VALUE
         SEC                           ; CHECK: LOOP INDEX VALUE <= LIMIT ?
         SBCB  TEMPX+1                 ; ...?
         SBCA  TEMPX                   ; ...?
         BCC   NEXTEXIT                ; B/ NOPE, TIME TO LEAVE THE LOOP!
NEXTITERATION  EQU                     ; *
         LDB   #7                      ; DO NEXT ITERATION OF LOOP, 7 IS LENGTH OF "OPFOR" OPCODE
         JMP   NTRADB                  ; START EXECUTION FOLLOWING OPFOR OPCODE AGAIN
         PAGE    
NEXTIOV  PSHD                          ; RATS, LOOP INDEX > 65535: CONVERT TO 4 BYTE INTEGER
         LDD   #1                      ; EQUIVALENT OF CORRECT SUM
         PSHD                          ; ("1" = CARRY WE LOST)
         call  FLOAT                   ; FLOAT THE RESULT
         lhld  BPC                     ; SAVE IT BACK IN THE INDEX VARIABLE
         lhld  ILADD+3,X
         call  FSTORE                  ; ASSERT: LOOP INDEX > LOOP LIMIT
NEXTEXIT EQU   *
         lhld  BPC                     ; NOW FALL OUT OF THE LOOP...
NEXT1A   lhld  ILADD+1,X               ; AND START EXECUTION BEYOND "NEXT" OPCODE
         JMP   NTRPTX
;
NEXT1    lhld  BPC                     ; LOOP INDEX < LIMIT
         lhld  ILADD+5,X               ; NOW CHECK SIGN OF STEP
         LDA   FSTYPE,X
         BPL   NEXTITERATION           ; B/ SIGN >= 0, DO NEXT ITERATION
         jr    NEXTEXIT                ; STEP IS < 0, LOOP IS COMPLETE!
         PAGE    
NEXTIF   EQU   *                       ; INDEX VARIABLE IS FLOATING, BUT STEP AND LIMIT AREN'T!!
         lhld  BPC                     ; PUSH LIMIT AND STEP
         lhld  ILADD+5,X               ; WE'LL DO THE SLOW WAY SINCE THIS HAPPENS ONCE IN A BLUE MOON
         LDB   #RSESIZ*2               ; # BYTES TO PUSH
NEXTIFL  LDA   RSESIZ*2-1,X
         DEX    
         PSHA    
         DECB    
         jrnz  NEXTIFL                 ; YOU FIGURE IT OUT
         call  MAKEBOTHFLOAT           ; FLOAT STEP AND LIMIT
         call  STORESTEPANDLIMIT       ; SAVE THEM AWAY
         lhld  BPC
         lhld  ILADD+5,X
NEXTF    EQU   *                       ; STEP/LIMIT ARE FLOAT, WE ASSUME INDEX VAR IS, TOO!
         call  FLOAD                   ; GRAB STEP VALUE
         lhld  BPC                     ; GET INDEX VARIABLE
         lhld  ILADD+3,X
         call  FLOAD
         call  FORCEFLOAT              ; JUST IN CASE!
NEXTF1   lhld  #FLOATOVFLOW            ; IN CASE WE GET OVERFLOW,...
         shld  FPTRAP                  ; WE WANT TO BE PREPARED!
         call  FADD                    ; ADD STEP TO INDEX VARIABLE VALUE
NEXTFS   lhld  BPC                     ; AND STORE UPDATED INDEX VAR VALUE
         lhld  ILADD+3,X
         call  FSTORE
         lhld  BPC
         lhld  ILADD+3,X
         call  FLOAD                   ; NOW CHECK: IS INDEX VAR VALUE PAST LIMIT ?
         lhld  BPC
         lhld  ILADD+5,X
         LDD   FLIM5,X                 ; PUSH LIMIT...
         PSHD    
         LDD   FLIM3,X
         PSHD    
         LDD   FLTYPE,X
         PSHD    
         call  FCMP                    ; I REPEAT, IS INDEX VAR PAST LIMIT ?
         BLT   NEXT1                   ; B LOOP INDEX < LIMIT
         jrz   NEXTITERATION           ; B/ LOOP INDEX = LIMIT EXACTLY (UNUSUAL!!)
         lhld  BPC                     ; LOOP INDEX > LIMIT, NOW CHECK SIGN OF STEP
         lhld  ILADD+5,X
         LDA   FSTYPE,X
         BPL   NEXTEXIT                ; B/ STEP >=0, LOOP IS COMPLETE
         JMP   NEXTITERATION           ; B/ STEP < 0, DO NEXT ITERATION
         PAGE  *****  I N P U T  *****
;        XINLINE -- OPCODE TO READ IN AN ASCII LINE AT BEGINNING OF "INPUT" STATEMENT
;        READ CHARS INTO CATBUF ON CURRENT CHANNEL
;        UNTIL CR OR CATMAX (INCLUSIVE)
;        PUT CR IN BUFFER IF READ
;        SET INPTR TO 1ST BYTE OF INPUT LINE
;        CATPTR TO LAST BYTE OF INPUT LINE, +1
;
XOPINL   ; INPUT LINE OF TEXT FOR PROCE; SSING BY REST OF INPUT STATEMENT
         LDA   CHANEL                  ; CHANNEL 0 ?
         jrnz  OPINL1                  ; B/ NO, DON'T REQUEST BREAK
         call  PROCESSLINEFLAGS        ; COLLECT TRACE AND SINGLE STEP BITS
;                                       BREAK REQUEST, ABORT IF ESCAPE
OPINL1   EQU   *
         lhld  BPC
         shld  ILERR                   ; SAVE RECOVERY POINT (+1) IN CASE OF ERROR IN INPUT
         LEAX  2,X                     ; ADVANCE BPC PAST "INLINE" INSTRUCTION
         shld  BPC

         call  SETSCOP
         db    SYSCALL:READA
         db    READA:SCLEN
         db    CHANGED,1               ; **** READ IT IN "LINE MODE"

         lhld  CATBUF
         shld  INPTR                   ; NOTE: INPTR POINTS DIRECTLY TO 1ST DATA BYTE!
         shld  SCBLK+SCBLK:RDBUF

         lhld  CATSIZ
         shld  SCBLK+SCBLK:RDLEN

         call  SYSCALLONUSERCHAN

         LDA   EOFHITFLAG              ; IF EOF HIT, SKIP INPUT STATEMENT
         jrnz  XOPINL1

         lhld  SCBLK+SCBLK:RPLEN       ; INPUT LINE ENDS WITH CR --> DROP THE CR
         DEX                           ; (ASSERT: NOT EOF --> RPLEN >=1)
         shld  SCBLK+SCBLK:RPLEN

         LDD   SCBLK+SCBLK:RPLEN

         ADDD  CATBUF
         TDX    
         shld  CATPTR                  ; = INPUT LINE LIMIT
         LDA   ,X                      ; FETCH LAST BYTE READ
         CMPA  #ASCII:CR               ; =CR?
         jrnz  CATEN5J                 ; B/ NO <CR> PRESENT ON END OF BUFFER
         LDA   CHANEL                  ; INPUT FROM CHANNEL 0 ?
         jrnz  INPUT4                  ; B/ NO, DON'T PROCESS LINE FLAGS AFTER INPUT COMPLETED!
         JMP   XOPLINE0                ; GO PROCESS ^B, ^T, ^V
;                                      IF ENTERED WHILE IN INPUT MODE

XOPINL1  lhld  [ILERR]                 ; EOF HIT DURING READ
         JMP   NTRPTX                  ; (X) = WHERE TO GO IF EOF HIT

CATEN5J  call  RTPERR
         db    :IBUFOVF
         PAGE    
;        XOPINP -- INPUT A VALUE TO TOS FROM THE INPUT LINE
;
XOPINP   LDD   CATPTR                  ; CALCULATE # OF CHARS TO EAT (MAX)
         SUBD  INPTR
         lhld  INPTR
         BSR   CONVERT
         jr    INPUT3                  ; ALL IS OK
         lhld  ERTRAP                  ; INPUT CONVERSION ERROR (SYNTAX OR OVERFLOW)
         jrnz  INPUT1                  ; B/ ERROR TRAPPING ENABLED, CAUSE TRAP!
         LDA   CHANEL                  ; INPUT CONVERSION ERROR (SYNTAX OR OVF)
         jrz   INPUT2
INPUT1   call  RTPERR
         db    :CONVER

INPUT2   call  XBCODE
         OPLSC                         ; LOAD STRING CONSTANT
         db    14
         db    7                       ; BELL CODE IN ERROR MESSAGE
         db    'Input Error!'
         db    CR
         OPPS                          ; PRINT STRING
         OPRMPT                        ;  PRINT PROMPT
         OPASM                         ; ENTER ASSY LANGUAGE
         lhld  ILERR
         DEX                           ; SO IT POINTS TO "OPINL" OPCODE
         lspd  ERRORRECOVERYSTACK      ; RECOVER FROM ERROR BY RESETTING STACK TO EMPTY...
         JMP   NTRPTX                  ; AND RE-EXECUTING FROM THE "OPINL" OPCODE

INPUT3   shld  INPTR
INPUT4   JMP   NTRPT1
         PAGE    
;        CONVERT -- CONVERT HEX VALUE OR FLOATING POINT NUMBER
;        (X) POINTS TO 1ST BYTE OF STRING TO CONVERT
;        (A,B) CONTAINS # CHARACTERS TO PROCESS
;        RETURNS POINTER TO END OF STRING
;
CONVERT  STD   LOOPCT                  
         shld  TEMPX                   ; COMPUTE POINTER PAST STRING
         ADDD  TEMPX
         STD   CONVERTLIMIT
         PULD    
         STD   RTPRET
         LDD   LOOPCT                  ; GET THE MAX CHARS TO EAT
         call  FCONVI
         jr    CONVER10                ; ALL IS OK
         jr    CONVER11                ; OVERFLOW
         shld  BUFERP                  ; CONVERSION (SYNTAX) ERROR, TRY HEX NUM
         lhld  LOOPCT                  ; SET UP MAX # TO EAT
         shld  LOOPX
CONVER1  call  GETCHAR
         CMPA  #ASCII:SPACE
         jrz   CONVER1                 ; IGNORE LEADING BLANKS
         CMPA  #ASCII:HT
         jrz   CONVER1
         CMPA  #':
         jrnz  CONVER11                ; INPUT ERROR
         CLRA    
         STA   MS1
         STA   MS2
         STA   MS3                     ; DIGIT COUNT
CONVER2  call  GETCHAR
         CMPA  #'0                     ; DIGIT?
         jrc   CONVER6                 ; NOT A DIGIT
         CMPA  #'9
         BHI   CONVER3
         SUBA  #'0
         jr    CONVER4
CONVER3  ANDA  #%01011111              ; FOLD UPPER INTO LOWER CASE TO ALLOW LOWER CASE HEX!
         CMPA  #'A                     ; 'A'-'F' DIGIT?
         jrc   CONVER6                 ; NOT A DIGIT
         CMPA  #'F
         BHI   CONVER6                 ; NOT A DIGIT
         SUBA  #'A-10
CONVER4  LDB   #1                      ; I SAW A DIGIT
         STB   MS3
         ASLA    
         ASLA    
         ASLA    
         ASLA    
         LDB   #4
CONVER5  ASLA    
         ROL   MS2
         ROL   MS1
         jrc   CONVER11                ; OVERFLOW
         DECB    
         jrnz  CONVER5
         jr    CONVER2
CONVER6  LDB   MS3
         jrz   CONVER11                ; NO DIGITS, INPUT ERROR
         LDD   MS1
         PSHD    
         LEAS  -3,S
         CLRB    
         PSHB    
         lhld  BUFERP
         DEX                           ; BECAUSE OF GETCHAR
CONVER10 CPX   CONVERTLIMIT
         jrz   CONVER9                 ; B/ YES, JUST LEAVE
         LDA   ,X                      ; NO, TRAILING COMMA?
         CMPA  #$2C
         jrnz  CONVER9
         INX                           ; YES, EAT THE COMMA
         IF    M6800!M6801
CONVER9  LDD   RTPRET
         PSHD    
         ELSE  (M6809)
CONVER9  JMP   [RTPRET]
         FIN    
PROUSRTS ret

CONVER11 lhld  RTPRET                  ; SYNTAX OR OVERFLOW ERROR
         JMP   2,X
         PAGE  *****  P R I N T  *****
;
;        WASCII-FOR THOSE WHO CAN AFFORD THE VERY WORST
;
WASCII   STA   CHAR
         PSHB    
         call  SETSCOP
         db    SYSCALL:WRITEA
         db    WRITEA:SCLEN
         db    CHANGED,IGNORED

         call  SETSCWRBUF
         DW    CHAR
         DW    1

         PULA    
         JMP   SYSCALLONCHANNELA       ; BYE!

;
;        PRINT PROMPT
;
XOPRMPT  LDA   #'?
         CLRB    
         BSR   WASCII
         jr    XOPPSP                  ; NOW OUTPUT A SPACE (WE KNOW CHANNEL # IS ZERO)
         PAGE    
;        PRINT REST OF USING STRING
;        USED BY PRINT USING ... ;
;        DOES NOT OUTPUT A CR
;
XOPPRUS  BSR   PROUS                   ; GO PRINT REST OF USING STRING
         JMP   NTRPT1                  ; AND EXECUTE THE NEXT OPCODE
;
PROUS    call  SETSCOP                 ; PRINT OUT REST OF USING STRING
         db    SYSCALL:WRITEA
         db    WRITEA:SCLEN
         db    CHANGED,IGNORED         ; WHERE STRING STARTS
         LDD   USINGMAX                ; COMPUTE LENGTH OF STRING
         SUBD  USING
         lhld  USING
         call  SYSCALLGETWRBUF1
         lhld  USINGMAX                ; ADVANCE USING TO MAKE NULL USING STRING
         shld  USING
         lhld  SYSCALLWRLEN            ; POSTAMBLE = 0 BYTES?
         jrz   PROUSRTS                ; B/ YES, DON'T BOTHER!
         JMP   SYSCALLONUSERCHAN
;
;        PRINT CR
;        DUMP OUT REST OF USING STRING IF <> 0
;        FOLLOW BY CR
;
XOPPCR   BSR   PROUS                   ; GO PRINT REST OF USING STRING
         LDA   #CR
         jr    PRINTA
;
;        PUT A SPACE TO THE OUTPUT
;
XOPPSP   LDA   #BLANK
PRINTA   LDB   CHANEL                  ; OUTPUT CHARACTER IN (A)
         call  WASCII
         JMP   NTRPT1
         PAGE    
;        RESOLVE THE STRING LENGTH ON TOS; RETURNS RESULT IN (X), TEMPX
;        PRESERVES (A,B)!
;
GSTRCNT  lhld  R1SDC1+2,S
         CPX   #$FFFF
         jrnz  GSTRCNT1
         lhld  R1SDA+2,S
         lhld  CURLEN,X
GSTRCNT1 shld  TEMPX                   ; AS ADVERTISED
         ret
;
;        PRINT STRING POINTED TO BY SD ON TOS
;
XOPPS    call  SETSCOP
         db    SYSCALL:WRITEA
         db    WRITEA:SCLEN
         db    CHANGED,IGNORED

         TSX    
         call  SYSCALLGETWRBUF
         call  SYSCALLONUSERCHAN
         JMP   PL1PC1
         PAGE    
;        ISFORMAT -- CHECK TO SEE IF (X) POINTS TO A VALID FORMAT STRING
;        (A,B) POINTS TO BYTE PAST END OF STRING
;        RETURNS IF FORMAT, (X) POINTS PAST FORMAT STRING
;        (A) RETURNS LENGTH
;        SETS UP LDOLLAR, LMINUS,LSHARP,DPCOUNT,RSHARP,RMINUS,RCARET...
;        TO APPROPRIATE COUNT AS SPECIFIED BY FORMAT STRING
;        SKIP RETURNS IF NOT A FORMAT
;
ISFORMAT EQU   *
         STD   ENDFORMAT
         CLRA                          ; INITIALIZE
         STA   LDOLLAR
         STA   LMINUS
         STA   LSHARP
         STA   DPCOUNT
         STA   RSHARP
         STA   RMINUS
         STA   RCARET
;
;        RECOGNIZES LEADING '$' '-' '$-' ''
;
         BSR   GETCHR
         CMPA  #'$
         jrnz  ISFRMT2
         INC   LDOLLAR
         BSR   GETCHR
         CMPA  #'-
         jrnz  ISFRMT4
ISFRMT1  INC   LMINUS
         jr    ISFRMT3
ISFRMT2  CMPA  #'-
         jrz   ISFRMT1
         jr    ISFRMT4
;
;        THIS SECTION SCANS LEFT SHARPS
;
ISFRMT3  BSR   GETCHR                  ; SCAN OFF LEFT SHARPS
ISFRMT4  CMPA  #'#
         jrnz  ISFRMT6
         LDA   LSHARP
         INCA    
         STA   LSHARP
         CMPA  #9
         BLS   ISFRMT3
         BSR   GETCHR
ISFRMT6  CMPA  #'.                     ; LOOK FOR DP
         jrnz  ISFRMT8                 ; NO DP, NO RIGHT SHARPS
         INC   DPCOUNT
         LDA   LSHARP
         CMPA  #9
         BHI   ISFRMT10                ; IF ENOUGH #'S FOUND, SKIP NEXT SECTION
ISFRMT7  BSR   GETCHR                  ; LOOK FOR RIGHT SHARPS
         CMPA  #'#
         jrnz  ISFRMT8
         LDA   RSHARP
         INCA    
         STA   RSHARP
         ADDA  LSHARP
         CMPA  #9
         BLS   ISFRMT7
ISFRMT10 BSR   GETCHR
ISFRMT8  LDB   LDOLLAR
         ORAB  LMINUS
         jrnz  ISFRMTD
         CMPA  #'-                     ; CAN HAVE '-', 3-5 CARETS, OR NOTHING
         jrnz  ISFRMTA
ISFRMT9  INC   RMINUS
         jr    ISFRMTF                 ; DONE
         PAGE    
;        GETCHR -- USED ONLY BY ISFORMAT...
;        TO FETCH POSSIBLE FORMAT STRING BYTES
;        RETURN 0 IN (A) IF END OF FORMAT STRING HIT
;
GETCHR       
         IF    M6800!M6801
         CLRA    
         CPX   ENDFORMAT
         jrz   GETCHR1
         LDA   ,X
GETCHR1  INX    
         ret
         ELSE  (M6809)
         LDA   ,X+
         CPX   ENDFORMAT
         BLS   GETCHR1
         CLRA    
GETCHR1  ret
         FIN    
;
ISFRMTE  EQU   *                       ; LEFT '-', NO LEFT '$': MAY HAVE '^'S OR NOTHING
ISFRMTA  CMPA  #'^
         jrnz  ISFRMTX                 ; DONE
         LDB   #5
         jr    ISFRMTB1
ISFRMTB  BSR   GETCHR
ISFRMTB1 CMPA  #'^
         jrnz  ISFRMTC
         INC   RCARET
         DECB    
         jrnz  ISFRMTB
         jr    ISFRMTF

ISFRMTC  LDA   RCARET                  ; VERIFY EXPONENT FIELD >=3 CHARACTERS
         CMPA  #2
         BHI   ISFRMTX
ISFRMTC1 DEX                           ; ASSERT: (A) <=2
         DECA    
         jrnz  ISFRMTC1
         CLR   RCARET
         jr    ISFRMTX                 ; DONE
;
ISFRMTD  LDB   LDOLLAR                 ; A STILL HAS CHAR
         ANDB  LMINUS
         jrnz  ISFRMTX                 ; DONE
         LDB   LDOLLAR
         jrz   ISFRMTE                 ; B/ LMINUS MUST BE ON
         CMPA  #'-                     ; LEFT '$', MAY HAVE '-' OR NOTHING
         jrz   ISFRMT9
ISFRMTX  DEX                           ; HANDLES CASE WHERE UNWANTED CHAR IS PICKED UP
ISFRMTF  LDA   LSHARP
         ADDA  RSHARP
         jrz   ISFRMTG                 ; AHA! THE NO-LEFT-OR-RIGHT-SHARPS TRICK
         CMPA  #10
         BHI   ISFRMTG                 ; NO GOOD
         ADDA  LDOLLAR
         ADDA  LMINUS
         ADDA  DPCOUNT
         ADDA  RMINUS
         ADDA  RCARET
         STA   FLENGTH                 ; REMEMBER THE FORMAT LENGTH HERE
         ret

ISFRMTG  PULX                          ; NOT A FORMAT STRING
         JMP   2,X
         PAGE    
;        PRINT VALUE ON TOS
;
XOPPV    call  FORCEFLOAT
         lhld  #FAC1
         call  FCONVO
         STA   LEAD
         STB   SIG
         lhld  USING
         CPX   USINGMAX
         jrz   PRNTV3

PRNTV1   shld  BEGINFORMAT             ; SAVE START OF POTENTIAL "FORMAT" STRING
         LDD   USINGMAX
         call  ISFORMAT                ; DOES A FORMAT STRING START AT BEGINFORMAT?
         jr    PRNTV4                  ; B/ YES
         lhld  BEGINFORMAT             ; NO
         INX                           ; ADVANCE TO NEXT BYTE OF USING STRING
         CPX   USINGMAX                ; USING STRING EXHAUSTED?
         jrnz  PRNTV1                  ; B/ NO.
         call  PROUS                   ; YES, NO FORMAT STRING WAS FOUND
PRNTV3   LDA   LEAD                    ; DO UNFORMATTED PRINT
         LDB   SIG
         lhld  #OUTBUF                 ; THIS IS WHERE TO PUT THE STUFF
         BSR   UFPRINT
         jr    PRNTV5
         PAGE    
PRNTV4   shld  ENDFORMAT               ; SAVE END OF FORMAT STRING
         lhld  BEGINFORMAT             ; SET USINGMAX := START OF FORMAT STRING
         LDD   USINGMAX
         shld  USINGMAX
         STD   BEGINFORMAT             ; SAVE REAL USING MAX
         call  PROUS                   ; GO PRINT THE NON-FORMAT PART
         lhld  BEGINFORMAT             ; RESTORE TRUE END OF "USING" STRING
         shld  USINGMAX
         lhld  ENDFORMAT               ; END OF LAST FORMAT =...
         shld  USING                   ; START OF REST OF USING STRING
         LDA   LEAD
         lhld  #OUTBUF                 ; THIS IS WHERE TO PUT THE STUFF
         call  FPRINT
;
;        PRINT NUMBER
;
PRNTV5   PSHA    
         call  SETSCOP
         db    SYSCALL:WRITEA
         db    WRITEA:SCLEN
         db    CHANGED,IGNORED

         PULA    
         STA   SCBLK+SCBLK:WRLEN+1
         lhld  #OUTBUF
         shld  SCBLK+SCBLK:WRBUF
         call  SYSCALLONUSERCHAN
         JMP   NTRPT1
        PAGE    
;        UNFORMATTED PRINT
;        SUBROUTINE FOR XOPPV, XOPNUM
;
;        A HAS # OF DIGITS LEFT OF THE DP IF E WERE = 0 (# OF INT DIGITS)
;        B HAS # OF SIGNIFICANT DIGITS (10 - # OF RIGHTMOST ZEROES)
;        X POINTS TO WHERE THE STUFF IS TO BE PUT
;        LDOLLAR CONTAINS LEFT DOLLAR COUNT
;        LMINUS CONTAINS LEFT MINUS COUNT
;        LSHARP CONTAINS LEFT SHARP COUNT
;        DP CONTAINS DP COUNT
;        RSHARP CONTAINS RIGHT SHARP COUNT
;        RMINUS CONTAINS RIGHT MINUS COUNT
;        RCARET CONTAINS RIGHT CARET COUNT
;        FLENGTH CONTAINS LENGTH OF ENTIRE FORMAT
;        FAC1-FAC6                     CONTAINS "S.DDDD"
;        FACEXT1-FACEXT5               CONTAINS "DDDDDD"
;        MS1-MS6                       CONTAINS "DESXXX"
;        WHERE S IS A '-' OR '+'
;        . IS A '.'
;        D IS AN ASCII DIGIT IN THE RANGE '0'-'9'
;        E IS A 'E'
;        X IS AN ASCII EXPONENT DIGIT IN THE RANGE '0'-'9'
;        ON EXIT, A RETURNS LENGTH
;        X POINTS PAST OUTPUT
;
;        CASE1 (ZERO)
;        A = 0 & ALL DIGITS ARE ZERO
;        (B = 0 SUFFICIENT)
;        PRINT ' 0'
;
;        CASE2 (INTEGER)
;        10 >= A >= 1 & RIGHTMOST 10-A DIGITS ARE ZERO
;        (A >= B)
;        PRINT SIGN, A DIGITS
;
;        CASE3 (INT W/FRAC)
;        9 >= A >=0 & RIGHTMOST 10-A DIGITS ARE NON-ZERO
;        (A < B)
;        PRINT SIGN, A DIGITS, '.' B DIGITS
;
;        CASE4 (SMALL FRACTION ONLY)
;        -1 >= A >= -5
;        PRINT SIGN, '.' (ABS(A)) ZEROES, B DIGITS
;
;        CASE5 (ALL ELSE)
;        PRINT SIGN, '.', B DIGITS
;        PRINT 'E', ESIGN, UP TO 3 DIGITS LEAD ZERO SUPPRESS
;
UFPRINT  shld  TWORD                   ; REMEMBER WHERE TO PUT THE RESULT
         CLR   TBYTE                   ; CLEAR THE LENGTH COUNTER
         TSTB                          ; ANY SIGNIFICANCE?
         jrnz  UFPRNT1                 ; YES
         INCA    
UFPRNT0  BSR   UFPRSN                  ; CASE 2, PRINT SIGN
         BSR   UFPRLFT                 ; PRINT LEFT DIGITS
         jr    UFPRNT6                 ; EXIT
UFPRNT1  CMPA  #10
         BGT   UFPRNT4                 ; GO DO CASE 5
         TSTA    
         BLE   UFPRNT3                 ; NOT CASE 2 OR 3, TRY 4
         CBA    
         BGE   UFPRNT0                 ; CASE 3
         BSR   UFPRSN                  ; CASE 3, PRINT SIGN
         BSR   UFPRLFT                 ; PRINT LEFT DIGITS
         BSR   UFPRDP                  ; PRINT '.'
         BSR   UFPRRT                  ; PRINT RIGHT DIGITS
         jr    UFPRNT6                 ; EXIT
UFPRNT3  CMPA  #-6                     ; SEE IF CASE 4, A IS ALREADY FOUND <= 0
         BLE   UFPRNT4
         BSR   UFPRSN                  ; CASE 4, PRINT SIGN
         BSR   UFPRDP                  ; PRINT DP
         BSR   UFPRZR                  ; PRINT THE ZEROES IF ANY
         BSR   UFPRRT                  ; PRINT RIGHT DIGITS
         jr    UFPRNT6                 ; EXIT
UFPRNT4  BSR   UFPRSN                  ; CASE 5, PRINT SIGN
         BSR   UFPRDP                  ; PRINT '.'
         BSR   UFPRRT
         LDA   #'E
         BSR   UFPR                    ; PRINT 'E'
         LDA   MS3
         BSR   UFPR                    ; PRINT SIGN
         lhld  #MS4
UFPRNT5  LDA   ,X
         CMPA  #'0
         jrnz  UFPRNT7
         INX    
         CPX   #MS6
         jrnz  UFPRNT5
UFPRNT8  LDA   ,X
UFPRNT7  BSR   UFPR
         INX    
         CPX   #MS6+1
         jrnz  UFPRNT8
UFPRNT6  LDA   TBYTE
         lhld  TWORD
         ret
         PAGE    
;        SUBROUTINES FOR UFPRINT, FPRINT

;        PRINT SIGN
;
UFPRSN   STA   LOOPCT
         LDA   FAC1
         CMPA  #'-
         jrz   UFPRSN3
UFPRSN2  LDA   #ASCII:SPACE
UFPRSN3  BSR   UFPR
         lhld  #FAC2
         ret
;
;        PRINT RIGHT DIGITS
;
UFPRRT1  LDB   RSHARP
UFPRRT   STB   LOOPCT
;
;        PRINT LEFT DIGITS
;
UFPRLFT  LDA   LOOPCT
         BLE   UFPRLFT2
UFPRLFT1 INX    
         LDA   ,X
         BSR   UFPR
         DECB                          ; ADJUST # OF SIG DIGITS RIGHT OF DP
         DEC   LOOPCT
         jrnz  UFPRLFT1
UFPRLFT2 ret
;
;        PRINT A DECIMAL POINT
;
UFPRDP   LDA   #'.
         BSR   UFPR
         ret
;
;        PRINT ZEROES
;
UFPRZR   LDA   LOOPCT
         BPL   FPRADSP1
         INCA    
         STA   LOOPCT
         CLRA    
         BSR   UFPR1
         jr    UFPRZR
;
;        ADD TO SPACE COUNT
;
FPRADSP  LDB   LMINUS
         jrz   FPRADSP1
         LDB   FAC1
         CMPB  #'+
         jrnz  FPRADSP1
         INCA    
FPRADSP1 TSTA                          ; FOR THE BENEFIT OF FORMATTED E-TYPE
         ret
;
;        PRINT LEADING MINUS IF LMINUS <> 0 & FAC1 = '-'
;
FPRLM    LDA   LMINUS
         jrz   FPRLM1
         LDA   FAC1
         CMPA  #'-
         jrnz  FPRLM1
         BSR   UFPR
FPRLM1   ret
;
;        PUT THE CHAR INTO THE OUTPUT BUFFER, PRESERVING X, B
;
UFPR1    ADDA  #'0
UFPR     shld  LOOPX
         lhld  TWORD
         STA   ,X+
         shld  TWORD
         lhld  LOOPX
         INC   TBYTE
         ret
         PAGE    
;        FORMATTED PRINT
;        SUBROUTINE FOR XOPPV, XOPNUMF
;
;        A HAS # OF DIGITS LEFT OF DP IF E WERE = 0 (SEE FCONVO)
;        X POINTS TO WHERE TO PUT THE STUFF
;        (ISFORMAT SETS UP THE FOLLOWING:)
;        LDOLLAR CONTAINS LEFT DOLLAR COUNT
;        LMINUS CONTAINS LEFT MINUS COUNT
;        LSHARP CONTAINS LEFT SHARP COUNT
;        DP CONTAINS DP COUNT
;        RSHARP CONTAINS RIGHT SHARP COUNT
;        RMINUS CONTAINS RIGHT MINUS COUNT
;        RCARET CONTAINS RIGHT CARET COUNT
;        FLENGTH CONTAINS LENGTH OF ENTIRE FORMAT
;        FAC1-FAC6                     CONTAINS "S.DDDD"
;        FACEXT1-FACEXT5               CONTAINS "DDDDDD"
;        MS1-MS6                       CONTAINS "DESXXX"
;        WHERE S IS A '-' OR '+'
;        . IS A '.'
;        D IS AN ASCII DIGIT IN THE RANGE '0'-'9'
;        E IS A 'E'
;        X IS AN ASCII EXPONENT DIGIT IN THE RANGE '0'-'9'
;        ON EXIT A RETURNS LENGTH
;        X POINTS PAST OUTPUT
;
;        CASE 1                        E-TYPE FORMAT
;        OVERFLOW IF NO '-' SPEC & VALUE IS NEGATIVE OR
;        ABS(A-LSHARP) > 100 & RCARET < 5 (3 EXP DIGITS) OR
;        100 > ABS(A-LSHARP) > 10 & RCARET < 4 (2 EXP DIGITS)
;        # SPACES = 1 IF LMINUS <> 0 & FAC1 = '+', ELSE = 0
;        PRINT LEADING SPACES
;        PRINT '-' IF LMINUS <> 0 & FAC1 = '-'
;        PRINT LSHARP DIGITS
;        PRINT '.' IF DP <> 0
;        PRINT RSHARP DIGITS (MAY BE NONE)
;        PRINT 'E'
;        LET EXP = A - LSHARP
;        PRINT SIGN(EXP) ('-' OR '+')
;        PRINT RCARET - 2 EXP DIGITS
;
;        CASE 2                        NOT E-TYPE FORMAT
;        OVERFLOW IF NO '-' SPEC & VALUE IS NEGATIVE OR
;        A > 0 & LSHARP - A < 0 
;        IF A <= 0 THEN
;        # SPACES = LSHARP (+ 1 IF LMINUS <> 0 & FAC1 = '+')...
;                                      ...-1*SGN(LSHARP)
;        IF A > 0 THEN
;        # SPACES = LSHARP - A (+ 1 IF LMINUS <> 0 & FAC1 = '+')
;        IF NUMBER OF LEADING SPACES > 0, THEN PRINT THEM
;        PRINT '$' IF LDOLLAR <> 0
;        PRINT '-' IF LMINUS <> 0 & FAC1 = '-'
;        PRINT A DIGITS ('0' IF A<=0 & LSHARP<>0 )
;        PRINT '.' IF DP <> 0
;        PRINT RSHARP DIGITS (MAY BE NONE)
;        PRINT '-' IF RMINUS <> 0 & FAC1 = '-', ELSE PRINT ' '
;
FPRINT   STA   LOOPCT
         shld  TWORD
         lhld  #FAC2
         CLR   TBYTE
;
         LDB   LMINUS                  ; CHECK OVERFLOW
         ORAB  RMINUS                  ; SIGN PROBLEM?
         jrnz  FPRINT1                 ; NO
         LDB   FAC1                    ; POSSIBLY, SEE IF VALUE IS NEG
         CMPB  #'-
         jrnz  FPRINT1
FPRINT10J      JMP                     ; FPRINT10 YES, FILL ASTERISKS
FPRINT1  LDB   RCARET                  ; E FORMAT?
         jrnz  FPRINT6                 ; YES
;
;        F-TYPE FORMAT (CASE 2)
;
         TSTA    
         BPL   FP1
         LDA   LSHARP
         jr    FP2
FP1      SUBA  LSHARP                  ; NO, CHECK MORE OVERFLOW
         NEGA    
         BMI   FPRINT10J               ; OVERFLOW
FP2      BSR   FPRADSP
         LDB   LOOPCT                  ; PICK UP A
         BGT   FP10
         LDB   LSHARP
         jrz   FP10
         DECA    
FP10     TAB    
         BLE   FPRINT0
FPRINT2  call  UFPRSN2                 ; PRINT SPACES
         DECB    
         jrnz  FPRINT2
FPRINT0  LDA   LDOLLAR                 ; NEED A DOLLAR SIGN PRINTED ?
         jrz   FPRINT3
         LDA   DOLLARSIGN              ; USE VALUE FROM FIXED LOCATION SO BRITISH CAN CHANGE IT
         BSR   UFPR
FPRINT3  BSR   FPRLM                   ; PRINT LEAD '-' IF REQUIRED
         LDA   LOOPCT
         BGT   FP11
         LDA   LSHARP
         jrz   FP13
         CLRA    
         BSR   UFPR1
FP11     EQU   *
FP13     call  UFPRLFT                 ; PRINT LEAD DIGITS
         LDA   DPCOUNT                 ; PRINT DP
         jrz   FPRINT4                 ; (NOW LOOPCT <= 0!)
         LDA   #'.
         BSR   UFPR
         LDB   RSHARP                  ; COMPUTE # SIGNIFICANT DIGITS TO PRINT
         ADDB  LOOPCT
         STB   LOOPCT
         BPL   FP3A                    ; B/ SIGNIFICANCE EXISTS
         CLRB                          ; PRINT RSHARP LEADING ZEROS
FP3A     SUBB  RSHARP                  ; PRINT OLD LOOPCT LEAD ZEROS
         jrz   FP4
FP3      CLRA    
         BSR   UFPR1
         INCB    
         jrnz  FP3
FP4      call  UFPRLFT
FPRINT4  LDA   RMINUS                  ; DO TRAILING MINUS IF ANY
         jrz   FPRINTH                 ; EXIT
         LDA   #ASCII:SPACE
         LDB   FAC1
         CMPB  #'-
         jrnz  FPRINT5
         TFR   B,A
FPRINT5  call  UFPR
FPRINTH  JMP   FPRINTG                 ; EXIT
;
;        E-TYPE FORMAT (CASE 1)
;
FPRINT6  STA   TEMPB                   ; SIGN EXTEND A INTO TEMPA
         CLRB    
         ROLA    
         SBCB  #0
         STB   TEMPA
         CLRA                          ; GET LSHARP SIGN EXTENDED
         LDB   LSHARP
         STB   LOOPCT
         SUBD  TEMPA                   ; SUBTRACT 'A'
         PSHD    
         BPL   FP5                     ; TAKE ABS(LSHARP - 'A')
         NEGD    
FP5      TSTA    
         jrnz  FPRINT8                 ; ABS(EXPONENT) > 255, NEED 5 CARETS
         CMPB  #99
         BHI   FPRINT8
         CMPB  #9
         BLS   FPRINTB                 ; EXP < 10, WE'RE OK
         LDA   RCARET
         CMPA  #4                      ; EXP >= 10 & < 100, REQUIRES AT LEAST 4 CARETS
         BLT   FPRINT9                 ; ERROR
         jr    FPRINTB                 ; AT LEAST 4 CARETS, WE'RE OK
FPRINT8  LDA   RCARET
         CMPA  #5                      ; EXP >= 100, REQUIRES 5 CARETS
         jrz   FPRINTB                 ; 5 CARETS, WE'RE OK
FPRINT9  LEAS  2,S
FPRINT10 LDB   FLENGTH                 ; PUT OUT '*'
FPRINTA  LDA   #'*
         call  UFPR
         DECB    
         jrnz  FPRINTA
         jr    FPRINTG                 ; EXIT
FPRINTB  CLRA    
         call  FPRADSP
         jrz   FPRINTC                 ; ANY BLANKS?
         call  UFPRSN2                 ; ONLY ONE POSSIBLE
FPRINTC  lhld  #FAC2
         call  FPRLM                   ; PRINT LEAD '-' IF REQUIRED
         call  UFPRLFT                 ; PRINT LEFT DIGITS
         LDA   DPCOUNT                 ; PRINT DP
         jrz   FPRINTD
         LDA   #'.
         call  UFPR
         call  UFPRRT1                 ; PRINT RIGHT DIGITS
FPRINTD  LDA   #'E                     ; PRINT 'E'
         call  UFPR
         LDA   SIG                     ; ANY SIGNIFICANCE?
         jrnz  FP9                     ; YES
         STA   MEXP                    ; NO, USE EXP 'E+000'
         LEAS  2,S
         jr    FP6
FP9      PULD    
         STB   MEXP                    ; PRINT ESIGN
         jrz   FP6                     ; EXP = 0, USE '+'
         TSTA    
         BPL   FPRINTE                 ; EXPONENT IS NON-ZERO AT THIS TEST
         NEGB    
         STB   MEXP
FP6      LDA   #'+                     ; THIS IS REVERSED BECAUSE THE SUBTRACT WAS 
         jr    FP6A
FPRINTE  LDA   #'-
FP6A     call  UFPR
         lhld  #0                      ; MAKE BCD EXPONENT DIGITS IN FAC1 & FAC2
         shld  FAC1
         LDB   #8                      ; 8 BITS TO SHIFT
FPRINTF  ASL   MEXP
         LDA   FAC2
         ADCA  FAC2
         DAA    
         STA   FAC2
         LDA   FAC1
         ADCA  FAC1
         DAA    
         STA   FAC1
         DECB    
         jrnz  FPRINTF
         LDB   RCARET                  ; SEE HOW MANY EXPONENT DIGITS TO USE
         SUBB  #4
         jrz   FP7                     ; PRINT 2 EXP DIGITS
         BMI   FP8                     ; PRINT 1 EXP DIGIT
         LDA   FAC1                    ; UPPER NIBBLE MUST BE 0, PRINT 3 EXP DIGITS
         call  UFPR1
FP7      LDA   FAC2
         LSRA    
         LSRA    
         LSRA    
         LSRA    
         call  UFPR1
FP8      LDA   FAC2                    ; ALWAYS PRINT THIS DIGIT
         ANDA  #$F
         call  UFPR1
FPRINTG  LDA   TBYTE
         lhld  TWORD
         ret
         PAGE    
;        CHANGE TOS VALUE TO HEX STRING
;
XOPHEX   call  FIXTOS                  ; AND DON'T COME BACK IF YOU CAN'T
         LEAS  4,S                     ; TOS FORM IS (X,X,X,X,I,I); DROP X,X,X,X
         LDA   #':
         STA   OUTBUF
         lhld  #OUTBUF+1
         PULA    
         BSR   HEX1
         PULA    
         BSR   HEX1
         LDA   #5
         jr    NUM2

;
;        CONVERT BYTE TO ASCII HEX
;
HEX1     TFR   A,B
         LSRA    
         LSRA    
         LSRA    
         LSRA    
         BSR   HEX2
         TFR   B,A
         ANDA  #$F
;
;        CONVERT NIBBLE TO HEX DIGIT IN ASCII
;
HEX2     CMPA  #9
         BLE   HEX3
         ADDA  #7
HEX3     ADDA  #$30
         STA   ,X+
HEXRTS   ret
         PAGE    
;        NUM$    
;        REPLACE TOS VALUE WITH SD
;
XOPNUM   BSR   FORCEFLOAT              ; MAKE SURE TOS IS FLOATING
         lhld  #FAC1
         call  FCONVO                  ; CONVERT IT TO RAW STUFF
         lhld  #OUTBUF
         call  UFPRINT                 ; DO UNFORMATTED MASSAGING
NUM2     PSHA    
         CLRA    
         PSHA    
         LDD   #(OUTBUF-4)
         PSHD    
         LDA   #1                      ; MAKE EXP BYTE OF SD <> 0
         PSHD    
         JMP   NTRPT2
;
;        FORCEFLOAT -- ENSURE THAT TOS IS FLOATING
;
FORCEFLOAT     EQU                     ; *
         LDA   R1TYPE+2,S
         jrnz  HEXRTS                  ; B/ ALREADY FLOAT, GO 'WAY
;
;        BFLOAT -- INTERFACE TO FP ROUTINE FLOAT
;
BFLOAT   PULD    
         STD   ,S
         IF    M6800!M6801
         CLR   2,X
         CLR   3,X
         ELSE  (M6809)
         CLR   2,S
         CLR   3,S
         FIN    
         JMP   FLOAT
         PAGE    
;        NUMF$ CONVERTS VALUE ON TOS TO SD USING FORMAT STRING SD AT TOS-1
;        FORMAT STRING MUST CONTAIN ONLY VALID # FORMAT
;
XOPNUMF  lhld  R2SDC1,S
         CPX   #$FFFF
         jrnz  NUMF0
         CLR   R2SDC1,S                ; SET FORMAT STRING LENGTH TO CURLEN
         IF    M6800!M6801
         lhld  R2SDA,X
         ELSE  (M6809)
         lhld  R2SDA,S
         FIN    
         LDA   CURLEN,X
         jrnz  NUMF1
         LDB   CURLEN+1,X
         STB   R2SDC2,S
NUMF0    LDA   R2SDC1,S
         jrnz  NUMF1
         IF    M6800!M6801
         LDB   R2SDC2,X                ; (A,B):= STRING LENGTH
         lhld  R2SDA,X                 ; GET ADDRESS OF FORMAT STRING
         ELSE  (M6809)
         LDB   R2SDC2,S
         lhld  R2SDA,S
         FIN    
         LEAX  STRING,X                ; = ADDRESS OF START OF FORMAT STRING
         shld  TWORD                   ; NOW SET (A,B):=END OF FORMAT STRING
         ADDD  TWORD                   ; = ADDRESS OF STRING + LENGTH IN BYTES
         call  ISFORMAT
         jr    NUMF2

NUMF1    call  RTPERR
         db    :FORMAT

NUMF2    CMPA  R2SDC2,S                ; LENGTH MUST MATCH
         jrnz  NUMF1
         BSR   FORCEFLOAT              ; MAKE SURE ITS FLOATING
         lhld  #FAC1
         call  FCONVO                  ; CONVERT TO RAW STUFF
         lhld  #OUTBUF
         call  FPRINT
         LDD   #(OUTBUF-4)
         STD   R1SDA,S
         JMP   NTRPT2
         PAGE  *****  I / O  *****
;
;        SET CHANNEL NUMBER TO ZERO
;
XOPZCHN  CLR   CHANEL
         IF    M6800!M6801
         JMP   NTRPT1
         ELSE  (M6809)
         JMP   NTRPTX
         FIN    
;
;        COLUMN FUNCTION
;
XOPCOL   call  RNDTOS
         DW    SETCHNERR
         TSTA    
         jrnz  SETCHNERR
         BSR   GETCOL
         CLRA    
         ADDD  #1
         PSHD    
         LEAS  -3,S
         CLRA    
         PSHA    
         JMP   NTRPT2
         PAGE    
;
;        GET COLUMN NUMBER
;
GETCOL   PSHB    
         call  SETSCOP
         db    SYSCALL:STATUS
         db    STATUS:SCLEN
         db    CHANGED
         db    SC:GETCOL

         call  SETSCRDBUF
         DW    CHAR
         DW    1

         PULA    
         STA   SCBLK+SCBLK:PARAMS
         call  ISYSCALL

         LDB   CHAR
         ret
         PAGE    
;
;        SET CHANNEL NUMBER
;
XOPCHNL  call  RNDTOS
         DW    SETCHNERR
         TSTA    
         jrnz  SETCHNERR
         STB   CHANEL
         JMP   NTRPT1

SETCHNERR      call                    ; RTPERR
         db    :CHNLR
         PAGE    
;
;        DO TAB TO NEXT PRINT COLUMN
;
XOPTABCOL      LDB                     ; CHANEL
         BSR   GETCOL
COLMN0   SUBB  #18                     ; REDUCE COLUMN COUNT MODULO 18
         BCC   COLMN0
         NEGB                          ; = # BLANKS TO OUTPUT (>=1)
COLMN1   STB   TBYTE
         call  SETSCOP                 ; SET UP SYSCALL OPCODE
         db    SYSCALL:WRITEA          ; WRITE ASCII
         db    WRITEA:SCLEN
         db    CHANGED,IGNORED
COLMNL   ; WRITE BLOCKS OF BLANKS
         CLR   SYSCALLWRLEN
         LDB   TBYTE                   ; ASSUME WRITE BUF LENGTH = COUNT
         STB   SYSCALLWRLEN+1
         LDB   #BLANKSTRINGEND-BLANKSTR; ING
         CMPB  TBYTE                   ; IS ACTUAL STRING SIZE < COUNT ?
         BCC   COLMN4                  ; B/ NO
         STB   SYSCALLWRLEN+1          ; YES, USE LENGTH OF BLANK CONSTANT
COLMN4   lhld  #BLANKSTRING            ; SET UP WRITE BUFFER
         shld  SYSCALLWRBUF
         call  SYSCALLONUSERCHAN       ; AND DO THE SYSTEM CALL!
         LDB   TBYTE                   ; SUBTRACT # BLANKS PRINTED...
         SUBB  SYSCALLWRLEN+1          ; FROM ACTUAL COUNT
         jrnz  COLMN1                  ; B/ MOVE TO PRINT.
COLMN3   JMP   NTRPT1
BLANKSTRING    db                      ; "                  "
BLANKSTRINGEND EQU                     ; *
         PAGE    
;
;        TAB TO SPECIFIED COLUMN #
;
XOPTAB   call  RNDTOS
         DW    TAB3
         TSTA    
         jrnz  TAB3
         PSHB    
         LDB   CHANEL
         call  GETCOL
         INCB                          ; TAB(1) = 1ST PRINT COLUMN
         PULA    
         jrz   COLMN3
         SBA    
         jrc   COLMN3
         jrz   COLMN3
         TFR   A,B
         jr    COLMN1

TAB3     call  RTPERR
         db    :TABBIG
         PAGE    
;        EOF CHECK
;
XOPEOF   call  RNDTOS
         jr    SETCHNERR
EOF2     TSTA    
         jrnz  SETCHNERR
;
;        GET EOF STATUS ON CHANNEL (B)
;
         BITB  #$E0                    ; B=0..31?
         jrnz  SETCHNERR
         STB   SCBLK+SCBLK:PARAMS
         call  EOFBGEN
         BITA  ,X
         JMP   NOTEQUALQ
         PAGE    
;        DEBUG
;
XOPDBG   call  SETSCOP
         db    SYSCALL:DEBUG
         db    DEBUG:SCLEN
         DW    IGNORED

         call  ISYSCALL
         JMP   NTRPT2
;
;        CLOSE A FILE
;
XOPCLS   call  SETSCOP
         db    SYSCALL:CLOSE
         db    CLOSE:SCLEN
         db    CHANGED,IGNORED
         call  SYSCALLONUSERCHAN
         JMP   NTRPT1
         PAGE    
;        READ A # FROM A FILE
;
XOPRV    call  SETSCOP
         db    SYSCALL:READB
         db    READB:SCLEN
         db    CHANGED,IGNORED

         IF    M6800!M6801
         LEAS  -(RSESIZ-1),S
         sspd  SCBLK+SCBLK:RDBUF
         DES    
         ELSE  (M6809)
         LEAS  -RSESIZ,S
         sspd  SCBLK+SCBLK:RDBUF
         FIN    
         LDA   #6
         STA   SCBLK+SCBLK:RDLEN+1
         call  SYSCALLONUSERCHAN
         JMP   NTRPT1
         PAGE    
;        OPEN FILE SPECIFIED BY TOS DESCRIPTOR
;
XOPOPN   call  SETSCOP
         db    SYSCALL:OPEN
         db    OPEN:SCLEN
         db    CHANGED,IGNORED

XOPOPN2  call  SETSCRDBUF
         DW    SCRATCH
         DW    4

         TSX    
         call  SYSCALLGETWRBUF
         call  SYSCALLONUSERCHAN
         JMP   PL1PC1

;
;        CHAIN TO FILE SPECIFIED BY TOS DESCRIPTOR
;
XOPCHAIN call  SETSCOP
         db    SYSCALL:CHAIN
         db    CHAIN:SCLEN
         DW    IGNORED
         JMP   XOPOPN2

         PAGE    
;        CREATE A FILE SPECIFIED BY TOS DESCRIPTOR
;
XOPCREAT call  SETSCOP
         db    SYSCALL:CREATE
         db    CREATE:SCLEN
         db    CHANGED,IGNORED
         JMP   XOPOPN2

;
;        DELETE FILE WHOSE NAME IS STRING ON TOS
;
XOPDEL   call  SETSCOP
         db    SYSCALL:DELETE
         db    DELETE:SCLEN
         DW    IGNORED
         JMP   XOPOPN2

         PAGE    
;        RENAME FILE NAMED TOS-1 (SD) TO TOS (SD)
;        NEW NAME LENGTH ON TOS, THEN ADDRESS, THEN RETURN ADDRESS
;        X PASSES POINTER TO OLD NAME, A TO OLD NAME LENGTH
;
XOPREN   call  SETSCOP
         db    SYSCALL:OPEN
         db    OPEN:SCLEN
         db    CHANGED,IGNORED

         IF    M6800!M6801
         TSX    
         shld  TEMPX
         ELSE  (M6809)
         sspd  TEMPX
         FIN    
         call  SYSCALLGETNEXTSTRING
         call  SYSCALLGETWRBUF1
         call  SETSCRDBUF
         DW    SCRATCH
         DW    4

         call  FINDACHAN

         call  SETSCOP
         db    SYSCALL:RENAME
         db    RENAME:SCLEN
         db    CHANGED,IGNORED

         TSX    
         call  SYSCALLGETWRBUF

         call  SETSCRDBUF
         DW    SCRATCH
         DW    4

         call  SYSCALLONMYCHAN
         call  CLOSEMYCHAN
         JMP   PL2PC1

         PAGE    
;        POSITION A FILE TO A SPECIFIED RECORD
;
XOPRESTR PULA    
         TSTA    
         jrz   POS1
         PSHA    
         lhld  #FPOINT5
         call  FLOAD
         call  FADD
         call  FIX
         jr    POS4
         call  RTPERR                  ; FILE POSITION IS TOO BIG!
         db    :POSERR
POS1     INS                           ; CONVERT TOS TO (0,0,X,X)
         CLR   ,S
         IF    M6800!M6801
         CLR   1,X
         ELSE  (M6809)
         CLR   1,S
         FIN    
POS4     call  SETSCOP
         db    SYSCALL:CONTROL
         db    SCBLK:RPLEN
         db    CHANGED
         db    CC:POSITION

         IF    M6800!M6801
         TSX    
         shld  SCBLK+SCBLK:WRBUF
         ELSE  (M6809)
         sspd  SCBLK+SCBLK:WRBUF
         FIN    
         lhld  #4
         shld  SCBLK+SCBLK:WRLEN
         call  SYSCALLONUSERCHAN

         LEAS  4,S                     ; DITCH POSITION INTEGER
         JMP   NTRPT1
         PAGE    
;
;        WRITE A NUMBER TO A FILE
;
XOPWV    call  SETSCOP
         db    SYSCALL:WRITEB
         db    WRITEB:SCLEN
         db    CHANGED,IGNORED

         IF    M6800!M6801
         TSX    
         shld  SCBLK+SCBLK:WRBUF
         ELSE  (M6809)
         sspd  SCBLK+SCBLK:WRBUF
         FIN    
         lhld  #RSESIZ
         shld  SCBLK+SCBLK:WRLEN
         call  SYSCALLONUSERCHAN

         JMP   PL1PC1
         PAGE    
;        READ A STRING USING TOS SD, READ MAX LENGTH IF COUNT = -1
;
XOPRS    call  SETSCOP
         db    SYSCALL:READB
         db    READB:SCLEN
         db    CHANGED,IGNORED

         TSX    
       