.cd
.br
SDOS/RT 68XX USER'S MANUAL
.pa 1
.he SDOS/RT 68XX USER'S MANUAL
.sh INTRODUCTION
.il Copyright (C) 1983
.ir Software Dynamics, Inc.
The contents of this document are proprietary property of Software Dynamics.
.sp
.TC
1. SDOS/RT -- GENERAL
.sp
.im 26
SDOS/RT is a multitasking operating system kernal for 6800, 6801, 6802,
6303, or 6809 microprocessors.   It provides the facilities required by
high-performance real-time applications, including:
       a) task-management primitives
            1) dynamic task creation and destruction
            2) resource locks (semaphores)
            3) event variables and event signalling
            4) task-wakeup on any one of multiple events
            5) dynamically adjustable task execution priorities
            6) sharable page zero locations
            7) error signalling and trapping
            8) fast block move subroutine
            9) task CPU utilization measurement
            10) 100uS. task context switch
            11) task stack space determined only by task requirements,
                not by interrupt system requirements
       b) interrupt management
            1) dynamically reconfigurable, priority-ordered
               interrupt poll chains
            2) nestable interrupts
            3) simulated interrupts from tasks to I/O initiation routines
            4) millisecond resolution timers causing simulated interrupts
            5) interrupt event signalling to tasks
            6) page zero locations for interrupt routines
            7) Fast (~100uS.) interrupt response time gauranteed
            8) Fast and slow interrupt routines to enhance response
.im 6
subjects to discuss:
memory organization
application program structure
RT:USPZ
What to do with processor vectors
RTTNZP
.pa
IMPLEMENTATION
.sp
.ix Implementation
.ix Conditional Assembly
SDOS/RT is designed to work on any of the following CPU chips: 6800,
6301/6801, 6802, (Hitachi) 6303, 6809 or 6811. A single source file
generates any or all versions. Difference in instruction sets is handled
either by convention (i.e., the "Y" register is RT:SPAD+0 for all machines
that do not have a "Y" register), by macro (i.e., LDD is expanded into
LDAA...LDAB on 6800), or conditional assembly.
.sp
.ix Code Convention
.ix External Label
.ix Motorola MDOS Assembler
.ix Boston Systems Office Assembler
.ix [ label ] notation
Coding Conventions are those of the SD MAL Assembler, which allows 32
character labels. A 6809 version compatible with the Motorola MDOS
assembler or Boston Systems Office PDP-11 cross assembler also exists. For
the MDOS/BSO version, external labels are limited to 6 characters by the
linker, and the shortened labels are shown in brackets "[" label "]"
following the discussion of the label used in the MAL assembler version.
.sp
.pa
.IX SDOSRT
.sp
.ix Real-Time Task
.ix Task Scheduler
.ix Multiple Tasks
.ix Processor Time Management
.ix Intertask Communication
.ix Task-to-Interrupt Communication
.ix Interval/Event Timing
.ix Address Space Management
SDOSRT is a real-time task scheduler. It provides processor time and and
address space management, intertask communication facilities,
task-to-interrupt and interrupt-to-task communications, and interval/event
timing facilities.
.sp
SDOS/RT provides the following facilities:
.ix SDOS/RT Facility
.sp
.in 4
.ix Priority Level
.un 3
1)~Scheduling of tasks with 256 different priority levels, using a
priority queue
.br
.un 3
2)~Round-robin scheduling of tasks with equal priorities
.br
.un 3
.ix Task Error Signal
.ix Propogation Facility
3)~Task error signal and propogation facilities
.br
.ix Task Initiation
.un 3
4)~Task initiation, freezing and/or deletion by other tasks
.br
.un 3
5)~Task wait for "or" of arbitrarily many events
.br
.un 3
6)~Event waiting and signalling
.ix Event Wait
.ix Event Signal
.br
.un 3
7)~Semaphore handling
.ix Semaphore
.br
.un 3
8)~Critical regions
.br
.un 3
9)~Task-to-interrupt routine signalling via Simulated Interrupt
.ix Task-to-Interrupt
.ix Simulate Interrupt
.br
.un 4
10)~Interrupt routine event posting/semaphore signalling
.br
.un 4
11)~Stack management for re-entrant routines
.ix Stack Management
.br
.un 4
12)~Dynamic interrupt device poll chain management
.br
.un 4
13)~Event signalling on timer
.br
.un 4
14)~Timeout interrupts for interrupt routines
.ix Time Out Interrupt
.br
.un 4
15)~Priority interrupt handling with 250uS context switch
.in 0
.sp
.ix System Space
.ix Interrupt Routine
.ix Task Control Block
.ix Event Object
SDOS/RT lives in a distinguished address space, called the "system space".
The system space holds all interrupt routines, Task Control blocks and event
objects referenceable by SDOS/RT.
.sp
SCRATCHPAD Storage
.ix Scratchpad Storage
.ix RT:SPad+0
.ix RT:SPad+7
.ix Table Pointer
.ix Subroutine Address
.ix Scratchpad Area
.ix Fixed Address
.ix Direct Memory Reference
.ix Code Speed
.sp
To facilitate the construction of tasks sharing common code SDOSRT provides
a set of 8 locations, RT:SPad+0 thru RT:SPad+7, in page zero at a fixed
address, which are switched as part of each task's context. Thus, pointers
to tables can be placed in the Scratchpad and passed to subroutines which
manipulate those tables; the subroutines can use the same addresses
throughout for working storage and yet still be assured that seperate, but
parallel executions of the same code are kept appropriately separated. The
scheduler ensures that whatever a particular task stores in the scratchpad
is always present in the scratchpad when the task is running. This allows
use of direct memory references, speeding up and shortening the code
considerably.
.sp
.in 0
.pa
ERROR PROPOGATION under SDOSRT
.ix Error Porpogation
.ix SDOS/RT
.ix Error Signal
.ix Task-Level Code
.ix Disaster Exit
.ix Error Code
.ix Runtime Stack
.ix Error Recovery Point
.ix Stack Pointer
.sp
SDOS/RT provides mechanisms to implement error signalling and propogation
throughout task-level code.  This ensures that all routines pass and handle
error signals correctly, and exit correctly in the face of disaster.  Error
codes are defined as 16 bit numbers, and are passed in register X. It is
important that routines which do not handle errors should pay as little as
possible in terms of time and space to allow error handling by those
routines that do.  This causes complications when an error must be
propogated through a routine that pushes data onto the runtime stack; how
can such a context block be removed automatically by the error propogation
mechanism?  This problem is solved by use of Error Recovery points; a module
that wishes to catch errors in itself, or in modules called by it, must
establish an Error Recovery point. Such a point records the current value of
.ix Recovery Point
.ix RT:RTrp
the stack pointer, so when control is passed to the recovery point, the
stack may be reset to a known good value, thus removing all extraneous
information on the stack at the time of the error recovery.   A routine
establishing an error recovery point, must, of course, remove it before
exiting; this can be accomplished by calling RT:RTrp.
.pa
Example:
.sp
.pw 120
.ll 100
.im 31
FRED    ...
        ldx     #FREDmain              ; address of block to be error trapped
        jsr     RT:STrp                ; save error recovery PC on stack
FREDErrorTrap ; control transfers to here if an error occurs
        ; check (X) for recoverable errors
        cpx     #errorcode             ; check for "errorcode"
        beq     handleerrorcode        ; b/ match, go recover
        ...
        jmp     RT:PErr                ; can't handle, propogate err

handleerrorcode ; handle error code (X)
        <test for can recover>
        bne     RT:PErr                ; b/ can't recover (X unchanged)
        <do logic to recover>
        ldx     #Fred2                 ; reinstantiate error recovery block
        jsr     RT:STrp
        bra     FREDErrorTrap

FREDmain ; main body of FRED goes here
        ...
        jsr     SAM                    ; which might error
        ...
        ldx     #errorcode             ; assume this error will happen
        <do test>
        lbeq    RT:SErr                ; signal error if bad condition
        ...
FRED2 ; reenter here after recovering from error
        ...
        jsr     RT:RTrp                ; remove error handler
        ...
        ret
.ll 65
.pw 85
.pa
.ix Scratchpad Location Preserved
.ix RT:SPAD
.in 6
.un 6
NOTE:~Unless otherwise indicated, registers are not preserved by SDOSRT
routines, and scratchpad locations (RT:SPAD) are always preserved.
.in 0
.in 10
.sp
.un 10
.ix RT:STrp
.ix CALL
.ix Error Recovery Routine
.ix Return Address
.ix RT:EStk
.ix Stack Pointer
.ix Save Value
.ix Set Trap
RT:STrp [RTSTRP] (Set Trap) handles Error Trap setup.  It is entered by
JSR; the return address points to the error recovery routine, and (X)
points to the beginning of the block of code to be executed with an error
trap set.  The current value of RT:EStk [RTESTK] is saved along with the
address of the error recovery routine, and then RT:EStk is set to the
current value of the processor's stack pointer. If an error occurs while in
the error trapped code, the machine stack pointer will be reset to the value
it had just before the JSR to this routine, RT:EStk will be set to the
saved value, and then control will be passed to the error recovery routine
coded in line after the call RT:STrp instruction.
All registers are preserved, but RT:SPad+0 and RT:SPad+1 are destroyed.
.sp
.un 10
.ix RT:RTrp
.ix RT:STrp
.ix Error Recovery Point
.ix Remove Trap
RT:RTrp [RTRTRP] (Remove Trap) deletes an error trap context set by RT:STrp.
No parameters are necessary.  RT:EStk is set back to the value it had at time
of entry to RT:STrp; thus, an error occurring after RT:RTrp is called will be
propogated to the "next higher level of error recovery", i.e., the most
recent error recovery point set that has not been cancelled by a call to
RT:RTrp. All registers are preserved, by RT:SPad+0, +1, +2, +3 are destroyed.
Note: on entry, the stack must have the same value it had on exit from
RT:STrp (i.e., it's clean).
.sp
.ix RT:SErr
.ix Signal Error
.ix JMP
.ix Error Code in (X)
.ix Error Trap
.ix Stack Pointer
.ix RT:STrp
.un 10
RT:SErr [RTSERR] (Signal Error) is entered by a JMP with a 16 bit error code
in (X). This causes control to be passed, with the error code in (X), to
the most recently established Error trap routine that has not been
cancelled; the stack pointer is reset to the value it had at entry to
RT:STrp. Passing control to an error trap routine also has the effect of
cancelling the error trap, so an error detected in an error trap routine
will be passed to a higher level error handler.
.sp
.un 10
RT:PErr [RTPERR] (Propogate Error) is entered by a JMP from an error trap
routine that does not recognize the error code it found in (X). This has the
effect of passing control to a higher level error handler, and also cancels
the error trap set by the higher level error handler.  SDOSRT ensures that
there exists a highest-lever error trap routine for each task, so no error
can propogate forever (but when highest level routine catches an error, it
kills the task).
.pa
.un 10
RT:GERR [RTGERR] (Generate Error) is entered via JSR, with an error code
coded inline following the return address.  The error code is fetched
to (X) and control is passed to RT:SERR.  This is simply a convenient
"door" to RT:SERR, that avoids extra space consumed by an LDX instruction
and the tedium of coding the LDX instruction.
.sp
.un 10
RT:IERR [RTIERR] (Inline Error) is entered via JSR, with an error code
coded inline following the return address.  RTIERR does not handle
errors using RT:ESTK.  Instead, after fetching the in-line error code
to (X), it pops pairs of bytes from the stack, assuming that each
pair is a return address, looking for a return address which points
at a BCC/BCS/LBCC/LBCS instruction.  When such an instruction is found,
the carry is set, and control is passed to the instruction.  Using
RTIERR, one can code routines that check for errors after subroutine calls
by doing BCS ERROR; the called subroutine must clear the carry before
taking a normal exit, or make a call on RT:IERR instead.
RT:IERR is included in SDOSRT for historical reasons; new applications
should use the RT:STrp/RT:RTrp error handling strategy instead.
.pa
.sh MISCELLANEOUS TASK LEVEL SUPPORT ROUTINES
MISCELLANEOUS TASK LEVEL SUPPORT ROUTINES
.un 10
.ix RT:BMov
.ix Block Move
.ix SDOS/RT
.ix Subroutine
.ix Source Area
.ix Destination Area
.ix Number of Bytes
RT:BMov [RTBMOV] (Block Move) is a standard subroutine to move a block of
data bytes very efficiently. It moves bytes from the location specified by
(X) to the location specified by (Y) [or the pointer in RT:SPad+0 for MPUs
with no Y register] for (D) bytes; the number of bytes moved may be zero. 
If the source and destination regions overlap, the destination must have a
lower address than the source. Exits with (X) advanced past the source area,
and (Y) has been advanced past the destination area. This block move
operates on blocks in the current space. It destroys all scratchpad
locations except RT:SPad+5 and RT:SPad+6.
.sp
.un 10
.ix RT:IMov
.ix Interspace Block Move
.ix Block Transfer Data
.ix Scratchpad Location 4
.ix Scratchpad Location 5
.ix RT:BMov
RT:IMov [RTIMOV] (Interspace Block Move) is used to block transfer data from
one bank to another. It has the same parameters as RT:BMov, with the
additional requirement that scratchpad location 4 contain the logical bank
number of the source bank, and scratchpad location 5 contains the logical
bank number of the destination bank. NOT CURRENTLY IMPLEMENTED.
.sp
.un 10
.ix RT:BCmp
.ix Block Compare
.ix Subroutine
.ix Return Condition Code
.ix HL
.ix DE
.ix BC
RT:BCmp [RTBCMP] (Block Compare) is a standard subroutine to
compare two strings of bytes.  (X) points to the 1st string, (Y) points to
the second, and (B) contains a count less than 256 of the number of bytes
to compare.  Returned condition codes are Zero if strings match for (B)
bytes; Not zero indicates the strings don't match, (B) is the remaining
count before end of string, and (X) and (Y) have been incremented just
past the point where the comparison failed.
RT:SPad+0, +1, +2, and +3 are destroyed.
.sp
.in 0
.pa
.sh INTERRUPT SYSTEM ORGANIZATION
INTERRUPTS under SDOSRT
.ix Interrupt
.ix Nestable Interrupt
.ix Priority Vectored Interrupt
.ix Simulated Interrup
.ix Task-to-Interrupt
.sp
SDOSRT supports nestable, priority vectored interrupts
It also provides for signalling
from an interrupt routine to a task, and simulated interrupts for
communication from task to interrupt routine.
.sp
.ix Vectored Interrupt
.ix Vector Target
.ix Memory Bank
.ix SDOSRT
SDOSRT's model of the interrupt system assumes that vectored interrupts
are always used (each vector target may, however, poll to determine
the source of the interrupt at that level). SDOSRT requires
each interrupt routine to run in the system space. Each
(vectored) interrupt routine must be coded according to certain
standards to ensure correct operation with SDOSRT.
.sp
.ix Interrupt
.ix Common Memory
.ix NMI Interrupt
.ix Vector Point
.ix Interrupt Routine
All interrupts must vector to locations in Common memory: memory which is
present no matter which bank is selected. At the vector point, the interrupt
routine is
.ix Switch Memory Bank
.ix RT:Bank
expected to select the system space (if an activity was executing in
another address space), so that the body of the interrupt poll chain routine
is addressable, and then to pass control to the interrupt poll chain. This
method keeps the amount of code in the common area to a minimum.  When
exiting the interrupt routine, the bank that was active before the interrupt
(RT:Bank) must be re-enabled.
.sp
.ix RT:Bank
.ix 2-Byte Variable
.ix Logical Bank
.ix Application Task
.ix RT:Bank+1
.ix Physical Bank Select Code
.ix OUT
.ix BankSelect Hardware Register
RT:Bank is a global 2-byte variable.  RT:Bank+0 contains the logical
bank selected (ignored by SDOSRT, but used by some application tasks
RT:Bank+1 contains the physical bank select
code, which is generally stored to a BankSelect hardware register to
switch to a specific bank.
.sp
.ix Nestable Interrupt
.ix Stack-Stingy
.ix Application Program
.ix Interrupted Activity Stack
.ix PC
.ix Stack Pointer
Nestable interrupts are allowed by requiring each (vector) interrupt routine
to switch to a special stack, called The Interrupt stack, if the interrupted
activity was a task (no switch is required if an interrupt routine is
interrupted, as the interrupt stack is already in use.) This ensures that
stack-stingy application tasks only need supply stack space for its own
needs, plus minimal stack space for context pushed by an interrupt. SDOSRT
dictates the the overhead is only 2 context blocks (one for a conventional
interrupt, one for a possible NMI) plus 8 (required by SDOSRT conventions for
fast interrupt routines).
.sp
Stack switching is accomplished by following code:
.sp
.im 5
            lsr    RT:ISSF            ; stacks switched yet (1 if no)?
            bcc    L1                 ; b/ yes, don't switch stacks again
            sts    RT:ISTK            ; yes, save task stack pointer
            lds    #RT:IISP           ; and switch to interrupt stack area
      L1
.sp
RT:ISSF is defined and initialized by SDOS/RT.  RT:ISTK is defined by
SDOSRT.
.pa
For really fast interrupt routines, the stack switch/unswitch may cause
unacceptable overhead.  To allow for such fast interrupt routines, SDOSRT
requires that all tasks reserve 8 bytes of stack space for use by interrupt
routines.  A fast interrupt routine may thus simply not switch stacks, and
yet has 8 bytes of stack space for return addresses, etc.  If the fast
interrupt routine detects nothing of interest to some task, it simply exits
via an RTI, thus avoiding any stack switching. To call RT:RTOB, RT:STOB,
RT:UTOB or RT:SIE, however, the fast interrupt routine is obliged to switch
stacks. Exit is still via RTI.
.sp
.ix Interrupt Routine
.ix Register Context
.ix Stack Pointer
.ix RT:ISTK
To exit the interrupt routine, the interrupt routine must first ensure that
the interrupting device has withdrawn its interrupt request and then
simply perform an RTI instruction.
.sp
.ix Nested Priority Interrupt
.ix Enable Interrupt
.ix RT:Bank
.ix Bank Code
.ix Interrupt Routine
.ix Interrupt Enable
To allow a nested priority interrupt, the interrupt routine must
first disable the device that caused this interrupt routine to run,
re-enable interrupts with a CLI instruction,
After operating with interrupts
enabled for a period, the interrupt routine will eventually need to disable
interrupts, perform final cleanup, and then exit as outlined above.
.sp
.ix Skeletal Example
.ix Interrupt Routine
.ix Vectored Interrupt Mode
.ix Disable Interrupt
Here are skeletal examples of how to construct interrupt routines that
operate under SDOSRT.  The example covers an interrupt system for
tasks that can run in any bank; for systems using only a single
bank of memory for SDOSRT and applications, considerable simplifications
can be made.
.pa
.pw 120
.ll 100
??? what about TCB:MAP???
.im 37
;       OVERALL INTERRUPT ROUTINE STRUCTURE

; FOLLOWING CODE MUST BE IN COMMON RAM

InterruptHardwareVectorsHere ; <interrupt comes here, in common space>
        jmp     BankedInterruptRoutine ; this value changed, should be in RAM
InterruptVector equ *-2

BankedInterruptRoutine ; control gets here if interrupt task running in another bank
        sts     RT:BSSV                ; save stack pointer of task in another bank
        lda     #SystemSpaceSelect
RT:SSBC equ     *-1 ; holds physical bank code of SDOSRT (must be PUBLIC label)
        sta     BankSelectHardware
        lds     #BankTaskRestart       ; set up to restart task in another bank
        ldx     #InterruptPollChain    ; where to to on subsequent interrupts
        stx     InterruptVector        ; (so we don't do this code twice on nested interrupts)
        jmp     InterruptPollChain     ; this makes for small code in common

BankedInterruptRoutineExit ; come here to return to interrupted banked task
        tfr     x,s                    ; restore banked task's stack pointer
        stb     BankSelectHardware     ; selected task's bank again
        ldx     #BankedInterruptRoutine ; set so interrupt handles bank switch
        stx     InterruptVector
        rti                            ; return control to interrupted task

; FOLLOWING CODE NEED NOT BE IN COMMON RAM

BankTaskRestart ; dummy stack area used to restart tasks in other banks
; What follows is an interrupt-disabled context block
; Its contents is restored to the MPU's registers by the last RTI...
; exeucuted by the interrupt routines
        fcb     $FF                    ; interrupt-disabled condition codes
RTBank  fcb     changed                ; (A) holds task logical bank
        fcb     changed                ; (B) holds task physical bank code
        ...
RT:BSSV fdb     changed                ; will end up in (X)
        fdb     BankedInterruptRoutineExit
        ...
.ll 65
.pw 85
.pa
.pw 120
.ll 100
.im 54
        org     xxxx
InterruptPollChain ; Beginning of interrupt poll chain
        lda     device1register        ; this device cause interrupt ?
        bita    device1expectsinterrupt ; (set up to cause interrupt ?)
        lbne    device1fastinterruptroutine ; b/ yes, go service!
        lda     device2register        ; is it this device ?
        bita    device2expectsinterrupt ; (set up to cause interrupt ?)
        lbne    device2fastinterruptroutine ; b/ yes, go service
        ...
        ; All the really fast devices on this vector have been checked.
        ; Must be only the slow ones left.  We have time to switch stacks.
        lsr     RT:ISSF               ; stacks switched yet (1 if no)?
        bcc     InterruptPollChain1   ; b/ yes, don't switch stacks again
        sts     RT:ISTK               ; yes, save task stack pointer
        lds     #RT:IISP              ; and switch to interrupt stack area
InterruptPollChain1 ; now using Interrupt stack instead of task's stack
        lda     device5register        ; this device cause interrupt ?
        bita    device5expectsinterrupt ; (set up to cause interrupt ?)
        lbne    device5slowinterruptroutine ; b/ yes, go service!
        lda     device6register        ; is it this device ?
        bita    device6expectsinterrupt ; (set up to cause interrupt ?)
        lbne    device6slowinterruptroutine ; b/ yes, go service
        ....
        ldx     badinterruptcounter    ; can't find cause of interrupt
        inx
        stx     badinterruptcounter    ; keep statistics for debugging
        rti                            ; and exit

 deviceXfastinterruptroutine ; do fast interrupt service
        <acknowledge device interrupt>
        <decide if interesting event>
        beq     deviceXfastinterruptroutineRTI ; b/ nothing, exit fast!
        ; to force scheduler to run, must switch stacks
        lsr     RT:ISSF               ; stacks switched yet (1 if no)?
        bcc     deviceXfastinterruptroutine1 ; b/ yes, don't switch stacks again
        sts     RT:ISTK               ; yes, save task stack pointer
        lds     #RT:IISP              ; and switch to interrupt stack area
deviceXfastinterruptroutine1 ; now using interrupt stack area
        <invoke various SDOSRT interrupt level routines>
deviceXfastinterruptroutineRTI
        rti                           ; and exit

        ...

 deviceYslowinterruptroutine ; already using interrupt stack area
        <acknowledge device interrupt>
        <invoke various SDOSRT interrupt level routines>
        <enable interrupts if interruptable interrupt routine>
        <decide if interesting event>
        beq     deviceYslowinterruptroutineRTI ; b/ nothing, exit!
        <disable interrupts if interruptable interrupt routine>
        <invoke various SDOSRT interrupt level routines>
deviceYslowinterruptroutineRTI
        rti                           ; and exit
.ll 65
.pw 85
.pa
DYNAMICALLY CONSTRUCTED INTERRUPT POLL CHAINS
.sp
Interrupt Poll Blocks (IPBs) are data structures used to dynamically
connect interrupt routines to interrupt poll chains in priority order.
While it is true that an interrupt poll chain can be constructed statically
(i.e., at assembly time), on some systems it is useful to construct
interrupt poll chains dynamically.
.sp
.in 10
.un 10
IPB:priority [IPBPRI] holds the priority of this IPB; 1 is lowest, 254 is highest.
(Codes 0 and 255 are reserved; using them will build an interrupt poll
chain that will run wild when an interrupt occurs).
.sp
.un 10
IPB:jmpnextipb [IPBJNI] contains an extended JMP opcode, whose target is
IPB:entry of the next interrupt poll block in the chain.
.sp
.un 10
IPB:nextipb [IPBNIP] is the address embedded in the JMP instruction.
.sp
.un 10
IPB:entry [IPBENT] contains device specific code to test for a device desiring
an interrupt, and to service the device if it is.
If the device is not requesting an interrupt, control
must be transferred to IPB:jmpnextipb of the IPB containing the entry.
If the device is requesting an interrupt, control is passed to
the device interrupt service routine.
.sp
.in 0
SDOSRT provides two built-in, empty poll chains:
RT:HighPriorityIntPollChain [RTHPIN], and RT:LowPriorityIntPollChain [RTLPIC].
It is normally
expected that the processor's IRQ vector will be set to point to
RT:HighPriorityIntPollChain.  The high priority interrupt poll chain is
expected to poll for very fast device interrupts (those which do not wish
to switch stacks), and, if it fails to locate any, to pass control to the
low priority interrupt poll chain. The low priority chain switches stacks,
and then polls for slow device interrupts.  Thus, the two chains accomplish
the effect shown in the example, with the additional capability of adding
or subtracting device interrupt routines to either chain.
.pa
.in 10
.un 10
RT:IPad [RTIPAD] is a set of 8 page zero locations reserved for use by
interrupt-disabled routines. An interrupt routine may not depend on the
values in RT:IPad being preserved from on interrupt to another, as other
interrupt routines may use the same locations. This primarily provides
scratch storage, making it easier to build ROM-based interrupt routines,
but it also speeds up the interrupt routines and simultaneously makes them
smaller.
.sp
.un 10
CB:xx [CBxx] define offsets into a stacked interrupt context block to access the
the various processor registers.
.sp
.un 10
FIRQ:xx [FIRQxx] defines the offsets into a stacked FIRQ interrupt context block
to access the various processor registers.
.in 0
.pa
.sh TASKS AND INTER-TASK COMMUNICATION: CONCEPTS
TASKS AND INTER-TASK COMMUNICATION: CONCEPTS
.sp
.ix Application Task
.ix Performance Limitation
.ix Asynchronous Performance
SDOSRT supports an arbitrarily large number of application tasks (although
performance limitations restrict practical use to under 100 tasks).  Each
task is an independent thread of execution, and may perform activities
asynchronously (and, in effect, in parallel with) other executing tasks.
Tasks are given priorities to ensure that activities are performed according
.ix Event Variable
.ix Synchronize Operation
.ix Task Priority
to their importance; a task may change its priority up or down if necessary.
Tasks may send signals (via event variables) or wait for events to
synchronize their operation, and tasks may wait for interrupt events or
cause an "interrupt" to signal an interrupt routine that service is
required. SDOSRT allows different tasks to operate in different memory
.ix Memory Bank Space
.ix Interbank Transfer
banks, so that large applications can take advantage of memory spaces larger
than 64k; any task may change the bank in which it is operating, so
interbank transfers and programs larger than 64kb are possible.
(One of
SDOSRT's design goals was to allow execution of banked systems
with a single main
task under SDOSRT running in its own private bank,
and SDOSRT, I/O drivers and various support tasks
.ix I/O Task
.ix System Bank
.ix Scratchpad Area
living in the system bank). SDOSRT provides each task with an 8
byte scratchpad area, which can be treated as extra registers; references to
the scratchpad by code is completely re-entrant.
.sp
.ix Task Control Block
.ix TCB
.ix Processor Context
.ix Priority Value
.ix TCB:Map
.ix Memory Bank
.ix TCB:StackPointer
.ix Address Space
.ix TCB:Priority
.ix Top of Stack
.br
"Task Control Blocks" (TCBs) are objects that represent tasks.  For each
task operating under SDOSRT, a TCB must be defined.  Each TCB contains
processor context when a task is not running, and a priority value for the
task.  Note that there are several important values that need set-up to
start a task: TCB:Map, i.e., a routine to select the address space in which
the task will execute; TCB:Stack, which contains the value that the
processor SP will hold when the task starts execution (note: the processor
stack area must be in the address space specified by TCB:Map); TCB:Priority,
to specify the relative priority of this task with respect to all the
others, and other values. All TCBs must be in the same space as SDOSRT.
.sp
.in 10
.un 10
.pa
.un 10
TCB:ESTK [TCBESK], TCB:ScratchPad [TCBSPD] and TCB:Map [TCBMAP] are simply
places to hold
.ix TCB:ESTK
.ix TCB:Map
.ix RT:EStk
.ix RT:SPad
.ix RT:Bank
.ix Propogated Error
.ix Garbage Stack Pointer
.ix TCB:ScratchPad
the task's values of RT:EStk, RT:SPad and RT:Bank??? while the task is not
executing.  TCB:ESTK MUST be set to a value that allows a
task to catch a propogated error, so that propogated errors NEVER pick up a
garbage stack pointer. RT:ATsk automatically sets TCB:ESTK.
.sp
.un 10
TCB:Stack [TCBSTK] holds a copy of the task's
.ix TCB:Stack
.ix Task Register Context
.ix Task Stack
register context when it is not executing.
.sp
.un 10
TCB:Priority [TCBPRI] is a byte which specifies the priority at which a task
executes.  SDOSRT maintains a list of tasks which are ready for execution,
and will choose the highest priority task from that list each time the list
.ix TCB:Priority
.ix SDOSRT
.ix Compute-Bound Task
.ix Multiple Tasks with Same Priority
.ix CPU Time
.ix Timeshare
.ix User-Defined Task
.ix Idle Task
.ix RT:ChPr
.ix Change Priority
is updated. Once a task is chosen for execution, SDOSRT will run that task
until it waits for some event, or until a task with a higher priority
pre-empts execution.  A compute-bound task will prevent tasks of lower
priority from executing at all. If there are multiple tasks with the same
priority, SDOSRT will allow each equal task a fixed amount of CPU time
before forcing another task of equal priority to run; thus simple
timesharing is effected. (IS THIS TRUE??)
SDOSRT defines 0 to be the HIGHEST priority, with
255 being the lowest; for implementation reasons, priority numbers 254 and
255 may NOT be used by any user-defined task (an Idle task of low priority
[254] soaks up all CPU cycles unwanted by other tasks).  A task may change
its priority by calling RT:ChPr (Change Priority).
.sp
.un 10
.ix TCB:NextTCB
TCB:NextTCB [TCBNXT] contains a pointer to another TCB if the task is in a queue. If
the TCB is not in any queue (i.e., it is waiting on an event) then
TCB:NextTCB is zero.
.sp
.un 10
TCB:CPUtime [TCBCPT] is the total amount of CPU, in milliseconds, a task has consumed
since the last time TCB:CPUtime was zeroed. TCB:CPUslw [TCBCPU] is the accumulated
CPU time in milliseconds since the last time the task was woken.
.sp
.un 10
TCB:Parameter [TCBPAR] holds the latest wake-up code a task has received, or
zero (no wake-up code).
.sp
.un 10
TCB:ID [TCBID] holds a "name" of the task, and is ignored by SDOSRT.
.pa
.in 0
.ix Event
.ix Interrupt Routine
.ix Task Signal Interrupt Routine
.ix Event Control Block
.ix EVN
.ix Event Count
.ix Event Code
.ix TCB Pointer
.ix Simulated Interrupt
"Events" are objects that represent the occurrence of an event.  They are
used (primarily) to signal events from interrupt routines to tasks (tasks
signal interrupt routines via simulated interrupts), and (occasionally) as
signals between tasks.  Each event is represented by an Event Control Block
(EVN), which contains an event count, a event code, and a pointer to a TCB.
.ix Event Counter
The event count records the number of occurrences of an event.
It is bumped when an event is "signalled", and it is
decremented when a task wakes up as a result of being "connected" to that
event; the event counter may also be forcibly zeroed.  The TCB pointer
indicates which task is waiting for the event to occur; since several EVNs
.ix OR Wait
may point to the same task. A task can be awakened when any of the events
occur, thus allowing OR waits.  Events can occur even when no task is
waiting for them; they are simply stored (by the counter) until some task
forms a connection to that event and then issues a wait.  This allows
interrupt routines and other tasks to build up several units of work,
asynchronously, with respect to the task whose job is to process those units
of work.
.sp
.in 10
.un 10
EVN:Count [EVNCNT] holds the event count stored by this event.  Limit is 65535.
.ix EVN:Count
.ix Event Count
.ix Limit
.sp
.un 10
EVN:Parameter [EVNPAR] holds a 16 bit code which identifies the event
represented by
.ix EVN:Parameter.
this EVN.  This is used by a task upon wakeup to determine which event woke
it.  The upper byte of this code MUST be non-zero. Practical uses for
EVN:Parameter include an event "name" or a pointer to an action for a task
to execute when the event occurs.
.sp
.un 10
EVN:TCB [EVNTCB] points to the TCB of the task which most recently issued
an
.ix EVN:ConnectedTCB
.ix SDOSRT:ConnectEvent
.ix RT:DWC
.ix Special Cell
RT:CEVN request for this EVN.  If this EVN has most recently
been disconnected, this points to a special cell used only by
SDOSRT to make processing of events simple.
.in 0
.pa
"Semaphores" are used to lock and unlock critical regions of code
(resource management), and to communicate between tasks which do not know
.ix Semaphore
.ix Interrupt Routine
each other's identity (producer/consumer relationship).  They are
occasionally used to communicate from interrupt routines to tasks, and
never used from tasks to interrupt routines (this is because interrupt
routines cannot
.ix Sempahore Update
.ix Semaphore Control Block
.ix TCB
wait).  Semaphores are always used as a pair, i.e., for each semaphore
update, there exists a corresponding wait for that semaphore somewhere.  A
semaphore control block (SCB) represents each semaphore, and contains a
count and a queue of TCBs.
.sp
.in 10
.un 10
.ix SCB:Count
.ix Semaphore Count
SCB:Count [SCBCNT] holds the semaphore count; 0 implies no resource available. A
limit of 127 resource units, and 128 waiting tasks results because the count
is stored in a byte.
.sp
.un 10
SCB:TCBQ [SCBTCQ] points to a queue of TCBs representing tasks, in priority
.ix SCB:TCBQueue
.ix TCB
.ix Priority Order
.ix Resource Available
order, which are waiting for availability of the resource.
.pa
.in 0
.ix Time Out
.ix Simulated Interrupt
.ix TOB
.ix RT:ITE
.ix InterruptTimeoutEvent
.ix Event Control Block
"Timeouts" are simulated interrupts which occur after a specified period of
time. A timeout block (TOB) represents a potential timeout interrupt, and
holds a timeout period, and a pointer to a block of code that gets control
as if an interrupt had occurred when the timer expires.  A parameter from
the timeout block is passed in (D) and (X) to the timeout routine. RT:ITSE
(InterruptTimeoutSignalEvent) can be specified as the TOB:Routine if an
event needs to be flagged when the timeout occurs (the TOB:Parameter must
point to an Event Control Block); this allows easy conversion of a timeout
interrupt to a timeout event detectable by a task.
.sp
.in 10
.un 10
TOB:DelayDelta [TOBDYD] holds the timeout period in 1000Hz ticks (limited to about 65
seconds) after which a timeout occurs.  When a TOB is in the
TimeoutBlock list, TOB:DelayDelta contains the 2's complement of the number
.ix TOB:DelayDelta
.ix Time Out Period
.ix TimeoutBlock
.ix Add Clock Tick
.ix RT:Tick
.ix $FF00 Ticks
.ix Limit Time Out
of clock ticks before the timeout will occur; this makes it easy to ADD a
clock tick. A timeout is complete when the most significant byte of the
remaining delay is zero (i.e., the time has arrived), thus allowing some
overshoot.  Since the number of clock ticks passed to RT:Tick cannot exceed
255, there is just enough overshoot to handle a maximum number of
ticks. These rules limit timeouts to $FF00 ticks, maximum (delays "larger"
than $FE00 are illegal.)
.sp
.un 10
TOB:Routine [TOBRUT] points to an interrupt routine which gains control via RT:SInt
when
.ix TOB:Routine
.ix RT:SInt
the timeout expires. See RT:SInt for description of properties that
interrupt one time must have.
.sp
.un 10
TOB:Parameter [TOBPAR] holds a 16 bit value which is passed to TOB:Routine in (D)
and (X) when
.ix TOB:Parameter
it gets control.
.sp
.un 10
TOB:QFlink [TOBQFL] holds a pointer to the next TOB in delay-sorted order; this
ensures that the timeout queue need process only the TOB at the head of the
queue at each clock tick.  If the TOB has expired then the TOB is not in
the timer queue and TOB:QFlink points to the TOB containing it.
TOB:QBlink [TOBQBL] is used with TOB:QFlink to make a doubly-linked list; this
makes deletions of TOBs from the timer queue efficient.
.pa
.sh SDOS/RT FACILITIES
SDOS/RT FACILITIES
.sp
.un 10
RT:ITOB [RTITOB] (Initialize Timeout) is called with (X) pointing to an
area to be used for a TOB, with a value in (D).  The value is stored in
both TOB:Routine and TOB:Parameter; the programmer must always initialize
one or the other by a STD instruction.  This routine must be called before
calling RT:RTOB, RT:STOB or RT:UTOB. Exits with (X) pointing to the TOB.
.sp
.un 10
RT:STOB [RTSTOB] (Set Timeout) is called with the address of a timeout block in (X),
and a timeout delay in (D).  The timeout block MUST NOT BE in the timer
queue, (IF IT MIGHT BE, USE RT:UTOB).  Interrupts must be disabled.
The TOB is then inserted in the
.ix RT:STOB
.ix Set Time Out
.ix Timer Queue
.ix WARNING
.ix RT:UTOB
.ix TOB:Routine
.ix TOB:Parameter
.ix Disable Interrupt
timer queue with the delay in milliseconds specified by (D).  After the
delay time has elapsed, the TOB is automatically removed from the timer
queue, and TOB:Routine is passed control via a simulated interrupt
(see RT:SInt)
(with interrupts disabled) with (D) and (X) holding TOB:Parameter. The
called routine need not save any registers, but must exit via RTI
It should re-enable enable interrupts it if has a lot of work to do.
.br
NOTE: A 1ms delay guarantees at least 1 millisecond will pass.
.sp
.un 10
RT:RTOB [RTRTOB] (Reset Timeout) is passed the address of a timeout block
in (X). If
.ix RT:RTOB
.ix Reset Time Out
.ix Timer Queue
.ix Disable Interrupt
.ix Time Out Expire
the TOB is still in the timer queue, it is removed, otherwise no action
takes place.  This routine should be called if the event which a timeout is
watching takes place before the timeout expires, and the effects of timing
the event out are no longer desired. Interrupts must be disabled.
.sp
.un 10
RT:UTOB [RTUTOB] (Update timeout) first does RT:RTOB, followed by RT:STOB, but is
more
.ix RT:UTOB
.ix RT:RTOB
.ix RT:STOB
.ix Disable Interrupt
.ix Update Time Out
efficient than calling each individually. Arguments are the same as
RT:STOB. Interrupts must be disabled.
.pa
.in 10
.un 10
RT:Clk [RTCLK] holds a 32 bit counter containing the number of clock ticks since the
.ix RT:Clk
.ix Number of Clock Ticks
.ix Clock Tick
.ix RT:TIME
.ix True Millisecond
system began operation.  Clock ticks are approximately 1/1000th of a second,
but may vary due to local hardware dependencies.
.sp
The clock tick error should be limited to 5% or software independent of
.ix SDOSRT
SDOSRT may not operate correctly.
.sp
.un 10
.ix RT:Tick
.ix Subroutine
.ix Hardware-Specific Clock Interrupt
.ix IO:SCID
.ix Scheduler
RT:Tick [RTTICK] is called as a subroutine by the hardware-specific clock interrupt
routine, and is given the nonzero number of clock ticks that have elapsed
since the last call to IO:RET (see below) in the (B) register
(note: this routine must be called at least once per quarter second;
IO:SCID will be called by the scheduler often enough to ensure this).
Interrupts must be in the disabled state; RT:Tick does not enable
interrupts and returns very quickly. The caller must be in the same bank as
RT:Tick.
.sp
.un 10
IO:RET [IORET] (Return Elapsed Time) is a user-defined routine that returns the
.ix RT:RET
.ix Return Elapsed Time
.ix User-Defined Routine
.ix Hardware Clock
.ix SDOSRT
number of clock ticks in (B) that have elapsed since the last call to
IO:RET. It is intended to be used to ask a hardware clock the amount of
elapsed time. SDOSRT will issue calls on IO:RET at intervals no longer than
(approx.) 100 milliseconds.
.sp
.un 10
IO:SCID [IOSCID] (Set Clock Interrupt Delay) is a user-defined subroutine that
will
.ix IO:SCID
.ix Set Clock Interrupt Delay
.ix Hardware Clock
.ix RT:Tick
.ix IO:RET
.ix Disable Interrupt
.ix Multiple Calls
cause an interrupt (by use of a hardware clock) to RT:Tick after -(D) clock
ticks (min 1, max 127) have passed since the last call to IO:RET. It is
called with interrupts disabled. This routine should be very fast to keep
interrupt system overhead small. A call to IO:SCID is always preceded by a
call to IO:RET or RT:Tick. It is not possible for the sequence
IO:RET...RT:Tick...IO:SCID or RT:Tick...IO:RET...IO:SCID to occur. Multiple
calls to IO:RET are valid.
.in 0
.pa
.in 10
.un 10
RT:WEVN [RTWEVN] is called by a task to wait for a wakeup condition.
RT:CEVN must
.ix RT:WEVN
.ix Wait
.ix RT:CEVN
.ix RT:RTEW
.ix Event Count Decrement
.ix Time Out Block
.ix Time Out Event
.ix Abort Event
be called once for each event that might wake the task, prior to executing
RT:WEVN.  Upon awakening, the Event code of the event that woke the task
is in (D) (and (X)??), or can be obtained by calling RT:RTEW, so the task
may know which event caused it to awaken. The event which caused the task to
awaken will have its event count decremented. If a task must not wait longer
than a fixed period of time, it can set up a timeout block to signal a
timeout event, and connect to the timeout event. NOT IMPLEMENTED: A task may
also awaken because of an Abort event, which sets (X) to Err:Aborted, and
performs an implicit RT:SERR (Signal Error) to start error recovery; in this
case, no registers
.ix Err:Aborted
.ix RT:SERR
.ix Signal Error
.ix Error Recovery
are preserved.
.sp
.un 10
RT:AEVN [RTAEVN] (Arm for new Event) allows events about to be
connected to wakeup this
.ix RT:AEVN
.ix Arm for new Event
task if it waits.  RT:AEVN must be called before connecting to any events,
or no event will wake the task.  No parameters needed.
.sp
.un 10
RT:RTEW [RTRTEW] (Read Task Event Wakeup Code) is called to read the Event
Code that woke this
.ix RT:RTEW
.ix Read Wakeup Code
.ix Event Code
.ix RT:WEVN
task. This can be used after waking up from waiting to determine which of
several connected events caused the wakeup (see RT:WEVN).
.sp
.un 10
RT:REVN [RTREVN] (Reset Event) is called with (X) pointing to an Event
Control Block.
.ix RT:REVN
.ix Reset Event
.ix Event Control Block
.ix EVN
The event count is zeroed. This is used to ensure that an EVN only records
"the next event" as opposed to some events stored from the past, and should
be called before RT:AEVN.
.sp
.un 10
RT:CEVN [RTCEVN] (Connect Event) is called with (X) pointing to an Event
Control
.ix RT:CEVN
.ix Connect Event
.ix Event Control Block
.ix RT:WEVN
.ix OR Condition
.ix Event Code
.ix Err:AlreadyConnected
Block. This sets up the event to awaken the task when an RT:WEVN is
issued.  Several events may be connected to a task before issuing a wait;
this allows a task to wait on an OR condition of any event. Since the
awakening event sets an event code, the task can easily determine which of
several events woke it.  Only one task may be connected to an event at a
time.  Not implemented: Err:AlreadyConnected will be issued if the event is
already connected to some other task.
.sp
.un 10
RT:DEVN [RTDEVN] (Disconnect Event) is called with (X) pointing to an Event
Control
.ix RT:DEVN
.ix Disconnect Event
.ix Event Control Block
.ix EVN
.ix Issuing Task
Block. This disconnects the event from the task; after a disconnect, the
event cannot awaken a task.  No error is given, even if the EVN is not
currently connected to the issuing task.
.pa
.un 10
RT:SEVN [RTSEVN] (Signal Event) is called with (X) pointing to an Event
Control
.ix RT:SEVN
.ix Signal Event
.ix Event Control Block
.ix Task Level Routine
.ix Interrupt
.ix RT:SIE
.ix Event Code
.ix Signal Interrupt Event
Block (this entry point is meant for use by task level routines only;
interrupt routines must use RT:SIE (Signal Interrupt Event)). The event
count is incremented by one, and, if some task is waiting for this event,
that task is awoken with an event code taken from the Event Control Block.
.sp
*******NEEDS WORK********
.br
.un 10
RT:SIW [RTSIW] (Signal Interrupt Waiting) is called with (X) pointing to an
Event
.ix RT:SIW
.ix Signal Interupt Waiting
.ix RT:SIE
.ix Signal Interrupt Event
.ix Event Control Block
.ix Interrupt Routine
.ix Task Level Routine
.ix RT:SEVN
.ix Signal Event
.ix Event Count
.ix Buffer Busy
.ix Buffer Free
Control Block (this entry point is meant for use by interrupt routines only;
task level routines should use RT:SEVN (Signal Event)). The event count is
set to one (not incremented!), and, if some task is waiting for this event,
that task is awoken with an event code taken from the Event Control Block.
RT:SIW is typically used when the interrupt routine keeps a separate count
of data, collects variable amounts of data in each transaction, and is used
to notify the task level that new data has arrived.
.sp
.un 10
RT:SIE [RTSIE] (Signal Interrupt Event) is called with (X) pointing to an
Event
.ix RT:SIE
.ix Signal Interrupt Event
.ix Event Control Block
.ix Interrupt Routine
.ix Task Level Routine
.ix RT:SEVN
.ix Signal Event
.ix Event Count
.ix Buffer Busy
.ix Buffer Free
Control Block (this entry point is meant for use by interrupt routines
only; task level routines must use RT:SEvn (Signal Event)). The event
count is incremented by one, and, if some task is waiting for this event,
that task is awoken with an event code taken from the Event Control Block.
The event count for an interrupt event is typically a "buffer busy" or
"buffer free" count.
.un 10
RT:SINT [RTSINT] (Simulate Interrupt) is called by a task with (X) pointing
to an interrupt
.ix RT:SInt
.ix Simulate Interrupt
.ix Register Contents
routine. The task is stopped exactly as if an interrupt had occurred; an
interrupt is simulated, including an interrupt-disable and a stack switch.
The contents of the registers are preserved for inspection by the interrupt
routine.  This allows a task to start an interrupt routine's operation, and
to pass that routine parameters describing the work to be done.  When the
interrupt routine has completed, it exits exactly like a true interrupt
routine (i.e., via RTI), and the task continues execution with registers
unchanged. This is the preferred method for a task to signal to an interrupt
routine that something interesting to the interrupt routine has occurred. No
address space switch occurs; (X) must point to an interrupt routine that is
visible when the system space is enabled. If an interrupt routine must do an
RT:SInt, it must be prepared for nested interrupts. When control returns,
interrupts are enabled.
.pa
.ix RT:RLck
.ix Semaphore
.un 10
RT:ILCK [RTILCK] Called with (X) pointing to an area of storage to
be used for a semaphore. Initializes the semaphore for use.
.sp
.un 10
RT:LOCK [RTLOCK] is called with (X) pointing to a semaphore. If the
semaphore is already
.ix RT:Lock
.ix Semaphore
.ix Semaphore Locked
.ix TCB:Priority
.ix Serial Execution
.ix Critical Code Section
.ix RT:Unlk
.ix Task Error
.ix Region Locked
.ix Priority Order
locked, the task is put to sleep until the semaphore is unlocked.  When
control is returned, the semaphore is locked. If several tasks lock a region,
the first to the region will succeed; the others will get their turn in
priority order, as specified by TCB:Priority. This call is meant primarily to
help ensure serial execution of critical sections of code, and should be used
in conjunction with RT:Unlk (Unlock). The programmer must ensure that tasks
erroring within a locked region recover gracefully, in particular, the error
recovery code must perform an RT:Unlk (Unlock) on the appropriate semaphore.
.sp
Not Implmented: How to handle error recovery and aborts.  If the waiting
task times out,
.ix Time Out
.ix Error Trap
or is aborted, it will wake up and pass control to the most recent error
trap set, with an approriate error code in (X).
.sp
.un 10
RT:Unlk [RTUNLK] (Unlock) is called with (X) pointing to a semaphore.  The
semaphore
.ix RT:Unlk
.ix Unlock
.ix Semaphore
.ix RT:Lock
is unlocked; if there is a task waiting for the semaphore to be unlocked
(RT:Lock), that task is woken and placed into execution. The calling
task does not wait; control returns immediately.
.sp
.un 10
RT:ALLC [RTALLC] (Allocate Resource) NOT IMPLEMENTED is called with (X)
pointing to a semaphore,
.ix RT:Allc
.ix Semaphore
.ix Resource Number Count
and (D) containing a count of the number of resource units to allocate.
If enough units are not available, the task is put to sleep until
enough do become available.
.sp
.un 10
RT:DLLC [RTDLLC] (Deallocate Resource) NOT IMPLEMENTED is called with (X)
pointing to a
.ix RT:DAllc
semaphore, and (D) containing a count of the number of resource units to
deallocate.  If some other task was waiting for resource units, and
enough became available, then the other task will be allowed to continue
execution.
.pa
.un 10
RT:ISTA [RTISTA] (Initialize Stack Area) is called with (X) pointing
to the byte just above an area to be used for a task's stack space,
with (D) containing an
initial PC for a task.  The stack area is set up with a context block, and
(D) is returned pointing to the context block created.  This routine is
typically used immediately prior to a call to RT:ITCB.
.sp
.un 10
RT:ITCB [RTITCB] (Initialize Task Control Block) is called with (X)
pointing to an area to be used as a Task Control Block, with (D)
pointing to a stack area containing a CPU context block.  The
task control block is initialized.  Exits with (X) left pointing
to the TCB; usually, this routine is called immediately prior to a call to
RT:ATCB.  RT:ITCB does NOT set/change TCB:Priority.
.sp
.un 10
RT:ATCB [RTATCB] (Add Task) called with a TCB address in (X) to add a new
Task to the ready-to-run task queue; TCB:Priority must previously have been
set. This entrypoint is used to set up all the tasks that will be in a
running SDOSRT system, but can be used to dynamically add tasks after the
system starts operation. A task can be removed by waiting on an event that
never occurs. Must be called by a task. Not implemented: RT:ATCB sets
TCB:ESTK to crash recovery point which kills the offending task if error
recovery is possible.
.sp
.un 10
RT:CHPR [RTCHPR] (Change Priority) is called by a task to change its current
priority
.ix RT:ChPr
.ix Change Priority
.ix A Register
.ix Undefined Value Result
to the value specified in the A register.  The value must be in the range
0-253; results for values 254 and 255 are undefined.
.sp
.un 10
RT:INIT [RTINIT] (Initialize) is called to start the operation of SDOSRT.
It must be
.ix RT:Init
.ix Initialize
.ix SDOSRT
.ix RT:ATsk
.ix TCB:StackPointer
.ix Task Control Block
.ix HL
called via JSR with interrupts disabled before any other SDOSRT function.
After it returns, tasks may be added to the ready task list by making
calls on RT:ATCB.
.ix System-Specific Initialize
After all tasks are added, and other system-specific initializing is
complete, control must transfer to RT:STRT to enable operation of SDOSRT.
.in 0
.pa
.in 10
.sp
.un 10
RT:ATPC [RTATPC] (Add to Poll Chain) is called with the address of
an IPB in (X), and (D) pointing to the head of an interrupt poll chain.
The IPB is inserted into the poll chain according to IPB:priority.
.sp
.un 10
RT:RFPC [RTRFPC] (Remove from Poll Chain) is called with the address
of an IPB in (X), and (D) pointing to the head of the interrupt poll
chain containing the IPB.  The IPB is removed from the poll chain.
.en
