        list    1
        page
*
err:argcount       equ  27
err:devicetimedout equ  $412
err:diskformatprot equ  $418
*
D.SENSE         EQU     $F6E6          SENSE SWITCHES (READ ONLY)
S.HDASFP        EQU     %00000010      SASI FORMAT PROTECT
*
*       HDA-S EQUATES
*
S.DATA          EQU     $F6E4          DATA I/O BUS
S.STAT          EQU     $F6E5          STATUS REGISTER
*
*       HDA-S STATUS REGISTER BIT DEFINITIONS
*
S.BUSY          EQU     %00000001      I/O BUS BUSY
S.RDWR          EQU     %00000010      READ/WRITE
S.CMDA          EQU     %00000100      COMMAND/DATA
S.MSG           EQU     %00001000      MESSAGE
S.INTE          EQU     %00010000      INTERRUPT ENABLE (LATCH)
S.SEL           EQU     %00100000      SELECT (LATCH)
S.INTR          EQU     %01000000      INTERRUPT REQUEST
S.REQ           EQU     %10000000      REQUEST
*
*       HDA-S STATE DEFINITIONS
*
S.SEND          EQU     S.MSG+S.RDWR   SEND COMMAND BYTES
S.WDATA         EQU     S.MSG+S.CMDA+S.RDWR WRITE DATA
S.RDATA         EQU     S.MSG+S.CMDA   READ DATA
S.RSTA          EQU     S.MSG          READ STATUS BYTES
S.DONE          EQU     0              COMMAND SEQUENCE DONE
*
C.FMTD          EQU     %00000100      FORMAT DRIVE
        PAGE
*
*       SELECT THE TARGET
*
WDSELECT
        LDA     S.STAT                 CHECK TO SEE IF CONTROLLER IS AVAILABLE
        BITA    #S.BUSY
        BNE     WDSELECT1              B/ IT IS
        SWI                            IT ISN'T !???
WDSELECT1
        LDA     #1                     ASSERT THE CONTROLLER ID
        STA     S.DATA
        LDA     S.STAT                 ASSERT SEL
        ORA     #S.SEL
        STA     S.STAT
        LDB     S.STAT                 CHECK TO SEE THAT CONTROLLER ASSERTS BSY
        BITB    #S.BUSY                ...?
        BEQ     WDSELECT2              B/ IT DID
        SWI                            CONTROLLER DID NOT ASSERT BUSY
WDSELECT2
        EORA    #S.SEL                 DEASSERT SEL
        STA     S.STAT
        LDB     #6
*
*       SEND THE STANDARD 6-BYTE COMMAND (AFTER TARGET SELECTION)
*       THESE SIGNALS ARE CONSTANT THROUGHOUT THIS SEQUENCE:
*       SEL HIGH, BSY LOW, C/D LOW, I/O HIGH, MSG HIGH
*       FOR EACH BYTE TRANSFER, TARGET ASSERTS (MAKES LOW) REQ,
*       HOST OUTPUTS DATA BYTES, HOST ASSERTS ACK, TARGET RECEIVES
*       DATA BYTES, TARGET DEASSERTS REQ.
*
WDSENDCMD
        BSR     WDLOOPINIT
WDSENDCMD1
        LDA     S.STAT
        DEC     WDLOOPCOUNT
        BEQ     WDLOOPTIMEDOUT         B/ TIMED OUT
        ANDA    #S.REQ+S.MSG+S.CMDA+S.RDWR+S.BUSY
        CMPA    #S.SEND
        BNE     WDSENDCMD1             B/ REQ NOT ASSERTED
        LDA     ,U+                    OUTPUT A COMMAND BYTE
        STA     S.DATA
        DECB                           DONE YET?
        BNE     WDSENDCMD1             B/ NO
        RTS                            YES, DONE
*
WDLOOPINIT
        LDA     #60
        STA     WDLOOPCOUNT
        RTS
        page
WDLOOPTIMEDOUT
        lds     wdstack
        ldx     #err:devicetimedout
        sec
        rts
*
*       call formatwinchester
*
formatwinchester
        ldx     #err:argcount
        tsta                           right number of args?
        bne     wdformaterror          b/ no
        ldx     #err:diskformatprot
        lda     d.sense                check format protect
        bita    #s.hdasfp              
        bne     wdformaterror          b/ format protected
        ldu     #wdformat              all systems go
        sts     wdstack                for error recovery
        bsr     wdselect               send the command to the controller
*
*       wait for format done
*
        ldy     #0000                  timeout counter
        clrb                           timeout counter
        ldx     #err:devicetimedout
wdformatwaitdone
        lda     s.stat                 (5~) see if format is done
        anda    #s.req+s.msg+s.cmda+s.rdwr+s.busy (2~)
        cmpa    #s.rsta                (2~)
        beq     wdformatdone           (3~) b/ done, go finish up
        decb                           (2~)
        bne     wdformatwaitdone       (3~) /= 15*256=3840~
        leay    -1,y                   (5~)
        bne     wdformatwaitdone       (3~) /= 3848*65536= 126 sec
wdformaterror
        sec
        rts
*
*       format is done, finish up
*
wdformatdone
        bsr     wdcomplete             finish up
        clra
        tfr     d,x
        cmpx    #0000                  any errors?
        bne     wdformaterror
        clc
        rts
        PAGE
*
*       COME HERE AFTER DATA TRANSFER IS COMPLETE
*       GET STATUS BYTE FROM THE TARGET. ASSERT TARGET IS SELECTED
*       AND THE DATA TRANSFER TO/FROM THE HOST IS COMPLETE.
*       THESE SIGNALS ARE CONSTANT THROUGHOUT THIS SEQUENCE:
*       SEL HIGH, BSY LOW, C/D LOW, I/O LOW, MSG HIGH
*       FOR STATUS BYTE TRANSFER, TARGET OUTPUTS STATUS BYTE,
*       TARGET ASSERTS (MAKES LOW) REQ, HOST READS STATUS BYTE,
*       HOST ASSERTS ACK, TARGET DEASSERTS REQ.
*
WDCOMPLETE
        BSR     WDLOOPINIT
WDCOMPLETE1
        LDA     S.STAT                 SEE IF STATUS BYTE IS READY
        DEC     WDLOOPCOUNT
        BEQ     WDLOOPTIMEDOUT         B/ TIMED OUT
        ANDA    #S.REQ+S.MSG+S.CMDA+S.RDWR+S.BUSY
        CMPA    #S.RSTA
        BNE     WDCOMPLETE1            B/ REQ NOT ASSERTED
        LDB     S.DATA                 READ STATUS BYTE
*
*       GET MESSAGE BYTE FROM THE TARGET.
*       THESE SIGNALS ARE CONSTANT THROUGHOUT THIS SEQUENCE:
*       SEL HIGH, BSY LOW, C/D LOW, I/O LOW, MSG LOW
*       FOR MESSAGE BYTE TRANSFER, TARGET OUTPUTS MESSAGE BYTE,
*       TARGET ASSERTS (MAKES LOW) REQ, HOST READS MESSAGE BYTE,
*       HOST ASSERTS ACK, TARGET DEASSERTS REQ.
*
WDCOMPLETE2
        LDA     S.STAT                 SEE IF STATUS BYTE IS READY
        DEC     WDLOOPCOUNT
        BEQ     WDLOOPTIMEDOUT         B/ TIMED OUT
        ANDA    #S.REQ+S.MSG+S.CMDA+S.RDWR+S.BUSY
        CMPA    #S.DONE
        BNE     WDCOMPLETE2            B/ REQ NOT ASSERTED
        LDA     S.DATA                 READ MESSAGE BYTE
*
*       IGNORE THE MESSAGE BYTE (ALL ZEROES)
*       CHECK STATUS BYTE FOR ERROR
*
        BITB    #%00000010             ANY ERRORS?
        RTS
*
wdloopcount     rmb     1              timeout counter
wdstack         rmb     2
*
WDFORMAT
        FCB     C.FMTD
        FCB     0                      LUN
        FCB     0                      UNUSED
        FCB     0                      UNUSED
        FCB     1                      INTERLEAVE FACTOR
        FCB     0                      CONTROL FIELD
*
        END
