        REM ********** BASIC RUNTIME PACKAGE TEST **********
        REM ***** PART 1 OF 3 PARTS *****
        REM THIS PROGRAM TESTS "BASRTP14L" FOR 6800/6809 MICROCOMPUTERS
        REM COPYRIGHT (C) 1977 SOFTWARE DYNAMICS
        REM ALL RIGHTS RESERVED
        REM 1/28/85 20:00

        REM TEST RUNTIME PACKAGE OPCODES
        REM IF INPUT IS NULL, TESTS ALL OPCODES
        REM PROMPTS FOR OPCODE NUMBER (SEE LIST OF OPCODES IN BASIC COMPILER)
        REM REQUIRES I/O DEVICE WITH POSITION$ CAPABILITY AND READ/WRITE
        REM LINES WHICH TEST OPCODE NUMBER XXX...
        REM ARE LINES XXX00 THRU XXX99
        REM OPCODE 0 IS TESTED IN LINES 100-149
        REM OPCODE 1 IS TESTED IN LINES 150-199
        REM EACH OPCODE TEST ASSUMES ALL OTHER OPCODES WORK PROPERLY

        PROGRAM ORIGIN :3800
        CONCATENATION BUFFER SIZE = 100
        REM DATA STORAGE
        DATA ORIGIN :2F00
        COMMON CHNTST,CHNTST$(3),COMMONVARIABLE

        DIM SCALAR,OPCODE$[10],OPCODE,V[100],S$/:1,"HELLO"/,T$[2]
        DIM U$[258],A[3,5],NEGONE/-1/,T/1/,EPSILON/1E-8/
        DIM SIX$[6],ZEROLEN$[0],ONELEN$[1]
        DIM UNIQUE$/"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"/
        DIM JUNKFILE$/"JUNK"/
        DIM I,J,K,L,X,Y

        REM SET UP 65 SCALARS TO TEST OPLESCALAR, OPSESCALAR
        DIM SCALAR0,SCALAR1,SCALAR2,SCALAR3,SCALAR4,SCALAR5,SCALAR6,SCALAR7
        DIM SCALAR8,SCALAR9,SCALAR10,SCALAR11,SCALAR12,SCALAR13,SCALAR14,SCALAR15
        DIM SCALAR16,SCALAR17,SCALAR18,SCALAR19,SCALAR20,SCALAR21,SCALAR22,SCALAR23
        DIM SCALAR24,SCALAR25,SCALAR26,SCALAR27,SCALAR28,SCALAR29,SCALAR30,SCALAR31
        DIM SCALAR32,SCALAR33,SCALAR34,SCALAR35,SCALAR36,SCALAR37,SCALAR38,SCALAR39
        DIM SCALAR40,SCALAR41,SCALAR42,SCALAR43,SCALAR44,SCALAR45,SCALAR46,SCALAR47
        DIM SCALAR48,SCALAR49,SCALAR50,SCALAR51,SCALAR52,SCALAR53,SCALAR54,SCALAR55
        DIM SCALAR56,SCALAR57,SCALAR58,SCALAR59,SCALAR60,SCALAR61,SCALAR62,SCALAR63
        DIM SCALAR64,SCALAR65

50      REM INITIALIZE
        PRINT "*** RUNTIME PACKAGE DIAGNOSTIC PART 1 (BASRTP14L) ***"

        PRINT "TESTING LOAD/STORE SCALAR (:80/:C0+...) OPCODE"
        LET OPCODE=:80
        LET SCALAR=1\IF SCALAR<>1 THEN GOSUB 99
        LET SCALAR=-1\IF SCALAR<>-1 THEN GOSUB 99
        LET SCALAR=17.0000001\IF SCALAR<>17.0000001 THEN GOSUB 99
        LET SCALAR=SCALAR-.0000001\IF SCALAR<>17 THEN GOSUB 99
        PRINT "LOAD/STORE SCALAR TEST COMPLETE"

        PRINT "TO TEST ALL OPCODES, TYPE <CR>"
        PRINT "TO TEST A SPECIFIC OPCODE 'X', TYPE 'X'"
        PRINT "TO TEST ALL OPCODES > X, TYPE '>X'"
        CREATE #T,JUNKFILE$\ ! A SCRATCH PLACE TO READ AND WRITE
        PRINT #T\ ! WRITE SOMETHING FOR SUBR 91 TO READ
        RESTORE #T,0\ !SET UP FOR SUBR 91

90      REM THIS IS WHERE WE ASK...
        ON ERROR GOTO 96
        INPUT "WHICH OPCODE ? " OPCODE$
        IF UPPERCASE$(OPCODE$)="STOP" THEN STOP
        IF LEN(OPCODE$)=0
        THEN
                FOR OPCODE = 0 TO 66
                        PRINT OPCODE
                        GOSUB 95
                NEXT OPCODE
                PRINT
                PRINT '***DIAGNOSTIC PART 1 COMPLETED***'
                LET CHNTST=:B27A
                LET CHNTST$="RAT"
                PRINT "CHAINING TO BASRTP14LT2..."
                CHAIN "BASRTP14LT2"
                PRINT "*** FAILED TO CHAIN! ***"
                STOP
        ELSE
                IF OPCODE$[1]=ASC(">")
                THEN
                        FOR OPCODE=VAL(RIGHT$(OPCODE$,2))+1 TO 66
                                PRINT OPCODE
                                GOSUB 95
                        NEXT OPCODE
                        PRINT
                        PRINT 'PARTIAL TEST COMPLETED'
                ELSE
                        OPCODE = VAL(OPCODE$)
                        GOSUB 95
                        PRINT "TEST COMPLETED"
                FI
        FI
        GOTO 90

91      REM SUBROUTINE TO INPUT INTO U$ FROM TEMP FILE
        REM AND REWIND TEMP FILE TO BYTE 0
        RESTORE #T,0
        INPUT #T,U$
        RESTORE #T,0
        RETURN

95      REM BRANCH TO OPCODE TEST SUBROUTINE
        RESTORE #T,0\ REM THIS SAVES EVERYBODY ELSE THE TROUBLE
        ON OPCODE+1 GOTO 100,150,200,300,400,500,600,700,800,900,...
&       1000,1100,1200,1300,1400,1500,1600,1700,1800,1900,...
&       2000,2100,2200,2300,2400,2500,2600,2700,2800,2900,...
&       3000,3100,3200,3300,3400,3500,3600,3700,3800,3900,...
&       4000,4100,4200,4300,4400,4500,4600,4700,4800,4900,...
&       5000,5100,5200,5300,5400,5500,5600,5700,5800,5900,...
&       6000,6100,6200,6300,6400,6500,6600
        PRINT "I CAN'T TEST THAT OPCODE IN THIS PART"\ RETURN

96      REM ERROR TRAP ROUTINE
        IF ERR=1 THEN 97
        IF ELN=2110 AND ERR=11 THEN 2120
        IF ELN=2120 AND ERR=11 THEN 2130
        IF ELN=2130 AND ERR=11 THEN 2199
        IF ELN=2210 AND ERR=11 THEN 2220
        IF ELN=2220 AND ERR=11 THEN 2230
        IF ELN=2230 AND ERR=11 THEN 2240
        IF ELN=2240 AND ERR=12 THEN 2299
        IF ELN=2410 AND ERR=9 THEN 2420
        IF ELN=2420 AND ERR=9 THEN 2430
        IF ELN=2430 AND ERR=9 THEN 2440
        IF ELN=2440 AND ERR=9 THEN 2450
        IF ELN=2510 AND ERR=9 THEN 2520
        IF ELN=2520 AND ERR=9 THEN 2530
        IF ELN=2530 AND ERR=9 THEN 2540
        IF ELN=2540 AND ERR=9 THEN 2550
        IF ELN=2810 AND ERR=9 THEN 2820
        IF ELN=2820 AND ERR=9 THEN 2830
        IF ELN=2830 AND ERR=9 THEN 2840
        IF ELN=2840 AND ERR=9 THEN 2850
        IF ELN=2850 AND ERR=9 THEN 2899
        IF ELN=2910 AND ERR=9 THEN 2920
        IF ELN=2920 AND ERR=9 THEN 2930
        IF ELN=2930 AND ERR=9 THEN 2940
        IF ELN=2940 AND ERR=9 THEN 2950
        IF ELN=2950 AND ERR=9 THEN 2999
        IF ELN=3410 AND ERR=14 THEN 3420
        IF ELN=3420 AND ERR=14 THEN 3499
        IF ELN=3510 AND ERR=14 THEN 3520
        IF ELN=3520 AND ERR=14 THEN 3599
        IF ELN=3710 AND ERR=14 THEN 3799
        IF ELN=3810 AND ERR=14 THEN 3820
        IF ELN=3820 AND ERR=14 THEN 3899
        IF ELN=3910 AND ERR=15 THEN 3920
        IF ELN=3920 AND ERR=15 THEN 3999
        IF ELN=4010 AND ERR=15 THEN 4020
        IF ELN=4020 AND ERR=15 THEN 4099
        IF ELN=4110 AND ERR=15 THEN 4199
        IF ELN=4210 AND ERR=15 THEN 4299
        IF ELN=5000 AND ERR=14 THEN 5010
        IF ELN=5310 AND ERR=14 THEN 5320
        IF ELN=5321 AND ERR=6 THEN 5330
        IF ELN=5410 AND ERR=6 THEN 5411
        IF ELN=5600 AND ERR=14 THEN 5699
        IF ELN=5860 AND ( ERR=1032 OR 1030 ) THEN 5899
        IF ELN=6310 AND ERR=50 THEN 6399
        IF ELN=6510 AND ERR=16 THEN 6599
        REM NOT A VALID TRAP!
97      PRINT "ERROR"; ERR; "OCCURRED DURING OPCODE"; OPCODE; "(LINE ";ELN;")"
        GOSUB POP 0
        GOTO 90

99      PRINT "OPCODE"; OPCODE; "FAILED"\ RETURN

        SUBROUTINE TESTRELATIVEERROR(TESTVALUE,ACTUALVALUE,TESTERROR)
        RELATIVEERROR=ABS((TESTVALUE-ACTUALVALUE)/ACTUALVALUE)
        IF RELATIVEERROR>TESTERROR
        THEN PRINT "ERROR TOLERANCE EXCEEDED: ";TESTVALUE;ACTUALVALUE
        IF RELATIVEERROR>MAXRELATIVEERROR
        THEN    MAXRELATIVEERROR=RELATIVEERROR
        EXIT SUBROUTINE
        END

100     REM TEST OPLSMI+0
        REM TEST OPCODE 0
        IF 0<>10-10 THEN GOSUB 99
        RETURN

150     REM TEST OPLSMI+1
        REM TEST OPCODE 1
        IF 1<>11-10 THEN GOSUB 99
        RETURN

200     REM TEST OPLSMI+2
        IF 2<>12-10 THEN GOSUB 99
        RETURN

300     REM TEST OPLSMI+3
        IF 3<>13-10 THEN GOSUB 99
        RETURN

400     REM TEST OPLSMI+4
        IF 4<>14-10 THEN GOSUB 99
        RETURN

500     REM TEST OPLSMI+5
        IF 5<>15-10 THEN GOSUB 99
        RETURN

600     REM TEST OPLSMI+6
        IF 6<>16-10 THEN GOSUB 99
        RETURN

700     REM TEST OPLSMI+7
        IF 7<>17-10 THEN GOSUB 99
        RETURN

800     REM TEST OPLSMI+8
        IF 8<>18-10 THEN GOSUB 99
        RETURN

900     REM TEST OPLSMI+9
        IF 9<>19-10 THEN GOSUB 99
        RETURN

1000    REM TEST OPLOAD
        LET COMMONVARIABLE=5\ IF COMMONVARIABLE<>5 THEN GOSUB 99
        LET COMMONVARIABLE=-5.2\ IF COMMONVARIABLE<>-5.2 THEN GOSUB 99
        RETURN

1100    REM TEST OPLV
        FOR I=-100 TO +100 STEP PI
                CALL TESTOPLV(I)
        NEXT I
        RETURN

SUBROUTINE TESTOPLV(OPLVTESTARG)
        IF OPLVTESTARG<>I THEN GOSUB 99
        EXIT SUBROUTINE
END

1200    REM TEST OPSESCALAR
        LET SCALAR64=0
        IF SCALAR64<>0 THEN GOSUB 99
        LET SCALAR64=4.0
        IF SCALAR64<>4 THEN GOSUB 99
        LET SCALAR64=65536
        IF SCALAR64<>65536 THEN GOSUB 99
        LET SCALAR64=-2.7
        IF SCALAR64<>-2.7 THEN GOSUB 99
        REM TEST THAT SCALARS DON'T OVERLAP
        LET SCALAR65=19.2
        IF SCALAR64<>-2.7 OR SCALAR65<>19.2 THEN GOSUB 99
        RETURN

1300    REM TEST OPLINT
        IF 65535<>1+2+4+8+16+32+64+128+256+512+1024+2048+4096+8192+16384+32768
        THEN GOSUB 99
        REM WHAT DOES THE FOLLOWING TEST DO?
        IF 3-0 <> 3.2-.2 THEN GOSUB 99
1399    RETURN

1400    REM TEST OPLESCALAR
        GOTO 1200

1500    REM TEST OPLFI
        IF 14<>13.1+.9 THEN GOSUB 99
        IF 6-9<>-3.0 THEN GOSUB 99
        RETURN

1600    REM TEST OPLDB
        IF S$[1] <> 1 THEN GOSUB 99
        IF S$[2]<>ASC("H") THEN GOSUB 99
        IF S$(6) <> ASC("O") THEN GOSUB 99
        RETURN

1700    REM TEST OPDUP
        REM COMPILER DOESN'T GENERATE OPDUP NOW...THIS TEST IS WRONG
        FOR I=1 TO 100\ FOR J=1 TO 10\ NEXT J\ NEXT I\ RETURN

1800    REM TEST OPLSD
        IF S$[2,5] <> "HELLO" THEN GOSUB 99
        LET T$=''\ IF LEN(T$) <> 0 THEN GOSUB 99
        LET T$="ABC"\ IF LEN(T$) <> 2 THEN GOSUB 99
        RETURN

1900    REM TEST OPLSC
        IF S$[2,5] <> "HELLO" THEN GOSUB 99
        RETURN

2000    REM TEST OPLEN
        IF LEN(S$) <> 6 THEN GOSUB 99
        LET T$="A"\ IF LEN(T$) <> 1 THEN GOSUB 99
        RETURN

2100    REM TEST OPSS1
        LET LEN(U$)=0
        FOR I=1 TO 100\ LET U$[I]=I\ NEXT I
        LET LEN(U$)=258
        IF U$[ASC("A"),5] <> "ABCDE" THEN GOSUB 99
2110    IF U$[300]*0 = 0 THEN GOSUB 99
2120    IF U$[0]*0 = 0 THEN GOSUB 99
2130    IF U$[-1]*0 = 0 THEN GOSUB 99
2199    RETURN

2200    REM TEST OPSS2
        LET U$=S$
        IF U$[2,5] <> "HELLO" THEN GOSUB 99
        IF U$[300,0] <> '' THEN GOSUB 99
2210    IF U$[300,1] <> '' THEN GOSUB 99
2220    IF U$[0,1] <> '' THEN GOSUB 99
2230    IF U$[-1,1] <> '' THEN GOSUB 99
2240    IF U$[3,5] > '' THEN GOSUB 99
2299    RETURN

2300    REM TEST OPVSA
        FOR I=0 TO 100\V[I]=I+2\NEXT I
        CALL TESTOPVSA(V)
        FOR I=0 TO 100
                IF V[I]<>-I THEN GOSUB 99
        NEXT I
        RETURN

SUBROUTINE TESTOPVSA(TESTOPVSAARG[*])
        IF LEN(TESTOPVSAARG)<>100 THEN GOSUB 99
        FOR I=0 TO LEN(TESTOPVSAARG)
                IF TESTOPVSAARG[I]<>I+2 THEN GOSUB 99
                TESTOPVSAARG[I]=-I
        NEXT I
        EXIT SUBROUTINE
END

2400    REM TEST OPVSV
        FOR I=0 TO 100\ V[I]=I\ NEXT I
        FOR I=0 TO 100
        IF V[I]<>I THEN GOSUB 99\ GOTO 2410
        NEXT I
2410    IF V[-1]*0 = 0 THEN GOSUB 99
2420    IF V[101]*0 = 0 THEN GOSUB 99
2430    IF V[-.500000001]*0 = 0 THEN GOSUB 99
2440    IF V[100.5]*0 = 0 THEN GOSUB 99
2450    FOR I=0 TO 100
        IF V[I-.3] <> I THEN GOSUB 99
        NEXT I
        RETURN

2500    REM TEST OPVSS
        FOR I=0 TO 100 DO V[I]=I+1
        FOR I=0 TO 100 DO IF V[I]<>1+I THEN GOSUB 99\EXIT I
        FOR X=-.5 TO 99.5
                LET V[X]=X+.5
        NEXT X
        FOR I=0 TO 100 DO IF V[I]<>I THEN GOSUB 99\EXIT I
2510    LET V[-1]=0\GOSUB 99
2520    LET V[101]=0\GOSUB 99
2530    LET V[-.500000001]=0\GOSUB 99
2540    LET V[100.5]=0\GOSUB 99
2550    RETURN

2600    REM TEST OPVPA
        FOR I=0 TO LEN(V)\V(I)=I-2\NEXT I
        CALL TESTOPVPA1(V)
        RETURN

SUBROUTINE TESTOPVPA1(TESTOPVPA1ARG[*])
        FOR I=1 TO LEN(TESTOPVPA1ARG)
                CALL TESTOPVPA2(TESTOPVPA1ARG[I],I)
                IF V[I]<>I+.001 THEN GOSUB 99
        NEXT I
        EXIT SUBROUTINE
END

SUBROUTINE TESTOPVPA2(TESTOPVPA2ARG1,TESTOPVPA2ARG2)
        IF TESTOPVPA2ARG1<>V(TESTOPVPA2ARG2) THEN GOSUB 99
        TESTOPVPA2ARG1=TESTOPVPA2ARG2+.001
        EXIT SUBROUTINE
END

2700    REM TEST OPASA
        FOR I=0 TO ROWS(A)\FOR J=0 TO COLUMNS(A)\A(I,J)=J*10+I\NEXT J\ NEXT I
        CALL TESTOPASA(A)
        FOR I=0 TO ROWS(A)
                FOR J=0 TO COLUMNS(A)
                        IF A(I,J)<>I*10+J-1 THEN GOSUB 99
                NEXT J
        NEXT I
        RETURN

SUBROUTINE TESTOPASA(TESTOPASAARG[*,*])
        IF ROWS(TESTOPASAARG)<>ROWS(A) OR COLUMNS(TESTOPASAARG)<>COLUMNS(A) THEN GOSUB 99
        FOR I=0 TO ROWS(TESTOPASAARG)
                FOR J=0 TO COLUMNS(TESTOPASAARG)
                        IF TESTOPASAARG[I,J]<>J*10+I THEN GOSUB 99
                        LET TESTOPASAARG[I,J]=I*10+J-1
                NEXT J
        NEXT I
        EXIT SUBROUTINE
END

2800    REM TEST OPASV
        FOR I=0 TO 3\ FOR J=0 TO 5\ LET A[I,J]=I*10+J\ NEXT J\ NEXT I
        FOR J=5 TO 0 STEP -1
                FOR I=3 TO 0 STEP -1
                        IF A[I-.5,J-.5] <> I*10+J THEN GOSUB 99
                        IF A[I+.4999999999,J+.4999999999] <> I*10+J THEN GOSUB 99
                NEXT I
        NEXT J
2810    IF A[-.500000001,1]*0 = 0 THEN GOSUB 99
2820    IF A[1,-.500000001]*0 = 0 THEN GOSUB 99
2830    IF A[3.5,1]*0 = 0 THEN GOSUB 99
2840    IF A[1,5.5]*0 = 0 THEN GOSUB 99
2850    IF A[13104,5]*0 = 0 THEN GOSUB 99\ ! REM TRY +65536 WORDS
2899    RETURN

2900    REM TEST OPASS
        FOR I=0 TO 3\ FOR J=0 TO 5\ LET A[I,J]=I*10+J\ NEXT J\ NEXT I
        FOR I=0 TO 3 DO FOR J=0 TO 3 DO IF A[I,J]<>I*10+J THEN GOSUB 99
        FOR I=-.5 TO 2.5
                FOR J=4.5 TO -.5 STEP -1
                        LET A[I,J]=I*10+J+5.5+PI
                NEXT J
        NEXT I
        FOR J=5 TO 0 STEP -1
                FOR I=3 TO 0 STEP -1
                        IF A[I,J]<>I*10+J+PI THEN GOSUB 99
                        LET A[I+.4999999999,J+.4999999999]=J*10+I
                NEXT I
        NEXT J
        FOR I=0 TO 3 DO FOR J=0 TO 5 DO IF A[I,J]<>J*10+I THEN GOSUB 99
2910    LET A[-.5000000001,1]=0\GOSUB 99
2920    LET A[1,-.5000000001]=0\GOSUB 99
2930    LET A[3.5,1]=0\ GOSUB 99
2940    LET A[1,5.5]=0\ GOSUB 99
2950    LET A[13104,5]=0\ GOSUB 99\ REM TRY +65536 WORDS
2999    RETURN

3000    REM TEST OPAPA
        FOR I=0 TO ROWS(A)\FOR J=0 TO COLUMNS(A)\A[I,J]=J*7-I\NEXT J\NEXT I
        CALL TESTOPAPA1(A)
        FOR I=0 TO ROWS(A)
                FOR J=0 TO COLUMNS(A)
                        IF A(I,J)<>I*9-J THEN GOSUB 99
                NEXT J
        NEXT I
        RETURN

SUBROUTINE TESTOPAPA1(TESTOPAPA1ARG[*,*])
        FOR I=0 TO ROWS(TESTOPAPA1ARG)
                FOR J=0 TO COLUMNS(TESTOPAPA1ARG)
                        CALL TESTOPAPA2(TESTOPAPA1ARG[I,J],I,J)
                NEXT J
        NEXT I
        EXIT SUBROUTINE
END

SUBROUTINE TESTOPAPA2(TESTOPAPA2ARG1,TESTOPAPA2ARG2,TESTOPAPA2ARG3)
        IF TESTOPAPA2ARG1<>TESTOPAPA2ARG3*7-TESTOPAPA2ARG2 THEN GOSUB 99
        LET TESTOPAPA2ARG1=TESTOPAPA2ARG2*9-TESTOPAPA2ARG3
        EXIT SUBROUTINE
END

3100    REM TEST OPST
        REM TEST OPST ON INTEGER
        FOR I=0 TO 65535 STEP 64
                CALL TESTOPST(J)
                IF I<>J THEN GOSUB 99
        NEXT I
        REM TEST OPST ON FLOAT
        FOR I=-100 TO 100 STEP PI
                CALL TESTOPST(J)
                IF I<>J THEN GOSUB 99
        NEXT I
        RETURN

SUBROUTINE TESTOPST(OPSTARG)
        OPSTARG=I
        EXIT SUBROUTINE
END

3200    REM TEST OPSTS
        LET U$=''
        IF U$ <> '' OR LEN(U$) <> 0 THEN GOSUB 99
        LET U$ = "ABCDEF"
        IF U$ <> "ABCDEF" OR LEN(U$) <> 6 THEN GOSUB 99
        LET U$[3,4]="ZYXV"
        IF LEN(U$)<>6 OR U$[3,4] <> "ZYXV" THEN GOSUB 99
        LET U$[3,4] = "CDEFGH"
        IF U$ <> "ABCDEF" OR LEN(U$) <> 6 THEN GOSUB 99
        LET U$[17,0] = "Q"
        IF U$<> "ABCDEF" OR LEN(U$) <> 6 THEN GOSUB 99
        LET U$[2,3]=U$[3,3]
        IF U$<>"ACDEEF" THEN GOSUB 99
        LET U$[3,3]=U$[2,3]
        IF U$<>"ACCDEF" THEN GOSUB 99
        REM TEST BLANK FILL ON SUBSTRING ASSIGNMENT
        LET U$[2,5]="XYZ"
        IF U$<>"AXYZ  " THEN GOSUB 99
        REM TEST BIG STRING MOVE ROUTINE
        LET LEN(U$)=MAXLEN(U$)
        FOR I=0 TO 33
                FOR J=1 TO MAXLEN(U$) DO U$(J)=0\ REM ZERO OUT U$
                LET U$[1+I,I]=UNIQUE$[1,I]\ REM COPY A STRING INTO U$
                IF U$[1+I,I]<>UNIQUE$[1,I] THEN GOSUB 99
                REM MAKE SURE REST OF U$ HASN'T BEEN DISTURBED
                FOR J=1 TO I DO IF U$(J)<>0 THEN GOSUB 99
                FOR J=1+I+I TO MAXLEN(U$) DO IF U$(J)<>0 THEN GOSUB 99
        NEXT I
        RETURN

3300    REM TEST OPSTB
        LET LEN(U$)=0
        FOR I=1 TO 258
        LET U$[I]=I&:FF
        IF U$[I]<>I&:FF THEN GOSUB 99
        NEXT I
        FOR X=1.1 TO 258.1
                LET U$[X]=(X-.1)&:FF
                IF U$[X]<>(X-.1)&:FF THEN GOSUB 99
        NEXT X
        RETURN
3400   REM TEST OPADD
        IF 0+0<>0 OR 0+1<>1 OR 1+0<>1 OR 27+13<>40 OR 255+1<>256 THEN GOSUB 99
        IF 2+255<>257 OR 15296+31408<>46704 THEN GOSUB 99
        IF 65535+1 <> 65536.0 THEN GOSUB 99
        IF 7.9+1 <> 8.9 THEN GOSUB 99
        REM TEST FLOATING ADD FOR ALL COMBINATIONS OF OPERAND ALIGNMENT
        IF 12.74196839+402.718881<>415.460849 THEN GOSUB 99
        IF 175E42+219E43<>2365E42 THEN GOSUB 99
        IF (-2)+(-3) <> (-5) THEN GOSUB 99
        IF (-45.9237146)+(-27.229) <> -(73.1527146) THEN GOSUB 99
        IF 17+(-65)<>-48 THEN GOSUB 99
        IF (-17983124)+316198342.8 <> 298215218.8 THEN GOSUB 99
        IF 1200+.005<> 1200.005 THEN GOSUB 99
        IF 1E9+1<>1000000001 OR 1E10+1<>1E10 OR 1E11+1<>1E11 THEN GOSUB 99
        IF .5E126+.5E-126<>.5E126 THEN GOSUB 99
        IF 123E-126+(-123.001E-126)<>0 THEN GOSUB 99
        IF 7.9+0<>7.9 OR 0+7.9<>7.9 THEN GOSUB 99
        IF .9999999999+.01<>1.00999999 OR .01+.9999999999<>1.00999999 THEN GOSUB 99
        IF .9999999999+1E-4<>1.00009999 OR 1E-4+.9999999999<>1.00009999 THEN GOSUB 99
        IF .9999999999+1E-6<>1.00000099 OR 1E-6+.9999999999<>1.00000099 THEN GOSUB 99
        IF .9999999999+1E-8<>1 OR 1E-8+.9999999999<>1 THEN GOSUB 99
        IF .9999999999+1E-10<>1 OR 1E-10+.9999999999<>1 THEN GOSUB 99
        IF 1+(-1E-2)<>.99 OR (-1E-2)+1<>.99 THEN GOSUB 99
        IF 1+(-.99)<>.01 OR (-.99)+1<>.01 THEN GOSUB 99
        IF 1+(-.9999)<>1E-4 OR (-.9999)+1<>1E-4 THEN GOSUB 99
        IF 1+(-.999999)<>1E-6 OR (-.999999)+1<>1E-6 THEN GOSUB 99
        IF 1+(-.99999999)<>1E-8 OR (-.99999999)+1<>1E-8 THEN GOSUB 99
        IF 1+(-.9999999999)<>1E-8 OR (-.9999999999)+1<>1E-8 THEN GOSUB 99
        REM *** LOSS OF SIGNIFICANCE MAKES PREVIOUS TEST LOOK FUNNY *** 
        FOR I=0 TO 65535
3405    IF INT(I+.001)<>I THEN GOSUB 99
        NEXT I
3410    IF (.5E126+.5E126)*0=0 THEN GOSUB 99
3420    IF ((-.5E126)+(-.5E126))*0=0 THEN GOSUB 99
3499    RETURN

3500    REM TEST OPSUB
        IF 0-0<>0 OR 1-0<>1 OR 27-13<>14 OR 257-2<>255 THEN GOSUB 99
        IF 46704-31408<>15296 OR INT(65536-1)<>65535 THEN GOSUB 99
        IF 8.9-1<>7.9 THEN GOSUB 99
        IF 415.460849-12.74196839<>402.718881 THEN GOSUB 99
        IF 2365E42-175E42<>219E43 THEN GOSUB 99
        IF (-5)-(-3)<>(-2) THEN GOSUB 99
        IF -73.1527146-(-27.229)<>-(45.9237146) THEN GOSUB 99
        IF -48-(-65)<>-(-17) THEN GOSUB 99
        IF 298215218.8-316198342.8<>-17983124 THEN GOSUB 99
        IF 1200.005-.005<>1200 THEN GOSUB 99
        IF 1000000001-1E9<>1 THEN GOSUB 99
        IF 1E10-1<>1E10 OR 1E11-1<>1E11 THEN GOSUB 99
        IF .5E126-.5E-126<>.5E126 THEN GOSUB 99
        IF 123E-126-123.001E-126<>0 THEN GOSUB 99
        IF 7.9-0<>7.9 OR 0-7.9<>-7.9 THEN GOSUB 99
3510    IF (.5E126-(-.5E126))*0=0 THEN GOSUB 99
3520    IF ((-.5E126)-.5E126)*0=0 THEN GOSUB 99
3599    RETURN

3600    REM TEST OPNEG
        IF -0<>0 THEN GOSUB 99
        IF -1 <> NEGONE OR -(20+10)<>-20-10 THEN GOSUB 99
        IF (-.5E126)+.5E126<>0 THEN GOSUB 99
        IF -(12.0073)+12.0073<>0 THEN GOSUB 99
        IF -1+-1+-1<>0-3 THEN GOSUB 99
        IF -(-(-4))<>0-4 THEN GOSUB 99
        IF -(65535)<>0-65535 THEN GOSUB 99
        IF -65536<>0-65536 THEN GOSUB 99
        IF .9999999999E126<>-(-(.9999999999E126)) THEN GOSUB 99
        RETURN

3700    REM TEST OPMUL
        IF 0*0<>0 OR 0*1<>0 OR 1*0<>0 OR 12*43<>516 THEN GOSUB 99
        IF 65535<>5*3*4369 THEN GOSUB 99
        IF 2102*174<>365748 THEN GOSUB 99
        IF 1.7550018E-4*567.890123<>.0996648188 THEN GOSUB 99
        IF 1E17*1E-23<>1E-6 THEN GOSUB 99
        IF .9999999999E63*.9999999999E63<>.999999998E126 THEN GOSUB 99
        IF 10.0010001*3456<>34563.45634 THEN GOSUB 99
        IF -1*1<>-1 OR 1*1<>1 OR 1*-1<>-1 OR -1*-1<>1 THEN GOSUB 99
        IF -272.96*341<>-93079.36 THEN GOSUB 99
        IF 1E-64*1.01E-65<>0 THEN GOSUB 99
        IF 0*.12341341E42<>0 THEN GOSUB 99
        IF .9383824724*0<>0 THEN GOSUB 99
        REM COMPUTE ERROR IN MULTIPLY
        LET RND=PI\ REM MAKE IT REPEAT THE SEQUENCE!
        LET MAXRELATIVEERROR=0
        FOR I=1 TO 1000
                LET X=INT(RND*9999999999)
                LET Y=INT(RND*9999999999)
                LET XTIMESY=X*Y
                REM NOW COMPUTE A BEST APPROXIMATION OF X*Y
                LET X0=X
                LET XRECONSTRUCTED=0
                LET TWOTOJ=1
                LET PRODUCT14=0\PRODUCT7=0\PRODUCT0=0\ REM ZERO THE TRIPLE PRECISION ACCUMULATOR
                REM PLACE Y INTO TRIPLE PRECISION ACCUMULATOR
                LET Y14=0\Y7=INT(Y/1E7)\Y0=Y-Y7*1E7
                FOR J=0 TO 34 \ REM # BITS
                        LET BIT=X0-(INT(X0/2)+INT(X0/2))
                        LET X0=(X0-BIT)/2
                        IF BIT
                        THEN
                                XRECONSTRUCTED=XRECONSTRUCTED+TWOTOJ
                                REM ADD Y ACCUMULATOR TO PRODUCT ACCUMULATOR
                                LET PRODUCT0=PRODUCT0+Y0
                                LET PRODUCT7=PRODUCT7+Y7
                                LET PRODUCT14=PRODUCT14+Y14
                                REM PROPOGATE THE CARRIES BETWEEN THE PRODUCT ACCUMULATOR PARTS
                                IF PRODUCT0>=1E7 THEN PRODUCT7=PRODUCT7+1\ PRODUCT0=PRODUCT0-1E7
                                IF PRODUCT7>=1E7 THEN PRODUCT14=PRODUCT14+1\ PRODUCT7=PRODUCT7-1E7
                        FI
                        TWOTOJ=TWOTOJ+TWOTOJ
                        REM DOUBLE THE Y ACCUMULATOR
                        LET Y0=Y0+Y0\Y7=Y7+Y7\Y14=Y14+Y14
                        IF Y0>=1E7 THEN Y7=Y7+1\Y0=Y0-1E7
                        IF Y7>=1E7 THEN Y14=Y14+1\Y7=Y7-1E7
                NEXT J
                IF XRECONSTRUCTED<>X THEN GOSUB 99
                REM COMPUTE ERROR IN ACTUAL PRODUCT
                LET MULTIPLYERROR=ABS(XTIMESY-1E14*PRODUCT14-1E7*PRODUCT7-PRODUCT0)
                XTIMESYACCURATE=((PRODUCT0+PRODUCT7*1E7)+PRODUCT14*1E14)
                RELATIVEERROR=ABS(MULTIPLYERROR/XTIMESY)
                IF RELATIVEERROR>EPSILON
                THEN PRINT "ERROR TOLERANCE EXCEEDED: ";XTIMESY;XTIMESYACCURATE
                IF RELATIVEERROR>MAXRELATIVEERROR
                THEN    MAXRELATIVEERROR=RELATIVEERROR
        NEXT I
        PRINT "MULTIPLY TEST MAX ERROR = "; MAXRELATIVEERROR
3710    IF (-1.00000001E63*.9999999999E63)*0=0 THEN GOSUB 99
3799    RETURN

3800    REM TEST OPDIV
        REM FIRST TEST DIVIDE BY 2^K
        IF 1/1<>1 OR 4/2<>2 OR 16/4<>4 OR 256/8<>32 OR 32768/16384<>2 THEN GOSUB 99
        REM NOW TEST OTHER DIVIDE CASES
        IF 0/1<>0 OR 0/29.4066E-22<>0 THEN GOSUB 99
        IF 65535/15<>4369 OR 365748/2102<>174 THEN GOSUB 99
        IF .0996648188/567.890123<>1.75500179E-4 THEN GOSUB 99
        IF 1E-6/1E-23<>1E17 THEN GOSUB 99
        IF .9999999999E126/1.00000001E63<>.999999989E63 THEN GOSUB 99
        IF 345634.5634/10.0010001<>34559.9999 THEN GOSUB 99
        IF -1/1<>-1 OR 1/1<>1 OR 1/-1<>-1 OR -1/-1<>1 THEN GOSUB 99
        IF 2102/12.9<>162.9457364 THEN GOSUB 99
        IF -93079.36/341<>-272.96 THEN GOSUB 99
        IF 123.456E-10/123.456001E+116<>.9999999918E-126 THEN GOSUB 99
        IF 1.23456E-10/123.456001E116<>0 THEN GOSUB 99
        REM CHECK MULTIPLY TEST "XRECONSTRUCTED"
        LET RND=PI\ REM MAKE IT REPEAT THE SEQUENCE!
        FOR I=1 TO 100
                LET X=INT(RND*99999999)
3802            IF (X+X)/2<>X THEN GOSUB 99
        NEXT I
        REM COMPUTE MAX RELATIVE ERROR IN DIVIDE
        MAXRELATIVEERROR=0
        FOR I=1 TO 1000
3805            LET X=RND\ LET Y=RND
                IF Y<>0
                THEN
                        CALL TESTRELATIVEERROR((X*Y)/Y,X,2*EPSILON)
                FI
                LET X=INT(65536*X)\ LET Y=INT(65536*Y)
                IF X*Y/Y<>X THEN GOSUB 99
        NEXT I
        PRINT "DIVIDE TEST MAX ERROR = "; MAXRELATIVEERROR
3810    IF (-1.00000001E63/.9999999999E-63)*0=0 THEN GOSUB 99
3820    IF (.9999999999E-126/0)*0=0 THEN GOSUB 99
3899    RETURN

3900    REM TEST OPAND
        IF 0&:FFFF<>0 OR :FFFF&:0<>0 OR :FFFF&:AAAA<>:AAAA THEN GOSUB 99
        IF :FFFF&:5555<>:5555 OR :FC96&:147A<>:1412 THEN GOSUB 99
        IF (3.2-.2)&:FF<>3 THEN GOSUB 99
        IF :FF&(3.2-.2)<>3 THEN GOSUB 99
3910    IF ((-2)&3)*0=0 THEN GOSUB 99
3920    IF (9&7.2)*0=0 THEN GOSUB 99
3999    RETURN

4000    REM TEST OPIOR
        IF 0!:FFFF<>:FFFF OR :FFFF!0<>:FFFF THEN GOSUB 99
        IF :FFFF!:FFFF<>:FFFF OR :AAAA!:5555<>:FFFF THEN GOSUB 99
        IF :1412!:4478<>:547A THEN GOSUB 99
        IF (3.2-.2)!5<>7 THEN GOSUB 99
        IF 5!(3.2-.2)<>7 THEN GOSUB 99
4010    IF ((-2)!3)*0=0 THEN GOSUB 99
4020    IF (9!7.2)*0=0 THEN GOSUB 99
4099    RETURN

4100    REM TEST OPSHF
        IF 1**0<>1 OR 1**1<>2 OR 1**4<>16 OR 1**8<>256 THEN GOSUB 99
        IF 1**15<>32768 OR 1**16<>0 THEN GOSUB 99
        IF 256**2<>1024 OR 256**-4<>16 OR 256**-9<>0 THEN GOSUB 99
        IF 12**3.2<>96 THEN GOSUB 99
        IF (3.9-.9)**0<>3 THEN GOSUB 99
4110    IF (3.9**1)*0=0 THEN GOSUB 99
4199    RETURN

4200    REM TEST OPCOM
        IF COM(0)<>:FFFF OR COM(65535)<>0 OR COM(:5A5A)<>:A5A5 THEN GOSUB 99
        IF COM(3.2-.2)<>:FFFF-3 THEN GOSUB 99
4210    IF COM(2.1)*0=0 THEN GOSUB 99
4299    RETURN

4300    REM TEST OPEQ
        IF 0=1 OR 256=0 THEN GOSUB 99
        IF NOT( 0=0 AND 259=259 ) THEN GOSUB 99
        IF NOT( PI=3.14159265 AND -5.2=-(5.2) ) THEN GOSUB 99
        IF NOT( 200=200.0 AND 65535.0=65535 ) THEN GOSUB 99
        IF -5=5 OR 48.00000001=48 THEN GOSUB 99
        IF -.999999999E48=-.999999998E48 THEN GOSUB 99
        IF 1E-125=1E125 OR 5E125=-5E125 THEN GOSUB 99
        RETURN

4400    REM TEST OPNE
        IF NOT( 0<>1 AND 256<>0 ) THEN GOSUB 99
        IF 0<>0 OR 259<>259 THEN GOSUB 99
        IF PI<>3.14159265 OR -5.2<>-(5.2) THEN GOSUB 99
        IF 200<>200.0 OR 65535.0<>65535 THEN GOSUB 99
        IF NOT( -5<>5 AND 48.00000001<>48 ) THEN GOSUB 99
        IF NOT( -.999999999E48<>-.999999998E48 ) THEN GOSUB 99
        IF NOT( 1E-125<>1E125 AND 5E125<>-5E125 ) THEN GOSUB 99
        RETURN

4500    REM TEST OPLT
        IF 1<0 OR 256<0 OR 354<259 OR 0<0 OR 259<259 THEN GOSUB 99
        IF 32768<32767 OR 65535<0 THEN GOSUB 99
        IF PI<3.14159265 OR -5.2<-(5.2) THEN GOSUB 99
        IF 200<200.0 OR 65535.0<65535 THEN GOSUB 99
        IF 5<-5 OR 48.0000001<48 THEN GOSUB 99
        IF -5<-7 OR .999999999E48<.999999998E48 THEN GOSUB 99
        IF 1E125<1E-125 OR 5E125<-5E125 THEN GOSUB 99
        IF NOT( 0<1 AND 0<256 AND 259<354 ) THEN GOSUB 99
        IF NOT( 48<48.00000001 AND 47.99999999<48 ) THEN GOSUB 99
        IF NOT( 47.99999999<48.00000001 AND -7<-5 ) THEN GOSUB 99
        IF NOT( .9999999998E48<.9999999999E48 ) THEN GOSUB 99
        IF NOT( 1E-125<1E125 AND -1E125<-1E-125 ) THEN GOSUB 99
        IF NOT( -9E125<-5E125 AND -7<5.2 AND -5.2<7 ) THEN GOSUB 99
        RETURN

4600    REM TEST OPLE
        IF 1<=0 OR 256<=0 OR 354<=259 THEN GOSUB 99
        IF 32768<=32767 OR 65535<=0 THEN GOSUB 99
        IF 48.00000001<=48 OR -5<=-7 THEN GOSUB 99
        IF .9999999999E48<=.999999998E48 THEN GOSUB 99
        IF 1E125<=1E-125 OR 5E125<=-5E125 THEN GOSUB 99
        IF NOT( 0<=1 AND 0<=256 AND 259<=354 ) THEN GOSUB 99
        IF NOT( 0<=0 AND 259<=259 ) THEN GOSUB 99
        IF NOT( PI<=3.14159265 AND -5.2<=-(5.2) ) THEN GOSUB 99
        IF NOT( 200<=200.0 AND 65535.0<=65535 ) THEN GOSUB 99
        IF NOT( -5<5 AND 48<=48.0000000001 ) THEN GOSUB 99
        IF NOT( -7<=-5 AND .9999999998E48<=.9999999999E48 ) THEN GOSUB 99
        IF NOT( 1E-125<=1E125 AND -5E125<=5E125 ) THEN GOSUB 99
        IF NOT( -7<=5.2 AND -5.2<=7 ) THEN GOSUB 99
        RETURN

4700    REM TEST OPGE
        IF 0>=1 OR 0>=256 OR 259>=354 THEN GOSUB 99
        IF 32767>=32768 OR 0>=65535 THEN GOSUB 99
        IF 48>=48.00000001 OR -7>=-5 THEN GOSUB 99
        IF .999999998E48>=.999999999E48 THEN GOSUB 99
        IF 1E-125>=1E125 OR -5E125>=5E125 THEN GOSUB 99
        IF NOT( 1>=0 AND 256>=0 AND 354>=259 ) THEN GOSUB 99
        IF NOT( 0>=0 AND 259>=259 ) THEN GOSUB 99
        IF NOT( PI>=3.14159265 AND -5.2>=-(5.2) ) THEN GOSUB 99
        IF NOT( 200>=200.0 AND 65535.0>=65535 ) THEN GOSUB 99
        IF NOT( 5>=-5 AND 48.00000001>=48 ) THEN GOSUB 99
        IF NOT( -5>=-7 AND .9999999999E48>=.999999998E48 ) THEN GOSUB 99
        IF NOT( 1E125>=1E-125 AND 5E125>=-5E125 ) THEN GOSUB 99
        IF NOT( 5.2>=-7 AND 7>=-5.2 ) THEN GOSUB 99
        RETURN

4800    REM TEST OPGT
        IF 0>1 OR 0>256 OR 259>354 THEN GOSUB 99
        IF 0>0 OR 259>259 THEN GOSUB 99
        IF 32767>32768 OR 0>65535 THEN GOSUB 99
        IF 3.14159265>PI OR -5.2>-(5.2) THEN GOSUB 99
        IF 200.0>200 OR 65535>65535.0 THEN GOSUB 99
        IF -5>5 OR 48>48.00000001 THEN GOSUB 99
        IF -7>-5 OR .9999999998E48>.9999999999E48 THEN GOSUB 99
        IF 1E-125>1E125 OR -5E125>5E125 THEN GOSUB 99
        IF NOT( 1>0 AND 256>0 AND 354>259 ) THEN GOSUB 99
        IF NOT( 48.00000001>48 AND 48>47.99999999 ) THEN GOSUB 99
        IF NOT( 48.00000001>47.99999999 AND -5>-7 ) THEN GOSUB 99
        IF NOT( .9999999999E48>.9999999998E48 ) THEN GOSUB 99
        IF NOT( 1E125>1E-125 AND -1E-125>-1E125 ) THEN GOSUB 99
        IF NOT( -5E125 > -9E125 AND 5.2>-7 AND 7>-5.2 ) THEN GOSUB 99
        RETURN

4900    REM TEST OPBF
        IF 1=0 THEN GOSUB 99
        IF 1=1 THEN RETURN ELSE GOSUB 99
        IF 1=1
        THEN LET I=0
        ELSE GOSUB 99
        IF 0=0
        THEN LET I=0\J=0
        ELSE GOSUB 99
        WHILE I<>0 DO PRINT 1/0 END
        WHILE I=0 DO IF I=0 THEN 4910 ELSE PRINT 1/0 END
4910    WHILE I<10 DO J=J+I\I=I+1 END
        IF J<>45 THEN GOSUB 99
        WHILE 0=1 DO
                PRINT 1/0
                LET I=1/0
        END
        RETURN

5000    REM TEST OPBT
        IF 1=0 OR 1/0=0 THEN GOSUB 99 ELSE GOSUB 99
5010    IF 1=1 OR 1/0=0 THEN RETURN ELSE GOSUB 99
        RETURN

5100    REM TEST OPINV
        IF NOT( 0=0 ) THEN GOSUB 99
        IF NOT( 0=1 ) THEN RETURN ELSE GOSUB 99
        RETURN

5200    REM TEST OPJMP
        LET X=1\ GOTO 5210
        LET X=0
5210    IF X<>1 THEN GOSUB 99
        RETURN

5300    REM TEST OPGSB
        LET X=0
        GOSUB 5390\ IF X<>1 THEN GOSUB 99
        Y=0\GOSUB 5385 \ REM TEST GOSUB NESTING
        IF Y<>1*2*3*4*5*6*7*8*9*10 THEN GOSUB 99
5310    REM TEST STORAGE OF CURRENT LINE # BY GOSUB ON ERROR REPORTING
        GOSUB 5399\ LET X=1/0\ GOSUB 99
        RETURN
5320    REM TEST GOSUBS IN MAINLINE ARE NOT KNOWN TO CALLED PROCEDURE
        GOSUB 5321
        GOTO 5330
5321    CALL TESTOPGSB1(X)
        RETURN
        GOSUB 99

5330    REM TEST GOSUB IN PROCEDURE1 DOESN'T AFFECT GOSUB IN PROCEDURE2
        CALL TESTOPGSB2(X)
        RETURN

5340    REM TEST RETURN W/O GOSUB IN MAIN UNAFFECTED BY UNMATCHED GOSUB...
        REM IN CALLED PROCEDURE
        CALL PROCEDURETOPUSHUNMATCHEDGOSUB
5345    RETURN\ REM SHOULD TRAP
        GOSUB 99
        RETURN

SUBROUTINE PROCEDURETOPUSHUNMATCHEDGOSUB
        GOSUB 5350
        GOSUB 99
5350    EXIT SUBROUTINE
END

5385    IF X<10 THEN X=X+1\ GOSUB 5385 ELSE Y=1
        Y=Y*X\X=X-1\RETURN
5390    LET X=1
5399    RETURN

SUBROUTINE TESTOPGSB1(TESTOPGSB1ARG)
        RETURN\ REM SHOULD TRAP
        GOSUB 99
        EXIT SUBROUTINE
END

SUBROUTINE TESTOPGSB2(TESTOPGSB2ARG)
        GOSUB 5341
        IF X<>0 THEN GOSUB 99
        EXIT SUBROUTINE
5341    X=3
        CALL TESTOPGSB3(X)
        IF X<>2 THEN GOSUB 99
        X=0
        RETURN
        GOSUB 99
END

SUBROUTINE TESTOPGSB3(TESTOPGSB3ARG)
        IF X<>3 THEN GOSUB 99
        X=2
        GOSUB 5342\ REM PUSH EXTRANEOUS GOSUB
        X=1
5342    IF X<>2 THEN GOSUB 99
        EXIT SUBROUTINE
END

5400    REM TEST OPRET
        REM TEST 1 LEVEL OF NESTING
        X=0
        GOSUB 5490
        IF X<>1 THEN GOSUB 99
        REM TEST SEVERAL LEVELS OF NESTING
        GOSUB 5470
        IF X<>31 THEN GOSUB 99
        IF OPCODE$='' OR OPCODE$[1]=ASC(">")
        THEN    PRINT "MUST TEST RETURN WITH NO GOSUB BY ITSELF"\ RETURN
        GOSUB POP 0
5410    RETURN
        GOSUB 99
5411    PRINT "TEST COMPLETED"
        GOTO 90
5470    LET X=X+2
        GOSUB 5471
        RETURN
        GOSUB 99
        STOP

5471    LET X=X+4
        GOSUB 5472
        RETURN
        GOSUB 99
        STOP

5472    LET X=X+8
        GOSUB 5473
        RETURN
        GOSUB 99
        STOP

5473    LET X=X+16
        RETURN
        GOSUB 99
        STOP

5490    LET X=1\RETURN\ GOSUB 99\ STOP

5500    REM TEST OPSTP
        IF OPCODE$='' OR OPCODE$[1]=ASC(">")
        THEN
                PRINT "'STOP' OPCODE MUST BE TESTED BY ITSELF"
        ELSE
                PRINT "Should 'STOP at 5500'"
                stop
                GOSUB 99
        fi
        RETURN

5600    REM TEST OPLINE
        LET X=1/0
5610    GOSUB 99
5699    RETURN

5700    REM TEST OPCALL
        REM COMPILER USES OPCALL TO CALL COMPILED BASIC SUBROUTINES
        REM TEST DOES IT WORK AT ALL
        LET X=0
        CALL CALLTEST1(5)
        IF X<>5 THEN GOSUB 99
        REM TEST MULTIPLE ARGUMENTS
        CALL CALLTEST3(1,2,3)
        PRINT "WHO TESTS ERROR PROPOGATION??"
        IF X<>6 THEN GOSUB 99
5710    REM TEST WRONG NUMBER OF ARGUMENTS
        IF OPCODE$='' OR OPCODE$[1]=ASC(">")
        THEN    PRINT "MUST TEST WRONG ARGUMENT COUNT BY ITSELF"
        ELSE
                PRINT "Should give 'Error 27 @ 5710'"
                CALL CALLTEST1(2,3)
                GOSUB 99
        FI
        RETURN

SUBROUTINE CALLTEST1(ARG1)
        LET X=ARG1
        EXIT SUBROUTINE
        END

SUBROUTINE CALLTEST3(ARG1A,ARG2A,ARG3A)
        IF ARG1A<>1 OR ARG2A<>2 OR ARG3A<>3 THEN GOSUB 99
        LET X=ARG1A*ARG2A*ARG3A
        EXIT SUBROUTINE
        END


5800    REM TEST OPPV
        PRINT #T,0\GOSUB 91
        IF U$<>" 0" THEN GOSUB 99
        PRINT #T,45\GOSUB 91
        IF U$<>" 45" THEN GOSUB 99
        PRINT #T,65535\GOSUB 91
        IF U$<>" 65535" THEN GOSUB 99
        PRINT #T,0.0\GOSUB 91
        IF U$<>" 0" THEN GOSUB 99
        PRINT #T,45.0\GOSUB 91
        IF U$<>" 45" THEN GOSUB 99
5510    PRINT #T,65535.0\GOSUB 91
        IF U$<>" 65535" THEN GOSUB 99
        PRINT #T,123000\GOSUB 91
        IF U$<>" 123000" THEN GOSUB 99
        PRINT #T,99999.99999E5\GOSUB 91
        IF U$<>" 9999999999" THEN GOSUB 99
        PRINT #T,-1\GOSUB 91
        IF U$<>"-1" THEN GOSUB 99
        PRINT #T,-123000\GOSUB 91
        IF U$<>"-123000" THEN GOSUB 99
        PRINT #T,-99999.99999E5\GOSUB 91
        IF U$<>"-9999999999" THEN GOSUB 99

5520    PRINT #T,1.00000001\GOSUB 91
        IF U$<>" 1.00000001" THEN GOSUB 99
        PRINT #T,9.2\GOSUB 91
        IF U$<>" 9.2" THEN GOSUB 99
        PRINT #T,-999900.9001\GOSUB 91
        IF U$<>"-999900.9001" THEN GOSUB 99
        PRINT #T,12345678.9\GOSUB 91
        IF U$<>" 12345678.9" THEN GOSUB 99

5530    PRINT #T,.9999999999\GOSUB 91
        IF U$<>" .9999999999" THEN GOSUB 99
        PRINT #T,-.070400\GOSUB 91
        IF U$<>"-.0704" THEN GOSUB 99
        PRINT #T,1.000004E-6\GOSUB 91
        IF U$<>" .000001000004" THEN GOSUB 99
        PRINT #T,-1E-6\GOSUB 91
        IF U$<>"-.000001" THEN GOSUB 99

5840    PRINT #T,.9999999999E-6\GOSUB 91
        IF U$<>" .9999999999E-6" THEN GOSUB 99
        PRINT #T,-1704E-19\GOSUB 91
        IF U$<>"-.1704E-15" THEN GOSUB 99
        PRINT #T,.9999999999E-126\GOSUB 91
        IF U$<>" .9999999999E-126" THEN GOSUB 99
        PRINT #T,-1E+10\GOSUB 91
        IF U$<>"-.1E+11" THEN GOSUB 99
        PRINT #T,245.78E41\GOSUB 91
        IF U$<>" .24578E+44" THEN GOSUB 99
        PRINT #T,-.9999999999E126\GOSUB 91
        IF U$<>"-.9999999999E+126" THEN GOSUB 99

5850    REM TEST OPPV WITH USING STRING
        PRINT #T,USING "###",0\GOSUB 91
        IF U$<>"  0" THEN GOSUB 99
        PRINT #T,USING ".##",.03\GOSUB 91
        IF U$<>".03" THEN GOSUB 99
        PRINT #T,USING "###.",7.04\GOSUB 91
        IF U$<>"  7." THEN GOSUB 99
        PRINT #T,USING "##.##",PI\ GOSUB 91
        IF U$<>" 3.14" THEN GOSUB 99
        PRINT #T,USING ".#",.006\GOSUB 91
        IF U$<>".0" THEN GOSUB 99
5852    PRINT #T,USING ".##########",9E-11\GOSUB 91
        IF U$<>".0000000000" THEN GOSUB 99
        PRINT #T,USING "-##.##", PI\ GOSUB 91
        IF U$<>"  3.14" THEN GOSUB 99
        PRINT #T,USING "$###",PI\ GOSUB 91
        IF U$<>"  $3" THEN GOSUB 99
        PRINT #T,USING "$##.##",0\ GOSUB 91
        IF U$<>" $0.00" THEN GOSUB 99
        PRINT #T,USING "$-##.##",PI\ GOSUB 91
        IF U$<>"  $3.14" THEN GOSUB 99
        PRINT #T,USING "$-##.##",-PI\ GOSUB 91
        IF U$<>" $-3.14" THEN GOSUB 99
5854    PRINT #T,USING "$###.#-",PI\ GOSUB 91
        IF U$<>"  $3.1 " THEN GOSUB 99
        PRINT #T, USING "$###.#-",-10*PI\GOSUB 91
        IF U$<>" $31.4-" THEN GOSUB 99
        PRINT #T,USING "$-##.###",-PI\GOSUB 91
        IF U$<>" $-3.141" THEN GOSUB 99
        PRINT #T,USING "$#.##-",-.90\ GOSUB 91
        IF U$<>"$0.90-" THEN GOSUB 99
        PRINT #T,USING "-##.##^^^",PI\GOSUB 91
        IF U$<>" 31.41E-1" THEN GOSUB 99
        PRINT #T,USING "-###.^^^^",-PI\GOSUB 91
        IF U$<>"-314.E-02" THEN GOSUB 99
5856    PRINT #T,USING "-.###^^^^^",1.59E49\GOSUB 91
        IF U$<>" .159E+050" THEN GOSUB 99
        PRINT #T,USING "-###^^^^^^",1.99E-6\GOSUB 91
        IF U$<>" 199E-008^" THEN GOSUB 99
        PRINT #T,USING "-###^^^^",1.23E-6\GOSUB 91
        IF U$<>" 123E-08" THEN GOSUB 99
        PRINT #T,USING "##.#^^^^",0\GOSUB 91
        IF U$<>"00.0E+00" THEN GOSUB 99
        PRINT #T,USING "####################'.-##",-3,"ZAP",2\ GOSUB 91
        IF U$<>"**********ZAP         2'.-##" THEN GOSUB 99
        PRINT #T,USING "#.#",29\GOSUB 91
        IF U$<>"***" THEN GOSUB 99
5658    PRINT #T,USING "$#.#",-1\GOSUB 91
        IF U$<>"****" THEN GOSUB 99
        PRINT #T,USING "-#.##^^^^",1E103\GOSUB 91
        IF U$<>"*********" THEN GOSUB 99
        PRINT #T,USING "$##.##^^^^",PI\GOSUB 91
        IF U$<>" $3.14^^^^" THEN GOSUB 99
        PRINT #T,USING "A-.^^^B#.#",PI\GOSUB 91
        IF U$<>"A-.^^^B3.1" THEN GOSUB 99
        PRINT #T,USING "A#.#^^^$-.^$-.#^^^",PI,.7\GOSUB 91
        IF U$<>"A3.1E+0$-.^ $.7^^^" THEN GOSUB 99
        PRINT #T,USING "%%",987654321\ GOSUB 91
        IF U$<>"%% 987654321" THEN GOSUB 99
        PRINT #T,USING "",123456789\ GOSUB 91
        IF U$<>" 123456789" THEN GOSUB 99
5860    REM TEST FOR I/O ERROR RECOVERY
        PRINT #99,72\ REM CHANNEL #99 IS NOT OPEN
5899    RETURN

5900    REM TEST OPPCR
        PRINT #T\GOSUB 91
        IF U$<>'' THEN GOSUB 99
        REM TEST OPPCR USED TO FORCE END OF USING STRING
        PRINT #T,USING "#.#ABCD#^B",3.9\ GOSUB 91
        IF U$<>"3.9ABCD#^B" THEN GOSUB 99
        PRINT #T,USING "#.#^^ABC",7.23\ GOSUB 91
        IF U$<>"7.2^^ABC" THEN GOSUB 99
        RETURN

6000    REM TEST OPPS (PRINT STRING)
        LET U$=''\PRINT #T,U$\GOSUB 91
        IF U$<>'' THEN GOSUB 91
        PRINT #T,"ABCDEF"\GOSUB 91
        IF U$<>"ABCDEF" THEN GOSUB 99
        LET U$="RETCH"\PRINT #T,U$\GOSUB 91
        IF U$<>"RETCH" THEN GOSUB 99
        PRINT #T,U$[2,3]\GOSUB 91
        IF U$<>"ETC" THEN GOSUB 99
        PRINT #T,''\GOSUB 91
        IF U$<>'' THEN GOSUB 99
        RETURN

6100    REM TEST OPPSP (PRINT SPACE)
        PRINT #T,1;-2\GOSUB 91
        IF U$<>" 1 -2" THEN GOSUB 99
        RETURN

6200    REM TEST OPINS
        PRINT #T,"QWERT";
        PRINT #T,"YUIOP"
        GOSUB 91
        IF U$<>"QWERTYUIOP" THEN GOSUB 99
        CLOSE #T
        REM TEST OPINS AT END OF FILE
        CREATE #T,JUNKFILE$
        PRINT #T,"BULLSHIT";
        RESTORE #T,0
6210    INPUT #T,U$
        IF NOT(EOF(T)) THEN GOSUB 99
        RETURN

6300    REM TEST OPCHNL
        RESTORE #T,0
6310    RESTORE #256,0\GOSUB 99
6399    RETURN

6400    REM TEST OPCIN
        LET U$='' CAT ''
        IF U$<>"" THEN GOSUB 99
        RETURN

6500    REM TEST OPCAT
        LET U$='' CAT ''
        IF U$<>'' THEN GOSUB 99
        LET U$='A' CAT 'BCD'
        IF U$<>'ABCD' THEN GOSUB 99
        LET U$=U$[4,1] CAT U$
        IF U$<>'DABCD' THEN GOSUB 99
        REM TEST FOR CONCATENATION BUFFER OVERFLOW CHECK
        LET LEN(U$)=MAXLEN(U$)
6510    LET U$= U$ CAT U$
6599    RETURN

6600    REM TEST OPCND
        GOTO 6500

        END
