        REM ********** BASIC RUNTIME PACKAGE TEST **********
        REM *** PART 2 OF 3 PARTS (BASRTP14LT2.BAS) ***
        REM COPYRIGHT (C) 1977 SOFTWARE DYNAMICS
        REM ALL RIGHTS RESERVED
        REM 1/29/85 1200

        REM TEST RUNTIME PACKAGE OPCODES
        REM IF INPUT IS NULL, TESTS ALL OPCODES
        REM PROMPTS FOR OPCODE NUMBER (SEE LIST OF OPCODES IN BASIC COMPILER)
        REM REQUIRES I/O DEVICE WITH POSITION$ CAPABILITY AND READ/WRITE
        REM LINES WHICH TEST OPCODE NUMBER XXX...
        REM ARE LINES XXX00 THRU XXX99
        REM EACH OPCODE TEST ASSUMES ALL OTHER OPCODES WORK PROPERLY

        PROGRAM ORIGIN :3800
        CONCATENATION BUFFER SIZE = 256
        REM FOR "OPINL" TEST
        REM DATA STORAGE
        DATA ORIGIN :2F00
        COMMON CHNTST,CHNTST$[3]
        DIM OPCODE$[10],V[100],S$/:1,"HELLO"/,T$[2]
        DIM U$[258],U1$[257],A[3,5],NEGONE/-1/,T/1/
        DIM BIN257$/:00,:00,:00,:00,:1,:1/,BINPI$/:41,03,14,15,92,65/
        DIM SIX$[6],FORMAT$/"ABC.##D"/,ZEROLEN$[0],ONELEN$[1]
        DIM EPSILON/1E-8/,GPOPF/0/
        DIM TEMP/2/
        DIM INITSTRING$[25]/"STRING CONTENTS"/,GOELNFLAG/0/
        DIM JUNKFILE$/"JUNK"/
        DIM SPACES$[32]/"                                "/
        DIM ALPHABET$/"ABCDEFGHIJKLMNOPQRSTUVWXYZ"/
        DIM ISCONSOLE$/:1A,2,:FF,:FF,:FF,:FF,:FF,:FF,:FF,:FF,:FF,:FF,:FF,:FF/
        DIM WRITEAONT$/:C,8,1/,OPENT$/0,:E,1/,READBONT$/:B,:E,1/

50      REM INITIALIZE

        PRINT "*** RUNTIME PACKAGE TEST -- PART II (BASRTP14L) ***"
        PRINT "TESTS OPCODES 67-127"
        PRINT "TO TEST ALL OPCODES, TYPE <CR>"
        PRINT "TO TEST A SPECIFIC OPCODE 'X', TYPE 'X'"
        PRINT "TO TEST ALL OPCODES > X, TYPE '>X'"

        CREATE #T,JUNKFILE$\ ! A SCRATCH PLACE TO READ AND WRITE
        PRINT #T\ ! WRITE SOMETHING FOR SUBR 91 TO READ
        RESTORE #T,0\ !SET UP FOR SUBR 91

        REM CHECK FOR SUCCESSFUL CHAIN
        IF CHNTST<>:B27A OR CHNTST$<>'RAT' THEN PRINT "'COMMON' FAILURE"
                                           ELSE PRINT "'COMMON' WORKS!"

90      REM THIS IS WHERE WE ASK...
        ON ERROR GOTO 96
        INPUT "WHICH OPCODE ? " OPCODE$
        IF UPPERCASE$(OPCODE$)="STOP" THEN STOP
        IF LEN(OPCODE$)=0
        THEN
                FOR OPCODE=67 TO 127
                        PRINT OPCODE
                        GOSUB 95
                        IF GPOPF<>0 OR GOELNFLAG<>0
                        THEN GPOPF=0\GOELNFLAG=0\GOSUB 99 FI
                NEXT OPCODE
                PRINT '***DIAGNOSTIC PASS II COMPLETED***'
                PRINT 'CHAINING TO BASRTP14LT3'
                CHAIN 'BASRTP14LT3'
        ELSE
                IF OPCODE$(1)=ASC(">")
                THEN
                        FOR OPCODE=VAL(RIGHT$(OPCODE$,2))+1 TO 127
                                PRINT OPCODE
                                GOSUB 95
                                IF GPOPF<>0 OR GOELNFLAG<>0
                                THEN GPOPF=0\GOELNFLAG=0\GOSUB 99 FI
                        NEXT OPCODE
                        PRINT '*** PARTIAL DIAGNOSTIC PASS COMPLETED ***'
                ELSE
                        LET OPCODE=VAL(OPCODE$)
                        GOSUB 95
                        IF GPOPF<>0 OR GOELNFLAG<>0
                        THEN GPOPF=0\GOELNFLAG=0\GOSUB 99 FI
                        PRINT "TEST COMPLETED"
                FI
        FI
        GOTO 90

91      REM SUBROUTINE TO INPUT INTO U$ FROM TEMP FILE
        REM AND REWIND TEMP FILE TO BYTE 0
        RESTORE #T,0
        INPUT #T,U$
        RESTORE #T,0
        RETURN

95      REM BRANCH TO OPCODE TEST SUBROUTINE
        RESTORE #T,0\! THIS SAVES DOING IT EVERYWHERE ELSE
        ON OPCODE-66 GOTO 6700,6800,6900,...
&       7000,7100,7200,7300,7400,7500,7600,7700,7800,7900,...
&       8000,8100,8200,8300,8400,8500,8600,8700,8800,8900,...
&       9000,9100,9200,9300,9400,9500,9600,9700,9800,9900,...
&       10000,10100,10200,10300,10400,10500,10600,10700,10800,10900,...
&       11000,11100,11200,11300,11400,11500,11600,11700,11800,11900,...
&       12000,12100,12200,12300,12400,12500,12600,12700
        PRINT "I CAN'T TEST THAT OPCODE IN THIS PASS"\ RETURN


96      REM ERROR TRAP ROUTINE
        IF ELN=96 AND ERR=1 THEN PRINT "ESCAPE BOTHERED ERROR TRAP LINE #!?"\
                                 GOSUB POP 0\
                                 GOTO 90
        IF ELN=6710 AND ERR=11 THEN 6720
        IF ELN=6810 AND ERR=60 THEN 6899
        IF ELN=7602 AND ERR=7 THEN 7603
        IF ELN=7606 AND ERR=7 THEN 7607
        IF ELN=7610 AND ERR=7 THEN 7620
        IF ELN=7630 AND ERR=7 THEN 7640
        IF ELN=7650 AND ERR=7 THEN 7660
        IF ELN=7670 AND ERR=7 THEN 7674
        IF ELN=7678 AND ERR=7 THEN 7680
        IF ELN=7693 AND ERR=7 THEN 7699
        IF ELN=7710 AND ERR=60 THEN 7799
        IF ELN=7810 AND ERR=8 THEN 7820
        IF ELN=7920 AND ERR=17 THEN 7999
        IF ELN=8710 AND ERR=15 THEN 8720
        IF ELN=8720 AND ERR=15 THEN 8799
        IF ELN=8800 AND ERR=15 THEN 8810
        IF ELN=8810 AND ERR=15 THEN 8820
        IF ELN=8820 AND ERR=15 THEN 8830
        IF ELN=8830 AND ERR=15 THEN 8840
        IF ELN=8840 AND ERR=24 THEN 8850
        IF ELN=8850 AND ERR=25 THEN 8860
        IF ELN=9300 AND ERR=X THEN 9310
        IF ELN=9410 AND ERR=1011 THEN 9420
        IF ELN=9420 AND ERR=1023 THEN 9430
        IF ELN=9500 AND ERR=1030 THEN 9510
        IF ELN=9510 AND ERR=50 THEN 9520
        IF ELN=9605 AND ERR=50 THEN 9610
        IF ELN=9610 AND ERR=50 THEN 9620
        IF ELN=9620 AND ERR=1023 THEN 9630
        IF ELN=9705 AND ERR=1023 THEN 9710
        IF ELN=OPLFREFLLABELTEST AND ERR=14 THEN 9810
        IF ELN=10220 AND ERR=18 THEN 10299
        IF ELN=10410 AND ERR=11 THEN 10419
        IF ELN=10710 AND ERR=1011 THEN 10720
        IF ELN=10720 AND ERR=1023 THEN 10799
        IF ELN=10800 AND ERR=1011 THEN 10801
        IF ELN=10820 AND ERR=1011 THEN 10830
        IF ELN=10910 AND ERR=11 THEN 10999
        IF ELN=11710 AND ERR=1053 THEN 11720
        IF ELN=11810 AND ERR=1032 THEN 11820
        IF ELN=11820 AND ( ERR=1030 OR ERR=1032) THEN 11830
        IF ELN=11905 AND ERR=1001 THEN 11906
        IF ELN=11910 AND ERR=1054 THEN 11920
        IF ELN=12010 AND ERR=11 THEN 12020
        IF ELN=12030 AND ERR=11 THEN 12040
        IF ELN=12050 AND ERR=11 THEN 12060
        IF ELN=12710 AND ERR=14 AND GOELNFLAG=0 THEN LET GOELNFLAG=1\GOTO ELN
        IF ELN=12720 AND ERR=1 THEN GOTO ELN
        IF ELN=12730 AND ERR=13 THEN 12740
        REM NOT A VALID TRAP!
97      PRINT "ERROR"; ERR; "OCCURRED DURING OPCODE"; OPCODE; "(LINE ";ELN;")"
        GOSUB POP 0
        GOTO 90

99      PRINT "OPCODE"; OPCODE; "FAILED"\ RETURN

6700    REM TEST OPRIGHT
        LET U$='ABCDEF'
6710    LET U$=RIGHT$(U$,8)\GOSUB 99
6720    LET U$=RIGHT$(U$,3)
        IF U$<>'CDEF' THEN GOSUB 99
        LET U$=RIGHT$(U$,4)
        IF U$<>'F' THEN GOSUB 99
        LET U$=RIGHT$(U$,2)
        IF U$<>'' THEN GOSUB 99
        RETURN

6800    REM TEST OPRESTR
        PRINT #T,"ABCDEF"
        RESTORE #T,0\INPUT #T,U$
        IF U$<>"ABCDEF" THEN GOSUB 99
        RESTORE #T,3\INPUT #T,U$
        IF U$<>"DEF" THEN GOSUB 99
6810    RESTORE #T,1E10\GOSUB 99
6899    RETURN

6900    REM TEST OPWV
        WRITE #T,257
        RESTORE #T,0\READ #T,SIX$
        IF SIX$[1]<>BIN257$[1] OR SIX$[5,2]<>BIN257$[5,2] THEN GOSUB 99
        RESTORE #T,0\WRITE #T,PI
        RESTORE #T,0\READ #T,SIX$
        IF SIX$<>BINPI$ THEN GOSUB 99
        RETURN

7000    REM TEST OPWS
        WRITE #T,BIN257$
        RESTORE #T,0\READ #T,X\IF X<>257 THEN GOSUB 99
        RESTORE #T,0\WRITE #T,BINPI$[1,6]
        RESTORE #T,0\READ #T,X\IF X<>PI THEN GOSUB 99
        RESTORE #T,0\WRITE #T,BIN257$[1,0]
        RESTORE #T,0\READ #T,X\IF X<>PI THEN GOSUB 99
        LET U$=''
        RESTORE #T,0\WRITE #T,U$
        RESTORE #T,0\READ #T,X\IF X<>PI THEN GOSUB 99
        RETURN

7100    REM TEST OPRV
        CLOSE #T
        CREATE #T,JUNKFILE$
        WRITE #T,ONELEN$
7110    READ #T@0,X
        IF NOT(EOF(T)) THEN GOSUB 99
        RESTORE #T,0
7199    GOTO 7000

7200    REM TEST OPRS
        PRINT #T,ALPHABET$
        RESTORE #T,0
        READ #T,ZEROLEN$,ONELEN$,SIX$
        IF ZEROLEN$<>'' OR ONELEN$<>'A' THEN GOSUB 99
        IF SIX$<>"BCDEFG" THEN GOSUB 99
        READ #T,SIX$[2,4]
        IF SIX$<>"BHIJKG" THEN GOSUB 99
        CLOSE #T
        CREATE #T,JUNKFILE$
        WRITE #T,"ABCD"
7210    READ #T@0,SIX$
        REM CHECK EOF HANDLING; SET STRING LENGTH TO # BYTES READ AT EOF
        IF NOT(EOF(T)) THEN GOSUB 99
        IF LEN(SIX$)<>4 THEN GOSUB 99
7299    RETURN

7300    REM TEST OPFOR
        LET J=0
        FOR I=0 TO 295\! CHECK INTEGER LOOP
        IF I<>J THEN GOSUB 99
        LET J=J+1
        IF J>296 THEN GOSUB 99\RETURN
        NEXT I
        IF I<>296 THEN GOSUB 99
7310    REM TEST INTEGER STEP <> 1
        LET J=3
        FOR I=3 TO 10700 STEP 941
        IF I<>J THEN GOSUB 99
        LET J=J+941
        IF J>11295 THEN GOSUB 99\RETURN
        NEXT I
        IF I<> 11295 THEN GOSUB 99
7315    REM TEST INTEGER INDEX FORCED TO FLOAT MODE ON LOOP EXIT
        LET J=65000
        FOR I=65000 TO 65535 \ LET J=J+1 \ NEXT I
        IF J<>65536 OR I<>65536 THEN GOSUB 99
7320    LET J=.001\! CHECK FLOATING POINT LOOP
        FOR I=.001 TO 1.0 STEP .09
        IF I<>J THEN GOSUB 99
        LET J=J+.09
        IF J>1.081 THEN GOSUB 99\RETURN
        NEXT I
        IF I<>1.081 THEN GOSUB 99
7330    LET J=1\! CHECK IMPLIED STEP OF 1
        FOR I=1.0 TO 100.0\LET J=J+1\NEXT I
        IF J<>101 OR I<>101 THEN GOSUB 99
7340    LET J=0\! CHECK NEGATIVE STEP
        FOR I=100.0 TO -6.0 STEP -1\J=J+1\NEXT I
        IF J<>107 OR I<>-7 THEN GOSUB 99
7350    LET J=0 \ ! CHECK INTEGER LIMIT
        FOR I=-6 TO 100 STEP 1.0\ J=J+1\NEXT I
        IF J<>107 OR I<>101 THEN GOSUB 99
7360    LET J=0\! CHECK INTEGER INIT VALUE
        FOR I=100 TO -6.0 STEP -1.0\J=J+1\NEXT I
        IF J<>107 OR I<>-7 THEN GOSUB 99
7365    LET J=0\! CHECK INTEGER STEP
        FOR I=-12.71 TO 19.73 STEP 1\J=J+1\NEXT I
        IF J<>33 OR I<>20.29 THEN GOSUB 99
7370    LET X=0\! CHECK LOOP NESTING
        FOR I=1 TO 999
7373            FOR J=.0 TO .9 STEP .1
                        LET X=X+.1
                NEXT J
                IF X<>I THEN GOSUB 99
        NEXT I
        IF X<>999 THEN GOSUB 99
7380    REM TEST 0 ITERATIONS OF INTEGER LOOP
        J=0
        FOR I=11 TO 10 STEP 1
                J=1
        NEXT I
        IF J<>0 OR I<>11 THEN GOSUB 99
7385    REM TEST 0 ITERATIONS OF FLOATING POINT LOOP: POSITIVE INDEX
        J=0
        FOR X=PI TO 1 STEP 2
                J=1
        NEXT X
        IF J<>0 OR X<>PI THEN GOSUB 99
7387    REM TEST 0 ITERATIONS OF FLOATING POINT LOOP: NEGATIVE INDEX
        J=0
        FOR X=1 TO PI STEP -.0001
                J=1
        NEXT X
        IF J<>0 OR X<>1 THEN 99
7388    REM TEST USER CAUSES INDEX VAR TO GO FLOAT IN AN INTEGER LOOP
        FOR I=0 TO 100
                IF I=50 THEN LET I=I+.001
        NEXT I
        IF I<>100.001 THEN GOSUB 99
7399    RETURN

7400    REM TEST OPNEXT
        GOTO 7300

7500    REM TEST OPTABCOL
        PRINT #T
        FOR I=1 TO 10
                PRINT #T,I,
REM             PRINT COL(T),I
                IF COL(T)<>18*I+1 THEN GOSUB 99
        NEXT I
7510    REM TEST OUTPUT VARYING SIZE CHUNKS OF 0 TO 18 BYTES
        FOR I=0 TO 32
                RESTORE #T,0\ REM SET COL(T)=1
                PRINT #T,SPACES$[1,I];"*","#"
REM             PRINT SPACES$[1,I];"*","#"
REM             PRINT "123456789012345678901234567890123456789012345678901234567890"
                RESTORE #T,I+1\ REM SKIP PAST THE "*"
                LET J=I+2\ REM J=COL("*")+1
                REM CHECK FOR THE GAURANTEED SPACE
                READ #T,ONELEN$
                IF ONELEN$<>" " THEN GOSUB 99
                LET J=J+1
                REM CHECK FOR SPACES UNTIL J MOD 18 = 1
                UNTIL J-INT(J/18)*18=1 DO
                        REM UNTIL J MOD 18 = 1 DO...
7520                    READ #T,ONELEN$
                        IF ONELEN$<>" " THEN GOSUB 99
                        LET J=J+1
                END
7530            READ #T,ONELEN$
                IF ONELEN$<>"#" THEN GOSUB 99
        NEXT I
        RETURN

7600    REM TEST OPINP
        REM TEST NORMAL INPUT SEPERATED BY COMMAS
        PRINT #T,"1,2.7,-3,1E42,-.00097E16"
        RESTORE #T,0\INPUT #T,I,J,X,Y,Z
        IF I<>1 OR J<>2.7 OR X<>-3 OR Y<>1E42 OR Z<>-.00097E16 THEN GOSUB 99
        REM TEST INPUT SEPERATED BY TERMINATORS
        RESTORE #T,0\PRINT #T,"14.2:3A-15.7.17:FF.22"
        RESTORE #T,0\INPUT #T,I,J,K,X,Y,Z
        IF I<>14.2 OR J<>:3A OR K<>-15.7 OR X<>.17 OR Y<>255 OR Z<>.22 THEN GOSUB 99
        REM TEST FLOATING POINT INPUT CONVERSION ROUTINES
        RESTORE#T,0\PRINT #T,"123E+000000001 123E-00 456E+00,0E400,123.45.99"
        RESTORE #T,0\INPUT #T,I,J,K,X,Y,Z
        IF I<>1230 OR J<>123 OR K<>456 OR X<>0 OR Y<>123.45 OR Z<>.99 THEN GOSUB 99
        REM TEST NOT ENOUGH VALUES SUPPLIED TO SATISFY INPUT REQUEST
        RESTORE #T,0\PRINT #T,""
7602    RESTORE #T,0\INPUT #T,I\GOSUB 99
7603    RESTORE #T,0\PRINT #T,"3,        1"
        REM TEST IGNORE LEADING SPACES
        RESTORE #T,0\INPUT #T,I,J
        IF I<>3 OR J<>1 THEN GOSUB 99
        REM TEST NO COMMA REQUIRED TO SEPERATE VALUES
        RESTORE #T,0\PRINT #T,"1     3"
        RESTORE #T,0\INPUT #T,I,J
        IF I<>1 OR J<>3 THEN GOSUB 99
        REM TEST HEX INPUT
        RESTORE #T,0\PRINT #T,":127A"
        RESTORE #T,0\INPUT #T,X
        IF X<>:127A THEN GOSUB 99
        REM TEST FALSE TAIL ON FLOATING INPUT
        RESTORE #T,0\ PRINT #T,"1E"\ RESTORE #T,0
        INPUT #T,X\ IF X<>1 THEN GOSUB 99
        RESTORE #T,0\ PRINT #T,"2E-THIS IS TRASH"\ RESTORE #T,0
        INPUT #T,X,U$\ IF X<>2 OR U$<>"E-THIS IS TRASH" THEN GOSUB 99
        REM TEST HEX REJECTION OF NON-HEX
        RESTORE #T,0\PRINT #T,":A0FG THIS IS GARBAGE"\RESTORE #T,0
        INPUT #T,X,U$\ IF X<>:A0F OR U$<>'G THIS IS GARBAGE' THEN GOSUB 99
        REM TEST LOWER CASE FLOATING INPUT
        PRINT #T@0,"123.456e-22*"
        INPUT #T@0,X
        IF X<>123.456E-22 THEN GOSUB 99
        PRINT #T@0,":abcd,:ef12"
        INPUT #T@0,X,Y
        IF X<>:ABCD OR Y<>:EF12 THEN GOSUB 99
        REM TEST EAT COMMA TRAILING INPUT VALUE
        PRINT #T@0,"23,  JUNK"
        INPUT #T@0,X,U$
        IF X<>23 OR U$<>"  JUNK" THEN GOSUB 99
        PRINT #T@0,"52 ,  JUNK"
        INPUT #T@0,X,U$
        IF X<>52 OR U$<>" ,  JUNK" THEN GOSUB 99
        REM TEST PROCESS ONLY WHAT WAS INPUT INTO CATBUF THIS TIME AROUND
        CLOSE #T
        CREATE #T,JUNKFILE$
        PRINT #T,"234,567"
        PRINT #T,"891"
        INPUT #T@0,X,Y\IF X<>234 OR Y<>567 THEN GOSUB 99
        INPUT #T,X,U$
        IF X<>891 OR U$<>"" THEN GOSUB 99
        REM TEST PROPER EOF HANDLING
        INPUT #T,X,Y
7605    IF NOT(EOF(T)) THEN GOSUB 99
        REM TEST OVERFLOW IN HEX INPUT
        RESTORE #T,0
        PRINT #T,":ABCDEFGHI"
        RESTORE #T,0
7606    INPUT #T,X\ GOSUB 99
7607    REM TEST OVERFLOW ON INPUT
        RESTORE #T,0\PRINT #T,"1E200"
        RESTORE #T,0
7610    INPUT #T,I\GOSUB 99
7620    RESTORE #T,0\ PRINT #T
        RESTORE #T,0
7630    INPUT #T,I\GOSUB 99
7640    RESTORE #T,0\ PRINT #T,"   -"\ RESTORE #T,0
7650    INPUT #T,X\ GOSUB 99
7660    RESTORE #T,0\ PRINT #T,"E1"\ RESTORE #T,0
7670    INPUT #T,X\ GOSUB 99
7674    RESTORE #T,0\ PRINT #T,".E2"\ RESTORE #T,0
7678    INPUT #T,X\ GOSUB 99
7680    RESTORE #T,0\ PRINT #T,":"\RESTORE #T,0
7693    INPUT #T,X\GOSUB 99
7699    RETURN

7700    REM TEST OPEOF
        RESTORE #T,0
        IF EOF(T) THEN GOSUB 99
        RESTORE #T,1E9
        IF NOT(EOF(T)) THEN GOSUB 99
7710    RESTORE #T,1E20\GOSUB 99
7799    RETURN

7800    REM TEST OPINL
        PRINT #T,"INLINE TEST"
        PRINT #T,"THIS STUFF SHOULD NOT GET READ"
        RESTORE #T,0\ INPUT #T,U$
        IF U$<>"INLINE TEST" THEN GOSUB 99
        IF EOF(T) THEN GOSUB 99
        REM TEST INPUT BUFFER OVERFLOW
        RESTORE #T,0\ PRINT #T,TAB(250);SPACES$[1,32]
7810    INPUT #T@0,SIX$\ GOSUB 99
7820    REM TEST EOF HANDLING
        CLOSE #T
        CREATE #T,JUNKFILE$
        PRINT #T,"ABC"
        PRINT #T,"7";
        INPUT #T@0,SIX$
        IF EOF(T) THEN GOSUB 99
        LET X=5
        INPUT #T,X
        IF NOT(EOF(T)) THEN GOSUB 99
        REM VERIFY THAT REST OF INPUT STATEMENT HAS BEEN SKIPPED PROPERLY
        IF X<>5 THEN GOSUB 99
        RETURN

7900    REM TEST OPTAB
        FOR I=1 TO 255
                RESTORE #T,0
                IF COL(T)<>1 THEN GOSUB 99
                PRINT #T,TAB(I);"*";
7905            IF COL(T)<>I+1 THEN GOSUB 99
                RESTORE #T,0
7910            FOR J=1 TO I-1
                        READ #T,ONELEN$
                        IF ONELEN$<>" " THEN GOSUB 99
                NEXT J
                READ #T,ONELEN$
                IF ONELEN$<>"*" THEN GOSUB 99
        NEXT I
        RESTORE #T,0\ REM SHOULD SET COL(T)=1
        REM TEST DON'T TAB IF ALREADY BEYOND PROPER COLUMN
        PRINT #T,ALPHABET$;TAB(26);"*"
        INPUT #T@0,U$
        IF U$<>"ABCDEFGHIJKLMNOPQRSTUVWXYZ*" THEN GOSUB 99
        PRINT #T@0,ALPHABET$;TAB(27);"*"
        INPUT #T@0,U$
        IF U$<>"ABCDEFGHIJKLMNOPQRSTUVWXYZ*" THEN GOSUB 99
        PRINT #T@0,ALPHABET$;TAB(28);"*"
        INPUT #T@0,U$
        IF U$<>"ABCDEFGHIJKLMNOPQRSTUVWXYZ *" THEN GOSUB 99
7920    PRINT #T,TAB(256);\ GOSUB 99
7930    PRINT #T,TAB(0);\ GOSUB 99
7999    RETURN

8000    REM TEST OPSEQ
        IF NOT(''="") THEN GOSUB 99
        IF NOT('A'='A') THEN GOSUB 99
        IF NOT("ABCD"="ABCD") THEN GOSUB 99
        LET LEN(U$)=258
        IF NOT(U$=U$) THEN GOSUB 99
        IF NOT(U$=U$[1,258]) THEN GOSUB 99
        IF NOT(U$[1,258]=U$) THEN GOSUB 99
        IF ''="A" OR "ABC"="AB" OR "ABC"="ABD" THEN GOSUB 99
        REM TEST MULTIPLE OF 256 BYTE COMPARE FOR EQUAL
        LET U1$=U$
        LET U$[257]=1
        LET U1$[257]=0
        IF NOT( U$[1,256]=U1$[1,256] ) THEN GOSUB 99
        IF U$=U1$ THEN GOSUB 99
        LET U$[256]=0
        LET U1$[256]=1
        IF U$[1,256]=U1$[1,256] THEN GOSUB 99
        RETURN

8100    REM TEST OPSNE
        IF ''<>'' OR 'A'<>'A' OR 'ABCD'<>"ABCD" THEN GOSUB 99
        LET LEN(U$)=258
        IF U$<>U$ OR U$<>U$[1,258] OR U$[1,258]<>U$ THEN GOSUB 99
        IF NOT( ''<>'A' AND 'ABC'<>'AB' AND 'ABC'<>'ABD' ) THEN GOSUB 99
        RETURN

8200    REM TEST OPSLT
        IF "B"<"A" OR "9"<"0" THEN GOSUB 99
        IF "Q"<"Q" OR ".ABC"<"." THEN GOSUB 99
        IF "N"<"" OR ""<"" THEN GOSUB 99
        IF NOT( "CA"<"CB" AND ".AC"<".ACD" ) THEN GOSUB 99
        LET LEN(U$)=258
        IF U$<U$[1,258] OR U$[1,258]<U$ THEN GOSUB 99
        LET SIX$=U$[1,5] CAT 'A'\LET U$[6]=ASC("B")
        IF NOT( U$[1,5]<SIX$ AND SIX$<U$ ) THEN GOSUB 99
        RETURN

8300    REM TEST OPSLE
        IF "B"<="A" OR "99"<="89" OR ".ABC"<="." THEN GOSUB 99
        IF NOT( ''<='' AND 'AB'<="AB" AND "ABC"<="ABCD" ) THEN GOSUB 99
        IF "A"<="" THEN GOSUB 99
        IF NOT( ''<="AB" ) THEN GOSUB 99
        LET LEN(U$)=258
        IF NOT( U$<=U$ AND U$[1,6]<=U$ ) THEN GOSUB 99
        LET SIX$=U$[1,5] CAT "A"\ LET U$[6]=ASC("B")
        IF NOT( SIX$<=U$[1,6] AND SIX$<=U$ ) THEN GOSUB 99
        RETURN

8400    REM TEST OPSGT
        IF "A">"B" OR "0">"9" THEN GOSUB 99
        IF "A">"A" OR ".">".ABC" THEN GOSUB 99
        IF "">"N" OR "">"" THEN GOSUB 99
        IF NOT( "CB">"CA" AND ".ACD">".AC" ) THEN GOSUB 99
        LET LEN(U$)=258
        IF U$[1,258]>U$ OR U$>U$[1,258] THEN GOSUB 99
        LET SIX$=U$[1,5] CAT 'A'\ LET U$[6]=ASC("B")
        IF NOT( SIX$>U$[1,5] AND U$>SIX$ ) THEN GOSUB 99
        RETURN

8500    REM TEST OPSGE
        IF "A">="B" OR "89">="99" OR ".">=".ABC" THEN GOSUB 99
        IF NOT( "">='' AND "AB">="AB" AND "ABCD">='ABC' ) THEN GOSUB 99
        IF "">='A' THEN GOSUB 99
        IF NOT( 'AB'>='' ) THEN GOSUB 99
        LET LEN(U$)=258
        IF NOT( U$>=U$ AND U$>=U$[1,6] ) THEN GOSUB 99
        LET SIX$=U$[1,5] CAT "A"\ LET U$[6]=ASC("B")
        IF NOT( U$[1,6]>=SIX$ AND U$>=SIX$ ) THEN GOSUB 99
        RETURN

8600    REM TEST OPON
        ON 0 GOTO 8610,8610,8610,8610\ GOTO 8620
8610    GOSUB 99
8620    ON -1 GOTO 8630,8630\GOTO 8640
8630    GOSUB 99
8640    ON 5 GOTO 8650,8650,8650,8650\GOTO 8660
8650    GOSUB 99
8660    ON 2.4 GOTO 8670,8680,8670
8670    GOSUB 99
8680    ON 3.7 GOTO 8690,8690,8690,8699,8690
8690    GOSUB 99
8699    RETURN

8700    REM TEST OPXOR
        IF :0 XOR :0 <> 0 OR :0 XOR 65535 <> :FFFF THEN GOSUB 99
        IF :1 XOR :1 <> 0 OR :5A5A XOR :FFFF <> :A5A5 THEN GOSUB 99
        IF :1234 XOR :1111 <> :0325 THEN GOSUB 99
        IF ((3.2-.2) XOR 1 <> 2) OR ( 3 XOR (1.2-.2)<> 2) THEN GOSUB 99
8710    IF ((-2) XOR 3 )*0=0 THEN GOSUB 99
8720    IF ( 2 XOR 5.1)*0=0 THEN GOSUB 99
8799    RETURN

8800    REM TEST OPPOKE
        POKE -1,:2\GOSUB 99
8810    POKE 2.9,:2\GOSUB 99
8820    POKE 65536,:2\GOSUB 99
8830    POKE :FFFF,-1\GOSUB 99
8840    POKE :FFFF,257\GOSUB 99
8850    POKE :0,:2\GOSUB 99
8860    REM POKE AT THE PROGRAM ORIGIN
        LET X=PEEK(:3600)
        POKE :3600,:FF
        IF PEEK(:3600)<>:FF THEN GOSUB 99
        POKE :3600,:00
        IF PEEK(:3600)<>:00 THEN GOSUB 99
        REM TEST FLOAT TO FIX CONVERSION FOR POKE
        POKE :3600+.1-.1,:AA
        IF PEEK(:3600)<>:AA THEN GOSUB 99
        POKE :3600,:55+.7-.7
        IF PEEK(:3600)<>:55 THEN GOSUB 99
        POKE :3600,X
        IF PEEK(:3600)<>X THEN GOSUB 99
        RETURN

8900    REM TEST OPEEK
        IF PEEK(:3800)<>:BD OR PEEK(:3801)<>:01 OR PEEK(:3802)<>:00...
&               OR PEEK(:3803)<>:14 THEN GOSUB 99
        LET LEN(U$)=179
        FOR J=1 TO LEN(U$)
                REM FILL U$ WITH RANDOMNESS
                LET U$(J)=INT(256*RND)
        NEXT J
        FOR I=:0000 TO :E000 \! FIND U$ IN MEMORY
                FOR J=1 TO LEN(U$)
                        IF PEEK(I+J-1)<>U$[J] THEN CYCLE I\GOSUB 99\RETURN
                NEXT J
                REM FOUND WHAT APPEARS TO BE U$ AT I IN MEMORY
                IF PEEK(I-4)*256+PEEK(I-3)<>258 THEN GOSUB 99
                IF PEEK(I-2)<>0 OR PEEK(I-1)<>179 THEN GOSUB 99
                RETURN
        NEXT I
        GOSUB 99
        RETURN

9000    REM TEST OPUSE
        PRINT #T, USING "ABC##.#D",PI\GOSUB 91
        IF U$<>"ABC 3.1D" THEN GOSUB 99
        PRINT #T, USING FORMAT$,PI\GOSUB 91
        IF U$<>"ABC***D" THEN GOSUB 99
        RETURN

9100    REM TEST OPINP
        IF LEN(OPCODE$)=0 OR OPCODE$(1)=ASC(">")
        THEN
                PRINT "MUST TEST OPINP (91) BY ITSELF"
        ELSE
                PRINT "Should print prompt ('? '); enter any string to proceed"
                INPUT U$
                PRINT "#";U$;"#"
        FI
        RETURN

9200    REM TEST OPINT
        FOR I=-1000 TO 1000
        IF INT(I)<>I THEN GOSUB 99\RETURN
        NEXT I
        FOR I=-100 TO 100
                FOR X=.1 TO .999999 STEP 1/PI
                        IF INT(I+X)<>I THEN GOSUB 99\ RETURN
                NEXT X
        NEXT I
        RETURN

9300    REM TEST OPERR
        LET X=INT(65536*RND)
        ERROR X
9310    IF ERR<>X THEN GOSUB 99
        RETURN

9400    REM TEST OPOPN
        CLOSE #T
        DELETE JUNKFILE$
9410    OPEN #T,JUNKFILE$\GOSUB 99
9420    OPEN #T,""\ GOSUB 99
9430    CREATE #T,JUNKFILE$
        PRINT #T,"HELLO!"
        CLOSE #T
        OPEN #T,JUNKFILE$[1,LEN(JUNKFILE$)]
        INPUT #T,U$\ IF U$<>"HELLO!" THEN GOSUB 99
        CLOSE #T
        LET U$=JUNKFILE$
        OPEN #T,U$
        INPUT #T,U$\ IF U$<>"HELLO!" THEN GOSUB 99
        RETURN

9500    REM TEST OPCLS
        CLOSE #99\REM CHANNEL NUMBER 99 IS NOT OPEN
        GOSUB 99
9510    CLOSE #-2
9520    GOTO 9400

9600    REM TEST OPCREAT
        CLOSE #T
9605    CREATE #-2,JUNKFILE$\GOSUB 99
9610    CREATE #257,JUNKFILE$\GOSUB 99
9620    CREATE #T,''\ GOSUB 99
9630    CREATE #T,JUNKFILE$
        GOTO 9400

9700    REM TEST OPCHAIN
        IF LEN(OPCODE$)=0 OR OPCODE$(1)=ASC(">")
        THEN
                PRINT "MUST TEST OPCHAIN (97) IN MANUAL MODE"
        ELSE
9705            CHAIN ""
9710            PRINT "CHAINING TO BASRTP14LT2"
                LET CHNTST=:B27A
                LET CHNTST$="RAT"
                CHAIN "BASRTP14LT2"
        FI
        RETURN

9800    REM TEST OPLFREFL
OPLFREFLLABELTEST:      X=1/0
        GOSUB 99
9810    IF OPLFREFLABELTEST2=0 THEN GOSUB 99
        REM TEST GOTO FORWARD REF LABEL
        X=-PI
        GOTO OPLFREFLABELTEST2
        GOSUB 99
OPLFREFLABELTEST2:      IF X<>-PI THEN GOSUB 99
        RETURN

9900    REM TEST OPELN
        ON ERROR GOTO 9920
9910    LET X=1/0
        GOSUB 99
9920    IF ELN<>9910 OR ERR<>14 THEN GOSUB 99
        ON ERROR GOTO 9930
        LET ONELEN$[2,50]="A"
        GOSUB 99
9930    IF ELN<>9920 OR ERR<>11 THEN GOSUB 99
        ON ERROR GOTO 96
        RETURN
10000  REM TEST OPPI
        IF PI<>3.14159265 THEN GOSUB 99
        RETURN

10100   REM TEST OPFIND
        LET U$='A'\ LET U$=''
        IF FIND(U$,'')<>1 THEN GOSUB 99
        IF FIND(U$,"A")<>0 THEN GOSUB 99
        LET U$="ABCDEFGH"
        IF FIND(U$,'')<>1 THEN GOSUB 99
        IF FIND(U$,"A")<>1 THEN GOSUB 99
        IF FIND(U$,"ABCD")<>1 THEN GOSUB 99
        IF FIND(U$,"ACB")<>0 THEN GOSUB 99
        IF FIND(U$,"ABCDEFGHI")<>0 THEN GOSUB 99
        IF FIND(U$,"GHI")<>0 THEN GOSUB 99
        IF FIND(U$[2,7],"DEF")<>3 THEN GOSUB 99
        IF FIND(U$,U$)<>1 THEN GOSUB 99
        IF FIND(U$,S$)<>0 THEN GOSUB 99
        REM TEST FOR FIND IN A 256 BYTE STRING
        FOR I=1 TO MAXLEN(U$) DO LET U$[I]=0
        LET LEN(U$)=MAXLEN(U$)
        LET U$[256,2]="AB"
        IF FIND(U$[1,256],"A")<>256 THEN GOSUB 99
        IF FIND(U$[1,256],"B")<>0 THEN GOSUB 99
        REM TEST FIND A 256 BYTE STRING
        LET U1$=U$
        IF FIND(U$,U1$[1,256])<>1 THEN GOSUB 99
        IF FIND(U$[2,256],U$[1,256])<>0 THEN GOSUB 99
        RETURN

10200   REM TEST OPUSL
        REM TEST "USING LINENUMBER"
10202   PRINT #T,USING 10210,2.7\GOSUB 91
10210   FORMAT "ABZ#.###-"
        IF U$<>"ABZ2.700 " THEN GOSUB 99
        REM TEST "USING LABEL"
OPUSLTEST: FORMAT "##.# TIN SOLDIERS"
10212   PRINT #T,USING OPUSLTEST,36.82\GOSUB 91
        IF U$<>"36.8 TIN SOLDIERS" THEN GOSUB 99
        REM TEST "USING FOWARD REFERENCE LABEL"
        LET X=(1=OPUSLTESTFWDREF) \ REM MAKE OPUSLTESTFWDREF A FWD REF LABEL
10215   PRINT #T,USING OPUSLTESTFWDREF,1E11\GOSUB 91
        IF U$<>" 100E+09 DOLLARS IS ROUGHLY THE NATIONAL DEBT." THEN GOSUB 99
OPUSLTESTFWDREF: FORMAT " ###^^^^ DOLLARS IS ROUGHLY THE NATIONAL DEBT."
        REM TEST "USING <NON-FORMAT STATEMENT>"
10220   PRINT #T, USING 10299, 3.7\ GOSUB 99
10299   RESTORE #T,0\RETURN

10300   REM TEST OPJUC
10310   FORMAT "##.##^^^"
        RETURN

10400   REM TEST OPINIT
        IF NEGONE<>-1 THEN GOSUB 99
        REM CHECK THAT COMPILER INITZES STRING$[N]/"..."/ PROPERLY
        IF INITSTRING$<>"STRING CONTENTS" THEN GOSUB 99
        LET LEN(INITSTRING$)=25\! SHOULDN'T ERROR
10410   LET LEN(INITSTRING$)=26\GOSUB 99
10419   LET LEN(INITSTRING$)=15\! RESTORE ORIGINAL STRING LENGTH
        RETURN

10500   REM TEST OPZCHN
        PRINT "This message should be printed on the console:"
        PRINT "TESTING OPZCHN (105)"
        RETURN

10600   REM TEST OPONG
        ON -1 GOSUB 99,99,99
        ON 0 GOSUB 99,99,99,99
        ON 5 GOSUB 99,99,99,99
        X=1
        ON 2.4 GOSUB 99,10630,99
        IF X<>-1 THEN GOSUB 99
        ON 3.6 GOSUB 99,99,99,10630,99
        IF X<>1 THEN GOSUB 99
        RETURN
10630   X=-X\ RETURN

10700   REM TEST OPDEL
        CLOSE #T
        CREATE #T,JUNKFILE$
        CLOSE #T
        DELETE JUNKFILE$
10710   OPEN #T,JUNKFILE$\ GOSUB 99
10720   DELETE ""\GOSUB 99
10799   CREATE #T,JUNKFILE$
        RETURN

10800   REM TEST OPREN
        DELETE JUNKFILE$ CAT 'X'
10801   CLOSE #T
10810   CREATE #T,JUNKFILE$
        CLOSE #T
        RENAME JUNKFILE$,JUNKFILE$ CAT "X"
10820   DELETE JUNKFILE$\GOSUB 99
10830   DELETE JUNKFILE$ CAT "X"
        CREATE #T,JUNKFILE$
        RETURN

10900   REM TEST OPSSL
        FOR I=0 TO 258
                LET LEN(U$)=I
                IF LEN(U$)<>I THEN GOSUB 99
        NEXT I
10910   LET LEN(U$)=259\GOSUB 99
10999   RETURN

11000   REM TEST OPSTORE
        LET CHNTST=15.001
        IF CHNTST<>15.001 THEN GOSUB 99
        LET CHNTST=46
        IF CHNTST<>46 THEN GOSUB 99
        LET CHNTST=91.003-.003
        IF CHNTST<>91 THEN GOSUB 99
        RETURN

11100   REM TEST OPSGN
        IF SGN(0)<>0 OR SGN(2)<>1 OR SGN(-7)<>-1 THEN GOSUB 99
        IF SGN(3.9)<>1 OR SGN(-2.9)<>-1 THEN GOSUB 99
        RETURN

11200   REM TEST OPASM
        REM "OPASM NOT GENERATED BY COMPILER, CAN'T TEST"
        RETURN

11300   REM TEST OPLBOOL
        LET X=1>2
        IF X<>FALSE THEN GOSUB 99
        LET X=2>1
        IF X<>TRUE THEN GOSUB 99
        RETURN

11400   REM TEST OPPRUS
        PRINT #T,USING "#ABC#",3;\PRINT #T,"?"\GOSUB 91
        IF U$<>"3ABC#?" THEN GOSUB 99
        PRINT #T,USING "#.## HELLO #.$",3.6,"ABC";\PRINT #T,"!"\GOSUB 91
        IF U$<>"3.60ABC HELLO #.$!" THEN GOSUB 99
        RETURN

11500   REM TEST OPSETLABEL
        REM SET ERROR TRAP SO THAT LABEL ISN'T A FORWARD REFERENCE
        ON ERROR GOTO 11590
OPSETLABELTEST: LET X=1/0
        GOSUB 99
11510   ON ERROR GOTO 96\ REM RESTORE ERROR TRAP ROUTINE
        RETURN
11590   IF ELN=OPSETLABELTEST AND ERR=14 THEN 11510
        GOTO 97

11600   REM TEST OPMAXLEN
        LET LEN(U$)=0
        IF LEN(U$)<>0 OR MAXLEN(U$)<>258 THEN GOSUB 99
        RETURN

11700   REM TEST OPSYSCALL1ARG
        REM TEST PROPER EXECUTION
        REM LEN(ISCONSOLE$)=:E
        REM ISCONSOLE$ CONTENTS HAVE INTENTIONAL GARBAGE FOR RDLEN, WRLEN, RPLEN
        SYSCALL(ISCONSOLE$)
        REM TEST REDICULOUSLY LONG SYSCALL BLOCK LENGTH, BUT STRING ITSELF TOO SHORT
        PRINT "WHAT HAPPENS IF WAIT BIT IS SET??"
        SIX$=ISCONSOLE$
        SIX$[2]=:7F
        SYSCALL(SIX$)
        REM TEST ERROR TRAP
        SIX$=ISCONSOLE$
        SIX$[2]=0\ REM SYSCALL BLOCK LENGTH = 0 --> SDOS WILL COMPLAIN
11710   SYSCALL(SIX$)
11720   RETURN

11800   REM TEST OPSYSCALL2ARG
        REM TEST COMPLETE STRING WRITE
        SYSCALL(WRITEAONT$,ALPHABET$)
        PRINT #T
        GOSUB 91
        IF U$<>ALPHABET$ THEN GOSUB 99
        REM TEST SUBSTRING WRITE
        SYSCALL(WRITEAONT$,RIGHT$(ALPHABET$,16))
        PRINT #T
        GOSUB 91
        IF U$<>RIGHT$(ALPHABET$,16) THEN GOSUB 99
        REM TEST ERROR HANDLING
        LET SIX$=WRITEAONT$
        LET SIX$(3)=2\! UNOPENED CHANNEL
11810   SYSCALL(SIX$,ALPHABET$)
11820   REM TEST NON-ZERO CHANNEL NUMBER GIVEN OVERRIDES SYSCALL BLOCK CH #
        SYSCALL #255,WRITEAONT$,"This should cause an 'Invalid Channel' trap"
        GOSUB 99
11830   REM TEST CHANNEL ZERO GIVEN USES CHANNEL NUMBER IN SYSCALL BLOCK
        SYSCALL #0,WRITEAONT$,"This message goes to channel T"
        PRINT #T
        GOSUB 91
        IF U$<>"This message goes to channel T" Then gosub 99
        RETURN

11900   REM TEST OPSYSCALL3ARG
        REM TEST WRITE BUFFER CASE
        LET U$=ALPHABET$
        SYSCALL(WRITEAONT$,ALPHABET$,U$)
        PRINT #T
        IF LEN(U$)<>0 THEN GOSUB 99
        GOSUB 91
        IF U$<>ALPHABET$ THEN GOSUB 99
        REM TEST REPLY STRING IS LONG ENOUGH
        CLOSE #T
        SYSCALL(OPENT$,JUNKFILE$,U$)
        IF LEN(U$)<>2 OR U$[1]**8+U$[2]<>LEN(JUNKFILE$) THEN GOSUB 99
        REM TEST REPLY SUBSTRING IS LONG ENOUGH
        CLOSE #T
        LET U$="123"
        SYSCALL(OPENT$,JUNKFILE$,U$[2,2])
        IF LEN(U$)<>3 OR U$[1]<>ASC("1") OR U$[2]**8+U$[3]<>LEN(JUNKFILE$) THEN GOSUB 99
        REM TEST NULL WRITE BUFFER, AND EOF ON READ TRIMS REPLY
        CLOSE #T
        CREATE #T,JUNKFILE$
        LET LEN(U$)=255
        FOR I=1 TO 255 DO U$[I]=I
        WRITE #T,U$
        FOR I=1 TO 255 DO U$(I)=0
        LET LEN(U$)=0
        RESTORE #T,0
11905   SYSCALL(READBONT$,'',U$)
11906   IF LEN(U$)<>255 THEN GOSUB 99
        FOR I=1 TO 255 DO IF U$(I)<>I THEN GOSUB 99
        REM TEST REPLY STRING IS TOO SHORT
        CLOSE #T
11910   SYSCALL(OPENT$,JUNKFILE$,ONELEN$)
11920   OPEN #T,JUNKFILE$
        RETURN

12000   REM TEST OPSYSCALL4ARG
        REM TEST REPLY BUFFER LEN < SPECIFIED SIZE AND MAXLEN > SPEC'D SIZE
        CLOSE #T
        LET U$=''
        SYSCALL(OPENT$,JUNKFILE$,U$,3)
        IF LEN(U$)<>2 OR U$[1]**8+U$(2)<>LEN(JUNKFILE$) THEN GOSUB 99
        REM TEST REPLY BUFFER LEN < SPECIFIED SIZE AND MAXLEN < SPEC'D SIZE
12010   SYSCALL(OPENT$,JUNKFILE$,ONELEN$,3)\ GOSUB 99
12020   REM TEST NON-INTEGER SPECIFIED SIZE
        CLOSE #T
        LET LEN(U$)=10
        SYSCALL(OPENT$,JUNKFILE$,U$,3.6)
        IF LEN(U$)<>2 OR U$[1]**8+U$[2]<>LEN(JUNKFILE$) THEN GOSUB 99
        REM TEST ILLEGAL SPECIFIED SIZE
12030   SYSCALL(OPENT$,JUNKFILE$,U$,-2)\ GOSUB 99
12040   REM TEST REPLY BUFFER IS SUBSTRING LARGER THAN SPECIFIED SIZE
        CLOSE #T
        LET LEN(U$)=4
        SYSCALL(OPENT$,JUNKFILE$,U$[2,3],2)
        IF LEN(U$)<>4 OR U$[2]**8+U$[3]<>LEN(JUNKFILE$) THEN GOSUB 99
        REM TEST REPLY BUFFER IS SUBSTRING SMALLER THAN SPECIFIED SIZE
        CLOSE #T
12050   SYSCALL(OPENT$,JUNKFILE$,U$[4,1],2)\ GOSUB 99
12060   OPEN #T,JUNKFILE$
        RETURN

12100   REM TEST OPCOPYRIGHT
        PRINT "THIS IS THE COPYRIGHT MESSAGE:"
        PRINT COPYRIGHT$
        IF COPYRIGHT$<>"RTP 1.4l Copyright (C) 1977 Software Dynamics"
        THEN GOSUB 99
        RETURN

12200   REM TEST OPEXTENDED
        PRINT "OPEXTENDED (122) IS TESTED BY PASS III"
        RETURN

12300   REM TEST OPSUBRET
        X=0
        CALL SUBTEST(PI)
        IF X<>PI THEN GOSUB 99
        RETURN
        SUBROUTINE SUBTEST(SUBTESTARG)
        X=SUBTESTARG
        EXIT SUBROUTINE
        END

12400   REM TEST OPFNCALL
        REM DEFINE THE FUNCTIONS WE NEED
DEF MAX(MAX1,MAX2)= IF MAX1>MAX2 THEN MAX1 ELSE MAX2 FI
DEF CONCATENATE$(CONC1$,CONC2$)=CONC1$ CAT CONC2$
DEF PRINTONCHANNELZERO(PRINTONCH0ARG)
        PRINT #0,"This message is to be printed on the console:"
        RETURN PRINTONCH0ARG
END
        IF 3<>MAX(2,3) THEN GOSUB 99
        IF "HELLO"<>CONCATENATE$("HEL","LO") THEN GOSUB 99
        REM CHECK THAT CHANNEL NUMBER IS PRESERVED THRU A FUNCTION CALL
        PRINT #T,PRINTONCHANNELZERO(75)\GOSUB 91
        IF U$<>" 75" THEN GOSUB 99
        RETURN

12500   REM TEST OPLINT
        IF 10<>10.0 OR 255 <> 255.0 THEN GOSUB 99
        RETURN

12600   REM TEST OPEXITLOOP
        FOR I=1 TO 10
                IF I=5 THEN EXIT I
                IF I>=5 THEN GOSUB 99
        NEXT I
        IF I<>5 THEN GOSUB 99
        RETURN

12700   REM TEST OPTRP
        REM TEST THAT ERROR TRAP ROUTINES DO NOT RESPOND TO <ESC>
        LET GOELNFLAG=0
        DEF JPLUSI=J+I
12710   IF GOELNFLAG=0 THEN PRINT 1/0
        IF GOELNFLAG<>1 THEN GOSUB 99
        PRINT "PLEASE BANG ON THE ESCAPE KEY..."
        PRINT "(NO RESPONSE SHOULD OCCUR)" 
        LET J=0
        FOR I=1 TO 10000
12720           REM A PLACE FOR ESCAPE TO CATCH US
                REM ERROR TRAP ROUTINES TRANSFER CONTROL BACK TO THIS POINT
                LET J=JPLUSI \ REM INVOKE A FUNCTION, SHOULD NOT RESPOND TO ESCAPE
        NEXT I
        IF J<>10000*(10000+1)/2 THEN GOSUB 99\! NOT ESCAPE PROOF!
12730   GOTO ELN\GOSUB 99
12740   LET GOELNFLAG=0
        RETURN

        END
