SAFETRAN Grade Crossing Predictor Runtime Environment Specification

INTRODUCTION

This document specifies the software Run Time Environment (RTE) in which the
SAFETRAN Grade Crossing Predictor (GCP) application program executes. The
document gives some background on the environmental requirements, the
hardware constraints, and then specifies the interface to all routines used
in the runtime environment.  This runtime environment is expected to
be used for work on the GCP after June 1, 1986.  Prior to that time,
the runtime enviroment is undefined.

BACKGROUND

<insert RTP requirements document here>

HARDWARE

The GCP application runs on a 6809 microprocessor with 48Kb of ROM and 16Kb
of RAM, with some small portion of the address space dedicated for I/O. 
Approximately 256(??) bytes of battery-backed RAM (call NOVRAM, or
non-volatile RAM) is used to store long-term application configuration
parameters.

A real-time clock generates an interrupt every 1.9? milliseconds for use by
the GCP application to handle timing needs.

An HP64000 logic analyzer is used in the test environment, and provides not
only conventional logic analyzer facilities such as examine, change, stop,
go, but also provides a Virtual I/O interface used by the GCP runtime
environment for high-level language debugging features.

DEVELOPMENT ENVIRONMENT

The GCP application is written primarily using SDM, a programming language
derived from the Software Development Methodology defined originally by
Westinghouse, Ltd. of England.

SDM defines 3 language dialects: SDM (proper), PDL and PAP.  The three
dialects are required to organize the software into components analyzable by
special fault detection tools.  From the point of view of the runtime
environment, however, all three dialects might as well be one as the runtime
enviroment must provide support for the needs of the union of all three, and
so no further distinction is made in this document, except where dialectic
limitations force specialized support. The application is broken into many
seperately-compiled modules, each of which may be coded in any of the three
dialects.

The SDM dialects are compiled by the SDM compiler into assembly source code.
The compiler is used in two modes: for testing of unreleased software, and
for final production.  In test mode, the compiler generates many validity
checks in the application code to help detect problems quickly, and also
generates information used by the runtime enviroment debugger to inspect
execution state and variables of the various application program modules. In
production mode, the compiler generates smaller and faster code than in test
mode, giving up the test and inspection support. The SDM methodology
requires that production mode output of the compiler be inspected by
Safetran personnel to ensure an accurate implementation of the SDM code has
been effected.  Test mode code is not inspected manually. A compile time
switch selects the style of code production.  Presence of test mode code in
any module is signalled (HOW?? NEED EXPLICIT TEST IN RTE) to the runtime
enviroment, and eventually to the application so that the presence of ANY test
mode code in a "production" release is easily detected.

The compiler output is fed to the 2000 A.D. assembler running on an IBM
PC; thus, the runtime enviroment is indirectly affected by characteristics
of that assembler.  Assembler output in the form of relocatable modules
is linked with other already compiled modules, and a series of modules
which comprise the runtime environment, to produce an executable
program.

The program is typically downloaded into a HP64000 logic analyzer connected
to a test bed containing the execution hardware outlined earlier.
The analyzer is used to:

   inspect or change memory at a machine-language level

   start execution of the application at its normal starting point

   stop the program at specific instructions or on the detection of certain
   data patterns present in the instruction or data stream

   perform diagnostic display as required by the RTE on the detection of a
   fault in the application program

   start the SDM Debug portion of the RTE, and act as keyboard/display
   for the Debug so that an application programmer can interrogate
   the state of variables or the status of the various activities
   in the application.

A production program may also be burned into Read-only memory, installed
in the testbed, and tested by use of the analyzer.  RTE diagnostic
displays and the SDM Debug facility are not available in this test
arrangement.

RUN TIME ENVIRONMENT LOGICAL COMPONENTS

The RTE is composed of several logical components.  Each component plays a
different role in fulfilling the needs of application execution and test.
The components of the RTE are all coded in assembly language, and thus fall
outside the SDM methodology as far as coding is concerned, but within the
methodology via the requirement for each RTE component to be verified by a
structured walk-through and validation. The interfaces to each routine or
data structure defined by the RTE modules are specified in this document.

    SDOSRT   Software Dynamics Operating System for Real Time
             This provides a high-performance, priority-driven, real-time
             task scheduler, task synchronizing routines, interrupt
             architecture and task interface, and sundry support routines.
             SDOSRT is considerably more general purpose than GCP requires.
             The specifications for the interface to SDOS/RT are supplied
             in a seperate document.
>>>> IRA: YOU MUST GENERATE THOSE SPECS!

    SDDBG    Software Dynamics Debugger.  Simple debugger to allow
             memory inspection and modification, register inspection
             and change, and a single breakpoint.  Also provides
             communication facility used by SDMDBG.  SDDBG is provided
             to allow test in an environment where a HP64000 is
             not available.
>>> IRA: YOU MUST GENERATE THOSE SPECS!


    FPPKG    Floating point arithmetic package.  Provides re-entrant
             routines to perform 24 bit floating point operations,
             including (but not limited to) ADD, SUBTRACT, MULTIPLY,
             DIVIDE, COMPARE, FIX (convert float to 16 bit signed integer),
             FLOAT (convert 16 bit signed integer to floating format),
             FCONVI (floating point input conversion) and FCONVO
<DOES COMPILER GENERATE FLOATING COMPARE LIKE IT SHOULD?>
             (floating point output conversion).  While the floating
             point package is not particularly defined for use by
             GCP, its limited precision was determined by the GCP
             application program needs, and is understood by the SDM
             compiler.
??? WHERE ARE SPECS FOR THIS?

    SDMSPT   SDM high-level language support other than floating point.    
             Includes re-entrant routines used to implement compiler
             generated macros, such as 16 bit by 16 bit multiplication
             and division, 16 bit shifting and masking operations,
             array indexing support, interface between SDM channels
             and SDOSRT task synchronizing primitives, and other
             miscellaneous operations.

    SDMDBG   SDM high-level language debugging facility.  Provides
             programmer with facilities to determine state of each
             activity (running, waiting for xxx, register values),
             activation record chain trace, subroutine execution trace,
             (HOW IS SUBR EX TRACE DIFF THAN ACTIVA RECORD TRACE?)
             variable inspection facility, and application fault trap
             and tracking to module and source line number. This code
             is not GCP specific, but is SDM specific.

     INTRPT  Interrupt routines and system Reset code for RTE and
             application program.  Part of this module is custom coded
             specifically for the application.

     APPGLB  Application Program Global data.  Contains Pools,
             Channels, and other data specified as global by the
             various SDM application modules.  Also contains tables
             used by SDMDBG and INTRPT to locate SDM-compiled modules.
             This module is coded specifically for GCP.

RUN TIME ENVIRONMENT PHYSICAL COMPONENTS

The RTE is organized into a set of assembly language modules.
Relocatable object files of these modules are linked with compiler
output to produce executable object programs.  Modules whose
name is marked with an "*" are used only in the test enviroment,
not in the production environment.

------------------------
The following stuff should go after the RTE requirements document.

THE 15 POINTS, INSTANTIATED FOR THE APPLICATION

1) CLASS OF APPLICATIONS TO BE SERVICED BY RUNTIME ENVIRONMENT

The product called Micro Grade Crossing Predictor (MGCP) is the main
application to be serviced by the SDM compiler methodology.  This
application requires the prediction of the time of arrival of passanger or
freight trains at a crossing, so that a warning gate can be lowered. 
Various sensors must be sampled in real time, and computation performed
quickly enough to make such prediction possible.  The prediction causes a
signal to go to a crossing gaurd gate as to whether it should be up or
down. Multiple prediction activities are necessary at the same time due to
multiple possible train approaches (at least tracks).  Information from
nearby MGCPs must be integrated into the predictions.  Programmable
configurability is required to allow customization of MGCP to the local
site and locally changing conditions.

The MGCP performs many actions simultaneously:
   a) it predicts the arrival of trains based upon collected data
   b) collects analog data for task a) from 8 sources
   c) interfaces to local operator via keyboard and display
   d) drives gate crossing guard with unique frequency to hold
      gaurd in "gate up" state
   e) scans inputs
   f) preprocess collected data before predictions
   g) records data

Micro S-Code is a contemplated product that computes boolean outputs
from a variety of real-time analog data inputs with thresholds.
This product too could be potentially implemented using the
SDM methodology.

Solid State Interlock is a third product which will block multiple
trains from occupying the same section of track.  It might also be
built using the SDM methodology.

It is a requirement that the software for the above products be very
reliable, and thus considerable attention is being paid to the construction
and test methodologies in an attempt to minimize design errors being
delivered to the field, as well as minimizing the impact of various
hardware failures.

2) MECHANISMS REQUIRED OF THE RUNTIME ENVIRONMENT

The MGCP application demonstrates need for the following mechanisms:
    a) Datatypes: Booleans, Integers, Reals, Arrays of same, Text strings.
    b) Computational facilities for the above:
          +,-,*,/, shift, and/or, comparison, conversion between types,
          array indexing facilities.
    c) Control flow mechanisms: loops, subroutines, conditionals
    d) Multiple threads of execution (tasks)
    e) Shared data among tasks
    f) Fast interrupt must be serviced reliably to provide signature output.
    g) Data collection via interrupt: 500uS response acceptable.
    h) Some tasks must meet real-time deadlines, while others can be delayed.
    i) Data reporting to display device and logger; low priority.
    j) Error detection for "obvious faults"

Micro S-code and the Solid State Interlock product do not obviously
require reals.

Items a), b) and c) are provided by the SDM compiler (text strings are
treated as arrays of bytes).  Items d) and e) are provided by a combination
of the SDM compiler (which allows the programmer to state his intentions)
and SDOS/RT, which carries out the management of task multiplexing and
synchronization. Items f) and g) are carried out by a specialized piece of
assembly code which handles an approx. 2mS. interrupt and converts it to
task wakeup signals honored by SDOSRT; the application programmer defines a
high-priority task to be woken at an appropriate time to collect whatever
data is needed. Item h), different requirements on tasks priorities are
handled by SDOSRT's task priorities; the application programmer states which
tasks are high priority, and SDOSRT pre-empts lower priority tasks when high
priority tasks become ready, and runs those tasks to completion before
running/continuing tasks of lower priority. Task priorities, coupled with
the assurance that the amount of CPU time required by the tasks that have
hard periodic deadlines is less than the total amount of CPU available
during the most congested period in which a deadine must be met, assures
that deadlines ARE met. Item i) is handled as a low priority application
task.  Item j) is handled by a combination of the compiler and the runtime
support system.

There is no identifiable requirement for any SDM activity to use more
than one task.

There is no identifiable requirement for any SDM activity to respond
to more than one external event at a time.

3 and 4) RESOURCE CONFLICTS AND POLICIES FOR RESOLUTION

   The following kinds of resource conflicts are present:
   a) Competition by multiple activities for CPU.  Some activities
      must be run before others when there is a choice.
      This is handled by SDOS/RT as outlined above.
   b) Interaction over pools of data between activities.
      SDM provides EXCHANGES, a relatively clumsy method.
      SDOS/RT and an extension to SDM provide LOCKs, a
      clean way to resolve this.
      Both of these methods avoiding timing splinters on problems
      storing as simple as storing reals into shared pools.
   c) Interaction over NonVolative RAM between activities (variant of b)
      Solved by same policy as for b).
   d) Competition for use of compiler support routines such as
      floating point, array indexing logic, etc.
      Solved by requiring that all potentially sharable compiler support
      routines either be coded re-entrantly, or that they be serially
      sharable (by use of disable/enable interrupt over PROVABLY short
      periods of time, or SDOS/RT LOCK sequences over longer periods
      of time.)
   e) Total amount of CPU: Is there enough?
      Enumeration of tasks for MGCP and computation of percentage demand
      over deadline windows, given current SDM compiler code quality,
      shows enough CPU is currently available.  When modifying compiler,
      leave compiler code quality alone unless easy opportunity for
      code space or execution cost shrinkage is possible.
   f) Competition for ROM space to hold application procedures (48Kb available)
      Apparantly enough ROM space.  Same policy as e).
   g) Allocation of stack space: how to determine how much?
      This is a very tough problem.  Strategy is to allocate stack
      areas by hand and to install stack overflow/underflow checks.
   h) Competition by application programs for use of shared application
      subroutines. The SDM compiler (specification?) implementation makes
      this impossible due to its method of parameter passing.
EITHER WE LIVE WITH THIS OR WE FIX IT. HAROLD?

5) COMPILER EFFICIENCY. See section 4.

6) RUNTIME DEBUG SUPPORT

Errors made by the application program which are potentially detectable
by run-time checks are:
   a) Division by zero
      Easily accomplished in FPPKG. Accepted.
   b) Unnormalized Real (probably uninitialized variable)
      Easily accomplished in FPPKG. Accepted.
   c) Floating Overflow
      Easily accomplished in FPPKG. Accepted.
   m) Uninitialized variable.
      Not easily accomplished, therefore rejected.
   e) Integer arithmetic overflow
      Detectable only at high code cost (BVS after every computation). Rejected.
   f) Array subscript errors
      Array subscript code bulky anyway; if placed in a subroutine,
      array subscript checking does not add much. Accepted.
   g) Bad value errors on store.
      Requires test on every data store, which is infrequent compared
      to data fetches, and takes medium amount of code.
      Accepted.
   h) Bad value errors on fetch.
      Requires test on every data fetch, which happens frequently and
      and therefore increases demand on CPU, and it takes medium amount
      of extra code to accomplish.
      Does not catch many problems not caught by g), therefore rejected.
   i) Missed task deadlines COMMENT?
   j) Stack overflow. COMMENT?
   k) Stack underflow. COMMENT?
   l) Misused EXCHANGEs. COMMENT?

Facilities that a runtime environment can provide to aid debugging:
   a) Reporting of detected faults by activity name/module name/line number
   b) Stop execution
   c) Report status of all activities
   c) Activation record trace for a particular activity
   d) Inspect local variables of a module
   e) Inspect global variables
   f) Modify variable
   g) Continue execution
   h) Start execution

7) COMPILER SEQUENCES NEEDING PERFORMANCE TAILORING

   <<<SEE SAFETRAN COMPILER MODS DOCUMENT>>>
8) RUNTIME ARCHITECTURAL SUPPORT FOR COMPILER SEQUENCES

   EXCHANGE, LOCK, WAIT, etc.

9) RUNTIME SPECIFICATION FOR COMPILER SUPPORT


TEST ENVIRONMENT

   Serial port to host
   Serial port to talk to programmer
   Debugger to allow low level debugging
   Use NMI for "Stop execution"
   FIRQ for "address out of range"
   IRQ for 2 Ms interrupt
   SWI for debugger

   Memory Organization


   !-----------------------!   (high addresses)
   !    Interrupt Vectors  !
   !-----------------------!
   !      I/O Window       ! -------------> to serial terminal for debugger
   !-----------------------!
   !        SDDBG          !   Standalone debugger
   !-----------------------!
   !                       !
   !  Run Time Environment !
   !                       !
   !-----------------------!
   !                       !
   !         RAM           !
   !       holding         !
   !     Application       !
   !      Software         !
   !                       !
   !-----------------------!  :8000
   !                       !
   !         RAM           !
   !       variable        !
   !       storage         !
   !                       !
   !-----------------------!
   !      NonVolatile      !
   !         RAM           !
   !-----------------------!
   !     Page Zero RAM     !
   !-----------------------!  :0000


10) INTERRUPT SYSTEM IDOSYNCRASIES (CLI, SEI, priorities must be
   addressed)

     /------------\
     !    IRQ     !
     \------------/
           |
           V
   ------------------
   ! Switch Stacks  !
   ------------------
           |
           |
           V
           ^
          / \
         /   \
        /     \
       /       \   YES
      <  EVENT? >---------------------> (as below)
       \       /
        \     /
         \   /
          \ /
           V  NO
           |
           V
           ^
          / \
         /   \
        /     \
       /       \   YES
      <  EVENT? >---------------------> (as below)
       \       /
        \     /
         \   /
          \ /
           V  NO
           |
           V
           ^
          / \
         /   \
        /     \
       /       \   YES
      <  EVENT? >---------------------------\
       \       /                            |
        \     /                             |
         \   /                              |
          \ /                               |
           V  NO                            |
           |                                |
           |                                V
           |                 -----------------------------------
           |                 !  JSR  SDMcodedinterruptroutine  !
           |                 -----------------------------------
           V                                |
    ---------------                         |
    !     RTI     ! <-----------------------/
    ---------------

      WHAT IF SDMcodedinterrupt routine DAMAGES SFP???

Who sets "TEST INT FLAG"? Who clears it? What does trigger event mean?

11) INITIALIZATION
   Need to initialize task list, stacks, locks, local storage required
by variables, etc, RAM data tables that require initz from ROM.

A problem with an application with multiple tasks is ensuring that the tasks
get reset in a controlled order that is application dependent. If no order for
reset is necessary at all, then all tasks may be started at once and simply
compete for the processor immediately.  If a particular order is required, it
can be accomplished in the following way. Without loss of generality, let us
call the first task which we desire to reset TASK1, the second, TASK2, etc.
Then the following structure ensures that the reset code for TASK1 is executed
before the reset code of TASK2, which is executed before the reset code of
TASK3, etc., regardless of the task priorities. We require that each task have
an SDOS/RT lock named TASKx_INITIALIZED. TASK1_INITIALIZED is special because
the reset code for the system starts it out in the locked state.  All other
locks start in an uninitialized state.

               TASK1
                 |
                 V
     ----------------------------
     ! RESET TASK2_INITIALIZED  !
     ! RESET TASK3_INITIALIZED  !
     ! RESET TASK4_INITIALIZED  !
     !           ...            !
     ! RESET TASKN_INITIALIZED  !
     ! UNLOCK TASK1_INITIALIZED !   \
     ! UNLOCK TASK1_INITIALIZED !    \
     !           ...            !     > N times
     ! UNLOCK TASK1_INITIALIZED !    /
     ! UNLOCK TASK1_INITIALIZED !   /
     !   <DO RESET FOR TASK1>   !
     ! UNLOCK TASK2_INITIALIZED !  (tell TASK2 that it can do its reset code)
     ----------------------------
                 |
                 V
          -----------------
          ! BODY OF TASK1 !
          -----------------


               TASK2
                 |
                 V
     ----------------------------
     !  LOCK TASK1_INITIALIZED  !  (ensures that TASK1 gets control first)
     !  LOCK TASK2_INITIALIZED  !  (this makes TASK2 wait for TASK1 reset done)
     !   <DO RESET FOR TASK2>   !
     ! UNLOCK TASK3_INITIALIZED !  (tell TASK3 that it can do its reset code)
     ----------------------------
                 |
                 V
          -----------------
          ! BODY OF TASK3 !
          -----------------


               TASK3
                 |
                 V
     ----------------------------
     !  LOCK TASK1_INITIALIZED  !  (ensures that TASK1 gets control first)
     !  LOCK TASK3_INITIALIZED  !  (this makes TASK3 wait for TASK2 reset done)
     !   <DO RESET FOR TASK3>   !
     ! UNLOCK TASK4_INITIALIZED !  (tell TASK4 that it can do its reset code)
     ----------------------------
                 |
                 V
          -----------------
          ! BODY OF TASK3 !
          -----------------


                 *
                 *                  (same diagram N-4 times)
                 *


               TASKN
                 |
                 V
     --------------------------------
     !  LOCK TASK1_INITIALIZED      !  (ensures that TASK1 gets control first)
     !  LOCK TASK(N-1)_INITIALIZED  !  (this makes TASKN wait for TASK(N-1) reset done)
     !   <DO RESET FOR TASKN>       !  (no need to tell anybody else)
     --------------------------------
                 |
                 V
          -----------------
          ! BODY OF TASK3 !
          -----------------

One could allow some tasks to perform their reset code in paralell, but it
gets complicated to think about, and since the system need not run fast
at reset time, there is no advantage to doing so.


IT WOULD BE REALLY NICE IF COMPILER WOULD COMPILE GLOBAL DATA AS A SEPERATE
MODULE, WOULD MEAN THERE WOULD NOT BE SO MUCH HAND CODING OF THE
APPLICATION DATA MODULE.  I LIKE THE IDEA!
Who owns pool variables? exchanges? locks? etc.? (Harold says, Hardware Module)

12) INTERFACE REQUIREMENTS

Fill up H/W definition module with more stuff...everything that needs
to be defined
What to do if error detected? Three policies: restart system is
one, log error and continue (how?), give control to debug

Reset code must act identically to JMP [$FFFE] so that system restart
is possible by literally doing JMP [$FFFE].  THIS MEANS THAT RESET
CODE CANNOT DEPEND ON RESET PULSE TO PLACE I/O DEVICES IN RESET STATE;
THE RESET CODE MUST EXPLICITLY RESET EACH DEVICE COMPLETELY.



<NEED TO RECORD THE 15 POINTS>
------------------------------------
>>> IMPLEMENT LOCK AND UNLOCK VIA EXCHANGE? NO. PUT IN SPECIAL
EXCHANGE LOGIC, AS WELL AS LOCK/UNLOCK (BECAUSE IT IS MORE NATURAL)
CAN COMPILER INITAILIZE AN ARRAY OF READ-ONLY DATA? IF SO, THEN A
TEXT STRING IS EASILY HANDLED AT COMPILE TIME, ELSE MUST PUT TEXT
STRNG INTO GLOBAL MODULE>

NEED STACK OVER/UNDERFLOW CHECKS.
NEED MISUSED EXCHANGE CHECK (3 tasks using same exchange)
NEED MISSED TASK DEADLINE CHECK ...hmm...


.PA
The 2 Millisecond interrupt routine serves 3 functions for MGCP:
    a) it generates unique signature signal to keep grade crossing
       gate raised, only if it has been told to do so recently.
    b) if not told to raise gate recently, it lowers the gate
       by NOT issuing the unique signature signal (this handles
       the prediction logic computing proper answers, and also
       handles many failures)
    c) provides TICKS to SDOSRT to allow clock tick routines
       to run.
A schematic of the interrupt routine is shown.  The corresponding assembly code
for it should be extremely short and easy to understand and validate.
GATEUP is XDEF'd so that the prediction task can set it non-zero
if it predicts "no train will arrive soon".  If GATEUP is a single
byte, the prediction task must set it 255 every 500 milliseconds or
the real gate will drop.

       ---------------
      < 2Ms Interrupt >
       ---------------
              |
              |
              ^
             / \
            /   \
           /     \
          /       \   >0 (set nonzero when prediction task sez "no train")
         <  GATEUP >---------------------------\
          \       /                            |
           \     /                             |
            \   /                              |
             \ /                               |
              V  =0                            |
              |                                |
              |                                V
              |                 --------------------------------------
              |                 !       GATEUP := GATEUP -1          !
              |                 ! Send special signal to gateup hdwe !
              |                 --------------------------------------
              |                                |
    !-------------------!                      |
    !      A:=2         !<---------------------/
    !-------------------!
              |
              |
        ------------
       <   RTTICK   >
        ------------
              |
              V
           -------
          <  RTI  >
           -------



<NEED TO SPECIFY WHAT HAPPENS TO ALL
HARDWARE VECTORS> <NEED TO RESERVE SWI VECTOR FOR SDDBG> <ALL MODULES MUST
BE LISTED IN THE GCBGLB MODULE SO THAT A RESET ROUTINE IN EACH MODULE CAN
BE CALLED AT RESET TIME, BEFORE APPLICATION PROGRAM EXECUTES>

IMPLEMENTING THE SDM EXCHANGE MECHANISM

To keep within the spirit of the original SDM language design document,
SDMSPT provides support routines to implement the EXCHANGE primitive.
Two kinds of exchanges are allowed by the language: a "standard" exchange,
in which the first activity executing an EXCHANGE waits for second to
do the same, and then a single scalar value is exchanged.
The second type is a REALTIME EXCHANGE, which, when executed, determines if
another activity is already waiting, and if so, proceeds with a standard
exchange, and if not, aborts the exchange; a boolean result of the REALTIME
EXCHANGE indicates TRUE if the exchange was succesful, and false if aborted.
Ideally, an exchange should operate regardless of whether the other
activity is software or hardware. A single interface is provided to
the compiler that implements these ideas properly.


>>>THIS CODE NEEDS COMPLETE REWRITE
? How does SDM ensure that only two tasks reference an exchange at any one
time? <CAN IMPLEMENT EXCHANGE BY:
     <initialize SDOSRT LOCK to -2 resources>

* DECLARE <channel> generates following code:
<channel> RMB  SCB:SIZE                reserve storage for Semaphore
          RMB  4                       data exchange area

RESET     CLR  <channel>+4             note: 1st task thru code
          LDX  #<channel>
          JSR  RTISCB                  reset semaphore
          LDA  #-2                     lock semaphore twice too often(??)
          STA  SCB:COUNT
          ...
          RTS

* EXCHANGE <channel> generates following code:
         LD?  value                    fetch value to exchange
         LDX  #<channel>
         JSR  SDMXCHG                  call RTE support routine
         ST?  value                    store exchanged value
     ...
SDMXCHG EQU * ; SDM RTE support routine to implement exchange
* (X) points to channel (SDOSRT Semaphore)
         pshs  x,y,u,a,b               save value to exchange
         jsr   RTUNLK                  unlock semaphore
* Note: 2 unlocks needed to cause an exchange
         jsr   RTLOCK                  lock the semaphore
* Assert: can't get here unless 2 UNLOCKs applied to same channel!
             ??? more thought needed here???



APPGLB: APPLICATION PROGRAM GLOBAL DATA MODULE ORGANIZATION

The module APPGLB contains Pools, Channels, and other data specified as global
by the various SDM application modules.  It also contains tables used by SDMDBG
and INTRPT to locate SDM-compiled modules. This module is coded by hand, in
assembly code.

The global table ACTVTS specifies the list of "activities" defined by the SDM
application program modules, by giving information about each activity. The
>>>> NEED NOTE REFERENCING SDOSRT INTERFACE REQUIREMENTS, saying they
are nodfned in this document, but form a basis for all.


programmer must specify, for each activity, a pointer to an SDOS/RT Task
Control Block, the task priority, a Stack area and size, and the starting
address of each activity.  The Task Control block and stack area for each task
are reserved within the APPGLB module, but are filled in the the RESET code in
INTRPT.  The start address for each task is defined externally to 