	TITLE	- - -   D E C O D E   L I N E   - - -
	PAGE	- - -   D O I T L   - - -
*
*  DOITL--
*
*        DECODES COMMAND AND FIGGERS OUT WHAT TO DO W/ IT.
*
*	(1)	IF CF(1) IS 3 OR 4 CH, SCAN OPTABLE FOR VALID OP;
*
*	(2)	IF NOT (1) THEN SCAN LONG OPCODE TABLE;
*
*        (3)      IF NOT (1) OR NOT (2) THEN IF CF(1) IS A SYMBOL ONLY,
*                 AND IF THAT SYMBOL IS IN THE PSUEDO-OP TABLE,
*                 (USER OR ASSEMBLER) THEN WE SCAN A DIRECTIVE.
*
*        (4)      IF NOT (3) THEN CF IS HANDLED AS A FUNNY
*                 DATA EXP.
*
*        AFTERWARDS, LIST IS CALLED.
*
*
DOITEX9	JSR	LFPC	Set Label Field sym to PC value
	JMP      DOITEX

DOITL    EQU      *
         LDX      CFPTR
         STX      AFPTR             PREPARE TO LOOK FOR AF.
         JSR      CHCFSYM           IS CF(1) A SYMBOL??
         BNE      DOITEX9           B/ NO==> GO TREAT AS FUNNY DATA STAT
	CMPB	#ASCII:COMMA	CK/ IS TERMINATOR A COMMA? (B SET BY CHCFSYM)
	BEQ	DOITEX9	  B/ YUP.  CAN'T BE OPCODE.
	PAGE	MC6805 Opcode Processing
OP6805	CLRA		Initialize:
	STAA	OPSIZE	Op code size (may include operand)
	STAA	PZBYTE	CLEAR PAGE ZERO BYTE ADDRESS
	STAA	PZINST	PAGE ZERO BIT MANIPULATION INST FLAG
	STAA	JMACFLG	CLEAR JUMP MACRO FLAG

	LDAA	SYM	Get symbol length
	CMPA	#4	Large symbol?
	BGT	DOITOPBIG	B/Yes
	BEQ	DOITOP	B/4 Characters

	LDAA	#$20	=Blank
	STAA	SYM+4	  into 4th character position
	PAGE
	IF	M6809=0
DOITOP	LDX	#OPTBL	Scan for 4 character op code
DOITOPSL	STX	OPPTR	Save pointer into OPTBL
	LDX	0,X	Get 1st two bytes of op
	BMI	DOITOPBIG	B/End of OPTBL
	CPX	SYM+1	Match??
	BNE	DOITOPS	B/No	
	LDX	OPPTR
	LDX	2,X	2nd two byte of op
	CPX	SYM+3	Match??
	BEQ	DOOPF	B/Yes
DOITOPS	LDX	OPPTR	Step pointer
	RPT	7
	INX
	BRA	DOITOPSL
	ELSE
DOITOP	LDY	#OPTBL	Scan for 4 character op code
DOITOPSL
	LDX	0,Y	Get 1st two bytes of op
	BMI	DOITOPBIG	B/End of OPTBL
	CPX	SYM+1	Match??
	BNE	DOITOPS	B/No	
	LDX	2,Y	2nd two bytes of op
	CPX	SYM+3	Match??
	BEQ	DOOPF	B/Yes
DOITOPS	LEAY	7,Y	Step pointer
	BRA	DOITOPSL
	FIN
	PAGE
DOITOPBIG LDX	#M6805LONG	Long opcode table 
	JSR	FSYM1	 and look it up
	BNE	DOITDR	B/Not found
	BRA	DOOPBG

DOOPF
	IF	M6809=1
	TFR	Y,X
	ELSE
	LDX	OPPTR	Load pointer
	FIN
	LEAX	2,X	Adjust to match symbol table offset
DOOPBG	JMP	DOOPC	Do opcode processing
	INCLUDE	D3:ASM15.DREX.ASM	*********************
	TITLE	 - - - O P C O D E    P R O C E S S I N G - - -
	PAGE	GET OP CHARACTER DETERMINATION
DOOPC	STX	OPPTR	Save for optype processing
	JSR	LFPC	Set label if any
	JSR	FINDAF
	LDX	OPPTR
	LDAA	OT:OPCD,X	Save
	STAA	OP	 Opcode
	LDAA	OT:OPER,X	Save
	STAA	GRP	 Operand flags
DOOPC1	JSR	OPSET	Do opcode setup and AF processing
	TST	JMACFLG	JUMP MACRO ?
	BEQ	DOOPC2	 No
	JSR	OPCONDJUMP	Yes, Conditional jump macro
DOOPC2	CLRA		Add nothing to OP before output to BO
	JSR	OUTCODE	Output the code
	JMP	LIST


	PAGE
	TITLE	Opcode and argument field setup and Processing
*
*	OPSET	Opcode and argument field setup and processing
*
*	This subroutine calls the proper opcode class routine to generate
* an address mode adjusted opcode and correct operand bytes.  If the
* opcode in OP has be set to $00 then the opcode will be biased for the
* for the monadic class of opcodes.  If OP  is < $80 then the
* opcode would be biased for the didatic class of opcode address modes.
*

OPSET
	CLRA		Initialize:
	STA	VAL	Clear expression accumulator
	STA	VAL+1
	STAA	PZBYTE	CLEAR PAGE ZERO BYTE ADDRESS
	STAA	PZINST	PAGE ZERO BIT MANIPULATION INST FLAG
	STAA	JMACFLG	CLEAR JUMP MACRO FLAG
	LDAA	#1	Assume opcode size of 1
	STAA	OPSIZE
	LDX	OPPTR	Point to op info again
	LDAB	OT:TYPE,X	Get op type word
	ANDB	#OTM:CLAS	 and mask for class
	LSRB		Shift to
	LSRB		 be a
	LSRB		  word index
	JSR	LDAXB	   and add
	OPCLASTABEL		    to class table
	LDX	0,X	Get routine address
	LDAB	GRP	Load flags
	JSR	0,X	 and call it
	BCC	NOERRORS	B/NO SYNTAX ERRORS
	LDX	#0	Clear VAL
	STX	VAL
	JSR	SYNTAX
NOERRORS
	RTS



*
* OPCODE CLASS TABLE
*
OPCLASTABEL
	#BITTEST
	#BITBRANCH
	#BRANCH
	#GENERAL
	PAGE
	TITLE	Output Opcode and Operand Bytes to BO
*
*	OUTCODE	Output opcode and operand bytes to BO
*
*	This routine outputs the opcode and operand bytes generated by
* OPSET.  This routine may only be used after a call to OPSET.
*
*	A-Reg	Value to bias OP by before output to BO
*

OUTCODE
	ADDA	OP	A-Reg + OP is value to output
	STAA	OP
	JSR	PUTB	 AND OUTPUT IT
	DEC	OPSIZE
	LDAA	PZBYTE	Do we have
	TST	PZINST	 page zero op?
	BEQ	NOPZ	B/NO
	JSR	PUTB	Output page zero byte
	DEC	OPSIZE
	CLR	PZINST	Reset flag
NOPZ	TST	OPSIZE	ANY OPERAND?
	BEQ	NOOPERAND	B/NO
	DEC	OPSIZE	2 BYTE OPERAND?
	BNE	OUTOPERAND2	B/Yes
	LDA	VAL	H.O. = 0?
	BEQ	OUTOPERAND	B/Yes
	JSR	OVRFLW	Overflow in byte in byte operand
	BRA	OUTOPERAND	 and output byte anyway

OUTOPERAND2
	LDA	VAL	Output H.O. byte
	JSR	PUTB
OUTOPERAND
	LDAA	VAL+1	OUTPUT L.O. BYTE
	JSR	PUTB
NOOPERAND
	RTS
	PAGE
*
* OPCONDJUMP
*
*	Output is effectively:
*		Bxx  Q
*		JMP  oper
*	       Q:
*
OPCONDJUMP
	LDA	OP	Invert
	EORA	#1	 branch
	STA	OP	  condition
	DEC	OPSIZE	Suppress branch offset output
	CLRA		(No opcode bias)
	JSR	OUTCODE	Output branch less offset
	LDX	PC	Bias PC
	INX		 by +1
	STX	PC	  for operand evaluation
	LDX	#JMPOP	Force JMP opcode
	STX	OPPTR	 entry in opcode table pointer
	LDX	OPPTR
	LDAA	OT:OPCD,X	Save
	STAA	OP	 Opcode
	LDAA	OT:OPER,X	Save
	STAA	GRP	 Operand flags
	JSR	OPSET	Do operand evaluation
	LDX	PC	Put PC
	DEX		 back the way
	STX	PC	  it was
	LDAA	OPSIZE	Get full instruction size
	JSR	PUTB	 and output it as offset byte of branch
	RTS
         PAGE     - - - C H I M M - - -
*13*
*
*
* SUBROUTINE TO CHECK FOR IMMEDIATE INSTRUCTIONS:
* IF IT IS IMMEDIATE, THEN RETURNS Z=1, AND SETS VAL
* TO VALUE OF EXPRESSION.  OTHERWISE, RETURNS Z=0.
*
CHIMM    LDX      AFPTR             GET POINTER TO FIRST CH.
         BEQ      CHIRTN            B/ NO AF; NOT IMMEDIATE.
         LDAA     0,X               GET FIRST CH OF AF.
         CMPA     #'#               IS IT IMMEDIATE QUALIFIER?
         BNE      CHIRTS            B/ NO # AT START ==> NOT IMMEDIATE.
	JSR	OPFIXIM	SET FOR IMMEDIATE

	LDX	AFPTR
	INX                        POINT AT NEXT CH,
         JSR      EVAFX             GO EVALUATE THE EXPRESSION.
         CLRB                       SET APPROPRIATE CC.
CHIRTS   RTS                        AND EXIT, SUCCESS.
*
CHIRTN   INX                        SET CC # 0,
         RTS                        AND EXIT, FAIL.
         PAGE     - - - B R A N C H E S - - -
*
* RELATIVE BRANCHES:
BRANCH	INC	OPSIZE	ASSUME ONE BYTE OF OFFSET
	LDX	OPPTR	Direct invocation
	LDA	OT:TYPE,X	 of a jump macro?
	BMI	JUMP	Yes
	JSR      EVAF              EVALUATE THE ARG...
	CMPB     #ASCII:COMMA	TERMINATOR A COMMA?
	BNE      BRAN1             B/ NO:  NOT TRYING TO INDEX.
	JSR      ILLAF             *E* TRIED TO INDEX A BRANCH.
BRAN1    LDAA     XTYPE             GET THE EXPRESSION TYPE
	BITA     #XT:FREF!XT:UNDF  IS IT EASY TO CHECK?
	BEQ      BRAN2             B/ YES.
	TST      PASS              IS THIS PASS 1?
	BEQ      OUT222             B/ YES
* CHECK FOR OUT OF RANGE BRANCH
BRAN2    LDAB     VAL+1             GET THE VALUE
	LDAA     VAL
	SUBB     PC+1
	SBCA     PC                (A,B) := VAL-(PC+OPSIZE)
	SUBB     OPSIZE
	STAB     VAL+1             SAVE NEW VAL,
	SBCA     #0
	STAA	VAL
	BMI      BRANN             CHECK VAL FOR IN RANGE...
	BRA	BRANP	VALUE IS POSITIVE


BRANE    JSR      BRANERR           *E* OUT OF RANGE BRANCH
	CLRA		GENERATE A "BRA *"
	CLRB
	SUBB	OPSIZE
	SBCA	#0
	STAA	VAL
	STAB     VAL+1
OUT222	CLR	VAL	Make operand an "8-bit value
	CLC
	RTS	    	AND OUTPUT THE CODE
	PAGE
*
* BRANCH IN NEGATIVE DIRECTION.
*
BRANN	COMA
	COMB                       PREPARE FOR RANGE CHECK.
*
* BRANCH IN POSITIVE DIRECTION.
* UNSIGNED.
*
BRANP	TSTA		<255?
	BNE	BRANTCHK	B/NO
	TSTB		<128?
	BGE      OUT222             B/ YES, B IS UNSIGNED ==> GOOD
BRANTCHK
	LDAA	XTYPE	EVALUABLE??
	BITA	#XT:FREF!XT:UNDF!XT:UNEV
	BNE	BRANE	B/NO - FIX HIS WAGON

	LDA	OPT1F	Get flags
	BITA	#OPT1:JMAC	Automatic jump macros allowed ?
	BEQ	BRANE	No
	LDA	BSROPCODE
	CMPA	OP
	BEQ	MAKEJSR
JUMP	INC	JMACFLG	Flag jump macro
	CLC
	RTS



MAKEJSR			;CHANGE TO JSR
	LDX	#JSROP
	STX	OPPTR
	LDA	OT:OPCD,X
	STA	OP
	LDA	OT:OPER,X
	STA	GRP
	JSR	EVAF	Evaluate AF for JSR processing
	JMP	DOITTO	Go do JSR instruction

*
* Bit Test Instruction
*
BITTEST
	INC	OPSIZE	Bump opsize to include page zero byte
	JSR	EVAF	Get bit number
	LDA	VAL	H.O. byte zero ?
	BNE	BITBIG	No, error
	LDA	VAL+1	Value
	CMPA	#7	 less than 8 ?
	BHI	BITBIG	No, only 8 bits per byte
	ASLA		Position bit number
	ORA	OP	Put into op
	STA	OP	 and update it
	JSR	GTCMA	"," ?
	BVC	BITBAD	No, syntax error
	LDX	EXPTR	Get expression pointer
	JSR	EVAFX	 to scan page zero byte number
	LDA	VAL	Value > 255 ?
	BNE	BITBIG	Yes, error
	LDA	VAL+1	Get byte number
	STA	PZBYTE	Set byte number
	INC	PZINST	Flag PZBYTE set
	CLC		Good return
	RTS

* Field overflow
BITBIG	JSR	OVRFLW
	RTS

* Illegal argument for format
BITBAD	JSR	ILLAF
BITBYE	RTS
	PAGE

*
* Bit branch instructions
*
BITBRANCH
	INC	OPSIZE	Count branch offset byte
	JSR	BITTEST	Process bit number and page zero byte
	JSR	GTCMA	"," ?
	BVC	BITBAD	No, error
	LDX	EXPTR	Reset argument field
	STX	AFPTR	 to point past comma
	DEC	OPSIZE	Backup to so BRANCH can inc again
	JMP	BRANCH	Go process branch offset
	PAGE	RECOVERY ROUTINE FOR REGISTER SCANNERS
*+
* BURP	Branch Unconditonally to Recovery Proceedure
*
* This routine unwinds the stack until it finds a BSR or JSR which is
* followed by a BCS or BCC.  The carry is then set and control given
* to the BCC or BCS.
*-
BURP	TSX		GET STACK POINTER
BURP1	STX	TEMPX	SAVE POINTER INTO STACK
	LDX	0,X	GET ADDRESS FROM STACK
	LDAA	0,X	GET OPCODE AT RETURN ADDRESS
	CMPA	#$24	BCC?
	BEQ	BURPUP	B/YES
	CMPA	#$25	BCS?
	BEQ	BURPUP	B/YES
	LDX	TEMPX	RELOAD POINTER INTO STACK
	LEAX	2,X
	BRA	BURP1

BURPUP	LDX	TEMPX	GET THAT VALID NEW STACK POINTER
	TXS		ZAPPA THE STACKA
	SEC		SET DA CARRY
	RTS
	PAGE	GENERAL TYPE
*+
* GENERAL TYPE	(OLD MONADIC AND DIDATICS)
*
*-
GENERAL
	TST	GRP	ANY OPERANDS?
	BNE	DOITTOIT	B/YES
	CLC
	RTS
	PAGE	6805 Dydatic (Memory Ref) Operand Processing
*+
*	Operand Processing for Memory Reference (Dydatic) Instructions
*
*	Modes:	Immediate
*		Extended
*		Direct
*		Indexed
*-

ABTBL	#DOITTO		Direct or Extended not specified
	#DOITTDR		"<" Force Direct
	#DOITTOXF	">" Force Extended


DOITTOIT
	INC	OPSIZE	Bump for argument (at least 1 byte)
	JSR	CHIMM	Check for Immediate
	BEQ	DOSHIP	B/Immediate
	JSR	ABRKTEST	Check for "<",">"

	LDX	AFPTR	Set Expression
	STX	EXPTR	 Pointer
	JSR	GTCMA	Comma Found??
	BVS	DOITIDX	B/Yes, Indexed for sure

	JSR	EVAF	Get AF Value for Direct or Extended
	LDAB	ABRKT	Get Bracket ("<") Flag if any
	JSR	TBJMP	Branch on flag value (0-2)
	#ABTBL		(Angle Bracket TaBLe)

DOSHIP	CLC
	RTS		SHIPIT
	PAGE


*	Direct or Extended not specified


DOITTO	LDA	GRP	Check if extended
	BITA	#OTF:EXT	 allowed for this op
	BEQ	DOITTDR	No, must be direct or nothing
	LDAA	XTYPE	Expression Evaluable??
	BITA	#XT:FREF!XT:UNDF!XT:UNEV
	BNE	DOITTOXF	B/No, Force Extended

	LDAA	VAL	Yes, >8 bits??
	BNE	DOITTOXF	B/Yes, Must be extended

DOITTDR	JSR	OPFIXDR	Adjust op to Direct mode
	BRA	DOSHIP


DOITTOXF
	INC	OPSIZE	Make Extended
	JSR	OPFIXEX	Make op Extended
	BCS	BADFORCE	Illegal ">"
	BRA	DOSHIP


*	Bad forced reference ("<" or ">")
*
BADFORCE
	JSR	FRCREFERR
	RTS
*	Indexed Addressing
*
DOITIDX
	LDX	EXPTR	Is
	LDA	0,X	 character after ","
	CMPA	#'X	  an "X" ?
	BEQ	DOIDXED	Yes
	JSR	ILLAF	No, illegal argument field
	RTS

DOIDXED
	LDX	AFPTR	Check for ",X"
	LDA	0,X	Get first char of AF
	CMPA	#',	"," ??
	BEQ	DOIDXED1	Yes
	JSR	EVAF	Evaluate AF for offset
DOIDXED1
	LDAB	ABRKT	Get Bracket ("<") Flag if any
	JSR	TBJMP	Branch on flag value (0-2)
	#IDXABTABL	InDeXAngleBracketTaBLe

IDXABTABL
	DOSIZEIDX	No brackets
	DOITIDX1		"<"
	DO16BIT		">"

DOSIZEIDX
	LDA	XTYPE	Expression evaluable ?
	BITA	#XT:FREF!XT:UNDF!XT:UNEV
	BNE	DO16BIT	No
	LDX	VAL	Zero offset ?
	BNE	DO8BIT	No
DOITIDX0
	JSR	OPFIXIDX0	Yes
	DEC	OPSIZE	No operand byte
	CLC
	RTS

DO8BIT	LDA	GRP
	BITA	#OTF:IND2	16-Bit addressing allowed ?
	BEQ	DOITIDX1	No, assume 8 or less
	LDA	VAL	High order byte zero ?
	BNE	DO16BIT	No
DOITIDX1
	JSR	OPFIXIDX1	1 byte offset
	RTS

DO16BIT
	JSR	OPFIXIDX2	2 byte offset
	BCS	BADFORCE	Illegal ">"
	INC	OPSIZE	Correct opsize
	RTS



	PAGE
*+
* ABRKTEST	Angle Bracket Test
*
* This routine will step AFPTR past "<", ">" if they are there.
*
* Returns:	AFPTR updated (if Angle Brackets found)
*		X-Reg = AFPTR
*		A-Reg   Destroyed
*		B-Reg = 0 -> No Angle Brackets
*		        1 -> "<"
*		        2 -> ">"
*		ABRKT = B-Reg
*-
ABRKTEST
	CLRB		Assume none
	LDX	AFPTR	Get 1st
	LDAA	0,X	 character of AF
	CMPA	#'<	Angle Bracket??
	BNE	ABRK1	B/No, Try other
	BRA	ABRK2	Yes

ABRK1	CMPA	#'>	Going my way??
	BNE	ABRK3	B/No, Not any at all
	INCB
ABRK2	INX		Step AFPTR
	INCB

ABRK3	STAB	ABRKT	Save flag
	STX	AFPTR	Update AFTPR
	RTS
	PAGE	Set Addressing Mode (and see if legal)
*+
* OPFIX
*
* This routine adds a "correction" to the opcode to produce the correct
* addressing mode.  The instructions with a base opcode of < $80 have
* a different correction than those above.
*
*	NOTE: B-register is preserved through operation
*
*-
OPFIXIM	JSR	OPFIX	Immediate addressing mode
OPFIXDR	JSR	OPFIX	Direct addressing mode
OPFIXEX	JSR	OPFIX	Extended addressing mode
OPFIXIDX0	JSR	OPFIX	Indexed (0) addressing mode
OPFIXIDX1	JSR	OPFIX	Indexed (1) addressing mode
OPFIXIDX2	JSR	OPFIX	Indexed (2) addressing mode


OPFIXTAB
	FCB	0,0,OTF:IMM	Immediate Factors
	FCB	0,$10,OTF:DIR	Direct Factors
	FCB	0,$20,OTF:EXT	Extended Factors
	FCB	$40,$50,OTF:IND0	Indexed (0) Factors
	FCB	$30,$40,OTF:IND1	Indexed (1) Factors
	FCB	$20,$30,OTF:IND2	Indexed (2) Factors

OPDISP	EQU	OPFIXTAB-OPFIXDR	Displacement to table entries

OPFIX	PULX		Get biased pointer into OPFIXTAB
	LDAA	GRP	Load operand flags
	BITA	OPDISP+2,X	Is addressing mode permitted??
	BEQ	OPBURP	B/no
	LDAA	OP	Dydatic Op??
	BPL	OPFIX2	B/No
	INX		Step to Dydatic entry
OPFIX2	ADDA	OPDISP,X	Add in correction factor
	STAA	OP	  and update OP
	RTS

OPBURP	JMP	BURP
	PAGE	Op Code Type/Control Byte Definitions 6805
*
*		Opcode Type Byte	OT:TYPE
*
*             0 1 2 3 4 5 6 7
*             - ----- -------
*             !  !    RESERVED
*             !  !
*             !  !
*       +-----+  !
*  JMP MACRO     !
*     Flag       !
*                !   
*                !  
*              CLASS
*              -----
*	0 = BIT SET/CLEAR             OTF:BSC
*	1 = BIT BRANCH                OTF:BB
*	2 = Branch (relative) class   OTF:BRA
*	3 = General (old monadics, diadatics)  OTF:GEN
*
*
*		Operand Flag Byte	OT:OPER
*
*              0 1 2 3 4 5 6 7
*              --- - - - - - -
*               !  ! ! ! ! ! !
*               !  ! ! ! ! ! !
*               !  ! ! ! ! ! Extended Addressing  OTF:EXT
*               !  ! ! ! ! !
*               !  ! ! ! ! Immediate Value Addressing  OTF:IMM
*               !  ! ! ! !
*       +-------+  ! ! ! Direct Addressing  OTF:DIR
*    Reserved      ! ! !
*                  ! ! Indexed Addressing (NO OFFSET) OTF:IND0
*                  ! !
*                  ! Indexed Addressing (1 BYTE) OTF:IND1
*                  !
*                  Indexed Addressing (2 BYTE) OTF:IND2
*                 
	PAGE
*	Opcode Table Entry Layout for 6805
*
*	+--------+--------+--------+--------+
*	!  Four  !  Bytes !   of   !  Text  !
*	+--------+--------+--------+--------+
*
*	+--------+
*	!  Type  !	One byte of type   OT:TYPE
*	+--------+
*
*	+--------+
*	!  Flags !    	One byte of flags  OT:OPER    
*	+--------+
*
*	+--------+
*	! Opcode !    	Opcode Value       OT:OPCD    
*	+--------+
*
**	There are 7 bytes per entry in the 6805 Opcode table
*
*
*
*

OT:TYPE	EQU	2	Offset for type byte
OT:OPER	EQU	3	Offset for operand flags
OT:OPCD	EQU	4	Offset for opcode value
	PAGE
*
*	Flag Byte Definitions
*
OTF:EXT	EQU	1	Extended
OTF:IMM	EQU	2	IMMEDIATE
OTF:DIR	EQU	4	Direct
OTF:IND0	EQU	8	INDEXED, NO OFFSET
OTF:IND1	EQU	$10	INDEXED, 1 BYTE OFFSET
OTF:IND2	EQU	$20	INDEXED, 2 BYTE OFFSET

OTF:BSC	EQU	$0000	BIT SET/CLEAR
OTF:BB	EQU	$1000	BIT BRANCH
OTF:BRA	EQU	$2000	Branch
OTF:GEN	EQU	$3000	Old monadics & didatics
OTF:JMAC	EQU	$8000	JMP MACRO


*
*	Common flag combinations
*
OTF:NIL	EQU	OTF:GEN		No Argument Field
OTF:MON	EQU	OTF:IND0!OTF:IND1!OTF:DIR!OTF:GEN	Memory reference monadic
OTF:DYD	EQU	OTF:MON!OTF:IND2!OTF:IMM!OTF:EXT	Dydatics
OTF:SBR	EQU	OTF:BRA	Short branchs

OTM:MSK	EQU	OTF:DYD	MASK FOR FLAGS
OTM:CLAS	EQU	$70	CLASS MASK FOR TYPE WORD

	PAGE	OPCODE TABLE
OPTBL
	FCC	'ADC '
	#OTF:DYD,$A9
	FCC	'ADCA'
	#OTF:DYD,$A9	;6809/6800 (ADC)
	FCC	'ADD '
	#OTF:DYD,$AB
	FCC	'ADDA'
	#OTF:DYD,$AB	;6809/6800 ADD
	FCC	'AND '
	#OTF:DYD,$A4
	FCC	'ANDA'
	#OTF:DYD,$A4	;6809/6800 AND
	FCC	'ASL '
	#OTF:MON,$38
	FCC	'ASLA'
	#OTF:NIL,$48
	FCC	'ASLX'
	#OTF:NIL,$58
	FCC	'ASR '
	#OTF:MON,$37
	FCC	'ASRA'
	#OTF:NIL,$47
	FCC	'ASRX'
	#OTF:NIL,$57
	FCC	'BCC '
	#OTF:SBR,$24
	FCC	'BCLR'
	#OTF:BSC,$11
	FCC	'BCS '
	#OTF:SBR,$25
	FCC	'BEQ '
	#OTF:SBR,$27
	FCC	'BHCC'
	#OTF:SBR,$28
	FCC	'BHCS'
	#OTF:SBR,$29
	FCC	'BHI '
	#OTF:SBR,$22
	FCC	'BHS '
	#OTF:SBR,$24
	FCC	'BIH '
	#OTF:SBR,$2F
	FCC	'BIL '
	#OTF:SBR,$2E
	FCC	'BIT '
	#OTF:DYD,$A5
	FCC	'BITA'
	#OTF:DYD,$A5	;6809/6800 BIT
	FCC	'BLS '
	#OTF:SBR,$23
	FCC	'BLO '
	#OTF:SBR,$25
	FCC	'BMC '
	#OTF:SBR,$2C
	FCC	'BMS '
	#OTF:SBR,$2D
	FCC	'BMI '
	#OTF:SBR,$2B
	FCC	'BNE '
	#OTF:SBR,$26
	FCC	'BPL '
	#OTF:SBR,$2A
	FCC	'BRA '
	#OTF:SBR,$20
	FCC	'BRN '
	#OTF:SBR,$21
	FCC	'BSET'
	#OTF:BSC,$10
BSROPCODE EQU *+6
	FCC	'BSR '
	#OTF:SBR,$AD
	FCC	'CLC '
	#OTF:NIL,$98
	FCC	'CLI '
	#OTF:NIL,$9A
	FCC	'CLR '
	#OTF:MON,$3F
	FCC	'CLRA'
	#OTF:NIL,$4F
	FCC	'CLRX'
	#OTF:NIL,$5F
	FCC	'CMP '
	#OTF:DYD,$A1
	FCC	'CMPX'
	#OTF:DYD,$A3	;6809/6800 CPX
	FCC	'COM '
	#OTF:MON,$33
	FCC	'COMA'
	#OTF:NIL,$43
	FCC	'COMX'
	#OTF:NIL,$53
	FCC	'CPX '
	#OTF:DYD,$A3
	FCC	'DAA '
	#OTF:NIL,$8D
	FCC	'DEC '
	#OTF:MON,$3A
	FCC	'DECA'
	#OTF:NIL,$4A
	FCC	'DECX'
	#OTF:NIL,$5A
	FCC	'DEX '
	#OTF:NIL,$5A	;6800 DECX
	FCC	'EOR '
	#OTF:DYD,$A8
	FCC	'INC '
	#OTF:MON,$3C
	FCC	'INCA'
	#OTF:NIL,$4C
	FCC	'INCX'
	#OTF:NIL,$5C
	FCC	'INX '
	#OTF:NIL,$5C	;6800 INCX
	FCC	'JCC '
	#OTF:SBR!OTF:JMAC,$24
	FCC	'JCLR'
	#OTF:BB!OTF:JMAC,$01
	FCC	'JCS '
	#OTF:SBR!OTF:JMAC,$25
	FCC	'JEQ '
	#OTF:SBR!OTF:JMAC,$27
	FCC	'JHCC'
	#OTF:SBR!OTF:JMAC,$28
	FCC	'JHCS'
	#OTF:SBR!OTF:JMAC,$29
	FCC	'JHI '
	#OTF:SBR!OTF:JMAC,$22
	FCC	'JHS '
	#OTF:SBR!OTF:JMAC,$24
	FCC	'JIH '
	#OTF:SBR!OTF:JMAC,$2F
	FCC	'JIL '
	#OTF:SBR!OTF:JMAC,$2E
	FCC	'JLS '
	#OTF:SBR!OTF:JMAC,$23
	FCC	'JLO '
	#OTF:SBR!OTF:JMAC,$25
	FCC	'JMC '
	#OTF:SBR!OTF:JMAC,$2C
JMPOP	EQU	*+2
	FCC	'JMP '
	#OTF:DYD!!OTF:IMM,$AC
	FCC	'JMS '
	#OTF:SBR!OTF:JMAC,$2D
	FCC	'JMI '
	#OTF:SBR!OTF:JMAC,$2B
	FCC	'JNE '
	#OTF:SBR!OTF:JMAC,$26
	FCC	'JPL '
	#OTF:SBR!OTF:JMAC,$2A
	FCC	'JRA '
	#OTF:SBR!OTF:JMAC,$20
	FCC	'JRN '
	#OTF:SBR!OTF:JMAC,$21
	FCC	'JSET'
	#OTF:BB!OTF:JMAC,$00
JSROP	EQU	*+2
	FCC	'JSR '
	#OTF:DYD!!OTF:IMM,$AD
	FCC	'LDA '
	#OTF:DYD,$A6
	FCC	'LDAA'
	#OTF:DYD,$A6	;6800 LDA
	FCC	'LDX '
	#OTF:DYD,$AE
	FCC	'LSL '
	#OTF:MON,$38
	FCC	'LSLA'
	#OTF:NIL,$48
	FCC	'LSLX'
	#OTF:NIL,$58
	FCC	'LSR '
	#OTF:MON,$34
	FCC	'LSRA'
	#OTF:NIL,$44
	FCC	'LSRX'
	#OTF:NIL,$54
	FCC	'NEG '
	#OTF:MON,$30
	FCC	'NEGA'
	#OTF:NIL,$40
	FCC	'NEGX'
	#OTF:NIL,$50
	FCC	'NOP '
	#OTF:NIL,$9D
	FCC	'ORA '
	#OTF:DYD,$AA
	FCC	'ORAA'
	#OTF:DYD,$AA	;6800 ORA
	FCC	'ROL '
	#OTF:MON,$39
	FCC	'ROLA'
	#OTF:NIL,$49
	FCC	'ROLX'
	#OTF:NIL,$59
	FCC	'ROR '
	#OTF:MON,$36
	FCC	'RORA'
	#OTF:NIL,$46
	FCC	'RORX'
	#OTF:NIL,$56
	FCC	'RSP '
	#OTF:NIL,$9C
	FCC	'RTI '
	#OTF:NIL,$80
	FCC	'RTS '
	#OTF:NIL,$81
	FCC	'SBC '
	#OTF:DYD,$A2
	FCC	'SBCA'
	#OTF:DYD,$A2	;6809/6800 SBC
	FCC	'SEC '
	#OTF:NIL,$99
	FCC	'SEI '
	#OTF:NIL,$9B
	FCC	'STA '
	#OTF:DYD!!OTF:IMM,$A7
	FCC	'STAA'
	#OTF:DYD!!OTF:IMM,$A7	;6800 STA
	FCC	'STOP'
	#OTF:NIL,$8E
	FCC	'STX '
	#OTF:DYD!!OTF:IMM,$AF
	FCC	'SUB '
	#OTF:DYD,$A0
	FCC	'SUBA'
	#OTF:DYD,$A0	;6809/6800 SUB
	FCC	'SWI '
	#OTF:NIL,$83
	FCC	'TAX '
	#OTF:NIL,$97
	FCC	'TXA '
	#OTF:NIL,$9F
	FCC	'TST '
	#OTF:MON,$3D
	FCC	'TSTA'
	#OTF:NIL,$4D
	FCC	'TSTX'
	#OTF:NIL,$5D
	FCC	'WAI '
	#OTF:NIL,$8F	;6800 WAIT
	FCC	'WAIT'
	#OTF:NIL,$8F

	#-1		END OF OPCODE TABLE
	PAGE	LONG OPCODE TABLE

*
*	LONG OPCODE TABLE (>4 CHARACTERS)
*
*	Table format is the same as the symbol table
*
M6805LONG
	#M6805LONGLIST	LONG OPCODE LIST HEADER

M6805LONGLIST
	#M6805BRSET
	#OTF:BB,$01,5
	FCC	'BRCLR'

M6805BRSET
	#M6805LONGEND
	#OTF:BB,$00,5
	FCC	'BRSET'


M6805LONGEND EQU	0

