	REM ********** BASIC RUNTIME PACKAGE TEST **********
	REM ***** PART 1 OF 2 PARTS *****
	REM THIS PROGRAM TESTS "CTLRTP14H" FOR 6800 MICROCOMPUTERS
	REM COPYRIGHT (C) 1977 SOFTWARE DYNAMICS
	REM ALL RIGHTS RESERVED
	REM 10/10/81 1235

	REM TEST RUNTIME PACKAGE OPCODES
	REM IF INPUT IS NULL, TESTS ALL OPCODES
	REM PROMPTS FOR OPCODE NUMBER (SEE LIST OF OPCODES IN BASIC COMPILER)
	REM REQUIRES I/O DEVICE WITH POSITION$ CAPABILITY AND READ/WRITE
	REM LINES WHICH TEST OPCODE NUMBER XXX...
	REM ARE LINES XXX00 THRU XXX99
	REM OPCODE 0 IS TESTED IN LINES 100-149
	REM OPCODE 1 IS TESTED IN LINES 150-199
	REM EACH OPCODE TEST ASSUMES ALL OTHER OPCODES WORK PROPERLY

!	PROGRAM ORIGIN :3600
	CONCATENATION BUFFER SIZE = 100
	REM DATA STORAGE
!	DATA ORIGIN :2E00
	COMMON CHNTST,CHNTST$(3),COMMONVARIABLE

	DIM SCALAR,OPCODE$[10],OPCODE2$[10],OPCODE,V[100],S$/:1,"HELLO"/,T$[2]
	DIM U$[250],TEN$[10],NEGONE/-1/,T/1/,BIN257$/:00,:00,:00,:1,:1/
	DIM SPACES$[32]/"                                "/
	DIM SIX$[6],ZEROLEN$[0],ONELEN$/0/,TWENTY$[20],THIRTY$[30],U1$[250]
	DIM UNIQUE$/"ABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789"/
	DIM JUNKFILE$/"JUNK"/,WRITEAONT$/:C,8,1/
	DIM I,J,K,L,X,Y
	DIM ALPHABET$/"ABCDEFGHIJKLMNOPQRSTUVWXYZ"/
	DIM OPENT$/0,:E,1/,READBONT$/:B,:E,1/ 
	DIM TWOBYTES$/0,0/, ONEBYTE$/0/,ONEBYTE1$/0/

	REM SET UP 65 SCALARS TO TEST OPLESCALAR, OPSESCALAR
	DIM SCALAR0,SCALAR1,SCALAR2,SCALAR3,SCALAR4,SCALAR5,SCALAR6,SCALAR7
	DIM SCALAR8,SCALAR9,SCALAR10,SCALAR11,SCALAR12,SCALAR13,SCALAR14,SCALAR15
	DIM SCALAR16,SCALAR17,SCALAR18,SCALAR19,SCALAR20,SCALAR21,SCALAR22,SCALAR23
	DIM SCALAR24,SCALAR25,SCALAR26,SCALAR27,SCALAR28,SCALAR29,SCALAR30,SCALAR31
	DIM SCALAR32,SCALAR33,SCALAR34,SCALAR35,SCALAR36,SCALAR37,SCALAR38,SCALAR39
	DIM SCALAR40,SCALAR41,SCALAR42,SCALAR43,SCALAR44,SCALAR45,SCALAR46,SCALAR47
	DIM SCALAR48,SCALAR49,SCALAR50,SCALAR51,SCALAR52,SCALAR53,SCALAR54,SCALAR55
	DIM SCALAR56,SCALAR57,SCALAR58,SCALAR59,SCALAR60,SCALAR61,SCALAR62,SCALAR63
	DIM SCALAR64,SCALAR65

50	REM INITIALIZE
	PRINT "*** RUNTIME PACKAGE DIAGNOSTIC PART 1 (BASRTP14H) ***"

	PRINT "TESTING LOAD/STORE SCALAR (:80/:C0+...) OPCODE"
	LET OPCODE=:80
	LET SCALAR=1\IF SCALAR<>1 THEN GOSUB 99
	LET SCALAR=-1\IF SCALAR<>-1 THEN GOSUB 99
	PRINT "LOAD/STORE SCALAR TEST COMPLETE"

	PRINT "TO TEST ALL OPCODES, TYPE <CR>"
	PRINT "TO TEST A SPECIFIC OPCODE 'X', TYPE 'X'"
	PRINT "TO TEST ALL OPCODES > X, TYPE '>X'"
	CREATE #T,JUNKFILE$\ ! A SCRATCH PLACE TO READ AND WRITE
	PRINT #T\ ! WRITE SOMETHING FOR SUBR 91 TO READ
	RESTORE #T,0\ !SET UP FOR SUBR 91

90	REM THIS IS WHERE WE ASK...
	ON ERROR GOTO 96
	INPUT "WHICH OPCODE ? " OPCODE$
	IF UPPERCASE$(OPCODE$)="STOP" THEN STOP
	IF OPCODE$="          "
	THEN
		FOR OPCODE = 0 TO 127
			PRINT OPCODE;
			GOSUB 95
		NEXT OPCODE
		PRINT
		PRINT '***DIAGNOSTIC PART 1 COMPLETED***'
		LET CHNTST=:B27A
		LET CHNTST$="RAT"
		CHAIN "CTLRTP14HT2"
		PRINT "*** FAILED TO CHAIN! ***"
	ELSE
		IF OPCODE$[1]=ASC(">")
		THEN
			LET OPCODE2$=OPCODE$
			LET OPCODE2$[1]=ASC(" ")
			FOR OPCODE=VAL(OPCODE2$)+1 TO 127
				PRINT OPCODE;
				GOSUB 95
			NEXT OPCODE
			PRINT
			PRINT 'PARTIAL TEST COMPLETED'
			LET CHNTST=:B27A
			LET CHNTST$="RAT"
			CHAIN "CTLRTP14HT2"
			PRINT "FAILED TO CHAIN"
		ELSE
			OPCODE = VAL(OPCODE$)
			GOSUB 95
			PRINT "TEST COMPLETED"
		FI
	FI
	GOTO 90

91	REM SUBROUTINE TO INPUT INTO SIX$ FROM TEMP FILE
	REM AND REWIND TEMP FILE TO BYTE 0
	RESTORE #T,0
	INPUT #T,SIX$
	RESTORE #T,0
	RETURN

95	REM BRANCH TO OPCODE TEST SUBROUTINE
	RESTORE #T,0\ REM THIS SAVES EVERYBODY ELSE THE TROUBLE
	ON OPCODE+1 GOTO 100,150,200,300,400,500,600,700,800,900,...
&	1000,1100,1200,1300,1400,1500,1600,1700,1800,1900,...
&	2000,2100,2200,2300,2400,2500,2600,2700,2800,2900,...
&	3000,3100,3200,3300,3400,3500,3600,3700,3800,3900,...
&	4000,4100,4200,4300,4400,4500,4600,4700,4800,4900,...
&	5000,5100,5200,5300,5400,5500,5600,5700,5800,5900,...
&	6000,6100,6200,6300,6400,6500,6600,6700,6800,6900,...
&	7000,7100,7200,7300,7400,7500,7600,7700,7800,7900,...
&	8000,8100,8200,8300,8400,8500,8600,8700,8800,8900,...
&	9000,9100,9200,9300,9400,9500,9600,9700,9800,9900,...
&	10000,10100,10200,10300,10400,10500,10600,10700,10800,10900,...
&	11000,11100,11200,11300,11400,11500,11600,11700,11800,11900,...
&	12000,12100,12200,12300,12400,12500,12600,12700
	PRINT "I CAN'T TEST THAT OPCODE IN THIS PASS"\ RETURN

96	REM ERROR TRAP ROUTINE
	IF ELN=96 AND ERR=1 THEN PRINT "ESCAPE BOTHERED ERROR TRAP LINE #!?"\	
						 GOSUB POP 0\
						 GOTO 90
	IF ELN=2110 AND ERR=11 THEN 2120
	IF ELN=2120 AND ERR=11 THEN 2130
	IF ELN=2130 AND ERR=11 THEN 2199
	IF ELN=2410 AND ERR=9 THEN 2420
	IF ELN=2420 AND ERR=9 THEN 2450
	IF ELN=2510 AND ERR=9 THEN 2520
	IF ELN=2520 AND ERR=9 THEN 2550
	IF ELN=3410 AND ERR=14 THEN 3420
	IF ELN=3420 AND ERR=14 THEN 3430
	IF ELN=3430 AND ERR=14 THEN 3440
	IF ELN=3440 AND ERR=14 THEN 3499
	IF ELN=3710 AND ERR=14 THEN 3799
	IF ELN=3850 AND ERR=14 THEN 3899
	IF ELN=5000 AND ERR=14 THEN 5010
	IF ELN=5310 AND ERR=14 THEN 5320
	IF ELN=5321 AND ERR=6 THEN 5330
	IF ELN=5410 AND ERR=6 THEN 5411
	IF ELN=5600 AND ERR=14 THEN 5699
	IF ELN=5860 AND ( ERR=1032 OR 1030 ) THEN 5899
	IF ELN=6310 AND ERR=50 THEN 6399
	IF ELN=7602 AND ERR=7 THEN 7603
	IF ELN=7606 AND ERR=7 THEN 7607
	IF ELN=7610 AND ERR=7 THEN 7620
	IF ELN=7630 AND ERR=7 THEN 7640
	IF ELN=7650 AND ERR=7 THEN 7680
	IF ELN=7693 AND ERR=7 THEN 7699
	IF ELN=7710 AND ERR=1004 THEN 7799
	IF ELN=7810 AND ERR=8 THEN 7820
	IF ELN=7920 AND ERR=17 THEN 7999
	IF ELN=8800 AND ERR=15 THEN 8810
	IF ELN=8810 AND ERR=25 THEN 8830
	IF ELN=8830 AND ERR=24 THEN 8840
	IF ELN=8840 AND ERR=24 THEN 8850
	IF ELN=8850 AND ERR=25 THEN 8860
	IF ELN=9305 AND ERR=X THEN 9310
	IF ELN=9410 AND ERR=1011 THEN 9420
	IF ELN=9420 AND ERR=1023 THEN 9430
	IF ELN=9500 AND ERR=50 THEN 9510
	IF ELN=9510 AND ERR=50 THEN 9520
	IF ELN=9605 AND ERR=50 THEN 9610
	IF ELN=9610 AND ERR=50 THEN 9620
	IF ELN = 9705 AND ERR = 1023 THEN 9710
	IF ELN=9910 AND ERR = 14 THEN 9920
	IF ELN = 9920 AND ERR = 11 THEN 9930
	IF ELN=9620 AND ERR=1023 THEN 9630
	IF ELN=OPLFREFLLABELTEST AND ERR=14 THEN 9810
	IF ELN=10710 AND ERR=1011 THEN 10720
	IF ELN=10720 AND ERR=1023 THEN 10799
	IF ELN=12710 AND ERR=14 AND GOELNFLAG=0 THEN LET GOELNFLAG=1\GOTO ELN
	IF ELN=12720 AND ERR=1 THEN GOTO ELN
	IF ELN=12730 AND ERR=13 THEN 12740
	REM NOT A VALID TRAP!
97	PRINT "ERROR"; ERR; "OCCURRED DURING OPCODE"; OPCODE; "(LINE ";ELN;")"
	GOSUB POP 0
	GOTO 90

99	PRINT "OPCODE"; OPCODE; "FAILED"\ RETURN

	SUBROUTINE TESTRELATIVEERROR(TESTVALUE,ACTUALVALUE,TESTERROR)
	RELATIVEERROR=ABS((TESTVALUE-ACTUALVALUE)/ACTUALVALUE)
	IF RELATIVEERROR>TESTERROR
	THEN PRINT "ERROR TOLERANCE EXCEEDED: ";TESTVALUE;ACTUALVALUE
	IF RELATIVEERROR>MAXRELATIVEERROR
	THEN	MAXRELATIVEERROR=RELATIVEERROR
	EXIT SUBROUTINE
	END
DEF RANDOM
	SEED=((SEED**-1) XOR ((SEED&1)* :C003))
	RETURN SEED & :7FFF
END
DEF MUSTTESTINMANUAL
	PRINT OPCODE$
	IF OPCODE$="          " OR OPCODE$[1]=ASC(">") THEN
		PRINT "MUST TEST THIS OPCODE IN MANUAL MODE"
		RETURN TRUE
	ELSE	RETURN FALSE
END

100	REM TEST OPLSMI+0
	REM TEST OPCODE 0
	IF 0<>10-10 THEN GOSUB 99
	RETURN

150	REM TEST OPLSMI+1
	REM TEST OPCODE 1
	IF 1<>11-10 THEN GOSUB 99
	RETURN

200	REM TEST OPLSMI+2
	IF 2<>12-10 THEN GOSUB 99
	RETURN

300	REM TEST OPLSMI+3
	IF 3<>13-10 THEN GOSUB 99
	RETURN

400	REM TEST OPLSMI+4
	IF 4<>14-10 THEN GOSUB 99
	RETURN

500	REM TEST OPLSMI+5
	IF 5<>15-10 THEN GOSUB 99
	RETURN

600	REM TEST OPLSMI+6
	IF 6<>16-10 THEN GOSUB 99
	RETURN

700	REM TEST OPLSMI+7
	IF 7<>17-10 THEN GOSUB 99
	RETURN

800	REM TEST OPLSMI+8
	IF 8<>18-10 THEN GOSUB 99
	RETURN

900	REM TEST OPLSMI+9
	IF 9<>19-10 THEN GOSUB 99
	RETURN

1000	REM TEST OPLOAD
	LET COMMONVARIABLE=5\ IF COMMONVARIABLE<>5 THEN GOSUB 99
	RETURN

1100	REM TEST OPLV
	FOR I=-100 TO +100 STEP 1
		CALL TESTOPLV(I)
	NEXT I
	RETURN

SUBROUTINE TESTOPLV(OPLVTESTARG)
	IF OPLVTESTARG<>I THEN GOSUB 99
	EXIT SUBROUTINE
END

1200	REM TEST OPSESCALAR
	LET SCALAR64=0
	IF SCALAR64<>0 THEN GOSUB 99
	LET SCALAR64=4
	IF SCALAR64<>4 THEN GOSUB 99
	LET SCALAR64=32767
	IF SCALAR64<>32767 THEN GOSUB 99
	LET SCALAR64=-27
	IF SCALAR64<>-27 THEN GOSUB 99
	REM TEST THAT SCALARS DON'T OVERLAP
	LET SCALAR65=19 
	IF SCALAR64<>-27 OR SCALAR65<>19  THEN GOSUB 99
	RETURN

1300	REM TEST OPLINT
	IF 32767<>1+2+4+8+16+32+64+128+256+512+1024+2048+4096+8192+16384 
	THEN GOSUB 99
1399	RETURN

1400	REM TEST OPLESCALAR
	GOTO 1200

1500	REM TEST OPLFI
	GOTO NOTIMPLEMENTED
	RETURN

1600	REM TEST OPLDB
	IF S$[1] <> 1 THEN GOSUB 99
	IF S$[2]<>ASC("H") THEN GOSUB 99
	IF S$(6) <> ASC("O") THEN GOSUB 99
	RETURN

1700	REM TEST OPDUP
	GOTO NOTIMPLEMENTED
	RETURN

1800	REM TEST OPLSD
	LET T$=''\ IF LEN(T$) <> 2 THEN GOSUB 99
	LET T$="ABC"\ IF LEN(T$) <> 2 THEN GOSUB 99
	IF T$ <> "AB" THEN GOSUB 99
	LET T$ = "HE" 
	IF T$ <> "HE" THEN GOSUB 99
	RETURN

1900	REM TEST OPLSC
	LET T$="HE"
	IF T$ <> "HE" THEN GOSUB 99
	LET T$="A"
	IF T$<>"A " THEN GOSUB 99
	RETURN

2000	REM TEST OPLEN
	IF LEN(S$) <> 6 THEN GOSUB 99
	LET T$="A"\ IF LEN(T$) <> 2 THEN GOSUB 99
	RETURN

2100	REM TEST OPSS1
	FOR I=1 TO 100\ LET U$[I]=I\ NEXT I
	IF U$[16]<>16 THEN GOSUB 99
	IF U$[100]<>100 THEN GOSUB 99
2110	IF U$[254]*0 = 0 THEN GOSUB 99
2120	IF U$[0]*0 = 0 THEN GOSUB 99
2130	IF U$[-1]*0 = 0 THEN GOSUB 99
2199	RETURN

2200	REM TEST OPSS2
	GOTO NOTIMPLEMENTED
2299	RETURN

2300	REM TEST OPVSA
	FOR I=0 TO 99\V[I]=I+2\NEXT I
	FOR I = 0 TO 99
	CALL TESTOPVSA(V[I])
	NEXT I
	FOR I=0 TO 99
		IF V[I]<>-I THEN GOSUB 99
	NEXT I
	RETURN

SUBROUTINE TESTOPVSA(TESTOPVSAARG)
		IF TESTOPVSAARG<>I+2 THEN GOSUB 99
		TESTOPVSAARG=-I
	EXIT SUBROUTINE
END

2400	REM TEST OPVSV
	FOR I=0 TO 100\ V[I]=I\ NEXT I
	FOR I=0 TO 100
	IF V[I]<>I THEN GOSUB 99\ GOTO 2410
	NEXT I
2410	IF V[-1]*0 = 0 THEN GOSUB 99
2420	IF V[101]*0 = 0 THEN GOSUB 99
2450	FOR I=0 TO 100
	IF V[I+5-3-2] <> I THEN GOSUB 99
	NEXT I
	RETURN

2500	REM TEST OPVSS
	FOR I=0 TO 100 DO V[I]=I+1
	FOR I=0 TO 100 DO IF V[I]<>1+I THEN GOSUB 99\EXIT I
	FOR I=0 TO 100 DO IF V[I]<>I+1 THEN GOSUB 99\EXIT I
2510	LET V[-1]=0\GOSUB 99
2520	LET V[101]=0\GOSUB 99
2550	RETURN

2600	REM TEST OPVPA
	FOR I=0 TO LEN(V)\V(I)=I-2\NEXT I
	CALL TESTOPVPA1(V)
	RETURN

SUBROUTINE TESTOPVPA1(TESTOPVPA1ARG[*])
	IF LEN(TESTOPVPA1ARG)<>LEN(V) THEN GOSUB 99
	FOR I=1 TO LEN(TESTOPVPA1ARG)
		CALL TESTOPVPA2(TESTOPVPA1ARG[I],I)
		IF V[I]<>I+5 THEN GOSUB 99
	NEXT I
	EXIT SUBROUTINE
END

SUBROUTINE TESTOPVPA2(TESTOPVPA2ARG1,TESTOPVPA2ARG2)
	IF TESTOPVPA2ARG1<>V(TESTOPVPA2ARG2) THEN GOSUB 99
	TESTOPVPA2ARG1=TESTOPVPA2ARG2+5
	EXIT SUBROUTINE
END

2700	REM TEST OPASA
	GOTO NOTIMPLEMENTED
	RETURN


2800	REM TEST OPASV
	GOTO NOTIMPLEMENTED
2899	RETURN

2900	REM TEST OPASS
	GOTO NOTIMPLEMENTED
2999	RETURN

3000	REM TEST OPAPA
	GOTO NOTIMPLEMENTED
	RETURN


3100	REM TEST OPST
	REM TEST OPST ON INTEGER
	FOR I=-32768 TO 32735 STEP 32
		CALL TESTOPST(J)
		IF I<>J THEN GOSUB 99
	NEXT I
	RETURN

SUBROUTINE TESTOPST(OPSTARG)
	OPSTARG=I
	EXIT SUBROUTINE
END

3200	REM TEST OPSTS
	LET TEN$='1234567890'
	IF TEN$<>'1234567890' OR LEN(TEN$)<>10 THEN GOSUB 99

	LET SIX$='A    B'
	LET TEN$='A        B'
	IF SIX$ <> 'A    B' OR LEN(SIX$) <> 6 THEN GOSUB 99
	LET SIX$="C"
	IF TEN$<> 'A        B' THEN GOSUB 99
	IF SIX$<>"C     " THEN GOSUB 99
	LET SIX$ = "ABCDEF"
	IF SIX$ <> "ABCDEF" OR LEN(SIX$) <> 6 THEN GOSUB 99
3210	LET SIX$[2]=SIX$[5]
	LET SIX$[5]=SIX$[2]
	IF SIX$<>"AECDEF" THEN GOSUB 99
	REM TEST BIG STRING MOVE ROUTINE
3220	FOR I=1 TO 34

		LET U$[I]=UNIQUE$[I]\ REM COPY A STRING INTO U$
		IF U$[I]<>UNIQUE$[I] THEN GOSUB 99
	NEXT I
	RETURN

3300	REM TEST OPSTB
	FOR I=1 TO 100
	LET U$[I]=I&:FF
	IF U$[I]<>I&:FF THEN GOSUB 99
	NEXT I
	RETURN


3400	REM TEST OPADD
	IF 0+0<>0 OR 0+1<>1 OR 1+0<>1 OR 27+13<>40 OR 255+1<>256 THEN GOSUB 99
	IF 2+255<>257 OR 15296+17471 <>32767 THEN GOSUB 99
	IF (-2)+(-3) <> (-5) THEN GOSUB 99
	IF 17+(-65)<>-48 THEN GOSUB 99
3410	IF ((-32768)+(-32768))*0=0 THEN GOSUB 99
3420	IF (32767+32767)*0=0 THEN GOSUB 99
3430	IF ((-32768)+(-1))*0=0 THEN GOSUB 99
3440	IF (32767+1)*0=0 THEN GOSUB 99
3499	RETURN

3500	REM TEST OPSUB
	IF 0-0<>0 OR 1-0<>1 OR 27-13<>14 OR 257-2<>255 THEN GOSUB 99
	IF 4670-3140<>1530 OR INT(32767-1)<>32766 THEN GOSUB 99
	IF (-5)-(-3)<>(-2) THEN GOSUB 99
	IF -48-(-65)<>-(-17) THEN GOSUB 99
3599	RETURN

3600	REM TEST OPNEG
	IF -0<>0 THEN GOSUB 99
	IF -1 <> NEGONE OR -(20+10)<>-20-10 THEN GOSUB 99
	IF -1+(-1)+(-1)<>0-3 THEN GOSUB 99
	IF -(-(-4))<>0-4 THEN GOSUB 99
	IF -32768<>0-32767-1 THEN GOSUB 99
	IF -(32767)<>0-32767 THEN GOSUB 99
	RETURN

3700	REM TEST OPMUL
	IF 0*0<>0 OR 0*1<>0 OR 1*0<>0 OR 12*43<>516 THEN GOSUB 99
	IF 32767<>7*4681 THEN GOSUB 99
	IF 151*31*7<>32767 THEN GOSUB 99
	IF (-151)*31*7<>-32767 THEN GOSUB 99
	IF (-5)*(-5)<>25 THEN GOSUB 99
	IF -15246<>(-99)*154 THEN GOSUB 99
	IF 256<>(-16)*(-16) THEN GOSUB 99
	IF (-3)*0<>0 THEN GOSUB 99
	IF 0*(-3)<>0 THEN GOSUB 99
3710	IF (32767*2)*0=0 THEN GOSUB 99
3799	RETURN

3800	REM TEST OPDIV
	REM FIRST TEST DIVIDE BY 2^K
	IF 1/1<>1 OR 4/2<>2 OR 16/4<>4 OR 256/8<>32 OR 32766/16383<>2 THEN GOSUB 99
	REM NOW TEST OTHER DIVIDE CASES
	IF 5/2<>2 OR 7/3 <>2 OR 35/6<>5 OR 25864/39<>663 THEN GOSUB 99
	IF 0/1<>0 OR 0/29<>0 THEN GOSUB 99
	IF 32767/31<>1057 OR 3451/210<>16 THEN GOSUB 99
	IF -1/1<>-1 OR 1/1<>1 OR 1/-1<>-1 OR -1/-1<>1 THEN GOSUB 99
3850	IF (5/0)*0=0 THEN GOSUB 99
3899	RETURN

3900	REM TEST OPAND
	IF 0&:FFFF<>0 OR :FFFF&:0<>0 OR :FFFF&:AAAA<>:AAAA THEN GOSUB 99
	IF :FFFF&:5555<>:5555 OR :FC96&:147A<>:1412 THEN GOSUB 99
3999	RETURN

4000	REM TEST OPIOR
	IF 0!:FFFF<>:FFFF OR :FFFF!0<>:FFFF THEN GOSUB 99
	IF :FFFF!:FFFF<>:FFFF OR :AAAA!:5555<>:FFFF THEN GOSUB 99
	IF :1412!:4478<>:547A THEN GOSUB 99
4099	RETURN

4100	REM TEST OPSHF
	IF 1**0<>1 OR 1**1<>2 OR 1**4<>16 OR 1**8<>256 THEN GOSUB 99
	IF 1**14<>16384 OR 1**16<>0 OR 1**15<>:8000  THEN GOSUB 99
	IF 256**2<>1024 OR 256**-4<>16 OR 256**-9<>0 THEN GOSUB 99
	IF (5-1)**0<>4 THEN GOSUB 99
4199	RETURN

4200	REM TEST OPCOM
	IF COM(0)<>:FFFF OR COM(:5A5A)<>:A5A5 THEN GOSUB 99
	IF COM(4-2)<>:FFFF-2 THEN GOSUB 99
4299	RETURN

4300	REM TEST OPEQ
	IF 0=1 OR 128=0 OR  256=0 THEN GOSUB 99
	IF NOT( 0=0 AND 259=259 ) THEN GOSUB 99
	IF NOT(128=126+2) THEN GOSUB 99
	RETURN

4400	REM TEST OPNE
	IF NOT( 0<>1 AND 256<>0 ) THEN GOSUB 99
	IF 0<>0 OR 259<>259 THEN GOSUB 99
	IF NOT( -5<>5 AND 49<>50 ) THEN GOSUB 99
	RETURN

4500	REM TEST OPLT
	IF 1<0 OR 256<0 OR 354<259 OR 0<0 OR 259<259 THEN GOSUB 99
	IF 200<200  OR 128<5 OR 32767<32767 THEN GOSUB 99
	IF 5<-5 OR 255<5 OR 256<5 OR 128<5 OR 127<5 OR 49 <49 THEN GOSUB 99
	IF -5<-7 OR 31322<31321 THEN GOSUB 99
	IF NOT( 0<1 AND 0<256 AND 259<354 ) THEN GOSUB 99
	RETURN

4600	REM TEST OPLE
	IF 1<=0 OR 256<=0 OR 354<=259 THEN GOSUB 99
	IF 128<=5 OR 127<=5 OR 255<=5 OR 256<=5 THEN GOSUB 99
	IF -5<=-7 THEN GOSUB 99
	IF NOT( 0<=1 AND 0<=256 AND 259<=354 ) THEN GOSUB 99
	IF NOT( 0<=0 AND 259<=259 ) THEN GOSUB 99
	IF NOT( -5<5 AND 48<=49 ) THEN GOSUB 99
	RETURN

4700	REM TEST OPGE
	IF 0>=1 OR 0>=256 OR 259>=354 THEN GOSUB 99
	IF 5>=128 OR 5>=127 OR 5>=255 OR 5>=256 THEN GOSUB 99
	IF 48>=49 OR -7>=-5 THEN GOSUB 99
	IF NOT( 1>=0 AND 256>=0 AND 354>=259 ) THEN GOSUB 99
	IF NOT( 0>=0 AND 259>=259 ) THEN GOSUB 99
	IF NOT( 200>=200  AND 32767>=32767 ) THEN GOSUB 99
	IF NOT( 5>=-5 AND 48   >=48 ) THEN GOSUB 99
	RETURN

4800	REM TEST OPGT
	IF 0>1 OR 0>256 OR 259>354 THEN GOSUB 99
	IF 5>128 OR 5>127 OR 5>255 OR 5>256 THEN GOSUB 99
	IF 0>0 OR 259>259 THEN GOSUB 99
	IF 200 >200 OR 32767>32767 THEN GOSUB 99
	IF -5>5 OR 48>49 THEN GOSUB 99
	IF -7>-5THEN GOSUB 99
	IF 1E-125>1E125 OR -5E125>5E125 THEN GOSUB 99
	IF NOT( 1>0 AND 256>0 AND 354>259 ) THEN GOSUB 99
	RETURN

4900	REM TEST OPBF
	IF 1=0 THEN GOSUB 99
	IF 1=1 THEN RETURN ELSE GOSUB 99
	IF 1=1
	THEN LET I=0
	ELSE GOSUB 99
	IF 0=0
	THEN LET I=0\J=0
	ELSE GOSUB 99
	WHILE I<>0 DO PRINT 1/0 END
	WHILE I=0 DO IF I=0 THEN 4910 ELSE PRINT 1/0 END
4910	WHILE I<10 DO J=J+I\I=I+1 END
	IF J<>45 THEN GOSUB 99
	WHILE 0=1 DO
		PRINT 1/0
		LET I=1/0
	END
	RETURN

5000	REM TEST OPBT
	IF 1=0 OR 1/0=0 THEN GOSUB 99 ELSE GOSUB 99
5010	IF 1=1 OR 1/0=0 THEN RETURN ELSE GOSUB 99
	RETURN

5100	REM TEST OPINV
	IF NOT( 0=0 ) THEN GOSUB 99
	IF NOT( 0=1 ) THEN RETURN ELSE GOSUB 99
	RETURN

5200	REM TEST OPJMP
	LET X=1\ GOTO 5210
	LET X=0
5210	IF X<>1 THEN GOSUB 99
	RETURN

5300	REM TEST OPGSB
	LET X=0
	GOSUB 5390\ IF X<>1 THEN GOSUB 99
	Y=0\GOSUB 5385 \ REM TEST GOSUB NESTING
	IF Y<>1+2+3+4+5+6+7+8+9+10 THEN GOSUB 99
5310	REM TEST STORAGE OF CURRENT LINE # BY GOSUB ON ERROR REPORTING
	GOSUB 5399\ LET X=1/0\ GOSUB 99
	RETURN
5320	REM TEST GOSUBS IN MAINLINE ARE NOT KNOWN TO CALLED PROCEDURE
	GOSUB 5321
	GOTO 5330
5321	CALL TESTOPGSB1(X)
	RETURN
	GOSUB 99

5330	REM TEST GOSUB IN PROCEDURE1 DOESN'T AFFECT GOSUB IN PROCEDURE2
	CALL TESTOPGSB2(X)
	RETURN

5340	REM TEST RETURN W/O GOSUB IN MAIN UNAFFECTED BY UNMATCHED GOSUB...
	REM IN CALLED PROCEDURE
	CALL PROCEDURETOPUSHUNMATCHEDGOSUB
5345	RETURN\ REM SHOULD TRAP
	GOSUB 99
	RETURN

SUBROUTINE PROCEDURETOPUSHUNMATCHEDGOSUB
	GOSUB 5350
	GOSUB 99
5350	EXIT SUBROUTINE
END

5385	IF X<10 THEN X=X+1\ GOSUB 5385 ELSE Y=0
	Y=Y+X\X=X-1\RETURN
5390	LET X=1
5399	RETURN

SUBROUTINE TESTOPGSB1(TESTOPGSB1ARG)
	RETURN\ REM SHOULD TRAP
	GOSUB 99
	EXIT SUBROUTINE
END

SUBROUTINE TESTOPGSB2(TESTOPGSB2ARG)
	GOSUB 5341
	IF X<>0 THEN GOSUB 99
	EXIT SUBROUTINE
5341	X=3
	CALL TESTOPGSB3(X)
	IF X<>2 THEN GOSUB 99
	X=0
	RETURN
	GOSUB 99
END

SUBROUTINE TESTOPGSB3(TESTOPGSB3ARG)
	IF X<>3 THEN GOSUB 99
	X=2
	GOSUB 5342\ REM PUSH EXTRANEOUS GOSUB
	X=1
5342	IF X<>2 THEN GOSUB 99
	EXIT SUBROUTINE
END

5400	REM TEST OPRET
	REM TEST 1 LEVEL OF NESTING
	X=0
	GOSUB 5490
	IF X<>1 THEN GOSUB 99
	REM TEST SEVERAL LEVELS OF NESTING
	GOSUB 5470
	IF X<>31 THEN GOSUB 99
	IF MUSTTESTINMANUAL THEN RETURN
	GOSUB POP 0
5410	RETURN
	GOSUB 99
5411	PRINT "TEST COMPLETED"
	GOTO 90
5470	LET X=X+2
	GOSUB 5471
	RETURN
	GOSUB 99
	STOP

5471	LET X=X+4
	GOSUB 5472
	RETURN
	GOSUB 99
	STOP

5472	LET X=X+8
	GOSUB 5473
	RETURN
	GOSUB 99
	STOP

5473	LET X=X+16
	RETURN
	GOSUB 99
	STOP

5490	LET X=1\RETURN\ GOSUB 99\ STOP

5500	REM TEST OPSTP
	IF MUSTTESTINMANUAL THEN RETURN
	ELSE
		PRINT "Should 'STOP at 5500'"
		stop
		GOSUB 99
	fi
	RETURN

5600	REM TEST OPLINE
	LET X=1/0
5610	GOSUB 99
5699	RETURN

5700	REM TEST OPCALL
	REM COMPILER USES OPCALL TO CALL COMPILED BASIC SUBROUTINES
	REM TEST DOES IT WORK AT ALL
	LET X=0
	CALL CALLTEST1(5)
	IF X<>5 THEN GOSUB 99
	REM TEST MULTIPLE ARGUMENTS
	CALL CALLTEST3(1,2,3)
!	PRINT "WHO TESTS ERROR PROPOGATION??"
	IF X<>6 THEN GOSUB 99
5710	REM TEST WRONG NUMBER OF ARGUMENTS
	IF MUSTTESTINMANUAL THEN RETURN
	ELSE
		PRINT "Should give 'Error 27 @ 5710'"
		CALL CALLTEST1(2,3)
		GOSUB 99
	FI
	RETURN

SUBROUTINE CALLTEST1(ARG1)
	LET X=ARG1
	EXIT SUBROUTINE
	END

SUBROUTINE CALLTEST3(ARG1A,ARG2A,ARG3A)
	IF ARG1A<>1 OR ARG2A<>2 OR ARG3A<>3 THEN GOSUB 99
	LET X=ARG1A*ARG2A*ARG3A
	EXIT SUBROUTINE
	END


5800	REM TEST OPPV
	PRINT #T,0\GOSUB 91
	IF SIX$<>" 0    " THEN GOSUB 99
	PRINT #T,45\GOSUB 91
	IF SIX$<>" 45   " THEN GOSUB 99
	PRINT #T,32767\GOSUB 91
	IF SIX$<>" 32767" THEN GOSUB 99
	PRINT #T,-1\GOSUB 91
	IF SIX$<>"-1    " THEN GOSUB 99
	PRINT #T,-32767\GOSUB 91
	IF SIX$<>"-32767" THEN GOSUB 99

	PRINT #T,92\GOSUB 91
	IF SIX$<>" 92   " THEN GOSUB 99

	RETURN


5850	REM TEST OPPV WITH USING STRING
	GOTO NOTIMPLEMENTED
5899	RETURN

5900	REM TEST OPPCR
	PRINT #T\GOSUB 91
	IF SIX$<>'      ' THEN GOSUB 99
	RETURN

6000	REM TEST OPPS (PRINT STRING)
	LET SIX$=''\PRINT #T,SIX$\GOSUB 91
	IF SIX$<>'      ' THEN GOSUB 91
	PRINT #T,"ABCDEF"\GOSUB 91
	IF SIX$<>"ABCDEF" THEN GOSUB 99
	LET SIX$="RETCH"\PRINT #T,SIX$\GOSUB 91
	IF SIX$<>"RETCH " THEN GOSUB 99
	RETURN


6100	REM TEST OPPSP  (PRINT SPACE)
	PRINT #T,1;-2\GOSUB 91
	IF SIX$<> " 1 -2 " THEN GOSUB 99
	RETURN

6200	REM TEST OPINS
	PRINT #T, "QWERT";
	PRINT #T, "YUIOP"
	GOSUB 91
	IF SIX$<> "QWERTY" THEN GOSUB 99
	CLOSE #T
	REM TEST OPINS AT END OF FILE
	CREATE #T, JUNKFILE$
	PRINT #T, "BULL";
	RESTORE #T,0
6210	INPUT #T,TEN$
	IF NOT(EOF(T)) THEN GOSUB 99
	RETURN


6300	REM TEST OPCHNL
	RESTORE #T,0
6399	RETURN

6400	REM TEST OPCIN
	GOTO NOTIMPLEMENTED

6500	REM TEST OPCAT
	GOTO NOTIMPLEMENTED
	RETURN

6600	REM TEST OPCND
	GOTO NOTIMPLEMENTED
	RETURN

NOTIMPLEMENTED:
	PRINT "OPCODE NOT IMPLEMENTED IN CONTROL BASIC"
	RETURN

6700	REM TEST OPRIGHT
	GOTO NOTIMPLEMENTED

6800	REM TEST OPRESTR
	PRINT #T,'ABCDEF'
	RESTORE #T,0\INPUT #T,SIX$
	IF SIX$<> 'ABCDEF' THEN GOSUB 99 
	RESTORE #T,3 \ INPUT #T, SIX$
	IF SIX$ <> "DEF   " THEN GOSUB 99
	RETURN

6900	REM TEST OPWV
	WRITE #T,258
	RESTORE #T,0\READ #T,TWOBYTES$
	IF NOT (TWOBYTES$[1]=1 AND TWOBYTES$[2]=2) THEN GOSUB 99
	WRITE #T @0,16
	 READ #T @0,TWOBYTES$
	IF NOT (TWOBYTES$[1]=0 AND TWOBYTES$[2]=16) THEN GOSUB 99
	WRITE #T@0,-1
	READ #T@0,TWOBYTES$
	IF NOT(TWOBYTES$[1]=255 AND TWOBYTES$[2]=255) THEN GOSUB 99
	RETURN
7000	REM TEST OPWS
	FOR I = 0 TO 255
		LET ONEBYTE$[1] = I
		WRITE #T@0,ONEBYTE$
		READ #T@0,ONEBYTE1$
		IF ONEBYTE1$[1] <> I THEN GOSUB 99
	NEXT I
!  ADD CODE FOR DIFFERENT LENGTH STRINGS
	RETURN

7100	REM TEST OPRV
	CLOSE #T
	CREATE #T,JUNKFILE$
	WRITE #T,ONELEN$
7110	READ #T@0,X
	IF NOT(EOF(T)) THEN GOSUB 99
	WRITE #T@0, 258,16,-75
	READ #T@0,X,Y,Z
	IF X <> 258 THEN GOSUB 99
	IF Y <> 16 THEN GOSUB 99
	IF Z <> -75 THEN GOSUB 99
	IF EOF(T) THEN GOSUB 99
	RETURN

7200	REM TEST OPRS
	PRINT #T,ALPHABET$
	RESTORE #T,0
	READ #T,ZEROLEN$,ONELEN$,SIX$
	IF ZEROLEN$<>'' OR ONELEN$<>'A' THEN GOSUB 99
	IF SIX$<>"BCDEFG" THEN GOSUB 99
	WRITE #T@0,ASC("H")
	READ #T@0,SIX$[4]\ ! TEST READ INTO STRING BYTE
	IF SIX$<>"BCDHFG" THEN GOSUB 99
	CLOSE #T
	CREATE #T,JUNKFILE$
	WRITE #T,"ABCD"
7210	READ #T@0,SIX$
	REM CHECK EOF HANDLING; SET STRING LENGTH TO # BYTES READ AT EOF
	IF NOT(EOF(T)) THEN GOSUB 99
7299	RETURN

7300	REM TEST OPFOR
	LET J=0
	FOR I=0 TO 295
		! CHECK INTEGER LOOP
		IF I<>J THEN GOSUB 99
		LET J=J+1
		IF J>296 THEN GOSUB 99\RETURN
	NEXT I
	IF I<>296 THEN GOSUB 99
7310	REM TEST INTEGER STEP <> 1
	LET J=3
	FOR I=3 TO 10700 STEP 941
	IF I<>J THEN GOSUB 99
	LET J=J+941
	IF J>11295 THEN GOSUB 99\RETURN
	NEXT I
	IF I<> 11295 THEN GOSUB 99
7315	REM TEST INTEGER INDEX FORCED TO FLOAT MODE ON LOOP EXIT
REM I DON'T THINK THIS TEST IS NECESSARY!
	LET J=6500
	FOR I=6500 TO 32766 \ LET J=J+1 \ NEXT I
!	PRINT "FOR I=6500 TO 32767 ???? UNDETERMINED VALUE FOR I UPON EXIT OF LOOP".
	IF J<>32767 OR I<>32767 THEN GOSUB 99
7330	LET J=1\! CHECK IMPLIED STEP OF 1
	FOR I=1  TO 100 \LET J=J+1\NEXT I
	IF J<>101 OR I<>101 THEN GOSUB 99
7340	LET J=0\! CHECK NEGATIVE STEP
	FOR I=100 TO -6 STEP -1\J=J+1\NEXT I
	IF J<>107 OR I<>-7 THEN GOSUB 99
7350	LET J=0 \ ! CHECK INTEGER LIMIT
	FOR I=-6 TO 100 STEP 1 \ J=J+1\NEXT I
	IF J<>107 OR I<>101 THEN GOSUB 99
7360	LET J=0\! CHECK INTEGER INIT VALUE
	FOR I=100 TO -6  STEP -1 \J=J+1\NEXT I
	IF J<>107 OR I<>-7 THEN GOSUB 99
7370	LET X=0\! CHECK LOOP NESTING
	FOR I=1 TO 999
7373		FOR J=1 TO 10 STEP 1
			LET X=X+1
		NEXT J
		IF I<>X/10 THEN GOSUB 99
	NEXT I
	IF X<>9990 THEN GOSUB 99
7380	REM TEST 0 ITERATIONS OF INTEGER LOOP
	J=0
	FOR I=11 TO 10 STEP 1
		J=1
	NEXT I
	IF J<>0 OR I<>11 THEN GOSUB 99
	RETURN


7400	REM TEST OPNEXT
	GOTO 7300

7500	REM TEST OPTABCOL
	PRINT #T
	FOR I=1 TO 10
		PRINT #T,I,
REM		PRINT COL(T),I
		IF COL(T)<>10*I+1 THEN GOSUB 99
	NEXT I
7510	REM TEST OUTPUT VARYING SIZE CHUNKS OF 0 TO 18 BYTES
	FOR I=1 TO 32
		RESTORE #T,0\ REM SET COL(T)=1
		FOR J=1 TO I DO PRINT #T," ";
		PRINT #T,"*","#"
!		PRINT #T,SPACES$[1,I];"*","#"
REM		PRINT "123456789012345678901234567890123456789012345678901234567890"
		RESTORE #T,I+1\ REM SKIP PAST THE "*"
		LET J=I+2\ REM J=COL("*")+1
		REM CHECK FOR THE GAURANTEED SPACE
		READ #T,ONELEN$
		IF ONELEN$<>" " THEN GOSUB 99
		LET J=J+1
		REM CHECK FOR SPACES UNTIL J MOD 10 = 1
		UNTIL J-INT(J/10)*10=1 DO
			REM UNTIL J MOD 10 = 1 DO...
7520			READ #T,ONELEN$
			IF ONELEN$<>" " THEN GOSUB 99
			LET J=J+1
		END
7530		READ #T,ONELEN$
		IF ONELEN$<>"#" THEN GOSUB 99
	NEXT I
	RETURN

7600	REM TEST OPINP
	REM TEST NORMAL INPUT SEPERATED BY COMMAS
	PRINT #T,"1,27,-3,1342,875"
	RESTORE #T,0\INPUT #T,I,J,X,Y,Z
	IF I<>1 OR J<>27 OR X<>-3 OR Y<>1342 OR Z<>875 THEN GOSUB 99
	REM TEST INPUT SEPERATED BY TERMINATORS
!	RESTORE #T,0\PRINT #T,"1412:3A-117:FF122"
!	RESTORE #T,0\INPUT #T,I,J,K,X,Y,Z
!	IF I<>1412 OR J<>:3A OR K<>-1517 OR X<>117 OR Y<>255 OR Z<>122 THEN GOSUB 99
	REM TEST NOT ENOUGH VALUES SUPPLIED TO SATISFY INPUT REQUEST
	RESTORE #T,0\PRINT #T,""
7602	RESTORE #T,0\INPUT #T,I\GOSUB 99
7603	RESTORE #T,0\PRINT #T,"3,        1"
	REM TEST IGNORE LEADING SPACES
	RESTORE #T,0\INPUT #T,I,J
	IF I<>3 OR J<>1 THEN GOSUB 99
	REM TEST NO COMMA REQUIRED TO SEPERATE VALUES
	RESTORE #T,0\PRINT #T,"1     3"
	RESTORE #T,0\INPUT #T,I,J
	IF I<>1 OR J<>3 THEN GOSUB 99
	REM TEST HEX INPUT

	RESTORE #T,0\PRINT #T,":127A"
	RESTORE #T,0\INPUT #T,X
	IF X<>:127A THEN GOSUB 99
	REM TEST HEX REJECTION OF NON-HEX
	RESTORE #T,0\PRINT #T,":A0FG THIS IS GARBAGE"\RESTORE #T,0
	INPUT #T,X,TWENTY$
	 IF X<>:A0F OR TWENTY$<>'G THIS IS GARBAGE   ' THEN GOSUB 99
	REM TEST EAT COMMA TRAILING INPUT VALUE
	PRINT #T@0,"23,  JUNK"
	INPUT #T@0,X,TEN$
	IF X<>23 OR TEN$<>"  JUNK    " THEN GOSUB 99
	PRINT #T@0,"52 ,    JUNK"
	INPUT #T@0,X,TEN$
	IF X<>52 OR TEN$<>" ,    JUNK" THEN GOSUB 99
	REM TEST PROCESS ONLY WHAT WAS INPUT INTO CATBUF THIS TIME AROUND
	CLOSE #T
	CREATE #T,JUNKFILE$
	PRINT #T,"234,567"
	PRINT #T,"891"
	INPUT #T@0,X,Y\IF X<>234 OR Y<>567 THEN GOSUB 99
	INPUT #T,X,SIX$
	IF X<>891 OR SIX$<>"      " THEN GOSUB 99
	REM TEST PROPER EOF HANDLING
	INPUT #T,X,Y
7605	IF NOT(EOF(T)) THEN GOSUB 99
	REM TEST OVERFLOW IN HEX INPUT
	RESTORE #T,0
	PRINT #T,":ABCDEFGHI"
	RESTORE #T,0
7606	INPUT #T,X\ GOSUB 99
7607	REM TEST OVERFLOW ON INPUT
	RESTORE #T,0\PRINT #T,"32768"
	RESTORE #T,0
7610	INPUT #T,I\GOSUB 99
7620	RESTORE #T,0\ PRINT #T
	RESTORE #T,0
7630	INPUT #T,I\GOSUB 99
7640	RESTORE #T,0\ PRINT #T,"   -"\ RESTORE #T,0
7650	INPUT #T,X\ GOSUB 99
7680	RESTORE #T,0\ PRINT #T,":"\RESTORE #T,0
7693	INPUT #T,X\GOSUB 99
7699	RETURN

7700	REM TEST OPEOF
	RESTORE #T,0
	IF EOF(T) THEN GOSUB 99
	CLOSE #T
	CREATE #T,JUNKFILE$
	WRITE #T,TWOBYTES$
	RESTORE #T,254
	IF NOT(EOF(T)) THEN GOSUB 99
7710	RESTORE #T,-257\GOSUB 99
7799	RETURN

7800	REM TEST OPINL
	PRINT #T,"INLINE TEST "
	 PRINT #T,"THIS SHOULD NOT PRINT "
	RESTORE #T,0\ INPUT #T,THIRTY$
	IF THIRTY$<>"INLINE TEST                   " THEN GOSUB 99
	IF  EOF(T) THEN GOSUB 99
	REM TEST INPUT BUFFER OVERFLOW
	RESTORE #T,0\ PRINT #T,TAB(250);"*"
7810	INPUT #T@0,SIX$\ GOSUB 99
7820	REM TEST EOF HANDLING
	CLOSE #T
	CREATE #T,JUNKFILE$
	PRINT #T,"ABC"
	PRINT #T,"7";
	INPUT #T@0,SIX$
	IF EOF(T) THEN GOSUB 99
	LET X=5
	INPUT #T,X
	IF NOT(EOF(T)) THEN GOSUB 99
	REM VERIFY THAT REST OF INPUT STATEMENT HAS BEEN SKIPPED PROPERLY
	IF X<>5 THEN GOSUB 99
	RETURN

7900	REM TEST OPTAB
	FOR I=1 TO 255
		RESTORE #T,0
		IF COL(T)<>1 THEN GOSUB 99
		PRINT #T,TAB(I);"*";
7905		IF COL(T)<>I+1 THEN GOSUB 99
		RESTORE #T,0
7910		FOR J=1 TO I-1
			READ #T,ONELEN$
			IF ONELEN$<>" " THEN GOSUB 99
		NEXT J
		READ #T,ONELEN$
		IF ONELEN$<>"*" THEN GOSUB 99
	NEXT I
	RESTORE #T,0\ REM SHOULD SET COL(T)=1
	REM TEST DON'T TAB IF ALREADY BEYOND PROPER COLUMN
	PRINT #T,ALPHABET$;TAB(26);"*"
	INPUT #T@0,THIRTY$
	IF THIRTY$<>"ABCDEFGHIJKLMNOPQRSTUVWXYZ*   " THEN GOSUB 99
	PRINT #T@0,ALPHABET$;TAB(27);"*"
	INPUT #T@0,THIRTY$
	IF THIRTY$<>"ABCDEFGHIJKLMNOPQRSTUVWXYZ*   " THEN GOSUB 99
	PRINT #T@0,ALPHABET$;TAB(28);"*"
	INPUT #T@0,THIRTY$
	IF THIRTY$<>"ABCDEFGHIJKLMNOPQRSTUVWXYZ *  " THEN GOSUB 99
7920	PRINT #T,TAB(256);\ GOSUB 99
7930	PRINT #T,TAB(0);\ GOSUB 99
7999	RETURN

8000	REM TEST OPSEQ
	IF NOT(''="") THEN GOSUB 99
	IF NOT('A'='A') THEN GOSUB 99
	IF NOT("ABCD"="ABCD") THEN GOSUB 99
	LET U$=" "\ ! FILL U$ WITH BLANKS
	IF NOT(U$=U$) THEN GOSUB 99
	IF ''="A" OR "ABC"="AB" OR "ABC"="ABD" THEN GOSUB 99
	RETURN

8100	REM TEST OPSNE
	IF ''<>'' THEN GOSUB 99
	IF  'A'<>'A' THEN GOSUB 99
	IF  'ABCD'<>"ABCD" THEN GOSUB 99
	IF NOT  (' '<>'A') THEN GOSUB 99
	IF NOT(  'ABC' <> 'AB' ) THEN GOSUB 99
	IF NOT(  'ABC' <> 'ABD'  ) THEN GOSUB 99
	RETURN

8200	REM TEST OPSLT
	IF "B"<"A" OR "9"<"0" THEN GOSUB 99
	IF "Q"<"Q" OR ".ABC"<"." THEN GOSUB 99
	IF "N"<"" OR ""<"" THEN GOSUB 99
	IF NOT( "CA"<"CB" ) THEN GOSUB 99
	IF NOT(  ".AC"<".ACD"  ) THEN GOSUB 99
	LET SIX$ = 'ABCDEF'
	LET TEN$ = 'ABCDEF    '
	IF SIX$ > TEN$ OR TEN$ = SIX$ THEN GOSUB 99
	LET TEN$ = 'ABCDEFA   '

	IF TEN$ < SIX$ THEN GOSUB 99
	IF NOT ( SIX$ < TEN$ ) THEN GOSUB 99
	RETURN

8300	REM TEST OPSLE
	IF "B"<="A" OR "99"<="89" OR ".ABC"<="." THEN GOSUB 99

	IF NOT( ''<='' AND 'AB'<="AB" AND "ABC"<="ABCD" ) THEN GOSUB 99
	IF "A"<="" THEN GOSUB 99
	IF NOT( ''<="AB" ) THEN GOSUB 99
	LET SIX$ = 'ABCDEF'
	LET TEN$ = 'ABCDEFG   '
	RETURN

8400	REM TEST OPSGT
	IF "A">"B" OR "0">"9" THEN GOSUB 99
	IF "A">"A" OR ".">".ABC" THEN GOSUB 99
	IF "">"N" OR "">"" THEN GOSUB 99
	IF NOT( "CB">"CA" AND ".ACD">".AC" ) THEN GOSUB 99
	LET SIX$ = 'ABCDEF'
	LET TEN$ = 'ABCDEF    '
	IF TEN$ < SIX$ OR SIX$ =TEN$ OR TEN$ <>TEN$ THEN GOSUB 99
	LET TEN$ = 'ABCDEFA   '
	IF SIX$ > TEN$ THEN GOSUB 99
	IF NOT (TEN$ > SIX$ ) THEN GOSUB 99
	RETURN

8500	REM TEST OPSGE
	IF "A">="B" OR "89">="99" OR ".">=".ABC" THEN GOSUB 99
	IF NOT( "">='' AND "AB">="AB" AND "ABCD">='ABC' ) THEN GOSUB 99
	IF "">='A' THEN GOSUB 99
	IF NOT( 'AB'>='' ) THEN GOSUB 99
	LET SIX$ = 'ABCDEF'
	LET TEN$ = 'ABCDEFG   '
	IF NOT (TEN$[1] >= SIX$[1] AND TEN$ >= SIX$ ) THEN GOSUB 99
	IF NOT ( TEN$[7] >= SIX$[6] AND TEN$ >= TEN$ ) THEN GOSUB 99
	RETURN

8600	REM TEST OPON
	ON 0 GOTO 8610,8610,8610,8610\ GOTO 8620
8610	GOSUB 99
8620	ON -1 GOTO 8630,8630\GOTO 8640
8630	GOSUB 99
8640	ON 5 GOTO 8650,8650,8650,8650\GOTO 8699
8650	GOSUB 99
8699	RETURN

8700	REM TEST OPXOR
	IF :0 XOR :0 <> 0 OR :0 XOR :FFFF <> :FFFF THEN GOSUB 99
	IF :1 XOR :1 <> 0 OR :5A5A XOR :FFFF <> :A5A5 THEN GOSUB 99
	IF :1234 XOR :1111 <> :0325 THEN GOSUB 99
	RETURN

8800	REM TEST OPPOKE
8810	POKE 29,:2\GOSUB 99
8830	POKE :FFFF,-1\GOSUB 99
8840	POKE :FFFF,257\GOSUB 99
8850	POKE :0,:2\GOSUB 99
8860	REM POKE AT THE PROGRAM ORIGIN
	LET X=PEEK(:3600)
	POKE :3600,:FF
	IF PEEK(:3600)<>:FF THEN GOSUB 99
	POKE :3600,:00
	IF PEEK(:3600)<>:00 THEN GOSUB 99
	POKE :3600,X
	RETURN

8900	REM TEST OPEEK
	IF PEEK(:100)<>:7E THEN GOSUB 99
	LET U$=" "\ ! SET LENGTH(U$) TO MAXLEN
	FOR J=1 TO MAXLEN(U$)
		REM FILL U$ WITH RANDOMNESS
		LET U$(J)=RANDOM & :FF
	NEXT J
	FOR I=:0000 TO :7FFF \! FIND U$ IN MEMORY
		FOR J=1 TO MAXLEN(U$)
			IF PEEK(I+J-1)<>U$[J] THEN CYCLE I\GOSUB 99\RETURN
		NEXT J
		REM FOUND WHAT APPEARS TO BE U$ AT I IN MEMORY
		IF PEEK(I-3)<>MAXLEN(U$) THEN GOSUB 99
		IF  PEEK(I-1)<>MAXLEN(U$) THEN GOSUB 99
		RETURN \ ! TEST COMPLETE
	NEXT I
	GOSUB 99
	RETURN

9000	REM TEST OPUSE
	GOTO NOTIMPLEMENTED

9100	REM TEST OPRMPT
	IF MUSTTESTINMANUAL THEN RETURN
	ELSE
		PRINT "Should print prompt ('? '); enter any string to proceed"
		INPUT U$
		PRINT "#";U$;"#"
	FI
	RETURN

9200	REM TEST OPINT
	FOR I=-1000 TO 1000
	IF INT(I)<>I THEN GOSUB 99\RETURN
	NEXT I
	FOR I=1 TO 100
		FOR X=1 TO 100
			IF INT(I/X)<>I/X THEN GOSUB 99\RETURN
		NEXT X
	NEXT I
	RETURN



9300	REM TEST OPERR
	FOR X=1 TO 32766
9305	ERROR X
9310	IF ERR<>X THEN GOSUB 99
	NEXT X
	RETURN

9400	REM TEST OPOPN
	CLOSE #T
	DELETE JUNKFILE$
9410	OPEN #T,JUNKFILE$\GOSUB 99
9420	OPEN #T,""\ GOSUB 99
9430	CREATE #T,JUNKFILE$
	PRINT #T,"HELLO!"
	CLOSE #T
	OPEN #T,JUNKFILE$
	INPUT #T,SIX$\ IF SIX$<>"HELLO!" THEN GOSUB 99
	RETURN

9500	REM TEST OPCLS
	CLOSE #99\REM CHANNEL NUMBER 99 IS NOT OPEN
	GOSUB 99
9510	CLOSE #-2
9520	GOTO 9400

9600	REM TEST OPCREAT
	CLOSE #T
9605	CREATE #-2,JUNKFILE$\GOSUB 99
9610	CREATE #257,JUNKFILE$\GOSUB 99
9620	CREATE #T,''\ GOSUB 99
9630	CREATE #T,JUNKFILE$
	GOTO 9400

9700	REM TEST OPCHAIN
	IF MUSTTESTINMANUAL THEN RETURN 
	ELSE
9705		CHAIN ""
9710		PRINT "CHAINING TO CTLRTP14HT2"
		LET CHNTST=:B27A
		LET CHNTST$="RAT"
		CHAIN "CTLRTP14HT2"
	FI
	RETURN

9800	REM TEST OPLFREFL
OPLFREFLLABELTEST:	X=1/0
	GOSUB 99
9810	IF OPLFREFLABELTEST2=0 THEN GOSUB 99
	REM TEST GOTO FORWARD REF LABEL
	X=-314
	GOTO OPLFREFLABELTEST2
	GOSUB 99
OPLFREFLABELTEST2:	IF X<>-314 THEN GOSUB 99
	RETURN

9900	REM TEST OPELN
	ON ERROR GOTO 9920
9910	LET X=1/0
	GOSUB 99
9920	IF ELN<>9910 OR ERR<>14 THEN GOSUB 99
	ON ERROR GOTO 9930
	LET ONELEN$[258]=1
	GOSUB 99
9930	IF ELN<>9920 OR ERR<>11 THEN GOSUB 99
	ON ERROR GOTO 96
	RETURN

10000	REM TEST OPPI
	GOTO NOTIMPLEMENTED
10100	REM TEST OPFIND
	LET TEN$='A'\ LET TEN$=''
	IF FIND(TEN$,'')<>1 THEN GOSUB 99
	IF FIND(TEN$,"A")<>0 THEN GOSUB 99
	LET TEN$="ABCDEFGHIJ"
	IF FIND(TEN$,'')<>1 THEN GOSUB 99
	IF FIND(TEN$,"A")<>1 THEN GOSUB 99
	IF FIND(TEN$,"ABCD")<>1 THEN GOSUB 99
	IF FIND(TEN$,"ACB")<>0 THEN GOSUB 99
	IF FIND(TEN$,"ABCDEFGHIJK")<>0 THEN GOSUB 99
	IF FIND(TEN$,"IJK")<>0 THEN GOSUB 99
	IF FIND(TEN$,TEN$)<>1 THEN GOSUB 99
	IF FIND(TEN$,"HIJ")<>8 THEN GOSUB 99
	IF FIND(TEN$,S$)<>0 THEN GOSUB 99
	REM TEST FOR FIND IN A 256 BYTE STRING
	LET U$=" "\ ! FILL U$ WITH BLANKS
	LET U$[250] =ASC("A")
	IF FIND(U$,"A")<> 250 THEN GOSUB 99
	IF FIND("ABABCAB","ABC")<>3 THEN GOSUB 99
	IF FIND("","")<>1 THEN GOSUB 99
	IF FIND("","A")<>0 THEN GOSUB 99
	RETURN

10200	REM TEST OPUSL
	GOTO NOTIMPLEMENTED
	RETURN

10300	REM TEST OPJUC
	GOTO NOTIMPLEMENTED2
	RETURN

10400	REM TEST OPINIT
	IF NEGONE<>-1 THEN GOSUB 99
	REM CHECK THAT COMPILER INITZES STRING$[N]/"..."/ PROPERLY
	IF LEN(S$)<>6 THEN GOSUB 99
	IF S$[1]<>:1 OR S$[2]<>ASC("H") OR S$[3]<>ASC("E")...
&	OR S$[4]<>ASC("L") OR S$[5]<>ASC("L") OR S$[6]<>ASC("O")
	THEN GOSUB 99
	RETURN

10500	REM TEST OPZCHN
	PRINT "This message should be printed on the console:"
	PRINT "TESTING OPZCHN (105)"
	RETURN

10600	REM TEST OPONG
	ON -1 GOSUB 99,99,99
	ON 0 GOSUB 99,99,99,99
	ON 5 GOSUB 99,99,99,99
	X=1
!	IF X<>-1 THEN GOSUB 99
	IF X<>1 THEN GOSUB 99
	RETURN
10630	X=-X\ RETURN

10700	REM TEST OPDEL
	CLOSE #T
	CREATE #T,JUNKFILE$
	CLOSE #T
	DELETE JUNKFILE$
10710	OPEN #T,JUNKFILE$\ GOSUB 99
10720	DELETE ""\GOSUB 99
10799	CREATE #T,JUNKFILE$
	RETURN

10800	REM TEST OPREN
	GOTO NOTIMPLEMENTED
	RETURN

10900	REM TEST OPSSL
	GOTO NOTIMPLEMENTED2
10999	RETURN

11000	REM TEST OPSTORE
	LET CHNTST=15 
	IF CHNTST<>15  THEN GOSUB 99
	LET CHNTST=46
	IF CHNTST<>46 THEN GOSUB 99
	RETURN

11100	REM TEST OPSGN
	IF SGN(0)<>0 OR SGN(2)<>1 OR SGN(-7)<>-1 THEN GOSUB 99
	RETURN

11200	REM TEST OPASM
	REM "OPASM NOT GENERATED BY COMPILER, CAN'T TEST"
	RETURN

11300	REM TEST OPLBOOL
	LET X=1>2
	IF X<>FALSE THEN GOSUB 99
	LET X=2>1
	IF X<>TRUE THEN GOSUB 99
	RETURN

11400	REM TEST OPRUS
	GOTO NOTIMPLEMENTED2
	RETURN


11500	REM TEST OPSETLABEL
	REM SET ERROR TRAP SO THAT LABEL ISN'T A FORWARD REFERENCE
	ON ERROR GOTO 11590
OPSETLABELTEST:	LET X=1/0
	GOSUB 99
11510	ON ERROR GOTO 96\ REM RESTORE ERROR TRAP ROUTINE
	RETURN
11590	IF ELN=OPSETLABELTEST AND ERR=14 THEN 11510
	GOTO 97

11600	REM TEST OPMAXLEN
	IF  MAXLEN(U$)<>250 THEN GOSUB 99
	IF MAXLEN(TEN$)<>10 THEN GOSUB 99
	IF MAXLEN(SIX$)<>6 THEN GOSUB 99
	RETURN

11700	REM TEST OPSYSCALL1ARG
	GOTO NOTIMPLEMENTED2


11800	REM TEST OPSYSCALL2ARG
	GOTO NOTIMPLEMENTED2


11900	REM TEST OPSYSCALL3ARG
	GOTO NOTIMPLEMENTED2


12000	REM TEST OPSYSCALL4ARG
	GOTO NOTIMPLEMENTED2


12100	REM TEST OPCOPYRIGHT
	GOTO NOTIMPLEMENTED

12200	REM TEST OPEXTENDED
	PRINT "OPEXTENDED (122) IS TESTED BY PASS III"
	RETURN

12300	REM TEST OPSUBRET
	X=0
	CALL SUBTEST(3)
	IF X<>3 THEN GOSUB 99
	RETURN
	SUBROUTINE SUBTEST(SUBTESTARG)
	X=SUBTESTARG
	EXIT SUBROUTINE
	END

12400	REM TEST OPFNCALL
	REM DEFINE THE FUNCTIONS WE NEED
DEF MAX(MAX1,MAX2)= IF MAX1>MAX2 THEN MAX1 ELSE MAX2 FI
DEF MAX$(CONC1$,CONC2$)
	RETURN IF CONC1$ > CONC2$ THEN CONC1$ ELSE CONC2$ FI
END

DEF PRINTONCHANNELZERO(PRINTONCH0ARG)
	PRINT #0,"This message is to be printed on the console:"
	RETURN PRINTONCH0ARG
END
	IF 3<>MAX(2,3) THEN GOSUB 99
	IF "LO"<>MAX$("HEL","LO") THEN GOSUB 99
	REM CHECK THAT CHANNEL NUMBER IS PRESERVED THRU A FUNCTION CALL
	PRINT #T,PRINTONCHANNELZERO(75)\GOSUB 91
	IF SIX$<>" 75   " THEN GOSUB 99
	RETURN

12500	REM TEST OPLINT
	IF 10<>9+1 OR 255 <> 256-1 THEN GOSUB 99
	RETURN

12600	REM TEST OPEXITLOOP
	FOR I=1 TO 10
		IF I=5 THEN EXIT I
		IF I>=5 THEN GOSUB 99
	NEXT I
	IF I<>5 THEN GOSUB 99
	RETURN

12700	REM TEST OPTRP
	REM TEST THAT ERROR TRAP ROUTINES DO NOT RESPOND TO <ESC>
	LET GOELNFLAG=0
	DEF JPLUSI=J+I
12710	IF GOELNFLAG=0 THEN PRINT 1/0
	IF GOELNFLAG<>1 THEN GOSUB 99
	PRINT "PLEASE BANG ON THE ESCAPE KEY..."
	PRINT "(NO RESPONSE SHOULD OCCUR)" 
	LET J=0
	FOR I=1 TO 100
12720		REM A PLACE FOR ESCAPE TO CATCH US
		REM ERROR TRAP ROUTINES TRANSFER CONTROL BACK TO THIS POINT
		LET J=JPLUSI \ REM INVOKE A FUNCTION, SHOULD NOT RESPOND TO ESCAPE
	NEXT I
	IF J<>100*(100+1)/2 THEN GOSUB 99\! NOT ESCAPE PROOF!
12730	GOTO ELN\GOSUB 99
12740	LET GOELNFLAG=0
	RETURN

NOTIMPLEMENTED2:
	PRINT "OPCODE NOT IMPLEMENTED IN CONTROL BASIC"
	RETURN

	END
