ASM 1.4
.SP
REFERENCE MANUAL
.SP 3
.CD
.np
.pa
.lm 10
.fs 22
.ce
ASM 1.4
.sp
.ce
REFERENCE MANUAL
.sp 4
.ce
7th Printing
.sp 2
.ce
COPYRIGHT (C) 1977 SOFTWARE DYNAMICS
.pa
.fs 10
.ce
NOTICE
.br
.ce
______
.sp 2
This manual describes Software Dynamics' ASM version 1.4 family of 680x
assemblers.  Software Dynamics has carefully checked the information given
in this manual, and it is believed to be entirely reliable.  However, no
responsibility is assumed for inaccuracies.
.sp
Software Dynamics reserves the right to change specifications without notice.
.SP
.pw 120
.ll 100
.im 20
**********************************************************************
** This manual  describes software  which is a proprietary  product **
** of Software Dynamics (SD).  SD software is licensed for use on a **
** single copy per computer basis, and is covered by U.S  copyright **
** laws.  Unless a written exception is obtained from SD, the soft- **
** ware must be used only on the single computer whose unique,  SD- **
** assigned serial number matches that for which  the  software was **
** purchased.  Copying the software  for  any  purpose  other  than **
** archival storage, or use of the  software on other than the  as- **
** signed serial numbered CPU is strictly  prohibited.   SD assumes **
** no liability regarding the use of the software.                  **
** Certain  software  programs and  datafiles are delivered for use **
** in an encrypted  format.  The content of such  programs and data **
** are  considered  to be a trade  secret of SD.  Attempts to break **
** the encryption  method,  publishing,  copying or storage of such **
** a program or file in clean text form will be treated as theft of **
** a trade secret, and prosecuted as such.                          **
** POSSESSION OR USE  OF THIS  MANUAL OR THE SOFTWARE  IT DESCRIBES **
** CONSTITUTES AGREEMENT BY THE USER TO THESE TERMS.                **
**********************************************************************
.ix Encryption
.sp
.ll 65
.pw 85
This manual and the software it describes are the copyrighted property
of Software Dynamics.
.sp
.pa 1
.he ASM REFERENCE MANUAL 10/28/85
.sh SECTION  I: INTRODUCTION
.IL Copyright (C) 1977
.IR Software Dynamics
.bp
.ce
SOFTWARE DYNAMICS
.ce
ASM -- 6800/6809/6805 MICROPROCESSOR ASSEMBLY LANGUAGE
.sp
.ce
INTRODUCTION
.tc
.sp 2
ASM -- A SMART ASSEMBLER ON A LITTLE MACHINE
.tc
.sp
ASM is a sophisticated family of assemblers for 6800, 6801, 6809 and 6805
microprocessors, and is intended for operation under the
.IX SDOS
SDOS operating system.
.sp
There are three such assemblers:
.sp
.in 10
.un 5
ASM6800, which assembles 6800/6801 source code.  ASM6800.680 executes
on a 6800, and ASM6800.689 executes on a 6809 system.
.br
.un 5
ASM6809, which assembles 6809 source code.  ASM6809.680 executes
on a 6800, and ASM6809.689 executes on a 6809 system.
.br
.un 5
ASM6805, which assembles 6805 source code.  ASM6805.680 executes
on a 6800, and ASM6805.689 executes on a 6809 system.
.in 0
.sp
These assemblers are  powerful, highly flexible development tools.  They are
fast.  Most important, they are designed by professionals with the
professional user in mind.
.sp
Significant features include:
.sp
.in 2
.un 2
--Multi-level conditional assembly.  ASM's facilities are unrivalled in the
industry.
.sp
.un 2
--Multi-level INCLUDE files.
.sp
.un 2
--Extensive listing format control.
.sp
.un 2
--Big-assembler computational power due to extensive operator
set.
.sp
.un 2
--Big-assembler performance due to hash-coded symbol table lookup.
.sp
.un 2
--Symbol table dumps sorted by name and by value; unused symbols are
flagged.
.sp
.un 2
--Big-assembler error diagnosis.  Readable error messages are produced on
the listing; error lines are always listed; and a special summary at the end
of the assembly tells you which lines had errors.
.sp
.un 2
.IX 680C
--680C coding style allows code to work on 6800, 6801 or 6809 by simply
reassembling.
.in 0
.pa
.tc
.IX Notation
NOTATION DEFINITION
.sp
When introducing a construct or command, the following notation will be used
to describe its allowable
.IX Syntax
syntax.
.sp
.in 2
.un 2
--Graphic characters (e.g., +, /, -) and symbols printed in upper case
denote strings of characters which must be present exactly as written in the
manual.  Example:
.in 8
,X
.in 2
denotes the string ",X".
.sp
.in 2
.un 2
--Symbols written in
.ix Angle Brackets
angle brackets denote a class of possible inputs.  For example,
.in 8
<NUMBER>
.in 2
denotes any string which conforms to ASM's definition of a number.  Hence,
the string
.in 8
345
.in 2
would qualify.
.sp
.un 2
.ix Curly Brackets
--Curly brackets are used to denote that a certain item is optional.
.in 8
{,X}
.in 2
indicates that the string ",X" may occur, but need not.
.sp
.in 2
Ranges of possibilities of which one must be chosen are denoted by listing
the alternatives vertically.
.in 8
X
.br
,X
.br
<EXP>,X
.in 2
indicates that either "X", ",X", or an expression followed by ",X" must be
present.  Note that this could also have been written as
.in 8
X
.br
{<EXP>},X
.in 2
or
.in 8
{ {<EXP>} , } X
.in 2
.sp
.un 2
--Finally,
.ix Ellipsis
.ix ...
ellipsis ("...") are used to indicate the possibility of indefinite
repetition when embedded in text.  For example,
.in 8
<EXP> { ,<EXP> ... }
.in 2
indicates that a series of one or more expressions separated by commas is
acceptable.  Ellipsis on a line by itself represents some indefinite
sequence of source lines.  For example:
.in 8
.im 3
        line 1
        ...
        line n
.br
.in 2
indicates that some sequence of lines exists between line 1 and line n.
.in 0
.pa
.tc
GENERAL DISCUSSION
.sp 2
All assemblers in the ASM family have all the properties described in this
manual, unless specifically indicated.  For the most part, differences
between the assemblers are limited to the instruction set intended
for assembly by ASM.
.sp
This manual assumes that the reader knows the appropriate
target machine instruction set (M6800/M6801, M6809 or M6805).
It is a manual on the USE of the assembler.  It is
not, nor is it intended to be, a
.ix Tutorial, Not A
tutorial on the
instruction set for these microprocessors.
.sp
To use ASM, the programmer first prepares a
.ix Source File
"source" disk file.  This can be done by using
.ix EDIT
EDIT or
.ix SEDIT
SEDIT under
.ix SDOS
SDOS.    Then ASM is invoked, and given the name of the source file to be
assembled, and names of listing and binary object files to be produced. 
.sp
ASM is a
.ix Two-Pass
two-pass assembler.  That is, the entire source file is read twice.  On the
first pass through the source file, all assembly errors are suppressed, and
certain operations (like producing a listing or binary) are not performed. 
This pass is performed primarily to assign symbols their values.
.sp
At the end of the
.ix Pass One
first pass, all symbols should be defined; ASM rewinds the source file, and
processes it again.
.ix Pass Two
This time it produces a listing file and a binary file, according to the
user's directions.
.sp 2
.sh SECTION II:  SOURCE FILE FORMAT
.pa
.tc
.ce
.ix Source File
.ix Source File Format
SOURCE FILE FORMAT
.SP
ASM places very few restrictions on the format of the source file.  Its only
requirements are:
.SP
.IN 8
.un 3
1)~Source lines must be terminated with
.ix Carriage Return
carriage returns.
.SP
.un 3
2)~Nulls may not be significant characters in the file; they will always
be ignored.
.SP
.un 3
3)~If the file is divided up into "forms" using
.ix Form-Feed
form-feed characters, the form-feeds must immediately follow a
carriage-return.
.IN 0
.SP
All other
.ix ASCII
ASCII characters are legal and will be printed in the listing without
complaint.
.ix Control Characters
Control characters (with the exception of tab) will always be printed as "^"
followed by an appropriate letter.  For example, control-A will be listed as
"^A".
.SP
The
.ix Tab
tab character is treated somewhat differently.  If it appears as part of a
character string, it will be listed as "^I"; otherwise it will cause one or
more blanks to be output, until the print carriage is positioned at a tab
stop or is past the last tab stop.  Tabs may be adjusted by the user via the
TABS directive.
.SP
A
.ix Form-Feed
form-feed character that does not follow a carriage return will always be
treated like any other ASCII control character.
.pa
.tc
.ix Source Line Format
.ix Line Format
LINE FORMAT
.SP
ASM has a free-format line
.ix Syntax
syntax.
.ix Fields
Fields may begin in
any column and are separated from one another (or
.ix Delimited
"delimited") by blanks or
.ix Tab
tabs.  Each field may be broken
into
.ix Subfield
subfields, each subfield being separated from the next
by
.ix Comma
commas.
.SP
Some consequences of ASM's line syntax are:
.SP
.IN 2
.un 2
.ix Blank Lines
--Blank lines may be freely inserted to format the
listing as desired.
.SP
.un 2
.ix Comment Line
--Comment lines may be specified either with a star
("*") in column 1 or with a series of blanks, a
.ix Semicolon
semicolon and the comment.  Examples:
.nj
.sp
     * THIS IS A COMMENT LINE.  THE "*" IS IN COLUMN 1.
.br
     ; THIS IS ALSO A COMMENT LINE.
.br
       ; THIS IS A COMMENT LINE, TOO.
.br
               ; ANY NUMBER OF BLANKS CAN PRECEDE ";".
.ju
.SP
.un 2
--Blank or tab characters not embedded in a string
ALWAYS terminate a field.  In particular, this means
that a comma should not usually be followed by a blank,
as one would ordinarily do when typing.  Also, this
means that blanks may not be inserted in the middle of
an
.ix Expression
expression.
.SP
.un 2
.ix Consecutive Blank
--Consecutive blanks or tabs are treated as a single
blank.
.IN 0
.pa
.ix Source Line Format
.ix Line Format
A line consists of the following parts, any of which may be
absent.  The scanning of a line is always stopped by a
.ix Semicolon
";" (semi-colon) character encountered outside a text string.
.SP
.tc
.in 4
.un 3
.ix Field, Label
1)~LABEL~FIELD (or
.ix LF
LF).  The
.ix Label Field
label field, if non-null, must
begin in the first column of the line.  (see "Line Numbers",
below for exception).  This field is generally used to
specify symbols whose values are to be changed or determined
by the command given on the same line.  If the label field begins
with an
.ix Asterisk
asterisk, the entire line is treated as a comment.
It will be listed but otherwise ignored.
.sp
.tc
.un 3
.ix Field, Command
2)~COMMAND~FIELD (or
.ix CF
CF).  The
.ix Command Field
command field is the second field of the
line.  This field is examined by ASM
in order to determine how to process the line.  If the command field
is absent, ASM will treat the line as an implicit
.ix EQU
EQU *
if a label is present, otherwise the line will be treated as
a comment.
.sp
.tc
.un 3
.ix Field, Argument
3)~ARGUMENT~FIELD (or
.ix AF
AF).  The
.ix Argument Field
argument field is the third
field of the line.  It  contains all arguments needed by the command.
For an argument field to be present, there must also be a command field.
Example:
.sp
.im 4
                LDAA    AF
                |       |
                |       > ARGUMENT FIELD
                > COMMAND FIELD
.sp
.tc
.un 3
.ix Field, Comment
.ix Comment Field
4)~COMMENT~FIELD.  Any portion of the line which is not
scanned for a given command, or which is separated from the
rest of the line by a semicolon, is treated as commentary.
It is listed but otherwise ignored (but note that this is not
the case when the semicolon is part of or delimits a string.
See discussions of
.ix FCC
FCC,
.ix TITLE
TITLE directives.)
.in 0
.pa
.tc
SOURCE LINE NUMBERS
.sp
ASM can accept files containing
.ix Line Numbers
line numbers at the
beginning of each line, as long as the user alerts ASM via
the
.ix WITH
"WITH" directive.
.sp
If line numbers are present in the file, the
.ix Source Line Format
.ix Line Format
line format is
modified somewhat.  Line numbers are handled in the following
fashion.
.sp
.in 8
.un 3
1)~Any string of zero or more digits or periods which
starts a line will be listed but otherwise ignored.
.sp
.un 3
2)~If the next character is a blank or a tab, it will
also be ignored.
.sp
.un 3
3)~The next character in the file will be the first
significant character of the line.
.sp
.un 3
4)~No error checking is done with respect to line
numbers.
.in 0
.pa
Examples: (Note that <TAB> represents the ASCII tab
character.  Assume that ASM has been directed to expect line
numbers.)
.sp
.im 3
        409.17 <TAB> LABEL <TAB> LDAA <TAB> FROG
        \----------/ \---/       \--/       \--/
           LINE #     LF          CF         AF
.sp
.im 3
        409.17LABEL <TAB> LDAA <TAB> FROG
        \----/\---/       \--/       \--/
         LN #  LF          CF         AF
.sp 2
Because of the definition of the
.ix Line Numbers
line number format, rather
unexpected things can happen:
.sp
.im 3
        409.17 <TAB> LDAA <TAB> FROG
        \----------/ \--/       \--/
           LINE #     LF         CF
.sp
In the above example, the LDAA is erroneously treated as a
label.  The proper way to enter the line is:
.sp
.im 4
        409.17 <TAB> <TAB> LDAA <TAB> FROG
        \----------/   |   \--/       \--/
           LINE #      |    CF         AF
                    (NO LF)
.sp
Note that the line number can be absent:
.sp
.im 3
        <TAB> LABEL <TAB> LDAA <TAB> FROG
        \---/ \---/       \--/       \--/
         LN #  LF          CF         AF
.sp
The moral is, be careful with line numbers.
.sh SECTION III: EXPRESSIONS
.pa
.tc
.ce
.ix Expressions
EXPRESSIONS
.sp
ASM provides the user with the ability to perform
sophisticated
.ix Computation
computations at assembly time.  ASM
expression handling represents a significant step beyond the
capabilities provided by
.ix Motorola
Motorola-standard assemblers.  Many
more
.ix Operators
operators are handled, as well as
.ix Parentheses
parenthetical and
.ix Operator Precedence
heirarchical grouping of subexpressions.
.sp
These extensions do not represent a burned bridge between
ASM and Motorola standard assemblers; in fact, ASM can
be directed via the
.ix WITH
"WITH" command to supress heirarchical
considerations and evaluate
.ix Expression Evaluation Order
operators from left to right;
thus sources currently in development using Motorola-standard
assemblers can be shifted to ASM without difficulty.
.sp 2
.tc
.ix Values
VALUES
.sp
.ix Numeric Values
Numeric values can be specified in
.ix Expressions
expressions in two ways:
manifestly and implicitly.
.ix Signed Numbers
All values share certain
attributes:
.sp
.in 2
.un 2
--They are all sixteen-bit quantities.
.sp
.un 2
--They are usually considered as two's complement signed
numbers, where the most-significant bit is the sign of the
number: positive if reset, negative if set.
.sp
.un 2
--Certain operators treat the values as 16-bit
.ix Unsigned Numbers
unsigned quantities, in particular the multiply and divide group.
.in 0
.pa
.ix Expressions, Values
.tc
.ix Manifest Values
.ix Values, Manifest
MANIFEST VALUES
.sp
"Manifest values" are those values which are entirely
self-defining; that is, the text of the manifest value
completely specifies the value to be used.  This section
describes the various
.ix Manifest Constants
manifest constants and their
variations.
.sp
.tc
DECIMAL NUMBERS
.ix Decimal Numbers
.ix Numbers, Decimal
.sp
The simplest manifest value is a decimal number.  The
value is represented by a string of decimal digits, in
ordinary base-10 notation.
.sp
.in 5
<DIGIT> { <DIGIT> ... }
.in 0
.sp
If the value specified exceeds 65535, "Overflow" is
reported.  If a letter is detected in the middle of a number,
"Illegal Digit" is reported.
.sp
Examples:
.sp
.pw 120
.ll 100
.nj
.im 5
        346
        000443
        00000001     (Many Leading Zeroes is OK)
        10000000     (But this is too big -- "Overflow" is reported)
        1139A4       (Also illegal -- bad digit)
.ll 65
.pw 85
.ju
.pa
.ix Expressions, Binary
.tc
BINARY NUMBERS
.ix Binary Numbers
.ix Numbers, Binary
.sp
Numbers may be specified in bases other than base ten.
Binary (base two) numbers are represented as follows:
.sp
.im 2
        % <B-DIGIT> { <B-DIGIT> ... }
        <B-DIGIT> { <B-DIGIT> ... }   B
.sp
<B-DIGIT> must be either '0' or '1'.  If a digit outside this
range is seen, "Illegal Digit" is reported.  If the assembled
value exceeds 65535, "Overflow" is reported.
.sp
Examples:
.sp
.pw 120
.ll 100
.nj
.im 4
        %10110                (Binary repesentation of 22 base 10)
        10110B                (Same thing using suffixed form)
        %111000111000111000   (Too big -- causes "overflow")
        010210B               (Illegal -- "2" is not a binary digit)
.sp
.ll 65
.pw 85
.ju
Lower case
.ix Qualifiers
qualifiers are also accepted:
.sp
.im 1
        %1011b                (Same as %1011B)
.sp 2
.tc
OCTAL NUMBERS
.ix Octal Numbers
.ix Numbers, Octal
.sp
Numbers may be specified in base eight, "octal
notation." Such numbers have the form:
.im 3
        @ <O-DIGIT> { <O-DIGIT> ... }
        <O-DIGIT> { <O-DIGIT> ... }  O  (The letter "oh")
        <O-DIGIT> { <O-DIGIT> ... }  Q
.sp
<O-DIGIT> may be any of the digits "0" through "7"; if "8" or
"9" are seen, "Illegal Digit" is reported.  If the value
exceeds 65535, "Overflow" is reported.
.sp
Examples:
.sp
.pw 120
.ll 100
.nj
.im 5
        @26           (Octal representation of 22, base ten)
        26O           (The same, using suffix form)
        26Q           (Alternate suffix form)
        @759          (Illegal -- '9' is not an octal digit)
        @3777777      (Too big -- "overflow" is reported)
.ll 65
.pw 85
.ju
.sp
Note that lower case
.ix Qualifiers
qualifiers are also accepted:
.sp
.im 2
        026q
        73o
.pa
.tc
HEXADECIMAL NUMBERS
.ix Hexadecimal Numbers
.ix Expressions, Hexadecimal
.ix Numbers, Hexadecimal
.sp
Numbers may be specified in base 16, so-called "hexadecimal notation." Each
digit represents a number from 0 to 15; the digits 10 through 15 are
represented by the letters "A" through "F".  There are two forms:
.sp
.im 1
        $ <HEXDIGIT> { <HEXDIGIT> ... }
.br
.im 1
        <DIGIT> { <HEXDIGIT> ... } H
.sp
A suffix-form hexadecimal value MAY NOT begin with one of the hex digits "A"
through "F".  Numbers whose first significant digit is "A" through "F" must
have a leading zero (see examples).
.sp
If a letter that is not between "A" and "F" is seen, "Illegal Digit" is
reported.  If the value exceeds $FFFF, "Overflow" is reported.
.sp
Examples:
.pw 120
.ll 100
.nj
.sp
.im 6
        $16       (Hex representation of 22, base 10)
        16H       (Suffix form of same number)
        0AEH      (Suffix form of $AE)
        AEH       (Invalid -- this is a symbol)
        $EG       (Invalid -- "G" is not a hex digit)
        $FFFE3    (Invalid -- too big for 16 bits. Overflow reported)
.ll 65
.pw 85
.ju
.sp
Lower case digits and
.ix Qualifiers
qualifiers are accepted:
.sp
.im 2
        0aeh
        $f7f
.pa
.tc
.ix Expressions, Character
CHARACTER VALUES
.ix Characters
.ix Character Values
.ix Values, Character
.sp
A value may be specified in terms of the
.ix ASCII
ASCII code of an input character.  Such values have the following form:
.sp
.im 1
        ' <CHARACTER>
.sp
The "'" is a single
.ix Quote Character
quote character, ASCII $27.  <CHARACTER> may be any character except
carriage-return (subject to the restrictions mentioned in the section on
"Source File Format").  If the character is a tab, it will be listed as "^I"
for improved readability; hence the only time one will see "'" followed by a
blank in a listing is when the quoted character actually is a blank.
.sp
The value used will be the 7-bit ASCII value of the character, with zeroes
extended to fill the 9 most-significant bits of the value.
.pw 120
.ll 100
.nj
.sp
Examples:
.sp
.im 4
        'A            (Specifies the value 65, base 10)
        '             (Specifies the value 32, i.e. quoted blank)
        '^I           (Specifies the value 9)
        '<CR>         (Invalid -- "illegal string" is reported)
.ll 65
.pw 85
.ju
.pa
.tc
.ix Expressions, Implicit Value
.tb 5,15,22,35,40,45,50,55,60,
IMPLICIT VALUES
.ix Implicit Values
.ix Values, Implicit
.ix Symbolic Values
.ix Values, Symbolic
.ix Expressions, Special Symbols
.br
.sp
Obviously, manifest values would not be very useful by themselves.  An
important feature of any assembler is the ability to represent values
symbolically. The user thus gains the ability to manipulate values without
having to know what the actual values are.
.sp 2
.tc
THE "*" VALUE
.ix Expressions, *
.sp
ASM provides a special kind of implicit value -- the address that the next
byte stored into memory will occupy.  This value is called the
.ix Location Counter
LOCATION COUNTER.  Whenever
a
.ix Star
star ("*") takes the place of a value in an expression, ASM substitutes the
current value of the location counter.  This value can be used like any
other value; it is never a
.ix Forward Reference
forward reference.  At the beginning of each pass, "*" has the value zero.
.sp
"*" does not neccessarily remain the same throughout the processing of a
statement (for example, see
.ix FDB
FDB directive). But on most statements, particularly all machine language
instructions, it remains constant until all expressions on that line have
been evaluated.
.sp 2
.tc
THE "*'" VALUE
.ix Expressions, *'
.ix Next Instruction Address
.sp
ASM for 6809 provides a second type of instruction counter, the location of
the start of the next instruction.  Whenever the
.ix Star-Apostrophe
star-apostrophe appears ("*'")
within an instruction operand, it will yield the value of the following
instruction's opcode byte.  If the star-apostrophe appears in a
non-instruction line, its value is identical with star ("*").
.sp
Examples:
.sp
.im 3
                FDB     *'      ;Same as *
                #*'             ;Same as *
        A       SET     *'      ;Same as *
.sp
The reason for this special implicit value is it represents the
.ix PC
PC (program counter) value that is used in
.ix Program Counter Relative, 6809
PC relative addressing modes.
.sp
Example:
.sp
.im 1
                LDA     QQQ-*',PC       ;Relative reference to loc QQQ
.pa
.tc
SYMBOLS
.ix Symbols
.ix Expressions, Symbols
.ix Symbol Syntax
.sp
Symbols in ASM consist of a letter, a colon (":") or a period ("."),
followed by a string of letters, digits, colons, periods, dollar signs
("$"), percent signs ("%") or at signs ("@").  A symbol may be of any
length; however only the first thirty-two are used to distinguish one symbol
from another.
.sp
Lower-case letters which appear in symbols are considered by ASM to be the
same character as their upper-case equivalent.  They will appear in lower
case on the listing, but will match upper-case versions of the same letters.
.sp
The following are symbols:
.sp
.pw 120
.ll 100
.nj
.im 9
        QRS
        qrs     (The same as QRS -- lower-case matches upper-case)
        L34
        A
        .BEGIN.WITH.DOT.LONGER.THAN.THIRTY
        .BEGIN.WITH.DOT.LONGER.THAN.THIRTY.TWO
                (ASM treats the last two as the same symbol)
        .BEGIN.WITH.DOT.LONGER.THAN.FIFTEEN
                (This symbol is different from both the above)
.sp
.ll 65
.pw 85
.ju
The following are NOT symbols:
.sp
.pw 120
.ll 100
.nj
.im 1
        $DOLLAR (Does not begin with letter, colon or period)
.sp
.ll 65
.pw 85
.ju
.pa
.tc
RESERVED SYMBOLS
.ix Symbols, Reserved
.ix Reserved Symbols
.ix Symbol, X
.ix Symbol, U
.ix Symbol, A
.ix Symbol, B
.ix Symbol, D
.ix Symbol, S
.ix Symbol, CC
.ix Symbol, DP
.ix Symbol, PC
.ix Symbol, PCR
.sp
ASM has no "reserved symbols", however, some symbols have special
interpretation in certain contexts.  For 6800/6801 ASM, these symbols are
"A", "B", "D", "S",  and "X".  For 6809 ASM the symbols "A", "B", "D", "X",
"Y", "S", "U", "CC", "DP", "PC" and "PCR" can have special interpretations.
For 6805 ASM, only the symbol "X" has a special interpretion.
See "Machine Instruction Lines" for details.
.sp 2
.tc
PRE-DEFINED SYMBOLS
.ix Pre-Defined Symbols
.ix Symbols, Pre-Defined
.sp
ASM has three pre-defined symbols:
.sp
.ix M6800
.ix M6801
.ix M6809
.ix Symbol, M6800
.ix Symbol, M6801
.ix Symbol, M6809
.im 3
        M6800   
        M6801   
        M6809   
.sp
The purpose of these symbols is to support the
.ix 680C
680C "concept", permitting
.ix Conditional Assembly
conditional assembly dependent on the target CPU.  For more information,
see "Appendix D".
.sp
For the ASM6800 with 6801 option disabled (no use of WITH M6801 directive),
the symbol M6800 has the value 1, and M6801 and M6809 have the value 0.  For
ASM6800 with 6801 option enabled (WITH M6801 directive used), the symbol
M6801 has the value 1 and M6800 and M6809 have the value 0.  ASM6809 has
M6809 equal to 1 with M6800 and M6801 equal to 0.
.sp
ASM6805 does not support M680C, and so does not predefine the symbols
M6800, M6801 or M6809.
.sp 2
.tc
FORWARD REFERENCES
.ix Forward Reference
.ix Expressions, Forward References
.sp
A symbol may with some restrictions be used before it is defined.  Such a
use is called a FORWARD REFERENCE.  In general, a forward reference may be
used in any context that will allow ASM to allocate the same number of bytes
at the same locations in
.ix Pass One
pass one and
.ix Pass Two
pass two.
.sp
See Appendix A for a list of ASM directives which do not allow forward
references.
.pa
.tc
COMPUTATION
.ix Computation
.ix Arithmetic
.ix Operators
.ix Expressions, Operators
.sp
Manifest and implicit values can be combined and operated upon at assembly
time to produce new values.  This is done by means of operators.  ASM
provides an extensive range of computational functions.  These functions are
divided into two categories:
.ix Monadic Operators
Monadic operators, which operate on one value to produce a result; and
.ix Dyadic Operators
Dyadic Operators, which combine two values to produce a third.
.sp
.tc
MONADIC OPERATORS
.ix Monadic Operators
.ix Binary Operators
.sp 2
.ix Plus
.ix +<A>
.im 1
     +<A>
.br
Monadic plus does nothing.  Its usual use is for clarity.
.im 5
     +1      ==>     1
     +0      ==>     0


     -<A>
.ix -<A>
.ix Negate
.ix Minus
.br
Monadic minus computes the two's complement of its argument.
.im 5
     -1      ==>     $FFFF
     -0      ==>     0


      +\<A>
.ix +\<A>
.ix Complement
.ix Backslash
.br
Monadic backslash computes the one's complement of its argument.
.im 5
     \1      ==>     $FFFE
     \0      ==>     $FFFF


     &<A>
.ix &<A>
.ix Ampersand
.ix Logical Inverse
.ix TRUE
.ix FALSE
.br
Monadic ampersand computes the logical inverse of its argument.  ASM
considers any zero or negative value to be logically "false"; any positive
non-zero value is "true".
.im 4
     &1      ==>     0
     &0      ==>     1
     &17     ==>     0
     &(-1)   ==>     1
.pa
.tc
.ix Expressions, Arithmetic
.ix Dyadic Operators
.ix Binary Operators
DYADIC OPERATORS
.sp 2
.im 1
     <A>+<B>
.ix <A>+<B>
.ix Add
.br
Dyadic
.ix Plus
plus computes the arithmetic sum of its two arguments. No check is made for
overflow.
.im 6
     3+2             ==>     5
     $FA00+$100      ==>     $FB00
     $105+$FFFF      ==>     $104    (No overflow is reported)


     <A>-<B>
.ix <A>-<B>
.ix Subtract
.br
Dyadic
.ix Minus
minus computes the two's complement arithmetic difference of its arguments. 
No overflow check is made.
.im 6
     3-2             ==>     1
     $FA00-$100      ==>     $F900
     $105-$FFFF      ==>     $106


     <A>*<B>
.ix <A>*<B>
.ix Times
.br
Dyadic
.ix Star
star multiplies its arguments together as sixteen-bit unsigned quantities. 
If the result cannot be represented as a sixteen bit unsigned number,
"Overflow" is reported.
.im 6
     3*2             ==>     6
     $7000*2         ==>     $E000   (No overflow)
     $FE00*2         ==>     $FC00   (Overflow)


     <A>/<B>
.ix <A>/<B>
.ix Divide
.ix Slash
.br
Slash computes the quotient of <A> divided by <B>.  The arguments are
treated as sixteen-bit, unsigned quantities. If <B> is zero, "Overflow" is
reported, and the result is zero.
.im 4
     3/2             ==>     1       (Integer division)
     307/5           ==>     61
     $FE00/$100      ==>     $FE
     $170C/0         ==>     0       (Overflow)
.pa
.im 1
     <A>//<B>
.ix <A>//<B>
.ix Doubleslash
.ix Divide
.ix Covered Quotient
.br
Doubleslash computes the Covered Quotient of <A> and <B>. Covered Quotient
is defined as (<A>+<B>-1)/<B>.  This operator is useful in computing the
number of <B>-byte units needed to hold <A> bytes.  For example, if PROGSIZE
is the number of bytes in a program, and SECTSIZE is the number of bytes in
a disk sector, PROGSIZE//SECTSIZE is the number of disk sectors required to
store that program.
.im 7
     3//2            ==>     2
     307//5          ==>     62
     $FE00//$100     ==>     $FE
     $170C//0        ==>     0       (Overflow)
     $FF03//$100     ==>     $100    (Note that this works even
                                     though $FF03+$100-1 exceeds
                                     16 bits) 
.sp
.im 1
     <A>\<B>
.ix <A>\<B>
.ix Remainder
.ix Divide
.ix Backslash
.br
Dyadic backslash computes the remainder of <A> divided by
<B>.
.im 5
     3\2             ==>     1
     307\5           ==>     2
     $FE00\$100      ==>     0
     $170C\0         ==>     0       (Overflow)
     $FF03\$100      ==>     3
.sp 2
.im 1
     <A>##<B>
.ix <A>##<B>
.ix Shift
.ix Hash
.br
Doublehash performs a logical-shift operation.  If <B> is positive, the
result is <A> shifted left <B> bit places, with zeroes shifted into the
least-significant bits.  If <B> is negative, the result is <A> shifted right
<B> bit places, with zeroes shifted into the most-significant bits.  If <B>
is zero, the result is <A>.
.im 4
     3##2            ==>     $C
     $FE##8          ==>     $FE00
     $FE00##-8       ==>     $FE
     12345##16       ==>     0
.sp 2
.im 1
     <A>!<B>
.ix <A>!<B>
.ix Or
.ix Inclusive-Or
.ix Bang
.ix Exclamation Point
.br
Bang computes the bitwise logical-inclusive-or of its arguments.
.im 3
     2!1     ==>     3
     0!4     ==>     4
     7!2     ==>     7
.pa
.ix Expressions, Boolean
.im 1
     <A>&<B>
.ix <A>&<B>
.ix Ampersand
.br
Dyadic ampersand computes the bitwise logical-and of its arguments.
.im 3
     2&1     ==>     0
     0&4     ==>     0
     7&2     ==>     2
.sp 2
.im 1
     <A>!!<B>
.ix <A>!!<B>
.ix Exclusive-Or
.br
Doublebang computes the bitwise logical-exclusive-or of its arguments.  It
is defined as (<A>&\<B>)!(<B>&\<A>).
.im 3
     2!!1    ==>     3
     0!!4    ==>     4
     7!!2    ==>     5
.sp 2
.im 1
     <A>=<B>
.ix <A>=<B>
.ix Expressions, Relational
.ix Relational Operators
.ix Equal
.br
Equal compares its arguments and returns 1 if they are equal, 0 otherwise.
.im 2
     3=3     ==>     1
     3=4     ==>     0
.sp 2
.im 1
     <A>#<B>
.ix <A>#<B>
.ix Not Equal
.br
Hash compares its arguments and returns 0 if they are equal, 1 otherwise.
.im 2
     3#3     ==>     0
     3#4     ==>     1
.pa
.im 1
     <A> > <B>
.ix <A> > <B>
.ix Greater
.br
Greater compares its arguments as signed numbers; returns 1 if left argument
is greater than the right argument, 0 otherwise.
.im 5
     3>3     ==>     0
     3>4     ==>     0
     4>3     ==>     1
     $FFFE>0 ==>     0
     0>$FFFE ==>     1
.br
(Note that $FFFE is interpreted here as -2.)
.sp 2
.im 2
     <A> >= <B>
     <A> => <B>
.ix <A> >= <B>
.IX <A> => <B>
.IX Greater Equal
.br
Greater-equal is like Greater, but returns 1 if <A> is
greater than or equal to <B>.
.im 6
     3>=3            ==>     1
     3>=4            ==>     0
     4>=3            ==>     1
     $FFFE>=0        ==>     0
     0>=$FFFE        ==>     1
($FFFE is interpreted here as -2.)
.sp 2
.im 1
     <A> < <B>
.ix <A> < <B>
.ix Less
.br
Less is like Greater, but returns 1 if <A> is less than <B>,
0 otherwise.
.im 6
     3<3             ==>     0
     3<4             ==>     1
     4<3             ==>     0
     $FFFE<0         ==>     1
     0<$FFFE         ==>     0
($FFFE is interpreted here as -2.)
.sp 2
.im 2
     <A> <= <B>
     <A> =< <B>
.ix <A> <= <B>
.ix <A> =< <B>
.ix Less Equal
.br
Less-equal is like Greater, but returns 1 if <A> is less than
or equal to <B>, 0 otherwise.
.im 6
     3<=3            ==>     1
     3<=4            ==>     1
     4<=3            ==>     0
     $FFFE<=0        ==>     1
     0<=$FFFE        ==>     0
($FFFE is interpreted here as -2.)
.pa
.im 1
     <A> >> <B>
.ix <A> >> <B>
.ix Greater
.br
Logical-greater compares its arguments as UNSIGNED numbers;
it returns 1 if <A> is greater than <B>, otherwise 0.
.im 6
     3>>3            ==>     0
     3>>4            ==>     0
     4>>3            ==>     1
     $FFFE>>0        ==>     1
     0>>$FFFE        ==>     0
($FFFE is interpreted here as 65534.)
.sp 2
.im 1
     <A> >/ <B>
.ix <A> >/ <B>
.ix Greater Equal
.br
Logical-greater-equal is like Logical-greater, but returns 1
if <A> is greater than or equal to <B>, 0 otherwise.
.im 6
     3>/3            ==>     1
     3>/4            ==>     0
     4>/3            ==>     1
     $FFFE>/0        ==>     1
     0>/$FFFE        ==>     0
($FFFE is interpreted here as 65534.)
.sp 2
.im 1
     <A> << <B>
.ix <A> << <B>
.ix Less
.br
Logical-less is like Logical-greater, but returns 1 if <A> is
less than <B>, otherwise 0.
.im 6
     3<<3            ==>     0
     3<<4            ==>     1
     4<<3            ==>     0
     $FFFE<<0        ==>     0
     0<<$FFFE        ==>     1
($FFFE is interpreted here as 65534.)
.sp 2
.im 1
     <A> \< <B>
.ix <A> \< <B>
.ix Less Equal
.br
Logical-less-equal is like Logical-greater, but returns 1 if
<A> is less than or equal to <B>, otherwise 0.
.im 6
     3\<3            ==>     1
     3\<4            ==>     1
     4\<3            ==>     0
     $FFFE\<0        ==>     0
     0\<$FFFE        ==>     1
($FFFE is interpreted here as 65534.)
.pa
.tc
COMPLEX EXPRESSIONS
.sp
ASM allows the user to create complex expressions
involving many operators.  In such
.ix Expressions
expressions, the problem
arises of order of computation.  ASM provides two
methods of specifying this order.
.sp 2
.tc
OPERATOR HIERARCHY
.ix Operator Precedence
.ix Expressions, Precedence
.sp
Unless otherwise instructed (via the "WITH" directive or
the use of parentheses), ASM evaluates expressions using
an operator-precedence algorithm; the
.ix Order of Evaluation
order of evaluation,
though generally left-to-right, can be modified according to
which operators are used.  In order to determine whether an
operator gets to be evaluated, ASM looks at the
.ix Operators
operators which follow that operator in the expression.  If
the next operator gets to go first, ASM performs that
operator and uses the result as the right argument to this
operator -- but not before checking the operator-after-next,
and so on.  The ordering decision is made as follows:
.sp
.in 3
.un 3
1)~The first operators performed will be monadic operators,
from right to left.
.im 2
        --SYM   <==>    -(-SYM)
        -\4     <==>     -(\4).
.sp
.un 3
2)~The next operator performed will be double-hash (shift).
.im 1
        A##-3   <==>    A##(-3)
.sp
.un 3
3)~The next operators performed will be *, /, // and \, going
from left to right across the expression.
.im 3
        A*B/5   <==>    (A*B)/5
        A/5##4  <==>    A/(5##4)
        A/B*2   <==>    (A/B)*2
.sp
.un 3
4)~The next operators performed will be dyadic + and -, again
from left to right.
.im 4
        A+3-B   <==>    (A+3)-B
        A-3+B   <==>    (A-3)+B
        A-B-C   <==>    (A-B)-C
        A-B*4   <==>    A-(B*4)
.sp
.un 3
5)~The next operators evaluated will be the relational
operators: =, #, <, <=, =<, >, >=, =>, <<, \<, >>, and >/.
.im 4
        3*A<B           <==>    (3*A)<B
        4##2<<5/A+2     <==>    (4##2)<<((5/A)+2)
        B>3*A           <==>    B>(3*A)
        A<B<C           <==>    (A<B)<C
.sp
.un 3
6)~Last come the logical operators: !, &, and !!.
.im 2
        A<B&C=D+2       <==>    (A<B)&(C=(D+2))
        A>B!C#D!!D<0    <==>    ((A>B)!(C#D))!!(D<0)
.sp
.in 0
.pa
.tc
PARENTHESES
.ix Parentheses
.ix Expressions, Parentheses
.sp
As implied in the above descriptions, parentheses can be used to specify
explicitly the order of evaluation of a given expression.  Parentheses must
always be matched; that is, for every left parenthesis there must be one and
only one corresspondng right parenthesis.  A failure here will result in a
"Syntax Error" for the line containing the expression.
.sp
Parentheses may be nested to any level.
.sp
They may be used even if
.ix WITH
WITH MCM has been specified.
.sh SECTION IV: LINE PROCESSING
.pa
.tc
.ce
LINE PROCESSING
.ix Line Processing
.sp
ASM follows these rules when processing a line:
.sp
.in 3
.un 3
1)~If the first character of the Label field is a
.ix Star
star ("*"), the line is treated as a
.ix Comment
comment.  It is listed but otherwise ignored.
.im 2
        *       This is a comment
        *       Ignore me.
.sp 2
.un 3
2)~If the
.ix Command Field
command field consists of a single symbol it is looked up in the list of
.ix Opcodes
opcodes (see sections on "Machine Instruction Lines" for lists of opcodes
accepted).  If found, the line is treated as a
.ix Machine Instruction Line
machine instruction line.
.im 4
                LDX     3
                TSX             All of these
                CLV             are machine instruction lines
                PUL A           by rule (2).
.sp
.un 3
3)~If the command field is not an opcode symbol, then the symbol is checked in
the list of ASM directives.  If found, the line is treated as a
.ix Directive
directive line.
.im 3
        J       EQU     17      This is a directive by rule (4)
                PAGE            So is this
                ORG     $47     As is this
.sp
.un 3
4)~Any line which does not qualify under rules (2), or (3) is processed as
an
.ix Implicit Data
implicit data statement (see
below).
.im 3
                LDAC    #34     This is an implicit data statement
                3,4*17          So is this
                (TSX)           So is this
.in 0
.sh SECTION V: 6800/6801 MACHINE INSTRUCTION LINES
.pa
.tc
.ce
6800/6801 MACHINE INSTRUCTION LINES
.ix Machine Instruction Line, 6800/6801
.sp
The major function of an assembler is the translation of symbolically
specified machine instructions into a form directly understandable by the
target computer.  This section describes instructions translated by
.ix ASM6800
ASM6800, and presumes knowledge
of the
.ix 6800/6801
6800/6801 instruction set, which can be found in the Motorola MC6801
Programming Manual.  ASM is fully compatible with the
.ix Motorola
Motorola 6800 standard assembler syntax, with several useful
.ix Extensions
extensions.
.sp
.in 2
.un 2
--6801 opcodes are assembled if enabled by use of a WITH M6801 directive.  6800
equivalent instructions are assembled for 6801 instructions if a WITH M6801 
directive is not given.
.sp
.un 2
.ix 6809
--Many 6809 assembly mnemonics and address modes are supported.  This
considerably simplifies construction of programs that will run on
either processor, depending on which assembler is used.  See section 
.IX M680C (see 680C)
on M680C.
.sp
.un 2
--Special set of opcodes to allow coding to work on 6800, 6801 and
6809.  These opcodes are called
.ix 680C
680C opcodes  (See Appendix D).
Many "convenience" instructions are included in 680C, which act as logical
extensions to the '00/'09 instruction set, such as double register shifts,
16 bit memory increments, and decrements, etc.
.sp
.in 2
.ix Long Branches
.ix Branches, Long
.ix Short Branches
.ix Branches, Short
.un 2
--Automatic long branching.  Short branches that are out-of-range will be
assembled as a branch on complementary conditions around
a JMP to the destination if the destination expression contains no
.ix Forward Reference
forward references.
.sp
.un 2
--Multiple
.ix Labels
labels are allowed, separated by
.ix Comma
commas.  All labels present on an opcode line will be equated to the
.ix Location Counter
location counter, "*", before the rest of the line is
processed.
.sp
.un 2
--Two new inherent-addressing mode opcodes are defined,
.ix SK1
SK1 and
.ix SK2
SK2 (Skip 1 and Skip 2).  These opcodes can be used to cause the CPU to skip
one or two bytes before executing the next instruction, changing only the
condition code flags.  These opcodes will work on all standard 6800/6801
CPUs; they are really the opcode bytes of Bit A, Immediate and Compare X,
Immediate instructions. Note that use of these instructions is NOT generally
portable from 6800 to 6809 and vice versa.
.sp
.un 2
--A, B, D, S, and X may be used as ordinary symbols as long
.ix Symbols
as they are distinguishable from their use as register designators.
.sp
.in 0
.pa
ASM processes each machine instruction line as follows: all
.ix Labels
labels are
first equated to the
.ix Location Counter
.ix Line Processing
location counter, '*'; then the opcode specified is inspected to determine
which operand addressing modes are legal.  Finally, the operand field is
scanned for an appropriate
.ix Addressing Mode
addressing mode specification.  The
.ix Opcode
opcode is combined with the specified addressing mode to generate the
object code corresponding to the desired instruction.
.sp
Many opcodes (LDA, STAA STX, SUBD, etc.) include a
.ix Register
register specification
(A, B, D, X, or S) as the last letter of the opcode mnemonic.
.sp
There are several operand modes for 6800/6801 instructions. A given
instruction that is recognized by ASM will have one or more modes as legal
forms (some opcodes require no operand specification whatsoever).  The
.ix Syntax
syntax of each of these modes is discussed in the following pages. A few
examples of each mode will be given. A table of
.ix Instruction Mnemonics, 6800
instruction mnemonics and their modes can be found at the end of this
section.
.sp
Throughout this section, the
.ix Notation
notation " <expr> " means any expression, "EA=" means Effective Address, and
"(" <expr> ")" to the right of "EA=" means "the contents of <expr>".
.pa
.tc
INHERENT MODE
.ix Inherent Mode 6800
.ix Addressing, Inherent 6800
.sp
Inherent Mode opcodes need no operand specifications.  The
.ix Argument Field
argument field is ignored.  For portability purposes, it should be left blank.
.sp
Syntax:
.im 1
                <opcode>
.sp
Examples:
.sp
.im 4
                RTI             ;Return from Interrupt
                DES             ;S:=S-1
                CLRA            ;A-Reg:=0
                PSHD            ;Pushes A and B
.sp 2
.tc
REGISTER-REGISTER MODE
.ix Register-Register Mode
.ix Addressing, Register 6800
.sp
Register-Register Mode addresses source and destination registers.
This mode is used only for
.ix TFR
TFR A,B and TFR B,A 6809 equivalent
instructions.  See
.ix 680C
M680C description.
.sp
Syntax:
.im 1
                <opcode>  <reg>,<reg>
.sp
Examples:
.sp
.im 2
                TFR     A,B
                Tfr     b,a
.pa
.tc
DIRECT MODE
.ix Direct Mode, 6800
.ix Addressing, Direct 6800
.sp
Direct Mode is used to address a location in the range $0000 through $00FF.
The 8 bits of operand embedded in the instruction form the lower 8-bits of
the 16-bit memory reference address while the upper 8-bits of the address
are implicitly zero.  If an instruction operand address evaluates within the
range $0000 to $00FF, ASM automatically generates  Direct Mode memory
reference if appropriate for that instruction.
.sp
Direct references may be forced with a "<" prefix.
.ix Prefix, < 6800
.ix Prefix
Use of this prefix prevents any default to the
.ix Extended Mode, 6800
Extended Mode addressing. An error is generated if the effective address
does not map into the range $0000 to $00FF. Use of the "<" prefix is illegal
with opcodes that only allow extended mode addressing.
.sp
Syntax:
.im 1
                <opcode>        {<prefix>}<exp>
.sp
Example:
.sp
.pw 120
.ll 100
.im 8
        A       EQU     $10
        B       EQU     $123
                                ;Generated:
                SUBB    A       ;Direct reference to loc $10
                INC     B       ;Extended reference to loc $123
                ADDB    <A      ;Direct reference to loc $10
                LDA     <B      ;Direct ref to loc $123 WITH ERROR
                ROR     <A      ;Extended reference WITH ERROR
.ll 65
.pw 85
.pa
.tc
EXTENDED MODE
.ix Extended Mode, 6800
.ix Addressing, Extended 6800
.sp
Extended mode addresses memory with a 16-bit address embedded in the
instruction.  Any location in the memory space can be referenced with this
mode.  Extended mode may be forced by use of the ">" prefix.
.ix Prefix, > 6800
.ix Prefix
Certain 6800/6801 instructions can only use Extended modes to directly
reference memory.  Instructions whose operand evaluates to an address in the
range $0100 to $FFFF, or which are extended-mode only instructions are
assembled with an extended address mode.
.sp
Syntax:
.im 1
                <opcode>        {<prefix>}<exp>
.sp
Example:
.sp
.im 6
        AA      EQU     $10
        BB      EQU     $1234
                LDAA    >AA     ;">" was required to produce
                                ;extended mode addressing
                STA     BB      ;Extended addressing
                ROR     AA      ;Always generates extended mode
.sp 2
.tc
EXTENDED INDIRECT MODE
.ix Addressing, Extended Indirect 6800
.ix Extended Indirect Mode, 6800
.ix [ ], 6800
.sp
Extended Indirect Mode addresses memory using a 16-bit address embedded in
the instruction to retrieve the effective 16-bit address.  This mode is
indicated by "[" "]" surrounding the operand field.
.sp
Syntax:
.sp
.im 1
                <opcode>        [<exp>]
.sp
Whenever
.ix Indirect Mode
indirect mode is encountered, ASM6800 substitutes the following:
.sp
.im 2
                LDX             <exp>
                <opcode>        0,X
.sp
Note that use of indirect addressing destroys the contents of the X
register.  This is an extension of M6800 assembly code and is
supported for
.ix 680C
M680C.
.sp
Example:
.sp
.im 5
                LDD     [PNTR]  ;Load $1234 from loc QQ
                ...
        PNTR    FDB     QQ
                ...
        QQ      $1234
.pa
.tc
INDEXED MODE
.ix Indexed Mode, 6800
.ix Addressing, Indexed 6800
.sp
Indexed mode addressing forms an effective address equal to the sum of
an offset value and the contents of an index register.
.sp
There are several types of indexing that may be specified to ASM:
.sp
.in 5
Zero offset
.br
8-bit offset
.br
Pre-decrement
.br
Post-increment
.sp
.in 0
All the above permit indirect addressing,
specified by enclosing the operand field in "[" "]"s.
.sp
Indexed Mode always involves one of the following index register notations:
.nj
.pw 120
.ll 100
.sp
.im 2
                ,X      Index register X
                ,S      System stack pointer
.ll 65
.pw 85
.ju
.sp
General syntax:
.br
.pw 120
.ll 100
.nj
.im 1
        <opcode>        {[}{{--}{<expr>},<indexreg>{++}{]}
.ll 65
.pw 85
.ju
.sp
Whenever indirect mode is encountered, ASM6800 substitutes the following:
.sp
.im 2
                LDX             <expr>
                <opcode>        0,X
.sp
Note that use of indirect addressing destroys the contents of the X
register.  If the index register specified is S, then a TSX instruction
is inserted, and the instruction treated as though ,X had been written
instead.
.sp 2
.tc
ZERO OFFSET INDEXED MODE
.ix Zero Offset, 6800
.ix Addressing, Zero Offset 6800
.sp
This mode is also known as a register indirect addressing.  The effective
address is equal to the contents of the specified index register.
This form generates a zero offset byte for a conventional 8 bit constant
offset indexed  mode.
.sp
Index Registers:  X, S
.sp
Syntax:
.sp
.pw 120
.ll 100
.nj
.im 2
                <opcode>        ,<reg>    ;(register indirect)
                <opcode>        [,<reg>]  ;(indirect register indirect)
.ll 65
.pw 85
.ju
.sp
Examples:
.sp
.im 2
                LDA     ,X      ;EA = (X)
                LDB     [,S]    ;EA = ((S+1))
.sp
.pa
.tc
8-BIT CONSTANT OFFSET INDEXED MODE
.ix 8-Bit Offset, 6800
.ix Addressing, 8-Bit Offset 6800
.sp
Constant offset indexing forms an effective address equal to a constant
plus the contents of an index register.  The constant is embedded in the
instruction.  The constant must be in the range 0 to 255.
.sp
Index Registers: X, S
.sp
Syntax:
.sp
.im 2
                <opcode>        <expr>,<reg>    ;constant offset
                <opcode>        [<expr>,<reg>]  ;indirect constant offset
.sp
Examples:
.sp
.im 3
                SUBA    5,X             ;EA = (X)+5
                DEC     [61,S]          ;EA = ((S)+1+61)
                ADDD    [CAT,X]         ;EA = ((X)+CAT)
.pa
.tc
AUTO INCREMENT/DECREMENT INDEXED MODE
.ix Auto-Increment, 6800
.ix Auto-Decrement, 6800
.ix Addressing, Auto-Increment, 6800
.ix Addressing, Auto-Decrement, 6800
.sp
Index registers on the M6809 may be automatically stepped by +1, +2, -1
and -2 bytes.  ASM6800 simulates this for
.ix 680C
M680C.  Increments are done AFTER the memory reference and hence
annotated FOLLOWING the index register (i.e., X++); the effective address
is the original contents of the index register.  Decrements are done
PRIOR to the memory reference and hence annotated PRECEEDING the index 
register (i.e., --Y); the effective address is the contents of the index
register after it is decremented.  Indirection is permitted, but only with the
double stepped forms (++, --).
.sp
Index Registers: X, S
.sp
Syntax:
.sp
.im 6
                <opcode>        ,<reg>+
                <opcode>        ,<reg>++
                <opcode>        ,-<reg>
                <opcode>        ,--<reg>
                <opcode>        [,<reg>++]
                <opcode>        [,--<reg>]
.sp
ASM6800 substitutes for each of the above:
.sp
.im 13
                <opcode>        ,<reg>  ; <reg>+
                IN<reg>

                <opcode>        ,<reg>  ; <reg>++
                IN<reg>

                IN<reg>
                DE<reg>
                <opcode>        ,<reg> ;-<reg>

                DE<reg>                ;--<reg>
                DE<reg>
                <opcode>        ,<reg>
.sp
Indirect mode is treated as described previously.
.sp
Examples:
.sp
.im 5
                LDA     ,X+     ;EA=(X) \ X=X+1
                STA     ,-S     ;Y=Y-1 \ EA=(Y)
                LDD     ,X++    ;EA=(X) \ X=X+2
                STX     ,-Y     ;Y=Y-2 \ EA=(Y)
                LDX     [,S++]  ;EA=((Y)+2) \ Y=Y+2
.pa
.tc
RELATIVE MODE
.ix Relative Mode, 6800
.ix Addressing, Relative 6800
.sp
The
.ix Branch
branch (Bxx and LBxx) class of instructions use this mode.  There are two
offset sizes used in relative mode, 8 and 16 bits.  The 8 bit
form is invoked with instruction mnemonics of the form "Bxx" and the 16
bit with "LBxx".  The effective address is equal to the address
of the next instruction plus the value of the (sign-extended) constant
offset embedded in the instruction.
The "LBxx" form generates 2 M6800 instructions: a conditional branch on
the opposite condition around a JMP extended to the destination.
.sp
Syntax:
.sp
.im 2
        Bxx     <expr>
        LBxx    <expr>
.sp
Examples:
.sp
.im 2
                BRA     BLIMP
                LBCC    ZEPPELIN
.sp
.in 10
.un 10
NOTE:~~~~~If the 8-bit form ("Bxx") is requested and the <expr> expression
is evaluable on Pass 1 to a destination that is out of range, ASM will
substitute the 16-bit ("LBxx") form.
.in 0
.sp 2
.tc
IMMEDIATE MODE
.ix Immediate Mode, 6800
.ix Addressing, Immediate 6800
.sp
Many 6800 instructions use a constant embedded in the instruction
rather than an operand in a memory location separate from the
instruction.  This is designated "immediate" mode.  The size of
an immediate operand is determined by the instruction, not the 
operand; some instructions use 16 bit immediate operands while
others use 8 bit immediate operands.  The
.ix Notation
notation "#<expr>" is used
to specify an immediate operand; if only 8 bits are required by the
instruction, the expression value must be in the range -128 to 255 or
an error will result.
.sp
Syntax:
.im 1
                <opcode>        #<expr>
.sp
Examples:
.sp
.im 6
                ADDA    #1              ; adds 1 to A register
                SUBD    #$4071
                LDS     #BUFFER+2

                SUBB    #BUFFER\256     ; same general effect as
                SBCA    #BUFFER/256     ; SUBD #BUFFER
.pa
.tc
OPCODE MNEMONICS RECOGNIZED BY ASM6800
.ix Opcode Mnemonics, 6800
.sp
This table lists all the opcode mnemonics recognized by ASM6800. The operand
modes accepted by ASM for each of the opcodes are marked in the table. 
Additionally, there are
.ix Notation
notations, comments and opcode mnemonic classifications.  The notations will
show expansions if the mnemonic causes alternative code or multiple machine
instructions to be generated.  The opcode classes are as follows:
.sp
.in 9
.un 9
6800~~~-~6800 standard mnemonic.
.sp
.un 9
6801~~~-~6801 standard mnemonic.  6800 instructions are substituted if
WITH M6801 is not specified at assembly time.
.sp
.un 9
6809~~~-~6809 only mnemonic.  Generates equivalent 6801 instructions.
.sp
.ix 680C
.un 9
680C~~~-~680C mnemonic; supported in the 680C instruction set.  One or more
6801 instructions may be substituted.  Memory
reference instructions are limited to a restricted subset of the 6809 indexed
addressing forms.  See Appendix D for more detail.
.sp
.in 0
*OPERAND MODE KEY:
.sp
.pw 120
.ll 100
.nj
.IM 2
IDX=INDEXED     EXT=EXTENDED     DIR=DIRECT     IMM=IMMEDIATE
INH=INHERENT    BRA=BRANCH       PSH=PUSH/PULL  R/R=REG/REG
.LL 65
.PW 85
.pa
.PW 120
.LL 100
.im 49
                               OPCODE
OPCODE     OPERAND MODE*       CLASS         NOTES AND COMMENTS

           I E D I I B P R
           D X I M N R S /
           X T R M H A H R

ABA        . . . . X . . .      6800         
ABX        . . . . X . . .      6801         See Footnote #1
ADCA       X X X X . . . .      6800   
ADCB       X X X X . . . .      6800   
ADCD       X X X X . . . .      680C         ADCB arg+1 \ ADCA arg
ADDA       X X X X . . . .      6800   
ADDB       X X X X . . . .      6800   
ADDD       X X X X . . . .      6801         ADDB arg+1 \ ADCA arg
ANDA       X X X X . . . .      6800   
ANDB       X X X X . . . .      6800   
ANDD       X X X X . . . .      6800         ANDB arg+1 \ ANDA arg
ASL        X X . . . . . .      6800   
ASLA       . . . . X . . .      6800   
ASLB       . . . . X . . .      6800   
ASLD       . . . . X . . .      6801         ASLB \ ASLA
ASR        X X . . . . . .      6800   
ASRA       . . . . X . . .      6800   
ASRB       . . . . X . . .      6800   
ASRD       . . . . X . . .      680C         ASRA \ RORB
BCC        . . . . . X . .      6800   
BCS        . . . . . X . .      6800   
BEQ        . . . . . X . .      6800   
BEQD       . . . . . X . .      680C         BNE xxx \ TSTA \ xxx BEQ arg
BGE        . . . . . X . .      6800   
BGT        . . . . . X . .      6800
BHI        . . . . . X . .      6800   
BHS        . . . . . X . .      6800   
BITA       X X X X . . . .      6800   
BITB       X X X X . . . .      6800   
BLE        . . . . . X . .      6800   
BLO        . . . . . X . .      6800   
BLS        . . . . . X . .      6800   
BLT        . . . . . X . .      6800   
BMI        . . . . . X . .      6800   
BNE        . . . . . X . .      6800   
BNED       . . . . . X . .      680C         BEQ xxx \ TSTA \ xxx BNE arg
BPL        . . . . . X . .      6800   
BRA        . . . . . X . .      6800   
BRN        . . . . . X . .      6801         NOP \ NOP
BSR        . . . . . X . .      6800   
BVC        . . . . . X . .      6800   
BVS        . . . . . X . .      6800   
.ll 65
.pw 85
.pa
.pw 120
.ll 100
.im 40
                              OPCODE
OPCODE     OPERAND MODE*      CLASS          NOTES AND COMMENTS

           I E D I I B P R
           D X I M N R S /
           X T R M H A H R

CBA        . . . . X . . .      6800
CLC        . . . . X . . .      6800
CLI        . . . . X . . .      6800
CLR        X X . . . . . .      6800   
CLRA       . . . . X . . .      6800   
CLRB       . . . . X . . .      6800   
CLV        . . . . X . . .      6800
CMPA       X X X X . . . .      6800   
CMPB       X X X X . . . .      6800
CMPD       X X X X . . . .      680C         See Footnote 2
CMPX       X X X X . . . .      6809         CPX
COM        X X . . . . . .      6800   
COMA       . . . . X . . .      6800   
COMB       . . . . X . . .      6800   
COMD       . . . . X . . .      680C         COMB \ COMA
CPX        X X X X . . . .      6800
DAA        . . . . X . . .      6800   
DEC        X X . . . . . .      6800   
DECA       . . . . X . . .      6800   
DECB       . . . . X . . .      6800   
DECD       X X X . . . . .      680C         See Footnote 3
DES        . . . . X . . .      6800
DEX        . . . . X . . .      6800
EORA       X X X X . . . .      6800   
EORB       X X X X . . . .      6800   
EORD       X X X X . . . .      680C         EORB arg+1 \ EORA arg
ERRORRTS   . . . . X . . .      680C         SEC \ RTS
INC        X X . . . . . .      6800   
INCA       . . . . X . . .      6800   
INCB       . . . . X . . .      6800   
INCD       X X X . . . . .      680C         See Footnote 4
INS        . . . . X . . .      6800
INX        . . . . X . . .      6800
.ll 65
.pw 85
.pa
.pw 120
.ll 100
.im 42
                              OPCODE
OPCODE     OPERAND MODE*      CLASS          NOTES AND COMMENTS

           I E D I I B P R
           D X I M N R S /
           X T R M H A H R

JMP        X X . . . . . .      6800
JSR        X X X . . . . .      6800
LBCC       . . . . . X . .      680C         BCS xxx \ JMP arg \ xxx ...
LBCS       . . . . . X . .      680C         BCC xxx \ JMP arg \ xxx ...
LBEQ       . . . . . X . .      680C         BNE xxx \ JMP arg \ xxx ...
LBGE       . . . . . X . .      680C         BLT xxx \ JMP arg \ xxx ...
LBGT       . . . . . X . .      680C         BLG xxx \ JMP arg \ xxx ...
LBHI       . . . . . X . .      680C         BLS xxx \ JMP arg \ xxx ...
LBHS       . . . . . X . .      680C         BLO xxx \ JMP arg \ xxx ...
LBLE       . . . . . X . .      680C         BGT xxx \ JMP arg \ xxx ...
LBLO       . . . . . X . .      680C         BHS xxx \ JMP arg \ xxx ...
LBLS       . . . . . X . .      680C         BHI xxx \ JMP arg \ xxx ...
LBLT       . . . . . X . .      680C         BGE xxx \ JMP arg \ xxx ...
LBMI       . . . . . X . .      680C         BPL xxx \ JMP arg \ xxx ...
LBNE       . . . . . X . .      680C         BEQ xxx \ JMP arg \ xxx ...
LBRA       . . . . . X . .      680C         JMP xxx
LBVC       . . . . . X . .      680C         BVS xxx \ JMP arg \ xxx ...
LBVS       . . . . . X . .      680C         BVS xxx \ JMP arg \ xxx ...
LDA        X X X X . . . .      6800         LDAA arg
LDAA       X X X X . . . .      6800
LDAB       X X X X . . . .      6800
LDB        X X X X . . . .      6800         LDAB arg
LDD        X X X X . . . .      6801         LDAB arg+1 \ LDAA arg
LDS        X X X X . . . .      6800   
LDX        X X X X . . . .      6800   
LEAS       X . . . . . . .      680C         RPT arg \ INS
LEAX       X . . . . . . .      6800         RPT arg \ INX
LSL        X X . . . . . .      6800         ASL arg
LSLA       . . . . X . . .      6800         ASLA
LSLB       . . . . X . . .      6800         ASLB
LSLD       . . . . X . . .      680C         ASLB \ ROLA
LSR        X X . . . . . .      6800   
LSRA       . . . . X . . .      6800   
LSRB       . . . . X . . .      6800   
LSRD       . . . . X . . .      680C         LSRA \ RORB
.ll 65
.pw 85
.PA
.pw 120
.ll 100
.im 42
                              OPCODE
OPCODE     OPERAND MODE*      CLASS          NOTES AND COMMENTS

           I E D I I B P R
           D X I M N R S /
           X T R M H A H R

MUL        . . . . X . . .      6801         JSR MUL6809
NEG        X X . . . . . .      6800   
NEGA       . . . . X . . .      6800   
NEGB       . . . . X . . .      6800   
NEGD       . . . . X . . .      680C         NEGA \ NEGB \ SBCA #0
NOP        . . . . X . . .      6800   
OKRTS      . . . . X . . .      680C         CLC \ RTS
ORA        X X X X . . . .      6800         ORA
ORAA       X X X X . . . .      6800
ORAB       X X X X . . . .      6800
ORB        X X X X . . . .      6800         ORB
ORD        X X X X . . . .      680C         ORB arg+1 \ ORA arg
PSHA       . . . . X . X .      6800
PSHB       . . . . X . X .      6800
PSHD       . . . . X . X .      680C         PSHB \ PSHA
PSHX       . . . . X . X .      6801         See Footnote 5
PULA       . . . . X . X .      6800
PULB       . . . . X . X .      6800
PULD       . . . . X . X .      680C         PULA \ PULB
PULX       . . . . X . X .      6801         TSX \ LDX 0,X \ INS \ INS
ROL        X X . . . . . .      6800   
ROLA       . . . . X . . .      6800   
ROLB       . . . . X . . .      6800   
ROLD       . . . . X . . .      680C         ROLB \ ROLA
ROR        X X . . . . . .      6800   
RORA       . . . . X . . .      6800   
RORB       . . . . X . . .      6800   
RORD       . . . . X . . .      680C         RORA \ RORB
RTI        . . . . X . . .      6800   
RTS        . . . . X . . .      6800   
SBA        . . . . X . . .      6800
SBCA       X X X X . . . .      6800   
SBCB       X X X X . . . .      6800   
SBCD       X X X X . . . .      680C         SBCB arg+1 \ SBCA arg
SEC        . . . . X . . .      6800
.ll 65
.pw 85
.PA
.pw 120
.ll 100
.im 38
                              OPCODE
OPCODE     OPERAND MODE*       CLASS          NOTES AND COMMENTS

           I E D I I B P R
           D X I M N R S /
           X T R M H A H R

SEI        . . . . X . . .      6800
SEV        . . . . X . . .      6800
STA        X X X . . . . .      6800         STAA arg
STAA       X X X . . . . .      6800
STAB       X X X . . . . .      6800
STB        X X X . . . . .      6800         STAB arg
STD        X X X . . . . .      6801         STAB arg+1 \ STAA arg
STS        X X X . . . . .      6800   
STX        X X X . . . . .      6800   
SUBA       X X X X . . . .      6800   
SUBB       X X X X . . . .      6800   
SUBD       X X X X . . . .      6801         SUBB arg+1 \ SBCA arg
SWI        . . . . X . . .      6800   
TAB        . . . . X . . .      6800
TAP        . . . . X . . .      6800
TBA        . . . . X . . .      6800
TDS        . . . . X . . .      680C         STD TEMPX \ LDS TEMPX
TDX        . . . . X . . .      680C         TFR D,X
TFR        . . . . . . . X      680C         TAB or TBA
TPA        . . . . X . . .      6800
TSD        . . . . X . . .      680C         TSX \ TXD
TST        X X . . . . . .      6800   
TSTA       . . . . X . . .      6800   
TSTB       . . . . X . . .      6800   
TSTD       . . . . X . . .      680C         SUBD #$0000
TSX        . . . . X . . .      6800
TXD        . . . . X . . .      680C         STX TEMPX \ LDD TEMPX
TXS        . . . . X . . .      6800
WAI        . . . . X . . .      6800
.ll 65
.pw 85
.ju
.sp
.in 13
.un 13
.nj
.nf
.un 13
Footnote~1:~~STAB TEMPX+1\ADDB TEMPX+1\STAB TEMPX+1\
LDAB TEMPX \ ADCB #0\STAB TEMPX\LDX TEMPX
.sp
.un 13
Footnote~2:~~CMPB arg+1 \ BNE xxx \ CMPA arg \ xxx ...
.sp
.un 13
Footnote~3:~~TST arg+1 \ BNE xxx \ DEC arg \ xxx DEC arg+1
.sp
.un 13
Footnote~4:~~INC arg+1 \ BNE xxx \ INC arg \ xxx ...
.sp
.un 13
Footnote~5:~~STX TEMPX \ LDAB TEMP+1 \ PSHB \ LDAB TEMPX \ PSHB
.in 0
.br
.FO
.JU
.LL 65
.PW 85
.pa
.ju
.sh SECTION VI: 6809 MACHINE INSTRUCTION LINES
.pa
.tc
.ce
6809 MACHINE INSTRUCTION LINES
.ix Machine Instruction Line, 6809
.sp
The major function of an assembler is the translation of symbolically
specified machine instructions into a form directly understandable by the
target computer.  This section presumes knowledge of the 6809 instruction
set, which can be found in the Motorola MC6809 Programming Manual.  ASM is
fully compatible with the Motorola 6809 standard assembler syntax, with
several useful extensions.
.sp
.in 2
.un 2
--All M6800/M6801 Opcodes are accepted and generate equivalent 6809 code.
.sp
.un 2
--Special set of opcodes to allow coding to work on 6800, 6801 and 6809. 
These opcodes are called 680C opcodes  (See Appendix D).   Many
"convenience" instructions are included in 680C, which act as logical
extensions to the '00/'09 instruction set, such as double register shifts,
16 bit memory increments, and decrements, etc.
.sp
.un 2
--Automatic long branching.  Short branches that are out-of-range will be
assembled as long branches if the destination expression contains no
forward references.
.sp
.un 2
--Special offset prefix "<<" to force 5 bit offset form.
.sp
.un 2
--Multiple labels are allowed, separated by commas.  All labels present on
an opcode line will be equated to the location counter, "*", before the rest
of the line is processed.
.sp
.un 2
--A, B, D, S, X, U, CC, DP, PC, and PCR may be used as ordinary symbols as
long as they are distinguishable from their use as register designators.
.in 0
.pa
ASM processes each machine instruction line as follows:
.ix Line Processing
.ix Instruction Mnemonics, 6809
all
.ix Labels
labels are
first equated to the
.ix Location Counter
location counter, '*'; then the opcode specified is
inspected to determine which operand addressing modes are legal.  Finally, the
operand field is scanned for an appropriate
.ix Addressing Mode
addressing mode specification.  The
.ix Opcode
opcode is combined with the specified addressing mode to generate the
object code corresponding to the desired instruction.
.sp
Many opcodes (LDA, STX, CMPD, etc.) include a
.ix Register
register specification
(A, B, D, X, Y, U, or S) as the last letter of the opcode mnemonic.
.sp
There are several operand modes for 6809 instructions.  A given instruction
will have one or more modes as legal forms (some opcodes require no
operand specification whatsoever).  The
.ix Syntax
syntax of each of these modes is discussed in the following pages.
A few examples of each mode will be given.  A table of instruction mnemonics
and their modes is given at the end of this section.
.sp
Throughout this section, the
.ix Notation
notation "<expr>" means any expression,
"EA=" means Effective Address, and "(" ")" to the right of "EA=" means
"the contents of".
.pa
.tc
INHERENT MODE
.ix Inherent Mode, 6809
.ix Addressing, Inherent 6809
.sp
Inherent Mode opcodes need no operand specifications.  The
.ix Argument Field
argument field is ignored.  For portability purposes, it should be left blank.
.sp
Syntax:
.im 1
                <opcode>
.sp
Examples:
.sp
.im 3
                RTI             ;Return from Interrupt
                MUL             ;(A-Reg)*(B-Reg)
                CLRA            ;A-Reg:=0
.sp 2
.sp 2
.tc
REGISTER-REGISTER MODE
.ix Register, 6809
.ix Addressing, Register 6809
.sp
Register-Register Mode addresses source and destination registers.  The
registers come in two sizes, 8-bit and 16-bit.  Only registers of like sizes
may be addressed together.  This mode may only be used with
.ix TFR
TFR or
.ix EXG
EXG opcodes.
.sp
.op
        ________________          _______________
        16-bit~Registers~~~~~~~~~~8-bit~Registers
.sp
.im 6
        X (X index reg)           A (A-reg)
        Y (Y index reg)           B (B-reg)
        U (User Stack Pointer)    CC (Condition Codes)
        S (System Stack Pointer)  DP (Data Page Register)
        PC (Program Counter)
        D (A+B register)
.sp
Syntax:
.im 1
                <opcode>  <reg>,<reg>
.sp
Examples:
.sp
.im 3
                TFR     X,Y
                EXG     A,B
                Tfr     X,A     ;Illegal: X&A not same size
.pa
.tc
DIRECT MODE
.ix Direct Mode, 6809
.ix Addressing, Direct 6809
.sp
Direct Mode is used to address a location in the 256 byte memory "page"
designated by the contents of the DPR
(Data Page Register).  The 8 bits of operand embedded in the instruction
form the lower 8-bits of the
16-bit memory reference address while the upper 8-bits of the address are
supplied by the DPR.  ASM must be informed what contents to assume in the
DPR.  This is done via the
.ix SETDPR
SETDPR directive (see Directives section).  If
an instruction operand address evaluates within the DPR page bounds, ASM
automatically generates  Direct Mode memory reference.
.sp
Direct references may be forced with a "<"
.ix Prefix, < 6809
prefix.  Use of this prefix
prevents any default to the
.ix Extended Mode
Extended Mode addressing.  If the effective address does not map into the
Data Page as specified by the last SETDPR directive, an error is generated.
.sp
Syntax:
.im 1
                <opcode>        {<prefix>}<exp>
.sp
Example:
.sp
.im 11
        A       EQU     $10
        B       EQU     $123
        C       EQU     $456
                SETDPR  $100    ;PAGE 1 ($100-$1FF)
                                ;Generated:
                CLR     A       ;Extended reference to loc $10
                INC     B       ;Direct reference to loc $123
                DEC     C       ;Extended reference to $456
                ROR     <A      ;Direct reference to loc $110 WITH ERROR
                ASL     <B      ;Direct reference to loc $123
                TST     <C      ;Direct reference to loc $156 WITH ERROR
.sp
Note: The programmer is responsible for insuring that the value in the DPR
during program execution matches the (SETDPR value)/$100.
.pa
EXTENDED MODE
.ix Extended Mode, 6809
.ix Addressing, Extended 6809
.tc
.sp
Extended mode addresses memory with a 16-bit address embedded in the
instruction.  Any location
in the memory space can be referenced with this mode.  Extended mode may be
forced by use of the ">"
.ix Prefix
.ix Prefix, > 6809
prefix.
.sp
Syntax:
.im 1
                <opcode>        {<prefix>}<exp>
.sp
Example:
.sp
.im 6
        AA      EQU     $10
        BB      EQU     $1234
                SETDPR  $00     ;(Default DPR setting)
                LDA     >AA     ;">" was required to produce
                                ;extended mode addressing
                STA     BB      ;Extended addressing
.sp 2
.tc
EXTENDED INDIRECT MODE
.ix Extended Indirect Mode, 6809
.ix Addressing, Extended Indirect 6809
.ix [ ], 6809
.sp
Extended Indirect Mode addresses memory using a 16-bit address
embedded in the instruction
to retrieve the effective 16-bit address.
.ix Indirect Mode
This mode is indicated by "[" "]"
surrounding the operand field.
.sp
Syntax:
.im 1
                <opcode>        [<exp>]
.sp
Example:
.sp
.im 5
                LDD     [PNTR]  ;Load $1234 from loc QQ
                ...
        PNTR    FDB     QQ
                ...
        QQ      $1234
.pa
.tc
INDEXED MODE
.ix Indexed Mode, 6809
.ix Addressing, Indexed 6809
.sp
Indexed mode addressing forms an effective address equal to the sum of
an offset value and the contents of an index register.
.sp
There are many types of indexing that may be specified to ASM:
.sp
.in 5
Zero offset
.br
5-bit offset
.br
8-bit offset
.br
16-bit offset
.br
A-Reg offset
.br
B-Reg offset
.br
D-Reg offset
.br
Pre-decrement
.br
Post-increment
.sp
.in 0
All the above except 5-bit offset permit indirect addressing,
specified by enclosing the operand field in "[" "]"s.
.sp
Indexed Mode always involves one of the following index register notations:
.nj
.pw 120
.ll 100
.sp
.im 8
                ,X      Index register X
                ,Y      Index register Y
                ,S      System stack pointer
                ,U      User stack pointer
                ,PC     Program Counter
                ,PCR    Special form of ,PC for easy relative
                        addressing (See section on PC relative
                        addressing that follows)
.ll 65
.pw 85
.ju
General syntax:
.br
.pw 120
.ll 100
.nj
.im 1
        <opcode>        {<prefix>}{[}{{--}{<expr>},<indexreg>{++}{]}
.ll 65
.pw 85
.ju
.sp 2
ZERO OFFSET INDEXED MODE
.ix Zero Offset, 6809
.ix Addressing, Zero Offset 6809
.tc
.sp
This mode is also known as a register indirect addressing.  The effective
address is equal to the contents of the specified index register.
Zero Offset
Indexed Mode is the shortest and fastest M6809 form for addressing via a
register.
.sp
Index Registers:  X, Y, U, S
.sp
Syntax:
.sp
.pw 120
.ll 100
.nj
.im 2
                <opcode>        ,<reg>    ;(register indirect)
                <opcode>        [,<reg>]  ;(indirect register indirect)
.ll 65
.pw 85
.ju
.sp
Examples:
.sp
.im 2
                LDA     ,X      ;EA = (X)
                LDB     [,Y]    ;EA = ((Y))
.sp
.pa
.tc
5-BIT, 8-BIT AND 16-BIT CONSTANT OFFSET INDEXED MODES
.ix 5-Bit Offset, 6809
.ix 8-Bit Offset, 6809
.ix 16-Bit Offset, 6809
.ix Addressing, Indexed 6809
.sp
Constant offset indexing forms an effective address equal to a constant
plus the contents of an index register.  The constant is embedded in the
instruction.  The constant may be positive or negative.
.sp
There are several sizes of constant offsets available on the M6809.
Notationally their invocations are identical.  ASM attempts to assemble
the shortest form.  The limitations of the two-pass assembly technique
force ASM to assume worst-case, 16-bit offset, for those offset expressions
containing forward references.  Prefix notations are provided to allow the
programmer to force the offset size (5, 8 or 16 bits), even in the presence
of a forward reference.
.sp
Index Registers: X, Y, U, S, PC
.sp
Syntax:
.sp
.im 3
                <opcode>        <prefix><expr>,<reg>    ;constant offset
                <opcode>        [<prefix><expr>,<reg>]
                                ;indirect constant offset (Illegal for PC)
.sp
Examples:
.sp
.im 7
                SUBA    5,X             ;EA = (X)+5
                DEC     [-61,Y]         ;EA = ((Y)-61)
                STY     27083,U         ;EA = (U)+27083
                LEAX    DOG,S           ;EA = (S)+DOG
                ADDD    [CAT,Y]         ;EA = ((Y)+CAT)
                LDD     FRED-*',PC      ;EA = FRED = PC+offset to FRED
                STD     [JOE-*;PC]      ;EA = (JOE) = (PC+offset to JOE)
.sp
Special operand prefix notations:
.sp
.im 3
                <<      force 5-bit offset (illegal with indirection)
                <       force 8-bit offset
                >       force 16-bit offset
.sp
Examples:
.sp
.im 3
                ORB     <<BUGOUT,U      ;Assumes BUGOUT fits in 5 bits
                SUBB    >[FAROUT,X]     ;Forces offset to 16 bits
                LDA     <WAYOUT,Y       ;Assumes WAYOUT fits in 8 bits
.pa
Notes:
.sp
.in 10
.un 5
1.~~~PC indexing does not have a 5-bit offset form.  This means
<<...,PC and <<...,PCR are illegal.
.sp
.un 5
2.~~~There is no 5-bit offset indirect form.  This means <<[...] is
illegal.
.sp
.un 5
3.~~~If the offset expression has no forward references and
evaluates to zero during Pass 1, then
the zero offset form will be substituted.  The zero offset form saves one
machine cycle over the 5-bit offset form.
.sp
Example:
.SP
.im 4
        BACKWARD        EQU     0
                LDA     BACKWARD,X      ;Generates "LDA ,X"
                STA     FORWARD,Y       ;Generates "STA >0,Y"
        FORWARD EQU     0
.sp
.br
Notice that the FORWARD reference generated a 16-bit offset.  This is
because in ASM Pass 1, the value of FORWARD was not known and the worst case
was assumed.
.in 0
.sp 2
.tc
PROGRAM COUNTER RELATIVE (INDEXED) MODE
.ix Addressing, PCR 6809
.ix Program Counter Relative, 6809
.sp
This is a special form of constant offset indexing from the program
counter.  It is an alternate to the form "...,PC".  The section
"IMPLICIT VALUES" describes the
.ix *'
*' value as being the location of the
NEXT instruction.  This is the implicit value of the PC during the execution
of any instruction.  If only the ",PC" form were available, PC relative
addressing would usually be "<destination>-*',PC".  Program Counter
Relative notation produces
the same result from "<destination>,PCR".  Indirection is permitted in this
mode.  The prefixes "<" and ">" are
.ix Prefix
.ix Prefix, > 6809
.ix Prefix, < 6809
valid.
.sp
Syntax:
.sp
.im 2
                <opcode>        <expr>,PCR
                <opcode>        [<expr>,PCR]
.sp
Examples:
.nj
.pw 120
.ll 100
.sp
.im 4
                ORA     MASK,PCR        ;EA=MASK
                ADDD    VALX,PCR        ;EA=VALX
                JMP     <THERE,PCR      ;Force 8-bit offset
                JSR     >[BEEP,PCR]     ;Force 16-bits and indirection
.ju
.ll 65
.pw 85
.in 0
.pa
.tc
ACCUMULATOR OFFSET INDEXED MODE
.ix Accumulator Offset, 6809
.ix Addressing, Accumulator 6809
.sp
Offsets on the M6809 may be specified to be the contents of an accumulator.
The effective address is formed by 2's complement addition of the
accumulator contents, sign extended to 16 bits,
and the index register contents.  Indirection may be applied to this
indexing mode.
.sp
Index Registers:  X, Y, U, S
.sp
Offset Accumulators:  A, B, D
.sp
Syntax:
.sp
.im 2
                <opcode>        <acc>,<reg>
                <opcode>        [<acc>,<reg>]
.sp
Examples:
.sp
.im 3
                LDA     B,X     ;EA = (B)+(X)
                CLR     [A,Y]   ;EA = ((A)+(Y))
                LDD     D,U     ;EA = (D)+(U)
.sp 2
.tc
AUTO INCREMENT/DECREMENT INDEXED MODE
.ix Auto-Increment, 6809
.ix Auto-Decrement, 6809
.ix Addressing, Auto-Increment 6809
.ix Addressing, Auto-Decrement 6809
.sp
Index registers on the M6809 may be automatically stepped by +1, +2, -1
and -2 bytes.  Increments are done AFTER the memory reference and hence
annotated FOLLOWING the index register (i.e., X++); the effective address
is the original contents of the index register.  Decrements are done
PRIOR to the memory reference and hence annotated PRECEEDING the index 
register (i.e., --Y); the effective address is the contents of the index
register after it is decremented.  Indirection is permitted, but only with the
double stepped forms (++, --).
.sp
Syntax:
.sp
.im 6
                <opcode>        ,<reg>+
                <opcode>        ,<reg>++
                <opcode>        ,-<reg>
                <opcode>        ,--<reg>
                <opcode>        [,<reg>++]
                <opcode>        [,--<reg>]
.sp
Examples:
.sp
.im 5
                LDA     ,X+     ;EA=(X) \ X=X+1
                STA     ,-Y     ;Y=Y-1 \ EA=(Y)
                LDD     ,X++    ;EA=(X) \ X=X+2
                STX     ,-Y     ;Y=Y-2 \ EA=(Y)
                LDX     [,Y++]  ;EA=((Y)+2) \ Y=Y+2
.pa
.tc
RELATIVE MODE
.ix Relative Mode, 6809
.ix Addressing, Relative 6809
.sp
The
.ix Branch
branch (Bxx and LBxx) class of instructions use this mode.  There are two
offset sizes used in relative mode, 8 and 16 bits.  The 8 bit
form is invoked with instruction mnemonics of the form "Bxx" and the 16
bit with "LBxx".  The effective address is equal to the address
of the next instruction plus the value of the (sign-extended) constant
offset embedded in the instruction.
.sp
Syntax:
.sp
.im 2
        Bxx     <expr>
        LBxx    <expr>
.sp
Examples:
.sp
.im 2
                BRA     BLIMP
                LBCC    ZEPPELIN
.sp
.in 10
.un 10
NOTE:~~~~~If the 8-bit form ("Bxx") is requested and the <expr> expression
is evaluable on Pass 1 to a destination that is out of range, ASM will
substitute the 16-bit ("LBxx") form.
.in 0
.sp 2
.tc
IMMEDIATE MODE
.ix Immediate Mode, 6809
.ix Addressing, Immediate 6809
.sp
Many 6809 instructions use a constant embedded in the instruction
rather than an operand in a memory location separate from the
instruction.  This is designated "immediate" mode.  The size of
an immediate operand is determined by the instruction, not the 
operand; some instructions use 16 bit immediate operands while
others use 8 bit immediate operands.  The
.ix Notation
notation "#<expr>" is used
to specify an immediate operand; if only 8 bits are required by the
instruction, the expression value must be in the range -128 to 255 or
an error will result.
.sp
Syntax:
.im 1
                <opcode>        #<expr>
.sp
Examples:
.sp
.im 6
                ADDA    #1              ; adds 1 to A register
                CMPD    #$4071
                LDY     #BUFFER+2

                SUBB    #BUFFER\256     ; same general effect
                SBCA    #BUFFER/256     ; as SUBD #BUFFER
.pa
.tc
STACK MODE
.ix Stack Addressing, 6809
.ix Stack Mode, 6809
.ix Addressing, Stack 6809
.ix Push/Pop, 6809
.sp
This mode may only be used with
.ix PSHS
.IX PSHU
.IX PULS
.IX PULU
PSHS, PSHU, PULS, and PULU instructions.
The operands in this mode are registers to be pushed or pulled from a
stack (user or system).  The operand field consists of a sequence of
register names separated by commas or a single immediate mode expression.  The
ordering of registers is arbitrary since the order of PUSH/PULL is
fixed.  Mention of a register name sets the appropriate corresponding bit
in the postbyte of the instruction.  If an immediate expression is used,
the lower 8 bits of the
expression are used as the post byte.  The immediate form has the
advantage of allowing register groups to be symbolically named.
.sp
Registers: PC, S, U, Y, X, DP, B, A, D, CC
.sp
Syntax:
.im 2
                <opcode>        <reg>,...,<reg>
                <opcode>        #<expr> 
.sp
Examples:
.sp
.pw 120
.ll 100
.im 2
                PSHU    PC,S,D,DP
                PULS    #STKFRAME       STKFRAME is some register subset
.ll 65
.pw 85
.SP
.in 10
.un 10
NOTE:~~~~~The use of the "D" register is equivalent to "A,B".
.in 0
.pa
.tc
OPCODE MNEMONICS RECOGNIZED BY ASM6809
.ix Opcode Mnemonics, 6809
.sp
This table lists all the opcode mnemonics recognized by the ASM6809. The
operand modes accepted by ASM for each of the opcodes are marked in the
table.  Additionally, there are
.ix Notation
notations, comments and opcode mnemonic classifications.  The notations will
show expansions if the mnemonic causes an alternative code or multiple
machine instructions to be generated.  The opcode classes are as follows:
.sp
.in 9
.un 9
6809~~~-~6809 (Motorola) standard mnemonic.  Generates a conventional
6809 instruction.
.sp
.un 9
6800~~~-~6800 standard mnemonic which has an exact 6809 counterpart.
The 6809 counterpart is generated.
.sp
.un 9
6800EQ~-~6800 equivalent mnemonic; there is no exact 6809 counterpart.
Notes and comments will show the 6809 instruction sequence substituted.
The sequence is as close to functionally equivalent
to the 6800 mnemonic as possible.
.sp
.ix 680C
.un 9
680C~~~-~680C mnemonic; supported in the 680C instruction set.  One or more
6809 instructions may be substituted.  Memory
reference instructions are limited to a restricted subset of the 6809 indexed
addressing forms.  See Appendix D for more detail.
.sp
.in 0
*OPERAND MODE KEY:
.sp
.pw 120
.ll 100
.nj
.IM 2
IDX=INDEXED     EXT=EXTENDED     DIR=DIRECT     IMM=IMMEDIATE
INH=INHERENT    BRA=BRANCH       PSH=PUSH/PULL  R/R=REG/REG
.ll 65
.pw 85
.pa
.pw 120
.ll 100
.im 50
                               OPCODE
OPCODE     OPERAND MODE*       CLASS         NOTES AND COMMENTS

           I E D I I B P R
           D X I M N R S /
           X T R M H A H R

ABA        . . . . X . . .    6800EQ/680C    PSHS B\ ADDA ,S+
ABX        . . . . X . . .    6809/680C
ADCA       X X X X . . . .    6809/6800
ADCB       X X X X . . . .    6809/6800
ADCD       X X X X . . . .      680C         ADCB arg+1 \ADCA arg
ADDA       X X X X . . . .    6809/6800
ADDB       X X X X . . . .    6809/6800
ADDD       X X X X . . . .    6809/680C
ANDA       X X X X . . . .    6809/6800
ANDB       X X X X . . . .    6809/6800
ANDC       . . . X . . . .      6809         Alternative for ANDCC
ANDCC      . . . X . . . .      6809
ANDD       X X X X . . . .      680C         ANDB arg+1 \ANDA arg
ASL        X X X . . . . .    6809/6800
ASLA       . . . . X . . .    6809/6800
ASLB       . . . . X . . .    6809/6800
ASLD       . . . . X . . .      680C         ASLB \ ASLA
ASR        . . . . X . . .    6809/6800
ASRA       . . . . X . . .    6809/6800
ASRB       . . . . X . . .    6809/6800
ASRD       . . . . X . . .      680C         ASRA \ RORB
BCC        . . . . . X . .    6809/6800
BCS        . . . . . X . .    6809/6800
BEQ        . . . . . X . .    6809/6800
BEQD       . . . . . X . .      680C
BGE        . . . . . X . .    6809/6800
BHI        . . . . . X . .    6809/6800
BHS        . . . . . X . .    6809/6800
BITA       X X X X . . . .    6809/6800
BITB       X X X X . . . .    6809/6800
BLE        . . . . . X . .    6809/6800
BLO        . . . . . X . .    6809/6800
BLS        . . . . . X . .    6809/6800
BLT        . . . . . X . .    6809/6800
BMI        . . . . . X . .    6809/6800
BNE        . . . . . X . .    6809/6800
BNED       . . . . . X . .      680C
BPL        . . . . . X . .    6809/6800
BRA        . . . . . X . .    6809/6800
BRN        . . . . . X . .      6809
BSR        . . . . . X . .    6809/6800
BVC        . . . . . X . .    6809/6800
BVS        . . . . . X . .    6809/6800
.ll 65
.pw 85
.pa
.pw 120
.ll 100
.im 45
                              OPCODE
OPCODE     OPERAND MODE*      CLASS          NOTES AND COMMENTS

           I E D I I B P R
           D X I M N R S /
           X T R M H A H R

CBA        . . . . X . . .    6800EQ/680C    PSHS B\CMPA ,S+
CLC        . . . . X . . .      6800EQ       ANDCC #$FE
CLI        . . . . X . . .      6800EQ       ANDCC #$EF
CLR        X X X . . . . .    6809/6800
CLRA       . . . . X . . .    6809/6800
CLRB       . . . . X . . .    6809/6800
CLV        . . . . X . . .      6800EQ       ANDCC #$FD
CMPA       X X X X . . . .    6809/6800
CMPB       X X X X . . . .    6809/6800
CMPD       X X X X . . . .    6809/680C
CMPS       X X X X . . . .      6809
CMPU       X X X X . . . .      6809
CMPX       X X X X . . . .    6809/6800
CMPY       X X X X . . . .      6809
COM        X X X . . . . .    6809/6800
COMA       . . . . X . . .    6809/6800
COMB       . . . . X . . .    6809/6800
COMD       . . . . X . . .      680C         COMB \ COMA
CPX        X X X X . . . .      680EQ        CMPX
CWAI       . . . X . . . .      6809
DAA        . . . . X . . .    6809/6800
DEC        X X X . . . . .    6809/6800
DECA       . . . . X . . .    6809/6800
DECB       . . . . X . . .    6809/6800
DECD       X X X . . . . .      680C         See Footnote 1
DES        . . . . X . . .      680EQ        LEAS -1,S
DEX        . . . . X . . .      680EQ        LEAX -1,X
EORA       X X X X . . . .    6809/6800
EORB       X X X X . . . .    6809/6800
EORD       X X X X . . . .      680C         EORB arg+1 \ EORA arg
ERRORRTS   . . . . X . . .      680C         ORCC #1 \ RTS
EXG        . . . . . . . X      6809
INC        X X X . . . . .    6809/6800
INCA       . . . . X . . .    6809/6800
INCB       . . . . X . . .    6809/6800
INCD       X X X . . . . .      680C         See Footnote 2
INS        . . . . X . . .      680EQ        LEAS 1,S
INX        . . . . X . . .      680EQ        LEAX 1,X
.ll 65
.pw 85
.pa
.pw 120
.ll 100
.im 48
                              OPCODE
OPCODE     OPERAND MODE*      CLASS          NOTES AND COMMENTS

           I E D I I B P R
           D X I M N R S /
           X T R M H A H R

JMP        X X X . . . . .    6809/6800/680C
JSR        X X X . . . . .    6809/6800/680C
LBCC       . . . . . X . .    6809/680C
LBCS       . . . . . X . .    6809/680C
LBEQ       . . . . . X . .    6809/680C
LBGE       . . . . . X . .    6809/680C
LBGT       . . . . . X . .    6809/680C
LBHI       . . . . . X . .    6809/680C
LBHS       . . . . . X . .    6809/680C
LBLE       . . . . . X . .    6809/680C
LBLO       . . . . . X . .    6809/680C
LBLS       . . . . . X . .    6809/680C
LBLT       . . . . . X . .    6809/680C
LBMI       . . . . . X . .    6809/680C
LBNE       . . . . . X . .    6809/680C
LBRA       . . . . . X . .      6809
LBRN       . . . . . X . .      6809
LBSR       . . . . . X . .      6809
LBVC       . . . . . X . .    6809/680C
LBVS       . . . . . X . .    6809/680C
LDA        X X X X . . . .    6809/680C
LDAA       X X X X . . . .      6800EQ       LDA
LDAB       X X X X . . . .      6800EQ       LDB
LDB        X X X X . . . .    6809/680C
LDD        X X X X . . . .    6809/680C
LDS        X X X X . . . .    6809/680C
LDU        X X X X . . . .      6809
LDX        X X X X . . . .    6809/6800
LDY        X X X X . . . .      6809
LEAS       X . . . . . . .    6809/680C
LEAU       X . . . . . . .      6809
LEAX       X . . . . . . .    6809/680C
LEAY       X . . . . . . .      6809
LSL        X X X . . . . .    6809/6800
LSLA       . . . . X . . .    6809/6800
LSLB       . . . . X . . .    6809/6800
LSLD       . . . . X . . .      680C         ASLB \ ROLA
LSR        X X X . . . . .    6809/6800
LSRA       . . . . X . . .    6809/6800
LSRB       . . . . X . . .    6809/6800
LSRD       . . . . X . . .    6809/680C      LSRA \ RORB
.ll 65
.pw 85
.PA
.pw 120
.ll 100
.im 47
                              OPCODE
OPCODE     OPERAND MODE*      CLASS          NOTES AND COMMENTS

           I E D I I B P R
           D X I M N R S /
           X T R M H A H R

MUL        . . . . X . . .    6809/680C
NEG        X X X . . . . .    6809/6800
NEGA       . . . . X . . .    6809/6800
NEGB       . . . . X . . .    6809/6800
NEGD       . . . . X . . .      680C         NEGA \ NEGB \ SBCA #0
NOP        . . . . X . . .    6809/6800
OKRTS      . . . . X . . .      680C         ANDCC #$FE \ RTS
ORA        X X X X . . . .    6809/680C
ORAA       X X X X . . . .      6800EQ       ORA
ORAB       X X X X . . . .      6800EQ       ORB
ORB        X X X X . . . .    6809/680C
ORCC       . . . X . . . .      6809
ORD        X X X X . . . .      680C         ORB arg+1 \ ORA arg
PSHA       . . . . X . . .      6800EQ       PSHS A
PSHB       . . . . X . . .      6800EQ       PSHS B
PSHD       . . . . X . . .      680C         PSHS D
PSHS       . . . . X . X .      6809
PSHU       . . . . X . X .      6809
PSHX       . . . . X . . .      680C         PSHS X
PULA       . . . . X . . .      6800EQ       PULS A
PULB       . . . . X . . .      6800EQ       PULS B
PULD       . . . . X . . .      6800EQ       PULS D
PULS       . . . X . . X .      6809
PULU       . . . X . . X .      6809
PULX       . . . X . . . .      680C         PULS X
ROL        X X X . . . . .    6809/6800
ROLA       . . . . X . . .    6809/6800
ROLB       . . . . X . . .    6809/6800
ROLD       . . . . X . . .      680C         ROLB \ ROLA
ROR        X X X . . . . .    6809/6800
RORA       . . . . X . . .    6809/6800
RORB       . . . . X . . .    6809/6800
RORD       . . . . X . . .      680C         RORA \ RORB
RTI        . . . . X . . .    6809/6800
RTS        . . . . X . . .    6809/6800
SBA        . . . . X . . .    6800EQ/680C    PSHS B \ SUBA ,S+
SBCA       X X X X . . . .    6809/6800
SBCB       X X X X . . . .    6809/6800
SBCD       X X X X . . . .      680C         SBCB arg+1 \ SBCA arg
SEC        . . . . X . . .      6800EQ       ORCC #$01
.ll 65
.pw 85
.PA
.pw 120
.ll 100
.im 42
                              OPCODE
OPCODE     OPERAND MODE*       CLASS          NOTES AND COMMENTS

           I E D I I B P R
           D X I M N R S /
           X T R M H A H R

SEI        . . . . X . . .      6800EQ       ORCC #$10
SEV        . . . . X . . .      6800EQ       ORCC #$02
SEX        . . . . X . . .      6809
STA        X X X . . . . .    6809/680C
STAA       X X X . . . . .      6800EQ       STA
STAB       X X X . . . . .      6800EQ       STB
STB        X X X . . . . .    6809/680C
STD        X X X . . . . .    6809/680C
STS        X X X . . . . .    6809/6800
STU        X X X . . . . .      6809
STX        X X X . . . . .    6809/6800
STY        X X X . . . . .      6809
SUBA       X X X X . . . .    6809/6800
SUBB       X X X X . . . .    6809/6800
SUBD       X X X X . . . .    6809/680C
SWI        . . . . X . . .    6809/6800
SWI2       . . . . X . . .      6809
SWI3       . . . . X . . .      6809
SYNC       . . . . X . . .      6809
TAB        . . . . X . . .      6800EQ       TFR A,B \ TSTA
TAP        . . . . X . . .      6800EQ       TFR A,CC
TBA        . . . . X . . .      6800EQ       TFR B,A \ TSTA
TDS        . . . . X . . .      680C         TFR D,S
TDX        . . . . X . . .      680C         TFR D,X
TFR        . . . . . . . X      6809
TPA        . . . . X . . .      6800EQ       TFR CC,A
TSD        . . . . X . . .      680C         TFR S,D
TST        X X X . . . . .    6809/6800
TSTA       . . . . X . . .    6809/6800
TSTB       . . . . X . . .    6809/6800
TSTD       . . . . X . . .      680C         SUBD #$0000
TSX        . . . . X . . .      6800EQ       TFR S,X
TXD        . . . . X . . .      680C         TFR X,D
TXS        . . . . X . . .      6800EQ       TFR X,S
WAI        . . . . X . . .      6800EQ       CWAI #$FF
.ll 65
.pw 85
.ju
.in 13
.sp
.un 13
Footnote~1:~~TST arg+1\BNE xxx\DEC arg\xxx: DEC arg+1
.sp
.un 13
Footnote~2:~~INC arg+1\BNE xxx\INC arg\xxx:
.pa
.in 0
.sh SECTION VII: 6805 MACHINE INSTRUCTION LINES
.tc
.ce
6805 MACHINE INSTRUCTION LINES
.ix Machine Instruction Line, 6805
.sp
The major function of an assembler is the translation of symbolically
specified machine instructions into a form directly understandable by the
target computer.  This section presumes knowledge of the 6805 instruction
set, which can be found in the Motorola MC6805 Programming Manual.  ASM is
fully compatible with the Motorola 6805 standard assembler syntax, with
several useful extensions.
.sp
.in 2
.un 2
--All M6805 Opcodes are accepted and generate equivalent 6805 code.
.sp
.un 2
--Automatic branch extension.  Branches that are out-of-range will be
assembled as branch/jump macros if the destination expression contains no
forward references.  This feature may be turned off with the appropriate
WITH option.
.sp
.un 2
--Special jump macros that parallel all branch instructions available on the
6805.  These jump macros allow the full range of addressing modes available
for the JMP instruction thus giving the effect of having conditional jump
instructions.
.sp
.un 2
--Special offset prefixes "<" and ">" that will force 8-bit or 16-bit
indexing offsets respectively.
.sp
.un 2
--Special addressing prefixes "<" and ">" that will force direct or
extended addressing modes respectively.
.sp
.un 2
--Multiple labels are allowed, separated by commas.  All labels present on
an opcode line will be equated to the location counter, "*", before the rest
of the line is processed.
.in 0
.pa
ASM processes each machine instruction line as follows:
.ix Line Processing
.ix Instruction Mnemonics, 6805
all
.ix Labels
labels are
first equated to the
.ix Location Counter
location counter, '*'; then the opcode specified is
inspected to determine which operand addressing modes are legal.  Finally, the
operand field is scanned for an appropriate
.ix Addressing Mode
addressing mode specification.  The
.ix Opcode
opcode is combined with the specified addressing mode to generate the
object code corresponding to the desired instruction.
.sp
There are several operand modes for 6805 instructions.  A given instruction
will have one or more modes as legal forms (some opcodes require no
operand specification whatsoever).  The
.ix Syntax
syntax of each of these modes is discussed in the following pages.
A few examples of each mode will be given.  A table of instruction mnemonics
and their modes is given at the end of this section.
.sp
Throughout this section, the
.ix Notation
notation "<expr>" means any expression,
"EA=" means Effective Address, and "(" ")" to the right of "EA=" means
"the contents of".
.pa
.tc
INHERENT MODE
.ix Inherent Mode, 6805
.ix Addressing, Inherent 6805
.sp
Inherent Mode opcodes need no operand specifications.  The
.ix Argument Field
argument field is ignored.  For portability purposes, it should be left blank.
.sp
Syntax:
.im 1
                <opcode>
.sp
Examples:
.sp
.im 3
                RTI             ;Return from Interrupt
                TXA             ;(X-Reg) to (A-Reg)
                CLRA            ;A-Reg:=0
.sp 2
.sp 2
.tc
DIRECT MODE
.ix Direct Mode, 6805
.ix Addressing, Direct 6805
.sp
Direct Mode is used to address a location in the first 256 bytes of memory.
.sp
Direct references may be forced with a "<"
.ix Prefix, < 6805
prefix.  Use of this prefix
prevents any default to the
.ix Extended Mode
Extended Mode addressing.  If the effective address does not map into the
first 256 bytes of memory, an error is generated.
.sp
Syntax:
.im 1
                <opcode>        {<prefix>}<exp>
.sp
Example:
.sp
.im 8
        A       EQU     $10
                                ;Generated:
                CLR     B       ;Extended reference EA=$20
                INC     A       ;Direct reference EA=$10
                ROR     <C      ;Forced Direct reference with error
                ASL     <B      ;Forced Direct reference EA=$20
        B       EQU     $20     ;Forward reference address
        C       EQU     $1234   ;Forward reference address (too big)
.pa
EXTENDED MODE
.ix Extended Mode, 6805
.ix Addressing, Extended 6805
.tc
.sp
Extended mode addresses memory with a 16-bit address embedded in the
instruction.  Any location
in the memory space can be referenced with this mode.  Extended mode may be
forced by use of the ">"
.ix Prefix
.ix Prefix, > 6805
prefix.
.sp
Special Note: This addressing mode is not available for the
.ix Monadic Instructions, 6805
monadic instructions of the 6805.
.sp
Syntax:
.im 1
                <opcode>        {<prefix>}<exp>
.sp
Example:
.sp
.im 5
        AA      EQU     $10
        BB      EQU     $1234
                LDA     >AA     ;">" was required to produce
                                ;extended mode addressing
                STA     BB      ;Extended addressing
.pa
.tc
INDEXED MODE
.ix Indexed Mode, 6805
.ix Addressing, Indexed 6805
.sp
Indexed mode addressing forms an effective address equal to the sum of
an offset value and the contents of the 8-bit index register.
.sp
There are three types of indexing that may be specified:
.sp
.in 5
Zero offset
.br
8-bit offset
.br
16-bit offset
.sp
Special Note: The 16-bit indexing mode is not available for the
.ix Monadic Instructions, 6805
monadic instructions of the 6805.
.sp
.in 0
.sp
.ju
General syntax:
.br
.pw 120
.ll 100
.nj
.im 1
        <opcode>        {<prefix>}{<expr>},X
.ll 65
.pw 85
.ju
.sp 2
ZERO OFFSET INDEXED MODE
.ix Zero Offset, 6805
.ix Addressing, Zero Offset 6805
.tc
.sp
This mode is also known as a register indirect addressing.  The effective
address is equal to the contents of the 8-bit index register.
.sp
Syntax:
.sp
.pw 120
.ll 100
.nj
.im 2
                <opcode>        ,X        ;Both zero offset
                <opcode>        0,X       ; forms functionally the same.
.ll 65
.pw 85
.ju
.sp
Examples:
.sp
.im 1
                LDA     ,X      ;EA = (X)
.sp
.pa
.tc
8-BIT AND 16-BIT OFFSET INDEXING MODES
.ix 8-Bit Offset, 6805
.ix 16-Bit Offset, 6805
.ix Addressing, Indexed 6805
.sp
The 8-bit and 16-bit offset indexing form an effective address equal to a
constant plus the contents of the 8-bit index register. The constant is
embedded in the instruction.  The constant is assumed to be positive for
8-bit offsets and may be negative for 16-bit offsets.
.sp
The two sizes of offsets are notationally identical. ASM attempts to assemble
the shortest form.  The limitations of the two-pass assembly technique force
ASM to assume worst-case, 16-bit offset, for those offset expressions
containing forward references.  Prefix notations are provided to allow the
programmer to force the offset size (8 or 16 bits), even in the presence of a
forward reference or with a non-forward reference value of less than 256.
.sp
Syntax:
.sp
.im 1
                <opcode>        <prefix><expr>,X    ;constant offset
.sp
Examples:
.sp
.im 2
                SUB     5,X             ;EA = (X)+5
                STA     27083,X         ;EA = (X)+27083
.sp
Special operand prefix notations:
.sp
.im 2
                <       force 8-bit offset
                >       force 16-bit offset
.sp
Examples:
.sp
.im 2
                SUB     >FAROUT,X       ;Forces offset to 16 bits
                LDA     <WAYOUT,X       ;Assumes WAYOUT fits in 8 bits
.sp
Note:
.sp
.in 10
.un 5
~~~~~If the offset expression has no forward references and evaluates to zero
during Pass 1, then the zero offset form will be substituted.  The zero offset
form saves one machine cycle over the 8-bit offset form.
.sp
Example:
.SP
.im 4
        BACKWARD        EQU     0
                LDA     BACKWARD,X      ;Generates "LDA ,X"
                STA     FORWARD,Y       ;Generates "STA >0,Y"
        FORWARD EQU     0
.sp
.br
Notice that the FORWARD reference generated a 16-bit offset.  This is because
in ASM Pass 1, the value of FORWARD was not known and the worst case was
assumed.
.pa
.in 0
.tc
RELATIVE MODE
.ix Relative Mode, 6805
.ix Addressing, Relative 6805
.sp
The
.ix Branch
branch (Bxx) class of instructions use this mode.  The offset is an 8-bit
signed value in bytes.
The effective address is equal to the address
of the next instruction plus the value of the (sign-extended) constant
offset embedded in the instruction.
.sp
Syntax:
.sp
.im 2
        Bxx     <expr>
        BRxxx   <bit expr>,<byte expr>,<dest expr>
.sp
Examples:
.sp
.im 2
                BRA     BLIMP
                BRSET   1,PZLOC,ZEPPELIN
.sp
.in 10
.un 10
NOTE:~~~~~If either form ("Bxx" or "BRxxx") is requested and the <expr>
expression is evaluable on Pass 1 to a destination that is out of range, ASM
will substitute the equivalent jump macro ("Jxx" or "Jxxx").
.in 0
.sp 2
.tc
IMMEDIATE MODE
.ix Immediate Mode, 6805
.ix Addressing, Immediate 6805
.sp
Many 6805 instructions use a constant embedded in the instruction
rather than an operand in a memory location separate from the
instruction.  This is designated "immediate" mode.  The size of
an immediate operand is always  8 bits.  The
.ix Notation
notation "#<expr>" is used
to specify an immediate operand.  Operand expression value must fall in
the range of -128 to 255 or an error will be generated.
.sp
Syntax:
.im 1
                <opcode>        #<expr>
.sp
Examples:
.sp
.im 3
                ADD     #1              ; adds 1 to A register
                CMP     #$40
                LDA     #BUFFER+2
.sp
.pa
.in 0
.tc
BIT MODE
.ix Bit Mode, 6805
.ix Addressing, Bit 6805
.sp
The 6805 has instructions that may address any bit in the first 256 bytes of
memory.  This addressing mode take two operand values.  The first is the
bit number which must be in the range of 0-7.  The second is the byte number
which has a value range of 0-255.  The
.ix Notation
notation "<bit>,<byte>" is used to specify the bit and byte respectively.
If the value ranges for either of the operand values are exceeded, then an
error is generated.
.sp
Syntax:
.im 1
               <opcode>      <bit expr>,<byte expr>
.sp
Examples:
.sp
.im 3
               BCLR    3,21            ;Clear bit 3 in EA=21
               BRSET   HIBIT,FBYTE,GO  ;Branch to GO if HIBIT
                                       ; set in FBYTE
.pa
.tc
OPCODE MNEMONICS RECOGNIZED BY ASM6805
.ix Opcode Mnemonics, 6805
.sp
This table lists all the opcode mnemonics recognized by the ASM6805. The
operand modes accepted by ASM for each of the opcodes are marked in the
table.  Additionally, there are
.ix Notation
notations, comments and opcode mnemonic classifications.  The notations will
show expansions if the mnemonic causes an alternative code or multiple
machine instructions to be generated.  The opcode classes are as follows:
.sp
.in 9
.un 9
6805~~~-~6805 (Motorola) standard mnemonic.  Generates a conventional
6805 instruction.
.sp
.un 9
.ix Jump Macros, 6805
JMAC~~~-~Jump macro.  These jump macros are extensions to the existing
conditional branches available on the 6805.  A jump macro generates a
branch instruction for the complemented condition around a JMP instruction
with the addressing mode specified by the operand field.  A jump macro will
accept any mode of addressing the JMP instruction will accept.
.sp
Examples:
.sp
.im 11
            JCC    0,X          ;Jump Carry Clear (BCC equivalent)
      expands to:
            BCS    xxx
            JMP    0,X
       xxx:

            JCLR   1,2,3,X      ;Jump bit clear (BRCLR equivalent)
      expands to:
            BRSET  1,2,xxx      ;Branch if bit 1 in byte 2 set
            JMP    3,X
       xxx:
.sp
.in 0
*OPERAND MODE KEY:
.sp
.pw 120
.ll 100
.nj
.IM 3
IDX0=INDEXED(ZERO OFFSET)     DIR=DIRECT     BRA=BRANCH(RELATIVE)
IDX1=INDEXED(8-BIT OFFSET)    IMM=IMMEDIATE  INH=INHERENT
IDX2=INDEXED(16-BIT OFFSET)   EXT=EXTENDED   BIT=BIT
.ll 65
.pw 85
.PA
.ll 65
.pw 85
.PA
.pw 120
.ll 100
.im 51
                              OPCODE
OPCODE     OPERAND MODES*     CLASS          NOTES AND COMMENTS

           I I I E D I I B B
           D D D X I M N R I
           X X X T R M H A T
           0 1 2

ADC        X X X X X X         6805
ADCA       X X X X X X         6805       6809/6800 ADC
ADD        X X X X X X         6805
ADDA       X X X X X X         6805       6809/6800 ADD
AND        X X X X X X         6805
ANDA       X X X X X X         6805       6809/6800 AND
ASL        X X     X           6805
ASLA                   X       6805
ASLX                   X       6805
ASR        X X     X           6805
ASRA                   X       6805
ASRX                   X       6805
BCC                      X     6805
BCLR                       X   6805
BCS                      X     6805
BEQ                      X     6805
BHCC                     X     6805
BHCS                     X     6805
BHI                      X     6805
BHS                      X     6805
BIH                      X     6805
BIL                      X     6805
BIT        X X X X X X         6805
BITA       X X X X X X         6805       6809/6800 BIT
BLS                      X     6805
BLO                      X     6805
BMC                      X     6805
BMS                      X     6805
BMI                      X     6805
BNE                      X     6805
BPL                      X     6805
BRA                      X     6805
BRCLR                    X X   6805       See note 1
BRN                      X     6805
BRSET                    X X   6805       See note 1
BSET                       X   6805
BSR                      X     6805
CLC                    X       6805
CLI                    X       6805
CLR        X X     X           6805
CLRA                   X       6805
CLRX                   X       6805
CMP        X X X X X X         6805
.ll 65
.pw 85
.PA
.pw 120
.ll 100
.im 51
                              OPCODE
OPCODE     OPERAND MODES*     CLASS          NOTES AND COMMENTS

           I I I E D I I B B
           D D D X I M N R I
           X X X T R M H A T
           0 1 2

CMPX       X X X X X X         6805       6809/6800 CPX
COM        X X     X           6805
COMA                   X       6805
COMX                   X       6805
CPX        X X X X X X         6805
DAA                    X       6805
DEC        X X     X           6805
DECA                   X       6805
DECX                   X       6805
DEX                    X       6805       6800 DECX
EOR        X X X X X X         6805
INC        X X     X           6805
INCA                   X       6805
INCX                   X       6805
INX                    X       6805       6800 INCX
JCC        X X X X X           JMAC       Jump macro
JCLR       X X X X X       X   JMAC       Jump macro, see note 2
JCS        X X X X X           JMAC       Jump macro
JEQ        X X X X X           JMAC       Jump macro
JHCC       X X X X X           JMAC       Jump macro
JHCS       X X X X X           JMAC       Jump macro
JHI        X X X X X           JMAC       Jump macro
JHS        X X X X X           JMAC       Jump macro
JIH        X X X X X           JMAC       Jump macro
JIL        X X X X X           JMAC       Jump macro
JLS        X X X X X           JMAC       Jump macro
JLO        X X X X X           JMAC       Jump macro
JMC        X X X X X           JMAC       Jump macro
JMP        X X X X X           6805
JMS        X X X X X           JMAC       Jump macro
JMI        X X X X X           JMAC       Jump macro
JNE        X X X X X           JMAC       Jump macro
JPL        X X X X X           JMAC       Jump macro
JRA        X X X X X           JMAC       Jump macro
JRN        X X X X X           JMAC       Jump macro
JSET       X X X X X       X   JMAC       Jump macro, see note 2
JSR        X X X X X           6805
LDA        X X X X X X         6805
LDAA       X X X X X X         6805       6800 LDA
LDX        X X X X X X         6805
LSL        X X     X           6805
LSLA                   X       6805
LSLX                   X       6805
.ll 65
.pw 85
.PA
.pw 120
.ll 100
.im 51
                              OPCODE
OPCODE     OPERAND MODES*     CLASS          NOTES AND COMMENTS

           I I I E D I I B B
           D D D X I M N R I
           X X X T R M H A T
           0 1 2

LSR        X X     X           6805
LSRA                   X       6805
LSRX                   X       6805
NEG        X X     X           6805
NEGA                   X       6805
NEGX                   X       6805
NOP                    X       6805
ORA        X X X X X X         6805
ORAA       X X X X X X         6805       6800 ORA
ROL        X X     X           6805
ROLA                   X       6805
ROLX                   X       6805
ROR        X X     X           6805
RORA                   X       6805
RORX                   X       6805
RSP                    X       6805
RTI                    X       6805
RTS                    X       6805
SBC        X X X X X X         6805
SBCA       X X X X X X         6805       6809/6800 SBC
SEC                    X       6805
SEI                    X       6805
STA        X X X X X           6805
STAA       X X X X X X         6805       6800 STA
STOP                   X       6805
STX        X X X X X           6805
SUB        X X X X X X         6805
SUBA       X X X X X X         6805       6809/6800 SUB
SWI                    X       6805
TAX                    X       6805
TXA                    X       6805
TST        X X     X           6805
TSTA                   X       6805
TSTX                   X       6805
WAI                    X       6805       6800 WAIT
WAIT                   X       6805


Note 1: Bit test branches (BRxxx) take "<bit>,<byte>,<dest>"
        where <dest> is a legal BRA operand.

Note 2: Bit test jump macros take the "<bit>,<byte>,<dest>"
        like the BRxxx instructions but <dest> may be any
        legal JMP operand including all 3 indexing modes.

.ll 65
.pw 85
.pa
.ll 65
.pw 85
.sh SECTION VIII: DIRECTIVES
.tc
.ce
DIRECTIVES
.sp
.ju
.ix Directives
Directives are used to control the action of ASM in ways
not directly related to the generation of machine language
opcodes.  Throughout this section we will use the following
.ix Notation
notation to describe the syntax of directives.
.sp
.in 5
.ix LF
.un 5
<LF>~indicates a list of zero or more symbols separated by
commas, occuring in the
.ix Label Field
label field of the line.  The list may begin with a
.ix Comma
comma, and consecutive commas are allowed.  The exact
.ix Syntax
syntax is:
.im 1
                { <SYMBOL> }  { , { <SYMBOL> } ... }
If such a list of symbols is malformed, "Illegal Label"
will be reported.
.sp
.un 5
<EXPLIST> indicates a list of expressions separated by
.ix Comma
commas.  Consecutive commas, leading commas and trailing
commas are allowed, and are interpreted as having a zero expression where
an expression is missing.  The
exact definition of <EXPLIST> is:
.sp
.im 2
                <EXP>   { , { <EXP> } ... }
                        , { <EXP> }
.in 0
.pa
.tc
SYMBOL DEFINITION DIRECTIVES
.ix Symbol Definition Directives
.sp
Two commands are provided to allow users directly to assign a
value to a symbol.
.sp 2
.tc
EQUATE
.sp
.im 1
        {<LF>}  EQU     <EXP>
.sp
.ix EQU
EQU directs ASM permanently to associate the value given
as the argument with the symbols given in the
.ix Label Field
label field. <EXP> may involve one level of
.ix Forward Reference
forward reference; if it does,
then the symbols specified in the label field will be treated
as forward references throughout the assembly.
.sp
.in 2
.un 2
--Any attempt to redefine the value of an EQU'd symbol
will be diagnosed as an error.
.sp
.un 2
--If no symbols are present in the label field, EQU
merely evaluates the expression.  This can be useful to
display the value of a given expression in the listing.
.sp
.un 2
--If no expression is present, "Illegal Argument" is
reported.
.in 0
.sp 2
.tc
IMPLICIT EQU:
.ix EQU, Implicit
.sp
.im 1
        <LF>
.sp
.in 0
A label found in the
.ix Label Field
label field, with a null
.ix Command Field
command field, is treated as shorthand for
.sp
.im 1
        <LF>    EQU     *
.in 0
.sp
This allows a notationally pretty method of placing very long labels in
sequences of assembled machine instructions.
.pa
Examples:
.pw 120
.ll 100
.nj
.sp
.im 19
        A,B     EQU     10      ;Sets values of A and B to 10.
                EQU     A       ;Displays value of A 
        C       EQU             ;Causes "illegal argument" error
        D       EQU     E       ;One level of forward
        E       EQU     $15     ;reference is allowed.
                LDAA    E       ;This will generate a page-zero
                                ;reference, 2-bytes
                LDAA    D       ;This will generate a long
                                ;reference, 3 bytes.

        I       EQU     10      ;Note that once a symbol is EQU'd, 
        I       EQU     99      ;it may not be redefined: this an error.

        F       EQU     G       ;This is illegal...
        G       EQU     H
        H       EQU     $10
                FCB     F       ; It is diagnosed here.

        THISISAVERYLONGLABEL    ; Whose value is equated to *
.ll 65
.pw 85
.ju
.pa
.tc
SET
.sp
.im 1
        {<LF>}  SET     <EXP>
.sp
.ix SET
SET is like
.ix EQU
EQU (see above) with one difference: symbols
whose values have been defined by SET may later be
.ix Redefinition
redefined using SET.  <EXP> may NOT involve a forward reference.
.sp
SET and EQU are mutually exclusive.  If a symbol is SET in
its first definition, it may not later be EQU'd; if a symbol
is EQU'd first, it may not later be SET.  Any violation of
these rules will result in "Double Definition" being
reported.
.sp
.in 2
.un 2
--Like EQU, SET does not require that labels be present.
If no symbols are present in the
.ix Label Field
label field, SET is
equivalent to EQU.  Note that
.ix Forward Reference
forward references cannot
be displayed with SET.
.sp
.un 2
--If <EXP> involves a forward reference, "Illegal Value"
is reported, and the value zero is used instead.
.sp
.un 2
--If no argument field is present, "Illegal Argument" is
reported.
.sp
.un 2
--If an attempt to SET a symbol conflicts with another
definition somewhere else in the assembly, "Double
Definition" is reported.  The first definition of the
symbol is retained.
.in 0
.pa
Examples:
.sp
.im 26
        A       SET     10      ;Value of A is 10
                ...
                FDB     A       ;Generates $000A
                ...
        A       SET     20      ;Value of A is now 20
                ...
                FDB     A       ;Generates $0014


        B       EQU     $5
                ...
        B       SET     $10     ;The first definition applies.
                               
                                ;"Double def" is reported both
                                ;here and above.

        ;  Double-def does not prevent a symbol that was
        ;  SET first from being SET later.
        C       SET     $7      
        C       EQU     $9      ;Double def!    
                FCB     C       ;Generates $07
        C       SET     $A
                FCB     C       ;Generates $0A

        D       SET     E       ;This is illegal --
        E       EQU     $15     ;D ends up set to zero.
.pa
.tc
DATA GENERATION DIRECTIVES
.ix Data Generation Directives
.sp
Several methods of generating data are provided by ASM.
.sp 2
.tc
FORM CONSTANT BYTE
.sp
.im 1
        {<LF>}  FCB     { <EXPLIST> }
.sp
.ix FCB
FCB directs ASM to output a series of one-byte values to
be loaded into memory starting at the current value of the
.ix Location Counter
location counter.  Expressions may be of any type; however,
their values must be between -$80 and $FF.
.in 2
.sp
.un 2
--If labels are present, they are
.ix EQU
EQU'd to the location
counter before data generation begins.
.sp
.un 2
--Null expressions (i.e., contiguous
.ix Comma
commas) cause a zero value to be generated for that expression.  No
error is reported.
.sp
.un 2
--Each expression is output as soon as it has been
evaluated.  This means that
.ix *
"*" will have a different
value in each expression across the line.
.sp
.in 0
Examples:
.im 8
                FCB     10,12   ;Generates $0A followed by $0C.
        A,B     FCB             ;A and B are EQU'd to * 
                                ;one byte of $00 is output.
                FCB     -3,7,'9 ;Note that leading sign is OK.
                FCB     ,,,3    ;Generates 0,0,0,3
                FCB     $105    ;Reports overflow, generates $05

                FCB     3,      ;Generates byte of 3, then byte of 0 
.pa
.tc
RESERVE MEMORY BYTES
.sp
.im 1
       {<LF>}  RMB     <EXP>
.sp
.ix RMB
RMB directs ASM to reserve memory space without
initializing its contents.  <EXP> is interpreted as a sixteen
bit, positive integer.  It may not be a
.ix Forward Reference
forward reference.
.in 2
.sp
.un 2
--Any labels present will be
.ix EQU
EQU'd to the location
counter before the RMB is processed.
.sp
.un 2
--If <EXP> is a forward reference, "Illegal Value" is
reported, and the location counter is not moved.
.sp
.un 2
--If <EXP> is not present, "Illegal Argument" is
reported, and the location counter is not moved.
.sp
.un 2
--The location counter's old value and the
number of bytes reserved are listed.
.sp
.in 0
Examples:
.pw 120
.ll 100
.nj
.sp
.im 13
0000 0030              RMB     $30     ;Reserve $30 bytes
  0030                 EQU     *

0030 0010      A       RMB     $10     ; A label
  0040                 EQU     *       ; is EQU'd to the
  0030                 EQU     A       ; first byte of the reserved space.

0040 0000      B       RMB     0       ; Zero bytes can be reserved.
  0040                 EQU     B

0040 0000              RMB     C       ;This is illegal!!
*** Illegal Value.
  0040         C       EQU     *       ;C was a forward reference.
.ll 65
.pw 85
.ju
.pa
.tc
FORM DOUBLE BYTE CONSTANT
.sp
.im 1
       {<LF>}  FDB     { <EXPLIST> }
.sp
.ix FDB
FDB directs ASM to assemble the expressions given in the
argument field into memory as two-byte values.  The
expressions may be of any type.
.sp
.in 2
.un 2
--Each expression is output as soon as it has been
evaluated.  This means that
.ix *
"*" will have a different
value in each expression across a given line.
.sp
.un 2
--If there are labels on the line, they will be
.ix EQU
EQU'd to the location counter before the line is processed.
.sp
.un 2
--The most significant byte of each expression is
output, followed by the least significant byte.
.sp
.un 2
--Null expressions are treated as zero values as for
FCB; two bytes of zero will be output.
.sp
.un 2
--If more than 4 bytes are generated, only the first
four are listed on the line with the statement.
Additional lines are used to list all bytes after the
fourth, and will be listed only if PGEN 1 has been
specified.
.in  0
.sp
Examples:
.sp
.pw 120
.ll 100
.nj
.im 11
0000 0000      A,B     FDB     0       ;A, B are EQU'd to *
  0000                 EQU     A

0002 00020004  C       FDB     *,*     ;Note that *'s value changes

0006 0000              FDB             ;Generates 2 bytes of zero

0008 00000000          FDB     ,,,3    ;Generates 6 zero bytes, then $0003
000C 00000003

0010 04270000          FDB     $427,   ;Note trailing zero
.ll 65
.pw 85
.ju
.pa
.tc
FORM CONSTANT CHARACTERS
.sp
.im 1
       {<LF>}  FCC     <DELIM> { <CHARACTER> ...} <DELIM>
.sp
.ix FCC
FCC causes ASM to assemble the ASCII value of a string
of characters into memory.
.sp
The first character of the argument
.ix String
.ix Character String
string is taken as the
delimiter, and may be any character (except carriage-return).
All characters between the delimiter and the second occurence
of the delimiter character are assembled as the string; the
most significant bit of each
.ix Character
character will be zero.
.sp
.in 2
.un 2
--If the line ends before a second occurence of the
delimiter is found, "Illegal String" is reported, and
the carriage return is treated as the end of the string.
.sp
.un 2
--A digit may be used as the delimiter of a string,
provided that the string does not begin with a series of
digits followed by a comma.
.sp
.un 2
--The string may contain any
.ix ASCII
ASCII character with the
exception of null and carriage return.  This is an
extension over the Motorola standard, which only allows
characters whose values are between $20 and $5F.
.sp
.un 2
.ix Tab
--Tabs contained in the string will be printed as "^I".
.sp
.un 2
--Any labels present will be
.ix EQU
EQU'd to the location
counter before the line is processed.
.sp
.un 2
--The first four bytes generated by the FCC command will
be listed on the line listing the source statement.
Further bytes will be listed as for FCB and FDB.  Note
that if PGEN 1 has not been specified, only the first
four bytes will be listed.
.in 0
.sp
To enhance portability to future SD assemblers, we strongly
recommend use of " (double-quote) as the <DELIM> character.
.sp
.cp 29
Examples:
.sp
.pw 120
.ll 100
.nj
.im 12
  0001                 PCC     1       ;So we can see the PGEN
  0001                 PGEN    1       ;List everything, please.

0000 53545249          FCC     "STRING"
0004 4E47

000A 4E472020
  0000                 PGEN    0       ;List only first 4 bytes.
0006 4F4E4C59  K       FCC     'Only 4 bytes listed'
  0013                 EQU     *-K     But all here generated.

0019 09                FCC     /^I/    Look how nicely tabs get listed.
.ll 65
.pw 85
.ju
.sp
.pa
.tc
FORM FLOATING POINT NUMBER
.sp
.pw 120
.ll 100
.nj
.im 1
        {<LF>}  FFC     <floatingpointnumber>
.ll 65
.pw 85
.ju
.sp
.ix FFC
FFC (Form Floating Constant) causes ASM to convert the
.ix Floating Point
floating point number specified to its corresponding binary form and place
the results into memory. Each floating point number is stored in the BASE
100 format used by the SD
.ix BASIC
BASIC 1.4 Compiler; range is limited to 10**126.  The syntax of numbers
accepted is identical to forms accepted by the compiler. For more details,
refer to the BASIC 1.4 manual.
.sp
.in 2
.un 2
--Any labels present will be
.ix EQU
EQU'd with the location counter before the
line is processed.
.sp
.un 2
--Unreasonably large numbers will get an overflow error and ASM's version
of infinity will be substituted.
.sp
.in 0
Examples:
.sp
.im 12
0000 00000000     4:         FFC     0
0004 0000
0006 41010000     5:         FFC     1
000A 0000
000C 41030E0F     6: PI      FFC     3.14159287
0010 5C57
0012 C1010000     7:         FFC     -1
0016 0000
0018 530A0000     8:         FFC     1E37
001C 0000
001E 32624C36     9:         FFC     .000987654321E-25
0022 200A
.pa
.tc
IMPLICIT DATA STATEMENT
.sp
.ix Implicit Data Generation
.im 1
       {<LF>}  <EXPLIST>
.sp
ASM allows the user to generate data without writing
.ix FDB
FDB or
.ix FCB
FCB statements.  If the command field of a line cannot be
interpreted as a machine language instruction or a directive,
ASM will interpret the entire
.ix Command Field
command field as a list of
expressions whose values are to be assembled as data.
.sp
Each expression will be assembled into one or two bytes,
depending on its value.  If an expression has a value between
0 and $FF, it will be assembled into one byte.  Otherwise it
will be assembled into two bytes.
.sp
These defaults can be overriden in the following ways:
.sp
.in 3
.un 3
1)~If the expression is preceded by a
.ix Hash Mark
hash mark ("#"), the
hash mark will be ignored, and the expression will be
assembled into two bytes regardless of its value.
.sp
.un 3
2)~If the expression is preceded by
.ix Monadic Plus
monadic plus or
.ix Monadic Minus
minus, the expression will be assembled into one byte regardless of
value.  The minus sign will have its usual effect.
.sp
.in 2
.un 2
--Labels present on the line will be
.ix EQU
EQU'd to the
location counter before the statement is processed.
.sp
.un 2
--If an expression contains a forward reference or an
undefined symbol, it will be assembled into two bytes
unless a prefix of "+" or "-" is present.
.sp
.un 2
--Each expression is output as soon as it has been
evaluated.  This means that
.ix *
"*" will have a different
value for each expression across the line.
.in 0
.pa
Examples:
.sp
.pw 120
.ll 100
.nj
.im 25
0000 07                7               ;Generates one byte.
0001 0105              $105            ;Generates two bytes.

  0011         EQU     EQU     17      Define symbol called EQU,
0003 11                +EQU            Generate the value like this,
0004 11                (EQU)           Like this,
0005 0011              #EQU            or like this,
  0000                 EQU             ; But not like this!!
*** Illegal Argument.

0007 009F              Z               ;Generates 2 bytes as forward ref,
0009 9F                +Z              ; Unless qualified.
  009F         Z       EQU     $9F     ;Define Z,
000A 9F                Z               ; Now it generates one byte.

  3F01         SWI.GETC EQU    $3F01   ; This feature can be very useful.
000B 3F01              SWI.GETC        ;Generates SWI followed by code.
  003F         SWI.    EQU     $3F
000D 3F1132            SWI.,Z,50       ;Generates SWI followed by stuff

0010 FE                -2              ;Note: minus sign forces 1 byte
0011 FFFE              (-2)            ;Brackets cause default;
0013 FFFE              #-2             ;Hash ensures two bytes.

0015 020002            2,#2            ;Note: all EXPs can be prefixed
.ll 65
.pw 85
.ju
.pa
.tc
SET LOCATION COUNTER
.sp
.im 1
        {<LF>}  ORG     <EXP>
.sp
.ix ORG
ORG directs ASM to set the location counter to the value
given as the argument.  <EXP> is interpreted as a sixteen-bit
unsigned value, and may not involve a forward reference.
.in 2
.sp
.un 2
--Any labels will be
.ix EQU
EQU'd to the NEW location counter.
.sp
.un 2
--If <EXP> is a forward reference, "Illegal Value" is
reported, and the location counter is not changed.
.sp
.un 2
--The value of the location counter will be listed.
.in 0
.sp
Examples:
.sp
.pw 120
.ll 100
.nj
.im 9
  0010                 ORG     $10     ;New loc. is listed.

  0020         I       ORG     $20     ;Labels are EQU'd...
  0020                 EQU     I       ; ...After the ORG.

  0020                 ORG     J       ;Illegal: J is forward ref.
*** Illegal Value.
0020 0020              FDB     *       ;Note that the ORG 
  0100         J       EQU     $100    ;  wasn't performed.
.ll 65
.pw 85
.ju
.sp 2
.tc
SET DATA PAGE REGISTER
.SP
        {<LF>}  SETDPR  <EXP>
.SP
.ix SETDPR
.ix Direct Mode, 6809
.ix Addressing, Direct 6809
SETDPR directs ASM to assume the DP (Data Page) register has the value
<EXP>/$100 (the upper 8-bits of the 16-bit value <EXP>) when attempting to
generate Direct Mode addresses.  This pseudo-op
is only available in the 6809 assembler.  The default value selected
at the start of each assembly pass is 0.
.in 2
.sp
.un 2
--Any labels will be ignored.
.sp
.un 2
--If <EXP> is a forward reference, "Illegal Value" is reported, and the
assumed value for the DP is set to zero.
.sp
.un 2
--The address of the page to which DP is set is listed.
.in 0
.sp
Examples:
.sp
.pw 120
.ll 100
.nj
.tb 5,15,22,35,40,45,50,55,60
.im 6
  1F00          ORG     $1F00
  0100          SETDPR  $123    ;New DP page address listed
                        
  0000          SETDPR  J       ;ILLEGAL-- J is forward reference
*** Illegal Value
               J        FDB     0
.ll 65
.pw 85
.ju
.sh SECTION IX: CONDITIONAL ASSEMBLY DIRECTIVES
.pa
.tc
.ce
CONDITIONAL ASSEMBLY DIRECTIVES
.ix Conditional Assembly, General
.sp
ASM supports a powerful set of conditional
assembly commands.  These
commands allow great flexibility in system generation and
maintenance especially when multiple configuration or
.ix Options
options
are needed in a program.
.sp
Conditional assembly essentially allows the assembly of only selected
portions of the source; portions not assembled are treated effectively
as comments.  Selection of the desired portions can be specified at
assembly time; see "Operator Input Lines".
.sp
General features of ASM conditional assembly are:
.sp
.in 2
.un 2
--Conditional assembly commands may be nested up to a
total of 255 levels.
.sp
.un 2
--Source security is enhanced by listing options that can
suppress included files, skipped lines and conditional assembly lines.
.sp
.un 2
--Conditional assembly commands are highly consistent:
all blocks are terminated by
.ix FIN
FIN, and all clauses within
blocks are separated by
.ix ELSE
ELSE or
.ix ELSEIF
ELSEIF, depending on function desired.
.sp
.in 0
It should be noted that labels specified on conditional
assembly commands are completely ignored.
.sp 2
It should also be noted that
.ix Forward Reference
forward references are STRICTLY
FORBIDDEN as arguments to conditional assembly commands (exception: see
.ix IFUND
IFUND and
.ix IFDEF
IFDEF).  If an expression is evaluated which contains a forward
reference, "Illegal Value" will be reported, and zero will be
used as a value.
.sp
The following is intended to illustrate use of conditional assembly.  Details
may be found under the full description of conditional assembly.
.pa
.tc
SIMPLE CONDITIONAL ASSEMBLY:
.ix IF
.ix FIN
.sp
.im 3
        IF      <EXP>
        ...
        FIN
.sp
The expression is evaluated.  If it is "true", i.e., positive
and non-zero, the lines between the IF and the FIN are
assembled; otherwise they are skipped.
.sp 2
.tc
ALTERNATIVE ASSEMBLY
.sp
.ix ELSE
.im 5
        IF      <EXP>
        ...
        ELSE
        ...
        FIN
.sp
The expression is evaluated.  If "true", the lines
between the IF and the ELSE are executed.  If "false", the
lines between the ELSE and the FIN are assembled.
.sp 2
.tc
NESTED CONDITIONAL ASSEMBLY
.sp
.ix ELSE
.im 7
        IF      <EXP1>
        ...
        IF      <EXP2>
        ...
        FIN
        ...
        FIN
.sp 2
The first expression <EXP1> is evaluated.  If "false", all
lines up to the second FIN are skipped.  If "true",
lines up to the second IF are assembled, and <EXP2) is
evaluated.  If "true", the lines in the inner block are
assembled; if "false", they are skipped.  Then the lines
from the first FIN to the second FIN are assembled.
.pa
.tc
MORE COMPLICATED CONDITIONAL ASSEMBLY
.sp
.ix ELSEIF
.im 9
        IF      <EXP1>
        ...
        ELSEIF  <EXP2>
        ...
        ELSEIF  <EXP3>
        ...
        ELSE
        ...
        FIN
.sp
The ELSEIF directive is designed to allow the user to have
multiple alternatives without having to nest conditional
assembly blocks.  Instead of writing,
.sp
.im 9
        IF      <EXP1>
        ...
        ELSE
        IF      <EXP2>
        ...
        ELSE
        ...
        FIN
        FIN
.ix ELSE
.sp
one can write,
.sp
.im 7
        IF      <EXP1>
        ...
        ELSEIF  <EXP2>
        ...
        ELSE
        ...
        FIN
.sp
which both is clearer and minimizes the possibility of
forgetting a FIN.  
If <EXP1> is "true", then the lines up to the first
ELSEIF are assembled, and the remaining lines (up to the
FIN) are skipped.
.sp
If <EXP1> is "false", then the lines up to the first
ELSEIF are skipped.  If <EXP2> is "true", then the block of
lines between the first and second ELSEIFs is assembled,
and the remainder of the lines (up to the FIN) are
skipped.
.sp
This process of skipping to the next ELSEIF continues until
either a ELSE command is encountered or an ELSEIF is
encountered with a "true" expression.  In either case, all
lines up to the next ELSE, ELSEIF or FIN are assembled.
ASM then skips to the FIN which closes this block.
.pa
.tc
MULTI-CASE CONDITIONAL ASSEMBLY
.sp
.ix CASE
.ix ELSE
.ix FIN
.im 9
        CASE    <EXP>
        ...
        ELSE
        ...
        ELSE
        ...
        ELSE
        ...
        FIN
.sp
If <EXP> is negative, all lines are skipped to the FIN.
.sp
Otherwise, the n-th block of lines is selected to be
assembled, and all others are skipped.  If <EXP> is zero, the
lines between the CASE and the first ELSE is assembled; if
<EXP> is one, the lines between the first and second ELSE
is assembled; and so on.  If <EXP> is greater than the number
of ELSE lines in this CASE block, none of the lines are
assembled.
.pa
.tc
CONDITIONAL ASSEMBLY ON UNDEFINED SYMBOLS
.sp
.ix IFUND
.im 5
        IFUND   <SYMBOL>
        ...
        ELSE
        ...
        FIN
.sp
If the symbol given as an argument is undefined or a forward
reference, the  block of lines between IFUND and ELSE is assembled;
otherwise the block of lines between ELSE and FIN are assembled.
The ELSE portion is optional.
.sp
This form of the IF directive can be extremely useful for
supplying default values to
.ix Symbol, Default Value
symbols used in controlling
system generation.  When combined with console input (see
"Using ASM", below), it allows certain parameters to be
changable at assembly time, without requiring that they be
explicitly specified.
.sp
.sp
Example:
.sp
.im 3
                IFUND   BUFSIZE ;BUFSIZE will be
        BUFSIZE EQU     17      ; EQU'd to 17 only
                FIN             ; if it isn't already defined.
.sp 2
CONDITIONAL ASSEMBLY ON DEFINED SYMBOLS
.tc
.ix IFDEF
.sp
.im 5
        IFDEF   <SYMBOL>
        ...
        ELSE
        ...
        FIN
.sp
This form of the IF directive is the logical opposite of IFUND.
.sp
If the symbol given as an argument is defined and not a forward
reference, the block of lines between IFUND and ELSE 
are assembled; otherwise, the block of lines between ELSE and
FIN are assembled.  The ELSE portion is optional.
.sp
Example:
.pw 120
.ll 100
.nj
.sp
.im 3
                IFDEF   BUFFERSIZE      ;This defines BUFFER
        BUFFER  RMB     BUFFERSIZE      ; only if BUFFERSIZE is defined
                FIN
.ll 65
.pw 85
.ju
.pa
.tc
FULL DESCRIPTION OF CONDITIONAL ASSEMBLY COMMANDS
.ix Conditional Assembly, Details
.sp
In this section we present a rigorous description of the
conditional assembly commands.  This section may be skipped
by those who do not need to know the exact details of
conditional assembly in ASM.
.sp
ASM has five states with respect to conditional
assembly.  Each command will have a different interpretation
in each of the five states.  These states are:
.sp
.in 11
.un 11
STATE~1~--~No conditional assembly blocks are being
processed.  This is the initial state of ASM.
.sp
.un 11
STATE~2~--~Lines are being assembled within a
conditional assembly block.
.sp
.un 11
STATE~3~--~Lines are being skipped to the next
matching ELSE or ELSEIF.
.sp
.un 11
STATE~4~--~Lines are being skipped to the next
matching FIN, i.e., to the end of this conditional
assembly block.
.sp
.un 11
STATE~5~--~Lines are being skipped to the n-th
matching ELSE.
.in 0
.sp 2
State one needs no special description.  Lines are read
and processed unconditionally.  When a conditional assembly
command is encountered in state 1, ASM switches to one
of the other four states, depending on the command and its
arguments.
.sp
State 2 is similar to state 1.  Lines are read and
processed unconditionally.  Unlike state 1, ELSE, ELSEIF and
FIN commands are valid.  If an ELSE or ELSEIF command is
encountered, ASM enters state 4, skipping to the next
matching FIN.  FIN commands are ignored unless the FIN closes
the outermost conditional assembly block; in this case,
ASM switches to state 1.
.sp
State 3 skips lines.  Lines are read and ignored
unless they are one of the conditional assembly directives.
If a nested conditional assembly block is encountered, all
lines contained in that block are unconditionally
skipped.  If a FIN is encountered, we go to states 1 or 2 as
appropriate.  If an ELSE is encountered ASM switches to
state 2.  If an ELSEIF is encountered, then its argument is
evaluated.  If "true", ASM switches to state 2,
otherwise it remains in state 3.
.sp
State 4 is like state 3; the difference is that ELSE and
ELSEIF commands are skipped.  The only directive that will
get ASM out of state 4 is FIN.
.pa
State 5 is like state 3, but is used to process CASE blocks.
When state 5 is entered, an internal counter records the
number of ELSE or ELSEIF lines to be skipped.
Lines are processed as for state 4, but when an ELSE or
ELSEIF is encountered, the counter is decremented.  If the
counter then has the value one, ASM switches
unconditionally to state 3.  An unmatched FIN terminates the CASE
block, and ASM switches to state 1.
.sp
In the following discussion of the individual directives, the
operation of each directive in each state will be described.
.sp
Again, note that conditional assembly commands do not allow
argument expressions involving forward references.
.pa
.tc
THE "IF" DIRECTIVE
.ix IF
.sp
.im 1
                IF      <EXP>
.sp
IF is the basic conditional assembly command in ASM.
.sp
.in 9
.un 9
STATE~1:~<EXP> is evaluated.  If false (<exp> is zero or
negative), ASM transfers to
state 3, and skips to an ELSE, ELSEIF or FIN.  If true (<exp> is positive
and non zero), state
2 is entered.
.sp
.un 9
STATE~2:~Exactly like state 1 -- except that if this IF would
open the 255-th nested conditional assembly block, "Nesting
Error" is reported and the IF is ignored.
.sp
.un 9
STATE~3:~ASM unconditionally skips all lines
contained in the conditional assembly block which this IF
opens.
.sp
.un 9
STATE~4:~Same as state 3.
.sp
.un 9
STATE~5:~Same as state 3.
.in 0
.sp 2
.tc
CLOSE CONDITIONAL ASSEMBLY BLOCK
.in 0
.ix FIN
.sp
.im 1
                FIN
.sp
FIN marks the end of the most recently opened conditional
assembly block.
.sp
.in 9
.un 9
STATE~1:~"Nesting Error" is reported.
.sp
.un 9
STATES~2, 3, 4 and 5: ASM returns to the state it was in
when it encountered the line that opened this block.
.in 0
.sp 2
.in 0
.tc
CONDITIONAL ASSEMBLY WITH CHECK
.sp
.ix DO
.im 1
                DO      <EXP>
.sp
DO's operation is in all cases like IF, with the added
restriction that the value of <EXP> is restricted to be +1, 0
or any negative value.
.pa
.tc
IF SYMBOL NOT DEFINED
.ix IFUND
.sp
.im 1
                IFUND   <SYMBOL>
.sp
IFUND causes ASM to check the symbol given as the
argument.  If the symbol given is undefined, the effect is
that of IF 1; if it is defined, the effect is that of IF 0.
.sp
From IFUND's point of view, <SYMBOL> is undefined if it is
either truly undefined or a forward reference.
.sp
.in 9
.un 9
STATE~1:~If the argument is not solely a symbol, "Illegal
Argument" is reported, and ASM switches to state 3.  If
the argument is solely a symbol, and the symbol is either a
forward reference or undefined, ASM switches to state
two; otherwise it switches to state 3.
.sp
.un 9
STATE~2:~Like state 1, with the additional checks described
for IF, state 2.
.sp
.un 9
STATE~3:~Same as IF.
.sp
.un 9
STATE~4:~Same as IF.
.sp
.un 9
STATE~5:~Same as IF.
.in 0
.sp 2
.tc
IF SYMBOL DEFINED
.SP
.ix IFDEF
.im 1
                IFDEF   <SYMBOL>
.sp
IFDEF causes ASM to check the symbol given as the
argument.  If the symbol given is defined, the effect is
that of IF 1; if it is undefined, the effect is that of IF 0.
.sp
From IFDEF's point of view, <SYMBOL> is undefined if it is
either truly undefined or a forward reference.
.sp
.in 9
.un 9
STATE~1:~If the argument is not solely a symbol, "Illegal
Argument" is reported, and ASM switches to state 3.  If
the argument is solely a symbol, and the symbol is not a
forward reference and is defined, ASM switches to state
two; otherwise it switches to state 3.
.sp
.un 9
STATE~2:~Like state 1, with the additional checks described
for IF, state 2.
.sp
.un 9
STATE~3:~Same as IF.
.sp
.un 9
STATE~4:~Same as IF.
.sp
.un 9
STATE~5:~Same as IF.
.sp
.in 0
.pa
.tc
THE ELSE DIRECTIVE
.ix ELSE
.sp
.im 1
                ELSE
.sp
The ELSE directive serves to separate groups of lines
within a conditional assembly block into clauses.
.sp
.in 9
.un 9
STATE~1:~"Nesting Error" is reported; no other action is
taken.
.sp
.un 9
STATE~2:~ASM unconditionally changes to state 4, and
skips the remaining lines in this conditional assembly
block.
.sp
.un 9
STATE~3:~ASM unconditionally changes to state 2, and
begins assembling lines.
.sp
.un 9
STATE~4:~The directive is ignored.
.sp
.un 9
STATE~5:~The case counter is decremented.  If its value is
now 1, ASM switches to state 3; otherwise it remains in
state 5.
.in 0
.sp 2
.tc
CONDITIONAL ELSE
.ix ELSEIF
.sp
.im 1
                ELSEIF  <EXP>
.sp
The ELSEIF directive is designed to allow the user to have
multiple alternatives without having to nest conditional
assembly blocks.  ELSEIF is legal anywhere an ELSE is, although
in CASE blocks it should be used with caution, as its misuse
can lead to difficult code to read.
.sp
.in 9
.un 9
STATE~1:~"Nesting Error" is reported; no other action is
taken.
.sp
.un 9
STATE~2:~Exactly like ELSE.
.sp
.un 9
STATE~3:~It is this state which distinguishes ELSEIF from
ELSE.  <EXP> is evaluated, and if "true" (positive and non-zero)
ASM switches to state 2.  Otherwise ASM remains in state 3.
.sp
.un 9
STATE~4:~Same as ELSE.
.sp
.un 9
STATE~5:~Same as ELSE.
.in 0
.pa
.tc
CASE CONDITIONAL ASSEMBLY
.sp
.ix CASE
.im 1
                CASE    <EXP>
.sp
The CASE directive causes ASM to select one of the
subsequent ELSE-clauses to be assembled.
.sp
.in 9
.un 9
STATE~1:~<EXP> is evaluated.  If negative, ASM switches
to state 4, and skips all lines in this block.  If zero,
it switches to state 2, and processes the lines up to
the first ELSE.  If +1, it switches to state 3, and skips to
the first ELSE.  Otherwise, it enters state 5, and skips to
the n-th ELSE-clause.
.sp
.un 9
STATE~2:~Like state 1, with the additional checks described
in IF, state 2.
.sp
.un 9
STATE~3:~All lines in the conditional assembly block
opened by the CASE are skipped.
.sp
.un 9
STATE~4:~Like state 3.
.sp
.un 9
STATE~5:~Like state 3.
.in 0
.pa
.tc
SINGLE LINE ITERATIVE ASSEMBLY
.ix Iterative Assembly
.ix RPT
.sp
.im 1
        {<LF>}  RPT     <EXP>
.sp
RPT causes ASM to assemble the next source line zero or
more times.  If <EXP> is zero or negative, the next line is
skipped.  If <EXP> is positive, the next line is repeated as
many times as specified.  <EXP> may not involve a forward
reference.
.sp
.in 2
.un 2
--Any labels present will be
.ix EQU
EQU'd to the
.ix Location Counter
location counter before the line is processed.
.sp
.un 2
--The target of the RPT may not be any of the following
directives:
.ix CASE
.ix DO
.ix ELSE
.ix ELSEIF
.IX END
.IX FIN
.IX IF
.IX IFDEF
.IX IFUND
.IX MON
.IX RPT
.im 2
        CASE    DO      ELSE      ELSEIF  END     FIN
        IF      IFDEF   IFUND     MON     RPT
.br
If such a line is discovered as a target of an RPT,
"Nesting Error" is reported, and the line is always
processed once.
.sp
.un 2
.ix Comment Line
--Comment lines encountered between the RPT and the next
non-comment line will be printed and ignored, NOT
repeated.
.sp
.un 2
--If <EXP> involves a
.ix Forward Reference
forward reference, "Illegal Value" is reported, and the effect is
.im 1
                RPT     0
.sp
.un 2
.ix INCLUDE
--INCLUDE can be the target of a RPT only if the repeat count is 0 or 1.
.sp
.in 0
Example:
.sp
.pw 120
.ll 100
.nj
.im 19
  0004         AB      RPT     5       Generate 5 bytes of zero:
0000 00                FCB     0       And EQUs AB to beginning of block
0001 00        
0002 00                
0003 00                
0004 00                
  0000                 EQU     AB      ;Note that AB has right value


               * Generate ascending powers of 2 in 1 byte table:
  0008         TBL     RPT     8
0005 01                FCB     1##(*-TBL)
0006 02                
0007 04                
0008 08                
0009 10                
000A 20                
000B 40                
000C 80
.ll 65
.pw 85
.ju
.sh SECTION X: ASSEMBLY CONTROL DIRECTIVES
.pa
.tc
.ce
ASSEMBLY CONTROL DIRECTIVES
.ix Assembly Control Directives
.sp
ASM provides several commands which control various
aspects of its operation.
.sp 2
.tc
TERMINATE SOURCE FILE
.ix END
.ix MON
.sp
.im 3
                END
                END     <expr>
                MON
.sp
The END (or MON) directive informs ASM that there are no
more source lines to be assembled.  When encountered during
.ix Pass One
pass one, it causes ASM to rewind the source file, open
the binary and listing files, reprocess the saved
operator-input lines (see "Using ASM"), and then process
the source file.  When encountered during
.ix Pass Two
pass 2, it causes
ASM to print summaries as requested on the
.ix WITH
WITH command, to close the source, binary and listing files, and then to
exit.
.sp
The following summaries may be printed at the end of pass
two:
.sp
.in 2
.un 2
--Symbol table sorted by name and by value
.sp
.un 2
--Line numbers on which errors were detected.
.sp
.un 2
--Number of errors detected.
.sp
.in 0
The last two items will also be printed on the console device.
.sp
END or MON need not be present at the end of a source file.  If none
is found, ASM will supply an END statement.
.sp
END statements accept an optional
.ix Start Address
start address expression in the AF
field.  The expression
must evaluate on Pass 2 to a non-zero value.  If
.ix INCLUDE
INCLUDE files are in use, END statements in INCLUDE'd files may set the
start address.  Multiple ENDs may set the start address if they all evaluate
to the same value. Differing values will cause an error.  The first value
set will prevail.
.sp
NOTE: Start addresses of 0 are illegal.  This is because the
object format uses 0 to indicate
.ul
NO
start address.
.pa
.in 0
.tc
SELECT ASSEMBLY OPTIONS
.ix Select Assembly Options
.sp
.im 1
        WITH    <OPTION> { , <OPTION> ... }
.sp
The
.ix WITH
WITH command provides control over miscellaneous features of ASM.  It is
intended to be input by the operator at the start of the assembly (see
"Using ASM"), but may also be included in the source file.  The
.ix Options
options in effect at any time are the result of the last WITH command
encountered; options not specified are not affected.  The options in effect
at the beginning of the
.ix Pass Two
second pass are the options in effect at the end of the
.ix Pass One
first pass.
.sp
The following options are specified by default:
.sp
.im 9
        NMCM
        NLN
        NLF
        WI=132
        DE=66
        DMP
        EL
        LST
        DO
.sp
.sp
Options and their meanings are:
.sp
.in 13
.un 8
.ix MCM
MCM
.br
.ix Motorola
.ix Operator Precedence
"Motorola compatible".  Forces dyadic
operators to be evaluated strictly
left-to-right.  This option should be
selected when assembling files originally
prepared for assembly by Motorola standard
assemblers.  Parentheses are still available
for overriding Motorola precedence.
.sp
.ix NMCM
.ix Operator Precedence
.un 8
NMCM
.br
"Not Motorola compatible".  Causes dyadic
operators to be evaluated in the usual,
heirarchial order.  This is the default mode
of operation.
.sp
.ix M6801
.un 8
M6801
.br
"Assemble M6801 instructions."  Accepted only by ASM6800.  Tells ASM that
M6801 instructions are valid and should be assembled as such.  If this
option is not enabled, all
.ix 6801
6801 specific instructions are treated as
.ix 680C
M680C instructions and 6800 equivalent instructions are substituted in their
place.
.pa
.ix LN
.ix Line Numbers
.un 8
LN
.br
"Line numbers".  Informs ASM that there
are source line numbers present in the file.
See "Source Line Numbers" for a description
of how source line numbers are processed.
.sp
.ix NLN
.un 8
NLN
.br
"No line numbers".  Tells ASM not to
expect line numbers in the file.  This is the
default mode of operation.
.sp
.ix LF
.un 8
LF
.br
"Line feeds".  Informs ASM that extraneous line feeds are present in the
source file, and are to be ignored.  This option should be specified for all
files prepared on systems which use CR/LF or LF/CR as line separators.  If
specified, all line
feeds encounterd in the source file will be
completely ignored: they will not even be
listed.
.sp
.ix NLF
.un 8
NLF
.br
"No line feeds".  Informs ASM that line feed characters encountered in the
file have no special significance.  This is the default mode of operation. 
Files prepared with editors which use CR alone to separate lines should be
processed in this mode.
.sp
.ix WI=<EXP>
.un 8
WI=<EXP>
.br
"Set listing device page width".  Tells ASM how many physical columns there are
on the
.ix Listing, Width
listing device.  Any line that is longer than <EXP> characters long
(including assembler generated information such as the output data in the
left portion of the page) will be truncated.  The default width for a
printing device is the page width established by the SDOS SET command; for a
disk file, it is defaulted  to 132.
.sp
.ix DE=<EXP>
.un 8
DE=<EXP>
.br
"Set listing device page depth".  Tells ASM how many physical lines there are
on a
.ix Listing, Depth
page.  This information is used to control pagination.  The default
depth for a printing device is the page depth established by the SDOS
.ix SET, SDOS
SET command; for a disk file, the default depth is 66.  A depth
specification of less than 13 causes continuous form listing (no page
headers except the first).
.pa
.ix DMP
.un 8
DMP
.br
"Dump symbol table".  Requests that a
.ix Symbol Table
symbol table dump be produced on the listing device at the end of the
assembly, sorted by name and by value.
.sp
.ix NDMP
.un 8
NDMP
.br
"No dump of symbol table." prevents a symbol
table dump.
.sp
.ix EL
.un 8
EL
.br
"Save error line numbers".  Requests that a summary be printed at the end of
the assembly on the listing device, detailing which lines had errors.  Each
error line saved requires six bytes of memory; if there is no room to save
an
.ix Error Lines
error line number, no notification is given to the user, and the list of
lines at the end of the assembly may not be complete. However, this
situation will only arise when ASM has run out of space in the symbol table,
which will cause notification of space problems.
.sp
.ix NEL
.un 8
NEL
.br
"No error line numbers".  Prevents ASM from saving or reporting error line
numbers.
.sp
.ix LST
.un 8
LST
.br
"Produce listing".  Tells ASM to produce a full
.ix Listing
listing of the assembled source file. Does not imply DMP.
.sp
.ix NLST
.un 8
NLST
.br
"No listing, please".  Tells ASM not to produce a full listing of the
assembled source file on the listing device.  Note that LIST 1 occurring in
the source will NOT override this option; note also that any lines on which
errors are detected will be listed anyway.  This option does not prevent
DMP, nor does it imply NDMP.
.sp
.ix DO
.un 8
DO
.br
"Diagnostic output on console".  Tells ASM to copy
.ix Error Lines
error lines and error messages to the console.
.sp
.ix NDO
.un 8
NDO
.br
"No diagnostic output on console".  Tells ASM not to copy error lines and
messages to the console.  This option should be used when a listing is being
produced on the console device.  Otherwise the output may have intermixed
listing and error messages.
.pa
.ix BXPN
.un 8
BXPN
.br
"Branch Expansion".  Tells ASM to expand branches with a jump macro
destination resolves on pass and one as out of branch range (+ 127, - 128).
This option available only for 6805 Assembler.
.sp
.ix NBXPN
.un 8
NBXPN
.br
"No Branch Expansion".  Tells ASM not to expand branches with jump macros.
This option available only for 6805 Assembler.
.in 0
.pa
THE OPT STATEMENT
.ix OPT
.tc
.sp
.im 1
        OPT     <CHAR>...
.sp
The OPT command is provided only for compatibility with
.ix Motorola
Motorola source files.  The
.ix Argument Field
argument field is totally ignored
and none of the Motorola specific options are supported.
Assembly control directives are specified to ASM via the WITH
command.
.sp 2
.tc
THE INCLUDE STATEMENT
.sp
.im 1
        INCLUDE <FILE NAME>
.sp
The
.ix INCLUDE
INCLUDE command allows the inclusion of whole source files as part of the
assembly.  An INCLUDE'd file is assembled as though its contents were
actually substituted for the INCLUDE statement.  An INCLUDE'd file may also
contain INCLUDE directives.  INCLUDE files may be nested in this fashion to
a depth of 16 levels.
.sp
Common uses for INCLUDE are:
.sp
.in 2
.un 2
--Inclusion of SDOSUSERDEFS to define SDOS symbols.
.sp
.un 2
--Sharing of common code between several assemblies.
.sp
.un 2
--Breaking up of huge source files to reasonable size files.
.sp
.in 0
The <FILENAME> must be a valid SDOS file name; it is written as though it
were a symbol name.
.sp
Example:
.sp
.im 3
        INCLUDE SDOSUSERDEFS.ASM

        INCLUDE D3:DATATABLES.SRC
.pa
INCLUDE supports recursion.  This means that by use of conditional assembly
and recursion, "looping" for multiple copies of a file is possible to the
maximum include depth.
.sp
Example:
.sp
File A:
.sp
.IM 5
        N       SET     10
        F       SET     1
                INCLUDE FACTORIAL
                FDB     F       ;Gen word with Factorial
                END
.SP
File FACTORIAL:
.sp
.IM 7
                IF      N
                FDB     N       ;Generate word with a factor
        F       SET     F*N     ;Compute Factorial
        N       SET     N-1
                INCLUDE FACTORIAL
                FIN
                END
.in 0
.sp
When file "A" is assembled it will cause FDB's with values 10 down to 1 and
10! to be generated.
.sp
.ix END
END statements are optional in INCLUDE files.  When they are used, they may
specify a
.ix Start Address
start address.  (See END for more detail).
.sp
INCLUDE statements may be the target of
.ix RPT
RPT statements if the count is 0 or 1.  Any other count will produce a
"nesting error".  Thus a RPT may be used for conditional INCLUDEs.
.pa
.tc
LISTING CONTROL AND FORMATTING
.ix Listing Control
.sp
ASM has an range of listing formatting options, allowing the professional
user great flexibility in generating listings which will also serve as
documentation.
.sp
It is important to understand two underlying design goals of the listing
portion of ASM:
.sp
.in 2
.un 2
--Any line which is determined to be in error will unconditionally be sent
to the listing device, regardless of the various listing control options. 
Such lines will also be sent to the console device, unless supressed by
.ix WITH
WITH NDO.  The lines will be printed on the console exactly as formatted for
the listing.
.sp
.un 2
--If WITH NLST was specified (see "Assembly Control"), then ONLY error lines
will be listed.  In particular, the LIST directive cannot override the NLST
option; LIST was designed to be used in formatting listings as they are
produced.
.sp
.un 2
--At no time will a totally blank page be printed. Consecutive page-eject
commands, or spacing operations which cross multiple page boundaries will
never cause more than one page to be ejected; and if encountered at the top
of a clean page, they will be ignored.
.sp
.un 2
--There are three listing on/off directives which control whether output
goes to the
.IX LO
LO (Listing Output).  They are listed below in order of decreasing
dominance.
.sp
.im 3
                WITH    LST
                WITH    NLST
                LIST
.sp
.in 0
.pa
.tc
PAGE HEADING FORMAT
.ix Page Heading Format
.sp
In the following discussions it will be important to know what the various
fields of the page header are, and what they are called.
.sp 2
.im 26
   ----------------------------------->  Name of Assembler.
   |     ----------------------------->  Version of Assembler.
   |     |    ------------------------>  PC at Time of Page
   |     |    |                           Eject
   |     |    |       ---------------->  Program Name From
   |     |    |       |                   "Name" Command.
   |     |    |       |           ---->  Program Title From
   |     |    |       |           |       "Title" Command.
   |     |    |       |           |
   ASM 1.4:   0000   <NAME>    <TITLE>
<DATE/TIME>; Page 1; Form 1    <SUBTITLE>
<SRC FILE>|    |          |        |
     |    |    |          |        --->  Program Subtitle From
     |    |    |          |               "Page" Command.
     |    |    |          ------------>  Count of Control-L's
     |    |    |                          Encountered So Far
     |    |    |                          in file.  Useful
     |    |    |                          when using Editors
     |    |    |                          based on ^L.
     |    |    ----------------------->  Page Number, this
     |    |                               listing.
     |    ---------------------------->  Date/Time in SDOS
     |                                    System Format.
     --------------------------------->  Source File Being
                                          Processed When Page
                                          Throw Occurred.
.pa
.tc
LINE LISTING FORMAT
.ix Line Listing Format
.sp
ASM uses several formats when listing a line.  Lines which
generate data will be listed in the following form.
.sp
.im 6
        PPPP DDDDDDDD NNNN: TTTTTTTT....
          VVVV        NNNN: TTTTTTTT....
        PPPP          NNNN: TTTTTTTT....
          *S*         NNNN: TTTTTTTT....
                      NNNN: TTTTTTTT....
        PPPP VVVV     NNNN: TTTTTTTT....
.sp
The first form is used when a line generates data.  PPPP is
the first location that the data will be loaded into;
DDDDDDDD are the data bytes.  Up to four bytes may be
displayed on a given line.  NNNN is the line number; this
field is reset to 1 whenever a form-separator is encountered
in the source, and incremented for every line read.  TTTTTTT
is the text of the source line, with tab characters expanded
according to the tab stops currently in effect (specified by
.IX TABS
TABS).
.sp
The second form is used for lines containing directives that
do not generate data but do have a numeric result of some
kind.  VVVV is the value field, and generally is used to
display the value of the directive's argument.
.sp
The third form is used to list lines containing an ORG
command.  PPPP is the new value of the location counter.
.sp
The fourth form is used to list lines that were skipped due
to conditional assembly commands.  "*S*" is printed in the
value field.
.sp
The fifth form is used to list comment lines, and lines which
do not have any value per se.
.sp
The sixth form is used to list lines containing RMB commands.
PPPP is the value of the location counter at the beginning of
the reserved block, and VVVV is the number of bytes in the
block.
.pa
.tc
PRINT CONTROL CARDS
.ix PCC
.sp
.im 1
        PCC     <EXP>
.sp
PCC instructs ASM as to whether listing control commands
are to be printed on the listing.  If <EXP> is false,
subsequent control commands will not be printed in the
listing.  If <EXP> is true, subsequent control commands will
be printed in the listing.
.sp
.in 2
.un 2
--PCC is always printed.
.sp
.un 2
--The default at start of assembly is PCC 0.
.in 0
.sp 2
.tc
TURN LISTING ON/OFF
.sp 1
.im 1
        LIST    <EXP>
.sp
.ix LIST
LIST instructs ASM as to whether subsequent records are
to be included in the listing.  If <EXP> is true, subsequent
lines will be listed; if false, subsequent lines will not be
listed.
.sp
.in 2
.un 2
--LIST has no effect unless a listing is being produced
(WITH LST specified).
.sp
.un 2
--PCC controls whether LIST is listed.
.sp
.un 2
--<EXP> may be a forward reference.
.sp
.un 2
--LIST 1 in an INCLUDE'd file will affect the listing of the
file containing the
.ix INCLUDE
INCLUDE directive.
.in 0
.pa
.tc
SET TITLE AND EJECT PAGE
.sp
.im 1
        TITLE   {;} { <STRING OF CHARACTERS> }
.sp
.ix TITLE
TITLE directs ASM to eject a page before printing the
next line of the listing.  If any non-blank characters occur
in the
.ix Argument Field
argument field, the title field in the page header is
changed before the page is ejected.  If no non-blank
characters appear, the title is not changed.
.sp
.in 2
.un 2
--If a
.ix Semicolon
semicolon appears as the first non-blank
character after the "TITLE" command, it will be ignored,
but the title field will be set to whatever characters
remain on the line.  Thus, a null title may be set by
writing
.im 1
                TITLE   ;
.sp
.un 2
--The first title specified in
.ix Pass One
pass one will be used as
the initial value of the title field at the start of the
listing in
.ix Pass Two
Pass Two.
.sp
.un 2
.ix PCC
--PCC controls whether TITLE is listed.
.sp
.un 2
--If LIST 0 is in effect, the page eject is not issued.
However, the title will be changed if a new title was
specified.
.sp
.un 2
--If PCC 0 has been specified, then TITLE followed by
PAGE will set both the title and the subtitle; only one
page will be ejected.
.in 0
.pa
.tc
SET SUBTITLE AND EJECT PAGE
.ix PAGE
.sp
.im 1
        PAGE    {;} { <CHARACTERS> }
.sp
The PAGE directive is identical in function to
.IX TITLE
TITLE, except
that it changes the subtitle field of the page header rather
than the title field.  As with TITLE, the first subtitle
encountered in pass one will be used as the initial subtitle
of the listing.
.sp 2
.tc
SET NAME
.sp
.im 2
        NAME    {;} { <CHARACTERS> }
        NAM
.sp
.IX NAM
.IX NAME
The NAME directive is similar to the TITLE directive, with
the following differences.
.sp
.in 2
.un 2
--The name field in the page header is affected.
.sp
.un 2
.IX PCC
--PCC has no control over the listing of NAME.
.sp
.un 2
--NAME does not eject a page.
.sp
.in 0
The following differences between the
.ix Motorola
Motorola standard and ASM should be noted:
.sp
.in 2
.un 2
--NAME need not be the first statement in a file.
.sp
.un 2
--More than one NAME directive is permitted.
.sp
.un 2
--No restrictions are placed on the possible contents of
the name field.
.in 0
.pa
.tc
SPACE LISTING N LINES
.sp
.im 2
        SPACE   {<EXP>}
        SPC
.sp
.ix SPC
.IX SPACE
SPACE directs ASM to insert <EXP> blank lines before
printing the next line of the listing.  If <EXP> is negative,
no lines are spaced; if <EXP> is zero or missing, one line is
spaced.
.sp
.in 2
.un 2
.IX PCC
--PCC controls whether SPACE is listed.
.sp
.un 2
--If listed, the SPACE command is listed after the
spacing operation has been performed.
.sp
.un 2
--In no case will SPACE cause more spaces to be inserted
than remain on the current page.
.sp
.un 2
.IX LIST
--If LIST 0 is in effect, no action is taken, although
the expression is evaluated.
.in 0
.sp 2
.tc
SET LISTING TABS
.sp
.im 1
        TABS    <EXPLIST>
.sp
.IX TABS
TABS allows the user to tell ASM how tabs are to be
expanded.  Each <EXP> specifies a column number relative to
the first column of the source line, which is numbered 1.  No
<EXP> may be less than 2 or greater that 234.  No more than
eight tab stops may be specified.
.sp
.in 2
.un 2
--The default values for tabs are 9, 17, 25, 33 and 41:
every eight columns.
.sp
.un 2
--The tabs must be specified in ascending order.
.sp
.un 2
--If any argument to a TABS directive is erroneous,
the tabs are reset to their default values.
.sp
.IX PCC
.un 2
--PCC controls whether the TABS command is listed.
.sp
.un 2
--At least one <EXP> must be present, and null
expressions are NOT allowed.
.in 0
.pa
.tc
PRINT SKIPPED RECORDS
.sp
.im 1
        PSR     <EXP>
.sp
.IX PSR
The PSR directive allows the user to specify whether records
skipped due to conditional assembly commands are to be
listed.  <EXP> is evaluated; if false, then
.IX Skipped Records
skipped records
are not to be included in the listing; if true, skipped
records are to be included in the listing, marked by "*S*"
printed in the data field of the listing.
.sp
This command can be especially useful when preparing listings
of software for release to the users of the software.  Code
not relevant to the particular system generated can be easily
omitted from the listing.
.sp
.in 2
.ix PCC
.un 2
--PCC controls whether the PSR command is listed.
.sp
.un 2
--The default is PSR 1.
.in 0
.sp 2
.tc
PRINT GENERATED DATA
.sp
.im 1
        PGEN    <EXP>
.sp
.ix PGEN
The PGEN directive is used to tell ASM whether all data
generated is to be included in the listing.  The expression
is evaluated; if false, only the first four bytes of data
will be listed.  If true, all data will be listed, with
additional lines included on the listing if necessary.
.sp
.in 2
.ix PCC
.un 2
--PCC controls the listing of the PGEN directive.
.sp
.un 2
--The default is PGEN 0.
.sp
.in 0
Examples:
.sp
.im 9
  0001                 PCC     1       ;So we can see the PGEN
  0001                 PGEN    1       ;So we can see everything.

0000 01020304          FCB     1,2,3,4,5,6,7,8,9
0004 05060708  
0008 09        
  0000                 PGEN    0       ;So we only see first part.
0009 01020304  L1      FCB     1,2,3,4,5,6,7,8,9
  0009                 EQU     *-L1    ;It really got generated.
.pa
.tc
PRINT CONDITIONAL ASSEMBLY COMMANDS
.sp
.im 1
        PCA     <EXP>
.ix PCA
.sp
The PCA directive is used to tell ASM whether to list
.ix Conditional Assembly
conditional assembly command lines.  The expression is
evaluated; if false, subsequent conditional assembly commands
will not be listed.  If true, subsequent conditional assembly
commands will be listed.
.sp
.in 2
.un 2
--The default is PCA 1
.sp
.un 2
--PCA controls the listing of the following commands.
.br
.IX DO
.IX ELSE
.IX ELSEIF
.IX FIN
.IX IF
.IX IFUND
.IX RPT
.im 2
                DO      ELSE    ELSEIF  FIN
                IF      IFUND   RPT
.sp
.un 2
--If a conditional assembly command is being skipped, it
will be listed only if PCA 1 and PSR 1 are both in
effect.
.sp
.IX PCC
.un 2
--PCC controls the listing of PCA commands.
.in 0
.sh SECTION XI: OPERATING ASM
.pa
.tc
.ce
OPERATING ASM
.IX Operation of ASM
.sp
To use ASM, one must first construct a source file containing the text of
the assembly language program to be assembled.  Under SDOS, this can be
accomplished using the context editor
.ix EDIT
(EDIT) or the screen editor
.ix SEDIT
(SEDIT).  Description of the use of these editors is beyond the scope of
this manual.
.sp
Once the assembler has started, two kinds of reactions are possible:
reactions based upon activities by SDOS on behalf of the assembler (such as
opening files, printing on the printer, asking for keyboard data entry,
etc.) and actions by the assembler.  Interactions with and reactions of SDOS
are beyond the scope of this manual; it is assumed the operator is familiar
with the SDOS command interpreter, line editing conventions, and how to deal
with errors  (for more information, refer to the SDOS manual).  See Appendix
C for a list of some SDOS related error messages that can be reported while
using ASM, and their meanings. This manual covers only responses and actions
of ASM itself.
.sp 2
.tc
STARTING ASM
.sp
Once the source file has been constructed, the assembler must be invoked. 
This is accomplished in the SDOS conventional way, by typing its name while
at the SDOS command interpreter prompt; and then entering carriage return. 
ASM will respond by identifying itself:
.sp
.im 2
        .ASM
        Software Dynamics ASM/680d, Version 1.4r
.sp
"d" will be "0" if this assembler produces 6800 or 6801 object, and "9" if
the assembler produces 6809 object code.  "r" is the revision letter of ASM.
.sp
It will then print
.sp
.ix Source File
.im 1
        Source File=
.sp
and wait for input.  Enter the name of the file which is to be assembled,
followed by a carriage return.  If  a bad file name is entered, or the file
cannot be found or opened, the prompt is typed again, and file name entry is
again requested.
.pa
After the source file has been successfully opened, the following message will
be printed:
.sp
.ix Listing File
.im 1
        Listing File=
.sp
If a listing is to be produced, the name of the file or device which is to
receive the listing should be entered. Otherwise an empty line, indicating
"No listing desired", should be entered.  If ASM cannot create the file, an
error message is printed and the prompt is issued again.
.sp
When the listing file has been established,  the following message will be
printed:
.sp
.ix Binary File
.im 1
        Binary File=
.sp
If a binary object file is to be produced, the name of the file which is to
receive the binary must be entered,  otherwise an empty line, indicating "no
object file desired", must be entered.  If ASM cannot create the file, an
error message will be printed and the prompt will be reissued.
.sp 2
.tc
OPERATOR INPUT LINES
.ix Operator Input Lines
.sp
At this point, all files that need to be opened have been. ASM then issues
the following prompt:
.sp
.im 1
        >
.sp
and waits for input.  The user now has the option of entering as many valid
ASM source lines as desired. The assembler will save them in internal
scratch storage and process them at the beginning of each pass (as though
they were attached to the front of the source file).  This mode can be
terminated by inputting an empty line.  At that point, the assembler will
enter pass one and begin assembling the user's program.
.sp
These operator input lines are typically used for two purposes: to enter
.ix WITH
WITH directives, to establish overall listing or options selection, or to
enter
.ix EQU
EQUate directives to specify values for configuration symbols used by
conditional assembly directives embedded in the source file.
.sp
It is convenient sometimes to build an SDOS "DO" file that invokes ASM,
sets up source, listig and object files, and then specifies (as operator
input lines) a specific set of configuration parameters for the program
being assembled.  The DO file then "represents" a particular configuration
of the assembled program, and can be used to easily regenerate that
configuration.  Other DO files would represent other configurations.
.pa
Examples of use:
.sp
.in 3
.un 3
1)~The following procedure allows the user to assemble a
simple program typed in from the console.
.sp
.im 12
        ASM VERSION 1.x / xxxx
        SOURCE FILE=CONSOLE:
        LISTING FILE=MYLIST
        BINARY FILE=MYBIN
        >       ORG     $100
        >       LDX     #$FE00
        >L1     CLR     0,X
        >       INX
        >       CPX     #$FEFF
        >       BNE     L1
        >       RTS
        >       END
.sp
The program will be assembled, and a listing produced. Note that operator
input was terminated not by an empty line, but by ASM discovering the END
directive.
.sp
.un 3
2)~Assemble a file called "PROCESS.ASM", generate no listing and no binary. 
This can be useful when checking for errors. (The file name extension ".ASM"
is used purely by convention; any valid SDOS filename can be used here).
.sp
.im 5
        ASM VERSION 1.x / xxxx
        SOURCE FILE=PROCESS.ASM
        LISTING FILE=
        BINARY FILE=
        >
.sp
.un 3
3)~Assemble "PROCESS.ASM", generate no listing, but do generate a symbol
table dump in on the printer device.  The listing format used will match the
printer's width and depth as specified by the
.ix SET, SDOS
SET program.
.sp
.im 6
        ASM VERSION 1.x / xxxx
        SOURCE FILE=PROCESS.ASM
        LISTING FILE=LPT:
        BINARY FILE=
        > WITH NLST,DMP
        >
.pa
.un 3
4)~Assemble "PROCESS.ASM", generate a listing in file "PROCESS.LPT" and
specify listing page sizes, overriding the default used with files.
.sp
.im 6
        ASM VERSION 1.x / xxxx
        SOURCE FILE=PROCESS.ASM
        LISTING FILE=PROCESS.LPT
        BINARY FILE=
        > WITH WI=105,DE=51
        >
.sp
.un 3
5)~Assemble "PROCESS.ASM", generate listing as before, generate binary,
specify listing format, and define certain symbols that control conditional
assembly of PROCESS.
.sp
.im 9
        ASM VERSION 1.x / xxxx
        SOURCE FILE=PROCESS.ASM
        LISTING FILE=PROCESS.LPT
        BINARY FILE=PROCESS.BIN
        > WITH WI=105,DE=51
        >MEMSIZE EQU    $4000
        >PROGBASE EQU   $1000
        >USEFLOPPY      EQU     1
        >
.in 0
.pa
.tc
ERROR MESSAGES
.ix Error Messages
.sp
If an error is detected while processing a source file, the following
actions are taken:
.sp
.in 5
.un 2
--The line and the error messages are listed on the console, unless WITH NDO
was specified.  A printed error message refers to the line printed
immediately preceding it.
.sp
.un 2
--The line and the error messages are listed on the listing device if one was
specified.
.sp
.in 0
The following error messages can be reported:
.sp
.in 4
.un 4
*** Double Definition.
.br
The line contains an attempt to define a symbol whose value is also defined
elsewhere.  Only the first definition is honored.
.sp
.un 4
*** End of Source File Encountered.
.br
The end of the source file was encountered before an END command was seen.
.sp
.un 4
*** Illegal Argument.
.br
A bad argument field was detected.  Examples:
.im 2
       Y       EQU
               ORG
.sp
.un 4
*** Illegal Digit.
.br
Indicates the presence of a malformed number.  Examples:
.im 3
       34F
       $1HJ
       %LMN
.sp
.un 4
*** Illegal Label.
.br
An illegal label was detected.  Either the label field contains a
non-symbol, or a label was specified on a line without a command.
.sp
.un 4
*** Illegal String.
.br
Indicates an attempt to define a string that included a carriage return.
.sp
.un 4
*** Illegal Value.
.br
Usually indicates that a forward reference was present where forward
references are not allowed (see appendix A).
.sp
.un 4
*** Impossible forced reference (<< or <).
.br
Use of "<<" with ",PC", ",PCR" or "[...]" or "<" used with DPR value not
correctly set.
.sp
.un 4
*** INCLUDE file not found.
.br
INCLUDE file was not found.  INCLUDE was ignored.
.sp
.un 4
*** Input Line Too Long
.br
Input line was too long and was truncated prior to processing.
.sp
.un 4
*** Nesting Error.
.br
The line violates some rule regarding condtional assembly.  Possibilities
are:
.in 6
.sp
.un 2
--ELSE, ELSEIF or FIN encountered when no conditional
assembly block was open.
.sp
.un 2
--IF, CASE, IFUND or DO encountered that would cause
conditional assembly commands to be nested more than 255
deep.
.sp
.un 2
--The argument of an RPT command was a command which
cannot be RPT'd.
.sp
.in 4
.un 4
*** Out of Memory.
.br
Indicates that there was no room to enter a new symbol into the symbol
table.  Assembly continues, but the symbol will remain undefined throughout
the assembly.  No more error line numbers will be saved.
.sp
.un 4
*** Phase Error.
.br
Indicates that the assembler has been asked to give a symbol a different
value in pass two than it was given in pass one.  Usually caused by "Out of
Memory."
.sp
.un 4
*** Register Field Missing
.br
Indicates that a machine instruction which requires a register was written
with an undecipherable register field.
.sp
.un 4
*** Start address =0 or does not match other end(s).
.br
Start address specified has value zero (illegal under SDOS) or multiple ENDs
specified differing start addresses  (Multiple ENDS are possible when
INCLUDE is used).
.sp
.un 4
*** Syntax Error.
.br
A malformed expression or addressing mode was encountered.  Examples:
.im 4
                3+
                (
                3?7
                ADDB    O,S+
.sp
.un 4
*** Undefined Symbol.
.br
The line contains a symbol that was not defined.  This can occur with
symbols which involve more than one level of forward reference.
.sp
.un 4
*** Use of Doubly-defined Symbol.
.br
The line contains a use of a doubly-defined symbol.
.in 0
.pa
.tc
SYMBOL TABLE DUMP FORMAT
.ix Symbol Table Format
.sp
This section describes the format of ASM symbol table dumps.  The symbol
table is dumped sorted by name and by value, using a common format for the
symbol entries:
.sp
.im 16
     Qname/0123
     | |    |
     | |    ----->  This field contains the symbol's
     | |              value.  If the symbol is undefined,
     | |              this field is "****".
     | |
     | ---------->  This field contains the symbol's name.
     |
     ------------>  This field contains a qualifier
                      which gives additional
                      information about the symbol.
                    Possibilities are:
                      "*"   Indicates unused symbol.
                      "+"   Indicates doubly-defined symbol.
                      Blank indicates none of the above.

.pa
.tc
ERROR LINE SUMMARY FORMAT
.ix Error Line Summary Format
.ix Error Lines
.sp
At the end of pass two, after the symbol table dump, ASM will print out a
list of lines on which errors occurred. Each item in the list has the
following format:
.sp
.im 1
        ffff-llll
.sp
"ffff" specifies the Form number that contained the line, as printed in the
Form field of the page header.  "llll" specifies the line within that form
which was in error, as listed in the line number field of the listing.  This
is especially useful when using EDIT 1.1, as the offending line can easily
be found by telling the editor to do a "EBfilename\ffffEYllllJ", which goes
to the ffffth form, llllth line.
.sp
.tc
MEMORY USAGE AND SIZING CONSIDERATIONS
.ix Size
.ix Memory
.sp
ASM dynamically allocates memory at runtime for the following kinds of data:
.sp
.in 2
.un 2
--User-defined
.ix Symbols
symbols require at least 7 bytes of storage.  The amount used by a given
symbol will be
.br
.im 1
            6 + LEN(SYM)
where LEN(SYM) is the number of characters in the symbol name.  Only the
first thirty-two characters of a symbol name are saved.
.sp
.un 2
--Operator-input lines require an amount of space that varies with the
length of the line.  The formula is:
.im 1
            3 + LEN(LINE)
.br
where LEN(LINE) is the number of bytes in the line, including carriage
return.
.sp
.ix Error Lines
.un 2
--Saved error line numbers require 6 bytes of space each.
.in 0
.sp
ASM will automatically use all the memory between the end of ASM and the top
of the user space (see SDOS manual).
.sp
It is recommended that ASM be run on a system with at least 16K bytes of
user space.  This will allow approximately 4K bytes of usable space for ASM
runtime tables.
.sh SECTION XII: APPENDIX A - ASM DIRECTIVES WHICH DISALLOW FWD REF
.pa
.tc
APPENDIX A -- ASM Directives which Disallow Forward References:
.sp
The following directives will not allow the user to use
.ix Forward Reference
forward references in their argument lists:
.ix CASE
.IX DO
.IX TABS
.IX SPACE
.IX SETDPR
.IX SET
.IX RPT
.IX RMP
.IX PSR
.IX PGEN
.IX PCC
.IX PCA
.IX ORG
.IX IF
.IX ELSEIF
.sp
.im 15
        CASE
        DO
        ELSEIF
        IF
        ORG
        PCA
        PCC
        PGEN
        PSR
        RMB
        RPT
        SET
        SETDPR
        SPACE
        TABS
.sh SECTION XIII: APPENDIX B - ASCII CHARACTER SET
.pa
.tc
APPENDIX B -- ASCII Character Set
.ix ASCII Character Set
.sp
.im 20
   |   $00  |  $10  |  $20 |  $30  |  $40  |  $50  |  $60  |  $70  |
---+--------+-------+------+-------+-------+-------+-------+-------+
$0 |   NUL  |  DLE  | BLANK|   0   |   @   |   P   |   `   |   p   |
$1 |   SOH  |  DC1  |  !   |   1   |   A   |   Q   |   a   |   q   |
$2 |   STX  |  DC2  |  "   |   2   |   B   |   R   |   b   |   r   |
$3 |   ETX  |  DC3  |  #   |   3   |   C   |   S   |   c   |   s   |
$4 |   EOT  |  DC4  |  $   |   4   |   D   |   T   |   d   |   t   |
$5 |   ENQ  |  NAK  |  %   |   5   |   E   |   U   |   e   |   u   |
$6 |   ACK  |  SYN  |  &   |   6   |   F   |   V   |   f   |   v   |
$7 |   BEL  |  ETB  |  '   |   7   |   G   |   W   |   g   |   w   |
$8 |   BS   |  CAN  |  (   |   8   |   H   |   X   |   h   |   x   |
$9 |   TAB  |  EM   |  )   |   9   |   I   |   Y   |   i   |   y   |
$A |   LF   |  SUB  |  *   |   :   |   J   |   Z   |   j   |   z   |
$B |   VT   |  ESC  |  +   |   ;   |   K   |   {   |   k   |   {   |
$C |   FF   |  FS   |  ,   |   <   |   L   |   \   |   l   |   |   |
$D |   CR   |  GS   |  -   |   =   |   M   |   }   |   m   |   }   |
$E |   SO   |  RS   |  .   |   >   |   N   |   ^   |   n   |   ~   |
$F |   SI   |  US   |  /   |   ?   |   O   |   _   |   o   |  RO   |
---+--------+------+-------+-------+-------+-------+-------+-------+

.sh SECTION XIV: APPENDIX C - I/O ERROR MESSAGES
.pa
.tc
APPENDIX C -- Common I/O Error Messages
.ix I/O Errors
.ix Errors, I/O
.sp
.im 6
ERROR          MEANING

1011           Can't find file
1015           Disk space exhausted
1023           File name doesn't start with A-Z or $
1034           Illegal Device operation requested
.sp 2
Error 1034 generally indicates that an output-only device has been
specified as the source file, or that an input-only device
has been specified as the listing or binary file.
.sh SECTION XV: APPENDIX D - 680C COMPATIBILITY INSTRUCTION SET
.pa
APPENDIX D - 680C Compatibility Instruction Set
.ix 680C
.tc
.tb 10,20,30,40,50
.sp 2
The 680C is an imaginary processor whose instruction set includes most of
the 6800, 6801, 6802, and 6803 instruction sets (the exceptions are those
instructions dealing with processor context). Many of the 6809 functions are
supported by the 680C. In addition, the 680C instruction set includes some
instructions which don't exist on any of the real 680x processors, but
implement frequently-used code sequences.  Note: the 6805 is NOT covered by
680C.
.sp
The value of the 680C is that code written using its instruction set will
execute on any of the 680x processors, although more efficiently on some
than on others.  This means that some features of the more advanced
processors may be used, while preserving backward compatibility with earlier
processors through emulation of the advanced instructions.
.sp
The ASM6800 and ASM6809 assemblers both accept 680C instructions. ASM6809,
of course, also accepts the balance of the 6809 instruction set. The
emulation feature of the 680C assembler is a two-edged sword: on the one
hand, it offers a consistent instruction set across the family of 680x
processors; on the other hand, emulated instructions often have side-effects
of which the coder should be aware.  Overall, the value gained from a
consistent instruction set outweighs the constraints introduced by the
emulation of instructions.
.sp
In certain cases, the emulation constraints are untenable.  The coder then
has recourse to conditional assembly:
.sp
.im 7
        IF      M6800
        ...
        ELSEIF  M6801
        ...
        ELSEIF  M6809
        ...
        FIN
.sp
to produce code sequences optimized for a particular processor.
.sp
Note that the meaning of a 680C istruction is the intersection of the
meanings of the implementations of the 680C instruction on all processors;
this generally means that many 680C instructions leave the condition code
bits in an undefined state.  Other side effects are also possible, such as
damage to X register contents or the memory location TEMPX.
.pa
The 680C instruction set includes nearly all of the 6800/6801 instructions,
a good portion of the 6809 instruction set (replete with many of the more
popular addressing modes), and a few new instructions added, due to popular
demand.
.sp
First, all 6800 instructions except the following are included in 680C:
.sp
.im 1
        TAP     TPA     WAI
.sp
The following 6801 instructions are included in 680C (thus allowing their
use on the 6800):
.sp
.nf
.im 3
        ABX     ADDD    ASLD    BHS     BLO
        LDD     LSLD    LSRD    MUL     PSHX
        PULX    STD     SUBD
.sp
.fo
The entire set of 6809 long conditional branches (except LBRN) are included
in 680C.
.sp
For the instructions
.sp
.nf
.SP
.IM 4
        ADCD    ADDD    ANDD    CMPD    DECD
        EORD    INCD    LDA     LDB     LDD
        ORA     ORB     ORD     SBCD    STA        
        STB     STD     SUBD
.fo
.sp
most of the 6809 addressing modes may be used.  The ones that may not be
used are:
.ix Addressing, 680C
.sp
.in 9
accumulator-offset~indexed
.sp
program~counter~relative
.sp
indexing using registers U, Y, PC or PCR
.sp
.un 9
Additional limitations are:
.sp
constant offsets may be positive only, and must be in the range $00 - $FF
.sp
auto post-increment is not allowed in the indirect addressing mode
.in 0
.sp
.fo
.pa
The following 6809 instructions are implemented in a limited fashion:
.sp
.nf
.im 2
                LEAX    k,X
                LEAS    k,S
.fo
.sp
where -16 <= k <=15.  Note that the destination and index registers must be
the same for each instance of the instruction.
.sp
The 6809 instructions
.sp
.ix TFR
.im 2
                TFR     A,B
                TFR     B,A
.sp
are allowed.  No other TFR class instruction is allowed.  Note that 680C TFR
leaves the CC bits (except carry) undefined.  TAB and TBA can be used if
setting the CC bits is desired, but TFR is faster otherwise.
.pa
The 6809 instruction CMPD, subject to the addressing and conditional
branch restrictions above, is included in 680C.  Only the instructions
.sp
.im 4
        BEQ     LBEQ    BNE     LBNE    BCC
        LBCC    BCS     LBCS    BHI     LBHI
        BLS     LBLS    BLO     LBLO    BHS
        LBHS
.sp
may immediately follow the CMPD instruction.
.sp
The instructions
.sp
.nf
.im 1
        JMP     JSR
.fo
.sp
are allowed, but cannot have auto post-increment of any kind,
in any addressing mode.
.sp
The following 6809 instructions are not allowed.  All instructions using the
U or Y registers are implicit members of this list:
.sp
.nf
.im 4
        ANDCC   BRN     CMPS    CWAI    EXG
        LBRN    LBSR    ORCC    PSHS    PSHU
        PULS    PULU    SEX     SWI2    SWI3
        SYNC
.fo
.ju
.pa
Instructions peculiar to the 680C (and their equivalent expansions) are:
.sp
.nf
.tb 5,10,15,40,45,50,55
.im 55
        NEGD                    COMD
                NEGA                    COMB
                NEGB                    COMA
                SBCA    #0

        ORD                     EORD
                ORAB    arg+1           EORB    arg+1
                ORAA    arg             EORA    arg

        INCD    arg             DECD    arg
                INC     arg+1           TST     arg+1
                BNE     x               BNE     x
                INC     arg             DEC     arg
          x:                      x:    DEC     arg+1

        OKRTS                   ERRORTS
                CLC                     SEC
                RTS                     RTS

        ROLD                    RORD
                ROLB                    RORA
                ROLA                    RORB

        TDX                     TXD
                STAA    TEMPA           STX     TEMPX
                STAB    TEMPB           LDAA    TEMPA
                LDX     TEMPX           LDAB    TEMPB

        TDS                     TSD
                TDX                     TSX
                TXS                     TXD

        ASRD                    SBCD    arg
                ASRA                    SBCB    arg+1
                RORB                    SBCA    arg

        ADCD    arg             ANDD    arg
                ADCB    arg+1           ANDB    arg+1
                ADCA    arg             ANDA    arg

        BNED    arg             BEQD    arg
                IF      \M6809          IF      \M6809
                BNE     arg             BNE     x
                TSTB                    TSTB                    
                FIN                     FIN
                BNE     arg             BEQ     arg
                                  x:

        PULD                    PSHD
                PULA                    PSHB
                PULB                    PSHA
        TSTD                    TSTD
                TSTB    6800/6801       SUBD    #0 6809
                BNE     *+3
                TSTA
.tb 20,30,40,50,60
.fo
.sp
NOTE:  The instructions BEQD and BNED may be used only immediately
following:
.sp
.nf
.im 3
        ORD     EORD    ADDD    SUBD    ADCD
        SBCD    LDD     STD     ASLD    ROLD
        COMD    NEGD    ANDD
.fo
.sp
.in 0
Side effects to watch for using 680C:
.sp
.ix Side Effects, 680C
The side effects should be "obvious" if careful thought is given to the
problem of making 680C code work on any of the 680x processors.
.sp
The contents of the X register will be undefined after execution of a 680C
instruction that uses S as an index register (except LEAS), or uses
indirection ("[" "]") in an addressing mode.
.sp
Use of auto-increment in an instruction leaves the condition codes in an
undefined state.
.sp
The MUL instruction will alter the location TEMPX (**).
.sp
The PSHX instruction will alter the B register and the location TEMPX (**).
.sp
The TXD instruction will alter location TEMPX (**).
.sp
The ABX instruction will alter the B register and the location TEMPX (**).
.sp
The TDX instruction will alter location TEMPX (**).
.sp
The CPX instruction will alter the carry condition.
.sp
.ix TFR
The TFR instruction will alter all arithmetic conditions, except carry.
.sp
The memory locations $00 - $18 do not exist on the 680C,
as this would be incompatible with the 6801.
.sp 2
Double-register instruction operations are not indivisible with respect to
interrupts.
.sp
(**) These instructions should NEVER be used in interrupt service
routines.  The instruction sequence interrupted may use TEMPX.
.pa
Sample 680C code (works on 6800, 6801 and/or 6809:)
.sp
.im 14
* Search BUFFER in blocks of 4 for word TARGET
SEARCHBUFFER
        LDD     WORD            ; Note we can do this on 6800!
        LDX     #BUFFEREND+2
SEARCHBUFFERLOOP
        LEAX    -2,X
        CMPX    #BUFFERBASE     ;buffer searched?
        BEQ     SEARCHBUFFERFAIL        ;b/ yes, didn't find it
        CMPD    ,--X            ; CMPD ,X+++ would destroy CC bits
        BNE     SEARCHBUFFERLOOP        ; note use of BNE, not BNED here!
        RTS                     ; assent: carry is reset

SEARCHBUFFERFAIL                ; signal fail: exit with carry set
        ERRORRTS
.pa
.sp
.of 7
NOTE:~~When the target processor of an assembly is a 6800, the MUL
instruction is emulated by emitting a
.of
.sp
.ix Multiply
.nf
                JSR     MUL6809
.fo
.sp
.in 7
instruction.  The user is responsible for supplying that code --
preferably using conditional assembly:
.in
.sp
.nf
.PW 120
.LL 100
.im 2
                IF      M6800
                .
.LL 65
.PW 85
.tb 15,23,30
.nf
.sp
.im 39
        *       MUL6809 -- Subroutine to simulate 6809 style
        *                  "MUL" instruction
        *
        MUL6809 STAA    TEMPA   Save multiplicand
                RORB            Look at first multiplier bit
                BCS     *+3     B/ 1st bit is one!
                CLRA            1st mult. bit is 0, set part. prod.
                LSRA            Perform multiply iteration
                RORB
                BCC     *+4
                ADDA    TEMPA
                RORA
                RORB
                BCC     *+4
                ADDA    TEMPA
                RORA
                RORB
                BCC     *+4
                ADDA    TEMPA
                RORA
                RORB
                BCC     *+4
                ADDA    TEMPA
                RORA
                RORB
                BCC     *+4
                ADDA    TEMPA
                RORA
                RORB
                BCC     *+4
                ADDA    TEMPA
                RORA
                RORB
                BCC     *+4
                ADDA    TEMPA
                RORA
                RORB
                RTS
                FIN

.sh
.pa
.np
.pc
.ce
TABLE OF CONTENTS
.sp 3
INTRODUCTION
~~~ASM -- A SMART ASSEMBLER ON A LITTLE MACHINE
~~~NOTATION DEFINITION
~~~GENERAL DISCUSSION
.sp
SOURCE FILE FORMAT
~~~LINE FORMAT
~~~LABEL FIELD (OR LF)
~~~COMMAND FIELD (OR CF)
~~~ARGUMENT FIELD (OR AF)
~~~COMMENT FIELD
~~~SOURCE LINE NUMBERS
.sp
EXPRESSIONS
~~~VALUES
~~~~~~MANIFEST VALUES
~~~~~~~~~DECIMAL NUMBERS
~~~~~~~~~BINARY NUMBERS
~~~~~~~~~OCTAL NUMBERS
~~~~~~~~~HEXADECIMAL NUMBERS
~~~~~~~~~CHARACTER VALUES
~~~~~~IMPLICIT VALUES
~~~~~~~~~THE "*" VALUE
~~~~~~~~~THE "*'" VALUE
~~~~~~~~~SYMBOLS
~~~~~~~~~~~~RESERVED SYMBOLS
~~~~~~~~~~~~PRE-DEFINED SYMBOLS
~~~~~~~~~~~~FORWARD REFERENCES
~~~~~~COMPUTATION
~~~~~~~~~MONADIC OPERATORS
~~~~~~~~~DYADIC OPERATORS
~~~~~~~~~COMPLEX EXPRESSIONS
~~~~~~~~~OPERATOR HEIRARCHY
~~~~~~~~~PARENTHESES
.sp
LINE PROCESSING
.sp
6800/6801 MACHINE INSTRUCTION LINES
~~~INHERENT MODE OPCODES
~~~REGISTER-REGISTER MODE
~~~DIRECT MODE
~~~EXTENDED MODE
~~~EXTENDED INDIRECT MODE
~~~INDEXED MODE
~~~ZERO OFFSET INDEXED MODE
~~~8-BIT CONSTANT OFFSET INDEXED MODE
~~~AUTO INCREMENT/DECREMENT INDEXED MODE
~~~RELATIVE MODE
~~~IMMEDIATE MODE
~~~OPCODE MNEMONICS RECOGNIZED
.pa
6809 MACHINE INSTRUCTION LINES
~~~INHERENT MODE
~~~REGISTER-REGISTER MODE
~~~DIRECT MODE
~~~EXTENDED MODE
~~~EXTENDED INDIRECT MODE
~~~INDEXED MODE
~~~ZERO OFFSET INDEXED MODE
.im 1
   5-, 8-, AND 16-BIT CONSTANT
~~~OFFSET INDEXED MODE
~~~PROGRAM COUNTER RELATIVE (INDEXED) MODE
~~~ACCUMULATOR OFFSET INDEXED MODE
~~~AUTO INCREMENT/DECREMENT INDEXED MODE
~~~RELATIVE MODE
~~~IMMEDIATE MODE
~~~STACK MODE
~~~OPCODE MNEMONICS RECOGNIZED
.sp
6805 MACHINE INSTRUCTION LINES
~~~INHERENT MODE
~~~DIRECT MODE
~~~EXTENDED MODE
~~~INDEXED MODE
~~~ZERO OFFSET INDEXED MODE
~~~8-BIT AND 16-BIT OFFSET INDEXING MODES
~~~RELATIVE MODE
~~~IMMEDIATE MODE
~~~BIT MODE
~~~OPCODE MNEMONICS RECOGNIZED BY ASM 6805
.sp
DIRECTIVES
.sp
SYMBOL DEFINITION DIRECTIVES
~~~EQUATE (EQU)
~~~IMPLICIT EQUATE (EQU)
~~~SET
.sp
DATA GENERATION DIRECTIVES
~~~FORM CONSTANT BYTE
~~~RESERVE MEMORY BYTES
~~~FORM DOUBLE BYTE CONSTANT
~~~FORM CONSTANT CHARACTERS
~~~FORM FLOATING POINT NUMBERS
~~~IMPLICIT DATA STATEMENT
~~~SET LOCATION COUNTER
~~~SET DATA PAGE REGISTER
.pa
CONDITIONAL ASSEMBLY DIRECTIVES
~~~SIMPLE CONDITIONAL ASSEMBLY
~~~ALTERNATIVE ASSEMBLY
~~~NESTED CONDITIONAL ASSEMBLY
~~~MORE COMPLICATED CONDITIONAL ASSEMBLY
~~~MULTI-CASE CONDITIONAL ASSEMBLY
~~~CONDTIONAL ASSEMBLY ON UNDEFINED SYMBOLS
~~~CONDITIONAL ASSEMBLY ON DEFINED SYMBOLS
.sp
FULL DESCRIPTION OF CONDITIONAL ASSEMBLY COMMANDS
~~~THE "IF" DIRECTIVE
~~~CLOSE CONDITIONAL ASSEMBLY BLOCK
~~~CONDITIONAL ASSEMBLY WITH CHECK
~~~IF SYMBOL NOT DEFINED
~~~IF SYMBOL DEFINED
~~~THE ELSE DIRECTIVE
~~~CONDITIONAL ELSE
~~~CASE CONDITIONAL ASSEMBLY
.sp
SINGLE LINE ITERATIVE ASSEMBLY
.sp
ASSEMBLY CONTROL DIRECTIVES
~~~TERMINATE SOURCE FILE
~~~SELECT ASSEMBLY OPTIONS
~~~THE OPT STATEMENT
~~~THE INCLUDE STATEMENT
.sp
LISTING CONTROL AND FORMATTING
~~~PAGE HEADING FORMAT
~~~LINE LISTING FORMAT
~~~PRINT CONTROL CARDS
~~~TURN LISTING ON/OFF
~~~SET TITLE AND EJECT PAGE
~~~SET SUBTITLE AND EJECT PAGE
~~~SET NAME
~~~SPACE LISTING N LINES
~~~SET LISTING TABS
~~~PRINT SKIPPED RECORDS
~~~PRINT GENERATED DATA
~~~PRINT CONDITIONAL ASSEMBLY COMMANDS
.sp
OPERATING ASM
~~~STARTING ASM
~~~OPERATOR INPUT LINES
~~~ERROR MESSAGES
~~~SYMBOL TABLE DUMP FORMAT
~~~ERROR LINE SUMMARY FORMAT
~~~MEMORY USAGE
.pa
.ce
APPENDICES
.sp
.im 1
APPENDIX A -- ASM DIRECTIVES
~~~WHICH DISALLOW FORWARD REFERENCES
.sp
APPENDIX B -- ASCII CHARACTER SET
.sp
APPENDIX C -- I/O ERROR MESSAGES
.SP
.IM 1
APPENDIX D -- 680C COMPATIBILITY
~~~INSTRUCTION SET
.pc
.pa
.me
.en
