                         REGISTER/MEMORY INSTRUCTIONS


                          ADDRESSING MODES
--------------------------------------------------------------------------------------------------------------
                                                  INDEXED     INDEXED    INDEXED      /CONDITION CODE
                        IMMEDIATE/DIRECT/EXTENDED/NO OFFSET/8-BIT OFFSET/16-BIT OFFSET/H/I/N/Z/C
FUNCTION          /MNEM./OP/#/~/ OP/#/~/ OP/ #/~ /OP/ #/ ~ /    OP/ #/~ /OP/ #/ ~/
-------------------------------------------------------------------------------------------------------------
LOAD A FROM MEMORY /LDA/A6 2 2  B6 2 4   C6 3  5  F6 1  4       E6  2 5  D6  3 6      /*/*/^/^/*
LOAD X FROM MEMORY /LDX/AE 2 2  BE 2 4   CE 3  5  FE 1  4       EE  2 5  DE  3 6      /*/*/^/^/*
STORE A IN MEMORY  /STA/-  - -  B7 2 5   C7 3  6  F7 1  5       E7  2 6  D7  3 7      /*/*/^/^/*
STORE X IN MEMORY  /STX/-  - -  BF 2 5   CF 3  6  FF 1  5       EF  2 6  DF  3 7      /*/*/^/^/*
ADD MEMORY TO A    /ADD/AB 2 2  BB 2 4   CB 3  5  FB 1  4       EB  2 5  DB  3 6      /^/*/^/^/^
ADD MEMORY AND
CARRY TO A         /ADC/A9 2 2  B9 2 4   C9 3  5  F9 1  4       E9  2 5  D9  3 6      /^/*/^/^/^
SUBTRACT MEMORY    /SUB/A0 2 2  B0 2 4   C0 3  5  F0 1  4       E0  2 5  D0  3 6      /*/*/^/^/^
SUBTRACT MEMORY
FROM A WITH BORROW /SBC/A2 2 2  B2 2 4   C2 3  5  F2 1  4       E2  2 5  D2  3 6      /*/*/^/^/^
AND MEMORY TO A    /AND/A4 2 2  B4 2 4   C4 3  5  F4 1  4       E4  2 5  D4  3 6      /*/*/^/^/*
OR MEMORY WITH A   /ORA/AA 2 2  BA 2 4   CA 3  5  FA 1  4       EA  2 5  DA  3 6      /*/*^/^/*
EXCLUSIVE OR MEMORY
WITH A             /EOR/A8 2 2  B8 2 4   C8 3  5  F8 1  4       E8  2 5  D8  3 6      /*/*/^/^/*
ARITHMETIC COMPARE
A WITH MEMORY      /CMP/A1 2 2  B1 2 4   C1 3  5  F1 1  4       E1  2 5  D1  3 6      /*/*/^/^/^
ARITHMETIC COMPARE
X WITH MEMORY      /CPX/A3 2 2  B3 2 4   C3 3  5  F3 1  4       E3  2 5  D3  3 6      /*/*/^/^/^
BIT TEST MEMORY
WITH A (LOGICAL
COMPARE)           /BIT/A5 2 2  B5 2 4   C5 3  5  F5 1  4       E5  2 5  D5  3 6      /*/*^/^/*
JUMP UNCONDITIONAL /JMP/-  - -  BC 2 3   CC 3  4  FC 1  3       EC  2 4  DC  3 5      /*/*/*/*/*
JUMP TO SUBROUTINE /JSR/-  - -  BD 2 7   CD 3  8  FD 1  7       ED  2 8  DD  3 9      /*/*/*/*/*
---------------------------------------------------------------------------------------------------------------

                       READ/MODIFY/WRITE INSTRUCTIONS

                            ADDRESSING MODES
                                                          INDEXED    INDEXED      CONDITION
                           INHERENT(A) INHERENT(X) DIRECT (NO OFFSET)(8 BIT OFFSET)/  CODE
FUNCTION           /MNEM./OP / # / ~  /OP / # /~ /OP /#/~/OP /# / ~ /OP / #/ ~      H/I/N/Z/C/
------------------------------------------------------------------------------------------------------------------
INCREMENT          /INC  /4C  1   4    5C   1  4  3C  2 6 7C  1   6  6C  2   7     /*/*^/^/*
DECREMENT          /DEC  /4A  1   4    5A   1  4  3A  2 6 7A  1   6  6A  2   7     /*/*/^/^/*
CLEAR              /CLR  /4F  1   4    5F   1  4  3F  2 6 7F  1   6  6F  2   7     /*/*/0/1/*
COMPLEMENT         /COM  /43  1   4    53   1  4  33  2 6 73  1   6  63  2   7     /*/*/^/^/1
NEGATE (2'S
COMPLEMENT)        /NEG  /40  1   4    50   1  4  30  2 6 70  1   6  60  2   7     /*/*/^/^/^
ROTATE LEFT THRU
CARRY              /ROL  /49  1   4    59   1  4  39  2 6 79  1   6  69  2   7     /*/*/^/^/^
ROTATE RIGHT THRU
CARRY              /ROR  /46  1   4    56   1  4  36  2 6 76  1   6  66  2   7     /*/*/^/^/^
LOGICAL SHIFT LEFT /LSL  /48  1   4    58   1  4  38  2 6 78  1   6  68  2   7     /*/*/^/^/^
LOGICAL SHIFT RIGHT/LSR  /44  1   4    54   1  4  34  2 6 74  1   6  64  2   7     /*/*/0/^/^
ARITHMETIC SHIFT
RIGHT              /ASR  /47  1   4    57   1  4  37  2 6 77  1   6  67  2   7     /*/*/^/^/^
TEST FOR NEGATIVE
OR ZERO            /TST  /4D  1   4    5D   1  4  3D  2 6 7D  1   6  6D  2   7     /*/*/^/^/*
---------------------------------------------------------------------------------------------------------------------


                        BIT MANIPULATION INSTRUCTIONS

                             ADDRESSING MODES
-----------------------------------------------------------------------------------------------------------------
                                                BIT TEST AND
                                  BIT SET/CLEAR    BRANCH       CONDITION CODE
FUNCTION          / MNEM.          OP / #/ ~/   OP CODE/ #/ ~/  H/I/N/Z/C
------------------------------------------------------------------------------
BRANCH IFF BIT
n IS SET          /BRSET n(n=0...7)/-  -   -/     2*n   3  10   */*/*/*/^
BRANCH IFF BIT
n IS CLEAR        /BRCLR n(n=0...7)/-  -   -/  01+2*n   3  10   */*/*/*/^
SET BIT n         /BSET n(n=0...7) /10+2*n/2/7/  -      -  -    */*/*/*/*
CLEAR BIT n       /BCLR n(n=0...7  /11+2*n/2/7/  -      -  -    */*/*/*/*
---------------------------------------------------------------------------------------------------------


                           CONTROL INSTRUCTIONS

                                INHERENT
FUNCTION           MNEMONIC    OP  /  #  /  ~  /  CONDITION CODE
                                                  H/I/N/Z/C
TRANSFER A TO X       TAX      97     1     2     */*/*/*/*
TRANSFER X TO A       TXA      9F     1     2     */*/*/*/*
SET CARRY BIT         SEC      99     1     2     */*/*/*/1
CLEAR CARRY BIT       CLC      98     1     2     */*/*/*/0
SET INTERRUPT
MASK BIT              SEI      9B     1     2     */1/*/*/*
CLEAR INTERRUPT
MASK BIT              CLI      9A     1     2     */0/*/*/*
SOFTWARE INTERRUPT    SWI      83     1     11    */1/*/*/*
RETURN FROM
SUBROUTINE            RTS      81     1     6     */*/*/*/*
RETURN FROM
INTERRUPT             RTI      80     1     9     ?/?/?/?/?
RESET STACK POINTER   RSP      9C     1     2     */*/*/*/*
NO-OPERATION          NOP      9D     1     2     */*/*/*/*
------------------------------------------------------------------------------------------------------------

CONDITION CODE SYMBOLS

H  HALF CARRY (from bit 3)
I  INTERRUPT MASK
N  NEGATIVE (sign bit)
Z  ZERO
C  CARRY/BORROW
*  NOT AFFECTED
^  TEST AND SET IF TRUE, CLEARED OTHERWISE
?  LOAD CC REGISTER FROM STACK
0  BIT=0 (cleared)
1  BIT=1 (set)

-----------------------------------------------------------------------------------------------------------

                            BRANCH INSTRUCTIONS

                                        RELATIVE
                                     ADDRESSING MODE     CONDITION CODE
FUNCTION               MNEMONIC       OP / # / ~ /         H/I/N/Z/C
BRANCH ALWAYS            BRA          20   2   4           */*/*/*/*
BRANCH NEVER             BRN          21   2   4           */*/*/*/*
BRANCH IFF HIGHER        BHI          22   2   4           */*/*/*/*
BRANCH IFF LOWER
OR SAME                  BLS          23   2   4           */*/*/*/*
BRANCH IFF CARRY CLEAR   BCC          24   2   4           */*/*/*/*
(BRANCH IFF HIGHER
OR SAME)                (BHS)         24   2   4           */*/*/*/*
BRANCH IFF CARRY SET     BCS          25   2   4           */*/*/*/*
(BRANCH IFF LOWER)      (BLO)         25   2   4           */*/*/*/*
BRANCH IFF NOT EQUAL     BNE          26   2   4           */*/*/*/*
BRANCH IFF EQUAL         BEQ          27   2   4           */*/*/*/*
BRANCH IFF HALF CARRY
CLEAR                    BHCC         28   2   4           */*/*/*/*
BRANCH IFF HALF CARRY
SET                      BHCS         29   2   4           */*/*/*/*
BRANCH IFF PLUS          BPL          2A   2   4           */*/*/*/*
BRANCH IFF MINUS         BMI          2B   2   4           */*/*/*/*
BRANCH IFF INTERRUPT
MASK BIT IS CLEAR        BMC          2C   2   4           */*/*/*/*
BRANCH IFF INTERRUPT
MASK BIT IS SET          BMS          2D   2   4           */*/*/*/*
BRANCH IFF INTERRUPT
LINE IS LOW              BIL          2E   2   4           */*/*/*/*
BRANCH IFF INTERRUPT
LINE IS HIGH             BIH          2F   2   4           */*/*/*/*
BRANCH TO SUBROUTINE     BSR          AD   2   8           */*/*/*/*




























