                  6809 ADDRESSING MODES
------------------------------------------------------------------------------
              INHERENT /DIRECT /  EXTENDED /IMMEDIATE/INDEXED / RELATIVE/ 5/3/2/1/0  /DESRIPTION
INSTRUCTION/  -----------------------------------------------------------------
    FORMS     OP/ ~/ #/ OP/ ~/ #/ OP/ ~/ #/ OP/ ~/ #/ OP/ ~/ #/ OP/ ~/ #/ H/N/Z/V/C
------------------------------------------------------------------------------
ABX           3A  3  1                                                    */*/*/*/*  /B + X- X
ADC  ADCA               99  4 2   B9  5 3   89  2 2   A9 4+ 2+            !/!/!/!/!  /A+M+C-A
     ADCB               D9  4 2   F9  5 3   C9  2 2   E9 4+ 2+            !/!/!/!/!  /B+M+C-B
ADD  ADDA               9B  4 2   BB  5 3   8B  2 2   AB 4+ 2+            !/!/!/!/!  /A+M-A
     ADDB               DB  4 2   FB  5 3   CB  2 2   EB 4+ 2+            !/!/!/!/!  /B+M-B
     ADDD               D3  6 2   F3  7 3   C3  4 3   E3 6+ 2+            !/!/!/!/!  /D+M:M+1 -D
AND  ANDA               94  4 2   B4  5 3   84  2 2   A4 4+ 2+            */!/!/0/*  /A^M A
     ANDB               D4  4 2   F4  5 3   C4  2 2   E4 4+ 2+            */!/!/0/*  /B^M B
     ANDCC                                  1C  3 2                        / / / /1  /CC^ IMM - CC
ASL  ASLA     48  2  1                                                    8/!/!/!/!  /A
     ASLB     58  2  1                                                    8/!/!/!/!  /B
     ASL                08  6 2   78  7 3             68 6+ 2+            8/!/!/!/!  /M
ASR  ASRA     47  2 1                                                     8/!/!/*/!  /A
     ASR      57  2 1                                                     8/!/!/*/!  /B
     ASR                07  6 2   77  7 3             67 6+ 2+            8/!/!/*/!  /M

BCC  BCC                                                        24  3   2 */*/*/*/*  /BRANCH C=0
     LBCC                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH
                                                                24                    C=0
BCS  BCS                                                        25  3   2 */*/*/*/*  /BRANCH C=1
     LBCS                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH
                                                                2                     C=1
BEQ  BEQ                                                        27  3   2 */*/*/*/*  /BRANCH Z=0
     LBEQ                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH
                                                                27                    Z=0
BGE  BGE                                                        2C  3   2 */*/*/*/*  /BRANCH >-ZERO
     LBGE                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH >-
                                                                2C                    ZERO
BGT  BGT                                                        2E  3   2 */*/*/*/*  /BRANCH > ZERO
     LBGT                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH >
                                                                2E                    ZERO
BHI  BHI                                                        22  3   2 */*/*/*/*  /BRANCH HIGHER
     LBHI                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH
                                                                22                    HIGHER
BHS  BHS                                                        24  3   2 */*/*/*/*  /BRANCH HIGHER
                                                                                      OR SAME
LBHS                                                       10 5(6) 4      */*/*/*/*  /LONG BRANCH
                                                                24                    HIGHER OR SAME
BIT  BITA               95  4 2   B5  5 3   85 2 2    A5 4+ 2+            */!/!/0/*  /BIT TEST A(M^A)
     BITB               D5  4 2   F5  5 3   C5 2 2    E5 4+ 2+            */!/!/0/*  /BIT TEST B(M^B)
BLE  BLE                                                        2F  3   2 */*/*/*/*  /BRANCH <-ZERO
     LBLE                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH <-
                                                                2F                    ZERO
BLO  BLO                                                        25  3   2 */*/*/*/*  /BRANCH LOWER
     LBLO                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH
                                                                25                    LOWER
BLS  BLS                                                        23  3   2 */*/*/*/*  /BRANCH LOWER
                                                                                      OR SAME
     LBLS                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH
                                                                23                    LOWER OR SAME
BLT  BLT                                                        2D  3   2 */*/*/*/*  /BRANCH <ZERO
     LBLT                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH <
                                                                2D                    ZERO
BMI  BMI                                                        2B  3   2 */*/*/*/*  /BRANCH MINUS
     LBMI                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH
                                                                2B                    MINUS
BNE  BNE                                                        26  3   2 */*/*/*/*  /BRANCH Z = 0
     LBNE                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH
                                                                26                    Z=0
BPL  BPL                                                        2A  3   2 */*/*/*/*  /BRANCH PLUS
     LBPL                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH
                                                                2A                    PLUS
BRA  BRA                                                        20  3   2 */*/*/*/*  /BRANCH ALWAYS
     LBRA                                                       16  5   3 */*/*/*/*  /LONG BRANCH ALWAYS
BRN  BRN                                                        21  3   2 */*/*/*/*  /BRANCH NEVER
     LBRN                                                       10  5   4 */*/*/*/*  /LONG BRANCH NEVER
                                                                21
BSR  BSR                                                        8D  7   2 */*/*/*/*  /BRANCH TO SUBROUTINE
     LBSR                                                       17  9   3 */*/*/*/*  /LONG BRANCH TO SUBROUTINE
BVC  BVC                                                        28  3   2 */*/*/*/*  /BRANCH V=0
     LBVC                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH
                                                                28                    V=0
BVS  BVS                                                        29  3   2 */*/*/*/*  /BRANCH  V=1
     LBVS                                                       10 5(6) 4 */*/*/*/*  /LONG BRANCH
                                                                29                    V=1
CLR  CLRA     4F  2 1                                                     */0/1/0/0  /0 A
     CLRB     5F  2 1                                                     */0/1/0/0  /0 B
     CLR                0F  6  2   7F  7 3           6F 6+ 2+             */0/1/0/0  /0 M
CMP  CMPA               91  4  2   B1  5 3  81 2 2   A1 4+ 2+             8/!/!/!/!  /COMPARE M FROM A
     CMPB               D1  4  2   F1  5 3  C1 2 2   E1 4+ 2+             8/!/!/!/!  /COMPARE M FROM B
     CMPD               10  7  3   10  8 4  10 5 4   10 7+ 3+             */!/!/!/!  /COMPARE M:M + 1
                        93         B3       83       A3                                  FROM D
     CMPS               11  7  3   11  8 4  11 5 4   11 7+ 3+             */!/!/!/!  /COMPARE M:M + 1
                        9C         BC       8C       AC                               FROM S
     CMPU               11  7  3   11  8 4  11 5 4   11 7+ 3+             */!/!/!/!  /COMPARE M:M + 1
                        93         B3       83       A3                               FROM U
     CMPX               9C  6  2   BC  7 3  8C 4 3   AC 6+ 2+             */!/!/!/!  /COMPARE M:M + 1
                                                                                      FROM X
     CMPY               10  7  3   10  8 4  10 5 4   10 7+ 3+             */!/!/!/!  /COMPARE M:M + 1
                        9C         BC       8C       AC                               FROM Y
COM  COMA     43  2 1                                                     */!/!/0/1  /A A
     COMB     53  2 1                                                     */!/!/0/1  /B B
     COM                03  6  2   73  7 3           63 6+ 2+             */!/!/0/1  /M M
CWAI          3C 20 2                                                      / / / /1  /CC ^ IMM  CC;
                                                                           WAIT FOR INTERRUPT
DAA           19  2 1                                                     */!/!/0/!  /DECIMAL ADJUST A
DEC  DECA     4A  2 1                                                     */!/!/!/*  /A - 1  A
     DECB     5A  2 1                                                     */!/!/!/*  /B - 1  B
     DEC                0A  6  2   7A  7 3           6A 6+ 2+             */!/!/!/*  /M - 1  M
EOR  EORA               98  4  2   B8  5 3  88 2 2   A8 4+ 2+             */!/!/0/*  /A - M  A
     EORB               D8  4  2   F8  5 3  C8 2 2   E8 4+ 2+             */!/!/0/*  /B - M  B
EXG  R1,R2    1E  7 2                                                     */*/*/*/*  /R1 R2
INC  INCA     4C  2 1                                                     */!/!/!/*  /A + 1  A
     INCB     5C  2 1                                                     */!/!/!/*  /B + 1  B
     INC                0C  6  2   7C  7 3           6C 6+ 2+             */!/!/!/*  /M + 1  M
JMP                     0E  3  2   7E  4 3           6E 3+ 2+             */*/*/*/*  /EA3   PC
JSR                     9D  7  2   BD  8 3           AD 7+ 2+             */*/*/*/*  /JUMP TO SUBROUTINE
LD   LDA                96  4  2   B6  5 3  86 2 2   A6 4+ 2+             */!/!/0/*  /M A
     LDB                D6  4  2   F6  5 3  C6 2 2   E6 4+ 2+             */!/!/0/*  /M B
     LDD                DC  5  2   FC  6 3  CC 3 3   EC 5+ 2+             */!/!/0/*  /M:M + 1  D
     LDS                10  6  3   10  7 4  10 4 4   10 6+ 3+             */!/!/0/*  /M:M + 1  S
                        DE         FE       CE       EE
     LDU                DE  5  2   FE  6 3  CE 3 3   EE 5+ 2+             */!/!/0/*  /M:M + 1  U
     LDX                9E  5  2   BE  6 3  8E 3 3   AE 5+ 2+             */!/!/0/*  /M:M + 1  X
     LDY                10  6  3   10  7 4  10 4 4   10 6+ 3+             */!/!/0/*  /M:M + 1  Y
                        9E         BE       8E       AE
LEA  LEAS                                            32 4+ 2+             */*/*/*/*  /EA3  S
     LEAU                                            33 4+ 2+             */*/*/*/*  /EA3  U
     LEAX                                            30 4+ 2+             */*/!/*/*  /EA3  X
     LEAY                                            31 4+ 2+             */*/!/*/*  /EA3  Y
LSL  LSLA     48  2 1                                                     */!/!/!/!  /A
     LSLB     58  2 1                                                     */!/!/!/!  /B
     LSL                08  6  2   78  7 3           68 6+ 2+             */!/!/!/!  /M
LSR  LSRA     44  2 1                                                     */0/!/*/!  /A
     LSRB     54  2 1                                                     */0/!/*/!  /B
     LSR                04  6  2   74  7 3           64 6+ 2+             */0/!/*/!  /M
MUL           3D 11 1                                                     */*/!/*/9  /A X B  D (UNSIGNED)
NEG  NEGA     40  2 1                                                     8/!/!/!/!  /A + 1  A
     NEGB     50  2 1                                                     8/!/!/!/!  /B + 1  B
     NEG                00  6  2   70  7 3           60 6+ 2+             8/!/!/!/!  /M + 1  M
NOP           12  2 1                                                     */*/*/*/*  /NO OPERATION
OR   ORA                9A  4  2   BA  5 3  8A 2 2   AA 4+ 2+             */!/!/0/*  /A V M  A
     ORB                DA  4  2   FA  5 3  CA 2 2   EA 4+ 2+             */!/!/0/*  /B V M  B
     ORCC                                   1A 3 2                         / / / /7  /CC V IMM  CC
PSH  PSHS     34 5+4 2                                                    */*/*/*/*  /PUSH REGISTERS ON S STACK
     PSHU     36 5+4 2                                                    */*/*/*/*  /PUSH REGISTERS ON U STACK
PUL  PULS     35 5+4 2                                                    */*/*/*/*  /PULL REGISTERS FROM S STACK
     PULU     37 5+4 2                                                    */*/*/*/*  /PULL REGISTERS FROM U STACK
ROL  ROLA     49  2 1                                                     */!/!/!/!  /A
     ROLB     59  2 1                                                     */!/!/!/!  /B
     ROL                09  6  2   79  7 3           69 6+ 2+             */!/!/!/!  /M
ROR  RORA     46  2 1                                                     */!/!/*/!  /A
     RORB     56  2 1                                                     */!/!/*/!  /B
     ROR                06  6  2   76  7 3           66 6+ 2+             */!/!/*/!  /M
RTI           3B 6/15 1                                                    / / / /7  /RETURN FROM INTERRUPT
RTS           39  5 1                                                     */*/*/*/*  /RETURN FROM SUBROUTINE
SBC  SBCA               92  4  2   B2  5 3  82 2 2   A2 4+ 2+             8/!/!/!/!  /A - M - C  A
     SBCB               D2  4  2   F2  5 3  C2 2 2   E2 4+ 2+             8/!/!/!/!  /B - M - C  B
SEX           1D  2 1                                                     */!/!/0/*  /SIGN EXTEND B INTO A
ST   STA                97  4  2   B7  5 3           A7 4+ 2+             */!/!/0/*  /A  M
     STB                D7  4  2   F7  5 3           E7 4+ 2+             */!/!/0/*  /B  M
     STD                DD  5  2   FD  6 3           ED 5+ 2+             */!/!/0/*  /D  M:M + 1
     STS                10  6  3   10  7 4           10 6+ 3+             */!/!/0/*  /S  M:M + 1
                        DF         FF                EF
     STU                DF  5  2   FF  6 3           EF 5+ 2+             */!/!/0/*  /U  M:M + 1
     STX                9F  5  2   BF  6 3           AF 5+ 2+             */!/!/0/*  /X  M:M + 1
     STY                10  6  3   10  7 4           10                   */!/!/0/*  /Y  M:M + 1
                        9F         BF                AF 6+ 3+
SUB  SUBA               90  4  2   B0  5 3  80 2 2   A0 4+ 2+             8/!/!/!/!  /A - M  A
     SUBB               D0  4  2   F0  5 3  C0 2 2   E0 4+ 2+             8/!/!/!/!  /B - M  B
     SUBD               93  6  2   B3  7 3  83 4 3   A3 6+ 2+             */!/!/!/!  /D - M:M + 1  D
SWI  SWI(6)   3F  19 1                                                    */*/*/*/*  /SOFTWARE INTERRUPT 1
     SWI2(6)  10  20 2                                                    */*/*/*/*  /SOFTWARE INTERRUPT 2
              3F
     SWI3(6)  11  20 2                                                    */*/*/*/*  /SOFTWARE INTERRUPT 3
              3F
SYNC          13  2 1                                                     */*/*/*/*  /SYNCHRONIZE TO INTERRUPT
TFR  R1,R2    1F  7 2                                                     */*/*/*/*  /R1 R22
TST  TSTA     4D  2 1                                                     */!/!/0/*  /TEST A
     TSTB     5D  2 1                                                     */!/!/0/*  /TEST B
     TST                0D  6  2   7D  7 3           6D 6+ 2+             */!/!/0/*  /TEST M
------------------------------------------------------------------------------
                       INDEXED ADDRESSING MODES
                             NON INDIRECT            INDIRECT
                        ASSEMBLER/ POST-BYTE/ ++     ASSEMBLER/ POST-BYTE/ ++
TYPE             FORMS      FORM   / OP CODE/ ~ #    FORM     / OP CODE  / ~ #
------------------------------------------------------------------------------
CONSTANT OFFSET FROM R
                 NO OFFSET    ,R   1RR00100   0 0    [,R]     1RR10100     3 0
                 5 BIT OFFSET n,R  0Rnnnnnn   1 0     DEFAULTS TO 8 BIT
                 8 BIT OFFSET n,R  1RR01000   1 1   [n,R]     1RR11000     4 1
                16 BIT OFFSET n,R  1RR01001   4 2   [n,R]     1RR11001     7 2
------------------------------------------------------------------------------
ACCUMULATOR OFFSET FROM R
              A-REGISTER OFFSET A,R 1RR00110  1 0   [A,R]     1RR10110     4 0
              B-REGISTER OFFSET B,R 1RR00101  1 0   [B,R]     1RR10101     4 0
              D-REGISTER OFFSET D,R 1RR01011  4 0   [D,R]     1RR11011     7 0
------------------------------------------------------------------------------
AUTO INCREMENT/DECREMENT R
              INCREMENT BY 1    ,R+ 1RR00000  2 0    NOT ALLOWED
              INCREMENT BY 2   ,R++ 1RR00001  3 0   [,R++]    1RR10001     6 0
              DECREMENT BY 1    ,-R 1RR00010  2 0    NOT ALLOWED
              DECREMENT BY 2   ,--R 1RR00011  3 0   [,--R]    1RR10011     6 0
------------------------------------------------------------------------------
CONSTANT OFFSET FROM PC
              8 BIT OFFSET    n,PCR 1XX01100  1 1  [n,PCR]    1XX11100     4 1
             16 BIT OFFSET    n,PCR 1XX01101  5 2  [n,PCR]    1XX11101     8 2
------------------------------------------------------------------------------
EXTENDED INDIRECT
             16 BIT ADDRESS    ---   ----     - -   [n]       10011111     5 2
------------------------------------------------------------------------------
                          R=X,Y,U, OR S
                          X=DON'T CARE
NOTES:
1. Given in the table are the base cycles and byte counts. To determine the total
   cycles and byte counts add the values from the '6809 indexing modes' table.
2. R1 and R2 may be any pair of 8 bit or any pair of 16 bit registers.
   The 8 bit registers are: A,B,CC,DP
   The 16 bit registers are X,Y,U,S,D,PC
3. EA is the effective address.
4. The PSH and PUL instructions require 5 cycles plus 1 cycle for each byte pushed or
   pulled.
5. 5(6) means: 5 cycles if branch not taken, 6 cycles if taken.
6. SW1 sets I&F bits. SW112 and SW13 do not affect I&F.
7. Conditions Codes set as a direct result of the instruction.
8. Value of half-carry flag is undefined.
9. Special Case--Carry set if b7 is set.

                  
LEGEND:
OP  OPERATION CODE (HEXADECIMAL)
~   NUMBER OF MPU CYCLES
#   NUMBER OF PROGRAM BYTES
+   ARITHMETIC PLUS
-   ARITHMETIC MINUS
*   MULTIPLY
-
M   COMPLEMENT OF M
(symbol-arrow pointing to right)  TRANSFER INTO
H   HALF-CARRY FROM BIT 3
N   NEGATIVE (SIGN BIT)
Z   ZERO (BYTE)
V   OVERFLOW, 2'S COMPLEMENT
C   CARRY FROM BIT 7
!   TEST AND SET IF TRUE, CLEARED OTHERWISE
*   NOT AFFECTED
CC  CONDITION CODE REGISTER
:   CONCATENATION
V   LOGICAL OR
^   LOGICAL AND
V (with line through)  LOGICAL EXCLUSIVE OR

