.HE               BMP - Binary Maintenance Program
.BL 4
.CE
*** Introduction ***
.BL 2
BMP is a program which facilitates the maintenance and manipulation of the contents of
disks, disk files, and memory.  Included are commands for symbolic entry and display
of machine instructions (disassemble and assemble),  ASCII and hexadecimal entry and display, as well
as binary and decimal entry.
.BL 1
User operation of the program is the same regardless of the type of object being
accessed, although some commands are meaningless when accessing in a non-diskdump
mode.
.BL 2
.CE
*** Access Modes ***
.BL 2
.BL 1
BMP has three addressing modes: memory, diskdump, and binary file.
.BL 1
The memory mode allows the user immediate access to the computer memory and in
many ways is similar in operation and effect to the interpretive debugger, IDB.
Naturally, if the user is not careful while in this mode, he may easily destroy the
resident copy of SDOS.
.BL 1
The diskdump mode allows the user to examine the contents of a disk or diskfile in its
'raw' form.  Locations specified by the user are the actual byte positions used in the
file, as offset by a sector or cluster base given by the user (see the section
on access commands).
.BL 1
The binary file mode allows the user to access the program contained in a
binary file as if it were loaded into memory.  This means that the user can talk
about the program without regard to how it is stored on disk~--~in fact, BMP will
take care of all the details involved in expanding the file if the user
adds new data!
.PA
.CE
*** Display Commands ***
.BL 2
BMP will display data from a location in an output format selected by the
user (the default display mode is ;H).
.BL 1
.OF 15
;A~~~~~~~~~~~~~ASCII: the contents of the location is printed out as an ASCII character
enclosed by apostrophes.  Should the character not be a printing
character, its hexadecimal value is printed.
.BL 1
;O~~~~~~~~~~~~~OPCODE: the contents of the location are treated as though it were an instruction
and its symbolic form is printed.  Relative branches are printed with
their absolute destinations rather than their relative displacements.
Undefined op-codes have their hexadecimal value printed out preceeded
by 'FCB'.
.BL 1
;H~~~~~~~~~~~~~HEXADECIMAL: 1 byte is printed out in hexadecimal representation.
.bl 1
;X~~~~~~~~~~~~~HEXADECIMAL:~~2~~bytes~~are~~printed~~~out~~in hexadecimal notation.
.LM 10
.OF 0
.BL 2
.CE
*** Commands ***
.BL 2
The following is a list of commands, with descriptions and references to section names
associated with each command.  The following notation is used regarding objects in
meta-brackets ('<>'):
.BL 1
Lower case letters in meta-brackets describe special keys.  For
example, <cr> refers to the return key, <lf> is a line feed, and <esc> is an
escape.
.BL 1
Upper case letters in meta-brackets refer to strings with a specific syntactic
meaning.  For example, <E> is an expression.  A full list is given below.
.LM 10
.BL 1
.CP 42
.PW 132
.LL 121
.TB 15,59
Command	Description	Reference
.BR
=======	===========	=========
.BR
+~-~*~#~%~!	operators	expressions
.bl 1
;E	exit BMP
.BL 2
Examine and Deposit
.bl 1
<E>/	examine contents of location <E>	simple commands
.BR
<cr>	close current location	simple commands
.BR
<lf>	examine next location	simple commands
.BR
^	examine previous location	simple commands
.BR
<E>,<E>/	display multiple locations	simple commands
.BR
<D><cr>	deposit data	simple commands
.BR
<D><lf>	deposit and examine next location	simple commands
.BR
<D>^	deposit and examine previous location	simple commands
.BR
<E>=	display value of expression	simple commands
.BL 2
Set Access Mode
.BL 1
<FILE>;B	binary, open <FILE>	access commands
.BR
<FILE>;D	diskdump, open <FILE>	access commands
.BR
;M	memory	access commands
.BL 2
Display File Information
.BL 1
<FILE>;H	find header cluster of <FILE>	info commands
.BR
<FILE>;L	show load record layout of <FILE>	info commands
.BL 2
Set Display Mode
.BL 1
;A	ASCII	display commands
.BR
;H	single byte hex	display commands
.BR
;X	double byte hex	display commands
.BR
;O	opcode	display commands
.BL 2
Set Diskdump Mode Offset
.bl 1
<E>;C	set I/O base to cluster <E>	access commands
.BR
<E>;S	set I/O base to sector <E>	access commands
.BL 2
Searching
.bl 1
?	display search target and mask	searching
.br
<E>?T	set search target	searching
.br
<E>?M	set search mask	searching
.br
<E>,<E>?S	perform search	searching
.LM 10
.LL 65
.pw 85
.PA
.CE
*** Expressions: <E> ***
.BL 2
BMP allows simple expressions with strict left to right evaluation and no
parenthesis.  The recursive definition is as follows:
.BL 1
An expression <E> is:
.BL 1
<E>+<E>	addition
.BR
<E>-<E>	subtraction
.BR
<E>*<E>	multiplication
.BR
<E>&<E>	logical not
.BR
<E>!<E>	logical or
.BR
<E>#<E>	logical exclusive or
.BR
-<E>	negation
.BR
<HEX>	a string of digits consisting of 0 through F
.BR
<DEC>\	a string of decimal digits followed by '\'
.BR
<BIN>%	a string of binary digits followed by '%'
.BR
.IG
.	the last opened location
.BR
'<CHAR>	the ASCII value of <CHAR> (which is one character)
.BL 1
The only restriction is that the negation operator must be the first operator in the
expression.    For example,
.bl 1
	4*3+-2#7!3
.bl 1
is not legal, while
.bl 1
	-4*.+'b
.bl 1
is legal.
.BL 1
Note:  While BMP can display numbers in only hexadecimal, numbers may be input as
binary, decimal, or hexadecimal.
.PA
.CE
*** Deposit Data: <D> ***
.BL 2
This is data which is intended to be written out by the user and takes two forms:
symbolic and non-symbolic.
.BL 1
The symbolic form has the syntax:
.BR
.BL 1
	<OPCODE>~<ARG> 
.BL 1
where the opcode is 'LDAA', 'ORAA', 'TSX', 'CLRA', etc.
<ARG> is absent when the opcode requires no argument;  otherwise, it has the form:
.BL 1
	#<E> or <E>,X or <E>
.BL 1
# indicates immediate addressing; ,X means indexed; just <E> means direct or extended
addressing (direct is used if possible).  The argument must be separated from the
opcode by exactly one space.  For example:
.BL 1
	LDAA 10+45,X
.BL 1
The non-symbolic form has the syntax
.BL 1
	$<E> or <E>
.BL 1
Examples:	$101~~~$10+'a~~~24+.
.PA
.CE
*** Simple commands ***
.BL 2
There are a few simple commands which are used most of the time in BMP:
.BR
.BL 1
	<E>/ - examine
.BL 1
.OF 0
This command examines the contents of location <E>.  The data is printed out in
the mode specified by the last mode setting command.
.bl 1
Note: Because some modes require
more than one byte of data, the location specified by the user is used as a starting
location.  For instance, in the ;X mode, BMP prints out the value of two adjacent
bytes.
.BL 1
In addition, the next deposit location is set to the address <E>, thereby allowing the
user to change the data with the next command.  No actual data is changed with this
command.  Also, the symbol '.' is
given the value of <E>, when used in expressions.
.BL 1
	<cr> - close
.BL 1
A <cr> 'disarms' the next deposit location so that it is no longer valid.
Afterwards, should the user try to deposit data without doing a '/' command, he will
be chastised with a 'I don't know where to deposit that!' error message.
.BL 1
	<D><cr> - deposit and close
.BL 1
The data <D> is deposited at the next deposit location and a regular <cr> command is
executed.
.BL 1
	<lf> - examine next
.BL 1
Acts as if the user had typed '.+n/' where n is the number of bytes last displayed.
Illegal if there is no valid next deposit location.
.PA
	<D><lf> - deposit and examine next
.BL 1
The data <D> is deposited in the next deposit location and the contents of the location
following the deposited data is shown.
.BL 1
	^ - examine previous
.BL 1
Is identical to '.-1/'.  Not legal if there is no valid next deposit location.
.BL 1
	<D>^ - deposit and examine previous
.BL 1
Is identical to '<D><cr>.-1/'.  Not legal if there is no valid next deposit location.
.BL 1
	<E>= - evaluate expression
.BL 1
The equals command merely prints out the value of the expression preceeding it.  The
value printed out may be used as the first operand in an expression following the '='
just as if the user had typed the value.  For example, typing '2+.=xxxx-10/' (where
xxxx is printed by BMP) is both legal and useful.
.BL 1
	<E1>,<E2>/ - display multiple locations
.BL 1
Starting at <E1>, the contents of memory or disk are displayed on the terminal.  If <E2>
is a hex number with less than three digits or is an expression less than 256,
locations are displayed through <E1>+<E2>;  otherwise, they are displayed through <E2>.
.BL 1
If the display mode is ;O, the display is in symbolic format.  If the display
mode is not ;O, locations are displayed as both hex numbers and ASCII characters.
Pressing <esc> during the print out will cause the display to abort.
.pa
.CE
*** Searching ***
.bl 2
BMP will search the designated source for a specified target, using a specified mask
to select the bits to be used in the comparison.  A list of all locations meeting the
search criteria will be displayed.
.bl 1
The source is designated by one of the three access modes.  The target is specified
by
.bl 1
	<E>?T
.bl 1
and the mask is specified by
.bl 1
	<E>?M
.bl 1
The current search target and mask may be displayed by
.bl 1
	?
.bl 1
yielding
.bl 1
	TARGET = xx~~MASK = xx
.bl 1
The search is initiated by
.bl 1
	<E1>,<E2>?S
.bl 1
where <E1> and <E2> are the lower and upper inclusive bounds of the search.
.bl 1
The search mask tells BMP what parts of the target to take seriously; each byte of
the mask corresponds to a byte of the target (so the mask must be as long as the target).
A bit set to 1 in a mask byte says to ignore that corresponding bit in the byte
being compared with the target byte.  A bit set to 0 says that the
corresponding bit in the byte being compared must match exactly.
.PA
.CE
*** Access commands ***
.BL 2
;M
.BL 1
All references go to memory after execution of this command.  This is the default
mode.
.BL 1
<file>;B
.BL 1
All locations referenced by the user are translated  to disk
addresses and the reference made to the  specified binary file.  If the file
contains records which will overlap other records when loaded into memory,
BMP directs the reference to the record which would be loaded last.
.bl 1
When an examined location is not found in any of the records, the value zero
is displayed.  When a deposit location does not exist in any of the records, a new
record is created.
.BL 1
Note:~~Because of the translation involved in converting a memory address to a disk address,
binary mode runs slightly slower than memory or diskdump modes.
.BL 1
<file>;D
.BL 1
All references go to the specified disk or disk file.  Since BMP and the user can only
discuss locations in the range of 0 to 65535, BMP has a provision for dealing with files
that have 65536 or more bytes in them.  The user is allowed to specify an offset which
is added to the user's location to produce an absolute file location.  This offset can
be specified in either of two forms: a base sector or a base cluster.  Thus, if the
user wishes to change byte 3E of sector 5F5 to a zero, he need only type
.BL 1
	5F5;S
.br
	3E/~xx~~$0<CR>
.BL 1
To set the offset to sector <E>, type '<E>;S'.  To set it to cluster <E>, type
'<E>;C'.  An automatic '0,nbps/' is performed upon execution of these commands (nbps
is the number of bytes per sector).
.PA
.CE
*** Filenames: <FILE> ***
.BL 2
<FILE> is a valid SDOS file name, including device names.
.BL 1
Examples:	sdos.sys~~D0:defaultprogram  wd0:
.bl 3
.CE
*** Information Commands ***
.bl 1
Information commands give information about a file or its structure.
.bl 1
	<FILE>;L
.bl 1
This command gives a list of load records in the object FILE selected.  It is most
useful for determining where an object file loads into memory.
.bl 1
	<FILE>;H
.bl 1
This command locates the file named in the directory, and displays the displacement
into the directory for filename entry and the header cluster of the FILE.  The
value displayed can be used in conjunction with <DISK>;D and xx;C commands to examine
the file header cluster.
.bl 3
.ce
*** Miscellaneous Commands ***
.bl 1
	<E1>,<E2>;C
.bl 1
This command computes the sum (modulo 256) of the bytes between the addresses
E1 and E2, inclusive.
.bl 3
.CE
*** Errors ***
.BL 2
Most error messages issued by BMP are self explanatory.  One, though, may be a bit
confusing: 'Are you sure you want to write on the disk DEVICE?' This message occurs
when a disk device (not a file) is open in diskdump mode and the user is attempting to
do a deposit.  This is merely a safety check, and typing 'YES' will pacify BMP.
Typing anything else will abort the deposit and issue a disk write-locked
error.
.BL 1
Error messages printed out are of two varieties: those which have an 'AT LINE xxxx'
tacked to the end and those that do not.  Those errors which have a line number are
issued by SDOS and relate to some I/O problem (like file not found, etc.).  Those not
followed by line numbers are issued by BMP and inform the user that BMP cannot
understand or execute the last command.
.PA
.CE
*** Sample commands ***
.BL 2
.BL 1
To display page zero of memory
.BL 1
	;M 0,FF/
.BL 1
To disassemble a block of code between $100 and $25E
.BL 1
	;O 100,25E/
.BL 1
To display bytes at 12D3 through 12D3+1E
.BL 1
	12D3,1E/
.BL 1
To display $26 through $38
.BL 1
	26,0038/
.BL 1
To patch a JSR $100 into location $526
.BL 1
	526/ xxxx JSR 100
.BL 1
To patch a BNE $1234 at $1226
.BL 1
	1226/ xxxx BNE 1234
.bl 1
To open a binary file ABC for examination/patching
.bl 1
	ABC;B
.bl 1
To patch location 107D to a CLRA
.bl 1
	107D/ xxxx~~CLRA
.bl 1
To search for 'fred' or 'FRED' in the range of 12D3 to 12F3
.bl 1
	'F'R'E'D?T 20202020?M 12D3,12F3?S
.bl 1
To quit:
.bl 1
	;E
.BL 4
(C040281)
