.np
.fs 15
.ce
E D I T
.sp
.ce
U S E R ' S
.sp
.ce
M A N U A L
.sp 4
.ce
EDIT V1.1
.sp 6
.ce
5th Printing
.sp
.ce
COPYRIGHT (C) 1978 SOFTWARE DYNAMICS
.fs 10
.ce
NOTICE
.br
.ce
______
.sp 2
This manual describes EDIT Version 1.1.  Software Dynamics has carefully
checked the information given in this manual, and it is believed to be
entirely reliable.  However, no responsibility is assumed for inaccuracies. 
Software Dynamics reserves the right to change the specifications without
notice.
.sp
EDIT V1.1 is an improved version of EDIT V1.0, and has been optimized for
use under SDOS.  These optimizations prevent use of EDIT V1.1 in non-SDOS
environments.
.sp
.pw 120
.ll 100
.im 21
**********************************************************************
** This manual  describes software  which is a proprietary  product **
** of Software Dynamics (SD).  SD software is licensed for use on a **
** single copy per computer basis, and is covered by U.S  copyright **
** laws.  Unless a written exception is obtained from SD, the soft- **
** ware must be used only on the single computer whose unique,  SD- **
** assigned serial number matches that for which  the  software was **
** purchased.  Copying the software  for  any  purpose  other  than **
** archival storage, or use of the  software on other than the  as- **
** signed serial numbered CPU is strictly  prohibited.   SD assumes **
** no liability regarding the use of the software.                  **
** Certain  software  programs and  datafiles are delivered for use **
** in an encrypted  format.  The content of such  programs and data **
** are  considered  to be a  trade  secret of SD.  Attempts or suc- **
** cess at  breaking the  encryption, publication of the results of **
** such attempts or successes, or copying, storage or use of such a **
** file in clear text form will be treated as theft of a trade sec- **
** ret, and prosecuted as such.                                     **
** POSSESSION OR USE  OF THIS  MANUAL OR THE SOFTWARE  IT DESCRIBES **
** CONSTITUTES AGREEMENT BY THE USER TO THESE TERMS.                **
**********************************************************************
.sp
.ll 65
.pw 85
This manual and the software it describes are the copyrighted property of
Software Dynamics.
.he EDIT USER'S MANUAL
.il Copyright (C) 1978 SD
.pa 1
.bp
EDITOR FEATURES
.tc
.sp
.ix Feature
.ix File, ASCII Text
EDIT is a general purpose context editor, used to enter and correct ASCII
text files.
.sp
Significant features include:
.sp
.in 3
.un 3
--~Two input files, each re-selectable without leaving EDIT
.ix File, Input
.sp
.un 3
--~One output file, re-selectable without leaving EDIT
.ix File, Output
.sp
.un 3
--~Ability to merge or split files
.ix File, Merge
.ix File, Split
.sp
.un 3
--~Multiple commands allowed on command lines
.ix Command Line
.ix Multiple Commands
.sp
.un 3
--~Commands for both line-oriented and character-oriented editing
.ix Line-Oriented Edit
.ix Character-Oriented Edit
.sp
.un 3
--~Easy-to-use search, change, and remove commands
.ix Search
.ix Change
.ix Remove
.sp
.un 3
--~Automatic typing of a line after a search, change, or remove
.ix Automatic Type
.sp
.un 3
--~Value registers
.ix Value Register
.sp
.un 3
--~Easy insertion and deletion of text
.ix Text Insertion
.ix Text Deletion
.sp
.un 3
--~Display commands
.ix Command, Display
.sp
.un 3
--~Command input can be taken from a file, allowing canned editing
procedures (macros)
.ix Macro
.sp
.un 3
--~Iteration commands, including testing and branching
.sp
.un 3
--~Arithmetic, logicals, and relationals (for iteration control)
.sp
.un 3
--~Command success/fail testing (for iteration control)
.in 0
.pa
INTRODUCTORY CONCEPTS
.ix Concept
.tc
.sp
.ix Context
.ix Specified Character
.ix Specified Word
.ix Specified Phrase
EDIT is a general purpose context editor.  "Context" is the part of a word,
sentence, or paragraph that occurs just before and/or after a specified
character, word, or phrase. "Editing" is the preparation, arrangement,
revision, or correction of a document.
.sp
.ix Create Text File
.ix File
.ix ASCII Null
.ix Operating System Convention
The editor is used to change (or create) a text file (a file is generally
defined to be any collection of data, usually on a disk; for our purposes,
only files containing textual information are important).  With the
exception of deleting ASCII nulls, EDIT does not restrict the kind of text
data that may be edited (local operating system conventions may place
additional restrictions, however).
.sp
.ix Text Block Duplicating
.ix Buffer, Text
Besides holding text, files may be used to hold frequently used command
sequences, or for moving and/or duplicating blocks of text from the text
buffer.
.sp
The editor treats the text to be processed as a stream of characters, which
can be read and edited in chunks.  Once a chunk is processed, it cannot be
changed or examined without re-processing the entire text file again.
.sp
.ix Computer Memory
.ix Workspace
.ix Buffer, Text
.ix Buffer, Command
.ix Buffer Size
EDIT uses the computer's memory as a "workspace" to perform the required
editing.  The workspace is used for two purposes: storing text while editing
and as a place to put editing commands typed by the user.  The portion of
the workspace used for holding text while it is being edited is called the
"text buffer" and the portion used for holding commands being typed in is
called the "command buffer".  Although the workspace has a fixed size
determined by the particular system configuration, the text buffer and
command buffer may dynamically grow and shrink during the editing process.
.sp
.ix Buffer, Text
.ix Page
.ix ^L
.ix Form Character
The editor fills its text buffer on a page by page basis.  A "page" is that
portion of a text file up to and including a form character (^L).  Therefore
form characters are generally used to make the amount of text transferred
into the text buffer at any one time more manageable.  Forms should
generally be placed to make the number of characters in any one page less
than half the size of the workspace.  Multiple pages may be present in the
text buffer as long as enough memory is available to hold them.
.pa
The editing process operates as follows:
.ix Edit Process
.sp
.in 4
.un 4
1.)~The user invokes the editor.
.un 4
.ix File, Source
.ix Command, ER
.ix Command, EB
2.)~A file containing text is selected to be modified (Source file) (ER or
EB command).
.un 4
.ix File, New
.ix File, Destination
.ix Command, EW
3.)~A new file is created which will eventually contain the modified version
of the file selected in Step 2 (Destination file) (EW command).
.un 4
.ix Buffer, Text
.ix Command, A
4.)~The first page of text from the source file is copied into the text
buffer (1A command).
.un 4
.ix Command, Insert
.ix Command, Change
.ix Command, Type
.ix Command, Search
5.)~The user interacts with the editor to modify the contents of the text
buffer until he is satisfied with the results (Insert, Change, Type, Search
commands).
.un 4
.ix Command, P
.ix Modified Page
6.)~The modified page is written to the destination file (P command).
.un 4
.ix File, Source
7.)~The next source file page is read into the text buffer, modified, etc.
.un 4
.ix Command, EXIT
8.)~Having changed all parts of the text that needed changing, the user
exits the Editor (EXIT command).
.in 0
.sp
The user tells the editor what to do next by typing commands.
.sp
.ix Command, Type
.ix Command, Insert
.ix Command, Delete
.ix Value
.ix Delimiter
.ix Command, One Character
Many EDIT operations are invoked by a single character command mnemonic: "T"
means Type one line; "I" means Insert, etc.  Some commands allow or require
values before them to specify a count of how many times the command should
be done: "5T" means Type five lines; "2D" means Delete two characters, etc. 
If a value is not supplied, it is generally assumed to be "1".  A "-"
(minus) sign preceding a command causes the value to be assumed to be -1. 
Some commands require a string argument (arbitrary sequence of characters)
followed by a delimiter (end-of-string indicator): "SHELLO\" means Search
for the occurrence of "HELLO" (\ is the delimiter); "CABC\XYZ\" means Change
"ABC" to "XYZ", 3FHI\ means Find the third occurrence of "HI".
.sp
.ix Command, Two Character
Some of the editor commands are spelled with two characters. There are two
reasons for this:
.sp
.ix Command, Dangerous
.ix Command, Three Character
.ix Command, Two Character
1.) Many editor commands are very powerful and can destroy portions of a
file if used carelessly or accidentally.  In addition to the two character
format, "dangerous" commands also require a value (usually a single digit)
preceding them. This 3 character format helps ensure that the user really
intended to use the command.
.sp
2.) It is difficult to choose unique single character command names that are
mnemonic given only 26 alphabetical characters.
.sp
.ix Command Input
.ix Prompt Character
.ix *
.ix Buffer, Command
.ix Carriage Return
.ix Character, Activation
When the editor is ready to accept command input, it will signal ready with
the prompt character "*".  Commands that are typed into the editor are
placed into the command buffer and "saved-up" until the activation character
(carriage-return) is received.  If the command requires more input, the
editor will prompt for more input before executing the command.  At this
point, the editor will execute (perform) all the specified operations.  When
the editor finishes the required operations, it will again signal ready by
displaying the prompt.
.sp
.ix Uppercase
.ix Lowercase
.ix String Argument
When typing in a command, uppercase or lowercase commands may be used
interchangeably.  String arguments are used exactly as typed. Consequently,
"Shello\" is not equivalent to "SHELLO\", while "sHELLO\" is the same as
"SHELLO\".
.sp
.ix Mistake Correction
.ix Delete
.ix Rubout
.ix Virtual Terminal Driver
.ix SDOS
Line input editing (correcting typing mistakes while entering a command
string) is subject to local system conventions. Usually, a Delete (or
Rubout) character can be typed to erase an erroneous character.  The SDOS
virtual terminal driver will allow editing within a typed-in line before
EDIT sees the line; refer to the SDOS manual for more details.
.sp
.ix Carriage Return
.ix Command String
.ix Character, Activation
.ix Buffer, Command
One or more EDIT commands may be typed followed by a carriage-return.  This
series of commands is referred to as a command string.  The command string
is not restricted to one line of input as it may include carriage-returns in
string arguments.  The last character in a command string is a
carriage-return which is not part of a string argument; this carriage return
is called the activation character.  A carriage-return appearing in a string
argument is considered to be part of the string and is not an activation
character.  The editor saves up the command string in the command buffer
until the activation character is typed.  The commands are then executed
left to right until no more commands remain.
.sp
.ix Error
.ix Command Syntax Incorrect
.ix Error Code
When the editor discovers an error, such as incorrect command syntax, or a
command cannot be performed, it will print an error code which can be found
in the error summary.
.sp
.ix Text Display
.ix Buffer, Text
.ix Character Pointer
.ix CP
.ix Context
Editor commands that manipulate and display text do their work on text in
the text buffer.  Since there is usually a lot of text in the buffer, some
mechanism is needed to focus the editor's attention on a particular part of
the text buffer.  This focusing is done via a special pointer called the
"CP" (character pointer).  CP always points to a particular character in the
text buffer, which is where the actual editing is performed.  The CP and the
text buffer together are very like a pencil and some paper with printing on
it; before one can change the printing on the paper, one must first place
the pencil on the word to be changed.  Commands exist to allow the user to
move the CP around in the text buffer in several different ways.  The
location of CP is generally termed "the context"; thus the name of the
editor's style.
.pa
.ix Buffer, Text
For the purpose of explanations involving the CP, the text buffer could be
considered a linear arrangement of all of the characters currently in the
text buffer.  For example, suppose the text buffer contained the following
text and the CP was positioned on the "F":
.sp
       ABC
       DEF
       GHI
       JKL
.sp
This could be represented linearly as follows:
.sp
Beginning of text buffer
.sp
       A
       B
       C
       <CR>
       D
       E               (BACKWARD, OR PREVIOUS TO CP)
       F       <-- CP
       <CR>
       G               (FORWARD FROM CP)
       H
       I
       <CR>
       J
       K
       L
       <CR>
.sp
End of text buffer
.br
.sp
.ix CP
.ix Character Pointer
.ix Buffer
.ix Carriage Return
In this case, "ABC" and "DE" are considered to be "before" the CP while
"GHI" and "JKL" are considered to be after the CP.  We say that the CP
"points" to the "F" character.  Also, CP is considered to be "between" "DE"
and "GHI".  Note that the end of a line has an explicit marker representing
it in the buffer; this marker is called a "carriage-return" <CR> character. 
The CP may point to a <CR> character.
.pa
THE DISPLAY SCREEN VERSUS THE TEXT BUFFER
.ix Display Screen
.ix Buffer, Text
.tc
.sp
Many who are new to the idea of computers and editing may tend to think in
terms of the familiar typewriter concepts:
.sp
.in 8
"I can't see it, therefore, it is not there."
.sp
"That line that just rolled off the screen disappeared for good."
.sp
"The top line (or bottom line) of the screen is the most interesting line;
since I work there, the editor must work there."
.in 0
.sp
.ix Buffer, Text
.ix Window, Text
.ix Scroll
Often, what is displayed on the screen is confused with what is in the text
buffer.  Actually, what is on the screen is only a copy of the part of the
text buffer that the editor was asked to show the user, like a "window". 
The computer can be asked to display (using the "T" command) as little as
one line or as much as the entire text buffer -- but only the last screen
full of displayed text is available to be viewed. This is like a small
window through which only a small portion of the text buffer can be seen at
any one time.  Even though lines will disappear off the top of the screen
while scrolling, the lines never disappear from the text buffer until the
computer is explicitly instructed to make them do so.
.sp
Note that the editor's text buffer may grow to contain more text than can
fit on the computer's display device all at one time.  For example, imagine
the text buffer currently contains 500 lines of text.  If
.sp
       B100T
.sp
.ix CP
.ix Scroll
.ix Top of Screen
.ix Buffer, Text
is typed into the computer, the editor will move the CP to the beginning of
the buffer and type the first 100 lines, most of which will scroll off the
top of the screen, leaving only the last 23 (depending upon the size of the
display) lines in full view.  Note that the CP is still at the beginning of
the buffer even though the line containing the CP was scrolled off the top
of the screen, and all 500 lines of text still remain in the text buffer.
.pa
COMMONLY USED COMMANDS
.tc
.sp
Probably the most frequently used commands are:
.sp
.br
.in 7
.un 7
A~~~~~~Append from input file
.ix A
.ix Append
.br
.un 7
B~~~~~~Begin (move CP to beginning of buffer)
.ix Begin
.ix B
.ix Buffer, Beginning
.br
.un 7
C~~~~~~Change one string to another string
.ix C
.ix Change
.br
.un 7
D~~~~~~Delete character
.ix D
.ix Delete
.br
.un 7
EB~~~~~Edit a file and make a backup copy of the old one
.ix EB
.ix Edit With Backup
.ix Backup Copy
.br
.un 7
ER~~~~~Edit Read (select input file)
.ix ER
.ix Edit Read
.ix File, Input
.br
.un 7
EW~~~~~Edit Write (select output file)
.ix EW
.ix Edit Write
.ix File, Output
.br
.un 7
EXIT~~~Copy current buffer and the remainder of the input file (if any) to
the output file and exit the editor.
.ix Exit
.br
.un 7
I~~~~~~Insert
.ix Insert
.ix I
.br
.un 7
K~~~~~~Kill (delete) lines
.ix K
.ix Kill
.ix Delete
.br
.un 7
L~~~~~~Move CP in units of lines
.ix L
.ix CP, Move Line
.br
.un 7
M~~~~~~Move CP in units of characters
.ix M
.ix CP, Move Character
.br
.un 7
P~~~~~~Punch current buffer to output file
.ix P
.ix Punch
.ix File, Output
.br
.un 7
R~~~~~~Remove a string
.ix R
.ix Remove
.br
.un 7
S~~~~~~Search for a string
.ix S
.ix Search
.br
.un 7
T~~~~~~Type (display) line(s)
.ix Type
.ix T
.ix Display
.br
.un 7
U~~~~~~Delete Until (up to) a matched string
.ix U
.ix Delete Until
.br
.un 7
Z~~~~~~Move CP to the end of the buffer
.ix Z
.ix CP, Move to End
.br
.un 7
<CR>~~~Move CP to beginning of next line. Equivalent to 1L1T
.ix <CR>
.ix CP, Move to Next Line
.in 0
.sp
These commands will handle all of the needs of the casual user and will be
described further in this section.  A complete reference for all the
commands appears in the detailed command description section.
.sp
.ix Begin
.ix Change
.ix Type
Of these commands, B(egin), C(hange) and T(ype) are sufficient to make
virtually all changes to text in the buffer, and are worth remembering for
the novice user.
.pa
A~~~~~~Append
.ix A
.ix Append
.sp
.ix Buffer, Text
.ix File, Input
This command is used to bring a portion of the input file into the editor's
text buffer where editing may take place. The editor will read text from the
input file until a control-L (page mark) is encountered, end of input file
is encountered, or the text buffer becomes full.  For example:
.sp
       A
.sp
.ix End of File
will append the next page of the input file to the end of the text buffer. 
An End of File message will be printed when the last page of the input file
is appended; this is not an error.
.sp
B~~~~~~Begin
.ix B
.ix Begin
.sp
.ix Buffer, Text Beginning
This command is used to move the CP to the beginning of the text buffer. 
The form is simply:
.sp
       B
.sp
C~~~~~~Change
.ix Change
.ix C
.sp
The C command is used to change the occurrence of one string to another
string.  For example,
.sp
      CHELLO\GOODBYE\
.sp
.ix CP
.ix Carriage Return

will search for and then change the next (starting from CP) occurrence of
"HELLO" to "GOODBYE" and leave the CP pointing to the first character after
the replacement string.  Note that strings (in general) may contain a
carriage-return (CR) character.
.sp
As with all of the editor commands, the editing operation is performed
relative to the CP.  This means that if there were two occurrences of
"HELLO", and the CP was positioned before the first "HELLO", the first
"HELLO" would be changed.  If the CP was positioned after the first "HELLO",
the second "HELLO" would be changed.
.sp
.ix Search, Backwards
.ix Minus
To make the editor search backwards from the CP, simply type a minus (-)
before the change command.  For example:
.sp
       -CHELLO\GOODBYE\
.sp
In this case, if the CP were positioned after the first "HELLO", the editor
would search backwards from the CP for the match, discovering the first
"HELLO", and change it to "GOODBYE".
.pa
.ix Buffer, Text
If the CP were at the beginning of the text buffer, we could tell the editor
to change the second occurrence of "HELLO" to "GOODBYE" by typing:
.sp
       2CHELLO\GOODBYE\
.sp
This will force the editor to change the second occurrence of "HELLO" and
leave the first occurrence alone.
.sp
.ix Change
If Change indicates that it cannot find the desired string then perhaps that
string is before CP and a backward ("-") change will find it.
.sp
.ix Display, Automatic
.ix Change
.ix Delete
.ix Remove
.ix Search
Automatic display of the current line (the one containing the CP) will
happen if a Change, Delete, Remove, or Search command is the last command in
the command string so the user can easily verify that the changes actually
made are the desired ones.
.sp
D~~~~~~Delete Character
.ix Character, Delete
.ix D
.sp
.ix Character, Remove
.ix Command Value
This command is used to remove the character(s) pointed to by CP.  This
command must have a value.  The command:
.sp
       5D
.sp
would delete five characters starting with the CP and leave the CP pointing
to the next character after the deleted sequence.
.sp
EB~~~~~Edit with Backup
.ix Edit With Backup
.ix EB
.sp
.ix Backup Copy
.ix File, Original
.ix Recovery
.ix ER
.ix EW
This command selects a file to be edited.  It is intended for use when one
wishes to make changes to a file which already exists. It tells the editor
to keep a backup copy of the original file, so if a disaster occurs,
recovery of the original text is easy. It acts similar to a combination of
ER and EW.
.sp
       EBMYFILE.TXT\
.sp
.ix File, Temporary
.ix Exit
.ix File, Temporary Output
tells the editor to get input (ER) from MYFILE.TXT for editing, and to
output (EW) edited text to a temporary file.  When an EXIT is performed,
MYFILE.TXT is made into a backup file by renaming it to MYFILE.BAK, and the
resulting temporary output file is then renamed MYFILE.TXT.  If EB is used,
ER and EW should not be used.
.pa
ER~~~~~Edit Read
.ix ER
.ix Edit Read
.sp
.ix File, Input
.ix ER
.ix EW
.ix File, Original
This command is used to select an input file for the editor. It should be
used with EW when one wishes to make a similar copy of a file with some
changes and leave the original file intact (ER and EW together).
.sp
       ERPAYROLL.BAS\
.sp
.ix SDOS
would instruct the editor to open the file named "PAYROLL.BAS" for editor
input; this is required before commands to fetch text from the input file
can be issued.  This command is not required if the editor is being used
solely to create a new file (see EW).  Since the file name given to EDIT is
passed to SDOS, it is subject to the rules and conventions of SDOS.
.sp
.ix File Name, Null
A null file name will cause the editor to close the input file.  At this
point, another input file may be selected:
.sp
       ER\ERINVENTORY.BAS\
.sp
EW~~~~~Edit Write
.ix Edit Write
.ix EW
.ix ER
.ix Copy, Similar
.ix File, Original
.ix Create
.ix Operating System
.sp
This command is used to create an output file.  It should be used when one
wants to create a file for the first time (EW by itself), or when one wishes
to make a similar copy of a file with some changes and leave the original
file intact (ER and EW together).  If an output file is already open, it
will be closed and the new file will be selected.  The editor uses a
"CREATE" call to the operating system which may cause any file by the same
name to be deleted before the new file is created.  An example of the EW
command is:
.sp
       EWPROG1.DOC\
.sp
Use ER and EW as follows to make a modified version of JOESCONTRACT for SAM:
.sp
       ERJOESCONTRACT.TXT\EWSAMSCONTRACT.TXT\
.sp
EXIT
.sp
.ix Edit, Terminate
.ix Exit
.ix Buffer, Text
.ix File, Input
.ix File, Output
This command is used to terminate an editing session.  When EXIT is typed,
the current text buffer is copied to the output file and the remainder of
the input file is also copied to the output file.  If there is an input file
selected or there is text in the text buffer, there must be an output file
selected.
.sp
.ix EZ
.ix Buffer, Clear
If no output is desired, use "ER\" to close the input file (only if it is
open) and use "EZ" to clear the text buffer (required only if the text
buffer is not empty):
.sp
       ER\EZEXIT
.pa
I~~~~~~Insert
.ix I
.ix Insert
.sp
.ix CP
This command is used to insert text immediately BEFORE the CP.  For example,
let's say that the CP was positioned on the first "E" of the example "THIS
IS A EXAMPLE".  The command
.sp
      IGOOD \
.sp
would insert the characters "GOOD " after "THIS IS A " and before "EXAMPLE"
producing "THIS IS A GOOD EXAMPLE".
.sp
.ix Delimiter
To insert many lines of text, simply type "I" followed by the desired text
which is then followed by the delimiter "\":
.sp
.im 8
       ILine 1
       Line 2
       Line 3
       .       
       .
       .
       Line n
       \
.sp
K~~~~~~Kill Line
.ix K
.ix Kill Line
.sp
Kill is used to delete ("kill") lines of text near CP.
.sp
.ix Negative Argument
The argument specifies how many lines to "kill", starting from CP. If the
argument is negative, lines are deleted before CP.  0K kills the part of the
line to the left of CP.  If CP is at the beginning of the line,
.sp
       0K
.sp
will do nothing.
.sp
       1K
.sp
will remove one line, and
.sp
       -2K
.sp
will remove the two previous lines.
.pa
L~~~~~~Lines (Move CP over lines)
.ix L
.ix Line
.ix CP
.sp
.ix Buffer, Text
This command is used to move the CP around in the text buffer in units of
lines.  For example,
.sp
       L
.sp
moves the CP forward to the beginning of the next line.
.sp
       0L
.sp
moves the CP to the beginning of the current line.
.sp
       5L
.sp
moves the CP forward five lines.
.sp
       -5L
.sp
moves the CP back to the beginning of the fifth previous line.
.sp
M~~~~~~Move (CP over characters)
.ix M
.ix Move
.sp
This command is used to move the CP forward or backward starting from the CP
in units of characters.
.sp
       M
.sp
moves the CP forward 1 character.
.sp
       -5M
.sp
moves the CP backward 5 characters.
.sp
P~~~~~~Punch (text buffer to output file)
.ix P
.ix Punch
.ix Buffer, Text
.ix File, Output
.ix File, Input
.sp
This command is used to move the contents of the text buffer to the output
file (thus making room for the next page of text from the input file).  This
command requires a value. If the value is 0, then the current text buffer is
moved to the output file, and the buffer is left empty.  If the value (n) is
greater than 0, then n-1 pages (counting the current text buffer as 1 page)
are copied from the input to the output file, and the nth page is read into
the text buffer.
.sp
       1P
.sp
moves the current text buffer to the output file, and fetches the next text
buffer from the input file.
.pa
R~~~~~~Remove a string
.ix R
.ix Remove
.sp
.ix String, Null Replacement
This command searches for the specified string and removes it from the text
buffer.  This command is exactly equivalent to the change command with a
null replacement string.  If the CP preceded the phrase "THIS IS A GOOD
EXAMPLE", then
.sp
       RTHIS IS \
.sp
would leave "A GOOD EXAMPLE".  The CP is left pointing to the first
character past the removed string.
.sp
S~~~~~~Search for a string
.ix S
.ix Search
.ix Buffer, Text
.ix Editor, Context
.ix Occurrence, Unique
.sp
This command is used to search for the occurrence of a string in the text
buffer and set the CP pointing to the first character after the matched
occurrence.  This command is very important in a context editor, because it
is valuable in placing CP in the desired location for editing.  By searching
for a unique occurrence of some phrase, sequence of characters, special
marker in the text, etc., the CP can be located very near the area of text
to be edited.
.sp
.ix Search
Assume that a particular word was misspelled in several places and needed to
be corrected.  We can locate the misspelled word by using the Search
command.  For example, if the CP were at the top of the buffer, and we knew
that AMOUNT was misspelled AMMOUNT somewhere in the buffer, the following
command would find the mispelled version:
.sp
       SAMMOUNT\
.sp
.ix L
.ix M
.ix C
.ix Search
Assume that a paragraph needed to be inserted in a section of a document
labeled "Questions and Answers".  The Search command could be used to locate
the section by searching for "Questions and Answers", and by applying the
Search command a few more times, the desired context can be located.  If
necessary, subsequent application of the "L" and "M" commands will pinpoint
the exact context.  Note that the "C" command includes a Search, which is
very convenient for finding and changing a string.
.pa
T~~~~~~Type (display lines)
.ix T
.ix Type
.ix Line Display
.ix CP
.sp
This command is used to make the editor print out lines of text (in the
buffer near CP) on the console.  This is particularly useful for examining
changes just made to the text, displaying the current context, or for
finding out exactly where the CP is.  Note that this is a command that asks
the editor to do some typing instead of the user.
.sp
       T
.sp
.ix Carriage Return
will type from the CP inclusive, up to and including the next
carriage-return.
.sp
       -5T5T
.sp
will type out ten lines; the five lines before the CP and the five lines
after the CP.
.sp
       0T
.sp
will type from the beginning of the line up to, but not including, the CP.
.sp
U~~~~~~Until (delete up to matched string)
.ix U
.ix Delete Until
.sp
This command is useful for deleting text from the current position of the CP
up to, but not including, the matched string.  For example,
.sp
       1U<tab>\
.sp
.ix WARNING
will delete every character from the CP inclusive, up to but not including
the first <tab> character.  Warning:  this can delete large chunks of text
if you give the wrong string as an argument; use it carefully!
.pa
Z~~~~~~Move CP to the end of the text buffer
.ix Z
.ix Buffer, Text End
.sp
Z is useful for moving the CP to the end of the text buffer to view the end
of the text buffer,
.sp
       Z-23T
.sp
or to insert text at the end of the text buffer:
.sp
.im 8
       ZILine 1
       Line 2
       Line 3
       .
       .
       .
       Line n
       \
.sp
<CR>~~~Moves CP forward 1 line and displays that line.
.ix <CR>
.ix Carriage Return
.sp
The <CR> command is exactly equivalent to "1L1T".  It is handy for stepping
through the text buffer one line at a time.
.pa
COMMONLY USED COMMAND SEQUENCES
.ix Command Sequence
.ix Command, Common
.tc
.sp
Some examples of common types of command sequences are given below:
.sp
.in 23
.un 16
SEQUENCE~~~~~~~~~~~~~~~EXPLANATION
.sp
.un 16
CNUTZ\NUTS\~~~~~Change "NUTZ" to "NUTS"
.br
.un 16
0TT~~~~~~~~~~~~~Type the current line
.br
.un 16
0LT~~~~~~~~~~~~~Position CP to the beginning of the Line and Type it
.br
.un 16
BS<CR>
.br
.un 16
LABEL\-TT~~~~~~~Find the first occurence of "<Carriage-Return>Label"
and type the previous line and the current line
.br
.un 16
23T~~~~~~~~~~~~~Type a screen-full of context
.br
.un 16
23L23T~~~~~~~~~~Move CP forward 23 Lines then Type a screen-full of context
.br
.un 16
-10T10T~~~~~~~~~Type the previous 10 lines and the next 10 lines
.br
.un 16
2C.\,\~~~~~~~~~~Change the second period to a comma (and type the line if
Auto-Type is on)
.br
.un 16
ILOTSA<CR>
.br
.un 16
WORDS\-2TT~~~~~~Insertion.  Inserts the text LOTSA<CR>WORDS at CP,
and then types 3 lines around CP.  Note that the entire inserted string is
inserted before the CP.
.sp
.in 0
.ix 0TT
.ix Type From Beginning
.ix Automatic Type, Engage
.ix Automatic Type, Disable
Probably the most useful sequence of editing commands is "0TT" which means
type from the beginning of the line up to the CP (0T part) and then type the
remainder of the line from the CP (T part). The net effect is to type the
current line, no matter where the CP is within the line, and without moving
the CP. Since this command is so commonly used, EDIT provides for an
automatic "0TT" after every change, delete, search, remove or move CP
command.  "0EA" will disable the auto-type feature. "1EA" will re-enable it.
.sp
.ix S
.ix X
Once the user is familiar with the commonly used commands, he should
investigate the empty string search (see "S" command in Detailed Command
descriptions section) and the X command, as they prove to be very useful.
.pa
TWO SIMPLE EDITING EXAMPLES
.ix Example
.tc
.sp
.ix Prompt
.ix File, New
.ix Form
.ix ^L
In the first example, a new file is created in the Editor. Note the "\"
character appearing in the left margin.  This is the editor's signal that it
is expecting more of a string argument. Note also that a TAB character has
been consistently used when moving from the left margin to the first word in
a line; this is why the r10\ command below does not affect the spacing. 
Note the "12V" command in Example 1; this is the most common method of
putting a "Form" character in the buffer.  The ^L is printed by EDIT when it
outputs a form.
.sp
Example 1:
.sp
.im 71
.EDIT
EDIT V1.1s    Copyright (C) 1979 Software Dynamics
*ewprimes.bas\
*I10    **** PRIME NUMBER CHASER ****
\       REM PRINTS OUT FIRST 100 PRIME NUMBERS
\       DIM X, PRIMES (100), CANDIDATE/3/
\       DIM PRIMESELECTOR, NPRIMES/1/
\       PRINT "Prime Finder"
\       PRIMES(NPRIMES) = 2
\       X = PRIMES(PRIMESELECTOR)
\\
*-LT
        X = PRIMES(PRIMESELECTOR)
*i100   FOR I = 1 TO NPRIMES
\\
*z-23t
10      **** PRIME NUMBER CHASER ****
        REM PRINTS OUT FIRST 100 PRIME NUMBERS
        DIM X, PRIMES (100), CANDIDATE/3/
        DIM PRIMESELECTOR, NPRIMES/1/
        PRINT "Prime Finder"
        PRIMES(NPRIMES) = 2
100     FOR I = 1 TO NPRIMES
        X = PRIMES(PRIMESELECTOR)
*br10\miREM\
        REM**** PRIME NUMBER CHASER ****
*0t
        REM*i \
        REM **** PRIME NUMBER CHASER ****
*zi     IF INT(CANDIDATE/X) * X = CANDIDATE THEN 180
\       NEXT PRIMESELECTOR
\       ! FOUND A NEW PRIME
\       NPRIMES = NPRIMES + 1
\       PRIMES(NPRIMES) = CANDIDATE
\       CANDIDATE = CANDIDATE + 2
\       IF NPRIMES <> 100 THEN 100
\       FOR PRIMESELECTOR = 1 TO 100
\       PRINT PRIMES(PRIMESELECTOR)
\       NEXT PRIMESELECTOR
\       PRINT ' All Done!'
\200    STOP
\       END
\\
*12V
^L*-23T
        REM **** PRIME NUMBER CHASER ****
        REM PRINTS OUT FIRST 100 PRIME NUMBERS
        DIM X, PRIMES (100), CANDIDATE/3/
        DIM PRIMESELECTOR, NPRIMES/1/
        PRINT "Prime Finder"
        PRIMES(NPRIMES) = 2
100     FOR I = 1 TO NPRIMES
        X = PRIMES(PRIMESELECTOR)
        IF INT(CANDIDATE/X) * X = CANDIDATE THEN 180
        NEXT PRIMESELECTOR
        ! FOUND A NEW PRIME
        NPRIMES = NPRIMES + 1
        PRIMES(NPRIMES) = CANDIDATE
        CANDIDATE = CANDIDATE + 2
        IF NPRIMES <> 100 THEN 100
        FOR PRIMESELECTOR = 1 TO 100
        PRINT PRIMES(PRIMESELECTOR)
        NEXT PRIMESELECTOR
        PRINT ' All Done!'
200     STOP
        END
^L*bsDATE + 2\0LT
        CANDIDATE = CANDIDATE + 2
*i180\
180     CANDIDATE = CANDIDATE + 2
*exit
.pa
.ix File, Existing
.ix *
.ix Prompt
.ix <CR>
In this example, an existing file (produced in Example 1) is edited.   Lines
which contain only an "*" are prompts printed by EDIT, with <CR> (which acts
as 1L1T) entered by operator.  "-EA" was done to show CP location.
.sp
Example 2:
.sp
.im 97
.edit
EDIT V1.1s    Copyright (C) 1979 Software Dynamics
*ebprimes.bas\
*-ea
*1ab23t
        REM **** PRIME NUMBER CHASER ****
        REM PRINTS OUT FIRST 100 PRIME NUMBERS
        DIM X, PRIMES (100), CANDIDATE/3/
        DIM PRIMESELECTOR, NPRIMES/1/
        PRINT "Prime Finder"
        PRIMES(NPRIMES) = 2
100     FOR I = 1 TO NPRIMES
        X = PRIMES(PRIMESELECTOR)
        IF INT(CANDIDATE/X) * X = CANDIDATE THEN 180
        NEXT PRIMESELECTOR
        ! FOUND A NEW PRIME
        NPRIMES = NPRIMES + 1
        PRIMES(NPRIMES) = CANDIDATE
180     CANDIDATE = CANDIDATE + 2
        IF NPRIMES <> 100 THEN 100
        FOR PRIMESELECTOR = 1 TO 100
        PRINT PRIMES(PRIMESELECTOR)
        NEXT PRIMESELECTOR
        PRINT ' All Done!'
200     STOP
        END
^L*
        REM PRINTS OUT FIRST 100 PRIME NUMBERS
*
        DIM X, PRIMES (100), CANDIDATE/3/
*
        DIM PRIMESELECTOR, NPRIMES/1/
*
        PRINT "Prime Finder"
*
        PRIMES(NPRIMES) = 2
*
100     FOR I = 1 TO NPRIMES
*cI\PRIMESELECTOR\
100     FOR PRIMESELECTOR = 1 TO NPRIMES

                         ^
*
        X = PRIMES(PRIMESELECTOR)
*
        IF INT(CANDIDATE/X) * X = CANDIDATE THEN 180
*i      Q = INT(CANDIDATE/X)
\       IF Q < X THEN 130
\\-2tt
        Q = INT(CANDIDATE/X)
        IF Q < X THEN 130
        IF INT(CANDIDATE/X) * X = CANDIDATE THEN 180
*sIF \1u \
        IF  * X = CANDIDATE THEN 180

           ^
*0t
        IF *iQ\
        IF Q * X = CANDIDATE THEN 180

            ^
*
        NEXT PRIMESELECTOR
*
        ! FOUND A NEW PRIME
*i130\
130     ! FOUND A NEW PRIME

   ^
*z-23t
        REM **** PRIME NUMBER CHASER ****
        REM PRINTS OUT FIRST 100 PRIME NUMBERS
        DIM X, PRIMES (100), CANDIDATE/3/
        DIM PRIMESELECTOR, NPRIMES/1/
        PRINT "Prime Finder"
        PRIMES(NPRIMES) = 2
100     FOR PRIMESELECTOR = 1 TO NPRIMES
        X = PRIMES(PRIMESELECTOR)
        Q = INT(CANDIDATE/X)
        IF Q < X THEN 130
        IF Q * X = CANDIDATE THEN 180
        NEXT PRIMESELECTOR
130     ! FOUND A NEW PRIME
        NPRIMES = NPRIMES + 1
        PRIMES(NPRIMES) = CANDIDATE
180     CANDIDATE = CANDIDATE + 2
        IF NPRIMES <> 100 THEN 100
        FOR PRIMESELECTOR = 1 TO 100
        PRINT PRIMES(PRIMESELECTOR)
        NEXT PRIMESELECTOR
        PRINT ' All Done!'
200     STOP
        END
^L*exit

End Of File hit
.* (Back at SDOS Command Interpreter)
.pa
DETAILED COMMAND DESCRIPTIONS
.ix Command, Detailed Description
.tc
.sp
.ix Command, Syntax
This section gives detailed information on all EDITor commands.  Editor
commands have the following syntax:
.sp
.im 1
   <VALUE><COMMAND><STRING><DELIMITER><STRING><DELIMITER>
.sp
.ix Value
<VALUE> is an integer in the range of -32768 to +32767.  The value may be
further restricted by the individual command that uses it.  The value may be
supplied as a result of a previous command.  Some commands do not allow a
value to be supplied.
.sp
.ix Command
.ix Command, Relational
.ix Command, Extended
.ix Lowercase
.ix Uppercase
<COMMAND> is the editing command indicating what operation is to be
performed.  This is normally a single character; exceptions are the
relational commands and the extended commands (E-type).  Lower case commands
are treated as the equivalent of upper case commands.
.sp
.ix String
.ix Operating System
.ix Delimiter
.ix Carriage Return
.ix String, Null
<STRING> is an arbitrary sequence of characters, not including the current
delimiter or any characters which are given special treatment by the
operating system (these are system dependent -- consult your operations
manual).  The string may include a carriage-return <CR>.  A "null" string is
one that has zero characters in it.
.sp
.ix Delimiter
.ix String, End
.ix G
<DELIMITER> is a character chosen by the user to indicate end-of-string. 
EDIT initially assumes "\" (backslash) as the delimiter, but this may be
changed by the G command.
.sp
.ix Command, Description
.ix Command, Format
.ix Error, Syntax
.ix Value, Default
Each command has some variation of the above syntax, which is indicated with
the command description.  If the command description indicates a particular
format, then the command must be given to the editor exactly as specified,
or a syntax error will result (exception: <VALUE> is usually optional, with
a default, or the previous command may supply it).
.sp
.ix Value Register
There are ten value registers numbered 0 through 9.  These registers are
useful for remembering the location of the CP. They can also be used as
counter registers or single character registers (since a character can be
represented as a value) in the more sophisticated editing sequences.
.sp
.ix String, Null
A special "convenience" allows commands that search the text to search for a
previously entered string, if the specified search string is null.  See S
command description.
.pa
In the command descriptions, the following notation is used:
.sp
.ix Value, Default
.ix Command, Blank
"n" refers to a user or previous command specified value.  If the user gives
a value, it overrides the default; a value supplied by a previous command
may be overridden with the blank command; if n is not indicated in the
syntax, it must not be supplied.
.sp
"d" refers to a single digit (0-9).
.sp
.ix Delimiter
\ (backslash) represents the current delimiter.
.sp
s1,s2 are strings, not including the current delimiter.
.sp
.ix Line
.ix Buffer, Text
.ix Carriage Return
.ix CP
A line is a sequence of characters in the text buffer that is bounded by
carriage-return <CR> characters.  It includes the CR at the end, but not at
the beginning.  The current line is defined to be a line containing a
character pointed to by CP.
.sp
.ix Workspace
.ix Buffer, Text
.ix Buffer, Command
.ix Register, Text
Workspace refers to the total space available to the editor for all buffers,
i.e., text buffer, command buffer, and text registers.
.sp
.ix Yank
.ix Buffer
.ix File, Input
"Yank" means to make the buffer empty, and then to fill the buffer using the
next page from the input file.
.sp
.ix Iteration
.ix []
An iteration is a command sequence enclosed by a [ ] pair.
.pa
.in 10
.un 10
nA
.br
.ix Append
.ix A
.ix Buffer, Text
.ix Buffer, End
.ix Value, Default
.ix CP
.ix Error, Recoverable
.ix Error, End Of File Hit
Append.  If n > 0, the next n pages of the source file are appended to the
text buffer at the end of the buffer.  If n <= 0, an error is given; the
default value for n is 1.  CP is positioned to the beginning of the first
appended page.  The only recoverable error is End of File Hit.
.sp
.un 10
B
.ix B
.ix Begin
.ix Buffer, Text
.br
Begin.  Moves CP to the first character in the text buffer.  This command is
the same as "1J".
.sp
.un 10
nCs1\s2\
.ix C
.ix Change
.ix Error
.ix Value, Default
.ix CP
.ix Buffer
.ix S
.ix Error, String Not Found
.ix Error, Recoverable
.br
Change.  Causes the nth occurrence of s1 to be changed to s2.  If n = 0, an
error is given.  If n > 0, a forward search is made.  If n < 0, a backwards
search is made.  The default value of n is 1.  CP is left pointing to the
first character after s2 in the buffer.  See S command if s1 is null.  The
only recoverable error is "string not found".  The change command is
equivalent to nSs1\Xs2\.
.sp
.un 10
nD
.ix D
.ix Delete
.ix CP
.ix Value, Default
.ix Error, Delete Off End Of Buffer
.ix Error, Recoverable
.br
Delete.  Deletes the next n characters relative to CP.  If n = 0, an error
is given.  If n > 0, deletion is in the forward direction starting with and
including CP.  If n < 0, deletion is in the reverse direction, but does not
include CP.  There is no default value for n.  The only recoverable error is
"Delete off the end of the buffer."
.pa
.un 10
nEA
.ix EA
.ix Automatic Type
.br
.ix Value, Default
Auto-type.  The auto-type flag controls the automatic typing of the current
line.  If n = 0, the auto-type flag is reset.  If n is 1 or -1,  the flag is
set. There is no default value for n.  EDIT starts with 1EA.  If the
auto-type flag is set, commands which move the CP or make changes to the
text buffer (see table below), will automatically type (0TT) the current
line after successful execution if that command is the last command in the
command string.  For example:
.br
       BSHELLO\.EV1
.br
will not auto-type, while
.br
       BSHELLO\
.br
will.  If n=-1 then auto-type is enabled and the CP position will be
indicated by a "^" on an auto type (exception:  no caret will be displayed
if CP is at 0L of a line).  For example, if the buffer in the example above
contained "SAY HELLO there.", then the session would appear as
.br
       *BSHELLO\
.br
       SAY HELLO there.
.br
                ^                      
.br
       *
.sp
This setting is recommended for persons new to the concept of the CP.  To
find the CP position on the current line use "0M".
.sp
Commands which auto-type:
.ix Command, Automatic Type
.br
.nj
.pw 120
.ll 100
.im 11
          A(ppend)                       N(ext)
          B(egin)                        P(unch)
          C(hange)                       Q(uerysearch)
          D(elete)                       R(emove)
          EY                             S(earch)
          F(ind)                         U(ntil)
          I(nsert partial line)          V(alueinsert)
          J(ump)                         W(rite)
          K(ill)                         X(change)
          L(ine)                         <tab>(insert partial line)
          M(ove)
.ju
.ll 65
.pw 85
.br
.sp
.un 10
EBs1\
.ix EB
.ix Edit Backup
.ix .BAK Extension
.ix EDITOR.TMP
.ix Error, No Such File
.ix Error, Recoverable
.br
Edit Backup.  Edit file s1 creating a backup file. The precise effect when
executed is: ERs1\EWEDITOR.TMP\.  When an EF, EXIT, or EW is executed after
an EB, the original file s1 is renamed with a .BAK extension; then
EDITOR.TMP is renamed to s1.  NOTE: if s1 has a device designation in it,
EDITOR.TMP will be created on that device (if possible).  The only
recoverable error using "?" is "No such file".
.pa
.un 10
ECs1\
.ix EC
.ix Copy
.ix Buffer, Text
.ix Text Preceding CP Flushed
.ix ER
.ix Error, Recoverable
.ix Error, No Such File
.br
Edit copy.  Copy the entire contents of file s1 into the text buffer before
CP.  If there is not enough room in the text buffer, then to make room,
lines are output from the beginning of the buffer up to CP, until the file
has been copied; the Editor will indicate this has happened by printing out
"Text preceding CP flushed".  The status of the input (ER) file is not
affected.  CP is left pointing after the text copied into the buffer.  The
only recoverable error ("?") is "No such file".
.sp
.un 10
EF
.ix EF
.ix Edit Finish
.ix File, Output
.ix File, Input
.ix Buffer, Text
.ix Exit
.br
Edit finish.  Copy the text buffer to the output file, then copy the
remaining portion of the input, if any, to the output file.  If no output
file is currently open, the input file is closed and the text buffer is
cleared.  If ERs1\ was used to open an input file, a close s1 is performed. 
If EWs2\ was used to open an output file, a close s2 is performed.  The
buffer is left empty.  This is identical to EXIT except that control is
returned to the EDITor.
.sp
.un 10
EIs1\
.ix EI
.ix Edit Input
.ix Keyboard, Suspend
.ix SDOS
.ix File, DO
.ix Error, Recoverable
.ix Error, No Such File
.br
Edit input.  Causes editor to suspend accepting commands from the keyboard
(specifically, channel 0 by SDOS conventions) and to accept commands from
the file whose name is s1.  When the file is exhausted, the editor will
automatically switch back to accepting commands from the keyboard (channel
0).  This command is primarily used by DO files under SDOS which invoke the
editor so that keyboard input can be used while the DO file is active, or to
execute pre-canned sequences of editor commands stored in a file.  The only
recoverable error ("?") is "No Such File".
.sp
.un 10
nEOs1\
.br
.ix EO
.ix Edit Output
.ix Buffer, Text
.ix File, New
.ix Value, Default
.ix Error, Recoverable
.ix Error, Write Off End Of Buffer
Edit output.  A file named s1 is created and the next n lines of the text
buffer are output to the newly created file; then the file is closed.  If
n<0, the previous n lines are copied to the output file.  If n=0, the
current line is written from its beginning up to, but not including CP.  If
n>0, the next n lines are output, starting from CP.  There is no default
value for n.  The output lines are NOT deleted from the text buffer.  The
only recoverable error is "Write off end of buffer."  (i.e., n is larger
than number of lines left between CP and end of buffer).
.pa
.un 10
ERs1\
.ix ER
.ix Edit Read
.ix File, Input
.ix String, Empty
.ix Error, Recoverable
.ix Error, No Such File
.br
Edit read.  Open file s1 for input.  If there is a currently open input
file, close it, then open s1. If s1 is the empty string, the input file is
closed and no new input file is opened.  The only recoverable error ("?") is
"No such file".
.sp
.un 10
ETt1,t2,...,tk
.ix ET
.ix Tab, Set
.ix Tab, Default
.br
Set tabs.  The tab stops are set to t1,t2,...,tk (column numbers).  Tab
stops are used for displaying tab characters.  There are a maximum of 20 tab
stops allowed on a (displayed) line.  If there are unspecified tab stops,
they are assigned values that are increments of 8 after the last specified
tab stop.  The default tab stops are 8, 16, 24, 32...  This command must be
the last command on a command line.
.sp
.un 10
EUd
.ix EU
.ix Value Register
.ix Search
.ix String, Target
.br
Use value.  The value of register d is returned as a value for the next EDIT
command.  NOTE: EU0 returns the negative of the size of last successful
search target string (negative if "S", "N", "Q"; positive if "F") or insert
if CP has not been moved since; otherwise, it returns 0.  Note: d must be a
digit 0-9.
.sp
.un 10
nEVd
.ix EV
.ix Value, Store
.ix Value, Default
.br
Store value.  The value n is stored into value register d.  This command is
intended for use with EUd.  There is no default value for n.  NOTE: d may
only be 1-9.
.sp
.un 10
EWs1\
.ix EW
.ix Edit Write
.ix File, Output
.br
Edit write.  If an output file is currently open, close it.  If file s1 does
not exist, it is created for use as the output file.  EW\ closes the output
file.
.sp
.un 10
EXIT
.ix Exit
.ix EF
.ix SDOS Command Interpreter
.br
Exit.  Perform an EF, then exit to SDOS command interpreter.
.sp
.un 10
nEY
.ix EY
.ix Yank
.ix Buffer, Clear
.br
.ix EZ
.ix Value, Default
.ix Error, Recoverable
.ix Error, End Of File Hit
Yank.  Clear the buffer and read in n pages.  If n <= 0, an error is given. 
If n > 0, the command is identical to EZnA.  There is no default value for
n.  CP is left pointing to the first character in the buffer.  The only
recoverable error is "End of file hit."
.sp
.un 10
EZ
.ix EZ
.ix Edit Zap
.ix Buffer, Delete Text
.br
Edit zap.  An E-Z way to delete the entire contents of the text buffer.
.pa
.un 10
nFs1\
.br
.ix F
.ix Find
.ix Buffer, Text
.ix Value, Default
.ix S
.ix Error, String Not Found
.ix Error, Recoverable
Find.  Starting with CP, search the text buffer for the nth occurrence of s1
in the buffer.  CP is left pointing to the first character of s1 in the
buffer.  If n = 0, an error is given.  If n < 0, a backward search is made. 
If n > 0, a forward search is made.  The default value for n is 1.  See S
command if s1 is null.  The only recoverable error is "String not found."
.sp
.un 10
Gchar
.ix G
.ix Delimiter, Change
.br
.ix <CR>
Get delimiter.  Char is taken as the new delimiter. Char must be a valid
printing character, and must not be a letter.  The G command must be the
last command on a line, and must be followed by a <CR>. For example:
.sp
       *G\
.sp
.un 10
H
.ix H
.ix Bytes, Free
.ix Workspace, Free
.br
Returns the number of free bytes in the editor's workspace as a value.
.sp
.un 10
nIs1\
.ix I
.ix Insert
.ix Buffer, Text
.ix CP
.br
.ix Default
Insert.  Place s1 into the text buffer just in front of CP.  CP remains
pointing to the character it was originally pointing to, i.e., after the
inserted string.  If n <= 0, an error is given.  If n > 1, the insert is
performed n times.  n defaults to 1.
.sp
.un 10
nJ
.ix J
.ix Jump
.ix B
.ix Error, Recoverable
.ix Error, Jump Off End Of Buffer
.br
Jump.  Moves the CP to the nth line in the buffer.
If n <= 0, an error is given.  n = 1 does the same
as a "B" command.  n > 0, does the same as a "BnL"
command sequence.  There is no default value for n.
The only recoverable error is "Jump off end of
buffer."
.sp
.un 10
nK
.ix K
.ix Kill
.ix Delete
.ix Error, Recoverable
.ix Error, Kill Off End Of Buffer
.br
Kill.  Causes the next n lines, starting with CP to be deleted.  If n < 0,
deletion is done backwards, starting with the character before the CP.  If n
= 0, the current line is deleted from its beginning up to, but not
including, the CP.  If n > 0, the next n lines are deleted starting from the
CP. There is no default value for n.  The only recoverable error is "Kill
off end of buffer."
.pa
.un 10
nL
.ix L
.ix Line
.ix <CR>
.ix Error, Recoverable
.ix Error, Move CP Off End Of Buffer
.br
Line.  Moves the CP forward across n CR characters. If n < 0, the CP is
moved backwards.  If n = 0, the CP is moved to the beginning of the current
line. If n > 0, the CP is moved forward.  The default value for n is 1.  The
only recoverable error is "Move CP off end of buffer."
.sp
.un 10
nM
.ix M
.ix Move
.ix Error, Recoverable
.ix Error, Move CP Off End Of Buffer
.ix Default
.br
Move.  Moves the CP n characters.  If n < 0, CP is moved backwards.  If n =
0, CP is not moved.  If n > 0, CP is moved forward.  n defaults to 1. The
only recoverable error is "Move CP off end of buffer."
.sp
.un 10
nNs1\
.ix N
.ix Next Occurrence
.ix Search
.ix Buffer
.ix P
.ix Punch
.ix Value, Default
.ix S
.ix Error, String Not Found
.ix Error, Recoverable
.ix Buffer Boundary
.br
Search for next occurrence.  Starting with the CP, searches forward for s1
in the buffer.  If found, n is decremented; if n goes to zero, the operation
is complete.  Otherwise, the search is repeated starting from the end of the
last occurrence of the string.  If s1 is not found in the buffer, then the
current page is punched (1P), and the operation continues.  If n <= 0, then
an error is given. There is no default value for n.  Leaves CP following s1
in the buffer.  See S command if s1 is null. The only recoverable error is
"String not found." Note: the N command can generally be used in place of S;
this has the advantage of making buffer boundaries mostly invisible.
.sp
.un 10
nP
.ix P
.ix Punch
.ix Buffer, Output
.ix Buffer, Clear
.ix Yank
.ix Error, End Of File Hit
.ix Error, Recoverable
.br
Punch.  The current contents of buffer is output, and then the buffer is
cleared.  If n = 0, nothing else is done; if n >= 1, then n-1 pages are
copied from the input to the output file, and the next input page is yanked.
There is no default value for n.  The only recoverable error is "End of file
hit."
.sp
.un 10
nQs1\
.ix Q
.ix Query
.br
.ix N
.ix EY
.ix S
.ix Error, Recoverable
.ix Error, String Not Found
Query.  Like the N command, but does not output any pages (does a 1EY
instead of a 1P).  See S command if s1 is null. The only recoverable error
is "string not found."
.pa
.un 10
nRs1\
.ix R
.ix Remove
.ix Delete
.br
.ix Search, Backwards
.ix Search, Forwards
.ix Value, Default
.ix Error, Recoverable
.ix Error, String Not Found
Remove.  Deletes the nth occurrence of s1 and leaves CP pointing to the
first character following the deleted occurrence of s1.  If n = 0, an error
is given.  If n < 0, a backward search is made.  If n > 0, a forward search
is made.  The default value for n is 1.  See S for null S1.  The only
recoverable error is "String not found."
.sp
.un 10
nSs1\
.ix S
.ix Search
.ix Buffer, Text
.ix String, Null
.ix Search, Default
.ix Error, String Not Found
.ix Error, Recoverable
.ix String, Target
.br
Search.  Searches the text buffer for the nth occurrence of s1 and leaves
the CP pointing to the first character following s1 in the buffer.  If n =
0, an error is given.  If n < 0, a backward search is made.  If n > 0, a
forward search is made.  The default value for n is 1.  A null search string
(i.e., s\) will default the search target to the previous search string
(size limited to 250 characters).  If the search for a default string fails,
the target string is displayed, enclosed by the current delimiter.  The only
recoverable error is "String not found."
.sp
.un 10
nT
.ix T
.ix Type
.ix CP
.ix Error, Type Off End Of Buffer
.ix Error, Recoverable
.br
Type.  Types the next n lines starting with the CP. If n < 0, the previous n
lines are typed.  If n = 0, the current line is typed from its beginning up
to, but not including the CP.  If n > 0, then the next n lines are typed. 
The default value for n is 1.  1T types from CP to the end of the line
containing CP, and is useful for determining where the editor left CP.  0TT
will type the entire line containing CP.  The only recoverable error is
"Type off end of buffer."
.sp
.un 10
nUs1\
.ix U
.ix Until
.ix Delete
.br
.ix S
.ix Error, String Not Found
.ix Error, Recoverable
Until.  Deletes all characters from CP to the nth occurrence of s1, but not
including any part of the nth occurrence of s1.  If n = 0, an error is
given. Backward deletion occurs (not including the character under CP) if n
< 0.  Forward deletion occurs (including CP) if n > 0.  Leaves the CP
pointing to the first character following the deleted characters.  If s1 is
not found, nothing is deleted.  There is no default value for n.  See S
command if s1 is null. The only recoverable error is "String not found."
.sp
.un 10
nV
.ix V
.ix Value Insert
.ix Character, ASCII
.br
Value insert.  Convert n to its Ascii character equivalent and insert it in
front of the CP.  If n < 0, or n > 127, an error is given.  There is no
default value for n.  For example, to insert a FORM character at CP, use
"12V".
.pa
.un 10
nW
.ix W
.ix Write
.ix File, Output
.ix Copy
.ix Delete
.ix Error, Write Off End Of Buffer
.ix Buffer, Text
.ix Error, Recoverable
.br
Write.  Writes lines to the output file.  If n < 0, the previous n lines are
copied to the output file. If n = 0, the current line is written from its
beginning up to, but not including CP.  If n > 0, the next n lines are
output, starting from CP. There is no default value for n.  The output lines
are deleted from the text buffer.  The only recoverable error is "Write off
end of buffer."
.sp
.un 10
Xs1\
.ix X
.ix Exchange
.ix Insert
.ix Change
.ix Search
.br
Exchange.  This command only works if the CP has not been moved since the
last I, C, S, N, Q, F, or X command (these commands set EU0 to the size of
the string inserted or replaced).  This command exchanges s1 for the last
string inserted, changed, searched for or exchanged.  Register 0 is used to
control the exchange.  If EU0 yields 0, X will not function.  If EU0 is
non-zero the effect of the X instruction is: EU0DIs1\.
.sp
.un 10
nYs1\
.ix Y
.ix String, Verify
.ix S
.br
Verify string.  In n = 1, s1 is compared to the string pointed to by CP.  If
n = -1, s1 is compared to the string before CP.  n <> 1 or n <> -1 is
illegal.  If s1 matches, the value 1 is returned, else returns 0.  The
default value for n is 1.  See S command if s1 is null.
.sp
.un 10
Z
.ix Z
.ix Zip
.br
.ix Buffer, Text
Zip to end of buffer.  Moves the CP to the end of the text buffer (beyond
the last character).
.pa
.un 10
^Is1\
.br
.ix ^I
.ix Tab
Tab.  Like I, but repetition cannot occur, and s1 is placed in the buffer
preceded by a tab character.  CP is left pointing to the first character
after the inserted string.
.sp
.un 10
n[
.ix []
.ix Iteration
.ix Iteration, Abort
.ix Key, Escape
.ix Command, Repeat
.br
Repeat.  Do all commands inside [ ] n times.  If n < 0, an error is given. 
If n = 0, commands inside the [ ] are skipped over.  If n is not given, the
iteration is repeated forever (exit is normally made via ^ or ] ).  The
escape key can be used to abort the iteration.
.sp
.un 10
n]
.ix []
.ix Continue
.ix Iteration Counter
.br
Continue.  If n = 0, command interpretation will exit the [ ] pair.  If n <>
0, decrement the iteration counter and continue interpreting commands in the
iteration from the matching [ if the counter > 0.  If the iteration count
goes to zero, exit the [ ] pair and continue execution with the command to
the right of the ].  The default value for n is 1.
.sp
.un 10
?
.ix ?
.ix Status
.ix Value
.br
Status.  This command must immediately follow a command.  A value followed
by a "?" is not allowed. Yields 0 if the previous command failed, else
yields 1.  This value can be used as a value in an expression for the next
command.
.sp
.un 10
n^
.ix ^
.ix Abort
.br
Abort.  Command execution will exit the [ ] pair if n = 0.  If n <> 0, ^ is
a no-op.  There is no default value for n.
.sp
.un 10
n$
.ix $
.ix Complement
.ix Relational
.ix Status
.br
Complement.  If n = 0, the result is 1, otherwise 0.  This is used to
complement the state of relationals, status, etc.  There is no default value
for n.
.sp
.un 10
#d
.ix #
.ix Label
.ix Branch, Conditional
.br
Label.  Used as a target of conditional branches. If d = 0, an error is
given.
.sp
.un 10
n_
.ix _
.ix Branch
.br
Branch.  If n < 0 or n > 9, an error is given.  If n = 0, no action is
taken.  The editor will continue command interpretation at label n if n > 0
and n <= 9 (i.e., start execution immediately following a #d command).  For
example:
.br
       [CHELLO\GOODBYE\?^ @='.*1_0TT] IMOM\ #1
.br
.ix Iteration
There is no default value for n.  Branching into an iteration is not
allowed, but branching out of one is legal.
.pa
.un 10
'char
.br
Value.  Yields the value of the character following
the single quote.  Char must be a printing
character.
.sp
.un 10
n;
.ix ;
.ix Continue
.ix Iteration Counter
.ix []
.br
Continue.  If n = 0, no action is taken.  If n <> 0, the editor decrements
the iteration counter, and continues the iteration from the innermost
enclosing [ if the counter > 0, else command interpretation exits the
innermost enclosing [ ] pair (similar to n] command).  There is no default
value for n.
.sp
.un 10
%
.ix %
.ix Iteration Count Value
.br
Iteration count value.  Yields the number of executed iterations (i.e., on
the first iteration, % yields 1, on the second iteration, % yields 2, etc.
.sp
.un 10
@
.ix @
.ix At
.ix Character, ASCII
.ix Value, Numeric
.ix Buffer, Null
.br
At.  Yields the numeric value of the Ascii character that CP points to. 
Only if CP is at the end of the buffer will @ yield 255.  A null in the
buffer (rare case!) will cause @ to return zero.
.sp
.un 10
n=
.ix =
.br
.un 10
n<
.ix <
.br
.un 10
n<=
.ix <=
.br
.un 10
n>=
.ix >=
.br
.un 10
n>
.ix >
.br
.un 10
n<>
.ix <>
.ix Relational
.ix Value, Relational
.br
Relationals.  Each relational must be followed by a value or a value
generating command.  Yields 0 if the relation is false, 1 if the relation is
true. There is no default value for n.
.sp
.un 10
n+
.ix +
.br
.un 10
n-
.ix -
.ix Add
.ix Subtract
.br
Add and subtract.  The default value for n is 0.
.sp
.un 10
n*
.ix *
.br
.un 10
n/
.ix /
.br
.un 10
n&
.ix &
.br
.un 10
n!
.ix !
.ix Multiply
.ix Divide
.ix And
.ix Or
.ix Operation, Binary
.br
Multiply, divide, and, or.  & and !  are bitwise binary operations.  For
example, 5!11 = 15, 5&11 = 1.  There is no default value for n.
.sp
.in 0
.ix .
.im 1
.
.in 10
.ix Period
.ix CP Position
.br
.ix Buffer, Text Beginning
Period.  The value representing CP's position (counted in characters) with
respect to the beginning of the text buffer.  When "." has the value zero,
the CP is at the beginning (B) of the buffer.  B23M gives the value "23" to
"." if there are more than 23 characters in the buffer.
.pa
.un 10
:
.ix :
.ix Colon
.ix Buffer, Text Beginning
.br
Colon.  The value representing the current line number with respect to the
beginning of the text buffer.  B15L gives ":" the value "15" (if there are
more than 15 lines in the buffer).
.sp
.un 10
( )
.ix ()
.ix Change, Precedence
.br
Precedence change.  Editor expressions are normally evaluated with operator
precedence determining the order of operations ("algebraically") unless ( )
overrides this.  Operator precedence is as follows:
.br
       * / &   are evaluated first
.br
       + - !   are evaluated next.
.br
       Relationals are evaluated last.
.sp
.un 10
n<CR>
.ix <CR>
.ix Value, Print
.ix Command Line
.br
Print value.  If an explicit value precedes the CR, then that value is
printed.  If n is not supplied, nothing is typed.  If a command line
consists merely of <CR>, it is treated as if 1L1T had been typed.
.sp
.un 10
n<BLANK>
.ix <Blank>
.ix Value, Eat
.ix Command Sequence, Construct
.ix Command, Blank
.ix Macro Readibility
.br
Eat value.  The value is consumed.  This command is useful for constructing
command sequences that consist of a command that explicitly cannot have a
value preceded by a command that yields a value; this can be done by
separating the two commands with the blank command.  If n is not supplied,
the blank command is a no-op.  This command can be used to increase
readability of macros.
.in 0
.pa
COMMAND STRING PROCESSING
.tc
.ix Command String Process
.sp
.ix CR Character
.ix Looping
.ix _
.ix ]
EDIT collects an entire command string before executing any commands.  A
command string is a series of commands ended by a CR character (a CR
embedded in a string argument does not "end" the command string).  Once a
command string has been entered, the commands are executed from left to
right until no more commands remain.  Note that looping may occur due to the
_ or ] commands.
.sp
.ix Input
.ix Operating System
.ix Input, Console
Typed input to EDIT is subject to the operating system conventions for line
editing on console input.
.sp
.ix Command Interpretation
.ix Key, Escape
.ix Yank
.ix Punch
.ix Type
.ix Extension
Command interpretation may be stopped by using the ESCape key.  This key is
checked upon encountering a ;, ], yank, punch, type, extension command
(E-type), or during console input.  A message is given when the ESCape key
is used.
.sp
.ix Command Interpretation
.ix []
.ix ^
.ix ;
Command interpretation is normally left-to-right, with changes in order as
directed by [ ], ^, ;, and commands.
.sp
.ix Workspace
Any command exhausting workspace room will cause command interpretation to
terminate.
.sp
ERROR HANDLING
.ix Error Handling
.tc
.sp
EDITor commands complete in one of 3 ways:
.sp
       Successful termination
.br
       Recoverable error
.br
       Abortive error
.sp
.ix Successful Termination
.ix Error, Recoverable
.ix Error, Abortive
If an editor command can be performed exactly as requested by the user, the
command terminates successfully, and the editor then proceeds to execute the
next command.
.sp
If a command fails for an unusual reason, then the editor will abort
execution of the remainder of the  command string, print the line
(containing the error) of the command string, a pointer, and an error
message describing the problem.
.sp
Example:
.sp
       *ER%\
.br
       ER%\
.br
       ^
.br
       Filename doesn't begin with A-Z or $
.pa
.ix Failure, Reason
.ix Error Recovery, Automatic
.ix Macro
.ix ?, Trailing
.ix Branch, Conditional
.ix Looping, Conditional
Some commands fail for common reasons, e.g., the search command might not
find the desired string.  Automatic error recovery may be built into macros
for handling the most common reasons.  The success or (recoverable) failure
of a command may be tested by use of a trailing "?" (status) following the
command; this ?  Will produce a value of 1 for success or 0 for failure. 
This value may be used by a following command to effect conditional
branching or looping.
.sp
Example:
.br
       sABC\?_ sDEF\#1xXYZ\
.br
changes the first occurence of ABC or DEF to XYZ.
.sp
.ix Error, Disk Read
Each command that can fail in a recoverable fashion has only one recoverable
condition.  All other failure conditions are treated as abortive, i.e., a
Disk Read Error is a non-recoverable error condition for an N command.
.sp
.ix Command Termination, Abortive
.ix Delimiter
.ix Text
.ix Buffer
.ix Error Recovery
In the case of abortive command termination, the EDITor will allow the user
to save (insert) the entire command string (delimiters, commands, text and
all) in the buffer at the current CP if the command string is more than 40
characters long.  This is a useful "do what I mean" error recovery in cases
where the user forgot to precede a large chunk of text by an I, and many
other circumstances.
.sp
Example:
.sp
.im 16
.edit

EDIT V1.1q   Copyright (C) 1979 Software Dynamics
*ewd1:lamb\
*Once upon time, there was a little lamb
\who loved to go to school with his
\master.  Everybody knew the lamb was
\gentle and kind.
\\

Once upon time, there was a little lamb
^
Illegal character
Did you really want to insert that whole command string? y
*exit

A response of anything not starting with the letter N saves the offending
command; any other response throws it away.
.sp
.ix File, DO
.ix Exit
If an error (other than 216 [Can't Find String] or 226 [End of File prior to
"A" or "EY"]) occurs while the EDITor is running under a DO file and is not
operating in EI mode, then at EXIT time, the EDITor will report the
existence of that error to SDOS.
.pa
VALUES RETURNED FROM COMMANDS
.tc
.sp
The following commands return explicit values:
.sp
.nj
       @ : * / & + - = < <= !
.br
       >= > <> % $ ? EUd nYs1\ .
.ju
.sp
.ix Value, Implicit
.ix Value, Explicit
.ix ?, Trailing
.ix Error, Recoverable
.ix Error, Non-Recoverable
The following commands return implicit values  (the implicit value can be
converted to an explicit value by use of a trailing "?" command).  These
commands either succeed or they give errors and stop.  If they are followed
by the "?" command, and no error occurs during command execution, a 1 is
returned; if a recoverable error occurs, a 0 is returned; and if a
non-recoverable error occurs, the command string is aborted.
.sp
.nj
       A C D EB EC ER EY F N P Q R S U
.ju
.sp
.ix Error, End Of The Buffer
The following commands also return implicit values; these commands either
succeed, or they fail in a recoverable way. However, if they fail, they
never give errors.  If they are followed by the "?" command, a 1 or 0 is
generated if the command succeeded or failed respectively.  These commands
all share the property that a recoverable failure has to do with an
operation that runs off the end of the buffer, and are friendly about it for
the user's convenience.
.sp
.nj
       EO K J L M T W
.ju
.sp
All the remaining commands either succeed or abort and do not generate
success/fail values.  However, if they are successful and are followed by
the "?" command, a 1 is generated.
.sp
.ix Value, Explicit
All the commands that return explicit values can be used to generate values
for the following commands that use or require them.  For example, ".EV1"
would remember CP in register 1, and "BEU1M" would restore CP.
.sp
.ix Value, Implicit
Using the implicit value commands require that they be followed by the "?"
command to generate values.  For example:
.br
       #1 SHELLO\?_
.br
is a loop that searches for "HELLO" until it is not found, but
.br
       #1 SHELLO\_
.br
is an error; the implicit value generated as a result of the success or
failure of the search must be made explicit by the "?" command.
.pa
REPEATING COMMAND SEQUENCES
.ix Command Sequence, Repeat
.tc
.ix []
.ix Looping
.ix Buffer, Text
.sp
Command sequences may be repeated by enclosing the sequence in a [ ] pair. 
Such loops are particularly useful for performing repetitive editing
functions on the text buffer. For example, let's assume that we wanted to
change the first 100 occurrences of "LDAA" to "STAA".  We could say:
.sp
       100[CLDAA\STAA\]
.sp
If we wanted to change all occurrences, we could say:
.sp
       [CLDAA\STAA\?]
.sp
.ix ?
.ix Key, Escape
The "?" command used here allows the iteration to cease when "LDAA" is not
found.  Note that [ ] by itself will keep the editor very busy doing nothing
(use the ESCape key to stop).
.sp
Any number of commands may be contained in a command string within the [ ]
pair which allows for very powerful commands. Below is a example of a
command sequence which will change all lines containing a "jmp" to a "bra"
and would type each line in which a change took place.
.sp
       [CJMP\BRA\?^0TT]
.sp
A sequence of commands in a loop can be terminated by striking the ESCape
key at any time during execution.
.pa
SHORT SOPHISTICATED EDITING EXAMPLES
.ix Example, Sophisticated
.tc
.sp
1.) Edit file "TEST1", change "NUTZ" to "NUTS", and quit:
.sp
       *ERTEST1\EWTEST1\1NNUTZ\XNUTS\EXIT
.sp
2.) Edit file "PROGRAM5", insert "95 INPUT 'ZIP: ' ZIP$" after line 90,
verify the insertion, and quit:
.sp
.pw 120
.ll 100
.im 11
       *ERPROGRAM5\EWPROGRAM6\1N90\
       End Of File hit
       90 WRITE #SCREEN, ZIPX, ZIPY
       *
       100 GOSUB 2900 \ ! GO PUT THE ZIPCODE INTO THE FILE
       *I95 INPUT 'ZIP: ' ZIP$
       \\-2TT
       90 WRITE #SCREEN, ZIPX, ZIPY
       95 INPUT 'ZIP: ' ZIP$
       100 GOSUB 2900 \ ! GO PUT THE ZIPCODE INTO THE FILE
       *EXIT
.ll 65
.pw 85
.sp
3.) Edit file "PROGMAN", and change all the mispelled versions of "AMMOUNT"
to "AMOUNT" and show each line; then quit.  "PROGMAN" is a large file so we
will use the N command.
.sp
.pw 120
.ll 100
.im 1
       *ERPROGMAN\EWPROGMAN\[1NAMMOUNT\?^XAMOUNT\0TT]EXIT
.ll 65
.pw 85
.sp
4.) Create a new file "JUNK", insert "PERFORM AN INJUSTICE TO MANKIND", and
quit.  The typist made mistakes, so corrective measures were used.
.sp
.im 12
       *EWJUNK\
       *IPERFRM A JUSTIXE\0T
       PERFRM A JUSTIXE*ITO MANKIND\0LT
       PERFRM A JUSTIXETO MANKIND*CRM\ORM\
       PERFORM A JUSTIXETO MANKIND*ZI
       \\-LSA\0T
       PERFORM A*IN\M0T
       PERFORM AN *IIN\CX\C\
       PERFORM AN INJUSTICETO MANKIND
       *CTO\ TO\
       PERFORM AN INJUSTICE TO MANKIND
       *EXIT
.sp
5.) Merge file "TEMP1" onto the end of "TEST".
.sp
       *ERTEST\EWTEST\[1A?^1P]ECTEMP1\EXIT
.pa
ERROR SUMMARY
.ix Error Code
.ix Error Summary
.tc
.sp
.pw 120
.ll 100
.im 31
 200  - Syntax Error
 201  - Can't find branch target
 202  - Can't find "]"
 203  - Incorrect Bracket Nesting
 204  - *** EDITor error ***
 205  - Illegal argument for command
 206  - Zero is not a valid argument
 207  - command requires argument
 208  - Command doesn't want an argument
 209  - No such "E" command
 210  - Illegal character
 211  - Can't use that as delimiter character
 212  - Too many )s
 213  - Too many (s
 214  - Xchange not valid, must do search or insert first
 215  - Command not allowed while doing edit with EB
 216  - Can't find string
 217  - Q register index must be 1 to 9
 218  - Need to open input file first
 219  - Text Buffer is full
 220  - Command buffer is full
 221  - Don't have enough lines in buffer to J that far
 222  - Illegal tab stop list
 223  - Need to select output file first
 224  - Unbalanced [ ]'s
 225  - Bracket Stack overflow or underflow
 226  - End of File prior to "A" or "EY"
 227  - Buffer approaching full, operation aborted
 228  - Error encountered during EDIT for which no recovery was provided.
 229  - Overflow occurred in operation
 230  - Can't find matching [
.ll 65
.pw 85
.pc
.np
.ce
TABLE OF CONTENTS
.sp
EDITOR FEATURES 
.sp
INTRODUCTORY CONCEPTS 
.sp
THE DISPLAY SCREEN VERSUS THE TEXT BUFFER 
.sp
COMMONLY USED COMMANDS 
.sp
COMMONLY USED COMMAND SEQUENCES 
.sp
TWO SIMPLE EDITING SESSIONS 
.sp
DETAILED COMMAND DESCRIPTIONS 
.sp
COMMAND STRING PROCESSING 
.sp
ERROR HANDLING
.sp
VALUES RETURNED FROM COMMANDS 
.sp
REPEATING COMMAND SEQUENCES 
.sp
SHORT SOPHISTICATED EDITING EXAMPLES 
.sp
ERROR SUMMARY
.sp
 
