.bp
.he MDOS SIMULATOR
.sh SECTION I: INTRODUCTION
.ce
MDOSSIMULATOR
.sp
.il Copyright (c) 1980
.ir Software Dynamics
INTRODUCTION
.sp
The MDOS Simulator Package is a set of programs that allows programs
designed to run under MDOS to run under SDOS.
.sp
There can be no doubt that MDOS supports many useful development tools
(RASM, RLOAD, ...).  However, MDOS itself has several limitations: it isn't
interrupt driven, it can only support floppies, and it is not especially
friendly to the operator.  SDOS, on the other hand, has none of these
problems: all I/O is interrupt driven, allowing both user type-ahead and
disk read-ahead; SDOS can support any mixture of disk drives on a system;
and SDOS tries to be friendly: error messages are in plain English.
Simple-to-use line editing trivializes typing errors, and command syntax is
designed to be concise yet easy to use.
.sp
Ideally, one would like to combine MDOS's development software with the
superior environment of SDOS.  And this is just what the MDOS simulator
package does: it allows MDOS development programs to run under SDOS without
any modification to the MDOS programs.  With this simulator package, it is
possible to RASM files on a Winchester disk, enjoying the speed of the disk,
yet not sacrificing any features of RASM.
.sp
Two programs comprise the MDOS simulator package: MDOSUTILITY and MDOSSIM. 
MDOSUTILITY provides a mechanism for moving files from MDOS to SDOS. 
MDOSSIM allows MDOS programs to run under SDOS.
.sp
In addition, there is a DO file, "MDOSERRS.DO", which will extend the
Errormsgs.sys file to include error messages produced by MDOSSIM.  This DO
file should be executed before running MDOSSIM.  To run the DO file, type
"DO MDOSERRS.DO" when at the prompt in the SDOS command interpreter.  Note
that this program extends Errormsgs.sys on the default disk, so this DO file
should be run when defaulted to the proper disk.
.sp
Example:
.sp
.im 7
     .DO MDOSERRS.DO
     .SDOSERRORMAINT
     >I
     Error Number=
         .
         .
         .
.sh SECTION II: HOW TO USE MDOSUTILITY
.pa
HOW TO USE MDOSUTILITY
.sp
Obviously, one cannot just boot SDOS and start running assemblies (or
whatever) of files on a MDOS diskette since the file system SDOS uses is
incompatible with MDOS's. Somehow, files from a MDOS disk must be moved to a
SDOS disk. The MDOSUTILITY program is designed to retrieve files from MDOS
file structured disks while running under SDOS. (MDOSUTILITY can also move
them from SDOS to MDOS if necessary.) To retrieve a file from a diskette,
type "MDOSUTILITY" when running the command interpreter ('DEFAULTPROGRAM').
The program will print a banner giving the program's name, version, and date.
It will then ask you for the name of the device which contains your MDOS
disk. If you do not specify the device name, by just hitting return, the
program defaults to d0: as the device name, as indicated by the '<d0:>' at
the end on the question.  Once the program knows which disk to use, the
program will read in the contents of the MDOS-style directory and prompt
you for a command with an equals sign ('=').
.sp
The utility program supports four (4) commands: EXIT, DIR, COPY from MDOS,
and COPY from SDOS.
.sp
EXIT does just what it says, namely, exit the utility and return to the
command interpreter ('DEFAULTPROGRAM').
.sp
DIR prints out a listing of names of the files on the diskette in a similar
manner as the DIR command from under MDOS.
.sp
COPY from MDOS retrieves a file from the MDOS diskette and puts it into a
SDOS file (or device).  In addition, the command performs (if needed)
conversion of the file as it is copying it, since some MDOS files have
internal structures which are incompatible with SDOS: MDOS binary load
format files are converted into SDOS-style load files; MDOS binary record
files are converted to be compatible with the MDOSSIM program, and text
files have compressed spaces expanded.  The format of the COPY from
MDOS command is:
.sp
.im 1
     COPY <MDOS file>,<SDOS file>
.sp
Any valid SDOS file or device name can be used in the <SDOS file> field. 
Only complete MDOS file names (name.ex) can be used in the <MDOS file>
field.
.sp
COPY from MDOS transfers  text files from MDOS to SDOS. The format of the
COPY from MDOS command is:
.sp
.im 1
     COPY <MDOS file> to <SDOS file>
.pa
.ce
Example:
.sp
Suppose you want to retrieve the following files from drive 0: RASM.CM,
RLOAD.CM, and EQU.SA.  To do this, the following sequence might be used:
.sp
.im 2
.MDOSUTILITY
*** MDOS Utility program 1.0a 12/03/79 ***
.pw 130
.ll 100
.im 20
WHAT DISK IS THE MDOS DISK <D0:>? D0:
=DIR
LIST    .CM    MDOSOV0 .SY    DIR     .CM    MERGE   .CM    RASM09  .CM    
RLOAD   .CM    EDITOVL6.LO    MDOSOV4 .SY    ASM09   .CM    EDITOVL3.LO    
EDITOVLB.LO    MDOS    .SY    X       .CM    MDOSOV6 .SY    P       .CM    
RASM    .CM    EDITOVL7.LO    FREE    .CM    ROLLOUT .CM    EQU     .SA    
MEMLOC  .LO    DUMP    .CM    EXBIN   .CM    NAME    .CM    MDOSOV1 .SY    
EDITOVL0.LO    PATCH   .CM    EDITOVL5.LO    TEST09  .SA    ASM     .CM    
ECHO    .CM    EDIT    .CM    EDITM   .CM    LOAD    .CM    EDITOVL8.LO    
EDITOVLC.LO    MDOSOV3 .SY    MDOSER  .SY    DEL     .CM    EDITOVL4.LO    
TEST09  .RO    LIST    .CF    EDITOVL1.LO    CHAIN   .CM    E       .CM    
BACKUP  .CM    REPAIR  .CM    EDITOVL9.LO    MDOSOV5 .SY    DOSGEN  .CM    
SDEDIT  .CM    COPY    .CM    FORMAT  .CM    EDITOVL2.LO    EDITOVLA.LO    
MDOSOV2 .SY    MEMTEST .LO    EXBUG   .CM    CHAIN   .SY    
=COPY RASM.CM,RASM.CM
=COPY RLOAD.CM,RLOAD.CM
=COPY EQU.SA,EQUATES.SA
=EXIT
.


.ll 65
.pw 85
.pa
.sh SECTION III: HOW TO USE MDOSSIM
HOW TO USE MDOSSIM
.sp
Once the appropriate files have been retrieved from the MDOS diskette
(including any programs), the MDOSSIM program can be used to perform RASMs,
etc.
.sp
Basically, the MDOSSIM program manages to simulate MDOS by translating a
MDOS system call into the equivalent SDOS call(s).  Thus, a MDOS program
such as RASM can run under SDOS, even though it issues system calls intended
for MDOS.
.sp
This conversion is not perfect, however.  Unfortunately, MDOS programs are
forced to understand so much about MDOS that they know about MDOS's internal
structures and idiosyncrasies; simulating some calls completely is
impossible.
.sp
In fact, MDOSSIM is only designed to run key MDOS programs: RASM, RLOAD,
FORTRAN, MPL, and COBOL.  To date, only RASM and RLOAD are officially
tested.  All other programs are not guaranteed to work (see technical
notes).
.sp
Another point in conflict between MDOS and SDOS is device names.  MDOS file
name syntax is incompatible with SDOS's, so file names supplied to MDOSSIM
will be analyzed according to MDOS's file name syntax.
.sp
Since MDOS specifies device names either with "#dv" (#CN, #LP, etc.) or by
suffixing a ":n" (0<=n<=9) to a file name (TEMP.LX:3, etc.) and SDOS
specifies devices by prefixing a "<dev>:" to a file name (D0:JUNK.MIK,
etc.), MDOSSIM converts from MDOS device names to SDOS device names
according to the following:
.sp
.CP 15
.im 12
     MDOS device         SDOS device
     -----------         -----------
        :0                  DISK:
        :1                  WD0:
        :2                  D0:
        :3                  D1:
        :4                  D2:
        :5                  D3:
        :6                  DS0:
        :7                  DS1:
        :8                  DS2:
        :9                  DS3:
.sp
.im 2
        #CN                 CONSOLE:
        #LP                 LPT:
.sp
Note that these device names are not usually all valid on any given system;
using an invalid device will result in a "No Such Device" error when the
file is opened.
.pa
Actual use of MDOSSIM is quite easy.  Essentially, the sequence "MDOSSIM
<MDOS command line>" will do the trick.  The "<MDOS command line>" is merely
a typical command line, one that would be typed into MDOS.  For example:
.sp
.im 1
     .MDOSSIM RASM TEXT;L=#CN
.sp
would assemble TEXT.SA, printing a listing onto the terminal.
.sp
The extension .CM is automatically used for the extension of the program
name.
.sp
AN EXAMPLE OF MDOSSIM
.sp
.pw 130
.ll 100
.im 3
  .MDOSSIM RASM09 TEST09;R
  M6809 MACROASSEMBLER 02.00
  COPYRIGHT BY MOTOROLA 1978
.sp
.im 14
  .MDOSSIM RLOAD
  MDOS LINKING LOADER REV F3.P0
  COPYRIGHT BY MOTOROLA 1977
  ?IF=TEMP
  ?LOAD=TEST09
  ?OBJX=TEST09
  ?EXIT
  .LIST TEST09.LX
  S00B000054455354303920200B
  S12120008E0100CC0FF0DC12FC2035ECA82D86FF96AAB61023A684A6A4A68814A688D2
  S121201ECEA682A680B70200A784A7A4A7C4A7E4A7881EA78908FCA79F3000A7981E0B
  S113203CA78DE038A79DDFCB343635363018316A9E
  S9030000FC
  .
.ll 65
.pw 85
.sh SECTION IV: TECHNICAL NOTES
.pa
What follows is a more detailed and specific description of MDOSUTILITY
and MDOSSIM.  These notes are only intended for users with specific
questions.
.sp
TECHNICAL NOTES ON MDOSUTILITY
.sp
In order to perform the necessary conversions, the COPY routine must first
determine what type the file is (Binary record, contiguous load, text, ...).
To do this, the routine looks at the first attribute byte in the MDOS
directory entry of the file about to be copied.  If the lower three bits are
equal to 3 (%011), the file is declared to be in Binary Record format.  If
these lower three bits are equal to 5 (%101), the file is considered
space-compressed ASCII text.  NOTE: Even if a text file doesn't have
compressed spaces, it should be copied correctly so long as the most
significant bit of each byte is 0 (no parity).
.sp
If the lower 5 bits of the attribute byte are equal to $12 (%10010), the
file is presumed to be a contiguous load file (such as a command program),
and is converted into an SDOS compatible load format.  In MDOS terms,
MDOSUTILITY thinks a Binary record file is FD$FMB, a load file is FD$FML,
and a text file is FD$FMA.
.sp
.pa
TECHNICAL NOTES ON MDOSSIM
.sp
The MDOSSIM program was designed to allow working, debugged MDOS based
development software (RASM, FORTRAN, etc.) to be run under SDOS.  It is not
the goal of this program to provide an MDOS development system, nor is it to
provide the user with an alternate method of interfacing to SDOS.  To date,
it has only been tested with Motorola assemblers and loaders.  No guarantee
of any kind is expressed or implied concerning any other piece of MDOS
software.
.sp
MDOSSIM is not a full simulation of MDOS calls, but is a simulation of the
minimal subset of MDOS calls necessary to support the development software. 
This difference between MDOS and MDOSSIM is invisible to the average MDOS
program, but will be described so that the more advanced user can deal with
any problems that arise in trying to run a non-standard piece of software
under MDOSSIM.
.sp
This documentation presumes the reader is throughly familiar with MDOS
notation, conventions, and system calls.  Also, familiarity with SDOS is
needed, since MDOSSIM interacts with SDOS and these interactions have
effects on the MDOSSIM program.
.sp
.sh SECTION V: SUPPORTED CALLS
.pa
CALLS SUPPORTED BY MDOSSIM
.sp
The following calls are supported:
.sp
Unified I/O Calls
.sp
.im 9
     .RESRV
     .RELES
     .OPEN
     .CLOSE
     .GETRC
     .PUTRC
     .REWND
     .GETLS
     .PUTLS
.sp
Device specific I/O calls:
.sp
.im 5
     .KEYIN
     .DSPLY
     .DSPLX
     .DSPLZ
     .CKBRK
.sp
Register and Double byte arithmetic functions:
.sp
.im 5
     .TXBA     .TBAX     .XBAX     .ADBX
     .ADBAX    .ADXBA    .SUBX     .SUAX
     .SUBAX    .SUXBA    .CPBAX    .ASRX
     .ASLX     .PSHX     .PULX     .ADDAM
     .SUBAM    .MMA      .DMA
.sp
String functions:
.sp
.im 2
     .MOVE     .CMPAR    .STCHR    .STCHB
     .ALPHA    .NUMD
.sp
Miscellaneous functions:
.sp
.im 2
     .PFNAME   .ALUSM    .MDERR    .DIRSM
     .EWORD
.sp
Each of the register/double byte calls and the string calls operate exactly
as it does under MDOS.  The rest of the calls may behave slightly different.
These differences are described below.
.sp
.pa
UNIFIED I/O CALLS
.sp
All MDOS unified I/O calls use an IOCB to pass data to and from MDOS.
MDOSSIM uses IOCBs in a similiar way, but with the following differences:
.sp
.in 5
IOCRIB, IOCEOF, IOCSUS, IOCSDW, IOCDEN and IOCMLS are ignored.
.sp
.in 5
IOCGDW normally points to a CDB (controller descriptor block) once an IOCB
has been reserved.  In MDOSSIM, IOCGDW contains a pointer to an MDOSSIM
internal structure.  However, if a program believes that IOCGDW points to a
CDB and only references CDBIOC and CDBDDF of the CDB, no problems will
arise.
.sp
.in 0
FILE TYPES
.sp
Since SDOS does not provide any mechanism for file typing, the MDOSSIM
program determines file types solely on the basis of extensions:
.sp
.im 7
     Extension           File type
     ---------           ---------
      .LX                 FDF=03
      .CM                 FDF=02
      .BN                 FDF=03
      .RO                 FDF=03
      all others          FDF=05
.sp
ERROR HANDLING
.sp
Because MDOS programs are incapable of dealing with most SDOS errors, the
MDOSSIM program has the general philosophy of aborting the MDOS program when
I/O errors occur.  However, in specific cases where the MDOS program is
likely to be able to cope with the error, the error is returned to the
program.  Any case where an error is returned will be mentioned under the
description of the specific call.
.pa
.im 1
.RESRV
.sp
.in 5
The reserve call is used under MDOS to associate an IOCB with its
corresponding CDB.  Under MDOSSIM, the reserve call is used to assign an
SDOS I/O channel number to an IOCB.
.sp
Since SDOS provides a fixed number of channels to the user, a fatal error
may result if a program tries to reserve too many IOCBs at a given time. 
Releasing an IOCB frees the associated channel.  Please note that an IOCB
MUST be released before the space it occupies can be used for any other
purpose.
.sp
A special problem arises when a program reserves an IOCB twice without
releasing it.  Though this is illegal, some MDOS programs "forget" to
release an IOCB when they wish to reuse it.  To counter this problem, the
MDOSSIM program may force a .RELES on any IOCB which is already reserved and
is being reserved a second time.
.sp
.in 0
.im 1
.RELES
.sp
.in 5
RELEASE performs exactly as in MDOS, with the following exceptions:
.sp
.in 8
.un 3
1.~If the IOCB was not reserved, no error will result.
.sp
.un 3
2.~If the IOCB describes an open file, RELESing the IOCB will neither
return an error nor close the channel associated with the IOCB.  This means
that the next IOCB to be assigned that particular channel will find an open
file, and the program is likely to encounter an error when it tries to open
another file using that IOCB.
.sp
.in 0
.im 1
.OPEN
.sp
.in 5
OPEN provides the mechanism whereby an IOCB is associated with a file.
OPEN in MDOSSIM performs essentially the same function as in MDOS, with the
following exceptions:
.sp
.in 8
.un 3
1.~Even though a file may be OPENed in "output only" or "input only"
mode, MDOSSIM will service any request to do I/O to the file, even though
this may violate the mode in which the file was OPENed.
.sp
.un 3
2.~The only error which can be returned is a "File Not Found" error.
.pa
.in 0
.im 1
.CLOSE
.sp
.in 5
CLOSE operates as in MDOS, except any errors cause the program to
abort.
.sp
.in 0
.im 1
.GETRC & .PUTRC
.sp
.in 5
GET and PUT RECORD perform exactly as in MDOS, except for three things.
First, ASCII space compression/expansion is not performed in order to
maintain compatability with the SDOS format for ASCII files.  Second, rather
than having the somewhat wasteful binary record format MDOS uses, the
MDOSSIM program has a two part format: a one byte count followed by the
data.  This is transparent to the program running under MDOSSIM so long as
it only issues .GETRC's and .PUTRC's to access the binary records.  Third,
ASCII-converted binary is not supported; any attempts to use this mode will
result in an equivalent regular binary call being executed.  This means that
MDOSSIM only concerns itself with whether or not the file is in binary
format, and not about being ASCII converted or not.
.sp
The MDOSUTILITY program will automatically perform all necessary conversions
for ASCII and binary record files when retrieving them from an MDOS
diskette.  ASCII converted binary files, however, are not processed in any
way by the MDOSUTILITY program.
.sp
.in 0
.im 1
.REWND
.in 5
.sp
REWIND performs the following:
.sp
.in 8
.un 3
1.~Make sure IOCB is reserved.  If not, abort the program with an "File Not
Open" error.
.sp
.un 3
2.~Cause SDOS to do a REWIND on the channel associated with the IOCB. If
SDOS returns any error, abort the program.
.sp
.un 3
3.~Clear IOCLSN and IOCSTA.
.pa
.in 0
.im 1
.GETLS & .PUTLS
.sp
.in 5
These two calls, which are basically the same, perform the following:
.sp
.in 8
.un 3
1.~If the sector I/O flag is not set, pass an error back to the program.
.sp
.un 3
2.~Fetch or write the appropriate sector.  MDOSSIM ignores the size of the
sector buffer: all sector I/O is done in blocks of 128 regardless of the
actual sector buffer size.
.sp
.un 3
3.~Increment IOCLSN, clear IOCSTA, set IOCSBP=IOCSBS
.sp
.un 3
4.~Return.
.sp
If an EOF error occurs during a read and no bytes were read in from the
disk, an EOF error is returned to the user program.  If the EOF error
occurs, but a partial sector was read in, the MDOSSIM program will zero out
the remainder of the sector and pretend that no EOF had occured.
.sp
.in 0
.im 1
.KEYIN
.sp
.in 5
Keyin operates as in MDOS except:
.sp
.in 8
.un 3
1.~If the X register points to the MDOS command buffer, the size of the
request is not truncated should it exceed the length of the command buffer.
.sp
.un 3
2.~All line editing during type-in is done according to SDOS's standards
rather than MDOS's.
.sp
.in 0
.im 1
.DSPLX, .DSPLY, & .DSPLZ
.sp
.in 5
These calls execute exactly as under MDOS.
.pa
.in 0
.im 1
.CKBRK
.sp
.in 5
CKBRK is the same as under MDOS except:
.sp
.in 8
.un 3
1.~It detects escapes rather than breaks (via the SYSCALL:ATTNCHECK SDOS
call).
.sp
.un 3
2.~Executing a CKBRK will clear the escape status so that a second CKBRK
will not 'see' an escape a previous call might have seen.
.sp
.in 0
.im 1
.DIRSM
.in 5
.sp
MDOSSIM's DIRSM operates in the following modes only: ACCB=2, 4, or 8. All
other modes are not supported.  The supported modes operate as in MDOS.
.sp
.in 0
.im 1
.PFNAME
.in 5
.sp
MDOSSIM performs a normal PFNAME, except that it only recognizes complete
file names (name+extension) or devices (#xx).  All other types of file names
cause undefined operation.
.in 0
.sp
.im 1
.ALUSM
.in 5
.sp
ALUSM executes the same under MDOSSIM as under MDOS.
.sp
.in 0
.im 1
.MDERR & .EWORD
.in 5
.sp
Since MDOS's and SDOS's error schemes are different, MDERR ignores
parameters (such as pointers to file names, etc.).  Thus, when an error
occurs, only a generalized message will be printed out, even though a
more specific one would have been printed under MDOS (such as "TEST.SA
not found" under MDOS and "File Not Found" under SDOS).
.sp
.in 0
.im 1
.PRINT & .PRINX
.sp
.in 5
These calls operate as under MDOS.
.in 0
.sh SECTION VI: USING FORTRAN WITH MDOSSIM
.pa
USING FORTRAN WITH MDOSSIM
.sp
.in 6
.un 6
NOTE:~This document describes the changes involved with running MDOS Fortran
under SDOS. It is not, nor is it intended to be, a description of how to
use Fortran, SDOS, or MDOSSIM. A working familiarity with these three
programs is a prerequisite to reading this document.
.in 0
.sp
INTRODUCTION
.sp
Fortran systems written for MDOS Fortran and intended to be run under MDOS
can be run under MDOSSIM "as is", though a few subroutines must be linked in
with the program at compile time. At this point, only Fortran Version 2.2
and RLOAD Version 3.0 have been tested and are assumed to work. All other
versions may require some minor modification to routines supplied with
MDOSSIM.
.sp
PREPARATION
.sp
Prior to running Fortran under MDOSSIM, four files must be fetched from a
MDOS disk using the MDOSUTILITY program:
.sp
.im 4
     RLOAD.CM
     FORT.CM
     RASM.CM
     FORLB.RO
.sp
RLOAD must be Version 3.0 or greater; if it is not, see section "OLD
RLOADs". Again, this document refers to Version 2.2 Fortran; for other
versions, see "OTHER VERSIONS OF FORTRAN".
.sp
As was mentioned above, a few subroutines must be linked in with any Fortran
program before it can run. These subroutines are contained, in source form,
in the file "FTTOMD.SA" (ForTran To MDos). Before these routines can be
used, they must be assembled into a relocatable format. Type:
.sp
.im 1
     MDOSSIM RASM FTTOMD;R
.sp
This will create the appropriate .RO file.
.sp
At this point, the preparation is complete.
.pa
COMPILING FORTRAN PROGRAMS
.sp
Invocation of the Fortran compiler is no different under MDOSSIM than under
MDOS, except for normal MDOSSIM invocation procedures. For example:
.sp
.im 8
     .MDOSSIM FORT FRTTST4
     MDOS SIMULATOR PACKAGE V1.0A 06/24/80
     COPYRIGHT (C) 1980 SOFTWARE DYNAMICS

     MDOS FORTRAN VERSION 02.20
     COPYRIGHT BY MOTOROLA 1979

     .
.SP
LINKING FORTRAN PROGRAMS
.sp
The "RLOAD" phase of compiling is identical under MDOSSIM as MDOS, except
that the new I/O routines must be included in the link process. At the end
of pass 1 and pass 2 of the load process, which occurs normally after the
"LIB=FORLB", the new subroutine package must be loaded by typing
"LOAD=FTTOMD". This program will replace the EXBUG I/O routines present in
the Fortran Runtime Package with routines that use MDOS (and thus SDOS).
.sp
Also, absolute file ("OBJA=") cannot be produced under MDOSSIM, so MIKBUG
(.LX extension according to MDOS rules) files must be produced by typing
"OBJX=" in place of "OBJA=". For example:
.pa
.pw 130
.ll 100
.im 53
     .MDOSSIM RLOAD
     MDOS SIMULATOR PACKAGE V1.0A 6/24/80
     COPYRIGHT (C) 1980 SOFTWARE DYNAMICS

     MDOS LINKING LOADER REV 03.00
     COPYRIGHT BY MOTOROLA 1977
     ?BASE
     ?IDON
     ?LOAD=FRTTST4
       MAIN      02.20 -       MDOS FORTRAN VERSION 02.20
     ?LIB=FORLB
       FTNRUN    02.20 - MDOS FORTRAN LIBRARY
       DISKIO    02.20 - MDOS FORTRAN LIBRARY
       POWER     02.20 - MDOS FORTRAN LIBRARY
       ALOG      02.20 - MDOS FORTRAN LIBRARY
       EXP       02.20 - MDOS FORTRAN LIBRARY
       SINCOS    02.20 - MDOS FORTRAN LIBRARY
       ATAN      02.20 - MDOS FORTRAN LIBRARY
       SQRT      02.20 - MDOS FORTRAN LIBRARY
       MOD       02.20 - MDOS FORTRAN LIBRARY
       ABS       02.20 - MDOS FORTRAN LIBRARY
       IBIT      02.20 - MDOS FORTRAN LIBRARY
       IAND      02.20 - MDOS FORTRAN LIBRARY
       IOR       02.20 - MDOS FORTRAN LIBRARY
       IEOR      02.20 - MDOS FORTRAN LIBRARY
       ISHFT     02.20 - MDOS FORTRAN LIBRARY
       IABS      02.20 - MDOS FORTRAN LIBRARY
       LPINIT    02.20 - MDOS FORTRAN LIBRARY
       PAGE      02.20 - MDOS FORTRAN LIBRARY
       LPQ       02.20 - MDOS FORTRAN LIBRARY
       FILTST    02.20 - MDOS FORTRAN LIBRARY
       KEYIN     02.20 - MDOS FORTRAN LIBRARY
       IRAND     02.20 - MDOS FORTRAN LIBRARY
       ERR       02.20 - MDOS FORTRAN LIBRARY
     ?LOAD=FTTOMD
       FTTOMD    2.20 : FORTRAN TO MDOS ROUTINES BY SOFTWARE DYNAMICS
     ?OBJX=FRTTST4
     ?LOAD=FRTTST4
       MAIN    02.20 -         MDOS FORTRAN VERSIONN 02.20
     ?LIB=FORLB
       FTNRUN    02.20 - MDOS FORTRAN LIBRARY
       DISKIO    02.20 - MDOS FORTRAN LIBRARY
       POWER     02.20 - MDOS FORTRAN LIBRARY
       ALOG      02.20 - MDOS FORTRAN LIBRARY
       EXP       02.20 - MDOS FORTRAN LIBRARY
       SINCOS    02.20 - MDOS FORTRAN LIBRARY
       ATAN      02.20 - MDOS FORTRAN LIBRARY
       SQRT      02.20 - MDOS FORTRAN LIBRARY
       MOD       02.20 - MDOS FORTRAN LIBRARY
       ABS       02.20 - MDOS FORTRAN LIBRARY
       IBIT      02.20 - MDOS FORTRAN LIBRARY
       IAND      02.20 - MDOS FORTRAN LIBRARY
       IOR       02.20 - MDOS FORTRAN LIBRARY


.ll 65
.pw 85
.pa
.pw 130
.ll 100
.im 14
       IEOR      02.20 - MDOS FORTRAN LIBRARY
       ISHFT     02.20 - MDOS FORTRAN LIBRARY
       IABS      02.20 - MDOS FORTRAN LIBRARY
       LPINIT    02.20 - MDOS FORTRAN LIBRARY
       PAGE      02.20 - MDOS FORTRAN LIBRARY
       LPQ       02.20 - MDOS FORTRAN LIBRARY
       FILTST    02.20 - MDOS FORTRAN LIBRARY
       KEYIN     02.20 - MDOS FORTRAN LIBRARY
       IRAND     02.20 - MDOS FORTRAN LIBRARY
       ERR       02.20 - MDOS FORTRAN LIBRARY
     ?LOAD=FTTOMD
       FTTOMD    2.20 - FORTRAN TO MDOS ROUTINES BY SOFTWARE DYNAMICS
     ?EXIT
     .





.ll 65
.pw 85
.sp 2
After producing the MIKBUG, it must be converted to SDOS load format by
running the MAKEBINARY program. To use makebinary, follow this example:
.sp
.im 7
     .MAKEBINARY
     Make binary v1.0 6/10/80
     Input file= FRTTST4.LX
     Output file= FRTTST4.CM
     Start address=
     All done
     .

.pa
MDOSCOMPILE
.sp
To simplify the preceeding process, which involves many steps, a special
"do-it-all" program has been included: MDOSCOMPILE. This program, written in
SDBASIC, accepts the name of a Fortran program and generates a DO file for
all of the steps needed to produce the compiled object. Only sources for the
program have been supplied, which means: (a) it is user customizable, and
(b) the MDOSCOMPILE program itself must be compiled by SDBASIC. To compile
the program, type:
.sp
.im 1
     COMPILE MDOSCOMPILE
.sp
when defaulted to a disk which contains BASIC, COMPILE, and ASM. After this,
a Fortran program can be compiled simply by typing:
.sp
.im 1
     MDOSCOMPILE <Fortran program>
.sp
For example, a typical sequence might look as follows (remember, the user
only typed the first line):
.pa
.pw 130
.ll 100
.im 53
     .MDOSCOMPILE FRTTST4
     .DELETE FRTTST4.RO
     .IFERROR 1011 OK
     .LABEL OK
     .MDOSSIM FORT FRTTST4
     MDOS SIMULATOR PACKAGE V1.0A 6/24/80
     COPYRIGHT (C) 1980 SOFTWARE DYNAMICS

     MDOS FORTRAN VERSION 02.20
     COPYRIGHT BY MOTOROLA 1979

     .DELETE FRTTST4.LX
     .IFERROR 1011 OK
     .LABEL OK
     .MDOSSIM RLOAD
     MDOS SIMULATOR PACKAGE V1.0A 06/24/80
     COPYRIGHT (C) 1980 SOFTWARE DYNAMICS

     MDOS LINKING LOADER REV 03.00
     COPYRIGHT BY MOTOROLA 1977
     ?BASE
     ?IDON
     ?LOAD=FRTTST4
       MAIN      02.20 -     MDOS FORTRAN VERSION 02.20
     ?LIB=FORLB
       FTNRUN    02.20 - MDOS FORTRAN LIBRARY
       DISKIO    02.20 - MDOS FORTRAN LIBRARY
       POWER     02.20 - MDOS FORTRAN LIBRARY
       ALOG      02.20 - MDOS FORTRAN LIBRARY
       EXP       02.20 - MDOS FORTRAN LIBRARY
       SINCOS    02.20 - MDOS FORTRAN LIBRARY
       ATAN      02.20 - MDOS FORTRAN LIBRARY
       SQRT      02.20 - MDOS FORTRAN LIBRARY
       MOD       02.20 - MDOS FORTRAN LIBRARY
       ABS       02.20 - MDOS FORTRAN LIBRARY
       IBIT      02.20 - MDOS FORTRAN LIBRARY
       IAND      02.20 - MDOS FORTRAN LIBRARY
       IOR       02.20 - MDOS FORTRAN LIBRARY
       IEOR      02.20 - MDOS FORTRAN LIBRARY
       ISHFT     02.20 - MDOS FORTRAN LIBRARY
       IABS      02.20 - MDOS FORTRAN LIBRARY
       LPINIT    02.20 - MDOS FORTRAN LIBRARY
       PAGE      02.20 - MDOS FORTRAN LIBRARY
       LPTQ      02.20 - MDOS FORTRAN LIBRARY
       FILTST    02.20 - MDOS FORTRAN LIBRARY
       KEYIN     02.20 - MDOS FORTRAN LIBRARY
       IRAND     02.20 - MDOS FORTRAN LIBRARY
       ERR       02.20 - MDOS FORTRAN LIBRARY
     ?LOAD=FTTOMD
       FTTOMD    2.20 - FORTRAN TO MDOS ROUTINES BY SOFTWARE DYNAMICS
     ?OBJX=FRTTST4
     ?LOAD=FRTTST4
       MAIN      02.20 -       MDOS FORTRAN VERSION 02.20


.ll 65
.pw 85
.pa
.pw 130
.ll 100
.im 41
     ?LIB=FORLB
       FTRUN     02.20 - MDOS FORTRAN LIBRARY
       DISKIO    02.20 - MDOS FORTRAN LIBRARY
       POWER     02.20 - MDOS FORTRAN LIBRARY
       ALOG      02.20 - MDOS FORTRAN LIBRARY
       EXP       02.20 - MDOS FORTRAN LIBRARY
       SINCOS    02.20 - MDOS FORTRAN LIBRARY
       ATAN      02.20 - MDOS FORTRAN LIBRARY
       SQRT      02.20 - MDOS FORTRAN LIBRARY
       MOD       02.20 - MDOS FORTRAN LIBRARY
       ABS       02.20 - MDOS FORTRAN LIBRARY
       IBIT      02.20 - MDOS FORTRAN LIBRARY
       IAND      02.20 - MDOS FORTRAN LIBRARY
       IOR       02.20 - MDOS FORTRAN LIBRARY
       IEOR      02.20 - MDOS FORTRAN LIBRARY

       ISHFT     02.20 - MDOS FORTRAN LIBRARY
       IABS      02.20 - MDOS FORTRAN LIBRARY
       LPINIT    02.20 - MDOS FORTRAN LIBRARY
       PAGE      02.20 - MDOS FORTRAN LIBRARY
       LPQ       02.20 - MDOS FORTRAN LIBRARY
       FILTST    02.20 - MDOS FORTRAN LIBRARY
       KEYIN     02.20 - MDOS FORTRAN LIBRARY
       IRAND     02.20 - MDOS FORTRAN LIBRARY
       ERR       02.20 - MDOS FORTRAN LIBRARY
     ?LOAD=FTTOMD
       FTTOMD    2.20 - FORTRAN TO MDOS ROUTINES BY SOFTWARE DYNAMICS
     ?EXIT
     .MAKEBINARY
     Make binary v1.0 6/10/80
     Input file= FRTTST4.LX
     Output file= FRTTST4.CM
     Start address=
     All done
     .* * * DONE * * *
     .
     .
     .




.ll 65
.pw 85
.pa
OTHER VERSIONS OF FORTRAN
.sp
OLD RLOADS
.sp
Two things might need modification in the Fortran package when attempting to
use other versions of Fortran and/or RLOAD:
.sp
.in 3
.un 3
1.~The FTTOMD.SA source, which is used to redirect console I/O, may have to
be modified because different versions of Fortran expect different
interfaces for these routines. For the correct format, consult the
appropriate section of the Fortran manual (Appendix H in M68FTN(D) and
Appendix I in M68FTN(D2) ).
.sp
.un 3
2.~The sequence of commands fed to RLOAD may need changing. For example, old
versions of RLOAD require CURP= and CURD=. The MDOSCOMPILE program source,
which is mostly self-explanatory, should be modified to reflect the
differences in the RLOAD being used.
.sp
.in 0
In general, no major problems should be encountered in bringing up various
versions of Fortran.
