        TITLE   SDOS/MT Version 1.2 Copyright (C) 1980 Software Dynamics
        PAGE    Things To Do
        with    wi=105,de=51
;       To assemble:
;               Place SDOS11DEFS on default drive
;               Place SDVT11DEFS on default drive
;               Place this file on default drive
;               Type:
;                       .ASM
;                       Source File = SDMT12x.ASM
;                       Listing File = SDMT12x.LPT
;                       Binary File = SDMT12x.BIN
;                       >
;               Assembly commences.  On completion, the object file
;               must be patched so its checksum logic won't complain;
;               this can be done with the aid of the "calcchecksum"
;               routine documented at the end of this listing.

mtsubversion    equ     'e      (other versions are lurking in the field)

                ifund   ShowRoughEdges
ShowRoughEdges  equ     1
? ; You have defaulted ShowRoughEdges to 1. For production, EQU it to 0.
                fin
                page
; **** REVISION HISTORY ****

; SDMT12D.ASM 11/20/82
;    Cleaned up known bugs in SDMT12C:
;       There is now a UCB:OLDENCRYPTEDKEY for each user
;       Checks properly for UserSpace > Size(Defaultprogram)
;       Now uses SDOS11g "SYSCALL:GETSERIALNUMBER" in decrypting loader
;       Modified SYSCALL:DELAY logic to use SETFUSE and TESTFUSE; this
;          speeds up scheduler when a job is waiting for time to pass.
;       Added SYSCALL:JOBCONTROL calls to allow extra jobs to spun off
;          in user spaces that have no terminals attached.
;    Big effort to improve performance and responsiveness by several means:
;       Single character I/O path efficiency enhanced by better coding
;       Dedicated a page to each user for efficient allocation by ALLOCATE1PAGE
;       Modified READA to allocate only 1 page, no matter what size reply buffer
;       Added IOQUANTUMTICKS, COMPUTEQUANTUMTICKS, CRASHINFOPTR to /MT prims table
;       Added IOQ for I/O bound users, and "fair" policy scheduler to ensure
;          no job starves to death, and each gets equal portions of CPU
;    Other trivia in prepartion for SDMT13.ASM
        page
; SDMT12E.ASM 7/1/85
;    Installed all patches to SDMT12D.ASM as source modifications:
;       Fixed ESC in DO file caused double echo
;       Fixed LIST LPT: hangs /MT
;       Fixed "lineflags not returned from input"
;       Fixed READA non-linemode
;       Fixed "lineflags not returned after output wait"
;       Fixed LBCS after syscall not unwound properly
;       Fixed SYSCALL:STATUS didn't pass WRBUF.
;       Fixed READA non-linemode doesn't do large reads correctly
;       Fixed "illegal syscall" error when DO file ends
;       Fixed "EICONSOLE:\" crashes /MT occasionally
;    Fixed known problems with SDMT12D.ASM:
;       SYSCALL:CONTROL now returns RDBUF.
;       Allows timeslicing while reading/writing big chunks.
;       Big read/writes give up allocated buffers when timeslicing.
;       ReadLoopTest now signals 3 states: NoMore, LastChunk, and MoreChunks.
;       Timeslices while loading user programs
;       Program loads are queued so that only one is active at a time:
;           thus no disk thrashing caused by multiple users loading simultaneously
;       CC:DUMPBUFFERS performed before chain prevents unnecessary thrashing
;       Returns lineflags after doing successful chain
;       Handle up to 16 users in 1Mb on 6809 (1Mb has room for 17 users)
;       Closes/re-opens CONSOLE: to clear EOF after typing ^Z from keyboard
;       SYSCALL:READA triggers ERR:ACTIVATIONNOTINBUFFER if reply buffer filled.
;       Now correctly reports ERR:SYSCALLTOOSHORT when SCBLK:WLEN = 0 or 1.
;       CC:Killproof delays Job Abort until CC:Killenable (esp for Bkgnd Jobs)
;       Conventional users can be aborted by others via JC:ABORT.
;       Fixed SYSCALL:LOAD erroneously stored StartAddress into /MT address space.
;       Cut UCBs down to 256 bytes from 512 --> more buffer pool room
;       Fixed "Close Channel #0" when ^C^C and Ch#0 already closed crashed /MT
;       Modified ResetLFChannel to ignore I/O errors on a close.
;       Implemented SDOS/ES as conditional switch in this source file.
        page
        if      ShowRoughEdges
;    Bugs to fix:
? ;     Make MT reboot once/day if unregistered. MOST IMPORTANT
? ;     Make READB from terminal timeshare correctly, with timeout.
? ;     Verify Scheduler does truly fair job of scheduling
? ;     Allow user terminal to select multiple jobs
? ;     Allow a user job to be killed with capability. Must get capability.
? ;     add system call to get capability of current job
? ;     Mod scheduler to dynamically compute optimal time slices
;             (use binary exponential backoff)
? ;     Penalty to CPUBOUND job is lost if we give him a short TS
;             need UCB:PENALYTICKS & UCB:QUANTUM
;             at PFU: determine quantum: ADDA UCB:PENALTYTICKS
? ;     Fix writing to other channel doesn't kill system
? ;     Periodic dumpbuffers -- perhaps dump defaultdisk on exit?
? ;     lift comment form from SDNETDEVICE.ASM
? ;     Ira/Joe both want User Job wait on event desired.
? ;     convert back to single user operation on demand
? ;     allow DEFAULTDISK command if master port: NO: stop MT, DEFAULTDISK, run MT
? ;     need way to boot all users off system for shutdown purposes.
  ;          use LOGOFF to help?
? ;     need way to send messages to other terminals.
? ;     mod INTERLOCK:TEST to return # of locks extant against object.
? ;     Record processor Serial Number in capability?
? ;     Call S/U SDOS to get NetID and NodeID (see discussion of CREATE)
;            Compare interlock objects with ID of supplied capability; if
;            wrong, complain and reject; else do interlock operation.
;            Ask SDOS/SU to create interlock object if create call;
;            this tags interlock object with machine ID); fill rest of
;            interlock object with randomness. NOT YET. WAIT FOR NETWORK SDOS.
;       Make /MT use SDOS "decrypt region" syscall, to make /MT smaller?
;       READB code should look like READA so we can Timeshare ReadBinary to
;            VT driver. Do this sometime when VT driver is ready for it.
        fin     ShowRoughEdges
        page
; Things to do over the long run:

; add spooler [version 1.3 ?]

; verify that SELECTBANK is in ROM (by checking that what the I/O package
;    passes as an address is the same as that referenced by the boot ROM)
;    [do a flow analysis of the MT primitives at MT initialization;
;    version 2.0 ?]
        PAGE    Templates & Equates
IOPKDEFS equ    1       ; so we get processor REG: definitions
        list    0       ; I don't want to see SDOS definitions
        INCLUDE SDOS11DEFS.ASM
        list    1       ; I do want to see rest of /MT listing
        IFUND   M6800
M6800   EQU     1
M6801   EQU     0
M6809   EQU     0
M6811   EQU     0
        FIN     M6800

        IFUND   M6811
M6811   EQU     0
        FIN

        IFUND   MTVERSION
MTVERSION       EQU     $12     1.2 in hex
        FIN

        ifund   SDOSExtendedSpace
SDOSExtendedSpace equ 0 ; don't want single-user version
        fin     SDOSExtendedSpace

MAXUSERS equ 16 ; maximum number of users supportable by SDOS/MT
;                 (limited by SERVICEDIO flags)

        ifund   UCBchannels
UCBchannels equ 32      ; User may reference logical channels 0..UCBchannels-1
        ; This value limits the size of a sub-table in the UCB. Don't change.
        fin

LINEFLAGS       EQU     $F0     user's lineflags
USERSPSAVE      EQU     $F1     location of stack pointer in each user's space

LOAD:TYPE0      EQU     0
                IF      M6809
LOAD:TYPE1      EQU     2
                ELSE
LOAD:TYPE1      EQU     1
                FIN
LOAD:TYPE2      EQU     2
LOAD:TYPE3      EQU     3
LOAD:ENCRYPTED  EQU     5
TOPOINTER       EQU     TEMPX

capmap:refcount equ     0       references to this object
capmap:queue    equ     1       first user queued on this object

queue:head      equ     0       head of queue
queue:tail      equ     1       tail of queue

; Job State definitions
js:free equ 0 this job available to be used
js:busy equ 1 this job is not free to be used
js:dying       equ     2       this job is dead, but doesn't know it yet

                ORG     0
USER1CONSOLE    RMB     1       user 1 will get this channel (real channel 0)
ERRMSGCHANNEL   RMB     1       channel to use for reading errormsgs.sys
AVAILABLECHANNELS EQU   *       channels available for general usage
INITCHANNEL     RMB     1       channel to used in INIT logic
                page    User Control Block Definitions
                ORG     $0

UCB:SCB         RMB     128     user's syscall block
UCB:JOBSTATE    RMB     1       indicates whether job is free, busy or dying
UCB:BUFFER      RMB     1       address of working buffer for syscall
UCB:BUFFERSIZE  RMB     1       size of working buffer
UCB:NEXTONQ     RMB     1       next UCB on current queue
UCB:CHANNELMAP  RMB     2       name of logical to physical channel map
UCB:USERNUMBER  RMB     1       user number 1..16
UCB:BITMASK     RMB     2       user number bit mask...used with SERVICEDIO
UCB:USERSCB     RMB     2       address of syscall block in userspace
UCB:GIVERPLEN   RMB     1       <>0 --> return RPLEN to user
UCB:LFNEXT      RMB     1       points to next ucb in system
UCB:LFCHAN      RMB     1       channel to use for getting Line Flags
*                               contains channel to talk to user
*                               if = :FF, no terminal attached to this job
UCB:LOGCHANNEL  RMB     1       <>:FF --> user is logging to this real channel
UCB:LOADCHANNEL RMB     1       channel to use while loading
UCB:DELAY       RMB     2       delay time increment when in delay queue
UCB:PNEEDED     RMB     1       number of pages being waited for
UCB:LASTERROR   RMB     2       last error for this user
UCB:TOPMEM      RMB     2       top of user space (address of last usable byte)
UCB:USERCHAN    RMB     1       user's channel number, this operation
UCB:USERWRBUF   RMB     2       user's wrbuf, this operation
UCB:USERWRLEN   RMB     2       user's wrlen, this operation
UCB:USERRPLEN   RMB     2       user's rplen, this operation
UCB:USERRDBUF   RMB     2       user's rdbuf, this operation
UCB:USERRDLEN   RMB     2       user's rdlen, this operation
UCB:QUEUEERR    RMB     2       holding tank for errors while queued
UCB:VTFLAG      RMB     1       <>0 if current channel is vt device
UCB:LINEFLAGS   RMB     1       lineflags hint for user
UCB:ALLOCATEDPAGECNT RMB 1      contains # pages in variable size allocation
UCB:ALLOCATEDPAGESBASE RMB 1    page number of 1st page of variable allocation
UCB:PERMANENTPAGEBUSY RMB 1     <>0 --> permanent page has been allocated
UCB:PERMANENTPAGE RMB   1       page permanently allocated as buffer
UCB:USERCPUBOUND RMB    1       <>0 --> user has not recently done VT I/O
UCB:REMAININGQUANTUM RMB 1      = # ticks left in user's time slice
UCB:KILLPROOF   RMB     1       <>0 --> job is Kill Proof
UCB:OLDKEYENCRYPTED RMB 8       old key encrypted application suite signature
UCB:JOBCAPABILITY RMB   16      holds capability that matches this job
UCB:CHAN0       RMB     1       real channel 0 for this user
UCB:CHANNELMAPT EQU     UCB:CHAN0  maps user channel #s to actual channel #s
                RMB     UCBchannels-1 (rest of channel map)
UCB:CONSOLESTR  RMB     8       name of console device for this user
                if      *>/256
                ?? UCB displacements not addressable by 6800/6801/6811 ??
                fin
UCB:STACKP      RMB     2       saved copy of pointer into SDOSMTSTACK
UCB:STACKBOTTOM RMB     0       lowest byte usable by stack area
                ; copy of top end of SDOSMTSTACK is stored here

                ORG     UCB:SCB+256 force convenient page bound
UCB:STACK       RMB     0       top of system stack for this user
UCB:SIZE        EQU     *-UCB:SCB

UCB:STACKSIZE   EQU     UCB:STACK-UCB:STACKBOTTOM ; space set aside for stack

UCB:STACKSPACENEEDED equ  16    determined empirically; this seems to work

                if      UCB:STACKSIZE<<UCB:STACKSPACENEEDED
                ? ; not enough stack in UCB for SDOS/MT to operate
                fin

; Note: labels UCB:LOADxxx are in use only while LOAD/CHAIN Syscall in execution
                ORG     SCBLK:END
UCB:LOADDECRYPTFLAG RMB 1       <>0 --> file must be decrypted
UCB:LOADSTARTADDRESS RMB 2      start address of module being loaded
UCB:LOADDECRYPTIONKEY RMB 8     holds key to use to decrypt module being loaded
        PAGE    Virtual Terminal Driver information unique to /MT
CC:WRITEANOWAIT EQU     $30     write ascii to VT device with no wait
CC:SETTIMESHARE EQU     $31     say that MT is running and get prims
CC:WRITEBNOWAIT EQU     $33     write binary to VT device with no wait

SC:ATTENTIONCK  EQU     $30     see if a particular VT device has attention
SC:ALLSTATUS    EQU     $33     see if any VT device has changed status
SC:GETLINEFLAGSHINT     EQU     $34     get lineflags hint--dont reset in DCB

VT:PRINTER      EQU     $20
VT:CONSOLE      EQU     $40
                PAGE    Variables
                ORG     $20

SYSCALLX        FDB     OPCODES&$FF00
DECBUF          RMB     3       conversion buffer for DERR
ERRORNUMBER     RMB     2       this MUST follow DECBUF!!
ERRORADDRESS    RMB     2       for use in debugging
LASTERROR       RMB     2       last internal error
USERLASTERROR   RMB     2       last error for current user
TSTEMP          RMB     2       Temp storage: general purpose
PAGEBASE        RMB     1       used for buffer allocation
                FCB     0       zero byte to extend PAGEBASE into 16 bit pointer
THISCOUNT       RMB     1
LASTBASE        RMB     1
LASTCOUNT       RMB     1
NPAGES          RMB     1
                FCB     0
NAMESCANNEDCNT  RMB     2       bytes scanned off user-supplied filename
STRINGBUFFER    RMB     6       ASCII buffer for DERR
BUFFER          RMB     2       for GET1BYTES and GET2BYTES
PAGEMAPINDEX    FDB     PAGEMAP&$FF00   for fiddling with the page map
POINTERINBUFFER RMB     2       temporary buffer pointer for display error
MAPSIZE         FCB     0       size of bufferspace, in pages
PAGEMAPBASE     FDB     PAGEMAP+ENDOFTIMESHARE//256
NUMUSERS        FCB     0       number of users, this invocation
ucbchain        FDB     0       head of list of ucbs chained thru UCB:LFNEXT
NUMPAGES        FCB     0       number of pages available for allocation
DERRCRFLAG      FCB     0       put a CR on the end of an error message
DELAYADJUST     RMB     2       amount by which to adjust delay queue
capslot         rmb     1       capability slot number matches below
captablex       fdb     captable        used for indexing into the capability table
capmapx         fdb     capmap  used for indexing into the capability map
loginexists     fcb     0       1 -> LOGIN program exists
DECRYPTBUFPTR   FDB     DECRYPTBUFFER POINTER TO SCAN DECRYPTBUFFER
NKEYS           FCB     CHANGED TYPE 5 RECORD: KEY COUNT
ucbpointer      rmb     2       used to scan all ucbs
                PAGE
SERVICEDIO      FDB     0                      bit n sez user n+1 was serviced recently
CURRENTUSER     FCB     1                      number of current user
CURRENTUCB      FDB     FIRSTUCB               address of current user's UCB
RUNQ            fcb     FIRSTUCB/256,changed   ready-to-run queue
IOQ             FDB     0                      queue for users doing I/O
INPUTQ          FDB     0                      waiting-for-input queue
OUTPUTQ         FDB     0                      waiting-for-output queue
SPACEQ          FDB     0                      waiting-for-space queue
DELAYQ          FDB     0                      delay user queue
LOADQ           FDB     0                      queue of users doing LOAD/CHAIN
QUEUE:UCB       FDB     0                      used in queue management

                FCB     $A5     stack dike: don't push on top of here.
                RPT     64      stack area for SDOS/MT to use.
                FCB     $5A     so we can tell how much stack got used
SDOSMTSTACK     RMB     0       initial value to use for stack

                IF      *>/$F0
                ? page zero capacity exceeded ?
                FIN
                PAGE    Allocation Tables
                ORG     $100

; The pagemap must begin on a page boundary and is used by SD/MT to keep 
; track of which user (or the system, for that matter) owns which
; dynamically attainable pages.  Each byte corresponds to a page in the
; 680x address space; the value of a byte indicates the current status of
; the corresponding page: =0 means the page is available, =$4x means the
; page has been allocated to user x, any other value means to leave that
; page alone.  The map is assembled with all pages "taken", and the
; initialize code suitably alters the map, so that the correct pages are
; available.

PAGEMAP RPT     256
                FCB     $FF

; The device map is indexed by a real channel number and holds the
; device type information: vt:console, vt:printer, or 0.

DEVICEMAP
        rmb     256

; The captable must begin on a page boundary and is used by SD/MT to
; keep track of the capabilities in use within SD/MT.  Each slot of 16
; bytes is used to record a 16-byte capability to an object.
; This table is managed using capmap, below.

captable        rmb     8*4*16  8 users x 4 slots/user x 16 bytes/slot
        page
; The capmap must begin on a page boundary and is used by SD/MT to keep
; track of the capability slots contained in captable.  Each 2-byte entry
; in capmap corresponds to a 16-byte slot in captable.  The first byte of
; each capmap entry is a reference count, indicating the number of lock
; requests made against this object.  The second byte of the capmap
; entry is the msb of the ucb address of the first user enqueued for this
; object (0 -> none in queue); subsequent users are linked to the first user
; (with the ucb:nextonq field).

capmap  rpt     8*4
        fcb     0,0

; The channelstack is a stack of available real channels (not necessarily
; all available in a given configuration).  When a real channel is needed,
; it is removed from the top of the stack; when no longer needed, it is
; returned to the top of the stack.  A check is made for stack underflow,
; but no check is made for stack overflow.  Channel 255 is not available:
; it is used to indicate a closed channel.

channelstackp   fdb     channelstack
channelstackc   fcb     257-availablechannels

channelstack    fcb     0
                rpt     256-availablechannels
                fcb     *-channelstack+availablechannels-1

                PAGE    Timesharing Primitives
SDOSMTSTATUSCHANGED FCB 1              0 --> no change in any user status
;  "Status is changed" flag initz'd TRUE to force status check on fire-up
;  Note: SDOSMTSTATUSCHANGED is set by VT driver, who knows its location
;  is 1 byte preceding the WRBUF specified on a CC:SETTIMESHARE call.

*       Timesharing primitives reside in the I/O package.  The following
*       vector is filled in by the Initialize Timesharing SYSCALL, establishing
*       a connection between SDOS/MT and the I/O package.

USERSPACESYSCALL        RMB     3       where the user goes for syscalls
USERSELECT      RMB     3       select a user address space for subsequent use
USERCURRENTSIZE RMB     3       get size of user space; returns in (A,B)
RETURNTOUSER    RMB     3       return to user space selected above
SETQUANTUM      RMB     3       set quantum (60 Hz clock) for this user
COPYTOSYSTEM.BIG RMB    3       copy from selected user space to system space
COPYTOUSER.BIG  RMB     3       copy from system space to selected user space
COPYUSERTODX    RMB     3       copy two bytes from selected user space to D & X
COPYATOUSER     RMB     3       copy A to selected user space (addressed by X)
COPYDTOUSER     RMB     3       copy D to selected user space (addressed by X)
COPYUSERTOA     RMB     3       copy byte from user space to (A)
SETFUSE         RMB     3       set delay timer to (X)
TESTFUSE        RMB     3       read remaining delay time to (X)
CRASHINFOPTR    FDB     $C000   default: where /MT should place crash information
IOQUANTUMTICKS  FCB     3       default time slice for I/O users
CPUQUANTUMTICKS FCB     6       default time slice for compute-bound users
GETREMAININGQUANTUM LDAA #-128  get remaining ticks for user timeslice
                RTS             3 bytes reserved here as default routine

SIZETSPRIMS     EQU     *-USERSPACESYSCALL
                page
CONTEXTBLOCK    RMB     16      holds user context while unwinding stack
targetcap       rmb     16      capability which is target of search


DECRYPTBUFFER     ; THIS IS WHERE CHUNKS OF 8 BYTES GET READ FOR DECRYPTION
        fcb     0,1,2,3,4,5,6,7 Loader decryption area
DECRYPTBUFFEREND  ; END OF DECRYPT BUFFER

NEWKEYENCRYPTED ; ENCRYPTED VERSION OF KEY USED TO LOAD THIS FILE
        FCB     0,0,0,0,0,0,0,0 SPACE TO HOLD 8 BYTE KEY

ILKCAP          ; SEED FOR INTERLOCK CAPABILITY SUPPLIED BY ILK.CREATE
        RMB     16

        PAGE    Internal SYCALL control blocks
*       INTERNAL SYSCALL CONTROL BLOCKS

BYTEMODE        EQU     0       used by READA

DISPOUT ; used to write error number on console
        FCB     SYSCALL:WRITEA,READA:SCLEN,CHANGED,IGNORED
        FDB     STRINGBUFFER,CHANGED    BUFFER ADDRESS & LENGTH

DISPREADB3 ; USED TO READ POINTER FROM ERRORMSGS.SYS
        FCB     SYSCALL:READB,READB:SCLEN,ERRMSGCHANNEL,IGNORED
        FDB     IGNORED,IGNORED WRBUF,WRLEN
        FDB     CHANGED,DISPPOS1+1,3    REPLY LENGTH, BUFFER ADDRESS & LENGTH

DISPPOS1 ; THESE 4 BYTES GET MODIFIED BY DISPREADB3, DISPUSERERROR
        FCB     0,CHANGED,CHANGED,CHANGED

DISPGETCHAR ; USED TO READ ERROR MESSAGE FROM ERRORMSGS.SYS
        FCB     SYSCALL:READA,READA:SCLEN,ERRMSGCHANNEL,BYTEMODE
        FDB     IGNORED,IGNORED WRBUF,WRLEN
        FDB     CHANGED,BUFFER,1        rplen, rdbuf, rdlen

GETDEVTYP ; used to get device type of channel just opened
        FCB     SYSCALL:STATUS,STATUS:SCLEN,CHANGED,SC:GETTYPE
        FDB     IGNORED,IGNORED
        FDB     CHANGED,BUFFER,1        rplen, rdbuf, rdlen

DUMPBUFFERS ; used to dump the device buffers at EXIT
        FCB     SYSCALL:CONTROL,CONTROL:SCLEN,CHANGED,CC:DUMPBUFFERS
        PAGE
ATTENTIONCK ; used to check for attention on a virtual terminal device
        FCB     SYSCALL:STATUS,STATUS:SCLEN,CHANGED,SC:ATTENTIONCK
        FDB     IGNORED,IGNORED
        FDB     CHANGED,BUFFER,1

CKANYLINE ; has the status of any port changed?
        ; ASSERT: real channel 0 is open to user 1's console
        FCB     SYSCALL:STATUS,STATUS:SCLEN,0,SC:ALLSTATUS
        FDB     IGNORED,IGNORED
        FDB     CHANGED,BUFFER,1

READYLINE ; used to stage an input line
        FCB     SYSCALL:CONTROL,CONTROL:SCLEN,CHANGED,CC:ACTIVATIONCK

GETLINEFLAGS ; get virtual terminal line flags hint for this user
        FCB     SYSCALL:STATUS,STATUS:SCLEN,CHANGED,SC:GETLINEFLAGSHINT
        FDB     IGNORED,IGNORED
        FDB     CHANGED,BUFFER,1

CLOSELOGCHAN ; used to close the log channel and the real console
        FCB     SYSCALL:CLOSE,CLOSE:SCLEN,CHANGED

OPENLFCHAN ; used to open the real console
        FCB     SYSCALL:OPEN,OPEN:SCLEN,CHANGED,IGNORED
        FDB     CHANGED,CHANGED
        FDB     CHANGED,NAMESCANNEDCNT,2

SETKILLPROOF ; used to killproof a user console
        FCB     SYSCALL:CONTROL,CONTROL:SCLEN,CHANGED,CC:KILLPROOF

CLEARKILLPROOF ; used to killenable a user console
        FCB     SYSCALL:CONTROL,CONTROL:SCLEN,CHANGED,CC:KILLENABLE
        PAGE
LOADOPEN ; used for opening load module file
        FCB     SYSCALL:OPEN,OPEN:SCLEN,CHANGED,IGNORED
        FDB     CHANGED,CHANGED wrbuf, wrlen
        FDB     CHANGED,NAMESCANNEDCNT,2        rplen, rdbuf, rdlen

LOADGETPOS ; USED BY LOADER TO PERFORM A "SKIP N BYTES" LOADER COMMAND
        FCB     SYSCALL:STATUS
        FCB     STATUS:SCLEN
        FCB     CHANGED
        FCB     SC:GETPOS
        FDB     IGNORED,IGNORED        WRBUF,WRLEN
        FDB     CHANGED                RPLEN: EXPECTED VALUE OF 4
        FDB     LOADFILEPOS            PLACE TO PUT LOAD FILE POSITION
        FDB     4                      SIZE OF LOAD FILE POSITION BUFFER
*
LOADFILEPOS ; CURRENT POSITION OF LOAD FILE
        FCB     CHANGED,CHANGED,CHANGED,CHANGED
*
LOADSETPOS ; SYSCALL TO POSITION LOAD FILE PAST SKIP RECORD
        FCB     SYSCALL:CONTROL        USE BY LOADER TO EXECUTE "SKIP N BYTES"
        FCB     CONTROL:SCLEN+4
        FCB     CHANGED                LOAD CHANNEL
        FCB     CC:POSITION
        FDB     LOADFILEPOS            POINTER TO POSITION SELECT BUFFER
        FDB     4                      SIZE OF POSITION SELECT BUFFER
*
GETSERIALNUMBER ; syscall to read serialnumber for decrypting loader
        FCB     SYSCALL:GETSERIALNUMBER
        FCB     GETSERIALNUMBER:SCLEN
        FCB     IGNORED,IGNORED
        FDB     IGNORED,IGNORED WRBUF,WRLEN
        FDB     CHANGED         EXPECTED VALUE OF 8
        FDB     ROMSERIALNUMBER,8

ROMSERIALNUMBER ; holds ROM serial number for decrypting loader to inspect
        FDB     CHANGED,CHANGED,CHANGED,CHANGED
*
FILLDECRYPTBUFFER ; SYSCALL BLOCK TO READ 8 BYTES INTO DECRYPTBUFFER
         FCB     SYSCALL:READB,READB:SCLEN
         FCB     CHANGED,IGNORED
         FDB     IGNORED,IGNORED
         FDB     CHANGED         EXPECTED VALUE IS 8
         FDB     DECRYPTBUFFER,8
        PAGE
GET1BYTE ; SYSCALL BLOCK USED TO READ 1 BYTE FROM LOADCHANNEL INTO BUFFER
        FCB     SYSCALL:READB,READB:SCLEN
        FCB     CHANGED,IGNORED
        FDB     IGNORED,IGNORED
        FDB     CHANGED RPLEN: EXPECTED VALUE OF 1
        FDB     BUFFER,1        WHERE TO PLACE REPLY

OPENERRMSGS ; open the errormsgs.sys file
        FCB     SYSCALL:OPEN,OPEN:SCLEN,ERRMSGCHANNEL,IGNORED
        FDB     ERRMSGFILENAME,LENERRMSGFILENAME
        FDB     CHANGED,NAMESCANNEDCNT,2

ERRMSGFILENAME
        FCC     'ERRORMSGS.SYS'
LENERRMSGFILENAME       EQU     *-ERRMSGFILENAME

CLOSEERRMSGS ; used to close errormessage channel
        FCB     SYSCALL:CLOSE,CLOSE:SCLEN,ERRMSGCHANNEL

console fcc     'CONSOLE:'
lconsole equ    *-console
        page
; the following are used for indexing into tables;
;   (x) -> table; indexfor<xxx> must be valid
;   the carry bit is preserved

ldaindex
        if      m6809
indexforlda equ *+3
        lda     >0,x
        else
indexforlda equ *+1
        lda     0,x
        fin
        rts

staindex
        if      m6809
indexforsta equ *+3
        sta     >0,x
        else
indexforsta equ *+1
        sta     0,x
        fin
        rts
        PAGE    Serially Reusable Loader Code
decrypt1        ; do "decrypt step"
        staa    0,x
        ldaa    1,x     EOR with this byte of key
        rora            shift right, saving carry from left
Key1    equ     *+1
        eora    #$16    $16 is red herring
        staa    1,x
        ldaa    2,x     EOR with this byte of key
        rora            shift right, saving carry from left
Key2    equ     *+1
        eora    #$73    $73 is red herring
        staa    2,x
        ldaa    3,x     EOR with this byte of key
        rora            shift right, saving carry from left
Key3    equ     *+1
        eora    #$F6    $F6 is red herring
        staa    3,x
        ldaa    4,x     EOR with this byte of key
        rora            shift right, saving carry from left
Key4    equ     *+1
        eora    #$09    $09 is red herring
        staa    4,x
        ldaa    5,x     EOR with this byte of key
        rora            shift right, saving carry from left
Key5    equ     *+1
        eora    #$56    $56 is red herring
        staa    5,x
        ldaa    6,x     EOR with this byte of key
        rora            shift right, saving carry from left
Key6    equ     *+1
        eora    #$ED    $ED is red herring
        staa    6,x
        ldaa    7,x     EOR with this byte of key
        rora            shift right, saving carry from left
Key7    equ     *+1
        eora    #$41    $41 is red herring
        staa    7,x
        decb            down count # iterations
        bne     decryptloop     b/ more to do
        jmp     decryptrts      all done, go clean up and exit!
        page
*       Decrypt -- Undoes Encrypt
*       Decryption key is stored inline in locations KEY0, KEY1, ... KEY7
*       Block of 8 bytes at (X) is decrypted in place
*
Decrypt ; Do the encryption in reverse, literally
*       ldab    #64     64 iterations of reverse encryption required
        ldab    key7    do 8 + 2 lsb of key iterations
        andb    #3
        addb    #8
        bsr     eorall8bytes    unscramble least significant byte
        staa    7,x     do first decryption iteration
decryptloop ; right shift current value and EOR with key
        rora            Shift encrypted "encrypt" bit into carry...
        ldaa    0,x     EOR with this byte of key
        rora            shift right, saving carry from left
Key0    equ     *+1
        eora    #$92    92 is red herring
MTCHKSUMBASE    ; ALL CODE FROM HERE TO END OF MT IS CHECKSUMMED!!
        bmi     decrypt1        b/ encrypt bit was 1, go do "decrypt step"
decrypt0 ; "encrypt" bit was 0, right shift current value and EOR with randomizer
        eora    key0    undo "eora key" done by decryptloop
        anda    #$7F    force MSB to be zero
        eora    #$55    EOR with randomizer byte
        staa    0,x     (Note: MSB(Randomizer) must be zero)
        ldaa    1,x     EOR with this byte of key
        rora            shift right, saving carry from left
        eora    #$A6
        staa    1,x
        ldaa    2,x     EOR with this byte of key
        rora            shift right, saving carry from left
        eora    #$0A
*** note: perhaps could speed up this loop, by doing LDD/STD, and using
*** ADDD instead of EORx; would by ~8 cycles/byte instead of 12~
        staa    2,x
        ldaa    3,x     EOR with this byte of key
        rora            shift right, saving carry from left
        eora    #$9C
        staa    3,x
        ldaa    4,x     EOR with this byte of key
        rora            shift right, saving carry from left
        eora    #$E3
        staa    4,x
        ldaa    5,x     EOR with this byte of key
        rora            shift right, saving carry from left
        eora    #$57
        staa    5,x
        ldaa    6,x     EOR with this byte of key
        rora            shift right, saving carry from left
        eora    #$AC
        staa    6,x
        ldaa    7,x     EOR with this byte of key
        rora            shift right, saving carry from left
        eora    #$39
        staa    7,x
        decb            down count # iterations
        bne     decryptloop     b/ more iterations to try
decryptrts
        bsr     eorall8bytes    now unscramble Most significant byte
        staa    0,x
        rts             decryption complete, result is in Result
        page
Eorall8bytes ; Compute XOR of all 8 bytes
        ldaa    4,x     Why are the index displacements all mixed up?
        eora    7,x     Because it puzzles the hell out of whoever...
        eora    5,x     attempts to dis-assemble it!
        eora    0,x
        eora    2,x
        eora    6,x
        eora    1,x
        eora    3,x     so Most sig byte of result depends on all 64 bits
        rts
        page    Optimized CopyToUser and CopyToSystem routines
CopyToSystem ; (X) contains user address, (Y) system address, (D) = count
;  This routine optimizes the best for transfers of 1 byte,
;    which need the optimization the most.  We also handle 0 and 2.
;  This optimization primarily speeds up little I/O requests.
        if      m6800
        cmpb    #1                     1 byte copy ?
        beq     CopyToSystem.1         b/ appears to be.
        cmpb    #2                     copy 2 bytes ?
        lbhi    copytosystem.big       b/ copy >2, go do it!
        blo     CopyToSystem.0         b/ seems to be zero byte copy
CopyToSystem.2
        tsta
        lbne    copytosystem.big
        else    (m6801!m6809)
        cmpd    #1                     1 byte copy ?
        beq     CopyToSystem.1         b/ yes, go handle
        cmpd    #2                     copy 2 bytes ?
        lbhi    copytosystem.big       b/ copy >2, go do it!
        blo     CopyToSystem.0         b/ Copy 0 bytes
CopyToSystem.2
        fin
        jsr     copyusertodx           fetch byte pair (MUST NOT DAMAGE TEMPX!)
        if      (m6800!m6801)
        std     [tempx]
        else    (m6809)
        std     ,y
        fin
        rts

CopyToSystem.1 ; copy 1 byte
        if      m6800
        tsta
        lbne    copytosystem.big
        fin
        jsr     copyusertoa
        if      (m6800!m6801)
        sta     [tempx]
        else    (m6809)
        sta     ,y
        fin
        rts

CopyToSystem.0 ; copy 0 bytes
        if      m6800
        tsta
        lbne    copytosystem.big
        fin
        rts
        page
CopyToUser ; (X) contains system address, (Y) user address, (D) = count
;  This routine optimizes the best for transfers of 1 byte,
;     which need the optimization the most.  We also handle 0 and 2.
;  This optimization primarily speeds up return of status results.
        if      m6800
        cmpb    #1                     1 byte copy ?
        beq     CopyToUser.1           b/ appears to be.
        cmpb    #2                     copy 2 bytes ?
        lbhi    copytouser.big         b/ copy >2, go do it!
        blo     CopyToUser.0           b/ seems to be zero byte copy
CopyToUser.2
        tsta
        lbne    copytouser.big
        else    (m6801!m6809)
        cmpd    #1                     1 byte copy ?
        beq     CopyToUser.1           b/ yes, go handle
        cmpd    #2                     copy 2 bytes ?
        lbhi    CopyToUser.big         b/ copy >2, go do it!
        blo     CopyToUser.0           b/ Copy 0 bytes
CopyToUser.2
        fin
        ldd     ,x                     fetch byte pair to store
        if      m6800!m6801
        ldx     tempx
        else
        tfr     y,x
        fin
        jsr     copydtouser            store byte pair
        rts

CopyToUser.1 ; copy 1 byte
        if      m6800
        tsta
        lbne    copytouser.big
        fin
        lda     ,x                     fetch byte to store
        if      m6800!m6801
        ldx     tempx
        else
        tfr     y,x
        fin
        jsr     copyatouser
        rts

CopyToUser.0 ; copy 0 bytes
        if      m6800
        tsta
        lbne    copytouser.big
        fin
        rts
        page    Checksum and Program Identification
        If      SDOSExtendedSpace
MTMSG   FCC     'SDOS/ES Version '
        else    (SDOS/MT)
MTMSG   FCC     'SDOS/MT Version '
        fin
        FCB     '0+((MTVERSION/$10)&$F)
        FCB     '.
        FCB     '0+((MTVERSION/$1)&$F)
        IFUND   MTSUBVERSION
        ELSE
        FCB     MTSUBVERSION
        FIN
        FCB     $31     patch level byte
        FCC     ', '
COPYRIGHT       FCC     'Copyright (C) 1980 Software Dynamics'
                FCB     ASCII:CR
COPYRIGHTEND    EQU     *
MTCHKSUM        FCB     0       this gets set to a value that makes the sum=0
        page    Tables
*
*       SYSCALL MINIMUM SIZE,+ N-WAY OPCODE BRANCH TABLE
*
OPCODES
   OPEN:SCLEN,#OPEN,IGNORED                OPEN FILE
   CREATE:SCLEN,#CREATE,IGNORED            CREATE A NEW FILE
   CLOSE:SCLEN,#CLOSE,IGNORED              CLOSE A FILE
   RENAME:SCLEN,#RENAME,IGNORED            RENAME A FILE
   DELETE:SCLEN,#DELETE,IGNORED            DELETE A FILE
   LOAD:SCLEN,#LOAD,IGNORED                LOAD A FILE INTO MEMORY
   CHAIN:SCLEN,#CHAIN,IGNORED              CHAIN TO A FILE
   CREATELOG:SCLEN,#CREATELOG,IGNORED      CREATE A FILE FOR OUTPUT ON LOG CHANNEL
   CLOSELOG:SCLEN,#CLOSELOG,IGNORED        CLOSE LOG OUTPUT FILE
   DISKDEFAULT:SCLEN,#ERRNOTTS,IGNORED     SET DISK DEFAULT DEVICE *** error ***
   READA:SCLEN,#READA,IGNORED              READ ASCII BYTES FROM A FILE
   READB:SCLEN,#READB,IGNORED              READ BINARY BYTES FROM A FILE
   WRITEA:SCLEN,#WRITEA,IGNORED            WRITE ASCII BYTES TO A FILE
   WRITEB:SCLEN,#WRITEB,IGNORED            WRITE BINARY BYTES TO A FILE
   CONTROL:SCLEN,#CONTROL,IGNORED          PERFORM A CONTROL OPERATION ON AN I/O CHANNEL
   STATUS:SCLEN,#STATUS,IGNORED            READ STATUS FROM AN I/O CHANNEL
   WAITDONE:SCLEN,#SYSCALLEXIT,IGNORED     WAIT FOR I/O CHANNEL OPERATION DONE *** no-op ***
   EXIT:SCLEN,#EXIT,IGNORED                GIVE CONTROL BACK TO THE OPERATING SYSTEM
   ERROREXIT:SCLEN,#ERROREXIT,IGNORED      EXIT TO SYSTEM WITH ERROR CODE
   SETERROR:SCLEN,#SETERROR,IGNORED        REPORT AN ERROR TO THE SYSTEM
   GETERROR:SCLEN,#GETERROR,IGNORED        RETURN THE LAST ERROR CODE
   DISPERROR:SCLEN,#DERR,IGNORED           DISPLAY USER'S LAST ERROR
   KILLPROOF:SCLEN,#KILLPROOF,IGNORED      MAKE USER PROGRAM KILL-PROOF
   KILLENABLE:SCLEN,#KILLENABLE,IGNORED    MAKE USER PROGRAM KILLABLE
   DEBUG:SCLEN,#ERRNOTTS,IGNORED           CALL SYSTEM DEBUGGER *** error ***
   ATTNCHECK:SCLEN,#ATTNCHECK,IGNORED      OPERATOR ATTENTION CHECK
   ISCONSOLE:SCLEN,#ISCONSOLE,IGNORED      IS CHANNEL ZERO OPEN TO CONSOLE PREDICATE
   INTERLOCK:SCLEN,#INTERLOCK,IGNORED      PERFORM INTERLOCK FUNCTIONS
   DELAY:SCLEN,#DELAY,IGNORED              DELAY USER AT 60 Hz RESOLUTION
   +0,#ERRILLSYSCALL,IGNORED               READ LOGICAL UNIT NUMBER
   GETSERIALNUMBER:SCLEN,#USERGETSERIALNUMBER,IGNORED GET SERIAL NUMBER
   JOBCONTROL:SCLEN,#JOBCONTROL,IGNORED    PERFORM JOB CONTROL FUNCTIONS
OPCODEMAX       EQU     (*-OPCODES)/4-1
        page    Syscall Handler: Exit back to user
SYSCALL.ERRILLSYSCALL
        LDX     #ERR:ILLEGALSYSCALL
        JMP     USERERRORED

SYSCALLEXIT
        JSR     RELEASEALLPAGES get rid of all user pages
        LDAA    UCB:GIVERPLEN,X    return reply length to user, if requested
        BEQ     SYSCALLEXIT.1   B/ not requested
        IF      M6800!M6801
        LDD     UCB:USERSCB,X
        ADDD    #SCBLK:RPLEN
        STD     TEMPX
        LDD     SCBLK:RPLEN,X
        LDX     TEMPX
        ELSE    (M6809)
        LDD     SCBLK:RPLEN,X
        LDX     UCB:USERSCB,X
        LEAX    SCBLK:RPLEN,X
        FIN
        JSR     COPYDTOUSER
SYSCALLEXIT.1
        if      m6800!m6801!m6811
        tsx                     make sure things don't get out of hand...
        cpx     #SDOSMTSTACK-2  stack MUST BE EMPTY (except for firewall) here!
        beq     SYSCALLEXIT.2   b/ stack is empty
        else    (m6809)
        cmps    #SDOSMTSTACK-2  make sure stack has just firewall in it here
        beq     SYSCALLEXIT.2   b/ stack is empty
        tfr     s,x             save bad stack for error reporting purposes
        fin
        jsr     GoCatatonic     things are very sick...
SYSCALLEXIT.2
        JSR     RETURNTOUSER    return to user with fruits of labor
*       JMP     SYSCALLENTRY
        page    Syscall Handler: Front Door
SYSCALLENTRY ; user issued a system call, service it!
; assert: Carry bit in user context is cleared by USERSPACESYSCALL
; assert: DPR register contains zero on entry to this point
        LDX     CURRENTUCB      save remainder of user's quantum
        STA     UCB:REMAININGQUANTUM,X
        JSR     GETXFROMUSERCONTEXT fetch user's X from his context (return D & X)
        LDX     CURRENTUCB      fetch user's syscall block
        STD     UCB:USERSCB,X
        LDX     UCB:USERSCB,X
        JSR     COPYUSERTODX
        CMPA    #OPCODEMAX      IS THE OPCODE LEGAL?
        BHI     SYSCALL.ERRILLSYSCALL B/ NO
        ASLA                    MULTIPLY OPCODE VALUE BY 4
        ASLA
        IF      OPCODEMAX*4>>255
        ?ERROR  OPCODE INDEXING WON'T WORK
        FIN
        STAA    SYSCALLX+1      LOCATE OPCODE TABLE SLOT CORRESPONDING TO OPCODE
        CLRA
        ANDB    #%01111111
        CMPB    #1              SCBLK:WLEN UNREASONABLY SMALL ?
        BLS     SYSCALL.ERRSYSCALLTOOSHORT B/ YES, GO COMPLAIN
        LDX     CURRENTUCB
        IF      M6809
        TFR     X,Y
        ELSE
        STX     TEMPX
        FIN
        LDX     UCB:USERSCB,X
        JSR     COPYTOSYSTEM
        PAGE
SYSCALLVALIDATE ; inspect system call block for "reasonableness"
        LDX     CURRENTUCB      ; validate the syscall block
        LDAA    SCBLK:WLEN,X    COPY SYSCALL BLOCK LENGTH TO (A)
        ANDA    #%01111111      MASK OFF WAIT FLAG
        CMPA    #SCBLK:RDLEN+2
        BHS     SYSCALLVR       B/ reply buffer has been supplied
        CLR     UCB:GIVERPLEN,X no RDBUF, so no RPLEN desired
        CMPA    #SCBLK:WRLEN+2  validate write buffer, if given
        BHS     SYSCALLVW       B/ write data buffer has been supplied
        BRA     SYSCALLVO       go validate the opcode

SYSCALLVR ; validate reply buffer
        STA     UCB:GIVERPLEN,X flag 'please fill in SCBLK:RPLEN'
        CLR     SCBLK:RPLEN,X   zero reply length as convenience for later code
        CLR     SCBLK:RPLEN+1,X
        LDD     SCBLK:RDLEN,X   don't care how squirrelly the RDBUF is if 0 RDLEN
        BEQD    SYSCALLVW       B/ RDLEN=0
        ADDD    SCBLK:RDBUF,X
        BCS     SYSCALL.ERRBADREADBUF
        CMPD    UCB:TOPMEM,X
        BHI     SYSCALL.ERRBADREADBUF
SYSCALLVW
        LDD     SCBLK:WRLEN,X   don't care how squirrelly the WRBUF is if 0 WRLEN
        BEQD    SYSCALLVO       B/ 0 WRLEN
        ADDD    SCBLK:WRBUF,X
        BCS     SYSCALL.ERRBADWRITEBUF
        CMPD    UCB:TOPMEM,X
        BHI     SYSCALL.ERRBADWRITEBUF
SYSCALLVO ; validate opcode
        LDAA    SCBLK:WLEN,X    COPY SYSCALL BLOCK LENGTH TO (A)
        ANDA    #%01111111      MASK OFF WAIT FLAG
        LDX     SYSCALLX        GRAB POINTER TO OPCODE TABLE SLOT
        CMPA    OPCODES&$FF,X   IS SIZE OF SYSCALL BLOCK >= NECESSARY MINIMUM ?
        BLO     SYSCALL.ERRSYSCALLTOOSHORT B/ NO, YOU DIE!
        JSR     [(OPCODES&$FF)+1,X] GO DO THE SYSCALL
        LBCC    SYSCALLEXIT     do a no-error exit
        JMP     USERERRORED     else bitch about situation
        page
SYSCALL.ERRBADREADBUF
        LDX     #ERR:BADREADBUF
        JMP     USERERRORED

SYSCALL.ERRBADWRITEBUF
        LDX     #ERR:BADWRITEBUF
        JMP     USERERRORED

SYSCALL.ERRSYSCALLTOOSHORT
        LDX     #ERR:SYSCALLTOOSHORT
        JMP     USERERRORED
        PAGE
ERRILLSYSCALL
        JSR     ERRET
        FDB     ERR:ILLEGALSYSCALL

ERRSYSCALLTOOSHORT
        JSR     ERRET
        FDB     ERR:SYSCALLTOOSHORT

ERRBADWRITEBUF
        JSR     ERRET
        FDB     ERR:BADWRITEBUF

ERRBADREADBUF
        JSR     ERRET
        FDB     ERR:BADREADBUF

ERRNOTTS
        JSR     ERRET
        FDB     ERR:NOTUNDERTIMESHARE
        PAGE    Job Scheduler
SAVEPLACE
*       Remember return address in context of this user and go find something
*       else to do.  The remembered return address will receive control at
*       some later time.
        JSR     SAVECONTEXT
        LDD     SDOSMTSTACK-2   store stacked context into UCB
        STD     UCB:STACK-2,x
        LDD     SDOSMTSTACK-4
        STD     UCB:STACK-4,x
        LDD     SDOSMTSTACK-6
        STD     UCB:STACK-6,x
        LDD     SDOSMTSTACK-8
        STD     UCB:STACK-8,x
        LDD     SDOSMTSTACK-10
        STD     UCB:STACK-10,x
        LDD     SDOSMTSTACK-12
        STD     UCB:STACK-12,x
        LDD     SDOSMTSTACK-14
        STD     UCB:STACK-14,x
        LDD     SDOSMTSTACK-16
        STD     UCB:STACK-16,x
        STS     UCB:STACKP,X    remember which part of context is useful
        if      M6800!M6801!M6811
        LDD     UCB:STACKP,X    remember, (S) points to next free byte
        SUBD    #SDOSMTSTACK-UCB:STACKSIZE-1
        BHS     POLLFORUSER     b/ won't lose any context
        LDX     TEMPX           so we can see bad stack pointer
        else    (m6809)
        CMPS    #SDOSMTSTACK-UCB:STACKSIZE check amount of context to save
        BHS     POLLFORUSER     b/ won't lose any context
        TFR     S,X             so we can see bad stack pointer
        fin
        JSR     GOCATATONIC     ...too much context to save...
        page
POLLFORUSER ; Poll for some user ready to run
        lds     #SDOSMTSTACK-(&m6809)  start with fresh stack pointer
        ldaa    sdosmtstatuschanged    any status change for any user ?
        beq     pfu.0                  b/ no, skip expensive stuff
        clr     sdosmtstatuschanged    acknowledge we have seen status changes
pfu.i ; search input queue for all jobs whose input is now complete
        jsr     examineinputq          go look for a user which is ready
        bcs     pfu.cklineflags        b/ no more input-complete jobs
        std     currentucb             give this job a complete I/O slice
        ldx     currentucb
        ldab    ioquantumticks
        stab    ucb:remainingquantum,x
        ldd     currentucb
        jsr     addioq                 this job ready, stuff in fast-service q
        bra     pfu.i                  and go see if more jobs are ready
        page
pfu.cklineflags ; status change may have been due to line flags or ^C^C
        JSR     CHECKLINEFLAGS         see if anyone twitched
pfu.0 ; no status changes left to service
        ; First, look for high priority work
        JSR     EXAMINEOUTPUTQ         look for output complete
        BCC     PFU.1                  (queue is normally empty)
        JSR     EXAMINESPACEQ          look for space available
        BCC     PFU.1                  (queue is normally empty)
        JSR     EXAMINEDELAYQ          see if anyone's time is up
        BCC     PFU.1                  (queue is normally empty)
        JSR     EXAMINEIOQ             look for I/O bound user who needs a turn
        BCS     PFU.RUNLOWPRIORITY     b/ no high priority work
PFU.1 ; user specified by (D) wants priority service!
        STD     CURRENTUCB             we should serve this user for awhile
        LDAA    RUNQ                   any low priority requests ?
        ORAA    LOADQ                  (someone in RUNQ or LOADQ ?)
        BEQ     PFU.2                  b/ no, serve this user
        LDX     CURRENTUCB
        LDD     SERVICEDIO             set to inspect SERVICEDIO flags
        BITA    UCB:BITMASK,X          has user recieved good service recently?
        BNE     PFU.1A                 b/ yes, stick him back on front of IOQ
        BITB    UCB:BITMASK+1,X        ...?
        BEQ     PFU.2                  b/ no, run this user
PFU.1a ; user has recently received good service
        ; --> all high priority users have had good service.
        ; Let's give the low priority users a SHORT turn.
        LDD     CURRENTUCB             yes, stick him back on IOQ
        JSR     ADDIOQFRONT            give this guy 1st shot at next service
PFU.RUNLOWPRIORITY ; no high priority work
        ; No high priority work. Mark nobody as having had good service.
        CLR     SERVICEDIO             obviously, no high priority work to do
        CLR     SERVICEDIO+1
        JSR     EXAMINELOADQ           look for a user that wants to load something
        BCC     PFU.RUN                (queue is normally empty)
        JSR     REMRUNQ                see if there's any user to run
        TSTA                           UCB's are on page boundaries
        BEQ     POLLFORUSER            B/ none to run--keep looking
PFU.RUN ; run user selected by (D)
        STD     CURRENTUCB             we should serve this user for awhile
PFU.2 ; run user selected by CURRENTUCB
        LDX     CURRENTUCB
        LDD     SERVICEDIO             record that this user...
        ORAA    UCB:BITMASK,X          obtained good service recently
        ORAB    UCB:BITMASK+1,X
        STD     SERVICEDIO
        LDAA    UCB:REMAININGQUANTUM,X = time this user should get
        LDB     OUTPUTQ                anybody in fast service queues ?
        ORAB    SPACEQ
        ORAB    DELAYQ
        ORAB    IOQ
        BNE     PFU.4                  b/ yes, ensure that system is responsive
        LDAB    LOADQ                  any other demand for low priority service?
        ORAB    RUNQ                   (somebody in LOAD or RUN queue ?)
        BNE     PFU.3                  b/ yes, use given time slice
        LDA     CPUQUANTUMTICKS        nobody else needs service!
        BRA     PFU.3                  so give this guy excellent service
        page
PFU.4 ; (A) contains time slice desired, but fast service q's contain users
        CMPA    IOQUANTUMTICKS         is slice too big ?
        BLE     PFU.3                  b/ no
        LDAA    IOQUANTUMTICKS         yes, trim to keep response time down
PFU.3 ; time slice for user has been trimmed to appropriate amount
        LDAB    IOQUANTUMTICKS         get time slice abort threshold
        LDX     #TIMESLICEABORTED      where to go when time slice up
        JSR     SETQUANTUM             tell /MT primitives all about it...
        JSR     FETCHCONTEXT           fetch user-specific context
        LDAA    CURRENTUSER
        JSR     USERSELECT
        LDX     CURRENTUCB
        LDS     UCB:STACKP,X           fetch this user's system environment
        LDD     UCB:STACK-2,x          restore stacked context from UCB
        STD     SDOSMTSTACK-2          I know this looks funny, but note
        LDD     UCB:STACK-4,x          that the stack pointer is already
        STD     SDOSMTSTACK-4          set properly; an interrupt will
        LDD     UCB:STACK-6,x          push trash below that place even
        STD     SDOSMTSTACK-6          if we are storing there. We don't
        LDD     UCB:STACK-8,x          care one bit.
        STD     SDOSMTSTACK-8
        LDD     UCB:STACK-10,x
        STD     SDOSMTSTACK-10
        LDD     UCB:STACK-12,x
        STD     SDOSMTSTACK-12
        LDD     UCB:STACK-14,x
        STD     SDOSMTSTACK-14
        LDD     UCB:STACK-16,x
        STD     SDOSMTSTACK-16
        LDAA    UCB:KILLPROOF,X        is job kill-proof ?
        BNE     PFU.6                  b/ yes, force it to continue running
        LDA     UCB:JOBSTATE,X         not killproof, is this guy a dead duck ?
        CMPA    #JS:DYING
        LBEQ    JOBCONTROL.MERCYKILLING b/ yes, issue the coup de grace
PFU.6 ; let job continue running
        LDX     UCB:QUEUEERR,X         see if reason to croak now
        LBNE    ERRORINQ               go rap him on the fingers!
        LDX     CURRENTUCB
        OKRTS                   go back to where ah came frum
        PAGE
CHECKLINEFLAGS ; only called if VT driver signals 'status has changed'
; **** DESTROYS CURRENTUCB ****
        LDX     #CKANYLINE      see if anyone's twitched
        JSR     SYSCALL$
        BCC     CHECKLINEFLAGS.DOIT     B/ got something
        JSR     GOCATATONIC             gasp..choke...die....

CHECKLINEFLAGS.DOIT
        TST     BUFFER                  see if worth looking further
        BNE     CHECKLINEFLAGS.DOIT.1
        RTS

CHECKLINEFLAGS.DOIT.1
        LDA     UCBCHAIN
CHECKLINEFLAGS.DOIT.2
        STA     CURRENTUCB
        JSR     GETUSERLFCHANNEL
        BEQ     CHECKLINEFLAGS.DOIT.3   b/ no LF channel, so don't ask for lineflags
        LDX     #GETLINEFLAGS
        STA     SCBLK:PARAMS,X          plug in the user's console channel
        JSR     SYSCALL$                get the lineflags hint
        BCS     CHECKLINEFLAGS.KABLOOIE something's wrong!!
        LDA     BUFFER                  get the hint
        LDX     CURRENTUCB
        STA     UCB:LINEFLAGS,X         save the hint
CHECKLINEFLAGS.DOIT.3
        LDA     UCB:LFNEXT,X
        BNE     CHECKLINEFLAGS.DOIT.2   go look at the next user, if any more
        RTS                             all done
        page
CHECKLINEFLAGS.KABLOOIE

; If we're here, we probably got hit with an ERR:PROGRAMKILLED, so we'll
; pretend that's what we got.  Now that it's agreed that the user was
; ^C'd, remember the actual error, move him from the delay or interlock
; blocked queue (if he was there) to the run queue, and then go check the
; status of the next user.  The other queue-checking routines will eventually
; remove the errored user and dump him in the run queue, where he will
; be received into the clutches of USERDIED (heh, heh!) via POLLFORUSER

        TXD
        LDX     CURRENTUCB              save whatever happened for the user
        STD     UCB:QUEUEERR,X
        CLR     UCB:LINEFLAGS,X         (just to be tidy)
        JSR     ILK.CTLC.UNBLOCK        call this just in case...
        JSR     DELAY.CTLC.UNBLOCK      ...and this one, too, in case...
        LDX     CURRENTUCB
        BRA     CHECKLINEFLAGS.DOIT.3   go look for the next user

GETUSERLFCHANNEL ; returns UCB:LFCHAN in (A)
; Z bit set --> this job has no LFCHAN
        LDX     CURRENTUCB
        LDA     UCB:LFCHAN,X
        CMPA    #$FF                   is it open ?
        RTS
        page
TIMESLICEABORTED ; system is forcing user to relinquish control
; (A) contains number of quantum ticks that user hasn't burned yet
; Assert: DPR register contains zero here
        LDX     CURRENTUCB      save remaining quantum
        STA     UCB:REMAININGQUANTUM,X
        BLE     TIMESLICEEXPIRED b/ quantum really did expire
        PSHA                    user didn't get all of allocated time slice!
        LDD     UCB:BITMASK,X   so remember that good service is still needed
        COMD
        ANDA    SERVICEDIO      (reset SERVICEDIO bit)
        ANDB    SERVICEDIO+1
        STD     SERVICEDIO
        PULA
        CMPA    IOQUANTUMTICKS  safe to put this guy in fast service Q ?
        BGT     TIMESLICEABORTED.CPU b/ no
        LDD     CURRENTUCB      put user in I/O service Q
        JSR     ADDIOQFRONT
        BRA     TIMESLICE.1     and wait for scheduler to start him again

TIMESLICEABORTED.CPU ; put guy on front of RUN Q
        LDD     CURRENTUCB
        JSR     ADDRUNQFRONT
        BRA     TIMESLICE.1

        if      ShowRoughEdges
? ; Note: bug in scheduler.  If a CPU bound job overruns its timeslice, it
; will get  its next time slice penalized; but if there is I/O present,
; its penalized timeslice will get trimmed to IOQUANTUM-- so the effective
; penalty is lost!  This ought to be fixed.
        fin     ShowRoughEdges
        PAGE
*       Come here when the quantum has expired.  The current user is moved to
*       the end of the RUN Q and another ready-to-run user is sought.  If
*       there is only the one user ready to run (only one on the RUN Q) then
*       he will be selected again.

TIMESLICEEXPIRED ; user's time slice is exhausted, (A) holds overrun
        LDX     CURRENTUCB      did user do any terminal I/O ?
        TST     UCB:USERCPUBOUND,X
        BNE     TIMESLICE.CPUBOUND
        ADDA    IOQUANTUMTICKS  yes, set user up for I/O time slice
        STA     UCB:REMAININGQUANTUM,X
        LDD     CURRENTUCB
        JSR     ADDIOQ          put him on I/O queue for fast service
        BRA     TIMESLICE.1

TIMESLICE.CPUBOUND ; this guy clearly wants to eat CPU cycles
        ADDA    CPUQUANTUMTICKS  set him up for looong time slice...
        STA     UCB:REMAININGQUANTUM,X but cheat of for his overrun
        LDD     CURRENTUCB      but make him low priority
        JSR     ADDRUNQ
TIMESLICE.1 ; put guy to sleep till scheduler wakes him
        JSR     SAVEPLACE       this user resumes here for next quantum
        BCS     TIMESLICE.USERDIED
NEWTIMESLICE ; guy woke up, run him!
        LDX     CURRENTUCB      assume this guy will be a bad guy...
        LDA     #1
        STA     UCB:USERCPUBOUND,X and if he's good, we'll relent!
*       BRA     RUNTHISUSER
        PAGE
RUNTHISUSER ; start up the currently selected user
        BSR     RETURNLINEFLAGS give user line flags hint at start of timeslice
        tst     sdosmtstatuschanged any change to user statuses ?
        LBEQ    RETURNTOUSER    b/ no, scheduling decision is correct!
        ldx     currentucb      oops, job choice needs to be re-considered
        lda     ucb:remainingquantum,x fake as though ABORTTIMESLICE occurred
        jmp     timesliceaborted

TIMESLICE.USERDIED
        JMP     USERDIED               go hold a funeral service

RETURNLINEFLAGS
        LDX     CURRENTUCB
        LDA     UCB:LINEFLAGS,X
        LDX     #LINEFLAGS
        JMP     COPYATOUSER             give him the current hint

        PAGE    Error Handling
*       MT ERROR HANDLING
*
*       ERRET -- CALLED VIA A JSR WITH IN-LINE 2-BYTE ERROR CODE
*               ERROR CODE IS LOADED INTO (X)
*               CARRY IS SET TO INDICATE ERROR CONDITION
*               AND A RTS IS PERFORMED
*               IF CALLING ROUTINE HAS NO BCS/BCC AFTER JSR,
*               ERRET AUTOMATICALLY POPS THE STACK ONE SUBROUTINE LEVEL
*               AND LOOKS AGAIN FOR A BCS
*               ***NOTE: THIS MEANS TOP LEVEL (USER!) MUST HAVE BCC/BCS!***
*
ERRET   PULX            GET RETURN ADDRESS TO (X)
        STX     ERRORADDRESS    THIS HELPS WHEN WE'RE DEBUGGING SDOS
        LDX     0,X     GET ERROR CODE INTO (X)
ERRORINX        ; ENTRY POINT IF ERROR CODE IS ALREADY IN (X)
        STX     LASTERROR       SAVE THE ERROR CODE
        BRA     ERRORED         SKIP INTO BCC/BCS STACK POP LOOP
ERRETL  ; POP RETURN ADDRESS FROM THE STACK
        LEAS    2,S
ERRORED ; NOW FAKE "RTS" UNTIL BCC/BCS ENCOUNTERED
        LDX     0,S     GRAB RETURN ADDRESS
        LDAA    0,X     DOES RETURN ADDRESS POINT TO BCS/BCC ?
        IF      M6809
        CMPA    #$10    CHECK FOR LBCC/LBCS
        BNE     *+4
        LDA     1,X
        FIN     M6809
        ANDA    #\%1    (MASK OFF "INVERT BRANCH CONDITION" BIT)
        CMPA    #$24    (BCS OPCODE)
        BNE     ERRETL  NO, SIMULATE "BCS TO A RTS"
        LDX     LASTERROR       GET THE ERROR CODE AGAIN
        ERRORRTS        SET THE CARRY AND EXIT
        PAGE
ERRORSAVE       ; SAVE THE ERROR CODE IN (X)
        STX     LASTERROR
        ERRORRTS        AND EXIT

ERRORINQ        ; save the error code in LASTERROR and clear the queueerr field
        STX     LASTERROR
        LDX     CURRENTUCB
        CLR     UCB:QUEUEERR,X
        CLR     UCB:QUEUEERR+1,X
        BRA     ERRORED
        PAGE
FIREBREAK       ; last-ditch firebreak
        BCS     FIREBREAK.1     need this to stop the stack un-winder
FIREBREAK.1
        BSR     GOCATATONIC     I should never be here--roll up eyes and go mum

GOCATATONIC

;  JSR here to roll over and die
;  (X) contains error code

;  Places crash info at CRASHINFOPTR specified by SDOS/MT primitive table
;     @CRASHINFO+0   MT Version, Revision
;     @CRASHINFO+2   Error Code
;     @CRASHINFO+4   Return Address

        nop                     shut down the world
        sei                     and die
        txd
        ldx     crashinfoptr
        std     2,x             save error code
        LDAA    #MTVERSION      save version and subversion for same reason
        IFUND   MTSUBVERSION
        CLRB
        ELSE
        LDAB    #MTSUBVERSION
        FIN
        STD     0,x
        puld                    fetch return address
        std     4,x             save it, too...
        BRA     *               whizzzz...
        PAGE
*
*       USER SPACE ERROR HANDLING
*
*       USERERRORED
*               IF CALLING ROUTINE HAS NO BCS/BCC AFTER JSR,
*               ERRET AUTOMATICALLY POPS THE USER'S STACK ONE SUBROUTINE LEVEL
*               AND LOOKS AGAIN FOR A BCS
*               ***NOTE: THIS MEANS TOP LEVEL (USER!) MUST HAVE BCC/BCS!***
*
USERERRORED
        STX     LASTERROR
        CPX     #ERR:PROGRAMKILLED      see if he was ^C^C'ed
        BNE     UE.3
USERDIED ; User died via ^C^C
; Assert: can't get here if UCB:LFCHAN=$FF!
        JSR     RELEASEALLPAGES         make room for exit
        JSR     CLOSELOADCHANNEL        in case ^C^C aborted a CHAIN or LOAD
        BCS     *+2                     ignore error (channel not open)
        JSR     CLOSELOG                close LOG channel
        BCS     *+2                     ignore error (channel not open)
        JSR     CLOSECHANNEL0           get rid of any do files
        BCS     *+2                     ignore error if channel 0 already closed
        jsr     ResetLFChannel          force LF channel to 'reset' state
        JSR     OPENCONSOLE
        LDX     #ERR:PROGRAMKILLED
        JMP     EXIT1                   he loses!!

UE.3    JSR     SAVEUSERCONTEXT         leave context PC on top of user stack
        LDX     LASTERROR               let user in on our little secret
        JSR     SETXINSAVEDUSERCONTEXT
        BRA     UE.1

UE.2
        JSR     POPDXFROMUSERSTACK      pop one return level

UE.1
        JSR     GETDXFROMUSERSTACK      look at instruction following return.  If not...
        JSR     COPYUSERTODX            If "bcc/bcs" then pop one return level and look again.
        IF      M6809
        CMPA    #$10
        BNE     *+4
        TFR     B,A                     this was a lbcc/lbcs
        FIN     M6809
        ANDA    #\%1                    ignore "invert branch condition"
        CMPA    #$24                    is this a bcc/bcs?
        BNE     UE.2                    B/ nope!
        JSR     RESTOREUSERCONTEXT      restore user's context to top of pruned stack
        JMP     SYSCALLEXIT
        PAGE    System context management
*       Frequently-used fields of the current UCB are kept in a context area
*       to avoid juggling the X register a lot.  This routine and the
*       SAVECONTEXT routine, below, set up and tear down the context area
*       as attention is focused and unfocused on a particular user.

FETCHCONTEXT
        LDX     CURRENTUCB
        LDD     UCB:LASTERROR,X assert: (x) -> current user's UCB
        STD     USERLASTERROR
        LDAA    UCB:USERNUMBER,X
        STAA    CURRENTUSER
        STAA    INDEXFORLDA
        RTS

SAVECONTEXT
        LDX     CURRENTUCB
        LDD     USERLASTERROR
        STD     UCB:LASTERROR,X
        RTS
        PAGE    User context management primitives
NEWSTACK ; virgin stack frame for user's stack (his space)
        IF      M6800!M6801
        FCB     0                      CC with interrupts enabled
        FCB     0                      B
        FCB     0                      A
        FDB     0                      X
        FDB     $100                   PC
        ELSEIF  M6811
        FCB     0                      CC with interrupts enabled
        FCB     0                      B
        FCB     0                      A
        FDB     0                      X
        FDB     0                      Y
        FDB     $100                   PC
        ELSE    (M6809)
        FCB     $80                    CC with 'Entire' bit set
        FCB     0                      A
        FCB     0                      B
        FCB     0                      DP set to page zero
        FDB     0                      X
        FDB     0                      Y
        FDB     0                      U
        FDB     $100                   PC
        FIN
NEWSTACKLEN     EQU     *-NEWSTACK
        PAGE
GETDXFROMUSERSTACK
        LDX     #USERSPSAVE
        JSR     COPYUSERTODX
        STX     TSTEMP  save for possible use by popdxfromuserstack
        IF      M6800!M6801
        INX
        FIN
        JMP     COPYUSERTODX

POPDXFROMUSERSTACK
        BSR     GETDXFROMUSERSTACK
        LDX     TSTEMP  top of stack saved by getdxfromuserstack
        STD     TSTEMP
        INX
        INX
        TXD
        LDX     #USERSPSAVE     trim stack by 2 bytes
        JSR     COPYDTOUSER
        LDX     TSTEMP
        LDD     TSTEMP
        RTS

INITUSERSTACK
        LDX     CURRENTUCB
        LDD     UCB:TOPMEM,X    put user's stack starting at top of his memory
        SUBD    #NEWSTACKLEN+(&m6809)
        STD     TSTEMP
        LDX     #USERSPSAVE
        JSR     COPYDTOUSER
        IF      M6809
        LDY     TSTEMP
        ELSE
        LDX     TSTEMP
        INX                     because stack pointer points 1 below 1st byte in stack
        STX     TEMPX
        FIN
        LDX     #NEWSTACK
        LDD     #NEWSTACKLEN
        JMP     COPYTOUSER
        PAGE
GETXFROMUSERCONTEXT     ; user's processor context is on top of his stack
        LDX     #USERSPSAVE
        JSR     COPYUSERTODX
        IF      M6800!M6801!M6811
        LEAX    REG:X,X
        ELSE
        LEAX    REG:X,X
        FIN
        JMP     COPYUSERTODX
        PAGE
SETPCINUSERCONTEXT
        STX     TSTEMP
        LDX     #USERSPSAVE
        JSR     COPYUSERTODX
        LDD     TSTEMP
        IF      M6800!M6801!M6811
        LEAX    REG:PC,X
        ELSE
        LEAX    REG:PC,X
        FIN
;       IF      M6809
; Assert: E flag in CCR is set
;       STX     TSTEMP            ensure E flag set in CCR
;       JSR     COPYDTOUSER
;       LDD     TSTEMP
;       SUBD    #REG:PC
;       STD     TSTEMP
;       TFR     D,X
;       JSR     COPYUSERTODX
;       ORAA    #$80
;       LDX     TSTEMP
;       JMP     COPYATOUSER      I know...this isn't pretty, but it's a solution
;       ELSE
        JMP     COPYDTOUSER
;       FIN     M6809
        PAGE
SAVEUSERCONTEXT ; move all of user context, to safe place
;  We actually don't save the context, because there is nothing worthwile saving!
;  SDOS defines the register contents after a SYSCALL to be garbage,
;  except the Carry bit, and if C=1, then the X register contains useful stuff.
;  This code should eventually be substituted inline in UserErrored
        IF      M6800!M6801!M6811
        LDAA    #$01                    Force interrupt enabled CC with C=1
        ELSE    (M6809)
        clr     contextblock+REG:DP     ensure DPR is zero on exit
        LDA     #$81                    Force interrupt enabled CC with C=1
        FIN
        STA     CONTEXTBLOCK+REG:CC-(&m6809) Build phony context
        LDX     #USERSPSAVE
        JSR     COPYUSERTODX
        ADDD    #REG:PC-(&m6809)        Adjust top of stack
        LDX     #USERSPSAVE
        JMP     COPYDTOUSER

SETXINSAVEDUSERCONTEXT  ; guess what this does!
        STX     CONTEXTBLOCK+REG:X-(&m6809)
        RTS
        PAGE
RESTOREUSERCONTEXT      ; move user context back to user space
        LDX     #USERSPSAVE
        JSR     COPYUSERTODX
        SUBD    #REG:PC-(&m6809)
        STD     TSTEMP
        LDX     #USERSPSAVE
        JSR     COPYDTOUSER
        LDX     TSTEMP
        IF      M6800!M6801!M6811
        INX
        STX     TEMPX
        ELSE
        TFR     X,Y
        FIN
        LDX     #CONTEXTBLOCK   safe place
        LDD     #REG:PC-(&m6809)
        JMP     COPYTOUSER
        PAGE    Queue Management: Run Queue
*       All of the subsequent queue management routines (ADDxxxQ, REMxxxQ)
*       operate on the named queue by adding the UCB named in the D register
*       to the head of that queue or removing the UCB from the named queue,
*       leaving the name of that UCB in the D register.  There
*       are separate routines to avoid the overhead of one generalized
*       routine.

ADDRUNQ ; add UCB to end of RUN Queue
        LDX     #RUNQ
        JMP     ADDQUEUE

ADDRUNQFRONT ; add UCB to FRONT of RUN Queue
        LDX     #RUNQ
        JMP     ADDQUEUEFRONT

REMRUNQ ; remove 1st UCB from RUN Queue
        LDX     #RUNQ
        JMP     REMQUEUE

ADDLOADQ ; add UCB to end of LOAD Queue
        LDX     #LOADQ
        JMP     ADDQUEUE

ADDLOADQFRONT ; add UCB to FRONT of LOAD Queue
        LDX     #LOADQ
        JMP     ADDQUEUEFRONT

REMLOADQ ; remove 1st UCB from LOADQ
        LDX     #LOADQ
        JMP     REMQUEUE
        page
ADDIOQ ; add UCB to end of I/O Queue
        LDX     #IOQ
        JMP     ADDQUEUE

ADDIOQFRONT ; add UCB to FRONT of I/O Queue
        LDX     #IOQ
        JMP     ADDQUEUEFRONT

REMIOQ ; remove 1st UCB from I/O Queue
        LDX     #IOQ
        JMP     REMQUEUE

ADDINPUTQ ; add UCB to Input Wait Queue
        LDX     #INPUTQ
        JMP     ADDQUEUE

REMINPUTQ ; remove 1st UCB from Input Wait Queue
        LDX     #INPUTQ
        JMP     REMQUEUE

ADDOUTPUTQ ; add UCB to Output Wait Queue
        LDX     #OUTPUTQ
        JMP     ADDQUEUE

REMOUTPUTQ ; remove 1st UCB from Output Wait Queue
        LDX     #OUTPUTQ
        JMP     REMQUEUE

ADDSPACEQ ; add UCB to Space Wait Queue
        LDX     #SPACEQ
        JMP     ADDQUEUE

REMSPACEQ ; remove 1st UCB from Space Wait Queue
        LDX     #SPACEQ
        JMP     REMQUEUE

REMDELAYQ ; remove 1st UCB from Delay Wait Queue
        LDX     #DELAYQ
        JMP     REMQUEUE
        page
ADDDELAYQ ; entries are in ascending order of length of delay desired.
; the current user is inserted in the delay queue where his wakeup time is
; less than or equal to his successor's wakeup time

        tst     delayq+queue:head
        beq     adddelayq.qempty       b/ the queue is empty
        sta     currentucb
        jsr     testfuse               fetch fuse left before 1st job ready
        stx     tempx
        lda     delayq+queue:head      update ucb:delay for 1st job
        sta     queue:ucb
        ldx     queue:ucb
        ldd     tempx                  = remaining fuse for this job
        std     ucb:delay,x            now all ucb:delay contain proper deltas
        clr     tempx                  prior:=nil
        clr     tempx+1
        lda     delayq+queue:head
adddelayq.loop
        sta     queue:ucb
        ldx     currentucb
        ldd     ucb:delay,x
        ldx     queue:ucb
        subd    ucb:delay,x            = remaining delay when this job is ready
        blo     delaygoeshere          b/ currentucb goes in front of this ucb
        ldx     currentucb             update delay delta required
        std     ucb:delay,x
        ldx     queue:ucb
        stx     tempx                  prior:=current
        lda     ucb:nextonq,x          current:=current^.next
        bne     adddelayq.loop         b/ not end of queue
adddelayq.qempty
        LDX     #DELAYQ
        ldd     currentucb
        JSR     ADDQUEUE
adddelayq.setfuse
        lda     delayq+queue:head      assert: somebody's in the q!
        sta     queue:ucb
        ldx     queue:ucb
        ldx     ucb:delay,x            get delay for 1st job in q
        jmp     setfuse                tell /MT primitives about it
        page
delaygoeshere
        negd                           = new delay delta for next guy on q
        std     ucb:delay,x
        ldb     tempx                  = pointer to previous node
        beq     delaygoesathead        b/ goes at head of queue
        ldx     currentucb
        lda     queue:ucb
        sta     ucb:nextonq,x          target^.next:=current
        ldx     tempx
        lda     currentucb
        sta     ucb:nextonq,x          prior^.next:=target
        bra     adddelayq.setfuse      and set up fuse

delaygoesathead
        ldx     currentucb
        lda     delayq+queue:head
        sta     ucb:nextonq,x          target^.next:=head
        lda     currentucb
        sta     delayq+queue:head      head:=target
        bra     adddelayq.setfuse      and set up fuse
        PAGE
; The queue management routines, below, presume that a UCB is on a page
; boundary, and therefore, the lower 8 bits of each address will always
; be zero: a ucb may be referenced with a byte.

ADDQUEUE ; add to end of queue
; (a) -> ucb, (x) -> queue descriptor

        LDB     QUEUE:TAIL,X            see if anyone 't all's in the queue
        BNE     ADDQUEUE.1              B/ yup
ADDQUEUE.MT ; add to empty queue
        STA     QUEUE:HEAD,X            assert: empty tail -> empty queue
        STA     QUEUE:TAIL,X
        RTS

ADDQUEUE.1
        STA     QUEUE:TAIL,X            this is the new tail (old is in (b))
        STB     QUEUE:UCB               point old tail at new one
        LDX     QUEUE:UCB
        STA     UCB:NEXTONQ,X
        RTS

ADDQUEUEFRONT ; add to front of queue
; (a) -> ucb, (x) -> queue descriptor
        LDB     QUEUE:HEAD,X
        BEQ     ADDQUEUE.MT             b/ trivial case
        STA     QUEUE:HEAD,X
        STA     QUEUE:UCB
        LDX     QUEUE:UCB
        STB     UCB:NEXTONQ,X
        RTS
        page
REMQUEUE

; (x) -> queue descriptor
; returns (a) =  0  => empty queue
;         (a) <> 0  => (a) -> ucb

        LDA     QUEUE:HEAD,X            get the head of the queue
        BEQ     REMQUEUE.1              B/ queue is empty
        CMPA    QUEUE:TAIL,X            see if only entry on queue
        BNE     REMQUEUE.2              B/ more than one entry
        CLR     QUEUE:HEAD,X            clear the queue
        CLR     QUEUE:TAIL,X
REMQUEUE.1
        CLRB                            return this ucb
        RTS

REMQUEUE.2
        STA     QUEUE:UCB               make the successor of this ucb
        STX     TEMPX
        LDX     QUEUE:UCB
        LDB     UCB:NEXTONQ,X           the new head of queue
        CLR     UCB:NEXTONQ,X           subject ucb has no successor
        LDX     TEMPX                   install the new queue head
        STB     QUEUE:HEAD,X
        CLRB
        RTS
        PAGE
*       Examine the input queue, looking for ports which have completed.
*       If a ^C^C has been detected, force the user to do an ERROREXIT
*       syscall.

EXAMINEINPUTQ
        LDA     INPUTQ          see if there's anything interesting going on
        STA     TSTEMP  (used to prevent subsequent tail chasing)
        BNE     EXAMINEINPUTQ.5 B/ I thought so!!
        ERRORRTS        ohhh..  Too bad!

EXAMINEINPUTQ.5
        JSR     REMINPUTQ       pull this one off the queue and work with him
        STD     CURRENTUCB
        LDX     CURRENTUCB
        LDA     UCB:QUEUEERR,X  see if this one died in sleep
        ORAA    UCB:QUEUEERR+1,X (this field set by CKLINEFLAGS)
        BEQ     EXAMINEINPUTQ.5a        B/ still alive
        LDD     CURRENTUCB
        OKRTS                           SURPRISE!!

EXAMINEINPUTQ.5a
        LDAA    SCBLK:PARAMS,X  see if this one has completed
        STAA    READYLINE+SCBLK:PARAMS
        LDX     #READYLINE
        JSR     SYSCALL$
        BCC     EXAMINEINPUTQ.6 B/ not ready yet
        CPX     #ERR:IOINPROGRESS       if busy, try again later
        BEQ     EXAMINEINPUTQ.6 B/ still busy
        CPX     #ERR:ACTIVATIONRECEIVED if done, exit
        BNE     EXAMINEINPUTQ.7 B/ got an error, instead!!
        LDD     CURRENTUCB
        OKRTS                   all done

EXAMINEINPUTQ.6
        LDD     CURRENTUCB      tack this one on the end of the queue
        JSR     ADDINPUTQ
        LDA     INPUTQ          get the head of the queue and do him
        CMPA    TSTEMP          what's this...
        BNE     EXAMINEINPUTQ.5 ...oh...we haven't seen you before...OK
        ERRORRTS                ohhh...we've been here before...too bad!
        PAGE
EXAMINEINPUTQ.7
        TXD
        LDX     CURRENTUCB
        STD     UCB:QUEUEERR,X
        LDD     CURRENTUCB
        OKRTS                   user is ready to run--with BIG surprise!

EXAMINEINPUTQ.ERROR
        JSR     GOCATATONIC     something bad happened while waiting for input to complete
        PAGE    Queue Management: Output Wait Queue
*       Examine the output queue to find user whose output is complete.

EXAMINEOUTPUTQ
        LDA     OUTPUTQ         see if anyone waiting for output
        BEQ     EXAMINEOUTPUTQ.ERRORRTS
        STA     TSTEMP          remember place to avoid tail-chasing
EXAMINEOUTPUTQ.1
        JSR     REMOUTPUTQ      go feed some of this user's buffer to vt driver
        STD     CURRENTUCB
        LDX     CURRENTUCB
        TST     SCBLK:DATA,X    see if request completed
        BEQ     EXAMINEOUTPUTQ.2
        LDD     UCB:QUEUEERR,X  see if he died in sleep
        BNED    EXAMINEOUTPUTQ.1a       B/ he died (probably via ^C^C)
        LDX     SCBLK:DATA+1,X  request completed--see if with error
        BNE     EXAMINEINPUTQ.7 b/ with error... too bad!
EXAMINEOUTPUTQ.1a
        LDD     CURRENTUCB      no error--return with completed request
        OKRTS

EXAMINEOUTPUTQ.2
        LDD     CURRENTUCB      put this user at the end of the line
        JSR     ADDOUTPUTQ
        LDA     OUTPUTQ         check for tail-chasing
        CMPA    TSTEMP
        BNE     EXAMINEOUTPUTQ.1        look at another user
EXAMINEOUTPUTQ.ERRORRTS
        ERRORRTS                found nothing of interest
        PAGE    Queue Management: I/O Queue
*       Choose from I/O Queue in Round-Robin fashion

EXAMINEIOQ
        LDA     IOQ
        BEQ     EXAMINEIOQ.EMPTY
        JSR     REMIOQ
        OKRTS

EXAMINEIOQ.EMPTY
        ERRORRTS
        PAGE    Queue Management: Load Program Wait Queue
*       Determine if any jobs waiting to Load a program.
*       If found, carry clear; if empty then return with carry set.

EXAMINELOADQ
        LDA     LOADQ
        BEQ     EXAMINELOADQEXIT       B/ no one on SPACE Q
        JSR     REMLOADQ               ok, remove him from LOADQ
        STD     CURRENTUCB             and remember this guy as current
        OKRTS

EXAMINELOADQEXIT ; Nobody in LOADQ
        ERRORRTS
        PAGE    Queue Management: Space Wait Queue
*       Allocate space for first user on SPACE Q.  If success, make that
*       user current and return with carry clear;
*       if fail or queue is empty, then return with carry set.

EXAMINESPACEQ
        LDA     SPACEQ
        BEQ     ESQXIT                 B/ no one on SPACE Q
        LDB     NUMPAGES               any pages available yet ?
        BEQ     ESQXIT                 b/ no, nothing we can do here!
        STA     CURRENTUCB             assert: no context is current!!
        LDX     CURRENTUCB
        LDA     UCB:QUEUEERR,X         see if he died in sleep
        ORAA    UCB:QUEUEERR+1,X
        BNE     EXAMINESPACEQ.1        b/ he died...
        LDAA    UCB:USERNUMBER,X       set up for space allocation
        STAA    CURRENTUSER
        LDAA    UCB:PNEEDED,X          get count of pages desired
        JSR     ALLOCATENPAGES
        BCS     ESQXIT                 B/ no pages available, at all (shouldn't happen!)
EXAMINESPACEQ.1
        JSR     REMSPACEQ              remove user from SPACE Q
        OKRTS

ESQXIT
        ERRORRTS
        PAGE    Queue Management: Delay Queue
EXAMINEDELAYQ

; Examine the first user on the delay queue to see if his wakeup time has
; been reached or passed.  If so, remove him from the queue and turn him
; loose.

; assert: queue is in ascending order of time

        ldx     delayq
        beq     delayqisempty
        jsr     testfuse               is fuse for 1st job on queue burned up ?
        bne     delaynotdone           b/ yes
        jsr     remdelayq              pull off head of queue
        ldb     queue:head,x           anybody else on the delay queue ?
        beq     examinedelayq.okrts    b/ no, leave fuse burned out.
        stb     queue:ucb              yes, get new fuse
        ldx     queue:ucb
        ldx     ucb:delay,x
        psha
        jsr     setfuse
        pula
examinedelayq.okrts
        clrb
        okrts

delayqisempty
delaynotdone
        errorrts                       no one ready to go
        page
delay.ctlc.unblock

; come here when the current user is to be removed from the delay queue;
; if the user is not on the delay queue, just return; otherwise, remove him
; from the delay queue and add him to the run queue

        lda     delayq+queue:head
        beq     delay.ctlc.notinq
        sta     queue:ucb
        jsr     testfuse               get remaining fuse
        txd                            and save as 1st job's remaining delay
        ldx     queue:ucb
        std     ucb:delay,x
        lda     queue:ucb              get pointer to 1st user in queue
        clrb                           prior:=nil
delay.ctlc.loop
        ldx     queue:ucb
        cmpa    currentucb
        beq     delay.ctlc.foundit     b/ found currentucb in queue
        tfr     a,b                    prior:=current
        lda     ucb:nextonq,x          current:=current^.next
        sta     queue:ucb
        bne     delay.ctlc.loop
delay.ctlc.notinq
        rts

delay.ctlc.foundit
        pshb
        ldx     currentucb             now remove current user from q
        lda     ucb:nextonq,x
        beq     delay.ctlc.lastonq     b/ current is on queue tail
        sta     queue:ucb              remember next guy on q
        ldd     ucb:delay,x            get delay remaining for current user
        ldx     queue:ucb              add to delay for next user in q
        addd    ucb:delay,x
        std     ucb:delay,x
        lda     queue:ucb              points to next user in q
        pulb
        stb     queue:ucb
        beq     delay.ctlc.firstonq    b/ current is on queue head
        ldx     queue:ucb
        sta     ucb:nextonq,x          prior^.next:=current^.next
        bra     delay.ctlc.setfuse     b/ somebody is still in delay q
        page
delay.ctlc.firstonq ; and somebody else follows current user in q
        sta     delayq+queue:head      head:=current^.next
        bra     delay.ctlc.setfuse     b/ somebody is still in delay q

delay.ctlc.lastonq
        pulb
        stb     queue:ucb
        beq     delay.ctlc.onlyonq     b/ current is only one on queue
        stb     delayq+queue:tail      tail:=prior
        ldx     queue:ucb
        clr     ucb:nextonq,x          prior^.next:=nil
delay.ctlc.setfuse
        lda     delayq+queue:head      assert: queue is not empty
        sta     queue:ucb              set fuse to delay for 1st job in q
        ldx     queue:ucb
        ldx     ucb:delay,x
        jsr     setfuse
        bra     delay.ctlc.addtorunq

delay.ctlc.onlyonq
        ldx     #0                     head:=nil
        stx     delayq                 tail:=nil
delay.ctlc.addtorunq
        ldx     currentucb             clear ucb^.next since we removed him
        clr     ucb:nextonq,x
        ldd     currentucb
        jsr     addrunq
        rts
        PAGE    Buffer Management
* Support routines for ALLOCATE1PAGE and ALLOCATENPAGES

* FINDFREEPAGE (and FFP1) find the beginning of a "hole" in the page map
* COUNTPAGES determines the size of the "hole"

* All registers (including TEMPX) are volatile

FINDFREEPAGE
        TST     NUMPAGES see if any free pages exist
        BEQ     FFP3     B/ none.
        LDAB    MAPSIZE
        LDX     PAGEMAPBASE  points to 1st dynamically allocatable page
FFP1
        IF      M6800!m6801
        LDAA    0,X     look for a zero slot in the map
        BEQ     FFP2    B/ found one!
        INX             next!!   pleez
        ELSE    (M6809)
        LDA     ,x+
        BEQ     FFP2    B/ found one!
        FIN
        DECB
        BNE     FFP1
FFP3    ERRORRTS

FFP2
        IF      M6809
        DEX
        FIN
        STX     TEMPX   assert: map on page boundary
        LDAA    TEMPB   presto!  get the page number
        OKRTS
        PAGE
COUNTPAGES
        LDAA    NPAGES  I'm satisfied if I get this much
        STAA    THISCOUNT
        CLRA            count how many I got
COUNTPAGES.LOOP
        IF      M6800!M6801
        TST     0,X     is this available?
        BNE     COUNTPAGES.EXIT B/ nope
        INX             next page, pleez
        ELSE    (M6809)
        TST     ,X+     is this available ?
        BNE     COUNTPAGES.EXIT B/ nope
        FIN
        INCA            count it
        DEC     THISCOUNT
        BEQ     COUNTPAGES.GOTENUFF     B/ got what I asked for
        DECB            don't overrun map
        BNE     COUNTPAGES.LOOP
COUNTPAGES.EXIT
        ERRORRTS

COUNTPAGES.GOTENUFF
        OKRTS
        PAGE
* Allocate one page and mark it as being used
*
*  returns carry clear: (A), NPAGES contains 1; (B), PAGEBASE contains page number
*                       (X) contains CurrentUCB
*  If no page is available and a BCC/BCS follows the JSR/BSR,
*  then return is made with carry set.
*  Otherwise, the user is blocked until the request can be satisfied.
*
ALLOCATE1PAGE
        LDAA    #1              = number of pages to allocate
ALLOCATENPAGES.1 ; enter here with (A)=1
        STA     NPAGES          assert: (A)=1
        LDB     UCB:PERMANENTPAGEBUSY,X is permanently allocated page busy ?
        BNE     ALLOCATE1PAGE.HUNT b/ yes, allocate the hard way...
        STA     UCB:PERMANENTPAGEBUSY,x mark permanent page as allocated
        LDB     UCB:PERMANENTPAGE,x     get page address
        STB     PAGEBASE        fulfill contract
        OKRTS

ALLOCATE1PAGE.HUNT ; go hunt for a page
        LDB     UCB:ALLOCATEDPAGECNT,X
        BNE     ALLOCATENPAGES.TOOMANYSEGMENTS
        BSR     FINDFREEPAGE
        LBCS    ANP.1   B/ didn't get page
        LDAB    CURRENTUSER     mark it as owned
        ORAB    #$40            don't want to confuse with available page
        STAB    0,X
        STAA    PAGEBASE
        LDX     CURRENTUCB
        STAA    UCB:ALLOCATEDPAGESBASE,X
        INC     UCB:ALLOCATEDPAGECNT,X
        TFR     A,B             meet contract
        LDAA    #1              = number of pages allocated
        DEC     NUMPAGES
        OKRTS

ALLOCATENPAGES.TOOMANYSEGMENTS ; USER WANTS MORE THAN 2 ALLOCATED SEGMENTS
        LDX     #ERR:MEMORYMGMTFAIL
        JSR     GOCATATONIC
        PAGE
* Allocate (A) pages and mark them as being used.
* Note: Nothing prevents a request from chewing up ALL of the available pages,
* leaving none for other users which need 2 chunks. That's OK; the SPACEQ
* handles the problem of delaying the other users until space is available.
*
* returns carry clear: (B), PAGEBASE contains page number,
*                      (A), NPAGES contains from 1 to original contents of (A)
*                      (X) contains CurrentUCB
*
* returns carry set: If no page is available and a BCC/BCS follows the JSR/BSR
*                    If no page is available, and there IS no BCC/BCS,
*                    then user is blocked until the request can be satisfied.
*
* Optimized to handle requests for 1 page very quickly,
* as this is by far the most common request /MT makes.
* Note that /MT can never issue more than 2 requests
* for pages to handle a system call, and it is
* guaranteed that one of those request is for 1 page.
*
ALLOCATENPAGES
        LDX     CURRENTUCB      ensure pre-conditions met
        CMPA    #1              check for most frequent request
        BEQ     ALLOCATENPAGES.1 b/ go handle most common request
        CMPA    NUMPAGES        truncate request to "pages available"
        BLS     ANP.0           b/ request is smaller than pages available
        LDAA    NUMPAGES        truncate request to smaller value
        BEQ     ALLOCATE1PAGE   b/ no pool pages available, try allocating permanent page
ANP.0 ; (A) has number of max number of pages possible to allocate
        STAA    NPAGES          remember request size
        BEQ     ANP.8           0 pages is an easy request to satisfy
        LDB     UCB:ALLOCATEDPAGECNT,X
        BNE     ALLOCATENPAGES.TOOMANYSEGMENTS b/ 2 segments of length > 1 !!?
        CLR     LASTCOUNT       prepare (sigh!) for search
        JSR     FINDFREEPAGE    find a hole
        BCS     ANP.1           B/ none to be found
ANP.5   BSR     COUNTPAGES      size the hole
        BCC     ANP.2           B/ the hole is big enough--split with the goods!!
        CMPA    LASTCOUNT       is this one bigger than the last one?
        BLS     ANP.3           B/ no--look for another hole
        STAA    LASTCOUNT       remember this hole
        LDAA    TEMPB
        STAA    LASTBASE
ANP.3   TSTB                    see if the map has been completely examined
        BEQ     ANP.4           B/ it has--take our best match and scoot!
        JSR     FFP1            (B) and (X) are still set up--look for another hole
        BCC     ANP.5           B/ got a hole--go size it

ANP.4   LDX     CURRENTUCB      take best match; mark it as owned
        LDAA    LASTBASE
        STAA    UCB:ALLOCATEDPAGESBASE,X
        STAA    PAGEBASE
        STAA    TEMPB
        LDAA    LASTCOUNT
        STAA    UCB:ALLOCATEDPAGECNT,X
        STAA    NPAGES
        LDX     TEMPX
        LDAB    CURRENTUSER
        ORAB    #$40
ANP.6   STB     ,X+
        DECA
        BNE     ANP.6
        LDB     NUMPAGES        keep track of number of pages available
        SUBB    NPAGES
        BCC     ANP.A
        LDX     #ERR:MEMORYMGMTFAIL
        JSR     GOCATATONIC

ANP.A   STB     NUMPAGES
        LDX     CURRENTUCB      meet exit contract
        LDAA    UCB:ALLOCATEDPAGECNT,X
        LDAB    UCB:ALLOCATEDPAGESBASE,X
ANP.8   OKRTS

ANP.2   LDAA    NPAGES  an exact match is our best match
        STAA    LASTCOUNT
        LDAA    TEMPB
        STAA    LASTBASE
        BRA     ANP.4

ANP.1   TSX             if he checks with BCC/BCS, don't block him
        LDX     0,X
        LDAA    0,X
        IF      M6809
        CMPA    #$10    check for lbcc/lbcs
        BNE     *+4
        LDA     1,X
        FIN     M6809
        ANDA    #$FE
        CMPA    #$24
        BNE     ANP.7   B/ he doesn't check
        LDX     CURRENTUCB      make life convenient for caller
        ERRORRTS

ANP.7   LDAA    NPAGES
        LDX     CURRENTUCB      block him until he can get the pages
        STAA    UCB:PNEEDED,X
        LDD     CURRENTUCB
        JSR     ADDSPACEQ
        JSR     SAVEPLACE       EXAMINESPACEQ calls ALLOCATENPAGES until success!
        LDX     CURRENTUCB      meet exit contract
        LDAA    UCB:ALLOCATEDPAGECNT,X
        LDAB    UCB:ALLOCATEDPAGESBASE,X
        OKRTS
        PAGE
RELEASEALLPAGES

*  Release all pages checked out to current user
*  Returns (X) pointing to CurrentUCB

        LDX     CURRENTUCB      this is convenient for SYSCALLEXIT
        CLR     UCB:PERMANENTPAGEBUSY,X "deallocate" permanent page
        LDB     UCB:ALLOCATEDPAGECNT,X a variable size segment allocated ?
        BEQ     RELEASEALLPAGES.RTS  b/ no, take fast exit!
        CLR     UCB:ALLOCATEDPAGECNT,X yes, make it disappear from UCB
        TFR     B,A             update free page count
        ADDA    NUMPAGES
        STA     NUMPAGES
        LDA     UCB:ALLOCATEDPAGESBASE,X mark pages in map as free
        STA     TEMPX+1
        LDA     PAGEMAPBASE
        STA     TEMPX
        LDX     TEMPX           get pointer to 1st page to free
RELEASEALLPAGES.LOOP
        CLR     ,X+
        DECB
        BNE     RELEASEALLPAGES.LOOP
*** Could check SPACEQ here, and move users on it to RUNQ
*** This is prevent having to inspect SPACEQ in POLL routine, enhancing response
*** This would require a change of viewpoint here, from
*** "this user releasing his pages" to "the system waking up others"
*** That is inconsistent with this implementation, and so we don't do it here
        LDX     CURRENTUCB
RELEASEALLPAGES.RTS
        RTS
        PAGE    OPEN, CREATE, and RENAME
OPEN
CREATE  BSR     DOOPEN  call open subroutine (localizes errors)
        BCS     OPEN.ERR1
        JMP     RETURNSCANNED

OPEN.ERR1
        STX     LASTERROR
        CPX     #ERR:RDBUFTOOSMALL      in this case, we return NOTHING!!
        BEQ     OPEN.ERR2
        JSR     RETURNSCANNED
        JMP     ERRORED

OPEN.ERR2
        LDX     CURRENTUCB
        CLR     UCB:GIVERPLEN,X        return nothing, pleez!
        JMP     ERRORED
        PAGE
DOOPEN
        JSR     FNAMESETUP              (checks for RDLEN >= 2)
        JSR     WASCONSOLEREQUESTED
        BCC     DOOPEN.2                b/ console was requested
DOOPEN.JC ; entry point for JC:CREATE
        JSR     SETCHANNEL
        JSR     SYSCALL$
        BCC     CHECKDEVTYP             get device class (i.e., vt or non-vt)
        CPX     #ERR:CHBUSY
        BNE     DOOPEN.1
        JSR     GOCATATONIC             MT out of sync with SDOS
DOOPEN.1
        STX     TSTEMP
        JSR     RELEASECHANNEL          close out virtual channel--don't care
        BCS     DOOPEN.DONTCARE         about errors
DOOPEN.DONTCARE
        LDX     TSTEMP
        JMP     ERRORINX
        PAGE
DOOPEN.2                                ; open/create to console:
        lda     scblk:params,x
        JSR     TRANSLATECHANNEL
        jsr     ischannelclosed         bomb out if channel is open
        jsr     getuserLFchannel        fetch LineFlags channel (user console:)
        bne     DOOPEN.3                b/ really is a LineFlags channel
        ldaa    ucb:chan0,x             use channel 0 content as poor substitute
DOOPEN.3 ; (A) has real channel number opened
        LDX     UCB:CHANNELMAP,X
        JSR     STAINDEX                note that channel is open to console
        LDX     CURRENTUCB
        okrts

ischannelopen                           ; c/r -> yes; c/s, err:closed -> no
        cmpa    #$ff
        beq     ischannelopen.no        b/ closed
        okrts

ischannelopen.no
        jsr     erret
        #err:closed

ischannelclosed                         ; c/r -> yes; c/s, err:chbusy -> no
        cmpa    #$ff
        bne     ischannelclosed.no      b/ open
        okrts

ischannelclosed.no
errchanisopen
        jsr     erret
        #err:chbusy
        page
RENAME
        BSR     DORENAME
        BCS     OPEN.ERR1
        JMP     RETURNSCANNED

DORENAME
        JSR     FNAMESETUP      validate and fetch file name
        JSR     GETCHANNEL      translate virtual to real channel
        JMP     SYSCALL$
        PAGE
*       ASSERT: Timeshare will be running only with virtual terminal driver;
*       therefore, DEVTYP=CONSOLE or DEVTYP=LPT will mean virtual terminal
*       device

CHECKDEVTYP
        LDX     CURRENTUCB
        LDAA    SCBLK:PARAMS,X  do a devtyp status syscall on this channel
        STA     INDEXFORSTA
        LDX     #GETDEVTYP
        STAA    SCBLK:PARAMS,X
        JSR     SYSCALL$
        LDX     #DEVICEMAP
        LDA     #VT:CONSOLE
        LDB     BUFFER          pick up the type
        CMPB    #DVTYP.CONSOLE
        BEQ     CHECKDEVTYP.1
        LDA     #VT:PRINTER
        CMPB    #DVTYP.PRINTER
        BEQ     CHECKDEVTYP.1
        CLRA                    not a virtual device
        JMP     STAINDEX

CHECKDEVTYP.1
        JSR     STAINDEX        plunk in the device type

*       make all VT devices which are not open to the console, killproof

        LDX     CURRENTUCB
        LDA     SCBLK:PARAMS,X
        CMPA    UCB:LFCHAN,X    is this the real console?
        BEQ     CHECKDEVTYP.2   b/ real console
        LDX     #SETKILLPROOF
        STAA    SCBLK:PARAMS,X
        JSR     SYSCALL$
CHECKDEVTYP.2
        OKRTS
        page
isitvirtual ; return Z reset (non-zero) if VT device selected
; return device type flags in ucb:vtflag

        ldx     currentucb
        lda     scblk:params,x
        sta     indexforlda
        ldx     #devicemap
        jsr     ldaindex
        ldx     currentucb
        sta     ucb:vtflag,x
        rts
        PAGE    CLOSE & DELETE
CLOSE
        JSR     GETCHANNEL      translate virtual to real channel
        JMP     RELEASECHANNEL

CLOSE.DUMP

*       do a DUMPBUFFERS before doing a CLOSE (called by EXITS)

        JSR     GETCHANNEL
        LDAA    SCBLK:PARAMS,X
        LDX     #DUMPBUFFERS
        STAA    SCBLK:PARAMS,X
        JSR     SYSCALL$
        bcs     close.dump.dontcare
close.dump.dontcare
        JMP     RELEASECHANNEL

DELETE
        BSR     DODELETE
        LBCS    OPEN.ERR1
        BRA     RETURNSCANNED

DODELETE
        JSR     FNAMESETUP      validate and copy over the file name
        LDX     CURRENTUCB      perform the syscall
        JMP     SYSCALL$
        PAGE    Support routines for OPEN, CLOSE, and friends
RETURNSCANNED

*       return the file name scanned length to the user space

        LDX     CURRENTUCB
        LDX     UCB:USERRDBUF,X
        LDD     NAMESCANNEDCNT
        JSR     COPYDTOUSER
        OKRTS
        PAGE
*       Perform common file name processing for OPEN, CREATE, RENAME,
*       and DELETE.  Error exits are taken for
*
*               write buffer too small
*               read buffer too small
*               bad file name

FNAMESETUP
        JSR     CHECKRDLEN      need at least 2 bytes for returning scanned count
        #2
        BSR     FNAMESETUP.1    (this is a firebreak)
        RTS

*       Perform common file name processing for LOAD and CHAIN.  Error
*       exits are taken for
*
*               write buffer too small
*               read buffer too small
*               bad file name

PNAMESETUP
        JSR     CHECKRDLEN
        #4
        BSR     FNAMESETUP.1    (this is a firebreak)
        RTS
        PAGE
FNP.ERR1
        JSR     ERRET
        #ERR:BADFILENAME

FNAMESETUP.1
        CLR     NAMESCANNEDCNT
        CLR     NAMESCANNEDCNT+1
        JSR     CHECKWRLEN
        #0                      this allows SDOS to complain about the name
        TST     SCBLK:WRLEN,X   look for an overly long file name (> 255 bytes)
        LBNE    FNP.ERR1
        JSR     ALLOCATE1PAGE   get buffer, copy over filename, update scb
        LDX     CURRENTUCB
        LDAA    PAGEBASE
        CLRB
        STD     SCBLK:WRBUF,X
        IF      M6809
        TFR     D,Y
        ELSE
        STD     TEMPX
        FIN
        LDD     SCBLK:WRLEN,X
        LDX     UCB:USERWRBUF,X
        JSR     COPYTOSYSTEM
        LDX     CURRENTUCB
        LDD     #NAMESCANNEDCNT
        STD     SCBLK:RDBUF,X
        LDD     #2
        STD     SCBLK:RDLEN,X
        LDX     CURRENTUCB
        OKRTS
        PAGE
WASCONSOLEREQUESTED             ; c/r -> yes; c/s -> no
        LDX     CURRENTUCB
        LDB     SCBLK:WRLEN+1,X for the device name CONSOLE:
        SUBB    #LCONSOLE
        BLO     FNP.1
        LDAB    #LCONSOLE       the length looks about right
        LDX     #CONSOLE        compare for an exact match
        STX     TEMPX
        LDX     CURRENTUCB
        LDX     SCBLK:WRBUF,X
FNP.2   LDAA    0,X
        cmpa    #'@
        bcs     fnp.3
        ANDA    #(\ASCII:SPACE)&$FF
fnp.3   INX
        STX     TEMPX+2
        LDX     TEMPX
        CMPA    0,X
        BNE     FNP.1           B/ match stops here--exit
        INX
        STX     TEMPX
        LDX     TEMPX+2
        DECB
        BNE     FNP.2
        LDX     CURRENTUCB
        OKRTS                   console requested

FNP.1   LDX     CURRENTUCB
        ERRORRTS                console not requested
        page    Channel Resource Management
; There are three segments to the channel mapping data base: the first
; segment is channelstack, which is a stacked list of all available
; real channels; the second is a channelmap for each user (referenced
; by ucb:channelmap), which maps the user's virtual channels to real
; channels-- a real channel of $ff indicates the virtual channel is closed
; (real channel $ff is not on the stack); the third is a devicemap,
; which flags a channel as a virtual printer (1), a virtual console (2),
; or neither (0)

allocaterealchannel
        tst     channelstackc   see if any available (most likely)
        bne     allocaterealchannel.1   b/ channels available
        jmp     erret
        #err:notenoughchannels

allocaterealchannel.1
        dec     channelstackc
        ldx     channelstackp
        lda     ,x+
        stx     channelstackp
        ldx     currentucb             for convenience of caller
        okrts

freerealchannel ; (A) holds channel number to free
        ldab    channelstackc           see if there's room on the stack
        beq     freerealchannel.badshow (need I say more?)
        inc     channelstackc
        ldx     channelstackp
        sta     ,-x                     release the channel
        stx     channelstackp
        ldx     currentucb             for convenience of caller
        okrts

freerealchannel.badshow ; no room in channel stack????
        jsr     gocatatonic
        page
releaserealchannel ; CLOSE and release real channel specified by (A); (x) -> ucb
; Note: if LF channel, does not release or close!
        cmpa    ucb:lfchan,x            see if real console
        beq     releaserealchannel.1    b/ it is--don't close or release it
        sta     closelogchan+scblk:params
        bsr     freerealchannel         return channel to available stack
        ldx     #closelogchan
        jsr     syscall$                now, close it
        ldx     currentucb
releaserealchannel.1
        okrts
        page
translatechannel                        ; (a) = userchannel; (x) -> UCB
        sta     ucb:userchan,x          save user's channel
        sta     indexforlda
        sta     indexforsta
        cmpa    #UCBchannels            check for valid channel number
        blo     translatechannel.1      b/ channel is valid
        jsr     erret
        #err:chtoobig

translatechannel.1
        ldx     ucb:channelmap,x        index into channel map
        clc                             signal "success"
        jmp     ldaindex                and fetch physical channel number

getchannel
        ldx     currentucb
        lda     scblk:params,x
        bsr     translatechannel
        jsr     ischannelopen
        ldx     currentucb
        sta     scblk:params,x          update the syscall block
        okrts
        page
setchannel ; allocate a real channel to use and record in CHANNELMAP.
        ldx     currentucb
        lda     scblk:params,x
        bsr     translatechannel
        jsr     ischannelclosed
        bsr     allocaterealchannel     go get the real thing
        sta     scblk:params,x          and put it in the user's channel map
        ldx     ucb:channelmap,x
        jsr     staindex
        ldx     currentucb
        okrts

releasechannel ; release user's logical channel specified by UCB:USERCHAN
        ldx     currentucb
        ldaa    ucb:userchan,x          which channel ?
        bne     releasechannel.1        b/ not channel 0, do nothing special
        ldaa    ucb:chan0,x             is user's channel 0 open to his console ?
        cmpa    ucb:lfchan,x            ...?
        bne     releasechannel.1        b/ no, just close it!
        jsr     resetLFchannel          yes, get rid of ^Z (EOF) status
        ; Note: this isn't a perfect simulation of single-user SDOS, which
        ; would clear the EOF status IFF this were the only channel open
        ; to the user's console.  But its close enough for government work.
releasechannel.1
        lda     #$ff                    mark channel as 'closed'
        ldx     ucb:channelmap,x
        jsr     staindex
        ldx     currentucb
        lda     scblk:params,x          get associated physical channel
        jmp     releaserealchannel      give the channel back
        PAGE    CHAIN/LOAD SYSCALLS
*       CHAIN -- PERFORM "SYSCALL:CHAIN"
*       ALWAYS RETURNS CONTROL TO CALLER AFTER ERROR UNTIL TYPE 1 RECORD VALIDATED
*       ONCE TYPE 1 RECORD SEEN, ERROREXIT IS FORCED ON AN ERROR.
*       CHAIN SWITCHES STACK TO TOP OF USER SPACE ONCE TYPE 1 RECORD SEEN.
*
*       CHAIN Transition/action table:
*       Unencrypted --> Unencrypted:    Do nothing
*       Unencrypted --> Encrypted:      Zero User Space, Save decryption key, mark 'running encrypted'
*       Encrypted --> Encrypted:        Do nothing
*       Encrypted --> Encrypted':       Zero the user space, save decryption key
*       Encrypted --> Unencrypted:      Zero the user space, save key, mark 'runencrypted'

*       LOAD Transition/action table:
*       Unencrypted --> Unencrypted:    Do nothing
*       Unencrypted --> Encrypted:      Signal error
*       Encrypted --> Encrypted:        Do nothing
*       Encrypted --> Encrypted':       Signal error
*       Encrypted --> Unencrypted:      Signal error
*
*       These routines use OldKeyEncrypted and NewKeyEncrypted to decide transitions
*       Definition: If OldKeyEncrypted=0, then we were running Unencrypted
*               If NewKeyEncrypted=0, then we are transiting to Unencrypted
        PAGE
CHAIN   JSR     EXITS                  GO CLOSE ALL THE CHANNELS
        JSR     LOADINIT               OPEN THE FILE AND VERIFY IT IS AN OBJECT FILE
        LDX     CURRENTUCB
        LDX     UCB:LOADSTARTADDRESS,X CHECK THE START ADDRESS FOR ILLEGAL VALUE
        BEQ     ERRZEROSTARTADDRESS    B/ NO START ADDRESS!
        BSR     COMPAREDECRYPTIONKEYS  ARE OLD AND NEW ENCRYPTION KEYS IDENTICAL ?
        BCC     CHAINOK                B/ DECRYPTION KEYS MATCH, DO NOTHING
        JSR     ZAPUSERSPACE           MAKE TRASH OUT OF INFORMATION IN USER SPACE
        if      m6800!m6801!m6811
        ldd     currentucb             save this "key" as last "key" used
        addd    #ucb:oldKeyEncrypted
        std     topointer
        else    (m6809)
        ldy     currentucb
        leay    ucb:OldKeyEncrypted,y
        fin
        LDX     #NEWKEYENCRYPTED       = FROM ADDRESS
        ldd     #8                     = # bytes to save
        jsr     blockmove              Note: it is NOT secure to call code+sdos:blockmove here!
CHAINOK ; ITS OK TO DO THE CHAIN, HOP TO IT!
        JSR     LOADREST               GO LOAD THE REST OF THE FILE
        BCC     CHAIN1                 B/ NO LOADER ERROR
        JMP     EXIT1                  I GIVE UP

CHAIN1  ;LDAA   KILLEDF                SEE IF USER GOT KILLED WHILE LOADING!
        ;JSR    KILLEDTEST             ...?
        JSR     INITUSERSTACK          GIVE USER A GOOD STACK POINTER
        LDX     CURRENTUCB             SET USER'S PC TO START ADDRESS
        LDX     UCB:LOADSTARTADDRESS,X
        JSR     SETPCINUSERCONTEXT
        JSR     RETURNLINEFLAGS        so loaded program sees new line flags
        OKRTS

ERRZEROSTARTADDRESS ; START ADDRESS IS ZERO ON A CHAIN
        LDX     #ERR:ZEROSTARTADDRESS  GET ERROR CODE
        JMP     LOADER2                GO CLOSE THE FILE, TRASH THE KEY, AND EXIT!
        PAGE
*       LOAD -- PERFORM "SYSCALL:LOAD"
*
LOAD    BSR     LOADINIT               LOAD THE FILE INTO MEMORY
        BSR     COMPAREDECRYPTIONKEYS  ARE OLD AND NEW DECRYPTION KEYS IDENTICAL ?
        LBCS    LOADER2                B/ KEYS DON'T MATCH, CLOSE FILES AND SIGNAL ERROR!
        JSR     LOADREST               LOAD OBJECT RECORDS FROM FILE
        LDX     CURRENTUCB
        LDD     UCB:LOADSTARTADDRESS,X COPY STARTADDRESS TO SYSCALL RESULT
        LDX     SCBLK:RDBUF,X
        LEAX    2,X                    WHERE TO PUT START ADDRESS
        JSR     COPYDTOUSER            PUT INTO USER SPACE
        OKRTS
        PAGE
*
*       COMPAREDECRYPTIONKEYS -- COMPARE OLD AND NEW DECRYPTION KEYS
*       SIGNAL ERROR IF NO MATCH
*       (DO SO IN A SUBTLE WAY, SO IT IS NOT EASY TO FIND WHO GENERATES THE ERROR CODE)
*
COMPAREDECRYPTIONKEYS
        IF      M6800!M6801!M6811
        LDD     CURRENTUCB             = COMPARE "TO" ADDRESS
        ADDD    #UCB:OLDKEYENCRYPTED
        STD     TOPOINTER
        ELSE    (M6809)
        LDY     CURRENTUCB
        LEAY    UCB:OLDKEYENCRYPTED,Y
        FIN
        LDX     #NEWKEYENCRYPTED       = COMPARE "FROM" ADDRESS
        LDB     #8      = # BYTES TO COMPARE (KEY SIZE)
        JSR     BLOCKCOMPARE
        BEQ     COMPAREDECRYPTIONMATCH B/ ALL IS OK
        LDD     #ERR:DECRYPTIONKEYSDONTMATCH-1234 GENERATE ERROR CODE...
        ADDD    #1234                  IN SUBTLE WAY
        TDX
        ERRORRTS                       AND TAKE ERROR EXIT

COMPAREDECRYPTIONMATCH ; OLD AND NEW KEYS MATCH!
        OKRTS
        PAGE
*        LOADINIT -- OPEN LOAD FILE, COMPUTE DECRYPTION KEY,
*        AND VERIFY OBJECT FORMAT CONTENT
*        IF SUCCESSFUL, LOAD CHANNEL IS LEFT OPEN.
*        IF FAILURE, LOAD CHANNEL HAS BEEN CLOSED AND RELEASED.

LOADINIT
        LDAA    LOADQ                  is somebody already loading a program ?
        BEQ     LOADINITNOW            b/ no, we'll take our turn now!
        JSR     GETREMAININGQUANTUM    get time left before slice expired
        ldx     currentucb
        staa    UCB:REMAININGQUANTUM,X store time left as our next slice
        LDD     CURRENTUCB             which UCB to add to LOADQ
        JSR     ADDLOADQ               add ourself to end of LOADQ
        JSR     SAVEPLACE              and return when other guy is done loading
        LDAA    #1                     mark us as going compute-bound
        staa    UCB:USERCPUBOUND,x
LOADINITNOW ; take our turn now!
        LDA     #255                   get as big a load record buffer as possible
        JSR     ALLOCATENPAGES         note: no competition from other LOAD/CHAIN attempts!
        ; if there is no room, we'll go to sleep waiting for space.
        ; if we are ^C^C'd while waiting, no harm done; we haven't done anything yet.
        STAA    UCB:BUFFERSIZE,X       save number of pages in load buffer
        STAB    UCB:BUFFER,X           remember location of buffer
        ; assert: UCB:PERMANENTPAGE is not allocated here
        JSR     PNAMESETUP             validate and copy file name
        LDX     CURRENTUCB
        LDD     SCBLK:WRBUF,X
        STD     LOADOPEN+SCBLK:WRBUF
        LDD     SCBLK:WRLEN,X
        STD     LOADOPEN+SCBLK:WRLEN
        jsr     allocaterealchannel    grab an available channel
        staa    ucb:loadchannel,x      and save it away for future reference
        staa    LOADOPEN+OPEN:CHANNEL  set channel into Open Syscall block
        staa    FILLDECRYPTBUFFER+READB:CHANNEL set channel into ReadB syscall
        staa    DUMPBUFFERS+CONTROL:CHANNEL set channel into DumpBuffers call
        ; Now we own a channel. If we are ^C^C'd here, we must give it up.
        ; We solve this problem by letting USERERRORED close and release
        ; the UCB:LOADCHANNEL if it is open.
        LDX     #LOADOPEN
        JSR     SYSCALL$
        BCS     LOADINITCANTOPEN       B/ HAD A PROBLEM!
        BSR     LOADINITCOPYSCANNED
        JSR     SETUPFRANKBAKER        set up syscall linkage within userspace
        BSR     LOADINITPROCESSSTARTRECORD
        LBCS    LOADER2                error, undo everything committed so far
        RTS
        PAGE
LOADINITPROCESSSTARTRECORD ; process start record
        LDX     #DUMPBUFFERS           dump buffers before we start loading,
        JSR     SYSCALL$               to eliminate unnecessary disk thrashing
        ; that would occur when we try to read a lot, causing SDOS to dump
        ; one cylinder, read more, causing SDOS to dump another cylinder,
        ; thereby causing lots of seeks between dump points and file being loaded
        LDX     CURRENTUCB
        CLR     UCB:LOADDECRYPTFLAG,X  FLAG "DON'T DECRYPT!"
        LDX     #DECRYPTBUFFER         SET UP SO GET BYTE GETS 1ST BYTE OF FILE
        STX     DECRYPTBUFPTR
        LDX     #FILLDECRYPTBUFFER     READ 1ST 8 BYTES OF FILE
        JSR     SYSCALL$
        JSR     GETBYTE                GET ME A BYTE
        CMPA    #LOAD:ENCRYPTED        IS THIS AN ENCRYPTED FILE?
        LBEQ    LOADENCRYPTED          B/ YES, GO COMPUTE DECRYPTION KEY AND PROCESS 1ST LOAD RECORD
        LDX     #NEWKEYENCRYPTED       SET NEWKEYENCRYPTED = 0 --> UNENCRYPTED FILE
        LDB     #8                     = # BYTES TO ZERO
ZERONEWKEYLOOP
        CLR     ,X+
        DECB
        BNE     ZERONEWKEYLOOP
LOADSTART ; VERIFY THAT THIS IS A PROPERLY CONSTRUCTED START RECORD
        CMPA    #LOAD:TYPE1            DOES IT APPEAR TO BE SDOS BINARY FORMAT ?
        BEQ     LOADTYPE1              B/ YES
CANTLOAD ; THIS IS NOT AN OBJECT FILE
        JSR     ERRET
        FDB     ERR:NOTALOADFILE
        page
LOADTYPE1 ; FETCH START ADDRESS AND VERIFY COMPLEMENT IN TYPE1 RECORD
        JSR     GETWORD                GET THE EXECUTION ADDRESS
        STD     UCB:LOADSTARTADDRESS,x
        JSR     GETWORD
        ADDD    UCB:LOADSTARTADDRESS,x
        CMPD    #-1
        BNE     CANTLOAD               B/ NOT TYPE 1 RECORD!
        LDD     UCB:LOADSTARTADDRESS,X get start address...
        LDX     UCB:USERRDBUF,X        so we can return it to the user space
        LEAX    2,X                    goes at offset 2 in reply buffer
        JSR     COPYDTOUSER
        OKRTS
        page
LOADINITCANTOPEN ; ERROR WHEN OPENING LOAD FILE
        STX     LASTERROR              save the error code
        LDX     CURRENTUCB             channel is not open, so don't need to close
        LDAA    UCB:LOADCHANNEL,X
        LDAB    #$FF                   = "NOT ALLOCATED" code
        STAB    UCB:LOADCHANNEL,X
        JSR     FREEREALCHANNEL
        BSR     LOADINITCOPYSCANNED    return length of filename to user
        LDX     LASTERROR              inspect error code
        CPX     #ERR:FILENOTFOUND      IS THIS THE CAUSE?
        BNE     LOADINITCANT1          B/ NO
        LDX     #ERR:NOSUCHPROGRAM     YES, CHANGE ERROR CODES
LOADINITCANT1
        JMP     ERRORINX               TRIGGER THE ERROR AGAIN

LOADINITCOPYSCANNED
        LDX     CURRENTUCB
        CLR     UCB:GIVERPLEN,X        remember we did it here, so we don't do it again
; in particular, prevent file name length and start address from being
; returned after a CHAIN has successfully loaded the address space
        LDX     UCB:USERSCB,X          set reply length for CHAIN/LOAD
        LEAX    SCBLK:RPLEN,X
        LDD     #2+2                   2 for filename length, 2 for start address
        JSR     COPYDTOUSER            set length of response
        JMP     RETURNSCANNED
        PAGE
LOADREST ; LOAD OBJECT RECORDS FROM FILE
        JSR     LOADCONTENTS           LOAD THE CONTENTS OF THIS FILE
        BCS     LOADER2                B/ ERRORED IN LOADING FILE CONTENTS
LOADCLOSE ; CLOSE THE LOAD FILE AND QUIT
        if      m6800!m6801
        LDD     CURRENTUCB             DECIDE IF WE SHOULD RUN ENCRYPTED OR NOT
        ADDD    #UCB:OLDKEYENCRYPTED
        TDX
        else    (m6809)
        LDX     CURRENTUCB
        LEAX    UCB:OLDKEYENCRYPTED,X
        fin
        JSR     SETKEY                 (TRASH THE DECRYPTION KEY, THIS PATH ALWAYS TAKEN!)
;       LDAA    0,X                    IF OLDKEYENCRYPTED<>0, THEN RUN ENCRYPTED!
;       ORAA    1,X
;       ORAA    2,X
;       ORAA    3,X
;       ORAA    4,X
;       ORAA    5,X
;       ORAA    6,X
;       ORAA    7,X
;       JSR     GETRUNNINGENCRYPTED     GET POINTER TO RUNNINGENCRYPTED FLAG
;       STAA    0,X                     TELL ROM WE ARE/ARE NOT RUNNING ENCRYPTED
        JSR     RELEASEALLPAGES         DON'T NEED BUFFERS ANY LONGER
*                                       Note: this is needed in case loader
*                                       errors while trying to CHAIN!
CLOSELOADCHANNEL ; close LOAD channel for current user if it is open
        ldx     currentucb              Now close the load file
        ldaa    ucb:loadchannel,x
        ldab    #$FF                    mark as "not allocated"
        stab    ucb:loadchannel,x
        jsr     ischannelopen           will error if not open;
        jmp     releaserealchannel      that's OK! It SHOULD be open here.

ErrSerialNoWrong
        Jsr     Erret
        Fdb     Err:SerialNoWrong
        page
LOADER2 ; ERRORED WHILE TRYING TO LOAD
        STX     LASTERROR              SAVE THE ERROR CODE
        BSR     LOADCLOSE              CLOSE UP THE LOAD FILE
        BCS     LOADER2.1              B/ IGNORE ERRORS
LOADER2.1
        LDX     LASTERROR              GET ERROR CODE BACK
        BRA     LOADINITCANT1          GO STICK USER WITH ERROR
        PAGE    SDOS BINARY FORMAT LOADER
;GETRUNNINGENCRYPTED ; GET ADDRESS OF RUNNING ENCRYPTED FLAG TO (X)
;       LDX     $FFFE                  GET POINTER TO JMP AROUND SERIAL NUMBER
;       LDX     1,X                    GET POINTER TO RESTART CODE
;       LDX     LDAENCRYPTED-RESTART+1,X = ADDRESS OF RUNNINGENCRYPTED FLAG
;       RTS

LOADENCRYPTED ; LOAD AN ENCRYPTED FILE, PROCESS TYPE 5 RECORD
        LDX     #GETSERIALNUMBER       GRAB CPU SERIAL NUMBER
        JSR     SYSCALL$
;       BSR     GETRUNNINGENCRYPTED    GET ADDRESS OF RUNNING ENCRYPTED
;       CLRA                           SELECT BANK 0
;       INC     0,X                    BUMP RUNNINGENCRYPTED; = 2 --> WAS ALREADY RUNNING ENCRYPTED
;       LDX     $FFFE                  CALL SELECTBANK TO VERIFY THAT IT WORKS
;       LDX     1,X
;       JSR     [ERASEBANK-RESTART+1,X]
        LDB     DECRYPTBUFFER+1        GET KEY COUNT FROM TYPE 5 RECORD
        STB     NKEYS                  = # OF KEYS ENCODED
        LDX     #SDOSSECRETKEY
        JSR     SETKEY                 TO START DECRYPT CASCADE THAT GENERATES KEY
        LDX     #DECRYPTBUFFER         START CASCADE OF DECRYPTING 05 RECORD
        JSR     DECRYPT                THIS RANDOMIZES AS MUCH AS ENCRYPT
        JSR     SETKEY                 SET KEY TO CONTENTS OF BUFFER
        LDX     CURRENTUCB
        CLR     UCB:LOADDECRYPTFLAG,X  FLAG 'NO SERIAL NUMBER MATCHES'
LOADCASCADELOOP ; PROCESS SERIAL NUMBERS BY CASCADING THEM
        LDX     #FILLDECRYPTBUFFER     READ IN THE NEXT SERIAL NUMBER
        JSR     SYSCALL$
        IF      M6800!M6801!M6811
        LDX     #DECRYPTBUFFER         = COMPARE "TO" ADDRESS
        STX     TOPOINTER
        ELSE    (M6809)
        LDY     #DECRYPTBUFFER
        FIN
        ldx     #RomSerialNumber       Get pointer to serial number in ROM
        LDB     #8                     = # BYTES TO COMPARE
        JSR     BLOCKCOMPARE           COMPARE DECRYPTBUFFER AGAINST ROM SERIAL NUMBER
        TPA                            HAS 4'S BIT SET IF MATCHED
        ANDA    #4                     = 0 IF NO MATCH, <>0 IF MATCH
*       SET DECRYPTFLAG IF THERE IS A MATCH
*       DON'T USE CONDITIONAL BRANCH AS THEY ARE EASY TO FIND
*
        LDX     CURRENTUCB
        EORA    UCB:LOADDECRYPTFLAG,X  NOW SET FLAG IF OK TO DECRYPT
        STA     UCB:LOADDECRYPTFLAG,X
*** IF DECRYPT KEY WERE FUNCTION OF ROM, THEN WE WOULD NOT HAVE TO CHECK SERIAL
*** NUMBER IN ROM AT ALL; SIMPLY TRY TO LOAD IT. ILLEGAL LOAD RECORD REPORTS AS
*** WRONG SERIAL NUMBER!
        LDX     #DECRYPTBUFFER         START CASCADE OF DECRYPTING 05 RECORD
        JSR     DECRYPT                THIS RANDOMIZES AS MUCH AS ENCRYPT
        JSR     SETKEY                 SET KEY TO CONTENTS OF BUFFER
        DEC     NKEYS                  PROCESSED A KEY...
        BNE     LOADCASCADELOOP        B/ MORE KEYS TO PROCESS
        LDX     CURRENTUCB
        LDAA    UCB:LOADDECRYPTFLAG,X  DID WE FIND A MATCHING SERIAL NUMBER?
        LBEQ    ERRSERIALNOWRONG
*
*       AT THIS POINT, THE DECRYPTION KEY FOR THE OBJECT RECORDS IS COMPLETE
*       NOW WE START THE ACTUAL LOADING PROCESS
*       WE STILL CHECK FOR OBJECT FILE FORMAT IN CASE THE DECRYPTION KEY IS BAD
        PAGE
        JSR     SAVEKEYINUCB           SAVE DECRYPTION KEY IN CASE WE TIMESLICE
        ; I really hate saving the decryption key where it can be easily found
        ; But I don't see any nice choices. Sigh.
*
*       NOW GENERATE AN ENCRYPTED VERSION OF THE DECRYPTION KEY...
*       SO THAT CHAIN/LOAD CAN COMPARE TO OLD VERSION OF "DECRYPTION" KEY
*
        LDX     #DECRYPTBUFFER
        jsr     decrypt                "Encrypt" the key using itself
        IF      M6800!M6801!M6811
        LDX     #NEWKEYENCRYPTED       = "TO" ADDRESS
        STX     TOPOINTER
        ELSE    (M6809)
        LDY     #NEWKEYENCRYPTED
        FIN
        LDX     #DECRYPTBUFFER         = FROM ADDRESS
        LDD     #8                     = SIZE OF KEY
        JSR     BLOCKMOVE              SAVE NEWKEY, ENCRYPTED FOR LATER COMPARISION
*       LDX     #DECRYPTBUFFEREND      SET UP TO GET PRESUMED TYPE1 RECORD CODE
        STX     DECRYPTBUFPTR
        JSR     GETBYTE                GET ME A BYTE
        jmp     loadstart              go process type1 load record

        FCB     $CE     TO THROW OFF WOULD-BE DISASSEMBLERS
SDOSSECRETKEY FCB $4C,$B0,$B7,$4E,$9B,$65,$72,$C9
        PAGE
LOADTYPE0 ; IGNORE "LOADCOUNT" BYTES (ASSERT: CANNOT OCCUR IN ENCRYPTED FILES!!!)
        JSR     GETWORD
LOADTYPE0L ; USE UP BYTES IN DECRYPT BUFFER
; This is sheer paranoia.  The encrypter strips SKIP records, so there
; should be nothing in the DECRYPTBUFFER when we get here.
        STD     UCB:USERRDLEN,X        SAVE # BYTES TO SKIP
        LDX     DECRYPTBUFFER          USE UP BYTES IN DECRYPTBUFFER, FIRST
        CPX     #DECRYPTBUFFEREND      DECRYPT BUFFER EXHAUSTED?
        BEQ     LOADTYPE0.2            B/ YES
        JSR     GETBYTE                NO, USE UP A BYTE
        LDD     UCB:USERRDLEN,X        DECREMENT SKIP LOADCOUNT
        SUBD    #1
        BNED    LOADTYPE0L             B/ MORE BYTES TO SKIP
        BRA     LOADNEXT               EXHAUSTED SKIP LOADCOUNT!

LOADTYPE0.2 ; SKIP OVER BIG CHUNK OF BYTES IN FILE
        LDX     CURRENTUCB
        LDAA    UCB:LOADCHANNEL,X
        STAA    LOADGETPOS+STATUS:CHANNEL
        STAA    LOADSETPOS+CONTROL:CHANNEL
        LDX     #LOADGETPOS            GET FILE POSITION
        JSR     SYSCALL$
        LDX     CURRENTUCB
        LDD     UCB:USERRDLEN,X        ADD SKIPCOUNT BYTES TO CURRENT POSITION
        ADDD    LOADFILEPOS+2
        STD     LOADFILEPOS+2
        BCC     LOADTYPE0.1
        LDX     LOADFILEPOS            PROPOGATE CARRY TO UPPER 16 BITS
        INX
        STX     LOADFILEPOS
LOADTYPE0.1
        LDX     #LOADSETPOS            AND POSITION THERE
        JSR     SYSCALL$
        BRA     LOADNEXT
        page
LOADCONTENTS ; LOAD CONTENTS OF OBJECT FILE
        LDAA    #SYSCALL:READB         convert CHAIN/LOAD into "READB" opcode
        LDX     CURRENTUCB
        STAA    SCBLK:OPCODE,X
        LDAA    UCB:BUFFER,X           where big buffer is
        STAA    SCBLK:RDBUF,X          set to use as target of massive READBs
        CLR     SCBLK:RDBUF+1,X
        LDAA    UCB:LOADCHANNEL,X      which channel to do READB from
        STAA    READB:CHANNEL,X
        ; Now Syscall block in UCB is set up to do massive read binaries.
        ; The opcode is a READB, set above. The length is 14, inherited
        ; from the SYSCALL:CHAIN/LOAD that the user did.  The RDBUF is set
        ; to the big buffer inside /MT allocated by LOADINIT.  RDLEN will
        ; be set by LOAD2AND3.  WRBUF/WRLEN will be ignored by the READB call,
        ; so we need not fiddle with it at all.
        bra     LOADNEXT
*
LOADTYPE2 ; LOAD BYTES AND THEN LOOK FOR NEXT RECORD
        BSR     LOAD2AND3
LOADNEXT ; PROCESS NEXT LOAD RECORD: Type 0, 2 or 3 allowed here
        JSR     GETBYTE
        CMPA    #LOAD:TYPE2            DATA RECORD ?
        BEQ     LOADTYPE2              B/ YES
        CMPA    #LOAD:TYPE3            LAST DATA RECORD ?
        BEQ     LOADTYPE3              B/ YES
        CMPA    #LOAD:TYPE0            SKIP RECORD ?
        BEQ     LOADTYPE0              B/ YES
ERRBADLOADRECORD
        JSR     ERRET
        FDB     ERR:BADLOADRECORD

ERRNOTENOUGHROOM
        JSR     ERRET
        FDB     ERR:NOTENOUGHROOM
        PAGE
LOADTYPE3 ; LAST LOAD RECORD AND QUIT
*
*       LOAD BYTES FROM DISK FILE INTO USER SPACE
*
LOAD2AND3 ; LOAD CONTENTS OF TYPE 2 OR TYPE 3 RECORD
        JSR     GETWORD                GO GET THE LOAD ADDRESS
        STD     UCB:USERRDBUF,X        REMEMBER WHERE DATA IS TO BE LOADED
        JSR     GETWORD
        STD     UCB:USERRDLEN,X
        ADDD    UCB:USERRDBUF,X        = ADDRESS OF LAST BYTE LOADED, +1
*
*       LOADBOUNDSCHECK -- MAKE SURE (A,B) <= DRIVER BASE
*       WE SHOULD ALSO CHECK TO MAKE SURE WE ARE LOADING ON TOP OF THE STACK, TOO!
*
        SEC                             ACTUALLY TEST FOR (A,B)-1 < DRIVERBASE
        SBCB    UCB:TOPMEM+1,X          ...?
        SBCA    UCB:TOPMEM,X            ...?
        BCC     ERRNOTENOUGHROOM        B/ HE'S DEAD!
LOAD2AND3.1 ; CHECK FOR DONE LOADING BYTES FROM THIS RECORD
        LDX     CURRENTUCB
        LDX     UCB:USERRDLEN,X        ARE WE DONE?
        BEQ     LOAD2AND3RTS           B/ YES
LOAD2AND3LOOP ; LOAD SOME BYTES FROM THIS RECORD
        LDX     DECRYPTBUFPTR          TRY TO OPTIMIZE THE LOAD PROCESS
        CPX     #DECRYPTBUFFEREND      IS THERE STILL STUFF IN THE DECRYPT BUFFER?
        ; if so, not only must we process it, but we must NOT timeslice.
        BEQ     LOAD2AND3BLOCK         GO LOAD EFFICIENTLY WITH LARGE BLOCKS
LOAD2AND3BYTE ; LOAD ONE BYTE THE UNOPTIMIZED WAY
        JSR     GETBYTE
        LDX     UCB:USERRDBUF,X
        JSR     COPYATOUSER
        LDX     CURRENTUCB
        INCD    UCB:USERRDBUF,X
        LDD     UCB:USERRDLEN,X
        SUBD    #1
        STD     UCB:USERRDLEN,X
        BNED    LOAD2AND3LOOP          B/ MORE BYTES TO LOAD ONE AT A TIME
LOAD2AND3RTS    OKRTS                  YOU GUESS...
        page
LOAD2AND3BLOCK ; LOAD EFFICIENTLY USING LARGE BLOCKS
        LDX     CURRENTUCB
        LDAA    UCB:BUFFERSIZE,X       TAKE MIN(BUFFERSPACE,RECORDSIZE)
        CLRB                           (EXTEND BUFFER SIZE TO 16 BITS)
        CMPD    UCB:USERRDLEN,X
        BLO     LOAD2AND3.3            B/ RECORD DOES NOT FIT IN BUFFER
        LDD     UCB:USERRDLEN,X        USE REMAINDER OF LOAD RECORD
LOAD2AND3.3 ; (D) has number of bytes to load this time, is it at least 8 ?
        ANDB    #(\7)&$FF              (D) = MULTIPLE OF 8 BYTES TO LOAD
        STD     SCBLK:RDLEN,X          SET AMOUNT TO LOAD ON THIS PASS
        BEQD    LOAD2AND3BYTE          B/ NOT ENOUGH BYTES TO LOAD BY BLOCK
        PAGE
*
*       LOAD A MULTIPLE OF 8 BYTES INTO MEMORY QUICKLY
*
        LDD     UCB:USERRDLEN,X        COMPUTE REMAINING LOADCOUNT AFTER OPTIMIZED LOAD
        SUBD    SCBLK:RDLEN,X
        STD     UCB:USERRDLEN,X
        JSR     SYSCALL$               EOF WILL OCCUR IF LOAD FILE IS NOT MULTIPLE OF 8 BYTES IN SIZE
        LDX     CURRENTUCB
        LDD     SCBLK:RDBUF,X          COMPUTE WHERE TO END DECRYPTING
        ADDD    SCBLK:RDLEN,X
        STD     TSTEMP                 = 1ST PLACE NOT YET LOADED
        TST     UCB:LOADDECRYPTFLAG,X  ARE WE DECRYPTING?
        BEQ     LOAD2AND3.2            B/ NO, GO LOAD MORE BYTES
        LDX     SCBLK:RDBUF,X          WHERE TO START DECRYPTING
LOAD2AND3MASSDECRYPT ; DECRYPT JUST LOADED BLOCK OF BYTES
        JSR     DECRYPT                GO DECRYPT A BLOCK OF 8 BYTES
        LEAX    8,X                    FIND NEXT BLOCK OF 8 BYTES
        CPX     TSTEMP                 ALL LOADED BYTES DECRYPTED YET?
        BNE     LOAD2AND3MASSDECRYPT   B/ NO, GO DECRYPT SOME MORE
        LDX     CURRENTUCB
LOAD2AND3.2
        LDD     UCB:USERRDBUF,X        GET SET TO COMPUTE NEXT LOAD ADDRESS IN USER SPACE
        IF      M6809
        LDY     UCB:USERRDBUF,X        SET WHERE TO MOVE BYTES TO IN USER SPACE
        ELSE    (M6800!M6801!M6811)
        STD     TEMPX                  SET WHERE TO MOVE BYTES TO IN USER SPACE
        FIN
        ADDD    SCBLK:RDLEN,X          ADDRESS OF NEXT BYTE TO LOAD...
        STD     UCB:USERRDBUF,X        IN USER SPACE AFTER THIS BLOCK OF BYTES
        LDD     SCBLK:RDLEN,X          NUMBER OF BYTES TO MOVE TO USER SPACE
        LDX     SCBLK:RDBUF,X          WHERE TO MOVE THEM FROM
        JSR     COPYTOUSER             move chunk of data to user space
        page
        ; OK. Now consider timeslicing. First check: any other users ready ?
        ldaa    sdosmtstatuschanged    any status change ?
;       oraa    inputq                 anybody in input q ?
        oraa    outputq                anybody in output wait q ?
        oraa    spaceq                 anybody waiting for space ?
        oraa    delayq                 anybody in the delay q?
        oraa    ioq                    anybody in I/O q ?
;       oraa    loadq                  program load desired ?
;       oraa    runq                   anybody else want cycles ?
        beq     LOADSWAP.NOTNEEDED     b/ nobody else needs attention
        JSR     GETREMAININGQUANTUM    SEE IF QUANTUM IS USED UP
        LBPL    LOAD2AND3.1            B/ NO, KEEP LOADING
        LDX     CURRENTUCB             set next quantum
        ADDA    CPUQUANTUMTICKS        = LONG TIME SLICE - OVERRUN PENALTY
        STAA    UCB:REMAININGQUANTUM,X
        LDD     CURRENTUCB             WHICH UCB TO INSERT INTO QUEUE
        JSR     ADDLOADQFRONT          PUT THIS GUY ON FRONT OF LOADQ...
        ; SO HE GETS CONTROL FIRST IF THERE ARE MULTIPLE USERS WISHING TO LOAD
        JSR     RELEASEALLPAGES        give up all of our pages
        JSR     SAVEPLACE              WAIT FOR NEXT TIMESLICE OPPORTUNITY
        LDA     #1                     MARK THIS GUY AS COMPUTE-BOUND
        STAA    UCB:USERCPUBOUND,X
        LDAA    #255                   SET NUMBER OF PAGES DESIRED
        JSR     ALLOCATENPAGES         ASSERT: this will ALWAYS find at least one page!
        STAA    UCB:BUFFERSIZE,X       save number of pages in load buffer
        STAB    UCB:BUFFER,X           remember location of buffer
        STAB    SCBLK:RDBUF,X          remember where big buffer is
        CLR     SCBLK:RDBUF+1,X        buffer address is on a page boundary
        JSR     SETKEYFROMUCB          SET KEY FROM SAVED KEY IN UCB
        LDX     #DECRYPTBUFFEREND      make sure DECRYPTBUFFER looks empty
        STX     DECRYPTBUFPTR         (or old trash from another user will confuse us!)
LOADSWAP.NOTNEEDED
        JMP     LOAD2AND3.1
        PAGE
GETBYTE ; GET NEXT DECRYPTED BYTE FROM THE FILE INTO (A)
        LDX     DECRYPTBUFPTR          IS THE BUFFER EMPTY?
        CPX     #DECRYPTBUFFEREND
        BNE     GETBYTE1               B/ NOPE
        LDX     CURRENTUCB
        LDAA    UCB:LOADCHANNEL,X      FETCH CHANNEL NUMBER OF FILE BEING LOADED
        LDAB    UCB:LOADDECRYPTFLAG,X  BUFFER IS EMPTY, ARE WE DECRYPTING?
        BNE     GETBYTED               B/ YES, GO FETCH ANOTHER BUFFERFUL TO DECRYPT
        STAA    GET1BYTE+READB:CHANNEL PREPARE TO READ ONE BYTE
        LDX     #GET1BYTE              NO, FETCH NEXT LOAD RECORD HEADER BYTE
        JSR     SYSCALL$
        LDA     BUFFER                 GET THE BYTE
        LDX     CURRENTUCB             FOR CONVENIENCE OF CALLER
        OKRTS

GETBYTED ; GET NEXT 8 BYTES FROM FILE AND DECRYPT
        STAA    FILLDECRYPTBUFFER+READB:CHANNEL PREPARE TO READ SEVERAL BYTES
        LDX     #FILLDECRYPTBUFFER
        JSR     SYSCALL$
        LDX     #DECRYPTBUFFER         START BUFFER POINTER AT BEGIN BUFFER
        JSR     DECRYPT                DECRYPT THE 8 BYTES JUST READ
GETBYTE1 ; FETCH DECRYPTED BYTE FROM BUFFER
        LDA     ,X+                    GET THE CHAR
        STX     DECRYPTBUFPTR
        LDX     CURRENTUCB             FOR CONVENIENCE OF CALLER
        OKRTS                          I'M DONE
*
GETWORD ; GET 2 BYTES FROM THE DISK BUFFER INTO (D)
        BSR     GETBYTE
        PSHA
        BSR     GETBYTE
        TFR     A,B
        PULA
        ; Assert: CURRENTUCB is in (X) here
        RTS
        page
SAVEKEYINUCB ; SAVE DECRYPTION KEY INTO UCB:DECRYPTIONKEY FIELD
        LDX     CURRENTUCB             WHERE TO STORE DECRYPTION KEY
        LDB     KEY5                   DO SO IN AS APPARENTLY DISORGANIZED WAY AS POSSIBLE
        LDA     KEY4
        STD     UCB:LOADDECRYPTIONKEY+4,X
        LDA     KEY0
        LDB     KEY1
        STD     UCB:LOADDECRYPTIONKEY+0,X
        LDB     KEY7
        LDA     KEY6
        STD     UCB:LOADDECRYPTIONKEY+6,X
        LDA     KEY2
        LDB     KEY3
        STD     UCB:LOADDECRYPTIONKEY+2,X
        RTS

SETKEYFROMUCB ; SET DECRYPTION KEY FROM UCB:DECRYPTIONKEY FIELD
        IF      M6809
        LDX     CURRENTUCB             LOCATE DECRYPTION KEY FIELD
        LEAX    UCB:LOADDECRYPTIONKEY,X
        ELSE    (M6800!M6801!M6811)
        LDD     CURRENTUCB
        ADDD    UCB:LOADDECRYPTIONKEY
        STD     TEMPX
        LDX     TEMPX
        FIN
;       BRA     SETKEY

SETKEY ; SET "KEY" TO 8 BYTES POINTED TO BY (X)
        LDD     4,X                    COPY KEY BYTES TO INLINE CODE
        STB     KEY5                   DO SO IN AS APPARENTLY DISORGANIZED WAY AS POSSIBLE
        STA     KEY4
        LDD     0,X
        STA     KEY0
        STB     KEY1
        LDD     6,X
        STB     KEY7
        STA     KEY6
        LDD     2,X
        STA     KEY2
        STB     KEY3
        RTS
        PAGE
ZAPUSERSPACE ; OLD DECRYPTION KEY <> NEW, ERASE USER SPACE!
        LDX     CURRENTUCB             ZERO OUT THE ALLOCATED BUFFER
        LDAA    UCB:BUFFER,X           WHERE TO START ZEROING
        CLRB                           (GENERATE 16 BIT PAGE ADDRESS)
        STD     TEMPX                  SO WE CAN LOAD (X) WITH THIS VALUE BELOW
        ADDA    UCB:BUFFERSIZE,X       1ST BYTE ABOVE REGION TO ZERO
        LDX     TEMPX                  WHERE TO START ZEROING
        STD     TEMPX                  WHERE TO STOP ZEROING
        IF      M6800!M6801!M6811
        STX     TEMPX+2                SET UP POINTER IN PLACE EASY TO ADJUST
        FIN
        LDD     #0                     ZEROS TO STORE
ZAPBUFFERL ; ZAP BUFFER LOOP
        STD     0,X                   ASSERT: BUFFER IS MULTIPLE OF 16 BYTES
        STD     2,X                   IN SIZE. WE ZAP 16 AT A TIME FOR SPEED.
        STD     4,X
        STD     6,X
        STD     8,X
        STD     10,X
        STD     12,X
        STD     14,X
        IF      M6800!M6801!M6811
        LDAB    TEMPX+3                POINTER TO CURRENT BLOCK
        ADDB    #16                    THIS IS FASTER THAN 16 INX'S
        STAB    TEMPX+3
        BCC     *+5
        INC     TEMPX+2
        LDX     TEMPX+2
        ELSE    (M6809)
        LEAX    16,X
        FIN
        CPX     TEMPX                 STOP ZEROING AT END OF BUFFER
        BNE     ZAPBUFFERL            b/ more buffer to zero
        page
; Now, repeatedly copy buffer to user space until user space is zeroed
        LDX     CURRENTUCB
        LDD     UCB:TOPMEM,X
        DECA                           DON'T ZERO PAGE ZERO
        STD     SCBLK:WRLEN,X          SET NUMBER OF BYTES TO ZAP USER SPACE
        LDD     #$100
        STD     SCBLK:WRBUF,X          WHERE TO START ZEROING IN USER SPACE
ZAPUSERSPACEL.1 ; ZERO BYTES IN USER SPACE AT SCBLK:WRBUF FOR SCBLK:WRLEN BYTES
        LDAA    UCB:BUFFERSIZE,X       THIS IS HOW MANY WE COULD ZERO
        CLRB                           (GENERATE ACTUAL COUNT FROM PAGE COUNT)
        CMPA    SCBLK:WRLEN,X          COPY WHOLE BUFFER OR ONLY PART ?
        BLS     ZAPUSERSPACEL.2        B/ BUFFER SIZE <= REMAINING, COPY WHOLE
        LDD     SCBLK:WRLEN,X          COPY ONLY ENOUGH TO FINISH
ZAPUSERSPACEL.2
        IF      M6809
        LDY     SCBLK:WRBUF,X          WHERE TO COPY TO IN USER SPACE
        ELSE
        LDX     SCBLK:WRBUF,X
        STX     TEMPX
        FIN
        LDX     CURRENTUCB
        LDX     UCB:BUFFER,X           WHERE TO COPY FROM IN /MT SPACE
        JSR     COPYTOUSER
        LDX     CURRENTUCB
        LDAA    SCBLK:WRBUF,X          DETERMINE NEXT PLACE IN USER SPACE
        ADDA    UCB:BUFFERSIZE,X
        STAA    SCBLK:WRBUF,X
        LDD     SCBLK:WRLEN,X          REDUCE # BYTES TO ZERO...
        SUBA    UCB:BUFFERSIZE,X       BY SIZE OF BUFFER COPIED TO USER SPACE
        ; Don't need to subtract (B), because BUFFERSIZE is multiple of 256
        STD     SCBLK:WRLEN,X
        BLO     SETUPFRANKBAKER        B/ ALL DONE
        BNE     ZAPUSERSPACEL.1        B/ MORE BYTES TO ZERO, GO DO IT
        TSTB                           SOME SCRAPS LEFT TO ZERO ?
        BNE     ZAPUSERSPACEL.1        B/ YES, GO ZERO THE SCRAPS
;       JMP     SETUPFRANKBAKER
        PAGE
SETUPFRANKBAKER ; set up syscall linkage within user space
        LDAA    SYSCALL$               SET UP SYSCALL JUMP IN PAGE ZERO...
        LDX     #SYSCALL$              ...to jump to I/O package base
        JSR     COPYATOUSER
        LDX     CURRENTUCB
        LDD     UCB:TOPMEM,X           (so user knows where base of I/O pack is!)
        LDX     #SYSCALL$+1
        JSR     COPYDTOUSER
        LDAA    USERSPACESYSCALL       tell user how to get to system space
        LDX     CURRENTUCB
        LDX     UCB:TOPMEM,X
        JSR     COPYATOUSER
        LDD     USERSPACESYSCALL+1
        LDX     CURRENTUCB
        LDX     UCB:TOPMEM,X
        INX
        JMP     COPYDTOUSER
        PAGE    EXIT CODE
EXITS ; Close all channels which user has open, except for channel 0
        LDX     CURRENTUCB             make CHAIN syscall block into a CLOSE scb
        LDAA    #UCBchannels-1         close all channels but channel 0
EXITS.LOOP
        LDX     CURRENTUCB
        STAA    SCBLK:PARAMS,X
        PSHA                           save this channel number
        JSR     CLOSE.DUMP
        BCS     EXITS.DOESNTMATTER
EXITS.DOESNTMATTER
        PULA
        DECA
        BNE     EXITS.LOOP
EXITS.DONE
        RTS
        PAGE    Block Move and Compare
blockmove ; /MT doesn't move big blocks, so this awful routine is ok
        std     tempx+4
blockmoveloop
        lda     ,x+
        if      m6800!m6801
        stx     tempx+2
        ldx     tempx
        sta     ,x+
        stx     tempx
        ldx     tempx+2
        else
        sta     ,y+
        fin     m6800!m6801
        decb
        bne     blockmoveloop
        tst     tempx+4
        beq     blockmoveloop.1
        dec     tempx+4
        bra     blockmoveloop

blockmoveloop.1
        rts
        page
blockcompare ; /MT doesn't compare big blocks, so this awful routine is ok
        lda     ,x+
        if      m6800!m6801
        stx     tempx+2
        ldx     tempx
        cmpa    0,x
        bne     blockcomparefail
        inx
        stx     tempx
        ldx     tempx+2
        else
        cmpa    ,y+
        bne     blockcomparefail
        fin     m6800!m6801
        decb
        bne     blockcompare
        rts                            Z flag cleared in CCR => compare =

blockcomparefail
        if      m6800!m6801
        inx
        stx     tempx
        ldx     tempx+2
        fin     m6800!m6801
        lda     #-1                    clears Z flag in CCR => compare <>
        rts

ERRILLDEVOP
        jsr     erret
        fdb     err:illdeviceop
        PAGE    READA
READA ; Execute SYSCALL:READA for user program
        JSR     GETCHANNEL      do channel translation
        JSR     ISITVIRTUAL
        BEQ     READA.1         b/ not VT device
        CLR     UCB:USERCPUBOUND,X doing I/O to VT device --> not CPU bound
        TST     SCBLK:PARAMS+1,X non-line mode read ?
        BEQ     ERRILLDEVOP     foo on non-linemode reada to vt device!!
                                ; give same error as VT driver would give
READA.1
        JSR     CHECKRDLEN
        #0
        JSR     READA.1.1       get ready to do a read
        LDX     CURRENTUCB      Like SETUPREADBUF

READA.ALLOCATE ; allocate a page of space to accomplish the read
        JSR     ALLOCATE1PAGE    but only allocate 1 page as reply buffer
*                                 since READA's of >256 bytes are unlikely;
*                                  this speeds up most READAs
        STAA    SCBLK:RDLEN,X
        CLR     SCBLK:RDLEN+1,X
        STAB    SCBLK:RDBUF,X
        CLR     SCBLK:RDBUF+1,X
READA.LOOP.0
        TST     UCB:VTFLAG,X    vt reada's and other reada's are different
        BNE     READA.VTLOOP    B/ go handle the vt device
        PAGE
READA.NONVTLOOP ; loop to read bytes from non VT class device
        JSR     READA.LOOPTEST         more data to read?
        BEQ     READA.BUFFERFILLED     b/ no, all done
        JSR     SYSCALL$
        BCC     READA.NONVTLOOPOK      b/ transaction completed nicely
        CPX     #ERR:ACTIVATIONNOTINBUFFER did SDOS want to give us more ?
        BNE     READA.ERROREDJ         oops! SDOS complained, go handle
READA.NONVTLOOPOK
        JSR     COPYBITETOUSER         and reduce RDLEN by amount copied
        JSR     READALOG               log this bite
        LDD     UCB:USERRDLEN,X        if user got everything he asked for, he's
        BEQD    READA.BUFFERFILLED     obviously done.  if he didn't, then check
        LDAA    SCBLK:PARAMS+1,X       the last character read for activation
        BEQ     READA.NONVTNEXT        (b/ not line mode: must fill buffer)
        LDD     SCBLK:RDBUF,X          find location of last byte in buffer
        ADDD    SCBLK:RPLEN,X
        TDX
        LDB     ,-X                    look at last character read
        LDX     CURRENTUCB             (restore pointer to UCB)
        CMPB    #ASCII:CR              (SDOS ensures that parity bit is reset)
        BEQ     READA.DONE             b/ we got it!
READA.NONVTNEXT ; must read another bufferful of data
        JSR     SWAPIFSLOW             swap users if this is taking too long
        BEQ     READA.NONVTLOOP        b/ activation not collected yet
        BRA     READA.ALLOCATE         b/ swapped, must reallocate the pages

READA.BUFFERFILLED ; User's Reply buffer is filled, but activation was not seen
        BSR     READA.DONE             FINISH CLEANING UP
        LDAA    SCBLK:PARAMS+1,X       line mode ?
        BNE     READA.BUFFEROVERFLOW   b/ yes, and no activation supplied
        OKRTS

READA.BUFFEROVERFLOW ; line mode read, but buffer filled before activation
        JSR     ERRET                  trigger an error
        FDB     ERR:ActivationNotInBuffer

READA.ERROREDJ
        JMP     READA.ERRORED
        page
READA.VTLOOP ; loop to read bytes from VT class device
        JSR     READA.LOOPTEST     any room left in buffer ?
        BEQ     READA.BUFFERFILLED B/ nothing left
        JSR     SYSCALL$
        BCS     READA.VTLOOP.ERR   B/ something's wrong
        JSR     COPYBITETOUSER
        BSR     READALOG        log this bite
READA.DONE
        JMP     READB.DONE      this bite contained activation--exit

READA.VTLOOP.ERR
        CPX     #ERR:ACTIVATIONNOTINBUFFER
        BNE     READA.ERROREDJ  B/ wasn't what I expected
        JSR     COPYBITETOUSER
        BSR     READALOG
        ; We don't need to swap here: this can't take very long.
        ; Reason: Input wait is complete, the activation character is
        ; someplace in the buffer, and the buffer is rarely larger
        ; than 100 bytes.  So we can't do any massive transfers!
        BRA     READA.VTLOOP    since no activation, keep trying
        PAGE
READALOG ; perform logging for a reada
        JSR     DOWELOG
        BEQ     READARTS        B/ nope
        LDD     SCBLK:PARAMS,X  save channel and line mode flag
        PSHD
        LDD     SCBLK:RDBUF,X   save this stuff, too
        STD     SCBLK:WRBUF,X
        LDD     SCBLK:RPLEN,X
        STD     SCBLK:WRLEN,X
        LDD     SCBLK:RDLEN,X
        PSHD
        LDAA    UCB:LOGCHANNEL,X
        STAA    SCBLK:PARAMS,X
        LDAA    #SYSCALL:WRITEA set up to do a write
        STAA    SCBLK:OPCODE,X
        LDAA    #WRITEA:SCLEN
        STAA    SCBLK:WLEN,X
        JSR     WRITEA.DIRTYWORK        which destroys SCBLK
        BCS     READALOG.ERR            oops
READALOG.COMPLETE
        LDX     CURRENTUCB             put the scblk back together
        PULD                           fetch saved RDLEN
        STD     SCBLK:RDLEN,X
        LDD     SCBLK:WRLEN,X          fetch saved RPLEN
        STD     SCBLK:RPLEN,X
        LDD     SCBLK:WRBUF,X          fetch saved Reply buffer address
        STD     SCBLK:RDBUF,X
        PULD                           restore saved channel/line flags
        STD     SCBLK:PARAMS,X
        JSR     ISITVIRTUAL            restore UCB:VTFLAG to entry value
        LDAA    #SYSCALL:READA         this undoes storing #SYSCALL:WRITEA...
        STAA    SCBLK:OPCODE,X         into SCBLK:OPCODE done above
        LDAA    #READA:SCLEN
        STAA    SCBLK:WLEN,X
READARTS OKRTS
        PAGE
READALOG.ERR ; see READALOG.COMPLETE for details
        STX     LASTERROR              save error code
        LDX     CURRENTUCB             put the scblk back together
        PULD                           fetch saved RDLEN
        STD     SCBLK:RDLEN,X
        LDD     SCBLK:WRLEN,X          fetch saved RPLEN
        STD     SCBLK:RPLEN,X
        LDD     SCBLK:WRBUF,X          fetch saved Reply buffer address
        STD     SCBLK:RDBUF,X
        PULD                           restore saved channel/line flags
        STD     SCBLK:PARAMS,X
        JSR     ISITVIRTUAL            restore UCB:VTFLAG to entry value
        LDAA    #SYSCALL:READA
        STAA    SCBLK:OPCODE,X
        LDAA    #READA:SCLEN
        STAA    SCBLK:WLEN,X
ERROREDJ JMP     ERRORED
        PAGE
READA.ERRORED ; come here for reada errors

; an error occurring during a reada propagates the error if it is not
; err:eofhit; otherwise, save the error code, readalog, if channel 0 is
; open to the console, leave it open: the user can close and re-open it;
; otherwise, close channel 0, close the log if logging to the console,
; and then open channel 0 to the console

        STX     LASTERROR
        JSR     COPYBITETOUSER  give user as much as I got from SDOS
        JSR     READB.DONE      calculate final rplen
        LDX     LASTERROR
        CPX     #ERR:EOFHIT     we're not interested if not EOF
        BNE     ERROREDJ
        JSR     READALOG        log what we've got
        lda     UCB:USERCHAN,X  toss him out if he's not using channel 0
        bne     reada.goteof    b/ EOF from channel other than 0
        jsr     isitconsole     is READA directed at CONSOLE: thru channel 0?
        beq     reada.goteof    b/ yes, make user close and re-open console:
        jsr     getuserlfchannel no, well, perhaps this is a background job.
        lbeq    jobcontrol.jobdone b/ eof on chan 0 and no console!
        JSR     CLOSECHANNEL0   switch back to the console for further input
        LDX     CURRENTUCB        and turn off logging if it's to the console
        LDAA    UCB:LOGCHANNEL,X
        CMPA    #$FF
        BEQ     READA.8.1       B/ not even logging
        CMPA    UCB:LFCHAN,X
        BNE     READA.8.1       B/ logging, but not to console
        JSR     CLOSELOG        bye, bye, logging!
READA.8.1
        JSR     OPENCONSOLE
        LDX     CURRENTUCB
        lda     ucb:chan0,x     patch up the scb
        sta     scblk:params,x
        JSR     ISITVIRTUAL
        JSR     READA.1.1       may have changed from file to vt, so make sure
        LDX     CURRENTUCB       (restore pointer to UCB)
        JMP     READA.LOOP.0      the coast is clear before leaping
        PAGE
READA.1.1
        LDAA    UCB:VTFLAG,X
        CMPA    #VT:CONSOLE     a CONSOLE type device ?
        BNE     READA.1.2       B/ not VT device, no special handling
        LDAA    SCBLK:PARAMS,X  if input is ready, don't wait for it!!
        STAA    READYLINE+SCBLK:PARAMS
        LDX     #READYLINE      go ready a line and wait for it
        JSR     SYSCALL$
        BCC     READA.3         B/ the line is not ready
        CPX     #ERR:ACTIVATIONRECEIVED
        BEQ     READA.1.2       B/ the line is ready to go
        CPX     #ERR:IOINPROGRESS
        BEQ     READA.3         B/ the line is not ready
        JSR     GOCATATONIC     BAD NEWS!!!

READA.3
        LDD     CURRENTUCB
        JSR     ADDINPUTQ
        JSR     SAVEPLACE
        JSR     RETURNLINEFLAGS back to user before we give him control
        LDX     CURRENTUCB
READA.1.2
        OKRTS

reada.goteof
        ldx     #err:eofhit
        jmp     errorinx
        PAGE
READA.LOOPTEST ; see if user has any more bytes to copy
;  Exit with Z set if all bytes have been copied
;  Exit with C reset if more than one bite left to copy
;  Exit with C set if last bite
;       bra     ReadB.LOOPTEST

READB.LOOPTEST ; see if the user has anything left to copy
;  Exit with C reset if more than one bite left to copy.
;  Exit with C set if last bite.
        LDD     UCB:USERRDLEN,X        see how much more must be read
        BEQD    READLOOP.NONE          b/ none to read, set count to minimum
        SUBD    SCBLK:RDLEN,X          see if full- or partial-bite needed
        BEQD    READLOOPTEST.LAST      b/ remaining = allocated, must be last bite
        BHI     READLOOPTEST.RTS       b/ at least 2 more bites to process (Carry cler)
        LDD     UCB:USERRDLEN,X        do a partial-bite to finish off operation
READLOOP.NONE
        STD     SCBLK:RDLEN,X          set Z bit if all bytes copied
        IF      M6800
        ORAA    SCBLK:RDLEN+1,X        (because M6800 doesn't set Z correctly on STD)
        FIN
        SEC                            flag "last bite"
READLOOPTEST.RTS
        RTS

READLOOPTEST.LAST
        LDAA    #1                     signal "non-empty transfer"
        SEC                            flag "last bite"
        RTS
        page
SWAPIFSLOW ; swap users if this is taking too long
; Exits with Z set if no swap occurred
; Exits with Z reset if swap occurs: all pages have been deallocated.
        ldaa    sdosmtstatuschanged    any status change ?
;       oraa    inputq                 anybody in input q ?
        oraa    outputq                anybody in output wait q
        oraa    spaceq                 anybody waiting for space ?
        oraa    delayq                 anybody in the delay q?
        oraa    ioq                    anybody in I/O q ?
        oraa    loadq                  program load desired ?
        oraa    runq                   anybody else want cycles ?
        beq     SWAP.NOTNEEDED         b/ nobody else needs attention
        jsr     getremainingquantum how many clock ticks left ?
        bpl     SWAP.NOTNEEDED         b/ some quantum left, continue operation
        adda    CPUQUANTUMTICKS        set him up for a long time slice
        staa    ucb:remainingquantum,x (use overrun as penalty against user)
        ldd     currentucb             but make him low priority
        jsr     addrunq                give some other user a chance
        jsr     releaseallpages        give our buffers up so someone else can use them
        jsr     saveplace              come back here when its our turn again
        ldaa    #1                     mark this guy as compute bound
        staa    ucb:usercpubound,x     also reset Z as per exit spec
        rts                            signal that all pages have been deallocated

SWAP.NOTNEEDED ; no swap needed, don't deallocate pages
        ldx     currentucb             for convenience of caller
        clra                           set Z as per exit spec
        rts
        PAGE    READB
*       Perform a read binary operation in bite-size chunks.  The size of the
*       bite is determined by how many pages /MT can allocate.

READB ; Execute SYSCALL:READB for user
        JSR     GETCHANNEL      do channel translation
        JSR     CHECKRDLEN      all I really want are the side-effects
        #0
READB.ALLOCATE ; allocate amount of buffer space necessary
        LDD     UCB:USERRDLEN,X fetch amount of data left to send
        ADDD    #255            round up to next page
        JSR     ALLOCATENPAGES  page count left in A--neat, huh?!
        STAA    SCBLK:RDLEN,X   adjust system call block
        CLR     SCBLK:RDLEN+1,X
        STAB    SCBLK:RDBUF,X
        CLR     SCBLK:RDBUF+1,X
READB.LOOP ; loop here to read chunks of data
        BSR     READB.LOOPTEST  any data left to read ?
        BCS     READB.LASTBITE  B/ last bite, go do it
        JSR     SYSCALL$        fetch, boy!!
        BCS     READB.ERRORED   ouch!!
        BSR     COPYBITETOUSER  move chunk of data
        BSR     SWAPIFSLOW      swap if this is taking a long time.
        BEQ     READB.LOOP      b/ didn't swap
        BRA     READB.ALLOCATE  swapped, go reallocate space

READB.LASTBITE ; This is last byte of data to process
        JSR     SYSCALL$        fetch chunk
        BCS     READB.ERRORED   ouch!!
        BSR     COPYBITETOUSER  move chunk of data
READB.DONE ; clean up after reading data
        LDD     UCB:USERRPLEN,X set reply length = Number of bytes copied
        STD     SCBLK:RPLEN,X   return the complete rplen
        OKRTS

READB.ERRORED ; got some kind of error: terminate operation
        STX     LASTERROR
        BSR     COPYBITETOUSER  copy data to user
        BSR     READB.DONE
        JMP     ERRORED
        PAGE
COPYBITETOUSER
        LDX     CURRENTUCB
        IF      M6809
        LDY     UCB:USERRDBUF,X
        ELSE
        LDD     UCB:USERRDBUF,X
        STD     TEMPX
        FIN
        LDD     SCBLK:RPLEN,X
        BEQD    COPYBITETOUSER.9        nothing to copy--so don't bother
        LDX     SCBLK:RDBUF,X
        JSR     COPYTOUSER
        LDX     CURRENTUCB      adjust pointers, counters
        LDD     UCB:USERRDBUF,X
        ADDD    SCBLK:RPLEN,X
        STD     UCB:USERRDBUF,X
        LDD     UCB:USERRDLEN,X
        SUBD    SCBLK:RPLEN,X
        STD     UCB:USERRDLEN,X
        LDD     UCB:USERRPLEN,X
        ADDD    SCBLK:RPLEN,X
        STD     UCB:USERRPLEN,X
COPYBITETOUSER.9
        RTS
        PAGE
COPYBITEFROMUSER ; copy "bite" (pun intended) from user space to system space
; "bite" size is determined by how much buffer we were able to grab
; returns Z bit Set ("Zero") if this is the last bite we must process
; returns Z bit Reset ("Not Zero") if user syscall block still has lots to move
        LDX     CURRENTUCB
        LDAA    UCB:BUFFER,X    copy data from userspace to systemspace
        CLRB
        STD     SCBLK:WRBUF,X
        IF      M6809
        TFR     D,Y
        ELSE
        STD     TEMPX
        FIN
        LDD     UCB:USERWRLEN,X
        CMPA    UCB:BUFFERSIZE,X   do we copy a full bite, or just a taste?
        BHS     COPYBITEFROMUSER.2      B/ copy over a full bite
        STD     SCBLK:WRLEN,X   copy over last bite
        LDX     UCB:USERWRBUF,X
        JSR     COPYTOSYSTEM
        CLRA                    signal "last bite"
        RTS                     --> no need to adjust pointers
        page
COPYBITEFROMUSER.2
        LDAA    UCB:BUFFERSIZE,X fetch size of buffer to move
        CLRB
        STD     SCBLK:WRLEN,X
        LDX     UCB:USERWRBUF,X
        JSR     COPYTOSYSTEM
        LDX     CURRENTUCB      adjust count and pointer
        LDD     UCB:USERWRBUF,X
        ADDD    SCBLK:WRLEN,X
        STD     UCB:USERWRBUF,X
        LDD     UCB:USERWRLEN,X
        SUBD    SCBLK:WRLEN,X
        STD     UCB:USERWRLEN,X
        IF      M6800
        BNE     *+3             set "Z" bit to indicate remaining amount
        TSTB
        FIN
        RTS
        PAGE    WRITEA & WRITEB
;       WRITEA -- To perform SYSCALL:WRITEA for user
;       Note that a fast path for WRITEAs with small WRBUFs has been provided
;
WRITEA  JSR     GETCHANNEL      do channel translation
        LDD     SCBLK:WRBUF,X   set up buffer space for COPYBITEFROMUSER
        STD     UCB:USERWRBUF,X
        LDD     SCBLK:WRLEN,X
        BEQD    WRITEAFROMSYSTEMSPACE  b/ nothing to write, do it quick!
        STD     UCB:USERWRLEN,X
WRITEA.ALLOCATE
        JSR     ISITVIRTUAL            VT class device ?
        BEQ     WRITEA.NONVT           b/ no
        JSR     ALLOCATE1PAGE          yes, allocate only a single page
        STAB    UCB:BUFFER,X            remember this!
        STAA    UCB:BUFFERSIZE,X        this too!!
WRITEA.VTLOOP
        JSR     COPYBITEFROMUSER
        BEQ     WRITEAFROMSYSTEMSPACE   b/ last bite, take fast path
        BSR     WRITEAFROMSYSTEMSPACE
        ; Note: we DON'T swap when talking to VT devices.
        BRA     WRITEA.VTLOOP          b/ more bites to process

WRITEA.NONVT ; WRITEA to non-VT device
        LDD     UCB:USERWRLEN,X        allocate enough pages for buffer
        ADDD    #255
        JSR     ALLOCATENPAGES
        STAB    UCB:BUFFER,X            remember this!
        STAA    UCB:BUFFERSIZE,X        this too!!
WRITEA.NONVTLOOP
        JSR     COPYBITEFROMUSER
        BEQ     WRITEAFROMSYSTEMSPACE   b/ last bite, take fast path
        BSR     WRITEAFROMSYSTEMSPACE
        JSR     SWAPIFSLOW             swap users if this is taking too long
        BEQ     WRITEA.NONVTLOOP       b/ didn't swap and this is not last bite
        BRA     WRITEA.NONVT           swapped, must reallocate pages
        PAGE
WRITEAFROMSYSTEMSPACE
        BSR     DOWELOG
        BEQ     WRITEAFROMSYSTEMSPACE.6 B/ no, we don't
        JSR     ISITCONSOLE
        BNE     WRITEAFROMSYSTEMSPACE.2 B/ no, it isn't
        LDX     CURRENTUCB              well, we are and it is, so do it twice
        LDD     SCBLK:WRBUF,X
        PSHD
        LDD     SCBLK:WRLEN,X
        PSHD
        JSR     WRITEA.DIRTYWORK         first to channel 0
        BCS     WRITEAFROMSYSTEMSPACE.3 oops!
        PULD
        STD     SCBLK:WRLEN,X
        PULD
        STD     SCBLK:WRBUF,X
        PAGE
WRITEAFROMSYSTEMSPACE.2
        LDAA    SCBLK:PARAMS,X          then to log
        PSHA
        LDD     #SYSCALL:WRITEA##8!WRITEA:SCLEN convert back to WRITEA call
        STD     SCBLK:OPCODE,X
        LDAA    UCB:LOGCHANNEL,X
        STAA    SCBLK:PARAMS,X
        JSR     WRITEA.DIRTYWORK
        BCS     WRITEAFROMSYSTEMSPACE.4
WRITEAFROMSYSTEMSPACE.5
        LDX     CURRENTUCB
        PULA
        STAA    SCBLK:PARAMS,X          patch scblk back together
        OKRTS

WRITEAFROMSYSTEMSPACE.4
        STX     TSTEMP
        JSR     CLOSELOG                had trouble during logging
        BCS     WFSS.4.DONTCARE         damn the log, full speed ahead!
WFSS.4.DONTCARE
        ldx     currentucb              if channel 0 is not to the console
        jsr     isitconsole             then close and re-open console, too
        bcc     wfss.5                  b/ console
        jsr     closechannel0           kaBLOOIE!
        jsr     openconsole
wfss.5
        LDX     CURRENTUCB
        PULA
        STAA    SCBLK:PARAMS,X          patch scblk back together
        ldx     tstemp
        JMP     ERRORINX

WRITEAFROMSYSTEMSPACE.6 ; fast path for WRITEAs with small buffers
        lda     scblk:params,x          writing to user CONSOLE: ?
        cmpa    ucb:lfchan,x
        beq     writea.dirtywork        b/ yes, go do it!
        cmpa    ucb:chan0,x             no, writing to channel zero ?
        bne     writea.dirtywork        b/ no, just go do it!
        okrts                           skip output if chan 0, but not console

WRITEAFROMSYSTEMSPACE.3
        LEAS    4,S
        JMP     ERRORINX
        PAGE
DOWELOG ; returns Z set (Zero) if NOT logging
; returns Z reset (Not Zero) if logging; log channel in (a)
        LDX     CURRENTUCB
        lda     ucb:logchannel,x
        cmpa    #$ff            see if log is open
        beq     dowelog.rts     b/ no (hi frequency path)
        ldb     scblk:params,x  is it channel zero ?
        cmpb    ucb:chan0,x
        beq     dowelog.yes
        clra                    set Z
dowelog.rts
        rts

dowelog.yes
        ldab    #1              reset Z --> logging
        rts

isitconsole ; returns Z set (Zero) if true
        ldx     currentucb
        lda     scblk:params,x
        cmpa    ucb:lfchan,x
        rts
        PAGE
WRITEA.DIRTYWORK ; execute SYSCALL:WRITEA in UCB.
; Returns (X) pointing to DCB or errors.
        LDX     CURRENTUCB
        JSR     ISITVIRTUAL             accomodate vt, if vt
        BEQ     WRITEA.DIRTYWORK.0      B/ not vt, just do it!
        CLR     UCB:USERCPUBOUND,X      be nice to guys who do terminal I/O
        LDD     #SYSCALL:CONTROL##8!SCBLK:DATA turn "writea" to "cc:writeanowait"
        STD     SCBLK:OPCODE,X
        LDAA    #CC:WRITEANOWAIT
        STAA    SCBLK:PARAMS+1,X
        LDD     CURRENTUCB
        ADDD    #SCBLK:DATA             put the done flag and error code in the scb
        STD     SCBLK:RDBUF,X
        LDD     #3
        STD     SCBLK:RDLEN,X
        JSR     SYSCALL$
        LDX     CURRENTUCB
        LDA     SCBLK:DATA,X            see if VT driver took all the data
        BEQ     WRITEA.DIRTYWORK.5      b/ no, go put user to sleep
        LDX     SCBLK:DATA+1,X          yes, get error code
        BEQ     WRITEA.DIRTYWORK.3      b/ no error, get out!
WRITEA.DIRTYWORK.2
        STX     LASTERROR
        JMP     ERRORED

WRITEA.DIRTYWORK.5 ; stick user into output wait queue
        LDD     CURRENTUCB
        JSR     ADDOUTPUTQ
        JSR     SAVEPLACE
        jsr     returnlineflags
WRITEA.DIRTYWORK.3 ; reload (X) as per exit spec
        ldx     currentucb             for convenience of caller
        okrts

WRITEA.DIRTYWORK.0 ; just execute the syscall
        JSR     SYSCALL$               just do it
        LDX     CURRENTUCB
        RTS                            assert: carry=0
        page
;       WRITEB -- does SYSCALL:WRITEB for users
;       Note fast path for WRITEBs with small WRBUFs
;
WRITEB  JSR     GETCHANNEL      do channel translation
        LDB     UCB:USERCHAN,X  writing to user channel zero ?
        BNE     WRITEB.1        b/ nope
        lda     ucb:chan0,x     is user channel 0 hooked...
        CMPA    UCB:LFCHAN,X    to user console: ?
        BNE     WRITEB.OKRTS    b/ write to channel 0, but not to console: !
WRITEB.1
        LDD     SCBLK:WRBUF,X
        STD     UCB:USERWRBUF,X
        LDD     SCBLK:WRLEN,X
        BEQD    WRITEB.DIRTYWORK b/ writeb 0 bytes, do call now!
        STD     UCB:USERWRLEN,X
        JSR     ISITVIRTUAL            writing to VT device ?
        BEQ     WRITEB.NONVT           b/ no, allocate as big a chunk as possible
        JSR     ALLOCATE1PAGE          yes, only allocate one page
        STAB    UCB:BUFFER,X            remember this!
        STAA    UCB:BUFFERSIZE,X        this too!!
WRITEB.VTLOOP
        JSR     COPYBITEFROMUSER
        BEQ     WRITEB.DIRTYWORK       b/ last bite, take fast path!
        BSR     WRITEB.DIRTYWORK       we must do this chunk and least one more
        ; Note: we DON'T swap when talking to VT devices.
        BRA     WRITEB.VTLOOP          b/ this is not last bite

WRITEB.NONVT ; writing Binary to non-VT device
        LDD     UCB:USERWRLEN,X        allocate as big a chunk as possible
        ADDD    #255
        JSR     ALLOCATENPAGES
        STAB    UCB:BUFFER,X            remember this!
        STAA    UCB:BUFFERSIZE,X        this too!!
WRITEB.NONVTLOOP
        JSR     COPYBITEFROMUSER
        BEQ     WRITEB.DIRTYWORK       b/ last bite, take fast path!
        BSR     WRITEB.DIRTYWORK       we must do this chunk and least one more
        JSR     SWAPIFSLOW             swap users if this is taking too long
        BEQ     WRITEB.NONVTLOOP       b/ this is not last bite
        BRA     WRITEB.NONVT           b/ swapped, must reallocate pages

WRITEB.OKRTS
        OKRTS                   das ist alles
        page
WRITEB.DIRTYWORK ; DOES NASTY PART OF I/O FOR WRITE BINARY
; Exits withh (B) hold pointer to UCB
        LDX     CURRENTUCB
        JSR     ISITVIRTUAL             accomodate vt, if vt
        LBEQ    SYSCALL$                B/ not vt, just do it
        CLR     UCB:USERCPUBOUND,X      be nice to guys who do terminal I/O
        LDD     #SYSCALL:CONTROL##8+SCBLK:DATA turn "writeb" into "cc:writebnowait"
        STD     SCBLK:OPCODE,X
        LDAA    #CC:WRITEBNOWAIT
        STAA    SCBLK:PARAMS+1,X
        LDD     CURRENTUCB
        ADDD    #SCBLK:DATA             put the done flag and error code in the scb
        STD     SCBLK:RDBUF,X
        LDD     #3
        STD     SCBLK:RDLEN,X
        JSR     SYSCALL$
        LDX     CURRENTUCB              no error during I/O
        LDA     SCBLK:DATA,X            see if VT driver took all the data
        BEQ     WRITEB.DIRTYWORK.5      b/ no, go put user to sleep
        LDX     SCBLK:DATA+1,X          yes, get error code
        BEQ     WRITEB.DIRTYWORK.3      b/ no error, get out!
WRITEB.DIRTYWORK.5 ; stick user into output wait queue
        LDD     CURRENTUCB
        JSR     ADDOUTPUTQ
        JSR     SAVEPLACE
        jsr     returnlineflags
        ldx     currentucb              for convenience of caller
        clc                             signal success
WRITEB.DIRTYWORK.3 ; assert: Carry bit is Reset, here...
        RTS
        PAGE    CREATELOG & CLOSELOG
CREATELOG
        LDX     CURRENTUCB
        LDA     UCB:LOGCHANNEL,X       is it open, already?
        JSR     ISCHANNELCLOSED        bomb out if not closed
        BSR     DOCREATELOG
        BCS     CREATELOG.ERR2
        JMP     RETURNSCANNED
        OKRTS

CREATELOG.ERR2

; got an error and log wasn't created, so get rid of the channel

        STX     TSTEMP
        LDX     CURRENTUCB
        LDA     UCB:LOGCHANNEL,X
        LDB     #$FF
        STB     UCB:LOGCHANNEL,X
        JSR     RELEASEREALCHANNEL
        BCS     CREATELOG.DONTCARE
CREATELOG.DONTCARE
        LDX     TSTEMP
        JMP     OPEN.ERR1
        PAGE
docreatelog
        jsr     fnamesetup             go get the device/file name
        jsr     wasconsolerequested
        bcc     docreatelog.2          b/ yes-- this is going to be easy
docreatelog.1 ; entry point for JC:CREATE
        jsr     allocaterealchannel    sigh...
        sta     ucb:logchannel,x
        sta     scblk:params,x
        ldd     #syscall:create##8!create:sclen
        std     scblk:opcode,x
        jsr     syscall$               go do the create
        jmp     checkdevtyp            now that it's open, record its type

docreatelog.2
        lda     ucb:lfchan,x           this is the real console
        sta     ucb:logchannel,x
        okrts

CLOSELOG
        LDX     CURRENTUCB
        LDA     UCB:LOGCHANNEL,X
        LDB     #$FF
        STB     UCB:LOGCHANNEL,X
        jsr     ischannelopen
        JMP     RELEASEREALCHANNEL

CONTROL.ERR3
        JSR     ERRET
        #ERR:NOTUNDERTIMESHARE

CONTROL.ERR1
        JSR     ERRET
        #ERR:WRBUFTOOBIG
        PAGE    CONTROL & STATUS
CONTROL ; Execute SYSCALL:CONTROL for user
        JSR     GETCHANNEL      translate virtual channel to real
        JSR     ISITVIRTUAL     VT cc:killenable and cc:killdisable not allowed
        BEQ     CONTROL.3       b/ not VT
        LDX     CURRENTUCB
        LDAA    SCBLK:PARAMS+1,X
        CMPA    #CC:KILLPROOF
        BEQ     CONTROL.ERR3
        CMPA    #CC:KILLENABLE
        BEQ     CONTROL.ERR3
CONTROL.3
        JSR     DOWELOG
        BEQ     CONTROL.2       b/ no logging
        STAA    SCBLK:PARAMS,X  control log channel
CONTROL.2
        LDAA    SCBLK:WLEN,X    see if syscall block contains write buffer
        ANDA    #%01111111
        CMPA    #SCBLK:WRLEN+2
        BLO     CONTROL.0       B/ no write buffer (also, no reply buffer!)
        LDD     SCBLK:WRLEN,X   see if buffer too large
        CMPD    #256
        BHI     CONTROL.ERR1    B/ too big--too bad!!
        LDD     SCBLK:WRBUF,X   remember user's write buffer
        STD     UCB:USERWRBUF,X
        JSR     ALLOCATE1PAGE   get page and establish WRBUF
        LDX     CURRENTUCB
        LDAA    PAGEBASE
        CLRB
        STD     SCBLK:WRBUF,X
        IF      M6809
        TFR     D,Y
        ELSE
        STD     TEMPX
        FIN
        LDD     SCBLK:WRLEN,X
        LDX     UCB:USERWRBUF,X
        JSR     COPYTOSYSTEM   copy Userspace WRBUF contents to system space
        LDX     CURRENTUCB
        page
        LDAA    SCBLK:WLEN,X    see if syscall block contains read buffer
        ANDA    #%01111111
        CMPA    #SCBLK:RDLEN+2
        BLO     control.0       B/ no read buffer, no reply expected
        LDD     SCBLK:RDLEN,X   see if read buffer too large
        CMPD    #256
        BLS     control.1       B/ buffer is one page or less
        LDD     #256
        STD     SCBLK:RDLEN,X   reduce the buffer to one page
control.1
        LDD     SCBLK:RDBUF,X
        STD     UCB:USERRDBUF,X save user's read buffer
        JSR     ALLOCATE1PAGE   go get room for reply
        LDX     CURRENTUCB
        LDAA    PAGEBASE
        CLRB
        STD     SCBLK:RDBUF,X
control.0 ; (BLASTOFF!) now execute the control call
        LDX     CURRENTUCB      do syscall
        JSR     SYSCALL$
        BCC     RDBUFTOUSER     copy reply back to user
        stx     lasterror       save the error code
        bsr     rdbuftouser     move response back to user space
        ldx     lasterror       grab error code again
        CPX     #ERR:FILEISOPEN maybe the errmsgs file is causing this
        BNE     control.errored (and then, again, maybe it isn't)
        LDX     CURRENTUCB      this can happen when doing a CC:DISMOUNT
        LDAA    SCBLK:PARAMS+1,X
        CMPA    #CC:DISMOUNTDISK
        BNE     control.ERRORED but, then, if it isn't dismount, I don't care
        LDX     #CLOSEERRMSGS   get this out of the way and retry the dismount
        JSR     SYSCALL$
        BCC     CONTROL.0       try the CC:DISMOUNT, again
control.errored
        jmp     errored         must have been err:closed...ah, well...
        PAGE
RDBUFTOUSER ; copy the reply buffer back to the user space
        LDX     CURRENTUCB
        LDAA    SCBLK:WLEN,X           get syscall block length
        ANDA    #%01111111             mask off WAIT flag
        CMPA    #SCBLK:RPLEN+2         is SCBLK long enough for RPLEN ?
        BLO     RDBUFTOUSER.EXIT       b/ no, don't return RPLEN
        IF      M6809
        LDY     UCB:USERRDBUF,X
        ELSE
        LDD     UCB:USERRDBUF,X
        STD     TEMPX
        FIN
        LDD     SCBLK:RPLEN,X
        BEQD    RDBUFTOUSER.EXIT       get out of here if rplen=0
        LDX     SCBLK:RDBUF,X
        JSR     COPYTOUSER
RDBUFTOUSER.EXIT
        OKRTS
        PAGE
; caveat: if the caller's RDLEN > 256 then it is reduced to 256, giving
; SDOS the opportunity to reject the buffer as too small (which is probably
; not the case)

STATUS ; execute Userspace SYSCALL:STATUS
        JSR     GETCHANNEL      translate virtual channel to real
        JSR     DOWELOG
        BEQ     STATUS.2        B/ the answer is "we're not"
        STAA    SCBLK:PARAMS,X  get status of log channel
STATUS.2
        LDAA    SCBLK:WLEN,X    see if syscall block contains write buffer
        ANDA    #%01111111
        CMPA    #SCBLK:WRLEN+2
        BLO     STATUS.1        B/ no write buffer (also, no reply buffer!)
        LDD     SCBLK:WRLEN,X   see if buffer too large
        CMPD    #256
        LBHI    CONTROL.ERR1    B/ too big--too bad!!
        LDD     SCBLK:WRBUF,X   remember user's write buffer
        STD     UCB:USERWRBUF,X
        JSR     ALLOCATE1PAGE   get page and move user's write buffer over
        LDX     CURRENTUCB
        LDAA    PAGEBASE
        CLRB
        STD     SCBLK:WRBUF,X
        IF      M6809
        TFR     D,Y
        ELSE
        STD     TEMPX
        FIN
        LDD     SCBLK:WRLEN,X
        LDX     UCB:USERWRBUF,X
        JSR     COPYTOSYSTEM    fetch Userspace WRBUF data to system space
        LDX     CURRENTUCB      do syscall
        LDAA    SCBLK:WLEN,X    see if syscall block contains read buffer
        ANDA    #%01111111
        CMPA    #SCBLK:RDLEN+2
        BCS     STATUS.1        B/ no read buffer, no reply expected
        LDD     SCBLK:RDLEN,X   see if read buffer too large
        CMPD    #256
        BLS     STATUS.3        B/ buffer is one page or less
        LDD     #256
        STD     SCBLK:RDLEN,X   reduce the buffer to one page
STATUS.3
        LDD     SCBLK:RDBUF,X
        STD     UCB:USERRDBUF,X save user's read buffer
        JSR     ALLOCATE1PAGE   go get room for reply
        LDX     CURRENTUCB
        LDAA    PAGEBASE
        CLRB
        STD     SCBLK:RDBUF,X
STATUS.1 ; reply buffer has been established
        JSR     SYSCALL$        do syscall
        LBCC    RDBUFTOUSER     copy read buffer to user space
        STX     LASTERROR       got an error, copy reply back
        JSR     RDBUFTOUSER
        JMP     ERRORED
        PAGE    ERROREXIT & EXIT
*       EXIT syscall stuffs a CHAIN syscall block and a call referencing it
*       into the user space and then forces the user's PC to that syscall.
*       EXIT sets the LASTERROR to 0.  ERROREXIT does the same as EXIT, but
*       sets LASTERROR to the error number supplied as a parameter to the
*       syscall.

EXIT ; Execute SYSCALL:EXIT for user
        LDX     #0      set LASTERROR to 0
        STX     USERLASTERROR
        BRA     EXIT2

ERROREXIT ; Execute SYSCALL:ERROREXIT for user
        LDX     CURRENTUCB
        LDX     SCBLK:PARAMS,X  get user supplied error code
EXIT1   STX     USERLASTERROR
        JSR     DERRCR          put error out on user's console
EXIT2   JSR     RELEASEALLPAGES make sure no loose ends
        LDS     #SDOSMTSTACK-(&M6809) set up fresh stack pointer, just to be safe
        LDD     #FIREBREAK      in case of disaster
        PSHD
        BSR     EXIT.CHECKSUM   make sure memory hasn't flaked out
        JSR     KILLENABLE      killenable, in case user disabled
        BCS     *+2             B/ I don't care!
        IF      M6809
        LDY     #USERSPACEEXIT
        ELSE
        LDX     #USERSPACEEXIT
        STX     TEMPX
        FIN
        LDX     #USERSPACEEXITSTUFF
        LDD     #USERSPACEEXITSTUFFLEN
EXIT4   JSR     COPYTOUSER
        JSR     INITUSERSTACK
        JMP     SYSCALLEXIT.1
        page
EXIT.CHECKSUM
        LDD     #MTCHKSUMSIZE
        STAA    TEMPA
        LDX     #MTCHKSUMBASE
        CLRA
CKSUMLOOP
        ASLA
        ADCA    0,X
        INX
        DECB
        BNE     CKSUMLOOP
        DEC     TEMPA
        BPL     CKSUMLOOP
        TSTA
        BNE     EXIT.CHKSUM
        OKRTS

EXIT.CHKSUM
        JSR     ERRET
        #ERR:SELFTESTCKSUM
        PAGE
USERSPACEEXITSTUFF
USERSPACEEXIT   EQU     $100
        LDX     #USERSPACECHAIN
        JSR     SYSCALL$
        BCC     *                      should never get here!!
        CPX     #ERR:NOSUCHPROGRAM     No DEFAULTPROGRAM ?
        BNE     USERSPACEEXIT.SHOWERROR b/ no, something else awful
        LDX     #USERSPACEOPENDISK     Open the default disk
        JSR     SYSCALL$
        BCS     USERSPACEEXIT.SHOWERROR b/ this failed???
        LDX     #USERSPACEDISMOUNTDISK ...then dismount it, allowing user
        JSR     SYSCALL$               to insert another with DEFAULTPROGRAM
        BCS     USERSPACEEXIT.SHOWERROR b/ this failed???
        LDX     #ERR:NODEFAULTPROGRAM  Yes, be specific with error code
USERSPACEEXIT.SHOWERROR ; (X) has error code
        STX     USERSPACEERROREXIT+SCBLK:PARAMS
        LDX     #USERSPACEERROREXIT
        JMP     SYSCALL$

USERSPACECHAIN  EQU     *-USERSPACEEXITSTUFF+USERSPACEEXIT
        FCB     SYSCALL:CHAIN,CHAIN:SCLEN,IGNORED,IGNORED
        FDB     DEFAULTPROG,DEFAULTPROGL
        FDB     CHANGED,USERSPACEREPLYBUF,4

USERSPACEERROREXIT      EQU     *-USERSPACEEXITSTUFF+USERSPACEEXIT
        FCB     SYSCALL:ERROREXIT,ERROREXIT:SCLEN,CHANGED,CHANGED

USERSPACEREPLYBUF EQU   *-USERSPACEEXITSTUFF+USERSPACEEXIT
        FDB     $0000,$0000     values are changed after placement in Userspace

DEFAULTPROG     EQU     *-USERSPACEEXITSTUFF+USERSPACEEXIT
DEFAULTPROG:
        FCC     'DEFAULTPROGRAM'
DEFAULTPROGL    EQU     *-DEFAULTPROG:

USERSPACEOPENDISK EQU  *-USERSPACEEXITSTUFF+USERSPACEEXIT
        FCB     SYSCALL:OPEN,OPEN:SCLEN,1,0
        FDB     DISK:,DISK:LENGTH
        FDB     CHANGED
        FDB     USERSPACEREPLYBUF,2

DISK:   EQU     *-USERSPACEEXITSTUFF+USERSPACEEXIT
        FCC     'DISK:'
DISK:LENGTH EQU (*-USERSPACEEXITSTUFF+USERSPACEEXIT)-DISK:

USERSPACEDISMOUNTDISK EQU *-USERSPACEEXITSTUFF+USERSPACEEXIT
        FCB     SYSCALL:CONTROL,CONTROL:SCLEN
        FCB     1,CC:DISMOUNTDISK

USERSPACEEXITSTUFFLEN   EQU     *-USERSPACEEXITSTUFF
        PAGE    SET ERROR & GET ERROR
SETERROR ; Execute SYSCALL:SETERROR for user
        LDX     CURRENTUCB
        LDX     SCBLK:PARAMS,X
        STX     USERLASTERROR
        OKRTS                          ta daaa!!

GETERROR ; Execute SYSCALL:GETERROR for user
        JSR     CHECKRDLEN
        #2
        LDX     CURRENTUCB
        LDX     SCBLK:RDBUF,X
        LDD     USERLASTERROR
        JSR     COPYDTOUSER
        OKRTS
        PAGE    KILLPROOF & KILLENABLE
KILLPROOF ; Execute SYSCALL:KILLPROOF for user
        JSR     GETUSERLFCHANNEL       get line flags channel
        LDAB    #1                     remember this user is killproof
        STAB    UCB:KILLPROOF,X
        CMPA    #$FF                   is LF channel allocated ?
        BEQ     KILLPROOF.OKRTS        b/ background job, don't do syscall
        LDX     #SETKILLPROOF
        STAA    SCBLK:PARAMS,X
        JSR     SYSCALL$
KILLPROOF.OKRTS ; no LF channel, do nothing
        OKRTS

KILLENABLE ; Execute SYSCALL:KILLENABLE for user
        JSR     GETUSERLFCHANNEL       get line flags channel
        CLR     UCB:KILLPROOF,X        remember that user is kill-enabled
        CMPA    #$FF                   is LF channel allocated ?
        BEQ     KILLENABLE.1           b/ background job, don't do syscall
        LDX     #CLEARKILLPROOF
        STAA    SCBLK:PARAMS,X
        JSR     SYSCALL$
        ; since I don't know what to do if an error occurs, I do nothing.
KILLENABLE.1
        LDX     CURRENTUCB             check user state
        LDAA    UCB:JOBSTATE,X         did someone direct a kill request...
        CMPA    #JS:DYING              at this job sometime in the past ?
        BNE     KILLENABLE.OKRTS       b/ no, just leave
        JMP     JOBCONTROL.MERCYKILLING b/ yes, make job die!

KILLENABLE.OKRTS
        OKRTS

        PAGE    ERROR DISPLAY
*       DERR -- DISPLAY "USERLASTERROR" ON THE CONSOLE...
*       AS EITHER AN ERROR STRING FROM THE ERRORMSGS.SYS FILE
*       OR AS "ERROR ddddd" IF WE CAN'T GET TO ERRORMSGS.SYS SOMEHOW
*       IF WE CANNOT PRINT THE ERROR MESSAGE, CROAK AND DIE!
*
DERRCR  ; tack a CR on the end of the error message
        INC     DERRCRFLAG
DERR
        LDX     USERLASTERROR   DO IT NOW, IN CASE OF ERROR WHILE
        STX     ERRORNUMBER     PROCESSING THIS ERROR
        JSR     OPENCONSOLE     MAKE SURE WE CAN OUTPUT THE ERROR MESSAGE
        lda     ucb:chan0,x     IS CONSOLE: REALLY OPEN ?
        JSR     ISCHANNELOPEN
        BCS     DERR.CANT       B/ no, job is in trouble !
        JSR     SETUPBUFFER     set up buffer housekeeping
        LDX     ERRORNUMBER     omit error 0
        BNE     DE.3
        CLR     DERRCRFLAG
        OKRTS

DERR.CANT ; can't display error message
        ldx     currentucb
        lda     #js:dying       so kill the job as desperation measure
        sta     ucb:jobstate,x
        okrts
        PAGE
*
*       POSITION TO THE ERROR MESSAGE POINTER
*       = 3 * ERROR NUMBER
*
DE.3
        LDX     #DISPPOS1
        CLR     1,X     (0,X IS ASSEMBLED AS A ZERO!)
        LDAA    ERRORNUMBER
        LDAB    ERRORNUMBER+1
        ASLB            *2
        ROLA
        ROL     1,X
        ADDB    ERRORNUMBER+1   *3
        ADCA    ERRORNUMBER
        BCC     DERR0
        INC     1,X
DERR0
        STAB    3,X
        STAA    2,X
        LDX     #DISPPOS        NOW POSITION ERRORMSGS.SYS FILE...
        JSR     SYSCALL$        TO THE ERROR MESSAGE STRING POINTER
        BCC     DERR.2
        CPX     #ERR:CLOSED     open the file if it's closed
        BNE     DERR4   otherwise, skip the English message
        LDX     #OPENERRMSGS
        JSR     SYSCALL$
        BCS     DERR4   B/ OOPS, SOME PROBLEM OCCURRED
        BRA     DE.3            go try the position again
        PAGE
DERR.2  
        LDX     #DISPREADB3     READ IN THE STRING ADDRESS
        JSR     SYSCALL$
        BCS     DERR4
        LDX     DISPPOS1+2      IS THE ERROR MSG IN THE FILE?
        BNE     DERR1A  B/ YUP
        LDAA    DISPPOS1+1      ...?
        BEQ     DERR4   B/ NO, PRINT THE ERROR CODE THE HARD WAY
DERR1A  
        LDX     #DISPPOS        POSITION TO THE STRING
        JSR     SYSCALL$
        BCS     DERR4   B/ ERROR
*
*       COPY THE STRING TO CHANNEL 0
*
DERR1
        LDAA    #255    upper limit on length of message
        STAA    TSTEMP
        LDX     #DISPGETCHAR
        JSR     SYSCALL$
        BCS     DERR4
        LDAA    BUFFER
        CMPA    #ASCII:CR
        LBEQ    DE.8.3  B/ I'M DONE!
        DEC     TSTEMP
        LBEQ    DE.8.3
        JSR     STUFFINBUFFER
        BRA     DERR1
        PAGE
*       AN ERROR WAS DETECTED WHILE TRYING TO PRINT AN ERROR STRING
*       IGNORE THE ERROR, AND ATTEMPT TO PRINT "ERROR <ERRORNUMBER>" INSTEAD
*       (IN DECIMAL FORMAT)
*
DERR4
        LDAA    #DISPERRORMSGL  stuff canned message into write buffer
        STAA    TSTEMP
        LDX     #DISPERRORMSG
        JSR     COPYTOBUFFER
        LDAB    #16     (16 BITS TO CONVERT)
        LDX     #DECBUF CONVERT 16 BITS BINARY TO 3 DIGITS BCD
        CLR     0,X
        CLR     1,X
        CLR     2,X
DERR5
        ASL     ERRORNUMBER-DECBUF+1,X
        ROL     ERRORNUMBER-DECBUF,X
        LDAA    2,X
        ADCA    2,X
        DAA
        STAA    2,X
        LDAA    1,X
        ADCA    1,X
        DAA
        STAA    1,X
        LDAA    0,X
        ADCA    0,X
        DAA
        STAA    0,X
        DECB
        BNE     DERR5
        LDAB    #3      (3 BYTES OF BCD)
DERR6
        LDAA    2,X
        ANDA    #$F
        PSHA
        LDAA    2,X
        LSRA
        LSRA
        LSRA
        LSRA
        ANDA    #$F
        PSHA
        DEX
        DECB
        BNE     DERR6
        LDX     #STRINGBUFFER
        LDAA    #'0
        STAA    0,X
        LDAB    #6      (6 BYTES ON THE STACK)
DERR7
        PULA
        DECB
        BEQ     DERR9   B/ NO MORE (THEY WERE ALL ZERO)
        TSTA
        BEQ     DERR7   B/ ZERO SUPPRESS
DERR9   INCB
        BRA     DE.8.1
        PAGE
DERR8   PULA
DE.8.1  ADDA    #'0
        STAA    0,X
        INX
        DECB
        BNE     DERR8
        DEX
        STX     TEMPX   COMPUTE LENGTH OF THE STRING (ALWAYS < 256)
        LDAB    TEMPX+1
        SUBB    #(STRINGBUFFER&$FF)-1
        STAB    TSTEMP
        LDX     #STRINGBUFFER
        JSR     COPYTOBUFFER
DE.8.3  TST     DERRCRFLAG      see if CR wanted on end of error message
        BEQ     DE.8.2
        CLR     DERRCRFLAG
        LDAA    #ASCII:CR
        BSR     STUFFINBUFFER
DE.8.2  JSR     WRITEAFROMSYSTEMSPACE   go for it!!
        BCS     DE.8.2.0        b/ owtch!
        OKRTS

DE.8.2.0
        JSR     GETUSERLFCHANNEL       does user have an LFCHAN ?
        LBEQ    DERR.CANT       b/ no, --> no way to display error from here
        JSR     CLOSECHANNEL0   get rid of the console: might be the problem
        BCS     *+2             ignore error if channel 0 already closed
        JSR     CLOSELOG        same goes for the log
        BCS     *+2             eat any error that happens
        JSR     OPENCONSOLE     get the real thing back!
DE.8.2.3
        JSR     WRITEAFROMSYSTEMSPACE  try again
        BCS     DE.8.2.2        b/ I give up!
        OKRTS

DE.8.2.2
        CPX     #ERR:PROGRAMKILLED      handle obscurata
        BEQ     DE.8.2.3
        JSR     GOCATATONIC
        PAGE
SETUPBUFFER
        LDX     CURRENTUCB
        LDAA    #SYSCALL:WRITEA         construct a WRITA syscall block
        STAA    SCBLK:OPCODE,X
        LDAA    #WRITEA:SCLEN
        STAA    SCBLK:WLEN,X
        JSR     ALLOCATE1PAGE           error message is 255 bytes max!
        LDX     CURRENTUCB
        LDAA    NPAGES
        STAA    UCB:BUFFERSIZE,X
        LDAA    PAGEBASE
        STAA    UCB:BUFFER,X
        STAA    POINTERINBUFFER
        STAA    SCBLK:WRBUF,X
        CLR     POINTERINBUFFER+1
        CLR     SCBLK:WRBUF+1,X
        CLR     SCBLK:WRLEN,X
        CLR     SCBLK:WRLEN+1,X
        lda     ucb:chan0,x
        STA     SCBLK:PARAMS,X
        OKRTS

STUFFINBUFFER
        LDX     POINTERINBUFFER guess what this routine does??
        STA     ,X+
        STX     POINTERINBUFFER
        LDX     CURRENTUCB
        INC     SCBLK:WRLEN+1,X byte count will never exceed 255!
        RTS
        PAGE
COPYTOBUFFER
        LDAA    0,X     copy (X) -> string to buffer
        INX
        STX     TEMPX
        BSR     STUFFINBUFFER
        LDX     TEMPX
        DEC     TSTEMP
        BNE     COPYTOBUFFER
        RTS

DISPERRORMSG    FCC     'Error '
DISPERRORMSGL   EQU     *-DISPERRORMSG

ERRMSGFNE       FCC     'ERRORMSGS.SYS'
ERRMSGFNEL      EQU     *-ERRMSGFNE

DISPPOS ; USED TO POSITION ERRORMSGS.SYS FILE
        FCB     SYSCALL:CONTROL,CONTROL:SCLEN+4,ERRMSGCHANNEL,CC:POSITION
        FDB     DISPPOS1,4      wrbuf, wrlen
        PAGE
openconsole ; make sure that channel 0 is open.
; If not, then open it to the console
        ldx     currentucb
        lda     ucb:chan0,x
        cmpa    #$ff                   is channel 0 closed?
        bne     openconsole.2          b/ no-- its already open
        lda     ucb:lfchan,x           open channel 0 to the real thing
        sta     ucb:chan0,x
openconsole.2
        rts
        page
closechannel0 ; make sure that channel 0 is closed.
; then release whatever was attached to channel 0
; Note: LineFlags channel ALWAYS stays open!
        ldx     currentucb
        ldb     #$ff
        lda     ucb:chan0,x
        stb     ucb:chan0,x
        jsr     ischannelopen          if channel not open, don't release it!
        jsr     releaserealchannel
        bcs     *+2                    don't care if error occurs
        okrts

ResetLFchannel ; reset LineFlags channel
; Force LF channel closed, and then re-open to clear EOF status
; Note: This is ONLY place LF channel is ever closed,
; and this happens only momentarily.
; Assert: this routine is never called if this job is a background job.
        jsr     getuserlfchannel
        beq     ResetLFchannel.okrts    b/ no lf channel, we're all done
        sta     scblk:params+closelogchan
        sta     scblk:params+openlfchan
        ldx     #closelogchan
        jsr     syscall$
        bcc     ResetLFchannel1        b/ no error
        cpx     #Err:Closed            is LF channel closed ?
        ; ignore all other (i.e., I/O) errors which occur on close
        bne     ResetLFChannelCatatonic b/ LF channel not open, something is very sick
ResetLFchannel1 ; now re-open LF channel
        ldd     currentucb
        addd    #ucb:consolestr
        std     openlfchan+scblk:wrbuf
        ldd     #8                      length of port names in UCB
        std     openlfchan+scblk:wrlen
        ldx     #openlfchan
        jsr     syscall$
        bcs     ResetLFChannelCatatonic can't open, something is very sick
ResetLFchannel.okrts
        ldx     currentucb             for convenience of caller
        okrts

ResetLFChannelCatatonic ; can't open/close LF channel something is very sick
        jsr     GoCatatonic
        PAGE
*       CHECKRDLEN -- CHECK SCBLK:RDLEN...
*       TO MAKE SURE ITS VALUE >= 2 BYTES AT RETURN ADDRESS
*       ALSO CHECKS THAT SYSCALL BLOCK IS LONG ENOUGH TO INCLUDE SCBLK:RDLEN
*       (X) = CURRENTUCB ON EXIT
*       SKIPS AROUND 2 BYTE INLINE VALUE IF OK; ELSE ERROREXIT
*
CHECKRDLEN      
        LDX     CURRENTUCB      CHECK THAT READ DATA BUFFER IS INCLUDED...
        LDAA    SCBLK:WLEN,X    IN THE SYSCALL BLOCK
        ANDA    #$7F    BYEBYE WAIT BIT
        CMPA    #SCBLK:RDLEN+2  IS SYSCALL BLOCK LONG ENOUGH ?
        BCS     ERRSYSTOOSHORTJ B/ NOPE, STICK THE USER WITH AN ERROR
        LDD     [0,S]           IS RDLEN >= MINLENGTH ?
;                               I.E., IS 0 > MINLENGTH-RDLEN-1 ?
        SEC                     (-1 PART)
        LDX     CURRENTUCB      SUBTRACT RDLEN
        SBCB    SCBLK:RDLEN+1,X
        SBCA    SCBLK:RDLEN,X
        BCC     ERRRDBUFTOOSMALL        B/ NO, NOT ENOUGH READ BUFFER
        ADCB    SCBLK:RDLEN+1,X SET REPLY LENGTH = DESIRED # BYTES
        ADCA    SCBLK:RDLEN,X   (A,B):=DESIRED # BYTES
        STAA    SCBLK:RPLEN,X   RPLEN:=(A,B)
        STAB    SCBLK:RPLEN+1,X
        LDD     SCBLK:RDBUF,X   remember the user's buffer
        STD     UCB:USERRDBUF,X
        LDD     SCBLK:RDLEN,X   and its length
        STD     UCB:USERRDLEN,X
        CLR     UCB:USERRPLEN,X
        CLR     UCB:USERRPLEN+1,X
CHECKRDLEN1     
        TSX             ALL IS OK, TAKE SKIP EXIT
        LDAA    1,X     BUMP RETURN PAST INLINE ARGUMENT
        ADDA    #2      =2 BYTES IN SIZE
        STAA    1,X
        BCC     CHECKRDLEN2
        INC     0,X
CHECKRDLEN2     
        LDX     CURRENTUCB
        OKRTS

ERRSYSTOOSHORTJ 
        JMP     ERRSYSCALLTOOSHORT

ERRRDBUFTOOSMALL        
        JSR     ERRET
        FDB     ERR:RDBUFTOOSMALL
        PAGE
*       CHECKWRLEN -- CHECK SCBLK:WRLEN...
*       TO MAKE SURE ITS VALUE >= 2 BYTES AT RETURN ADDRESS
*       ERROR EXIT IF NOT
*       RETURNS WITH (X) CONTAINING CURRENTUCB OTHERWISE
*       SKIPS AROUND 2 BYTE INLINE VALUE

CHECKWRLEN      
        LDX     CURRENTUCB      CHECK THAT WRBUF INFO IS INCLUDED...
        LDAA    SCBLK:WLEN,X    IN THE SYSCALL
        ANDA    #$7F    BYEBYE WAIT BIT
        CMPA    #SCBLK:WRLEN+2  SYSCALL BLOCK LONG ENOUGH ?
        BCS     ERRSYSTOOSHORTJ B/ NO, GO STICK IT TO THE USER
        LDD     [0,S]           IS WRLEN >= MINLENGTH ?
;                               I.E., IS 0 > MINLENGTH - WRLEN -1 ?
        SEC                     (-1 PART)
        LDX     CURRENTUCB      NOW SUBTRACT WRLEN
        SBCB    SCBLK:WRLEN+1,X
        SBCA    SCBLK:WRLEN,X
        BCC     ERRWRBUFTOOSMALL        B/ go bitch about it!!
        LDD     SCBLK:WRBUF,X   remember user's buffer
        STD     UCB:USERWRBUF,X
        LDD     SCBLK:WRLEN,X   and its length
        STD     UCB:USERWRLEN,X
        BRA     CHECKRDLEN1     go for common exit
ERRWRBUFTOOSMALL        
        JSR     ERRET
        FDB     ERR:WRBUFTOOSMALL
        PAGE    ATTNCHECK
*       An error return is made only if channel 0 is attached to virtual
*       console device and an attention is outstanding.

ATTNCHECK
        BSR     ISCONSOLE       see if it's even possible to get an attn
        BCS     ATTNCHECK.9     B/ I thought not!
        LDX     #ATTENTIONCK
        JMP     SYSCALL$        go ask if attention outstanding

ATTNCHECK.9
        OKRTS
        PAGE    ISCONSOLE
isconsole ; see if channel 0 is open to the user's console (the real console)
        ldx     currentucb
        lda     ucb:chan0,x
        jsr     ischannelopen
        cmpa    ucb:lfchan,x           is it open to the console
        bne     isconsole.2            b/ no-- something else
        sta     attentionck+scblk:params (for use of attentionck syscall)
        okrts

isconsole.2
        jsr     erret
        #err:notopentoconsole
        page    Interlock
interlock

; implement INTERLOCK syscall for SDOS/MT

        ldx     currentucb
        ldd     scblk:params,x
        cmpb    #ic:create
        lbeq    ilk.create
        cmpb    #ic:destroy
        lbeq    ilk.destroy
        cmpb    #ic:lock
        lbeq    ilk.lock
        cmpb    #ic:release
        lbeq    ilk.release
        cmpb    #ic:test
        lbeq    ilk.lockifavail
        cmpb    #ic:reset
        lbeq    ilk.reset
        jsr     erret
        #err:illegalinterlockfunction
        page
ilk.matchcap

; match the capability in targetcap with the capability named in (x)
; return with cc set to = or <>

        ldab    #16
        stx     tempx
        ldx     #targetcap
ilk.matchcap.1
        ldaa    0,x
        inx
        stx     tempx+2
        ldx     tempx
        cmpa    0,x
        bne     ilk.matchcap.2
        inx
        stx     tempx
        ldx     tempx+2
        decb
        bne     ilk.matchcap.1
ilk.matchcap.2
        rts
        page
ilk.addcap

; find a free slot in the capability table and move the capability in
; targetcap to that capability slot; return the slot in (a)

; err:implementationlimitreached may be returned if no more slots

        jsr     ilk.findcapslot
        jsr     ilk.resolveslot resolve slot in (a) to indices
        ldx     capmapx         allocate the slot
        ldd     #$0100          one reference, no queue
        std     capmap:refcount,x
        ldx     captablex
        ldab    #16
        stx     tempx
        ldx     #targetcap
ilk.addcap.1
        ldaa    0,x
        inx
        stx     tempx+2
        ldx     tempx
        staa    0,x
        inx
        stx     tempx
        ldx     tempx+2
        decb
        bne     ilk.addcap.1
        rts
        page
ilk.resolveslot

; resolve (a)=slot number to correct capmapx, captablex

        sta     capslot         this will be used later, too
        asla
        sta     capmapx+1       map index is 2x slot number
        asla
        asla
        asla
        sta     captablex+1     slot index is 16x slot number
        lda     #captable/512   allow for carry
        rola
        sta     captablex
        rts
        page
ilk.findcapslot

; find a free slot in the capability table
; return (a) -> slot number; return err:implementationlimitreached
; if no more slots 

        ldx     #capmap+31*2
        lda     #31
ilk.findcapslot.2
        tst     0,x
        beq     ilk.findcapslot.1
        dex
        dex
        deca
        bpl     ilk.findcapslot.2
        jsr     erret
        #err:implementationlimitreached

ilk.findcapslot.1
        okrts
        page
ilk.findcap

; find a match to the target capability, returning the matching slot number
; in (a), or err:notlocked when no match is made

        ldaa    #31
ilk.findcap.1
        psha
        jsr     ilk.resolveslot
        ldx     captablex
        jsr     ilk.matchcap
        beq     ilk.findcap.2
        pula
        deca
        bpl     ilk.findcap.1
        jsr     erret
        #err:notlocked

ilk.findcap.2
        pula
        ldx     capmapx                 the capabilities match, but is it
        tst     capmap:refcount,x       locked?
        bne     ilk.findcap.3           B/ apparently so
        deca                            oh well...go look again
        bra     ilk.findcap.1

ilk.findcap.3
        okrts
        page
ilk.block

; block the caller if he is not the first one locking the object

        ldx     capmapx                 count a lock
        inc     capmap:refcount,x
        lda     capmap:refcount,x
        cmpa    #1                      if he is the only reference,
        bne     ilk.block.1             he doesn't get blocked
        okrts

ilk.block.1
        clrb                            he's going on the queue for
        lda     capmap:queue,x          this object--see if there's one
        beq     ilk.block.2             B/ no queue--yet
        std     tempx                   point at ucb
        ldx     tempx
ilk.block.4
        tst     ucb:nextonq,x           see if this one's the last one
        beq     ilk.block.3             B/ sure is
        ldx     ucb:nextonq,x           look at the next ucb
        bra     ilk.block.4

ilk.block.2
        lda     currentucb              this one's now the head of the queue
        sta     capmap:queue,x
        bra     ilk.block.5             go block and return

ilk.block.3
        lda     currentucb              add this one to the end of the queue
        sta     ucb:nextonq,x
ilk.block.5
        jsr     saveplace               go away until unblocked
        okrts                           I must have been unblocked
        page
ilk.ctlc.unblock

; called when ^C^C hits a user; currentucb points at the ucb in question;
; if the user is in any of the interlock queues, he is removed, without
; altering the reference counts (subsequent use of ic:reset required), and
; added to the run queue; otherwise, nothing is done

        ldx     #capmap         look at all of the queues
ilk.cltc.unblock.1
        stx     capmapx
        bsr     ilk.ctlc.checkqueue
        bcc     ilk.ctlc.unblock.done
        ldx     capmapx
        inx
        inx
        cpx     #capmap+32*2    see if done
        bne     ilk.cltc.unblock.1
ilk.ctlc.unblock.done
        rts
        page
ilk.ctlc.checkqueue
        lda     capmap:queue,x
        beq     ilk.ctlc.checkerr
        clrb                            no prior in queue
        clr     tempx+1
ilk.ctlc.checkloop
        sta     tempx                   point at current
        ldx     tempx
        cmpa    currentucb              is he me?
        beq     ilk.ctlc.checkunq       b/ yup
        tab                             current becomes prior
        lda     ucb:nextonq,x           get the new current
        bne     ilk.ctlc.checkloop      b/ new current is valid--check him out
ilk.ctlc.checkerr
        errorrts                        not in this queue

ilk.ctlc.checkunq
        lda     ucb:nextonq,x           de-reference next ucb
        clr     ucb:nextonq,x
        tstb                            was prior the capmap?
        bne     ilk.ctlc.checkunq.1     b/ nope
        ldx     capmapx                 update the capmap entry
        sta     capmap:queue,x
        bra     ilk.ctlc.checkunq.2     found him!!  he's off the queue


ilk.ctlc.checkunq.1
        stb     tempx                   re-point the prior ucb
        ldx     tempx
        sta     ucb:nextonq,x
ilk.ctlc.checkunq.2
        lda     currentucb
        jsr     addrunq
        okrts
        page
ilk.unblock

; reduce the reference count of the named capability by 1; it it was
; zero, to start with, or doesn't exist, err:notlocked is returned;
; if it was one, to start with, then a simple return is made; otherwise,
; the first user enqueued upon the object is dequeued and put in the
; run queue

        stx     tstemp          save the unblock error code
        jsr     ilk.findcap     look up the capability
        ldx     capmapx         reduce the count
        dec     capmap:refcount,x
        bmi     ilk.unblock.1   B/ whoops--was zero
        bne     ilk.unblock.2   B/ must unblock a user
        okrts                   no users blocked

ilk.unblock.1
        inc     capmap:refcount,x       put the count back to zero
        jsr     erret           scream bloody murder
        #err:notlocked

ilk.unblock.2
        clrb                    pull a user off the head of the queue
        lda     capmap:queue,x
        bne     ilk.unblock.3   B/ queue exists
        okrts                   that's strange--no queue--oh, well...

ilk.unblock.3
        std     tempx
        ldx     tempx
        ldb     ucb:nextonq,x   unchain from the head of the queue
        clr     ucb:nextonq,x
        pshd
        ldd     tstemp          tell user what went wrong
        std     ucb:queueerr,x
        puld
        ldx     capmapx
        stb     capmap:queue,x
        clrb                    add user to run queue
        jsr     addrunq         (note: (d) contains UCB address)
        okrts                   all done
        page
ilk.validate

; Check that the capability is correctly formed.

; copy capability from userspace to targetcap

; this is where err:nosuchobject would be generated

        jsr     checkwrlen
        #16
        if      m6809
        ldy     #targetcap
        else
        ldd     #targetcap
        std     tempx
        fin
        ldx     currentucb
        ldx     scblk:wrbuf,x
        ldd     #16
        jsr     copytosystem
        okrts

        page
ilk.genrandom

; roll a 16-byte 'random' number, which will be used as the capability,
; for the time being

; call 'decrypt 8 bytes' twice, using the clock as the mudtext

        ldx     #ilkcap         use a YUKK decryption key
        jsr     setkey
        ldx     #ilkcap         decrypt 8 bytes at a time
        jsr     decrypt
        ldx     #ilkcap+8
        jmp     decrypt
        page
ilk.returncap

; return the capability to the user space

        ldx     currentucb
        if      m6809
        ldy     ucb:userrdbuf,x
        else
        ldd     ucb:userrdbuf,x
        std     tempx
        fin
        ldd     #16
        ldx     #ilkcap
        jsr     copytouser
        okrts
        page
ilk.create

; Create a capability to the object.  For the time being, a 16-byte random
; number is returned.

; If the object is invalid, err:nosuchobject will be returned.
; [full implementation, only]

        jsr     checkwrlen
        #16
        jsr     checkrdlen
        #16
        jsr     ilk.genrandom
        jsr     ilk.returncap
        okrts
        page
ilk.destroy

; Destroy the usefulness of capabilities to the object. Release all
; interlocks on the object; users enqueued for use of the object will be
; unblocked with err:objectdestroyed.

; If the capability is invalid, err:nosuchobject will be returned.
; [full implementation, only]

        jsr     ilk.validate
ilk.destroy.1
        ldx     #err:objectdestroyed
        jsr     ilk.unblock
        bcc     ilk.destroy.1
        cpx     #err:notlocked
        lbne    errorinx
        okrts
        page
ilk.lock

; Lock the object for the exclusive use of the caller.  If the object is
; not immediately available for the exclusive use of the caller, the caller
; is blocked until the object is available for his exclusive use.  
; err:implementationlimitreached will be returned if more than 32 objects
; are referenced.

; If the capability is invalid, err:nosuchobject will be returned.
; [full implementation, only]

        jsr     ilk.validate
        jsr     ilk.findcap
        bcs     ilk.lock.1
        jsr     ilk.block
        okrts

ilk.lock.1
        cpx     #err:notlocked
        lbne    errorinx
        jsr     ilk.addcap
        okrts
        page
ilk.release

; Release the object from the caller's exclusive use.  If the object has
; not been previously locked, err:notlocked is returned.

; If the capability is invalid, err:nosuchobject will be returned.
; [full implementation, only]

        jsr     ilk.validate
        ldx     #0
        jsr     ilk.unblock
        okrts
        page
ilk.lockifavail

; Lock the object for the exclusive use of the caller.  If the object is
; not immediately available for the exclusive use of the caller, no further
; action is taken and err:alreadylocked is returned.

; If the capability is invalid, err:nosuchobject will be returned.
; [full implementation, only]

        jsr     ilk.validate
        jsr     ilk.findcap
        bcs     ilk.lock.1
        jsr     erret
        #err:alreadylocked
        page
ilk.reset

; Unconditionally release all interlocks on the object; users enqueued for
; use of the object will be unblocked with err:lockreset.  If the object
; is not locked at all, err:notlocked will be returned.


; If the capability is invalid, err:nosuchobject will be returned.
; [full implementation, only]

        jsr     ilk.validate
        ldx     #err:lockreset
        jsr     ilk.unblock
ilk.reset.1
        ldx     #err:lockreset
        jsr     ilk.unblock
        bcc     ilk.reset.1
        cpx     #err:notlocked
        lbne    errorinx
        okrts
        PAGE    DELAY
DELAY
        LDX     CURRENTUCB
        LDD     SCBLK:PARAMS,X
        BEQD    DELAY.1
        STD     UCB:DELAY,X            set desired delay
        LDD     CURRENTUCB             put this one on ice
        JSR     ADDDELAYQ
        JSR     SAVEPLACE
DELAY.1
        OKRTS
         page  Get Serial Number for User
USERGETSERIALNUMBER ; Execute SYSCALL:GETSERIALNUMBER on behalf of user
         jsr   checkrdlen              ensure reply buffer is proper size
         fdb   8
; note: the following code should be part of a general
; routine that handles syscalls whose write and reply buffers are at most
; one page in size. Save for a rainy day.
         jsr   allocate1page           set up to execute the system call
         stb   scblk:rdbuf,x           remember where to place reply
         clr   scblk:rdbuf+1,x
         sta   scblk:rdlen,x
         clr   scblk:rdlen+1,x
         jsr   syscall$
         jmp   rdbuftouser             return results to user program
         page  SYSCALL:JOBCONTROL handling
*        SYSCALL:JOBCONTROL handler
*
*        Handles Job Control Syscalls, including subcodes:
*
*              JC:CREATE     Create a new job
*                                      WRBUF contains DO file name
*                                      SCBLK:EXTENSION contains LOG file name
*                                      RDBUF returns job capability
*
*              JC:TESTDONE   Test for job completion
*                                      WRBUF contains job capability
*                                      Signals ERR:NOSUCHJOB if complete
*
*              JC:DESTROY    Abort a job
*                                      WRBUF contains job capability
*
jobcontrol ; come here to handle SYSCALL:JOBCONTROL
         ldx   currentucb
         lda   scblk:params,x
         bne   errillegaljobcontrol    b/ params must be zero
         ldb   scblk:params+1,x
         cmpb  #jc:create
         lbeq  jc.create
         cmpb  #jc:testdone
         lbeq  jc.testdone
         cmpb  #jc:destroy
         lbeq  jc.destroy
errillegaljobcontrol
         jsr   erret
         #err:illegaljobcontrol
         page
jc.create ; come here to handle SYSCALL:JOBCONTROL with JC:CREATE
         jsr   checkrdlen              ensure that space for reply is present
         #16                           (also ensures that WRBUF is present)
jc.findfreejob ; loop to find a free job
         ldx   ucbchain                where to start
         stx   ucbpointer
jc.findfreejobloop
         ldx   ucbpointer              check job state
         lda   ucb:jobstate,x
         cmpa  #js:free                is job available for snatching ?
         beq   jc.foundfreejob         b/ yes, snatch it!
         lda   ucb:lfnext,x            find next ucb
         sta   ucbpointer
         bne   jc.findfreejobloop      b/ more jobs to inspect
         jsr   erret
         #err:nomorejobs

jc.foundfreejob ; job selected by ucbpointer is available for use
         ldd   currentucb              make new job be the current job awhile
         stx   currentucb
         std   ucbpointer              remember name of ucb initiating this
         addd  #scblk:data             form address of LOG file name
         std   scblk:wrbuf,x
         ldx   ucbpointer              get length of LOG file name
         ldb   scblk:wlen,x
         andb  #$7f                    mask off wait bit
         subb  #scblk:data             and remove scblk overhead
         clra                          form 16 bit length
         ldx   currentucb
         std   scblk:wrlen,x
         ldd   #namescannedcnt         set up reply buffer to make SDOS happy
         std   scblk:rdbuf,x
         ldd   #2
         std   scblk:rdlen,x
         jsr   wasconsolerequested     asking for CONSOLE: ?
         bcc   jc.createerrchanopen    b/ unreasonable thing to ask, here...
         jsr   docreatelog.1           set up the log file
         bcs   jc.createjoberr         b/ can't, abort this call!
         ldx   ucbpointer              set up SYSCALL:OPEN...
         ldd   scblk:wrlen,x
         ldx   scblk:wrbuf,x
         stx   tempx
         ldx   currentucb
         std   scblk:wrlen,x
         ldd   tempx
         std   scblk:wrbuf,x
         ldd   #syscall:open+open:sclen
         std   scblk:opcode,x
         clr   scblk:params,x          to open channel zero
         jsr   fnamesetup.1            go get the file name
         bcs   jc.createjoberr         b/ can't, abort this call!
         jsr   wasconsolerequested     can't DO user's console...
         bcc   jc.createerrchanopen    b/ DO CONSOLE: for another job !!???
         jsr   doopen.jc               open file to channel zero
         bcs   jc.createjoberr         b/ can't, abort this call!
         ldx   currentucb              successfully opened necessary channels
         lda   #js:busy                mark this job as busy
         sta   ucb:jobstate,x
         jsr   jc.setnewjobcapability  invent "new" capability for created job
         ldd   currentucb              put job into runnable state
         jsr   addrunq                 he will eventually wake up...
         ldd   ucbpointer              ucb of creating job
         std   currentucb              put world back like it belongs
         jsr   ilk.returncap           and give it back to the user
         okrts

jc.createerrchanopen ; CONSOLE: is already open, can't re-use
         ldx   ucbpointer              switch back to original user
         stx   currentucb
         jmp   errchanisopen

jc.createjoberr ; can't open "do" or "log" file for some reason
         pshx
         jsr   closelog                make sure log is closed
         bcs   *+2                     ignore any error
         pulx
         ldd   ucbpointer              ucb of creator...
         std   currentucb              restore to original state
         jmp   errorinx                and go yell about the problem

jc.setnewjobcapability ; chooses new capability key for job
         jsr   ilk.genrandom           invent a "new" capability
         if    m6800!m6801
         ldd   currentucb              form pointer to job capability name
         addd  #ucb:jobcapability
         std   tempx
         else  (m6809)
         ldx   currentucb
         leay  ucb:jobcapability,x
         fin
         ldd   #16
         ldx   #ilkcap
         jmp   blockmove               save capability in ucb
         page
jc.testdone ; come here to handle SYSCALL:JOBCONTROL with JC:TESTDONE
*        jsr   jc.findjob              find job specified by WRBUF capability
*        okrts                         if we found it, that's enough...

jc.findjob ; subroutine to find job specified by WRBUF capability
         jsr   ilk.validate            fetch the capability for job
         ldx   ucbchain                where to start
         stx   ucbpointer
jc.findjobloop
         ldx   ucbpointer              check job state
         lda   ucb:jobstate,x
         cmpa  #js:busy                does job "exist" ?
         bne   jc.findjobnext          b/ no, ignore this job
         if    m6800!m6801
         ldd   ucbpointer              form pointer to job capability name
         addd  #ucb:jobcapability
         tdx
         else  (m6809)
         ldx   ucbpointer
         leax  ucb:jobcapability,x
         fin
         jsr   ilk.matchcap            compare given capability to actual
         beq   jc.foundjob             b/ found matching job
jc.findjobnext
         ldx   ucbpointer              find next ucb
         lda   ucb:lfnext,x
         sta   ucbpointer
         bne   jc.findjobloop          b/ more jobs to inspect
         jsr   erret
         #err:nosuchobject

jc.foundjob
         okrts                         if we found it, that's enough...
         page
jc.destroy ; come here to handle SYSCALL:JOBCONTROL with JC:DESTROY
         jsr   jc.findjob              find job specified by WRBUF capability
         ldx   ucbpointer              make us into the other job, temporarily
         ldd   currentucb
         stx   currentucb
         std   ucbpointer
         lda   #js:dying               mark job as "needs destruction"
         sta   ucb:jobstate,x          yes, mark job as "needs destruction"
;                                      (makes scheduler destroy it...
;                                       next time job tries to wake up)
         ldb   ucb:killproof,x         is this job currently killproof ?
         bne   jc.destroylater         b/ yes, put off until job is ready
         jsr   ilk.ctlc.unblock        rip job out of interlock queues
         jsr   delay.ctlc.unblock      rip job out of delay queues
jc.destroylater
         ldx   ucbpointer              make us back into the job we were
         stx   currentucb
         okrts

jc.destroycant
         ldx   ucbpointer              make us back into the job we were
         stx   currentucb
errcapabilityfailure
         jsr   erret
         #err:capabilityfailure        capability bits for operation not set
         page
jobcontrol.fatalerror ; job can't proceed due to fatal error in DERR
         jsr   releaseallpages         give everything back to /MT
         bra   jobcontrol.finalservices

jobcontrol.jobdone ; job has reached EOF on channel 0
         ldx   #err:jobcompleted       get appropriate final status
         bra   jobcontrol.killjobforX

jobcontrol.mercykilling ; come here to do mercy killing of errant job
         ldx   #err:jobkilled          do final output to log file
jobcontrol.killjobforX ; (X) contains reason why job died
         stx   userlasterror           save cause of death
         jsr   releaseallpages         let go of allocated pages
         lda   #js:busy                prevent redundant mercy killing
         sta   ucb:jobstate,x
         jsr   jc.setnewjobcapability  prevent 2nd "jc.destroy" to this job
         jsr   derrcr                  write autopsy results to log
jobcontrol.finalservices
         jsr   exits                   close all the I/O channels
         jsr   releaseallpages         make clean slate
         jsr   closechannel0           get rid of any do file
         bcs   *+2                     (ignore possible ch#0 not open error)
         jsr   closelog                close the log file if open
         bcs   *+2                     eat "log file was closed" error
         jsr   closeloadchannel        in case a CHAIN/LOAD was aborted
         bcs   *+2                     eat "load file closed" error
         jsr   getuserLFchannel        is this a background job ?
         beq   jobcontrol.buried       b/ yes, all done with final services
         lda   #js:busy                no, can't let user job die, mark as live
         staa  ucb:jobstate,x
         jsr   resetLFchannel          reset Line Flags channel (ack EOF)
         jsr   openconsole             re-open console to LF channel
         jmp   exit                    and make job run the DEFAULTPROGRAM

jobcontrol.buried
         lda   #js:free                mark this job as free
         sta   ucb:jobstate,x
         jsr   saveplace               leave job in never-never (inspect) queue
         jmp   exit                    we awaken! must be new job to do
         PAGE
PATCH    RPT   50                      assume only a little patch space needed
         swi

firebomb.mtinit
        ldx     #initializetimeshare
firebomb.loop
        clr     ,x+
        cpx     #endofinitializetimeshare+1
        bne     firebomb.loop
        jmp     pollforuser

MTCHKSUMSIZE    EQU     *-MTCHKSUMBASE

ENDOFTIMESHARE ; end of SD/MT procedure section
        PAGE    UCBs
        org     (*//256)*256
firstucb ; begins here

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /console:/             exactly 8 bytes
        org     ucb+ucb:size

        if      SDOSExtendedSpace
ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /backgnd:/   2nd UCB under SDOS/ES is ALWAYS a background job
        org     ucb+ucb:size

; Only 2 UCBs are set up. This prevents an SDOS/ES system from EVER
; being mis-used as SDOS/MT, and therefore allows SD to charge a lower
; price for SDOS/ES.
        page
        else    (SDOS/MT)              set up LOTs of UCBs
ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port1:/
        fcb     0,0                    pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port2:/
        fcb     0,0                    pad name to 8 bytes
        org     ucb+ucb:size

        page
ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port3:/
        fcb     0,0                    pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port4:/
        fcb     0,0                    pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port5:/
        fcb     0,0                    pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port6:/
        fcb     0,0                    pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port7:/
        fcb     0,0                    pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port8:/
        fcb     0,0                    pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port9:/
        fcb     0,0                    pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port10:/
        fcb     0                      pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port11:/
        fcb     0                      pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port12:/
        fcb     0                      pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port13:/
        fcb     0                      pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port14:/
        fcb     0                      pad name to 8 bytes
        org     ucb+ucb:size

ucb     set     *
        rpt     ucb:size
        fcb     0
        org     ucb+ucb:consolestr     name of console
        fcc     /port15:/
        fcb     0                      pad name to 8 bytes
        org     ucb+ucb:size
        fin     SDOSExtendedSpace

; Note: 16 users max (console: + ports1 to ..15) limited by SERVICEDIO flags
EndUCBs ; End of User Control Blocks
        PAGE    SDOS/MT Initialization Code
INITIALIZETIMESHARE ; Initialize SDOS/MT for operation.
;
; For purpose of SWI below, see CALCCHKSUM routine at end of listing.
        SWI                     for debugging/checksum computing purposes

* This routine accomplishes the following:
*       Alert virtual terminal driver
*       Set up UCBs
*       Find and set TOPMEM for each user (1 per address space)
*       Set up a console for each user
*       Set each user's stack to look as if an exit syscall had been issued
*       Fill sundry other UCB: slots with appropriate values
* When done, this code becomes part of the /MT free page pool.

        LDS     #SDOSMTSTACK-(&M6809) set up stack pointer like /MT will use it
        LDX     #HELLODERE      announce myself now so people can see version
        ; We shouldn't announce ourselves here, as a trivial breakpoint on an
        ; output interrupt routine in the I/O package would then allow a user
        ; to see our internals.  Oh well, can't defend against everything.
        JSR     SYSCALL$
        BCS     INITERR         B/ oh well...something's not right
        BSR     DOSTUFF
        BCS     INITERR         B/ couldn't get going for some reason
        LDX     #SYSKILLENABLE  let the sun shine in!
        JSR     SYSCALL$
        BCS     INITERR         B/ oh well...something's not right
        LBCC    FIREBOMB.MTINIT GO for it!!!

INITERR ; Something's wrong, /MT won't start up today.
        STX     INIT.ERROREXIT+SCBLK:PARAMS
        LDX     #SYSKILLENABLE
        JSR     SYSCALL$
        BCS     *+2             ignore any error, I give up anyway!
        LDX     #INIT.ERROREXIT
        JMP     SYSCALL$

NOTENOUGHROOM
        JSR     ERRET
        #ERR:MTNOROOM           not enough address space to run SDOS/MT
        PAGE
DOSTUFF
        LDX     #SYSKILLPROOF   make me bulletproof!
        JSR     SYSCALL$
        LDX     #SETTIMESHARE   MT's running now!
        JSR     SYSCALL$
        ldx     CrashInfoPtr    Reset /MT Crash information to all zeros
        ldd     #0              get zeros to store
        std     0,x             and store them!
        std     2,x
        std     4,x
        CLRA                    no initial quantum
        LDX     #TIMESLICEABORTED where to go on 1st RETURNTOUSER calls
        JSR     SETQUANTUM

; should validate use of correct SELECTBANK at this point
; (and GOCATATONIC if wrong)

; read the clock to get seed for generating random interlock capabilities

        LDX     #OPENCLOCK
        JSR     SYSCALL$
        LDX     #READCLOCK
        JSR     SYSCALL$
        LDX     #CLOSECLOCK
        JSR     SYSCALL$

; close channel 0 and close the log (in case SDOS/MT was started with
; a DO file); channel 0 will be allocated to the first user as his invisible
; console channel, which will be used to watch out for ^C^C status

        ldx     #closezero
        jsr     syscall$
        ldx     #closelog$
        jsr     syscall$
        bcs     dostuff.2
dostuff.2

; see if the LOGIN program exists, and note the fact (of absence or presence)

        LDX     #FINDLOGIN
        JSR     SYSCALL$
        BCS     DOSTUFF.1       b/ LOGIN does not exist
        INC     LOGINEXISTS     note that LOGIN exists
        LDX     #CLOSELOGIN
        JSR     SYSCALL$
        PAGE
DOSTUFF.1

*       set up memory map

        LDAA    $FC             find my top of memory
        SUBA    #ENDOFTIMESHARE//256
        CMPA    #MAXUSERS*UCB:SIZE/256 need space for UCB'S + STACKS + PAGES to run SDOS/MT
        LBLO    NOTENOUGHROOM   b/ too bad--not enough room to sneeze in
        STAA    MAPSIZE
        LDX     PAGEMAPBASE
INIT.1  ; mark all available pages as available
        CLR     ,X+
        DECA
        BNE     INIT.1

*       set up the UCB's

        CLR     NUMUSERS        remember number of users we have
        CLR     UCBCHAIN        reset chain of UCBs
        CLR     UCBCHAIN+1
INIT.UCBS ; Initialize as many UCBs as possible
        BSR     SETUPUCB        set up as many user's as possible
        BCS     INIT.UCBS.1     b/ can't set up more ucbs
        LDAA    NUMUSERS        set up maximumn UCBs ?
        if      SDOSExtendedSpace
        CMPA    #2              SDOS/ES has only foreground user and bkgnd user
        else    ;(SDOS/MT)
        CMPA    #MAXUSERS       SDOS/MT has lots of users
        fin
        BEQ     INIT.UCBS.DONE  b/ yes
        LDD     CURRENTUCB
        ADDD    #UCB:SIZE
        STD     CURRENTUCB
        BRA     INIT.UCBS

INIT.UCBS.1 ; can't set up any more UCBs without running into resource limit
        CPX     #0              normal completion ?
        LBNE    ERRORINX        b/ no, croak and die...
INIT.UCBS.DONE ; enter from from INIT.UCBS loop when all UCBs set up
        TST     NUMUSERS        how many users did we set up ?
        BEQ     INIT.NOUSERS    b/ none, go roll over and die...
        LDA     FIRSTUCB+UCB:JOBSTATE verify 1st job can talk to world
        CMPA    #JS:BUSY
        BNE     INIT.FIRSTJOBMUSTHAVECONSOLE
        LDA     MAPSIZE
        STA     NUMPAGES
        CMPA    NUMUSERS        enough pages to run /MT ?
        BLS     INIT.NOTENOUGHPAGES
        LDA     UCBCHAIN        visit all users, and allocate UCB:PERMANENTPAGE
INIT.3 ; allocate UCB:PERMANENTPAGE to this user
        STA     CURRENTUCB
        LDX     CURRENTUCB
        LDA     UCB:USERNUMBER,X
        STA     CURRENTUSER
        JSR     ALLOCATE1PAGE.HUNT     go hunt for a page
        CLR     UCB:ALLOCATEDPAGECNT,X forget page as variable-size-segment
        STB     UCB:PERMANENTPAGE,X    remember it as this, instead
        INC     PAGEMAPBASE+1          prevent from ever searching this page again
        DEC     MAPSIZE
        LDA     UCB:LFNEXT,X           find next user
        BNE     INIT.3
        TST     NUMPAGES               any pages left at all ?
        BEQ     INIT.NOTENOUGHPAGES    b/ no, give up...
        OKRTS                          SDOS/MT initialization successful!!!

INIT.NOUSERS
INIT.FIRSTJOBMUSTHAVECONSOLE
INIT.NOTENOUGHPAGES
        JSR     ERRET
        #ERR:MTBADCONFIG
        PAGE
; Set up a UCB for CURRENTUCB.  If the userspace doesn't have enough
; space to run defaultprogram, then truncate the chain of users and exit.
; If there isn't a console for this user, then mark this user as a free job,
; and don't put it in any queue; otherwise mark as a busy job, set him
; up to do an EXIT, and stuff him in the run queue.
; Otherwise, put the finishing touches on the ucb, and exit.

DEFAULTPROGRAMSIZE      EQU     20000   rough guess at size needed for this one

TRUNCATECHAIN
        DEC     NUMUSERS
        LDX     #0                     signal "normal completion"
        ERRORRTS

SETUPUCB
        INC     NUMUSERS
        LDA     NUMUSERS
        JSR     USERSELECT      select this user so I determine how large...
        BCS     TRUNCATECHAIN     (user # too high for this configuration)
        JSR     USERCURRENTSIZE     his address space is
        CMPD    #DEFAULTPROGRAMSIZE
        BLO     TRUNCATECHAIN   b/ this space isn't large enough...
        SUBD    #3                    (allow for JMP USERSPACESYSCALL)

        LDX     PAGEMAPBASE     this user is real, allocate UCB space forever!
        DEC     0,X             mark pages as busy
        DEC     1,X

        rpt     UCB:SIZE//256
        INC     PAGEMAPBASE+1

        rpt     UCB:SIZE//256
        DEC     MAPSIZE

        LDX     CURRENTUCB
        STD     UCB:TOPMEM,X

        LDA     NUMUSERS               remember user number
        STA     UCB:USERNUMBER,X

        STAA    TEMPA                  set up counter
        LDD     #0                     get bit mask for user # 1
        SEC                            set carry to 1 on entry to loop
SETUPUCB:BITMASK ; determine bit mask required
        ROLD                           shift bit mask left, zeroing carry
        DEC     TEMPA                  User Number one has bit mask of :0001
        BNE     SETUPUCB:BITMASK       b/ more shifts required
        STD     UCB:BITMASK,X          store bitmask (see SERVICEDIO flags)
        LDB     UCBCHAIN               point current to prior
        STB     UCB:LFNEXT,X
        LDA     CURRENTUCB
        STA     UCBCHAIN

; make the UCB "habitable"

        LDAA    CPUQUANTUMTICKS
        STAA    UCB:REMAININGQUANTUM,X
        STAA    UCB:USERCPUBOUND,X
        page
        jsr     ilk.genrandom          generate capability for this job
        if      m6800!m6801
        ldd     currentucb             form pointer to ucb:capability
        addd    #ucb:jobcapability
        std     tempx
        else    (m6809)
        ldx     currentucb
        leay    ucb:jobcapability,x
        fin
        ldd     #16                    number of bytes to move
        ldx     #ilkcap                source of capability
        jsr     blockmove              save capability in ucb

        ldx     currentucb             reset this job's I/O channels
        lda     currentucb             form pointer to channel map table
        ldb     #ucb:channelmapt
        std     ucb:channelmap,x       and save in ucb
        lda     #$ff                   "Channel is closed"
        sta     ucb:logchannel,x       mark log channel as closed
        sta     ucb:loadchannel,x      mark load channel as closed
        ldx     ucb:channelmap,x
        ldb     #UCBchannels           number of user virtual channels
setupucb.ctl
        sta     ,x+                    mark virtual channels as closed
        decb                           (including ucb:chan0!)
        bne     setupucb.ctl
        page
; get a console for the user

        LDX     CURRENTUCB
        LDD     CURRENTUCB
        ADDD    #UCB:CONSOLESTR        get name
        STD     CONSOLEOPEN+SCBLK:WRBUF
        LDD     #8                     get length of name in UCB
        STD     CONSOLEOPEN+SCBLK:WRLEN
        JSR     ALLOCATEREALCHANNEL
        STA     CONSOLEOPEN+SCBLK:PARAMS
        if      SDOSExtendedSpace
        LDAA    NUMUSERS               if SDOS/ES, and user number 2,
        CMPA    #2                     then this is by definition a free job
        ; this prevents SDOS/ES from being used as a 2-user system.
        BHS     SETUPUCB.ASFREEJOB     b/ force it to be a free job
        fin
        LDX     #CONSOLEOPEN
        JSR     SYSCALL$               open it
        BCS     SETUPUCB.NOCONSOLE     b/ can't open console: for this guy
        LDX     CURRENTUCB
        LDA     #JS:BUSY               mark job as not available
        STA     UCB:JOBSTATE,X
        LDA     CONSOLEOPEN+SCBLK:PARAMS can open, set up LF channel info
        STA     UCB:LFCHAN,X           get the channel
        sta     ucb:chan0,x            give user an open console (channel 0)
        STA     INDEXFORSTA
        LDA     #VT:CONSOLE            set the device type
        LDX     #DEVICEMAP
        JSR     STAINDEX
        LDD     CURRENTUCB
        JSR     ADDRUNQ
        BRA     SETUPUCB.STACK
        PAGE
SETUPUCB.NOCONSOLE ; this job has no console
        CPX     #ERR:NOSUCHDEVICE      is this a good reason ?
        LBNE    ERRORINX               b/ no... RIBBIT! die...
SETUPUCB.ASFREEJOB ; force this job to be a "free" job
        LDX     CURRENTUCB
        LDA     #JS:FREE               mark job as available
        STA     UCB:JOBSTATE,X
        LDA     #$FF                   get "not open" code
        STA     UCB:LFCHAN,X           remember, this job has no LF channel
        sta     ucb:chan0,x            and currently has no channel 0
        LDA     CONSOLEOPEN+SCBLK:PARAMS
        JSR     RELEASEREALCHANNEL     give channel back to free pile
        BCS     *+2                    ignore "channel is closed" error
;                                      very carefully, leave job out of queues
        page
SETUPUCB.STACK ; set up system space stack pointer for this user
        LDX     CURRENTUCB

; prime the user's stack with simulated EXIT syscall, matching return
; address, and a firebreak address, in case something goes haywire

        LDD     #FIREBREAK      set up firebreak
        STD     UCB:STACK-2,X   note: this works for 6800 AND 6809!
        LDD     #EXIT           assume this as first user activity
        TST     UCB:JOBSTATE,X           is this a free job ?
        BEQ     SETFIRSTUSERACTIVITY     b/ yes, doesn't need to LOGIN
        TST     LOGINEXISTS
        BEQ     SETFIRSTUSERACTIVITY
; LOGOFF exists.  Set it up to recieve control as 1st program to run.
        JSR     KILLPROOF       logoff gets killproofed at system boot
        BCS     *+2             B/ I don't care!
        IF      M6809
        LDY     #USERSPACELOGIN
        ELSE
        LDX     #USERSPACELOGIN
        STX     TEMPX
        FIN
        LDX     #USERSPACELOGINSTUFF
        LDD     #USERSPACELOGINSTUFFLEN
        JSR     COPYTOUSER
        JSR     INITUSERSTACK
        LDD     #SYSCALLEXIT.1   set to pass control back to user
SETFIRSTUSERACTIVITY
        LDX     CURRENTUCB
        STD     UCB:STACK-4,X    (D) tells User where to start up
        LDD     #SDOSMTSTACK-4-(&M6809) set initial value of system stack for user
        STD     UCB:STACKP,X
        JSR     SETUPFRANKBAKER give user a way out
        OKRTS
        page
USERSPACELOGIN  EQU     $100 ; where LOGIN fetch code is placed in user space

USERSPACELOGINSTUFF ; Code placed in User space to fetch LOGIN
        LDX     #USERSPACELOGINCHAIN
        JSR     SYSCALL$
        BCC     *       should never get here!!
        STX     USERSPACELOGINERROREXIT+SCBLK:PARAMS
        LDX     #USERSPACELOGINERROREXIT
        JMP     SYSCALL$

USERSPACELOGINCHAIN     EQU     *-USERSPACELOGINSTUFF+USERSPACELOGIN
        FCB     SYSCALL:CHAIN,CHAIN:SCLEN,IGNORED,IGNORED
        FDB     LOGIN,LOGINL
        FDB     CHANGED,USERSPACELOGINREPBUF,4

USERSPACELOGINERROREXIT EQU     *-USERSPACELOGINSTUFF+USERSPACELOGIN
        FCB     SYSCALL:ERROREXIT,ERROREXIT:SCLEN,CHANGED,CHANGED

USERSPACELOGINREPBUF    EQU     *-USERSPACELOGINSTUFF+USERSPACELOGIN
        RMB     4

LOGIN   EQU     *-USERSPACELOGINSTUFF+USERSPACELOGIN
LOGIN:  FCC     'LOGOFF'
LOGINL  EQU     *-LOGIN:

USERSPACELOGINSTUFFLEN  EQU     *-USERSPACELOGINSTUFF
        page
HELLODERE ; used for announcing presence
        FCB     SYSCALL:WRITEA,WRITEA:SCLEN,0,IGNORED
        FDB     MTMSG,COPYRIGHTEND-MTMSG

SYSKILLENABLE ; enable ^C^C, etc.
        FCB     SYSCALL:KILLENABLE,KILLENABLE:SCLEN

SYSKILLPROOF ; disable ^C^C, etc.
        FCB     SYSCALL:KILLPROOF,KILLPROOF:SCLEN

SETTIMESHARE ; say that timeshare is now running
        FCB     SYSCALL:CONTROL,CONTROL:SCLEN+10,0,CC:SETTIMESHARE
        FDB     0,0
        FDB     0,USERSPACESYSCALL,SIZETSPRIMS

INIT.ERROREXIT ; exit with complaint
        FCB     SYSCALL:ERROREXIT,ERROREXIT:SCLEN,CHANGED,CHANGED
        PAGE
FINDLOGIN ; used to open LOGIN file or to get NO SUCH FILE error
        FCB     SYSCALL:OPEN,OPEN:SCLEN,INITCHANNEL,IGNORED
        FDB     LOGIN:,LOGINL
        FDB     CHANGED,NAMESCANNEDCNT,2

CLOSELOGIN ; used to close LOGIN file if OPEN was successful
        FCB     SYSCALL:CLOSE,CLOSE:SCLEN,INITCHANNEL,IGNORED

OPENCLOCK ; these three syscall blocks are used for initializing the interlock seed
        FCB     SYSCALL:OPEN,OPEN:SCLEN,INITCHANNEL,IGNORED
        FDB     CLOCKNAME,LENCLOCKNAME
        FDB     CHANGED,NAMESCANNEDCNT,2

READCLOCK ; used to read time-of-day to get something "random"
        FCB     SYSCALL:READB,READB:SCLEN,INITCHANNEL,IGNORED
        FDB     IGNORED,IGNORED
        FDB     CHANGED,ILKCAP,6

CLOSECLOCK ; used to close clock device
        FCB     SYSCALL:CLOSE,CLOSE:SCLEN,INITCHANNEL

CLOCKNAME
        FCC     "CLOCK:"
LENCLOCKNAME    EQU     *-CLOCKNAME

CLOSEZERO ; used to close channel zero
        FCB     SYSCALL:CLOSE,CLOSE:SCLEN,0,IGNORED

CLOSELOG$ ; used to make log file go away if it is open
        FCB     SYSCALL:CLOSELOG,CLOSELOG:SCLEN,IGNORED,IGNORED

CONSOLEOPEN ; used to open the CONSOLE device
        FCB     SYSCALL:OPEN,OPEN:SCLEN,CHANGED,IGNORED
        FDB     CHANGED,CHANGED
        FDB     CHANGED,NAMESCANNEDCNT,2
        page
calcchksum ; calculate Checksum and then do a SWI.
; ***** HOW TO USE THIS ROUTINE *****
; After assembling /MT, one must set (patch) its checksum byte or /MT will
; only run a short time before failing with a SELF-TEST CHECKSUM error.
; This is accomplished by leaving the SWI instruction in INIT in the test
; version of /MT.  On /MT startup, that SWI will get executed and
; a debugger should get control.  Re-aim the PC to this routine (CALCCHKSUM)
; and let the processor go.  After a few seconds, the variable MTCHKSUM
; will be properly initialized.  Record its value, and patch that value
; into the /MT object module.  Then set the start address to that of the
; SWI, +1, and encrypt /MT.  You now have a live version of /MT.

        jsr     exit.checksum
        bcc     calcchksum.swi  B/ Eureka!!
        inc     mtchksum        one of these values should do it
        bra     calcchksum

calcchksum.swi
        swi

endofinitializetimeshare

        if      *>>$4000
        ? ; SDOS/MT is greater than 16K in size!
        fin     *>>$4000

        if      $4000-EndUCBs<<$100
        ? ; No free pool pages available, SDOS/MT won't run!!!
        fin

        END     INITIALIZETIMESHARE
