
REM	A PROGRAM TO INITIALIZE AND TRANSFER FILES ON IBM 3741 DISKS
REM	THIS PROGRAM IS BASED ON ASSUMPTIONS MADE FROM IBM REFERENCE MAN.
REM	GA21-9182-3 IBM DISKETTE GENERAL INFORMATION MANUAL

	DIM DISMDISK$/:0E,4,1,:11/
	DIM TDATA$(10)
	DIM BYTEDATA$(128),SDDISKNAME$(5),UNLOCKDISK$/:0E,4,1,:10/
	DIM IBMFILENAME$(17),IBMFILELOC(8),IBMFILERECSIZE(8)
	DIM NULL$(10)
	DIM SDOSFILE$(30)
	DIM IBMFILERBOE(8),IBMFILEREOE(8),IBMFILEREOD(8)
	DIM BLANK$/"                 "/
	DIM	EBCDIC$/...
&			".....",:09,"..........", ...
&			".....",:0D,"..........", ...
&			"................", ...
&			"................", ...
&			" .........[.<(+ ", ...
&			"&.........!$*); ", ...
&			"_/.........,%->?", ...
&			"..........:#@'=",'"', ...
&			".abcdefghi......", ...
&			".jklmnopqr......", ...
&			"..stuvwxyz......", ...
&			"................", ...
&			".ABCDEFGHI......", ...
&			".JKLMNOPQR......", ...
&			"..STUVWXYZ......", ...
&			"0123456789......"/
	DIM ASCII$/ ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:05,:4B,:4B,:4B,:15,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:40,:5A,:7F,:7B,:5B,:6C,:50,:7D, ...
&		:4D,:5D,:5C,:4E,:6B,:6D,:00,:61, ...
&		:F0,:F1,:F2,:F3,:F4,:F5,:F6,:F7, ...
&		:F8,:F9,:7A,:5E,:4C,:7E,:6E,:6F, ...
&		:7C,:C1,:C2,:C3,:C4,:C5,:C6,:C7, ...
&		:C8,:C9,:D1,:D2,:D3,:D4,:D5,:D6, ...
&		:D7,:D8,:D9,:E2,:E3,:E4,:E5,:E6, ...
&		:E7,:E8,:E9,:4A,:4B,:4B,:4B,:60, ...
&		:4B,:81,:82,:83,:84,:85,:86,:87, ...
&		:88,:89,:91,:92,:93,:94,:95,:96, ...
&		:97,:98,:99,:A2,:A3,:A4,:A5,:A6, ...
&		:A7,:A8,:A9,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B, ...
&		:4B,:4B,:4B,:4B,:4B,:4B,:4B,:4B /

REM IBMASCIITOEBC
REM CONVERT ASCII FIELD TO EBCDIC FIELD IN BYTEDATA$
REM IBMASCIITOEBC( FIRSTBYTE, LASTBYTE) BYTEDATA$

SUBROUTINE IBMASCIITOEBC( IBMAFB,IBMALB)
	FOR IBMAT= IBMAFB TO IBMALB
	BYTEDATA$(IBMAT)= ASCII$(BYTEDATA$(IBMAT)+1)
	NEXT IBMAT
	EXIT SUBROUTINE
END

REM IBMEBCDICTOASC
REM CONVERT EBCDIC FIELD TO ASCII FIELD IN BYTEDATA$
REM IBMEBCDICTOASC( FIRSTBYTE, LASTBYTE) BYTEDATA$

SUBROUTINE IBMEBCDICTOASC( IBMEFB,IBMELB)
	FOR IBMET= IBMEFB TO IBMELB
	BYTEDATA$(IBMET)= EBCDIC$(BYTEDATA$(IBMET)+1)
	NEXT IBMET
	EXIT SUBROUTINE
END
REM IBMBYTEREAD
REM READS A STRING BYTEDATA$
REM IBMBYTEREAD(CHANNEL,SECTOR,BYTEPOSITION) BYTEDATA$

SUBROUTINE IBMBYTEREAD(IBMBRCHANNEL,IBMBRSECTOR,IBMBRPOSITION)
REM	PRINT "RCH:";IBMBRCHANNEL
	READ #IBMBRCHANNEL@IBMBRSECTOR*128+IBMBRPOSITION-129,BYTEDATA$(1,LEN(BYTEDATA$))
REM	PRINT "R: ";IBMBRSECTOR;IBMBRPOSITION
REM	PRINT "RDATA: ";BYTEDATA$
	EXIT SUBROUTINE
END

REM IBMBYTEWRITE
REM WRITES A STRING BYTEDATA$
REM IBMBYTEWRITE(CHANNEL,SECTOR,BYTEPOSITION) BYTEDATA$

SUBROUTINE IBMBYTEWRITE(IBMBWCHANNEL,IBMBWSECTOR,IBMBWPOSITION)
REM	PRINT "WCH:";IBMBWCHANNEL
	WRITE #IBMBWCHANNEL@IBMBWSECTOR*128+IBMBWPOSITION-129,BYTEDATA$
REM	PRINT "W: ";IBMBWSECTOR;IBMBWPOSITION
REM	PRINT "WDATA: ";BYTEDATA$
	EXIT SUBROUTINE
END

REM IBMFILL
REM FILLS A LOGICAL SECTOR BYTE FIELD WITH HEX VALUES
REM IBMFILL( CHANNEL,DATA,LOGSECTOR,STARTBYTE,ENDBYTE)

SUBROUTINE IBMFILL( IBMFCH,IBMFDATA,IBMFSECTOR,IBMFSTARTB,IBMFENDB)
	LEN (BYTEDATA$)= IBMFENDB-IBMFSTARTB+1
	FOR IBMI= IBMFSTARTB TO IBMFENDB
	BYTEDATA$(IBMI-IBMFSTARTB+1)= IBMFDATA
	NEXT IBMI
	CALL IBMBYTEWRITE(IBMFCH,IBMFSECTOR,IBMFSTARTB)
	EXIT SUBROUTINE
END

REM IBMWRITE
REM WRITES A EBCDIC STRING OF THE DATA CONTAINED BYTEDATA$
REM IBMWRITE (CHANNEL,LOGSECTOR,BYTEPOS)

SUBROUTINE IBMWRITE( IBMXCH, IBMXSECTOR, IBMXPOS)
	CALL IBMASCIITOEBC(1,LEN(BYTEDATA$))
	CALL IBMBYTEWRITE( IBMXCH, IBMXSECTOR, IBMXPOS)
	EXIT SUBROUTINE
END

REM IBMSECTOREL
REM CONVERT ASCII IBM DISKETTE LOCATION TEXT TO RELATIVE SECTOR
REM CONVERTS "01026" TO 52= 1*26+26
REM IBMSECTOREL(CHANNEL) BYTEDATA$(5)

DEF IBMSECTOREL(IBMSRCHANNEL)
	CALL IBMEBCDICTOASC(1,5)
	RETURN VAL(BYTEDATA$(1,2))*26+VAL(BYTEDATA$(4,2))
END

REM IBMRELTOSEC
REM CONVERT RELATIVE DISKETTE SECTOR TO ASCII IBM FORM
REM 52 BECOMES "01026"
REM IBMRELTOSEC(IBMRELATIVESECTOR) BYTEDATA$(5)

SUBROUTINE IBMRELTOSEC( IBMRSECTOR)
	IBMT=IBMRSECTOR-1
	IBMC= INT(IBMT/26)
	IBMS= IBMRSECTOR-IBMC*26
	BYTEDATA$= NUMF$("###",100+IBMC)(2,2) CAT "0"...
&	CAT NUMF$("###",100+IBMS)(2,2)
	CALL IBMASCIITOEBC(1,5)
	EXIT SUBROUTINE
END

REM IBMOPEN SUBROUTINE
REM OPENS SPECIFIED SDOS DISK AND THEN ACCESSES IBM
REM FILE INFORMATION SO FILE TRANSACTIONS CAN OCCUR
REM IBMOPEN(CHANNEL) SDDISKNAME$,IBMFILENAME$

SUBROUTINE IBMOPEN(IBMOCHANNEL)
REM OPEN DISK, DISMOUNT DISK, AND UNLOCK FOR WRITING
	OPEN #IBMOCHANNEL,SDDISKNAME$
	UNLOCKDISK$(3)=IBMOCHANNEL
	CALL SYSCALL(UNLOCKDISK$,NULL$,NULL$)
REM SEARCH DATA SET (SECTORS 8-26 CYL0) FOR MATCHING FILENAME
	LEN(BYTEDATA$)=17
	IBMFILENAME$= IBMFILENAME$ CAT BLANK$(1,17-LEN(IBMFILENAME$))
	FOR IBMOPENTEMP= 8 TO 26
998		CALL IBMBYTEREAD(IBMOCHANNEL,IBMOPENTEMP,6)
999		CALL IBMEBCDICTOASC(1,17)
1000		IF BYTEDATA$=IBMFILENAME$ THEN IBMOFND
	NEXT IBMOPENTEMP
	PRINT "FILE NOT FOUND ON IBM DISK: ";IBMFILENAME$
10001	STOP
IBMOFND:	IBMFILELOC(IBMOCHANNEL)= IBMOPENTEMP
REM ONCE FILE IS FOUND SAVE SECTOR LOCATION OF DATA SET AND
REM THE RECORD SIZE FOR THIS FILE
	LEN(BYTEDATA$)=5
	CALL IBMBYTEREAD(IBMOCHANNEL,IBMOPENTEMP,23)
	CALL IBMEBCDICTOASC(1,5)
	IBMFILERECSIZE(IBMOCHANNEL)= VAL(BYTEDATA$)
REM	IBMFILERECSIZE(IBMOCHANNEL)= 128
REM GET THE FILE DATA PARAMETERS BOE EOD EOE
	CALL IBMBYTEREAD(IBMOCHANNEL,IBMOPENTEMP,29)
	IBMFILERBOE(IBMOCHANNEL)= IBMSECTOREL(IBMOCHANNEL)
	CALL IBMBYTEREAD(IBMOCHANNEL,IBMOPENTEMP,35)
	IBMFILEREOE(IBMOCHANNEL)= IBMSECTOREL(IBMOCHANNEL)
	CALL IBMBYTEREAD(IBMOCHANNEL,IBMOPENTEMP,75)
	IBMFILEREOD(IBMOCHANNEL)= IBMSECTOREL(IBMOCHANNEL)
	LEN(BYTEDATA$)= IBMFILERECSIZE(IBMOCHANNEL)
	EXIT SUBROUTINE
END

REM IBMCLOSE
REM CLOSE SDOS CHANNEL OPEN TO IBM DISKETTE FILE
REM UPDATE BOE EOD EOE
REM IBMCLOSE(CHANNEL)

SUBROUTINE IBMCLOSE( IBMCCHANNEL)
	IBMCTEMP= IBMFILELOC(IBMCCHANNEL)
	LEN(BYTEDATA$)=5
	CALL IBMRELTOSEC( IBMFILERBOE(IBMCCHANNEL))
	CALL IBMBYTEWRITE( IBMCCHANNEL,IBMCTEMP,29)
	CALL IBMRELTOSEC( IBMFILEREOE(IBMCCHANNEL))
	CALL IBMBYTEWRITE( IBMCCHANNEL,IBMCTEMP,35)
	CALL IBMRELTOSEC( IBMFILEREOD(IBMCCHANNEL))
	CALL IBMBYTEWRITE( IBMCCHANNEL,IBMCTEMP,75)
	CLOSE #IBMCCHANNEL
	EXIT SUBROUTINE
END

REM IBMSECTORLOC
REM CONVERTS RELATIVE RECORD FOR IBM FILE TO PHYSICAL
REM IBM SECTOR ADDRESS IN RANGE 1 TO 1*26*74
REM IBMSECTORLOC(CHANNEL,RELRECORD,WRITEORREADFLAG)
REM RETURNS -1 IF ILLEGAL REQUEST
REM RETURNS STARTING RELATIVE PHY SECTOR ADDRESS IF OK
REM WRITE REQUEST UPDATES EOD ADDRESS

DEF IBMSECTORLOC(IBMSLCHANNEL,IBMSLREC,IBMSLTEMP)
	IBMSLTEMP1= IBMFILERBOE(IBMSLCHANNEL)+IBMSLREC-1
REM	PRINT IBMSLTEMP1;IBMFILERBOE(IBMSLCHANNEL);
REM	PRINT IBMFILEREOD(IBMSLCHANNEL);IBMFILEREOE(IBMSLCHANNEL)
	IF IBMSLTEMP1< IBMFILERBOE(IBMSLCHANNEL) THEN RETURN -1
	IF IBMSLTEMP1>= IBMFILEREOE(IBMSLCHANNEL) THEN RETURN 0
	IF IBMSLTEMP1> IBMFILEREOD(IBMSLCHANNEL) THEN RETURN -1
	IF IBMSLTEMP1<> IBMFILEREOD(IBMSLCHANNEL) THEN RETURN IBMSLTEMP1
	IF IBMSLTEMP=0 THEN RETURN 0
	IBMFILEREOD(IBMSLCHANNEL)=IBMSLTEMP1+1
	RETURN IBMSLTEMP1
END

REM IBMRECREAD
REM READS RELATIVE RECORD IN FILE
REM IF NO SUCH RECORD RETURNS -1 IF RECORD RETURNS RECORD REL LOC (1 TO X)
REM IBMRECREAD(CHANNEL,RECORD) BYTEDATA$

DEF IBMRECREAD(IBMRRCHANNEL,IBMRRRECORD)
	LEN(BYTEDATA$)= IBMFILERECSIZE(IBMRRCHANNEL)
	IBMRRTEMP= IBMSECTORLOC(IBMRRCHANNEL,IBMRRRECORD,0)
	IF IBMRRTEMP<0 THEN RETURN IBMRRTEMP
	CALL IBMBYTEREAD(IBMRRCHANNEL,IBMRRTEMP,1)
	RETURN IBMRRTEMP
END

REM IBMRECWRITE
REM WRITES RELATIVE RECORD IN FILE
REM EXPANDS FILE EOD TO EOE AS REQUIRED
REM RETURNS RECORD ADDRESS OR -1 IF ILLEGAL
REM IBMRECWRITE(CHANNEL,RECORD) BYTEDATA$

DEF IBMRECWRITE(IBMRWCHANNEL,IBMRWRECORD)
	LEN(BYTEDATA$)= IBMFILERECSIZE(IBMRWCHANNEL)
	IBMRWTEMP= IBMSECTORLOC(IBMRWCHANNEL,IBMRWRECORD,1)
	IF IBMRWTEMP<0 THEN RETURN IBMRWTEMP
	CALL IBMBYTEWRITE(IBMRWCHANNEL,IBMRWTEMP,1)
	RETURN IBMRWTEMP
END
REM ***** START OF IBM APPLICATION ********

	PRINT
	PRINT "IBM UTILITY PROGRAM BY SOFTWARE DYNAMICS"
	PRINT "ALLOWS FOR INITIALIATION OF IBM DISKETTES UNDER SDOS"
	PRINT "AND COPYING FILES BETWEEN SDOS FILES AND IBM 3741 FILES"
IBMPROMPT:	PRINT
	PRINT "LIST OF FUNCTIONS AVAILABLE;"
	PRINT
	PRINT "INITIALIZE DISKETTE =1"
	PRINT "COPY IBM FILE TO SDOS FILE =2"
	PRINT "COPY SDOS FILE TO IBM FILE =3"
	PRINT "GIVE DIRECTORY LIST ON IBM DISKETTE =4"
	PRINT "EXIT IBM UTILITY =5"
	PRINT
	INPUT "INPUT FUNCTION CODE? " FCODE
	ON FCODE GOTO IBMINIT,IBMCOPY2SDOS,IBMSDOS2COPY,IBMDIR,IBMEXIT
	PRINT "THAT IS NOT A VALID FUNCTION! TRY AGAIN!"
	GOTO IBMPROMPT
IBMEXIT:	PRINT "GOODBYE.... AND GOODLUCK!"
	EXIT

IBMDIR:	INPUT "SDOS UNIT NAME FOR IBM DISK (D0: OR D1:)? " SDDISKNAME$
	OPEN #1,SDDISKNAME$
	CALL SYSCALL(DISMDISK$)
	CALL SYSCALL(UNLOCKDISK$)
	LEN(BYTEDATA$)=17
	PRINT "FILES ON IBM DISKETTE ON UNIT ";SDDISKNAME$
	PRINT "ONLY FIRST FILE CAN HOLD DATA!"
	PRINT
	PRINT "FILENAME";TAB(20);"RECORDS USED";TAB(40);"TOTAL RECORDS AVAILABLE"
	PRINT
	FOR IBMDIRT= 8 TO 26
	CALL IBMBYTEREAD(1,IBMDIRT,6)
	CALL IBMEBCDICTOASC(1,17)
	PRINT BYTEDATA$;
	CALL IBMBYTEREAD(1,IBMDIRT,29)
	IBMFILERBOE(1)= IBMSECTOREL(1)
	CALL IBMBYTEREAD(1,IBMDIRT,35)
	IBMFILEREOE(1)= IBMSECTOREL(1)
	CALL IBMBYTEREAD(1,IBMDIRT,75)
	IBMFILEREOD(1)= IBMSECTOREL(1)
	PRINT TAB(20);IBMFILEREOD(1)-IBMFILERBOE(1);TAB(40);IBMFILEREOE(1) ...
&	-IBMFILERBOE(1)+1
	NEXT IBMDIRT
	CLOSE #1
	PRINT
	PRINT "END OF IBM DIRECTORY LIST"
	GOTO IBMPROMPT

REM	PROGRAM TO INITIALIZE SINGLE SIDED SINGLE DENSITY
REM	FLOPPY DISKETTE SO IBM SYSTEM 3740 CAN USE IT
REM	WRITES INDEX CYLINDER AND DATA SET LABELS IN FIRST TRACK
REM	BY RON WHITES 7/15/80

REM	START OF IBM 3740 INITIALIZE MAINLINE CODE

IBMINIT:	INPUT "SDOS UNIT NAME FOR IBM DISK TO INITIALIZE (D0: OR D1:)? " SDDISKNAME$

100	OPEN #1,SDDISKNAME$
200	CALL SYSCALL(DISMDISK$,NULL$,NULL$)
300	CALL SYSCALL(UNLOCKDISK$,NULL$,NULL$)

	REM 1-80 RESERVED FOR IPL AND IMPL
	CALL IBMFILL (1,:40,1,1,80)
	REM 81-128 RESERVED FOR IPL AND IMPL
	CALL IBMFILL (1,:00,1,81,128)

	REM 2 1-80 RESERVED FOR IPL AND IMPL
	CALL IBMFILL (1,:40,2,1,80)

	REM 2 81-128 RESERVED FOR IPL AND IMPL
	CALL IBMFILL (1,:00,2,81,128)

	REM 3 1-80 RESERVED FOR SYSTEM SCRATCH
	CALL IBMFILL (1,:40,3,1,80)

	REM 3 81-128 SYSTEM SCRATCH
	CALL IBMFILL (1,:00,3,81,128)

	REM 4 1-80 RESERVED
	CALL IBMFILL (1,:40,4,1,80)

	REM 4 81-128 RESERVED
	CALL IBMFILL (1,:00,4,81,128)

	REM 5 1-5 = EBCDIC "ERMAP"
	BYTEDATA$="ERMAP"
	CALL IBMWRITE(1,5,1)

	REM 5 6-80 CONTAINS HEX 40
	CALL IBMFILL(1,:40,5,6,80)

	REM 5 81-128 PADDED :00
	CALL IBMFILL(1,:00,5,81,128)

	REM 6 1-80 RESERVED
	CALL IBMFILL(1,:40,6,1,80)

	REM 6 81-128 RESERVED
	CALL IBMFILL(1,:00,6,81,128)

	REM 7 1-4 = EBCDIC "VOL1"
	BYTEDATA$="VOL1"
	CALL IBMWRITE(1,7,1)

	REM 7 5-79 CONTAINS HEX :40
	CALL IBMFILL(1,:40,7,5,79)

	REM 7 80 = EBCDIC "W" INDICATES IBM STAND. LABELS
	BYTEDATA$="W"
	CALL IBMWRITE(1,7,80)

	REM 7 81-128 CONTAINS :00
	CALL IBMFILL(1,:00,7,81,128)


	FOR SECTOR= 08 TO 26

	REM WRITE HDR1 OR DDR1 IN 1-4 OF EACH SECTOR IDENTIFIER

FILEINPUT:	IF SECTOR=08
	THEN
	BYTEDATA$="HDR1"
	ELSE
	BYTEDATA$="DDR1"
	FI
	CALL IBMWRITE(1,SECTOR,1)

	REM POSITION 5 RESERVED
	CALL IBMFILL(1,:40,SECTOR,5,5)

	REM WRITE DATA SET IDENTIFIER "DATAXX"
	TDATA$= NUM$(SECTOR)
	IF SECTOR=8
	THEN
	INPUT "THE NAME OF FILE FOR DATA? " BYTEDATA$
	FI
	IF LEN(BYTEDATA$)>17
	THEN
	PRINT "17 CHARACTERS MAX NOT STARTING WITH A BLANK"
	GOTO FILEINPUT
	FI
	IF SECTOR=9 THEN BYTEDATA$="DATA09"
	IF SECTOR>9 THEN BYTEDATA$="DATA" CAT TDATA$(2,2)
	BYTEDATA$= BYTEDATA$ CAT BLANK$(1,17-LEN(BYTEDATA$))
	CALL IBMWRITE (1,SECTOR,6)


	REM DEFINE DATA SET LOCATIONS

	REM BLOCK LENGHT 23-27
	BYTEDATA$="  128"
	CALL IBMWRITE (1,SECTOR,23)

	CALL IBMFILL (1,:40,SECTOR,28,28)

	REM WRITE BOE

	IF SECTOR=8
	THEN
	BYTEDATA$="01001"
	ELSE
	BYTEDATA$="74001"
	FI
	CALL IBMWRITE (1,SECTOR,29)
	REM INDICATOR FOR PHYSICAL RECORD LENGHT
	CALL IBMFILL(1,:40,SECTOR,34,34)

	BYTEDATA$="73026"
	CALL IBMWRITE(1,SECTOR,35)
	REM PAD FOR AWHILE!

	CALL IBMFILL(1,:40,SECTOR,40,74)

	REM EOD ADDRESS

	IF SECTOR=8
	THEN
	BYTEDATA$="01001"
	ELSE
	BYTEDATA$="74001"
	FI
	CALL IBMWRITE(1,SECTOR,75)

	REM POSITION 80 RESERVED

	CALL IBMFILL(1,:40,SECTOR,80,80)

	REM PAD 81 TO 128 WITH 00

	CALL IBMFILL(1,:00,SECTOR,81,128)

	NEXT SECTOR
	CALL SYSCALL(DISMDISK$,NULL$,NULL$)
	CLOSE #1
	PRINT
	PRINT "DISKETTE IS INITIALIZED!"
	GOTO IBMPROMPT
IBMCOPY2SDOS:	INPUT "SDOS UNIT NAME FOR IBM DISK (D0: OR D1:)? " SDDISKNAME$
	INPUT "IBM FILENAME TO GET DATA FROM? " IBMFILENAME$
	INPUT "SDOS FILENAME TO WRITE TO? " SDOSFILE$
	CREATE #1,SDOSFILE$
	CALL IBMOPEN(2)
	FOR XSECTOR=1 TO 2000
	TEMP= IBMRECREAD(2,XSECTOR)
	IF TEMP=0 THEN IBMSTOP
	IF TEMP<0
	THEN
	PRINT "READ RECORD ERROR ";XSECTOR
	GOTO IBMSTOP
	FI
	CALL IBMEBCDICTOASC(1,128)
	WRITE #1,BYTEDATA$
	IF EOF(2) THEN IBMSTOP
	NEXT XSECTOR
IBMSTOP:	CALL IBMCLOSE(2)
	CLOSE #1
	PRINT
	PRINT "FILE TRANSFERED FROM IBM FILE TO SDOS FILE"
	GOTO IBMPROMPT
IBMSDOS2COPY:	INPUT "SDOS UNIT NAME FOR IBM DISK (D0: OR D1:)? " SDDISKNAME$
	INPUT "IBM FILENAME TO WRITE DATA ON? " IBMFILENAME$
	INPUT "SDOS FILENAME TO READ FROM? " SDOSFILE$
	OPEN #1,SDOSFILE$
	CALL IBMOPEN(2)
	FOR XSECTOR=1 TO 2000
	READ #1,BYTEDATA$
	CALL IBMASCIITOEBC(1,128)
	TEMP= IBMRECWRITE(2,XSECTOR)
	IF TEMP=0 THEN IBMSTOP
	IF TEMP<0
	THEN
	PRINT "WRITE RECORD ERROR ";XSECTOR
	GOTO IBMSTOP
	FI
	IF EOF(1) THEN IBMSTOP
	NEXT XSECTOR
	CLOSE #1
	CALL IBMCLOSE(2)
	PRINT
	PRINT "FILE TRANSFERED FROM SDOS TO IBM DISKETTE"
	GOTO IBMPROMPT
	END
