        TITLE   IO DRIVERS FOR PSITECH GT68XX
************************************************************************
PSITECH EQU     1       THIS I/O PACKAGE IS FOR AN GT68XX!
*************************************************************************

        TABS    20,28,44,45
        PSR     0       *** DON'T PRINT ANY SKIPPED RECORDS ***
        NAME    SDOSDRIVERS
        WITH    LINCLUDE
*
*       BY SOFTWARE DYNAMICS
*       AND A CAST OF THOUSANDS!
*
EDITDATE        EQU     $0224   /82 MMDD IN HEX FORMAT
EDITYEAR        EQU     1982
*
*
*********************************************************************
*   I/O PACKAGE STRUCTURE
*   The I/O package is organized in the following fashion:
*
*   Low addresses: !                   !
*                  !  Read-only code,  !
*                  !   tables, etc.    !
*                  !-------------------!
*                  !                   !
*                  !  Interrupt poll   !
*                  !     chains        !
*                  !   (readonly)      !
*                  !                   !
*                  !-------------------!
*                  !                   !
*                  !  Working storage, !
*                  !  DCBs, TCBs, etc. !
*                  !                   !
*                  !-------------------!
*                  !                   !
*                  !    Disk Buffer    !
*                  !       Pool        !
*                  !    I/O Driver     !
*                  !    Reset code     !
*                  !    (once-only)    !
*                  !                   !
*                  !-------------------!
*                  !                   !
*                  !   VT Drivers      !
*                  !      SDOS         !
*                  !     ....          !
*
*       To make this arrangement possible, each I/O package source is
*       organized in the following way:
*               IOxxxxx.DO      is a file containing a configuration
*                               for machine xxxxx
*               IOxxxxx.DO      is a file containing an I/O package "shell"
*               IOyyyyy.ASM     is a file containing ALL driver-related code
*                               tables, etc. for the hardware device yyyyyy
*
*       Each I/O package shell uses conditional assembly switches to conditionally
*       INCLUDE IOyyyyy.ASM in a particular configuration.  The IOyyyyy.ASM
*       file is actually INCLUDEd 4 times, once for each of the 4 areas of
*       the I/O package shown above.  The following conditional switches
*       are used by the driver source module to distinguish between areas:
*               IODRIVERBODY    selects the read-only code portion
*               IODRIVERPOLL    selects the Interrupt poll chain portion
*               IODRIVERRAM     selects read/write storage of driver
*               IODRIVERINIT    selects the once-only I/O driver initializing code
*
*       Note: the driver source module should define all equates and (DCB)
*       table displacements when the conditional switch IODRIVERBODY is enabled.

*
*       A Typical shell has the following source form:
*
*       *       SET DEFAULTS
*               IFUND   xxxx
*               IFUND   yyyy
*               ...
*       *       BUILD READ-ONLY CODE
*       IODRIVERBODY    SET     1
*       IODRIVERPOLL    SET     0
*       IODRIVERRAM     SET     0
*       IODRIVERINIT    SET     0
*               IF      xxxx
*               INCLUDE IOxxxx.ASM
*               FIN
*               IF      yyyy
*               INCLUDE IOyyyy.ASM
*               FIN
*               ...
*       PATCHSPACE      RTP     zzzz
*               SWI
*       *****   Build Interrupt Poll Chains
*       IODRIVERBODY    SET     0
*       IODRIVERPOLL    SET     1
*               IF      xxxx    Note: order of poll routines may be different than bodies
*               INCLUDE IOxxxx.ASM
*               FIN
*               IF      yyyy
*               INCLUDE IOyyyy.ASM
*               FIN
*               ...
*       *****   Build Working Storage
*       IODRIVERPOLL    SET     0
*       IODRIVERRAM     SET     1
*               IF      xxxx
*               INCLUDE IOxxxx.ASM
*               FIN
*               IF      xxxx
*               IF      yyyy
*               INCLUDE IOyyyy.ASM
*               FIN
*               ...
*       *****   Build Driver Reset routines
*       IODRIVERRAM     SET     0
*       IODRIVERINIT    SET     1
*               IF      xxxx
*               INCLUDE IOxxxx.ASM
*               FIN
*               IF      yyyy
*               INCLUDE IOyyyy.ASM
*               FIN
*               ...
*       *****   Finish out disk buffer pool, etc
*               ...
*               END
        PAGE    I/O PACKAGE DEFAULT SWITCHES
        IFUND   MEMSIZE
MEMSIZE EQU     56      DEFAULT FOR GT6800 WITH GRAPHICS DISPLAYS
        FIN     MEMSIZE
        IFUND   MT
MT      EQU     0       NO MTSDOS
        FIN
*

        IFUND   NIOCHANNELS
        IF      MT
NIOCHANNELS     EQU     32
        ELSE
NIOCHANNELS     EQU     8
        FIN     MT
        FIN     NIOCHANNELS
*
        IFUND   IDBBASE
IDBBASE EQU     $E400
        FIN     IDBBASE
*
K       EQU     1024    # BYTES PER "K" OF MEMORY
*
*
        IFUND   SDOS
SDOS    EQU     MEMSIZE*K-$3200
        FIN     SDOS
*
        IFUND   VTDRIVER
VTDRIVER        EQU     SDOS-$1800
        FIN
*
        IFUND   CODE
CODE    EQU     VTDRIVER-$3C00
        FIN
*
        IFUND   DRIVERBASE
        IF      CODE<<SDOS
DRIVERBASE      EQU     CODE
        ELSE
DRIVERBASE      EQU     SDOS-3
        FIN     CODE<<SDOS
        FIN     DRIVERBASE

        IFUND   REALTIMECLOCK   "THERE EXISTS A REAL PIECE OF CLOCK HARDWARE"
        IFUND   USECONSOLEACIAASCLOCK   "NO REAL CLOCK HARDWARE, SO USE CONSOLE TO FAKE IT"
USECONSOLEACIAASCLOCK   EQU     1
        FIN     USECONSOLEACIAASCLOCK
REALTIMECLOCK   EQU     &USECONSOLEACIAASCLOCK
        FIN     REALTIMECLOCK

        IFUND   USECONSOLEACIAASCLOCK   "NO REAL CLOCK HARDWARE, SO USE CONSOLE TO FAKE IT"
USECONSOLEACIAASCLOCK   EQU     0
        FIN     USECONSOLEACIAASCLOCK

        IFUND   USEACIAASCLOCK
USEACIAASCLOCK  EQU     0
        FIN

TICKSPERSECOND  EQU     60      
        IFUND   CLOCK
CLOCK   EQU     1
        FIN
        IF      CLOCK
        IFUND   LISTCLOCK
LISTCLOCK       EQU     1
        FIN
        FIN

        IFUND   BLACKHOLE
BLACKHOLE       EQU     0
        FIN
        IF      BLACKHOLE
        IFUND   LISTBLACKHOLE
LISTBLACKHOLE   EQU     1
        FIN
        FIN

        IFUND   ICOM
ICOM    EQU     0
        FIN
        IF      ICOM
        IFUND   LISTICOMFLOPPY
LISTICOMFLOPPY  EQU     1
        FIN
        FIN

        IFUND   PSILOGFLOP
PSILOGFLOP      EQU     &ICOM
        FIN
        IF      PSILOGFLOP
        IFUND   LISTPSILOGFLOP
LISTPSILOGFLOP  EQU     1
        FIN
        FIN     PSILOGFLOP

        IFUND   LPT
LPT     EQU     1       STANDARD PRINTER
        FIN     LPT
        IF      LPT
        IFUND   LISTLPT
LISTLPT EQU     1
        FIN
        FIN

        IFUND   STORAGEDEMON
STORAGEDEMON    EQU     0
        FIN
        IF      STORAGEDEMON
        IFUND   LISTSTORAGEDEMON
LISTSTORAGEDEMON        EQU     1
        FIN
        FIN

        IFUND   LISTDEFS
LISTDEFS        EQU     0       DON'T LIST I/O PACKAGE DEFS
        FIN
IOPKDEFS        EQU     1       MAKE SURE WE GET I/O PACKAGE DEFINITIONS
        LIST    LISTDEFS
        INCLUDE SDOS11DEFS.ASM
        INCLUDE SDOSVT11DEFS.ASM
        LIST    1
        PAGE
*
*       SDOS-TO-IOPACKAGE COMMUNICATION REGION
        ORG     SDOS+1
****    FCB     $11     SDOS VERSION NUMBER
        FDB     0       LAST ERROR ENCOUNTERED
        FDB     CNFGTABLE       TELL SDOS WHERE ALL THE GOODIES ARE
        FDB     0       SERIAL NUMBER
        FDB     0       IOBLOCKPTR
        FDB     0       IOCB POINTER (FOR FILE-TYPE DEVICE DRIVERS)
        FCB     0,0,0   SET CLOCK TO "MIDNITE"
        FCB     0       DAY, LET COMMAND INTERPRETER KNOW
        FCB     0       MONTH, THAT THE TIME HASN'T BEEN SET
        FCB     EDITYEAR\100    YEAR
*
        ORG     DRIVERBASE
SYSCALLIO       JMP     SYSCALLIO       SDOS SETS JMP ADDR TO ITS ENTRY POINT
*
*****   READ ONLY CODE SECTION
IODRIVERBODY    SET     1
IODRIVERPOLL    SET     0
IODRIVERRAM     SET     0
IODRIVERINIT    SET     0

*
NEXTTCB SET     0       END OF TCB CHAIN
NEXTTIMEOUT     SET     0
NEXTDISKDCB     SET     0
NEXTDEVICEDCB   SET     0
NTIMEOUTS       SET     0
NDISKDCBS       SET     0
INTERRUPTTARGET SET     SDOS+SDOS:RTI   ASSUME CONVENTIONAL INTERRUPT SCHEME
        PAGE    INTERFACE TO IDB
        IFUND   IDBBASE
        ELSE
DEBUGSYSCALLHANDLER     DES             MAKE SPACE FOR X
        DES             MAKE ROOM FOR INDEX REGISTER
        DES             MAKE ROOM FOR CONTENTS OF (A)
        DES             SAVE ACCB
        TPA
        PSHA            SAVE CC BITS
DEBUGINTERRUPT  JSR     INTDISABLE      TURN OFF INTERRUPTS
        JMP     IDBBASE+$8
        FIN     IDBBASE
        IF      MT
        INCLUDE IOMT.ASM
        FIN     MT
        IF      CLOCK
        INCLUDE IOCLOCK.ASM
        FIN
        IF      BLACKHOLE
        INCLUDE IOBLACKHOLE.ASM
        FIN     BLACKHOLE
        IF      PSILOGFLOP
        INCLUDE IOPSILOGFLOP.ASM
        FIN     PSILOGFLOP
        IF      ICOM
DKDID   EQU     $FBD0
DKDIC   EQU     $FBD1
DKCOD   EQU     $FBD2
DKCOC   EQU     $FBD3
DKDOD   EQU     $FBD6
DKDOC   EQU     $FBD7
FDNBPS  EQU     128
FDNSPT  EQU     26
FDNTPC  EQU     1
FDNCYL  EQU     77
        INCLUDE IOICOMFLOPPY.ASM
        FIN     ICOM
        IF      STORAGEDEMON
        INCLUDE IOSTOREDEMON.ASM
        FIN
        IF      LPT
        PAGE    LPT I/O routines
LPTpia:dat      EQU     $FAA4
LPTpia:ctl      EQU     $FAA5
LPTpia:sts      EQU     $FAA6
LPTpia:ctl2     EQU     $FAA7

ilputdev:$FAA4  ; must specify $FAA4 to MAKEVTCONFIG
        STAA    LPTpia:dat      put data in output register
        LDAA    #%00110100      issue strobe pulse to printer
        STAA    LPTpia:ctl
        LDAA    #%00111101      and enable interrupt on printer ACK
        STAA    LPTpia:ctl
        rts

tlcheckready:$FAA4      ; Check for printer ready at OPEN time
        LDAA    LPTpia:sts      get device STAAtus bits
        anda    #%111   ignore disconnected inputs
        deca            is device ready ?
        nega            sets carry if (A)<>0, --> device not ready
        rts

ilgetdev:$FAA4  bra     *       can't get here!
        FIN     LPT
        IF      PACE
IO:PUTC EQU     $E00E
IO:CHECKREADY   EQU     $E014
IO:TSTNGETC     EQU     $E00B
*
*
ILPUTDEV:$FAF4  BRA     *       WE SHOULD NEVER GET HERE
TLCHECKREADY:$FAF4      JSR     IO:CHECKREADY
        RTS
ILGETDEV:$FAF4  LDAA    :$FAF4CHARTEMP
        OKRTS
:$FAF4CHARTEMP  FCB     1
TLPUTC:$FAF4    JSR     IO:PUTC
        LDX     DCBPOINTER
        OKRTS
        FIN     PACE
*
*
        INCLUDE IOVTCONFIG.ASM  GENERATED BY MAKEVTCONFIG IMMEDIATELY BEFORE ASSY
        INCLUDE IOVTDPBS.ASM
        PAGE    CONFIG TABLE
        IFUND   INTERRUPTSTACKSIZE
INTERRUPTSTACKSIZE      EQU     MINSTACK+7+7+7+7+7+7+7  7 FOR EACH POSSIBLE
*                       NESTED INTERRUPT RESULTING FROM A DEVICE
        FIN     INTERRUPTSTACKSIZE
*
CNFGTABLE       FDB     DISKDCBS        DEFAULT DISK MUST BE FIRST
        FDB     TTYDCB  CONSOLE MUST BE FIRST
        FDB     IOCBPOINTERS
        FCB     NIOCHANNELS
        FDB     DSKBUFFERPOOL
        FDB     DSKPOOLSIZE
        FDB     SDOS:VTATTNCHECK
        FDB     DEBUGSYSCALLHANDLER
        FDB     DRIVERBASE
        FDB     INTSETUP
INTDISABLE
        IF      M6800!M6801
        NOP             INT DISABLE
        FIN     M6800
        SEI
        RTS
INTENABLE
        IF      M6800!M6801
        NOP             INT ENABLE
        FIN     M6800
        CLI
        RTS
INTRTI  RTI             INT RTI
        NOP
        NOP
        FDB     INTERRUPTSTACKEND-1
        FDB     STACKSWITCHEDPOLLCHAIN     ROUTINE TO DETERMINE INTERRUPTING DEVICE
        FDB     TASKQUEUE
        FDB     TIMEOUTQUEUE
        FDB     PROFILECHAIN
        FDB     DEBUGINTERRUPT  WITH CONTEXT BLOCK ON STACK
        IF      MT
        FDB     PRIMITIVETABLE  POINT TO THE TABLE IN THE MT ROM
        ELSE
        FDB     0       NO TIMESHARE PRIMITIVE VECTOR
        FIN

ILLDEVICEOP     JSR     SDOS+SDOS:ERROR
        FDB     ERR:ILLDEVICEOP
*
ERRETX  JSR     SDOS+SDOS:ERRORSAVE
        JMP     SDOS+SDOS:ERRORED

PATCHSPACE      RPT     50
        SWI
        PAGE    *** INTERRUPT POLL CHAINS ***
IODRIVERBODY    SET     0
IODRIVERPOLL    SET     1

INTERRUPTDEVICEPOLL     ; ROUTINES TO CHECK FOR INTERRUPTING DEVICE
FASTINTERRUPTPOLLCHAIN  ; COME HERE FROM IRQ VECTOR

        INCLUDE IOVTCONFIG.ASM
        INCLUDE IOVTDPBS.ASM
        IF      LPT
*       Check for LPT "Character acknowledged" interrrupt
        LDAA    LPTpia:ctl
        bpl     NotprintInterrupt
        rora            sposd to ask for int ?
        bcc     NotprintInterrupt       b/ no, ignore
        LDAA    LPTpia:dat      yes, acknowledge the interrupt
        LDAA    #%00111100      tell printer not to bug us anymore
        STAA    LPTpia:ctl
        ldx     #dcb:$FAA4
        jmp     sdos+sdos:vtoutputint
NotprintInterrupt
        FIN     LPT
        IF      PACE    *?
        JSR     IO:TSTNGETC
        BCS     NOTCONSOLEINT
        STAA    :$FAF4CHARTEMP
        LDX     #DCB:$FAF4
        JMP     SDOS+SDOS:VTINPUTINT
        FIN     PACE    *?
        JMP     SDOS+SDOS:IOINT         GO SERVE THE SLOWER DEVICES
STACKSWITCHEDPOLLCHAIN           ; COME HERE VIA CONFIG TABLE
        IF      CLOCK
        INCLUDE IOCLOCK.ASM
        FIN
        IF      STORAGEDEMON
        INCLUDE IOSTOREDEMON.ASM
        FIN
        IF      PSILOGFLOP
        INCLUDE IOPSILOGFLOP.ASM
        FIN     PSILOGFLOP
NOTCONSOLEINT   EQU     *
*
        IF      ICOM
        INCLUDE IOICOMFLOPPY.ASM
        FIN
        LDX     BADINTERRUPTCOUNT       CAN'T FIGURE OUT WHO IT IS...
        INX                     BUMP CRAZY INTERRRUPT COUNTER
        STX     BADINTERRUPTCOUNT
        JMP     SDOS+SDOS:RTI   AND HOPE IT WENT AWAY !
        IF      MT
        INCLUDE IOMT.ASM
        FIN     MT
        PAGE    *** WORKING STORAGE ***
IODRIVERPOLL    SET     0
IODRIVERRAM     SET     1

        IF      MT
        INCLUDE IOMT.ASM
        FIN     MT
BADINTERRUPTCOUNT       FDB     0       # OF INTERRUPTS FROM UNKNOWN DEVICES

        IF      CLOCK
        INCLUDE IOCLOCK.ASM
        FIN
        IF      BLACKHOLE
        INCLUDE IOBLACKHOLE.ASM
        FIN
        IF      STORAGEDEMON
        INCLUDE IOSTOREDEMON.ASM
        FIN
        IF      PSILOGFLOP
        INCLUDE IOPSILOGFLOP.ASM
        FIN
        IF      ICOM
        INCLUDE IOICOMFLOPPY.ASM
        FIN
        IF      LPT
*       NO SCRATCH STORAGE NEEDED OTHER THAN DCB
        FIN     LPT
        INCLUDE IOVTCONFIG.ASM
        IF      PACE
::      SET     *
        ORG     DCB:$FAF4+DCB:#PUTBUF
        JMP     TLPUTC:$FAF4
        ORG     ::
        FIN     PACE
        INCLUDE IOVTDPBS.ASM
DISKDCBS        SET     NEXTDISKDCB
NDRIVES SET     NDISKDCBS
DEVICEDCBS      SET     NEXTDEVICEDCB
TIMEOUTQUEUE    SET     NEXTTIMEOUT
NTIMEOUTBLOCKS  SET     NTIMEOUTS
TASKQUEUE       EQU     TTYTCB
        PAGE    FCBS, IOCBS, INTERRUPT STACK
*
*       FCBS (MUST PRECEDE IOCBS)
*
FCBS    RPT     FCB:SIZE*(NIOCHANNELS+2*NDRIVES+NMAGICFCBS)
        FCB     0
*
*       IOCBS
*
IOCBS   RPT     IOCB:SIZE*NIOCHANNELS
        FCB     0
IOCBPOINTERS    RPT     NIOCHANNELS
        FDB     IOCBS+IOCB:SIZE*(*-IOCBPOINTERS)/2

*
INTERRUPTTO     SET     INTERRUPTTARGET

INTERRUPTSTACK  EQU     *       STACK SPACE FOR INTERRUPT ROUTINES
        RPT     INTERRUPTSTACKSIZE
        FCB     0
INTSETUP        LDX     #FASTINTERRUPTPOLLCHAIN        = WHERE TO GO ON INTERRUPT
        STX     $FFF8   SET IRQ VECTOR
        RTS
INTERRUPTSTACKEND       EQU     *
        PAGE    *** DRIVER INIT (ONCE-ONLY) CODE ***
IODRIVERRAM     SET     0
IODRIVERINIT    SET     1
        EQU     *-DRIVERBASE    SIZE OF READ-ONLY CODE
DSKBUFFERPOOL   EQU     *
        IF      CLOCK
        INCLUDE IOCLOCK.ASM
        FIN
        IF      BLACKHOLE
        INCLUDE IOBLACKHOLE.ASM
        FIN
        IF      PSILOGFLOP
        INCLUDE IOPSILOGFLOP.ASM
        FIN
        IF      ICOM
        INCLUDE IOICOMFLOPPY.ASM
        FIN
        IF      STORAGEDEMON
        INCLUDE IOSTOREDEMON.ASM
        FIN
RESET:$FAF4     RTS             ITS ALREADY RESET
        IF      LPT
        PAGE    print Reset routines
reset:$FAA4
        clr     LPTpia:ctl      set direction
        clr     LPTpia:ctl2
        LDAA    #$ff
        STAA    LPTpia:dat      all outputs
        clr     LPTpia:sts      all inputs
        LDAA    #$3c    set up CA2 as data strobe, CA1 as ACK
        STAA    LPTpia:ctl
        LDAA    #$3c    set up
        STAA    LPTpia:ctl2
        LDAA    LPTpia:dat      ACK any funny interrupts
        LDAA    LPTpia:sts
        rts
        FIN     LPT
        INCLUDE IOVTCONFIG.ASM
        INCLUDE IOVTDPBS.ASM
        PAGE
        IF      *>/VTDRIVER
        ? DRIVERS TOO BIG ?
        ELSE
        RMB     VTDRIVER-*
        FIN     *>/VTDRIVER
DSKPOOLSIZE     EQU     *-DSKBUFFERPOOL
        EQU     *-CODE  SO I CAN SEE HOW BIG THE WORLD IS
        END
