; Program to place in initialize.sys on booting disk to;

;       o Except name of defaultdisk and set
;       o Except name of MT and chain

        Org $3800   ; assert - 14k is above where MT lives but below userspace

syscall$        equ $FB

Start

        ldx     #PrintMsg2             ; "What is name of defaultdisk <DISK:>? "
        jsr     syscall$
        bcs     exiterror

        ldx     #GetAns2               ; get bare return or device name
        jsr     syscall$
        bcs     exiterror
        ldaa    #$d
        cmpa    getans2buf             ; bare return?
        bne     gotadevice
        ldx     #diskname
        stx     ans2pt
        ldx     #6
        bra     defaulted

gotadevice      equ *
        ldx     ans2len
defaulted
        stx     defaultfnlen

; Check for bare return and insert "DISK:" as default
        ldx     ans2pt
        stx     setdefpt
        ldx     #SetDefault            ; set defaultdisk
        jsr     syscall$
        bcs     exiterror

        ldx     #PrintMsg1             ; "Where is TimeShare File? "
        jsr     syscall$
        bcs     exiterror

        ldx     #GetAns1               ; get filename like "F0:SDMT12d6.5500"
        jsr     syscall$
        bcs     exiterror
        ldaa    #$d
        cmpa    getans1buf             ; bare return?
        bne     gotatsname
        ldx     #tsname
        stx     ans1pt
        ldx     #5
        bra     tsdefaulted
gotatsname
        ldx     ans1len
tsdefaulted
        stx     loadfnlen
        ldx     ans1pt
        stx     loadpt
        ldx     #LoadTS                ; load Timeshare
        jsr     syscall$
        bcs     exiterror

Exiterror
        stx     errorfound
        ldx     #Exiterrornow
        jsr     syscall$
loop7   jmp     loop7

Exiterrornow
        fcb     $12
        fcb     exiterrorend-exiterrornow
errorfound fdb 0
exiterrorend    equ     *

diskname   fcc "DISK:"
           fcb $d
tsname     fcc "SDMT"
           fcb $d

PrintMsg1
        fcb     $c                     ; write ascii
        fcb     printmsg1end-printmsg1
        fcb     0,0
        fdb     printmsg1data
        fdb     printmsg1de-printmsg1data
printmsg1end    equ     *
printmsg1data
;        fcb     $d,$a
        fcc     "Where is TimeShare file <SDMT>? "
printmsg1de     equ     *

PrintMsg2
        fcb     $c                     ; write ascii
        fcb     printmsg2end-printmsg2
        fcb     0,0
        fdb     printmsg2data
        fdb     printmsg2de-printmsg2data
printmsg2end    equ     *
printmsg2data
;        fcb     $d,$a
        fcc     "What is the name of the default disk <DISK:>? "
printmsg2de     equ     *

GetAns1
        fcb     $a
        fcb     getans1end-getans1
        fcb     0,$ff
        rmb     2
        fdb     0
Ans1Len fdb     0
ans1pt  fdb     GetAns1buf
        fdb     getans1bufe-getans1buf
getans1end      equ     *
getans1buf
        rmb     40
getans1bufe     equ     *


GetAns2
        fcb     $a
        fcb     getans2end-getans2
        fcb     0,$ff
        rmb     2
        fdb     0
Ans2Len fdb     0
Ans2pt  fdb     GetAns2buf
        fdb     getans2bufe-getans2buf
getans2end      equ     *
getans2buf
        rmb     40
getans2bufe     equ     *

LoadTS
        fcb     6
        fcb     loadtsend-loadts
        fcb     0,0
Loadpt        fdb     GetAns1buf
LoadFNLEN                              ; From ANS1LEN
        fdb     0
        fdb     0                      ; reply length
        fdb     count
        fdb     addrstart-count+2
loadtsend      equ     *
count   fdb     0
addrstart       fdb     0

SetDefault
        fcb     9
        fcb     Setdefaultend-Setdefault
        fcb     0,0
setdefpt        fdb     GetAns2buf
DEFAULTFNLEN                           ; From ANS2LEN
        fdb     0                      ; reply length
        rmb     2
        fdb     scannedcount
        fdb     2
Setdefaultend      equ     *
scannedcount    fdb     0

        end     start
