*        FLEX EQUATE file
*
*        FLEX entry points
*
*        Memory Map of FHL FLEX (Appendix F)
*
*        0000-B7FF                     User RAM
*        B800-BFFF                     His-Res Screen Drivers and character tables
*        C000-E5FF                     Disk Operating System (FLEX body)
*        E600-FDFF                     Hi-Res Screen memory
*        FE00-FEFF                     Miscellaneous routines
*        C07F                          System Stack
*        C100-C6FF                     Utility Command Space
*        CD00                          FLEX cold start entry address
*        CD03                          FLEX warm start entry address
*
*        File Control Block equates
*
         org   0
FCBFunctionCode rmb 1              ; Desired FMS Function
FCBErrorStatusByte rmb 1           ; Holds error response from FMS
FCBActivityStatus rmb 1            ; 1 --> Open for Read; 2 --> Open for Write
FCBFileSpecification rmb 12        ; Holds complete name of file
         org   FCBFileSpecification
FCBDriveNumber rmb 1               ; holds binary drive number 0-3
FCBFileName rmb 8                  ; zero-padded file name
FCBExtension rmb 3                 ; zero-padded file extension
FCBFileAttributes rmb 1            ; Protection bits for files
         rmb   1                       ; Reserved
FCBFileStartSector rmb 2           ; Points to first sector of file on disk
FCBFileEndSector rmb 2             ; Points to last sector of file on disk
FCBFileSize rmb 2                  ; Holds size of file in sectors
FCBFileSectorMapIndicator rmb 1    ; <>0 --> Random access file
         rmb   1                       ; reserverd
FCBFileCreationDate rmb 3          ; Contain MM DD YY binary-byte form of file creation date
FCBListPointer rmb 2               ; Points to next open FCB
FCBCurrentPosition rmb 2           ; Has disk address of sector in buffer
FCBCurrentRecordNumber rmb 2       ; Has logical record number of sector in buffer
FCBDataIndex rmb 1                 ; Offset of next byte to fetch/store in sector buffer
FCBRandomIndex rmb 1               ; Offset of byte to skip to in buffer
FCBNameWorkBuffer rmb 11           ; Working storage for FMS
FCBCurrentDirectoryAddress rmb 3   ; Used when FCB processing directory
FCBFirstDeletedDirectoryPointer rmb 3 ; Used by FMS when hunting for free directory slot
FCBRenameToFileSpecification rmb 11 ; Used to specify new filename for RENAME
FCBSpaceCompressionFlag equ 59     ; 0 --> compress spaces
FCBSectorBuffer rmb 256            ; Holds data sector from file
FCBsize equ *
         page
*        FLEX FMS Function codes
         org   0
FMS:ReadWriteNextByteCharacter rmb 1   ; read/write byte, advancing sectors
FMS:OpenForRead rmb 1                  ; Open a file for Read-only access
FMS:OpenForWrite rmb 1                 ; Open a new file for Write-only access
FMS:OpenForUpdate rmb 1                ; Open a file for both Read and Write
FMS:CloseFile rmb 1                    ; Close a file
FMS:RewindFile rmb 1                   ; Rewind a file
FMS:OpenDirectory rmb 1                ; Open Directory
FMS:GetInformationRecord rmb 1         ; Get Information Record
FMS:PutInformationRecord rmb 1         ; Put Information Record
FMS:ReadSingleSector rmb 1             ; Read single sector (low-level)
FMS:WriteSingleSector rmb 1            ; Write single sector (low level)
         rmb   1                       ; Reserved
FMS:DeleteFile rmb 1                   ; Delete File
FMS:RenameFile rmb 1                   ; Rename File
         rmb   1                       ; Reserved
FMS:NextSequentialSector rmb 1         ; Read/Write next sequential sector
FMS:OpenSystemInformationRecord rmb 1  ; Used only by FLEX
FMS:GetRandomByteFromSector rmb 1      ; Get Random Byte From Sector
FMS:PutRandomByteInSector rmb 1        ; Put Random Byte In Sector
         rmb   1                       ; reserved
FMS:FindNextDrive rmb 1                ; Find next (ready) drive
FMS:PositionToRecordN rmb 1            ; Position to a Record N (randomly)
FMS:BackupOneRecord rmb 1              ; Backup one record
         page
*        FLEX error codes
*
         org   1
IllegalFMA rmb 1                ; Illegal FMA function code encountered
FileBusy rmb 1                  ; The requested file is in use
FileExists rmb 1                ; The specified file already exists
FileNotFound rmb 1              ; The specified file could not be found
SystemDirectoryError rmb 1      ; System Directory Error- Reboot System
DirectoryFull rmb 1             ; The system directory is full
DiskFull rmb 1                  ; All available disk space has been used
EndOfFile rmb 1                 ; Read past end of file
DiskFileReadError rmb 1         ; Disk file Read error
DiskFileWriteError rmb 1        ; Disk file Write error
WriteProtected rmb 1            ; File or Disk is Write protected
DeleteProtected rmb 1           ; File is protected- file not deleted
BadFileControlBlock rmb 1       ; Illegal File Control Block specified
IllegalDiskAddress rmb 1        ; Illegal Disk Address encountered
IllegalDriveNumber rmb 1        ; Illegal Drive number specified
DriveNotReady rmb 1             ; Drive Not Ready
ReadProtected rmb 1             ; File is protected-access denied.
SystemFileStatusError rmb 1     ; System file status error
FMSDataIndexRangeError rmb 1    ; FMS Data Index Range Error
InactiveFMS rmb 1               ; FMS is inactive
IllegalFileSpecification rmb 1  ; Illegal File Specification
SystemFileCloseError rmb 1      ; System file close error
SectorMapOverflow rmb 1         ; Sector Map Overflow: disk too segemented
NonexistentRecordNumber rmb 1   ; Non-existent record number specified
RecordNumberMatchError rmb 1    ; Record Number match error- file damaged
CommandSyntaxError rmb 1        ; Command Syntax error - retype command
NotWhilePrinting rmb 1          ; That command is not allowed while printing
WrongHardwareConfiguration rmb 1 ; Wrong Hardware Configuration
         if    *#29
? ; FLEXerr codes are defined incorrectly
         fin
EOS      equ   4                ; END OF STRING mark for PSTRNG
         page
*
*        Global variables shared between FLEX and user programs
*
LINEBUFFER     equ $C080               ; Line Buffer (128 bytes)
TTYSETBACKSPACECHARACTER equ $CC00     ; Code to interpret as backspace
TTYSETDELETECHARACTER equ $CC01        ; Code to interpret as line cancel
TTYSETENDOFLINECHARACTER equ $CC02     ; Command seperator character
TTYSETDEPTHCOUNT equ $CC03             ; Page length before PAUSE/Eject
TTYSETWIDTHCOUNT equ $CC04             ; Line width
TTYSETNULLCOUNT equ $CC05              ; Nulls to send after CRLF
TTYSETTABCHARACTER equ $CC06           ; Specifies TAB character
TTYSETBACKSPACEECHOCHARACTER equ $CC07 ; Echoed by FLEX on reciept of Backspace
TTYSETEJECTCOUNT equ $CC08             ; Number of blank lines between pages.
TTYSETPAUSECONTROL equ $CC09           ; Action to take after page eject.
TTYSETESCAPECHARACTER equ $CC0A        ; Character code to cause PAUSE.
SYSTEMDRIVENUMBER equ $CC0B            ; Binary drive number to search for program
WORKINGDRIVENUMBER equ $CC0C           ; Binary driver number to search for data file
SYSTEMDATEREGISTERS equ $CC0E          ; holds MM, DD, YY in binary-byte form
LASTTERMINATOR equ $CC11               ; Holds most recent non-alphnum char seen
USERCOMMANDTABLEADDRESS equ $CC12      ; Address of command extension table.
LINEBUFFERPOINTER equ $CC14            ; Points to next character in Line Buffer
ESCAPERETURNREGISTER equ $CC16         ; Where to go if <RETURN> typed during PAUSE
CURRENTCHARACTER equ $CC18             ; Character last fetched by NXTCH
PREVIOUSCHARACTER equ $CC19            ; What used to be in CURRENTCHARACTER
CURRENTLINENUMBER equ $CC1A            ; # Lines currently on page.
LOADERADDRESSOFFSET equ $CC1B          ; 16 bit bias to add to load addresses
TRANSFERFLAG equ $CC1D                 ; <>0 --> transfer address seen
TRANSFERADDRESS equ $CC1E              ; Where to go if transfer address set
ERRORTYPE equ $CC20                    ; Error type number from FMS routines
SPECIALIOFLAG equ $CC21                ; makes PUTCHR ignore width and disable PAUSEing
OUTPUTSWITCH equ $CC22                 ; 0 --> PUTCHR uses OUTCH, else OUTCH2
INPUTSWITCH equ $CC23                  ; 0 --> GETCHR uses INCH, else INCH2
FILEOUTPUTADDRESS equ $CC24            ; Address of FCB in use for file output
FILEINPUTADDRESS equ $CC26             ; Address of FCB in use for file input
COMMANDFLAG equ $CC27                  ; <>0 if DOS called by user via DOCMND
CURRENTOUTPUTCOLUMN equ $CC28          ; count of # chars currently in line being output to terminal
MEMORYEND equ $CC2B                    ; point to end of user memory
ERRORNAMEVECTOR equ $CC2D              ; 0 --> RPTERR uses ERRORS.SYS
FILEINPUTECHOFLAG equ $CC2f            ; <>0 --> echo input if taken from file
SYSTEMCONSTANTS equ $CC4E              ; System Constants, whatever that means
         page
*        FLEX User-Callable System Routines
COLDS    equ   $CD00                   ; Cold-start entry point
WARMS    equ   $CD03                   ; Warmstart entry point
RENTER   equ   $CD06                   ; DOS Main Loop Re-entry point
INCH     equ   $CD09                   ; Input character: main
INCH2    equ   $CD0C                   ; Input character: secondary
OUTCH    equ   $CD0F                   ; Output character: main
OUTCH2   equ   $CD12                   ; Output character: secondary
GETCHR   equ   $CD15                   ; Get Character
PUTCHR   equ   $CD18                   ; Put Character
INBUFF   equ   $CD1B                   ; Input into Line Buffer
PSTRNG   equ   $CD1E                   ; Print String (after printing CRLF)
CLASS    equ   $CD21                   ; Classify Character
PCRLF    equ   $CD24                   ; Print Carriage Return and Line Feed
NXTCH    equ   $CD27                   ; Get Next Buffer Character
RSTRIO   equ   $CD2A                   ; Restore I/O Vectors
GETFIL   equ   $CD2D                   ; Get File Specification
LOAD     equ   $CD30                   ; File Loader
SETEXT   equ   $CD33                   ; Set Extension
ADDBX    equ   $CD36                   ; Add B-register to X-register
OUTDEC   equ   $CD39                   ; Output Decimal Number
OUTHEX   equ   $CD3C                   ; Output Hexadecimal Number
RPTERR   equ   $CD3F                   ; Report Error
GETHEX   equ   $CD42                   ; Get Hexadecimal Number
OUTADR   equ   $CD45                   ; Output Hexadecimal Address
INDEC    equ   $CD48                   ; Input Decimal Number
DOCMND   equ   $CD4B                   ; Call DOS as a Subroutine
STAT     equ   $CD4E                   ; Check Terminal Input Status
*
*        PRINT.SYS driver equates
*
PINIT    equ   $CCC0                   ; initialize printer
PCHK     equ   $CCD8                   ; check for printer ready
POUT     equ   $CCE4                   ; output character to printer
*
*        FMS entry points
*
FMSINIT  equ   $D400                   ; FMS Initialization
FMSCLOSE equ   $D403                   ; FMS Close
FMS      equ   $D406                   ; FMS Call

FCBBASEPOINTER equ $D409               ; Points to 1st FCB in chain of open FCBs
CURRENTFCBADDRESS equ $D40B            ; Points to last FCB processed by FMS
VERIFYFLAG equ $D435                   ; <>0 --> "Verify after write"
         page
*        Disk Driver entry points
*
READSECTOR equ $DE00                   ; Read a sector from a disk
WRITESECTOR equ $DE03                  ; Write a sector to a disk
VERIFY equ $DE06                       ; Verify a sector for CRC errors
RESTORE equ $DE09                      ; Restore a drive to track 00
DRIVESELECT equ $DE0C                  ; Select drive specified by FCB
CHECKDRIVEREADY equ $DE0F              ; Check to see if drive is ready in 2 seconds
QUICKCHECKDRIVEREADY equ $DE12         ; Check to see if drive is ready NOW
*
*        FHL-defined entry points (Appendix E page 1)
*
ULH      equ   $DE1E                   Unload Heads.
MTROFF   equ   $DE21                   Turn off Drive Motors
FCTE     equ   $DE24                   Find Configuration Table Entry
*
*        Appendix E page 2
*
DEBOUNCECOUNT equ $D3D1                # times keyboard scanned before key registered
BLINKPERIOD   equ $D3D3                Reciprocal of cursor blink frequency
MOTOROFFBLINKLIMIT equ $D3D5           Blinks before motor shuts off
CURSORTYPE equ $D3D7                   $00 = underline, $FF = blinking block
VDGMODE  equ   $D3D9                   Upper 5 bits word set VDG mode
         equ   $D3DB                   Reserved
         equ   $D3DD                   Reserved
         equ   $D3DF                   Reserved
BELLTONECYCLECOUNT equ $D3E1           Duration of bell tone in cycles
BELLTONEHALFPERIOD equ $D3E3           Reciprocal of bell tone frequency
INCHNE   equ   $D3E5                   Get a character from keyboard without echo
         end   ; FLEX equates file
