.ce
BAGL
.sp
BAGL is a notation for representing relations between objects and
computations on those objects.  It has a primitive definition based
only on the idea of a "bag", a set of entities with possible
duplicates, where each entity is a pointers to another bag, and an
extremely small number of primitive operations. More complex values and
operations can be built using just these definitions, including
conventional procedural programming languages operating on numbers,
conceptual graph systems, etc.
.sp
The purpose of BAGL is to provide an absolutely minimal representation
base, which has as few implementation dependent restrictions as
possible.
.sp
While BAGL shares many of LISP's properties, its is conceptually simpler
than LISP, and is implementation indepedent.
.sp
BAGL PRIMITIVE DATA TYPES
.im 3
Definition: BAG
.sp
A BAG is an object which contains an arbitrary, unordered group of
ELEMENTS, which may be empty (called a null bag).  There is an
arbitrarily large supply of unique bags. The same element may appear
multiple times within a single bag. An element is a reference to an
arbitrary bag, including, possibly, the bag containing the element. 
Two elements are said to be EQUIVALENT if they refer to the same bag.
.sp
A Bag without any duplicated elements is traditionally called a SET.
.sp
BAGL PRIMITIVE OPERATORS
.sp
Given two bags, B1 and B2, the following operations may be performed:
.sp
INSERT_NEWLY_CREATED_BAG(B1)
.br
inserts an element into bag B1 which refers to a bag B2 such           
that there are no other references anywhere in the universe to bag B2
(i.e., this element is unique).  Only implementation limit errors
(such as NO BAGS LEFT, NO MORE ROOM IN BAG) can abort this operation.
.sp
COPY_ARBITRARY_ELEMENT_FROM_FIRST_BAG_TO_SECOND(B1,B2)
.br
chooses an element at random from bag B1 and adds that element to B2.
After the operation, both B1 and B2 contain the element.  The operation
will fail if B1 has no elements.
.sp
DELETE_ARBITRARY_ELEMENT_IN_FIRST_BAG_FROM_SECOND_BAG(B1,B2)
.br
chooses an element at random from bag B1 and removes an equivalent
element from bag B2.  The operation will fail if B1 has no elements,
or B2 has no corresponding element.
.sp
DESTROY_BAG(B1)
.br
makes bag B1 evaporate from the universe.  An error will occur if
B1 is referenced by any other bag.
.sp
EQUAL_ELEMENTS(B1,B2) is a predicate which returns an error
if an arbitrary element of B1 does NOT match an arbitrary element of
B2 (the error/nonerror action may be used to produce conventional
boolean values).
.sp
Discussion
.sp
It should be apparant that the above operators are sufficient for the
construction, destruction, and arbitrary copying of the contents of
one bag to another. It is intended that all BAGL-defined operations be
defined in terms of the above operations; thus, BAGL has an extremely
well-defined semantics.
.pa
BAGL PROCEDURES
.sp
A BAGL procedure is a bag which specifies that a particular computation
should take place.  The elements of the bag specify the computation
by referencing bags which have pre-defined meanings.
.pa
Discussion:
.sp
These two kinds of objects are sufficient to represent all known
information! Here we justify this statement.
.sp
Typically, one wishes to represent knowledge as a list of concepts
and relations between those concepts.  In LISP, concepts are generally
represented by ATOMs; in BAGL, a concept is represented by an
arbitrarily chosen bag.
.sp
An ATOM is simply an object which has no internal structure.  There are
arbitrarily many atoms; for any two atoms, the only decision one can
make about them is to decide if they are identical or not.
In LISP, Atoms have externally recognizable print names.
Note that unlike LISP, the concept of Atom DOES NOT INCLUDE the
concept of number.
.sp
In BAGL, the arbitrarily chosen bag that represents a concept may be a
FRAME containing information about the atom, including Print-names,
values, and various properties; this is known as a property-list in
LISP. Unlike LISP, this is true, however, only by convention in a
particular representation. When an element refers to such a frame, we
call it an ATOM.
.sp
The print name of an atom is a sequence of characters. Each character
can be represented by an arbitrarily chosen bag; the sequence can
be stored in another bag structure.  Thus the print name of an atom
can be represented entirely by bags.
              If BAG_FOR_ASCII_A Then Print "A"
              ElseIf BAG_FOR_ASCII_B Then Print "B"
              ...
              ElseIf BAG_FOR_ASCII_Z Then Print "Z"
.sp
A BAG to represent {FRED, SAM ,FRED} is actually stored as
      BAG = { .BAG1 .BAG2 .BAG1 }
where the program, by convention,
interprets the pointer to BAG1 as a reference to FRED, and BAG2 as
a reference to SAM.
.sp
COMPOUND DATA TYPES
.sp
Although not defined by the base representation of BAGL, the concept of
a NUMBER has proven to be very useful.  The concept of POSITIVE INTEGER
is easily defined as a BAG with the appropriate number of atoms in it
(i.e., a UNARY representation); advanced versions of BAGL support an
specially implemented numeric bag, which return a special UNARY bag when a
bag is extracted (thus we defeat the issue of "what
atom is in the bag?").
.sp
The concept of SIGNED INTEGER is easily represented by a two component
bag, of which one element refers to the atom "+" or the atom "-", and
the other element refers to a POSITIVE INTEGER.
.sp
The concept of real is easily represented by a two component bag
referencing two SIGNED INTEGERS; the first is an exponent, the second
the mantissa.  The exponent base is arbitrary.
.sp
FRAME BAGS
.sp
It is useful to construct lists of associations within a single bag
representing an entity.  Such a bag is known as a FRAME in BAGL; it is
traditionally called a property list in LISP. The form of a FRAME is a SET
where each element refers to a two element bag called a PROPERTY-NAME/VALUE
pair. One of the two elements of the PROPERTY-NAME/VALUE pair is the value
of the property, and can refer to any bag (like LISP, the bag can be empty
(null), but unlike LISP, where all null lists are NIL and are therefore the
SAME list, there are an arbitrarily large number of EQUAL but NOT
EQUIVALENT NULL bags). The other element has a specific structure so it can
be determined to be the PROPERTY-NAME by running the procedure
IS-PROPERTY-NAME?. WE NEED A STRUCTURE WHICH THE PROPERTY-VALUE CANNOT
POSSIBLY CONTAIN! The Property-name references an arbitratily chosen bag
that represents the property.
.sp
ASSOCIATION PAIRS
.sp
An association bag contains two sub-bags.  One of the sub-bags represents
a property name, and the other bag represents a property value. The
property-name bag contains two bags, one of which is the special bag
PROPERTY-NAME, and the other is a bag which IS the property name
(i.e., all association pairs which contain, in the property-name bag,
a bag which is identical, have the same property).  The property value
bag contains two bags, one of which is the special bag PROPERTY-VALUE,
and the other which IS the property value.
.sp
ORDER FROM DISORDER
.sp
Careful analysis will reveal that the association pairs may have the bags
PROPERTY-NAME and/or PROPERTY-VALUE as property-names and/or
property-values! One can still determine the actual property name or value
of such a pair, but it might require inspecting both sub-bags to determine
which is REALLY the PROPERTY-VALUE bag, and which is the PROPERTY-NAME bag.
Thus, we have order determinable in the midst of chaos (nondeterminism
caused by definition of bag removal).
.sp
ENVIRONMENTS
.sp
Because BAGL is intended for use by programs which will run experiments
on other programs, one BAGL program MUST be able to establish an
environment for another which is inescapable; otherwise, wanton
destruction by the experimentee might destroy the experimentor.  Thus
we require the notion of an ENVIRONMENT, which contains not only
addressability limitations, but also Time and Space limitations.
Any limit encountered by a BAGL program must be trappable by that program
if it is to build a defense.
.sp
COMPLETE VISIBILITY
.sp
The entire enviroment in which a program runs should be visible, INCLUDING
the runtime system, such as a BAGL interpreter, storage manager, etc.
As little as possible should be "hidden below the surface".
.sp
PORTABILITY
.sp
To ensure that BAGL programs are portable, a limited character set is
used, as defined in this section.  Each character in the set is defined
by a particular bag set up by the implementation.  Input parsing
converts streams of characters into new bags, much like LISP atom
handling.  Once this conversion has been accomplished, BAGL is
independent of the world.
.sp
TRIVIAL IMPLEMENTATION
.sp
BAGL can be implemented by a very simple interpreter.  The interpreter
must manange a large linear virtual address space, say, 2^16 bytes or
more.  Each bag uses at least 3 bytes of this space.
A particular bag lives at a fixed address in this space, and consists
of a list of LISP-like CONS cells, called BAG CELLS. BAG CELLS
have two parts, nominally a pointer to a bag, and pointer to another
bag cell.  Unlike lisp, there is no mechanism for a BAGL program
to generate, reference or adjust a bag cell; bag cells are used
ONLY by the implementation.  Initially, all bag cells available are
placed in a free bag cell list.  Bag Creation causes a bag cell to
be removed from the free cell list, and the bag cell initialized
with a zero reference count in the bag pointer, and an end-of-bag
mark placed in the next-bag-cell link.  Insertion of a bag into
a bag causes a bag cell to be allocated and inserted in the
bag cell list for the target bag, with its bag pointer pointing
to the to-be-inserted bag.  The reference count on the inserted
bag in bumped.  Deletion of an element from a bag decrements the
reference count of the bag selected by the 2nd bag cell in the
bag cell list; if the deleted bag's reference count goes to zero,
its bag cell is returned to free space.
Special WHOLENUMBER bags are specially tagged BAG pointers that simply
contain a counter.
If such a bag has the special "unit" bag cell inserted, the counter
is incremented; if a bag is deleted, the counter is decremented.
Insertion of a non-unit bag causes allocation of a bag cell, and a mixed
list is constructed.





  Cheap garbage collection is
handled by reference counts; although reference counting does not
gaurantee that freed lists are collectible, it significantly reduces
garbage collection overhead.
.PA
Should BAGL be applicative? I don't know. Cheap solution is NO.
I choose cheap solution. We'll work on fancy versions of paralellism later.

A BAGL procedure is a bag specifying a computation.  The computation is
specified by the form of the bag contents, and by which bags are referenced
by the bag contents.

Certain specially designated bags represent primitive BAGL computations.
These operations are listed above, and are THE only primitive BAGL
computations.  More complex computations are ALWAYS composed of the
simpler ones.

We don't need conditional branch if we have error trap.

Three bag rder is not possible. Assume 3 bag tags: 1st, 2nd, 3rd.
     Consider the bag { {1st,2nd} {2nd,3rd}, {3rd,1st}}
     There is no way to determine whether this bag means (order intended)
              { {1st,2nd} {2nd,3rd}, {3rd,1st}}
     or
              { {1st,3rd} {2nd,1st}  {3rd,2nd}}  (order intended)


BAGL argument passing: caller constructs bag of arguments at call site,
duplicates procedure it desires to call, inserts the arguments into
duplicate, and passes control to duplicate bag.  Thus procedures are
pure; activations consist of procedure's code body.
        Code consists of...
        ...delete contents of bag Z...  (gets rid of previous invocation)
        ...copy procedure into bag Z...
        ...compute parameter 1...
        ...insert into Z everywhere necessary...
        ...compute parameter 2...
        ...insert into Z everywhere necessary...
        ...compute parameter 3....
        <etc.
        ...insert into Z everywhere necessary...
        ...bag Z is here....
        ....

     Propose bags called FIRST, SECOND, THIRD.




How to implement COPY_BAG
