capability:name rmb 8                  capability name bits
capability:redundancy equ capability:name 6 bytes matching object redundancy
capability:bits equ capability:name+6  16 capability bits
capability:net  rmb 1                  network number
capability:node rmb 1                  node number within network
capability:type rmb 1                  holds type of object referenced
*                                      0 is network
*                                      1 is node in network
*                                      2 is address space in node
*                                      3 is mass store device in node
*                                      4 is Virtual Terminal device
*                                      5 is task within node
*                                      6 is job within node
*                                      7 is user
*                                      8 is file
*                                      etc.
capability:object rmb 4                selects object in type-dependent way
*                                      for main store, is bit address
*                                      for tasks, is task id
*                                      for mass store, is sector number

capabilityhashtable:name rmb 8         hold capability name bits
capabilityhashtable:bits rmb 2         holds decrypted capability bits
capabilityhashtable:fnlist rmb 2       points to list of fns on capability
capabilityhashtable:objectid rmb 4     holds reference to object selected
*                                      (usually system space address of object)

*        SYSTEM CALL DECODER
*        Accepts a Capability-SDOS call and decodes it
*
CapabilityFunction ; enter here with (X) pointing to capability
;        (A) contains desired function code
;
         ldb   capability:node,x       can we do function in this node ?
         cmpb  nodeidentity            (does capability ref this node ?)
         bne   CapabilityFunctionRemote b/ no, forward request to another node
         psha                          save function code
         ldd   capability:name+6,x     get "hash function" of capability
         andd  capabilityhashtablemask drop unnecessary bits
         addd  capabilityhashtable     add table base
         tfr   d,u                     set for lookup
         ldd   capability:name,x       is slot occupied by same capability ?
         subd  capability:name,u       ...?
         bne   CapabilityFunctionDecrypt b/ no (high probability if not same)
         ldd   capability:name+2,x     ...?
         subd  capability:name+2,u
         bne   CapabilityFunctionDecrypt b/ no
         ldd   capability:name+4,x     ...?
         subd  capability:name+4,x
         bne   CapabilityFunctionDecrypt b/ no
         ldd   capability:name+6,x     ...?
         subd  capability:name+6,x
         beq   CapabilityFunctionDecrypted b/ yes
CapabilityFunctionDecrypt ; this slot contains non-matching capability
         jsr   Decrypt                 decrypt capability
         jsr   ValidateCapability      locate object referenced
         ; check capability:redundancy against object
         bne   CapabilityFunctionObjectDestroyed b/ no such object
         ldd   capability:name,x       set capability hash table slot
         std   capability:name,u
         ldd   capability:name+2,x
         std   capability:name+2,u
         ldd   capability:name+4,x
         std   capability:name+4,u
         ldd   capability:name+6,x
         std   capability:name+6,u
         ldd   capability:bits??,x     fetch decrypted capability bits
         std   capabilityhashtable:bits,u
         ldd   capabilityfunctionlist  fetch pointer to list of functions
         std   capabilityhashtable:fnlist,u
CapabilityFunctionDecrypted ; slot contains matching capability
         ldd   capabilityhashtable:bits,u fetch capability bits
         ldx   capabilityhashtable:fnlist,u get fn list pointer
         pula                          get function code back
         tsta                          legal function code ?
         bmi   ErrIllegalFunctionOnObject b/ no
CapabilityFunctionSearch ; search for specified function
         leax  2,x                     advance to next table entry
         cmpa  ,x+                     this function code desired ?
         beq   CapabilityFunctionFound b/ yes
         bvc   CapabilityFunctionSearch b/ not found yet
ErrIllegalFunctionOnObject ; Function code given is completely unreasonable
         ldx   #Err:IllegalFunctionOnObject
         sec
         rts

CapabilityFunctionFound ; legal capability function requested
;        (u) points to capabilityhashtable slot containing object id
         jmp   [,x]                    go to function routine

