	page	definitions
entry:channel	equ	0
entry:key	equ	1
entry:node	equ	5
entry:size	equ	6


nettcb:closeflag	equ	tcb:size
nettcb:opcrflag	equ	nettcb:closeflag+1
nettcb:nodenum	equ	nettcb:opcrflag+1
nettcb:entryptr	equ	nettcb:nodenum+1
nettcb:freesize	equ	nettcb:entryptr+2
nettcb:freespace	equ	nettcb:freesize+2
nettcb:keyptr	equ	nettcb:freespace+2
nettcb:scblkptr	equ	nettcb:keyptr+2
nettcb:scblk	equ	nettcb:scblkptr+2
nettcb:size	equ	nettcb:scblk+scblk:end
	page	function manager...
functioninit	ldx	#socketmbury
	stx	sdnetsocketmbury


functionmanager	sts	goodstack	to get back to basic with...
	jsr	getsocketforfnrec
	bcs	goback	no body to talk to!
	jsr	recbyte
	cmpa	#iosyscall
	beq	dosyscall
	jsr	releasesocket
goback	clc
	rts

dosyscall	jsr	recbyte
	psha
	jsr	recbyte
	anda	#$7f
	tab
	ldx	curtcb
	ldx	nettcb:scblkptr,x
	staa	1,x
	pulb
	stab	0,x
	suba	#2
	beq	gotblock	no more scblock in link
	inx
	inx
	tab
	clra
	jsr	recblock	get the rest

gotblock	ldx	curtcb
	ldx	nettcb:scblkptr,x
	ldab	#scblk:end
	subb	scblk:wlen,x
	beq	allocatebufs

clearitloop	clr	scblk:end-1,x
	dex
	decb
	bne	clearitloop

allocatebufs	ldx	curtcb
	ldaa	nettcb:freespace,x
	ldab	nettcb:freespace+1,x
	staa	nettcb:scblk+scblk:wrbuf,x
	stab	nettcb:scblk+scblk:wrbuf+1,x
	addb	nettcb:scblk+scblk:wrlen+1,x
	adca	nettcb:scblk+scblk:wrlen,x
	staa	nettcb:scblk+scblk:rdbuf,x
	stab	nettcb:scblk+scblk:rdbuf+1,x
	ldaa	nettcb:freesize,x
	ldab	nettcb:freesize+1,x
	subb	nettcb:scblk+scblk:wrlen+1,x
	sbca	nettcb:scblk+scblk:wrlen,x
	bcs	nospace
	subb	nettcb:scblk+scblk:rdlen+1,x
	sbca	nettcb:scblk+scblk:rdlen,x
	bcs	nospace

	ldx	curtcb
	ldaa	nettcb:scblk,x
	asla
	staa	tempx+1
	ldaa	#firstbranchad/256
	staa	tempx
	ldx	tempx
	ldx	firstbranchad\256,x
	jmp	0,x

firstbranchad	equ	*
	fdb	opcr	:open
	fdb	opcr	:create
	fdb	closecall	:close
	fdb	channelop	:rename
	fdb	getwrbuf	:delete
	fdb	changetoopen	:load
	fdb	changetoopen	:chain
	fdb	changetocreate	:creatlog
	fdb	closecall	:closelog
	fdb	getwrbuf	:diskdefault
	fdb	channelop	:reada
	fdb	channelop	:readb
	fdb	channelop	:writea
	fdb	channelop	:writeb
	fdb	channelop	:control
	fdb	channelop	:status
	page	scblk is too big...
nospace	ldaa	nettcb:scblk+scblk:opcode,x
	asla
	staa	tempx+1
	ldaa	#toobigbranch/256
	staa	tempx
	ldx	tempx
	ldx	toobigbranch\256,x
	jmp	0,x

toobigbranch	equ	*

	fdb	eatwrbuf	:open
	fdb	eatwrbuf	:create
	fdb	eatcapwrbuf	:close
	fdb	eatcapwrbuf	:rename
	fdb	eatwrbuf	:delete
	fdb	eatwrbuf	:load
	fdb	eatwrbuf	:chain	how did we get this?
	fdb	eatwrbuf	:createlog
	fdb	eatwrbuf	:closelog
	fdb	eatwrbuf	:diskdefault
	fdb	readatoobig	:reada
	fdb	readbtoobig	:readb
	fdb	writetoobig	:writea
	fdb	writetoobig	:writeb
	fdb	eatcapwrbuf	:control
	fdb	eatcapwrbuf	:status
	page	open/create calls
opcr	jsr	allocatechan	get me a new channel #
	bcc	opcr2
	ldx	#illegalentry	who will get some funny error

opcr2	stx	tempx
	ldx	curtcb
	ldaa	tempx
	ldab	tempx+1
	staa	nettcb:entryptr,x
	stab	nettcb:entryptr+1,x
	dec	nettcb:opcrflag,x
	ldx	tempx
	ldaa	entry:channel,x
	ldx	curtcb
	staa	nettcb:scblk+scblk:params,x
	jmp	getwrbuf

opcrwrapup	tsta
	bne	opcroops
	tstb
	bne	opcroops
	ldx	curtcb
	ldx	nettcb:entryptr,x
	rpt	entry:key
	inx
	ldab	#4
	clra
	jsr	xmitblock
	ldx	curtcb
	ldaa	nettcb:nodenum,x
	ldx	nettcb:entryptr,x
	staa	entry:node,x

opcrwu2	jsr	releasesocket
	ldx	curtcb
	clr	nettcb:opcrflag,x
	jmp	functionmanager


opcroops	equ	*
	clra
	jsr	xmitbyte	zero capability
	clra
	jsr	xmitbyte	zero capability
	clra
	jsr	xmitbyte	zero capability
	clra
	jsr	xmitbyte	zero capability

	ldx	curtcb
	ldx	nettcb:entryptr,x
	ldaa	0,x
	inx		assert entry:key=1
	jsr	deallocatechan
	bra	opcrwu2
	page	close call
closecall	ldx	curtcb
	inc	nettcb:closeflag,x
	jmp	channelop

closewrapup	ldx	curtcb
	ldaa	nettcb:scblk+scblk:params,x	=channel #
	clr	nettcb:closeflag,x
	ldx	nettcb:keyptr,x
	jsr	deallocatechan
	jsr	releasesocket
	jmp	functionmanager
	page	funny calls
changetoopen	ldaa	#syscall:open
	sk2
changetocreate	ldaa	#syscall:create
	ldx	curtcb
	staa	nettcb:scblk+scblk:opcode,x
	jmp	opcr
	page	normal calls
channelop	bsr	channelopsb
getwrbuf	bsr	getwrbufsb
	jmp	doit

channelopsb	ldx	curtcb
	ldx	nettcb:keyptr,x
	ldab	#4
	clra
	jsr	recblock
	ldx	curtcb
	ldx	nettcb:keyptr,x
	jsr	convertkeytochan
	ldaa	0,x
	ldx	curtcb
	staa	nettcb:scblk+scblk:params,x
	rts

getwrbufsb	ldx	curtcb
	ldaa	nettcb:scblk+scblk:wrlen,x
	ldab	nettcb:scblk+scblk:wrlen+1,x
	ldx	nettcb:scblk+scblk:wrbuf,x
	jmp	recblock
	page	do the syscall
doit	ldx	curtcb
	ldx	nettcb:scblkptr,x
	jsr	$fb
	bcs	oops
	ldx	#0
oops	stx	tempx
	ldaa	tempx
	ldab	tempx+1
	pshb
	psha
	bsr	xmitrdbuf
	clra
	jsr	xmitbyte
	clra
	jsr	xmitbyte
	tsx
	ldaa	0,x	get msb of error
	jsr	xmitbyte
	tsx
	ldaa	1,x	get lsb of error
	jsr	xmitbyte
	pula
	pulb
	ldx	curtcb
	tst	nettcb:opcrflag,x
	bne	jopcrwu
	tst	nettcb:closeflag,x
	bne	jclosewu
	jsr	releasesocket
	jmp	functionmanager	next!

jopcrwu	jmp	opcrwrapup
jclosewu	jmp	closewrapup

xmitrdbuf	ldx	curtcb
	ldx	nettcb:scblk+scblk:rplen,x
	beq	dontxmit
	ldx	curtcb
	ldaa	nettcb:scblk+scblk:rplen,x
	jsr	xmitbyte
	ldx	curtcb
	ldaa	nettcb:scblk+scblk:rplen+1,x
	jsr	xmitbyte

	ldx	curtcb
	ldaa	nettcb:scblk+scblk:rplen,x
	ldab	nettcb:scblk+scblk:rplen+1,x
	ldx	nettcb:scblk+scblk:rdbuf,x
	jmp	xmitblock
dontxmit	clc
	rts
	page	read ascii request too large
readatoobig	ldx	curtcb
	ldaa	nettcb:scblk+scblk:params+1,x	line mode?
	bne	lmreadatb	yes, just shorten line
	jmp	readbtoobig	no, do it in chunks

lmreadatb	ldx	curtcb
	ldaa	nettcb:freesize,x
	ldab	nettcb:freesize+1,x
	staa	nettcb:scblk+scblk:rdlen,x
	stab	nettcb:scblk+scblk:rdlen+1,x
	jsr	channelopsb
	jsr	eatwrbufsb
	jmp	doit
	page	read binary too large

readbtoobig	ldx	curtcb
	ldx	nettcb:scblk+scblk:wrlen,x
	beq	readbreallytb
	jsr	channelopsb
	jsr	eatwrbuf	why is there a write buffer?
	ldx	curtcb
	clr	nettcb:scblk+scblk:wrlen,x
	clr	nettcb:scblk+scblk:wrlen+1,x
	ldd	nettcb:freespace,x
	std	nettcb:scblk+scblk:rdbuf,x
	bra	readbrtb2

readbreallytb	jsr	channelopsb
readbrtb2	ldx	curtcb
	clr	nettcb:scblk+scblk:rplen,x
	clr	nettcb:scblk+scblk:rplen+1,x
	ldaa	nettcb:scblk+scblk:rdlen,x
	ldab	nettcb:scblk+scblk:rdlen+1,x
	pshb
	psha
readbloop	pula
	pulb
	ldx	curtcb
	subb	nettcb:scblk+scblk:rplen+1,x
	sbca	nettcb:scblk+scblk:rplen,x
	bne	readbloop2
	tstb
	beq	wrdonej
readbloop2	pshd
	cmpa	nettcb:freesize,x
	bgt	rdusefs
	blt	rduseleft
	cmpb	nettcb:freesize,x
	bhi	rdusefs
rduseleft	std	nettcb:scblk+scblk:rdlen,x
	bra	doreadb

rdusefs	ldd	nettcb:freesize,x
	bra	rduseleft

doreadb	ldx	nettcb:scblkptr,x
	jsr	$fb
	bcs	readboops

	ldx	curtcb
	ldd	nettcb:scblk+scblk:rplen,x
	bne	doreadb2
	tsta
	beq	readbloop	don't xmit a zero count!

doreadb2	pshb
	jsr	xmitbyte
	pula
	jsr	xmitbyte

	ldx	curtcb
	ldd	nettcb:scblk+scblk:rplen,x
	ldx	nettcb:scblk+scblk:rdbuf,x
	jsr	xmitblock
	bra	readbloop

wrdonej	jmp	wrdone

readboops	stx	tempx
	ldd	tempx
	pshd
	ldx	curtcb
	ldd	nettcb:scblk+scblk:rplen,x
	bne	readboops3
	tsta
	beq	readboops2
readboops3	equ	*
	pshb
	jsr	xmitbyte
	pula
	jsr	xmitbyte
	ldx	curtcb
	ldd	nettcb:scblk+scblk:rplen,x
	ldx	nettcb:scblk+scblk:rdbuf,x
	jsr	xmitblock

readboops2	clra
	jsr	xmitbyte
	clra
	jsr	xmitbyte
	pula
	jsr	xmitbyte
	pula
	jsr	xmitbyte
	jmp	wrwrapup
	page	write too big
writetoobig	ldx	curtcb
	ldx	nettcb:scblk+scblk:rdlen,x
	beq	writereallytb
	ldx	curtcb
	clr	nettcb:scblk+scblk:rdlen,x
	clr	nettcb:scblk+scblk:rdlen+1,x
	jmp	allocatebufs

writereallytb	ldx	curtcb
	ldd	nettcb:scblk+scblk:wrlen,x
	pshd
	clr	nettcb:scblk+scblk:wrlen,x
	clr	nettcb:scblk+scblk:wrlen+1,x
	jsr	channelopsb	get channel number

writeloop	ldx	curtcb
	puld
	subd	nettcb:scblk+scblk:wrlen,x
	bne	writeloop2
	tstb
	beq	wrdone

writeloop2	pshd
	cmpa	nettcb:freesize,x
	bgt	wrusefs
	blt	wruseleft
	cmpb	nettcb:freesize+1,x
	bhi	wrusefs

wruseleft	std	nettcb:scblk+scblk:wrlen,x
	bra	dowrite

wrusefs	ldd	nettcb:freesize,x
	bra	wruseleft

dowrite	jsr	getwrbufsb	get the stuff off the link
	ldx	curtcb
	ldx	nettcb:scblkptr,x
	jsr	$fb
	bcc	writeloop

*	error!!!
	stx	tempx
	puld
	ldx	curtcb
	subd	nettcb:scblk+scblk:wrlen,x
	bne	wrerr
	tstb
	beq	giveerror
wrerr	std	tempx+2
	ldd	tempx
	pshd
	ldd	tempx+2

wreatwr	pshd
	jsr	recbyte
	puld
	subb	#1
	sbca	#0
	bne	wreatwr
	tstb
	bne	wreatwr
	bra	giveerror2

giveerror	ldd	tempx
	pshd

giveerror2	clra
	jsr	xmitbyte
	clra
	jsr	xmitbyte
	pula
	jsr	xmitbyte
	pula
	jsr	xmitbyte

wrwrapup	jsr	releasesocket
	jmp	functionmanager

wrdone	clr	tempx
	clr	tempx+1
	bra	giveerror
	page	error recovery routines
eatcapwrbuf	rpt	4
	jsr	recbyte

eatwrbuf	bsr	eatwrbufsb
	clra
	jsr	xmitbyte
	clra
	jsr	xmitbyte

	ldaa	#err:scblktoobig/256
	jsr	xmitbyte
	ldab	#err:scblktoobig&$ff
	jsr	xmitbyte

	jsr	releasesocket
	jmp	functionmanager

eatwrbufsb	ldx	curtcb
	ldd	nettcb:scblk+scblk:wrlen,x
	bne	eatloop
	tsta
	bne	eatloop
	rts

eatloop	pshd
	jsr	recbyte
	puld
	subb	#1
	sbca	#0
	bne	eatloop
	tstb
	bne	eatloop
	rts
	page	multi-tasking subroutines
*
*
*	allocate channel
*
*
allocatechan	ldx	#chantablesemaphore
	jsr	allocatesema

	ldx	#channeltable

findchanl	tst	entry:channel,x
	beq	nochannels

	ldaa	entry:key,x
	oraa	entry:key+1,x
	oraa	entry:key+2,x
	oraa	entry:key+3,x
	beq	foundchan

	rpt	entry:size
	inx
	bra	findchanl

nochannels	ldx	#chantablesemaphore
	jsr	deallocatesema
	sec
	rts

foundchan	stx	tempx
	ldd	tempx
	pshd
	jsr	genkey
	stx	tempx+2
	std	tempx+4
	puld
	std	tempx
	ldx	tempx
	ldd	tempx+2
	std	entry:key,x
	ldd	tempx+4
	std	entry:key+2,x

	ldx	#chantablesemaphore
	jsr	deallocatesema
	ldx	tempx
	clc
	rts
	page
*
*	convert key to channel
*
*	(x)->4 byte key   returns (x)->entry
*
convertkeytochan	equ	*

	stx	tempx
	ldd	0,x
	ldx	#channeltable

convertloop	cmpa	entry:key,x
	bne	nextconv
	cmpb	entry:key+1,x
	bne	nextconv
	stx	tempx+2
	ldx	tempx
	ldd	2,x
	ldx	tempx+2
	cmpa	entry:key+2,x
	bne	nextconv1
	cmpb	entry:key+3,x
	bne	nextconv1
	clc
	rts

nextconv1	stx	tempx+2
	ldx	tempx
	ldd	0,x
	ldx	tempx+2

nextconv	rpt	entry:size
	inx
	tst	0,x
	bne	convertloop
	sec
	rts
	page
*
*	convert channel # in a to a entry pointer
*	in x.  does not use tempx, +1
*
converttoentry	deca
	asla		*2
	tab
	asla		*4
	aba		*6	assert entry:size=6
	ldab	#channeltable/256
	adda	#channeltable&$ff
	adcb	#0
	stab	tempx+2
	staa	tempx+3
	ldx	tempx+2
	rts
	page
*
*	deallocate channel
*		(a)=channel
*		(x)->capability
*
deallocatechan	stx	tempx
	bsr	converttoentry
	stx	tempx+2
	ldd	entry:key,x
	ldx	tempx
	cmpa	0,x
	bne	badcapability
	cmpb	1,x
	bne	badcapability
	ldd	2,x
	ldx	tempx+2
	cmpa	entry:key+2,x
	bne	badcapability
	cmpb	entry:key+3,x
	bne	badcapability
	
*	is this a free channel?

	ldaa	entry:key,x
	oraa	entry:key+1,x
	oraa	entry:key+2,x
	oraa	entry:key+3,x
	beq	badcapability

	clr	entry:key,x
	clr	entry:key+1,x
	clr	entry:key+2,x
	clr	entry:key+3,x
	clr	entry:node,x

	clc
	rts

badcapability	sec
	rts
	page
*
*	allocate semaphore
*
allocatesema	clc
	ror	0,x
	bcs	mine
	jsr	sdos+sdos:waitevent
	bra	allocatesema	make sure...

mine	rts

*
*	deallocate semaphore
*
deallocatesema	inc	0,x
	rts
	page	net interface routines
xmitbyte	ldx	curtcb
	tab
	ldaa	nettcb:nodenum,x
	jsr	sdnetxmitbyte	who knows...
	rts


xmitblock	stx	tempx
	std	tempx+2
	ldx	tempx+2
	beq	xmitrts

	pshd
	ldd	tempx
	pshd

xmitloop	tsx
	ldx	0,x
	ldaa	0,x
	inx
	stx	tempx
	tsx
	ldab	tempx
	stab	0,x
	ldab	tempx+1
	stab	1,x
	bsr	xmitbyte

	tsx
	ldx	2,x
	dex
	stx	tempx
	beq	xmitblockend
	ldd	tempx
	tsx
	std	2,x
	bra	xmitloop

xmitblockend	rpt	4
	ins
xmitrts	rts

recbyte	ldx	curtcb
	ldaa	nettcb:nodenum,x
	jsr	sdnetrecbyte
	tba
	nop	for breakpointing
	rts

recblock	pshd
	stx	tempx
	ldd	tempx
	pshd

	tsx
	ldx	2,x
	beq	xmitblockend

recblockloop	bsr	recbyte
	tsx
	ldx	0,x
	staa	0,x
	inx
	stx	tempx
	ldd	tempx
	tsx
	std	0,x
	ldx	2,x
	dex
	stx	tempx
	beq	xmitblockend
	ldd	tempx
	tsx
	std	2,x
	bra	recblockloop

releasesocket	rts
	nop
	nop

getsocketforfnrec	jsr	sdnetpoll
	beq	nothingtodo	yes, nobody is ready
	ldaa	nrb:nodenum,x
	ldx	curtcb
	staa	nettcb:nodenum,x
	clc
	rts

nothingtodo	sec
	rts
	page	socket died!
socketmbury	ldaa	nrb:nodenum,x
	psha
	jsr	sdnetopennode	reopen the guy...
	pula
	ldx	curtcb
	staa	nettcb:nodenum,x

	ldaa	#channeltable/256
	ldab	#channeltable&$ff
	staa	nettcb:entryptr,x
	stab	nettcb:entryptr+1,x

	ldaa	#syscall:close
	staa	nettcb:scblk,x
	ldaa	#3
	staa	nettcb:scblk+1,x

getthis	ldx	curtcb
	ldaa	nettcb:nodenum,x
	ldx	nettcb:entryptr,x
	cmpa	entry:node,x
	bne	getnext

	ldaa	entry:channel,x
	ldx	curtcb
	staa	nettcb:scblk+scblk:params,x
	ldx	nettcb:scblkptr,x
	jsr	$fb	hello sdos
	bcs	*+2	i don't care what error i get
	ldx	curtcb
	ldx	nettcb:entryptr,x
	clr	entry:key,x
	clr	entry:key+1,x
	clr	entry:key+2,x
	clr	entry:key+3,x
	clr	entry:node,x	free!

getnext	tst	entry:channel,x	done?
	beq	alldone
	ldx	curtcb
	ldd	nettcb:entryptr,x
	addb	#entry:size
	adca	#0
	std	nettcb:entryptr,x
	bra	getthis

alldone	lds	goodstack
	clc
	rts	back to the user...
	page	variables, etc.
iosyscall	equ	$e5

illegalentry	fcb	$f0,0,0,0,0
channeltable	equ	*
	rpt	nchannels
	fcb	1+(*-channeltable)/6,0,0,0,0,0
	fcb	0,0,0,0,0,0	end of table


goodstack	rmb	2
chantablesemaphore	fcb	1	not busy...
curtcb	fdb	psuedotcb


psuedotcb	rmb	tcb:size	since i can't use user's tcb
	fcb	0	:closeflag
	fcb	0	:opcrflag
	fcb	0	:nodenum
	fdb	changed	:entryptr
	fdb	freesize
	fdb	freespace
	fdb	psuedokey	:keyptr
	fdb	*+2
	rmb	scblk:end
psuedokey	rmb	4

freesize	equ	$800
freespace	rmb	freesize
	end
