*
* Point to Point Line drawing variables
*
LINEPOINT      RMB 2                   Address of line point display routine
LINEXSTEP      RMB 2                   Step for X (+1 or -1)
LINEYSTEP      RMB 2                   Step for Y (+1 or -1)
LINEDX         RMB 2                   Delta X for line (Absolute)
LINEDY         RMB 2                   Delta Y for line (Absolute)
LINEDECISION   RMB 2                   Decision variable for Y step
LINEDINC1      RMB 2                   Decision variable increment #1
LINEDINC2      RMB 2                   Decision variable increment #2
LINEX          RMB 2                   Untranslated X for line
LINEY          RMB 2                   Untranslated Y for line
LINEDYSIGNED   RMB 2                   Delta Y for line
LINEXEND       RMB 2                   Untranslated X end value

*
* Draw a line
*
DRAWLINE
         LDX   #0                      Set line start to origin
         STX   LINEX
         STX   LINEY
         LDX   #1                      Assume Delta X & Delta Y positive
         STX   LINEXSTEP
         STX   LINEYSTEP
         LDX   #-1                     Possible neg delta
         LDD   LINEY2                  Y2-Y1
         SUBD  LINEY1                  Neg delta Y ?
         STD   LINEDYSIGNED            Save true delta Y
         BPL   DRAWLINE1                No
         STX   LINEYSTEP                Yes, set neg step
         NEGD                          ABS(Y2-Y1)
DRAWLINE1
         STD   LINEDY                  Delta Y for line
         LDD   LINEX2                  X2-X1
         SUBD  LINEX1                  Neg delta X ?
         STD   LINEXEND                Assume termination dX
         BPL   DRAWLINE2                No
         STX   LINEXSTEP                Yes, set neg step
         NEGD                          ABS(X2-X1)
DRAWLINE2
         STD   LINEDX                  Delta X for line
         LDX   #LINEPOINTXY            Assume dX >= dY
         STX   LINEPOINT                and point to line output routine
         CMPD  LINEDY                  dX >= dY ?
         BHS   DRAWLINE3                Yes
         LDX   #LINEPOINTYX             No, set line output to
         STX   LINEPOINT                 swap X and Y
         LDX   LINEDY                  Swap dX and dY
         STX   LINEDX                   so dX >= dY
         STD   LINEDY                    is assured
         LDD   LINEDYSIGNED            X and Y are swapped so
         STD   LINEXEND                 terminate on dY value
DRAWLINE3
         LDD   LINEDY                  d := 2 * dY - dX
         LSLD
         SUBD  LINEDX
         STD   LINEDECISION            Set y incr decision variable
         LDD   LINEDY                  incr1 := 2 * dY
         LSLD
         STD   LINEDINC1               Set decision variable incr #1
         LDD   LINEDY                  incr2 := 2 * (dY-dX)
         SUBD  LINEDX
         LSLD
         STD   LINEDINC2               Set decision variable incr #2
LINEDPOINT                       ; Draw a line point
         JSR   [LINEPOINT]
         LDD   LINEX                   Get current X
         CMPD  LINEXEND                X at end value ?
         BEQ   LINEENDDOT               Yes


*
* Routines to translate (LINEX,LINEY) to screen coordinates
*
LINEPOINTXY                            ; Translate by line start point
         LDD   LINEX
         ADDD  LINEX1
         TFR   D,X                     X
         LDD   LINEY
         ADDD  LINEY1                  Y
         JMP   DRAWDOTATXY             .

LINEPOINTYX                            ; Swap coordinates and translate
         LDD   LINEY
         ADDD  LINEX1
         TFR   D,X                     X
         LDD   LINEX
         ADDD  LINEY1                  Y
         JMP   DRAWDOTATXY             .
