*       EACH CHARACTER BIT PATTERN OCCUPIES A 5 BY 7 MATRIX
*       THIS BIT PATTERN OCCUPIES 7 CONTIGUOUS BYTES...
*       WITH THE FIRST BYTE BEING THE FIRST DOT ROW OF THE CHARACTER, ETC.
*       THE 5 X 7 BIT MATRIX IS RIGHT JUSTIFIED IN THE BLOCK OF BYTES
*       THE TABLE IS ORDERED IN ASCII SEQUENCE...
*       SO THE PROCESS OF FINDING THE BIT MATRIX FOR A CHARACTER...
*       IS SIMPLY: LOC(BIT MATRIX):=CHARACTERSET+(CHAR-$20)*7
*       1ST BYTE OF CHARACTER HAS SIGN BIT SET IF CHARACTER HAS TAIL (SMALL G,J,P,Q,Y)

CHBLANK FCB     %00000  BLANK
        FCB     %00000
        FCB     %00000
        FCB     %00000
        FCB     %00000
        FCB     %00000
        FCB     %00000

CHBANG  FCB     %00100  ! BANG
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00000
        FCB     %00100

CHDBLQ  FCB     %01010  " DOUBLE QUOTE
        FCB     %01010
        FCB     %00000
        FCB     %00000
        FCB     %00000
        FCB     %00000
        FCB     %00000

CHHASH  FCB     %01010  # HASH
        FCB     %01010
        FCB     %11111
        FCB     %01010
        FCB     %11111
        FCB     %01010
        FCB     %01010

CHDOLR  FCB     %00100  $ DOLLAR
        FCB     %01111
        FCB     %10100
        FCB     %01110
        FCB     %00101
        FCB     %11110
        FCB     %00100

CHPCNT  FCB     %11001  % PERCENT
        FCB     %11001
        FCB     %00010
        FCB     %00100
        FCB     %01000
        FCB     %10011
        FCB     %10011

CHAMP   FCB     %01100  & AMPERSAND
        FCB     %10010
        FCB     %01100
        FCB     %11000
        FCB     %10101
        FCB     %10010
        FCB     %01101

CHSGQ   FCB     %00100  ' SINGLE QUOTE
        FCB     %00100
        FCB     %00100
        FCB     %00000
        FCB     %00000
        FCB     %00000
        FCB     %00000

CHLP    FCB     %00010  ( LEFT PARENTHESES
        FCB     %00100
        FCB     %01000
        FCB     %01000
        FCB     %01000
        FCB     %00100
        FCB     %00010

CHRP    FCB     %01000  ) RIGHT PARENTHESES
        FCB     %00100
        FCB     %00010
        FCB     %00010
        FCB     %00010
        FCB     %00100
        FCB     %01000

CHSTAR  FCB     %00100  * ASTERISK
        FCB     %10101
        FCB     %01110
        FCB     %11111
        FCB     %01110
        FCB     %10101
        FCB     %00100

CHPLUS  FCB     %00000  + PLUS
        FCB     %00100
        FCB     %00100
        FCB     %11111
        FCB     %00100
        FCB     %00100
        FCB     %00000

CHCOMA  FCB     %00000  , COMMA
        FCB     %00000
        FCB     %00000
        FCB     %00000
        FCB     %00010
        FCB     %00010
        FCB     %00100

CHDASH  FCB     %00000  - DASH
        FCB     %00000
        FCB     %00000
        FCB     %11111
        FCB     %00000
        FCB     %00000
        FCB     %00000

CHDOT   FCB     %00000  . DOT
        FCB     %00000
        FCB     %00000
        FCB     %00000
        FCB     %00000
        FCB     %00110
        FCB     %00110

CHSLS   FCB     %00001  / SLASH
        FCB     %00001
        FCB     %00010
        FCB     %00100
        FCB     %01000
        FCB     %10000
        FCB     %10000

CH0     FCB     %01110  0 ZERO
        FCB     %10001
        FCB     %10011
        FCB     %10101
        FCB     %11001
        FCB     %10001
        FCB     %01110

CH1     FCB     %00100  1 ONE
        FCB     %01100
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %11111

CH2     FCB     %01110  2 TWO
        FCB     %10001
        FCB     %00001
        FCB     %01110
        FCB     %10000
        FCB     %10000
        FCB     %11111

CH3     FCB     %01110  3 THREE
        FCB     %10001
        FCB     %00001
        FCB     %01110
        FCB     %00001
        FCB     %10001
        FCB     %01110

CH4     FCB     %10010  4 FOUR
        FCB     %10010
        FCB     %10010
        FCB     %11111
        FCB     %00010
        FCB     %00010
        FCB     %00010

CH5     FCB     %11111  5 FIVE
        FCB     %10000
        FCB     %10000
        FCB     %11110
        FCB     %00001
        FCB     %00001
        FCB     %11110

CH6     FCB     %01110  6 SIX
        FCB     %10001
        FCB     %10000
        FCB     %11110
        FCB     %10001
        FCB     %10001
        FCB     %01110

CH7     FCB     %11111  7 SEVEN
        FCB     %10001
        FCB     %00010
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100

CH8     FCB     %01110  8 EIGHT
        FCB     %10001
        FCB     %10001
        FCB     %01110
        FCB     %10001
        FCB     %10001
        FCB     %01110

CH9     FCB     %01110  9 NINE
        FCB     %10001
        FCB     %10001
        FCB     %01111
        FCB     %00001
        FCB     %00010
        FCB     %11100

CHCLN   FCB     %00000  : COLON
        FCB     %00110
        FCB     %00110
        FCB     %00000
        FCB     %00110
        FCB     %00110
        FCB     %00000

CHSMI   FCB     %00000  ; SEMICOLON
        FCB     %00100
        FCB     %00100
        FCB     %00000
        FCB     %00100
        FCB     %00100
        FCB     %01000

CHLAB   FCB     %00011  < LEFT ANGLE BRACKET
        FCB     %00100
        FCB     %01000
        FCB     %10000
        FCB     %01000
        FCB     %00100
        FCB     %00011

CHEQ    FCB     %00000  = EQUAL
        FCB     %00000
        FCB     %11111
        FCB     %00000
        FCB     %11111
        FCB     %00000
        FCB     %00000

CHRAB   FCB     %11000  > RIGHT ANGLE BRACKET
        FCB     %00100
        FCB     %00010
        FCB     %00001
        FCB     %00010
        FCB     %00100
        FCB     %11000

CHQMK   FCB     %01110  ? QUESTION MARK
        FCB     %10001
        FCB     %00010
        FCB     %00100
        FCB     %00000
        FCB     %00110
        FCB     %00110

CHAT    FCB     %01110  @ AT SIGN
        FCB     %10001
        FCB     %10101
        FCB     %10111
        FCB     %10110
        FCB     %10000
        FCB     %01111

CHA     FCB     %01110  LETTER A
        FCB     %10001
        FCB     %10001
        FCB     %11111
        FCB     %10001
        FCB     %10001
        FCB     %10001

CHB     FCB     %11110  LETTER B
        FCB     %10001
        FCB     %10001
        FCB     %11110
        FCB     %10001
        FCB     %10001
        FCB     %11110

CHC     FCB     %01110  LETTER C
        FCB     %10001
        FCB     %10000
        FCB     %10000
        FCB     %10000
        FCB     %10001
        FCB     %01110

CHD     FCB     %11110  LETTER D
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %11110

CHE     FCB     %11111  LETTER E
        FCB     %10000
        FCB     %10000
        FCB     %11100
        FCB     %10000
        FCB     %10000
        FCB     %11111

CHF     FCB     %11111  LETTER F
        FCB     %10000
        FCB     %10000
        FCB     %11100
        FCB     %10000
        FCB     %10000
        FCB     %10000

CHG     FCB     %01110  LETTER G
        FCB     %10001
        FCB     %10000
        FCB     %10000
        FCB     %10011
        FCB     %10001
        FCB     %01110

CHH     FCB     %10001  LETTER H
        FCB     %10001
        FCB     %10001
        FCB     %11111
        FCB     %10001
        FCB     %10001
        FCB     %10001

CHI     FCB     %11111  LETTER I
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %11111

CHJ     FCB     %01111  LETTER J
        FCB     %00010
        FCB     %00010
        FCB     %00010
        FCB     %00010
        FCB     %10010
        FCB     %01100

CHK     FCB     %10001  LETTER K
        FCB     %10010
        FCB     %10100
        FCB     %11000
        FCB     %10100
        FCB     %10010
        FCB     %10001

CHL     FCB     %10000  LETTER L
        FCB     %10000
        FCB     %10000
        FCB     %10000
        FCB     %10000
        FCB     %10000
        FCB     %11111

CHM     FCB     %10001  LETTER M
        FCB     %11011
        FCB     %10101
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %10001

CHN     FCB     %10001  LETTER N
        FCB     %10001
        FCB     %11001
        FCB     %10101
        FCB     %10011
        FCB     %10001
        FCB     %10001

CHO     FCB     %01110  LETTER OH
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %01110

CHP     FCB     %11110  LETTER P
        FCB     %10001
        FCB     %10001
        FCB     %11110
        FCB     %10000
        FCB     %10000
        FCB     %10000

CHQ     FCB     %01110  LETTER Q
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %10101
        FCB     %10010
        FCB     %01101

CHR     FCB     %11110  LETTER R
        FCB     %10001
        FCB     %10001
        FCB     %11110
        FCB     %10100
        FCB     %10010
        FCB     %10001

CHS     FCB     %01110  LETTER S
        FCB     %10001
        FCB     %10000
        FCB     %01110
        FCB     %00001
        FCB     %10001
        FCB     %01110

CHT     FCB     %11111  LETTER T
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100

CHU     FCB     %10001  LETTER U
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %01110

CHV     FCB     %10001  LETTER V
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %01010
        FCB     %00100

CHW     FCB     %10001  LETTER W
        FCB     %10001
        FCB     %10001
        FCB     %10101
        FCB     %10101
        FCB     %11011
        FCB     %10001

CHX     FCB     %10001  LETTER X
        FCB     %10001
        FCB     %01010
        FCB     %00100
        FCB     %01010
        FCB     %10001
        FCB     %10001

CHY     FCB     %10001  LETTER Y
        FCB     %10001
        FCB     %01010
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100

CHZ     FCB     %11111  LETTER Z
        FCB     %00001
        FCB     %00010
        FCB     %00100
        FCB     %01000
        FCB     %10000
        FCB     %11111

CHLSB   FCB     %11111  [ LEFT SQUARE BRACKET
        FCB     %10000
        FCB     %10000
        FCB     %10000
        FCB     %10000
        FCB     %10000
        FCB     %11111

CHBSL   FCB     %10000  BACK SLASH
        FCB     %10000
        FCB     %01000
        FCB     %00100
        FCB     %00010
        FCB     %00001
        FCB     %00001

CHRSB   FCB     %11111  ] RIGHT SQUARE BRACKET
        FCB     %00001
        FCB     %00001
        FCB     %00001
        FCB     %00001
        FCB     %00001
        FCB     %11111

CHUPA   FCB     %00100  ^ UP ARROW OR CARET
        FCB     %01110
        FCB     %10101
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100

CHLFA   FCB     %00000  _ LEFT ARROW OR UNDERSCORE
        FCB     %00100
        FCB     %01000
        FCB     %11111
        FCB     %01000
        FCB     %00100
        FCB     %00000

CHAGR   FCB     %01000  ` ACCENT GRAVE
        FCB     %00100
        FCB     %00000
        FCB     %00000
        FCB     %00000
        FCB     %00000
        FCB     %00000

CHSA    FCB     %00000  SMALL A
        FCB     %00000
        FCB     %01110
        FCB     %10010
        FCB     %10010
        FCB     %10010
        FCB     %01111

CHSB    FCB     %10000  SMALL B
        FCB     %10000
        FCB     %10000
        FCB     %11110
        FCB     %10001
        FCB     %10001
        FCB     %11110

CHSC    FCB     %00000  SMALL C
        FCB     %00000
        FCB     %01110
        FCB     %10000
        FCB     %10000
        FCB     %10000
        FCB     %01110

CHSD    FCB     %00001  SMALL D
        FCB     %00001
        FCB     %00001
        FCB     %01111
        FCB     %10001
        FCB     %10001
        FCB     %01111

CHSE    FCB     %00000  SMALL E
        FCB     %00000
        FCB     %01110
        FCB     %10001
        FCB     %11110
        FCB     %10000
        FCB     %01110

CHSF    FCB     %00110  SMALL F
        FCB     %01001
        FCB     %01000
        FCB     %11100
        FCB     %01000
        FCB     %01000
        FCB     %01000

CHSG    FCB     %00111+$80      SMALL G
        FCB     %01001
        FCB     %01001
        FCB     %00111
        FCB     %00001
        FCB     %00001
        FCB     %00110

CHSH    FCB     %10000  SMALL H
        FCB     %10000
        FCB     %10000
        FCB     %11110
        FCB     %10001
        FCB     %10001
        FCB     %10001

CHSI    FCB     %00100  SMALL I
        FCB     %00000
        FCB     %01100
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00110

CHSJ    FCB     $82     SMALL J
        FCB     %00000
        FCB     %00110
        FCB     %00010
        FCB     %00010
        FCB     %00010
        FCB     %01100

CHSK    FCB     %10000  SMALL K
        FCB     %10000
        FCB     %10010
        FCB     %10100
        FCB     %11000
        FCB     %10100
        FCB     %10010

CHSL    FCB     %01100  SMALL L
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %00100
        FCB     %01110

CHSM    FCB     %00000  SMALL M
        FCB     %10000
        FCB     %11010
        FCB     %10101
        FCB     %10101
        FCB     %10101
        FCB     %10101

CHSN    FCB     %00000  SMALL N
        FCB     %10000
        FCB     %11100
        FCB     %10010
        FCB     %10010
        FCB     %10010
        FCB     %10010

CHSO    FCB     %00000  SMALL O
        FCB     %00000
        FCB     %01110
        FCB     %10001
        FCB     %10001
        FCB     %10001
        FCB     %01110

CHSP    FCB     %11100+$80      SMALL P
        FCB     %10010
        FCB     %10010
        FCB     %11100
        FCB     %10000
        FCB     %10000
        FCB     %10000

CHSQ    FCB     %00111+$80      SMALL Q
        FCB     %01001
        FCB     %01001
        FCB     %00111
        FCB     %00001
        FCB     %00001
        FCB     %00001

CHSR    FCB     %00000  SMALL R
        FCB     %00000
        FCB     %10110
        FCB     %11001
        FCB     %10000
        FCB     %10000
        FCB     %10000

CHSS    FCB     %00000  SMALL S
        FCB     %00000
        FCB     %01110
        FCB     %10000
        FCB     %01110
        FCB     %00001
        FCB     %01110

CHST    FCB     %00000  SMALL T
        FCB     %01000
        FCB     %11100
        FCB     %01000
        FCB     %01000
        FCB     %01000
        FCB     %00100

CHSU    FCB     %00000  SMALL U
        FCB     %00000
        FCB     %10010
        FCB     %10010
        FCB     %10010
        FCB     %10010
        FCB     %01101

CHSV    FCB     %00000  SMALL V
        FCB     %00000
        FCB     %10001
        FCB     %10001
        FCB     %01010
        FCB     %01010
        FCB     %00100

CHSW    FCB     %00000  SMALL W
        FCB     %00000
        FCB     %10001
        FCB     %10001
        FCB     %10101
        FCB     %10101
        FCB     %01010

CHSX    FCB     %00000  SMALL X
        FCB     %00000
        FCB     %10001
        FCB     %01010
        FCB     %00100
        FCB     %01010
        FCB     %10001

CHSY    FCB     %01001+$80      SMALL Y
        FCB     %01001
        FCB     %01001
        FCB     %00111
        FCB     %00001
        FCB     %00001
        FCB     %00110

CHSZ    FCB     %00000  SMALL Z
        FCB     %00000
        FCB     %01111
        FCB     %00001
        FCB     %00010
        FCB     %00100
        FCB     %01111

CHLCB   FCB     %00110  LEFT CURLY BRACKET
        FCB     %01000
        FCB     %01000
        FCB     %10000
        FCB     %01000
        FCB     %01000
        FCB     %00110

CHVB    FCB     %00100  VERTICAL BAR
        FCB     %00100
        FCB     %00100
        FCB     %00000
        FCB     %00100
        FCB     %00100
        FCB     %00100

CHRCB   FCB     %01100  RIGHT CURLY BRACKET
        FCB     %00010
        FCB     %00010
        FCB     %00001
        FCB     %00010
        FCB     %00010
        FCB     %01100

CHTIL   FCB     %00000  TILDE
        FCB     %00000
        FCB     %01001
        FCB     %10101
        FCB     %10010
        FCB     %00000
        FCB     %00000

CHRUB   FCB     %11111  RUBOUT
        FCB     %11111
        FCB     %11111
        FCB     %11111
        FCB     %11111
        FCB     %11111
        FCB     %11111

CHCUR   FCB     %11100  Special right edge cursor
        FCB     %11100
        FCB     %11100
        FCB     %11100
        FCB     %11100
        FCB     %11100
        FCB     %11100
