*       EACH CHARACTER BIT PATTERN OCCUPIES A 4 BY 7 MATRIX
*       THIS BIT PATTERN OCCUPIES 7 CONTIGUOUS BYTES...
*       WITH THE FIRST BYTE BEING THE FIRST DOT ROW OF THE CHARACTER, ETC.
*       THE 4 X 7 BIT MATRIX IS RIGHT JUSTIFIED IN THE BLOCK OF BYTES
*       THE TABLE IS ORDERED IN ASCII SEQUENCE...
*       SO THE PROCESS OF FINDING THE BIT MATRIX FOR A CHARACTER...
*       IS SIMPLY: LOC(BIT MATRIX):=CHARACTERSET+(CHAR-$20)*7
*       1ST BYTE OF CHARACTER HAS
*       A SIGN BIT SET IF CHARACTER HAS TAIL (SMALL G,J,P,Q,Y)

CHNBLANK FCB    %0000   BLANK
        FCB     %0000
        FCB     %0000
        FCB     %0000
        FCB     %0000
        FCB     %0000
        FCB     %0000

CHNBANG FCB     %0010   ! BANG
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0000
        FCB     %0010

CHNDBLQ FCB     %0101   " DOUBLE QUOTE
        FCB     %0101
        FCB     %0000
        FCB     %0000
        FCB     %0000
        FCB     %0000
        FCB     %0000

CHNHASH FCB     %0110   # HASH
        FCB     %0110
        FCB     %1111
        FCB     %0110
        FCB     %1111
        FCB     %0110
        FCB     %0110

CHNDOLR FCB     %0010   $ DOLLAR
        FCB     %0111
        FCB     %1010
        FCB     %0111
        FCB     %0010
        FCB     %1111
        FCB     %0010

CHNPCNT FCB     %1100   % PERCENT
        FCB     %1001
        FCB     %0001
        FCB     %0010
        FCB     %0100
        FCB     %1001
        FCB     %1011

CHNAMP  FCB     %0100   & AMPERSAND
        FCB     %1010
        FCB     %0100
        FCB     %1010
        FCB     %1001
        FCB     %1010
        FCB     %0101

CHNSGQ  FCB     %0010   ' SINGLE QUOTE
        FCB     %0010
        FCB     %0010
        FCB     %0000
        FCB     %0000
        FCB     %0000
        FCB     %0000

CHNLP   FCB     %0001   ( LEFT PARENTHESES
        FCB     %0010
        FCB     %0100
        FCB     %0100
        FCB     %0100
        FCB     %0010
        FCB     %0001

CHNRP   FCB     %0100   ) RIGHT PARENTHESES
        FCB     %0010
        FCB     %0001
        FCB     %0001
        FCB     %0001
        FCB     %0010
        FCB     %0100

CHNSTAR FCB     %0000   * ASTERISK
        FCB     %1001
        FCB     %0110
        FCB     %1111
        FCB     %0110
        FCB     %1001
        FCB     %0000

CHNPLUS FCB     %0000   + PLUS
        FCB     %0010
        FCB     %0010
        FCB     %0111
        FCB     %0010
        FCB     %0010
        FCB     %0000

CHNCOMA FCB     $80     , COMMA
        FCB     %0000
        FCB     %0000
        FCB     %0000
        FCB     %0010
        FCB     %0010
        FCB     %0100

CHNDASH FCB     %0000   - DASH
        FCB     %0000
        FCB     %0000
        FCB     %1111
        FCB     %0000
        FCB     %0000
        FCB     %0000

CHNDOT  FCB     %0000   . DOT
        FCB     %0000
        FCB     %0000
        FCB     %0000
        FCB     %0000
        FCB     %0110
        FCB     %0110

CHNSLS  FCB     %0001   / SLASH
        FCB     %0010
        FCB     %0010
        FCB     %0100
        FCB     %0100
        FCB     %1000
        FCB     %1000

CHN0    FCB     %0110   0 ZERO
        FCB     %1001
        FCB     %1001
        FCB     %1011
        FCB     %1101
        FCB     %1001
        FCB     %0110

CHN1    FCB     %0010   1 ONE
        FCB     %0110
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0111

CHN2    FCB     %0110   2 TWO
        FCB     %1001
        FCB     %0001
        FCB     %0111
        FCB     %1000
        FCB     %1000
        FCB     %1111

CHN3    FCB     %1110   3 THREE
        FCB     %0001
        FCB     %0001
        FCB     %0110
        FCB     %0001
        FCB     %0001
        FCB     %1110

CHN4    FCB     %1001   4 FOUR
        FCB     %1001
        FCB     %1001
        FCB     %1111
        FCB     %0001
        FCB     %0001
        FCB     %0001

CHN5    FCB     %1111   5 FIVE
        FCB     %1000
        FCB     %1000
        FCB     %1110
        FCB     %0001
        FCB     %0001
        FCB     %1110

CHN6    FCB     %0111   6 SIX
        FCB     %1000
        FCB     %1000
        FCB     %1110
        FCB     %1001
        FCB     %1001
        FCB     %0110

CHN7    FCB     %1111   7 SEVEN
        FCB     %0001
        FCB     %0010
        FCB     %0100
        FCB     %0100
        FCB     %0100
        FCB     %1000

CHN8    FCB     %0110   8 EIGHT
        FCB     %1001
        FCB     %1001
        FCB     %0110
        FCB     %1001
        FCB     %1001
        FCB     %0110

CHN9    FCB     %0110   9 NINE
        FCB     %1001
        FCB     %1001
        FCB     %0111
        FCB     %0001
        FCB     %0001
        FCB     %1110

CHNCLN  FCB     %0000   : COLON
        FCB     %0110
        FCB     %0110
        FCB     %0000
        FCB     %0110
        FCB     %0110
        FCB     %0000

CHNSMI  FCB     $80     ; SEMICOLON
        FCB     %0010
        FCB     %0010
        FCB     %0000
        FCB     %0010
        FCB     %0010
        FCB     %0100

CHNLAB  FCB     %0001   < LEFT ANGLE BRACKET
        FCB     %0010
        FCB     %0100
        FCB     %1000
        FCB     %0100
        FCB     %0010
        FCB     %0001

CHNEQ   FCB     %0000   = EQUAL
        FCB     %0000
        FCB     %1111
        FCB     %0000
        FCB     %1111
        FCB     %0000
        FCB     %0000

CHNRAB  FCB     %1000   > RIGHT ANGLE BRACKET
        FCB     %0100
        FCB     %0010
        FCB     %0001
        FCB     %0010
        FCB     %0100
        FCB     %1000

CHNQMK  FCB     %0110   ? QUESTION MARK
        FCB     %1001
        FCB     %0001
        FCB     %0010
        FCB     %0000
        FCB     %0110
        FCB     %0110

CHNAT   FCB     %0111   @ AT SIGN
        FCB     %1001
        FCB     %1001
        FCB     %1011
        FCB     %1011
        FCB     %1000
        FCB     %0111

CHNA    FCB     %0110   LETTER A
        FCB     %1001
        FCB     %1001
        FCB     %1111
        FCB     %1001
        FCB     %1001
        FCB     %1001

CHNB    FCB     %1110   LETTER B
        FCB     %1001
        FCB     %1001
        FCB     %1110
        FCB     %1001
        FCB     %1001
        FCB     %1110

CHNC    FCB     %0111   LETTER C
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %0111

CHND    FCB     %1110   LETTER D
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1110

CHNE    FCB     %1111   LETTER E
        FCB     %1000
        FCB     %1000
        FCB     %1110
        FCB     %1000
        FCB     %1000
        FCB     %1111

CHNF    FCB     %1111   LETTER F
        FCB     %1000
        FCB     %1000
        FCB     %1110
        FCB     %1000
        FCB     %1000
        FCB     %1000

CHNG    FCB     %0111   LETTER G
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1011
        FCB     %1001
        FCB     %0111

CHNH    FCB     %1001   LETTER H
        FCB     %1001
        FCB     %1001
        FCB     %1111
        FCB     %1001
        FCB     %1001
        FCB     %1001

CHNI    FCB     %0111   LETTER I
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0111

CHNJ    FCB     %0111   LETTER J
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %1010
        FCB     %0110

CHNK    FCB     %1001   LETTER K
        FCB     %1001
        FCB     %1010
        FCB     %1100
        FCB     %1010
        FCB     %1001
        FCB     %1001

CHNL    FCB     %1000   LETTER L
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1111

CHNM    FCB     %1001   LETTER M
        FCB     %1111
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1001

CHNN    FCB     %1001   LETTER N
        FCB     %1001
        FCB     %1101
        FCB     %1011
        FCB     %1001
        FCB     %1001
        FCB     %1001

CHNO    FCB     %0110   LETTER OH
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %0110

CHNP    FCB     %1110   LETTER P
        FCB     %1001
        FCB     %1001
        FCB     %1110
        FCB     %1000
        FCB     %1000
        FCB     %1000

CHNQ    FCB     %0110   LETTER Q
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1011
        FCB     %1001
        FCB     %0111

CHNR    FCB     %1110   LETTER R
        FCB     %1001
        FCB     %1001
        FCB     %1110
        FCB     %1010
        FCB     %1001
        FCB     %1001

CHNS    FCB     %0111   LETTER S
        FCB     %1000
        FCB     %1000
        FCB     %0110
        FCB     %0001
        FCB     %1001
        FCB     %0110

CHNT    FCB     %0111   LETTER T
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010

CHNU    FCB     %1001   LETTER U
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %0110

CHNV    FCB     %1001   LETTER V
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1010
        FCB     %1100
        FCB     %1000

CHNW    FCB     %1001   LETTER W
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1111
        FCB     %1001

CHNX    FCB     %1001   LETTER X
        FCB     %1001
        FCB     %0110
        FCB     %0110
        FCB     %0110
        FCB     %1001
        FCB     %1001

CHNY    FCB     %1001   LETTER Y
        FCB     %1001
        FCB     %0101
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010

CHNZ    FCB     %1111   LETTER Z
        FCB     %0001
        FCB     %0001
        FCB     %0010
        FCB     %0100
        FCB     %1000
        FCB     %1111

CHNLSB  FCB     %1111   [ LEFT SQUARE BRACKET
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1111

CHNBSL  FCB     %1000   BACK SLASH
        FCB     %0100
        FCB     %0100
        FCB     %0010
        FCB     %0010
        FCB     %0001
        FCB     %0001

CHNRSB  FCB     %1111   ] RIGHT SQUARE BRACKET
        FCB     %0001
        FCB     %0001
        FCB     %0001
        FCB     %0001
        FCB     %0001
        FCB     %1111

CHNUPA  FCB     %0010   ^ UP ARROW OR CARET
        FCB     %0111
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010

CHNLFA  FCB     %0000   _ LEFT ARROW OR UNDERSCORE
        FCB     %0010
        FCB     %0100
        FCB     %1111
        FCB     %0100
        FCB     %0010
        FCB     %0000

CHNAGR  FCB     %0100   ` ACCENT GRAVE
        FCB     %0010
        FCB     %0000
        FCB     %0000
        FCB     %0000
        FCB     %0000
        FCB     %0000

CHNSA   FCB     %0000   SMALL A
        FCB     %0000
        FCB     %0111
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %0111

CHNSB   FCB     %1000   SMALL B
        FCB     %1000
        FCB     %1000
        FCB     %1111
        FCB     %1001
        FCB     %1001
        FCB     %1111

CHNSC   FCB     %0000   SMALL C
        FCB     %0000
        FCB     %0111
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %0111

CHNSD   FCB     %0001   SMALL D
        FCB     %0001
        FCB     %0001
        FCB     %0111
        FCB     %1001
        FCB     %1001
        FCB     %0111

CHNSE   FCB     %0000   SMALL E
        FCB     %0000
        FCB     %0110
        FCB     %1001
        FCB     %1111
        FCB     %1000
        FCB     %0111

CHNSF   FCB     %0011   SMALL F
        FCB     %0100
        FCB     %0100
        FCB     %1110
        FCB     %0100
        FCB     %0100
        FCB     %0100

CHNSG   FCB     %0111+$80       SMALL G
        FCB     %1001
        FCB     %1001
        FCB     %0111
        FCB     %0001
        FCB     %0001
        FCB     %0110

CHNSH   FCB     %1000   SMALL H
        FCB     %1000
        FCB     %1000
        FCB     %1110
        FCB     %1001
        FCB     %1001
        FCB     %1001

CHNSI   FCB     %0010   SMALL I
        FCB     %0000
        FCB     %0110
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0011

CHNSJ   FCB     $82     SMALL J
        FCB     %0000
        FCB     %0011
        FCB     %0001
        FCB     %0001
        FCB     %0001
        FCB     %0110

CHNSK   FCB     %1000   SMALL K
        FCB     %1000
        FCB     %1001
        FCB     %1010
        FCB     %1100
        FCB     %1010
        FCB     %1001

CHNSL   FCB     %0110   SMALL L
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0010
        FCB     %0111

CHNSM   FCB     %0000   SMALL M
        FCB     %0000
        FCB     %1001
        FCB     %1111
        FCB     %1001
        FCB     %1001
        FCB     %1001

CHNSN   FCB     %0000   SMALL N
        FCB     %1000
        FCB     %1110
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1001

CHNSO   FCB     %0000   SMALL O
        FCB     %0000
        FCB     %0110
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %0110


CHNSP   FCB     %1110+$80       SMALL P
        FCB     %1001
        FCB     %1001
        FCB     %1110
        FCB     %1000
        FCB     %1000
        FCB     %1000

CHNSQ   FCB     %0111+$80       SMALL Q
        FCB     %1001
        FCB     %1001
        FCB     %0111
        FCB     %0001
        FCB     %0001
        FCB     %0001

CHNSR   FCB     %0000   SMALL R
        FCB     %0000
        FCB     %1011
        FCB     %1100
        FCB     %1000
        FCB     %1000
        FCB     %1000

CHNSS   FCB     %0000   SMALL S
        FCB     %0000
        FCB     %0111
        FCB     %1000
        FCB     %0110
        FCB     %0001
        FCB     %0110

CHNST   FCB     %0000   SMALL T
        FCB     %0100
        FCB     %1110
        FCB     %0100
        FCB     %0100
        FCB     %0100
        FCB     %0010

CHNSU   FCB     %0000   SMALL U
        FCB     %0000
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %0110

CHNSV   FCB     %0000   SMALL V
        FCB     %0000
        FCB     %1001
        FCB     %1001
        FCB     %0101
        FCB     %0101
        FCB     %0010

CHNSW   FCB     %0000   SMALL W
        FCB     %0000
        FCB     %1001
        FCB     %1001
        FCB     %1001
        FCB     %1111
        FCB     %1001

CHNSX   FCB     %0000   SMALL X
        FCB     %0000
        FCB     %1001
        FCB     %0110
        FCB     %0110
        FCB     %0110
        FCB     %1001

CHNSY   FCB     %1001+$80       SMALL Y
        FCB     %1001
        FCB     %1001
        FCB     %0111
        FCB     %0001
        FCB     %0001
        FCB     %0111

CHNSZ   FCB     %0000   SMALL Z
        FCB     %0000
        FCB     %0111
        FCB     %0001
        FCB     %0010
        FCB     %0100
        FCB     %1111

CHNLCB  FCB     %0011   LEFT CURLY BRACKET
        FCB     %0100
        FCB     %0100
        FCB     %1000
        FCB     %0100
        FCB     %0100
        FCB     %0011

CHNVB   FCB     %0010   VERTICAL BAR
        FCB     %0010
        FCB     %0010
        FCB     %0000
        FCB     %0010
        FCB     %0010
        FCB     %0010

CHNRCB  FCB     %1100   RIGHT CURLY BRACKET
        FCB     %0010
        FCB     %0010
        FCB     %0001
        FCB     %0010
        FCB     %0010
        FCB     %1100

CHNTIL  FCB     %0000   TILDE
        FCB     %0000
        FCB     %0101
        FCB     %1010
        FCB     %0000
        FCB     %0000
        FCB     %0000

CHNRUB  FCB     %1111   RUBOUT
        FCB     %1111
        FCB     %1111
        FCB     %1111
        FCB     %1111
        FCB     %1111
        FCB     %1111

CHNCUR  FCB     %1000   Special right screen edge cursor
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1000
        FCB     %1000
