dim Version$/"Label printer V1.0 (C) 1984 Software Dynamics"/
dim printline$[4][132],labelline$[4][132]
dim infile$[50],outfile$[50],InChannel/1/,OutChannel/2/
dim temp$[100]

Print Version$
Print "This program accepts a source file containing label data."
Print "Each label is any number of lines of text, seperated by blank lines."
Print "Only the first 4 lines of text are printed on an actual label."
Print "Only the first 34 characters of each line are printed."
Print "The program prints on label stock 6 lines high, 3 labels horizontal."

Input "File containing label data? " Infile$\open #InChannel,infile$

Input "Where to place results? " OutFile$\create #OutChannel,OutFile$

Input "How many labels to be printed horizontally? " HorizontalLabels
Input "How many lines from label to label (>=4)? " LinesPerLabel
Input "How many blank lines at top of label? " BlankLinesAtTopOfLabel
Input "How wide is label in characters? " LabelTotalWidth
Input "How wide is left margin on label? " LabelLeftMargin
Input "Numbers of characters to print in label? " LabelPrintWidth

for i=1 to len(printline$) do
   ! Blank fill each PrintLine$
   len(printline$[i])=maxlen(printline$[i])
   printline$[i][1,len(printline$[i])]=""
end

Aligned=False
Repeat
    For i=1 to BlankLinesAtTopOfLabel do Print #OutChannel
    For LabelColumn=1 to HorizontalLabels
        Gosub GetLabel
        for i=1 to len(PrintLine$)
            printline$[i][LabelTotalWidth*(LabelColumn-1)+LabelLeftMargin+1,...
&                         LabelPrintWidth]=LabelLine$[i]
        next i
   Next LabelColumn
   For i=1 to len(PrintLine$) do Print #OutChannel,PrintLine$[i]
   For i=BlankLinesAtTopOfLabel+len(PrintLine$)+1 to LinesPerLabel
       Print #OutChannel
   Next i
   If Aligned=False and UpperCase$(OutFile$)="LPT:"
   Then
       ! Help user align labels
       input "Are labels aligned properly? " Temp$
       if Find(UpperCase$(Temp$),"Y")=1
       Then Aligned=True
       Else Restore #InChannel,0
   Fi
When Not Eof(InChannel) End

EXIT
!^L
GetLabel: ! Read a label from the input file
   ! Ignores blank lines preceeding next label
   ! Reads and retains up to 4 non-blank lines.
   ! Then reads until blank line encountered.
   for i=1 to len(LabelLine$)
      if i=1 or not BlankLineRead
      then
          Repeat
              ! Read a line. If EOF, treat as if line were blank.
              input #InChannel,temp$
              if eof(InChannel) then Temp$=""
              LabelLine$[i]=Temp$
              BlankLineRead=(Temp$="")
              ! Read another line if this is 1st line and it is blank
          When i=1 and BlankLineRead and not eof(InChannel) End
      else
          ! If already read a blank line, make rest of lines of label blank.
          LabelLine$[i]=""
      fi
   end

   ! Show user where we are in process of printing file
   FOR I=1 TO LEN(LABELLINE$)
       PRINT LABELLINE$[I]
   NEXT I
   PRINT

   If BlankLineRead Then Return
   Repeat
       ! Ignore lines until blank line or EOF encountered
       input #InChannel,temp$
   When Temp$<>"" and not eof(InChannel) End
   Return

END
