.fs 16
.ce
T Y P E
.bl 10
.lm 50
User's Manual
.lm 10
.bl 15
SOFTWARE DYNAMICS
.BR
2111 W. Crescent Avenue
.BR
Suite G
.br
Anaheim, CA 92801
.br
(714) 635-4760
.pa
.cm *************************************************
.cm *                                               *
.cm *      TYPEMANL.TYP  -  TYPE USER's MANUAL      *
.cm *                                               *
.cm *                 Version 2.2                   *
.cm *                                               *
.cm *        Last Changed:   12/15/80               *
.cm *                                               *
.cm *************************************************
.cm *  08-27-80  Original AMS published version.    *
.cm *  11-11-80  Changed to delete all Spinwriter   *
.cm *            SI-SO codes so will run on Ira's   *
.cm *            printer.  No data changed, so did  *
.cm *            not change manual date from        *
.cm *            08-27-80.                          *
.cm *************************************************
.lm 0
.ll 85
.tm 8
.hm 3
.bm 8
.he TYPE USER'S MANUAL
.cm The .IL is preceded by three spaces for positioning purposes
.il    Copyright (C) 1980 AMS
.cm The .IR is followed by three spaces for positioning purposes
.ir 12-15-80/V2.2   
.ll 65
.pw 85
.lm 10
.ce
NOTICE
.br
.CE
______
.bl 4
This manual describes version 2.2 of the Software Dynamics TYPE Program Formatter
for 6800/6809 microprocessors.  The information given in this manual has been carefully
checked and is believed to be entirely reliable.  However, no responsibility is assumed
for inaccuracies.
.bl 1
Software Dynamics reserves the right to change specifications with notice.
.bl 1
.nf
.pw 122
.ll 100
**********************************************************************
** SD software is sold on a single copy per computer basis, and is  **
** covered by both copyright and software non-disclosure agreement. **
** Use of this software without signing a non-disclosure agreement, **
** or copying this software for use on more than a single computer  **
** without the written consent of SD is strictly prohibited.        **
**********************************************************************
.fo
.pw 85
.ll 65
.bl 2
Copyright (C) 1980 Advanced Microcomputer Systems
.pa
.cm SECTION 1
.sh SECTION 1: GENERAL DESCRIPTION
.dd
.tb 8,13,18,23,28,33,38,43,48,53,58
.tc
1.	GENERAL DESCRIPTION
	-------------------
.sp 2
.tc
1.1	INTRODUCTION
	------------
.sp
	TYPE, the Document Formatter Program from Advanced Microcomputer Systems (AMS), offers high versatility to the user
in the generation of output documents.
The TYPE USER'S MANUAL was generated by TYPE from a single input file; utilizing the various formatting options to generate varied output formats.
A complete set of formatting controls allows virtually any placement and format of the output.
Formatting control variables may be redefined at any time during output generation,
allowing complete formatting control and multiple output formats within the same document.
The user may specify the page size, line length, number of lines per page, indentation, automatic centering,
line spacing, margins, page layout, titles, and page numbers.
Standard, logical defaults for page size, margins, etc., also allow TYPE to produce documents without any user-specified formats.
.sp
.cp 2
	Output may be directed to a file or to any output device, such as a printer or console.
A single page mode option allows use of non-continuous forms.
.sp
.cp 2
	Justification may be performed automatically; TYPE will concatenate and/or break lines between words
to fill user-defined line lengths.
A sophisticated justification algorithm provides even distribution of padding blanks.
.sp
.cp 2
	Profuse pagination options allow unusual versatility in producing professional looking documents.
Page numbers may be printed at the top or bottom of the page;
and in standard, alphanumeric, or Dewey Decimal number format.
User defined conditional paging insures that charts and figures will not be split by paging; as well as insuring that the
output has a neat, professional appearance.
.sp
.cp 2
	A merging option allows generation of multiple copies of the same document with insertion of variable data
anywhere within the document.
This feature may be used to produce multiple copies of the same letter with different addresses and varying data
at user selected locations within the letter body.
This is particularly useful for processing a file of names and addresses against a common form letter
for mass mailings and advertisements, where a personalized approach may be desired.
.sp
.cp 2
	A semiautomatic Table of Contents generator inserts page numbers into a Table of Contents at points specified by the user,
allowing complete freedom in insertion or deletion of text without regard to actual page numbers in the Table of Contents.
.sp
.cp 2
	Diagnostic messages flag invalid syntax or usage to facilitate use of the program.
.sp
.cp 2
	Comprehensive examples in the user manual make it easier for the user to utilize the program effectively.
.sp
.cp 2
	While the function of many commands in TYPE is self evident,
some commands require an exact knowledge of their purpose and effect in order to produce the expected results.
Users should not expect to immediately produce complex output without careful study of this manual and actual use of the program.
It is highly recommended that first time users enter some of the examples in Section 3 of this manual and study the commands used
in order to gain familiarity and confidence in the use of TYPE.
.sp 2
.cp 5
.tc
1.2	OPERATIONAL CHARACTERISTICS
	---------------------------
.sp
	TYPE reads a text file created via a text editor and produces a formatted output report.
The output report is formatted in accordance with commands specified by the user via control records embedded in the text file.
The input and output file specifications are requested at the start of program execution via an asterisk (*) prompt
and are entered in the following format:
.sp
.ce
ddd:output.ext=ddd:input1.ext,ddd:input2.ext/switches
.sp
.cp 2
The device specifications (ddd:), extensions (.ext), output file, second input file (input2), and switches are optional.
.sp
.cp 2
	a.	If no device is specified, default is to the current system default file-structured device.
.sp
.cp 2
	b.	The default extension for both input files is ".TYP", and the default for the output file is ".TXT".
The output may also be directed to non-file-structured devices; such as a HyType printer, line printer, or console device.
.sp
.cp 2
	c.	If the output specification is omitted, output is directed to the console device.
.sp
.cp 2
	d.	If the second input file is specified, both input files are "merged" to the output as described by the merge (.ME) command.
Refer to Section 2 for a complete description of merge processing.
.sp
.cp 5
	e.	If multiple switches are specified, they must be separated by commas.
Only the following switch specifications are currently defined:
.sp
.of 17
		E~=	Error~Stop.
Execution stops whenever an error diagnostic occurs, such as when an invalid command format is encountered.
The carriage return key is pressed to resume execution.
.sp
		P~=	Page~Stop.
Execution stops at the end of each output page (at the perforation)
to allow the paper to be changed when using single sheets rather than continuous form paper.
The carriage return key is pressed to resume execution.
.of
.sp
.cp 4
Following are examples of valid specifications:
.sp
	OUTPUT.SPL=FD1:FORMLTR,FD:ADDRESSES
	TT:=UMANUAL/E
	FD1:LETTER3.TXT
	PR:=LETTER/P
	VT:=TYPEMANL.TXT
	LETTER2
	LTRFILE=USERGUIDE
.cp 5
	FD1:LTRFILE=FD:USERGUIDE
	HT:=NEWSRELS,DISTRIB/P,E
.sp 2
.cp 5
.tc
1.3	DEFINITIONS
	-----------
.sp
	The following terms are used frequently throughout this manual and have the meanings indicated.
.sp
.cp 2
	a.	BREAK.
All input data encountered prior to this point is written to the output and a new output line started.
If concatenation is in effect, the line is written without concatenating words from the next line.
If offsetting is in effect,
.cp 5
the offset operation is restarted so that all but the first line
of the following paragraph is again offset.
Breaks are caused by a majority of the commands.
.sp
.cp 2
	b.	CONCATENATION.
Output lines are formed by shifting words to or from the next input line.
The resulting line will be as close to the specified line length (.LL) as possible without exceeding it or splitting a word.
If an input line without any blanks exceeds the currently specified line length,
it is truncated and a diagnostic message is issued.
.sp
.cp 2
	c.	FORMATTING.
This is a combination of both concatenation and justification; it is the normal default mode of operation.
.sp
.cp 2
	d.	JUSTIFICATION.
Output lines are padded with inserted spaces to produce an even right margin on the output.
If an input line without any blanks exceeds the currently specified line length,
it is truncated and a diagnostic message is issued.
If concatenation is also in effect, the concatenation process takes place prior to the justification.
.sp
.cp 2
	e.	PERFORATION.
This term refers to the physical boundaries or edges of the paper.
If using pin feed paper rather than single sheets, it refers to the boundaries after the pin feed strips have been removed.
For example, the width of standard typewriter paper is 8-1/2 inches from perforation to perforation (edge to edge).
.sp 2
.cp 8
.tc
1.4	RULES AND RESTRICTIONS
	----------------------
.sp
	The following general rules and restrictions apply to the operation of TYPE:
.sp
.cp 2
	1.	Command records are identified by a period (.) in the first byte of the record.
No input text line may have a period as the first byte of the line;
if it does, it is treated as a command record and causes a diagnostic message to be issued.
.sp
.cp 2
	2.	No text data or comments may be included on a command record line.
Any extraneous data on the command record is interpreted as part of the parameter;
therefore, it causes a diagnostic message to be issued and the command is ignored.
.sp
.cp 2
	3.	Command specifications must always precede the data to which they are to apply.
.sp
.cp 2
	4.	Commands may be specified in either upper or lower case.
.sp
.cp 2
	5.	If parameters are supplied with the command, they must be separated from the command code by one space.
If more than one parameter is allowed, they must be separated from each other by one space or comma.
.sp
.cp 2
	6.	All spaces in the input records are carried through to the output without change.
However, additional spaces are inserted in the output under the following conditions:
.sp
.cp 2
		a.	At least two spaces are inserted after each period (.), question mark (?), and exclamation mark (!)
if they occur at the end of the input line.
Spaces are not inserted after punctuation occurring within the input line, except as a result of justification.
.sp
.cp 2
		b.	One space is inserted following words at the end of the input line if a space is not already present.
.sp
.cp 2
		c.	Spaces are inserted if justification has been specified
and the output line is not the exact line length (.LL) specified.
Spaces may be inserted anywhere spaces are encountered in the input line.
.sp
.cp 2
	7.	Form feed/control-L codes (HEX 0C) in the input text file are ignored.
.sp
.cp 2
	8.	Headers (.HE/.SH) are normally printed on the first page of the output report.
If they are not desired on the first page but are to appear on subsequent pages, they must be specified after the first data record.
An example illustrating suppression of headers on the first page is provided in Section 3.
Headers are written immediately prior to writing the first text data line on the output page; therefore, if they are to be changed,
the change must take place prior to the first occurrence of data on the page.
It is recommended that the headers be changed immediately after the page eject (.PA), if explicit paging is being performed.
.sp
.cp 2
	9.	Tabbing (.TB) and substitute space character (.SC) replacement is not performed within the generation of headers (.HE), subheaders (.SH), and identifications (.IL/.IR);
therefore, tabs and substitute space characters should not be included in the parameters for those commands.
.sp
.cp 2
	10.	It is not recommended that page numbering be switched from bottom to top, or from top to bottom,
within the same document.
However, a method for doing so is provided as an example in Section 3 if it is so required.
Unless care is exercised, such switching may result in multiple page numbers on the same page or no page numbers on the page.
.sp
.cp 2
	11.	Embedded blank lines and multiple carriage returns are ignored and not printed.
.sp
.cp 2
	12.	Multiple page ejects without intervening text data are ignored in order to prevent inadvertent generation of blank pages.
If a page without any text data is required, the following sequence of commands produces the desired effect:
.sp
		.PA
		.FS
		.PA
.sp
.cp 2
	13.	The maximum number of characters that may be specified on a single input line prior to a carriage return
is dependent upon the operating system buffer size, with an absolute maximum of 255 characters.
.sp 2
.cp 5
.tc
1.5	SPECIAL FEATURES
	----------------
.sp
	Various page numbering features are available.
They include alphanumeric paging (.AN), alternate paging (.AP), numbering at the bottom of each page (.BP),
Dewey Decimal page numbering (.DD), suppression of page numbers (.NP), and top of page numbering (.TP).
The default is bottom page numbering.
The title page of this manual utilized the page suppression feature,
the body used Dewey Decimal page numbering,
and the Table of Contents and appendices used alphanumeric page numbering.
The use and specification of each type of page numbering is described in detail in Section 2, as are all available features.
.sp
.cp 2
	An identification (.IL/.IR) feature is available to provide a means of identifying each output page.
Identifications may be printed in the lower left corner, lower right corner, or both corners.
This manual is so identified by the date and version number in the lower right corner of each page,
and by the copyright in the lower left corner.
.sp
.cp 2
	A maximum of twenty tab stops can be set, and they may be changed at any point.
If none are explicitly specified via the set tab command (.TB), the defaults are 5, 10, 15, 20, 25, etc.
When a tab is encountered in the body of the text, a typewriter type tabulation occurs to the next tab stop.
If the output column is currently at a tab stop, it is moved to the next tab column specified.
If there are no further tab stops, no movement or space insertion occurs.
For example, if tabs have been set at 10, 20, and 30 and a tab code is encountered at column 20;
the output tabs to column 30.
If another tab is encountered at column 30, no tabulation takes place and subsequent data continues at column 30.
.sp
.cp 2
	A Table of Contents may be semiautomatically generated by use of the table of contents entry (.TC) and
print table of contents (.PC) commands.
The .TC command may be specified at any point in the input to cause the current page number to be
inserted into a table of page numbers for use by the .PC command.
The .PC command, followed by the desired headers to be used for the Table of Contents,
is specified at the end of the document.
The Table of Contents for this document was created using this feature.
A comprehensive example is included in Section 3 to facilitate the use of this feature.
.sp
.cp 2
	A forced space line (.FS) command is available for use where it is desired to force output
of a specific number of contiguous blank lines on a page, or at the top of a page, as was done on the title page of this manual.
Both the other blank line generation commands, space line (.SP) and blank line (.BL),
inhibit the generation of blank lines if they occur at the top of the output page after a page eject.
In addition, a new page is started if there are less than two lines remaining on a page after the .SP or .BL commands are executed.
The .FS command does not cause a page eject unless there are no lines remaining on the page, so it may be used for subtitling figures and drawings at the bottom of the page.
The difference between the .SP and .BL commands is that the .BL command is independent of
whether single or double spacing is currently in effect, while the .SP command is not.
For example, if double spacing (.DS) is in effect, the following commands all generate 10 blank lines:
.sp
.cp 3
	.BL 10
	.FS 10
	.SP 5
.sp
.cp 3
The preceding assumes, of course, that the .BL or .SP lines do not occur at the top of a page after a page eject;
in which case they are suppressed.
.pa
.cm SECTION 2
.sh SECTION 2: DETAILED DESCRIPTION
.dd
.fo
.tb 8,30
.tc
2.	DETAILED DESCRIPTION OF COMMANDS
	--------------------------------
.sp 2
	The formatting commands available in TYPE and their usage and specification are described in detail in this section.
Commands which cause a break are so indicated in parentheses after the command name.
.sp 2
.cp 5
.tc
2.1	.AN - ALPHANUMERIC PAGING COMMAND
	---------------------------------
.sp
	This command specifies that pages are to be numbered using the Dewey Decimal numbering system,
with a combination of alpha and numeric characters (B.7, i.2, X.23, etc.).
The appendices to this manual were numbered using this command.
All page numbers are written at the bottom center of the page.
.sp
.cp 2
	The optional parameter specifies the page number to be used for the next page eject; if omitted, A.1 is assumed for the first
specification and x+1.1 for subsequent specifications of the command (B.1, C.1, D.1, etc.).
The portion to the left of the decimal must be a single character; i.e., AA.0 is an invalid parameter.
Any valid ASCII character may be specified.
The portion to the right of the decimal must be numeric and cannot be greater than 9999.
.sp
.cp 2
	The page eject (.PA) command, with or without its optional parameter, may be used in conjunction with this command.
Specification of the .PA without a parameter causes a page eject and the page number to be
incremented in the manner x.n+1 (B.2, B.3, B.4, etc.).
If a parameter is specified with the .PA, the page number for the new page is set to x.p; where "p" is the specified parameter value.
.sp
.cp 2
	The bottom margin (.BM) must be at least five to allow for the page number to be printed 1/2 inch from the perforation;
.cp 6
if it is less than five, it is set to five.
The command is specified as follows:
.sp
	.AN x.n	Example: .AN C.15
.sp 2
.cp 5
.tc
2.2	.AP - ALTERNATE PAGING COMMAND
	------------------------------
.sp
	This command specifies that page numbers and headers are to be alternated from right to left at the top of each page.
Headers are printed on the left and page numbers on the right of odd-numbered pages; page numbers on the left and
headers on the right of even-numbered pages.
The page number is printed on the same line as the heading (.HE) line and is preceded by the legend "Page".
If the currently specified header (.HE) is longer than the page width (.PW) minus the left margin (.LM) minus 10,
it is truncated and a diagnostic message is issued.
The page eject (.PA) command, with or without its optional parameter,
.cp 6
may be used in conjunction with this command.
The command is specified as follows:
.sp
	.AP
.sp 2
.cp 5
.tc
2.3	.BK - BREAK ON TAB/SPACE COMMAND
	--------------------------------
.sp
	This command specifies that a break is to occur whenever a tab or space character is encountered
as the first character of the input line.
This command is normally the default, but it may be inhibited through use of the no tab/space break (.NB) command
.cp 6
and also serves to reset the .NB command.
The command is specified as follows:
.sp
	.BK
.sp 2
.cp 5
.tc
2.4	.BL - BLANK LINE COMMAND (BREAK)
	--------------------------------
.sp
	This command causes the specified number of blank lines to be generated prior to printing the next output line.
This command is independent of the currently selected spacing (.SS/.DS);
if the parameter specifies 5, only five lines are generated even if double spacing is in effect.
If the optional parameter is omitted, one blank line is generated.
The parameter must be less than the number of data lines that may be printed on a page (.PL~-~.BM~-~.TM~-~1).
If the end of the output page is encountered during execution of this command, the operation is terminated and
a new page started.
No blank lines are generated at the top of a page after a page eject.
If there are less than two lines remaining on the current page after completion of this operation,
.cp 6
a new page is started.
The command is specified as follows:
.sp
	.BL n	Example: .BL 5
.sp 2
.cp 5
.tc
2.5	.BM - SET BOTTOM MARGIN COMMAND (BREAK)
	---------------------------------------
.sp
	This command specifies the number of lines to be skipped at the bottom of each output report page.
If no .BM command is specified, the default is six.
This produces a 1-inch bottom margin at 6 lines per inch.
.cp 6
If one of the bottom paging options is in effect, the page number is printed within this bottom margin,
1/2 inch from the perforation.
The command is specified as follows:
.sp
	.BM n	Example: .BM 3
.sp 2
.cp 5
.tc
2.6	.BP - BOTTOM PAGING COMMAND
	---------------------------
.sp
	This command specifies that page numbers are to be centered at the bottom of each output report page.
This is the normal default mode of operation.
The optional parameter specifies the first report page on which page numbers are to appear;
i.e., a parameter of 3 suppresses page numbers on the first and second pages, then begins the third page with page number "3".
If the parameter is omitted, page numbers begin on the second page of the report.
The maximum page number that may be specified is 9999.
The bottom margin (.BM) must be at least five to allow for the page number to be printed 1/2 inch from the perforation;
if it is less than five, it is set to five.
The page eject (.PA) command, with or without its optional parameter,
.cp 6
may be used in conjunction with this command.
The command is specified as follows:
.sp
	.BP n	Example: .BP 2
.sp 2
.cp 5
.tc
2.7	.BR - BREAK COMMAND (BREAK)
	---------------------------
.sp
	This command causes a break to occur.
All input data encountered prior to this point is written to the output and a new output line started.
If concatenation is in effect,
.cp 6
the line is written without concatenating words from the next line.
The command is specified as follows:
.sp
	.BR
.sp 2
.cp 5
.tc
2.8	.CE - CENTER LINE COMMAND (BREAK)
	---------------------------------
.sp
	This command causes the next input data line to be centered over the column specified by the optional parameter.
The specified column number must be less than the current line length (.LL).
If the parameter is omitted, the line is centered over the column indicated by the current line length divided by 2.
If the line to be centered exceeds the current line length, it is truncated.
Tabs and spaces are treated as part of the line to be centered.
The column for centering is relative to the left margin setting (.LM)
.cp 6
and ignores any current indentation specified.
The command is specified as follows:
.sp
	.CE n	Example: .CE 45
.sp 2
.cp 5
.tc
2.9	.CM - COMMENT COMMAND
	---------------------
.sp
	This command causes the remainder of the command line to be treated as a comment.
.cp 6
It is ignored by TYPE and is not written to the output.
The command is specified as follows:
.sp
	.CM x	Example: .CM This is a comment
.sp 2
.cp 5
.tc
2.10	.CO - CONCATENATION COMMAND (BREAK)
	-----------------------------------
.sp
	This command specifies that concatenation is to become effective with the following input line.
This is the default mode of operation, but it may be inhibited by specifying the no concatenation (.NC) command
.cp 6
and is also used to cancel a previously specified .NC command.
The command is specified as follows:
.sp
	.CO
.sp 2
.cp 5
.tc
2.11	.CP - CONDITIONAL PAGE COMMAND
	------------------------------
.sp
	This command causes printing to begin on a new page if there is not enough room remaining on the current page for
the number of lines specified by the parameter.
If concatenation is in effect, the output line currently being processed is completed normally after beginning the new page;
therefore, .CP commands must be preceded by a break if the preceding data line must be output before the eject occurs.
If the parameter is omitted or is greater than the number of data lines which may be printed on a page
.cp 6
(.PL~-~.BM~-~.TM~-~1), a diagnostic is issued and the command is ignored.
The command is specified as follows:
.sp
	.CP n	Example: .CP 15
.sp 2
.cp 5
.tc
2.12	.DD - DEWEY DECIMAL PAGING COMMAND
	----------------------------------
.sp
	This command specifies that pages are numbered using the Dewey Decimal numbering system (8.32, 16.20, 3.1, etc.).
This manual was numbered using this command.
All page numbers are written at the bottom center of the page.
.sp
.cp 2
	The optional parameter specifies the page number to be used for the next page eject;
if omitted, 1.1 is assumed for the first specification and n+1.1 for subsequent specifications of the command (2.1, 3.1, 4.1, etc.).
The maximum page number that may be specified is 9999.9999.
.sp
.cp 2
	The page eject (.PA) command, with or without its optional parameter, may be used in conjunction with this command.
Specification of the .PA without a parameter causes a page eject
and the page number to be incremented in the manner n.m+1 (4.2, 4.3, 4.4, etc.).
If a parameter is specified with the .PA, the page number for the new page is set to n.p;
where "p" is the specified parameter value.
.sp
.cp 2
	The bottom margin (.BM) must be at least five to allow for the page number to be printed 1/2 inch from the perforation;
.cp 6
if it is less than five, it is set to five.
The command is specified as follows:
.sp
	.DD n.m	Example: .DD 15.6
.sp 2
.cp 5
.tc
2.13	.DS - DOUBLE SPACING COMMAND (BREAK)
	------------------------------------
.sp
	This command causes a blank line to be generated between each line of printed output.
.cp 7
It affects all commands except the blank line (.BL) and forced space line (.FS) commands.
The command is specified as follows:
.sp
	.DS
.sp 2
.cp 5
.tc
2.14	.EN - END OF TEXT FILE COMMAND (BREAK)
	--------------------------------------
.sp
	This command signifies the end of the text file to TYPE.
A page eject is performed, and control is returned to the operating system level unless merging (.ME) is in effect
(end of file processing for merge operations is described under the merge command).
The .EN should be the last command in the text file, as any subsequent data is ignored.
.cp 6
If no .EN command is encountered, processing ceases when the physical end of the input file is encountered.
The command is specified as follows:
.sp
	.EN
.sp 2
.cp 5
.tc
2.15	.FO - FORMAT COMMAND (BREAK)
	----------------------------
.sp
	This command specifies that formatting, both concatenation and justification, is to become effective with the following input line.
It is a combination of the .CO and .JU commands.
This is the normal default mode of operation.
.cp 7
It may also be used to cancel a previously specified no format (.NF), no concatenation (.NC), or no justification (.NJ) command.
The command is specified as follows:
.sp
	.FO
.sp 2
.cp 5
.tc
2.16	.FS - FORCED SPACE LINE COMMAND (BREAK)
	---------------------------------------
.sp
	This command causes the specified number of blank lines to be generated prior to printing the next output line.
This command is independent of the currently selected spacing (.SS/.DS);
if a parameter of 5 is specified, only five lines are generated even though double spacing may be in effect.
If the optional parameter is omitted, one blank line is generated.
The number of lines specified must be less than the number of data lines that may be printed on a page (.PL~-~.BM~-~.TM~-~1).
This command differs from the space line (.SP) command only in that the specified number of lines are always generated,
even if they happen to occur at the top of a page after a page eject.
The blank lines so generated are always contiguous on a single page.
If there is not enough room remaining on the current page for the number of lines specified by the parameter,
a page eject is performed prior to generating the lines.
The most common use of this feature is to reserve a specific number of blank lines on a page
.cp 6
for subsequent addition of drawings or figures after the document is generated.
The command is specified as follows:
.sp
	.FS n	Example: .FS 8
.sp 2
.cp 5
.tc
2.17	.HE - HEADING LINE COMMAND
	--------------------------
.sp
	This command specifies that a heading line is to be printed at the top of subsequent output pages.
It is printed at the left margin (.LM) unless alternate paging (.AP) is in effect.
The optional parameter specifies the heading to be printed; if omitted, the heading line is set to spaces.
The heading must be less than the output page width (.PW) minus the left margin (.LM).
If top of page numbering (.AP/.TP) is specified, the heading must be 10 characters less to allow for the page number.
Leading spaces may be used to center the heading on the page.
The heading is printed on the line specified by the heading margin (.HM) and top margin (.TM),
at the line determined by the computation .TM~-~.HM~-~1.
Additional .HE commands may be included at any point in the file to change the heading on subsequent pages.
If a new heading is to be placed on a page forced with the page eject (.PA) command,
the heading command must precede the first line of text data on the new page.
It may precede or follow the page eject command, so long as it precedes the first line of text.
.cp 6
If no .HE command is specified, a blank line is printed in its place.
The command is specified as follows:
.sp
	.HE x	Example: .HE Heading Line
.sp 2
.cp 5
.tc
2.18	.HM - SET HEADING MARGIN COMMAND (BREAK)
	----------------------------------------
.sp
	This command specifies the number of lines to be skipped between the heading lines and the first data line of the report.
The heading margin specified must always be less than or equal to the current top margin (.TM)
minus two for the heading and subheading lines.
.cp 6
If no .HM command is specified, the default is two.
The command is specified as follows:
.sp
	.HM n	Example: .HM 1
.sp 2
.cp 5
.tc
2.19	.IB - IGNORE NEXT TAB/SPACE BREAK COMMAND
	-----------------------------------------
.sp
	This command causes the next break initiated by a leading space or tab character to be ignored;
the lines are concatenated if concatenation is in effect.
This command affects only the next space or tab character initiated break;
.cp 6
it need not be placed immediately before it.
The command is specified as follows:
.sp
	.IB
.sp 2
.cp 9
.tc
2.20	.IG - IGNORE COMMAND RECORD COMMAND
	-----------------------------------
.sp
	This command specifies that the next line is to be processed as text data even if it begins with a period (.).
The command is specified as follows:
.sp
	.IG
.sp 2
.cp 5
.tc
2.21	.IL - IDENTIFICATION LEFT COMMAND
	---------------------------------
.sp
	This command specifies that the identification specified by the parameter is to be printed at the lower left corner of each page,
five spaces from the left perforation.
The identification may be a maximum of 30 characters; if omitted, it cancels printing of the previous left identification.-Leading and trailing spaces are treated as part of the identification.
The bottom margin (.BM) must be at least five
.cp 7
to allow the identification to be printed 1/2 inch from the perforation; if it is less than five, it is set to five.
The command is specified as follows:
.sp
	.IL x	Example: .IL (C) 1980 AMS
.sp 2
.cp 5
.tc
2.22	.IN - INDENTATION COMMAND (BREAK)
	---------------------------------
.sp
	This command specifies that subsequent output lines are to be indented the number of spaces from the left margin (.LM) specified
by the optional parameter.
The number of spaces must be less than the currently specified line length (.LL).
.cp 6
If the parameter is zero or omitted, any previously specified indentation is cancelled.
The command is specified as follows:
.sp
	.IN n	Example: .IN 5
.sp 2
.cp 5
.tc
2.23	.IR - IDENTIFICATION RIGHT COMMAND
	----------------------------------
.sp
	This command specifies that the identification specified by the parameter is to be printed at the lower right corner of each page,
five spaces from the right perforation.
The identification may be a maximum of 30 characters;
if omitted, it cancels printing of the previous right identification.
Leading and trailing spaces are treated as part of the identification.
The bottom margin (.BM) must be at least five
.cp 7
to allow the identification to be printed 1/2 inch from the perforation; if it is less than five, it is set to five.
The command is specified as follows:
.sp
	.IR x	Example: .IR 02-14-76/V1.0
.sp 2
.cp 5
.tc
2.24	.JU - JUSTIFICATION COMMAND (BREAK)
	-----------------------------------
.sp
	This command specifies that justification is to become effective with the next input line.
This is the normal default mode of operation.
.cp 6
It also cancels a previously specified no justification (.NJ) command.
The command is specified as follows:
.sp
	.JU
.sp 2
.cp 5
.tc
2.25	.LL - SET LINE LENGTH COMMAND (BREAK)
	-------------------------------------
.sp
	This command specifies the maximum number of characters that are to be printed on the output line relative to the left margin (.LM).
The line length cannot be greater than the page width (.PW) minus the left margin (.LM).
If no .LL command is specified, the default is 65.
This allows one inch margins at both sides of standard 8-1/2 by 11-inch paper at 10 characters per inch.
Input lines exceeding the maximum allowable line length are truncated if concatenation (.CO or .FO) is not in effect.
Any indentation specified (.IN/.OF) is treated as part of the allowable line length
and reduces the number of actual text characters permitted on the output line.
If truncation occurs, a diagnostic message is issued and
.cp 6
the first four bytes of data on the output line are replaced with "<<<<".
The command is specified as follows:
.sp
	.LL n	Example: .LL 60
.sp 2
.cp 5
.tc
2.26	.LM - SET LEFT MARGIN COMMAND (BREAK)
	-------------------------------------
.sp
	This command specifies the number of spaces to be skipped as the left margin of the output page;
the permanent indentation from the leftmost print position of the print head (normally set at the left perforation).
It affects all indentation (.IN/.OF/.UN), tabbing (.TB), centering (.CE), heading (.HE), subheading (.SH), and line length (.LL)
commands.
All such commands are relative to the specified left margin.
If no .LM command is specified, the default is 10.
.cp 6
This produces a one-inch left margin at 10 characters per inch.
The command is specified as follows:
.sp
	.LM n	Example: .LM 15
.sp 2
.cp 5
.tc
2.27	.ME - MERGE COMMAND
	-------------------
.sp
.cp 2
	This command specifies that input of data for TYPE is to be switched from the current input file to the alternate input file.
The data is initially input from the first file until a merge command is encountered.
Data is then input from the second file until a merge command is encountered in the second file,
at which time the input is switched back to the first file.
.sp
.cp 2
	The switching/merging process is continued at each encounter of the merge command
until an end of file (EOF) is encountered on both input files.
If at least one merge command has been encountered in the first file when the file reaches EOF, but the second file has not reached EOF;
the first file is rewound and reprocessed until an EOF is detected in the second file.
At that time, input is switched back to the first file for the last time.
Any subsequent merge commands encountered in the first file after this point are displayed as errors and ignored
since the second file is already at EOF.
.sp
.cp 2
	The last command in both files should be an end of file (.EN) command.
The last command in the second file prior to the .EN should NOT be a merge command;
otherwise, the entire first file is processed again, causing errors to occur.
If a merge command is never encountered in the first file even though two input files are specified,
execution is terminated when the end of the first file is encountered.
If a merge command is encountered in the first file and no second file has been specified;
a diagnostic message is issued and "<MERGE>" is inserted in the output at the point the merge would have taken place.
.sp
.cp 2
	An example of the merge is provided in Section 3 for further clarification.
Any of the other commands may be specified in either of the input files;
.cp 6
those last encountered, in either file, are the ones that are in effect.
The merge command is specified as follows:
.sp
	.ME
.sp 2
.cp 7
.tc
2.28	.NB - NO TAB/SPACE BREAK COMMAND
	--------------------------------
.sp
	This command specifies that all subsequently encountered input lines with leading space or tab characters will not cause a break.
All such lines are concatenated with prior lines if concatenation is in effect.
.cp 6
This command remains in effect until cancelled by a break on tab/space (.BK) command.
The command is specified as follows:
.sp
	.NB
.sp 2
.cp 5
.tc
2.29	.NC - NO CONCATENATION COMMAND (BREAK)
	--------------------------------------
.sp
	This command inhibits concatenation; all lines are printed without shifting words to or from the next input line.
.cp 6
The command remains in effect until cancelled by a concatenation (.CO) or format (.FO) command.
The command is specified as follows:
.sp
	.NC
.sp 2
.cp 5
.tc
2.30	.NF - NO FORMAT COMMAND (BREAK)
	-------------------------------
.sp
	This command specifies that neither concatenation nor justification is to take place.
It cancels any previous concatenation (.CO), justification (.JU), or format (.FO) command.
.cp 6
It remains in effect until another .FO command is encountered.
The command is specified as follows:
.sp
	.NF
.sp 2
.cp 10
.tc
2.31	.NJ - NO JUSTIFICATION COMMAND (BREAK)
	--------------------------------------
.sp
	This command inhibits the justification process.
It remains in effect until cancelled by a justification (.JU) or format (.FO) command.
The command is specified as follows:
.sp
	.NJ
.sp 2
.cp 5
.tc
2.32	.NN - NO TABLE OF CONTENTS PAGE COMMAND (BREAK)
	-----------------------------------------------
.sp
	This command specifies that the following input data line is to be printed as is,
and is not to be formatted as a Table of Contents entry.
This command is valid only during the printing of the Table of Contents (.PC);
a diagnostic message is issued if it is encountered at any other point.
The command applies only to the next data line; it must be repeated prior to each subsequent line if multiple lines
are to be treated in the same manner.
.cp 6
The data line is printed in the normal manner in accordance with all currently specified commands.
The command is specified as follows:
.sp
	.NN
.sp 2
.cp 5
.tc
2.33	.NP - NO PAGE NUMBERING COMMAND
	-------------------------------
.sp
	This command inhibits the printing of page numbers on the output report and resets all other paging options.
The page number continues to be incremented with each page eject, however; so page numbering may be resumed at any point.
If the page number is to be started or restarted at 1 or some other specific number,
.cp 6
it must be explicitly specified in the page eject (.PA) command following the paging option selection; i.e., .PA~1.
The command is specified as follows:
.sp
	.NP
.sp 2
.cp 5
.tc
2.34	.OF - OFFSET COMMAND (BREAK)
	----------------------------
.sp
	This command specifies that all but the first line of a paragraph or section are to be indented by the number of spaces 
specified by the parameter.
Offsetting is in addition to any currently specified indentation (.IN); therefore, the number of spaces to be offset
must be less than the current line length (.LL) minus the indentation.
If the parameter is zero or is omitted, any previously specified offsetting is cancelled.
While the offset command is in effect, any subsequently encountered break
.cp 6
causes the offset operation to be restarted for the following paragraph or section.
The command is specified as follows:
.sp
	.OF n	Example: .OF 7
.sp 2
.cp 5
.tc
2.35	.OP - OVERPRINT COMMAND (BREAK)
	-------------------------------
.sp
	This command specifies that the next two output text lines are to be overprinted.
No vertical movement of the paper occurs; therefore, both lines are printed on the same line.
The backspace control code (hexadecimal~08) is utilized in accomplishing this function;
therefore, any device to which such output is directed must support backspacing.
This command may be used to underline headers and titles, as well as to create special figures by overprinting characters.
It is the user's responsibility to insure that the overprint lines align in the desired manner;
.cp 5
hence, justification and concatenation should not be attempted for overprint lines.
The command is specified as follows:
.sp
	.OP
.sp 2
.cp 5
.tc
2.36	.PA - PAGE EJECT COMMAND (BREAK)
	--------------------------------
.sp
	This command causes a page eject to occur and a new page to be started.
The heading (.HE) and subheading (.SH) lines are not actually generated by the page eject;
instead, they are output at the time the first line of text data is written on the new page.
The optional parameter specifies the page number to be used for the new page; if omitted, the page number is incremented by 1.
The maximum page number that may be specified is 9999.
.sp
.cp 2
	This command may be used in conjunction with any of the various page numbering options,
including Dewey Decimal page numbering (.AN/.DD).
If Dewey Decimal page numbering is in effect and no parameter is specified, the page number is incremented in the manner n.m+1.
If a valid parameter is specified, the page number for the new page is set to n.p; where "p" is the specified parameter value.
For example, if the current page number is 23.15 and a ".PA 6" command is encountered,-the new page is numbered as 23.6.
.sp
.cp 2
	If Dewey Decimal page numbering is not in effect, the page number is simply incremented by 1 if no parameter is specified;
.cp 6
otherwise, the new page number is set to the specified parameter value.
The command is specified as follows:
.sp
	.PA n	Example: .PA 4
.sp 2
.cp 5
.tc
2.37	.PC - PRINT TABLE OF CONTENTS COMMAND (BREAK)
	---------------------------------------------
.sp
	This command specifies that subsequent input data lines are to be used as headers
for generating a Table of Contents.
A page eject is performed prior to generation of the Table of Contents and after completion of the Table of Contents.
No standard titles, such as "TABLE OF CONTENTS", are automatically generated; if they are desired, they must be specified by the user.
.sp
.cp 2
	A page number is obtained from a table of page numbers for each header line encountered.
The page numbers must have been previously placed in the table by specification of table of contents entry (.TC) commands
at appropriate locations throughout the document.
If there are more or fewer page numbers in the table than header lines following the .PC command,
a diagnostic message is issued.
.cp 4
It is the user's responsibility to insure that the number and sequence of .TC commands
match the number and sequence of header lines following the .PC command.
.sp
.cp 2
	The printing of the Table of Contents is terminated by the end of file (.EN) command or by specification of another .PC command.
Specification of another .PC command clears the page number table to allow new entries to be made;
thereby allowing the generation of multiple Tables of Contents for different portions of the document, if desired.
.sp
.cp 2
	All commands are functional within operation of the .PC command;
with the exception of formatting (.FO), justification (.JU), and concatenation (.CO).
.sp
.cp 2
	Table of Contents entries consist of the input header line and the page number, separated by a string of dots.
At least one dot is inserted between the header and the page number.
The page number may be a maximum of eight characters, including the decimal in Dewey Decimal and alphanumeric paging.
The maximum length of the header that may be printed as a Table of Contents entry
is the line length (.LL), minus all tabbing and indentation, minus 11.
.sp
.cp 2
	User selected input data lines may be excluded from inclusion as Table of Contents headers
by specifying that they be centered, or by preceding them with a no table of contents page number (.NN) command.
.cp 5
A detailed example of the use of this command, as well as the .TC and .NN commands, is provided in Section 3.
The command is specified as follows:
.sp
	.PC
.sp 2
.cp 5
.tc
2.38	.PL - SET PAGE LENGTH COMMAND (BREAK)
	-------------------------------------
.sp
	This command specifies the number of lines on the output page from perforation to perforation.
If no .PL command is specified, the default is 66.
.cp 7
This is the length of standard 8-1/2 by 11-inch paper at six lines per inch.
The command is specified as follows:
.sp
	.PL n	Example: .PL 66
.sp 2
.cp 5
.tc
2.39	.PW - SET PAGE WIDTH COMMAND (BREAK)
	------------------------------------
.sp
	This command specifies the width of the output page in characters from perforation to perforation.
The maximum width that may be specified is 132.
If no .PW command is specified, the default is 85.
.cp 6
This is the width of standard 8-1/2 by 11-inch paper at 10 characters per inch.
The command is specified as follows:
.sp
	.PW n	Example: .PW 60
.sp 2
.cp 5
.tc
2.40	.SC - SUBSTITUTE SPACE CHARACTER COMMAND (BREAK)
	------------------------------------------------
.sp
.sc _
	This command specifies that all occurrences of the character specified by the parameter are to be printed as spaces on the output report.
A space normally indicates where line breaks and justification may occur;
this command allows the printing of spaces without allowing a line break or additional space insertion to occur at that point.
.cp 6
If no .SC command is specified, the default is "~".
The command is specified as follows:
.sc ~
.sp
	.SC x	Example: .SC _
.sp 2
.cp 5
.tc
2.41	.SH - SUBHEADING LINE COMMAND
	-----------------------------
.sp
	This command specifies a subheading line to be printed after the heading line (.HE) at the top of subsequent output pages.
It is be printed at the left margin (.LM) unless alternate paging (.AP) is in effect.
The optional parameter specifies the subheading to be printed; if omitted, the subheading is set to spaces.
If the subheading is longer than the specified page width (.PW) minus the left margin (.LM),
a diagnostic is issued and the subheading is truncated.
Leading spaces may be used to center the subheading on the page.
Additional .SH commands may be included at any point in the file to change the subheading on subsequent pages.
If a new subheading is to be placed on a page forced with the page eject (.PA) command,
the .SH must precede the first line of text data on the new page.
It may precede or follow the page eject command, so long as it precedes the first text line.
.cp 6
If no .SH command is specified, a blank line is printed in its place.
The command is specified as follows:
.sp
	.SH x	Example: .SH Subheading Line
.sp 2
.cp 5
.tc
2.42	.SP - SPACE LINE COMMAND (BREAK)
	--------------------------------
.sp
	This command causes the specified number of blank lines to be generated prior to the printing of the next data line.
This command is dependent on the currently selected spacing (.SS/.DS); if double spacing is in effect,
two lines for each one line specified are generated.
If the optional parameter is omitted, one blank line is generated (or two if double spacing is in effect).
The parameter must be less than the number of data lines which may be printed on a page (.BL~-~.BM~-~.TM~-~1).
If the end of the output page is encountered during execution of this command, the operation is terminated and a new page started.
No blank lines are generated at the top of a page after a page eject.
.cp 7
If there are less than two lines remaining on the current page after this operation is completed, a new page is started.
The command is specified as follows:
.sp
	.SP n	Example: .SP 3
.sp 2
.cp 5
.tc
2.43	.SS - SINGLE SPACING COMMAND (BREAK)
	------------------------------------
.sp
	This command specifies that all output lines are to be single spaced.
This is the normal default mode of operation.
.cp 6
It may also be used to cancel a previous double spacing (.DS) command.
The command is specified as follows:
.sp
	.SS
.sp 2
.cp 5
.tc
2.44	.TB - SET TABS COMMAND (BREAK)
	------------------------------
.sp
	This command specifies the columns at which tab stops are to be set for the output report.
The optional parameters may specify up to 20 tab stops;
if omitted, the default is to tab settings of 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, and 100.
Tab stops must be specified in ascending order and must be less than the current line length (.LL).
If a parameter error is encountered, setting of the tab stops ceases at the point the error occurred;
i.e., if ".TB 5,10,9,20" were specified, tab stops are set only at columns 5 and 10.
When a tab is encountered in the input, it causes a typewriter type tabulation to the next tab stop.
If the output column is currently at a tab stop, it is moved to the next one specified; if there are no more tab stops set,
no movement nor space insertion occurs.
All tab settings are relative to the left margin (.LM) and are independent of any indentation commands.
A tab as the first character of a line causes a break
.cp 6
unless the no tab/space break (.NB) or ignore next tab/space break (.IB) command is in effect.
The command is specified as follows:
.sp
	.TB n1,n2,n3,...	Example: .TB 6,12,18
.sp 2
.cp 5
.tc
2.45	.TC - TABLE OF CONTENTS ENTRY COMMAND
	-------------------------------------
.sp
	This command specifies that the current page number is to be placed in a table for subsequent use by the print table of contents (.PC) command.
At the end of the document, the .PC command is then specified to print the Table of Contents
using the page numbers from this table and headers supplied by the user.
It is the responsibility of the user to insure that the number and sequence of .TC commands
match the number and sequence of the headers following the .PC command.
The page number may be a maximum of eight characters, including the period in Dewey Decimal and alphanumeric page number formats.
.cp 5
A maximum of 300 page number entries are currently allocated in this table.
The command is specified as follows:
.sp
	.TC
.sp 2
.cp 5
.tc
2.46	.TM - SET TOP MARGIN COMMAND (BREAK)
	------------------------------------
.sp
	This command specifies the number of lines between the top of page perforation and the first data line of the output report.
It includes the heading line (.HE), subheading line (.SH), and the heading margin (.HM).
The top margin specified must always be equal to or greater than the current heading margin plus two lines for the heading
and subheading lines.
.cp 6
If no .TM command is specified, the default is 6.
This produces a one-inch top margin at 6 lines per inch.
The command is specified as follows:
.sp
	.TM n	Example: .TM 5
.sp 2
.cp 5
.tc
2.47	.TP - TOP PAGING COMMAND
	------------------------
.sp
	This command specifies that page numbers are to be printed at the top of each page at the right margin.
The page number is printed on the same line as the heading (.HE) line and is preceded by the legend "Page".
If the currently specified header (.HE) is longer than the page width (.PW) minus the left margin (.LM) minus 10,
it is truncated and a diagnostic message is issued.
.cp 7
The page eject (.PA) command, with or without its optional parameter, may be used in conjunction with this command.
The command is specified as follows:
.sp
	.TP
.sp 2
.cp 5
.tc
2.48	.UN - UNDENTATION COMMAND (BREAK)
	---------------------------------
.sp
	This command forces the next line to start further left than the position indicated by the currently specified indentation (.IN).
It is usually used to make the first line of a section extend further to the left than the body of the section.
The number of positions the line is to be "undented" to the left
.cp 6
must be less than or equal to the current indentation setting.
.cp 4
The command is specified as follows:
.sp
	.UN n	Example: .UN 8
.pa
.cm SECTION 3
.sh SECTION 3: USAGE EXAMPLES
.dd
.tb 8,13,30
.fo
.in 0
.tc
3.	USAGE EXAMPLES
	--------------
.sp 2
	This section provides detailed examples of the use and specification of many of the commands
available in the TYPE Document Formatting Program.
The more complex commands require an exact knowledge of their purpose and effect in order to produce the expected results.
Prior to using such commands for the first time, it is recommended that the user thoroughly study the examples illustrating their usage.
A description of the output format generated by defaulting all commands is also provided in this section, as well as the format normally used for standard business letters.
For illustrative purposes only, all tabs in the input text examples in this section are indicated by the characters "<tab>".
.sp 2
.tc
3.1	DEFAULTS
	--------
.sp
	If a text data file in which no commands have been specified is input to TYPE, the defaults for all commands are used.
The output is generated with the following format:
.sp
	a.	One-inch margins on all sides: left, right, top, and bottom.
.sp
	b.	No heading, subheading, or identification lines appear on the output.
.sp
	c.	Page numbers appear at the bottom of each page,
beginning with the second page as page number "2" and subsequent page numbers incremented by 1.
.sp
	d.	The output is single spaced.
.sp
	e.	A break occurs if spaces or tabs are encountered at the start of an input text line.
.sp
	f.	All lines are concatenated and justified.
.sp
.sc _
	g.	The substitute space character is "~".
.sp
.sc ~
	h.	Tab settings are at columns 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 55, 60, 65, 70, 75, 80, 85, 90, 95, and 100.
.pa
.tc
3.2	STANDARD BUSINESS LETTER
	------------------------
.sp
	The following example produces a standard business letter:
1-1/2 inch left and top margins;
1 inch right and bottom margins;
66 lines per page (at 6 lines per inch and 10 characters per inch);
tabs every 5 spaces at columns 6, 11, 16, 21, 26, etc.;
no headings or page numbers;
concatenation but no justification.
.sp 3
	.LM 15
	.TM 9
	.LL 60
	.NP
	.TB 6,11,16,21,26,31,36,41,46,51,56
	.NF
	March 24, 1980
	.SP 2
	La Guardia Supplies and Printers, Inc.
	7891 La Mirada Lane
	Buena Park, CA 90623
	.SP
	Gentlemen,
	.SP
	.CO
	<tab>Thank you for your enquiry of February 14, 1980,
	concerning our new product, the Dual-Way Snap-Apart
	Instant Memo.  This new form offers the convenience
	of a multiple copy memo without the mess of carbons.
	The Dual-Way Snap-Apart Instant Memo is available
	immediately, and at a substantial discount.
	.SP
	<tab>The Instant Memo is available in case lots at a
	15% discount; with a 4% discount for prompt payment.
	Please do not hesitate to contact us if we can be of
	service to you in any way.
	.SP
	Sincerely,
	.SP 3
	Alfred J. Manhatten
	.EN
.pa
.tc
3.3	GENERAL EXAMPLE
	---------------
.sp
	The following example demonstrates several of TYPE's capabilities.
.sp
.tb 8,12,32,45
	.TB 5,25,38
	.LL 50
	.CE
	Usage Example 1
	.SP
	.DS
	This paragraph is double-spaced with the .DS command.
	No break is needed following this paragraph since a
	return to single spacing (.SS) also causes a break.
	.SS
	Although this is in format (.FO) mode, tabular
	information may be included.  The tab beginning each
	line causes a break, so no concatenation occurs.
	<tab>SINGLE SPACE<tab>.SS<tab>.ss
	<tab>DOUBLE SPACE<tab>.DS<tab>.ds
	.LL 30
	Use of the line length (.LL) command allows space to
	be reserved within a page for figures or drawings.
	The new line length must take effect at a paragraph,
	since it acts as a break.
	.LL 50
	<tab><tab><tab>CAPTION
	.BR
	PARAGRAPHS
	.BR
	A break is necessary following a paragraph heading
	while in format mode to prevent the heading from
	being concatenated to the body of the paragraph.
	<tab>A tab is the easiest way to force a break and
	separate paragraphs, as was done  with this one.
	The center (.CE) command is useful for small
	figures included in the text.  Note that it is
	required preceding every line to be centered.
	.SP
	.CE
	|----------------------|
	.CE
	|    CENTER EXAMPLE    |
	.CE
	|______________________|
	.CE
	Figure A
	.EN
.pa
Following is the output produced by TYPE from the preceding example.
.sp 4
.lm 17
.ll 50
.tb 5,25,38
.ce
Usage Example 1
.sp
.ds
This paragraph is double-spaced with the .DS command.
No break is needed following this paragraph since a return to single spacing (.SS) also causes a break.
.ss
Although this is in format (.FO) mode, tabular information may be included.
The tab beginning each line causes a break, so no concatenation occurs.
	SINGLE SPACE	.SS	.ss
	DOUBLE SPACE	.DS	.ds
.ll 30
Use of the line length (.LL) command allows space to be reserved within a page for figures or drawings.
The new line length must take effect at a paragraph, since it acts as a break.
.ll 50
				CAPTION
.br
PARAGRAPHS
.br
A break is necessary following a paragraph heading while in format mode to prevent the heading from being concatenated to
the body of the paragraph.
	A tab is the easiest way to force a break and separate paragraphs, as was done with this one.
The center (.CE) command is useful for small figures included in the text.
Note that it is required preceding every line to be centered.
.sp
.ce
|----------------------|
.ce
|    CENTER EXAMPLE    |
.ce
|______________________|
.ce
Figure A
.lm 12
.ll 60
.tb 8,13,30
.pa
.tc
3.4	LETTER AND ADDRESS FILE MERGE
	-----------------------------
.sp
	This example illustrates the input files required for merge processing.
Input file one contains a form letter which is to be printed for each address in input file two.
The merging of the two input files is controlled by specification of merge (.ME) commands in each of the input files.
Care must be taken to insure that the files match regarding merge points and the data to be merged.
If punctuation is required immediately following a word obtained from a merge file,
it must be included with the word in that file.
The following shows the contents of the input files required for the merge processing, followed by the ouput produced by TYPE.
The file specification for this example is:
.sp
	PR:=FORMLTR,ADDRESSES
.sp
Contents of file FORMLTR (input file 1):
.sp 3
	.NP
	.NF
	February 14, 1980
	.SP 3
	.ME
	.SP
	.CO
	Dear
	.ME
	.SP
	Thank you for your assistance in marketing our latest
	product, the Sierra Winters Geodesic three-man
	backpacker tent.  The response has been exceptional,
	and I'm sure your efforts contributed to this.
	.SP
	I wish to thank you again,
	.ME
	for your support.
	.SP
	.NF
	Sincerely,
	.SP 3
	Arlen A. Beaumont
	.PA
	.EN
.pa
Contents of file ADDRESSES (input file 2):
.sp 3
	Mr. Michael A. Bartone
	Long-Life Freeze-Dried Foods, Inc.
	700781 La Mission La Grande Avenue
	Los Angeles, CA 90008
	.ME
	Mr. Bartone,
	.ME
	Michael,
	.ME
	Mr. Jack M. Brockenmeyers
	622 East 7th Street
	Long Beach, CA 90807
	.ME
	Mr. Brockenmeyers,
	.ME
	Mr. Brockenmeyers,
	.ME
	Ms. Alice A. Gardis
	8325 West Bay Drive
	Roseville, CA 95678
	.ME
	Ms. Gardis,
	.ME
	Ms. Gardis,
	.EN
.pa
The letters output from TYPE, each on a separate page due to the .PA command in the first file, appear as follows:
.sp 5
.in 7
February 14, 1980
.sp 3
.nf
Mr. Michael A. Bartone
Long-Life Freeze-Dried Foods, Inc.
700781 La Mission La Grande Avenue
Los Angeles, CA 90008
.sp
.co
Dear Mr. Bartone,
.sp
Thank you for your assistance in marketing our latest product, the Sierra Winters Geodesic three-man backpacker tent.
The response has been exceptional, and I'm sure your efforts contributed to this.
.sp
I wish to thank you again, Michael, for your support.
.sp
Sincerely,
.sp 3
Arlen A. Beaumont
.pa
.fs 5
February 14, 1980
.sp 3
.nf
Mr. Jack M. Brockenmeyers
622 East 7th Street
Long Beach, CA 90807
.sp
Dear Mr. Brockenmeyers,
.sp
.co
Thank you for your assistance in marketing our latest product, the Sierra Winters Geodesic three-man backpacker tent.
The response has been exceptional, and I'm sure your efforts contributed to this.
.sp
I wish to thank you again, Mr. Brockenmeyers, for your support.
.sp
Sincerely,
.sp 3
Arlen A. Beaumont
.pa
.fs 5
February 14, 1980
.sp 3
.nf
Ms. Alice A. Gardis
8325 West Bay Drive
Roseville, CA 95678
.sp
Dear Ms. Gardis,
.sp
.co
Thank you for your assistance in marketing our latest product, the Sierra Winters Geodesic three-man backpacker tent.
The response has been exceptional, and I'm sure your efforts contributed to this.
.sp
I wish to thank you again, Ms. Gardis, for your support.
.sp
Sincerely,
.sp 3
Arlen A. Beaumont
.pa
.in 0
.fo
.tc
3.5	DEWEY DECIMAL PAGE NUMBERING
	----------------------------
.sp
	The following example prints four pages numbered in the Dewey Decimal numbering system,
with page numbers of 1.1, 1.2, 2.1, and 4.5.
.sp
	.CM The following sets the first page number to "1.1"
	.DD
	  |
	 text
	  |
	.CM The following prints page number "1.1" and ejects
	.PA
	  |
	 text
	  |
	.CM The following prints page number "1.2" and ejects
	.PA
	.CM The following changes the page number to "2.1"
	.DD
	  |
	 text
	  |
	.CM The following prints page number "2.1" and ejects
	.PA
	.CM The following changes the page number to "4.5"
	.DD 4.5
	  |
	 text
	  |
	.CM The following prints page number "4.5" and ejects
	.PA
	  |
	 etc.
.sp
	Note that the occurrence of the .DD command merely initializes the page number, it does not cause a page eject.
The occurrence of the .PA causes the actual page eject, then increments the page number from "1.1" to "1.2".
The second occurrence of the .DD command causes the page number to be incremented from "1.2" to "2.1".
Since the third occurrence of the .DD command does include a parameter,
the page number is set to that specified by the parameter ("4.5").
If a .PA with a parameter is encountered, the right hand portion of the page number on the new page is set to the parameter value;
i.e., if the current page number is 4.6, a ".PA 8" prints page 4.6 and numbers the next page as 4.8.
.pa
.tc
3.6	ALPHANUMERIC PAGE NUMBERING
	---------------------------
.sp
	The following example accomplishes the same purpose as example 3.5, except the pages are numbered A.1, A.2, B.1, and D.5.
.sp
	.CM The following sets the first page number to "A.1"
	.AN
	  |
	 text
	  |
	.CM The following prints page number "A.1" and ejects
	.PA
	  |
	 text
	  |
	.CM The following prints page number "A.2" and ejects
	.PA
	.CM The following changes the page number to "B.1"
	.AN
	  |
	 text
	  |
	.CM The following prints page number "B.1" and ejects
	.PA
	.CM The following changes the page number to "D.5"
	.AN D.5
	  |
	 text
	  |
	.CM The following prints page number "D.5" and ejects
	.PA
	  |
	 etc.
.sp
	Note that the occurrence of the .AN command merely initializes the page number to "A.1", it does not cause a page eject.
The occurrence of the .PA causes the actual page eject, then increments the page number from "A.1" to "A.2".
The second occurrence of the .AN command causes the page number to be incremented from "A.2" to "B.1".
Since the third occurrence of the .AN command does include a parameter,
the page number is set to that specified by the parameter ("D.5").
If a .PA with a parameter is encountered, the right hand portion of the page number on the new page is set to the parameter value;
i.e., if the current page number is F.11, a ".PA 9" prints page F.11 and numbers the next page as F.9.
.pa
.tb 8,13,18,30
.tc
3.7	CHANGING THE HEADER, SUBHEADER, AND IDENTIFICATION
	--------------------------------------------------
.sp
	The following example produces page headers, subheaders, and identifications on the output as follows:
.sp 3
	Page 1	Header	= "Heading A"
			Subheader	=  none
			IL	= "Left ID 1"
			IR	= "Right ID 1"
.sp
	Page 2	Header	=  unchanged
			Subheader	= "Subheading A"
			IL	= "Left ID 2"
			IR	=  unchanged
.sp
	Page 3	Header	= "Heading B"
			Subheader	= "Subheading B"
			IL	= "Left ID 3"
			IR	= "Right ID 2"
.sp 3
The commands, in the required sequence, are as follows:
.sp 3
	.HE Heading A
	.IL Left ID 1
	.IR Right ID 1
	  |
	  |
	 text
	  |
	  |
	.CM The following prints the first page and ejects
	.PA
	.CM The following changes the subheading for page 2
	.SH Subheading A
	.CM The following changes the left ID for page 2
	.IL Left ID 2
	  |
	  |
	 text
	  |
	  |
.pa
	  |
	  |
	.CM The following prints page number "2" and ejects
	.PA
	.CM The following changes the headers for page 3
	.HE Heading B
	.SH Subheading B
	.CM The following changes the ID's for page 3
	.IL Left ID 3
	.IR Right ID 2
	  |
	  |
	 text
	  |
	  |
	.CM The following prints page number "3" and ejects
	.PA
	  |
	  |
	 etc.
.sp 4
	Note that the header and subheader must be changed PRIOR to the first occurrence of text data on the page on which they are to appear,
since they are printed at the top of each page.
The identifications must be changed AFTER the eject to the page on which they are to appear,
since they are printed at the bottom of each page.
The header, subheader, and identification are changed IMMEDIATELY when they are encountered;
thus are in effect the very next time they are output.
.sp
	The headers are generated at the time the first line of text data is written to the output page;
they are not generated by the page eject itself.
Conversely, the identifications are generated during the page eject processing.
.pa
.tc
3.8	SUPPRESSING HEADERS ON THE FIRST PAGE
	-------------------------------------
.sp
	The following example suppresses printing of headers and subheaders on the first page of the output.
Subsequent pages have both headers and subheaders.
.sp 3
	 text
	  |
	  |
	.CM The following initializes the headers for page 2
	.HE Heading Line
	.SH Subheading Line
	  |
	  |
	 text
	  |
	  |
	.CM The following prints the first page and ejects
	.PA
	  |
	  |
	 text
	  |
	  |
	 etc.
.sp 3
	Note that the .HE and/or .SH commands may be specified at any time after the first occurrence of text data
in order to initiate the headers on subsequent pages.
They do not need to be specified immediately prior to or following the page eject;
in fact, no explicit page eject (.PA) need be specified at all.
The headers take effect the very next time they are output; which in this case is at the top of the next page.
.pa
.tc
3.9	SUPPRESSING PAGE NUMBERS ON THE FIRST PAGE
	------------------------------------------
.sp
	The following example suppresses the page number on the first page, then numbers subsequent pages beginning with page number "1.1".
If bottom paging (.BP) is selected, suppression of the page number on the first page is the normal default;
therefore, no further action is required by the user.
.sp 3
	.CM The following inhibits printing of page numbers
	.NP
	  |
	  |
	 text
	  |
	  |
	.CM The following ejects to the 2nd page
	.PA
.of 11
	.CM~The following resumes page numbering and numbers the second page as "1.1"
.of
	.DD
	  |
	  |
	 text
	  |
	  |
	 etc.
.sp 3
	The no page numbering (.NP) command suppresses the generation of page numbers on the output document.
To resume page numbering, the desired page numbering command (i.e., .BP, .DD, .AP, etc.) is specified at the appropriate location in the input text.
The .NP is frequently used to prevent page numbers from appearing on title and cover pages.
.pa
.tc
3.10	INDENTATION
	-----------
.sp
	The following example illustrates the use of the indentation (.IN) command.
The indentation command allows a section of the output to be indented a specific number of spaces from the left margin (.LM).
The indentation is reset only by another indentation or by an indentation specification of null or zero (.IN or .IN 0).
.sp 3
	This text prints at the normal left margin of the
	output.  However, specification of the following
	indentation command causes subsequent output to be
	indented by five spaces.
	.IN 5
	Thus, this paragraph prints five spaces further to
	the right than the preceding paragraph. The
	indentation can be cancelled by either another
	indentation or by an indentation of zero (.IN 0).
	.IN 0
	This paragraph now resumes printing at the far left
	margin specified by the .LM command. The indentation
	command may also be used to "reserve space" at the 
	left margin for figures, drawings, etc.
.sp 3
The above example prints as follows:
.sp 3
.lm 19
.ll 50
This text prints at the normal left margin of the output.
However, specification of the following indentation command causes subsequent output to be indented by five spaces.
.in 5
Thus, this paragraph prints five spaces further to the right than the preceding paragraph.
The indentation can be cancelled by either another indentation or by an indentation of zero (.IN 0).
.in 0
This paragraph now resumes printing at the far left margin specified by the .LM command.
The indentation command may also be used to "reserve space" at the left margin for figures, drawings, etc.
.lm 12
.ll 60
.pa
.tc
3.11	OFFSETTING
	----------
.sp
	This example illustrates the use of the offset (.OF) command.
The offset command specifies that all but the first line of paragraphs are to be indented
a specific number of spaces from the current left margin (.LM) or indentation (.IN) point.
Offsetting is cancelled by a subsequent offset specification of null or zero.
.sp
.lm 19
.ll 50
.nj
.tb 5,10
.ig
.TB 5,10
.br
.ig
.OF 9
.br
The first line of this paragraph begins at the normal left margin.
All subsequent lines are indented nine spaces by the offset command.
.br
<tab>Leading tabs and spaces cause a break and prevent the input line from being offset or concatenated to the prior line.
.br
<tab><tab>This sentence was preceded by a tab to column 10.
The break caused by the tab inhibits the concatenation process
and causes the offset operation to be "restarted" for the paragraph.
.br
.ig
.SP
.br
Since offsetting continues in effect until cancelled or reset by another offset command,
offsetting is also performed for all subsequent paragraphs.
.br
.ig
.OF
.sp 2
.lm 12
The above example prints as follows:
.lm 19
.sp
.fo
.of 9
The first line of this paragraph begins at the normal left margin.
All subsequent lines are indented nine spaces by the offset command.
	Leading tabs and spaces cause a break and prevent the input line from being offset or concatenated to the prior line.
		This sentence was preceded by a tab to column 10.
The break caused by the tab inhibits the concatenation process
and causes the offset operation to be "restarted" for the paragraph.
.sp
Since offsetting continues in effect until cancelled or reset by another offset command,
offsetting is also performed for all subsequent paragraphs.
.of
.lm 12
.ll 60
.tb 8,13,30
.pa
.tc
3.12	UNDENTATION
	-----------
.sp
	The undentation (.UN) command allows the first line of a paragraph or section to begin a specific number of spaces
to the left of the indentation (.IN) point currently specified.
The appearance of the output is similar to that generated by the offset command, but undentation applies only to the
following line of output and is valid only if indentation is in effect.
The number of spaces to be "undented" cannot be greater than the currently specified indentation.
The following example illustrates the use of the undentation command.
.sp 3
	.IN 10
	.UN 6
	The first line of this paragraph begins four spaces
	from the normal left margin due to the specification
	of the undentation (.UN) command.  All subsequent
	lines are indented ten spaces from the left margin
	as specified by the indentation (.IN) command.
	.UN 10
	The undentation applies only to the next line of
	data output.  It must therefore be specified prior
	to every line to which it is to apply.
.sp 3
The above example prints as follows:
.sp 3
.lm 19
.ll 50
.in 10
.un 6
The~first line of this paragraph begins four spaces from the normal left margin due to the specification of the undentation
(.UN) command.
All subsequent lines are indented ten spaces from the left margin as specified by the indentation (.IN) command.
.un 10
The undentation applies only to the next line of data output.
It must therefore be specified prior to every line to which it is to apply.
.lm 12
.ll 60
.in 0
.pa
.tc
3.13	SUBSTITUTE SPACE CHARACTER
	--------------------------
.sp
.sc _
	The substitute space character (.SC) command can be used to change the default substitute space character ("~") to another character.
The substitute space character is useful for printing spaces in text data
without allowing a line break or additional space insertion to occur at that point.
The following example illustrates the use of this command, using the backslash ("\") character as the substitute space character.
.sp 3
	.SC \
	The substitute space character can be used to print
	text exactly as encountered without additional space
	insertion or line breaks occurring.  Such text as
	IBM\360/50 and "The\cow\jumped\over\the\moon" are
	printed exactly as specified; with the exception that
	the backslash characters are replaced with spaces in
	the output.  Without use of the substitute space
	character, it is probable that line breaks or space
	insertion will occur in the text; such as in the
	above IBM 360/50 or "The cow jumped over the moon".
.sp 3
The above example prints as follows:
.sp 3
.sc \
.in 7
The substitute space character can be used to print text exactly as encountered
without additional space insertion or line breaks occurring.
Such text as IBM\360/50 and "The\cow\jumped\over\the\moon" are printed exactly as specified;
with the exception that the backslash characters are replaced with spaces in the output.
Without use of the substitute space character, it is probable that line breaks or space insertion will occur in the
text; such as in the above IBM 360/50 or "The cow jumped over the moon".
.in 0
.sc ~
.pa
.tc
3.14	NO FORMATTING
	-------------
.sp
	This example illustrates the use of the no format (.NF) command.
Specification of this command inhibits both the concatenation and justification processes.
If an input line exceeds the currently specified line length (.LL),
the line is truncated and the first four bytes of the output text are replaced with "<<<<" to indicate that truncation has occurred.
The text line and a diagnostic message are printed on the console device.
.sp 3
	.LL 46
	.NF
	This is an example of a paragraph for which
	neither concatenation nor justification has been
	specified.  Any lines exceeding the currently
	specified line length are truncated, therefore
	the user must insure that line lengths are
	not exceeded.
.sp 3
The above example prints as follows:
.sp 3
	This is an example of a paragraph for which
	<<<<her concatenation nor justification has be
	specified.  Any lines exceeding the currently
	specified line length are truncated, therefore
	the user must insure that line lengths are
	not exceeded.
.pa
.tc
3.15	CONDITIONAL PAGING
	------------------
.sp
	The following examples illustrate the use of conditional paging.
Conditional paging is most commonly used to insure that drawings and figures are not split over pages
or that single lines of text are not isolated at the top or bottom of the page.
Since the .CP command does not cause a break, it may occur anywhere within the input, even in the middle of a sentence.
If the number of printable lines remaining on the current page is less than the number of lines
specified in the .CP command parameter, a page eject is performed prior to printing the output line currently being processed;
otherwise, processing continues as usual.
.sp 3
.nj
.co
.in 7
.ce
EXAMPLE 1
.sp
The specification of the .CP command preceding the following figure insures that the entire ten lines of the figure are contained on one page.
If there are fewer than ten lines remaining on the current page when the .CP command is encountered,
a page eject is performed immediately and the figure appears on the following page.
If there are ten or more lines remaining on the page, the figure appears on the current page.
.nf
.ig
.SP
.ig
.NF
.ig
.CP 10
************
* \      / *
*  \    /  *
*   \  /   *
*    \/    *
*    /\    *
*   /  \   *
*  /    \  *
* /      \ *
************
.pa
.co
.cp 4
.ce
EXAMPLE 2
.sp
.ig
.CO
.br
When concatenation or formatting is in effect, the input text line is not immediately written to the output;
instead it is placed in a buffer for possible concatenation with the next input line.
If a .CP command is encountered which causes a page eject,
the output line currently being processed is completed normally AFTER beginning the new page.
If multiple figures preceded by .CP commands are to be output while concatenation is in effect,
the subsequent .CP commands must be preceded by a break to insure that the last line of the preceding .CP data is output PRIOR to the eject.
If no break is encountered and an eject occurs, the last line of the figure will remain in the buffer and will appear on the next page.
Normally, concatenation is not specified when generating figures on the output;
the input is written to the output line-for-line without change.
.cp 9
The following example illustrates the specification of the break (.SP, .TB, .LL, .BR, .TM, etc.) prior to the .CP command:
.nc
.ig
.BR
.ig
.CP 4
<tab>******************
<tab>*                *
<tab>*                *
<tab>******************
.cp 8
.ig
.BR
.ig
.CP 5
<tab>_______
<tab>|  |  |
<tab>|  |  |
<tab>|  |  |
<tab>|__|__|
.pa
.ce
EXAMPLE 3
.sp
.co
.ig
.CP 2
.co
The .CP command preceding this paragraph insures that a page eject occurs if there are less than two printable lines remaining on the current page.
This may be used to prevent single lines from being "isolated" on a page due to page overflow ejects.
.br
.ig
.SP
.br
Since the .CP command does not cause a break, it does not have to be specified at the end of a sentence or paragraph.
If there are fewer lines remaining on the current page than the .CP command parameter specifies,
a page eject is performed prior to completing the current output line being processed.
The processing of concatentation, justification,
.br
.ig
.CP 2
.br
and any other commands currently in effect is not affected by the page eject; processing continues to be performed in the normal manner.
.br
.ig
.SP
.br
The .CP command is also very useful in insuring that a paragraph header is not separated from the body of the paragraph, as shown below.
.nc
.ig
.SP
.ig
.CP 5
PARAGRAPH HEADER
.ig
.BR
----------------
.ig
.SP
.co
The .CP preceding the paragraph header insures that the header and at least two lines of the paragraph body
are printed on the same page.
.fo
.in 0
.pa
.tc
3.16	TABLE OF CONTENTS
	-----------------
.sp
	The following example illustrates the generation of a Table of Contents for a document.
The table of contents entry (.TC) command is used to place the current page number into a table of page numbers
at appropriate locations throughout the document for subsequent use by the print table of contents (.PC) command.
.sp
.cp 2
	It should be noted that if page numbers are changed by the user by specification of .AN or .DD commands,
the change should be initiated immediately after the prior page eject.
The .TC command causes the CURRENT page number to be placed in the table;
if the current page number is changed after the .TC command is specified, the page number in the Table of Contents will reflect the
page number before the change rather than after.
For example, if the page number is changed in the middle of the page, all .TC commands encountered in the first half of the page will
relect the wrong page number.
Care should always be taken when explicitly changing page numbers rather than allowing TYPE to automatically control page
numbering.
.sp
.cp 2
	Following the .PC command, the user supplies text lines to be used as headers for the Table of Contents entries.
The user must insure that the number and sequence of the .TC commands match the number and sequence
of the headers following the .PC command.
.sp
.cp 2
	The .PC command causes an immediate page eject; therefore, the Table of Contents is printed on a separate page or pages.
Any desired headers or titles must be supplied by the user; none are generated by the .PC command.
.sp
.cp 2
	Preceding a text line by a center (.CE) or no table of contents page number (.NN) command
excludes its use as a Table of Contents header entry.
Such lines may be used to generate headers or titles within the Table of Contents.
.sp
.cp 2
	All formatting commands except justification (.JU), concatenation (.CO), and format (.FO)
can be specified within the Table of Contents generation;
for example, double spacing, blank line generation, tabbing, centering, indentation, line length, etc.
In addition, the page size, margins, headings, identifications, and type of paging to be used
may all be defined or redefined by the user.
If not redefined within the Table of Contents generation, default is to any prior specifications.
.sp
.cp 2
	In the following example, explicit page ejects (.PA) with parameters are used to illustrate clearly the current page numbers
at the time the .TC commands are specified.
Normally, page ejects are due to normal page overflow rather than to explicit page ejects.
.sp 3
.in 7
.nf
.ig
.TM 6
.ig
.BP
.ig
.HE TIME SHARING SYSTEM (TSS) USAGE
.tb 22,27,32,37
.ig
.TB 15,20,25,30
.ig
.TC
SECTION I.<tab>INITIATION OF BATCH JOBS IN TSS
.ig
.SP
.ig
.TC
.co
<tab>1.<tab>TSS JOBS REQUIRING TAPES.
All Time Sharing System (TSS) jobs requiring tapes will adhere to the following procedures:
.nc
.cp 4
     |
     |
    etc.
     |
.cp 4
.ig
.PA 2
.ig
.TC
.co
<tab>2.<tab>TSS JOBS REQUIRING REMOVABLE DISKS.
All TSS jobs requiring removable disks must be cleared with the Operations Department prior to entry into the system.
.nc
.cp 4
     |
     |
    etc.
     |
.cp 4
.ig
.PA 4
.ig
.TC
.co
<tab>3.<tab>TSS JOBS REQUIRING CARD PUNCHES.
All TSS jobs utilizing card punches at the central site for the punching of output
must contain JCL cards advising the operator of the card stock to be used.
.nc
.cp 4
     |
     |
    etc.
     |
.cp 4
.ig
.PA 6
.ig
.TC
.co
<tab>4.<tab>TSS JOBS REQUIRING CARD READERS.
Jobs requiring card readers will not be initiated from remote terminals; they will be submitted as
batch jobs, along with the accompanying card deck.
.nc
.cp 4
     |
     |
    etc.
     |
.cp 4
.ig
.PA 9
.ig
.TC
SECTION II.<tab>TSS DISK STORAGE ALLOCATION.
.ig
.SP
.ig
.TC
.co
<tab>1.<tab>ALLOCATED STORAGE AREAS.
All users will be allocated disk storage space under their individual USERID.
.nc
.cp 4
     |
     |
    etc.
     |
.cp 4
.ig
.PA 11
.ig
.TC
.co
<tab>2.<tab>THE INITIAL ASSIGNMENT OF ACCESS PERMISSIONS.
The initial storage space will be allocated with permissions granted only to the individual user.
.nc
.cp 4
     |
     |
    etc.
     |
.cp 4
.ig
.PA 12
.ig
.TC
.co
<tab>3.<tab>OTHER USER ACCESS.
Other authorized TSS users may be granted access to your individual USERID storage area only with your permission.
.nc
.cp 4
     |
     |
    etc.
     |
.ig
.TC
.co
<tab>4.<tab>BACKUP SAVES OF USER AREAS.
Saves of all user areas will be performed on a daily basis.
.nc
.cp 4
     |
     |
    etc.
     |
.cp 4
.ig
.PA 13
.ig
.TC
SECTION III.<tab>TSS SUBSYSTEM USAGE.
.ig
.SP
.ig
.TC
.co
<tab>1.<tab>ACCESS SUBSYSTEM USAGE.
A detailed description of the usage and features of the TSS ACCESS subsystem is provided in this section.
.nc
.cp 4
     |
     |
    etc.
     |
.cp 4
.ig
.PA 15
.cp 3
.ig
.TC
.co
<tab>2.<tab>BASIC SUBSYSTEM USAGE.
A detailed description of the usage and features of the TSS BASIC subsystem is provided in this section.
.nc
.cp 4
     |
     |
    etc.
     |
.cp 4
.ig
.PA 18
.ig
.TC
.co
<tab>3.<tab>CARDIN SUBSYSTEM USAGE.
A detailed description of the usage and features of the TSS CARDIN subsystem is provided in this section.
.nc
.cp 4
     |
     |
    etc.
     |
.cp 4
.ig
.PA 20
.ig
.TC
.co
<tab>4.<tab>EDIT SUBSYSTEM USAGE.
A detailed description of the usage and features of the TSS EDIT subsystem is provided in this section.
.nc
.cp 4
     |
     |
    etc.
     |
.cp 4
.ig
.PA 23
.ig
.TC
.co
<tab>5.<tab>FDUMP SUBSYSTEM USAGE.
A detailed description of the usage and features of the TSS FDUMP subsystem is provided in this section.
.nf
.cp 4
     |
     |
    etc.
     |
.pa
.ig
.CM PRINT THE TABLE OF CONTENTS
.ig
.PC
.ig
.TM 8
.ig
.HM 3
.ig
.LL 60
.ig
.LM 12
.ig
.BM 6
.ig
.TB 6,12
.tb 13,19
.ig
.AN i.1
.ig
.OP
.ig
.CE
_________________
.ig
.CE
TABLE OF CONTENTS
.ig
.SP 3
I.<tab>INITIATION OF BATCH JOBS IN TSS
<tab>1.<tab>Jobs Requiring Tapes
<tab>2.<tab>Jobs Requiring Removable Disks
<tab>3.<tab>Jobs Requiring Card Punches
<tab>4.<tab>Jobs Requiring Card Readers
.ig
.SP
II.<tab>TSS DISK STORAGE ALLOCATION
<tab>1.<tab>Allocated Storage Areas
.ig
.NN
<tab>2.<tab>The Initial Assignment of Access
<tab><tab>Permissions
<tab>3.<tab>Other User Access
<tab>4.<tab>Backup Saves of User Areas
.ig
.SP
III.<tab>TSS SUBSYSTEM USAGE
<tab>1.<tab>ACCESS Subsystem
<tab>2.<tab>BASIC Subsystem
<tab>3.<tab>CARDIN Subsystem
<tab>4.<tab>EDIT Subsystem
<tab>5.<tab>FDUMP Subsystem
.ig
.EN
.pa
.in 0
.fo
The following Table of Contents is generated for the preceding example:
.nf
.in 7
.sp 3
.op
.ce 35
_________________
.ce 35
TABLE OF CONTENTS
.sp 3
.ll 65
I.	INITIATION OF BATCH JOBS IN TSS  . . . . . . . 1
	1.	Jobs Requiring Tapes . . . . . . . . . . 1
	2.	Jobs Requiring Removable Disks . . . . . 2
	3.	Jobs Requiring Card Punches  . . . . . . 4
	4.	Jobs Requiring Card Readers  . . . . . . 6
.sp
II.	TSS DISK STORAGE ALLOCATION  . . . . . . . . . 9
	1.	Allocated Storage Areas  . . . . . . . . 9
	2.	The Initial Assignment of Access
		Permissions  . . . . . . . . . . . . . . 11
	3.	Other User Access  . . . . . . . . . . . 12
	4.	Backup Saves of User Areas . . . . . . . 12
.sp
III.	TSS SUBSYSTEM USAGE  . . . . . . . . . . . . . 13
	1.	ACCESS Subsystem . . . . . . . . . . . . 13
	2.	BASIC Subsystem  . . . . . . . . . . . . 15
	3.	CARDIN Subsystem . . . . . . . . . . . . 18
	4.	EDIT Subsystem . . . . . . . . . . . . . 20
	5.	FDUMP Subsystem  . . . . . . . . . . . . 23
.in 0
.ll 60
.pa
.fo
.tb 8,13,30
.tc
3.17	SWITCHING PAGE NUMBERING FROM TOP TO BOTTOM
	-------------------------------------------
.sp
	The following example illustrates the commands required to switch the page numbering from top paging to bottom paging within the
same document.
Care must be exercised in switching from top to bottom, or from bottom to top, to prevent multiple page numbers
on the same page or no page numbers on the page.
.sp 2
.of 11
	.CM~The following specifies top of page numbering, with the first page numbered "1"
.br
	.TP
	  |
	  |
	 text
	  |
	  |
	.CM~The following ejects and numbers the new page at the top as "2"
.br
	.PA
	.CM~The following insures that the next page is NOT numbered at the top after the next page eject
.br
	.NP
	  |
	  |
	 text
	  |
	  |
	.CM~The following causes a page eject, but the number is not printed at the top of the page due to the .NP command
.br
	.PA
	.CM~The following causes the third page to be numbered at the bottom as page number "3"
.br
	.BP
	  |
	  |
	 etc.
.of
.sp 3
	Obviously, switching from top paging to bottom paging or from bottom paging to top paging can be very confusing;
and it is not a recommended procedure.
If such a situation is desired, it may be more productive to create two separate input document files rather than one.
Each can then be numbered in the desired mode very simply.
.pa
.tc
3.18	FORMATTING AND JUSTIFICATION
	----------------------------
.sp
	When formatting and/or justification is in effect, spaces are inserted in the output line
to produce an even right margin.
Spaces may be inserted anywhere there is already a space in the input line.
This may be a problem when a specific number of spaces is desired at certain points and no additional
spaces should be added; such as between the number and the first data character of numbered paragraphs.
Additional space insertion may be prevented by using tabs (.TB) or substitute space characters (.SC) rather than actual spaces in the input line.
Tabs and substitute space characters are not treated as spaces; therefore, no additional space insertion occurs at those points during
justification.
The easiest and most clearly understood method is the use of tabs.
The first example illustrates the use of tabs, while the second illustrates the use of the substitute space character.
Both examples accomplish exactly the same purpose.
.nf
.sp 3
.in 7
.ce
EXAMPLE 1
.sp
.ig
.TB 6
.br
.co
1.<tab>AMPLIFICATION.
Increase in the magnitude of a transmission signal from one point to another.
.br
.ig
.SP
.br
2.<tab>ANALOG.
The representation of one or more characteristics by means of physical variables which obey a similar
mathematical relationship; e.g., rotation, voltage, resistance, time.
.br
.ig
.SP
.br
3.<tab>ASYNCHRONOUS.
Descriptive of the transmission method, or the terminal equipment employed, which requires that requisite timing information be
included in each transmitted character.
.br
.ig
.SP
.br
4.<tab>ATTENUATION.
Loss of electrical energy (power) due to resistance inherent in the transmission facility.
.sp 3
.cp 5
.ce
EXAMPLE 2
.sp
.sc \
8.~~~AUTOMATIC CALLING UNIT.
A unit which will generate dial pulses (or tones) to a telephone network in response
to signals from a computer or business machine.
.br
.ig
.SP
.br
9.~~~AUTOMATIC ERROR CORRECTION.
A technique requiring the use of special codes and/or automatic retransmission which
detects and corrects errors occurring in transmission.
.br
.ig
.SP
.br
10.~~AUTOMATIC SEND/RECEIVE.
A teleprinter unit with keyboard, printer, paper tape reader, and paper tape punch,
which allows tape to be produced and edited off line for automatic transmission.
.br
.ig
.SP
.br
11.~~BINARY.
A term used to describe a "binary code" meaning that each code or bit has two possible states.
For example, a "marking" or "spacing," sometimes referred to as "yes" or "no."
.sc ~
.sp 3
.fo
.cp 8
.un 7
The preceding examples print as follows:
.sp 3
.cp 5
.ce
EXAMPLE 1
.sp
1.	AMPLIFICATION.
Increase in the magnitude of a transmission signal from one point to another.
.sp
2.	ANALOG.
The representation of one or more characteristics by means of physical variables which obey a similar
mathematical relationship; e.g., rotation, voltage, resistance, time.
.sp
3.	ASYNCHRONOUS.
Descriptive of the transmission method, or the terminal equipment employed, which requires that requisite timing
information be included in each transmitted character.
.sp
4.	ATTENUATION.
Loss of electrical energy (power) due to resistance inherent in the transmission facility.
.sp 3
.cp 4
.ce
EXAMPLE 2
.sp
8.~~~AUTOMATIC CALLING UNIT.
A unit which will generate dial pulses (or tones) to a telephone network in response to signals from a computer
or business machine.
.sp
9.~~~AUTOMATIC ERROR CORRECTION.
A technique requiring the use of special codes and/or automatic retransmission which detects and corrects errors occurring in
transmission.
.sp
10.~~AUTOMATIC SEND/RECEIVE.
A teleprinter unit with keyboard, printer, paper tape reader, and paper tape punch, which allows tape to be
produced and edited off line for automatic transmission.
.sp
11.~~BINARY.
A term used to describe a "binary code" meaning that each code or bit has two possible states.
For example, a "marking" or "spacing," sometimes referred to as "yes" or "no."
.tb 8,30
.in 0
.pa
.tc
3.19	FIRST-LINE PARAGRAPH OFFSETTING
	-------------------------------
.sp
	The following examples illustrate two methods available to offset all but the first line of a paragraph.
The method used depends upon individual user preference, format specifications in effect, etc.
The first example illustrates the use of the offset (.OF) command to offset all but the first line of a group of paragraphs.
The offset need be specified only once; it remains in effect until cancelled by a null or zero offset.
The second example illustrates the use of the undent (.UN) command in conjunction with indentation (.IN) to accomplish a similar output
format.
The undent must be specified preceding every line to which it is to apply, but the indentation need be
specified only once.
.in 7
.sp 3
.ce
EXAMPLE 1
.sp
.nj
.ig
.TB 6
.br
.ig
.OF 5
.br
1.<tab>CIRCUIT SPEED.
The number of information pulses which can be effectively propogated in a given period of time
(technically expressed in bits per second).
Also called "line speed" or "data rate."
.br
.ig
.SP
.br
2.<tab>COMMON CARRIER.
A company recognized by the Federal Communications Commission or appropriate state agency as having a vested or rightful
interest in furnishing communication services to the public.
.br
.ig
.SP
.br
3.<tab>CROSSTALK.
Interference created by the inductive effect of one transmission facility upon another, when they lie in a parallel path.
The degree of crosstalk is a function of facility length, strength of transmitted current, and signaling frequency, and may vary
from weak background noise to total interference.
.br
.ig
.OF
.pa
.fo
.ce
EXAMPLE 2
.sp
.nj
.ig
.TB 6
.br
.ig
.IN 5
.br
.ig
.UN 5
.br
23.<tab>PRIVATE LINE.
A communication circuit (telegraph or voice-grade) between two points which is reserved for the use of the subscriber.
.br
.ig
.SP
.br
.ig
.UN 5
.br
24.<tab>PULSE DURATION (PULSE LENGTH).
The duration of a pulse is the time interval between the points on the leading and trailing edges
at which the instantaneous value bears a specified relation to the pulse amplitude.
.br
.ig
.SP
.br
.ig
.UN 5
.br
25.<tab>PULSE MODULATION.
Modulation of a continuous-wave carrier by a pulse train.
Modulation of one or more characteristics of a pulse carrier.
.sp 3
.un 7
The preceding examples print as follows:
.sp 3
.fo
.of 5
.tb 13
.ce
EXAMPLE 1
.sp
1.	CIRCUIT SPEED.
The number of information pulses which can be effectively propogated in a given period of time (technically expressed
in bits per second).
Also called "line speed" or "data rate."
.sp
2.	COMMON CARRIER.
A company recognized by the Federal Communications Commission or appropriate state agency as having a vested or rightful
interest in furnishing communication services to the public.
.sp
3.	CROSSTALK.
Interference created by the inductive effect of one transmission facility upon another, when they lie in a parallel path.
The degree of crosstalk is a function of facility length, strength of transmitted current,
and signaling frequency, and may vary from weak background noise to total interference.
.of
.sp 3
.cp 4
.ce
EXAMPLE 2
.sp
.in 12
.un 5
23.	PRIVATE LINE.
A communication circuit (telegraph or voice-grade) between two points which is reserved for the use of the subscriber.
.sp
.un 5
24.	PULSE DURATION (PULSE LENGTH).
The duration of a pulse is the time interval between the points on the leading and trailing edges at which the instantaneous value
bears a specified relation to the pulse amplitude.
.sp
.un 5
25.	PULSE MODULATION.
Modulation of a continuous-wave carrier by a pulse train.
Modulation of one or more characteristics of a pulse carrier.
.in 0
.pa
.tb 8,13,30
.tc
3.20	GENERATING TITLE AND COVER PAGES
	--------------------------------
.sp
	The following example shows a method for generating a title or cover page, such as was done for the cover page of this manual.
The number of lines on a page (.PL), the top margin (.TM), and the bottom margin (.BM) must all be considered when attempting
to place text data at specific locations on a page.
This example illustrates the commands required to generate a cover page,
with a copyright indication on the last printable text line.
.sp 2
	.LM 0
	.LL 85
	.BM 8
	.NP
	.FS 13
	.CE
	USE OF THE TIME SHARING SYSTEM
	.SP
	.CE
	ON THE HONEYWELL H6060 COMPUTER
	.SP 10
	.CE
	12 AUGUST 1980
	.SP 10
	.CE
	Anreico Design Labs, Inc.
	.CE
	83290 El Sohio Place, Suite 103
	.CE
	Los Angeles, CA 90008
	.FS 11
	.CE
	Copyright (C) 1980 Anreico Design Labs, Inc.
	.PA
.sp 2
.cp 2
	Note the use of the forced space line (.FS) command, rather than the space line (.SP) or blank line (.BL) command.
It is recommended that the .FS command always be used when attempting to place lines of data at or near the bottom of the page;
such as subtitles for figures or drawings.
Both the .SP and .BL commands start a new page if less than two lines remain on the current page after the specified number of lines are generated.
In addition, the .FS is required to force blank lines at the top of a page prior to the occurrence of text data.
.pa
.tc
3.21	OVERPRINTING
	------------
.sp
	The overprint (.OP) command may be used to underline headers and titles, double print for emphasis,
and create special figures by overprinting selected characters.
The overprinting affects the next two output text lines following specification of the overprint command.
The normal vertical spacing between the two lines is suppressed; therefore, both lines are printed on the same physical line.
It is the user's responsibility to insure that the overprint lines are aligned in the desired manner.
Since both concatenation and justification may affect the placement of characters on a line,
their use should not be attempted for overprint lines.
The following example illustrates the use of the overprint command.
.sp 3
.nj
.in 7
.tb 22,37,52
.ig
.TB 15,30,45
.br
The overprint command may be used to underline headers and titles; such as column headers, paragraph headers, etc.
If the output may be directed to a video device as well as to a printer, it is recommended that the underline be specified prior to the text line.
On video devices, only the last line output is visible;
therefore, if the text line is specified first, only the underline will be visible after printing.
All commands are functional within operation of the overprint command; including tabbing, indentation, and centering.
The following command sequence underlines title and column headings using the overprint command.
.nc
.ig
.SP
.ig
.OP
.ig
.CE
______________
.ig
.CE
CENTERED TITLE
.ig
.SP
.ig
.OP
____<tab>____<tab>____<tab>____
.ig
.BR
COL1<tab>COL2<tab>COL3<tab>COL4
.ig
.SP
.co
.pa
The overprint command may also be used to double print a header or title for added emphasis.
The two lines following the overprint command specification would normally be identical;
however, if only part of the line is to be double printed, only that part need be respecified.
For example, the following command sequence double prints only the "DOUBLE PRINTED" portion of the line:
.nf
.ig
.SP
.ig
.OP
                   DOUBLE PRINTED
.ig
.BR
THIS LINE HAS BEEN DOUBLE PRINTED BY THE .OP COMMAND
.ig
.SP
.co
This command may also be used to generate special figures or characters by overprinting selected characters, as in the following examples:
.nf
.ig
.SP
.ig
.OP
_     O    0    >    /    \    O    O    0    |    "
.ig
.BR
//    |    /    <    _    _    +    -    |    _    -
.fo
.sp 3
.un 7
The preceding example prints as follows:
.sp 3
The overprint command may be used to underline headers and titles; such as column headers, paragraph headers, etc.
If the output may be directed to a video device as well as to a printer, it is recommended
that the underline be specified prior to the text line.
On video devices, only the last line output is visible; therefore, if the text line is specified first,
only the underline will be visible after printing.
All commands are functional within operation of the overprint command; including tabbing, indentation, and centering.
The following command sequence underlines title and column headings using the overprint command.
.sp
.op
.ce
______________
.ce
CENTERED TITLE
.sp
.op
____	____	____	____
.br
COL1	COL2	COL3	COL4
.sp
The overprint command may also be used to double print a header or title for added emphasis.
The two lines following the overprint command specification would normally be identical;
however, if only part of the line is to be double printed, only that part need be respecified.
For example, the following command sequence double prints only the "DOUBLE PRINTED" portion of the line:
.sp
.op
                   DOUBLE PRINTED
.br
THIS LINE HAS BEEN DOUBLE PRINTED BY THE .OP COMMAND
.sp
This command may also be used to generate special figures or characters by overprinting selected characters, as in the
following examples:
.sp
.op
_     O    0    >    /    \    O    O    0    |    "
.br
//    |    /    <    _    _    +    -    |    _    -
.in
.tb 8,13,30
.pa
.cm APPENDIX A
.lm 9
.ll 70
.sh APPENDIX A: COMMAND SUMMARY
.tm 7
.bm 5
.in 0
.an
.tb 17,52,62
.nf
.tc
.ce
COMMAND SUMMARY
.ce
---------------
.sp
SPECIFICATION	COMMAND	DEFAULT	BREAK
.sp
.ig
.AN x.n	ALPHANUMERIC PAGING	x+1.1	NO
.ig
.AP	ALTERNATE PAGING		NO
.ig
.BK	BREAK ON TAB/SPACE	YES	NO
.ig
.BL n	BLANK LINE	1	YES
.ig
.BM n	SET BOTTOM MARGIN	6	YES
.ig
.BP n	BOTTOM PAGING	2	NO
.ig
.BR	BREAK		YES
.ig
.CE n	CENTER LINE	LL/2	YES
.ig
.CM	COMMENT		NO
.ig
.CO	CONCATENATION	YES	YES
.ig
.CP n	CONDITIONAL PAGE		NO
.ig
.DD n.m	DEWEY DECIMAL PAGING	n+1.1	NO
.ig
.DS	DOUBLE SPACING		YES
.ig
.EN	END OF TEXT FILE		YES
.ig
.FO	FORMAT	YES	YES
.ig
.FS	FORCED SPACE LINE	1	YES
.ig
.HE x	HEADING LINE	blank	NO
.ig
.HM n	SET HEADING MARGIN	2	YES
.ig
.IB	IGNORE NEXT TAB/SPACE BREAK		NO
.ig
.IG	IGNORE COMMAND RECORD		NO
.ig
.IL x	IDENTIFICATION LEFT	none	NO
.ig
.IN n	INDENTATION	0	YES
.ig
.IR x	IDENTIFICATION RIGHT	none	NO
.ig
.JU	JUSTIFICATION	YES	YES
.ig
.LL n	SET LINE LENGTH	65	YES
.ig
.LM n	SET LEFT MARGIN	10	YES
.ig
.ME	MERGE		NO
.ig
.NB	NO TAB/SPACE BREAK		NO
.ig
.NC	NO CONCATENATION		YES
.ig
.NF	NO FORMAT		YES
.ig
.NJ	NO JUSTIFICATION		YES
.ig
.NN	NO TABLE OF CONTENTS PAGE NUMBER		YES
.ig
.NP	NO PAGE NUMBERING		NO
.ig
.OF n	OFFSET	0	YES
.ig
.OP	OVERPRINT		YES
.ig
.PA n	PAGE EJECT	+1	YES
.ig
.PC	PRINT TABLE OF CONTENTS		YES
.ig
.PL n	SET PAGE LENGTH	66	YES
.ig
.PW n	SET PAGE WIDTH	85	YES
.sc _
.ig
.SC x	SUBSTITUTE SPACE CHARACTER	~	YES
.sc ~
.ig
.SH x	SUBHEADING LINE	blank	NO
.ig
.SP n	SPACE LINE	1	YES
.ig
.SS	SINGLE SPACING	YES	YES
.ig
.TB n1,n2,...	SET TABS	5,10,...	YES
.ig
.TC	TABLE OF CONTENTS ENTRY		NO
.ig
.TP	TOP PAGING		NO
.ig
.TM n	SET TOP MARGIN	6	YES
.ig
.UN n	UNDENTATION		YES
.pa
.sh APPENDIX B: FORM LAYOUT
.lm 12
.ll 65
.tm 8
.an
.tc
.ce
FORM LAYOUT SPECIFICATIONS
.ce
--------------------------
.sp
.tb 7,13,47,52,57,61
	<=LM=><===============LL================>
.sp
	______________________________________________ <_______
	|			|	|	|
	|			|	|	|
	|	Heading Line		|	|	|
 ___>	|	Subheading Line		|	TM	|
 |	|			|	|	|
HM	|			|	|	|
 |__>	|	___________________________________	| <__|	|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		PL
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
	|	|	|	|		|
 --->	|	-----------------------------------	|		|
 |	|			|		|
 |	|			|		|
BM	|			|		|
 |	|			|		|
 |__>	|____________________________________________| <______|
.sp
	<=====================PW=====================>
.sp 2
		BM = bottom margin .BM (default 6)
		HM = heading margin .HM (default 2)
		LL = line length .LL (default 65)
		LM = left margin .LM (default 10)
		PL = page length .PL (default 66)
		PW = page width .PW (default 85)
		TM = top margin .TM (default 6)
.pa
.sh APPENDIX C: DIAGNOSTIC MESSAGES
.bm 8
.ll 60
.an
.tb 8,13,18
.fo
.tc
.ce
DIAGNOSTIC ERROR MESSAGES
.ce
-------------------------
.sp
	All diagnostic error messages generated by TYPE are directed to the console device.
Each is preceded by the legend "**ERROR:", and causes the bell or buzzer on the terminal to ring.
Most of the following errors do not cause execution termination; the erroneous command or data is simply flagged as an error and ignored.
If an error occurs during entry of the initial file specification line, the specification is requested again.
The following illustrates the diagnostic error format:
.sp
.ce
**ERROR: <.FG> INVALID
.sp
	The following diagnostics, in the format indicated above, may be encountered during TYPE execution.
They are listed in alphabetical order for ease of use.
.sp 3
.in 7
.cp 4
.un 7
nnn BYTE BUFFER INSUFFICIENT
.sp
The operating system buffer size (nnn) is insufficient for operation of TYPE.
Execution has been aborted.
.sp 2
.cp 4
.un 7
FILE2 EOF; <command> INVALID
.sp
The second merge file is already at end of file (EOF), therefore the merge command cannot be processed and is ignored.
.sp 2
.cp 4
.un 7
HEADING TRUNCATED; <command> INVALID
.sp
The heading or subheading exceeds the maximum permissible length.
The command is processed, but the heading is truncated to the maximum allowable size.
.sp 2
.cp 4
.un 7
ID TRUNCATED; <command> INVALID
.sp
The specified right or left identification exceeds the maximum permissible length.
The command is processed, but the identification is truncated to the maximum allowable size.
.sp 2
.cp 4
.un 7
NO FILE2; <command> INVALID
.sp
No second merge file was specified as input, therefore the merge command cannot be processed.
The legend "<MERGE>" is inserted into the output in place of the data from the second file.
.sp 2
.cp 4
.un 7
NO TOC PAGE FOR <data>
.sp
All page numbers previously inserted in the page number table by specification of .TC commands have been utilized;
therefore, no page number is available to be printed for this Table of Contents (TOC) header entry.
This and all subsequent entries are formatted in the normal manner, but the page numbers are left blank.
.sp 2
.cp 4
.un 7
NOT WITHIN TOC; <command> INVALID
.sp
The specified command has validity only within the generation of the Table of Contents (TOC) by the .PC command.
The command is ignored.
.sp 2
.cp 4
.un 7
TOC TABLE EMPTY; <command> INVALID
.sp
No entries have been placed in the Table of Contents (TOC) table by specification of .TC commands;
therefore, there are no page numbers to be printed with the Table of Contents header entries.
The entries are formatted in the normal manner, but the page numbers are left blank.
.sp 2
.cp 4
.un 7
TOC TABLE MISMATCH
.sp
All of the page numbers inserted into the page number table by specification of the .TC commands were not
utilized in the Table of Contents (TOC) generation.
This is a warning diagnostic only; its purpose is to advise of a probable mismatch in the Table of Contents.
.sp 2
.cp 4
.un 7
TOC TABLE OVERFLOW; <command> INVALID
.sp
The page number table for the Table of Contents (TOC) generation has been completely filled.
There is no space available for insertion of the current page number.
The command is ignored.
.sp 2
.cp 6
.un 7
WITHIN TOC; <command> INVALID
.sp
The specified command is not valid within the generation of the Table of Contents (TOC) by the .PC command.
The command is ignored.
.sp 2
.cp 4
.un 7
<command> INVALID
.sp
An invalid command, command format, or parameter has been specified.
The command is ignored.
.sp 2
.cp 4
.un 7
<data> TRUNCATED
.sp
The current data line exceeds the maximum line length specified and has been truncated to the maximum line length.
The legend "<<<<" replaces the first four characters of text data in the output line to indicate that truncation has occurred.
.sp 2
.cp 4
.un 7
<filespec> filetype ERROR - errortype
.sp
The file specification is invalid or an error occurred while attempting to access the file or device.
The asterisk prompt is redisplayed, and the specification must be re-entered.
Refer to Section 1.2 for valid file specification formats.
The file on which the error occurred ("filetype") is indicated as follows:
.sp
	INPUT1 = first input file
	INPUT2 = second input file
	OUTPUT = output file
.sp
The type of error ("errortype") that occurred is indicated as follows:
.sp
.of 10
.cp 2
	DEVICE NOT READY -
		device is busy or not ready
.br
.cp 2
	DEVICE WRITE PROTECTED -
		device is protected or read only is selected
.br
.cp 3
	EOF ON DEVICE -
		not enough room on the specified device for the output file; i.e., disk full
.br
.cp 3
	FILE NOT FOUND -
		the file was not found on the specified device
.br
.cp 4
	ILLEGAL FILE SPEC -
		the specified filename is too long, an invalid device is specified, illegal characters occurred in the filename, etc.
.br
.cp 5
	ILLEGAL I/O OPERATION -
		attempting to read an output only device, attempting to write to an input only device,
specifying an output filename for a non-file structured device, etc. 
.of
.sp
If "errortype" indicates a number rather than a message, the error is dependent upon the operating system;
refer to the operating system error codes to determine the cause of the error.
.sp 2
.cp 5
.un 7
<switch> INVALID SWITCH
.sp
An invalid switch was specified in the input file specification line.
The asterisk prompt is redisplayed and the specification must be re-entered.
.sp 2
.cp 5
.un 7
<record> SIZE > nnn
.sp
The input text record size exceeded the maximum allowable number of characters without specification of a carriage return.
The maximum number of characters ("nnn") is dependent upon the operating system buffer size, with an absolute maximum of 255.
Output results for the current and following record may be invalid.
.in 0
.pa
.cm TABLE OF CONTENTS
.pc
.lm 12
.sh
.tm 7
.hm 2
.bm 7
.ll 60
.an i.1
.tb 6,12
.ce
TABLE OF CONTENTS
.ce
-----------------
.fs 2
1.	GENERAL DESCRIPTION
.fs
	1.1	Introduction
	1.2	Operational Characteristics
	1.3	Definitions
	1.4	Rules and Restrictions
	1.5	Special Features
.fs
2.	DETAILED DESCRIPTION OF COMMANDS
.fs
	2.1	.AN Alphanumeric Paging Command
	2.2	.AP Alternate Paging Command
	2.3	.BK Break on TAB/Space Command
	2.4	.BL Blank Line Command
	2.5	.BM Set Bottom Margin Command
	2.6	.BP Bottom Paging Command
	2.7	.BR Break Command
	2.8	.CE Center Line Command
	2.9	.CM Comment Command
	2.10	.CO Concatenation Command
	2.11	.CP Conditional Page Command
	2.12	.DD Dewey Decimal Paging Command
	2.13	.DS Double Spacing Command
	2.14	.EN End of Text File Command
	2.15	.FO Format Command
	2.16	.FS Forced Space Line Command
	2.17	.HE Heading Line Command
	2.18	.HM Set Heading Margin Command
.nn
	2.19	.IB Ignore Next TAB/Space Break
		 Command
	2.20	.IG Ignore Command Record Command
	2.21	.IL Identification Left Command
	2.22	.IN Indentation Command
	2.23	.IR Identification Right Command
	2.24	.JU Justification Command
	2.25	.LL Set Line Length Command
	2.26	.LM Set Left Margin Command
	2.27	.ME Merge Command
	2.28	.NB No TAB/Space Break Command
	2.29	.NC No Concatenation Command
	2.30	.NF No Format Command
	2.31	.NJ No Justification Command
.nn
	2.32	.NN No Table of Contents Page Number
		 Command
	2.33	.NP No Page Numbering Command
	2.34	.OF Offset Command
	2.35	.OP Overprint Command
	2.36	.PA Page Eject Command
	2.37	.PC Print Table of Contents Command
	2.38	.PL Set Page Length Command
	2.39	.PW Set Page Width Command
	2.40	.SC Substitute Space Character Command
	2.41	.SH Subheading Line Command
	2.42	.SP Space Line Command
	2.43	.SS Single Spacing Command
	2.44	.TB Set Tabs Command
	2.45	.TC Table of Contents Entry Command
	2.46	.TM Set Top Margin Command
	2.47	.TP Top Paging Command
	2.48	.UN Undentation Command
.fs
3.	USAGE EXAMPLES
.fs
	3.1	Defaults
	3.2	Standard Business Letter
	3.3	General Example
	3.4	Letter and Address File Merge
	3.5	Dewey Decimal Page Numbering
	3.6	Alphanumeric Page Numbering
.nn
	3.7	Changing the Header, Subheader, and
		Identification
	3.8	Suppressing Headers on the First Page
.nn
	3.9	Suppressing Page Numbers on the
		First Page
	3.10	Indentation
	3.11	Offsetting
	3.12	Undentation
	3.13	Substitute Space Character
	3.14	No Formatting
	3.15	Conditional Paging
	3.16	Table of Contents
.nn
	3.17	Switching Page Numbering from Top to
		Bottom
	3.18	Formatting and Justification
	3.19	First-Line Paragraph Offsetting
	3.20	Generating Title and Cover Pages
	3.21	Overprinting
.fs 3
.ce
APPENDICES
.fs
A.	COMMAND SUMMARY
.fs
B.	FORM LAYOUT SPECIFICATIONS
.fs
C.	DIAGNOSTIC ERROR MESSAGES
.en
