! PROGRAM TO GENERATE OPCODE TABLES FOR 6805 DOCUMENTATION

   DIM OPCODE$[20]
   DIM OPTYPE$[20]
   DIM COMMENT$[30]
   DIM LINE$[80]
   DIM I,J,K
   DIM IDX0 /12/
   DIM IDX1 /14/
   DIM IDX2 /16/
   DIM EXT  /18/
   DIM DIR  /20/
   DIM IMM  /22/
   DIM INH  /24/
   DIM BRA  /26/
   DIM BIT  /28/
   DIM OPCODECLASS /32/
   DIM NOTES /43/
   DIM LINECOUNT /0/
   DIM MAXPERPAGE /43/  \!51-8
   DIM OPVALUE, BITNO

SUBROUTINE OPSETUP
   LEN(LINE$) = 80
   FOR I = 1 TO 80
     LINE$[I,1] = " "
   NEXT I
   LINE$[1,LEN(OPCODE$)] = OPCODE$
   LINE$[OPCODECLASS,4] = "6805"
   RETURN SUBROUTINE
END


SUBROUTINE DIRECT
   LINE$[DIR,1] = "X"
   RETURN SUBROUTINE
END

SUBROUTINE INDEX0
   LINE$[IDX0,1] = "X"
   RETURN SUBROUTINE
END

SUBROUTINE INDEX1
   LINE$[IDX1,1] = "X"
   RETURN SUBROUTINE
END

SUBROUTINE INDEX2
   LINE$[IDX2,1] = "X"
   RETURN SUBROUTINE
END


SUBROUTINE IMMEDIATE
   IF OPCODE$ = "STA" OR ...
&     OPCODE$ = "JMP" OR ...
&     OPCODE$ = "JSR" OR ...
&     OPCODE$ = "STX"  THEN RETURN SUBROUTINE
   LINE$[IMM,1] = "X"
   RETURN SUBROUTINE
END

SUBROUTINE EXTENDED
   LINE$[EXT,1] = "X"
   RETURN SUBROUTINE
END

SUBROUTINE NILTYPE
   CALL OPSETUP
   LINE$[INH,1] = "X"
   RETURN SUBROUTINE
END

SUBROUTINE MONADIC
   CALL OPSETUP
   CALL DIRECT
   CALL INDEX0
   CALL INDEX1
   RETURN SUBROUTINE
END

SUBROUTINE DYDATIC
   CALL MONADIC
   CALL INDEX2
   CALL IMMEDIATE
   CALL EXTENDED
   RETURN SUBROUTINE
END

SUBROUTINE BRANCH
   CALL OPSETUP
   LINE$[BRA,1] = "X"
   RETURN SUBROUTINE
END

SUBROUTINE BITOP
   LINE$[BIT,1] = "X"
   RETURN SUBROUTINE
   END

SUBROUTINE BITBRANCH
   CALL BRANCH
   CALL BITOP
   LINE$[NOTES,80-NOTES] = "See note 1"
   RETURN SUBROUTINE
END

SUBROUTINE BITSETCLR
   CALL OPSETUP
   CALL BITOP
   RETURN SUBROUTINE
END

SUBROUTINE JUMPMACRO
   CALL OPSETUP
   LINE$[NOTES,80-NOTES] = "Jump macro"
   LINE$[OPCODECLASS,4] = "JMAC"
   CALL INDEX0
   CALL INDEX1
   CALL INDEX2
   CALL EXTENDED
   CALL DIRECT
   RETURN SUBROUTINE
END

SUBROUTINE BBMACRO
   CALL JUMPMACRO
   CALL BITOP
   LINE$[NOTES,80-NOTES] = "Jump macro, see note 2"
   RETURN SUBROUTINE
END

SUBROUTINE NEWPAGE
   PRINT #2,".ll 65"
   PRINT #2,".pw 85"
   PRINT #2,".PA"
   PRINT #2,".pw 120"
   PRINT #2,".ll 100"
   PRINT #2,".im 51"
   PRINT #2,"                              OPCODE"
   PRINT #2,"OPCODE     OPERAND MODES*     CLASS          NOTES AND COMMENTS"
   PRINT #2,""
   PRINT #2,"           I I I E D I I B B"
   PRINT #2,"           D D D X I M N R I"
   PRINT #2,"           X X X T R M H A T"
   PRINT #2,"           0 1 2"
   PRINT #2,""
!            12345678901234567890123456789012345678901234567890
   RETURN SUBROUTINE
END

!*** START OF MAIN PROGRAM
   IF ERROR WHEN OPEN #1,"ASM.05.TEST.DAT" THEN
               PRINT "INPUT OPEN ERROR = ";ERR
     FI
   IF ERROR WHEN CREATE #2,"ASM.05.TABL.TYP" THEN
               PRINT "CREATE OUTPUT ERROR =";ERR
     FI

SCANFILE: ...
&  REPEAT

       INPUT #1,OPCODE$
       IF EOF(1) THEN EXIT SCANFILE
       INPUT #1,OPTYPE$
       INPUT #1,OPVALUE
       INPUT #1,COMMENT$
       IF OPTYPE$ = "NIL"      THEN CALL NILTYPE
       IF OPTYPE$ = "MON"      THEN CALL MONADIC
       IF OPTYPE$ = "DYD"      THEN CALL DYDATIC
       IF OPTYPE$ = "SBR"      THEN CALL BRANCH
       IF OPTYPE$ = "BB"       THEN CALL BITBRANCH
       IF OPTYPE$ = "JMAC"     THEN CALL JUMPMACRO
       IF OPTYPE$ = "BB!JMAC"  THEN CALL BBMACRO
       IF OPTYPE$ = "BSC"      THEN CALL BITSETCLR
       IF LINECOUNT >= MAXPERPAGE THEN LET LINECOUNT = 0
       IF LINECOUNT = 0 THEN CALL NEWPAGE
       LINECOUNT = LINECOUNT + 1
       IF (LEN(COMMENT$) > 1) THEN LINE$[NOTES,80-NOTES] = COMMENT$
       FOR I = 80 TO 1 STEP -1 UNTIL LINE$[I,1] <> " "
       NEXT I
       LEN(LINE$) = I
       PRINT LINE$
       PRINT #2,LINE$
   END
   PRINT #2,""
   PRINT #2,""
   PRINT #2,'Note 1: Bit test branches (BRxxx) take "<bit>,<byte>,<dest>"'
   PRINT #2,'        where <dest> is a legal BRA operand.'
   PRINT #2,""
   PRINT #2,'Note 2: Bit test jump macros take the "<bit>,<byte>,<dest>"'
   PRINT #2,'        like the BRxxx instructions but <dest> may be any'
   PRINT #2,'        legal JMP operand including all 3 indexing modes.'
   CLOSE #1,#2
   EXIT
END
