.sh SECTION ???: 6805 MACHINE INSTRUCTION LINES
.pa
.tc
.ce
6805 MACHINE INSTRUCTION LINES
.ix Machine Instruction Line, 6805
.sp
The major function of an assembler is the translation of symbolically
specified machine instructions into a form directly understandable by the
target computer.  This section presumes knowledge of the 6805 instruction
set, which can be found in the Motorola MC6805 Programming Manual.  ASM is
fully compatible with the Motorola 6805 standard assembler syntax, with
several useful extensions.
.sp
.in 2
.un 2
--All M6805 Opcodes are accepted and generate equivalent 6805 code.
.sp
.un 2
--Automatic branch extension.  Branches that are out-of-range will be
assembled as branch/jump macros if the destination expression contains no
forward references.  This feature may be turned off with the appropriate
WITH option.
.sp
.un 2
--Special jump macros that parallel all branch instructions available on the
6805.  These jump macros allow the full range of addressing modes available
for the JMP instruction thus giving the effect of having conditional jump
instructions.
.sp
.un 2
--Special offset prefixes "<" and ">" that will force 8-bit or 16-bit
indexing offsets respectively.
.sp
.un 2
--Special addressing prefixes "<" and ">" that will force direct or
extended addressing modes respectively.
.sp
.un 2
--Multiple labels are allowed, separated by commas.  All labels present on
an opcode line will be equated to the location counter, "*", before the rest
of the line is processed.
.in 0
.pa
ASM processes each machine instruction line as follows:
.ix Line Processing
.ix Instruction Mnemonics, 6805
all
.ix Labels
labels are
first equated to the
.ix Location Counter
location counter, '*'; then the opcode specified is
inspected to determine which operand addressing modes are legal.  Finally, the
operand field is scanned for an appropriate
.ix Addressing Mode
addressing mode specification.  The
.ix Opcode
opcode is combined with the specified addressing mode to generate the
object code corresponding to the desired instruction.
.sp
There are several operand modes for 6805 instructions.  A given instruction
will have one or more modes as legal forms (some opcodes require no
operand specification whatsoever).  The
.ix Syntax
syntax of each of these modes is discussed in the following pages.
A few examples of each mode will be given.  A table of instruction mnemonics
and their modes is given at the end of this section.
.sp
Throughout this section, the
.ix Notation
notation "<expr>" means any expression,
"EA=" means Effective Address, and "(" ")" to the right of "EA=" means
"the contents of".
.pa
.tc
INHERENT MODE
.ix Inherent Mode, 6805
.ix Addressing, Inherent 6805
.sp
Inherent Mode opcodes need no operand specifications.  The
.ix Argument Field
argument field is ignored.  For portability purposes, it should be left blank.
.sp
Syntax:
.im 1
                <opcode>
.sp
Examples:
.sp
.im 3
                RTI             ;Return from Interrupt
                TXA             ;(X-Reg) to (A-Reg)
                CLRA            ;A-Reg:=0
.sp 2
.sp 2
.tc
DIRECT MODE
.ix Direct Mode, 6805
.ix Addressing, Direct 6805
.sp
Direct Mode is used to address a location in the first 256 bytes of memory.
.sp
Direct references may be forced with a "<"
.ix Prefix, < 6805
prefix.  Use of this prefix
prevents any default to the
.ix Extended Mode
Extended Mode addressing.  If the effective address does not map into the
first 256 bytes of memory, an error is generated.
.sp
Syntax:
.im 1
                <opcode>        {<prefix>}<exp>
.sp
Example:
.sp
.im 8
        A       EQU     $10
                                ;Generated:
                CLR     B       ;Extended reference EA=$20
                INC     A       ;Direct reference EA=$10
                ROR     <C      ;Forced Direct reference with error
                ASL     <B      ;Forced Direct reference EA=$20
        B       EQU     $20     ;Forward reference address
        C       EQU     $1234   ;Forward reference address (too big)
.pa
EXTENDED MODE
.ix Extended Mode, 6805
.ix Addressing, Extended 6805
.tc
.sp
Extended mode addresses memory with a 16-bit address embedded in the
instruction.  Any location
in the memory space can be referenced with this mode.  Extended mode may be
forced by use of the ">"
.ix Prefix
.ix Prefix, > 6805
prefix.
.sp
Special Note: This addressing mode is not available for the
.ix Monadic Instructions, 6805
monadic instructions of the 6805.
.sp
Syntax:
.im 1
                <opcode>        {<prefix>}<exp>
.sp
Example:
.sp
.im 5
        AA      EQU     $10
        BB      EQU     $1234
                LDA     >AA     ;">" was required to produce
                                ;extended mode addressing
                STA     BB      ;Extended addressing
.sp 2
.tc
INDEXED MODE
.ix Indexed Mode, 6805
.ix Addressing, Indexed 6805
.sp
Indexed mode addressing forms an effective address equal to the sum of
an offset value and the contents of the 8-bit index register.
.sp
There are three types of indexing that may be specified:
.sp
.in 5
Zero offset
.br
8-bit offset
.br
16-bit offset
.sp
Special Note: The 16-bit indexing mode is not available for the
.ix Monadic Instructions, 6805
monadic instructions of the 6805.
.sp
.in 0
.sp
.ju
General syntax:
.br
.pw 120
.ll 100
.nj
.im 1
        <opcode>        {<prefix>}{<expr>},X
.ll 65
.pw 85
.ju
.sp 2
ZERO OFFSET INDEXED MODE
.ix Zero Offset, 6805
.ix Addressing, Zero Offset 6805
.tc
.sp
This mode is also known as a register indirect addressing.  The effective
address is equal to the contents of the 8-bit index register.
.sp
Syntax:
.sp
.pw 120
.ll 100
.nj
.im 2
                <opcode>        ,X        ;Both zero offset
                <opcode>        0,X       ; forms functionally the same.
.ll 65
.pw 85
.ju
.sp
Examples:
.sp
.im 1
                LDA     ,X      ;EA = (X)
.sp
.pa
.tc
8-BIT AND 16-BIT OFFSET INDEXING MODES
.ix 8-Bit Offset, 6805
.ix 16-Bit Offset, 6805
.ix Addressing, Indexed 6805
.sp
The 8-bit and 16-bit offset indexing form an effective address equal to a
constant plus the contents of the 8-bit index register. The constant is
embedded in the instruction.  The constant is assumed to be positive for
8-bit offsets and may be negative for 16-bit offsets.
.sp
The two sizes of offsets are notationally identical. ASM attempts to assemble
the shortest form.  The limitations of the two-pass assembly technique force
ASM to assume worst-case, 16-bit offset, for those offset expressions
containing forward references.  Prefix notations are provided to allow the
programmer to force the offset size (8 or 16 bits), even in the presence of a
forward reference or with a non-forward reference value of less than 256.
.sp
Syntax:
.sp
.im 1
                <opcode>        <prefix><expr>,X    ;constant offset
.sp
Examples:
.sp
.im 2
                SUB     5,X             ;EA = (X)+5
                STA     27083,X         ;EA = (X)+27083
.sp
Special operand prefix notations:
.sp
.im 2
                <       force 8-bit offset
                >       force 16-bit offset
.sp
Examples:
.sp
.im 2
                SUB     >FAROUT,X       ;Forces offset to 16 bits
                LDA     <WAYOUT,X       ;Assumes WAYOUT fits in 8 bits
.sp
Note:
.sp
.in 10
.un 5
~~~~~If the offset expression has no forward references and evaluates to zero
during Pass 1, then the zero offset form will be substituted.  The zero offset
form saves one machine cycle over the 8-bit offset form.
.sp
Example:
.SP
.im 4
        BACKWARD        EQU     0
                LDA     BACKWARD,X      ;Generates "LDA ,X"
                STA     FORWARD,Y       ;Generates "STA >0,Y"
        FORWARD EQU     0
.sp
.br
Notice that the FORWARD reference generated a 16-bit offset.  This is because
in ASM Pass 1, the value of FORWARD was not known and the worst case was
assumed.
.pa
.in 0
.tc
RELATIVE MODE
.ix Relative Mode, 6805
.ix Addressing, Relative 6805
.sp
The
.ix Branch
branch (Bxx) class of instructions use this mode.  The offset is an 8-bit
signed value in bytes.
The effective address is equal to the address
of the next instruction plus the value of the (sign-extended) constant
offset embedded in the instruction.
.sp
Syntax:
.sp
.im 2
        Bxx     <expr>
        BRxxx   <bit expr>,<byte expr>,<dest expr>
.sp
Examples:
.sp
.im 2
                BRA     BLIMP
                BRSET   1,PZLOC,ZEPPELIN
.sp
.in 10
.un 10
NOTE:~~~~~If either form ("Bxx" or "BRxxx") is requested and the <expr>
expression is evaluable on Pass 1 to a destination that is out of range, ASM
will substitute the equivalent jump macro ("Jxx" or "Jxxx").
.in 0
.sp 2
.tc
IMMEDIATE MODE
.ix Immediate Mode, 6805
.ix Addressing, Immediate 6805
.sp
Many 6805 instructions use a constant embedded in the instruction
rather than an operand in a memory location separate from the
instruction.  This is designated "immediate" mode.  The size of
an immediate operand is determined by the instruction, not the 
operand; some instructions use 16 bit immediate operands while
others use 8 bit immediate operands.  The
.ix Notation
notation "#<expr>" is used
to specify an immediate operand.  Operand expression value must fall in
the range of 0-255 or an error will be generated.
.sp
Syntax:
.im 1
                <opcode>        #<expr>
.sp
Examples:
.sp
.im 3
                ADD     #1              ; adds 1 to A register
                CMP     #$40
                LDA     #BUFFER+2
.sp
.pa
.in 0
.tc
BIT MODE
.ix Bit Mode, 6805
.ix Addressing, Bit 6805
.sp
The 6805 has instructions that may address any bit in the first 256 bytes of
memory.  This addressing mode take two operand values.  The first is the
bit number which must be in the range of 0-7.  The second is the byte number
which has a value range of 0-255.  The
.ix Notation
notation "<bit>,<byte>" is used to specify the bit and byte respectively.
If the value ranges for either of the operand values are exceeded, then an
error is generated.
.sp
Syntax:
.im 1
               <opcode>      <bit expr>,<byte expr>
.sp
Examples:
.sp
.im 3
               BCLR    3,21            ;Clear bit 3 in EA=21
               BRSET   HIBIT,FBYTE,GO  ;Branch to GO if HIBIT
                                       ; set in FBYTE
.pa
.tc
OPCODE MNEMONICS RECOGNIZED BY ASM6805
.ix Opcode Mnemonics, 6805
.sp
This table lists all the opcode mnemonics recognized by the ASM6805. The
operand modes accepted by ASM for each of the opcodes are marked in the
table.  Additionally, there are
.ix Notation
notations, comments and opcode mnemonic classifications.  The notations will
show expansions if the mnemonic causes an alternative code or multiple
machine instructions to be generated.  The opcode classes are as follows:
.sp
.in 9
.un 9
6805~~~-~6805 (Motorola) standard mnemonic.  Generates a conventional
6805 instruction.
.sp
.un 9
.ix Jump Macros, 6805
JMAC~~~-~Jump macro.  These jump macros are extensions to the existing
conditional branches available on the 6805.  A jump macro generates a
branch instruction for the complimented condition around a JMP instruction
with the addressing mode specified by the operand field.  A jump macro will
accept any mode of addressing the JMP instruction will accept.
.sp
Examples:
.sp
.im 11
            JCC    0,X          ;Jump Carry Clear (BCC equivalent)
      expands to:
            BCS    xxx
            JMP    0,X
       xxx:

            JCLR   1,2,3,X      ;Jump bit clear (BRCLR equivalent)
      expands to:
            BRSET  1,2,xxx      ;Branch if bit 1 in byte 2 set
            JMP    3,X
       xxx:
.sp
.in 0
*OPERAND MODE KEY:
.sp
.pw 120
.ll 100
.nj
.IM 3
IDX0=INDEXED(ZERO OFFSET)     DIR=DIRECT     BRA=BRANCH(RELATIVE)
IDX1=INDEXED(8-BIT OFFSET)    IMM=IMMEDIATE  INH=INHERENT
IDX2=INDEXED(16-BIT OFFSET)   EXT=EXTENDED   BIT=BIT
.ll 65
.pw 85
.PA
.pw 120
.ll 100
.im 48
                              OPCODE
OPCODE     OPERAND MODES*     CLASS          NOTES AND COMMENTS

           I I I E D I I B B
           D D D X I M N R I
           X X X T R M H A T
           0 1 2

ADC        X X X X X X         6805
ADD        X X X X X X         6805
AND        X X X X X X         6805
ASL        X X     X           6805
ASLA                   X       6805
ASLX                   X       6805
ASR        X X     X           6805
ASRA                   X       6805
ASRX                   X       6805
BCC                      X     6805
BCLR                       X   6805
BCS                      X     6805
BEQ                      X     6805
BHCC                     X     6805
BHCS                     X     6805
BHI                      X     6805
BHS                      X     6805
BIH                      X     6805
BIL                      X     6805
BIT        X X X X X X         6805
BLS                      X     6805
BMC                      X     6805
BMS                      X     6805
BMI                      X     6805
BNE                      X     6805
BPL                      X     6805
BRA                      X     6805
BRCLR                    X X   6805       See note 1
BRN                      X     6805
BRSET                    X X   6805       See note 1
BSET                       X   6805
BSR                      X     6805
CLC                    X       6805
CLI                    X       6805
CLR        X X     X           6805
CLRA                   X       6805
CLRX                   X       6805
CMP        X X X X X X         6805
COM        X X     X           6805
COMA                   X       6805
.ll 65
.pw 85
.PA
.pw 120
.ll 100
.im 48
                              OPCODE
OPCODE     OPERAND MODES*     CLASS          NOTES AND COMMENTS

           I I I E D I I B B
           D D D X I M N R I
           X X X T R M H A T
           0 1 2

COMX                   X       6805
CPX        X X X X X X         6805
DAA                    X       6805
DEC        X X     X           6805
DECA                   X       6805
DECX                   X       6805
EOR        X X X X X X         6805
INC        X X     X           6805
INCA                   X       6805
INCX                   X       6805
JCC        X X X X X           JMAC       Jump macro
JCLR       X X X X X       X   JMAC       Jump macro, see note 2
JCS        X X X X X           JMAC       Jump macro
JEQ        X X X X X           JMAC       Jump macro
JHCC       X X X X X           JMAC       Jump macro
JHCS       X X X X X           JMAC       Jump macro
JHI        X X X X X           JMAC       Jump macro
JHS        X X X X X           JMAC       Jump macro
JIH        X X X X X           JMAC       Jump macro
JIL        X X X X X           JMAC       Jump macro
JLS        X X X X X           JMAC       Jump macro
JMC        X X X X X           JMAC       Jump macro
JMP        X X X X X           6805
JMS        X X X X X           JMAC       Jump macro
JMI        X X X X X           JMAC       Jump macro
JNE        X X X X X           JMAC       Jump macro
JPL        X X X X X           JMAC       Jump macro
JRA        X X X X X           JMAC       Jump macro
JRN        X X X X X           JMAC       Jump macro
JSET       X X X X X       X   JMAC       Jump macro, see note 2
JSR        X X X X X           6805
LDA        X X X X X X         6805
LDX        X X X X X X         6805
LSL        X X     X           6805
LSLA                   X       6805
LSLX                   X       6805
LSR        X X     X           6805
LSRA                   X       6805
LSRX                   X       6805
NEG        X X     X           6805
.ll 65
.pw 85
.PA
.pw 120
.ll 100
.im 43
                              OPCODE
OPCODE     OPERAND MODES*     CLASS          NOTES AND COMMENTS

           I I I E D I I B B
           D D D X I M N R I
           X X X T R M H A T
           0 1 2

NEGA                   X       6805
NEGX                   X       6805
NOP                    X       6805
ORA        X X X X X X         6805
ROL        X X     X           6805
ROLA                   X       6805
ROLX                   X       6805
ROR        X X     X           6805
RORA                   X       6805
RORX                   X       6805
RSP                    X       6805
RTI                    X       6805
RTS                    X       6805
SBC        X X X X X X         6805
SEC                    X       6805
SEI                    X       6805
STA        X X X X X           6805
STOP                   X       6805
STX        X X X X X           6805
SUB        X X X X X X         6805
SWI                    X       6805
TAX                    X       6805
TXA                    X       6805
TST        X X     X           6805
TSTA                   X       6805
TSTX                   X       6805
WAIT                   X       6805


Note 1: Bit test branches (BRxxx) take "<bit>,<byte>,<dest>"
        where <dest> is a legal BRA operand.

Note 2: Bit test jump macros take the "<bit>,<byte>,<dest>"
        like the BRxxx instructions but <dest> may be any
        legal JMP operand including all 3 indexing modes.
