	REM **** GRAPHICS CHESS **** 3/1/78
	REM ANALYSISRATE IS SOME 51.8 ANALYSES PER MINUTE
	REM STACK BOARD IN CHARACTER STRING ??
	REM INSTALL PIECE RATIO ON SCORES
	REM ACCESS BOARD AS VECTOR ??
	REM BOARD SWAP COSTS VERY HIGH--COULD REPLICATE 8000,6000
	REM 2 4 ARE REASONABLE MIN,MAX

	REM **** CHESS *****
	REM BY IRA BAXTER, SOFTWARE DYNAMICS

	REM BOARD[2..9,2..9] IS USED TO PREVENT KNIGHTMOVE$ FROM USING FP ARITHMETIC
	REM EXTRA ROWS AROUND BOARD ARE FILLED WITH "PAWN"...
	REM SO THAT MOVES TO THOSE REGIONS ARE APPARANTLY ILLEGAL
10	DIM BOARD(11,11),ROW,COLUMN,ROWTO,COLTO
	DIM ONE/2/,TWO/3/,THREE/4/,FOUR/5/,FIVE/6/,SIX/7/,SEVEN/8/,EIGHT/9/,NINE/11/
	REM NINE = EIGHT + ONE
	DIM KINGROW,KINGCOLUMN
	DIM ROOK/4/,KNIGHT/2/,BISHOP/3/,QUEEN/5/,KING/6/,PAWN/1/
	DIM PAWNSCORE/16/,KNIGHTSCORE/48/,BISHOPSCORE/48/,ROOKSCORE/80/
	DIM QUEENSCORE/144/,KINGSCORE/10000/,CASTLESCORE/8/
	DIM ADVANCEPAWNSCORE/1/,TREEDEPTHPENALTY/1/
	DIM BACKROW$/0,4,2,3,6,5,3,2,4/
	DIM OBJECTNAME$/".PNBRQK"/,OBJECTCOLOR$/" WWWWWWW BBBBBBB"/
	DIM SCOREPIECE[15],NEWNODE,INSERT/0/,PREVIOUS,POSSCORE
	DIM SWAPPIECE[14]

	REM CURRENT STATE (OF LOOKAHEAD)
	DIM CURSCORE,CURROWFROM/0/,CURCOLFROM/0/,CURROWTO/0/,CURCOLTO/0/
	DIM CURBESTMOVE,CURBESTSCORE,CURMACHCASTLED/0/,CUROPPCASTLED/0/
	DIM CURMOVEBASE/0/,CURMOBILITY,CURBESTONEMOBILITY

	REM NEW STATE (OF LOOKAHEAD)
	DIM NEWSCORE,NEWROWFROM,NEWCOLFROM,NEWROWTO,NEWCOLTO,NEWMACHCASTLED
	DIM NEWSOURCEPIECE,NEWTARGETPIECE

	REM PUSHDOWN STACK FOR CURRENT STATE WHEN DOING RECURSIVE LOOKAHEAD
	DIM LEVEL/1/,MAXLEVEL/4/,MINLEVEL/1/,MAXDEPTH/10/
	DIM STACKSCORE[10]
	DIM STACKBESTMOVE[10],STACKBESTSCORE[10],STACKSOURCEPIECE[10],STACKTARGETPIECE[10]
	DIM STACKMACHCASTLED[10],STACKOPPCASTLED[10],STACKMOVEBASE[10],STACKMOBILITY[10]
	DIM STACKBESTONEMOBILITY[10]

	DIM CHEAT/2/
	REM VALUES IN ...MOVE$ HAVE HAD "CHEAT" ALREADY ADDED!
	REM THIS PREVENTS ME FROM DOING FLOATING POINT ARITHMETIC
	DIM KNIGHTMOVE$/3,4,1,4,3,0,1,0,4,3,4,1,0,3,0,1/
	DIM BISHOPROOKMOVE$/3,3,3,1,1,3,1,1,3,2,1,2,2,1,2,3/
	DIM POSSSOURCEROW$[300],POSSSOURCECOL$[300],POSSTARGETROW$[300],POSSTARGETCOL$[300]
	DIM MAXPOSSMOVES/300/,MOVE,POSSSCORE[300],POSSLINK[300],POSSFREE,MOVELIST/0/
	DIM I,J,TEMP,TEMP1,ONEMOBILITY
	DIM DEADHEAT/32767/,LOSE/27767/,WIN/37767/,TWODEADHEAT/65534/
	REM (WIN-LOSE)/2 > SUM(SCOREPIECES+CASTLING+POSITION+...)
	DIM REPLY$[10],HUMANCOLOR$[10],DBG$[10]
	DIM ANALYSISHISTORY[3],RECENTANALYSIS,NUMBEROFMOVES/0/
	DIM ANALYSISRATE,TOTALANALYSIS/0/,ANALYSISCOUNT/0/,HISTORYLENGTH/3/


	REM *** MAGIC COLOR VALUES ****
	REM	THESE ARE TAG BITS DIFFERENTIATING TYPES OF PIECES
	DIM	MACHINE/0/,OPPONENT/8/,EMPTY/0/,MACHINEQ/8/,OPPONENTQ/8/

	REM	****** GRAPHICS ADDITIONS FOR GRAPHBOX *****
	DIM MOVETO$/:1B," "/,READCROSSHAIRS$/:1B,:05/,HIDECURSOR$/:1B," 511 255",:0/

	DIM CLEARSCREEN$/:0C/,HOME$/:1B," 0 255",:1B,"-255 9",:1B," 0 255",:0D/
	DIM ANYCHAR$[1],COORDINATES$[12]
	DIM LINE2$/:1B," 0 246",:1B,"-255 9",:1B," 0 246",:0D/
	DIM LINE3$/:1B," 0 237",:1B,"-255 9",:1B," 0 237",:0D/
	DIM LINE4$/:1B," 0 228",:1B,"-255 9",:1B," 0 228",:0D/
	DIM LINE5$/:1B," 0 219",:1B,"-255 9",:1B," 0 219",:0D/
	DIM LINE6$/:1B," 0 210",:1B,"-255 9",:1B," 0 210",:0D/
	DIM LINE7$/:1B," 0 201",:1B,"-255 9",:1B," 0 201",:0D/
	DIM COMMENTARY$/:1B," 0 192",:1B,"-255 9",:1B," 0 192",:0D/
	DIM BOARDBASE$/:1B," 255 243",:0D,:1B,"*242 242"/
	DIM EMPTYSQUARE$/:1B,"+30 30"/
	DIM SOLIDKING$/:1B,"(24 24",:0D,...
&		"0399C0",...
&		"0FDBF0",...
&		"3FE7FC",...
&		"7FFFFE",...
&		"FFE7FF",...
&		"FFE7FF",...
&		"FF00FF",...
&		"7F00FE",...
&		"7FE7FE",...
&		"3FE7FC",...
&		"1FE7F8",...
&		"1FE7F8",...
&		"0FE7F0",...
&		"0FE7F0",...
&		"07C3E0",...
&		"023C40",...
&		"1DE7B8",...
&		"1FC3F8",...
&		"1FE7F8",...
&		"0FFFF0",...
&		"0F00F0",...
&		"06FF60",...
&		"01FF80",...
&		"00FF00"/
	DIM SOLIDKNIGHT$/:1B,"(24 24",:0D,...
&		"0C8000",...
&		"06C000",...
&		"07F000",...
&		"07FC00",...
&		"07FE00",...
&		"0FFF80",...
&		"08FFC0",...
&		"19FFC0",...
&		"1FFFE0",...
&		"7FFFF0",...
&		"FFFFF0",...
&		"BEFFF8",...
&		"FF0FF8",...
&		"FE0FF8",...
&		"6C1FFC",...
&		"183FFC",...
&		"00FFFC",...
&		"01FFFE",...
&		"03FFFE",...
&		"07FFFE",...
&		"07FFFE",...
&		"0FFFFE",...
&		"0FFFFF",...
&		"0FFFFF"/
	DIM SOLIDQUEEN$/:1B,"(24 24",:0D,...
&		"0700E0",...
&		"0500A0",...
&		"0700E0",...
&		"0381C0",...
&		"0381C0",...
&		"0381C0",...
&		"E3C3C7",...
&		"A1C385",...
&		"E1E787",...
&		"71E78E",...
&		"79E79E",...
&		"7DFFBE",...
&		"3FFFFC",...
&		"3FFFFC",...
&		"3FC3FC",...
&		"1C3C38",...
&		"13E7C8",...
&		"0FC3F0",...
&		"1FE7F8",...
&		"0FFFF0",...
&		"0F00F0",...
&		"06FF60",...
&		"01FF80",...
&		"01FF80"/
	DIM SOLIDPAWN$/:1B,"(24 24",:0D,...
&		"003C00",...
&		"007E00",...
&		"007E00",...
&		"019980",...
&		"07FFE0",...
&		"0FFFF0",...
&		"002400",...
&		"003C00",...
&		"003C00",...
&		"003C00",...
&		"003C00",...
&		"003C00",...
&		"003C00",...
&		"007E00",...
&		"007E00",...
&		"00FF00",...
&		"00FF00",...
&		"00FF00",...
&		"00FF00",...
&		"007E00",...
&		"007E00",...
&		"009900",...
&		"07FFE0",...
&		"0FFFF0"/
	DIM SOLIDBISHOP$/:1B,"(24 24",:0D,...
&		"01C380",...
&		"014280",...
&		"01C380",...
&		"00E700",...
&		"01F780",...
&		"03F7C0",...
&		"07FBE0",...
&		"07FDE0",...
&		"07FDE0",...
&		"03FEC0",...
&		"03FEC0",...
&		"01FF80",...
&		"00FF00",...
&		"004200",...
&		"01FF80",...
&		"03FFC0",...
&		"03C3C0",...
&		"033CC0",...
&		"01FF80",...
&		"009900",...
&		"07E7E0",...
&		"3FFFFC",...
&		"3FFFFC",...
&		"3FFFFC"/
	DIM SOLIDROOK$/:1B,"(24 24",:0D,...
&		"1C3C38",...
&		"1C3C38",...
&		"1FFFF8",...
&		"1FFFF8",...
&		"1FFFF8",...
&		"0FFFF0",...
&		"07FFE0",...
&		"020040",...
&		"03FFC0",...
&		"03FFC0",...
&		"03FFC0",...
&		"03FFC0",...
&		"03FFC0",...
&		"03FFC0",...
&		"03FFC0",...
&		"03FFC0",...
&		"03FFC0",...
&		"020040",...
&		"07FFE0",...
&		"07FFE0",...
&		"3FFFFC",...
&		"3FFFFC",...
&		"3FFFFC",...
&		"3FFFFC"/
	DIM HOLLOWPAWN$/:1B,"(24 24",:0D,...
&		"003C00",...
&		"006600",...
&		"004200",...
&		"01E780",...
&		"060060",...
&		"0FFFF0",...
&		"002400",...
&		"002400",...
&		"002400",...
&		"002400",...
&		"002400",...
&		"002400",...
&		"002400",...
&		"004200",...
&		"004200",...
&		"008100",...
&		"008100",...
&		"008100",...
&		"008100",...
&		"004200",...
&		"004200",...
&		"00E700",...
&		"0700E0",...
&		"0FFFF0"/
	DIM HOLLOWKNIGHT$/:1B,"(24 24",:0D,...
&		"0C8000",...
&		"0AC000",...
&		"0AB000",...
&		"040C00",...
&		"040200",...
&		"080180",...
&		"0F00C0",...
&		"160040",...
&		"100020",...
&		"600030",...
&		"810810",...
&		"A0F808",...
&		"810808",...
&		"920808",...
&		"641804",...
&		"182004",...
&		"00C004",...
&		"010002",...
&		"020002",...
&		"040002",...
&		"040002",...
&		"080001",...
&		"080001",...
&		"0FFFFF"/
	DIM HOLLOWBISHOP$/:1B,"(24 24",:0D,...
&		"01C380",...
&		"014280",...
&		"01C380",...
&		"00A500",...
&		"011880",...
&		"020840",...
&		"020440",...
&		"040220",...
&		"040220",...
&		"020240",...
&		"020140",...
&		"010180",...
&		"008100",...
&		"007E00",...
&		"018180",...
&		"020040",...
&		"023C40",...
&		"02C340",...
&		"010080",...
&		"00E700",...
&		"0718E0",...
&		"3C007C",...
&		"200004",...
&		"3FFFFC"/
	DIM HOLLOWROOK$/:1B,"(24 24",:0D,...
&		"1C3C38",...
&		"142428",...
&		"17E7E8",...
&		"100008",...
&		"100008",...
&		"080010",...
&		"040020",...
&		"03FFC0",...
&		"020040",...
&		"020040",...
&		"020040",...
&		"020040",...
&		"020040",...
&		"020040",...
&		"020040",...
&		"020040",...
&		"020040",...
&		"03FFC0",...
&		"040020",...
&		"040020",...
&		"3C003C",...
&		"200004",...
&		"200004",...
&		"3FFFFC"/
	DIM HOLLOWQUEEN$/:1B,"(24 24",:0D,...
&		"0700E0",...
&		"0500A0",...
&		"0700E0",...
&		"028140",...
&		"028140",...
&		"028140",...
&		"E24247",...
&		"A14285",...
&		"E12487",...
&		"51248A",...
&		"492492",...
&		"4518A2",...
&		"2300C4",...
&		"200004",...
&		"203C04",...
&		"13C3C8",...
&		"1C1838",...
&		"103C08",...
&		"101808",...
&		"080010",...
&		"08FF10",...
&		"0500A0",...
&		"020040",...
&		"01FF80"/
	DIM HOLLOWKING$/:1B,"(24 24",:0D,...
&		"0399C0",...
&		"0C5A30",...
&		"30240C",...
&		"401802",...
&		"801801",...
&		"801801",...
&		"80FF01",...
&		"40FF02",...
&		"401802",...
&		"201804",...
&		"101808",...
&		"101808",...
&		"081810",...
&		"081810",...
&		"043C20",...
&		"03C3C0",...
&		"1C1838",...
&		"103C08",...
&		"101808",...
&		"080010",...
&		"08FF10",...
&		"0500A0",...
&		"020040",...
&		"01FF80"/
	DIM OLDBOARD(9,9)

20	WRITE #0, CLEARSCREEN$
	REM INITZ OLDBOARD TO ALL EMPTY SQUARES
	FOR ROW=ONE TO EIGHT
		FOR COLUMN=ONE TO EIGHT
			LET OLDBOARD(ROW,COLUMN)=EMPTY
		NEXT COLUMN
	NEXT ROW
	REM NOW DRAW THE CHESSBOARD
	WRITE #0, BOARDBASE$
	FOR I=0 TO 7 STEP 2
		FOR J=0 TO 3
			WRITE #0, MOVETO$
			PRINT 256+J*30*2;242-I*30
			WRITE #0, EMPTYSQUARE$
			WRITE #0, MOVETO$
			PRINT 286+J*30*2;242-(I+1)*30
			WRITE #0, EMPTYSQUARE$
		NEXT J
	NEXT I
	WRITE #0, HOME$
	PRINT " **** SOFTWARE DYNAMICS <<CHESS>> ****"
	INPUT "TIMED PLAY ? " ANALYSISRATE
	FOR I=1 TO HISTORYLENGTH
		LET ANALYSISHISTORY[I]=ANALYSISRATE
	NEXT I
50	INPUT "HOW CLEVER AM I TODAY?   " MINLEVEL,MAXLEVEL
	IF MINLEVEL<1 OR MINLEVEL<>INT(MINLEVEL)...
&	   OR MAXLEVEL>MAXDEPTH OR MAXLEVEL<>INT(MAXLEVEL) ...
&	   OR MINLEVEL>MAXLEVEL THEN 50
REM	INPUT "PRINT LIST OF GENERATED MOVES ?" DBG$
100	REM **** INITIALIZE TO PLAY ****
	CURSCORE=DEADHEAT	\! START OFF EVEN
	CURBESTSCORE=DEADHEAT	\! SO 9000 WORKS PROPERLY FIRST TIME
	FOR COLUMN=ONE TO EIGHT
		LET BOARD(ONE,COLUMN)=BACKROW$(COLUMN)
		LET BOARD(TWO,COLUMN)=PAWN
		FOR ROW=THREE TO SIX\ BOARD(ROW,COLUMN)=EMPTY\ NEXT ROW
		LET BOARD(SEVEN,COLUMN)=OPPONENT!PAWN
		LET BOARD(EIGHT,COLUMN)=OPPONENT!BACKROW$(COLUMN)
	NEXT COLUMN
	FOR ROW=0 TO 1	\! SET UP BOARD EDGES TO "PAWN"
		FOR COLUMN=0 TO 11	\! THIS SPEEDS UP "MOVE OFF EDGE OF BOARD" CHECK
			BOARD[ROW,COLUMN]=PAWN
			BOARD[COLUMN,ROW]=PAWN
			BOARD[11-ROW,COLUMN]=PAWN
			BOARD[COLUMN,11-ROW]=PAWN
		NEXT COLUMN
	NEXT ROW
	REM INITZ SCOREPIECE
	SCOREPIECE[EMPTY]=0
	SCOREPIECE[PAWN]=PAWNSCORE
	SCOREPIECE[KNIGHT]=KNIGHTSCORE
	SCOREPIECE[BISHOP]=BISHOPSCORE
	SCOREPIECE[ROOK]=ROOKSCORE
	SCOREPIECE[QUEEN]=QUEENSCORE
	SCOREPIECE[KING]=KINGSCORE	\! = 2* VALUE REQUIRED TO WIN
	FOR I=0 TO 7\ SCOREPIECE[I!OPPONENT]=SCOREPIECE[I]\NEXT I
	REM INITZ SWAPPIECE VECTOR
	FOR I=PAWN TO KING
		SWAPPIECE[I]=OPPONENT!I
		SWAPPIECE[OPPONENT!I]=I
	NEXT I
	SWAPPIECE[EMPTY]=EMPTY
	REM INITZ POSSLINK FREE LIST
	FOR I=1 TO MAXPOSSMOVES\POSSLINK[I]=I-1\NEXT I
	POSSFREE=MAXPOSSMOVES

200	WRITE #0, LINE2$
	INPUT "DO YOU WANT BLACK OR WHITE ?" HUMANCOLOR$
	WRITE #0, LINE2$
	IF HUMANCOLOR$="BLACK" THEN GOSUB 9000\ GOTO 2000
	IF HUMANCOLOR$<>"WHITE" THEN PRINT "NOT A VALID COLOR!?"\GOTO 200
	LET OBJECTCOLOR$=" BBBBBBB WWWWWWW"
	BOARD(ONE,FOUR)=QUEEN
	BOARD(ONE,FIVE)=KING
	BOARD(EIGHT,FOUR)=OPPONENT!QUEEN
	BOARD(EIGHT,FIVE)=OPPONENT!KING

1000	REM **** HUMAN MOVES ****
	GOSUB 9000\! DISPLAY THE BOARD
	IF CURSCORE>=WIN
	THEN
		WRITE #0, COMMENTARY$
		PRINT "YOU LOSE, BUSTER!"
		EXIT
	FI
1005	FOR I=1 TO MAXPOSSMOVES\POSSLINK[I]=I-1\NEXT I\ ! RESET FREE MOVE CHAIN
	POSSFREE=MAXPOSSMOVES
	GOSUB 5000\! SWAP MACHINE FOR OPPONENT OBJECTS
	MOVELIST=0	\! MAKE MOVE LIST EMPTY
	MAXLEVEL=MAXLEVEL+1	\! SO 8000 DOESN'T "TRIM MOVE LIST (8970)"
	GOSUB 8000\! FIGURE OUT WHAT ALL THE LEGAL MOVES ARE
	MAXLEVEL=MAXLEVEL-1	\! UNDO THE INCREMENT DONE BEFORE THE GOSUB
	IF CURMOBILITY=0
	THEN
		WRITE #0,COMMENTARY$
		PRINT "I HATE DRAW GAMES!"
		EXIT
	FI
1010	WRITE #0, HOME$
	PRINT "YOUR MOVE: ";
	GOSUB 1100	\! READ FROM COORDINATES
	WRITE #0, COMMENTARY$
	IF ROWTO=0 THEN 1020
	WRITE #0,MOVETO$
	PRINT 65;255
	PRINT ROWTO;COLTO;" TO";
	LET ROW=NINE-(ROWTO-1+ONE)
	LET COLUMN=ONE-1+COLTO
	IF BOARD[ROW,COLUMN]=OPPONENT!KING THEN 1500\ REM ENTER NEW PIECE LAYOUT
	IF OPPONENTQ&BOARD[ROW,COLUMN]<>0 OR BOARD[ROW,COLUMN]=EMPTY...
&	THEN 1020	\! CAN'T MOVE MACHINE'S PIECES OR EMPTY SQUARES
	GOSUB 1100	\! GET "TO" COORDINATES
	IF ROWTO=0 THEN 1020
	WRITE #0, MOVETO$
	PRINT 122;255
	PRINT ROWTO;COLTO
	LET ROWTO=NINE-(ROWTO-1+ONE)
	LET COLTO=ONE-1+COLTO
	LET MOVE=MOVELIST
	WHILE MOVE<>0 DO
		IF POSSSOURCEROW$(MOVE)=ROW AND POSSSOURCECOL$(MOVE)=COLUMN...
&		AND POSSTARGETROW$(MOVE)=ROWTO AND POSSTARGETCOL$(MOVE)=COLTO
		THEN 1600 ELSE MOVE=POSSLINK[MOVE]
	END
1020	WRITE #0, COMMENTARY$
	PRINT "THAT'S NOT A LEGAL MOVE, BUDDY....."
	GOTO 1010

1100	REM INPUT COORDINATES INTO "ROWTO", "COLTO"
	WRITE #0, HIDECURSOR$
	FOR I=1 TO 1000 DO REM
	INPUT '' ANYCHAR$	\! WAIT FOR CARRIAGE RETURN
	WRITE #0,READCROSSHAIRS$
	READ #0,COORDINATES$
	LET COLTO=VAL(COORDINATES$)
	LET ROWTO=VAL(COORDINATES$[7,5])
	IF COLTO<256 OR 256+8*30<=COLTO OR ROWTO<242-8*30 OR 242<ROWTO
	THEN LET ROWTO=0\ RETURN
	LET COLTO=1+INT((COLTO-256)/30)
	LET ROWTO=8-INT((ROWTO-(241-8*30))/30)
	RETURN

1500	REM **** MODIFY BOARD LAYOUT
	GOSUB 5000\REM TURN BOARD RIGHTSIDE UP AGAIN
1510	GOSUB 9000	\! DISPLAY THE BOARD
	WRITE #0, HOME$
	WRITE #0, LINE2$
	INPUT "PLACE PIECE: " REPLY$
	IF REPLY$="" THEN 1550
	IF REPLY$="." THEN 1520
	IF LEN(REPLY$)<>2 OR (REPLY$[1]<>ASC("W") AND REPLY$[1]<>ASC("B")) THEN 1510
	LET NEWSOURCEPIECE=FIND(OBJECTNAME$[2,6],REPLY$[2,1])
	IF NEWSOURCEPIECE=0 THEN 1510
1520	INPUT "WHERE? " ROW,COLUMN
	LET ROW=ONE-1+ROW
	LET COLUMN=ONE-1+COLUMN
	IF ONE>ROW OR EIGHT<ROW OR ONE>COLUMN OR EIGHT<COLUMN THEN 1520
	IF REPLY$="." THEN BOARD[ROW,COLUMN]=EMPTY
		      ELSE BOARD[ROW,COLUMN]=NEWSOURCEPIECE
			   IF REPLY$[1]=HUMANCOLOR$[1]
			   THEN BOARD[ROW,COLUMN]=OPPONENT!BOARD[ROW,COLUMN]
	GOTO 1510
1550	WRITE #0, COMMENTARY$
	LET CURSCORE=DEADHEAT
	FOR ROW=ONE TO EIGHT
		FOR COLUMN=ONE TO EIGHT
			IF OPPONENT&BOARD[ROW,COLUMN]<>0
			THEN CURSCORE=CURSCORE-SCOREPIECE[BOARD[ROW,COLUMN]]
			ELSE CURSCORE=CURSCORE+SCOREPIECE[BOARD[ROW,COLUMN]]
1560		NEXT COLUMN
	NEXT ROW
	GOSUB 9000\ REM DISPLAY THE BOARD
	FOR ROW=ONE TO EIGHT
		FOR COLUMN=ONE TO EIGHT
			IF BOARD[ROW,COLUMN]=KING THEN 1570
		NEXT COLUMN
	NEXT ROW
	WRITE #0, COMMENTARY$
	PRINT "YOU'RE MISSING MY KING!"\GOTO 1510
1570	FOR ROW=ONE TO EIGHT
		FOR COLUMN=ONE TO EIGHT
			IF BOARD[ROW,COLUMN]=OPPONENT!KING
			THEN 1005
		NEXT COLUMN
	NEXT ROW
	WRITE #0, COMMENTARY$
	PRINT "YOU'RE MISSING YOUR KING!"\GOTO 1510

1600	REM HUMAN MADE LEGAL MOVE, NOW DO THE MOVE
	INSERT=MOVELIST	\! REMEMBER BEGINNING OF MOVELIST
	MOVELIST=MOVE	\! SO WE CAN MAKE THE MOVE ON THE BOARD
	GOSUB 6000\! DO POSSIBLEMOVES(MOVELIST,...)
	NEWSCORE=POSSSCORE[MOVELIST]	\! SO 6100 WORKS PROPERLY
	GOSUB 6100\! FIX MOVE PERMANENTLY
	GOSUB 5000\! SWAP THE BOARD BACK THE WAY IT WAS
	GOSUB 9000	\! DISPLAY HUMAN'S MOVE ON BOARD
	WRITE #0, LINE4$
	PRINT "SCORE: "; (CURSCORE-DEADHEAT)/PAWNSCORE
	IF CURSCORE<=LOSE
	THEN
		WRITE #0,COMMENTARY$
		PRINT "YOU ATE MY KING!"
		EXIT
	FI

2000	REM **** NOW ITS THE MACHINE'S TURN !
	WRITE #0, LINE3$
	PRINT "THINKING..."	\! ERASE "MY MOVE IS..."
	REM ADD HUMAN MOVES BACK TO FREE LIST
	LET MOVELIST=INSERT	\! PUT THINGS BACK LIKE THEY WERE AT LINE 1600
	IF INSERT<>0
	THEN WHILE POSSLINK[INSERT]<>0 DO INSERT=POSSLINK[INSERT] END\
	     LET POSSLINK[INSERT]=POSSFREE\
	     LET POSSFREE=MOVELIST\
	     LET MOVELIST=0
	REM FIND ENEMY KING
	FOR KINGROW=ONE TO EIGHT
		FOR KINGCOLUMN=ONE TO EIGHT
			IF BOARD(KINGROW,KINGCOLUMN)=OPPONENT!KING THEN 2010
		NEXT KINGCOLUMN
	NEXT KINGROW
2010	LET ANALYSISCOUNT=0	\! SO WE COUNT # BOARDS ANALYZED BY "7000"
	LET STACKSCORE[0]=CURSCORE
	REM SO "IF" BEFORE 7100 DOESN'T COMPARE AGAINST GARBAGE IF LEVEL=1
	GOSUB 7000	\! FIGURE OUT BEST POSSIBLE MOVE
	IF CURMOBILITY=0
	THEN
		WRITE #0,COMMENTARY$	
		PRINT "YOU BACKED ME INTO A CORNER..."
		STOP
	FI
	IF CURBESTSCORE<=LOSE
	THEN
		WRITE #0,COMMENTARY$
		PRINT "...(I LOSE)..."
		EXIT
	FI
	MOVELIST=CURBESTMOVE	\! PICK THE BEST MOVE TO MAKE
	PRINT "MY MOVE IS: ";POSSSOURCEROW$(MOVELIST)+1-ONE;POSSSOURCECOL$(MOVELIST)+1-ONE;
	PRINT  " TO ";POSSTARGETROW$(MOVELIST)+1-ONE;POSSTARGETCOL$(MOVELIST)+1-ONE
	GOSUB 6000\! REM MAKE THE BEST MOVE
	LET NEWSCORE=POSSSCORE[MOVELIST]	\! SO 6100 WORKS RIGHT
	GOSUB 6100\! FIX MOVE PERMANENTLY
2100	REM OPERATE MOVE DEPTH FILTER OVER "HISTORYLENGTH" MOST RECENT MOVES
	LET NUMBEROFMOVES=NUMBEROFMOVES+1
	LET TOTALANALYSIS=TOTALANALYSIS+ANALYSISCOUNT
	LET RECENTANALYSIS=ANALYSISCOUNT	\! ZERO THE SUM
	FOR I=2 TO HISTORYLENGTH
		LET RECENTANALYSIS=RECENTANALYSIS+ANALYSISHISTORY[I]
		LET ANALYSISHISTORY[I-1]=ANALYSISHISTORY[I]
	NEXT I
	LET ANALYSISHISTORY[HISTORYLENGTH]=ANALYSISCOUNT
	IF NUMBEROFMOVES<40
	THEN LET TEMP=(40*ANALYSISRATE-TOTALANALYSIS)/(40-NUMBEROFMOVES)
	ELSE LET TEMP=ANALYSISRATE
	IF ANALYSISRATE<>0
	THEN IF RECENTANALYSIS/HISTORYLENGTH > TEMP
	     THEN IF MINLEVEL>0 AND ANALYSISCOUNT > TEMP
		  THEN LET MINLEVEL=MINLEVEL-1 FI
	     ELSE IF ANALYSISCOUNT < TEMP THEN MINLEVEL=MINLEVEL+1
	GOTO 1000\! HUMAN'S TURN AGAIN

5000	REM **** SWAP MACHINE OBJECTS FOR OPPONENT'S OBJECTS ****
	FOR ROW=ONE TO FOUR\! ALSO ROTATE OBJECTS AROUND HORIZONTAL AXIS
		FOR COLUMN=ONE TO EIGHT
			LET TEMP=SWAPPIECE[BOARD(ROW,COLUMN)]
			LET BOARD(ROW,COLUMN)=SWAPPIECE[BOARD(NINE-ROW,COLUMN)]
			LET BOARD(NINE-ROW,COLUMN)=TEMP
		NEXT COLUMN
	NEXT ROW
	REM SWITCH LAST MOVE STATE AROUND TO MATCH OBJECT SWAP, TOO!
	TEMP=CURMACHCASTLED\CURMACHCASTLED=CUROPPCASTLED\CUROPPCASTLED=TEMP
	CURROWFROM=NINE-CURROWFROM
	CURROWTO=NINE-CURROWTO
	CURSCORE=TWODEADHEAT-CURSCORE
	RETURN

6000	REM **** DO POSSIBLEMOVES(MOVELIST,...)
	REM CREATE NEW LOOKAHEAD STATE
	NEWROWFROM=POSSSOURCEROW$(MOVELIST)
	NEWCOLFROM=POSSSOURCECOL$(MOVELIST)
	NEWROWTO=POSSTARGETROW$(MOVELIST)
	NEWCOLTO=POSSTARGETCOL$(MOVELIST)
	NEWMACHCASTLED=CURMACHCASTLED
	NEWSOURCEPIECE=BOARD[NEWROWFROM,NEWCOLFROM]
	NEWTARGETPIECE=BOARD[NEWROWTO,NEWCOLTO]
	BOARD[NEWROWFROM,NEWCOLFROM]=EMPTY
	REM ROOK MOVE SHOULD PREVENT CASTLING!
	IF NEWSOURCEPIECE=KING
	THEN NEWMACHCASTLED=TRUE\
	     IF NEWCOLTO=NEWCOLFROM-2
	     THEN BOARD[ONE,ONE]=EMPTY\BOARD[ONE,NEWCOLTO+1]=ROOK
	     ELSE IF NEWCOLTO=NEWCOLFROM+2
		  THEN BOARD[ONE,EIGHT]=EMPTY\BOARD[ONE,NEWCOLTO-1]=ROOK FI
	ELSE IF NEWSOURCEPIECE=PAWN
		THEN IF NEWROWTO=EIGHT
		     THEN BOARD[NEWROWTO,NEWCOLTO]=QUEEN\RETURN
		     ELSE IF NEWCOLFROM<>NEWCOLTO AND BOARD[NEWROWTO,NEWCOLTO]=EMPTY
			  THEN BOARD[NEWROWFROM,NEWCOLTO]=EMPTY
	BOARD[NEWROWTO,NEWCOLTO]=NEWSOURCEPIECE
	RETURN

6100	REM **** FIX MOVE MADE BY SUBROUTINE 6000 AS PERMANENT MOVE ****
	CURSCORE=NEWSCORE
	CURROWFROM=NEWROWFROM
	CURCOLFROM=NEWCOLFROM
	CURROWTO=NEWROWTO
	CURCOLTO=NEWCOLTO
	CURMACHCASTLED=NEWMACHCASTLED
	RETURN

6500	REM **** UNDO LAST MOVE(LIST) ****
REM	IF DBG$="YES" THEN PRINT NEWSCORE\ GOSUB 9000
	BOARD[POSSSOURCEROW$[MOVELIST],POSSSOURCECOL$[MOVELIST]]=NEWSOURCEPIECE
	BOARD[POSSTARGETROW$[MOVELIST],POSSTARGETCOL$[MOVELIST]]=NEWTARGETPIECE
	IF NEWSOURCEPIECE=KING
	THEN IF POSSTARGETCOL$[MOVELIST]=POSSSOURCECOL$[MOVELIST]-2
	     THEN BOARD[ONE,ONE]=ROOK\
		  BOARD[ONE,POSSTARGETCOL$[MOVELIST]+1]=EMPTY
	     ELSE IF POSSTARGETCOL$[MOVELIST]=POSSSOURCECOL$[MOVELIST]+2
		  THEN BOARD[ONE,EIGHT]=ROOK\
		       BOARD[ONE,POSSTARGETCOL$[MOVELIST]-1]=EMPTY FI
	ELSE IF NEWSOURCEPIECE=PAWN AND NEWTARGETPIECE=EMPTY ...
&		AND POSSTARGETCOL$[MOVELIST]<>POSSSOURCECOL$[MOVELIST]
	     THEN BOARD[FIVE,POSSTARGETCOL$[MOVELIST]]=OPPONENT!PAWN
	RETURN

7000	REM **** FIGURE OUT BEST POSSIBLE MOVE *****
	REM **** RETURN CURBESTSCORE= BEST SCORE
	REM **** RETURNS CURBESTMOVE = POINTER TO NODE IN FREE POOL WITH BEST MOVE
	REM **** RETURNS WITH MOVELIST = CURMOVEBASE
	REM **** PRESERVES CURSCORE ****
	GOSUB 8000\! FIGURE OUT THE POSSIBLE MOVES
	IF CURMOBILITY=0 THEN LET CURBESTSCORE=DEADHEAT\ RETURN
	REM DOES PREVIOUS STATEMENT HELP ?
	REM NOW CHECK FOR QUICK WIN
	IF POSSSCORE[MOVELIST]>=WIN
	THEN CURBESTSCORE=POSSSCORE[MOVELIST]\
	     CURBESTMOVE=MOVELIST\
	     INSERT=MOVELIST\
	     WHILE POSSLINK[INSERT]<>CURMOVEBASE DO INSERT=POSSLINK[INSERT] END\
	     POSSLINK[INSERT]=POSSFREE\
	     POSSFREE=MOVELIST\
	     MOVELIST=CURMOVEBASE\
	     RETURN \! MOBILITIES DON'T MATTER...
	REM STACK THESE THINGS NOW SO WE DON'T HAVE TO DO IT IN MAIN LOOP
	STACKSCORE[LEVEL]=TWODEADHEAT-CURSCORE
	STACKMACHCASTLED[LEVEL]=CURMACHCASTLED
	STACKOPPCASTLED[LEVEL]=CUROPPCASTLED
	STACKMOVEBASE[LEVEL]=CURMOVEBASE
	STACKMOBILITY[LEVEL]=CURMOBILITY
	CURBESTMOVE=0	\! NOW ALLOCATE A DUMMY NODE AS "BEST"
	CURBESTSCORE=0	\! ASSUME WORSE THAN WORST POSSIBLE SCORE
	REM SO THAT 7100 CHOOSES FIRST MOVE AS BETTER MOVE, IGNORING MOBILITIES
7010	IF MOVELIST=CURMOVEBASE
	THEN POSSLINK[CURBESTMOVE]=POSSFREE\
	     POSSFREE=CURBESTMOVE\
	     CURMACHCASTLED=STACKMACHCASTLED[LEVEL]\
	     CUROPPCASTLED=STACKOPPCASTLED[LEVEL]\
	     CURMOBILITY=STACKMOBILITY[LEVEL]\
	     RETURN \! WITH CURBESTSCORE, CURMOBILITY
	REM CURMOBILITY IS # MOVES AVAILABLE TO WHITE AT PLY #0
	REM ONEMOBILITY IS # MOVES AVAILABLE TO BLACK AT PLY #1
	LET NEWSCORE=POSSSCORE[MOVELIST]
	IF NEWSCORE-CURSCORE<CASTLESCORE AND...
&		( LEVEL>MINLEVEL OR LEVEL=MINLEVEL AND STACKSCORE[LEVEL-1]-CURSCORE<PAWNSCORE ) ...
&	   OR LEVEL=MAXLEVEL OR POSSFREE=0 
	THEN LET ONEMOBILITY=0\ GOTO 7100
	REM NO RECURSION, SO USE FIXED MOBILITY
REM	IF DBG$="GOOD" THEN PRINT NEWSCORE\GOSUB 9000
	REM SOMETHING INTERESTING HAPPENED, FOLLOW IT UP!
	GOSUB 6000	\! MAKE THE MOVE ON THE BOARD
	REM SAVE EVERYTHING AND DO RECURSIVE LOOKAHEAD
	REM PUSH ALL THE STUFF WE NEED TO SAVE ON THE STACK
	STACKBESTMOVE[LEVEL]=CURBESTMOVE
	STACKBESTSCORE[LEVEL]=CURBESTSCORE
	STACKSOURCEPIECE[LEVEL]=NEWSOURCEPIECE
	STACKTARGETPIECE[LEVEL]=NEWTARGETPIECE
	STACKBESTONEMOBILITY[LEVEL]=CURBESTONEMOBILITY

	LEVEL=LEVEL+1
	REM SWITCH OUR ATTENTION TO OTHER PLAYER BY SWAPPING SIDES
	CURSCORE=NEWSCORE
	CURROWFROM=NEWROWFROM
	CURCOLFROM=NEWCOLFROM
	CURROWTO=NEWROWTO
	CURCOLTO=NEWCOLTO
	CURMACHCASTLED=NEWMACHCASTLED
	CURMOVEBASE=MOVELIST
	GOSUB 5000	\! SWITCH PIECE COLORS
	GOSUB 7000	\! REM DO RECURSIVE CALL TO COMPUTE BEST MOVE
	GOSUB 5000	\! SWITCH PIECE COLORS BACK AGAIN
	NEWSCORE=TWODEADHEAT-CURBESTSCORE	\! THIS IS THE RESULT OF THE EVALUATION
	LET ONEMOBILITY=CURMOBILITY\ REM BECAUSE WE WENT UP TREE ONE PLY!
	REM NOW UNSTACK ALL THE STUFF!
	LEVEL=LEVEL-1	\! POP THE LOOKAHEAD STACK
	CURMOVEBASE=STACKMOVEBASE[LEVEL]
	CURBESTMOVE=STACKBESTMOVE[LEVEL]
	CURBESTSCORE=STACKBESTSCORE[LEVEL]
	NEWSOURCEPIECE=STACKSOURCEPIECE[LEVEL]
	NEWTARGETPIECE=STACKTARGETPIECE[LEVEL]
	CURMACHCASTLED=STACKMACHCASTLED[LEVEL]
	CURSCORE=TWODEADHEAT-STACKSCORE[LEVEL]
	CURBESTONEMOBILITY=STACKBESTONEMOBILITY[LEVEL]
	IF CURSCORE<>NEWSCORE
	THEN IF NEWSCORE>CURSCORE
	     THEN LET NEWSCORE=NEWSCORE-TREEDEPTHPENALTY
	     ELSE LET NEWSCORE=NEWSCORE+TREEDEPTHPENALTY
	GOSUB 6500	\! UNMAKE THE MOVE
	REM COULD ALSO MOVE PIECE THAT COVERS MAX DISTANCE TOWARDS KING
	REM OR MOVE SMALLEST PIECE THAT MOVES TOWARDS KING
7100	REM 1) MAXIMIZE SCORE (DONE BY SUBROUTINE 8000)
	REM 2) MINIMIZE PLY 1 MOBILITY
	REM 3) CHOOSE MOVE THAT BRINGS PIECE CLOSEST TO ENEMY KING
	IF NEWSCORE>CURBESTSCORE...
&	    OR NEWSCORE=CURBESTSCORE AND...
&		( ONEMOBILITY < CURBESTONEMOBILITY OR...
&		ONEMOBILITY=CURBESTONEMOBILITY AND LEVEL=1 ...
&		AND (INT(ABS(KINGROW-POSSTARGETROW$[MOVELIST]))+INT(ABS(KINGCOLUMN-POSSTARGETCOL$[MOVELIST])))*8 ...
&		    +BOARD[POSSSOURCEROW$[MOVELIST],POSSSOURCECOL$[MOVELIST]] <...
&			(INT(ABS(KINGROW-POSSTARGETROW$(CURBESTMOVE)))+...
&			INT(ABS(KINGCOLUMN-POSSTARGETCOL$(CURBESTMOVE))))*8 ...
&			+BOARD[POSSSOURCEROW$(CURBESTMOVE),POSSSOURCECOL$(CURBESTMOVE)] )
	THEN IF CURBESTMOVE<>0 
	     THEN POSSLINK[CURBESTMOVE]=POSSFREE\
		  POSSFREE=CURBESTMOVE FI\
	     CURBESTMOVE=MOVELIST\CURBESTSCORE=NEWSCORE\CURBESTONEMOBILITY=ONEMOBILITY\
	     IF LEVEL>=2 AND TWODEADHEAT-CURBESTSCORE<STACKBESTSCORE[LEVEL-1]
	     THEN LET INSERT=MOVELIST\
		  WHILE POSSLINK[INSERT]<>CURMOVEBASE DO INSERT=POSSLINK[INSERT] END\
		  LET POSSLINK[INSERT]=POSSFREE\
		  LET POSSFREE=MOVELIST\
		  MOVELIST=CURMOVEBASE\
		  CURMACHCASTLED=STACKMACHCASTLED[LEVEL]\
		  CUROPPCASTLED=STACKOPPCASTLED[LEVEL]\
		  CURMOBILITY=STACKMOBILITY[LEVEL]\
		  RETURN
	     ELSE MOVELIST=POSSLINK[MOVELIST]
	ELSE INSERT=MOVELIST\
	     MOVELIST=POSSLINK[MOVELIST]\
	     POSSLINK[INSERT]=POSSFREE\
	     POSSFREE=INSERT
	GOTO 7010

8000	REM **** GENERATE LIST OF ALL POSSIBLE MOVES ****
	LET ANALYSISCOUNT=ANALYSISCOUNT+1	\! COUNT # TIMES THRU HERE
	CURMOBILITY=0	\! NUMBER OF MOVES AVAILABLE
	FOR ROW=ONE TO EIGHT
		FOR COLUMN=ONE TO EIGHT
			ON BOARD[ROW,COLUMN] GOSUB 8100,8200,8300,8400,8500,8600
		NEXT COLUMN
	NEXT ROW
	RETURN

8100	REM DO PAWN MOVE
	ROWTO=ROW+1
	REM WAS LAST MOVE EN PASSANT ?
	IF ROW=FIVE AND CURROWTO=FIVE AND CURROWFROM=SEVEN ...
&		AND BOARD[CURROWTO,CURCOLTO]=OPPONENT!PAWN...
&		AND ( COLUMN=CURCOLTO-1 OR COLUMN=CURCOLTO+1 )
	THEN COLTO=CURCOLFROM\
	     POSSCORE=CURSCORE+PAWNSCORE\
	     GOSUB 8950\! RECORD THE EN PASSANT CAPTURE AS A POSSIBILITY
	REM TRY PAWN CAPTURE
	IF OPPONENTQ&BOARD(ROWTO,COLUMN-1)<>0
	THEN COLTO=COLUMN-1\POSSCORE=CURSCORE+SCOREPIECE[BOARD[ROWTO,COLTO]]\GOSUB 8920
	IF OPPONENTQ&BOARD(ROWTO,COLUMN+1)<>0
	THEN COLTO=COLUMN+1\POSSCORE=CURSCORE+SCOREPIECE[BOARD[ROWTO,COLTO]]\GOSUB 8920
	REM TRY STRAIGHT FORWARD
	IF BOARD(ROWTO,COLUMN)=EMPTY
	THEN COLTO=COLUMN\
	     POSSCORE=CURSCORE+ADVANCEPAWNSCORE\
	     GOSUB 8920\
	     IF ROW=TWO AND BOARD(FOUR,COLTO)=EMPTY THEN ROWTO=FOUR\GOSUB 8950
	RETURN

8200	REM DO KNIGHT MOVE
	FOR I=1 TO 15 STEP 2
		LET ROWTO=ROW+KNIGHTMOVE$(I)-CHEAT
		LET COLTO=COLUMN+KNIGHTMOVE$(I+1)-CHEAT
		IF BOARD(ROWTO,COLTO)=EMPTY
		THEN GOSUB 8900
		ELSE IF OPPONENTQ&BOARD(ROWTO,COLTO)<>0
		     THEN POSSCORE=CURSCORE+SCOREPIECE[BOARD[ROWTO,COLTO]]\GOSUB 8950
	NEXT I
	RETURN

8300	REM DO BISHOP MOVE
	FOR I=1 TO 7 STEP 2
		LET ROWTO=ROW
		LET COLTO=COLUMN
		FOR J=1 TO 7
			REM J IS DISTANCE MOVED
			LET ROWTO=ROWTO+BISHOPROOKMOVE$(I)-CHEAT
			LET COLTO=COLTO+BISHOPROOKMOVE$(I+1)-CHEAT
			IF BOARD[ROWTO,COLTO]<>EMPTY
			THEN
				IF OPPONENTQ&BOARD[ROWTO,COLTO]<>0
				THEN
					POSSCORE=CURSCORE+SCOREPIECE[BOARD[ROWTO,COLTO]]
					GOSUB 8950
				FI
				CYCLE I
			ELSE	GOSUB 8900
		NEXT J
	NEXT I
	RETURN

8400	REM DO ROOK MOVE
	FOR I=9 TO 15 STEP 2
		LET ROWTO=ROW
		LET COLTO=COLUMN
		FOR J=1 TO 7
			REM J IS DISTANCE MOVED
			LET ROWTO=ROWTO+BISHOPROOKMOVE$(I)-CHEAT
			LET COLTO=COLTO+BISHOPROOKMOVE$(I+1)-CHEAT
			IF BOARD[ROWTO,COLTO]<>EMPTY
			THEN
				IF OPPONENTQ&BOARD[ROWTO,COLTO]<>0
				THEN
					POSSCORE=CURSCORE+SCOREPIECE[BOARD[ROWTO,COLTO]]
					GOSUB 8950
				FI
				CYCLE I
			ELSE	GOSUB 8900
		NEXT J
	NEXT I
	RETURN

8500	REM DO QUEEN MOVE
	FOR I=1 TO 15 STEP 2
		LET ROWTO=ROW
		LET COLTO=COLUMN
		FOR J=1 TO 7
			REM J IS DISTANCE MOVED
			LET ROWTO=ROWTO+BISHOPROOKMOVE$(I)-CHEAT
			LET COLTO=COLTO+BISHOPROOKMOVE$(I+1)-CHEAT
			IF BOARD[ROWTO,COLTO]<>EMPTY
			THEN
				IF OPPONENTQ&BOARD[ROWTO,COLTO]<>0
				THEN
					POSSCORE=CURSCORE+SCOREPIECE[BOARD[ROWTO,COLTO]]
					GOSUB 8950
				FI
				CYCLE I
			ELSE	GOSUB 8900
		NEXT J
	NEXT I
	RETURN

8600	REM DO KING MOVE
	FOR I=1 TO 15 STEP 2
		LET ROWTO=ROW+BISHOPROOKMOVE$(I)-CHEAT
		LET COLTO=COLUMN+BISHOPROOKMOVE$(I+1)-CHEAT
		IF BOARD[ROWTO,COLTO]=EMPTY
		THEN GOSUB 8900
		ELSE IF OPPONENTQ&BOARD[ROWTO,COLTO]<>0
		     THEN POSSCORE=CURSCORE+SCOREPIECE[BOARD[ROWTO,COLTO]]\GOSUB 8950
	NEXT I
	REM TRY TO CASTLE
	REM NOTE: THIS DOESN'T DETECT CASTLING THRU CHECK !!
	IF CURMACHCASTLED=TRUE THEN RETURN
	REM CHECK CASTLE TO LEFT
	IF BOARD(ONE,ONE)=ROOK AND BOARD(ONE,TWO)=EMPTY AND BOARD(ONE,THREE)=EMPTY...
&		AND ( BOARD(ONE,FOUR)=KING OR BOARD(ONE,FOUR)=EMPTY AND BOARD(ONE,FIVE)=KING )
	THEN ROWTO=ONE\COLTO=COLUMN-2\POSSCORE=CURSCORE+CASTLESCORE\GOSUB 8950
	IF BOARD(ONE,EIGHT)=ROOK AND BOARD(ONE,SEVEN)=EMPTY AND BOARD(ONE,SIX)=EMPTY...
&		AND ( BOARD(ONE,FIVE)=KING OR BOARD(ONE,FIVE)=EMPTY AND BOARD(ONE,FOUR)=KING )
	THEN ROWTO=ONE\COLTO=COLUMN+2\POSSCORE=CURSCORE+CASTLESCORE\GOSUB 8950
	RETURN

8920	REM RECORD POSSIBLE MOVE WITH PAWN QUEENING
	IF ROWTO=EIGHT THEN POSSCORE=POSSCORE+QUEENSCORE-PAWNSCORE
	GOTO 8950

8900	REM RECORD POSSIBLE MOVE
	POSSCORE=CURSCORE
8950	REM RECORD POSSIBLE MOVE WITH POSSIBLE SCORE
	REM INSERT IN LIST ACCORDING TO:
	REM 1) VALUE OF POSSCORE (DECREASING)
	REM 2) VALUE OF PIECE MOVED (INCREASING) (NOT IMPLEMENTED)
	REM 3) DISTANCE TO ENEMY KING (? - NOT IMPLEMENTED)
	CURMOBILITY=CURMOBILITY+1	\! COUNT THE MOVE WHETHER WE RECORD IT OR NOT
	REM THROW AWAY NON-CAPTURES ONCE WE EXCEED THE MINIMUM LOOKAHEAD
	IF LEVEL>MINLEVEL AND POSSCORE-CURSCORE<PAWNSCORE...
&	AND MOVELIST<>CURMOVEBASE THEN RETURN
	NEWNODE=POSSFREE
	POSSFREE=POSSLINK[NEWNODE]
	POSSSOURCEROW$[NEWNODE]=ROW
	POSSSOURCECOL$[NEWNODE]=COLUMN
	POSSTARGETROW$[NEWNODE]=ROWTO
	POSSTARGETCOL$[NEWNODE]=COLTO
	POSSSCORE[NEWNODE]=POSSCORE
	LET INSERT=MOVELIST
	LET PREVIOUS=0
	WHILE INSERT<>CURMOVEBASE AND POSSCORE < POSSSCORE[INSERT] DO
		PREVIOUS=INSERT\
		INSERT=POSSLINK[PREVIOUS]
	END
	POSSLINK[NEWNODE]=INSERT
	IF PREVIOUS=0 THEN MOVELIST=NEWNODE ELSE POSSLINK[PREVIOUS]=NEWNODE
	IF POSSFREE=0 THEN PRINT "TRUNCATED 8000"\ GOSUB POP 2
	RETURN

9000	REM **** PRINT BOARD ****
	FOR ROW=ONE TO EIGHT
		FOR COLUMN=ONE TO EIGHT
			IF OLDBOARD(ROW,COLUMN)<>BOARD(ROW,COLUMN)
			THEN GOSUB 9100\ LET OLDBOARD(ROW,COLUMN)=BOARD(ROW,COLUMN)
		NEXT COLUMN
	NEXT ROW
	WRITE #0, LINE4$
	PRINT "SCORE: "; (CURSCORE-DEADHEAT)/PAWNSCORE
	WRITE #0, LINE5$
	PRINT "EXPECTED SCORE : ";(CURBESTSCORE-DEADHEAT)/PAWNSCORE
	WRITE #0, LINE6$
	PRINT "BOARD ANALYSES: ";ANALYSISCOUNT
	WRITE #0, LINE7$
	PRINT "CLOCK TIME: "; TOTALANALYSIS
	RETURN

9100	REM OLDBOARD IS DIFFERENT THAN CURRENT BOARD, UPDATE
	LET TEMP=OLDBOARD(ROW,COLUMN)
	GOSUB 9200	\! REM DRAW THE PIECE ON TOP OF ITSELF
	LET TEMP=BOARD(ROW,COLUMN)
	GOSUB 9200	\! REM DRAW IN THE NEW PIECE
	RETURN

9200	REM DRAW PIECE "TEMP" AT (ROW,COLUMN) ON SCREEN
	WRITE #0, MOVETO$
	PRINT 259+30*(COLUMN-ONE);239-30*(ROW-ONE)
	ON TEMP XOR ( ( (HUMANCOLOR$[1]&1) XOR ( ( COLUMN XOR ROW ) & 1 ) ) ** 3 ) ...
&	GOSUB 9210, 9220, 9230, 9240, 9250, 9260, 9270,...
&		9270, 9290, 9300, 9310, 9320, 9330, 9340
9270	RETURN
9210	WRITE #0, HOLLOWPAWN$\RETURN
9220	WRITE #0, HOLLOWKNIGHT$\RETURN
9230	WRITE #0, HOLLOWBISHOP$\RETURN
9240	WRITE #0, HOLLOWROOK$\RETURN
9250	WRITE #0, HOLLOWQUEEN$\RETURN
9260	WRITE #0, HOLLOWKING$\RETURN
9290	WRITE #0, SOLIDPAWN$\RETURN
9300	WRITE #0, SOLIDKNIGHT$\RETURN
9310	WRITE #0, SOLIDBISHOP$\RETURN
9320	WRITE #0, SOLIDROOK$\RETURN
9330	WRITE #0, SOLIDQUEEN$\RETURN
9340	WRITE #0, SOLIDKING$\RETURN

	END
