*	L I F E -- FOR THE GRAPHBOX
*	RUNS CONTINUOUS SIMULATION OF "LIFE" AS DEFINED BY JOHN CONWAY
*	ON THE 256 X 512 GRAPHBOX SCREEN
*
SCREENTOP	EQU	$BFFF
ROWCOUNTER	RMB	1
NEXTROWBYTE	RMB	1
NEXTSCREENBYTEPOINTER	RMB	2
RESULTBYTE	RMB	1
ROWBYTECOUNTER	RMB	1
THISROWBYTE	RMB	1
PREVROWBYTE	RMB	1
TABLEPTR	FDB	LIFETABLE
PREVROWBYTEPOINTER	RMB	2
PREVROWBUFFER	RMB	64
STACK	RMB	30
STACKBASE	EQU	*-1
	PAGE
	ORG	$100
START	EQU	*	INITZ DOWN AND LEFT SHIFT PIAS
	LDS	#STACKBASE
	CLR	$FFE9	DOWNSHIFTPIA
	LDAA	#$FF
	STAA	$FFE8
	LDAB	#$3F
	STAB	$FFE9
	STAA	$FFE8
	CLR	$FFEB	LEFTSHIFTPIA
	STAA	$FFEA
	LDAA	#$3C
	STAA	$FFEB
	LDAA	#$D8
	STAA	$FFEA
	PAGE
LIFE	LDX	#SCREENTOP-64	POINTER TO 1ST BYTE TO PROCESS
	STX	NEXTSCREENBYTEPOINTER
DOFIRSTROW	EQU	*
	LDX	#PREVROWBUFFER+63	CLEAR OUT PREVIOUS ROW (TO DEATH)
	LDAA	#64
DOFIRSTROWL	EQU	*
	CLR	0,X
	DEX
	DECA
	BNE	DOFIRSTROWL
	LDAA	#255	SET UP COUNTER TO PROCESS FIRST 255 ROWS
	STAA	ROWCOUNTER
DOROW	EQU	*
	LDX	#PREVROWBUFFER+63
	STX	PREVROWBYTEPOINTER
	LDAA	#64
	STAA	ROWBYTECOUNTER
DOFIRSTBYTEOFROW	EQU	*
	JSR	GETNEXTROWBYTE
	CLRB			SET UP (B)
	LSR	PREVROWBYTE	SKIP FIRST GENERATED BIT...
	ROLB			ITS OFF THE EDGE OF THE SCREEN
	LSR	THISROWBYTE
	ROLB
	LSR	NEXTROWBYTE
	ROLB
DONEXTROWBYTE	EQU	*
	JSR	DO7BITS		ONLY 7 DATA BITS LEFT, CAN ONLY GENERATE 7 VALID LIFE BITS
	DEC	ROWBYTECOUNTER
	BEQ	FINISHLASTBYTEOFROW
	JSR	GETNEXTROWBYTE
	JSR	DO1BIT		COMPLETING A FULL BYTE
	JSR	STORERESULTBYTE
	JMP	DONEXTROWBYTE

FINISHLASTBYTEOFROW	EQU	*	LEAVE PREVROWBYTE, THISROWBYTE, AND NEXTROWBYTE = 0 (DEATH)
	JSR	DO1BIT		WHICH FINISHES LAST BYTE
	JSR	STORELASTROWBYTE
	DEC	ROWCOUNTER
	BNE	DOROW
DOLASTROW	EQU	*
	LDX	#PREVROWBUFFER+63
	STX	PREVROWBYTEPOINTER
	LDAA	#64
	STAA	ROWBYTECOUNTER
DOFIRSTBYTEOFLASTROW	EQU	*
	JSR	GETNEXTROWBYTE
	CLRB			SET UP (B)
	LSR	PREVROWBYTE	SKIP FIRST GENERATED BIT...
	ROLB			ITS OFF THE EDGE OF THE SCREEN
	LSR	THISROWBYTE
	ROLB
	CLR	NEXTROWBYTE
	ROLB
DOLASTROWNEXTROWBYTE	EQU	*
	JSR	DO7BITS		ONLY 7 DATA BITS LEFT, CAN ONLY GENERATE 7 VALID LIFE BITS
	DEC	ROWBYTECOUNTER
	BEQ	FINISHLASTSCREENBYTE
	JSR	GETNEXTROWBYTE
	JSR	DO1BIT		COMPLETING A FULL BYTE
	JSR	STORERESULTBYTE
	JMP	DOLASTROWNEXTROWBYTE

FINISHLASTSCREENBYTE	EQU	*	LEAVE PREVROWBYTE, THISROWBYTE, AND NEXTROWBYTE = 0 (DEATH)
	JSR	DO1BIT		WHICH FINISHES LAST BYTE
	JSR	STORELASTROWBYTE
	JMP	LIFE
	PAGE
GETNEXTROWBYTE	EQU	*
	LDX	NEXTSCREENBYTEPOINTER
	LDAA	0,X
	STAA	NEXTROWBYTE
	LDAA	64,X
	STAA	THISROWBYTE
	DEX
	STX	NEXTSCREENBYTEPOINTER
	LDX	PREVROWBYTEPOINTER
	LDAA	0,X
	STAA	PREVROWBYTE
	LDAA	THISROWBYTE	SET UP PREVROW FOR NEXT SCAN
	STAA	0,X
	DEX
	STX	PREVROWBYTEPOINTER
	RTS

STORERESULTBYTE	EQU	*
	LDAA	RESULTBYTE
	LDX	NEXTSCREENBYTEPOINTER
	STAA	64+2,X		THE "1" OFFSETS THE "DEX" ALREADY DONE
	RTS

STORELASTROWBYTE	EQU	*
	LDAA	RESULTBYTE
	LDX	NEXTSCREENBYTEPOINTER
	STAA	64+1,X		THE "1" OFFSETS THE "DEX" ALREADY DONE
	RTS
	PAGE
*	DO7BITS -- PROCESS PREVROWBYTE, THISROWBYTE, NEXTROWBYTE TO GENERATE NEW LIFE PATTERN
*	PREVROWBYTE CONTAINS: . . . . . C B A (AS A BIT PATTERN)
*	THISROWBYTE CONTAINS: . . . . . E S D
*	NEXTROWBYTE CONTAINS: . . . . . H G F
*	AT THE END OF EACH "LSR,ROLB" SEQUENCE,
*	CARRY CONTAINS: A
*	(B)   CONTAINS: D F B S G C E H
*	(B) AND CARRY BIT ARE USED TO LOOK INTO TABLE
*	TO GET NEW LIFE CELL
*	TABLE FORMAT:
*		X......Y
*	X IS USED IF CARRY IS ON; Y IS USED IF CARRY IS OFF
*	X OR Y = 1 --> LIFE; =0 --> DEATH
*	TABLE CONTAINS 256 ENTRIES
*
*	PROCESSES 7 BITS, THEN RETURNS
*	RESULT BYTE IS RESULTBYTE
DO7BITS	EQU	*
	LDAA	PREVROWBYTE
	ORAA	THISROWBYTE
	ORAA	NEXTROWBYTE
	ABA
	BNE	DO7BITS1
	BCS	DO7BITS1
	STAA	RESULTBYTE	ALL INPUT BITS ZERO...
	RTS

DO7BITS1	EQU	*
	LSR	PREVROWBYTE
	ROLB
	LSR	THISROWBYTE
	ROLB
	LSR	NEXTROWBYTE
	ROLB
	BCS	MSB1:1
MSB1:0	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	RORA
	JMP	MSB1
MSB1:1	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	ROLA
MSB1	ROR	RESULTBYTE

	LSR	PREVROWBYTE
	ROLB
	LSR	THISROWBYTE
	ROLB
	LSR	NEXTROWBYTE
	ROLB
	BCS	MSB2:1
MSB2:0	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	RORA
	JMP	MSB2
MSB2:1	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	ROLA
MSB2	ROR	RESULTBYTE

	LSR	PREVROWBYTE
	ROLB
	LSR	THISROWBYTE
	ROLB
	LSR	NEXTROWBYTE
	ROLB
	BCS	MSB3:1
MSB3:0	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	RORA
	JMP	MSB3
MSB3:1	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	ROLA
MSB3	ROR	RESULTBYTE

	LSR	PREVROWBYTE
	ROLB
	LSR	THISROWBYTE
	ROLB
	LSR	NEXTROWBYTE
	ROLB
	BCS	MSB4:1
MSB4:0	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	RORA
	JMP	MSB4
MSB4:1	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	ROLA
MSB4	ROR	RESULTBYTE

	LSR	PREVROWBYTE
	ROLB
	LSR	THISROWBYTE
	ROLB
	LSR	NEXTROWBYTE
	ROLB
	BCS	MSB5:1
MSB5:0	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	RORA
	JMP	MSB5
MSB5:1	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	ROLA
MSB5	ROR	RESULTBYTE

	LSR	PREVROWBYTE
	ROLB
	LSR	THISROWBYTE
	ROLB
	LSR	NEXTROWBYTE
	ROLB
	BCS	MSB6:1
MSB6:0	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	RORA
	JMP	MSB6
MSB6:1	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	ROLA
MSB6	ROR	RESULTBYTE

	LSR	PREVROWBYTE
	ROLB
	LSR	THISROWBYTE
	ROLB
	LSR	NEXTROWBYTE
	ROLB
	BCS	MSB7:1
MSB7:0	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	RORA
	JMP	MSB7
MSB7:1	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	ROLA
MSB7	ROR	RESULTBYTE
	RTS
	PAGE
*
*	DO1BIT -- LIKE DO7BITS, BUT DOES ONLY ONE BIT
*
DO1BIT	EQU	*
	LSR	PREVROWBYTE
	ROLB
	LSR	THISROWBYTE
	ROLB
	LSR	NEXTROWBYTE
	ROLB
	BCC	MSB0:0
	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	ROLA
	ROR	RESULTBYTE
	RTS
MSB0:0	STAB	TABLEPTR+1
	LDX	TABLEPTR
	LDAA	0,X
	RORA
	ROR	RESULTBYTE
	RTS
	PAGE
	ORG	*//256*256
LIFETABLE	EQU	*
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 128
	FCB	 0
	FCB	 128
	FCB	 128
	FCB	 1
	FCB	 0
	FCB	 128
	FCB	 128
	FCB	 1
	FCB	 128
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 128
	FCB	 128
	FCB	 129
	FCB	 128
	FCB	 129
	FCB	 129
	FCB	 1
	FCB	 128
	FCB	 129
	FCB	 129
	FCB	 1
	FCB	 129
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 128
	FCB	 128
	FCB	 1
	FCB	 128
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 128
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 128
	FCB	 129
	FCB	 129
	FCB	 1
	FCB	 129
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 129
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 128
	FCB	 128
	FCB	 1
	FCB	 128
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 128
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 128
	FCB	 129
	FCB	 129
	FCB	 1
	FCB	 129
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 129
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 128
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 129
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 128
	FCB	 128
	FCB	 1
	FCB	 128
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 128
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 128
	FCB	 129
	FCB	 129
	FCB	 1
	FCB	 129
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 129
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 128
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 129
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 128
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 129
	FCB	 1
	FCB	 1
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 1
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	FCB	 0
	END
