DISK DRIVERS
.sp
The operations required of a disk driver in the I/O
package are "do sector I/O (read/write/verify)", "commit to drive
technology", and "check for write protected".  There are also several
support routines that must be implemented.
.sp
Here we give an overview of the operation of the disk driver.
The driver performs only single sector read, write or verify operations at
SDOS's request, and signals success or failure on completion.
SDOS will issue a request by passing an RDSI (Resident Disk Sector Info)
block to DRIVER:DISKIO; the RDSI block specifies the type of request
desired.  The driver processes the request, and when complete, writes an
error code (if needed) into the RDSI (SDOS marks the RDSI as "no error"
before handing it to the driver.)  SDOS will eventually issue a
DRIVER:DISKWAITDONE request to wait for completion of the sector I/O; at
no time will SDOS issue a second I/O request to the driver without waiting
for the first to complete.  The driver makes only one attempt to perform
the I/O for each call by SDOS; if the attempt fails, it is SDOS's
responsibility is issue a new request (SDOS will try a finite number of
times before giving up).  By dividing the I/O requests up in this fashion,
it is possible for SDOS to issue multiple sequential writes from the disk
buffer pool, followed by multiple sequential verifies of the sectors just
written, minimizing the time to write data to floppy disk class devices. 
Single sector I/O also simplifies construction of the driver,
at the expense of being able to read continuously from the disk, which is
only useful when loading programs or copying large files.
Because SDOS has access to the physical cylinder number of a sector (in
the RDSI), it can ensure efficient buffer dumping by writing all dirty
sectors in a cylinder to a disk at once.
.sp
It's strategy is to follow the LRU chain of sectors in the disk buffer
pool until a sector is found which is not modified, comes from a different
disk, or whose RDSI:cylinder doesn't match the last one dumped.
.sp
A verify operation only causes verification that the sector buffer contents
arrived at the disk correctly, and is issued by SDOS only after a successful
write of that sector.  Successful completion should cause the RDSI to be
marked I/O completed, no error.  Unsuccessful verification should cause the
RDSI to be marked as completed with disk write error.  This will cause SDOS
to requeue the sector later for another write attempt.
.sp
To maximize the ability of the disk driver to read/write logically
sequential sectors, a MapAlgorithm is used to specify latency and spiral
tuning parameters.  This MapAlgorithm affects the logical sector number to
physical sector number mapping performed by the driver.  To minimize the
computation time required to perform "mapping", SDOS calls a special driver
entry point whenever the MapAlgorithm is changed, so that as much of the
mapping process can be precomputed as possible.  SDOS also calls the driver
to convert an LSN to its physical form when a sector is first read; because
the driver can store the results of the mapping in the RDSI for the sector,
the mapping process is unnecessary on a write or verify of that same sector
if it is later updated (for sectors which have never been read, but are
updated, SDOS also calls the mapping routine).
.sp
Application programs can read/write arbitrary format disks by using
CC:PHYSICALIO, which allows specification of all the physical parameters
necessary for the driver to fetch an arbitrary sector from a disk.
This operation uses a buffer supplied by the user as source/target.
.sp
Error statistics are kept by the driver as to how many read/write/seek
errors occur, the hardware status that accompanied the error, the last
erroring LSN and the total operation count, so that SC:GETERRORSTATS can
report statistics to a user.  The driver need only update the current
statistics; they are reset by SDOS when reported.
.sp
Write protect checking is accomplished by a special entry point to the
driver.  SDOS uses this check to ensure that users do not write on
write protected disks.
.sp
Start-up (DRIVER:SELECTTECHNOLOGY) and clean-up operations (CC:DISMOUNT)
allow the driver an opportunity to chose the appropriate physical parameters
for the type of disk inserted currently in a drive, and to perform disk door
locking and unlocking as necessary.
.sp
There is a CC:MOUNT operation, but it is handled entirely by SDOS and need
not concern the driver.  Typically, CC:MOUNT occurs immediately after
DRIVER:SELECTTECHNOLOGY is called.
.sp
Other, non-standard disk operations may be implemented via the
DRIVER:CONTROL and DRIVER:STATUS entry points as desired.
.pa
This section describes the disk driver entry points in detail.
.sp
Error handling and propogation for all routines is according to the standard
SDOS conventions.
.sp
DRIVER:DISKRESET (text from manual)
.sp
DRIVER:DISKSELECTTECHNOLOGY is called by SDOS when it discovers DSKINFO:NBPS
is zero, and it needs to perform I/O to the drive (SDOS zeros DSKINFO:NBPS
when CC:DISMOUNT is requested by a user program).   This routine must
determine the technology of the disk platter currently in the disk drive,
set DSKINFO:NBPS, DSKINFO:NSPT, DSKINFO:NTPC, DSKINFO:NCYL,
DSKINFO:READRETRYCOUNT, and DSKINFO:WRITERETRYCOUNT to appropriate values.
This allows a driver to handle a drive which can deal with different
technology/capacity/format disk platters, such as single/double density
floppies, etc.  It is expected that a driver will have one or two preferred
technologies to select from; how it performs the selection is driver
dependent, although it should do it automatically if at all possible (SDOS
conventions prefer IBM format single-density 8" IBM format double-sided,
single-density first track, double density elsewhere; a driver could
determine how to commit by reading sector 1 on track one in single density
mode; if no error, it could commit to single density; if unreadable, it
could commit to double density). It may return an ERR:DISKNOTREADY instead
of committing to a technology. See CC:SETTECHNOLOGY.
.sp
DRIVER:DISKWRITEPROTECTCHECK is called by SDOS to determine whether a drive
is currently write protected.  It returns ERR:DISKNOTREADY if the disk is
not ready, ERR:DISKWRTPROT if the disk drive electronics indicate the drive
is currently write protected, otherwise it simply returns without error.
This is used by SDOS to check whether a file can safely be created or
updated on a disk.
.sp
DRIVER:DISKSETMAPALGORITHM is called by SDOS immediately after SDOS modifies
DSKINFO:MAPALGORITHM.  This routine should precompute as much of the latency
and spiral tuning computations as possible, and store for use by
DRIVER:DISKLSNTOPSN.
.sp
DRIVER:DISKLSNTOPSN is a routine called by SDOS to cause the disk driver to
convert the LSN in RDSI:LSN to physical cylinder, track, and sector,
according to the current DSKINFO:MAPALGORITHM.  The address of the RDSI is
passed in (X).  Must not return an error.  DRIVER:DISKSETMAPALGORITHM has
already been called and so its precomputed values should already be set up. 
SDOS ensures that only legal LSNs are passed to this routine.
.sp
DRIVER:DISKIOSTART is used to initiate a disk I/O operation on the RDSI
specified by DSKINFO:RDSI.  RDSI:STATE contains a code specifying the
desired operation.   RDSI:SECTOR, RDSI:TRACK, and RDSI:CYLINDER have already
been set by a call to DRIVER:DISKLSNTOPSN.
.sp
DRIVER:DISKIOWAITDONE is used to wait for a disk transfer started by
DISKIOSTART to complete. (text from manual).
.sp
DRIVER:DISKSTATUS (from manual)
.sp
DRIVER:DISKCONTROL (from manual)
.sp
DISKINFO:BADLSN is set by SDOS to RDSI:LSN when SDOS determines it is not
possible to perform sector IO to a sector.  It is reset by SDOS to :FFFFFF
when a CC:DISMOUNT is issued by a userprogram.
.sp
*****need DISKINFO:errorstats description
.pa
The driver should set a timeout on each physical I/O operation it performs,
not on a set of operations. Driver must detect write protect during write
operation and issue ERR:WRITEPOTRECTED.
.sp
CC:SETTECHNOLOGY is a special call to allow user programs to force the
technology selected when DRIVER:COMMIT is called.  This call is only valid
after a CC:DISMOUNT and before DRIVER:COMMIT is next issued by SDOS. If no
CC:SETTECHNOLOGY call is issued before DRIVER:COMMIT is invoked, the driver
should commit to one of the preferred technologies automatically. If
CC:SETTECHNOLOGY is called before DRIVER:COMMIT, then the technology
selected must be that chosen by the CC:SETTECHNOLOGY call.
.sp
CC:PHYSICALIO specifies density, cylinder, track, sector, sector size
TARGET, I/O OP (R/W,REG), # cylinders total on disk (used to tell driver
whether single or dbl track *******NEEDS WORK
.sp
CC:DISMOUNTDISK unlocks door, clears error stats
.sp
SC:GETERRSTATS done by SDOS; info generated by driver when an I/O operation
fails.   SDOS will automatically zero the error stats when a CC:DISMOUNTDISK
occurs.
.sp
DCB:DONEFLAG is set when RDSI operation is finished. Error code is stored in
both the RDSI and the DCB.  Convenience, not requirement
DRIVER:DISKIOWAITDONE dependent
.sp
DSKINFO:NBPS contains the number of bytes per sector on a drive. This value
can be changed by the driver when DRIVER:SETTECHNOLOGY is called. If
DSKINFO:NBPS is zero, SDOS will call DRIVER:SETTECHNOLOGY before performing
any other I/O operation on the drive.  This field should be zeroed by a
driver on a CC:DISMOUNT if the disk technology can change.
.sp
DSKINFO:DESCRIPTOR is byte containing a description of the disk drive.
Currently, only DISKINFODESCRIPTOR::VERIFYREQUIRED is defined; this bit
indicates that SDOS must issue a verify after a write operation.
.sp
DSKINFO:READRETRYCOUNT contains the number of read/write  attempts SDOS will
make before deciding to give up on a sector transfer.  This value is used to
set RDSI:RETRYCOUNT before the first I/O attempt.
.sp
DSKINFO:DRIVEMOUNTED is a flag managed by SDOS that indicates whether a
drive has committed to a technology, such as density, sector size, etc.
.sp
DISKINFO:WRITEPROTECTED is a flag managed by SDOS that tells SDOS whether
the drive is write protected.  This flag is set to the results obtained from
a DRIVER:WRITEPROTECTCHECK call immediately after a drive is mounted. Fast,
common operations (such as SYSCALL:WRITEx) inspect the flag; if reset, the
write operation proceeds. If set, DRIVER:WRITEPROTECTCHECK is invoked to get
an update on the write protect status; if the drive is truly write
protected, an error is issued, otherwise the write proceeds normally.
Slower, uncommon operations such as SYSCALL:RENAME, and SYSCALL:CREATE
simply always call the driver to determine the drive write protect status.
.pa
RDSI:DISKINFO points to the DCB representing the drive from which the sector
(that this RDSI represents) came.  RDSI:DISKINFO contains zero if SDOS
manufactures a dummy "zeros" sector when working with a sparse file; no disk
driver will ever find this field zero.
.sp
RDSI:LSN holds the 24 bit LSN of the sector that this RDSI represents.
.sp
RDSI:SECTORBASE holds a pointer to a buffer for the content of the sector. 
The buffer is gauranteed to be large enough for the current value of NBPS in
the DCB.
.sp
RDSI:FLINK and RDSI:BLINK are forward and backward links, used by SDOS to
chain the RDSIs together in Least Recently Used order.
.sp
RDSI:REFCOUNT holds the number of references IOCBs to this RDSI that are
currently active inside of SDOS. This field is examined by the SDOS's sector
pool dumping logic.
.sp
RDSI:MODIFIED is zero if the sector contents are unchanged since they were
read; non-zero indicates that the sector contents have changed and must
eventually go back to the disk.
.sp
RDSI:STATE indicates what is currently happening to the RDSI.  A value of
RDSI:RESIDENT indicates that a copy of the sector is currently in the buffer
selected by SECTORBASE, and is being used by SDOS.  RDSI:FREE indicates this
RDSI is not in use at the present time, and contains no valid information.  
RDSI:READING indicates that the sector contents have not yet arrived from
the disk; RDSI:WRITING indicates that the sector contents are being moved to
the disk; and RDSI:VERIFYING indicates that the sector contents have
tentatively been written, and verification of the transfer is pending
(verifies occur only if DISKINFO:DESCRIPTOR indicates verify is required).
.sp
RDSI:CYLINDER holds the physical cylinder number (as determined by
DRIVER:DISKLSNTOPSN).  SDOS never changes this field; DRIVER:DISKLSNTOPSN
must set this field when called.  SDOS uses this field to determine which
sectors in the pool are all in the same cylinder when dumping the pool. 
Drivers dealing with intelligent controllers that are passed only LSNs need
to set this field according to an appropriate dump strategy; a reasonable
choice is to place the top "n" bits of the LSN (for some n) into
RDSI:CYLINDER.  This ensures a dumping strategy which is "cylinder-like".
.sp
RDSI:TRACK holds physical track number corresponding to RDSI:LSN.  It is set
by DRIVER:LSNTOPSN; SDOS never sets this field.
.sp
RDSI:SECTOR holds the physical sector number corresponding to RDSI:LSN.  It
is set by DRIVER:LSNTOPSN; SDOS never changes this field.
.sp
RDSI:ERROR is zeroed by SDOS before entering the driver.  It is set by the
drive if an error occurrs in reading, writing or verifying the sector. When
an error occurs, the driver should set RDSI:DRIVERDATA so it knows how to
try again later.
.sp
RDSI:RETRYCOUNT is used by SDOS to keep track of the number of tries it has
made to perform the I/O specified by RDSI:STATE.  This retry count is set to
DSKINFO:RETRYCOUNT before SDOS issues the first I/O operation of a
particular type, such as read or write (verify is simply a second phase of
write, and gets tried only once per write attempt).  SDOS decrements this
counter each time it issues an I/O request for an RDSI and gets an error; if
the counter goes to zero, the SDOS gives up trying to fetch/write the
sector, issues a suitable error (taken from RDSI:ERROR), and releases the
RDSI for use for some other sector.
.sp
RDSI:DRIVERDATA is space reserved for use by driver for any purpose. It is
typically used to hold information about how the next retry on this sector
should be performed assuming no other intervening disk operations have
occurred.  The driver typically stores a LASTRDSI pointer; if a new I/O
request occurs with an RDSI the same as LASTRDSI and DSKINFO:RETRYCOUNT is
greater than RDSI:RETRYCOUNT, then this field is used to determine how to
perform a retry, otherwise a "first" time try is made to perform the I/O.
.sp
SDOS will not examine or modify the sector buffer contents until after it
has called DRIVER:DISKWAIT.  This transition state allows decryption to take
place. RDSI:VERIFYING indicates the sector needs to be verifed by the
driver.  An error on a verify causes SDOS to change the state to
RDSI:WRITING after decrementing the RDSI:RETRYCOUNT.
.sp
SC:GETERRORSTATS.  Reads back error status stored in DCB by driver. Zeroed
only by CC:DISMOUNTDISK.  Handled entirely by SDOS;  driver will not see
call.  Driver must, however, keep error statistics up to date.
.sp
16 character device names, blank padded no colons
.sp
INSTALL DECRYPTING FILES!!!!
.sp
.im 4
install verify logic
 install contig file stuff
 install lsntopsnstuff
instal rename device
.sp
Try sorting? -- insert on LSN increasing thread
.sp
Writeahead?
.sp
Under SDOS/mt -- defaulted to floppy --- floppy driver suddenly goes not
ready because dummy took disk out--- he got error 1060, dummy realized his
mistake, inserted diskette and got "illlegal LSN" forever (no way out!)
.sp
Wants complete xref on what fields used by who.
.en
