.ce
SDOS Mass LRU Specification
.sp
UNFINISHED
.sp
SDOS/MT systems service up to 8 users on machines that memory
capacities of 1 to 2 megabytes.  Since SDOS's need for memory is limited
to 512Kb, we would like to use the balance of the memory as a massive
LRU cache to enhance disk performance.
.sp
The LRU cache will store sectors of varying size.  Since all sectors are
a power of two, a buddy system space allocator seems quite appropriate;
thus, many more 128 byte sectors can be stored then 4kb sectors from
laser disks.
.sp
With 2Mb and 128 bytes per sector, up to 2^14 sectors could be stored in
the cache.  Each sector requires a descriptor of about 10 bytes to keep
track of the sector content, age, etc., so the cache logic will need to
handle up to 2^14 descriptors.  To keep the address arithmetic simple, we
arbitrarily limit the number of descriptors to 2^16-1.
.sp
Because the SDOS system space is cramped, we cannot afford to place the
descriptor information from the cache in the SDOS system space. We
therefore arbitrarily require the cache itself to store this descriptor
information, as well as the buddy system space allocation information,
and various bits of information required to keep track of the cache.
.sp
The cache maintains a hash table with which to efficiently look up
desired sectors.  The number of hash table slots is cache-specific but is
generally a power of two as the hashing function is usually "take the
bottom N bits of the desired LSN".  From each hash bucket there will be a
BALANCED tree of cache (sector) descriptor block, due to the possibility
of a large number descriptors hanging from a bucket, thus LOG2 search
times of the cache are assured.
.sp
Operations possible on the LRU cache:
.sp
LRUCACHE:FINDSECTOR is given a sector descriptor block by SDOS, and
determines if the desired sector is present in the cache.  If it is, the
sector contents are transferred to the memory location specified by the
sector descriptor, and removed from the cache.  The "dirty" flag from the
cache is transferred to the dirty flag of the SDOS sector descriptor.
.sp
LRUCACHE:STORESECTOR is given a sector descriptor block by SDOS. An error
occurs if the sector is already in the cache (this is a bug). If there is
no room in the cache, an ERR:NOROOM error is returned; SDOS must then
write the sector to the source drive if it is dirty, and then must throw
the sector away.  If room can be found (the usual case), then the sector
contents are taken from the buffer specified by the sector descriptor and
squirreled away, along with the LSN of the sector, its source drive, and
whether or not it is dirty. The cache finds room by locating its oldest
"clean" sector, and releasing that, repeating the process until it has
enough room or there are no more "clean" sectors (a really rare event
with a cache this large).
.sp
LRUCACHE:DELETESECTOR is given a sector descriptor block by SDOS. If the
sector exists in the cache, whether dirty or not, it is immediately
deleted.  This operation allows the operating system to decide it no
longer needs certain disk blocks, and it can save the cache and drivers
time by telling them that those disk blocks are worthless.
.sp
LRUCACHE:FLUSH is given to the cache to cause it to immediately write all
dirty sectors for the specified drive onto that drive. The dirty sectors
are then marked as clean.
.sp
LRUCACHE:DISMOUNT is given to the cache to cause it to remove all sectors
from the specified drive from its list. If there exists a dirty sector,
and error is issued, and the dismount operation is aborted.
.sp
LRUCACHE:OLDEST is given a sector descriptor block for a specific
drive by SDOS, and returns the lowest numbered LSN which is dirty and is
on the same cylinder as the oldest dirty LSN in cache for that drive. If
there is no such LSN, an error is returned.
HOW ABOUT OLDEST DIRTY LSN IN THE DIRECTION THE HEADS ARE MOVING?
.sp
LRUCACHE:NEXT is given a sector descriptor block, and locates the next
dirty sector on the same drive with a larger LSN, but an identical
physical cylinder number. If no such LSN exists, an error is given,
otherwise, the information for the found sector is transferred to the
sector descriptor and the sector contents are transferred to the sector
buffer in SDOS, and the sector is deleted from the cache. It is expected
that the sector will be written back to its proper disk.
.sp

 HOW DO I GET A
CSCAN POLICY? cough up list of dirty sectors on 1st cylinder >=
specified, or <= specified, in LSN increasing order.

There ought to be operations to cause the cache to drink or dump a track/
cylinder if possible.
