WHAT DO WE DO WITH ALL THE COMPUTER'S IDLE TIME ?

Now that personal computers have arrived with a vengeance, what
shall we do with the spare computer cycles that will be left over?
We could just waste them, but that seems like having a massive pile
of slaves and bricks, and not even building a pyramid. Or we
could figure a way to harness all that idle "intellectual" power.

What would be nice would be a serendipitous program. It must have
two goals: 1) To discover new facts, and 2) to make those facts
available to us.

To be successful, such a program needs a lot of built-in intelligence.
First, it should determine a list of possible goals. Then, it should
estimate the probability of success of each goal, and the benefit
thereof. It should then begin work on the goal with the highest
payoff. Periodic re-evaluations should occur to ensure that only a limited
amount of work is expended on non-productive goals. Among listed goals
should be self-improvement goals in all areas outlined above.


Idletime:
Task UserInteraction
    Repeat
        -- Perform next user request
        AskUserAction
        Case UserAction of
            WantsGoalDisplay --> DoGoalDisplay
            WantsResultDisplay --> DoResultDisplay
            WantstoAddGoal --> AddGoal
            WantstoDeleteGoal --> DeleteGoal
            WantstoAddToGlobalDatabase --> AddtoGlobalDataBase
        EndCase
    EndRepeat
EndTask

Task DoWork
    Repeat
        GenerateNewGoals
        EstimateUtilityofGoals
        EstimateProbabilityOfSuccessofGoals
Trydifferentgoal:
        ChooseGoalwithHighestPayoff
        Case Resultofworkingongoal of
             Success --> Integrate result of goal into GlobalDataBase, program
             Payoffestimatechanged --> Recordresolutionofdifficultyasnewgoal,
                                       Trydifferentgoal
             DemonstrablyImpossible --> Markgoalasimpossible, Trydifferentgoal
        End
End

The program will need a notation for recording goals. Clearly, goals
should be stored in a graph that has the property that if goal A depends
on goal B, there is a path from B to A marked only with directed arcs.
Cycles in the graph are not allowed because they imply a goal which
depends on itself.  Also, goals which generate themselves as a requirement
are likewise dropped as non-productive.

Possible goals:
    Improve notation
        Simplify notation
        Invent new mathematics
    Decrease Execution Time
        Use more efficient algorithm
        Use more efficient data structure
        Code in pop code, or machine code
        Propose more efficient scheme
    Decrease Storage Space
        Use more efficient data structure
        Encode program better
        Improve notation
    Improve goal-generation capability
    Improve estimates of goal utility
    Improve estimate of work to solve goal
    Improve estimate of goal payoff
    Improve method of locating knowledge needed
    Improve planning capability


The system needs a way to determine that making a modification to itself
does not affect its ability to solve classes of problems that it
solved in the past (i.e., it only gets better).  This implies that
it checks that new versions of itself can not only solve some
stored set of problems, but that the new version of itself will
also check even new versions for the same properties (this prevents
the program from making modifications to itself that lose the
"new version test" facility).  Hopefully, the program will learn
that modifying certain parts of itself are done with extreme care,
because most modifications lead simply to "sick" descendents; thus
the program would cease trying to "optimize" out the check.
Such "sacred" portions of the program can be viewed as
critical chromosomes.  Actual "chromosomes" could be implanted
that were checked by CRC or something else the program is unlikely
to break (until it is truly smart enough to diddle with it).

Because the system will operate on a real computer, and the real computer
code is really "part" of the program, the program will need a way
to modify the real computer code.  This implies that whatever (opaque) real
computer code exists must have a (transparent) counterpart coded
in a notation understandable by the program, and there must exist
a "compile" mechanism to convert a transparent notation to an
executable "opaque" notation.  Note that the compiler itself must
also have a transparent version.


The logical model of computation could be LISP, but this seems too
complex.  A threaded interpreter has much simpler built-in semantics.
Consider a threaded-code program (TCP) to be simply a list of atoms.
Each atom in the list represents an action.  Two kinds of actions
exist: primitive (i.e., there exists a chromosome that does it),
and interpreted (i.e., the action is represented by another TCP).
We postulate the existence of a push down stack to keep track
of incarnations.
The minimal actions required are:
     name                              action
     EXECUTE                      A pointer to a TCP is on top
                                  of the runtime stack.  That pointer
                                  is removed, and all actions in the
                                  TCP selected are executed before
                                  the action following the EXECUTE
                                  is performed.
     RETURN_IF_NIL                If TCP_Pointer on TOS has the value NIL,
                                  then control is passed back to the
                                  action following the last incomplete
                                  EXECUTE (pops stack 2 levels!)




Minimal data types:
     Threaded Code Program        An object containing a sequence
                                  of actions to perform.

     Atom                         A symbolic name that can be placed into
                                  a TCP.

     Pointer To Atom              A value, which when dereferenced,
                                  yeilds an Action value.  Such
                                  a pointer can also be advanced,
                                  and it will produce another
                                  Pointer To Action.

     Pointer To TCP               A value, which can be converted
                                  to a Pointer To Action.  This value
                                  can take on the special value NIL,
                                  which cannot be executed.



Definition of EXECUTE:
     EXECUTE_TCP_SELECTED_BY_POINTER_TO_TCP_ON_TOS:
        ( CONVERT_TCP_POINTER_ON_TOS_INTO_ACTION_POINTER
          EXECUTE_ACTIONS_UNTIL_RETURN_ENCOUNTERED
          RETURN)

     CONVERT_TCP_POINTER_ON_TOS_INTO_ACTION_POINTER: primitive???

     EXECUTE_ACTIONS_UNTIL_RETURN_ENCOUNTERED:
        ( ! Entered with TOS pointing to an action
          PUSH_ATOM_FROM_PLACE_SELECTED_BY_POINTER_TO_ATOM_ON_TOS
          REPLACE_ATOM_ON_TOS_WITH_POINTER_TO_TCP_ASSOCIATED_WITH_ATOM
          EXECUTE_TCP_SELECTED_BY_POINTER_TO_TCP_ON_TOS
          ADVANCE_POINTER_TO_ATOM_ON_TOS
          EXECUTE_ACTIONS_UNTIL_RETURN_ENCOUNTERED
          RETURN)

     RETURN:
        ( PUSH_NIL
          RETURN_IF_NIL )


Note this is unlike LISP in the sense that LISP defines the idea of
argument lists and bindings.  This notation does NOT define these
things in the primitives; they can be built (we use the concept of
push-down stack instead as a more primitive idea; note further that a
TCP could be treated as a push-down list, where POP(TCP) produces a
shorter TCB [the unexecuted part] and an atom [to be executed]).  One
expects that an external form would exist (much like conventional
programming languages) that looks very much like LISP, complete with
argument lists and the like; such an external notation would be mapped
by a "compiler" to an internal notation that is functionally identical.

We will probably have to explain the meaning of the primitive operators
by use of abstract data types, i.e.,
REPLACE_ATOM_ON_TOS_WITH_POINTER_TO_TCP_ASSOCIATED_WITH_ATOM
maps the domain of push-down stacks into the range of push-down stacks:
1S -> S
such that if Stack S1 with structure "push(S2,ATOM)" is processed,
the result is "push(S2,ptrtoTCP(ATOM))".


Reliability of the computation seems essential, becuase if the proram
is to operate over long periods of time, it is sure to encounter the
MTBF of the system on which it runs.  This implies some crash-proof
filing scheme, so the program can continue after a crash without
losing a lot of energy.

An interesting question is, how much information does it take to
form an intelligent entity? If we believe people are intelligent
(there is some doubt), then 46 chromosomes * nuclotides * 2 bits/
nucleotide (there are 4 of them) gives us some idea (it is not
clear how much information is hidden in the chromosomal interpreter!).

WHAT ARE THE MINIMUM RESOURCES REQUIRED BY SUCH A PROGRAM?

The program must have something to manipulate, i.e., a well-defined
set of operators, a mechanism for generating bindings of the operators
to a state (producing a set of pairs of [binding,operator] called
an OPERATION), and applying the operations to a state, and a method
of evaluting the new state to determine if it is better than the old.
"Better" implies that a partial ordering exist on states generated
by application of the operations, such that BETTER(x,y)
will occasionally produce TRUE (note that BETTER producing FALSE
does not necessarily imply that BETTER(y,x)!)
To prevent the program from going down completely useless paths
forever, some measure of computational energy must also exist.
We would like to have a generalized measure of resource utilization,
which almost implies the availability of integers.

If the manipulated something is the program itself, there is hope that
the program will improve itself!
