         TITLE *** SDOS I/O drivers for WaveMate Jupiter II (C) 1978 SOFTWARE DYNAMICS ***
**************************************************************************
JUPITERII EQU    1                     THIS I/O PACKAGE IS FOR A JUPITER II!
WAVEMATE EQU   1                       IF'S ON THIS SHOULD BE IF'S ON JUPITERII
*************************************************************************

         TABS  20,28,44,45
         PSR   0                       *** DON'T PRINT ANY SKIPPED RECORDS ***
         NAME  SDOSDRIVERS
         IFUND   M6800
M6800    EQU     1
M6801    EQU     0
M6809    EQU     0
         FIN     M6800

         IF    M6800!M6801
         WITH  LINCLUDE
         FIN

*
*        BY SOFTWARE DYNAMICS
*        AND A CAST OF THOUSANDS!
*
EDITDATE EQU   $1231                   /82 MMDD IN HEX FORMAT
EDITYEAR EQU   $1982
*
*
*********************************************************************
*   I/O PACKAGE STRUCTURE
*   The I/O package is organized in the following fashion:
*
*   Low addresses: !                   !
*                  !  Read-only code,  !
*                  !   tables, etc.    !
*                  !-------------------!
*                  !                   !
*                  !  Interrupt poll   !
*                  !     chains        !
*                  !   (readonly)      !
*                  !                   !
*                  !-------------------!
*                  !                   !
*                  !  Working storage, !
*                  !  DCBs, TCBs, etc. !
*                  !                   !
*                  !-------------------!
*                  !                   !
*                  !    Disk Buffer    !
*                  !       Pool        !
*                  !    I/O Driver     !
*                  !    Reset code     !
*                  !    (once-only)    !
*                  !                   !
*                  !-------------------!
*                  !                   !
*                  !   VT Drivers      !
*                  !      SDOS         !
*                  !     ....          !
*
*        To make this arrangement possible, each I/O package source is
*        organized in the following way:
*              IOxxxxx.DO              is a file containing a configuration
*                                       for machine xxxxx
*              IOxxxxx.DO      is a file containing an I/O package "shell"
*              IOyyyyy.ASM             is a file containing ALL driver-related code
*                                       tables, etc. for the hardware device yyyyyy
*
*        Each I/O package shell uses conditional assembly switches to conditionally
*        INCLUDE IOyyyyy.ASM in a particular configuration.  The IOyyyyy.ASM
*        file is actually INCLUDEd 4 times, once for each of the 4 areas of
*        the I/O package shown above.  The following conditional switches
*        are used by the driver source module to distinguish between areas:
*              IODRIVERBODY            selects the read-only code portion
*              IODRIVERPOLL            selects the Interrupt poll chain portion
*              IODRIVERRAM             selects read/write storage of driver
*              IODRIVERINIT            selects the once-only I/O driver initializing code
*
*        Note: the driver source module should define all equates and (DCB)
*        table displacements when the conditional switch IODRIVERBODY is enabled.

*
*        A Typical shell has the following source form:
*
*        *     SET DEFAULTS
*              IFUND                   xxxx
*              IFUND                   yyyy
*              ...
*        *     BUILD READ-ONLY CODE
*        IODRIVERBODY                  SET 1
*        IODRIVERPOLL                  SET 0
*        IODRIVERRAM                   SET 0
*        IODRIVERINIT                  SET 0
*              IF                      xxxx
*              INCLUDE                 IOxxxx.ASM
*              FIN
*              IF                      yyyy
*              INCLUDE                 IOyyyy.ASM
*              FIN
*              ...
*        PATCHSPACE                    RTP zzzz
*              SWI
*        ***** Build Interrupt Poll Chains
*        IODRIVERBODY                  SET 0
*        IODRIVERPOLL                  SET 1
*              IF                      xxxx Note: order of poll routines may be different than bodies
*              INCLUDE                 IOxxxx.ASM
*              FIN
*              IF                      yyyy
*              INCLUDE                 IOyyyy.ASM
*              FIN
*              ...
*        ***** Build Working Storage
*        IODRIVERPOLL                  SET 0
*        IODRIVERRAM                   SET 1
*              IF                      xxxx
*              INCLUDE                 IOxxxx.ASM
*              FIN
*              IF                      xxxx
*              IF                      yyyy
*              INCLUDE                 IOyyyy.ASM
*              FIN
*              ...
*        ***** Build Driver Reset routines
*        IODRIVERRAM                   SET 0
*        IODRIVERINIT                  SET 1
*              IF                      xxxx
*              INCLUDE                 IOxxxx.ASM
*              FIN
*              IF                      yyyy
*              INCLUDE                 IOyyyy.ASM
*              FIN
*              ...
*        ***** Finish out disk buffer pool, etc
*              ...
*              END
         Page  Jupiter II Hardware Configuration Definitions
*
INICV    EQU   $FC03                   INITIALIZE CONSOLE DEVICE VECTOR
PUTCV    EQU   $FC06                   PUT A CHARACTER TO CONSOLE VECTOR
GETCV    EQU   $FC09                   GET A CHARACTER TO CONSOLE VECTOR
TESTCV   EQU   $FC0C                   TEST FOR ARRIVAL OF CHARACTER FROM CONSOLE
INIDV    EQU   $FC12                   INIT DEFAULT DEVICE (FOR LPT)
PUTDV    EQU   $FC15                   PUT A CHARACTER TO DEFAULT DEVICE VECTOR

SYSPG    EQU   $FE
SYSIIRQ  EQU   $FD


         PAGE  I/O PACKAGE DEFAULT SWITCHES
OUTASPACE      EQU    1  ; USE TRIMMED DEF FILES TO SAVE SYMBOL TABLE SPACE

         IFUND SDOSMT
SDOSMT   EQU   0                       ; DEFAULT IS "NOT SDOS/MT"
         FIN

         IF    SDOSMT
         IFUND MTCRASHINFO
MTCRASHINFO    EQU                     $C000
         FIN
         IFUND IOQUANTUM
IOQUANTUM      EQU                     2
         FIN
         IFUND CPUQUANTUM
CPUQUANTUM     EQU                     60*2
         FIN
         IFUND MTROM
MTROM    EQU   $E400
         FIN
         FIN   SDOSMT
         IFUND MEMSIZE
MEMSIZE  EQU   60                      DEFAULT FOR JUPITER II/6800
         FIN   MEMSIZE

         IFUND DESIREDPOOLSIZE
DESIREDPOOLSIZE EQU   512*10
         FIN

         IFUND NIOCHANNELS
         IF    SDOSMT
NIOCHANNELS    EQU                     64 ALLOCATE ABOUT 8 PER USER
         ELSE
NIOCHANNELS    EQU                     8
         FIN
         FIN   NIOCHANNELS

*
K        EQU   1024                    # BYTES PER "K" OF MEMORY
*
         IF    M6800!M6801
         IFUND CODE
         IF    SDOSMT
CODE     EQU   $5800
         ELSE
CODE     EQU   $8800
         FIN
         FIN   CODE
*
         IFUND SDOS
SDOS     EQU   MEMSIZE*K-$3200
         FIN   SDOS
         IFUND VTDRIVER
VTDRIVER EQU   SDOS-$1800
         FIN
         ELSE  (M6809)

         IFUND CODE
         IF    SDOSMT
CODE     EQU   $5000
         ELSE
CODE     EQU   $7C00
         FIN
         FIN   CODE

         IFUND SDOS
SDOS     EQU   $B200                   FOR SDOS 1.1G FOR '09
         FIN

         IFUND VTDRIVER
VTDRIVER EQU   SDOS-$1880
         FIN

         FIN
*
         IFUND DRIVERBASE
         IF    CODE<<SDOS
DRIVERBASE     EQU                     CODE
         ELSE
DRIVERBASE     EQU                     SDOS-3
         FIN   CODE<<SDOS
         FIN   DRIVERBASE

         IFUND REALTIMECLOCK           "THERE EXISTS A REAL PIECE OF CLOCK HARDWARE"
         IFUND STORAGEDEMON
         IFUND USECONSOLEACIAASCLOCK   "NO REAL CLOCK HARDWARE, SO USE CONSOLE TO FAKE IT"
USECONSOLEACIAASCLOCK                  EQU 1
         FIN   USECONSOLEACIAASCLOCK
         ELSE
         IFUND USECONSOLEACIAASCLOCK
USECONSOLEACIAASCLOCK                  EQU &STORAGEDEMON
         FIN   USECONSOLEACIAASCLOCK
         FIN   STORAGEDEMON
REALTIMECLOCK  EQU                     &USECONSOLEACIAASCLOCK
         FIN   REALTIMECLOCK

TICKSPERSECOND EQU                     60 
         IFUND CLOCK
CLOCK    EQU   1
         FIN
         IF    CLOCK
         IFUND LISTCLOCK
LISTCLOCK      EQU                     1
         FIN
         FIN

         IFUND BLACKHOLE
BLACKHOLE      EQU                     0
         FIN
         IF    BLACKHOLE
         IFUND LISTBLACKHOLE
LISTBLACKHOLE  EQU                     1
         FIN
         FIN

         IFUND SDLP
SDLP     EQU   0
         FIN
         IF    SDLP
         IFUND LISTSDLP
LISTSDLP EQU   1
         FIN
         FIN

         IFUND VIRTUALFLOPPY
VIRTUALFLOPPY  EQU                     0
         FIN   VIRTUALFLOPPY
         IF    VIRTUALFLOPPY
         IFUND LIST.VIRTUALFLOPPY
LIST.VIRTUALFLOPPY EQU  1
         FIN   LISTVIRTUALFLOPPY
         IFUND PERSCI
PERSCI   EQU   0
         FIN   PERSCI
         IFUND DAMFLOPPY
DAMFLOPPY      EQU                     0
         FIN   DAMFLOPPY
         IF    PERSCI
         IFUND WMFORMAT
WMFORMAT EQU   1
         FIN   WMFORMAT
         IFUND IBMFORMAT
IBMFORMAT      EQU                     MEMSIZE>32
         FIN   IBMFORMAT
         FIN   PERSCI
         FIN   VIRTUALFLOPPY
         IFUND WMPERSCI
WMPERSCI EQU   0
         FIN
         IF    WMPERSCI
         IFUND LIST.WMPERSCI
LIST.WMPERSCI  EQU                     LIST.ALL
         FIN   LIST.WMPERSCI
         IFUND NFLOPPIES
NFLOPPIES      EQU                     2
         FIN   NFLOPPIES
         FIN   WMPERSCI
         IFUND WMDAMFLOPPY
WMDAMFLOPPY    EQU                     0
         FIN   WMDAMFLOPPY
         IF    WMDAMFLOPPY
         IF    WMPERSCI
         ?ERROR                        Must use virtual floppy driver for more than one type of floppy
         ELSE
         IFUND LIST.WMDAMFLOPPY
LIST.WMDAMFLOPPY                       EQU LIST.ALL
         FIN   LIST.WMDAMFLOPPY
         IFUND NFLOPPIES
NFLOPPIES      EQU                     2
         FIN   NFLOPPIES
         FIN   WMPERSCI
         FIN   WMDAMFLOPPY

         IFUND STORAGEDEMON
STORAGEDEMON   EQU                     0
         FIN
         IF    STORAGEDEMON
         IFUND LISTSTORAGEDEMON
LISTSTORAGEDEMON                       EQU 1
         FIN
         FIN

         IFUND LISTDEFS
LISTDEFS EQU   0                       DON'T LIST I/O PACKAGE DEFS
         FIN
IOPKDEFS EQU   1                       MAKE SURE WE GET I/O PACKAGE DEFINITIONS
         LIST  LISTDEFS
         IF    OUTASPACE
         INCLUDE JUPITERDEFS.ASM
         ELSE
         INCLUDE SDOS11DEFS.ASM
         FIN
         INCLUDE SDOS11VTDEFS.ASM
         LIST  1
         PAGE
*
*        SDOS-TO-IOPACKAGE COMMUNICATION REGION
*
         ORG   SDOS+1
****     FCB   $10                     SDOS VERSION NUMBER
         FDB   0                       LAST ERROR ENCOUNTERED
         FDB   CNFGTABLE               TELL SDOS WHERE ALL THE GOODIES ARE
         FDB   0                       SERIAL NUMBER
         FDB   0                       IOBLOCKPTR
         FDB   0                       IOCB POINTER (FOR FILE-TYPE DEVICE DRIVERS)
         FCB   0,0,0                   SET CLOCK TO "MIDNITE"
         FCB   0                       DAY, LET COMMAND INTERPRETER KNOW
         FCB   0                       MONTH, THAT THE TIME HASN'T BEEN SET
         FCB   EDITYEAR&$FF            YEAR
*
         ORG   DRIVERBASE
SYSCALLIO      JMP                     SYSCALLIO SDOS SETS JMP ADDR TO ITS ENTRY POINT

        FDB     EDITDATE                RECORD I/O PACKAGE DATE IN OBJECT FILE
        FDB     EDITYEAR

*
*****    READ ONLY CODE SECTION
IODRIVERBODY   SET                     1
IODRIVERPOLL   SET                     0
IODRIVERRAM    SET                     0
IODRIVERINIT   SET                     0

*
NEXTTCB  SET   0                       END OF TCB CHAIN
NEXTTIMEOUT    SET                     0
NEXTDISKDCB    SET                     0
NEXTDEVICEDCB  SET                     0
NTIMEOUTS      SET                     0
NDISKDCBS      SET                     0
INTERRUPTTARGET                        SET SDOS+SDOS:RTI ASSUME CONVENTIONAL INTERRUPT SCHEME
         PAGE  INTERFACE TO IDB
         IF    M6800
DEBUGSYSCALLHANDLER
         DES                           MAKE SPACE FOR X
         DES                           MAKE ROOM FOR INDEX REGISTER
         DES                           MAKE ROOM FOR CONTENTS OF (A)
         DES                           SAVE ACCB
         TPA
         PSHA                          SAVE CC BITS
         JSR   INTDISABLE              TURN OFF INTERRUPTS
DEBUGINTERRUPT ; ^D: CONTEXT BLOCK IS ON TOP OF STACK
         LDX   $FFFC                    ; NMI VECTOR
         JMP   0,X
         ELSE  (M6809)
DEBUGSYSCALLHANDLER                    ; SYSCALL:DEBUG TRANSFERS CONTROL HERE
         PSHS  X,Y,U,DP,A,B,CC         PUSH REMAINING PART OF CONTEXT BLOCK (PC ALREADY PUSHED)
         JSR   INTDISABLE              SHUT OUT THE WORLD
DEBUGINTERRUPT ; ^D: CONTEXT BLOCK IS ON TOP OF STACK
         JMP   [$FFFC]                 FAKE SYSTEM INTO BELIEVING THAT NMI HAS OCCURRED!
         FIN   M6800
         IF    CLOCK
         INCLUDE                       IOCLOCK.ASM
         FIN
         IF    BLACKHOLE
         INCLUDE                       IOBLACKHOLE.ASM
         FIN   BLACKHOLE
         IF    SDLP
         INCLUDE                       IOSDLP.ASM
         FIN   SDLP
         IF    VIRTUALFLOPPY
         INCLUDE                       IOVFD.ASM
         FIN
         IF    STORAGEDEMON
         INCLUDE                       IOSTOREDEMON.ASM
         FIN
         INCLUDE                       IOVTCONFIG.ASM GENERATED BY MAKEVTCONFIG IMMEDIATELY BEFORE ASSY
         INCLUDE                       IOVTDPBS.ASM
         PAGE  CONFIG TABLE
         IFUND INTERRUPTSTACKSIZE
INTERRUPTSTACKSIZE                     EQU MINSTACK+7+7+7+7+7+7+7 7 FOR EACH POSSIBLE
*                                      NESTED INTERRUPT RESULTING FROM A DEVICE
         FIN   INTERRUPTSTACKSIZE
*
CNFGTABLE      FDB                     DISKDCBS DEFAULT DISK MUST BE FIRST
         FDB   TTYDCB                  CONSOLE MUST BE FIRST
         FDB   IOCBPOINTERS
         FCB   NIOCHANNELS
         FDB   DSKBUFFERPOOL
         FDB   DSKPOOLSIZE
         FDB   SDOS+SDOS:VTATTNCHECK
         FDB   DEBUGSYSCALLHANDLER
         FDB   DRIVERBASE
         FDB   INTSETUP
INTDISABLE
         IF    M6800!M6801
         NOP                           INT DISABLE
         FIN
         SEI
         RTS
INTENABLE
         CLI
         RTS
         IF    M6800!M6801
         NOP
         FIN
INTRTI   RTI                           INT RTI
         NOP
         NOP
         FDB   INTERRUPTSTACKEND-1
         FDB   STACKSWITCHEDDEVICEPOLL     ROUTINE TO DETERMINE INTERRUPTING DEVICE
         FDB   TASKQUEUE
         FDB   TIMEOUTQUEUE
         FDB   NEXTDPB
         FDB   DEBUGINTERRUPT          WITH CONTEXT BLOCK ON STACK
*
        IF      SDOSMT
        FDB     MTPRIMS                 PRIMITIVES FOR SDOS/MT
        ELSE
        FDB     0                       NO SDOS/MT PRIMITIVES
        FIN
        IF      SDOSMT
        PAGE    SDOS/MT PRIMITIVES VECTOR
         JMP   ABORTQUANTUM$           ENTRY POINT FOR USE BY VT DRIVER
MTPRIMS FDB     LENPRIMITIVETABLE
*
*       TS PRIMITIVE JUMP TABLE
*
PRIMITIVETABLE
        JMP     USERSPACESYSCALL$      USE ROUTINE IN /MT ROM
        JMP     USERSELECT$            USE ROUTINE IN /MT ROM
        JMP     USERCURRENTSIZE
        JMP     RETURNTOUSER$          USE ROUTINE IN /MT ROM
        JMP     SETQUANTUM$            USE ROUTINE IN /MT ROM
        JMP     COPYTOSYSTEM$          USE ROUTINE IN /MT ROM
        JMP     COPYTOUSER$            USE ROUTINE IN /MT ROM
        JMP     COPYUSERTODX$          USE ROUTINE IN /MT ROM
        JMP     COPYATOUSER$           USE ROUTINE IN /MT ROM
        JMP     COPYDTOUSER$           USE ROUTINE IN /MT ROM
        JMP     COPYUSERTOA$           USE ROUTINE IN /MT ROM
        JMP     SETFUSE
        JMP     TESTFUSE
        FDB     MTCRASHINFO
        FCB     IOQUANTUM,CPUQUANTUM
LENPRIMITIVETABLE       EQU     *-PRIMITIVETABLE

::       SET   *
         ORG   MTROM
*
*        ENTRY VECTOR DEFINITIONS FOR /MT ROM
*
USERSELECT$    RMB                     3
USERSPACESYSCALL$                      RMB 3
RETURNTOUSER$  RMB                     3
SETQUANTUM$    RMB                     3
ABORTQUANTUM$  RMB                     3
CLOCKTICKED$   RMB                     3
COPYTOSYSTEM$  RMB                     3
COPYTOUSER$    RMB                     3
COPYUSERTODX$  RMB                     3
COPYATOUSER$   RMB                     3
COPYDTOUSER$   RMB                     3
COPYUSERTOA$   RMB                     3
         ORG   ::
SETFUSE STX     MTFUSE+TIMEOUT:FUSE
        RTS

TESTFUSE
        LDX     MTFUSE+TIMEOUT:FUSE
        RTS

MTFUSEBURNEDUP
         JSR   ABORTQUANTUM$
         JMP   SDOS+SDOS:RTI

USERCURRENTSIZE
         LDX   #$E000                  = 1ST BYTE THAT CAN'T BE PART OF USER SPACE
         STX   TEMPX
FINDTOPOFMEM
         LDX   TEMPX
         DEX                           = 1ST BYTE THAT MIGHT BE RAM FOR USER
         JSR   COPYUSERTOA$
         PSHA
         COMA
         JSR   COPYATOUSER$
         JSR   COPYUSERTOA$
         if    m6800!m6801
         TSX
         EORA  0,X                     USER BYTE + STORED COMPLEMENT SHOULD = $FF
         INS                           POP BYTE FROM STACK
         else  (m6809)
         EORA  ,S+                     USER BYTE + STORED COMPLEMENT SHOULD = $FF
         fin
         INCA
         BEQ   FOUNDTOPMEM
         DEC   TEMPX                   SCANADDRESS=SCANADDRESS-256
         BNE   FINDTOPOFMEM
FOUNDTOPMEM
         LDD   TEMPX
         RTS

         PAGE
         FIN   SDOSMT

ILLDEVICEOP    JSR                     SDOS+SDOS:ERROR
         FDB   ERR:ILLDEVICEOP
*
ERRETX   JSR   SDOS+SDOS:ERRORSAVE
         JMP   SDOS+SDOS:ERRORED

PATCHSPACE     RPT                     50
         SWI
         PAGE  *** INTERRUPT POLL CHAINS ***
IODRIVERBODY   SET                     0
IODRIVERPOLL   SET                     1

STACKUNSWITCHEDDEVICEPOLL ; come here via IRQ vector
         INCLUDE                       IOVTCONFIG.ASM
         JMP   SDOS+SDOS:IOINT         go switch stacks now

STACKSWITCHEDDEVICEPOLL ; come here after switching stacks
         IF    CLOCK
         INCLUDE                       IOCLOCK.ASM
         FIN
         IF    STORAGEDEMON
         INCLUDE                       IOSTOREDEMON.ASM
         FIN
         IF    VIRTUALFLOPPY
         INCLUDE                       IOVFD.ASM
         FIN

         LDX   BADINTERRUPTCOUNT       CAN'T FIGURE OUT WHO IT IS...
         INX                            BUMP CRAZY INTERRRUPT COUNTER
         STX   BADINTERRUPTCOUNT
         JMP   SDOS+SDOS:RTI           AND HOPE IT WENT AWAY !
         PAGE  *** WORKING STORAGE ***
IODRIVERPOLL   SET                     0
IODRIVERRAM    SET                     1

BADINTERRUPTCOUNT FDB 0 # OF INTERRUPTS FROM UNKNOWN DEVICES

         IF    SDOSMT
MTFUSE  FDB     NEXTTIMEOUT       POINTER TO NEXT TIMEOUTBLOCK
        FDB     0       TIMEOUT:FUSE
        FDB     MTFUSEBURNEDUP   WHERE TO GO IF FUSE EXPIRES
        FDB     0       RESERVED

NEXTTIMEOUT    SET                     MTFUSE
NTIMEOUTS      SET                     NTIMEOUTS+1
         FIN   SDOSMT

         IF    CLOCK
         INCLUDE                       IOCLOCK.ASM
         FIN
         IF    BLACKHOLE
         INCLUDE                       IOBLACKHOLE.ASM
         FIN
         IF    SDLP
         INCLUDE                       IOSDLP.ASM
         IFN
         FIN
         IF    VIRTUALFLOPPY
         INCLUDE                       IOVFD.ASM
         FIN
         IF    STORAGEDEMON
         INCLUDE                       IOSTOREDEMON.ASM
         FIN
         INCLUDE                       IOVTCONFIG.ASM
DISKDCBS SET   NEXTDISKDCB
NDRIVES  SET   NDISKDCBS
DEVICEDCBS     SET                     NEXTDEVICEDCB
TIMEOUTQUEUE   SET                     NEXTTIMEOUT
NTIMEOUTBLOCKS SET                     NTIMEOUTS
TASKQUEUE      EQU                     TTYTCB
PROFILECHAIN   EQU                     NEXTDPB
         PAGE  FCBS, IOCBS, INTERRUPT STACK
*
*        FCBS (MUST PRECEDE IOCBS)
*
FCBS     RPT   FCB:SIZE*(NIOCHANNELS+2*NDRIVES+NMAGICFCBS)
         FCB   0
*
*        IOCBS
*
IOCBS    RPT   IOCB:SIZE*NIOCHANNELS
         FCB   0
IOCBPOINTERS   RPT                     NIOCHANNELS
         FDB   IOCBS+IOCB:SIZE*(*-IOCBPOINTERS)/2
         PGEN  0
*
INTERRUPTSTACK EQU * ; STACK SPACE FOR INTERRUPT ROUTINES

INTSETUP LDX   SYSPG
         LDAA  #(STACKUNSWITCHEDDEVICEPOLL)/256 = WHERE TO GO ON INTERRUPT
         LDAB  #(STACKUNSWITCHEDDEVICEPOLL)\256
         STAA  SYSIIRQ+1,X
         STAB  SYSIIRQ+2,X
         OKRTS

         RPT   INTERRUPTSTACKSIZE-(*-INTERRUPTSTACK)
         FCB   0

INTERRUPTSTACKEND ; end of interruptstack
         PAGE  *** DRIVER INIT (ONCE-ONLY) CODE ***
IODRIVERRAM    SET                     0
IODRIVERINIT   SET                     1
         EQU   *-DRIVERBASE            SIZE OF READ-ONLY CODE
DSKBUFFERPOOL  EQU                     *
         IF    CLOCK
         INCLUDE                       IOCLOCK.ASM
         FIN
         IF    BLACKHOLE
         INCLUDE                       IOBLACKHOLE.ASM
         FIN
         IF    SDLP
         INCLUDE                       IOSDLP.ASM
         FIN
         IF    VIRTUALFLOPPY
         INCLUDE                       IOVFD.ASM
         FIN
         IF    STORAGEDEMON
         INCLUDE                       IOSTOREDEMON.ASM
         FIN
         INCLUDE                       IOVTCONFIG.ASM
         PAGE
         IF    *>/VTDRIVER
         ? DRIVERS TOO BIG ?
         ELSE
         RMB   VTDRIVER-*
         FIN   *>/VTDRIVER
DSKPOOLSIZE    EQU                     *-DSKBUFFERPOOL
         IF    DESIREDPOOLSIZE>>DSKPOOLSIZE
         ?DISK POOL NOT LARGE ENOUGH, MUST LOWER CODE BASE?
         FIN
         EQU   *-CODE                  SO I CAN SEE HOW BIG THE WORLD IS
         END
