* DO file to manufacture I/O package for WaveMate Jupiter II 6800.
* Components are intended to be SDVT11A60K.680,SDOS11G60K.680
* Source files required:
*     IOJUPITER.DO (this file)
*     IOJUPITER.ASM
*     IOVFD.ASM ("virtual" floppy driver)
*     IOVFDDCBS.ASM
*     IOSTOREDEMON.ASM (M680C'd for 6800)
*     IOVTDPBS.ASM (M680C'd for 6800)
*     SDOS11DEFS.ASM
*     SDOS11VTDEFS.ASM
* Configuration includes:
*     CONSOLE: at $FFC0
*     LPT: at $FFC4 (output only device)
*     HYTYPE: (serial only) at $FFC8
*     D0: (DAM floppy)
*     D1: (DAM floppy)
*     D2: (Persci 277 in IBM disguise)
*     D3: (Persci 277 in IBM disguise)
*     D4: (Persci 277 in WaveMate 256-byte sector format)
*     D5: (Persci 277 in WaveMate 256-byte sector format)
*     WD0: (IMI 7710S 10 Mb Winchester)
*     Device profiles:
*     MALVT,MALLPT,RS232LPT,EPSONLPT,ADM3,GT100,H19,SOROCIQ120
*
*  The following manufactures IOVTCONFIG.ASM
*
makevtconfig
:FFC0
yes, this is an acia
:FFC1
CONSOLE:
MALVT
:FFC4
yes, this is an acia
:FFC5
LPT:
MALLPT
:FFC8
yes, this is an acia
:FFC9
HYTYPE:
MALVT

RS232LPT
EPSONLPT
ADM3
GT100
H19
SOROCIQ120

*
*  Now do the assembly
*
ASM
IOJUPITER.ASM
IOJUPITER.LPT
IOJUPITER.BIN
Listdefs  equ  0              ; don't list SDOS definitions
;
memsize   equ    60           ; K of memory
code      equ    $8400        ; top of user space
;
VirtualFloppy equ 1           ; Use Virtual (joke) floppy drive
;
PerSci    equ    2            ; 1 dual persci
WMformat  equ    1            ;   set up for WM 256 byte format...
IBMformat equ    1            ;   and IBM 3740 format
;
DAMfloppy equ    2            ; 1 dual DAM floppy drive
;
StorageDemon equ 1            ; Standard Storage Demon
IMI7710S  equ    1            ;    IMI 7710s
UseDemonAsClock equ 1         ; Use Demon interface as clock
;
DesiredPoolSize equ 512*4     ; so poolsize is 3 sectors -> readahead happens
;
InBufSize:$ffc4 equ  0        ; line printer doesn't need input buffer
LineBufSize:$ffc4 equ 0       ; line printer doesn't need line buffer

