OPTICAL DISK FILE SYSTEM

This document contains design notes on a file system implementation
for a Write-once, Read-many-times Optical Disk drive.

Characteristics of the class of disk drives:
     1) Large sectors (>=1Kb)
     2) Large number of sectors (>=1e6)
     3) Slow seek times
     4) Each sector can only be written once.
     5) Evolution to the 100 to 1M GIGABYTE range (10^12 bytes)

The goals (F. Burton):
     a) A large file system
     b) Should be able to handle transactions for a period of 10 years
        before filling up drive.
     c) Recovery of file histories should be possible
     d) With aid of two platters and only a single drive, should
        have reliable backup.
     e) Willing to lose up to one day of data on a crash

The goals (IDB)
     a) A large file system
     b) Built in recovery/redundancy
     c) Heirarchical directories
     d) Scheme should work with R/W disk drives
     e) Encrypted files
     f) Fast file access and allocation
     g) Step towards capability based systems
     h) Portability to other CPUs
     i) Re-entrant so executable by multiple tasks
     j) Handle files of size 10^12 bytes
     k) Practical on 32 bit machines because they are common

Notes: 10 years = 3650 days ~~ 100,000 hours --> one disk write every
       6 minutes average would just barely fill the disk drive.
       Perhaps a large cache could keep the data rate down sufficiently
       to meet this specification ?  Consider the typical application
       conversing with a typical user: a single transaction OUGHT to take
       a time very close to this value.

How long to scan entire disk ? 1e6 sectors at one byte/.5 uS -->
500uS/sector MINIMUM * 1e6 sectors --> 500 seconds or 10 minutes.



Perhaps an interesting idea is to NOT assign disk locations to newly
written data, but rather to hold such data as long as possible in the
cache, and assign it a location only when absolutely forced (i.e., keep
written data in LRU order, and dump ONLY the oldest piece of written
data). This would allow many dynamic updates to data not-yet-written
without any write-once-uses-up-space penalty.

Should have transient files, so that if they are deleted before written,
no actual disk space is consumed ?  Perhaps a REALLY big disk buffer
pool is the secret!

?How to defend against drive failures blasting the disk ?
? Do we need an SDOSDISKVALIDATE like program ?

Let's assume we may want a DiskValidate class program.  Then we
must have enough redundancy in the file system to recover from a large
class of errors.  In particular, we should have enough redundancy to
recover from any one file system failure (i.e., the accidental destruction
of a sector) AUTOMATICALLY.  Does this mean destruction of a data sector ?
Where do we put duplicates to minimize probability of accidental destruction?

Keep incrementally computed CRC over file so it need not be computed?
Also keep incrementally computed CRC over entire disk?
This allows fast comparison of big file with other files.

File system structure.
Faults with SDOS 1.0 file system structure:
      1) Header clusters slowed system down, required large buffer pool
      2) Clusters wasted much disk space on small files
      3) Only single directory


A file is represented by its 1st sector.
The first sector contains
      A unique file descriptor which must match every
         capability used against the file (16B)1
      64 bytes of room to hold a descriptive english message describing
         WHAT the file is.
      The size of the file (32 bits for convenience;
                           or 40 bits to allow 1 file to cover disk)
      Creation date (down to uS) (32 bits)
      Last update date (down to uS) (32 bits)
      Last access date (down to uS) (32 bits)
      File version number (32 bits)
      K segment descriptors, where K handles 95% of all files built
         (a segment descriptor consists of a base sector number 32 bits
                    and segment length in sectors (16 bits))
         1st segment implicitly includes first sector of file.
      Pointer to header segment (header segment is segment containing
         only segment numbers)

???? updating header --> it will move a lot --> 1st segment descriptor
is useless ???
